/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentSubParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexHistogramFieldData;
import org.elasticsearch.index.fielddata.LeafHistogramFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.analytics.aggregations.support.AnalyticsValuesSourceType;

public class HistogramFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "histogram";
    public static final ParseField COUNTS_FIELD = new ParseField("counts", new String[0]);
    public static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    protected Explicit<Boolean> ignoreMalformed;

    public HistogramFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        HistogramFieldMapper gpfmMergeWith = (HistogramFieldMapper)other;
        if (gpfmMergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gpfmMergeWith.ignoreMalformed;
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] can't be used in multi-fields");
        }
        context.path().add(this.simpleName());
        XContentParser.Token token = null;
        XContentSubParser subParser = null;
        try {
            token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                context.path().remove();
                return;
            }
            DoubleArrayList values = null;
            IntArrayList counts = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, () -> ((XContentParser)context.parser()).getTokenLocation());
            subParser = new XContentSubParser(context.parser());
            token = subParser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, () -> ((XContentSubParser)subParser).getTokenLocation());
                String fieldName = subParser.currentName();
                if (fieldName.equals(VALUES_FIELD.getPreferredName())) {
                    token = subParser.nextToken();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, () -> ((XContentSubParser)subParser).getTokenLocation());
                    values = new DoubleArrayList();
                    token = subParser.nextToken();
                    double previousVal = -1.7976931348623157E308;
                    while (token != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, () -> ((XContentSubParser)subParser).getTokenLocation());
                        double val = subParser.doubleValue();
                        if (val < previousVal) {
                            throw new MapperParsingException("error parsing field [" + this.name() + "], [" + COUNTS_FIELD + "] values must be in increasing order, got [" + val + "] but previous value was [" + previousVal + "]");
                        }
                        values.add(val);
                        previousVal = val;
                        token = subParser.nextToken();
                    }
                } else if (fieldName.equals(COUNTS_FIELD.getPreferredName())) {
                    token = subParser.nextToken();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, () -> ((XContentSubParser)subParser).getTokenLocation());
                    counts = new IntArrayList();
                    token = subParser.nextToken();
                    while (token != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, () -> ((XContentSubParser)subParser).getTokenLocation());
                        counts.add(subParser.intValue());
                        token = subParser.nextToken();
                    }
                } else {
                    throw new MapperParsingException("error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                }
                token = subParser.nextToken();
            }
            if (values == null) {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected field called [" + VALUES_FIELD.getPreferredName() + "]");
            }
            if (counts == null) {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected field called [" + COUNTS_FIELD.getPreferredName() + "]");
            }
            if (values.size() != counts.size()) {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected same length from [" + VALUES_FIELD.getPreferredName() + "] and [" + COUNTS_FIELD.getPreferredName() + "] but got [" + values.size() + " != " + counts.size() + "]");
            }
            if (this.fieldType().hasDocValues()) {
                ByteBuffersDataOutput dataOutput = new ByteBuffersDataOutput();
                for (int i = 0; i < values.size(); ++i) {
                    int count = counts.get(i);
                    if (count < 0) {
                        throw new MapperParsingException("error parsing field [" + this.name() + "], [" + COUNTS_FIELD + "] elements must be >= 0 but got " + counts.get(i));
                    }
                    if (count <= 0) continue;
                    dataOutput.writeVInt(count);
                    dataOutput.writeLong(Double.doubleToRawLongBits(values.get(i)));
                }
                BytesRef docValue = new BytesRef(dataOutput.toArrayCopy(), 0, Math.toIntExact(dataOutput.size()));
                BinaryDocValuesField field = new BinaryDocValuesField(this.name(), docValue);
                if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
                    throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
                }
                context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
            }
        }
        catch (Exception ex) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)ex, new Object[]{this.fieldType().name(), this.fieldType().typeName()});
            }
            if (subParser != null) {
                subParser.close();
            }
            context.addIgnoredField(this.fieldType().name());
        }
        context.path().remove();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Boolean)this.ignoreMalformed.value());
        }
    }

    protected boolean indexedByDefault() {
        return false;
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }

    private static class InternalHistogramValue
    extends HistogramValue {
        double value;
        int count;
        boolean isExhausted;
        ByteArrayDataInput dataInput = new ByteArrayDataInput();

        InternalHistogramValue() {
        }

        void reset(BytesRef bytesRef) {
            this.dataInput.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            this.isExhausted = false;
            this.value = 0.0;
            this.count = 0;
        }

        public boolean next() {
            if (!this.dataInput.eof()) {
                this.count = this.dataInput.readVInt();
                this.value = Double.longBitsToDouble(this.dataInput.readLong());
                return true;
            }
            this.isExhausted = true;
            return false;
        }

        public double value() {
            if (this.isExhausted) {
                throw new IllegalArgumentException("histogram already exhausted");
            }
            return this.value;
        }

        public int count() {
            if (this.isExhausted) {
                throw new IllegalArgumentException("histogram already exhausted");
            }
            return this.count;
        }
    }

    public static class HistogramFieldType
    extends MappedFieldType {
        public HistogramFieldType(String name, boolean hasDocValues, Map<String, String> meta) {
            super(name, false, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
        }

        public String typeName() {
            return HistogramFieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new IndexFieldData.Builder(){

                public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
                    return new IndexHistogramFieldData(indexSettings.getIndex(), fieldType.name(), AnalyticsValuesSourceType.HISTOGRAM){

                        public LeafHistogramFieldData load(final LeafReaderContext context) {
                            return new LeafHistogramFieldData(){

                                public HistogramValues getHistogramValues() throws IOException {
                                    try {
                                        final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)fieldName);
                                        final InternalHistogramValue value = new InternalHistogramValue();
                                        return new HistogramValues(){

                                            public boolean advanceExact(int doc) throws IOException {
                                                return values.advanceExact(doc);
                                            }

                                            public HistogramValue histogram() throws IOException {
                                                try {
                                                    value.reset(values.binaryValue());
                                                    return value;
                                                }
                                                catch (IOException e) {
                                                    throw new IOException("Cannot load doc value", e);
                                                }
                                            }
                                        };
                                    }
                                    catch (IOException e) {
                                        throw new IOException("Cannot load doc values", e);
                                    }
                                }

                                public ScriptDocValues<?> getScriptValues() {
                                    throw new UnsupportedOperationException("The [histogram] field does not support scripts");
                                }

                                public SortedBinaryDocValues getBytesValues() {
                                    throw new UnsupportedOperationException("String representation of doc values for [histogram] fields is not supported");
                                }

                                public long ramBytesUsed() {
                                    return 0L;
                                }

                                public void close() {
                                }
                            };
                        }

                        public LeafHistogramFieldData loadDirect(LeafReaderContext context) throws Exception {
                            return this.load(context);
                        }

                        public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                            throw new UnsupportedOperationException("can't sort on the [histogram] field");
                        }

                        public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                            throw new IllegalArgumentException("can't sort on the [histogram] field");
                        }
                    };
                }
            };
        }

        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            throw new QueryShardException(context, "field  " + this.name() + " of type [" + HistogramFieldMapper.CONTENT_TYPE + "] has no doc values and cannot be searched", new Object[0]);
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "[histogram] field do not support searching, use dedicated aggregations instead: [" + this.name() + "]", new Object[0]);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<Builder> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue((Object)propNode, (String)(name + "." + "ignore_malformed")));
                    iterator.remove();
                }
                if (!propName.equals("meta")) continue;
                builder.meta(TypeParsers.parseMeta((String)propName, (Object)propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        protected Boolean ignoreMalformed;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit((Object)((Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings())), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public HistogramFieldMapper build(Mapper.BuilderContext context) {
            return new HistogramFieldMapper(this.name, this.fieldType, new HistogramFieldType(this.buildFullName(context), this.hasDocValues, this.meta), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.ignoreMalformed(context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit((Object)false, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

