/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.cumulativecardinality;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.xpack.analytics.cumulativecardinality.InternalSimpleLongValue;

public class CumulativeCardinalityPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;

    CumulativeCardinalityPipelineAggregator(String name, String[] bucketsPaths, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
    }

    public CumulativeCardinalityPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.formatter = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.formatter);
    }

    public String getWriteableName() {
        return "cumulative_cardinality";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)histo;
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>(buckets.size());
        try (HyperLogLogPlusPlus hll = null;){
            long cardinality = 0L;
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                HyperLogLogPlusPlus bucketHll = this.resolveBucketValue((MultiBucketsAggregation)histo, bucket, this.bucketsPaths()[0]);
                if (hll == null && bucketHll != null) {
                    hll = new HyperLogLogPlusPlus(bucketHll.precision(), reduceContext.bigArrays(), 1L);
                }
                if (bucketHll != null) {
                    hll.merge(0L, bucketHll, 0L);
                    cardinality = hll.cardinality(0L);
                }
                List aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
                aggs.add(new InternalSimpleLongValue(this.name(), cardinality, this.formatter, this.metadata()));
                MultiBucketsAggregation.Bucket newBucket = factory.createBucket(factory.getKey((MultiBucketsAggregation.Bucket)bucket), bucket.getDocCount(), InternalAggregations.from(aggs));
                newBuckets.add(newBucket);
            }
            InternalAggregation internalAggregation = factory.createAggregation(newBuckets);
            return internalAggregation;
        }
    }

    private HyperLogLogPlusPlus resolveBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath) {
        List aggPathsList = AggregationPath.parse((String)aggPath).getPathElementsAsStringList();
        Object propertyValue = bucket.getProperty(agg.getName(), aggPathsList);
        if (propertyValue == null) {
            throw new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference a cardinality aggregation");
        }
        if (propertyValue instanceof InternalCardinality) {
            return ((InternalCardinality)propertyValue).getCounts();
        }
        String currentAggName = aggPathsList.isEmpty() ? agg.getName() : (String)aggPathsList.get(0);
        throw new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference a cardinality aggregation, got: [" + propertyValue.getClass().getSimpleName() + "] at aggregation [" + currentAggName + "]");
    }
}

