/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.xpack.analytics.boxplot.Boxplot;

public class InternalBoxplot
extends InternalNumericMetricsAggregation.MultiValue
implements Boxplot {
    private final TDigestState state;

    InternalBoxplot(String name, TDigestState state, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        this.state = state;
        this.format = formatter;
    }

    public InternalBoxplot(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.state = TDigestState.read((StreamInput)in);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        TDigestState.write((TDigestState)this.state, (StreamOutput)out);
    }

    public String getWriteableName() {
        return "boxplot";
    }

    @Override
    public double getMin() {
        return this.state.getMin();
    }

    @Override
    public double getMax() {
        return this.state.getMax();
    }

    @Override
    public double getQ1() {
        return this.state.quantile(0.25);
    }

    @Override
    public double getQ2() {
        return this.state.quantile(0.5);
    }

    @Override
    public double getQ3() {
        return this.state.quantile(0.75);
    }

    @Override
    public String getMinAsString() {
        return this.valueAsString(Metrics.MIN.name());
    }

    @Override
    public String getMaxAsString() {
        return this.valueAsString(Metrics.MAX.name());
    }

    @Override
    public String getQ1AsString() {
        return this.valueAsString(Metrics.Q1.name());
    }

    @Override
    public String getQ2AsString() {
        return this.valueAsString(Metrics.Q2.name());
    }

    @Override
    public String getQ3AsString() {
        return this.valueAsString(Metrics.Q3.name());
    }

    public double value(String name) {
        return Metrics.resolve(name).value(this);
    }

    DocValueFormat format() {
        return this.format;
    }

    TDigestState state() {
        return this.state;
    }

    public InternalBoxplot reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TDigestState merged = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalBoxplot percentiles = (InternalBoxplot)aggregation;
            if (merged == null) {
                merged = new TDigestState(percentiles.state.compression());
            }
            merged.add((TDigest)percentiles.state);
        }
        return new InternalBoxplot(this.name, merged, this.format, this.metadata);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("min", this.getMin());
        builder.field("max", this.getMax());
        builder.field("q1", this.getQ1());
        builder.field("q2", this.getQ2());
        builder.field("q3", this.getQ3());
        if (this.format != DocValueFormat.RAW) {
            builder.field("min_as_string", this.format.format(this.getMin()));
            builder.field("max_as_string", this.format.format(this.getMax()));
            builder.field("q1_as_string", this.format.format(this.getQ1()));
            builder.field("q2_as_string", this.format.format(this.getQ2()));
            builder.field("q3_as_string", this.format.format(this.getQ3()));
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.state);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalBoxplot that = (InternalBoxplot)obj;
        return Objects.equals(this.state, that.state);
    }

    static enum Metrics {
        MIN,
        MAX,
        Q1,
        Q2,
        Q3;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        double value(InternalBoxplot boxplot) {
            switch (this) {
                case MIN: {
                    return boxplot.getMin();
                }
                case MAX: {
                    return boxplot.getMax();
                }
                case Q1: {
                    return boxplot.getQ1();
                }
                case Q2: {
                    return boxplot.getQ2();
                }
                case Q3: {
                    return boxplot.getQ3();
                }
            }
            throw new IllegalArgumentException("Unknown value [" + this.value() + "] in the boxplot aggregation");
        }

        double value(TDigestState state) {
            switch (this) {
                case MIN: {
                    return state == null ? Double.NEGATIVE_INFINITY : state.getMin();
                }
                case MAX: {
                    return state == null ? Double.POSITIVE_INFINITY : state.getMax();
                }
                case Q1: {
                    return state == null ? Double.NaN : state.quantile(0.25);
                }
                case Q2: {
                    return state == null ? Double.NaN : state.quantile(0.5);
                }
                case Q3: {
                    return state == null ? Double.NaN : state.quantile(0.75);
                }
            }
            throw new IllegalArgumentException("Unknown value [" + this.value() + "] in the boxplot aggregation");
        }
    }
}

