/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;
import org.elasticsearch.xpack.analytics.boxplot.InternalBoxplot;

public class BoxplotAggregator
extends NumericMetricsAggregator.MultiValue {
    private final ValuesSource valuesSource;
    private final DocValueFormat format;
    protected ObjectArray<TDigestState> states;
    protected final double compression;

    BoxplotAggregator(String name, ValuesSource valuesSource, DocValueFormat formatter, double compression, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSource;
        this.format = formatter;
        this.compression = compression;
        if (valuesSource != null) {
            this.states = context.bigArrays().newObjectArray(1L);
        }
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        if (this.valuesSource instanceof HistogramValuesSource.Histogram) {
            final HistogramValues values = ((HistogramValuesSource.Histogram)this.valuesSource).getHistogramValues(ctx);
            return new LeafBucketCollectorBase(sub, values){

                public void collect(int doc, long bucket) throws IOException {
                    TDigestState state = BoxplotAggregator.this.getExistingOrNewHistogram(bigArrays, bucket);
                    if (values.advanceExact(doc)) {
                        HistogramValue sketch = values.histogram();
                        while (sketch.next()) {
                            state.add(sketch.value(), sketch.count());
                        }
                    }
                }
            };
        }
        final SortedNumericDoubleValues values = ((ValuesSource.Numeric)this.valuesSource).doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                BoxplotAggregator.this.states = bigArrays.grow(BoxplotAggregator.this.states, bucket + 1L);
                if (values.advanceExact(doc)) {
                    TDigestState state = BoxplotAggregator.this.getExistingOrNewHistogram(bigArrays, bucket);
                    if (values.advanceExact(doc)) {
                        int valueCount = values.docValueCount();
                        for (int i = 0; i < valueCount; ++i) {
                            state.add(values.nextValue());
                        }
                    }
                }
            }
        };
    }

    private TDigestState getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.states = bigArrays.grow(this.states, bucket + 1L);
        TDigestState state = (TDigestState)this.states.get(bucket);
        if (state == null) {
            state = new TDigestState(this.compression);
            this.states.set(bucket, (Object)state);
        }
        return state;
    }

    public boolean hasMetric(String name) {
        try {
            InternalBoxplot.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public double metric(String name, long owningBucketOrd) {
        TDigestState state = null;
        if (this.valuesSource != null && owningBucketOrd < this.states.size()) {
            state = (TDigestState)this.states.get(owningBucketOrd);
        }
        return InternalBoxplot.Metrics.resolve(name).value(state);
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalBoxplot(this.name, state, this.format, this.metadata());
    }

    TDigestState getState(long bucketOrd) {
        if (this.valuesSource == null || bucketOrd >= this.states.size()) {
            return null;
        }
        return (TDigestState)this.states.get(bucketOrd);
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalBoxplot(this.name, new TDigestState(this.compression), this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.states});
    }
}

