/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations;

import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.MetricAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.metrics.PercentilesMethod;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.analytics.aggregations.bucket.histogram.HistoBackedHistogramAggregator;
import org.elasticsearch.xpack.analytics.aggregations.metrics.HistoBackedAvgAggregator;
import org.elasticsearch.xpack.analytics.aggregations.metrics.HistoBackedHDRPercentileRanksAggregator;
import org.elasticsearch.xpack.analytics.aggregations.metrics.HistoBackedHDRPercentilesAggregator;
import org.elasticsearch.xpack.analytics.aggregations.metrics.HistoBackedSumAggregator;
import org.elasticsearch.xpack.analytics.aggregations.metrics.HistoBackedTDigestPercentileRanksAggregator;
import org.elasticsearch.xpack.analytics.aggregations.metrics.HistoBackedTDigestPercentilesAggregator;
import org.elasticsearch.xpack.analytics.aggregations.metrics.HistoBackedValueCountAggregator;
import org.elasticsearch.xpack.analytics.aggregations.support.AnalyticsValuesSourceType;

public class AnalyticsAggregatorFactory {
    public static void registerPercentilesAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register("percentiles", (ValuesSourceType)AnalyticsValuesSourceType.HISTOGRAM, (AggregatorSupplier)((PercentilesAggregatorSupplier)(name, valuesSource, context, parent, percents, percentilesConfig, keyed, formatter, metadata) -> {
            if (percentilesConfig.getMethod().equals((Object)PercentilesMethod.TDIGEST)) {
                double compression = ((PercentilesConfig.TDigest)percentilesConfig).getCompression();
                return new HistoBackedTDigestPercentilesAggregator(name, valuesSource, context, parent, percents, compression, keyed, formatter, metadata);
            }
            if (percentilesConfig.getMethod().equals((Object)PercentilesMethod.HDR)) {
                int numSigFig = ((PercentilesConfig.Hdr)percentilesConfig).getNumberOfSignificantValueDigits();
                return new HistoBackedHDRPercentilesAggregator(name, valuesSource, context, parent, percents, numSigFig, keyed, formatter, metadata);
            }
            throw new IllegalArgumentException("Percentiles algorithm: [" + percentilesConfig.getMethod().toString() + "] is not compatible with Histogram field");
        }));
    }

    public static void registerPercentileRanksAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register("percentile_ranks", (ValuesSourceType)AnalyticsValuesSourceType.HISTOGRAM, (AggregatorSupplier)((PercentilesAggregatorSupplier)(name, valuesSource, context, parent, percents, percentilesConfig, keyed, formatter, metadata) -> {
            if (percentilesConfig.getMethod().equals((Object)PercentilesMethod.TDIGEST)) {
                double compression = ((PercentilesConfig.TDigest)percentilesConfig).getCompression();
                return new HistoBackedTDigestPercentileRanksAggregator(name, valuesSource, context, parent, percents, compression, keyed, formatter, metadata);
            }
            if (percentilesConfig.getMethod().equals((Object)PercentilesMethod.HDR)) {
                int numSigFig = ((PercentilesConfig.Hdr)percentilesConfig).getNumberOfSignificantValueDigits();
                return new HistoBackedHDRPercentileRanksAggregator(name, valuesSource, context, parent, percents, numSigFig, keyed, formatter, metadata);
            }
            throw new IllegalArgumentException("Percentiles algorithm: [" + percentilesConfig.getMethod().toString() + "] is not compatible with Histogram field");
        }));
    }

    public static void registerHistoBackedSumAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register("sum", (ValuesSourceType)AnalyticsValuesSourceType.HISTOGRAM, (AggregatorSupplier)((MetricAggregatorSupplier)HistoBackedSumAggregator::new));
    }

    public static void registerHistoBackedValueCountAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register("value_count", (ValuesSourceType)AnalyticsValuesSourceType.HISTOGRAM, (AggregatorSupplier)((MetricAggregatorSupplier)HistoBackedValueCountAggregator::new));
    }

    public static void registerHistoBackedAverageAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register("avg", (ValuesSourceType)AnalyticsValuesSourceType.HISTOGRAM, (AggregatorSupplier)((MetricAggregatorSupplier)HistoBackedAvgAggregator::new));
    }

    public static void registerHistoBackedHistogramAggregator(ValuesSourceRegistry.Builder builder) {
        builder.register("histogram", (ValuesSourceType)AnalyticsValuesSourceType.HISTOGRAM, (AggregatorSupplier)((HistogramAggregatorSupplier)HistoBackedHistogramAggregator::new));
    }
}

