/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.analytics.AnalyticsFeatureSet;
import org.elasticsearch.xpack.analytics.AnalyticsUsage;
import org.elasticsearch.xpack.analytics.action.TransportAnalyticsStatsAction;
import org.elasticsearch.xpack.analytics.aggregations.AnalyticsAggregatorFactory;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregationBuilder;
import org.elasticsearch.xpack.analytics.boxplot.InternalBoxplot;
import org.elasticsearch.xpack.analytics.cumulativecardinality.CumulativeCardinalityPipelineAggregationBuilder;
import org.elasticsearch.xpack.analytics.mapper.HistogramFieldMapper;
import org.elasticsearch.xpack.analytics.movingPercentiles.MovingPercentilesPipelineAggregationBuilder;
import org.elasticsearch.xpack.analytics.normalize.NormalizePipelineAggregationBuilder;
import org.elasticsearch.xpack.analytics.stringstats.InternalStringStats;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregationBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.InternalTopMetrics;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregationBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregatorFactory;
import org.elasticsearch.xpack.analytics.ttest.InternalTTest;
import org.elasticsearch.xpack.analytics.ttest.PairedTTestState;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregationBuilder;
import org.elasticsearch.xpack.analytics.ttest.TTestState;
import org.elasticsearch.xpack.analytics.ttest.UnpairedTTestState;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.analytics.action.AnalyticsStatsAction;

public class AnalyticsPlugin
extends Plugin
implements SearchPlugin,
ActionPlugin,
MapperPlugin {
    private final AnalyticsUsage usage = new AnalyticsUsage();
    private final boolean transportClientMode;

    public AnalyticsPlugin(Settings settings) {
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public static XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        ArrayList<SearchPlugin.PipelineAggregationSpec> pipelineAggs = new ArrayList<SearchPlugin.PipelineAggregationSpec>();
        pipelineAggs.add(new SearchPlugin.PipelineAggregationSpec("cumulative_cardinality", CumulativeCardinalityPipelineAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.CUMULATIVE_CARDINALITY, AnalyticsPlugin.checkLicense(CumulativeCardinalityPipelineAggregationBuilder.PARSER))));
        pipelineAggs.add(new SearchPlugin.PipelineAggregationSpec("moving_percentiles", MovingPercentilesPipelineAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.MOVING_PERCENTILES, AnalyticsPlugin.checkLicense(MovingPercentilesPipelineAggregationBuilder.PARSER))));
        pipelineAggs.add(new SearchPlugin.PipelineAggregationSpec("normalize", NormalizePipelineAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.NORMALIZE, AnalyticsPlugin.checkLicense(NormalizePipelineAggregationBuilder.PARSER))));
        return pipelineAggs;
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        return org.elasticsearch.common.collect.List.of((Object[])new SearchPlugin.AggregationSpec[]{new SearchPlugin.AggregationSpec("string_stats", StringStatsAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.STRING_STATS, AnalyticsPlugin.checkLicense(StringStatsAggregationBuilder.PARSER))).addResultReader(InternalStringStats::new).setAggregatorRegistrar(StringStatsAggregationBuilder::registerAggregators), new SearchPlugin.AggregationSpec("boxplot", BoxplotAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.BOXPLOT, AnalyticsPlugin.checkLicense(BoxplotAggregationBuilder.PARSER))).addResultReader(InternalBoxplot::new).setAggregatorRegistrar(BoxplotAggregationBuilder::registerAggregators), new SearchPlugin.AggregationSpec("top_metrics", TopMetricsAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.TOP_METRICS, AnalyticsPlugin.checkLicense(TopMetricsAggregationBuilder.PARSER))).addResultReader(InternalTopMetrics::new), new SearchPlugin.AggregationSpec("t_test", TTestAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.T_TEST, AnalyticsPlugin.checkLicense(TTestAggregationBuilder.PARSER))).addResultReader(InternalTTest::new).setAggregatorRegistrar(TTestAggregationBuilder::registerUsage)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.singletonList(new ActionPlugin.ActionHandler((ActionType)AnalyticsStatsAction.INSTANCE, TransportAnalyticsStatsAction.class, new Class[0]));
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, AnalyticsFeatureSet.class));
        return modules;
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(TopMetricsAggregatorFactory.MAX_BUCKET_SIZE);
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("histogram", new HistogramFieldMapper.TypeParser());
    }

    public List<Consumer<ValuesSourceRegistry.Builder>> getAggregationExtentions() {
        return org.elasticsearch.common.collect.List.of((Object[])new Consumer[]{AnalyticsAggregatorFactory::registerPercentilesAggregator, AnalyticsAggregatorFactory::registerPercentileRanksAggregator, AnalyticsAggregatorFactory::registerHistoBackedSumAggregator, AnalyticsAggregatorFactory::registerHistoBackedValueCountAggregator, AnalyticsAggregatorFactory::registerHistoBackedAverageAggregator, AnalyticsAggregatorFactory::registerHistoBackedHistogramAggregator});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(this.usage);
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return org.elasticsearch.common.collect.List.of((Object)new NamedWriteableRegistry.Entry(TTestState.class, "P", PairedTTestState::new), (Object)new NamedWriteableRegistry.Entry(TTestState.class, "U", UnpairedTTestState::new));
    }

    private static <T> ContextParser<String, T> checkLicense(ContextParser<String, T> realParser) {
        return (parser, name) -> {
            if (!AnalyticsPlugin.getLicenseState().checkFeature(XPackLicenseState.Feature.ANALYTICS)) {
                throw LicenseUtils.newComplianceException((String)"analytics");
            }
            return realParser.parse(parser, name);
        };
    }
}

