/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiFunction;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;

public final class MlParserUtils {
    private MlParserUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T, U> T parse(SearchHit hit, BiFunction<XContentParser, U, T> objectParser) {
        BytesReference source = hit.getSourceRef();
        try (StreamInput stream = source.streamInput();){
            XContentParser xContentParser;
            block14: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    xContentParser = objectParser.apply(parser, null);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return (T)xContentParser;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to parse " + hit.getId(), (Throwable)e, new Object[0]);
        }
    }
}

