/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class RestGetDatafeedsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}", RestRequest.Method.GET, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/datafeeds", RestRequest.Method.GET, "/_xpack/ml/datafeeds")));
    }

    public String getName() {
        return "ml_get_datafeeds_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (datafeedId == null) {
            datafeedId = "_all";
        }
        GetDatafeedsAction.Request request = new GetDatafeedsAction.Request(datafeedId);
        request.setAllowNoDatafeeds(restRequest.paramAsBoolean(GetDatafeedsAction.Request.ALLOW_NO_DATAFEEDS.getPreferredName(), request.allowNoDatafeeds()));
        return channel -> client.execute((ActionType)GetDatafeedsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

