/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.calendar;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

public class RestGetCalendarsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/calendars/{" + Calendar.ID.getPreferredName() + "}", RestRequest.Method.GET, "/_xpack/ml/calendars/{" + Calendar.ID.getPreferredName() + "}"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/calendars/", RestRequest.Method.GET, "/_xpack/ml/calendars/"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_ml/calendars/{" + Calendar.ID.getPreferredName() + "}", RestRequest.Method.POST, "/_xpack/ml/calendars/{" + Calendar.ID.getPreferredName() + "}"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_ml/calendars/", RestRequest.Method.POST, "/_xpack/ml/calendars/")));
    }

    public String getName() {
        return "ml_get_calendars_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetCalendarsAction.Request request;
        String calendarId = restRequest.param(Calendar.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            try (XContentParser parser = restRequest.contentOrSourceParamParser();){
                request = GetCalendarsAction.Request.parseRequest((String)calendarId, (XContentParser)parser);
            }
        } else {
            request = new GetCalendarsAction.Request();
            if (!Strings.isNullOrEmpty((String)calendarId)) {
                request.setCalendarId(calendarId);
            }
            if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            }
        }
        return channel -> client.execute((ActionType)GetCalendarsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

