/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.FindFileStructureAction;

public class RestFindFileStructureAction
extends BaseRestHandler {
    private static final TimeValue DEFAULT_TIMEOUT = new TimeValue(25L, TimeUnit.SECONDS);

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_ml/find_file_structure", RestRequest.Method.POST, "/_xpack/ml/find_file_structure"));
    }

    public String getName() {
        return "ml_find_file_structure_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        FindFileStructureAction.Request request = new FindFileStructureAction.Request();
        request.setLinesToSample(Integer.valueOf(restRequest.paramAsInt(FindFileStructureAction.Request.LINES_TO_SAMPLE.getPreferredName(), 1000)));
        request.setLineMergeSizeLimit(Integer.valueOf(restRequest.paramAsInt(FindFileStructureAction.Request.LINE_MERGE_SIZE_LIMIT.getPreferredName(), 10000)));
        request.setTimeout(TimeValue.parseTimeValue((String)restRequest.param(FindFileStructureAction.Request.TIMEOUT.getPreferredName()), (TimeValue)DEFAULT_TIMEOUT, (String)FindFileStructureAction.Request.TIMEOUT.getPreferredName()));
        request.setCharset(restRequest.param(FindFileStructureAction.Request.CHARSET.getPreferredName()));
        request.setFormat(restRequest.param(FindFileStructureAction.Request.FORMAT.getPreferredName()));
        request.setColumnNames(restRequest.paramAsStringArray(FindFileStructureAction.Request.COLUMN_NAMES.getPreferredName(), null));
        request.setHasHeaderRow(restRequest.paramAsBoolean(FindFileStructureAction.Request.HAS_HEADER_ROW.getPreferredName(), null));
        request.setDelimiter(restRequest.param(FindFileStructureAction.Request.DELIMITER.getPreferredName()));
        request.setQuote(restRequest.param(FindFileStructureAction.Request.QUOTE.getPreferredName()));
        request.setShouldTrimFields(restRequest.paramAsBoolean(FindFileStructureAction.Request.SHOULD_TRIM_FIELDS.getPreferredName(), null));
        request.setGrokPattern(restRequest.param(FindFileStructureAction.Request.GROK_PATTERN.getPreferredName()));
        request.setTimestampFormat(restRequest.param(FindFileStructureAction.Request.TIMESTAMP_FORMAT.getPreferredName()));
        request.setTimestampField(restRequest.param(FindFileStructureAction.Request.TIMESTAMP_FIELD.getPreferredName()));
        if (!restRequest.hasContent()) {
            throw new ElasticsearchParseException("request body is required", new Object[0]);
        }
        request.setSample(restRequest.content());
        return channel -> client.execute((ActionType)FindFileStructureAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    protected Set<String> responseParams() {
        return Collections.singleton("explain");
    }
}

