/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Regression;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.dataframe.StoredProgress;
import org.elasticsearch.xpack.ml.job.persistence.BatchedStateDocIdsIterator;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.elasticsearch.xpack.ml.utils.persistence.DocIdBatchedDocumentIterator;

public class UnusedStateRemover
implements MlDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(UnusedStateRemover.class);
    private final OriginSettingClient client;
    private final ClusterService clusterService;

    public UnusedStateRemover(OriginSettingClient client, ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
    }

    @Override
    public void remove(float requestsPerSec, ActionListener<Boolean> listener, Supplier<Boolean> isTimedOutSupplier) {
        try {
            List<String> unusedStateDocIds = this.findUnusedStateDocIds();
            if (isTimedOutSupplier.get().booleanValue()) {
                listener.onResponse((Object)false);
            } else if (unusedStateDocIds.size() > 0) {
                this.executeDeleteUnusedStateDocs(unusedStateDocIds, requestsPerSec, listener);
            } else {
                listener.onResponse((Object)true);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private List<String> findUnusedStateDocIds() {
        Set<String> jobIds = this.getJobIds();
        ArrayList<String> stateDocIdsToDelete = new ArrayList<String>();
        BatchedStateDocIdsIterator stateDocIdsIterator = new BatchedStateDocIdsIterator(this.client, AnomalyDetectorsIndex.jobStateIndexPattern());
        while (stateDocIdsIterator.hasNext()) {
            Deque stateDocIds = stateDocIdsIterator.next();
            for (String stateDocId : stateDocIds) {
                String jobId = JobIdExtractor.extractJobId(stateDocId);
                if (jobId == null || jobIds.contains(jobId)) continue;
                stateDocIdsToDelete.add(stateDocId);
            }
        }
        return stateDocIdsToDelete;
    }

    private Set<String> getJobIds() {
        HashSet<String> jobIds = new HashSet<String>();
        jobIds.addAll(this.getAnomalyDetectionJobIds());
        jobIds.addAll(this.getDataFrameAnalyticsJobIds());
        return jobIds;
    }

    private Set<String> getAnomalyDetectionJobIds() {
        HashSet<String> jobIds = new HashSet<String>();
        jobIds.addAll(MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).getJobs().keySet());
        DocIdBatchedDocumentIterator iterator = new DocIdBatchedDocumentIterator(this.client, MlConfigIndex.indexName(), (QueryBuilder)QueryBuilders.termQuery((String)Job.JOB_TYPE.getPreferredName(), (String)"anomaly_detector"));
        while (iterator.hasNext()) {
            Deque docIds = iterator.next();
            docIds.stream().map(Job::extractJobIdFromDocumentId).filter(Objects::nonNull).forEach(jobIds::add);
        }
        return jobIds;
    }

    private Set<String> getDataFrameAnalyticsJobIds() {
        HashSet<String> jobIds = new HashSet<String>();
        DocIdBatchedDocumentIterator iterator = new DocIdBatchedDocumentIterator(this.client, MlConfigIndex.indexName(), (QueryBuilder)QueryBuilders.termQuery((String)DataFrameAnalyticsConfig.CONFIG_TYPE.getPreferredName(), (String)"data_frame_analytics_config"));
        while (iterator.hasNext()) {
            Deque docIds = iterator.next();
            docIds.stream().map(DataFrameAnalyticsConfig::extractJobIdFromDocId).filter(Objects::nonNull).forEach(jobIds::add);
        }
        return jobIds;
    }

    private void executeDeleteUnusedStateDocs(List<String> unusedDocIds, float requestsPerSec, ActionListener<Boolean> listener) {
        LOGGER.info("Found [{}] unused state documents; attempting to delete", (Object)unusedDocIds.size());
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setRequestsPerSecond(requestsPerSec)).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(unusedDocIds.toArray(new String[0])));
        deleteByQueryRequest.getSearchRequest().source().sort("_doc");
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, ActionListener.wrap(response -> {
            if (response.getBulkFailures().size() > 0 || response.getSearchFailures().size() > 0) {
                LOGGER.error("Some unused state documents could not be deleted due to failures: {}", (Object)(Strings.collectionToCommaDelimitedString((Iterable)response.getBulkFailures()) + "," + Strings.collectionToCommaDelimitedString((Iterable)response.getSearchFailures())));
            } else {
                LOGGER.info("Successfully deleted all unused state documents");
            }
            listener.onResponse((Object)true);
        }, e -> {
            LOGGER.error("Error deleting unused model state documents: ", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private static class JobIdExtractor {
        private static List<Function<String, String>> extractors = Arrays.asList(ModelState::extractJobId, Quantiles::extractJobId, CategorizerState::extractJobId, Classification::extractJobIdFromStateDoc, Regression::extractJobIdFromStateDoc, StoredProgress::extractJobIdFromDocId);

        private JobIdExtractor() {
        }

        private static String extractJobId(String docId) {
            for (Function<String, String> extractor : extractors) {
                String jobId = extractor.apply(docId);
                if (jobId == null) continue;
                return jobId;
            }
            return null;
        }
    }
}

