/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.ml.job.retention.AbstractExpiredJobDataRemover;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;

public class ExpiredModelSnapshotsRemover
extends AbstractExpiredJobDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(ExpiredModelSnapshotsRemover.class);
    private static final long MS_IN_ONE_DAY = TimeValue.timeValueDays((long)1L).getMillis();
    private static final int MODEL_SNAPSHOT_SEARCH_SIZE = 10000;
    private final ThreadPool threadPool;

    public ExpiredModelSnapshotsRemover(OriginSettingClient client, Iterator<Job> jobIterator, ThreadPool threadPool) {
        super(client, jobIterator);
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    @Override
    Long getRetentionDays(Job job) {
        Long retentionDaysForConsideration = job.getDailyModelSnapshotRetentionAfterDays();
        if (retentionDaysForConsideration == null) {
            retentionDaysForConsideration = job.getModelSnapshotRetentionDays();
        }
        return retentionDaysForConsideration;
    }

    @Override
    void calcCutoffEpochMs(String jobId, long retentionDays, ActionListener<AbstractExpiredJobDataRemover.CutoffDetails> listener) {
        ThreadedActionListener threadedActionListener = new ThreadedActionListener(LOGGER, this.threadPool, "ml_utility", listener, false);
        this.latestSnapshotTimeStamp(jobId, (ActionListener<Long>)ActionListener.wrap(latestTime -> {
            if (latestTime == null) {
                threadedActionListener.onResponse(null);
            } else {
                long cutoff = latestTime - new TimeValue(retentionDays, TimeUnit.DAYS).getMillis();
                threadedActionListener.onResponse((Object)new AbstractExpiredJobDataRemover.CutoffDetails((long)latestTime, cutoff));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void latestSnapshotTimeStamp(String jobId, ActionListener<Long> listener) {
        SortBuilder sortBuilder = new FieldSortBuilder(ModelSnapshot.TIMESTAMP.getPreferredName()).order(SortOrder.DESC);
        BoolQueryBuilder snapshotQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName())).filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.TIMESTAMP.getPreferredName()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort(sortBuilder);
        searchSourceBuilder.query((QueryBuilder)snapshotQuery);
        searchSourceBuilder.size(1);
        searchSourceBuilder.trackTotalHits(false);
        searchSourceBuilder.fetchSource(false);
        searchSourceBuilder.docValueField(ModelSnapshot.TIMESTAMP.getPreferredName(), "epoch_millis");
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(searchSourceBuilder);
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        this.client.search(searchRequest, ActionListener.wrap(response -> {
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                listener.onResponse(null);
            } else {
                String timestamp = this.stringFieldValueOrNull(hits[0], ModelSnapshot.TIMESTAMP.getPreferredName());
                if (timestamp == null) {
                    LOGGER.warn("Model snapshot document [{}] has a null timestamp field", (Object)hits[0].getId());
                    listener.onResponse(null);
                } else {
                    long timestampMs = TimeUtils.parseToEpochMs((String)timestamp);
                    listener.onResponse((Object)timestampMs);
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    protected void removeDataBefore(Job job, float requestsPerSec, long latestTimeMs, long cutoffEpochMs, ActionListener<Boolean> listener) {
        if (job.getModelSnapshotId() == null) {
            listener.onResponse((Object)true);
            return;
        }
        LOGGER.debug("Considering model snapshots of job [{}] that have a timestamp before [{}] for removal", (Object)job.getId(), (Object)cutoffEpochMs);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)job.getId())});
        TermQueryBuilder activeSnapshotFilter = QueryBuilders.termQuery((String)ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), (String)job.getModelSnapshotId());
        TermQueryBuilder retainFilter = QueryBuilders.termQuery((String)ModelSnapshot.RETAIN.getPreferredName(), (boolean)true);
        BoolQueryBuilder query = ExpiredModelSnapshotsRemover.createQuery(job.getId(), cutoffEpochMs).filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName())).mustNot((QueryBuilder)activeSnapshotFilter).mustNot((QueryBuilder)retainFilter);
        SearchSourceBuilder source = new SearchSourceBuilder();
        source.query((QueryBuilder)query);
        source.size(10000);
        source.sort(ModelSnapshot.TIMESTAMP.getPreferredName());
        source.fetchSource(false);
        source.docValueField(Job.ID.getPreferredName(), null);
        source.docValueField(ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), null);
        source.docValueField(ModelSnapshot.TIMESTAMP.getPreferredName(), "epoch_millis");
        searchRequest.source(source);
        long deleteAllBeforeMs = job.getModelSnapshotRetentionDays() == null ? 0L : latestTimeMs - TimeValue.timeValueDays((long)job.getModelSnapshotRetentionDays()).getMillis();
        this.client.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new ThreadedActionListener(LOGGER, this.threadPool, "ml_utility", this.expiredSnapshotsListener(job.getId(), deleteAllBeforeMs, listener), false));
    }

    private ActionListener<SearchResponse> expiredSnapshotsListener(final String jobId, final long deleteAllBeforeMs, final ActionListener<Boolean> listener) {
        return new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                long nextToKeepMs = deleteAllBeforeMs;
                try {
                    ArrayList<JobSnapshotId> snapshotIds = new ArrayList<JobSnapshotId>();
                    for (SearchHit hit : searchResponse.getHits()) {
                        String timestamp = ExpiredModelSnapshotsRemover.this.stringFieldValueOrNull(hit, ModelSnapshot.TIMESTAMP.getPreferredName());
                        if (timestamp == null) {
                            LOGGER.warn("Model snapshot document [{}] has a null timestamp field", (Object)hit.getId());
                            continue;
                        }
                        long timestampMs = TimeUtils.parseToEpochMs((String)timestamp);
                        if (timestampMs >= nextToKeepMs) {
                            while (timestampMs >= (nextToKeepMs += MS_IN_ONE_DAY)) {
                            }
                            continue;
                        }
                        JobSnapshotId idPair = new JobSnapshotId(ExpiredModelSnapshotsRemover.this.stringFieldValueOrNull(hit, Job.ID.getPreferredName()), ExpiredModelSnapshotsRemover.this.stringFieldValueOrNull(hit, ModelSnapshotField.SNAPSHOT_ID.getPreferredName()));
                        if (idPair.hasNullValue()) continue;
                        snapshotIds.add(idPair);
                    }
                    ExpiredModelSnapshotsRemover.this.deleteModelSnapshots(new VolatileCursorIterator(snapshotIds), (ActionListener<Boolean>)listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("[" + jobId + "] Search for expired snapshots failed", (Throwable)e, new Object[0])));
            }
        };
    }

    private void deleteModelSnapshots(final Iterator<JobSnapshotId> modelSnapshotIterator, final ActionListener<Boolean> listener) {
        if (!modelSnapshotIterator.hasNext()) {
            listener.onResponse((Object)true);
            return;
        }
        final JobSnapshotId idPair = modelSnapshotIterator.next();
        DeleteModelSnapshotAction.Request deleteSnapshotRequest = new DeleteModelSnapshotAction.Request(idPair.jobId, idPair.snapshotId);
        this.client.execute((ActionType)DeleteModelSnapshotAction.INSTANCE, (ActionRequest)deleteSnapshotRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                try {
                    ExpiredModelSnapshotsRemover.this.deleteModelSnapshots(modelSnapshotIterator, (ActionListener<Boolean>)listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("[" + idPair.jobId + "] Failed to delete snapshot [" + idPair.snapshotId + "]", (Throwable)e, new Object[0])));
            }
        });
    }

    static class JobSnapshotId {
        private final String jobId;
        private final String snapshotId;

        JobSnapshotId(String jobId, String snapshotId) {
            this.jobId = jobId;
            this.snapshotId = snapshotId;
        }

        boolean hasNullValue() {
            return this.jobId == null || this.snapshotId == null;
        }
    }
}

