/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;

abstract class AbstractExpiredJobDataRemover
implements MlDataRemover {
    protected final OriginSettingClient client;
    private final Iterator<Job> jobIterator;

    AbstractExpiredJobDataRemover(OriginSettingClient client, Iterator<Job> jobIterator) {
        this.client = client;
        this.jobIterator = jobIterator;
    }

    @Override
    public void remove(float requestsPerSecond, ActionListener<Boolean> listener, Supplier<Boolean> isTimedOutSupplier) {
        this.removeData(this.jobIterator, requestsPerSecond, listener, isTimedOutSupplier);
    }

    private void removeData(Iterator<Job> jobIterator, float requestsPerSecond, ActionListener<Boolean> listener, Supplier<Boolean> isTimedOutSupplier) {
        if (!jobIterator.hasNext()) {
            listener.onResponse((Object)true);
            return;
        }
        Job job = jobIterator.next();
        if (job == null) {
            listener.onResponse((Object)true);
            return;
        }
        if (isTimedOutSupplier.get().booleanValue()) {
            listener.onResponse((Object)false);
            return;
        }
        Long retentionDays = this.getRetentionDays(job);
        if (retentionDays == null) {
            this.removeData(jobIterator, requestsPerSecond, listener, isTimedOutSupplier);
            return;
        }
        this.calcCutoffEpochMs(job.getId(), retentionDays, (ActionListener<CutoffDetails>)ActionListener.wrap(response -> {
            if (response == null) {
                this.removeData(jobIterator, requestsPerSecond, listener, isTimedOutSupplier);
            } else {
                this.removeDataBefore(job, requestsPerSecond, response.latestTimeMs, response.cutoffEpochMs, (ActionListener<Boolean>)ActionListener.wrap(arg_0 -> this.lambda$removeData$0(jobIterator, requestsPerSecond, listener, (Supplier)isTimedOutSupplier, arg_0), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    abstract void calcCutoffEpochMs(String var1, long var2, ActionListener<CutoffDetails> var4);

    abstract Long getRetentionDays(Job var1);

    abstract void removeDataBefore(Job var1, float var2, long var3, long var5, ActionListener<Boolean> var7);

    static BoolQueryBuilder createQuery(String jobId, long cutoffEpochMs) {
        return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobId)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).lt((Object)cutoffEpochMs).format("epoch_millis"));
    }

    private /* synthetic */ void lambda$removeData$0(Iterator jobIterator, float requestsPerSecond, ActionListener listener, Supplier isTimedOutSupplier, Boolean r) throws Exception {
        this.removeData(jobIterator, requestsPerSecond, (ActionListener<Boolean>)listener, isTimedOutSupplier);
    }

    protected static final class CutoffDetails {
        public final long latestTimeMs;
        public final long cutoffEpochMs;

        public CutoffDetails(long latestTimeMs, long cutoffEpochMs) {
            this.latestTimeMs = latestTimeMs;
            this.cutoffEpochMs = cutoffEpochMs;
        }

        public int hashCode() {
            return Objects.hash(this.latestTimeMs, this.cutoffEpochMs);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof CutoffDetails)) {
                return false;
            }
            CutoffDetails that = (CutoffDetails)other;
            return this.latestTimeMs == that.latestTimeMs && this.cutoffEpochMs == that.cutoffEpochMs;
        }
    }
}

