/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence.overallbuckets;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.OverallBucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class OverallBucketsProvider {
    private final long maxJobBucketSpanSeconds;
    private final int topN;
    private final double minOverallScore;

    public OverallBucketsProvider(TimeValue maxJobBucketSpan, int topN, double minOverallScore) {
        this.maxJobBucketSpanSeconds = maxJobBucketSpan.seconds();
        this.topN = topN;
        this.minOverallScore = minOverallScore;
    }

    public List<OverallBucket> computeOverallBuckets(Histogram histogram) {
        ArrayList<OverallBucket> overallBuckets = new ArrayList<OverallBucket>();
        for (Histogram.Bucket histogramBucket : histogram.getBuckets()) {
            Aggregations histogramBucketAggs = histogramBucket.getAggregations();
            Terms jobsAgg = (Terms)histogramBucketAggs.get(Job.ID.getPreferredName());
            int jobsCount = jobsAgg.getBuckets().size();
            int bucketTopN = Math.min(this.topN, jobsCount);
            TreeSet<OverallBucket.JobInfo> jobs = new TreeSet<OverallBucket.JobInfo>();
            TopNScores topNScores = new TopNScores(bucketTopN);
            for (Terms.Bucket jobsBucket : jobsAgg.getBuckets()) {
                Max maxScore = (Max)jobsBucket.getAggregations().get(OverallBucket.OVERALL_SCORE.getPreferredName());
                topNScores.insertWithOverflow(maxScore.getValue());
                jobs.add(new OverallBucket.JobInfo((String)jobsBucket.getKey(), maxScore.getValue()));
            }
            double overallScore = topNScores.overallScore();
            if (overallScore < this.minOverallScore) continue;
            Max interimAgg = (Max)histogramBucketAggs.get(Result.IS_INTERIM.getPreferredName());
            boolean isInterim = interimAgg.getValue() > 0.0;
            overallBuckets.add(new OverallBucket(OverallBucketsProvider.getHistogramBucketTimestamp(histogramBucket), this.maxJobBucketSpanSeconds, overallScore, new ArrayList(jobs), isInterim));
        }
        return overallBuckets;
    }

    private static Date getHistogramBucketTimestamp(Histogram.Bucket bucket) {
        ZonedDateTime bucketTimestamp = (ZonedDateTime)bucket.getKey();
        return new Date(bucketTimestamp.toInstant().toEpochMilli());
    }

    static class TopNScores
    extends PriorityQueue<Double> {
        TopNScores(int n) {
            super(n);
        }

        protected boolean lessThan(Double a, Double b) {
            return a < b;
        }

        double overallScore() {
            double overallScore = 0.0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                double score = (Double)iterator.next();
                overallScore += score;
            }
            return this.size() > 0 ? overallScore / (double)this.size() : 0.0;
        }
    }
}

