/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class JobDataCountsPersister {
    private static final Logger logger = LogManager.getLogger(JobDataCountsPersister.class);
    private final ResultsPersisterService resultsPersisterService;
    private final Client client;
    private final AnomalyDetectionAuditor auditor;

    public JobDataCountsPersister(Client client, ResultsPersisterService resultsPersisterService, AnomalyDetectionAuditor auditor) {
        this.resultsPersisterService = resultsPersisterService;
        this.client = client;
        this.auditor = auditor;
    }

    private static XContentBuilder serialiseCounts(DataCounts counts) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        return counts.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public void persistDataCounts(String jobId, DataCounts counts) {
        try {
            this.resultsPersisterService.indexWithRetry(jobId, AnomalyDetectorsIndex.resultsWriteAlias((String)jobId), (ToXContent)counts, ToXContent.EMPTY_PARAMS, WriteRequest.RefreshPolicy.NONE, DataCounts.documentId((String)jobId), () -> true, msg -> this.auditor.warning(jobId, "Job data_counts " + msg));
        }
        catch (IOException ioe) {
            logger.error(() -> new ParameterizedMessage("[{}] Failed writing data_counts stats", (Object)jobId), (Throwable)ioe);
        }
        catch (Exception ex) {
            logger.error(() -> new ParameterizedMessage("[{}] Failed persisting data_counts stats", (Object)jobId), (Throwable)ex);
        }
    }

    public void persistDataCountsAsync(String jobId, DataCounts counts, final ActionListener<Boolean> listener) {
        try (XContentBuilder content = JobDataCountsPersister.serialiseCounts(counts);){
            IndexRequest request = new IndexRequest(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId)).id(DataCounts.documentId((String)jobId)).source(content);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    listener.onResponse((Object)true);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (IOException ioe) {
            String msg = new ParameterizedMessage("[{}] Failed writing data_counts stats", (Object)jobId).getFormattedMessage();
            logger.error(msg, (Throwable)ioe);
            listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)msg, (Throwable)ioe)));
        }
    }
}

