/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public class MlClassicTokenizer
extends Tokenizer {
    public static String NAME = "ml_classic";
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private int nextOffset;
    private int skippedPositions;

    MlClassicTokenizer() {
    }

    public final boolean incrementToken() throws IOException {
        char toCheck;
        int curChar;
        this.clearAttributes();
        this.skippedPositions = 0;
        int start = -1;
        int length = 0;
        boolean haveNonHex = false;
        while ((curChar = this.input.read()) >= 0) {
            ++this.nextOffset;
            if (Character.isLetterOrDigit(curChar) || length > 0 && (curChar == 95 || curChar == 46 || curChar == 45)) {
                if (length == 0) {
                    start = this.nextOffset - 1;
                }
                this.termAtt.append((char)curChar);
                ++length;
                haveNonHex = haveNonHex || Character.digit(curChar, 16) == -1 && curChar != 46 && curChar != 45;
                continue;
            }
            if (length <= 0) continue;
            if (haveNonHex && !Character.isDigit(this.termAtt.charAt(0))) break;
            ++this.skippedPositions;
            start = -1;
            length = 0;
            this.termAtt.setEmpty();
        }
        if (length == 0) {
            return false;
        }
        if (!haveNonHex || Character.isDigit(this.termAtt.charAt(0))) {
            ++this.skippedPositions;
            return false;
        }
        while ((toCheck = this.termAtt.charAt(length - 1)) == '_' || toCheck == '.' || toCheck == '-') {
            --length;
        }
        this.termAtt.setLength(length);
        this.offsetAtt.setOffset(start, start + length);
        this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
        return true;
    }

    public final void end() throws IOException {
        super.end();
        int finalOffset = this.nextOffset + (int)this.input.skip(Integer.MAX_VALUE);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    public void reset() throws IOException {
        super.reset();
        this.nextOffset = 0;
        this.skippedPositions = 0;
    }
}

