/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceStats;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class TrainedModelStatsService {
    private static final Logger logger = LogManager.getLogger(TrainedModelStatsService.class);
    private static final TimeValue PERSISTENCE_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    private static final String STATS_UPDATE_SCRIPT_TEMPLATE = "    ctx._source.{0} += params.{0};\n    ctx._source.{1} += params.{1};\n    ctx._source.{2} += params.{2};\n    ctx._source.{3} += params.{3};\n    ctx._source.{4} = params.{4};";
    private static final String STATS_UPDATE_SCRIPT = Messages.getMessage((String)"    ctx._source.{0} += params.{0};\n    ctx._source.{1} += params.{1};\n    ctx._source.{2} += params.{2};\n    ctx._source.{3} += params.{3};\n    ctx._source.{4} = params.{4};", (Object[])new Object[]{InferenceStats.MISSING_ALL_FIELDS_COUNT.getPreferredName(), InferenceStats.INFERENCE_COUNT.getPreferredName(), InferenceStats.FAILURE_COUNT.getPreferredName(), InferenceStats.CACHE_MISS_COUNT.getPreferredName(), InferenceStats.TIMESTAMP.getPreferredName()});
    private static final ToXContent.Params FOR_INTERNAL_STORAGE_PARAMS = new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true"));
    private final Map<String, InferenceStats> statsQueue;
    private final ResultsPersisterService resultsPersisterService;
    private final OriginSettingClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ThreadPool threadPool;
    private volatile Scheduler.Cancellable scheduledFuture;
    private volatile boolean stopped;
    private volatile ClusterState clusterState;

    public TrainedModelStatsService(ResultsPersisterService resultsPersisterService, OriginSettingClient client, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ThreadPool threadPool) {
        this.resultsPersisterService = resultsPersisterService;
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.threadPool = threadPool;
        this.statsQueue = new ConcurrentHashMap<String, InferenceStats>();
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStart() {
                TrainedModelStatsService.this.start();
            }

            public void beforeStop() {
                TrainedModelStatsService.this.stop();
            }
        });
        clusterService.addListener(event -> {
            this.clusterState = event.state();
        });
    }

    public void queueStats(InferenceStats stats, boolean flush) {
        if (stats.hasStats()) {
            this.statsQueue.compute(InferenceStats.docId((String)stats.getModelId(), (String)stats.getNodeId()), (k, previousStats) -> previousStats == null ? stats : InferenceStats.accumulator((InferenceStats)stats).merge(previousStats).currentStats(stats.getTimeStamp()));
        }
        if (flush) {
            this.threadPool.executor("ml_utility").execute(this::updateStats);
        }
    }

    void stop() {
        logger.debug("About to stop TrainedModelStatsService");
        this.stopped = true;
        this.statsQueue.clear();
        Scheduler.Cancellable cancellable = this.scheduledFuture;
        if (cancellable != null) {
            cancellable.cancel();
        }
    }

    void start() {
        logger.debug("About to start TrainedModelStatsService");
        this.stopped = false;
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(this::updateStats, PERSISTENCE_INTERVAL, "ml_utility");
    }

    void updateStats() {
        block8: {
            if (this.clusterState == null || this.statsQueue.isEmpty() || this.stopped) {
                return;
            }
            if (!TrainedModelStatsService.verifyIndicesExistAndPrimaryShardsAreActive(this.clusterState, this.indexNameExpressionResolver)) {
                try {
                    logger.debug("About to create the stats index as it does not exist yet");
                    this.createStatsIndexIfNecessary();
                }
                catch (Exception e) {
                    if (e instanceof InvalidAliasNameException) break block8;
                    logger.error("failure creating ml stats index for storing model stats", (Throwable)e);
                    return;
                }
            }
        }
        ArrayList<InferenceStats> stats = new ArrayList<InferenceStats>(this.statsQueue.size());
        HashSet<String> keys = new HashSet<String>(this.statsQueue.keySet());
        for (String k : keys) {
            InferenceStats inferenceStats = this.statsQueue.remove(k);
            if (inferenceStats == null) continue;
            stats.add(inferenceStats);
        }
        if (stats.isEmpty()) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        stats.stream().map(TrainedModelStatsService::buildUpdateRequest).filter(Objects::nonNull).forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        if (bulkRequest.requests().isEmpty()) {
            return;
        }
        if (this.stopped) {
            return;
        }
        this.resultsPersisterService.bulkIndexWithRetry(bulkRequest, stats.stream().map(InferenceStats::getModelId).collect(Collectors.joining(",")), () -> !this.stopped, msg -> {});
    }

    static boolean verifyIndicesExistAndPrimaryShardsAreActive(ClusterState clusterState, IndexNameExpressionResolver expressionResolver) {
        String[] indices = expressionResolver.concreteIndexNames(clusterState, IndicesOptions.LENIENT_EXPAND_OPEN_HIDDEN, new String[]{MlStatsIndex.writeAlias()});
        if (indices.length == 0) {
            return false;
        }
        for (String index : indices) {
            if (!clusterState.metadata().hasIndex(index)) {
                return false;
            }
            IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            return false;
        }
        return true;
    }

    private void createStatsIndexIfNecessary() {
        PlainActionFuture listener = new PlainActionFuture();
        MlStatsIndex.createStatsIndexAndAliasIfNecessary((Client)this.client, (ClusterState)this.clusterState, (IndexNameExpressionResolver)this.indexNameExpressionResolver, (ActionListener)ActionListener.wrap(r -> ElasticsearchMappings.addDocMappingIfMissing((String)MlStatsIndex.writeAlias(), MlStatsIndex::mapping, (Client)this.client, (ClusterState)this.clusterState, (ActionListener)listener), arg_0 -> ((PlainActionFuture)listener).onFailure(arg_0)));
        listener.actionGet();
        logger.debug("Created stats index");
    }

    static UpdateRequest buildUpdateRequest(InferenceStats stats) {
        UpdateRequest updateRequest;
        block8: {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put(InferenceStats.FAILURE_COUNT.getPreferredName(), stats.getFailureCount());
                params.put(InferenceStats.MISSING_ALL_FIELDS_COUNT.getPreferredName(), stats.getMissingAllFieldsCount());
                params.put(InferenceStats.TIMESTAMP.getPreferredName(), stats.getTimeStamp().toEpochMilli());
                params.put(InferenceStats.INFERENCE_COUNT.getPreferredName(), stats.getInferenceCount());
                params.put(InferenceStats.CACHE_MISS_COUNT.getPreferredName(), stats.getCacheMissCount());
                stats.toXContent(builder, FOR_INTERNAL_STORAGE_PARAMS);
                UpdateRequest updateRequest2 = new UpdateRequest();
                ((UpdateRequest)updateRequest2.upsert(builder).index(MlStatsIndex.writeAlias())).retryOnConflict(3).id(InferenceStats.docId((String)stats.getModelId(), (String)stats.getNodeId())).script(new Script(ScriptType.INLINE, "painless", STATS_UPDATE_SCRIPT, params));
                updateRequest = updateRequest2;
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    logger.error(() -> new ParameterizedMessage("[{}] [{}] failed to serialize stats for update.", (Object)stats.getModelId(), (Object)stats.getNodeId()), (Throwable)ex);
                    return null;
                }
            }
            builder.close();
        }
        return updateRequest;
    }
}

