/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.core.ml.action.FindFileStructureAction;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FieldStats;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FileStructure;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureUtils;
import org.elasticsearch.xpack.ml.filestructurefinder.GrokPatternCreator;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;
import org.elasticsearch.xpack.ml.filestructurefinder.TimestampFormatFinder;

public class TextLogFileStructureFinder
implements FileStructureFinder {
    private final List<String> sampleMessages;
    private final FileStructure structure;

    static TextLogFileStructureFinder makeTextLogFileStructureFinder(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, int lineMergeSizeLimit, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        String[] sampleLines = sample.split("\n");
        TimestampFormatFinder timestampFormatFinder = TextLogFileStructureFinder.populateTimestampFormatFinder(explanation, sampleLines, overrides, timeoutChecker);
        switch (timestampFormatFinder.getNumMatchedFormats()) {
            case 0: {
                throw new IllegalArgumentException("Could not find " + (overrides.getTimestampFormat() == null ? "a timestamp" : "the specified timestamp format") + " in the sample provided");
            }
            case 1: {
                break;
            }
            default: {
                timestampFormatFinder.selectBestMatch();
            }
        }
        explanation.add((overrides.getTimestampFormat() == null ? "Most likely timestamp" : "Timestamp") + " format is " + timestampFormatFinder.getJavaTimestampFormats());
        ArrayList<String> sampleMessages = new ArrayList<String>();
        StringBuilder preamble = new StringBuilder();
        int linesConsumed = 0;
        StringBuilder message = null;
        int linesInMessage = 0;
        String multiLineRegex = TextLogFileStructureFinder.createMultiLineMessageStartRegex(timestampFormatFinder.getPrefaces(), timestampFormatFinder.getSimplePattern().pattern());
        Pattern multiLinePattern = Pattern.compile(multiLineRegex);
        for (String sampleLine : sampleLines) {
            if (multiLinePattern.matcher(sampleLine).find()) {
                if (message != null) {
                    sampleMessages.add(message.toString());
                    linesConsumed += linesInMessage;
                }
                message = new StringBuilder(sampleLine);
                linesInMessage = 1;
            } else if (message == null) {
                ++linesConsumed;
            } else {
                long lengthAfterAppend = (long)message.length() + 1L + (long)sampleLine.length();
                if (lengthAfterAppend > (long)lineMergeSizeLimit) {
                    assert (linesInMessage > 0);
                    throw new IllegalArgumentException("Merging lines into messages resulted in an unacceptably long message. Merged message would have [" + (linesInMessage + 1) + "] lines and [" + lengthAfterAppend + "] characters (limit [" + lineMergeSizeLimit + "]). If you have messages this big please increase the value of [" + FindFileStructureAction.Request.LINE_MERGE_SIZE_LIMIT + "]. Otherwise it probably means the timestamp has been incorrectly detected, so try overriding that.");
                }
                message.append('\n').append(sampleLine);
                ++linesInMessage;
            }
            timeoutChecker.check("multi-line message determination");
            if (sampleMessages.size() >= 2) continue;
            preamble.append(sampleLine).append('\n');
        }
        if (sampleMessages.isEmpty()) {
            throw new IllegalArgumentException("Failed to create more than one message from the sample lines provided. (The last is discarded in case the sample is incomplete.) If your sample does contain multiple messages the problem is probably that the primary timestamp format has been incorrectly detected, so try overriding it.");
        }
        sampleLines = null;
        FileStructure.Builder structureBuilder = new FileStructure.Builder(FileStructure.Format.SEMI_STRUCTURED_TEXT).setCharset(charsetName).setHasByteOrderMarker(hasByteOrderMarker).setSampleStart(preamble.toString()).setNumLinesAnalyzed(linesConsumed).setNumMessagesAnalyzed(sampleMessages.size()).setMultilineStartPattern(multiLineRegex);
        Map<String, String> messageMapping = Collections.singletonMap("type", "text");
        TreeMap<String, Object> mappings = new TreeMap<String, Object>();
        mappings.put("message", messageMapping);
        mappings.put("@timestamp", FileStructureUtils.DATE_MAPPING_WITHOUT_FORMAT);
        TreeMap<String, FieldStats> fieldStats = new TreeMap<String, FieldStats>();
        fieldStats.put("message", FileStructureUtils.calculateFieldStats(messageMapping, sampleMessages, timeoutChecker));
        Map<String, String> customGrokPatternDefinitions = timestampFormatFinder.getCustomGrokPatternDefinitions();
        GrokPatternCreator grokPatternCreator = new GrokPatternCreator(explanation, sampleMessages, mappings, fieldStats, customGrokPatternDefinitions, timeoutChecker);
        String interimTimestampField = overrides.getTimestampField();
        String grokPattern = overrides.getGrokPattern();
        if (grokPattern != null) {
            if (interimTimestampField == null) {
                interimTimestampField = "timestamp";
            }
            grokPatternCreator.validateFullLineGrokPattern(grokPattern, interimTimestampField);
        } else {
            Tuple<String, String> timestampFieldAndFullMatchGrokPattern = grokPatternCreator.findFullLineGrokPattern(interimTimestampField);
            if (timestampFieldAndFullMatchGrokPattern != null) {
                interimTimestampField = (String)timestampFieldAndFullMatchGrokPattern.v1();
                grokPattern = (String)timestampFieldAndFullMatchGrokPattern.v2();
            } else {
                if (interimTimestampField == null) {
                    interimTimestampField = "timestamp";
                }
                grokPattern = grokPatternCreator.createGrokPatternFromExamples(timestampFormatFinder.getGrokPatternName(), timestampFormatFinder.getEsDateMappingTypeWithFormat(), interimTimestampField);
            }
        }
        boolean needClientTimeZone = timestampFormatFinder.hasTimezoneDependentParsing();
        FileStructure structure = structureBuilder.setTimestampField(interimTimestampField).setJodaTimestampFormats(timestampFormatFinder.getJodaTimestampFormats()).setJavaTimestampFormats(timestampFormatFinder.getJavaTimestampFormats()).setNeedClientTimezone(needClientTimeZone).setGrokPattern(grokPattern).setIngestPipeline(FileStructureUtils.makeIngestPipelineDefinition(grokPattern, customGrokPatternDefinitions, null, mappings, interimTimestampField, timestampFormatFinder.getJavaTimestampFormats(), needClientTimeZone)).setMappings(mappings).setFieldStats(fieldStats).setExplanation(explanation).build();
        return new TextLogFileStructureFinder(sampleMessages, structure);
    }

    private TextLogFileStructureFinder(List<String> sampleMessages, FileStructure structure) {
        this.sampleMessages = Collections.unmodifiableList(sampleMessages);
        this.structure = structure;
    }

    @Override
    public List<String> getSampleMessages() {
        return this.sampleMessages;
    }

    @Override
    public FileStructure getStructure() {
        return this.structure;
    }

    static TimestampFormatFinder populateTimestampFormatFinder(List<String> explanation, String[] sampleLines, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        TimestampFormatFinder timestampFormatFinder = new TimestampFormatFinder(explanation, overrides.getTimestampFormat(), false, false, false, timeoutChecker);
        for (String sampleLine : sampleLines) {
            timestampFormatFinder.addSample(sampleLine);
        }
        return timestampFormatFinder;
    }

    static String createMultiLineMessageStartRegex(Collection<String> prefaces, String simpleDateRegex) {
        StringBuilder builder = new StringBuilder("^");
        GrokPatternCreator.addIntermediateRegex(builder, prefaces);
        builder.append(simpleDateRegex);
        if (builder.substring(0, 3).equals("^\\b")) {
            builder.delete(1, 3);
        }
        return builder.toString();
    }
}

