/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FileStructure;
import org.elasticsearch.xpack.ml.filestructurefinder.DelimitedFileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinderFactory;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;
import org.supercsv.prefs.CsvPreference;

public class DelimitedFileStructureFinderFactory
implements FileStructureFinderFactory {
    static final double DELIMITER_OVERRIDDEN_ALLOWED_FRACTION_OF_BAD_LINES = 0.1;
    static final double FORMAT_OVERRIDDEN_ALLOWED_FRACTION_OF_BAD_LINES = 0.05;
    private final CsvPreference csvPreference;
    private final int minFieldsPerRow;
    private final boolean trimFields;

    DelimitedFileStructureFinderFactory(char delimiter, char quote, int minFieldsPerRow, boolean trimFields) {
        this.csvPreference = new CsvPreference.Builder(quote, (int)delimiter, "\n").build();
        this.minFieldsPerRow = minFieldsPerRow;
        this.trimFields = trimFields;
    }

    DelimitedFileStructureFinderFactory makeSimilar(Character quote, Boolean trimFields) {
        return new DelimitedFileStructureFinderFactory((char)this.csvPreference.getDelimiterChar(), quote == null ? this.csvPreference.getQuoteChar() : quote.charValue(), this.minFieldsPerRow, trimFields == null ? this.trimFields : trimFields);
    }

    @Override
    public boolean canFindFormat(FileStructure.Format format) {
        return format == null || format == FileStructure.Format.DELIMITED;
    }

    @Override
    public boolean canCreateFromSample(List<String> explanation, String sample, double allowedFractionOfBadLines) {
        String formatName;
        switch ((char)this.csvPreference.getDelimiterChar()) {
            case ',': {
                formatName = "CSV";
                break;
            }
            case '\t': {
                formatName = "TSV";
                break;
            }
            default: {
                formatName = Character.getName(this.csvPreference.getDelimiterChar()).toLowerCase(Locale.ROOT) + " delimited values";
            }
        }
        return DelimitedFileStructureFinder.canCreateFromSample(explanation, sample, this.minFieldsPerRow, this.csvPreference, formatName, allowedFractionOfBadLines);
    }

    @Override
    public FileStructureFinder createFromSample(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, int lineMergeSizeLimit, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException {
        CsvPreference adjustedCsvPreference = new CsvPreference.Builder(this.csvPreference).maxLinesPerRow(lineMergeSizeLimit).build();
        return DelimitedFileStructureFinder.makeDelimitedFileStructureFinder(explanation, sample, charsetName, hasByteOrderMarker, adjustedCsvPreference, this.trimFields, overrides, timeoutChecker);
    }
}

