/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process.results;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.stats.classification.ClassificationStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.MemoryUsage;
import org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection.OutlierDetectionStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.regression.RegressionStats;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.dataframe.process.results.RowResults;
import org.elasticsearch.xpack.ml.dataframe.process.results.TrainedModelDefinitionChunk;
import org.elasticsearch.xpack.ml.inference.modelsize.ModelSizeInfo;

public class AnalyticsResult
implements ToXContentObject {
    public static final ParseField TYPE = new ParseField("analytics_result", new String[0]);
    private static final ParseField PHASE_PROGRESS = new ParseField("phase_progress", new String[0]);
    private static final ParseField MODEL_SIZE_INFO = new ParseField("model_size_info", new String[0]);
    private static final ParseField COMPRESSED_INFERENCE_MODEL = new ParseField("compressed_inference_model", new String[0]);
    private static final ParseField ANALYTICS_MEMORY_USAGE = new ParseField("analytics_memory_usage", new String[0]);
    private static final ParseField OUTLIER_DETECTION_STATS = new ParseField("outlier_detection_stats", new String[0]);
    private static final ParseField CLASSIFICATION_STATS = new ParseField("classification_stats", new String[0]);
    private static final ParseField REGRESSION_STATS = new ParseField("regression_stats", new String[0]);
    public static final ConstructingObjectParser<AnalyticsResult, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new AnalyticsResult((RowResults)a[0], (PhaseProgress)a[1], (MemoryUsage)a[2], (OutlierDetectionStats)a[3], (ClassificationStats)a[4], (RegressionStats)a[5], (ModelSizeInfo)a[6], (TrainedModelDefinitionChunk)a[7]));
    private final RowResults rowResults;
    private final PhaseProgress phaseProgress;
    private final MemoryUsage memoryUsage;
    private final OutlierDetectionStats outlierDetectionStats;
    private final ClassificationStats classificationStats;
    private final RegressionStats regressionStats;
    private final ModelSizeInfo modelSizeInfo;
    private final TrainedModelDefinitionChunk trainedModelDefinitionChunk;

    private AnalyticsResult(@Nullable RowResults rowResults, @Nullable PhaseProgress phaseProgress, @Nullable MemoryUsage memoryUsage, @Nullable OutlierDetectionStats outlierDetectionStats, @Nullable ClassificationStats classificationStats, @Nullable RegressionStats regressionStats, @Nullable ModelSizeInfo modelSizeInfo, @Nullable TrainedModelDefinitionChunk trainedModelDefinitionChunk) {
        this.rowResults = rowResults;
        this.phaseProgress = phaseProgress;
        this.memoryUsage = memoryUsage;
        this.outlierDetectionStats = outlierDetectionStats;
        this.classificationStats = classificationStats;
        this.regressionStats = regressionStats;
        this.modelSizeInfo = modelSizeInfo;
        this.trainedModelDefinitionChunk = trainedModelDefinitionChunk;
    }

    public RowResults getRowResults() {
        return this.rowResults;
    }

    public PhaseProgress getPhaseProgress() {
        return this.phaseProgress;
    }

    public MemoryUsage getMemoryUsage() {
        return this.memoryUsage;
    }

    public OutlierDetectionStats getOutlierDetectionStats() {
        return this.outlierDetectionStats;
    }

    public ClassificationStats getClassificationStats() {
        return this.classificationStats;
    }

    public RegressionStats getRegressionStats() {
        return this.regressionStats;
    }

    public ModelSizeInfo getModelSizeInfo() {
        return this.modelSizeInfo;
    }

    public TrainedModelDefinitionChunk getTrainedModelDefinitionChunk() {
        return this.trainedModelDefinitionChunk;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.rowResults != null) {
            builder.field(RowResults.TYPE.getPreferredName(), (ToXContent)this.rowResults);
        }
        if (this.phaseProgress != null) {
            builder.field(PHASE_PROGRESS.getPreferredName(), (ToXContent)this.phaseProgress);
        }
        if (this.memoryUsage != null) {
            builder.field(ANALYTICS_MEMORY_USAGE.getPreferredName(), (ToXContent)this.memoryUsage, params);
        }
        if (this.outlierDetectionStats != null) {
            builder.field(OUTLIER_DETECTION_STATS.getPreferredName(), (ToXContent)this.outlierDetectionStats, params);
        }
        if (this.classificationStats != null) {
            builder.field(CLASSIFICATION_STATS.getPreferredName(), (ToXContent)this.classificationStats, params);
        }
        if (this.regressionStats != null) {
            builder.field(REGRESSION_STATS.getPreferredName(), (ToXContent)this.regressionStats, params);
        }
        if (this.modelSizeInfo != null) {
            builder.field(MODEL_SIZE_INFO.getPreferredName(), (ToXContent)this.modelSizeInfo);
        }
        if (this.trainedModelDefinitionChunk != null) {
            builder.field(COMPRESSED_INFERENCE_MODEL.getPreferredName(), (ToXContent)this.trainedModelDefinitionChunk);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AnalyticsResult that = (AnalyticsResult)other;
        return Objects.equals(this.rowResults, that.rowResults) && Objects.equals(this.phaseProgress, that.phaseProgress) && Objects.equals(this.memoryUsage, that.memoryUsage) && Objects.equals(this.outlierDetectionStats, that.outlierDetectionStats) && Objects.equals(this.classificationStats, that.classificationStats) && Objects.equals(this.modelSizeInfo, that.modelSizeInfo) && Objects.equals(this.trainedModelDefinitionChunk, that.trainedModelDefinitionChunk) && Objects.equals(this.regressionStats, that.regressionStats);
    }

    public int hashCode() {
        return Objects.hash(this.rowResults, this.phaseProgress, this.memoryUsage, this.outlierDetectionStats, this.classificationStats, this.regressionStats, this.modelSizeInfo, this.trainedModelDefinitionChunk);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), RowResults.PARSER, RowResults.TYPE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)PhaseProgress.PARSER, PHASE_PROGRESS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)MemoryUsage.STRICT_PARSER, ANALYTICS_MEMORY_USAGE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)OutlierDetectionStats.STRICT_PARSER, OUTLIER_DETECTION_STATS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)ClassificationStats.STRICT_PARSER, CLASSIFICATION_STATS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)RegressionStats.STRICT_PARSER, REGRESSION_STATS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ModelSizeInfo.PARSER, MODEL_SIZE_INFO);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), TrainedModelDefinitionChunk.PARSER, COMPRESSED_INFERENCE_MODEL);
    }

    public static class Builder {
        private RowResults rowResults;
        private PhaseProgress phaseProgress;
        private MemoryUsage memoryUsage;
        private OutlierDetectionStats outlierDetectionStats;
        private ClassificationStats classificationStats;
        private RegressionStats regressionStats;
        private ModelSizeInfo modelSizeInfo;
        private TrainedModelDefinitionChunk trainedModelDefinitionChunk;

        private Builder() {
        }

        public Builder setRowResults(RowResults rowResults) {
            this.rowResults = rowResults;
            return this;
        }

        public Builder setPhaseProgress(PhaseProgress phaseProgress) {
            this.phaseProgress = phaseProgress;
            return this;
        }

        public Builder setMemoryUsage(MemoryUsage memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this;
        }

        public Builder setOutlierDetectionStats(OutlierDetectionStats outlierDetectionStats) {
            this.outlierDetectionStats = outlierDetectionStats;
            return this;
        }

        public Builder setClassificationStats(ClassificationStats classificationStats) {
            this.classificationStats = classificationStats;
            return this;
        }

        public Builder setRegressionStats(RegressionStats regressionStats) {
            this.regressionStats = regressionStats;
            return this;
        }

        public Builder setModelSizeInfo(ModelSizeInfo modelSizeInfo) {
            this.modelSizeInfo = modelSizeInfo;
            return this;
        }

        public Builder setTrainedModelDefinitionChunk(TrainedModelDefinitionChunk trainedModelDefinitionChunk) {
            this.trainedModelDefinitionChunk = trainedModelDefinitionChunk;
            return this;
        }

        public AnalyticsResult build() {
            return new AnalyticsResult(this.rowResults, this.phaseProgress, this.memoryUsage, this.outlierDetectionStats, this.classificationStats, this.regressionStats, this.modelSizeInfo, this.trainedModelDefinitionChunk);
        }
    }
}

