/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.ml.dataframe.process.AbstractNativeAnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsControlMessageWriter;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.dataframe.process.results.AnalyticsResult;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.process.StateToProcessWriterHelper;

public class NativeAnalyticsProcess
extends AbstractNativeAnalyticsProcess<AnalyticsResult> {
    private static final String NAME = "analytics";
    private final AnalyticsProcessConfig config;

    protected NativeAnalyticsProcess(String jobId, ProcessPipes processPipes, int numberOfFields, List<Path> filesToDelete, Consumer<String> onProcessCrash, Duration processConnectTimeout, AnalyticsProcessConfig config, NamedXContentRegistry namedXContentRegistry) {
        super(NAME, AnalyticsResult.PARSER, jobId, processPipes, numberOfFields, filesToDelete, onProcessCrash, processConnectTimeout, namedXContentRegistry);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void persistState() {
    }

    @Override
    public void writeEndOfDataMessage() throws IOException {
        new AnalyticsControlMessageWriter(this.recordWriter(), this.numberOfFields()).writeEndOfData();
    }

    @Override
    public AnalyticsProcessConfig getConfig() {
        return this.config;
    }

    @Override
    public void restoreState(BytesReference state) throws IOException {
        Objects.requireNonNull(state);
        try (OutputStream restoreStream = this.processRestoreStream();){
            StateToProcessWriterHelper.writeStateToStream(state, restoreStream);
        }
    }
}

