/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessFactory;
import org.elasticsearch.xpack.ml.dataframe.process.results.MemoryUsageEstimationResult;

public class MemoryUsageEstimationProcessManager {
    private static final Logger LOGGER = LogManager.getLogger(MemoryUsageEstimationProcessManager.class);
    private final ExecutorService executorServiceForJob;
    private final ExecutorService executorServiceForProcess;
    private final AnalyticsProcessFactory<MemoryUsageEstimationResult> processFactory;

    public MemoryUsageEstimationProcessManager(ExecutorService executorServiceForJob, ExecutorService executorServiceForProcess, AnalyticsProcessFactory<MemoryUsageEstimationResult> processFactory) {
        this.executorServiceForJob = Objects.requireNonNull(executorServiceForJob);
        this.executorServiceForProcess = Objects.requireNonNull(executorServiceForProcess);
        this.processFactory = Objects.requireNonNull(processFactory);
    }

    public void runJobAsync(String jobId, DataFrameAnalyticsConfig config, DataFrameDataExtractorFactory dataExtractorFactory, ActionListener<MemoryUsageEstimationResult> listener) {
        this.executorServiceForJob.execute(() -> {
            try {
                MemoryUsageEstimationResult result = this.runJob(jobId, config, dataExtractorFactory);
                listener.onResponse((Object)result);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MemoryUsageEstimationResult runJob(String jobId, DataFrameAnalyticsConfig config, DataFrameDataExtractorFactory dataExtractorFactory) {
        MemoryUsageEstimationResult memoryUsageEstimationResult;
        DataFrameDataExtractor dataExtractor = dataExtractorFactory.newExtractor(false);
        DataFrameDataExtractor.DataSummary dataSummary = dataExtractor.collectDataSummary();
        if (dataSummary.rows == 0L) {
            throw ExceptionsHelper.badRequestException((String)"[{}] Unable to estimate memory usage as no documents in the source indices [{}] contained all the fields selected for analysis. If you are relying on automatic field selection then there are currently mapped fields that do not exist in any indexed documents, and you will have to switch to explicit field selection and include only fields that exist in indexed documents.", (Object[])new Object[]{jobId, Strings.arrayToCommaDelimitedString((Object[])config.getSource().getIndex())});
        }
        Set<String> categoricalFields = dataExtractor.getCategoricalFields(config.getAnalysis());
        AnalyticsProcessConfig processConfig = new AnalyticsProcessConfig(jobId, dataSummary.rows, dataSummary.cols, new ByteSizeValue(1L, ByteSizeUnit.PB), 1, "", categoricalFields, config.getAnalysis(), dataExtractorFactory.getExtractedFields());
        AnalyticsProcess<MemoryUsageEstimationResult> process = this.processFactory.createAnalyticsProcess(config, processConfig, null, this.executorServiceForProcess, reason -> {});
        try {
            memoryUsageEstimationResult = MemoryUsageEstimationProcessManager.readResult(jobId, process);
            process.consumeAndCloseOutputStream();
        }
        catch (Exception e) {
            try {
                String errorMsg = new ParameterizedMessage("[{}] Error while processing process output [{}], process errors: [{}]", new Object[]{jobId, e.getMessage(), process.readError()}).getFormattedMessage();
                throw ExceptionsHelper.serverError((String)errorMsg, (Throwable)e);
            }
            catch (Throwable throwable) {
                process.consumeAndCloseOutputStream();
                try {
                    LOGGER.debug("[{}] Closing process", (Object)jobId);
                    process.close();
                    LOGGER.debug("[{}] Closed process", (Object)jobId);
                    throw throwable;
                }
                catch (Exception e2) {
                    String errorMsg = new ParameterizedMessage("[{}] Error while closing process [{}], process errors: [{}]", new Object[]{jobId, e2.getMessage(), process.readError()}).getFormattedMessage();
                    throw ExceptionsHelper.serverError((String)errorMsg, (Throwable)e2);
                }
            }
        }
        try {
            LOGGER.debug("[{}] Closing process", (Object)jobId);
            process.close();
            LOGGER.debug("[{}] Closed process", (Object)jobId);
            return memoryUsageEstimationResult;
        }
        catch (Exception e) {
            String errorMsg = new ParameterizedMessage("[{}] Error while closing process [{}], process errors: [{}]", new Object[]{jobId, e.getMessage(), process.readError()}).getFormattedMessage();
            throw ExceptionsHelper.serverError((String)errorMsg, (Throwable)e);
        }
    }

    private static MemoryUsageEstimationResult readResult(String jobId, AnalyticsProcess<MemoryUsageEstimationResult> process) {
        Iterator<MemoryUsageEstimationResult> iterator = process.readAnalyticsResults();
        if (!iterator.hasNext()) {
            String errorMsg = new ParameterizedMessage("[{}] Memory usage estimation process returned no results", (Object)jobId).getFormattedMessage();
            throw ExceptionsHelper.serverError((String)errorMsg);
        }
        MemoryUsageEstimationResult result = iterator.next();
        if (iterator.hasNext()) {
            String errorMsg = new ParameterizedMessage("[{}] Memory usage estimation process returned more than one result", (Object)jobId).getFormattedMessage();
            throw ExceptionsHelper.serverError((String)errorMsg);
        }
        return result;
    }
}

