/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.LatchedActionListener;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.license.License;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Regression;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelInput;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.process.AnalysisFieldInfo;
import org.elasticsearch.xpack.ml.dataframe.process.results.TrainedModelDefinitionChunk;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.extractor.MultiField;
import org.elasticsearch.xpack.ml.inference.modelsize.ModelSizeInfo;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelDefinitionDoc;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class ChunkedTrainedModelPersister {
    private static final Logger LOGGER = LogManager.getLogger(ChunkedTrainedModelPersister.class);
    private static final int STORE_TIMEOUT_SEC = 30;
    private final TrainedModelProvider provider;
    private final AtomicReference<String> currentModelId;
    private final DataFrameAnalyticsConfig analytics;
    private final DataFrameAnalyticsAuditor auditor;
    private final Consumer<Exception> failureHandler;
    private final ExtractedFields extractedFields;
    private final AtomicBoolean readyToStoreNewModel = new AtomicBoolean(true);

    public ChunkedTrainedModelPersister(TrainedModelProvider provider, DataFrameAnalyticsConfig analytics, DataFrameAnalyticsAuditor auditor, Consumer<Exception> failureHandler, ExtractedFields extractedFields) {
        this.provider = provider;
        this.currentModelId = new AtomicReference<String>("");
        this.analytics = analytics;
        this.auditor = auditor;
        this.failureHandler = failureHandler;
        this.extractedFields = extractedFields;
    }

    public void createAndIndexInferenceModelDoc(TrainedModelDefinitionChunk trainedModelDefinitionChunk) {
        if (Strings.isNullOrEmpty((String)this.currentModelId.get())) {
            this.failureHandler.accept((Exception)((Object)ExceptionsHelper.serverError((String)"chunked inference model definition is attempting to be stored before trained model configuration")));
            return;
        }
        TrainedModelDefinitionDoc trainedModelDefinitionDoc = trainedModelDefinitionChunk.createTrainedModelDoc(this.currentModelId.get());
        CountDownLatch latch = this.storeTrainedModelDoc(trainedModelDefinitionDoc);
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                LOGGER.error("[{}] Timed out (30s) waiting for chunked inference definition to be stored", (Object)this.analytics.getId());
                if (trainedModelDefinitionChunk.isEos()) {
                    this.readyToStoreNewModel.set(true);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.readyToStoreNewModel.set(true);
            this.failureHandler.accept((Exception)((Object)ExceptionsHelper.serverError((String)"interrupted waiting for chunked inference definition to be stored")));
        }
    }

    public String createAndIndexInferenceModelMetadata(ModelSizeInfo inferenceModelSize) {
        if (!this.readyToStoreNewModel.compareAndSet(true, false)) {
            this.failureHandler.accept((Exception)((Object)ExceptionsHelper.serverError((String)"new inference model is attempting to be stored before completion previous model storage")));
            return null;
        }
        TrainedModelConfig trainedModelConfig = this.createTrainedModelConfig(inferenceModelSize);
        CountDownLatch latch = this.storeTrainedModelMetadata(trainedModelConfig);
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                LOGGER.error("[{}] Timed out (30s) waiting for inference model metadata to be stored", (Object)this.analytics.getId());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.readyToStoreNewModel.set(true);
            this.failureHandler.accept((Exception)((Object)ExceptionsHelper.serverError((String)"interrupted waiting for inference model metadata to be stored")));
        }
        return trainedModelConfig.getModelId();
    }

    private CountDownLatch storeTrainedModelDoc(TrainedModelDefinitionDoc trainedModelDefinitionDoc) {
        CountDownLatch latch = new CountDownLatch(1);
        LatchedActionListener refreshListener = new LatchedActionListener(ActionListener.wrap(refreshed -> {
            if (refreshed != null) {
                LOGGER.debug(() -> new ParameterizedMessage("[{}] refreshed inference index after model store", (Object)this.analytics.getId()));
            }
        }, e -> LOGGER.warn((Message)new ParameterizedMessage("[{}] failed to refresh inference index after model store", (Object)this.analytics.getId()), (Throwable)e)), latch);
        ActionListener storeListener = ActionListener.wrap(arg_0 -> this.lambda$storeTrainedModelDoc$4(trainedModelDefinitionDoc, (ActionListener)refreshListener, arg_0), arg_0 -> this.lambda$storeTrainedModelDoc$5(trainedModelDefinitionDoc, (ActionListener)refreshListener, arg_0));
        this.provider.storeTrainedModelDefinitionDoc(trainedModelDefinitionDoc, (ActionListener<Void>)storeListener);
        return latch;
    }

    private CountDownLatch storeTrainedModelMetadata(TrainedModelConfig trainedModelConfig) {
        CountDownLatch latch = new CountDownLatch(1);
        ActionListener storeListener = ActionListener.wrap(aBoolean -> {
            if (!aBoolean.booleanValue()) {
                LOGGER.error("[{}] Storing trained model metadata responded false", (Object)this.analytics.getId());
                this.readyToStoreNewModel.set(true);
                this.failureHandler.accept((Exception)((Object)ExceptionsHelper.serverError((String)"storing trained model responded false")));
            } else {
                LOGGER.debug("[{}] Stored trained model metadata with id [{}]", (Object)this.analytics.getId(), (Object)trainedModelConfig.getModelId());
            }
        }, e -> {
            this.readyToStoreNewModel.set(true);
            this.failureHandler.accept((Exception)((Object)ExceptionsHelper.serverError((String)"error storing trained model metadata with id [{}]", (Throwable)e, (Object[])new Object[]{trainedModelConfig.getModelId()})));
        });
        this.provider.storeTrainedModelMetadata(trainedModelConfig, (ActionListener<Boolean>)new LatchedActionListener(storeListener, latch));
        return latch;
    }

    private TrainedModelConfig createTrainedModelConfig(ModelSizeInfo modelSize) {
        Instant createTime = Instant.now();
        String modelId = this.analytics.getId() + "-" + createTime.toEpochMilli();
        this.currentModelId.set(modelId);
        List<ExtractedField> fieldNames = this.extractedFields.getAllFields();
        String dependentVariable = this.getDependentVariable();
        List fieldNamesWithoutDependentVariable = fieldNames.stream().map(ExtractedField::getName).filter(f -> !f.equals(dependentVariable)).collect(Collectors.toList());
        Map<String, String> defaultFieldMapping = fieldNames.stream().filter(ef -> ef instanceof MultiField && !ef.getName().equals(dependentVariable)).collect(Collectors.toMap(ExtractedField::getParentField, ExtractedField::getName));
        return TrainedModelConfig.builder().setModelId(modelId).setCreatedBy("_xpack").setVersion(Version.CURRENT).setCreateTime(createTime).setTags(Collections.singletonList(this.analytics.getId())).setDescription(this.analytics.getDescription()).setMetadata(Collections.singletonMap("analytics_config", XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)this.analytics.toString(), (boolean)true))).setEstimatedHeapMemory(modelSize.ramBytesUsed()).setEstimatedOperations((long)modelSize.numOperations()).setInput(new TrainedModelInput(fieldNamesWithoutDependentVariable)).setLicenseLevel(License.OperationMode.PLATINUM.description()).setDefaultFieldMap(defaultFieldMapping).setInferenceConfig(this.analytics.getAnalysis().inferenceConfig((DataFrameAnalysis.FieldInfo)new AnalysisFieldInfo(this.extractedFields))).build();
    }

    private String getDependentVariable() {
        if (this.analytics.getAnalysis() instanceof Classification) {
            return ((Classification)this.analytics.getAnalysis()).getDependentVariable();
        }
        if (this.analytics.getAnalysis() instanceof Regression) {
            return ((Regression)this.analytics.getAnalysis()).getDependentVariable();
        }
        return null;
    }

    private /* synthetic */ void lambda$storeTrainedModelDoc$5(TrainedModelDefinitionDoc trainedModelDefinitionDoc, ActionListener refreshListener, Exception e) {
        this.readyToStoreNewModel.set(true);
        this.failureHandler.accept((Exception)((Object)ExceptionsHelper.serverError((String)"error storing trained model definition chunk [{}] with id [{}]", (Throwable)e, (Object[])new Object[]{trainedModelDefinitionDoc.getModelId(), trainedModelDefinitionDoc.getDocNum()})));
        refreshListener.onResponse(null);
    }

    private /* synthetic */ void lambda$storeTrainedModelDoc$4(TrainedModelDefinitionDoc trainedModelDefinitionDoc, ActionListener refreshListener, Void r) throws Exception {
        LOGGER.debug(() -> new ParameterizedMessage("[{}] stored trained model definition chunk [{}] [{}]", new Object[]{this.analytics.getId(), trainedModelDefinitionDoc.getModelId(), trainedModelDefinitionDoc.getDocNum()}));
        if (!trainedModelDefinitionDoc.isEos()) {
            refreshListener.onResponse(null);
            return;
        }
        LOGGER.info("[{}] finished storing trained model with id [{}]", (Object)this.analytics.getId(), (Object)this.currentModelId.get());
        this.auditor.info(this.analytics.getId(), "Stored trained model with id [" + this.currentModelId.get() + "]");
        this.currentModelId.set("");
        this.readyToStoreNewModel.set(true);
        this.provider.refreshInferenceIndex((ActionListener<RefreshResponse>)refreshListener);
    }
}

