/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsSource;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class MappingsMerger {
    private MappingsMerger() {
    }

    public static void mergeMappings(Client client, Map<String, String> headers, DataFrameAnalyticsSource source, ActionListener<ImmutableOpenMap<String, MappingMetadata>> listener) {
        ActionListener mappingsListener = ActionListener.wrap(getMappingsResponse -> listener.onResponse(MappingsMerger.mergeMappings(source, getMappingsResponse)), arg_0 -> listener.onFailure(arg_0));
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(source.getIndex());
        ClientHelper.executeWithHeadersAsync(headers, (String)"ml", (Client)client, (ActionType)GetMappingsAction.INSTANCE, (ActionRequest)getMappingsRequest, (ActionListener)mappingsListener);
    }

    static ImmutableOpenMap<String, MappingMetadata> mergeMappings(DataFrameAnalyticsSource source, GetMappingsResponse getMappingsResponse) {
        ImmutableOpenMap indexToMappings = getMappingsResponse.getMappings();
        String type = null;
        HashMap<String, IndexAndMapping> mergedMappings = new HashMap<String, IndexAndMapping>();
        for (ObjectObjectCursor indexMappings : indexToMappings) {
            for (ObjectObjectCursor typeMapping : (ImmutableOpenMap)indexMappings.value) {
                Map currentMappings;
                if (type == null) {
                    type = (String)typeMapping.key;
                } else if (!type.equals(typeMapping.key)) {
                    throw ExceptionsHelper.badRequestException((String)"source indices contain mappings for different types: [{}, {}]", (Object[])new Object[]{type, typeMapping.key});
                }
                if (!(currentMappings = ((MappingMetadata)typeMapping.value).getSourceAsMap()).containsKey("properties")) continue;
                Map fieldMappings = (Map)currentMappings.get("properties");
                for (Map.Entry fieldMapping : fieldMappings.entrySet()) {
                    String field = (String)fieldMapping.getKey();
                    if (source.isFieldExcluded(field)) continue;
                    if (mergedMappings.containsKey(field)) {
                        IndexAndMapping existingIndexAndMapping = (IndexAndMapping)mergedMappings.get(field);
                        if (existingIndexAndMapping.mapping.equals(fieldMapping.getValue())) continue;
                        throw ExceptionsHelper.badRequestException((String)"cannot merge mappings because of differences for field [{}]; mapped as [{}] in index [{}]; mapped as [{}] in index [{}]", (Object[])new Object[]{field, fieldMapping.getValue(), indexMappings.key, existingIndexAndMapping.mapping, existingIndexAndMapping.index});
                    }
                    mergedMappings.put(field, new IndexAndMapping((String)indexMappings.key, fieldMapping.getValue()));
                }
            }
        }
        MappingMetadata mappingMetadata = MappingsMerger.createMappingMetadata(type, mergedMappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexAndMapping)e.getValue()).mapping)));
        ImmutableOpenMap.Builder result = ImmutableOpenMap.builder();
        result.put(type, (Object)mappingMetadata);
        return result.build();
    }

    private static MappingMetadata createMappingMetadata(String type, Map<String, Object> mappings) {
        try {
            return new MappingMetadata(type, Collections.singletonMap("properties", mappings));
        }
        catch (IOException e) {
            throw ExceptionsHelper.serverError((String)("Failed to parse mappings: " + mappings));
        }
    }

    private static class IndexAndMapping {
        private final String index;
        private final Object mapping;

        private IndexAndMapping(String index, Object mapping) {
            this.index = Objects.requireNonNull(index);
            this.mapping = Objects.requireNonNull(mapping);
        }
    }
}

