/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsDest;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.MappingsMerger;

public final class DestinationIndex {
    public static final String ID_COPY = "ml__id_copy";
    public static final String IS_TRAINING = "is_training";
    static final String CREATION_DATE_MILLIS = "creation_date_in_millis";
    static final String VERSION = "version";
    static final String CREATED = "created";
    static final String CREATED_BY = "created_by";
    static final String ANALYTICS = "analytics";
    private static final String PROPERTIES = "properties";
    private static final String META = "_meta";
    private static final String[] PRESERVED_SETTINGS = new String[]{"index.number_of_shards", "index.number_of_replicas"};

    private DestinationIndex() {
    }

    public static void createDestinationIndex(Client client, Clock clock, DataFrameAnalyticsConfig analyticsConfig, ActionListener<CreateIndexResponse> listener) {
        ActionListener createIndexRequestListener = ActionListener.wrap(createIndexRequest -> ClientHelper.executeWithHeadersAsync((Map)analyticsConfig.getHeaders(), (String)"ml", (Client)client, (ActionType)CreateIndexAction.INSTANCE, (ActionRequest)createIndexRequest, (ActionListener)listener), arg_0 -> listener.onFailure(arg_0));
        DestinationIndex.prepareCreateIndexRequest(client, clock, analyticsConfig, (ActionListener<CreateIndexRequest>)createIndexRequestListener);
    }

    private static void prepareCreateIndexRequest(Client client, Clock clock, DataFrameAnalyticsConfig config, ActionListener<CreateIndexRequest> listener) {
        AtomicReference settingsHolder = new AtomicReference();
        ActionListener mappingsListener = ActionListener.wrap(mappings -> listener.onResponse((Object)DestinationIndex.createIndexRequest(clock, config, (Settings)settingsHolder.get(), (ImmutableOpenMap<String, MappingMetadata>)mappings)), arg_0 -> listener.onFailure(arg_0));
        ActionListener settingsListener = ActionListener.wrap(settings -> {
            settingsHolder.set(settings);
            MappingsMerger.mergeMappings(client, config.getHeaders(), config.getSource(), (ActionListener<ImmutableOpenMap<String, MappingMetadata>>)mappingsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getSettingsResponseListener = ActionListener.wrap(settingsResponse -> settingsListener.onResponse((Object)DestinationIndex.settings(settingsResponse)), arg_0 -> listener.onFailure(arg_0));
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(config.getSource().getIndex()).indicesOptions(IndicesOptions.lenientExpandOpen()).names(PRESERVED_SETTINGS);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, (ActionListener)getSettingsResponseListener);
    }

    private static CreateIndexRequest createIndexRequest(Clock clock, DataFrameAnalyticsConfig config, Settings settings, ImmutableOpenMap<String, MappingMetadata> mappings) {
        assert (mappings.size() == 1);
        String destinationIndex = config.getDest().getIndex();
        String type = (String)mappings.keysIt().next();
        Map mappingsAsMap = ((MappingMetadata)mappings.valuesIt().next()).sourceAsMap();
        Map properties = DestinationIndex.getOrPutDefault(mappingsAsMap, PROPERTIES, HashMap::new);
        DestinationIndex.checkResultsFieldIsNotPresentInProperties(config, properties);
        properties.putAll(DestinationIndex.createAdditionalMappings(config, Collections.unmodifiableMap(properties)));
        Map metadata = DestinationIndex.getOrPutDefault(mappingsAsMap, META, HashMap::new);
        metadata.putAll(DestinationIndex.createMetadata(config.getId(), clock));
        return new CreateIndexRequest(destinationIndex, settings).mapping(type, mappingsAsMap);
    }

    private static Settings settings(GetSettingsResponse settingsResponse) {
        Integer maxNumberOfShards = DestinationIndex.findMaxSettingValue(settingsResponse, "index.number_of_shards");
        Integer maxNumberOfReplicas = DestinationIndex.findMaxSettingValue(settingsResponse, "index.number_of_replicas");
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put(IndexSortConfig.INDEX_SORT_FIELD_SETTING.getKey(), ID_COPY);
        settingsBuilder.put(IndexSortConfig.INDEX_SORT_ORDER_SETTING.getKey(), (Enum)SortOrder.ASC);
        if (maxNumberOfShards != null) {
            settingsBuilder.put("index.number_of_shards", maxNumberOfShards.intValue());
        }
        if (maxNumberOfReplicas != null) {
            settingsBuilder.put("index.number_of_replicas", maxNumberOfReplicas.intValue());
        }
        return settingsBuilder.build();
    }

    @Nullable
    private static Integer findMaxSettingValue(GetSettingsResponse settingsResponse, String settingKey) {
        Integer maxValue = null;
        Iterator settingsIterator = settingsResponse.getIndexToSettings().valuesIt();
        while (settingsIterator.hasNext()) {
            Settings settings = (Settings)settingsIterator.next();
            Integer indexValue = settings.getAsInt(settingKey, null);
            if (indexValue == null) continue;
            maxValue = maxValue == null ? indexValue : Math.max(indexValue, maxValue);
        }
        return maxValue;
    }

    private static Map<String, Object> createAdditionalMappings(DataFrameAnalyticsConfig config, Map<String, Object> mappingsProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, String> idCopyMapping = new HashMap<String, String>();
        idCopyMapping.put("type", "keyword");
        properties.put(ID_COPY, idCopyMapping);
        properties.putAll(config.getAnalysis().getExplicitlyMappedFields(mappingsProperties, config.getDest().getResultsField()));
        return properties;
    }

    private static Map<String, Object> createMetadata(String analyticsId, Clock clock) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(CREATION_DATE_MILLIS, clock.millis());
        metadata.put(CREATED_BY, "data-frame-analytics");
        HashMap<String, Version> versionMapping = new HashMap<String, Version>();
        versionMapping.put(CREATED, Version.CURRENT);
        metadata.put(VERSION, versionMapping);
        metadata.put(ANALYTICS, analyticsId);
        return metadata;
    }

    private static <K, V> V getOrPutDefault(Map<K, Object> map, K key, Supplier<V> valueSupplier) {
        Object value = map.get(key);
        if (value == null) {
            value = valueSupplier.get();
            map.put(key, value);
        }
        return (V)value;
    }

    public static void updateMappingsToDestIndex(Client client, DataFrameAnalyticsConfig config, GetIndexResponse getIndexResponse, ActionListener<AcknowledgedResponse> listener) {
        assert (getIndexResponse.indices().length == 1);
        ImmutableOpenMap mappings = (ImmutableOpenMap)getIndexResponse.getMappings().get((Object)getIndexResponse.indices()[0]);
        String type = (String)mappings.keysIt().next();
        Map destMappingsAsMap = ((MappingMetadata)mappings.valuesIt().next()).sourceAsMap();
        Map<String, Object> destPropertiesAsMap = destMappingsAsMap.getOrDefault(PROPERTIES, Collections.emptyMap());
        DestinationIndex.checkResultsFieldIsNotPresentInProperties(config, destPropertiesAsMap);
        Map<String, Map<String, Object>> addedMappings = Collections.singletonMap(PROPERTIES, DestinationIndex.createAdditionalMappings(config, Collections.unmodifiableMap(destPropertiesAsMap)));
        PutMappingRequest putMappingRequest = new PutMappingRequest(getIndexResponse.indices()).type(type).source(addedMappings);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)PutMappingAction.INSTANCE, (ActionRequest)putMappingRequest, listener);
    }

    private static void checkResultsFieldIsNotPresentInProperties(DataFrameAnalyticsConfig config, Map<String, Object> properties) {
        String resultsField = config.getDest().getResultsField();
        if (properties.containsKey(resultsField)) {
            throw ExceptionsHelper.badRequestException((String)"A field that matches the {}.{} [{}] already exists; please set a different {}", (Object[])new Object[]{DataFrameAnalyticsConfig.DEST.getPreferredName(), DataFrameAnalyticsDest.RESULTS_FIELD.getPreferredName(), resultsField, DataFrameAnalyticsDest.RESULTS_FIELD.getPreferredName()});
        }
    }
}

