/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.tasks.TaskResult;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.StoredProgress;
import org.elasticsearch.xpack.ml.dataframe.stats.StatsHolder;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class DataFrameAnalyticsTask
extends AllocatedPersistentTask
implements StartDataFrameAnalyticsAction.TaskMatcher {
    private static final Logger LOGGER = LogManager.getLogger(DataFrameAnalyticsTask.class);
    private final Client client;
    private final ClusterService clusterService;
    private final DataFrameAnalyticsManager analyticsManager;
    private final DataFrameAnalyticsAuditor auditor;
    private final StartDataFrameAnalyticsAction.TaskParams taskParams;
    @Nullable
    private volatile Long reindexingTaskId;
    private volatile boolean isReindexingFinished;
    private volatile boolean isStopping;
    private volatile boolean isMarkAsCompletedCalled;
    private final StatsHolder statsHolder;

    public DataFrameAnalyticsTask(long id, String type, String action, TaskId parentTask, Map<String, String> headers, Client client, ClusterService clusterService, DataFrameAnalyticsManager analyticsManager, DataFrameAnalyticsAuditor auditor, StartDataFrameAnalyticsAction.TaskParams taskParams) {
        super(id, type, action, "data_frame_analytics-" + taskParams.getId(), parentTask, headers);
        this.client = new ParentTaskAssigningClient(Objects.requireNonNull(client), parentTask);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.analyticsManager = Objects.requireNonNull(analyticsManager);
        this.auditor = Objects.requireNonNull(auditor);
        this.taskParams = Objects.requireNonNull(taskParams);
        this.statsHolder = new StatsHolder(taskParams.getProgressOnStart());
    }

    protected void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        super.init(persistentTasksService, taskManager, persistentTaskId, allocationId);
    }

    public StartDataFrameAnalyticsAction.TaskParams getParams() {
        return this.taskParams;
    }

    public void setReindexingTaskId(Long reindexingTaskId) {
        LOGGER.debug("[{}] Setting reindexing task id to [{}] from [{}]", (Object)this.taskParams.getId(), (Object)reindexingTaskId, (Object)this.reindexingTaskId);
        this.reindexingTaskId = reindexingTaskId;
    }

    public void setReindexingFinished() {
        this.isReindexingFinished = true;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public StatsHolder getStatsHolder() {
        return this.statsHolder;
    }

    protected void onCancelled() {
        this.stop(this.getReasonCancelled(), StopDataFrameAnalyticsAction.DEFAULT_TIMEOUT);
        this.markAsCompleted();
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsCompleted() {
        DataFrameAnalyticsTask dataFrameAnalyticsTask = this;
        synchronized (dataFrameAnalyticsTask) {
            if (this.isMarkAsCompletedCalled) {
                return;
            }
            this.isMarkAsCompletedCalled = true;
        }
        this.persistProgress(this.client, this.taskParams.getId(), () -> super.markAsCompleted());
    }

    public void markAsFailed(Exception e) {
        this.persistProgress(this.client, this.taskParams.getId(), () -> super.markAsFailed(e));
    }

    public void stop(String reason, TimeValue timeout) {
        this.isStopping = true;
        ActionListener reindexProgressListener = ActionListener.wrap(aVoid -> this.doStop(reason, timeout), e -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] Error updating reindexing progress", (Object)this.taskParams.getId()), (Throwable)e);
            this.doStop(reason, timeout);
        });
        this.updateReindexTaskProgress((ActionListener<Void>)reindexProgressListener);
    }

    private void doStop(String reason, TimeValue timeout) {
        if (this.reindexingTaskId != null) {
            this.cancelReindexingTask(reason, timeout);
        }
        this.analyticsManager.stop(this);
    }

    private void cancelReindexingTask(String reason, TimeValue timeout) {
        TaskId reindexTaskId = new TaskId(this.clusterService.localNode().getId(), this.reindexingTaskId.longValue());
        LOGGER.debug("[{}] Cancelling reindex task [{}]", (Object)this.taskParams.getId(), (Object)reindexTaskId);
        CancelTasksRequest cancelReindex = new CancelTasksRequest();
        cancelReindex.setTaskId(reindexTaskId);
        cancelReindex.setReason(reason);
        cancelReindex.setTimeout(timeout);
        CancelTasksResponse cancelReindexResponse = this.cancelTaskWithinMlOriginContext(cancelReindex);
        Throwable firstError = null;
        if (!cancelReindexResponse.getNodeFailures().isEmpty()) {
            firstError = ((ElasticsearchException)((Object)cancelReindexResponse.getNodeFailures().get(0))).getRootCause();
        }
        if (!cancelReindexResponse.getTaskFailures().isEmpty()) {
            firstError = ((TaskOperationFailure)cancelReindexResponse.getTaskFailures().get(0)).getCause();
        }
        if (firstError != null && !(ExceptionsHelper.unwrapCause((Throwable)firstError) instanceof ResourceNotFoundException)) {
            throw ExceptionsHelper.serverError((String)("[" + this.taskParams.getId() + "] Error cancelling reindex task"), (Throwable)firstError);
        }
        LOGGER.debug("[{}] Reindex task was successfully cancelled", (Object)this.taskParams.getId());
    }

    private CancelTasksResponse cancelTaskWithinMlOriginContext(CancelTasksRequest cancelTasksRequest) {
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin("ml");){
            CancelTasksResponse cancelTasksResponse = (CancelTasksResponse)this.client.admin().cluster().cancelTasks(cancelTasksRequest).actionGet();
            return cancelTasksResponse;
        }
    }

    public void setFailed(Exception error) {
        this.persistProgress(this.client, this.taskParams.getId(), () -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] Setting task to failed", (Object)this.taskParams.getId()), (Throwable)error);
            String reason = ExceptionsHelper.unwrapCause((Throwable)error).getMessage();
            DataFrameAnalyticsTaskState newTaskState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.FAILED, this.getAllocationId(), reason);
            this.updatePersistentTaskState((PersistentTaskState)newTaskState, ActionListener.wrap(updatedTask -> {
                String message = Messages.getMessage((String)"Updated analytics task state to [{0}] with reason [{1}]", (Object[])new Object[]{DataFrameAnalyticsState.FAILED, reason});
                this.auditor.info(this.getParams().getId(), message);
                LOGGER.info("[{}] {}", (Object)this.getParams().getId(), (Object)message);
            }, e -> LOGGER.error((Message)new ParameterizedMessage("[{}] Could not update task state to [{}] with reason [{}]", new Object[]{this.getParams().getId(), DataFrameAnalyticsState.FAILED, reason}), (Throwable)e)));
        });
    }

    public void updateReindexTaskProgress(ActionListener<Void> listener) {
        this.getReindexTaskProgress((ActionListener<Integer>)ActionListener.wrap(reindexTaskProgress -> {
            this.statsHolder.getProgressTracker().updateReindexingProgress(Math.max(1, reindexTaskProgress));
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getReindexTaskProgress(ActionListener<Integer> listener) {
        TaskId reindexTaskId = this.getReindexTaskId();
        if (reindexTaskId == null) {
            listener.onResponse((Object)(this.isReindexingFinished ? 100 : 0));
            return;
        }
        GetTaskRequest getTaskRequest = new GetTaskRequest();
        getTaskRequest.setTaskId(reindexTaskId);
        this.client.admin().cluster().getTask(getTaskRequest, ActionListener.wrap(taskResponse -> {
            TaskResult taskResult = taskResponse.getTask();
            BulkByScrollTask.Status taskStatus = (BulkByScrollTask.Status)taskResult.getTask().getStatus();
            int progress = (int)((double)taskStatus.getCreated() * 100.0 / (double)taskStatus.getTotal());
            listener.onResponse((Object)progress);
        }, error -> {
            if (ExceptionsHelper.unwrapCause((Throwable)error) instanceof ResourceNotFoundException) {
                listener.onResponse((Object)(this.isReindexingFinished ? 100 : 0));
            } else {
                listener.onFailure(error);
            }
        }));
    }

    @Nullable
    private TaskId getReindexTaskId() {
        try {
            return new TaskId(this.clusterService.localNode().getId(), this.reindexingTaskId.longValue());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    void persistProgress(Client client, String jobId, Runnable runnable) {
        LOGGER.debug("[{}] Persisting progress", (Object)jobId);
        String progressDocId = StoredProgress.documentId(jobId);
        ActionListener indexProgressDocListener = ActionListener.wrap(indexResponse -> {
            LOGGER.debug("[{}] Successfully indexed progress document", (Object)jobId);
            runnable.run();
        }, indexError -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while indexing", (Object)jobId), (Throwable)indexError);
            runnable.run();
        });
        ActionListener searchFormerProgressDocListener = ActionListener.wrap(searchResponse -> {
            String indexOrAlias = AnomalyDetectorsIndex.jobStateIndexWriteAlias();
            if (searchResponse.getHits().getHits().length > 0) {
                indexOrAlias = searchResponse.getHits().getHits()[0].getIndex();
            }
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(indexOrAlias).id(progressDocId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            List<PhaseProgress> progress = this.statsHolder.getProgressTracker().report();
            try (XContentBuilder jsonBuilder = JsonXContent.contentBuilder();){
                LOGGER.debug("[{}] Persisting progress is: {}", (Object)jobId, progress);
                new StoredProgress(progress).toXContent(jsonBuilder, Payload.XContent.EMPTY_PARAMS);
                indexRequest.source(jsonBuilder);
            }
            ClientHelper.executeAsyncWithOrigin((Client)client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)indexProgressDocListener);
        }, e -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while retrieving former progress document", (Object)jobId), (Throwable)e);
            runnable.run();
        });
        ActionListener reindexProgressUpdateListener = ActionListener.wrap(aVoid -> {
            SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).source(new SearchSourceBuilder().size(1).query((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{progressDocId})));
            ClientHelper.executeAsyncWithOrigin((Client)client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)searchFormerProgressDocListener);
        }, e -> {
            LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while updating reindexing task progress", (Object)this.taskParams.getId()), (Throwable)e);
            runnable.run();
        });
        this.updateReindexTaskProgress((ActionListener<Void>)reindexProgressUpdateListener);
    }

    public static StartingState determineStartingState(String jobId, List<PhaseProgress> progressOnStart) {
        PhaseProgress lastIncompletePhase = null;
        for (PhaseProgress phaseProgress : progressOnStart) {
            if (phaseProgress.getProgressPercent() >= 100) continue;
            lastIncompletePhase = phaseProgress;
            break;
        }
        if (lastIncompletePhase == null) {
            return StartingState.FINISHED;
        }
        LOGGER.debug("[{}] Last incomplete progress [{}, {}]", (Object)jobId, (Object)lastIncompletePhase.getPhase(), (Object)lastIncompletePhase.getProgressPercent());
        if ("reindexing".equals(lastIncompletePhase.getPhase())) {
            return lastIncompletePhase.getProgressPercent() == 0 ? StartingState.FIRST_TIME : StartingState.RESUMING_REINDEXING;
        }
        return StartingState.RESUMING_ANALYZING;
    }

    public static enum StartingState {
        FIRST_TIME,
        RESUMING_REINDEXING,
        RESUMING_ANALYZING,
        FINISHED;

    }
}

