/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DatafeedNodeSelector {
    private static final Logger LOGGER = LogManager.getLogger(DatafeedNodeSelector.class);
    public static final PersistentTasksCustomMetadata.Assignment AWAITING_JOB_ASSIGNMENT = new PersistentTasksCustomMetadata.Assignment(null, "datafeed awaiting job assignment.");
    private final String datafeedId;
    private final String jobId;
    private final List<String> datafeedIndices;
    private final PersistentTasksCustomMetadata.PersistentTask<?> jobTask;
    private final ClusterState clusterState;
    private final IndexNameExpressionResolver resolver;
    private final IndicesOptions indicesOptions;

    public DatafeedNodeSelector(ClusterState clusterState, IndexNameExpressionResolver resolver, String datafeedId, String jobId, List<String> datafeedIndices, IndicesOptions indicesOptions) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        this.datafeedId = datafeedId;
        this.jobId = jobId;
        this.datafeedIndices = datafeedIndices;
        this.jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        this.clusterState = Objects.requireNonNull(clusterState);
        this.resolver = Objects.requireNonNull(resolver);
        this.indicesOptions = Objects.requireNonNull(indicesOptions);
    }

    public void checkDatafeedTaskCanBeCreated() {
        if (MlMetadata.getMlMetadata((ClusterState)this.clusterState).isUpgradeMode()) {
            String msg = "Unable to start datafeed [" + this.datafeedId + "] explanation [" + MlTasks.AWAITING_UPGRADE.getExplanation() + "]";
            LOGGER.debug(msg);
            IllegalStateException detail = new IllegalStateException(msg);
            throw new ElasticsearchStatusException("Could not start datafeed [" + this.datafeedId + "] as indices are being upgraded", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
        }
        AssignmentFailure assignmentFailure = this.checkAssignment();
        if (assignmentFailure != null && assignmentFailure.isCriticalForTaskCreation) {
            String msg = "No node found to start datafeed [" + this.datafeedId + "], allocation explanation [" + assignmentFailure.reason + "]";
            LOGGER.debug(msg);
            throw ExceptionsHelper.conflictStatusException((String)msg, (Object[])new Object[0]);
        }
    }

    public PersistentTasksCustomMetadata.Assignment selectNode() {
        if (MlMetadata.getMlMetadata((ClusterState)this.clusterState).isUpgradeMode()) {
            return MlTasks.AWAITING_UPGRADE;
        }
        AssignmentFailure assignmentFailure = this.checkAssignment();
        if (assignmentFailure == null) {
            String jobNode = this.jobTask.getExecutorNode();
            if (jobNode == null) {
                return AWAITING_JOB_ASSIGNMENT;
            }
            return new PersistentTasksCustomMetadata.Assignment(jobNode, "");
        }
        LOGGER.debug(assignmentFailure.reason);
        assert (!assignmentFailure.reason.isEmpty());
        return new PersistentTasksCustomMetadata.Assignment(null, assignmentFailure.reason);
    }

    @Nullable
    private AssignmentFailure checkAssignment() {
        String reason;
        PriorityFailureCollector priorityFailureCollector = new PriorityFailureCollector();
        priorityFailureCollector.add(this.verifyIndicesActive());
        JobTaskState jobTaskState = null;
        JobState jobState = JobState.CLOSED;
        if (this.jobTask != null) {
            jobTaskState = (JobTaskState)this.jobTask.getState();
            JobState jobState2 = jobState = jobTaskState == null ? JobState.OPENING : jobTaskState.getState();
        }
        if (!jobState.isAnyOf(new JobState[]{JobState.OPENING, JobState.OPENED})) {
            reason = "cannot start datafeed [" + this.datafeedId + "], because the job's [" + this.jobId + "] state is [" + jobState + "] while state [" + JobState.OPENED + "] is required";
            priorityFailureCollector.add(new AssignmentFailure(reason, true));
        }
        if (jobTaskState != null && jobTaskState.isStatusStale(this.jobTask)) {
            reason = "cannot start datafeed [" + this.datafeedId + "], because the job's [" + this.jobId + "] state is stale";
            priorityFailureCollector.add(new AssignmentFailure(reason, true));
        }
        return priorityFailureCollector.get();
    }

    @Nullable
    private AssignmentFailure verifyIndicesActive() {
        for (String index : this.datafeedIndices) {
            String[] concreteIndices;
            if (RemoteClusterLicenseChecker.isRemoteIndex((String)index)) continue;
            try {
                concreteIndices = this.resolver.concreteIndexNames(this.clusterState, this.indicesOptions, true, new String[]{index});
                if (concreteIndices.length == 0) {
                    return new AssignmentFailure("cannot start datafeed [" + this.datafeedId + "] because index [" + index + "] does not exist, is closed, or is still initializing.", true);
                }
            }
            catch (Exception e) {
                String msg = new ParameterizedMessage("failed resolving indices given [{}] and indices_options [{}]", (Object)index, (Object)this.indicesOptions).getFormattedMessage();
                LOGGER.debug("[" + this.datafeedId + "] " + msg, (Throwable)e);
                return new AssignmentFailure("cannot start datafeed [" + this.datafeedId + "] because it " + msg + " with exception [" + e.getMessage() + "]", true);
            }
            for (String concreteIndex : concreteIndices) {
                IndexRoutingTable routingTable = this.clusterState.getRoutingTable().index(concreteIndex);
                if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
                return new AssignmentFailure("cannot start datafeed [" + this.datafeedId + "] because index [" + concreteIndex + "] does not have all primary shards active yet.", false);
            }
        }
        return null;
    }

    private static class AssignmentFailure {
        private final String reason;
        private final boolean isCriticalForTaskCreation;

        private AssignmentFailure(String reason, boolean isCriticalForTaskCreation) {
            this.reason = reason;
            this.isCriticalForTaskCreation = isCriticalForTaskCreation;
        }
    }

    private static class PriorityFailureCollector {
        private AssignmentFailure failure;

        private PriorityFailureCollector() {
        }

        private void add(@Nullable AssignmentFailure newFailure) {
            if (newFailure == null) {
                return;
            }
            if (this.failure == null || !this.failure.isCriticalForTaskCreation && newFailure.isCriticalForTaskCreation) {
                this.failure = newFailure;
            }
        }

        @Nullable
        private AssignmentFailure get() {
            return this.failure;
        }
    }
}

