/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.ExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.MappingsMerger;
import org.elasticsearch.xpack.ml.dataframe.SourceDestValidations;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetectorFactory;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportStartDataFrameAnalyticsAction
extends TransportMasterNodeAction<StartDataFrameAnalyticsAction.Request, NodeAcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportStartDataFrameAnalyticsAction.class);
    private static final String PRIMARY_SHARDS_INACTIVE = "not all primary shards are active";
    private final XPackLicenseState licenseState;
    private final Client client;
    private final PersistentTasksService persistentTasksService;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final MlMemoryTracker memoryTracker;
    private final DataFrameAnalyticsAuditor auditor;
    private final SourceDestValidator sourceDestValidator;

    @Inject
    public TransportStartDataFrameAnalyticsAction(TransportService transportService, Client client, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, DataFrameAnalyticsConfigProvider configProvider, MlMemoryTracker memoryTracker, DataFrameAnalyticsAuditor auditor) {
        super("cluster:admin/xpack/ml/data_frame/analytics/start", transportService, clusterService, threadPool, actionFilters, StartDataFrameAnalyticsAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.configProvider = configProvider;
        this.memoryTracker = memoryTracker;
        this.auditor = Objects.requireNonNull(auditor);
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), null, clusterService.getNodeName(), License.OperationMode.PLATINUM.description());
    }

    protected String executor() {
        return "same";
    }

    protected NodeAcknowledgedResponse read(StreamInput in) throws IOException {
        return new NodeAcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(StartDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(final StartDataFrameAnalyticsAction.Request request, ClusterState state, final ActionListener<NodeAcknowledgedResponse> listener) {
        if (!this.licenseState.checkFeature(XPackLicenseState.Feature.MACHINE_LEARNING)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        ActionListener<PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>> waitForAnalyticsToStart = new ActionListener<PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> task) {
                TransportStartDataFrameAnalyticsAction.this.waitForAnalyticsStarted((PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>)task, request.getTimeout(), (ActionListener<NodeAcknowledgedResponse>)listener);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                    e = new ElasticsearchStatusException("Cannot start data frame analytics [" + request.getId() + "] because it has already been started", RestStatus.CONFLICT, (Throwable)e, new Object[0]);
                }
                listener.onFailure(e);
            }
        };
        ActionListener memoryUsageHandledListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(request, (ActionListener)waitForAnalyticsToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
        ActionListener startContextListener = ActionListener.wrap(startContext -> this.estimateMemoryUsageAndUpdateMemoryTracker((StartContext)startContext, (ActionListener<StartContext>)memoryUsageHandledListener), arg_0 -> listener.onFailure(arg_0));
        this.getStartContext(request.getId(), (ActionListener<StartContext>)startContextListener);
    }

    private void estimateMemoryUsageAndUpdateMemoryTracker(StartContext startContext, ActionListener<StartContext> listener) {
        String jobId = startContext.config.getId();
        ActionListener explainListener = ActionListener.wrap(explainResponse -> {
            ByteSizeValue expectedMemoryWithoutDisk = explainResponse.getMemoryEstimation().getExpectedMemoryWithoutDisk();
            this.auditor.info(jobId, Messages.getMessage((String)"Estimated memory usage for this analytics to be [{0}]", (Object[])new Object[]{expectedMemoryWithoutDisk}));
            if (startContext.config.getModelMemoryLimit().compareTo(expectedMemoryWithoutDisk) < 0) {
                ElasticsearchStatusException e = ExceptionsHelper.badRequestException((String)"Cannot start because the configured model memory limit [{}] is lower than the expected memory usage [{}]", (Object[])new Object[]{startContext.config.getModelMemoryLimit(), expectedMemoryWithoutDisk});
                listener.onFailure((Exception)e);
                return;
            }
            this.memoryTracker.addDataFrameAnalyticsJobMemoryAndRefreshAllOthers(jobId, startContext.config.getModelMemoryLimit().getBytes(), (ActionListener<Void>)ActionListener.wrap(aVoid -> listener.onResponse((Object)startContext), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        PutDataFrameAnalyticsAction.Request explainRequest = new PutDataFrameAnalyticsAction.Request(startContext.config);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, (ActionRequest)explainRequest, (ActionListener)explainListener);
    }

    private void getStartContext(String id, ActionListener<StartContext> finalListener) {
        ActionListener validateMappingsMergeListener = ActionListener.wrap(startContext -> this.validateSourceIndexHasAnalyzableData((StartContext)startContext, finalListener), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener toValidateMappingsListener = ActionListener.wrap(startContext -> MappingsMerger.mergeMappings(this.client, ((StartContext)startContext).config.getHeaders(), ((StartContext)startContext).config.getSource(), (ActionListener<ImmutableOpenMap<String, MappingMetadata>>)ActionListener.wrap(mappings -> validateMappingsMergeListener.onResponse(startContext), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener toValidateDestEmptyListener = ActionListener.wrap(startContext -> {
            switch (((StartContext)startContext).startingState) {
                case FIRST_TIME: {
                    this.checkDestIndexIsEmptyIfExists(this.client, (StartContext)startContext, (ActionListener<StartContext>)toValidateMappingsListener);
                    break;
                }
                case RESUMING_REINDEXING: 
                case RESUMING_ANALYZING: {
                    toValidateMappingsListener.onResponse(startContext);
                    break;
                }
                case FINISHED: {
                    logger.info("[{}] Job has already finished", (Object)((StartContext)startContext).config.getId());
                    finalListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Cannot start because the job has already finished", (Object[])new Object[0]));
                    break;
                }
                default: {
                    finalListener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)("Unexpected starting state " + (Object)((Object)((StartContext)startContext).startingState)))));
                }
            }
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener toValidateExtractionPossibleListener = ActionListener.wrap(startContext -> new ExtractedFieldsDetectorFactory(this.client).createFromSource(((StartContext)startContext).config, (ActionListener<ExtractedFieldsDetector>)ActionListener.wrap(extractedFieldsDetector -> {
            ((StartContext)startContext).extractedFields = (ExtractedFields)extractedFieldsDetector.detect().v1();
            toValidateDestEmptyListener.onResponse(startContext);
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener startContextListener = ActionListener.wrap(startContext -> {
            ((StartContext)startContext).config.getSource().getParsedQuery();
            this.sourceDestValidator.validate(this.clusterService.state(), ((StartContext)startContext).config.getSource().getIndex(), ((StartContext)startContext).config.getDest().getIndex(), SourceDestValidations.ALL_VALIDATIONS, ActionListener.wrap(aBoolean -> toValidateExtractionPossibleListener.onResponse(startContext), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener getConfigListener = ActionListener.wrap(config -> this.getProgress((DataFrameAnalyticsConfig)config, (ActionListener<List<PhaseProgress>>)ActionListener.wrap(progress -> startContextListener.onResponse((Object)new StartContext((DataFrameAnalyticsConfig)config, (List)progress)), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        this.configProvider.get(id, (ActionListener<DataFrameAnalyticsConfig>)getConfigListener);
    }

    private void validateSourceIndexHasAnalyzableData(StartContext startContext, ActionListener<StartContext> listener) {
        ActionListener validateAtLeastOneAnalyzedFieldListener = ActionListener.wrap(aVoid -> this.validateSourceIndexHasRows(startContext, listener), arg_0 -> listener.onFailure(arg_0));
        this.validateSourceIndexHasAtLeastOneAnalyzedField(startContext, (ActionListener<Void>)validateAtLeastOneAnalyzedFieldListener);
    }

    private void validateSourceIndexHasAtLeastOneAnalyzedField(StartContext startContext, ActionListener<Void> listener) {
        Set requiredFields = startContext.config.getAnalysis().getRequiredFields().stream().map(RequiredField::getName).collect(Collectors.toSet());
        long nonRequiredFieldsCount = startContext.extractedFields.getAllFields().stream().filter(extractedField -> !requiredFields.contains(extractedField.getName())).count();
        if (nonRequiredFieldsCount == 0L) {
            StringBuilder msgBuilder = new StringBuilder("at least one field must be included in the analysis");
            if (!requiredFields.isEmpty()) {
                msgBuilder.append(" (excluding fields ").append(requiredFields).append(")");
            }
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)msgBuilder.toString(), (Object[])new Object[0]));
        } else {
            listener.onResponse(null);
        }
    }

    private void validateSourceIndexHasRows(StartContext startContext, ActionListener<StartContext> listener) {
        DataFrameDataExtractorFactory extractorFactory = DataFrameDataExtractorFactory.createForSourceIndices(this.client, "validate_source_index_has_rows-" + startContext.config.getId(), startContext.config, startContext.extractedFields);
        extractorFactory.newExtractor(false).collectDataSummaryAsync((ActionListener<DataFrameDataExtractor.DataSummary>)ActionListener.wrap(dataSummary -> {
            if (dataSummary.rows == 0L) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Unable to start {} as no documents in the source indices [{}] contained all the fields selected for analysis. If you are relying on automatic field selection then there are currently mapped fields that do not exist in any indexed documents, and you will have to switch to explicit field selection and include only fields that exist in indexed documents.", (Object[])new Object[]{startContext.config.getId(), Strings.arrayToCommaDelimitedString((Object[])startContext.config.getSource().getIndex())}));
            } else {
                listener.onResponse((Object)startContext);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getProgress(DataFrameAnalyticsConfig config, ActionListener<List<PhaseProgress>> listener) {
        GetDataFrameAnalyticsStatsAction.Request getStatsRequest = new GetDataFrameAnalyticsStatsAction.Request(config.getId());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)getStatsRequest, (ActionListener)ActionListener.wrap(statsResponse -> {
            List stats = statsResponse.getResponse().results();
            if (stats.isEmpty()) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingDataFrameAnalytics((String)config.getId())));
            } else {
                listener.onResponse((Object)((GetDataFrameAnalyticsStatsAction.Response.Stats)stats.get(0)).getProgress());
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkDestIndexIsEmptyIfExists(Client client, StartContext startContext, ActionListener<StartContext> listener) {
        String destIndex = startContext.config.getDest().getIndex();
        SearchRequest destEmptySearch = new SearchRequest(new String[]{destIndex});
        destEmptySearch.source().size(0);
        destEmptySearch.allowPartialSearchResults(false);
        ClientHelper.executeWithHeadersAsync((Map)startContext.config.getHeaders(), (String)"ml", (Client)client, (ActionType)SearchAction.INSTANCE, (ActionRequest)destEmptySearch, (ActionListener)ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getTotalHits().value > 0L) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"dest index [{}] must be empty", (Object[])new Object[]{destIndex}));
            } else {
                listener.onResponse((Object)startContext);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                listener.onResponse((Object)startContext);
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void waitForAnalyticsStarted(final PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> task, TimeValue timeout, final ActionListener<NodeAcknowledgedResponse> listener) {
        final AnalyticsPredicate predicate = new AnalyticsPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(task.getId(), (Predicate)predicate, timeout, (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<PersistentTaskParams>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<PersistentTaskParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartDataFrameAnalyticsAction.this.cancelAnalyticsStart((PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>)task, predicate.exception, (ActionListener<NodeAcknowledgedResponse>)listener);
                } else {
                    TransportStartDataFrameAnalyticsAction.this.auditor.info(((StartDataFrameAnalyticsAction.TaskParams)task.getParams()).getId(), "Started analytics");
                    listener.onResponse((Object)new NodeAcknowledgedResponse(true, predicate.node));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                logger.error(() -> new ParameterizedMessage("[{}] timed out when starting task after [{}]. Assignment explanation [{}]", new Object[]{((StartDataFrameAnalyticsAction.TaskParams)task.getParams()).getId(), timeout, predicate.assignmentExplanation}));
                if (predicate.assignmentExplanation != null) {
                    TransportStartDataFrameAnalyticsAction.this.cancelAnalyticsStart((PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>)task, (Exception)new ElasticsearchStatusException("Could not start data frame analytics task, timed out after [{}] waiting for task assignment. Assignment explanation [{}]", RestStatus.TOO_MANY_REQUESTS, new Object[]{timeout, predicate.assignmentExplanation}), (ActionListener<NodeAcknowledgedResponse>)listener);
                } else {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("Starting data frame analytics [{}] timed out after [{}]", new Object[]{((StartDataFrameAnalyticsAction.TaskParams)task.getParams()).getId(), timeout})));
                }
            }
        });
    }

    private void cancelAnalyticsStart(final PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> persistentTask, final Exception exception, final ActionListener<NodeAcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                logger.error("[" + ((StartDataFrameAnalyticsAction.TaskParams)persistentTask.getParams()).getId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(ClusterState clusterState, IndexNameExpressionResolver resolver, String ... indexNames) {
        String[] concreteIndices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), indexNames);
        ArrayList<String> unavailableIndices = new ArrayList<String>(concreteIndices.length);
        for (String index : concreteIndices) {
            IndexRoutingTable routingTable;
            if (!clusterState.metadata().hasIndex(index) || (routingTable = clusterState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    private /* synthetic */ void lambda$masterOperation$0(StartDataFrameAnalyticsAction.Request request, ActionListener waitForAnalyticsToStart, StartContext startContext) throws Exception {
        StartDataFrameAnalyticsAction.TaskParams taskParams = new StartDataFrameAnalyticsAction.TaskParams(request.getId(), startContext.config.getVersion(), startContext.progressOnStart, startContext.config.isAllowLazyStart());
        this.persistentTasksService.sendStartRequest(MlTasks.dataFrameAnalyticsTaskId((String)request.getId()), "xpack/ml/data_frame/analytics", (PersistentTaskParams)taskParams, waitForAnalyticsToStart);
    }

    private static class StartContext {
        private final DataFrameAnalyticsConfig config;
        private final List<PhaseProgress> progressOnStart;
        private final DataFrameAnalyticsTask.StartingState startingState;
        private volatile ExtractedFields extractedFields;

        private StartContext(DataFrameAnalyticsConfig config, List<PhaseProgress> progressOnStart) {
            this.config = config;
            this.progressOnStart = progressOnStart;
            this.startingState = DataFrameAnalyticsTask.determineStartingState(config.getId(), progressOnStart);
        }
    }

    private static class AnalyticsPredicate
    implements Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> {
        private volatile Exception exception;
        private volatile String node = "";
        private volatile String assignmentExplanation;

        private AnalyticsPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetadata.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                return true;
            }
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetadata.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.assignmentExplanation = assignment.getExplanation();
                if (this.assignmentExplanation.contains(TransportStartDataFrameAnalyticsAction.PRIMARY_SHARDS_INACTIVE)) {
                    return false;
                }
                this.exception = new ElasticsearchStatusException("Could not start data frame analytics task, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            DataFrameAnalyticsTaskState taskState = (DataFrameAnalyticsTaskState)persistentTask.getState();
            DataFrameAnalyticsState analyticsState = taskState == null ? DataFrameAnalyticsState.STOPPED : taskState.getState();
            switch (analyticsState) {
                case STARTED: 
                case REINDEXING: 
                case ANALYZING: {
                    this.node = persistentTask.getExecutorNode();
                    return true;
                }
                case STOPPING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)"the task has been stopped while waiting to be started", (Object[])new Object[0]);
                    return true;
                }
                case STARTING: 
                case STOPPED: {
                    return false;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)("Unexpected task state [" + analyticsState + "] while waiting to be started"));
            return true;
        }
    }

    public static class TaskExecutor
    extends PersistentTasksExecutor<StartDataFrameAnalyticsAction.TaskParams> {
        private final Client client;
        private final ClusterService clusterService;
        private final DataFrameAnalyticsManager manager;
        private final DataFrameAnalyticsAuditor auditor;
        private final MlMemoryTracker memoryTracker;
        private final IndexNameExpressionResolver resolver;
        private volatile int maxMachineMemoryPercent;
        private volatile int maxLazyMLNodes;
        private volatile int maxOpenJobs;
        private volatile ClusterState clusterState;

        public TaskExecutor(Settings settings, Client client, ClusterService clusterService, DataFrameAnalyticsManager manager, DataFrameAnalyticsAuditor auditor, MlMemoryTracker memoryTracker, IndexNameExpressionResolver resolver) {
            super("xpack/ml/data_frame/analytics", "ml_utility");
            this.client = Objects.requireNonNull(client);
            this.clusterService = Objects.requireNonNull(clusterService);
            this.manager = Objects.requireNonNull(manager);
            this.auditor = Objects.requireNonNull(auditor);
            this.memoryTracker = Objects.requireNonNull(memoryTracker);
            this.resolver = Objects.requireNonNull(resolver);
            this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
            this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
            this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
            clusterService.addListener(event -> {
                this.clusterState = event.state();
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> persistentTask, Map<String, String> headers) {
            return new DataFrameAnalyticsTask(id, type, action, parentTaskId, headers, this.client, this.clusterService, this.manager, this.auditor, (StartDataFrameAnalyticsAction.TaskParams)persistentTask.getParams());
        }

        public PersistentTasksCustomMetadata.Assignment getAssignment(StartDataFrameAnalyticsAction.TaskParams params, ClusterState clusterState) {
            boolean scheduledRefresh;
            if (MlMetadata.getMlMetadata((ClusterState)clusterState).isUpgradeMode()) {
                return MlTasks.AWAITING_UPGRADE;
            }
            String id = params.getId();
            List<String> unavailableIndices = TransportStartDataFrameAnalyticsAction.verifyIndicesPrimaryShardsAreActive(clusterState, this.resolver, MlConfigIndex.indexName(), MlStatsIndex.indexPattern(), AnomalyDetectorsIndex.jobStateIndexPattern());
            if (unavailableIndices.size() != 0) {
                String reason = "Not opening data frame analytics job [" + id + "], because " + TransportStartDataFrameAnalyticsAction.PRIMARY_SHARDS_INACTIVE + " for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
                logger.debug(reason);
                return new PersistentTasksCustomMetadata.Assignment(null, reason);
            }
            boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
            if (!isMemoryTrackerRecentlyRefreshed && (scheduledRefresh = this.memoryTracker.asyncRefresh())) {
                String reason = "Not opening data frame analytics job [" + id + "] because job memory requirements are stale - refresh requested";
                logger.debug(reason);
                return new PersistentTasksCustomMetadata.Assignment(null, reason);
            }
            JobNodeSelector jobNodeSelector = new JobNodeSelector(clusterState, id, "xpack/ml/data_frame/analytics", this.memoryTracker, params.isAllowLazyStart() ? Integer.MAX_VALUE : this.maxLazyMLNodes, node -> TaskExecutor.nodeFilter(node, id));
            return jobNodeSelector.selectNode(this.maxOpenJobs, Integer.MAX_VALUE, this.maxMachineMemoryPercent, isMemoryTrackerRecentlyRefreshed);
        }

        protected void nodeOperation(AllocatedPersistentTask task, StartDataFrameAnalyticsAction.TaskParams params, PersistentTaskState state) {
            DataFrameAnalyticsTaskState analyticsTaskState = (DataFrameAnalyticsTaskState)state;
            DataFrameAnalyticsState analyticsState = analyticsTaskState == null ? null : analyticsTaskState.getState();
            logger.info("[{}] Starting data frame analytics from state [{}]", (Object)params.getId(), (Object)analyticsState);
            if (DataFrameAnalyticsState.STOPPING.equals((Object)analyticsState)) {
                logger.info("[{}] data frame analytics got reassigned while stopping. Marking as completed", (Object)params.getId());
                task.markAsCompleted();
                return;
            }
            if (DataFrameAnalyticsState.FAILED.equals((Object)analyticsState)) {
                return;
            }
            if (analyticsTaskState == null) {
                DataFrameAnalyticsTaskState startedState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.STARTED, task.getAllocationId(), null);
                task.updatePersistentTaskState((PersistentTaskState)startedState, ActionListener.wrap(response -> this.manager.execute((DataFrameAnalyticsTask)task, DataFrameAnalyticsState.STARTED, this.clusterState), arg_0 -> ((AllocatedPersistentTask)task).markAsFailed(arg_0)));
            } else {
                this.manager.execute((DataFrameAnalyticsTask)task, analyticsTaskState.getState(), this.clusterState);
            }
        }

        public static String nodeFilter(DiscoveryNode node, String id) {
            if (node.getVersion().before(StartDataFrameAnalyticsAction.TaskParams.VERSION_INTRODUCED)) {
                return "Not opening job [" + id + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because the data frame analytics requires a node of version [" + StartDataFrameAnalyticsAction.TaskParams.VERSION_INTRODUCED + "] or higher";
            }
            return null;
        }

        void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
            this.maxMachineMemoryPercent = maxMachineMemoryPercent;
        }

        void setMaxLazyMLNodes(int maxLazyMLNodes) {
            this.maxLazyMLNodes = maxLazyMLNodes;
        }

        void setMaxOpenJobs(int maxOpenJobs) {
            this.maxOpenJobs = maxOpenJobs;
        }
    }
}

