/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetDatafeedsStatsAction
extends TransportMasterNodeReadAction<GetDatafeedsStatsAction.Request, GetDatafeedsStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDatafeedsStatsAction.class);
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobResultsProvider jobResultsProvider;

    @Inject
    public TransportGetDatafeedsStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DatafeedConfigProvider datafeedConfigProvider, JobResultsProvider jobResultsProvider) {
        super("cluster:monitor/xpack/ml/datafeeds/stats/get", transportService, clusterService, threadPool, actionFilters, GetDatafeedsStatsAction.Request::new, indexNameExpressionResolver);
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobResultsProvider = jobResultsProvider;
    }

    protected String executor() {
        return "same";
    }

    protected GetDatafeedsStatsAction.Response read(StreamInput in) throws IOException {
        return new GetDatafeedsStatsAction.Response(in);
    }

    protected void masterOperation(GetDatafeedsStatsAction.Request request, ClusterState state, ActionListener<GetDatafeedsStatsAction.Response> listener) throws Exception {
        logger.debug("Get stats for datafeed '{}'", (Object)request.getDatafeedId());
        PersistentTasksCustomMetadata tasksInProgress = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        ActionListener expandIdsListener = ActionListener.wrap(expandedIds -> this.datafeedConfigProvider.expandDatafeedConfigs(request.getDatafeedId(), true, (ActionListener<List<DatafeedConfig.Builder>>)ActionListener.wrap(datafeedBuilders -> {
            Map existingConfigs = datafeedBuilders.stream().map(DatafeedConfig.Builder::build).collect(Collectors.toMap(DatafeedConfig::getId, Function.identity()));
            List<String> jobIds = existingConfigs.values().stream().map(DatafeedConfig::getJobId).collect(Collectors.toList());
            this.jobResultsProvider.datafeedTimingStats(jobIds, (ActionListener<Map<String, DatafeedTimingStats>>)ActionListener.wrap(timingStatsByJobId -> {
                List results = expandedIds.stream().map(datafeedId -> {
                    DatafeedConfig config = (DatafeedConfig)existingConfigs.get(datafeedId);
                    String jobId = config == null ? null : config.getJobId();
                    DatafeedTimingStats timingStats = jobId == null ? null : (DatafeedTimingStats)timingStatsByJobId.get(jobId);
                    return TransportGetDatafeedsStatsAction.buildDatafeedStats(datafeedId, state, tasksInProgress, jobId, timingStats);
                }).collect(Collectors.toList());
                QueryPage statsPage = new QueryPage(results, (long)results.size(), DatafeedConfig.RESULTS_FIELD);
                listener.onResponse((Object)new GetDatafeedsStatsAction.Response(statsPage));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        this.datafeedConfigProvider.expandDatafeedIds(request.getDatafeedId(), request.allowNoDatafeeds(), tasksInProgress, true, (ActionListener<SortedSet<String>>)expandIdsListener);
    }

    private static GetDatafeedsStatsAction.Response.DatafeedStats buildDatafeedStats(String datafeedId, ClusterState state, PersistentTasksCustomMetadata tasks, String jobId, DatafeedTimingStats timingStats) {
        PersistentTasksCustomMetadata.PersistentTask task = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
        DatafeedState datafeedState = MlTasks.getDatafeedState((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
        DiscoveryNode node = null;
        String explanation = null;
        if (task != null) {
            node = state.nodes().get(task.getExecutorNode());
            explanation = task.getAssignment().getExplanation();
        }
        if (timingStats == null && jobId != null) {
            timingStats = new DatafeedTimingStats(jobId);
        }
        return new GetDatafeedsStatsAction.Response.DatafeedStats(datafeedId, datafeedState, node, explanation, timingStats);
    }

    protected ClusterBlockException checkBlock(GetDatafeedsStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

