/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;

public class TransportGetDatafeedsAction
extends TransportMasterNodeReadAction<GetDatafeedsAction.Request, GetDatafeedsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDatafeedsAction.class);
    private final DatafeedConfigProvider datafeedConfigProvider;

    @Inject
    public TransportGetDatafeedsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/xpack/ml/datafeeds/get", transportService, clusterService, threadPool, actionFilters, GetDatafeedsAction.Request::new, indexNameExpressionResolver);
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
    }

    protected String executor() {
        return "same";
    }

    protected GetDatafeedsAction.Response read(StreamInput in) throws IOException {
        return new GetDatafeedsAction.Response(in);
    }

    protected void masterOperation(GetDatafeedsAction.Request request, ClusterState state, ActionListener<GetDatafeedsAction.Response> listener) {
        logger.debug("Get datafeed '{}'", (Object)request.getDatafeedId());
        Map<String, DatafeedConfig> clusterStateConfigs = this.expandClusterStateDatafeeds(request.getDatafeedId(), request.allowNoDatafeeds(), state);
        this.datafeedConfigProvider.expandDatafeedConfigs(request.getDatafeedId(), request.allowNoDatafeeds(), (ActionListener<List<DatafeedConfig.Builder>>)ActionListener.wrap(datafeedBuilders -> {
            for (DatafeedConfig.Builder datafeed : datafeedBuilders) {
                if (!clusterStateConfigs.containsKey(datafeed.getId())) continue;
                listener.onFailure((Exception)new IllegalStateException("Datafeed [" + datafeed.getId() + "] configuration exists in both clusterstate and index"));
                return;
            }
            ArrayList<Object> datafeeds = new ArrayList<Object>(datafeedBuilders.size() + clusterStateConfigs.values().size());
            for (DatafeedConfig.Builder builder : datafeedBuilders) {
                datafeeds.add(builder.build());
            }
            datafeeds.addAll(clusterStateConfigs.values());
            Collections.sort(datafeeds, Comparator.comparing(DatafeedConfig::getId));
            listener.onResponse((Object)new GetDatafeedsAction.Response(new QueryPage(datafeeds, (long)datafeeds.size(), DatafeedConfig.RESULTS_FIELD)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    Map<String, DatafeedConfig> expandClusterStateDatafeeds(String datafeedExpression, boolean allowNoDatafeeds, ClusterState clusterState) {
        HashMap<String, DatafeedConfig> configById = new HashMap<String, DatafeedConfig>();
        try {
            MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
            Set expandedDatafeedIds = mlMetadata.expandDatafeedIds(datafeedExpression, allowNoDatafeeds);
            for (String expandedDatafeedId : expandedDatafeedIds) {
                configById.put(expandedDatafeedId, mlMetadata.getDatafeed(expandedDatafeedId));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configById;
    }

    protected ClusterBlockException checkBlock(GetDatafeedsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

