/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;
import org.elasticsearch.xpack.core.ml.dataframe.stats.classification.ClassificationStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.DataCounts;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.MemoryUsage;
import org.elasticsearch.xpack.core.ml.dataframe.stats.outlierdetection.OutlierDetectionStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.regression.RegressionStats;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.StoredProgress;
import org.elasticsearch.xpack.ml.dataframe.stats.ProgressTracker;
import org.elasticsearch.xpack.ml.utils.persistence.MlParserUtils;

public class TransportGetDataFrameAnalyticsStatsAction
extends TransportTasksAction<DataFrameAnalyticsTask, GetDataFrameAnalyticsStatsAction.Request, GetDataFrameAnalyticsStatsAction.Response, QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats>> {
    private static final Logger logger = LogManager.getLogger(TransportGetDataFrameAnalyticsStatsAction.class);
    private final Client client;

    @Inject
    public TransportGetDataFrameAnalyticsStatsAction(TransportService transportService, ClusterService clusterService, Client client, ActionFilters actionFilters) {
        super("cluster:monitor/xpack/ml/data_frame/analytics/stats/get", clusterService, transportService, actionFilters, GetDataFrameAnalyticsStatsAction.Request::new, GetDataFrameAnalyticsStatsAction.Response::new, in -> new QueryPage(in, GetDataFrameAnalyticsStatsAction.Response.Stats::new), "management");
        this.client = client;
    }

    protected GetDataFrameAnalyticsStatsAction.Response newResponse(GetDataFrameAnalyticsStatsAction.Request request, List<QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats>> tasks, List<TaskOperationFailure> taskFailures, List<FailedNodeException> nodeFailures) {
        ArrayList stats = new ArrayList();
        for (QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats> task : tasks) {
            stats.addAll(task.results());
        }
        Collections.sort(stats, Comparator.comparing(GetDataFrameAnalyticsStatsAction.Response.Stats::getId));
        return new GetDataFrameAnalyticsStatsAction.Response(taskFailures, nodeFailures, new QueryPage(stats, (long)stats.size(), GetDataFrameAnalyticsAction.Response.RESULTS_FIELD));
    }

    protected void taskOperation(GetDataFrameAnalyticsStatsAction.Request request, DataFrameAnalyticsTask task, ActionListener<QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats>> listener) {
        logger.debug("Get stats for running task [{}]", (Object)task.getParams().getId());
        ActionListener reindexingProgressListener = ActionListener.wrap(aVoid -> {
            GetDataFrameAnalyticsStatsAction.Response.Stats stats = this.buildStats(task.getParams().getId(), task.getStatsHolder().getProgressTracker().report(), task.getStatsHolder().getDataCountsTracker().report(task.getParams().getId()), task.getStatsHolder().getMemoryUsage(), task.getStatsHolder().getAnalysisStats());
            listener.onResponse((Object)new QueryPage(Collections.singletonList(stats), 1L, GetDataFrameAnalyticsAction.Response.RESULTS_FIELD));
        }, arg_0 -> listener.onFailure(arg_0));
        task.updateReindexTaskProgress((ActionListener<Void>)reindexingProgressListener);
    }

    protected void doExecute(Task task, GetDataFrameAnalyticsStatsAction.Request request, ActionListener<GetDataFrameAnalyticsStatsAction.Response> listener) {
        logger.debug("Get stats for data frame analytics [{}]", (Object)request.getId());
        ActionListener getResponseListener = ActionListener.wrap(getResponse -> {
            List expandedIds = getResponse.getResources().results().stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toList());
            request.setExpandedIds(expandedIds);
            ActionListener runningTasksStatsListener = ActionListener.wrap(runningTasksStatsResponse -> this.gatherStatsForStoppedTasks(getResponse.getResources().results(), (GetDataFrameAnalyticsStatsAction.Response)runningTasksStatsResponse, (ActionListener<GetDataFrameAnalyticsStatsAction.Response>)ActionListener.wrap(finalResponse -> {
                QueryPage finalStats = new QueryPage(finalResponse.getResponse().results(), getResponse.getResources().count(), GetDataFrameAnalyticsAction.Response.RESULTS_FIELD);
                listener.onResponse((Object)new GetDataFrameAnalyticsStatsAction.Response(finalStats));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            super.doExecute(task, (BaseTasksRequest)request, runningTasksStatsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        GetDataFrameAnalyticsAction.Request getRequest = new GetDataFrameAnalyticsAction.Request();
        getRequest.setResourceId(request.getId());
        getRequest.setAllowNoResources(request.isAllowNoMatch());
        getRequest.setPageParams(request.getPageParams());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)getResponseListener);
    }

    void gatherStatsForStoppedTasks(List<DataFrameAnalyticsConfig> configs, GetDataFrameAnalyticsStatsAction.Response runningTasksResponse, ActionListener<GetDataFrameAnalyticsStatsAction.Response> listener) {
        List<DataFrameAnalyticsConfig> stoppedConfigs = TransportGetDataFrameAnalyticsStatsAction.determineStoppedConfigs(configs, runningTasksResponse.getResponse().results());
        if (stoppedConfigs.isEmpty()) {
            listener.onResponse((Object)runningTasksResponse);
            return;
        }
        AtomicInteger counter = new AtomicInteger(stoppedConfigs.size());
        AtomicArray jobStats = new AtomicArray(stoppedConfigs.size());
        for (int i = 0; i < stoppedConfigs.size(); ++i) {
            int slot = i;
            DataFrameAnalyticsConfig config = stoppedConfigs.get(i);
            this.searchStats(config, (ActionListener<GetDataFrameAnalyticsStatsAction.Response.Stats>)ActionListener.wrap(stats -> {
                jobStats.set(slot, stats);
                if (counter.decrementAndGet() == 0) {
                    ArrayList allTasksStats = new ArrayList(runningTasksResponse.getResponse().results());
                    allTasksStats.addAll(jobStats.asList());
                    Collections.sort(allTasksStats, Comparator.comparing(GetDataFrameAnalyticsStatsAction.Response.Stats::getId));
                    listener.onResponse((Object)new GetDataFrameAnalyticsStatsAction.Response(new QueryPage(allTasksStats, (long)allTasksStats.size(), GetDataFrameAnalyticsAction.Response.RESULTS_FIELD)));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    static List<DataFrameAnalyticsConfig> determineStoppedConfigs(List<DataFrameAnalyticsConfig> configs, List<GetDataFrameAnalyticsStatsAction.Response.Stats> runningTasksStats) {
        Set startedTasksIds = runningTasksStats.stream().map(GetDataFrameAnalyticsStatsAction.Response.Stats::getId).collect(Collectors.toSet());
        return configs.stream().filter(config -> !startedTasksIds.contains(config.getId())).collect(Collectors.toList());
    }

    private void searchStats(DataFrameAnalyticsConfig config, ActionListener<GetDataFrameAnalyticsStatsAction.Response.Stats> listener) {
        logger.debug("[{}] Gathering stats for stopped task", (Object)config.getId());
        RetrievedStatsHolder retrievedStatsHolder = new RetrievedStatsHolder(ProgressTracker.fromZeroes(config.getAnalysis().getProgressPhases(), config.getAnalysis().supportsInference()).report());
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.add(TransportGetDataFrameAnalyticsStatsAction.buildStoredProgressSearch(config.getId()));
        multiSearchRequest.add(TransportGetDataFrameAnalyticsStatsAction.buildStatsDocSearch(config.getId(), "analytics_data_counts"));
        multiSearchRequest.add(TransportGetDataFrameAnalyticsStatsAction.buildStatsDocSearch(config.getId(), "analytics_memory_usage"));
        multiSearchRequest.add(TransportGetDataFrameAnalyticsStatsAction.buildStatsDocSearch(config.getId(), "outlier_detection_stats"));
        multiSearchRequest.add(TransportGetDataFrameAnalyticsStatsAction.buildStatsDocSearch(config.getId(), "classification_stats"));
        multiSearchRequest.add(TransportGetDataFrameAnalyticsStatsAction.buildStatsDocSearch(config.getId(), "regression_stats"));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)MultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, (ActionListener)ActionListener.wrap(multiSearchResponse -> {
            MultiSearchResponse.Item[] itemResponses = multiSearchResponse.getResponses();
            for (int i = 0; i < itemResponses.length; ++i) {
                MultiSearchResponse.Item itemResponse = itemResponses[i];
                if (itemResponse.isFailure()) {
                    SearchRequest itemRequest = (SearchRequest)multiSearchRequest.requests().get(i);
                    logger.error((Message)new ParameterizedMessage("[{}] Item failure encountered during multi search for request [indices={}, source={}]: {}", new Object[]{config.getId(), itemRequest.indices(), itemRequest.source(), itemResponse.getFailureMessage()}), (Throwable)itemResponse.getFailure());
                    listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)itemResponse.getFailureMessage(), (Throwable)itemResponse.getFailure())));
                    return;
                }
                SearchHit[] hits = itemResponse.getResponse().getHits().getHits();
                if (hits.length == 0) continue;
                if (hits.length == 1) {
                    TransportGetDataFrameAnalyticsStatsAction.parseHit(hits[0], config.getId(), retrievedStatsHolder);
                    continue;
                }
                throw ExceptionsHelper.serverError((String)("Found [" + hits.length + "] hits when just one was requested"));
            }
            listener.onResponse((Object)this.buildStats(config.getId(), retrievedStatsHolder.progress.get(), retrievedStatsHolder.dataCounts, retrievedStatsHolder.memoryUsage, retrievedStatsHolder.analysisStats));
        }, e -> listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Error searching for stats", (Throwable)e)))));
    }

    private static SearchRequest buildStoredProgressSearch(String configId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()});
        searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        searchRequest.source().size(1);
        searchRequest.source().query((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{StoredProgress.documentId(configId)}));
        return searchRequest;
    }

    private static SearchRequest buildStatsDocSearch(String configId, String statsType) {
        SearchRequest searchRequest = new SearchRequest(new String[]{MlStatsIndex.indexPattern()});
        searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        searchRequest.source().size(1);
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Fields.JOB_ID.getPreferredName(), (String)configId)).filter((QueryBuilder)QueryBuilders.termQuery((String)Fields.TYPE.getPreferredName(), (String)statsType));
        searchRequest.source().query((QueryBuilder)query);
        searchRequest.source().sort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)Fields.TIMESTAMP.getPreferredName()).order(SortOrder.DESC)).unmappedType("long"));
        return searchRequest;
    }

    private static void parseHit(SearchHit hit, String configId, RetrievedStatsHolder retrievedStatsHolder) {
        String hitId = hit.getId();
        if (StoredProgress.documentId(configId).equals(hitId)) {
            retrievedStatsHolder.progress = (StoredProgress)MlParserUtils.parse(hit, StoredProgress.PARSER);
        } else if (DataCounts.documentId((String)configId).equals(hitId)) {
            retrievedStatsHolder.dataCounts = (DataCounts)MlParserUtils.parse(hit, DataCounts.LENIENT_PARSER);
        } else if (hitId.startsWith(MemoryUsage.documentIdPrefix((String)configId))) {
            retrievedStatsHolder.memoryUsage = (MemoryUsage)MlParserUtils.parse(hit, MemoryUsage.LENIENT_PARSER);
        } else if (hitId.startsWith(OutlierDetectionStats.documentIdPrefix((String)configId))) {
            retrievedStatsHolder.analysisStats = (AnalysisStats)MlParserUtils.parse(hit, OutlierDetectionStats.LENIENT_PARSER);
        } else if (hitId.startsWith(ClassificationStats.documentIdPrefix((String)configId))) {
            retrievedStatsHolder.analysisStats = (AnalysisStats)MlParserUtils.parse(hit, ClassificationStats.LENIENT_PARSER);
        } else if (hitId.startsWith(RegressionStats.documentIdPrefix((String)configId))) {
            retrievedStatsHolder.analysisStats = (AnalysisStats)MlParserUtils.parse(hit, RegressionStats.LENIENT_PARSER);
        } else {
            throw ExceptionsHelper.serverError((String)("unexpected doc id [" + hitId + "]"));
        }
    }

    private GetDataFrameAnalyticsStatsAction.Response.Stats buildStats(String concreteAnalyticsId, List<PhaseProgress> progress, DataCounts dataCounts, MemoryUsage memoryUsage, AnalysisStats analysisStats) {
        ClusterState clusterState = this.clusterService.state();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask analyticsTask = MlTasks.getDataFrameAnalyticsTask((String)concreteAnalyticsId, (PersistentTasksCustomMetadata)tasks);
        DataFrameAnalyticsState analyticsState = MlTasks.getDataFrameAnalyticsState((String)concreteAnalyticsId, (PersistentTasksCustomMetadata)tasks);
        String failureReason = null;
        if (analyticsState == DataFrameAnalyticsState.FAILED) {
            DataFrameAnalyticsTaskState taskState = (DataFrameAnalyticsTaskState)analyticsTask.getState();
            failureReason = taskState.getReason();
        }
        DiscoveryNode node = null;
        String assignmentExplanation = null;
        if (analyticsTask != null) {
            node = clusterState.nodes().get(analyticsTask.getExecutorNode());
            assignmentExplanation = analyticsTask.getAssignment().getExplanation();
        }
        return new GetDataFrameAnalyticsStatsAction.Response.Stats(concreteAnalyticsId, analyticsState, failureReason, progress, dataCounts, memoryUsage, analysisStats, node, assignmentExplanation);
    }

    private static class RetrievedStatsHolder {
        private volatile StoredProgress progress;
        private volatile DataCounts dataCounts;
        private volatile MemoryUsage memoryUsage;
        private volatile AnalysisStats analysisStats;

        private RetrievedStatsHolder(List<PhaseProgress> defaultProgress) {
            this.progress = new StoredProgress(defaultProgress);
        }
    }
}

