/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.ml.job.persistence.CalendarQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetCalendarsAction
extends HandledTransportAction<GetCalendarsAction.Request, GetCalendarsAction.Response> {
    private final JobResultsProvider jobResultsProvider;

    @Inject
    public TransportGetCalendarsAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider) {
        super("cluster:monitor/xpack/ml/calendars/get", transportService, actionFilters, GetCalendarsAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
    }

    protected void doExecute(Task task, GetCalendarsAction.Request request, ActionListener<GetCalendarsAction.Response> listener) {
        String calendarId = request.getCalendarId();
        if (request.getCalendarId() != null && !Strings.isAllOrWildcard((String)request.getCalendarId())) {
            this.getCalendar(calendarId, listener);
        } else {
            PageParams pageParams = request.getPageParams();
            if (pageParams == null) {
                pageParams = PageParams.defaultParams();
            }
            this.getCalendars(pageParams, listener);
        }
    }

    private void getCalendar(String calendarId, ActionListener<GetCalendarsAction.Response> listener) {
        this.jobResultsProvider.calendar(calendarId, (ActionListener<Calendar>)ActionListener.wrap(calendar -> {
            QueryPage page = new QueryPage(Collections.singletonList(calendar), 1L, Calendar.RESULTS_FIELD);
            listener.onResponse((Object)new GetCalendarsAction.Response(page));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getCalendars(PageParams pageParams, ActionListener<GetCalendarsAction.Response> listener) {
        CalendarQueryBuilder query = new CalendarQueryBuilder().pageParams(pageParams).sort(true);
        this.jobResultsProvider.calendars(query, (ActionListener<QueryPage<Calendar>>)ActionListener.wrap(calendars -> listener.onResponse((Object)new GetCalendarsAction.Response(calendars)), arg_0 -> listener.onFailure(arg_0)));
    }
}

