/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.ExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.explain.FieldSelection;
import org.elasticsearch.xpack.core.ml.dataframe.explain.MemoryEstimation;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetectorFactory;
import org.elasticsearch.xpack.ml.dataframe.process.MemoryUsageEstimationProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.results.MemoryUsageEstimationResult;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;

public class TransportExplainDataFrameAnalyticsAction
extends HandledTransportAction<PutDataFrameAnalyticsAction.Request, ExplainDataFrameAnalyticsAction.Response> {
    private final XPackLicenseState licenseState;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final NodeClient client;
    private final MemoryUsageEstimationProcessManager processManager;

    @Inject
    public TransportExplainDataFrameAnalyticsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NodeClient client, XPackLicenseState licenseState, MemoryUsageEstimationProcessManager processManager) {
        super("cluster:admin/xpack/ml/data_frame/analytics/explain", transportService, actionFilters, PutDataFrameAnalyticsAction.Request::new);
        this.transportService = transportService;
        this.clusterService = Objects.requireNonNull(clusterService);
        this.client = Objects.requireNonNull(client);
        this.licenseState = licenseState;
        this.processManager = Objects.requireNonNull(processManager);
    }

    protected void doExecute(Task task, PutDataFrameAnalyticsAction.Request request, ActionListener<ExplainDataFrameAnalyticsAction.Response> listener) {
        if (!this.licenseState.checkFeature(XPackLicenseState.Feature.MACHINE_LEARNING)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        DiscoveryNode localNode = this.clusterService.localNode();
        if (MachineLearning.isMlNode(localNode)) {
            this.explain(task, request, listener);
        } else {
            this.redirectToMlNode(request, listener);
        }
    }

    private void explain(Task task, PutDataFrameAnalyticsAction.Request request, ActionListener<ExplainDataFrameAnalyticsAction.Response> listener) {
        ExtractedFieldsDetectorFactory extractedFieldsDetectorFactory = new ExtractedFieldsDetectorFactory((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()));
        extractedFieldsDetectorFactory.createFromSource(request.getConfig(), (ActionListener<ExtractedFieldsDetector>)ActionListener.wrap(extractedFieldsDetector -> this.explain(task, request, (ExtractedFieldsDetector)extractedFieldsDetector, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void explain(Task task, PutDataFrameAnalyticsAction.Request request, ExtractedFieldsDetector extractedFieldsDetector, ActionListener<ExplainDataFrameAnalyticsAction.Response> listener) {
        Tuple<ExtractedFields, List<FieldSelection>> fieldExtraction = extractedFieldsDetector.detect();
        ActionListener memoryEstimationListener = ActionListener.wrap(memoryEstimation -> listener.onResponse((Object)new ExplainDataFrameAnalyticsAction.Response((List)fieldExtraction.v2(), memoryEstimation)), arg_0 -> listener.onFailure(arg_0));
        this.estimateMemoryUsage(task, request, (ExtractedFields)fieldExtraction.v1(), (ActionListener<MemoryEstimation>)memoryEstimationListener);
    }

    private void estimateMemoryUsage(Task task, PutDataFrameAnalyticsAction.Request request, ExtractedFields extractedFields, ActionListener<MemoryEstimation> listener) {
        String estimateMemoryTaskId = "memory_usage_estimation_" + task.getId();
        DataFrameDataExtractorFactory extractorFactory = DataFrameDataExtractorFactory.createForSourceIndices((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()), estimateMemoryTaskId, request.getConfig(), extractedFields);
        this.processManager.runJobAsync(estimateMemoryTaskId, request.getConfig(), extractorFactory, (ActionListener<MemoryUsageEstimationResult>)ActionListener.wrap(result -> listener.onResponse((Object)new MemoryEstimation(result.getExpectedMemoryWithoutDisk(), result.getExpectedMemoryWithDisk())), arg_0 -> listener.onFailure(arg_0)));
    }

    private void redirectToMlNode(PutDataFrameAnalyticsAction.Request request, ActionListener<ExplainDataFrameAnalyticsAction.Response> listener) {
        Optional<DiscoveryNode> node = TransportExplainDataFrameAnalyticsAction.findMlNode(this.clusterService.state());
        if (node.isPresent()) {
            this.transportService.sendRequest(node.get(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, ExplainDataFrameAnalyticsAction.Response::new));
        } else {
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"No ML node to run on", (Object[])new Object[0]));
        }
    }

    private static Optional<DiscoveryNode> findMlNode(ClusterState clusterState) {
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!MachineLearning.isMlNode(node)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }
}

