/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.datastreams.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.QueryShardContext;

public class DataStreamTimestampFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_data_stream_timestamp";
    private static final String DEFAULT_PATH = "@timestamp";
    private final String path;
    private final boolean enabled;

    private DataStreamTimestampFieldMapper(FieldType fieldType, MappedFieldType mappedFieldType, boolean enabled) {
        super(fieldType, mappedFieldType);
        this.path = DEFAULT_PATH;
        this.enabled = enabled;
    }

    public void validate(DocumentFieldMappers lookup) {
        if (!this.enabled) {
            return;
        }
        Mapper mapper = lookup.getMapper(this.path);
        if (mapper == null) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] does not exist");
        }
        if (!"date".equals(mapper.typeName()) && !"date_nanos".equals(mapper.typeName())) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] is of type [" + mapper.typeName() + "], but [" + "date" + "," + "date_nanos" + "] is expected");
        }
        DateFieldMapper dateFieldMapper = (DateFieldMapper)mapper;
        if (!dateFieldMapper.fieldType().isSearchable()) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] is not indexed");
        }
        if (!dateFieldMapper.fieldType().hasDocValues()) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] doesn't have doc values");
        }
        if (dateFieldMapper.getNullValue() != null) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] has disallowed [null_value] attribute specified");
        }
        if (dateFieldMapper.getIgnoreMalformed().explicit()) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] has disallowed [ignore_malformed] attribute specified");
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            dateFieldMapper.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            Map configuredSettings = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)builder), (boolean)false, (XContentType)XContentType.JSON).v2();
            configuredSettings = (Map)configuredSettings.values().iterator().next();
            configuredSettings.remove("type");
            configuredSettings.remove("meta");
            configuredSettings.remove("format");
            if (!configuredSettings.isEmpty()) {
                throw new IllegalArgumentException("data stream timestamp field [@timestamp] has disallowed attributes: " + configuredSettings.keySet());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void preParse(ParseContext context) throws IOException {
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        throw new IllegalStateException("_data_stream_timestamp field mapper cannot create fields");
    }

    public void postParse(ParseContext context) throws IOException {
        if (!this.enabled) {
            return;
        }
        IndexableField[] fields = context.rootDoc().getFields(this.path);
        if (fields.length == 0) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] is missing");
        }
        long numberOfValues = Arrays.stream(fields).filter(indexableField -> indexableField.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC).count();
        if (numberOfValues > 1L) {
            throw new IllegalArgumentException("data stream timestamp field [" + this.path + "] encountered multiple values");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.enabled) {
            return builder;
        }
        builder.startObject(this.simpleName());
        builder.field("enabled", this.enabled);
        return builder.endObject();
    }

    protected String contentType() {
        return NAME;
    }

    protected boolean indexedByDefault() {
        return false;
    }

    protected boolean docValuesByDefault() {
        return false;
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        DataStreamTimestampFieldMapper otherTimestampFieldMapper = (DataStreamTimestampFieldMapper)other;
        if (!Objects.equals(this.enabled, otherTimestampFieldMapper.enabled)) {
            conflicts.add("cannot update enabled setting for [_data_stream_timestamp]");
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                builder.setEnabled(XContentMapValues.nodeBooleanValue((Object)fieldNode, (String)(name + ".enabled")));
                iterator.remove();
            }
            return builder;
        }

        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext parserContext) {
            return new DataStreamTimestampFieldMapper(Defaults.TIMESTAMP_FIELD_TYPE, new TimestampFieldType(), false);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder> {
        private boolean enabled;

        public Builder() {
            super(DataStreamTimestampFieldMapper.NAME, Defaults.TIMESTAMP_FIELD_TYPE);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public MetadataFieldMapper build(Mapper.BuilderContext context) {
            return new DataStreamTimestampFieldMapper(this.fieldType, new TimestampFieldType(), this.enabled);
        }
    }

    public static final class TimestampFieldType
    extends MappedFieldType {
        public TimestampFieldType() {
            super(DataStreamTimestampFieldMapper.NAME, false, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        public String typeName() {
            return DataStreamTimestampFieldMapper.NAME;
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support term queries");
        }

        public Query existsQuery(QueryShardContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support exists queries");
        }
    }

    public static class Defaults {
        public static final FieldType TIMESTAMP_FIELD_TYPE = new FieldType();

        static {
            TIMESTAMP_FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            TIMESTAMP_FIELD_TYPE.freeze();
        }
    }
}

