/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.datastreams.action;

import java.io.IOException;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.DeleteDataStreamAction;

public class DeleteDataStreamTransportAction
extends TransportMasterNodeAction<DeleteDataStreamAction.Request, AcknowledgedResponse> {
    private static final Logger LOGGER = LogManager.getLogger(DeleteDataStreamTransportAction.class);
    private final MetadataDeleteIndexService deleteIndexService;

    @Inject
    public DeleteDataStreamTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataDeleteIndexService deleteIndexService) {
        super("indices:admin/data_stream/delete", transportService, clusterService, threadPool, actionFilters, DeleteDataStreamAction.Request::new, indexNameExpressionResolver);
        this.deleteIndexService = deleteIndexService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(final DeleteDataStreamAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("remove-data-stream [" + Strings.arrayToCommaDelimitedString((Object[])request.getNames()) + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.HIGH){

            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public ClusterState execute(ClusterState currentState) {
                return DeleteDataStreamTransportAction.removeDataStream(DeleteDataStreamTransportAction.this.deleteIndexService, currentState, request);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    static ClusterState removeDataStream(MetadataDeleteIndexService deleteIndexService, ClusterState currentState, DeleteDataStreamAction.Request request) {
        HashSet<String> dataStreams = new HashSet<String>();
        HashSet snapshottingDataStreams = new HashSet();
        for (String name : request.getNames()) {
            for (String dataStreamName : currentState.metadata().dataStreams().keySet()) {
                if (!Regex.simpleMatch((String)name, (String)dataStreamName)) continue;
                dataStreams.add(dataStreamName);
            }
            snapshottingDataStreams.addAll(SnapshotsService.snapshottingDataStreams((ClusterState)currentState, dataStreams));
        }
        if (!snapshottingDataStreams.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete data streams that are being snapshotted: " + snapshottingDataStreams + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        HashSet backingIndicesToRemove = new HashSet();
        for (String dataStreamName : dataStreams) {
            DataStream dataStream = (DataStream)currentState.metadata().dataStreams().get(dataStreamName);
            assert (dataStream != null);
            backingIndicesToRemove.addAll(dataStream.getIndices());
        }
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        for (String ds : dataStreams) {
            LOGGER.info("removing data stream [{}]", (Object)ds);
            metadata.removeDataStream(ds);
        }
        currentState = ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
        return deleteIndexService.deleteIndices(currentState, backingIndicesToRemove);
    }

    protected ClusterBlockException checkBlock(DeleteDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

