<?php // -*-php-*-
rcs_id('$Id: ListRelations.php,v 1.1 2007/01/02 13:23:22 rurban Exp $');
/*
 Copyright 2006 Reini Urban

 This file is part of PhpWiki.

 PhpWiki is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 PhpWiki is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with PhpWiki; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

require_once('lib/PageList.php');

/**
 * Display the list of all relations and optionally attributes in the wiki.
 *
 * @author: Reini Urban
 */
class WikiPlugin_ListRelations
extends WikiPlugin
{
    function getName() {
        return _("ListRelations");
    }
    function getDescription() {
        return _("Display the list of all defined relations and optionnally attributes in this entrire wiki");
    }
    function getVersion() {
        return preg_replace("/[Revision: $]/", '',
                            "\$Revision: 1.1 $");
    }
    function getDefaultArguments() { 
        return array_merge
            (
             PageList::supportedArgs(), // paging and more.
	     array(
		   'mode' => "relations" // or "attributes" or "all"
		   ));
    }
    function run ($dbi, $argstr, &$request, $basepage) {
        $args = $this->getArgs($argstr, $request);
        extract($args);
        $pagelist = new PageList($info, $exclude, $args);
	// should attributes be listed as pagename here? 
        $pagelist->addPageList($dbi->listRelations($mode == 'all', $mode == 'attributes', !empty($sortby)));
        return $pagelist;
    }

};

// $Log: ListRelations.php,v $
// Revision 1.1  2007/01/02 13:23:22  rurban
// simple lister for relations and/or attributes
//

// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:
?>
