/*
 * Project       : ipv6calc
 * File          : dbipv4_assignment.h
 * Version       : $Id: 96c3fae1d9e7cbaf4ad352957143a465f69cf8e0 $
 * Generated     : 20190405-054613+0200 CEST
 * Data copyright: RIPE NCC, APNIC, ARIN, LACNIC, AFRINIC, LISP
 *
 * Information:
 *  Additional header file for databases/lib/libipv6calc_db_wrapper_BuiltIn.c
 */

#include "databases/lib/libipv6calc_db_wrapper_BuiltIn.h"

static const char* dbipv4addr_registry_status __attribute__ ((__unused__)) = "AFRINIC/20190403 APNIC/20190404 ARIN/20190404 IANA/20180918 LACNIC/20190404 LISP/20190405 RIPENCC/20190404";
static const time_t dbipv4addr_registry_unixtime __attribute__ ((__unused__)) = 1554435973;

static const s_ipv4addr_assignment dbipv4addr_assignment[] = {
	//first     , last      , registry  
	{ 0x01000000, 0x01ffffff, REGISTRY_APNIC      }, // 1.0.0.0         - 1.255.255.255
	{ 0x02000000, 0x02ffffff, REGISTRY_RIPENCC    }, // 2.0.0.0         - 2.255.255.255
	{ 0x03000000, 0x04ffffff, REGISTRY_ARIN       }, // 3.0.0.0         - 4.255.255.255
	{ 0x05000000, 0x051c1fff, REGISTRY_RIPENCC    }, // 5.0.0.0         - 5.28.31.255
	{ 0x051c2000, 0x051c27ff, REGISTRY_APNIC      }, // 5.28.32.0       - 5.28.39.255
	{ 0x051c2800, 0x05b633ff, REGISTRY_RIPENCC    }, // 5.28.40.0       - 5.182.51.255
	{ 0x05b80000, 0x05ffffff, REGISTRY_RIPENCC    }, // 5.184.0.0       - 5.255.255.255
	{ 0x06000000, 0x087fffff, REGISTRY_ARIN       }, // 6.0.0.0         - 8.127.255.255
	{ 0x08800000, 0x08bfffff, REGISTRY_APNIC      }, // 8.128.0.0       - 8.191.255.255
	{ 0x08c00000, 0x08cfffff, REGISTRY_ARIN       }, // 8.192.0.0       - 8.207.255.255
	{ 0x08d00000, 0x08dfffff, REGISTRY_APNIC      }, // 8.208.0.0       - 8.223.255.255
	{ 0x08e00000, 0x09ffffff, REGISTRY_ARIN       }, // 8.224.0.0       - 9.255.255.255
	{ 0x0b000000, 0x0d73ffff, REGISTRY_ARIN       }, // 11.0.0.0        - 13.115.255.255
	{ 0x0d740000, 0x0d7bffff, REGISTRY_RIPENCC    }, // 13.116.0.0      - 13.123.255.255
	{ 0x0d7c0000, 0x0d8bffff, REGISTRY_ARIN       }, // 13.124.0.0      - 13.139.255.255
	{ 0x0d8c0000, 0x0d8fffff, REGISTRY_RIPENCC    }, // 13.140.0.0      - 13.143.255.255
	{ 0x0d900000, 0x0da7ffff, REGISTRY_ARIN       }, // 13.144.0.0      - 13.167.255.255
	{ 0x0da80000, 0x0db7ffff, REGISTRY_RIPENCC    }, // 13.168.0.0      - 13.183.255.255
	{ 0x0db80000, 0x0defffff, REGISTRY_ARIN       }, // 13.184.0.0      - 13.239.255.255
	{ 0x0df00000, 0x0df3ffff, REGISTRY_RIPENCC    }, // 13.240.0.0      - 13.243.255.255
	{ 0x0df40000, 0x0dffffff, REGISTRY_ARIN       }, // 13.244.0.0      - 13.255.255.255
	{ 0x0e000000, 0x0e66abff, REGISTRY_APNIC      }, // 14.0.0.0        - 14.102.171.255
	{ 0x0e66ac00, 0x0e66afff, REGISTRY_ARIN       }, // 14.102.172.0    - 14.102.175.255
	{ 0x0e66b000, 0x0effffff, REGISTRY_APNIC      }, // 14.102.176.0    - 14.255.255.255
	{ 0x0f000000, 0x17132fff, REGISTRY_ARIN       }, // 15.0.0.0        - 23.19.47.255
	{ 0x17133000, 0x171333ff, REGISTRY_RIPENCC    }, // 23.19.48.0      - 23.19.51.255
	{ 0x17133400, 0x171337ff, REGISTRY_ARIN       }, // 23.19.52.0      - 23.19.55.255
	{ 0x17133800, 0x17133fff, REGISTRY_RIPENCC    }, // 23.19.56.0      - 23.19.63.255
	{ 0x17134000, 0x17533fff, REGISTRY_ARIN       }, // 23.19.64.0      - 23.83.63.255
	{ 0x17534000, 0x175347ff, REGISTRY_RIPENCC    }, // 23.83.64.0      - 23.83.71.255
	{ 0x17534800, 0x17536fff, REGISTRY_ARIN       }, // 23.83.72.0      - 23.83.111.255
	{ 0x17537000, 0x17537fff, REGISTRY_RIPENCC    }, // 23.83.112.0     - 23.83.127.255
	{ 0x17538000, 0x1769dfff, REGISTRY_ARIN       }, // 23.83.128.0     - 23.105.223.255
	{ 0x1769e000, 0x1769ffff, REGISTRY_RIPENCC    }, // 23.105.224.0    - 23.105.255.255
	{ 0x176a0000, 0x176a67ff, REGISTRY_ARIN       }, // 23.106.0.0      - 23.106.103.255
	{ 0x176a6800, 0x176a77ff, REGISTRY_RIPENCC    }, // 23.106.104.0    - 23.106.119.255
	{ 0x176a7800, 0x176a7fff, REGISTRY_APNIC      }, // 23.106.120.0    - 23.106.127.255
	{ 0x176a8000, 0x176ccfff, REGISTRY_ARIN       }, // 23.106.128.0    - 23.108.207.255
	{ 0x176cd000, 0x176cdfff, REGISTRY_RIPENCC    }, // 23.108.208.0    - 23.108.223.255
	{ 0x176ce000, 0x176cffff, REGISTRY_ARIN       }, // 23.108.224.0    - 23.108.255.255
	{ 0x176d0000, 0x176dffff, REGISTRY_RIPENCC    }, // 23.109.0.0      - 23.109.255.255
	{ 0x176e0000, 0x176effff, REGISTRY_ARIN       }, // 23.110.0.0      - 23.110.255.255
	{ 0x176f0000, 0x176f07ff, REGISTRY_RIPENCC    }, // 23.111.0.0      - 23.111.7.255
	{ 0x176f0800, 0x176f0bff, REGISTRY_ARIN       }, // 23.111.8.0      - 23.111.11.255
	{ 0x176f0c00, 0x176f0fff, REGISTRY_APNIC      }, // 23.111.12.0     - 23.111.15.255
	{ 0x176f1000, 0x176f3fff, REGISTRY_RIPENCC    }, // 23.111.16.0     - 23.111.63.255
	{ 0x176f4000, 0x176f4fff, REGISTRY_ARIN       }, // 23.111.64.0     - 23.111.79.255
	{ 0x176f5000, 0x176f7fff, REGISTRY_RIPENCC    }, // 23.111.80.0     - 23.111.127.255
	{ 0x176f8000, 0x176fbfff, REGISTRY_ARIN       }, // 23.111.128.0    - 23.111.191.255
	{ 0x176fc000, 0x176ff7ff, REGISTRY_RIPENCC    }, // 23.111.192.0    - 23.111.247.255
	{ 0x176ff800, 0x17e1ffff, REGISTRY_ARIN       }, // 23.111.248.0    - 23.225.255.255
	{ 0x17e20000, 0x17e20fff, REGISTRY_APNIC      }, // 23.226.0.0      - 23.226.15.255
	{ 0x17e21000, 0x17e87fff, REGISTRY_ARIN       }, // 23.226.16.0     - 23.232.127.255
	{ 0x17e88000, 0x17e8ffff, REGISTRY_APNIC      }, // 23.232.128.0    - 23.232.255.255
	{ 0x17e90000, 0x17ef7fff, REGISTRY_ARIN       }, // 23.233.0.0      - 23.239.127.255
	{ 0x17ef8000, 0x17ef9fff, REGISTRY_RIPENCC    }, // 23.239.128.0    - 23.239.159.255
	{ 0x17efa000, 0x17f9e7ff, REGISTRY_ARIN       }, // 23.239.160.0    - 23.249.231.255
	{ 0x17f9e800, 0x17f9efff, REGISTRY_RIPENCC    }, // 23.249.232.0    - 23.249.239.255
	{ 0x17f9f000, 0x17fc41ff, REGISTRY_ARIN       }, // 23.249.240.0    - 23.252.65.255
	{ 0x17fc4200, 0x17fc44ff, REGISTRY_RIPENCC    }, // 23.252.66.0     - 23.252.68.255
	{ 0x17fc4500, 0x17fc46ff, REGISTRY_ARIN       }, // 23.252.69.0     - 23.252.70.255
	{ 0x17fc4700, 0x17fc48ff, REGISTRY_RIPENCC    }, // 23.252.71.0     - 23.252.72.255
	{ 0x17fc4900, 0x17fc4aff, REGISTRY_ARIN       }, // 23.252.73.0     - 23.252.74.255
	{ 0x17fc4b00, 0x17fc4cff, REGISTRY_RIPENCC    }, // 23.252.75.0     - 23.252.76.255
	{ 0x17fc4d00, 0x17fc4eff, REGISTRY_ARIN       }, // 23.252.77.0     - 23.252.78.255
	{ 0x17fc4f00, 0x17fc4fff, REGISTRY_RIPENCC    }, // 23.252.79.0     - 23.252.79.255
	{ 0x17fc5000, 0x18296fff, REGISTRY_ARIN       }, // 23.252.80.0     - 24.41.111.255
	{ 0x18297000, 0x18297fff, REGISTRY_APNIC      }, // 24.41.112.0     - 24.41.127.255
	{ 0x18298000, 0x1835bfff, REGISTRY_ARIN       }, // 24.41.128.0     - 24.53.191.255
	{ 0x1835c000, 0x1835dfff, REGISTRY_APNIC      }, // 24.53.192.0     - 24.53.223.255
	{ 0x1835e000, 0x1883ffff, REGISTRY_ARIN       }, // 24.53.224.0     - 24.131.255.255
	{ 0x18840000, 0x1887ffff, REGISTRY_RIPENCC    }, // 24.132.0.0      - 24.135.255.255
	{ 0x18880000, 0x1897ffff, REGISTRY_ARIN       }, // 24.136.0.0      - 24.151.255.255
	{ 0x18988000, 0x18e5ffff, REGISTRY_ARIN       }, // 24.152.128.0    - 24.229.255.255
	{ 0x18e60000, 0x18e61fff, REGISTRY_APNIC      }, // 24.230.0.0      - 24.230.31.255
	{ 0x18e62000, 0x18e7ffff, REGISTRY_ARIN       }, // 24.230.32.0     - 24.231.255.255
	{ 0x18e80000, 0x18e8ffff, REGISTRY_LACNIC     }, // 24.232.0.0      - 24.232.255.255
	{ 0x18e90000, 0x18eb15ff, REGISTRY_ARIN       }, // 24.233.0.0      - 24.235.21.255
	{ 0x18eb1600, 0x18eb17ff, REGISTRY_RIPENCC    }, // 24.235.22.0     - 24.235.23.255
	{ 0x18eb1800, 0x18eb1fff, REGISTRY_APNIC      }, // 24.235.24.0     - 24.235.31.255
	{ 0x18eb2000, 0x18ffffff, REGISTRY_ARIN       }, // 24.235.32.0     - 24.255.255.255
	{ 0x19000000, 0x19ffffff, REGISTRY_RIPENCC    }, // 25.0.0.0        - 25.255.255.255
	{ 0x1a000000, 0x1affffff, REGISTRY_ARIN       }, // 26.0.0.0        - 26.255.255.255
	{ 0x1b000000, 0x1b6403ff, REGISTRY_APNIC      }, // 27.0.0.0        - 27.100.3.255
	{ 0x1b640800, 0x1b6dffff, REGISTRY_APNIC      }, // 27.100.8.0      - 27.109.255.255
	{ 0x1b6e0000, 0x1b6e13ff, REGISTRY_RIPENCC    }, // 27.110.0.0      - 27.110.19.255
	{ 0x1b6e1400, 0x1b7c3fff, REGISTRY_APNIC      }, // 27.110.20.0     - 27.124.63.255
	{ 0x1b7c5000, 0x1b7e9bff, REGISTRY_APNIC      }, // 27.124.80.0     - 27.126.155.255
	{ 0x1b7ea000, 0x1bffffff, REGISTRY_APNIC      }, // 27.126.160.0    - 27.255.255.255
	{ 0x1c000000, 0x1effffff, REGISTRY_ARIN       }, // 28.0.0.0        - 30.255.255.255
	{ 0x1f000000, 0x1f0c47ff, REGISTRY_RIPENCC    }, // 31.0.0.0        - 31.12.71.255
	{ 0x1f0c4c00, 0x1f27ffff, REGISTRY_RIPENCC    }, // 31.12.76.0      - 31.39.255.255
	{ 0x1f280000, 0x1f286fff, REGISTRY_RIPENCC    }, // 31.40.0.0       - 31.40.111.255
	{ 0x1f287000, 0x1f287fff, REGISTRY_RIPENCC    }, // 31.40.112.0     - 31.40.127.255
	{ 0x1f288000, 0x1f28bfff, REGISTRY_RIPENCC    }, // 31.40.128.0     - 31.40.191.255
	{ 0x1f28c000, 0x1f28ffff, REGISTRY_RIPENCC    }, // 31.40.192.0     - 31.40.255.255
	{ 0x1f290000, 0x1f2957ff, REGISTRY_RIPENCC    }, // 31.41.0.0       - 31.41.87.255
	{ 0x1f295800, 0x1f295fff, REGISTRY_RIPENCC    }, // 31.41.88.0      - 31.41.95.255
	{ 0x1f296000, 0x1f2997ff, REGISTRY_RIPENCC    }, // 31.41.96.0      - 31.41.151.255
	{ 0x1f299800, 0x1f299fff, REGISTRY_RIPENCC    }, // 31.41.152.0     - 31.41.159.255
	{ 0x1f29a000, 0x1f29c7ff, REGISTRY_RIPENCC    }, // 31.41.160.0     - 31.41.199.255
	{ 0x1f29c800, 0x1f29cfff, REGISTRY_RIPENCC    }, // 31.41.200.0     - 31.41.207.255
	{ 0x1f29d000, 0x1f2a4fff, REGISTRY_RIPENCC    }, // 31.41.208.0     - 31.42.79.255
	{ 0x1f2a5000, 0x1f2a5fff, REGISTRY_RIPENCC    }, // 31.42.80.0      - 31.42.95.255
	{ 0x1f2a6000, 0x1f2bffff, REGISTRY_RIPENCC    }, // 31.42.96.0      - 31.43.255.255
	{ 0x1f2c0000, 0x1f7fffff, REGISTRY_RIPENCC    }, // 31.44.0.0       - 31.127.255.255
	{ 0x1f800000, 0x1f80ffff, REGISTRY_RIPENCC    }, // 31.128.0.0      - 31.128.255.255
	{ 0x1f810000, 0x1f813fff, REGISTRY_RIPENCC    }, // 31.129.0.0      - 31.129.63.255
	{ 0x1f814000, 0x1f8307ff, REGISTRY_RIPENCC    }, // 31.129.64.0     - 31.131.7.255
	{ 0x1f830800, 0x1f830fff, REGISTRY_RIPENCC    }, // 31.131.8.0      - 31.131.15.255
	{ 0x1f831000, 0x1f8357ff, REGISTRY_RIPENCC    }, // 31.131.16.0     - 31.131.87.255
	{ 0x1f835800, 0x1f835fff, REGISTRY_RIPENCC    }, // 31.131.88.0     - 31.131.95.255
	{ 0x1f836000, 0x1f839fff, REGISTRY_RIPENCC    }, // 31.131.96.0     - 31.131.159.255
	{ 0x1f83a000, 0x1f83a7ff, REGISTRY_RIPENCC    }, // 31.131.160.0    - 31.131.167.255
	{ 0x1f83a800, 0x1f83ffff, REGISTRY_RIPENCC    }, // 31.131.168.0    - 31.131.255.255
	{ 0x1f840000, 0x1f840fff, REGISTRY_RIPENCC    }, // 31.132.0.0      - 31.132.15.255
	{ 0x1f841000, 0x1f841fff, REGISTRY_RIPENCC    }, // 31.132.16.0     - 31.132.31.255
	{ 0x1f842000, 0x1f843fff, REGISTRY_RIPENCC    }, // 31.132.32.0     - 31.132.63.255
	{ 0x1f844000, 0x1f844fff, REGISTRY_RIPENCC    }, // 31.132.64.0     - 31.132.79.255
	{ 0x1f845000, 0x1f845fff, REGISTRY_RIPENCC    }, // 31.132.80.0     - 31.132.95.255
	{ 0x1f846000, 0x1f84bfff, REGISTRY_RIPENCC    }, // 31.132.96.0     - 31.132.191.255
	{ 0x1f84c000, 0x1f84c7ff, REGISTRY_RIPENCC    }, // 31.132.192.0    - 31.132.199.255
	{ 0x1f84c800, 0x1f8517ff, REGISTRY_RIPENCC    }, // 31.132.200.0    - 31.133.23.255
	{ 0x1f851800, 0x1f851fff, REGISTRY_RIPENCC    }, // 31.133.24.0     - 31.133.31.255
	{ 0x1f852000, 0x1f852fff, REGISTRY_RIPENCC    }, // 31.133.32.0     - 31.133.47.255
	{ 0x1f853000, 0x1f853fff, REGISTRY_RIPENCC    }, // 31.133.48.0     - 31.133.63.255
	{ 0x1f854000, 0x1f855fff, REGISTRY_RIPENCC    }, // 31.133.64.0     - 31.133.95.255
	{ 0x1f856000, 0x1f8567ff, REGISTRY_RIPENCC    }, // 31.133.96.0     - 31.133.103.255
	{ 0x1f856800, 0x1f85bfff, REGISTRY_RIPENCC    }, // 31.133.104.0    - 31.133.191.255
	{ 0x1f85c000, 0x1f85c7ff, REGISTRY_RIPENCC    }, // 31.133.192.0    - 31.133.199.255
	{ 0x1f85c800, 0x1f86ffff, REGISTRY_RIPENCC    }, // 31.133.200.0    - 31.134.255.255
	{ 0x1f870000, 0x1f8707ff, REGISTRY_RIPENCC    }, // 31.135.0.0      - 31.135.7.255
	{ 0x1f870800, 0x1f87ffff, REGISTRY_RIPENCC    }, // 31.135.8.0      - 31.135.255.255
	{ 0x1f880000, 0x1fceffff, REGISTRY_RIPENCC    }, // 31.136.0.0      - 31.206.255.255
	{ 0x1fcf0000, 0x1fcf07ff, REGISTRY_ARIN       }, // 31.207.0.0      - 31.207.7.255
	{ 0x1fcf0800, 0x1fcf37ff, REGISTRY_RIPENCC    }, // 31.207.8.0      - 31.207.55.255
	{ 0x1fcf3800, 0x1fcf3bff, REGISTRY_ARIN       }, // 31.207.56.0     - 31.207.59.255
	{ 0x1fcf3c00, 0x1fffffff, REGISTRY_RIPENCC    }, // 31.207.60.0     - 31.255.255.255
	{ 0x20000000, 0x23ffffff, REGISTRY_ARIN       }, // 32.0.0.0        - 35.255.255.255
	{ 0x24000000, 0x2431ffff, REGISTRY_APNIC      }, // 36.0.0.0        - 36.49.255.255
	{ 0x24330000, 0x24ff4fff, REGISTRY_APNIC      }, // 36.51.0.0       - 36.255.79.255
	{ 0x24ff5400, 0x24ffffff, REGISTRY_APNIC      }, // 36.255.84.0     - 36.255.255.255
	{ 0x25000000, 0x256effff, REGISTRY_RIPENCC    }, // 37.0.0.0        - 37.110.255.255
	{ 0x256f0000, 0x256fffff, REGISTRY_APNIC      }, // 37.111.0.0      - 37.111.255.255
	{ 0x25700000, 0x258b83ff, REGISTRY_RIPENCC    }, // 37.112.0.0      - 37.139.131.255
	{ 0x258b8800, 0x25ffffff, REGISTRY_RIPENCC    }, // 37.139.136.0    - 37.255.255.255
	{ 0x26000000, 0x26ffffff, REGISTRY_ARIN       }, // 38.0.0.0        - 38.255.255.255
	{ 0x27000000, 0x27ffffff, REGISTRY_APNIC      }, // 39.0.0.0        - 39.255.255.255
	{ 0x28000000, 0x2847ffff, REGISTRY_ARIN       }, // 40.0.0.0        - 40.71.255.255
	{ 0x28480000, 0x2849ffff, REGISTRY_APNIC      }, // 40.72.0.0       - 40.73.255.255
	{ 0x284a0000, 0x287d7fff, REGISTRY_ARIN       }, // 40.74.0.0       - 40.125.127.255
	{ 0x287d8000, 0x287dffff, REGISTRY_APNIC      }, // 40.125.128.0    - 40.125.255.255
	{ 0x287e0000, 0x287e3fff, REGISTRY_ARIN       }, // 40.126.0.0      - 40.126.63.255
	{ 0x287e4000, 0x287e7fff, REGISTRY_APNIC      }, // 40.126.64.0     - 40.126.127.255
	{ 0x287e8000, 0x28ffffff, REGISTRY_ARIN       }, // 40.126.128.0    - 40.255.255.255
	{ 0x29000000, 0x293dffff, REGISTRY_AFRINIC    }, // 41.0.0.0        - 41.61.255.255
	{ 0x293f0000, 0x29433fff, REGISTRY_AFRINIC    }, // 41.63.0.0       - 41.67.63.255
	{ 0x29435000, 0x294357ff, REGISTRY_AFRINIC    }, // 41.67.80.0      - 41.67.87.255
	{ 0x29438000, 0x29490fff, REGISTRY_AFRINIC    }, // 41.67.128.0     - 41.73.15.255
	{ 0x29492000, 0x294a5fff, REGISTRY_AFRINIC    }, // 41.73.32.0      - 41.74.95.255
	{ 0x294a7000, 0x294adfff, REGISTRY_AFRINIC    }, // 41.74.112.0     - 41.74.223.255
	{ 0x294af000, 0x294b0fff, REGISTRY_AFRINIC    }, // 41.74.240.0     - 41.75.15.255
	{ 0x294b3000, 0x294bdfff, REGISTRY_AFRINIC    }, // 41.75.48.0      - 41.75.223.255
	{ 0x294c0000, 0x294c87ff, REGISTRY_AFRINIC    }, // 41.76.0.0       - 41.76.135.255
	{ 0x294c9000, 0x294c9fff, REGISTRY_AFRINIC    }, // 41.76.144.0     - 41.76.159.255
	{ 0x294ca800, 0x294ce7ff, REGISTRY_AFRINIC    }, // 41.76.168.0     - 41.76.231.255
	{ 0x294cf000, 0x294d9fff, REGISTRY_AFRINIC    }, // 41.76.240.0     - 41.77.159.255
	{ 0x294da800, 0x294dd7ff, REGISTRY_AFRINIC    }, // 41.77.168.0     - 41.77.215.255
	{ 0x294ddc00, 0x294df7ff, REGISTRY_AFRINIC    }, // 41.77.220.0     - 41.77.247.255
	{ 0x294e0400, 0x294e0bff, REGISTRY_AFRINIC    }, // 41.78.4.0       - 41.78.11.255
	{ 0x294e1000, 0x294e2bff, REGISTRY_AFRINIC    }, // 41.78.16.0      - 41.78.43.255
	{ 0x294e3000, 0x294e43ff, REGISTRY_AFRINIC    }, // 41.78.48.0      - 41.78.67.255
	{ 0x294e4800, 0x294e5bff, REGISTRY_AFRINIC    }, // 41.78.72.0      - 41.78.91.255
	{ 0x294e6000, 0x294e67ff, REGISTRY_AFRINIC    }, // 41.78.96.0      - 41.78.103.255
	{ 0x294e6c00, 0x294e83ff, REGISTRY_AFRINIC    }, // 41.78.108.0     - 41.78.131.255
	{ 0x294e8800, 0x294e8fff, REGISTRY_AFRINIC    }, // 41.78.136.0     - 41.78.143.255
	{ 0x294e9400, 0x294e97ff, REGISTRY_AFRINIC    }, // 41.78.148.0     - 41.78.151.255
	{ 0x294e9c00, 0x294e9fff, REGISTRY_AFRINIC    }, // 41.78.156.0     - 41.78.159.255
	{ 0x294ea400, 0x294eafff, REGISTRY_AFRINIC    }, // 41.78.164.0     - 41.78.175.255
	{ 0x294eb800, 0x294eebff, REGISTRY_AFRINIC    }, // 41.78.184.0     - 41.78.235.255
	{ 0x294ef000, 0x294effff, REGISTRY_AFRINIC    }, // 41.78.240.0     - 41.78.255.255
	{ 0x294f0400, 0x294f0bff, REGISTRY_AFRINIC    }, // 41.79.4.0       - 41.79.11.255
	{ 0x294f1000, 0x294f53ff, REGISTRY_AFRINIC    }, // 41.79.16.0      - 41.79.83.255
	{ 0x294f5800, 0x294f63ff, REGISTRY_AFRINIC    }, // 41.79.88.0      - 41.79.99.255
	{ 0x294f6800, 0x294f6fff, REGISTRY_AFRINIC    }, // 41.79.104.0     - 41.79.111.255
	{ 0x294f7400, 0x294f8bff, REGISTRY_AFRINIC    }, // 41.79.116.0     - 41.79.139.255
	{ 0x294f9400, 0x29549fff, REGISTRY_AFRINIC    }, // 41.79.148.0     - 41.84.159.255
	{ 0x2954c000, 0x29571fff, REGISTRY_AFRINIC    }, // 41.84.192.0     - 41.87.31.255
	{ 0x29574000, 0x2989ffff, REGISTRY_AFRINIC    }, // 41.87.64.0      - 41.137.255.255
	{ 0x298a2000, 0x298b3fff, REGISTRY_AFRINIC    }, // 41.138.32.0     - 41.139.63.255
	{ 0x298b8000, 0x299affff, REGISTRY_AFRINIC    }, // 41.139.128.0    - 41.154.255.255
	{ 0x299b8000, 0x29bd5fff, REGISTRY_AFRINIC    }, // 41.155.128.0    - 41.189.95.255
	{ 0x29bda000, 0x29be4bff, REGISTRY_AFRINIC    }, // 41.189.160.0    - 41.190.75.255
	{ 0x29be5000, 0x29be9fff, REGISTRY_AFRINIC    }, // 41.190.80.0     - 41.190.159.255
	{ 0x29bee000, 0x29beefff, REGISTRY_AFRINIC    }, // 41.190.224.0    - 41.190.239.255
	{ 0x29bef400, 0x29befbff, REGISTRY_AFRINIC    }, // 41.190.244.0    - 41.190.251.255
	{ 0x29bf4000, 0x29bf5bff, REGISTRY_AFRINIC    }, // 41.191.64.0     - 41.191.91.255
	{ 0x29bf6000, 0x29bf6bff, REGISTRY_AFRINIC    }, // 41.191.96.0     - 41.191.107.255
	{ 0x29bf7400, 0x29bfcfff, REGISTRY_AFRINIC    }, // 41.191.116.0    - 41.191.207.255
	{ 0x29bfd400, 0x29cd9fff, REGISTRY_AFRINIC    }, // 41.191.212.0    - 41.205.159.255
	{ 0x29cdc000, 0x29cedfff, REGISTRY_AFRINIC    }, // 41.205.192.0    - 41.206.223.255
	{ 0x29cf0000, 0x29cfdfff, REGISTRY_AFRINIC    }, // 41.207.0.0      - 41.207.223.255
	{ 0x29cfe400, 0x29d17fff, REGISTRY_AFRINIC    }, // 41.207.228.0    - 41.209.127.255
	{ 0x29d1c000, 0x29d3bfff, REGISTRY_AFRINIC    }, // 41.209.192.0    - 41.211.191.255
	{ 0x29d40000, 0x29d7bfff, REGISTRY_AFRINIC    }, // 41.212.0.0      - 41.215.191.255
	{ 0x29d7d000, 0x29d7dfff, REGISTRY_AFRINIC    }, // 41.215.208.0    - 41.215.223.255
	{ 0x29d7e800, 0x29d7ffff, REGISTRY_AFRINIC    }, // 41.215.232.0    - 41.215.255.255
	{ 0x29d82000, 0x29d8efff, REGISTRY_AFRINIC    }, // 41.216.32.0     - 41.216.239.255
	{ 0x29d90000, 0x29d9c3ff, REGISTRY_AFRINIC    }, // 41.217.0.0      - 41.217.195.255
	{ 0x29d9c800, 0x29d9cfff, REGISTRY_AFRINIC    }, // 41.217.200.0    - 41.217.207.255
	{ 0x29d9d400, 0x29d9f7ff, REGISTRY_AFRINIC    }, // 41.217.212.0    - 41.217.247.255
	{ 0x29da0000, 0x29dbbfff, REGISTRY_AFRINIC    }, // 41.218.0.0      - 41.219.191.255
	{ 0x29dc0000, 0x29dc2fff, REGISTRY_AFRINIC    }, // 41.220.0.0      - 41.220.47.255
	{ 0x29dc4000, 0x29dd6fff, REGISTRY_AFRINIC    }, // 41.220.64.0     - 41.221.111.255
	{ 0x29dd8000, 0x29de4fff, REGISTRY_AFRINIC    }, // 41.221.128.0    - 41.222.79.255
	{ 0x29de5800, 0x29deefff, REGISTRY_AFRINIC    }, // 41.222.88.0     - 41.222.239.255
	{ 0x29def400, 0x29deffff, REGISTRY_AFRINIC    }, // 41.222.244.0    - 41.222.255.255
	{ 0x29df0400, 0x29df0bff, REGISTRY_AFRINIC    }, // 41.223.4.0      - 41.223.11.255
	{ 0x29df1000, 0x29df43ff, REGISTRY_AFRINIC    }, // 41.223.16.0     - 41.223.67.255
	{ 0x29df4800, 0x29df6fff, REGISTRY_AFRINIC    }, // 41.223.72.0     - 41.223.111.255
	{ 0x29df7400, 0x29dfbbff, REGISTRY_AFRINIC    }, // 41.223.116.0    - 41.223.187.255
	{ 0x29dfc000, 0x29dfcfff, REGISTRY_AFRINIC    }, // 41.223.192.0    - 41.223.207.255
	{ 0x29dfd400, 0x29f283ff, REGISTRY_AFRINIC    }, // 41.223.212.0    - 41.242.131.255
	{ 0x29f28800, 0x29f297ff, REGISTRY_AFRINIC    }, // 41.242.136.0    - 41.242.151.255
	{ 0x29f2a000, 0x29f2afff, REGISTRY_AFRINIC    }, // 41.242.160.0    - 41.242.175.255
	{ 0x29f2c000, 0x29f4ffff, REGISTRY_AFRINIC    }, // 41.242.192.0    - 41.244.255.255
	{ 0x29f58000, 0x29ffffff, REGISTRY_AFRINIC    }, // 41.245.128.0    - 41.255.255.255
	{ 0x2a000000, 0x2be16fff, REGISTRY_APNIC      }, // 42.0.0.0        - 43.225.111.255
	{ 0x2be17000, 0x2be173ff, REGISTRY_RIPENCC    }, // 43.225.112.0    - 43.225.115.255
	{ 0x2be17400, 0x2be3b7ff, REGISTRY_APNIC      }, // 43.225.116.0    - 43.227.183.255
	{ 0x2be3bc00, 0x2be4a3ff, REGISTRY_APNIC      }, // 43.227.188.0    - 43.228.163.255
	{ 0x2be4a800, 0x2be4abff, REGISTRY_APNIC      }, // 43.228.168.0    - 43.228.171.255
	{ 0x2be4b000, 0x2be70bff, REGISTRY_APNIC      }, // 43.228.176.0    - 43.231.11.255
	{ 0x2be70c00, 0x2be70fff, REGISTRY_ARIN       }, // 43.231.12.0     - 43.231.15.255
	{ 0x2be71000, 0x2be781ff, REGISTRY_APNIC      }, // 43.231.16.0     - 43.231.129.255
	{ 0x2be78300, 0x2bf353ff, REGISTRY_APNIC      }, // 43.231.131.0    - 43.243.83.255
	{ 0x2bf35400, 0x2bf357ff, REGISTRY_ARIN       }, // 43.243.84.0     - 43.243.87.255
	{ 0x2bf35800, 0x2bf837ff, REGISTRY_APNIC      }, // 43.243.88.0     - 43.248.55.255
	{ 0x2bf83c00, 0x2bfab3ff, REGISTRY_APNIC      }, // 43.248.60.0     - 43.250.179.255
	{ 0x2bfab800, 0x2bfb9fff, REGISTRY_APNIC      }, // 43.250.184.0    - 43.251.159.255
	{ 0x2bfba000, 0x2bfba3ff, REGISTRY_RIPENCC    }, // 43.251.160.0    - 43.251.163.255
	{ 0x2bfba400, 0x2bff4fff, REGISTRY_APNIC      }, // 43.251.164.0    - 43.255.79.255
	{ 0x2bff5400, 0x2bffffff, REGISTRY_APNIC      }, // 43.255.84.0     - 43.255.255.255
	{ 0x2c000000, 0x2d03ffff, REGISTRY_ARIN       }, // 44.0.0.0        - 45.3.255.255
	{ 0x2d040000, 0x2d0643ff, REGISTRY_LACNIC     }, // 45.4.0.0        - 45.6.67.255
	{ 0x2d064800, 0x2d07ffff, REGISTRY_LACNIC     }, // 45.6.72.0       - 45.7.255.255
	{ 0x2d100000, 0x2d28bfff, REGISTRY_ARIN       }, // 45.16.0.0       - 45.40.191.255
	{ 0x2d28c000, 0x2d28ffff, REGISTRY_APNIC      }, // 45.40.192.0     - 45.40.255.255
	{ 0x2d290000, 0x2d2b3fff, REGISTRY_ARIN       }, // 45.41.0.0       - 45.43.63.255
	{ 0x2d2b4000, 0x2d2b5fff, REGISTRY_RIPENCC    }, // 45.43.64.0      - 45.43.95.255
	{ 0x2d2b6000, 0x2d38dfff, REGISTRY_ARIN       }, // 45.43.96.0      - 45.56.223.255
	{ 0x2d38e000, 0x2d38ffff, REGISTRY_RIPENCC    }, // 45.56.224.0     - 45.56.255.255
	{ 0x2d390000, 0x2d3fffff, REGISTRY_ARIN       }, // 45.57.0.0       - 45.63.255.255
	{ 0x2d400000, 0x2d4137ff, REGISTRY_APNIC      }, // 45.64.0.0       - 45.65.55.255
	{ 0x2d413a00, 0x2d413fff, REGISTRY_APNIC      }, // 45.65.58.0      - 45.65.63.255
	{ 0x2d414000, 0x2d417fff, REGISTRY_RIPENCC    }, // 45.65.64.0      - 45.65.127.255
	{ 0x2d418000, 0x2d41ffff, REGISTRY_LACNIC     }, // 45.65.128.0     - 45.65.255.255
	{ 0x2d420000, 0x2d43ffff, REGISTRY_RIPENCC    }, // 45.66.0.0       - 45.67.255.255
	{ 0x2d460000, 0x2d47ffff, REGISTRY_LACNIC     }, // 45.70.0.0       - 45.71.255.255
	{ 0x2d480000, 0x2d4affff, REGISTRY_ARIN       }, // 45.72.0.0       - 45.74.255.255
	{ 0x2d4b0000, 0x2d4b7fff, REGISTRY_APNIC      }, // 45.75.0.0       - 45.75.127.255
	{ 0x2d4b8000, 0x2d4bffff, REGISTRY_RIPENCC    }, // 45.75.128.0     - 45.75.255.255
	{ 0x2d4c0000, 0x2d4fffff, REGISTRY_ARIN       }, // 45.76.0.0       - 45.79.255.255
	{ 0x2d600000, 0x2d6fffff, REGISTRY_AFRINIC    }, // 45.96.0.0       - 45.111.255.255
	{ 0x2d700000, 0x2d70efff, REGISTRY_APNIC      }, // 45.112.0.0      - 45.112.239.255
	{ 0x2d70f400, 0x2d71e3ff, REGISTRY_APNIC      }, // 45.112.244.0    - 45.113.227.255
	{ 0x2d71e800, 0x2d72dfff, REGISTRY_APNIC      }, // 45.113.232.0    - 45.114.223.255
	{ 0x2d72e000, 0x2d72e3ff, REGISTRY_ARIN       }, // 45.114.224.0    - 45.114.227.255
	{ 0x2d72e400, 0x2d72ebff, REGISTRY_APNIC      }, // 45.114.228.0    - 45.114.235.255
	{ 0x2d72f000, 0x2d73d7ff, REGISTRY_APNIC      }, // 45.114.240.0    - 45.115.215.255
	{ 0x2d73dc00, 0x2d7413ff, REGISTRY_APNIC      }, // 45.115.220.0    - 45.116.19.255
	{ 0x2d741800, 0x2d7583ff, REGISTRY_APNIC      }, // 45.116.24.0     - 45.117.131.255
	{ 0x2d758800, 0x2d77cfff, REGISTRY_APNIC      }, // 45.117.136.0    - 45.119.207.255
	{ 0x2d77d000, 0x2d77d3ff, REGISTRY_ARIN       }, // 45.119.208.0    - 45.119.211.255
	{ 0x2d77d400, 0x2d791fff, REGISTRY_APNIC      }, // 45.119.212.0    - 45.121.31.255
	{ 0x2d792400, 0x2d7b8bff, REGISTRY_APNIC      }, // 45.121.36.0     - 45.123.139.255
	{ 0x2d7b9000, 0x2d7ca3ff, REGISTRY_APNIC      }, // 45.123.144.0    - 45.124.163.255
	{ 0x2d7ca800, 0x2d7e27ff, REGISTRY_APNIC      }, // 45.124.168.0    - 45.126.39.255
	{ 0x2d7e2c00, 0x2d7fffff, REGISTRY_APNIC      }, // 45.126.44.0     - 45.127.255.255
	{ 0x2da00000, 0x2dab23ff, REGISTRY_LACNIC     }, // 45.160.0.0      - 45.171.35.255
	{ 0x2dab2800, 0x2dab79ff, REGISTRY_LACNIC     }, // 45.171.40.0     - 45.171.121.255
	{ 0x2dab7c00, 0x2dacddff, REGISTRY_LACNIC     }, // 45.171.124.0    - 45.172.221.255
	{ 0x2dace400, 0x2dad07ff, REGISTRY_LACNIC     }, // 45.172.228.0    - 45.173.7.255
	{ 0x2dad0d00, 0x2dad2eff, REGISTRY_LACNIC     }, // 45.173.13.0     - 45.173.46.255
	{ 0x2dad3000, 0x2dad33ff, REGISTRY_LACNIC     }, // 45.173.48.0     - 45.173.51.255
	{ 0x2dad3c00, 0x2dad53ff, REGISTRY_LACNIC     }, // 45.173.60.0     - 45.173.83.255
	{ 0x2dad5800, 0x2dad7fff, REGISTRY_LACNIC     }, // 45.173.88.0     - 45.173.127.255
	{ 0x2dad8400, 0x2dadabff, REGISTRY_LACNIC     }, // 45.173.132.0    - 45.173.171.255
	{ 0x2dadb000, 0x2dadb4ff, REGISTRY_LACNIC     }, // 45.173.176.0    - 45.173.180.255
	{ 0x2dadb800, 0x2dadbbff, REGISTRY_LACNIC     }, // 45.173.184.0    - 45.173.187.255
	{ 0x2dadc400, 0x2dadc7ff, REGISTRY_LACNIC     }, // 45.173.196.0    - 45.173.199.255
	{ 0x2dadcc00, 0x2dadd7ff, REGISTRY_LACNIC     }, // 45.173.204.0    - 45.173.215.255
	{ 0x2daddc00, 0x2dade3ff, REGISTRY_LACNIC     }, // 45.173.220.0    - 45.173.227.255
	{ 0x2dade800, 0x2dadfbff, REGISTRY_LACNIC     }, // 45.173.232.0    - 45.173.251.255
	{ 0x2dae0000, 0x2dae03ff, REGISTRY_LACNIC     }, // 45.174.0.0      - 45.174.3.255
	{ 0x2dae0800, 0x2dae09ff, REGISTRY_LACNIC     }, // 45.174.8.0      - 45.174.9.255
	{ 0x2dae1800, 0x2dae2bff, REGISTRY_LACNIC     }, // 45.174.24.0     - 45.174.43.255
	{ 0x2dae3c00, 0x2dae3fff, REGISTRY_LACNIC     }, // 45.174.60.0     - 45.174.63.255
	{ 0x2dae6800, 0x2dae6bff, REGISTRY_LACNIC     }, // 45.174.104.0    - 45.174.107.255
	{ 0x2dae8100, 0x2dae83ff, REGISTRY_LACNIC     }, // 45.174.129.0    - 45.174.131.255
	{ 0x2dc00000, 0x2ddd1aff, REGISTRY_AFRINIC    }, // 45.192.0.0      - 45.221.26.255
	{ 0x2ddd1c00, 0x2ddeffff, REGISTRY_AFRINIC    }, // 45.221.28.0     - 45.222.255.255
	{ 0x2ddf0000, 0x2ddfffff, REGISTRY_ARIN       }, // 45.223.0.0      - 45.223.255.255
	{ 0x2de00000, 0x2de063ff, REGISTRY_LACNIC     }, // 45.224.0.0      - 45.224.99.255
	{ 0x2de06800, 0x2de63bff, REGISTRY_LACNIC     }, // 45.224.104.0    - 45.230.59.255
	{ 0x2de64000, 0x2defffff, REGISTRY_LACNIC     }, // 45.230.64.0     - 45.239.255.255
	{ 0x2df00000, 0x2df7ffff, REGISTRY_AFRINIC    }, // 45.240.0.0      - 45.247.255.255
	{ 0x2df80000, 0x2df9dfff, REGISTRY_APNIC      }, // 45.248.0.0      - 45.249.223.255
	{ 0x2df9e400, 0x2dfa17ff, REGISTRY_APNIC      }, // 45.249.228.0    - 45.250.23.255
	{ 0x2dfa1800, 0x2dfa1bff, REGISTRY_RIPENCC    }, // 45.250.24.0     - 45.250.27.255
	{ 0x2dfa1c00, 0x2dfcebff, REGISTRY_APNIC      }, // 45.250.28.0     - 45.252.235.255
	{ 0x2dfcf000, 0x2dffffff, REGISTRY_APNIC      }, // 45.252.240.0    - 45.255.255.255
	{ 0x2e000000, 0x2e1167ff, REGISTRY_RIPENCC    }, // 46.0.0.0        - 46.17.103.255
	{ 0x2e117000, 0x2e1f4bff, REGISTRY_RIPENCC    }, // 46.17.112.0     - 46.31.75.255
	{ 0x2e1f5000, 0x2e940fff, REGISTRY_RIPENCC    }, // 46.31.80.0      - 46.148.15.255
	{ 0x2e941000, 0x2e946fff, REGISTRY_RIPENCC    }, // 46.148.16.0     - 46.148.111.255
	{ 0x2e947000, 0x2e947fff, REGISTRY_RIPENCC    }, // 46.148.112.0    - 46.148.127.255
	{ 0x2e948000, 0x2e94efff, REGISTRY_RIPENCC    }, // 46.148.128.0    - 46.148.239.255
	{ 0x2e94f000, 0x2e950fff, REGISTRY_RIPENCC    }, // 46.148.240.0    - 46.149.15.255
	{ 0x2e951000, 0x2e955fff, REGISTRY_RIPENCC    }, // 46.149.16.0     - 46.149.95.255
	{ 0x2e957000, 0x2e959fff, REGISTRY_RIPENCC    }, // 46.149.112.0    - 46.149.159.255
	{ 0x2e95a000, 0x2e95afff, REGISTRY_RIPENCC    }, // 46.149.160.0    - 46.149.175.255
	{ 0x2e95b000, 0x2e95bfff, REGISTRY_RIPENCC    }, // 46.149.176.0    - 46.149.191.255
	{ 0x2e95c000, 0x2e95cfff, REGISTRY_APNIC      }, // 46.149.192.0    - 46.149.207.255
	{ 0x2e95d000, 0x2e95dfff, REGISTRY_RIPENCC    }, // 46.149.208.0    - 46.149.223.255
	{ 0x2e95e000, 0x2e95efff, REGISTRY_RIPENCC    }, // 46.149.224.0    - 46.149.239.255
	{ 0x2e95f000, 0x2e95ffff, REGISTRY_RIPENCC    }, // 46.149.240.0    - 46.149.255.255
	{ 0x2e960000, 0x2e971fff, REGISTRY_RIPENCC    }, // 46.150.0.0      - 46.151.31.255
	{ 0x2e972000, 0x2e9727ff, REGISTRY_RIPENCC    }, // 46.151.32.0     - 46.151.39.255
	{ 0x2e972800, 0x2e97c7ff, REGISTRY_RIPENCC    }, // 46.151.40.0     - 46.151.199.255
	{ 0x2e97c800, 0x2e97d7ff, REGISTRY_RIPENCC    }, // 46.151.200.0    - 46.151.215.255
	{ 0x2e97d800, 0x2e97ffff, REGISTRY_RIPENCC    }, // 46.151.216.0    - 46.151.255.255
	{ 0x2e980000, 0x2eac5fff, REGISTRY_RIPENCC    }, // 46.152.0.0      - 46.172.95.255
	{ 0x2eac6000, 0x2eacdfff, REGISTRY_RIPENCC    }, // 46.172.96.0     - 46.172.223.255
	{ 0x2eace000, 0x2eacffff, REGISTRY_RIPENCC    }, // 46.172.224.0    - 46.172.255.255
	{ 0x2ead0000, 0x2eadefff, REGISTRY_RIPENCC    }, // 46.173.0.0      - 46.173.239.255
	{ 0x2eadf000, 0x2eadffff, REGISTRY_RIPENCC    }, // 46.173.240.0    - 46.173.255.255
	{ 0x2eae0000, 0x2eae87ff, REGISTRY_RIPENCC    }, // 46.174.0.0      - 46.174.135.255
	{ 0x2eae8800, 0x2eae8fff, REGISTRY_RIPENCC    }, // 46.174.136.0    - 46.174.143.255
	{ 0x2eae9000, 0x2eaec7ff, REGISTRY_RIPENCC    }, // 46.174.144.0    - 46.174.199.255
	{ 0x2eaec800, 0x2eaecfff, REGISTRY_RIPENCC    }, // 46.174.200.0    - 46.174.207.255
	{ 0x2eaed000, 0x2eaf6fff, REGISTRY_RIPENCC    }, // 46.174.208.0    - 46.175.111.255
	{ 0x2eaf7000, 0x2eaf77ff, REGISTRY_RIPENCC    }, // 46.175.112.0    - 46.175.119.255
	{ 0x2eaf7800, 0x2eaf97ff, REGISTRY_RIPENCC    }, // 46.175.120.0    - 46.175.151.255
	{ 0x2eaf9800, 0x2eaf9fff, REGISTRY_RIPENCC    }, // 46.175.152.0    - 46.175.159.255
	{ 0x2eafa000, 0x2eafffff, REGISTRY_RIPENCC    }, // 46.175.160.0    - 46.175.255.255
	{ 0x2eb00000, 0x2ee7efff, REGISTRY_RIPENCC    }, // 46.176.0.0      - 46.231.239.255
	{ 0x2ee7f800, 0x2effffff, REGISTRY_RIPENCC    }, // 46.231.248.0    - 46.255.255.255
	{ 0x2f000000, 0x2f07ffff, REGISTRY_ARIN       }, // 47.0.0.0        - 47.7.255.255
	{ 0x2f080000, 0x2f09ffff, REGISTRY_APNIC      }, // 47.8.0.0        - 47.9.255.255
	{ 0x2f0a0000, 0x2f0affff, REGISTRY_ARIN       }, // 47.10.0.0       - 47.10.255.255
	{ 0x2f0b0000, 0x2f0bffff, REGISTRY_APNIC      }, // 47.11.0.0       - 47.11.255.255
	{ 0x2f0c0000, 0x2f0effff, REGISTRY_ARIN       }, // 47.12.0.0       - 47.14.255.255
	{ 0x2f0f0000, 0x2f0fffff, REGISTRY_APNIC      }, // 47.15.0.0       - 47.15.255.255
	{ 0x2f100000, 0x2f1cffff, REGISTRY_ARIN       }, // 47.16.0.0       - 47.28.255.255
	{ 0x2f1d0000, 0x2f1fffff, REGISTRY_APNIC      }, // 47.29.0.0       - 47.31.255.255
	{ 0x2f200000, 0x2f5bffff, REGISTRY_ARIN       }, // 47.32.0.0       - 47.91.255.255
	{ 0x2f5c0000, 0x2f7fffff, REGISTRY_APNIC      }, // 47.92.0.0       - 47.127.255.255
	{ 0x2f800000, 0x2ff6ffff, REGISTRY_ARIN       }, // 47.128.0.0      - 47.246.255.255
	{ 0x2ff70000, 0x2ff7ffff, REGISTRY_APNIC      }, // 47.247.0.0      - 47.247.255.255
	{ 0x2ff80000, 0x30ffffff, REGISTRY_ARIN       }, // 47.248.0.0      - 48.255.255.255
	{ 0x31000000, 0x310bffff, REGISTRY_APNIC      }, // 49.0.0.0        - 49.11.255.255
	{ 0x310c0000, 0x310dffff, REGISTRY_RIPENCC    }, // 49.12.0.0       - 49.13.255.255
	{ 0x310e0000, 0x31ffffff, REGISTRY_APNIC      }, // 49.14.0.0       - 49.255.255.255
	{ 0x32000000, 0x323bffff, REGISTRY_ARIN       }, // 50.0.0.0        - 50.59.255.255
	{ 0x323c0000, 0x323dffff, REGISTRY_RIPENCC    }, // 50.60.0.0       - 50.61.255.255
	{ 0x323e0000, 0x3276ffff, REGISTRY_ARIN       }, // 50.62.0.0       - 50.118.255.255
	{ 0x32770000, 0x3277ffff, REGISTRY_RIPENCC    }, // 50.119.0.0      - 50.119.255.255
	{ 0x32780000, 0x32ffffff, REGISTRY_ARIN       }, // 50.120.0.0      - 50.255.255.255
	{ 0x33000000, 0x334effff, REGISTRY_RIPENCC    }, // 51.0.0.0        - 51.78.255.255
	{ 0x334f0000, 0x334fffff, REGISTRY_ARIN       }, // 51.79.0.0       - 51.79.255.255
	{ 0x33500000, 0x3350ffff, REGISTRY_RIPENCC    }, // 51.80.0.0       - 51.80.255.255
	{ 0x33510000, 0x3351ffff, REGISTRY_ARIN       }, // 51.81.0.0       - 51.81.255.255
	{ 0x33520000, 0x33aaffff, REGISTRY_RIPENCC    }, // 51.82.0.0       - 51.170.255.255
	{ 0x33ab0000, 0x33abffff, REGISTRY_RIPENCC    }, // 51.171.0.0      - 51.171.255.255
	{ 0x33ac0000, 0x33b2ffff, REGISTRY_RIPENCC    }, // 51.172.0.0      - 51.178.255.255
	{ 0x33b30000, 0x33b37fff, REGISTRY_RIPENCC    }, // 51.179.0.0      - 51.179.127.255
	{ 0x33b38000, 0x33d2ffff, REGISTRY_RIPENCC    }, // 51.179.128.0    - 51.210.255.255
	{ 0x33d30000, 0x33d3ffff, REGISTRY_RIPENCC    }, // 51.211.0.0      - 51.211.255.255
	{ 0x33d40000, 0x33d9ffff, REGISTRY_RIPENCC    }, // 51.212.0.0      - 51.217.255.255
	{ 0x33da0000, 0x33daffff, REGISTRY_RIPENCC    }, // 51.218.0.0      - 51.218.255.255
	{ 0x33db0000, 0x33deffff, REGISTRY_RIPENCC    }, // 51.219.0.0      - 51.222.255.255
	{ 0x33df0000, 0x33dfffff, REGISTRY_RIPENCC    }, // 51.223.0.0      - 51.223.255.255
	{ 0x33e00000, 0x33eaffff, REGISTRY_RIPENCC    }, // 51.224.0.0      - 51.234.255.255
	{ 0x33eb0000, 0x33ebffff, REGISTRY_RIPENCC    }, // 51.235.0.0      - 51.235.255.255
	{ 0x33ec0000, 0x33fbffff, REGISTRY_RIPENCC    }, // 51.236.0.0      - 51.251.255.255
	{ 0x33fc0000, 0x33fdffff, REGISTRY_RIPENCC    }, // 51.252.0.0      - 51.253.255.255
	{ 0x33fe0000, 0x33ffffff, REGISTRY_RIPENCC    }, // 51.254.0.0      - 51.255.255.255
	{ 0x34000000, 0x344fffff, REGISTRY_ARIN       }, // 52.0.0.0        - 52.79.255.255
	{ 0x34500000, 0x3453ffff, REGISTRY_APNIC      }, // 52.80.0.0       - 52.83.255.255
	{ 0x34540000, 0x3480dfff, REGISTRY_ARIN       }, // 52.84.0.0       - 52.128.223.255
	{ 0x3480e000, 0x3480ffff, REGISTRY_APNIC      }, // 52.128.224.0    - 52.128.255.255
	{ 0x34810000, 0x3481ffff, REGISTRY_ARIN       }, // 52.129.0.0      - 52.129.255.255
	{ 0x34820000, 0x3483ffff, REGISTRY_APNIC      }, // 52.130.0.0      - 52.131.255.255
	{ 0x34840000, 0x34903fff, REGISTRY_ARIN       }, // 52.132.0.0      - 52.144.63.255
	{ 0x34904000, 0x34905fff, REGISTRY_RIPENCC    }, // 52.144.64.0     - 52.144.95.255
	{ 0x34906000, 0x34ffffff, REGISTRY_ARIN       }, // 52.144.96.0     - 52.255.255.255
	{ 0x35000000, 0x35ffffff, REGISTRY_RIPENCC    }, // 53.0.0.0        - 53.255.255.255
	{ 0x36000000, 0x3623ffff, REGISTRY_ARIN       }, // 54.0.0.0        - 54.35.255.255
	{ 0x36240000, 0x3626ffff, REGISTRY_RIPENCC    }, // 54.36.0.0       - 54.38.255.255
	{ 0x36270000, 0x36ddffff, REGISTRY_ARIN       }, // 54.39.0.0       - 54.221.255.255
	{ 0x36de0000, 0x36dfffff, REGISTRY_APNIC      }, // 54.222.0.0      - 54.223.255.255
	{ 0x36e00000, 0x38ffffff, REGISTRY_ARIN       }, // 54.224.0.0      - 56.255.255.255
	{ 0x39000000, 0x39ffffff, REGISTRY_RIPENCC    }, // 57.0.0.0        - 57.255.255.255
	{ 0x3a000000, 0x3bbfe7ff, REGISTRY_APNIC      }, // 58.0.0.0        - 59.191.231.255
	{ 0x3bbff000, 0x3d0edfff, REGISTRY_APNIC      }, // 59.191.240.0    - 61.14.223.255
	{ 0x3d0ee000, 0x3d0ee3ff, REGISTRY_RIPENCC    }, // 61.14.224.0     - 61.14.227.255
	{ 0x3d0ee400, 0x3dffffff, REGISTRY_APNIC      }, // 61.14.228.0     - 61.255.255.255
	{ 0x3e000000, 0x3e083fff, REGISTRY_RIPENCC    }, // 62.0.0.0        - 62.8.63.255
	{ 0x3e084000, 0x3e085fff, REGISTRY_AFRINIC    }, // 62.8.64.0       - 62.8.95.255
	{ 0x3e086000, 0x3e0c5fff, REGISTRY_RIPENCC    }, // 62.8.96.0       - 62.12.95.255
	{ 0x3e0c6000, 0x3e0c7fff, REGISTRY_AFRINIC    }, // 62.12.96.0      - 62.12.127.255
	{ 0x3e0c8000, 0x3e185fff, REGISTRY_RIPENCC    }, // 62.12.128.0     - 62.24.95.255
	{ 0x3e186000, 0x3e187fff, REGISTRY_AFRINIC    }, // 62.24.96.0      - 62.24.127.255
	{ 0x3e188000, 0x3e2c5fff, REGISTRY_RIPENCC    }, // 62.24.128.0     - 62.44.95.255
	{ 0x3e2c6000, 0x3e2c7fff, REGISTRY_RIPENCC    }, // 62.44.96.0      - 62.44.127.255
	{ 0x3e2c8000, 0x3e3dbfff, REGISTRY_RIPENCC    }, // 62.44.128.0     - 62.61.191.255
	{ 0x3e3dc000, 0x3e3dffff, REGISTRY_AFRINIC    }, // 62.61.192.0     - 62.61.255.255
	{ 0x3e3e0000, 0x3e441fff, REGISTRY_RIPENCC    }, // 62.62.0.0       - 62.68.31.255
	{ 0x3e442000, 0x3e443fff, REGISTRY_AFRINIC    }, // 62.68.32.0      - 62.68.63.255
	{ 0x3e444000, 0x3e44dfff, REGISTRY_RIPENCC    }, // 62.68.64.0      - 62.68.223.255
	{ 0x3e44e000, 0x3e44ffff, REGISTRY_AFRINIC    }, // 62.68.224.0     - 62.68.255.255
	{ 0x3e450000, 0x3e4e3fff, REGISTRY_RIPENCC    }, // 62.69.0.0       - 62.78.63.255
	{ 0x3e4e4000, 0x3e4e5fff, REGISTRY_RIPENCC    }, // 62.78.64.0      - 62.78.95.255
	{ 0x3e4e6000, 0x3e5f7fff, REGISTRY_RIPENCC    }, // 62.78.96.0      - 62.95.127.255
	{ 0x3e5f8000, 0x3e5fffff, REGISTRY_RIPENCC    }, // 62.95.128.0     - 62.95.255.255
	{ 0x3e600000, 0x3e71ffff, REGISTRY_RIPENCC    }, // 62.96.0.0       - 62.113.255.255
	{ 0x3e720000, 0x3e72ffff, REGISTRY_AFRINIC    }, // 62.114.0.0      - 62.114.255.255
	{ 0x3e730000, 0x3e751fff, REGISTRY_RIPENCC    }, // 62.115.0.0      - 62.117.31.255
	{ 0x3e752000, 0x3e753fff, REGISTRY_AFRINIC    }, // 62.117.32.0     - 62.117.63.255
	{ 0x3e754000, 0x3e79ffff, REGISTRY_RIPENCC    }, // 62.117.64.0     - 62.121.255.255
	{ 0x3e7a0000, 0x3e7a17ff, REGISTRY_RIPENCC    }, // 62.122.0.0      - 62.122.23.255
	{ 0x3e7a1800, 0x3e7a27ff, REGISTRY_RIPENCC    }, // 62.122.24.0     - 62.122.39.255
	{ 0x3e7a2800, 0x3e7a47ff, REGISTRY_RIPENCC    }, // 62.122.40.0     - 62.122.71.255
	{ 0x3e7a4c00, 0x3e7a57ff, REGISTRY_RIPENCC    }, // 62.122.76.0     - 62.122.87.255
	{ 0x3e7a5800, 0x3e7ad7ff, REGISTRY_RIPENCC    }, // 62.122.88.0     - 62.122.215.255
	{ 0x3e7ad800, 0x3e7ae7ff, REGISTRY_RIPENCC    }, // 62.122.216.0    - 62.122.231.255
	{ 0x3e7ae800, 0x3e7affff, REGISTRY_RIPENCC    }, // 62.122.232.0    - 62.122.255.255
	{ 0x3e7b0000, 0x3e86ffff, REGISTRY_RIPENCC    }, // 62.123.0.0      - 62.134.255.255
	{ 0x3e870000, 0x3e877fff, REGISTRY_AFRINIC    }, // 62.135.0.0      - 62.135.127.255
	{ 0x3e878000, 0x3e8affff, REGISTRY_RIPENCC    }, // 62.135.128.0    - 62.138.255.255
	{ 0x3e8b0000, 0x3e8bffff, REGISTRY_AFRINIC    }, // 62.139.0.0      - 62.139.255.255
	{ 0x3e8c0000, 0x3e8c3fff, REGISTRY_RIPENCC    }, // 62.140.0.0      - 62.140.63.255
	{ 0x3e8c4000, 0x3e8c7fff, REGISTRY_AFRINIC    }, // 62.140.64.0     - 62.140.127.255
	{ 0x3e8c8000, 0x3ead1fff, REGISTRY_RIPENCC    }, // 62.140.128.0    - 62.173.31.255
	{ 0x3ead2000, 0x3ead3fff, REGISTRY_AFRINIC    }, // 62.173.32.0     - 62.173.63.255
	{ 0x3ead4000, 0x3eb5ffff, REGISTRY_RIPENCC    }, // 62.173.64.0     - 62.181.255.255
	{ 0x3eb60000, 0x3eb60fff, REGISTRY_RIPENCC    }, // 62.182.0.0      - 62.182.15.255
	{ 0x3eb61000, 0x3eb617ff, REGISTRY_RIPENCC    }, // 62.182.16.0     - 62.182.23.255
	{ 0x3eb61800, 0x3eb61fff, REGISTRY_RIPENCC    }, // 62.182.24.0     - 62.182.31.255
	{ 0x3eb62000, 0x3eb62fff, REGISTRY_RIPENCC    }, // 62.182.32.0     - 62.182.47.255
	{ 0x3eb63000, 0x3eb63fff, REGISTRY_RIPENCC    }, // 62.182.48.0     - 62.182.63.255
	{ 0x3eb64000, 0x3eb647ff, REGISTRY_RIPENCC    }, // 62.182.64.0     - 62.182.71.255
	{ 0x3eb64800, 0x3eb65fff, REGISTRY_RIPENCC    }, // 62.182.72.0     - 62.182.95.255
	{ 0x3eb66000, 0x3eb663ff, REGISTRY_RIPENCC    }, // 62.182.96.0     - 62.182.99.255
	{ 0x3eb66600, 0x3eb67fff, REGISTRY_RIPENCC    }, // 62.182.102.0    - 62.182.127.255
	{ 0x3eb68000, 0x3eb687ff, REGISTRY_RIPENCC    }, // 62.182.128.0    - 62.182.135.255
	{ 0x3eb68800, 0x3eb697ff, REGISTRY_RIPENCC    }, // 62.182.136.0    - 62.182.151.255
	{ 0x3eb69800, 0x3eb69fff, REGISTRY_RIPENCC    }, // 62.182.152.0    - 62.182.159.255
	{ 0x3eb6a000, 0x3eb6afff, REGISTRY_RIPENCC    }, // 62.182.160.0    - 62.182.175.255
	{ 0x3eb6b000, 0x3eb6b7ff, REGISTRY_RIPENCC    }, // 62.182.176.0    - 62.182.183.255
	{ 0x3eb6b800, 0x3eb6ffff, REGISTRY_RIPENCC    }, // 62.182.184.0    - 62.182.255.255
	{ 0x3eb70000, 0x3ec13fff, REGISTRY_RIPENCC    }, // 62.183.0.0      - 62.193.63.255
	{ 0x3ec14000, 0x3ec17fff, REGISTRY_AFRINIC    }, // 62.193.64.0     - 62.193.127.255
	{ 0x3ec18000, 0x3ec19fff, REGISTRY_RIPENCC    }, // 62.193.128.0    - 62.193.159.255
	{ 0x3ec1c000, 0x3ee9ffff, REGISTRY_RIPENCC    }, // 62.193.192.0    - 62.233.255.255
	{ 0x3eea0000, 0x3eeaffff, REGISTRY_APNIC      }, // 62.234.0.0      - 62.234.255.255
	{ 0x3eeb0000, 0x3ef01fff, REGISTRY_RIPENCC    }, // 62.235.0.0      - 62.240.31.255
	{ 0x3ef02000, 0x3ef03fff, REGISTRY_AFRINIC    }, // 62.240.32.0     - 62.240.63.255
	{ 0x3ef04000, 0x3ef05fff, REGISTRY_RIPENCC    }, // 62.240.64.0     - 62.240.95.255
	{ 0x3ef06000, 0x3ef07fff, REGISTRY_AFRINIC    }, // 62.240.96.0     - 62.240.127.255
	{ 0x3ef08000, 0x3ef17fff, REGISTRY_RIPENCC    }, // 62.240.128.0    - 62.241.127.255
	{ 0x3ef18000, 0x3ef19fff, REGISTRY_AFRINIC    }, // 62.241.128.0    - 62.241.159.255
	{ 0x3ef1a000, 0x3efb7fff, REGISTRY_RIPENCC    }, // 62.241.160.0    - 62.251.127.255
	{ 0x3efb8000, 0x3efbffff, REGISTRY_AFRINIC    }, // 62.251.128.0    - 62.251.255.255
	{ 0x3efc0000, 0x3effffff, REGISTRY_RIPENCC    }, // 62.252.0.0      - 62.255.255.255
	{ 0x3f000000, 0x3f8bffff, REGISTRY_ARIN       }, // 63.0.0.0        - 63.139.255.255
	{ 0x3f8c0000, 0x3f8c0fff, REGISTRY_APNIC      }, // 63.140.0.0      - 63.140.15.255
	{ 0x3f8c1000, 0x3f8d21ff, REGISTRY_ARIN       }, // 63.140.16.0     - 63.141.33.255
	{ 0x3f8d2200, 0x3f8d25ff, REGISTRY_RIPENCC    }, // 63.141.34.0     - 63.141.37.255
	{ 0x3f8d2600, 0x3f8dffff, REGISTRY_ARIN       }, // 63.141.38.0     - 63.141.255.255
	{ 0x3f8e0000, 0x3f8e0fff, REGISTRY_RIPENCC    }, // 63.142.0.0      - 63.142.15.255
	{ 0x3f8e1000, 0x4010bfff, REGISTRY_ARIN       }, // 63.142.16.0     - 64.16.191.255
	{ 0x4010c000, 0x4010dfff, REGISTRY_RIPENCC    }, // 64.16.192.0     - 64.16.223.255
	{ 0x4010e000, 0x401bffff, REGISTRY_ARIN       }, // 64.16.224.0     - 64.27.255.255
	{ 0x401c0000, 0x401c1fff, REGISTRY_RIPENCC    }, // 64.28.0.0       - 64.28.31.255
	{ 0x401c2000, 0x401c7fff, REGISTRY_ARIN       }, // 64.28.32.0      - 64.28.127.255
	{ 0x401c8000, 0x401c8fff, REGISTRY_LACNIC     }, // 64.28.128.0     - 64.28.143.255
	{ 0x401c9000, 0x40203fff, REGISTRY_ARIN       }, // 64.28.144.0     - 64.32.63.255
	{ 0x40204000, 0x40207fff, REGISTRY_LACNIC     }, // 64.32.64.0      - 64.32.127.255
	{ 0x40208000, 0x4020ffff, REGISTRY_ARIN       }, // 64.32.128.0     - 64.32.255.255
	{ 0x40210000, 0x40213fff, REGISTRY_APNIC      }, // 64.33.0.0       - 64.33.63.255
	{ 0x40214000, 0x402affff, REGISTRY_ARIN       }, // 64.33.64.0      - 64.42.255.255
	{ 0x402b0000, 0x402b7fff, REGISTRY_RIPENCC    }, // 64.43.0.0       - 64.43.127.255
	{ 0x402b8000, 0x40396fff, REGISTRY_ARIN       }, // 64.43.128.0     - 64.57.111.255
	{ 0x40397000, 0x40397fff, REGISTRY_AFRINIC    }, // 64.57.112.0     - 64.57.127.255
	{ 0x40398000, 0x403f3fff, REGISTRY_ARIN       }, // 64.57.128.0     - 64.63.63.255
	{ 0x403f4000, 0x403f7fff, REGISTRY_APNIC      }, // 64.63.64.0      - 64.63.127.255
	{ 0x403f8000, 0x40413fff, REGISTRY_ARIN       }, // 64.63.128.0     - 64.65.63.255
	{ 0x40414000, 0x40417fff, REGISTRY_RIPENCC    }, // 64.65.64.0      - 64.65.127.255
	{ 0x40418000, 0x40770fff, REGISTRY_ARIN       }, // 64.65.128.0     - 64.119.15.255
	{ 0x40771000, 0x40771fff, REGISTRY_APNIC      }, // 64.119.16.0     - 64.119.31.255
	{ 0x40772000, 0x40786dff, REGISTRY_ARIN       }, // 64.119.32.0     - 64.120.109.255
	{ 0x40786e00, 0x407879ff, REGISTRY_APNIC      }, // 64.120.110.0    - 64.120.121.255
	{ 0x40787a00, 0x4089bfff, REGISTRY_ARIN       }, // 64.120.122.0    - 64.137.191.255
	{ 0x4089c000, 0x4089ffff, REGISTRY_RIPENCC    }, // 64.137.192.0    - 64.137.255.255
	{ 0x408a0000, 0x40bc1fff, REGISTRY_ARIN       }, // 64.138.0.0      - 64.188.31.255
	{ 0x40bc2000, 0x40bc2fff, REGISTRY_APNIC      }, // 64.188.32.0     - 64.188.47.255
	{ 0x40bc3000, 0x40cfcfff, REGISTRY_ARIN       }, // 64.188.48.0     - 64.207.207.255
	{ 0x40cfd000, 0x40cfd7ff, REGISTRY_APNIC      }, // 64.207.208.0    - 64.207.215.255
	{ 0x40cfd800, 0x40efebff, REGISTRY_ARIN       }, // 64.207.216.0    - 64.239.235.255
	{ 0x40efec00, 0x40efefff, REGISTRY_RIPENCC    }, // 64.239.236.0    - 64.239.239.255
	{ 0x40eff000, 0x40fd1fff, REGISTRY_ARIN       }, // 64.239.240.0    - 64.253.31.255
	{ 0x40fd2000, 0x40fd3fff, REGISTRY_RIPENCC    }, // 64.253.32.0     - 64.253.63.255
	{ 0x40fd4000, 0x41126fff, REGISTRY_ARIN       }, // 64.253.64.0     - 65.18.111.255
	{ 0x41127000, 0x41127fff, REGISTRY_APNIC      }, // 65.18.112.0     - 65.18.127.255
	{ 0x41128000, 0x4112bfff, REGISTRY_RIPENCC    }, // 65.18.128.0     - 65.18.191.255
	{ 0x4112c000, 0x4112cfff, REGISTRY_ARIN       }, // 65.18.192.0     - 65.18.207.255
	{ 0x4112d000, 0x4112dfff, REGISTRY_RIPENCC    }, // 65.18.208.0     - 65.18.223.255
	{ 0x4112e000, 0x41273fff, REGISTRY_ARIN       }, // 65.18.224.0     - 65.39.63.255
	{ 0x41274000, 0x41275fff, REGISTRY_RIPENCC    }, // 65.39.64.0      - 65.39.95.255
	{ 0x41276000, 0x4162ffff, REGISTRY_ARIN       }, // 65.39.96.0      - 65.98.255.255
	{ 0x41630000, 0x41635fff, REGISTRY_APNIC      }, // 65.99.0.0       - 65.99.95.255
	{ 0x41636000, 0x41637fff, REGISTRY_ARIN       }, // 65.99.96.0      - 65.99.127.255
	{ 0x41638000, 0x4163bfff, REGISTRY_RIPENCC    }, // 65.99.128.0     - 65.99.191.255
	{ 0x4163c000, 0x41b53fff, REGISTRY_ARIN       }, // 65.99.192.0     - 65.181.63.255
	{ 0x41b54000, 0x41b55fff, REGISTRY_APNIC      }, // 65.181.64.0     - 65.181.95.255
	{ 0x41b56000, 0x4207ffff, REGISTRY_ARIN       }, // 65.181.96.0     - 66.7.255.255
	{ 0x42080000, 0x42087fff, REGISTRY_AFRINIC    }, // 66.8.0.0        - 66.8.127.255
	{ 0x42088000, 0x42123fff, REGISTRY_ARIN       }, // 66.8.128.0      - 66.18.63.255
	{ 0x42124000, 0x42125fff, REGISTRY_AFRINIC    }, // 66.18.64.0      - 66.18.95.255
	{ 0x42126000, 0x422a1fff, REGISTRY_ARIN       }, // 66.18.96.0      - 66.42.31.255
	{ 0x422a2000, 0x422a3fff, REGISTRY_APNIC      }, // 66.42.32.0      - 66.42.63.255
	{ 0x422a4000, 0x423bffff, REGISTRY_ARIN       }, // 66.42.64.0      - 66.59.255.255
	{ 0x423c0000, 0x423c3fff, REGISTRY_LACNIC     }, // 66.60.0.0       - 66.60.63.255
	{ 0x423c4000, 0x424f5fff, REGISTRY_ARIN       }, // 66.60.64.0      - 66.79.95.255
	{ 0x424f6000, 0x424f7fff, REGISTRY_RIPENCC    }, // 66.79.96.0      - 66.79.127.255
	{ 0x424f8000, 0x42543fff, REGISTRY_ARIN       }, // 66.79.128.0     - 66.84.63.255
	{ 0x42544000, 0x42544fff, REGISTRY_RIPENCC    }, // 66.84.64.0      - 66.84.79.255
	{ 0x42545000, 0x4260bfff, REGISTRY_ARIN       }, // 66.84.80.0      - 66.96.191.255
	{ 0x4260c000, 0x4260ffff, REGISTRY_APNIC      }, // 66.96.192.0     - 66.96.255.255
	{ 0x42610000, 0x4261ffff, REGISTRY_ARIN       }, // 66.97.0.0       - 66.97.255.255
	{ 0x42620000, 0x42625fff, REGISTRY_LACNIC     }, // 66.98.0.0       - 66.98.95.255
	{ 0x42626000, 0x42767fff, REGISTRY_ARIN       }, // 66.98.96.0      - 66.118.127.255
	{ 0x42768000, 0x4276bfff, REGISTRY_RIPENCC    }, // 66.118.128.0    - 66.118.191.255
	{ 0x4276c000, 0x42801fff, REGISTRY_ARIN       }, // 66.118.192.0    - 66.128.31.255
	{ 0x42802000, 0x42802fff, REGISTRY_LACNIC     }, // 66.128.32.0     - 66.128.47.255
	{ 0x42803000, 0x42854fff, REGISTRY_ARIN       }, // 66.128.48.0     - 66.133.79.255
	{ 0x42855000, 0x42855fff, REGISTRY_APNIC      }, // 66.133.80.0     - 66.133.95.255
	{ 0x42856000, 0x42b59fff, REGISTRY_ARIN       }, // 66.133.96.0     - 66.181.159.255
	{ 0x42b5a000, 0x42b5bfff, REGISTRY_APNIC      }, // 66.181.160.0    - 66.181.191.255
	{ 0x42b5c000, 0x42cb8fff, REGISTRY_ARIN       }, // 66.181.192.0    - 66.203.143.255
	{ 0x42cb9000, 0x42cb9fff, REGISTRY_APNIC      }, // 66.203.144.0    - 66.203.159.255
	{ 0x42cba000, 0x42cd3fff, REGISTRY_ARIN       }, // 66.203.160.0    - 66.205.63.255
	{ 0x42cd4000, 0x42cd5fff, REGISTRY_RIPENCC    }, // 66.205.64.0     - 66.205.95.255
	{ 0x42cd6000, 0x42d45fff, REGISTRY_ARIN       }, // 66.205.96.0     - 66.212.95.255
	{ 0x42d46000, 0x42d47fff, REGISTRY_RIPENCC    }, // 66.212.96.0     - 66.212.127.255
	{ 0x42d48000, 0x42e3ffff, REGISTRY_ARIN       }, // 66.212.128.0    - 66.227.255.255
	{ 0x42e40000, 0x42e40fff, REGISTRY_APNIC      }, // 66.228.0.0      - 66.228.15.255
	{ 0x42e41000, 0x42e73fff, REGISTRY_ARIN       }, // 66.228.16.0     - 66.231.63.255
	{ 0x42e74000, 0x42e74fff, REGISTRY_LACNIC     }, // 66.231.64.0     - 66.231.79.255
	{ 0x42e75000, 0x42e7ffff, REGISTRY_ARIN       }, // 66.231.80.0     - 66.231.255.255
	{ 0x42e80000, 0x42e80fff, REGISTRY_APNIC      }, // 66.232.0.0      - 66.232.15.255
	{ 0x42e81000, 0x42ea9fff, REGISTRY_ARIN       }, // 66.232.16.0     - 66.234.159.255
	{ 0x42eaa000, 0x42eaafff, REGISTRY_APNIC      }, // 66.234.160.0    - 66.234.175.255
	{ 0x42eab000, 0x42f8cbff, REGISTRY_ARIN       }, // 66.234.176.0    - 66.248.203.255
	{ 0x42f8cc00, 0x42f8cfff, REGISTRY_RIPENCC    }, // 66.248.204.0    - 66.248.207.255
	{ 0x42f8d000, 0x42fb7fff, REGISTRY_ARIN       }, // 66.248.208.0    - 66.251.127.255
	{ 0x42fb8000, 0x42fbbfff, REGISTRY_AFRINIC    }, // 66.251.128.0    - 66.251.191.255
	{ 0x42fbc000, 0x43161fff, REGISTRY_ARIN       }, // 66.251.192.0    - 67.22.31.255
	{ 0x43162000, 0x43163bff, REGISTRY_RIPENCC    }, // 67.22.32.0      - 67.22.59.255
	{ 0x43163c00, 0x439e33ff, REGISTRY_ARIN       }, // 67.22.60.0      - 67.158.51.255
	{ 0x439e3400, 0x439e34ff, REGISTRY_APNIC      }, // 67.158.52.0     - 67.158.52.255
	{ 0x439e3500, 0x439e3dff, REGISTRY_ARIN       }, // 67.158.53.0     - 67.158.61.255
	{ 0x439e3e00, 0x439e3eff, REGISTRY_RIPENCC    }, // 67.158.62.0     - 67.158.62.255
	{ 0x439e3f00, 0x43d17fff, REGISTRY_ARIN       }, // 67.158.63.0     - 67.209.127.255
	{ 0x43d18000, 0x43d19fff, REGISTRY_RIPENCC    }, // 67.209.128.0    - 67.209.159.255
	{ 0x43d1a000, 0x43d58bff, REGISTRY_ARIN       }, // 67.209.160.0    - 67.213.139.255
	{ 0x43d58c00, 0x43d58fff, REGISTRY_APNIC      }, // 67.213.140.0    - 67.213.143.255
	{ 0x43d59000, 0x43d76fff, REGISTRY_ARIN       }, // 67.213.144.0    - 67.215.111.255
	{ 0x43d77000, 0x43d77fff, REGISTRY_APNIC      }, // 67.215.112.0    - 67.215.127.255
	{ 0x43d78000, 0x4441e3ff, REGISTRY_ARIN       }, // 67.215.128.0    - 68.65.227.255
	{ 0x4441e400, 0x4441efff, REGISTRY_APNIC      }, // 68.65.228.0     - 68.65.239.255
	{ 0x4441f000, 0x4446bfff, REGISTRY_ARIN       }, // 68.65.240.0     - 68.70.191.255
	{ 0x4446c000, 0x4446cfff, REGISTRY_RIPENCC    }, // 68.70.192.0     - 68.70.207.255
	{ 0x4446d000, 0x444effff, REGISTRY_ARIN       }, // 68.70.208.0     - 68.78.255.255
	{ 0x444f0000, 0x444f3fff, REGISTRY_APNIC      }, // 68.79.0.0       - 68.79.63.255
	{ 0x444f4000, 0x4505ffff, REGISTRY_ARIN       }, // 68.79.64.0      - 69.5.255.255
	{ 0x45060000, 0x45063fff, REGISTRY_RIPENCC    }, // 69.6.0.0        - 69.6.63.255
	{ 0x45064000, 0x45064fff, REGISTRY_APNIC      }, // 69.6.64.0       - 69.6.79.255
	{ 0x45065000, 0x453f3fff, REGISTRY_ARIN       }, // 69.6.80.0       - 69.63.63.255
	{ 0x453f4000, 0x453f4fff, REGISTRY_AFRINIC    }, // 69.63.64.0      - 69.63.79.255
	{ 0x453f5000, 0x45431fff, REGISTRY_ARIN       }, // 69.63.80.0      - 69.67.31.255
	{ 0x45432000, 0x45432fff, REGISTRY_AFRINIC    }, // 69.67.32.0      - 69.67.47.255
	{ 0x45433000, 0x45484fff, REGISTRY_ARIN       }, // 69.67.48.0      - 69.72.79.255
	{ 0x45485000, 0x454857ff, REGISTRY_APNIC      }, // 69.72.80.0      - 69.72.87.255
	{ 0x45485800, 0x455e1fff, REGISTRY_ARIN       }, // 69.72.88.0      - 69.94.31.255
	{ 0x455e2000, 0x455e2fff, REGISTRY_APNIC      }, // 69.94.32.0      - 69.94.47.255
	{ 0x455e3000, 0x455e3fff, REGISTRY_ARIN       }, // 69.94.48.0      - 69.94.63.255
	{ 0x455e4000, 0x455e4fff, REGISTRY_RIPENCC    }, // 69.94.64.0      - 69.94.79.255
	{ 0x455e5000, 0x455e6fff, REGISTRY_APNIC      }, // 69.94.80.0      - 69.94.111.255
	{ 0x455e7000, 0x455e7fff, REGISTRY_RIPENCC    }, // 69.94.112.0     - 69.94.127.255
	{ 0x455e8000, 0x459fffff, REGISTRY_ARIN       }, // 69.94.128.0     - 69.159.255.255
	{ 0x45a00000, 0x45a01fff, REGISTRY_APNIC      }, // 69.160.0.0      - 69.160.31.255
	{ 0x45a02000, 0x45a0a7ff, REGISTRY_ARIN       }, // 69.160.32.0     - 69.160.167.255
	{ 0x45a0a800, 0x45a0afff, REGISTRY_APNIC      }, // 69.160.168.0    - 69.160.175.255
	{ 0x45a0b000, 0x45ac3fff, REGISTRY_ARIN       }, // 69.160.176.0    - 69.172.63.255
	{ 0x45ac4000, 0x45ac5fff, REGISTRY_APNIC      }, // 69.172.64.0     - 69.172.95.255
	{ 0x45ac6000, 0x45ac7fff, REGISTRY_RIPENCC    }, // 69.172.96.0     - 69.172.127.255
	{ 0x45ac8000, 0x45c23fff, REGISTRY_ARIN       }, // 69.172.128.0    - 69.194.63.255
	{ 0x45c24000, 0x45c27fff, REGISTRY_RIPENCC    }, // 69.194.64.0     - 69.194.127.255
	{ 0x45c28000, 0x45c29fff, REGISTRY_ARIN       }, // 69.194.128.0    - 69.194.159.255
	{ 0x45c2a000, 0x45c2afff, REGISTRY_APNIC      }, // 69.194.160.0    - 69.194.175.255
	{ 0x45c2b000, 0x45e6bfff, REGISTRY_ARIN       }, // 69.194.176.0    - 69.230.191.255
	{ 0x45e6c000, 0x45e6ffff, REGISTRY_APNIC      }, // 69.230.192.0    - 69.230.255.255
	{ 0x45e70000, 0x45e77fff, REGISTRY_ARIN       }, // 69.231.0.0      - 69.231.127.255
	{ 0x45e78000, 0x45e7bfff, REGISTRY_APNIC      }, // 69.231.128.0    - 69.231.191.255
	{ 0x45e7c000, 0x45eabfff, REGISTRY_ARIN       }, // 69.231.192.0    - 69.234.191.255
	{ 0x45eac000, 0x45eaffff, REGISTRY_APNIC      }, // 69.234.192.0    - 69.234.255.255
	{ 0x45eb0000, 0x45eb7fff, REGISTRY_ARIN       }, // 69.235.0.0      - 69.235.127.255
	{ 0x45eb8000, 0x45ebbfff, REGISTRY_APNIC      }, // 69.235.128.0    - 69.235.191.255
	{ 0x45ebc000, 0x462239ff, REGISTRY_ARIN       }, // 69.235.192.0    - 70.34.57.255
	{ 0x46223a00, 0x46223aff, REGISTRY_APNIC      }, // 70.34.58.0      - 70.34.58.255
	{ 0x46223b00, 0x4783bfff, REGISTRY_ARIN       }, // 70.34.59.0      - 71.131.191.255
	{ 0x4783c000, 0x47843fff, REGISTRY_APNIC      }, // 71.131.192.0    - 71.132.63.255
	{ 0x47844000, 0x47883fff, REGISTRY_ARIN       }, // 71.132.64.0     - 71.136.63.255
	{ 0x47884000, 0x47887fff, REGISTRY_APNIC      }, // 71.136.64.0     - 71.136.127.255
	{ 0x47888000, 0x4788ffff, REGISTRY_ARIN       }, // 71.136.128.0    - 71.136.255.255
	{ 0x47890000, 0x47893fff, REGISTRY_APNIC      }, // 71.137.0.0      - 71.137.63.255
	{ 0x47894000, 0x4823f7ff, REGISTRY_ARIN       }, // 71.137.64.0     - 72.35.247.255
	{ 0x4823f800, 0x4823fdff, REGISTRY_APNIC      }, // 72.35.248.0     - 72.35.253.255
	{ 0x4823fe00, 0x482c0fff, REGISTRY_ARIN       }, // 72.35.254.0     - 72.44.15.255
	{ 0x482c1000, 0x482c1fff, REGISTRY_LACNIC     }, // 72.44.16.0      - 72.44.31.255
	{ 0x482c2000, 0x48feffff, REGISTRY_ARIN       }, // 72.44.32.0      - 72.254.255.255
	{ 0x48ff0000, 0x48ff3fff, REGISTRY_APNIC      }, // 72.255.0.0      - 72.255.63.255
	{ 0x48ff4000, 0x48ffdfff, REGISTRY_ARIN       }, // 72.255.64.0     - 72.255.223.255
	{ 0x48ffe000, 0x48ffffff, REGISTRY_APNIC      }, // 72.255.224.0    - 72.255.255.255
	{ 0x49000000, 0x4a32cfff, REGISTRY_ARIN       }, // 73.0.0.0        - 74.50.207.255
	{ 0x4a32d000, 0x4a32d7ff, REGISTRY_APNIC      }, // 74.50.208.0     - 74.50.215.255
	{ 0x4a32d800, 0x4a722fff, REGISTRY_ARIN       }, // 74.50.216.0     - 74.114.47.255
	{ 0x4a723000, 0x4a7233ff, REGISTRY_APNIC      }, // 74.114.48.0     - 74.114.51.255
	{ 0x4a723400, 0x4a764fff, REGISTRY_ARIN       }, // 74.114.52.0     - 74.118.79.255
	{ 0x4a765000, 0x4a7653ff, REGISTRY_APNIC      }, // 74.118.80.0     - 74.118.83.255
	{ 0x4a765400, 0x4c4d2fff, REGISTRY_ARIN       }, // 74.118.84.0     - 76.77.47.255
	{ 0x4c4d3000, 0x4c4d3fff, REGISTRY_APNIC      }, // 76.77.48.0      - 76.77.63.255
	{ 0x4c4d4000, 0x4cffffff, REGISTRY_ARIN       }, // 76.77.64.0      - 76.255.255.255
	{ 0x4d000000, 0x4d4fffff, REGISTRY_RIPENCC    }, // 77.0.0.0        - 77.79.255.255
	{ 0x4d500000, 0x4d50ffff, REGISTRY_RIPENCC    }, // 77.80.0.0       - 77.80.255.255
	{ 0x4d510000, 0x4d56ffff, REGISTRY_RIPENCC    }, // 77.81.0.0       - 77.86.255.255
	{ 0x4d570000, 0x4d5787ff, REGISTRY_RIPENCC    }, // 77.87.0.0       - 77.87.135.255
	{ 0x4d578800, 0x4d578fff, REGISTRY_RIPENCC    }, // 77.87.136.0     - 77.87.143.255
	{ 0x4d579000, 0x4d57f7ff, REGISTRY_RIPENCC    }, // 77.87.144.0     - 77.87.247.255
	{ 0x4d57f800, 0x4ddbffff, REGISTRY_RIPENCC    }, // 77.87.248.0     - 77.219.255.255
	{ 0x4ddc0000, 0x4ddc1fff, REGISTRY_AFRINIC    }, // 77.220.0.0      - 77.220.31.255
	{ 0x4ddc2000, 0x4e1b7fff, REGISTRY_RIPENCC    }, // 77.220.32.0     - 78.27.127.255
	{ 0x4e1b8000, 0x4e1bffff, REGISTRY_RIPENCC    }, // 78.27.128.0     - 78.27.255.255
	{ 0x4e1c0000, 0x4e1effff, REGISTRY_RIPENCC    }, // 78.28.0.0       - 78.30.255.255
	{ 0x4e1f0000, 0x4e1f27ff, REGISTRY_RIPENCC    }, // 78.31.0.0       - 78.31.39.255
	{ 0x4e1f2800, 0x4e1f2fff, REGISTRY_RIPENCC    }, // 78.31.40.0      - 78.31.47.255
	{ 0x4e1f3000, 0x4e1f47ff, REGISTRY_RIPENCC    }, // 78.31.48.0      - 78.31.71.255
	{ 0x4e1f4800, 0x4e1f4fff, REGISTRY_RIPENCC    }, // 78.31.72.0      - 78.31.79.255
	{ 0x4e1f5000, 0x4e1f67ff, REGISTRY_RIPENCC    }, // 78.31.80.0      - 78.31.103.255
	{ 0x4e1f6800, 0x4e1f6fff, REGISTRY_RIPENCC    }, // 78.31.104.0     - 78.31.111.255
	{ 0x4e1f7000, 0x4e1fbfff, REGISTRY_RIPENCC    }, // 78.31.112.0     - 78.31.191.255
	{ 0x4e1fc000, 0x4e1fc7ff, REGISTRY_RIPENCC    }, // 78.31.192.0     - 78.31.199.255
	{ 0x4e1fc800, 0x4e1fe7ff, REGISTRY_RIPENCC    }, // 78.31.200.0     - 78.31.231.255
	{ 0x4e1fe800, 0x4e1fefff, REGISTRY_RIPENCC    }, // 78.31.232.0     - 78.31.239.255
	{ 0x4e1ff000, 0x4e1ff7ff, REGISTRY_RIPENCC    }, // 78.31.240.0     - 78.31.247.255
	{ 0x4e1ff800, 0x4f6e1fff, REGISTRY_RIPENCC    }, // 78.31.248.0     - 79.110.31.255
	{ 0x4f6e2000, 0x4f6e2fff, REGISTRY_RIPENCC    }, // 79.110.32.0     - 79.110.47.255
	{ 0x4f6e3000, 0x4f6e3fff, REGISTRY_RIPENCC    }, // 79.110.48.0     - 79.110.63.255
	{ 0x4f6e4000, 0x4f6e9fff, REGISTRY_RIPENCC    }, // 79.110.64.0     - 79.110.159.255
	{ 0x4f6ea000, 0x4f6eb7ff, REGISTRY_RIPENCC    }, // 79.110.160.0    - 79.110.183.255
	{ 0x4f6eb800, 0x4f6effff, REGISTRY_RIPENCC    }, // 79.110.184.0    - 79.110.255.255
	{ 0x4f6f0000, 0x4f8f7fff, REGISTRY_RIPENCC    }, // 79.111.0.0      - 79.143.127.255
	{ 0x4f8f9000, 0x4fae1fff, REGISTRY_RIPENCC    }, // 79.143.144.0    - 79.174.31.255
	{ 0x4fae2000, 0x4fae7fff, REGISTRY_RIPENCC    }, // 79.174.32.0     - 79.174.127.255
	{ 0x4fae8000, 0x50437fff, REGISTRY_RIPENCC    }, // 79.174.128.0    - 80.67.127.255
	{ 0x50438000, 0x50438fff, REGISTRY_AFRINIC    }, // 80.67.128.0     - 80.67.143.255
	{ 0x50439000, 0x5044e7ff, REGISTRY_RIPENCC    }, // 80.67.144.0     - 80.68.231.255
	{ 0x5044e800, 0x5044ffff, REGISTRY_RIPENCC    }, // 80.68.232.0     - 80.68.255.255
	{ 0x50450000, 0x50471fff, REGISTRY_RIPENCC    }, // 80.69.0.0       - 80.71.31.255
	{ 0x50472000, 0x50472fff, REGISTRY_ARIN       }, // 80.71.32.0      - 80.71.47.255
	{ 0x50473000, 0x50485fff, REGISTRY_RIPENCC    }, // 80.71.48.0      - 80.72.95.255
	{ 0x50486000, 0x50486fff, REGISTRY_AFRINIC    }, // 80.72.96.0      - 80.72.111.255
	{ 0x50487000, 0x504b9fff, REGISTRY_RIPENCC    }, // 80.72.112.0     - 80.75.159.255
	{ 0x504ba000, 0x504bbfff, REGISTRY_AFRINIC    }, // 80.75.160.0     - 80.75.191.255
	{ 0x504bc000, 0x50560fff, REGISTRY_RIPENCC    }, // 80.75.192.0     - 80.86.15.255
	{ 0x50561000, 0x50561fff, REGISTRY_ARIN       }, // 80.86.16.0      - 80.86.31.255
	{ 0x50562000, 0x50573fff, REGISTRY_RIPENCC    }, // 80.86.32.0      - 80.87.63.255
	{ 0x50574000, 0x50575fff, REGISTRY_AFRINIC    }, // 80.87.64.0      - 80.87.95.255
	{ 0x50576000, 0x5057ffff, REGISTRY_RIPENCC    }, // 80.87.96.0      - 80.87.255.255
	{ 0x50580000, 0x50580fff, REGISTRY_AFRINIC    }, // 80.88.0.0       - 80.88.15.255
	{ 0x50581000, 0x505e4fff, REGISTRY_RIPENCC    }, // 80.88.16.0      - 80.94.79.255
	{ 0x505e5200, 0x505e53ff, REGISTRY_RIPENCC    }, // 80.94.82.0      - 80.94.83.255
	{ 0x505e6000, 0x505effff, REGISTRY_RIPENCC    }, // 80.94.96.0      - 80.94.255.255
	{ 0x505f0000, 0x505f0fff, REGISTRY_AFRINIC    }, // 80.95.0.0       - 80.95.15.255
	{ 0x505f1000, 0x50edffff, REGISTRY_RIPENCC    }, // 80.95.16.0      - 80.237.255.255
	{ 0x50ee0000, 0x50ee1fff, REGISTRY_RIPENCC    }, // 80.238.0.0      - 80.238.31.255
	{ 0x50ee2000, 0x50ee5fff, REGISTRY_RIPENCC    }, // 80.238.32.0     - 80.238.95.255
	{ 0x50ee6000, 0x50ee7fff, REGISTRY_RIPENCC    }, // 80.238.96.0     - 80.238.127.255
	{ 0x50ee8000, 0x50f0bfff, REGISTRY_RIPENCC    }, // 80.238.128.0    - 80.240.191.255
	{ 0x50f0c000, 0x50f0cfff, REGISTRY_AFRINIC    }, // 80.240.192.0    - 80.240.207.255
	{ 0x50f0d000, 0x50f5ffff, REGISTRY_RIPENCC    }, // 80.240.208.0    - 80.245.255.255
	{ 0x50f60000, 0x50f60fff, REGISTRY_AFRINIC    }, // 80.246.0.0      - 80.246.15.255
	{ 0x50f61000, 0x50f7ffff, REGISTRY_RIPENCC    }, // 80.246.16.0     - 80.247.255.255
	{ 0x50f80000, 0x50f80fff, REGISTRY_AFRINIC    }, // 80.248.0.0      - 80.248.15.255
	{ 0x50f81000, 0x50f83fff, REGISTRY_RIPENCC    }, // 80.248.16.0     - 80.248.63.255
	{ 0x50f84000, 0x50f84fff, REGISTRY_AFRINIC    }, // 80.248.64.0     - 80.248.79.255
	{ 0x50f85000, 0x50f93fff, REGISTRY_RIPENCC    }, // 80.248.80.0     - 80.249.63.255
	{ 0x50f94000, 0x50f94fff, REGISTRY_AFRINIC    }, // 80.249.64.0     - 80.249.79.255
	{ 0x50f95000, 0x50fa1fff, REGISTRY_RIPENCC    }, // 80.249.80.0     - 80.250.31.255
	{ 0x50fa2000, 0x50fa2fff, REGISTRY_AFRINIC    }, // 80.250.32.0     - 80.250.47.255
	{ 0x50fa3000, 0x5103ffff, REGISTRY_RIPENCC    }, // 80.250.48.0     - 81.3.255.255
	{ 0x51044000, 0x5109ffff, REGISTRY_RIPENCC    }, // 81.4.64.0       - 81.9.255.255
	{ 0x510a0000, 0x510a7fff, REGISTRY_AFRINIC    }, // 81.10.0.0       - 81.10.127.255
	{ 0x510a8000, 0x510affff, REGISTRY_RIPENCC    }, // 81.10.128.0     - 81.10.255.255
	{ 0x510b0000, 0x510b7fff, REGISTRY_RIPENCC    }, // 81.11.0.0       - 81.11.127.255
	{ 0x510b8000, 0x5114dfff, REGISTRY_RIPENCC    }, // 81.11.128.0     - 81.20.223.255
	{ 0x5114e000, 0x5114ffff, REGISTRY_RIPENCC    }, // 81.20.224.0     - 81.20.255.255
	{ 0x51150000, 0x51155fff, REGISTRY_RIPENCC    }, // 81.21.0.0       - 81.21.95.255
	{ 0x51156000, 0x51156fff, REGISTRY_AFRINIC    }, // 81.21.96.0      - 81.21.111.255
	{ 0x51157000, 0x51163fff, REGISTRY_RIPENCC    }, // 81.21.112.0     - 81.22.63.255
	{ 0x51166000, 0x5117cfff, REGISTRY_RIPENCC    }, // 81.22.96.0      - 81.23.207.255
	{ 0x5117d000, 0x5117dfff, REGISTRY_APNIC      }, // 81.23.208.0     - 81.23.223.255
	{ 0x5117e000, 0x511a3fff, REGISTRY_RIPENCC    }, // 81.23.224.0     - 81.26.63.255
	{ 0x511a4000, 0x511a4fff, REGISTRY_AFRINIC    }, // 81.26.64.0      - 81.26.79.255
	{ 0x511a5000, 0x511d5fff, REGISTRY_RIPENCC    }, // 81.26.80.0      - 81.29.95.255
	{ 0x511d6000, 0x511d6fff, REGISTRY_AFRINIC    }, // 81.29.96.0      - 81.29.111.255
	{ 0x511d7000, 0x5143ffff, REGISTRY_RIPENCC    }, // 81.29.112.0     - 81.67.255.255
	{ 0x51440000, 0x5147ffff, REGISTRY_APNIC      }, // 81.68.0.0       - 81.71.255.255
	{ 0x51480000, 0x5157ffff, REGISTRY_RIPENCC    }, // 81.72.0.0       - 81.87.255.255
	{ 0x51580000, 0x51580fff, REGISTRY_RIPENCC    }, // 81.88.0.0       - 81.88.15.255
	{ 0x51581000, 0x515bdfff, REGISTRY_RIPENCC    }, // 81.88.16.0      - 81.91.223.255
	{ 0x515be000, 0x515befff, REGISTRY_AFRINIC    }, // 81.91.224.0     - 81.91.239.255
	{ 0x515bf000, 0x51a07fff, REGISTRY_RIPENCC    }, // 81.91.240.0     - 81.160.127.255
	{ 0x51a08000, 0x51a0ffff, REGISTRY_RIPENCC    }, // 81.160.128.0    - 81.160.255.255
	{ 0x51a10000, 0x51a10fff, REGISTRY_RIPENCC    }, // 81.161.0.0      - 81.161.15.255
	{ 0x51a11000, 0x51a12fff, REGISTRY_RIPENCC    }, // 81.161.16.0     - 81.161.47.255
	{ 0x51a13000, 0x51a137ff, REGISTRY_RIPENCC    }, // 81.161.48.0     - 81.161.55.255
	{ 0x51a13800, 0x51a1bfff, REGISTRY_RIPENCC    }, // 81.161.56.0     - 81.161.191.255
	{ 0x51a1c000, 0x51a1cfff, REGISTRY_RIPENCC    }, // 81.161.192.0    - 81.161.207.255
	{ 0x51a1d000, 0x51a1dfff, REGISTRY_RIPENCC    }, // 81.161.208.0    - 81.161.223.255
	{ 0x51a1e000, 0x51a1e3ff, REGISTRY_RIPENCC    }, // 81.161.224.0    - 81.161.227.255
	{ 0x51a1e800, 0x51a1efff, REGISTRY_RIPENCC    }, // 81.161.232.0    - 81.161.239.255
	{ 0x51a1f000, 0x51a33fff, REGISTRY_RIPENCC    }, // 81.161.240.0    - 81.163.63.255
	{ 0x51a34000, 0x51a347ff, REGISTRY_RIPENCC    }, // 81.163.64.0     - 81.163.71.255
	{ 0x51a34800, 0x51a3bfff, REGISTRY_RIPENCC    }, // 81.163.72.0     - 81.163.191.255
	{ 0x51a3c000, 0x51a3c7ff, REGISTRY_RIPENCC    }, // 81.163.192.0    - 81.163.199.255
	{ 0x51a3c800, 0x51a3ffff, REGISTRY_RIPENCC    }, // 81.163.200.0    - 81.163.255.255
	{ 0x51a40000, 0x51b9ffff, REGISTRY_RIPENCC    }, // 81.164.0.0      - 81.185.255.255
	{ 0x51ba0000, 0x51baffff, REGISTRY_RIPENCC    }, // 81.186.0.0      - 81.186.255.255
	{ 0x51bb0000, 0x51bfffff, REGISTRY_RIPENCC    }, // 81.187.0.0      - 81.191.255.255
	{ 0x51c00000, 0x51c0ffff, REGISTRY_AFRINIC    }, // 81.192.0.0      - 81.192.255.255
	{ 0x51c10000, 0x52657fff, REGISTRY_RIPENCC    }, // 81.193.0.0      - 82.101.127.255
	{ 0x52658000, 0x5265bfff, REGISTRY_AFRINIC    }, // 82.101.128.0    - 82.101.191.255
	{ 0x5265c000, 0x5273bfff, REGISTRY_RIPENCC    }, // 82.101.192.0    - 82.115.191.255
	{ 0x5273c000, 0x5273cfff, REGISTRY_RIPENCC    }, // 82.115.192.0    - 82.115.207.255
	{ 0x5273d000, 0x527fffff, REGISTRY_RIPENCC    }, // 82.115.208.0    - 82.127.255.255
	{ 0x52808000, 0x52817fff, REGISTRY_RIPENCC    }, // 82.128.128.0    - 82.129.127.255
	{ 0x52818000, 0x5281ffff, REGISTRY_AFRINIC    }, // 82.129.128.0    - 82.129.255.255
	{ 0x52820000, 0x52827fff, REGISTRY_RIPENCC    }, // 82.130.0.0      - 82.130.127.255
	{ 0x52828000, 0x52973fff, REGISTRY_RIPENCC    }, // 82.130.128.0    - 82.151.63.255
	{ 0x52974000, 0x52975fff, REGISTRY_AFRINIC    }, // 82.151.64.0     - 82.151.95.255
	{ 0x52976000, 0x529bffff, REGISTRY_RIPENCC    }, // 82.151.96.0     - 82.155.255.255
	{ 0x529c0000, 0x529dffff, REGISTRY_APNIC      }, // 82.156.0.0      - 82.157.255.255
	{ 0x529e0000, 0x52c97fff, REGISTRY_RIPENCC    }, // 82.158.0.0      - 82.201.127.255
	{ 0x52c98000, 0x52c9ffff, REGISTRY_AFRINIC    }, // 82.201.128.0    - 82.201.255.255
	{ 0x52ca0000, 0x52d3bfff, REGISTRY_RIPENCC    }, // 82.202.0.0      - 82.211.191.255
	{ 0x52d3c000, 0x52d3ffff, REGISTRY_RIPENCC    }, // 82.211.192.0    - 82.211.255.255
	{ 0x52d40000, 0x5360ffff, REGISTRY_RIPENCC    }, // 82.212.0.0      - 83.96.255.255
	{ 0x53610000, 0x53610fff, REGISTRY_RIPENCC    }, // 83.97.0.0       - 83.97.15.255
	{ 0x53611000, 0x536117ff, REGISTRY_RIPENCC    }, // 83.97.16.0      - 83.97.23.255
	{ 0x53611800, 0x53616fff, REGISTRY_RIPENCC    }, // 83.97.24.0      - 83.97.111.255
	{ 0x53617000, 0x536177ff, REGISTRY_RIPENCC    }, // 83.97.112.0     - 83.97.119.255
	{ 0x53617800, 0x53617fff, REGISTRY_RIPENCC    }, // 83.97.120.0     - 83.97.127.255
	{ 0x53618000, 0x538dffff, REGISTRY_RIPENCC    }, // 83.97.128.0     - 83.141.255.255
	{ 0x538e0000, 0x538e17ff, REGISTRY_RIPENCC    }, // 83.142.0.0      - 83.142.23.255
	{ 0x538e1800, 0x538e1fff, REGISTRY_RIPENCC    }, // 83.142.24.0     - 83.142.31.255
	{ 0x538e2000, 0x538e2fff, REGISTRY_RIPENCC    }, // 83.142.32.0     - 83.142.47.255
	{ 0x538e3000, 0x538e3fff, REGISTRY_RIPENCC    }, // 83.142.48.0     - 83.142.63.255
	{ 0x538e4000, 0x538e8fff, REGISTRY_RIPENCC    }, // 83.142.64.0     - 83.142.143.255
	{ 0x538e9000, 0x538e97ff, REGISTRY_RIPENCC    }, // 83.142.144.0    - 83.142.151.255
	{ 0x538e9800, 0x538ea7ff, REGISTRY_RIPENCC    }, // 83.142.152.0    - 83.142.167.255
	{ 0x538ea800, 0x538eafff, REGISTRY_RIPENCC    }, // 83.142.168.0    - 83.142.175.255
	{ 0x538eb000, 0x538edfff, REGISTRY_RIPENCC    }, // 83.142.176.0    - 83.142.223.255
	{ 0x538ee000, 0x538ee7ff, REGISTRY_RIPENCC    }, // 83.142.224.0    - 83.142.231.255
	{ 0x538ee800, 0x538f17ff, REGISTRY_RIPENCC    }, // 83.142.232.0    - 83.143.23.255
	{ 0x538f1800, 0x538f1fff, REGISTRY_AFRINIC    }, // 83.143.24.0     - 83.143.31.255
	{ 0x538f2000, 0x538f2fff, REGISTRY_RIPENCC    }, // 83.143.32.0     - 83.143.47.255
	{ 0x538f3000, 0x538f37ff, REGISTRY_RIPENCC    }, // 83.143.48.0     - 83.143.55.255
	{ 0x538f3800, 0x538f47ff, REGISTRY_RIPENCC    }, // 83.143.56.0     - 83.143.71.255
	{ 0x538f4800, 0x538f4fff, REGISTRY_RIPENCC    }, // 83.143.72.0     - 83.143.79.255
	{ 0x538f5000, 0x538f67ff, REGISTRY_RIPENCC    }, // 83.143.80.0     - 83.143.103.255
	{ 0x538f6800, 0x538f77ff, REGISTRY_RIPENCC    }, // 83.143.104.0    - 83.143.119.255
	{ 0x538f7800, 0x538fefff, REGISTRY_RIPENCC    }, // 83.143.120.0    - 83.143.239.255
	{ 0x538ff000, 0x538ff7ff, REGISTRY_RIPENCC    }, // 83.143.240.0    - 83.143.247.255
	{ 0x538ff800, 0x538fffff, REGISTRY_RIPENCC    }, // 83.143.248.0    - 83.143.255.255
	{ 0x53900000, 0x5396ffff, REGISTRY_RIPENCC    }, // 83.144.0.0      - 83.150.255.255
	{ 0x53970000, 0x53973fff, REGISTRY_RIPENCC    }, // 83.151.0.0      - 83.151.63.255
	{ 0x53974000, 0x53af7fff, REGISTRY_RIPENCC    }, // 83.151.64.0     - 83.175.127.255
	{ 0x53af8000, 0x53afbfff, REGISTRY_RIPENCC    }, // 83.175.128.0    - 83.175.191.255
	{ 0x53afc000, 0x53f1ffff, REGISTRY_RIPENCC    }, // 83.175.192.0    - 83.241.255.255
	{ 0x53f20000, 0x53f22fff, REGISTRY_RIPENCC    }, // 83.242.0.0      - 83.242.47.255
	{ 0x53f23000, 0x53f23fff, REGISTRY_RIPENCC    }, // 83.242.48.0     - 83.242.63.255
	{ 0x53f24000, 0x53f27fff, REGISTRY_RIPENCC    }, // 83.242.64.0     - 83.242.127.255
	{ 0x53f28000, 0x53f2ffff, REGISTRY_RIPENCC    }, // 83.242.128.0    - 83.242.255.255
	{ 0x53f30000, 0x53f327ff, REGISTRY_RIPENCC    }, // 83.243.0.0      - 83.243.39.255
	{ 0x53f32800, 0x53f32fff, REGISTRY_RIPENCC    }, // 83.243.40.0     - 83.243.47.255
	{ 0x53f33000, 0x53f337ff, REGISTRY_RIPENCC    }, // 83.243.48.0     - 83.243.55.255
	{ 0x53f33800, 0x53f33fff, REGISTRY_RIPENCC    }, // 83.243.56.0     - 83.243.63.255
	{ 0x53f34000, 0x53f34fff, REGISTRY_RIPENCC    }, // 83.243.64.0     - 83.243.79.255
	{ 0x53f35000, 0x53f35fff, REGISTRY_RIPENCC    }, // 83.243.80.0     - 83.243.95.255
	{ 0x53f36000, 0x53f377ff, REGISTRY_RIPENCC    }, // 83.243.96.0     - 83.243.119.255
	{ 0x53f37800, 0x5423ffff, REGISTRY_RIPENCC    }, // 83.243.120.0    - 84.35.255.255
	{ 0x54240000, 0x5424ffff, REGISTRY_AFRINIC    }, // 84.36.0.0       - 84.36.255.255
	{ 0x54250000, 0x5425ffff, REGISTRY_RIPENCC    }, // 84.37.0.0       - 84.37.255.255
	{ 0x54260000, 0x54261fff, REGISTRY_RIPENCC    }, // 84.38.0.0       - 84.38.31.255
	{ 0x54262000, 0x54262fff, REGISTRY_RIPENCC    }, // 84.38.32.0      - 84.38.47.255
	{ 0x54263000, 0x54265fff, REGISTRY_RIPENCC    }, // 84.38.48.0      - 84.38.95.255
	{ 0x54266000, 0x54266fff, REGISTRY_RIPENCC    }, // 84.38.96.0      - 84.38.111.255
	{ 0x54267000, 0x54267fff, REGISTRY_RIPENCC    }, // 84.38.112.0     - 84.38.127.255
	{ 0x54268000, 0x54269fff, REGISTRY_RIPENCC    }, // 84.38.128.0     - 84.38.159.255
	{ 0x5426a000, 0x5426afff, REGISTRY_RIPENCC    }, // 84.38.160.0     - 84.38.175.255
	{ 0x5426b000, 0x5426bfff, REGISTRY_RIPENCC    }, // 84.38.176.0     - 84.38.191.255
	{ 0x5426c000, 0x5426ffff, REGISTRY_RIPENCC    }, // 84.38.192.0     - 84.38.255.255
	{ 0x54270000, 0x54333fff, REGISTRY_RIPENCC    }, // 84.39.0.0       - 84.51.63.255
	{ 0x54334000, 0x54337fff, REGISTRY_RIPENCC    }, // 84.51.64.0      - 84.51.127.255
	{ 0x54338000, 0x54c9bfff, REGISTRY_RIPENCC    }, // 84.51.128.0     - 84.201.191.255
	{ 0x54c9c000, 0x54c9efff, REGISTRY_RIPENCC    }, // 84.201.192.0    - 84.201.239.255
	{ 0x54c9f000, 0x54ccffff, REGISTRY_RIPENCC    }, // 84.201.240.0    - 84.204.255.255
	{ 0x54cd0000, 0x54cd5fff, REGISTRY_RIPENCC    }, // 84.205.0.0      - 84.205.95.255
	{ 0x54cd6000, 0x54cd7fff, REGISTRY_AFRINIC    }, // 84.205.96.0     - 84.205.127.255
	{ 0x54cd8000, 0x54cdffff, REGISTRY_RIPENCC    }, // 84.205.128.0    - 84.205.255.255
	{ 0x54ce0000, 0x54e8ffff, REGISTRY_RIPENCC    }, // 84.206.0.0      - 84.232.255.255
	{ 0x54e90000, 0x54e97fff, REGISTRY_AFRINIC    }, // 84.233.0.0      - 84.233.127.255
	{ 0x54e98000, 0x54ea0fff, REGISTRY_RIPENCC    }, // 84.233.128.0    - 84.234.15.255
	{ 0x54ea1000, 0x54ea1fff, REGISTRY_RIPENCC    }, // 84.234.16.0     - 84.234.31.255
	{ 0x54ea2000, 0x54ea2fff, REGISTRY_RIPENCC    }, // 84.234.32.0     - 84.234.47.255
	{ 0x54ea3000, 0x54ea63ff, REGISTRY_RIPENCC    }, // 84.234.48.0     - 84.234.99.255
	{ 0x54ea6400, 0x54ea67ff, REGISTRY_RIPENCC    }, // 84.234.100.0    - 84.234.103.255
	{ 0x54ea6800, 0x54ea7fff, REGISTRY_RIPENCC    }, // 84.234.104.0    - 84.234.127.255
	{ 0x54ea8000, 0x551fdfff, REGISTRY_RIPENCC    }, // 84.234.128.0    - 85.31.223.255
	{ 0x551fe000, 0x551fefff, REGISTRY_RIPENCC    }, // 85.31.224.0     - 85.31.239.255
	{ 0x551ff000, 0x559e0bff, REGISTRY_RIPENCC    }, // 85.31.240.0     - 85.158.11.255
	{ 0x559e1000, 0x55bbffff, REGISTRY_RIPENCC    }, // 85.158.16.0     - 85.187.255.255
	{ 0x55bc0000, 0x55bcbfff, REGISTRY_RIPENCC    }, // 85.188.0.0      - 85.188.191.255
	{ 0x55bcc000, 0x55c9ffff, REGISTRY_RIPENCC    }, // 85.188.192.0    - 85.201.255.255
	{ 0x55ca0000, 0x55ca2fff, REGISTRY_RIPENCC    }, // 85.202.0.0      - 85.202.47.255
	{ 0x55ca3000, 0x55ca3fff, REGISTRY_RIPENCC    }, // 85.202.48.0     - 85.202.63.255
	{ 0x55ca4000, 0x55ca4fff, REGISTRY_RIPENCC    }, // 85.202.64.0     - 85.202.79.255
	{ 0x55ca5000, 0x55ca5fff, REGISTRY_RIPENCC    }, // 85.202.80.0     - 85.202.95.255
	{ 0x55ca6000, 0x55ca8fff, REGISTRY_RIPENCC    }, // 85.202.96.0     - 85.202.143.255
	{ 0x55ca9000, 0x55caafff, REGISTRY_RIPENCC    }, // 85.202.144.0    - 85.202.175.255
	{ 0x55cab000, 0x55cabfff, REGISTRY_RIPENCC    }, // 85.202.176.0    - 85.202.191.255
	{ 0x55cac000, 0x55cadfff, REGISTRY_RIPENCC    }, // 85.202.192.0    - 85.202.223.255
	{ 0x55cae000, 0x55caffff, REGISTRY_RIPENCC    }, // 85.202.224.0    - 85.202.255.255
	{ 0x55cb0000, 0x55feffff, REGISTRY_RIPENCC    }, // 85.203.0.0      - 85.254.255.255
	{ 0x55ff0000, 0x55ff4fff, REGISTRY_RIPENCC    }, // 85.255.0.0      - 85.255.79.255
	{ 0x55ff5000, 0x55ff5fff, REGISTRY_RIPENCC    }, // 85.255.80.0     - 85.255.95.255
	{ 0x55ff6000, 0x55ff6fff, REGISTRY_RIPENCC    }, // 85.255.96.0     - 85.255.111.255
	{ 0x55ff7000, 0x55ff7fff, REGISTRY_RIPENCC    }, // 85.255.112.0    - 85.255.127.255
	{ 0x55ff8000, 0x55ffafff, REGISTRY_RIPENCC    }, // 85.255.128.0    - 85.255.175.255
	{ 0x55ffb000, 0x55ffb7ff, REGISTRY_RIPENCC    }, // 85.255.176.0    - 85.255.183.255
	{ 0x55ffb800, 0x55ffffff, REGISTRY_RIPENCC    }, // 85.255.184.0    - 85.255.255.255
	{ 0x56000000, 0x566f3fff, REGISTRY_RIPENCC    }, // 86.0.0.0        - 86.111.63.255
	{ 0x566f4000, 0x566f7fff, REGISTRY_RIPENCC    }, // 86.111.64.0     - 86.111.127.255
	{ 0x566f8000, 0x566fbfff, REGISTRY_RIPENCC    }, // 86.111.128.0    - 86.111.191.255
	{ 0x566fc000, 0x566fcfff, REGISTRY_RIPENCC    }, // 86.111.192.0    - 86.111.207.255
	{ 0x566fd400, 0x566fd7ff, REGISTRY_RIPENCC    }, // 86.111.212.0    - 86.111.215.255
	{ 0x566fd800, 0x566fffff, REGISTRY_RIPENCC    }, // 86.111.216.0    - 86.111.255.255
	{ 0x56700000, 0x574bffff, REGISTRY_RIPENCC    }, // 86.112.0.0      - 87.75.255.255
	{ 0x574c0000, 0x574dffff, REGISTRY_RIPENCC    }, // 87.76.0.0       - 87.77.255.255
	{ 0x574e0000, 0x57635fff, REGISTRY_RIPENCC    }, // 87.78.0.0       - 87.99.95.255
	{ 0x57636000, 0x57637fff, REGISTRY_RIPENCC    }, // 87.99.96.0      - 87.99.127.255
	{ 0x57638000, 0x5764ffff, REGISTRY_RIPENCC    }, // 87.99.128.0     - 87.100.255.255
	{ 0x57650000, 0x57652fff, REGISTRY_RIPENCC    }, // 87.101.0.0      - 87.101.47.255
	{ 0x57653000, 0x57653fff, REGISTRY_RIPENCC    }, // 87.101.48.0     - 87.101.63.255
	{ 0x57654000, 0x57654fff, REGISTRY_RIPENCC    }, // 87.101.64.0     - 87.101.79.255
	{ 0x57655000, 0x57655fff, REGISTRY_RIPENCC    }, // 87.101.80.0     - 87.101.95.255
	{ 0x57656000, 0x57657fff, REGISTRY_RIPENCC    }, // 87.101.96.0     - 87.101.127.255
	{ 0x57658000, 0x57eeffff, REGISTRY_RIPENCC    }, // 87.101.128.0    - 87.238.255.255
	{ 0x57ef0000, 0x57ef2fff, REGISTRY_RIPENCC    }, // 87.239.0.0      - 87.239.47.255
	{ 0x57ef3000, 0x57ef3fff, REGISTRY_RIPENCC    }, // 87.239.48.0     - 87.239.63.255
	{ 0x57ef4000, 0x57ef47ff, REGISTRY_RIPENCC    }, // 87.239.64.0     - 87.239.71.255
	{ 0x57ef4800, 0x57ef4fff, REGISTRY_RIPENCC    }, // 87.239.72.0     - 87.239.79.255
	{ 0x57ef5000, 0x57ef9fff, REGISTRY_RIPENCC    }, // 87.239.80.0     - 87.239.159.255
	{ 0x57efa000, 0x57efa7ff, REGISTRY_RIPENCC    }, // 87.239.160.0    - 87.239.167.255
	{ 0x57efa800, 0x57efc7ff, REGISTRY_RIPENCC    }, // 87.239.168.0    - 87.239.199.255
	{ 0x57efc800, 0x57efcfff, REGISTRY_RIPENCC    }, // 87.239.200.0    - 87.239.207.255
	{ 0x57efd000, 0x57eff7ff, REGISTRY_RIPENCC    }, // 87.239.208.0    - 87.239.247.255
	{ 0x57eff800, 0x57f79fff, REGISTRY_RIPENCC    }, // 87.239.248.0    - 87.247.159.255
	{ 0x57f7a000, 0x57f7a7ff, REGISTRY_APNIC      }, // 87.247.160.0    - 87.247.167.255
	{ 0x57f7a800, 0x57ff5fff, REGISTRY_RIPENCC    }, // 87.247.168.0    - 87.255.95.255
	{ 0x57ff6000, 0x57ff7fff, REGISTRY_AFRINIC    }, // 87.255.96.0     - 87.255.127.255
	{ 0x57ff8000, 0x5886ffff, REGISTRY_RIPENCC    }, // 87.255.128.0    - 88.134.255.255
	{ 0x58870000, 0x588723ff, REGISTRY_RIPENCC    }, // 88.135.0.0      - 88.135.35.255
	{ 0x58872400, 0x588727ff, REGISTRY_RIPENCC    }, // 88.135.36.0     - 88.135.39.255
	{ 0x58872800, 0x58873fff, REGISTRY_RIPENCC    }, // 88.135.40.0     - 88.135.63.255
	{ 0x58874000, 0x58874fff, REGISTRY_RIPENCC    }, // 88.135.64.0     - 88.135.79.255
	{ 0x58875000, 0x5887ffff, REGISTRY_RIPENCC    }, // 88.135.80.0     - 88.135.255.255
	{ 0x58880000, 0x58c4ffff, REGISTRY_RIPENCC    }, // 88.136.0.0      - 88.196.255.255
	{ 0x58c50000, 0x58c5ffff, REGISTRY_RIPENCC    }, // 88.197.0.0      - 88.197.255.255
	{ 0x58c60000, 0x5915ffff, REGISTRY_RIPENCC    }, // 88.198.0.0      - 89.21.255.255
	{ 0x59160000, 0x59165fff, REGISTRY_RIPENCC    }, // 89.22.0.0       - 89.22.95.255
	{ 0x59166000, 0x59167fff, REGISTRY_RIPENCC    }, // 89.22.96.0      - 89.22.127.255
	{ 0x59168000, 0x5916dfff, REGISTRY_RIPENCC    }, // 89.22.128.0     - 89.22.223.255
	{ 0x5916e000, 0x5916efff, REGISTRY_RIPENCC    }, // 89.22.224.0     - 89.22.239.255
	{ 0x5916f000, 0x5917ffff, REGISTRY_RIPENCC    }, // 89.22.240.0     - 89.23.255.255
	{ 0x59180000, 0x59c88fff, REGISTRY_RIPENCC    }, // 89.24.0.0       - 89.200.143.255
	{ 0x59c89000, 0x59c897ff, REGISTRY_RIPENCC    }, // 89.200.144.0    - 89.200.151.255
	{ 0x59c89800, 0x59c89fff, REGISTRY_RIPENCC    }, // 89.200.152.0    - 89.200.159.255
	{ 0x59c8a000, 0x59c8a7ff, REGISTRY_RIPENCC    }, // 89.200.160.0    - 89.200.167.255
	{ 0x59c8a800, 0x59c8afff, REGISTRY_RIPENCC    }, // 89.200.168.0    - 89.200.175.255
	{ 0x59c8b000, 0x59c8d7ff, REGISTRY_RIPENCC    }, // 89.200.176.0    - 89.200.215.255
	{ 0x59c8d800, 0x59c8dfff, REGISTRY_RIPENCC    }, // 89.200.216.0    - 89.200.223.255
	{ 0x59c8e000, 0x59c8e7ff, REGISTRY_RIPENCC    }, // 89.200.224.0    - 89.200.231.255
	{ 0x59c8e800, 0x59c8efff, REGISTRY_RIPENCC    }, // 89.200.232.0    - 89.200.239.255
	{ 0x59c8f000, 0x59c8ffff, REGISTRY_RIPENCC    }, // 89.200.240.0    - 89.200.255.255
	{ 0x59c90000, 0x59cdffff, REGISTRY_RIPENCC    }, // 89.201.0.0      - 89.205.255.255
	{ 0x59ce0000, 0x59ce7fff, REGISTRY_RIPENCC    }, // 89.206.0.0      - 89.206.127.255
	{ 0x59ce8000, 0x59d0efff, REGISTRY_RIPENCC    }, // 89.206.128.0    - 89.208.239.255
	{ 0x59d0f000, 0x59d0ffff, REGISTRY_ARIN       }, // 89.208.240.0    - 89.208.255.255
	{ 0x59d10000, 0x59ef2fff, REGISTRY_RIPENCC    }, // 89.209.0.0      - 89.239.47.255
	{ 0x59ef3000, 0x59ef3fff, REGISTRY_ARIN       }, // 89.239.48.0     - 89.239.63.255
	{ 0x59ef4000, 0x59faffff, REGISTRY_RIPENCC    }, // 89.239.64.0     - 89.250.255.255
	{ 0x59fb1000, 0x5b59ffff, REGISTRY_RIPENCC    }, // 89.251.16.0     - 91.89.255.255
	{ 0x5b5a0000, 0x5b5a27ff, REGISTRY_RIPENCC    }, // 91.90.0.0       - 91.90.39.255
	{ 0x5b5a2800, 0x5b5a2fff, REGISTRY_RIPENCC    }, // 91.90.40.0      - 91.90.47.255
	{ 0x5b5a3000, 0x5b5a4fff, REGISTRY_RIPENCC    }, // 91.90.48.0      - 91.90.79.255
	{ 0x5b5a5000, 0x5b5a57ff, REGISTRY_RIPENCC    }, // 91.90.80.0      - 91.90.87.255
	{ 0x5b5a5800, 0x5b5a5fff, REGISTRY_RIPENCC    }, // 91.90.88.0      - 91.90.95.255
	{ 0x5b5a6000, 0x5b5a67ff, REGISTRY_RIPENCC    }, // 91.90.96.0      - 91.90.103.255
	{ 0x5b5a6800, 0x5b5adfff, REGISTRY_RIPENCC    }, // 91.90.104.0     - 91.90.223.255
	{ 0x5b5ae000, 0x5b6adbff, REGISTRY_RIPENCC    }, // 91.90.224.0     - 91.106.219.255
	{ 0x5b6ae000, 0x5b7affff, REGISTRY_RIPENCC    }, // 91.106.224.0    - 91.122.255.255
	{ 0x5b7b0000, 0x5b7b3fff, REGISTRY_RIPENCC    }, // 91.123.0.0      - 91.123.63.255
	{ 0x5b7b4000, 0x5b7b4fff, REGISTRY_RIPENCC    }, // 91.123.64.0     - 91.123.79.255
	{ 0x5b7b5000, 0x5b7bffff, REGISTRY_RIPENCC    }, // 91.123.80.0     - 91.123.255.255
	{ 0x5b7c0000, 0x5b8e7fff, REGISTRY_RIPENCC    }, // 91.124.0.0      - 91.142.127.255
	{ 0x5b8e8000, 0x5b8e84ff, REGISTRY_RIPENCC    }, // 91.142.128.0    - 91.142.132.255
	{ 0x5b8e8600, 0x5b8e8bff, REGISTRY_RIPENCC    }, // 91.142.134.0    - 91.142.139.255
	{ 0x5b8e8d00, 0x5b8e8fff, REGISTRY_RIPENCC    }, // 91.142.141.0    - 91.142.143.255
	{ 0x5b8e9000, 0x5b96bfff, REGISTRY_RIPENCC    }, // 91.142.144.0    - 91.150.191.255
	{ 0x5b96c000, 0x5b96ffff, REGISTRY_RIPENCC    }, // 91.150.192.0    - 91.150.255.255
	{ 0x5b970000, 0x5bbcffff, REGISTRY_RIPENCC    }, // 91.151.0.0      - 91.188.255.255
	{ 0x5bbd0000, 0x5bbdb7ff, REGISTRY_RIPENCC    }, // 91.189.0.0      - 91.189.183.255
	{ 0x5bbdb800, 0x5bbdbfff, REGISTRY_RIPENCC    }, // 91.189.184.0    - 91.189.191.255
	{ 0x5bbdc000, 0x5bbdcfff, REGISTRY_RIPENCC    }, // 91.189.192.0    - 91.189.207.255
	{ 0x5bbdd000, 0x5bbde7ff, REGISTRY_RIPENCC    }, // 91.189.208.0    - 91.189.231.255
	{ 0x5bbde800, 0x5bbdffff, REGISTRY_RIPENCC    }, // 91.189.232.0    - 91.189.255.255
	{ 0x5bbe0000, 0x5bbfffff, REGISTRY_RIPENCC    }, // 91.190.0.0      - 91.191.255.255
	{ 0x5bc00000, 0x5bc003ff, REGISTRY_RIPENCC    }, // 91.192.0.0      - 91.192.3.255
	{ 0x5bc00400, 0x5bc00bff, REGISTRY_RIPENCC    }, // 91.192.4.0      - 91.192.11.255
	{ 0x5bc00c00, 0x5bc017ff, REGISTRY_RIPENCC    }, // 91.192.12.0     - 91.192.23.255
	{ 0x5bc01800, 0x5bc01bff, REGISTRY_RIPENCC    }, // 91.192.24.0     - 91.192.27.255
	{ 0x5bc01c00, 0x5bc023ff, REGISTRY_RIPENCC    }, // 91.192.28.0     - 91.192.35.255
	{ 0x5bc02400, 0x5bc027ff, REGISTRY_RIPENCC    }, // 91.192.36.0     - 91.192.39.255
	{ 0x5bc02800, 0x5bc02fff, REGISTRY_RIPENCC    }, // 91.192.40.0     - 91.192.47.255
	{ 0x5bc03400, 0x5bc04fff, REGISTRY_RIPENCC    }, // 91.192.52.0     - 91.192.79.255
	{ 0x5bc05000, 0x5bc057ff, REGISTRY_RIPENCC    }, // 91.192.80.0     - 91.192.87.255
	{ 0x5bc05800, 0x5bc063ff, REGISTRY_RIPENCC    }, // 91.192.88.0     - 91.192.99.255
	{ 0x5bc06400, 0x5bc067ff, REGISTRY_RIPENCC    }, // 91.192.100.0    - 91.192.103.255
	{ 0x5bc06800, 0x5bc069ff, REGISTRY_RIPENCC    }, // 91.192.104.0    - 91.192.105.255
	{ 0x5bc06c00, 0x5bc06fff, REGISTRY_RIPENCC    }, // 91.192.108.0    - 91.192.111.255
	{ 0x5bc07000, 0x5bc0afff, REGISTRY_RIPENCC    }, // 91.192.112.0    - 91.192.175.255
	{ 0x5bc0b000, 0x5bc0b3ff, REGISTRY_RIPENCC    }, // 91.192.176.0    - 91.192.179.255
	{ 0x5bc0b400, 0x5bc0c9ff, REGISTRY_RIPENCC    }, // 91.192.180.0    - 91.192.201.255
	{ 0x5bc0ca00, 0x5bc0cbff, REGISTRY_RIPENCC    }, // 91.192.202.0    - 91.192.203.255
	{ 0x5bc0cc00, 0x5bc103ff, REGISTRY_RIPENCC    }, // 91.192.204.0    - 91.193.3.255
	{ 0x5bc10400, 0x5bc107ff, REGISTRY_RIPENCC    }, // 91.193.4.0      - 91.193.7.255
	{ 0x5bc10800, 0x5bc10fff, REGISTRY_RIPENCC    }, // 91.193.8.0      - 91.193.15.255
	{ 0x5bc11000, 0x5bc113ff, REGISTRY_RIPENCC    }, // 91.193.16.0     - 91.193.19.255
	{ 0x5bc11400, 0x5bc11bff, REGISTRY_RIPENCC    }, // 91.193.20.0     - 91.193.27.255
	{ 0x5bc11c00, 0x5bc11fff, REGISTRY_RIPENCC    }, // 91.193.28.0     - 91.193.31.255
	{ 0x5bc12000, 0x5bc139ff, REGISTRY_RIPENCC    }, // 91.193.32.0     - 91.193.57.255
	{ 0x5bc13c00, 0x5bc13fff, REGISTRY_RIPENCC    }, // 91.193.60.0     - 91.193.63.255
	{ 0x5bc14000, 0x5bc149ff, REGISTRY_RIPENCC    }, // 91.193.64.0     - 91.193.73.255
	{ 0x5bc14b00, 0x5bc163ff, REGISTRY_RIPENCC    }, // 91.193.75.0     - 91.193.99.255
	{ 0x5bc16400, 0x5bc167ff, REGISTRY_RIPENCC    }, // 91.193.100.0    - 91.193.103.255
	{ 0x5bc16800, 0x5bc16fff, REGISTRY_RIPENCC    }, // 91.193.104.0    - 91.193.111.255
	{ 0x5bc17000, 0x5bc177ff, REGISTRY_RIPENCC    }, // 91.193.112.0    - 91.193.119.255
	{ 0x5bc17800, 0x5bc197ff, REGISTRY_RIPENCC    }, // 91.193.120.0    - 91.193.151.255
	{ 0x5bc19800, 0x5bc19bff, REGISTRY_RIPENCC    }, // 91.193.152.0    - 91.193.155.255
	{ 0x5bc19c00, 0x5bc1b3ff, REGISTRY_RIPENCC    }, // 91.193.156.0    - 91.193.179.255
	{ 0x5bc1b400, 0x5bc1b7ff, REGISTRY_RIPENCC    }, // 91.193.180.0    - 91.193.183.255
	{ 0x5bc1b800, 0x5bc1bfff, REGISTRY_RIPENCC    }, // 91.193.184.0    - 91.193.191.255
	{ 0x5bc1c000, 0x5bc1c3ff, REGISTRY_RIPENCC    }, // 91.193.192.0    - 91.193.195.255
	{ 0x5bc1c400, 0x5bc1f7ff, REGISTRY_RIPENCC    }, // 91.193.196.0    - 91.193.247.255
	{ 0x5bc1f800, 0x5bc1fbff, REGISTRY_RIPENCC    }, // 91.193.248.0    - 91.193.251.255
	{ 0x5bc1fc00, 0x5bc1ffff, REGISTRY_RIPENCC    }, // 91.193.252.0    - 91.193.255.255
	{ 0x5bc20200, 0x5bc207ff, REGISTRY_RIPENCC    }, // 91.194.2.0      - 91.194.7.255
	{ 0x5bc20800, 0x5bc209ff, REGISTRY_RIPENCC    }, // 91.194.8.0      - 91.194.9.255
	{ 0x5bc20a00, 0x5bc20dff, REGISTRY_RIPENCC    }, // 91.194.10.0     - 91.194.13.255
	{ 0x5bc21000, 0x5bc217ff, REGISTRY_RIPENCC    }, // 91.194.16.0     - 91.194.23.255
	{ 0x5bc21a00, 0x5bc233ff, REGISTRY_RIPENCC    }, // 91.194.26.0     - 91.194.51.255
	{ 0x5bc23400, 0x5bc237ff, REGISTRY_RIPENCC    }, // 91.194.52.0     - 91.194.55.255
	{ 0x5bc23800, 0x5bc255ff, REGISTRY_RIPENCC    }, // 91.194.56.0     - 91.194.85.255
	{ 0x5bc25600, 0x5bc257ff, REGISTRY_RIPENCC    }, // 91.194.86.0     - 91.194.87.255
	{ 0x5bc25800, 0x5bc259ff, REGISTRY_RIPENCC    }, // 91.194.88.0     - 91.194.89.255
	{ 0x5bc25a00, 0x5bc25bff, REGISTRY_RIPENCC    }, // 91.194.90.0     - 91.194.91.255
	{ 0x5bc25c00, 0x5bc267ff, REGISTRY_RIPENCC    }, // 91.194.92.0     - 91.194.103.255
	{ 0x5bc26a00, 0x5bc275ff, REGISTRY_RIPENCC    }, // 91.194.106.0    - 91.194.117.255
	{ 0x5bc27800, 0x5bc27bff, REGISTRY_RIPENCC    }, // 91.194.120.0    - 91.194.123.255
	{ 0x5bc27e00, 0x5bc28bff, REGISTRY_RIPENCC    }, // 91.194.126.0    - 91.194.139.255
	{ 0x5bc28e00, 0x5bc295ff, REGISTRY_RIPENCC    }, // 91.194.142.0    - 91.194.149.255
	{ 0x5bc29600, 0x5bc297ff, REGISTRY_RIPENCC    }, // 91.194.150.0    - 91.194.151.255
	{ 0x5bc29800, 0x5bc2a3ff, REGISTRY_RIPENCC    }, // 91.194.152.0    - 91.194.163.255
	{ 0x5bc2a400, 0x5bc2a5ff, REGISTRY_RIPENCC    }, // 91.194.164.0    - 91.194.165.255
	{ 0x5bc2a800, 0x5bc2a9ff, REGISTRY_RIPENCC    }, // 91.194.168.0    - 91.194.169.255
	{ 0x5bc2ac00, 0x5bc2b5ff, REGISTRY_RIPENCC    }, // 91.194.172.0    - 91.194.181.255
	{ 0x5bc2b800, 0x5bc2bfff, REGISTRY_RIPENCC    }, // 91.194.184.0    - 91.194.191.255
	{ 0x5bc2c000, 0x5bc2c3ff, REGISTRY_RIPENCC    }, // 91.194.192.0    - 91.194.195.255
	{ 0x5bc2c400, 0x5bc2d5ff, REGISTRY_RIPENCC    }, // 91.194.196.0    - 91.194.213.255
	{ 0x5bc2d800, 0x5bc2e9ff, REGISTRY_RIPENCC    }, // 91.194.216.0    - 91.194.233.255
	{ 0x5bc2ea00, 0x5bc2eaff, REGISTRY_RIPENCC    }, // 91.194.234.0    - 91.194.234.255
	{ 0x5bc2eb00, 0x5bc2efff, REGISTRY_RIPENCC    }, // 91.194.235.0    - 91.194.239.255
	{ 0x5bc2f200, 0x5bc2f7ff, REGISTRY_RIPENCC    }, // 91.194.242.0    - 91.194.247.255
	{ 0x5bc2f800, 0x5bc2f9ff, REGISTRY_RIPENCC    }, // 91.194.248.0    - 91.194.249.255
	{ 0x5bc2fa00, 0x5bc2fdff, REGISTRY_RIPENCC    }, // 91.194.250.0    - 91.194.253.255
	{ 0x5bc30000, 0x5bc30bff, REGISTRY_RIPENCC    }, // 91.195.0.0      - 91.195.11.255
	{ 0x5bc30c00, 0x5bc30dff, REGISTRY_RIPENCC    }, // 91.195.12.0     - 91.195.13.255
	{ 0x5bc30e00, 0x5bc331ff, REGISTRY_RIPENCC    }, // 91.195.14.0     - 91.195.49.255
	{ 0x5bc33400, 0x5bc33fff, REGISTRY_RIPENCC    }, // 91.195.52.0     - 91.195.63.255
	{ 0x5bc34000, 0x5bc343ff, REGISTRY_RIPENCC    }, // 91.195.64.0     - 91.195.67.255
	{ 0x5bc34400, 0x5bc347ff, REGISTRY_RIPENCC    }, // 91.195.68.0     - 91.195.71.255
	{ 0x5bc34a00, 0x5bc365ff, REGISTRY_RIPENCC    }, // 91.195.74.0     - 91.195.101.255
	{ 0x5bc36800, 0x5bc391ff, REGISTRY_RIPENCC    }, // 91.195.104.0    - 91.195.145.255
	{ 0x5bc39200, 0x5bc393ff, REGISTRY_RIPENCC    }, // 91.195.146.0    - 91.195.147.255
	{ 0x5bc39400, 0x5bc3abff, REGISTRY_RIPENCC    }, // 91.195.148.0    - 91.195.171.255
	{ 0x5bc3ac00, 0x5bc3adff, REGISTRY_RIPENCC    }, // 91.195.172.0    - 91.195.173.255
	{ 0x5bc3b000, 0x5bc3cfff, REGISTRY_RIPENCC    }, // 91.195.176.0    - 91.195.207.255
	{ 0x5bc3d200, 0x5bc3d3ff, REGISTRY_RIPENCC    }, // 91.195.210.0    - 91.195.211.255
	{ 0x5bc3d600, 0x5bc3ddff, REGISTRY_RIPENCC    }, // 91.195.214.0    - 91.195.221.255
	{ 0x5bc3e000, 0x5bc3fdff, REGISTRY_RIPENCC    }, // 91.195.224.0    - 91.195.253.255
	{ 0x5bc40000, 0x5bc403ff, REGISTRY_RIPENCC    }, // 91.196.0.0      - 91.196.3.255
	{ 0x5bc40400, 0x5bc407ff, REGISTRY_RIPENCC    }, // 91.196.4.0      - 91.196.7.255
	{ 0x5bc40800, 0x5bc40fff, REGISTRY_RIPENCC    }, // 91.196.8.0      - 91.196.15.255
	{ 0x5bc41000, 0x5bc41fff, REGISTRY_RIPENCC    }, // 91.196.16.0     - 91.196.31.255
	{ 0x5bc42000, 0x5bc427ff, REGISTRY_RIPENCC    }, // 91.196.32.0     - 91.196.39.255
	{ 0x5bc42800, 0x5bc42bff, REGISTRY_RIPENCC    }, // 91.196.40.0     - 91.196.43.255
	{ 0x5bc42c00, 0x5bc43fff, REGISTRY_RIPENCC    }, // 91.196.44.0     - 91.196.63.255
	{ 0x5bc44000, 0x5bc44bff, REGISTRY_RIPENCC    }, // 91.196.64.0     - 91.196.75.255
	{ 0x5bc44c00, 0x5bc487ff, REGISTRY_RIPENCC    }, // 91.196.76.0     - 91.196.135.255
	{ 0x5bc48800, 0x5bc48fff, REGISTRY_RIPENCC    }, // 91.196.136.0    - 91.196.143.255
	{ 0x5bc49000, 0x5bc4b3ff, REGISTRY_RIPENCC    }, // 91.196.144.0    - 91.196.179.255
	{ 0x5bc4b400, 0x5bc4bfff, REGISTRY_RIPENCC    }, // 91.196.180.0    - 91.196.191.255
	{ 0x5bc4c000, 0x5bc4c7ff, REGISTRY_RIPENCC    }, // 91.196.192.0    - 91.196.199.255
	{ 0x5bc4c800, 0x5bc4cbff, REGISTRY_RIPENCC    }, // 91.196.200.0    - 91.196.203.255
	{ 0x5bc4cc00, 0x5bc4cfff, REGISTRY_RIPENCC    }, // 91.196.204.0    - 91.196.207.255
	{ 0x5bc4d000, 0x5bc4d3ff, REGISTRY_RIPENCC    }, // 91.196.208.0    - 91.196.211.255
	{ 0x5bc4d400, 0x5bc4d7ff, REGISTRY_RIPENCC    }, // 91.196.212.0    - 91.196.215.255
	{ 0x5bc4d800, 0x5bc4dfff, REGISTRY_RIPENCC    }, // 91.196.216.0    - 91.196.223.255
	{ 0x5bc4e000, 0x5bc4e7ff, REGISTRY_RIPENCC    }, // 91.196.224.0    - 91.196.231.255
	{ 0x5bc4e800, 0x5bc4ebff, REGISTRY_RIPENCC    }, // 91.196.232.0    - 91.196.235.255
	{ 0x5bc4ec00, 0x5bc4ffff, REGISTRY_RIPENCC    }, // 91.196.236.0    - 91.196.255.255
	{ 0x5bc50000, 0x5bc503ff, REGISTRY_RIPENCC    }, // 91.197.0.0      - 91.197.3.255
	{ 0x5bc50400, 0x5bc523ff, REGISTRY_RIPENCC    }, // 91.197.4.0      - 91.197.35.255
	{ 0x5bc52400, 0x5bc52bff, REGISTRY_RIPENCC    }, // 91.197.36.0     - 91.197.43.255
	{ 0x5bc52c00, 0x5bc52dff, REGISTRY_RIPENCC    }, // 91.197.44.0     - 91.197.45.255
	{ 0x5bc52e00, 0x5bc52fff, REGISTRY_RIPENCC    }, // 91.197.46.0     - 91.197.47.255
	{ 0x5bc53000, 0x5bc543ff, REGISTRY_RIPENCC    }, // 91.197.48.0     - 91.197.67.255
	{ 0x5bc54400, 0x5bc547ff, REGISTRY_RIPENCC    }, // 91.197.68.0     - 91.197.71.255
	{ 0x5bc54800, 0x5bc577ff, REGISTRY_RIPENCC    }, // 91.197.72.0     - 91.197.119.255
	{ 0x5bc57800, 0x5bc57bff, REGISTRY_RIPENCC    }, // 91.197.120.0    - 91.197.123.255
	{ 0x5bc57c00, 0x5bc5c3ff, REGISTRY_RIPENCC    }, // 91.197.124.0    - 91.197.195.255
	{ 0x5bc5c400, 0x5bc5cbff, REGISTRY_RIPENCC    }, // 91.197.196.0    - 91.197.203.255
	{ 0x5bc5cc00, 0x5bc5e7ff, REGISTRY_RIPENCC    }, // 91.197.204.0    - 91.197.231.255
	{ 0x5bc5e800, 0x5bc5ebff, REGISTRY_RIPENCC    }, // 91.197.232.0    - 91.197.235.255
	{ 0x5bc5ec00, 0x5bc5efff, REGISTRY_RIPENCC    }, // 91.197.236.0    - 91.197.239.255
	{ 0x5bc5f000, 0x5bc5f3ff, REGISTRY_RIPENCC    }, // 91.197.240.0    - 91.197.243.255
	{ 0x5bc5f400, 0x5bc5f7ff, REGISTRY_RIPENCC    }, // 91.197.244.0    - 91.197.247.255
	{ 0x5bc5f800, 0x5bc5fbff, REGISTRY_RIPENCC    }, // 91.197.248.0    - 91.197.251.255
	{ 0x5bc5fc00, 0x5bc61bff, REGISTRY_RIPENCC    }, // 91.197.252.0    - 91.198.27.255
	{ 0x5bc61d00, 0x5bc61fff, REGISTRY_RIPENCC    }, // 91.198.29.0     - 91.198.31.255
	{ 0x5bc62000, 0x5bc620ff, REGISTRY_RIPENCC    }, // 91.198.32.0     - 91.198.32.255
	{ 0x5bc62100, 0x5bc624ff, REGISTRY_RIPENCC    }, // 91.198.33.0     - 91.198.36.255
	{ 0x5bc62600, 0x5bc628ff, REGISTRY_RIPENCC    }, // 91.198.38.0     - 91.198.40.255
	{ 0x5bc62a00, 0x5bc62fff, REGISTRY_RIPENCC    }, // 91.198.42.0     - 91.198.47.255
	{ 0x5bc63100, 0x5bc640ff, REGISTRY_RIPENCC    }, // 91.198.49.0     - 91.198.64.255
	{ 0x5bc64300, 0x5bc64cff, REGISTRY_RIPENCC    }, // 91.198.67.0     - 91.198.76.255
	{ 0x5bc64e00, 0x5bc660ff, REGISTRY_RIPENCC    }, // 91.198.78.0     - 91.198.96.255
	{ 0x5bc66100, 0x5bc661ff, REGISTRY_RIPENCC    }, // 91.198.97.0     - 91.198.97.255
	{ 0x5bc66200, 0x5bc66bff, REGISTRY_RIPENCC    }, // 91.198.98.0     - 91.198.107.255
	{ 0x5bc66e00, 0x5bc672ff, REGISTRY_RIPENCC    }, // 91.198.110.0    - 91.198.114.255
	{ 0x5bc67400, 0x5bc67aff, REGISTRY_RIPENCC    }, // 91.198.116.0    - 91.198.122.255
	{ 0x5bc67c00, 0x5bc684ff, REGISTRY_RIPENCC    }, // 91.198.124.0    - 91.198.132.255
	{ 0x5bc68500, 0x5bc685ff, REGISTRY_RIPENCC    }, // 91.198.133.0    - 91.198.133.255
	{ 0x5bc68600, 0x5bc68cff, REGISTRY_RIPENCC    }, // 91.198.134.0    - 91.198.140.255
	{ 0x5bc68e00, 0x5bc692ff, REGISTRY_RIPENCC    }, // 91.198.142.0    - 91.198.146.255
	{ 0x5bc69400, 0x5bc69dff, REGISTRY_RIPENCC    }, // 91.198.148.0    - 91.198.157.255
	{ 0x5bc69f00, 0x5bc6a6ff, REGISTRY_RIPENCC    }, // 91.198.159.0    - 91.198.166.255
	{ 0x5bc6a800, 0x5bc6a9ff, REGISTRY_RIPENCC    }, // 91.198.168.0    - 91.198.169.255
	{ 0x5bc6ad00, 0x5bc6b8ff, REGISTRY_RIPENCC    }, // 91.198.173.0    - 91.198.184.255
	{ 0x5bc6ba00, 0x5bc6bfff, REGISTRY_RIPENCC    }, // 91.198.186.0    - 91.198.191.255
	{ 0x5bc6c100, 0x5bc6c3ff, REGISTRY_RIPENCC    }, // 91.198.193.0    - 91.198.195.255
	{ 0x5bc6c500, 0x5bc6cfff, REGISTRY_RIPENCC    }, // 91.198.197.0    - 91.198.207.255
	{ 0x5bc6d100, 0x5bc6d1ff, REGISTRY_RIPENCC    }, // 91.198.209.0    - 91.198.209.255
	{ 0x5bc6d300, 0x5bc6d6ff, REGISTRY_RIPENCC    }, // 91.198.211.0    - 91.198.214.255
	{ 0x5bc6d800, 0x5bc6d9ff, REGISTRY_RIPENCC    }, // 91.198.216.0    - 91.198.217.255
	{ 0x5bc6db00, 0x5bc6dbff, REGISTRY_RIPENCC    }, // 91.198.219.0    - 91.198.219.255
	{ 0x5bc6dd00, 0x5bc6e5ff, REGISTRY_RIPENCC    }, // 91.198.221.0    - 91.198.229.255
	{ 0x5bc6e700, 0x5bc6f3ff, REGISTRY_RIPENCC    }, // 91.198.231.0    - 91.198.243.255
	{ 0x5bc6f400, 0x5bc6f4ff, REGISTRY_RIPENCC    }, // 91.198.244.0    - 91.198.244.255
	{ 0x5bc6f500, 0x5bc6fdff, REGISTRY_RIPENCC    }, // 91.198.245.0    - 91.198.253.255
	{ 0x5bc6ff00, 0x5bc702ff, REGISTRY_RIPENCC    }, // 91.198.255.0    - 91.199.2.255
	{ 0x5bc70400, 0x5bc708ff, REGISTRY_RIPENCC    }, // 91.199.4.0      - 91.199.8.255
	{ 0x5bc70a00, 0x5bc711ff, REGISTRY_RIPENCC    }, // 91.199.10.0     - 91.199.17.255
	{ 0x5bc71300, 0x5bc71aff, REGISTRY_RIPENCC    }, // 91.199.19.0     - 91.199.26.255
	{ 0x5bc71c00, 0x5bc71dff, REGISTRY_RIPENCC    }, // 91.199.28.0     - 91.199.29.255
	{ 0x5bc71f00, 0x5bc71fff, REGISTRY_RIPENCC    }, // 91.199.31.0     - 91.199.31.255
	{ 0x5bc72100, 0x5bc729ff, REGISTRY_RIPENCC    }, // 91.199.33.0     - 91.199.41.255
	{ 0x5bc72b00, 0x5bc72bff, REGISTRY_RIPENCC    }, // 91.199.43.0     - 91.199.43.255
	{ 0x5bc72d00, 0x5bc72eff, REGISTRY_RIPENCC    }, // 91.199.45.0     - 91.199.46.255
	{ 0x5bc73000, 0x5bc750ff, REGISTRY_RIPENCC    }, // 91.199.48.0     - 91.199.80.255
	{ 0x5bc75300, 0x5bc753ff, REGISTRY_RIPENCC    }, // 91.199.83.0     - 91.199.83.255
	{ 0x5bc75500, 0x5bc756ff, REGISTRY_RIPENCC    }, // 91.199.85.0     - 91.199.86.255
	{ 0x5bc75800, 0x5bc759ff, REGISTRY_RIPENCC    }, // 91.199.88.0     - 91.199.89.255
	{ 0x5bc75b00, 0x5bc765ff, REGISTRY_RIPENCC    }, // 91.199.91.0     - 91.199.101.255
	{ 0x5bc76700, 0x5bc76bff, REGISTRY_RIPENCC    }, // 91.199.103.0    - 91.199.107.255
	{ 0x5bc76d00, 0x5bc77aff, REGISTRY_RIPENCC    }, // 91.199.109.0    - 91.199.122.255
	{ 0x5bc77c00, 0x5bc788ff, REGISTRY_RIPENCC    }, // 91.199.124.0    - 91.199.136.255
	{ 0x5bc78a00, 0x5bc792ff, REGISTRY_RIPENCC    }, // 91.199.138.0    - 91.199.146.255
	{ 0x5bc79400, 0x5bc799ff, REGISTRY_RIPENCC    }, // 91.199.148.0    - 91.199.153.255
	{ 0x5bc79b00, 0x5bc79fff, REGISTRY_RIPENCC    }, // 91.199.155.0    - 91.199.159.255
	{ 0x5bc7a100, 0x5bc7a2ff, REGISTRY_RIPENCC    }, // 91.199.161.0    - 91.199.162.255
	{ 0x5bc7a400, 0x5bc7a5ff, REGISTRY_RIPENCC    }, // 91.199.164.0    - 91.199.165.255
	{ 0x5bc7a700, 0x5bc7a7ff, REGISTRY_RIPENCC    }, // 91.199.167.0    - 91.199.167.255
	{ 0x5bc7a900, 0x5bc7abff, REGISTRY_RIPENCC    }, // 91.199.169.0    - 91.199.171.255
	{ 0x5bc7ad00, 0x5bc7b2ff, REGISTRY_RIPENCC    }, // 91.199.173.0    - 91.199.178.255
	{ 0x5bc7b400, 0x5bc7b5ff, REGISTRY_RIPENCC    }, // 91.199.180.0    - 91.199.181.255
	{ 0x5bc7b700, 0x5bc7b7ff, REGISTRY_RIPENCC    }, // 91.199.183.0    - 91.199.183.255
	{ 0x5bc7ba00, 0x5bc7c0ff, REGISTRY_RIPENCC    }, // 91.199.186.0    - 91.199.192.255
	{ 0x5bc7c200, 0x5bc7d0ff, REGISTRY_RIPENCC    }, // 91.199.194.0    - 91.199.208.255
	{ 0x5bc7d200, 0x5bc7d2ff, REGISTRY_RIPENCC    }, // 91.199.210.0    - 91.199.210.255
	{ 0x5bc7d400, 0x5bc7deff, REGISTRY_RIPENCC    }, // 91.199.212.0    - 91.199.222.255
	{ 0x5bc7e000, 0x5bc7f7ff, REGISTRY_RIPENCC    }, // 91.199.224.0    - 91.199.247.255
	{ 0x5bc7f900, 0x5bc81fff, REGISTRY_RIPENCC    }, // 91.199.249.0    - 91.200.31.255
	{ 0x5bc82000, 0x5bc823ff, REGISTRY_RIPENCC    }, // 91.200.32.0     - 91.200.35.255
	{ 0x5bc82400, 0x5bc84fff, REGISTRY_RIPENCC    }, // 91.200.36.0     - 91.200.79.255
	{ 0x5bc85000, 0x5bc853ff, REGISTRY_RIPENCC    }, // 91.200.80.0     - 91.200.83.255
	{ 0x5bc85400, 0x5bc857ff, REGISTRY_RIPENCC    }, // 91.200.84.0     - 91.200.87.255
	{ 0x5bc85800, 0x5bc85bff, REGISTRY_RIPENCC    }, // 91.200.88.0     - 91.200.91.255
	{ 0x5bc85c00, 0x5bc863ff, REGISTRY_RIPENCC    }, // 91.200.92.0     - 91.200.99.255
	{ 0x5bc86400, 0x5bc867ff, REGISTRY_RIPENCC    }, // 91.200.100.0    - 91.200.103.255
	{ 0x5bc86800, 0x5bc86bff, REGISTRY_RIPENCC    }, // 91.200.104.0    - 91.200.107.255
	{ 0x5bc86c00, 0x5bc86fff, REGISTRY_RIPENCC    }, // 91.200.108.0    - 91.200.111.255
	{ 0x5bc87000, 0x5bc87fff, REGISTRY_RIPENCC    }, // 91.200.112.0    - 91.200.127.255
	{ 0x5bc88000, 0x5bc887ff, REGISTRY_RIPENCC    }, // 91.200.128.0    - 91.200.135.255
	{ 0x5bc88800, 0x5bc893ff, REGISTRY_RIPENCC    }, // 91.200.136.0    - 91.200.147.255
	{ 0x5bc89400, 0x5bc897ff, REGISTRY_RIPENCC    }, // 91.200.148.0    - 91.200.151.255
	{ 0x5bc89800, 0x5bc8a7ff, REGISTRY_RIPENCC    }, // 91.200.152.0    - 91.200.167.255
	{ 0x5bc8a800, 0x5bc8abff, REGISTRY_RIPENCC    }, // 91.200.168.0    - 91.200.171.255
	{ 0x5bc8ac00, 0x5bc8afff, REGISTRY_RIPENCC    }, // 91.200.172.0    - 91.200.175.255
	{ 0x5bc8b000, 0x5bc8b3ff, REGISTRY_RIPENCC    }, // 91.200.176.0    - 91.200.179.255
	{ 0x5bc8b400, 0x5bc8bbff, REGISTRY_RIPENCC    }, // 91.200.180.0    - 91.200.187.255
	{ 0x5bc8bc00, 0x5bc8bfff, REGISTRY_RIPENCC    }, // 91.200.188.0    - 91.200.191.255
	{ 0x5bc8c400, 0x5bc8d3ff, REGISTRY_RIPENCC    }, // 91.200.196.0    - 91.200.211.255
	{ 0x5bc8d400, 0x5bc8d7ff, REGISTRY_RIPENCC    }, // 91.200.212.0    - 91.200.215.255
	{ 0x5bc8d800, 0x5bc8efff, REGISTRY_RIPENCC    }, // 91.200.216.0    - 91.200.239.255
	{ 0x5bc8f000, 0x5bc8f7ff, REGISTRY_RIPENCC    }, // 91.200.240.0    - 91.200.247.255
	{ 0x5bc8f800, 0x5bc8fbff, REGISTRY_RIPENCC    }, // 91.200.248.0    - 91.200.251.255
	{ 0x5bc8fc00, 0x5bc8ffff, REGISTRY_RIPENCC    }, // 91.200.252.0    - 91.200.255.255
	{ 0x5bc90000, 0x5bc903ff, REGISTRY_RIPENCC    }, // 91.201.0.0      - 91.201.3.255
	{ 0x5bc90800, 0x5bc913ff, REGISTRY_RIPENCC    }, // 91.201.8.0      - 91.201.19.255
	{ 0x5bc91400, 0x5bc917ff, REGISTRY_RIPENCC    }, // 91.201.20.0     - 91.201.23.255
	{ 0x5bc91800, 0x5bc918ff, REGISTRY_RIPENCC    }, // 91.201.24.0     - 91.201.24.255
	{ 0x5bc91900, 0x5bc919ff, REGISTRY_RIPENCC    }, // 91.201.25.0     - 91.201.25.255
	{ 0x5bc91a00, 0x5bc91bff, REGISTRY_RIPENCC    }, // 91.201.26.0     - 91.201.27.255
	{ 0x5bc91c00, 0x5bc923ff, REGISTRY_RIPENCC    }, // 91.201.28.0     - 91.201.35.255
	{ 0x5bc92400, 0x5bc93fff, REGISTRY_RIPENCC    }, // 91.201.36.0     - 91.201.63.255
	{ 0x5bc94000, 0x5bc943ff, REGISTRY_RIPENCC    }, // 91.201.64.0     - 91.201.67.255
	{ 0x5bc94400, 0x5bc95fff, REGISTRY_RIPENCC    }, // 91.201.68.0     - 91.201.95.255
	{ 0x5bc96000, 0x5bc963ff, REGISTRY_RIPENCC    }, // 91.201.96.0     - 91.201.99.255
	{ 0x5bc96400, 0x5bc967ff, REGISTRY_RIPENCC    }, // 91.201.100.0    - 91.201.103.255
	{ 0x5bc96800, 0x5bc96bff, REGISTRY_RIPENCC    }, // 91.201.104.0    - 91.201.107.255
	{ 0x5bc96c00, 0x5bc977ff, REGISTRY_RIPENCC    }, // 91.201.108.0    - 91.201.119.255
	{ 0x5bc97800, 0x5bc97fff, REGISTRY_RIPENCC    }, // 91.201.120.0    - 91.201.127.255
	{ 0x5bc98000, 0x5bc98bff, REGISTRY_RIPENCC    }, // 91.201.128.0    - 91.201.139.255
	{ 0x5bc98c00, 0x5bc98fff, REGISTRY_RIPENCC    }, // 91.201.140.0    - 91.201.143.255
	{ 0x5bc99000, 0x5bc9afff, REGISTRY_RIPENCC    }, // 91.201.144.0    - 91.201.175.255
	{ 0x5bc9b000, 0x5bc9b3ff, REGISTRY_RIPENCC    }, // 91.201.176.0    - 91.201.179.255
	{ 0x5bc9b400, 0x5bc9c3ff, REGISTRY_RIPENCC    }, // 91.201.180.0    - 91.201.195.255
	{ 0x5bc9c400, 0x5bc9c7ff, REGISTRY_RIPENCC    }, // 91.201.196.0    - 91.201.199.255
	{ 0x5bc9c800, 0x5bc9d5ff, REGISTRY_RIPENCC    }, // 91.201.200.0    - 91.201.213.255
	{ 0x5bc9d600, 0x5bc9dbff, REGISTRY_RIPENCC    }, // 91.201.214.0    - 91.201.219.255
	{ 0x5bc9dc00, 0x5bca1bff, REGISTRY_RIPENCC    }, // 91.201.220.0    - 91.202.27.255
	{ 0x5bca1c00, 0x5bca23ff, REGISTRY_RIPENCC    }, // 91.202.28.0     - 91.202.35.255
	{ 0x5bca2400, 0x5bcaa7ff, REGISTRY_RIPENCC    }, // 91.202.36.0     - 91.202.167.255
	{ 0x5bcaa800, 0x5bcaafff, REGISTRY_RIPENCC    }, // 91.202.168.0    - 91.202.175.255
	{ 0x5bcab000, 0x5bcabbff, REGISTRY_RIPENCC    }, // 91.202.176.0    - 91.202.187.255
	{ 0x5bcabc00, 0x5bcabfff, REGISTRY_RIPENCC    }, // 91.202.188.0    - 91.202.191.255
	{ 0x5bcac000, 0x5bcaf3ff, REGISTRY_RIPENCC    }, // 91.202.192.0    - 91.202.243.255
	{ 0x5bcaf400, 0x5bcafbff, REGISTRY_RIPENCC    }, // 91.202.244.0    - 91.202.251.255
	{ 0x5bcafc00, 0x5bcb07ff, REGISTRY_RIPENCC    }, // 91.202.252.0    - 91.203.7.255
	{ 0x5bcb0800, 0x5bcb0bff, REGISTRY_RIPENCC    }, // 91.203.8.0      - 91.203.11.255
	{ 0x5bcb0c00, 0x5bcb13ff, REGISTRY_RIPENCC    }, // 91.203.12.0     - 91.203.19.255
	{ 0x5bcb1400, 0x5bcb17ff, REGISTRY_RIPENCC    }, // 91.203.20.0     - 91.203.23.255
	{ 0x5bcb1800, 0x5bcb4bff, REGISTRY_RIPENCC    }, // 91.203.24.0     - 91.203.75.255
	{ 0x5bcb4c00, 0x5bcb4fff, REGISTRY_RIPENCC    }, // 91.203.76.0     - 91.203.79.255
	{ 0x5bcb5000, 0x5bcb5bff, REGISTRY_RIPENCC    }, // 91.203.80.0     - 91.203.91.255
	{ 0x5bcb5c00, 0x5bcb5fff, REGISTRY_RIPENCC    }, // 91.203.92.0     - 91.203.95.255
	{ 0x5bcb6000, 0x5bcb63ff, REGISTRY_RIPENCC    }, // 91.203.96.0     - 91.203.99.255
	{ 0x5bcb6400, 0x5bcb67ff, REGISTRY_RIPENCC    }, // 91.203.100.0    - 91.203.103.255
	{ 0x5bcb6800, 0x5bcb7bff, REGISTRY_RIPENCC    }, // 91.203.104.0    - 91.203.123.255
	{ 0x5bcb7c00, 0x5bcb83ff, REGISTRY_RIPENCC    }, // 91.203.124.0    - 91.203.131.255
	{ 0x5bcb8400, 0x5bcba7ff, REGISTRY_RIPENCC    }, // 91.203.132.0    - 91.203.167.255
	{ 0x5bcba800, 0x5bcbabff, REGISTRY_RIPENCC    }, // 91.203.168.0    - 91.203.171.255
	{ 0x5bcbac00, 0x5bcbc3ff, REGISTRY_RIPENCC    }, // 91.203.172.0    - 91.203.195.255
	{ 0x5bcbc400, 0x5bcbc7ff, REGISTRY_RIPENCC    }, // 91.203.196.0    - 91.203.199.255
	{ 0x5bcbc800, 0x5bcbcbff, REGISTRY_RIPENCC    }, // 91.203.200.0    - 91.203.203.255
	{ 0x5bcbcc00, 0x5bcbcfff, REGISTRY_RIPENCC    }, // 91.203.204.0    - 91.203.207.255
	{ 0x5bcbd000, 0x5bcbd3ff, REGISTRY_RIPENCC    }, // 91.203.208.0    - 91.203.211.255
	{ 0x5bcbd400, 0x5bcbd7ff, REGISTRY_RIPENCC    }, // 91.203.212.0    - 91.203.215.255
	{ 0x5bcbd800, 0x5bcbdbff, REGISTRY_RIPENCC    }, // 91.203.216.0    - 91.203.219.255
	{ 0x5bcbdd00, 0x5bcbe3ff, REGISTRY_RIPENCC    }, // 91.203.221.0    - 91.203.227.255
	{ 0x5bcbe400, 0x5bcbe7ff, REGISTRY_RIPENCC    }, // 91.203.228.0    - 91.203.231.255
	{ 0x5bcbe800, 0x5bcc0bff, REGISTRY_RIPENCC    }, // 91.203.232.0    - 91.204.11.255
	{ 0x5bcc0c00, 0x5bcc17ff, REGISTRY_RIPENCC    }, // 91.204.12.0     - 91.204.23.255
	{ 0x5bcc1800, 0x5bcc27ff, REGISTRY_RIPENCC    }, // 91.204.24.0     - 91.204.39.255
	{ 0x5bcc2800, 0x5bcc37ff, REGISTRY_RIPENCC    }, // 91.204.40.0     - 91.204.55.255
	{ 0x5bcc3800, 0x5bcc7bff, REGISTRY_RIPENCC    }, // 91.204.56.0     - 91.204.123.255
	{ 0x5bcc7c00, 0x5bcc7fff, REGISTRY_RIPENCC    }, // 91.204.124.0    - 91.204.127.255
	{ 0x5bcc8000, 0x5bcc9fff, REGISTRY_RIPENCC    }, // 91.204.128.0    - 91.204.159.255
	{ 0x5bcca000, 0x5bcca2ff, REGISTRY_RIPENCC    }, // 91.204.160.0    - 91.204.162.255
	{ 0x5bcca300, 0x5bcca7ff, REGISTRY_RIPENCC    }, // 91.204.163.0    - 91.204.167.255
	{ 0x5bcca800, 0x5bccabff, REGISTRY_RIPENCC    }, // 91.204.168.0    - 91.204.171.255
	{ 0x5bccac00, 0x5bccdbff, REGISTRY_RIPENCC    }, // 91.204.172.0    - 91.204.219.255
	{ 0x5bccdc00, 0x5bcce3ff, REGISTRY_RIPENCC    }, // 91.204.220.0    - 91.204.227.255
	{ 0x5bcce400, 0x5bcce7ff, REGISTRY_RIPENCC    }, // 91.204.228.0    - 91.204.231.255
	{ 0x5bcce800, 0x5bccebff, REGISTRY_RIPENCC    }, // 91.204.232.0    - 91.204.235.255
	{ 0x5bccec00, 0x5bccf7ff, REGISTRY_RIPENCC    }, // 91.204.236.0    - 91.204.247.255
	{ 0x5bccf800, 0x5bccfbff, REGISTRY_RIPENCC    }, // 91.204.248.0    - 91.204.251.255
	{ 0x5bccfc00, 0x5bcd0bff, REGISTRY_RIPENCC    }, // 91.204.252.0    - 91.205.11.255
	{ 0x5bcd0c00, 0x5bcd0fff, REGISTRY_RIPENCC    }, // 91.205.12.0     - 91.205.15.255
	{ 0x5bcd1000, 0x5bcd2bff, REGISTRY_RIPENCC    }, // 91.205.16.0     - 91.205.43.255
	{ 0x5bcd2c00, 0x5bcd2fff, REGISTRY_RIPENCC    }, // 91.205.44.0     - 91.205.47.255
	{ 0x5bcd3000, 0x5bcd5bff, REGISTRY_RIPENCC    }, // 91.205.48.0     - 91.205.91.255
	{ 0x5bcd5c00, 0x5bcd5fff, REGISTRY_RIPENCC    }, // 91.205.92.0     - 91.205.95.255
	{ 0x5bcd6000, 0x5bcd67ff, REGISTRY_RIPENCC    }, // 91.205.96.0     - 91.205.103.255
	{ 0x5bcd6800, 0x5bcd6fff, REGISTRY_RIPENCC    }, // 91.205.104.0    - 91.205.111.255
	{ 0x5bcd7000, 0x5bcd73ff, REGISTRY_RIPENCC    }, // 91.205.112.0    - 91.205.115.255
	{ 0x5bcd7400, 0x5bcd77ff, REGISTRY_RIPENCC    }, // 91.205.116.0    - 91.205.119.255
	{ 0x5bcd7800, 0x5bcdabff, REGISTRY_RIPENCC    }, // 91.205.120.0    - 91.205.171.255
	{ 0x5bcdac00, 0x5bcdafff, REGISTRY_RIPENCC    }, // 91.205.172.0    - 91.205.175.255
	{ 0x5bcdb000, 0x5bcdb7ff, REGISTRY_RIPENCC    }, // 91.205.176.0    - 91.205.183.255
	{ 0x5bcdb800, 0x5bcdbfff, REGISTRY_RIPENCC    }, // 91.205.184.0    - 91.205.191.255
	{ 0x5bcdc000, 0x5bcdc3ff, REGISTRY_RIPENCC    }, // 91.205.192.0    - 91.205.195.255
	{ 0x5bcdc400, 0x5bcdc7ff, REGISTRY_RIPENCC    }, // 91.205.196.0    - 91.205.199.255
	{ 0x5bcdc800, 0x5bcde7ff, REGISTRY_RIPENCC    }, // 91.205.200.0    - 91.205.231.255
	{ 0x5bcde800, 0x5bcdebff, REGISTRY_RIPENCC    }, // 91.205.232.0    - 91.205.235.255
	{ 0x5bcdec00, 0x5bce0dff, REGISTRY_RIPENCC    }, // 91.205.236.0    - 91.206.13.255
	{ 0x5bce0e00, 0x5bce0fff, REGISTRY_RIPENCC    }, // 91.206.14.0     - 91.206.15.255
	{ 0x5bce1000, 0x5bce25ff, REGISTRY_RIPENCC    }, // 91.206.16.0     - 91.206.37.255
	{ 0x5bce2600, 0x5bce27ff, REGISTRY_RIPENCC    }, // 91.206.38.0     - 91.206.39.255
	{ 0x5bce2800, 0x5bce2fff, REGISTRY_RIPENCC    }, // 91.206.40.0     - 91.206.47.255
	{ 0x5bce3200, 0x5bce3fff, REGISTRY_RIPENCC    }, // 91.206.50.0     - 91.206.63.255
	{ 0x5bce4200, 0x5bce43ff, REGISTRY_RIPENCC    }, // 91.206.66.0     - 91.206.67.255
	{ 0x5bce4600, 0x5bce5bff, REGISTRY_RIPENCC    }, // 91.206.70.0     - 91.206.91.255
	{ 0x5bce5e00, 0x5bce69ff, REGISTRY_RIPENCC    }, // 91.206.94.0     - 91.206.105.255
	{ 0x5bce6c00, 0x5bce8bff, REGISTRY_RIPENCC    }, // 91.206.108.0    - 91.206.139.255
	{ 0x5bce8e00, 0x5bce8fff, REGISTRY_RIPENCC    }, // 91.206.142.0    - 91.206.143.255
	{ 0x5bce9000, 0x5bce9bff, REGISTRY_RIPENCC    }, // 91.206.144.0    - 91.206.155.255
	{ 0x5bce9c00, 0x5bce9dff, REGISTRY_RIPENCC    }, // 91.206.156.0    - 91.206.157.255
	{ 0x5bce9e00, 0x5bceb5ff, REGISTRY_RIPENCC    }, // 91.206.158.0    - 91.206.181.255
	{ 0x5bceb600, 0x5bceb7ff, REGISTRY_RIPENCC    }, // 91.206.182.0    - 91.206.183.255
	{ 0x5bceb800, 0x5bcec9ff, REGISTRY_RIPENCC    }, // 91.206.184.0    - 91.206.201.255
	{ 0x5bcece00, 0x5bcecfff, REGISTRY_RIPENCC    }, // 91.206.206.0    - 91.206.207.255
	{ 0x5bced200, 0x5bceffff, REGISTRY_RIPENCC    }, // 91.206.210.0    - 91.206.255.255
	{ 0x5bcf0200, 0x5bcf0bff, REGISTRY_RIPENCC    }, // 91.207.2.0      - 91.207.11.255
	{ 0x5bcf0e00, 0x5bcf17ff, REGISTRY_RIPENCC    }, // 91.207.14.0     - 91.207.23.255
	{ 0x5bcf1800, 0x5bcf19ff, REGISTRY_RIPENCC    }, // 91.207.24.0     - 91.207.25.255
	{ 0x5bcf1a00, 0x5bcf1fff, REGISTRY_RIPENCC    }, // 91.207.26.0     - 91.207.31.255
	{ 0x5bcf2000, 0x5bcf21ff, REGISTRY_RIPENCC    }, // 91.207.32.0     - 91.207.33.255
	{ 0x5bcf2200, 0x5bcf37ff, REGISTRY_RIPENCC    }, // 91.207.34.0     - 91.207.55.255
	{ 0x5bcf3800, 0x5bcf39ff, REGISTRY_RIPENCC    }, // 91.207.56.0     - 91.207.57.255
	{ 0x5bcf3a00, 0x5bcf45ff, REGISTRY_RIPENCC    }, // 91.207.58.0     - 91.207.69.255
	{ 0x5bcf4a00, 0x5bcf5dff, REGISTRY_RIPENCC    }, // 91.207.74.0     - 91.207.93.255
	{ 0x5bcf6200, 0x5bcf6bff, REGISTRY_RIPENCC    }, // 91.207.98.0     - 91.207.107.255
	{ 0x5bcf6e00, 0x5bcf8fff, REGISTRY_RIPENCC    }, // 91.207.110.0    - 91.207.143.255
	{ 0x5bcf9200, 0x5bcf99ff, REGISTRY_RIPENCC    }, // 91.207.146.0    - 91.207.153.255
	{ 0x5bcf9c00, 0x5bcfa3ff, REGISTRY_RIPENCC    }, // 91.207.156.0    - 91.207.163.255
	{ 0x5bcfa600, 0x5bcfabff, REGISTRY_RIPENCC    }, // 91.207.166.0    - 91.207.171.255
	{ 0x5bcfac00, 0x5bcfafff, REGISTRY_RIPENCC    }, // 91.207.172.0    - 91.207.175.255
	{ 0x5bcfb000, 0x5bcfb1ff, REGISTRY_RIPENCC    }, // 91.207.176.0    - 91.207.177.255
	{ 0x5bcfb400, 0x5bcfb9ff, REGISTRY_RIPENCC    }, // 91.207.180.0    - 91.207.185.255
	{ 0x5bcfba00, 0x5bcfbbff, REGISTRY_RIPENCC    }, // 91.207.186.0    - 91.207.187.255
	{ 0x5bcfbc00, 0x5bcfc3ff, REGISTRY_RIPENCC    }, // 91.207.188.0    - 91.207.195.255
	{ 0x5bcfc600, 0x5bcfd5ff, REGISTRY_RIPENCC    }, // 91.207.198.0    - 91.207.213.255
	{ 0x5bcfd600, 0x5bcfd7ff, REGISTRY_RIPENCC    }, // 91.207.214.0    - 91.207.215.255
	{ 0x5bcfd800, 0x5bcfddff, REGISTRY_RIPENCC    }, // 91.207.216.0    - 91.207.221.255
	{ 0x5bcfe000, 0x5bcfe1ff, REGISTRY_RIPENCC    }, // 91.207.224.0    - 91.207.225.255
	{ 0x5bcfe200, 0x5bcfe5ff, REGISTRY_RIPENCC    }, // 91.207.226.0    - 91.207.229.255
	{ 0x5bcfe800, 0x5bcfe9ff, REGISTRY_RIPENCC    }, // 91.207.232.0    - 91.207.233.255
	{ 0x5bcfec00, 0x5bcfffff, REGISTRY_RIPENCC    }, // 91.207.236.0    - 91.207.255.255
	{ 0x5bd00100, 0x5bd00fff, REGISTRY_RIPENCC    }, // 91.208.1.0      - 91.208.15.255
	{ 0x5bd01100, 0x5bd011ff, REGISTRY_RIPENCC    }, // 91.208.17.0     - 91.208.17.255
	{ 0x5bd01200, 0x5bd012ff, REGISTRY_RIPENCC    }, // 91.208.18.0     - 91.208.18.255
	{ 0x5bd01400, 0x5bd014ff, REGISTRY_RIPENCC    }, // 91.208.20.0     - 91.208.20.255
	{ 0x5bd01600, 0x5bd01eff, REGISTRY_RIPENCC    }, // 91.208.22.0     - 91.208.30.255
	{ 0x5bd02000, 0x5bd02dff, REGISTRY_RIPENCC    }, // 91.208.32.0     - 91.208.45.255
	{ 0x5bd02f00, 0x5bd02fff, REGISTRY_RIPENCC    }, // 91.208.47.0     - 91.208.47.255
	{ 0x5bd03100, 0x5bd03fff, REGISTRY_RIPENCC    }, // 91.208.49.0     - 91.208.63.255
	{ 0x5bd04100, 0x5bd044ff, REGISTRY_RIPENCC    }, // 91.208.65.0     - 91.208.68.255
	{ 0x5bd04600, 0x5bd048ff, REGISTRY_RIPENCC    }, // 91.208.70.0     - 91.208.72.255
	{ 0x5bd04a00, 0x5bd067ff, REGISTRY_RIPENCC    }, // 91.208.74.0     - 91.208.103.255
	{ 0x5bd06900, 0x5bd06cff, REGISTRY_RIPENCC    }, // 91.208.105.0    - 91.208.108.255
	{ 0x5bd06e00, 0x5bd070ff, REGISTRY_RIPENCC    }, // 91.208.110.0    - 91.208.112.255
	{ 0x5bd07200, 0x5bd072ff, REGISTRY_RIPENCC    }, // 91.208.114.0    - 91.208.114.255
	{ 0x5bd07300, 0x5bd07fff, REGISTRY_RIPENCC    }, // 91.208.115.0    - 91.208.127.255
	{ 0x5bd08100, 0x5bd088ff, REGISTRY_RIPENCC    }, // 91.208.129.0    - 91.208.136.255
	{ 0x5bd08a00, 0x5bd096ff, REGISTRY_RIPENCC    }, // 91.208.138.0    - 91.208.150.255
	{ 0x5bd09800, 0x5bd0a1ff, REGISTRY_RIPENCC    }, // 91.208.152.0    - 91.208.161.255
	{ 0x5bd0a300, 0x5bd0afff, REGISTRY_RIPENCC    }, // 91.208.163.0    - 91.208.175.255
	{ 0x5bd0b200, 0x5bd0b7ff, REGISTRY_RIPENCC    }, // 91.208.178.0    - 91.208.183.255
	{ 0x5bd0b900, 0x5bd0c4ff, REGISTRY_RIPENCC    }, // 91.208.185.0    - 91.208.196.255
	{ 0x5bd0c600, 0x5bd0cdff, REGISTRY_RIPENCC    }, // 91.208.198.0    - 91.208.205.255
	{ 0x5bd0cf00, 0x5bd0cfff, REGISTRY_RIPENCC    }, // 91.208.207.0    - 91.208.207.255
	{ 0x5bd0d100, 0x5bd0e3ff, REGISTRY_RIPENCC    }, // 91.208.209.0    - 91.208.227.255
	{ 0x5bd0e500, 0x5bd0e5ff, REGISTRY_RIPENCC    }, // 91.208.229.0    - 91.208.229.255
	{ 0x5bd0e700, 0x5bd0e8ff, REGISTRY_RIPENCC    }, // 91.208.231.0    - 91.208.232.255
	{ 0x5bd0ea00, 0x5bd0ebff, REGISTRY_RIPENCC    }, // 91.208.234.0    - 91.208.235.255
	{ 0x5bd0ed00, 0x5bd0efff, REGISTRY_RIPENCC    }, // 91.208.237.0    - 91.208.239.255
	{ 0x5bd0f100, 0x5bd0f5ff, REGISTRY_RIPENCC    }, // 91.208.241.0    - 91.208.245.255
	{ 0x5bd0f700, 0x5bd0faff, REGISTRY_RIPENCC    }, // 91.208.247.0    - 91.208.250.255
	{ 0x5bd0fc00, 0x5bd10dff, REGISTRY_RIPENCC    }, // 91.208.252.0    - 91.209.13.255
	{ 0x5bd10f00, 0x5bd114ff, REGISTRY_RIPENCC    }, // 91.209.15.0     - 91.209.20.255
	{ 0x5bd11700, 0x5bd127ff, REGISTRY_RIPENCC    }, // 91.209.23.0     - 91.209.39.255
	{ 0x5bd12900, 0x5bd12fff, REGISTRY_RIPENCC    }, // 91.209.41.0     - 91.209.47.255
	{ 0x5bd13100, 0x5bd131ff, REGISTRY_RIPENCC    }, // 91.209.49.0     - 91.209.49.255
	{ 0x5bd13300, 0x5bd139ff, REGISTRY_RIPENCC    }, // 91.209.51.0     - 91.209.57.255
	{ 0x5bd13b00, 0x5bd13dff, REGISTRY_RIPENCC    }, // 91.209.59.0     - 91.209.61.255
	{ 0x5bd14000, 0x5bd143ff, REGISTRY_RIPENCC    }, // 91.209.64.0     - 91.209.67.255
	{ 0x5bd14500, 0x5bd155ff, REGISTRY_RIPENCC    }, // 91.209.69.0     - 91.209.85.255
	{ 0x5bd15600, 0x5bd156ff, REGISTRY_RIPENCC    }, // 91.209.86.0     - 91.209.86.255
	{ 0x5bd15700, 0x5bd159ff, REGISTRY_RIPENCC    }, // 91.209.87.0     - 91.209.89.255
	{ 0x5bd15b00, 0x5bd162ff, REGISTRY_RIPENCC    }, // 91.209.91.0     - 91.209.98.255
	{ 0x5bd16500, 0x5bd168ff, REGISTRY_RIPENCC    }, // 91.209.101.0    - 91.209.104.255
	{ 0x5bd16a00, 0x5bd16aff, REGISTRY_RIPENCC    }, // 91.209.106.0    - 91.209.106.255
	{ 0x5bd16b00, 0x5bd16bff, REGISTRY_RIPENCC    }, // 91.209.107.0    - 91.209.107.255
	{ 0x5bd16c00, 0x5bd172ff, REGISTRY_RIPENCC    }, // 91.209.108.0    - 91.209.114.255
	{ 0x5bd17400, 0x5bd194ff, REGISTRY_RIPENCC    }, // 91.209.116.0    - 91.209.148.255
	{ 0x5bd19600, 0x5bd196ff, REGISTRY_RIPENCC    }, // 91.209.150.0    - 91.209.150.255
	{ 0x5bd19800, 0x5bd1a1ff, REGISTRY_RIPENCC    }, // 91.209.152.0    - 91.209.161.255
	{ 0x5bd1a400, 0x5bd1b2ff, REGISTRY_RIPENCC    }, // 91.209.164.0    - 91.209.178.255
	{ 0x5bd1b400, 0x5bd1b6ff, REGISTRY_RIPENCC    }, // 91.209.180.0    - 91.209.182.255
	{ 0x5bd1b900, 0x5bd1b9ff, REGISTRY_RIPENCC    }, // 91.209.185.0    - 91.209.185.255
	{ 0x5bd1bb00, 0x5bd1bdff, REGISTRY_RIPENCC    }, // 91.209.187.0    - 91.209.189.255
	{ 0x5bd1be00, 0x5bd1beff, REGISTRY_RIPENCC    }, // 91.209.190.0    - 91.209.190.255
	{ 0x5bd1bf00, 0x5bd1ccff, REGISTRY_RIPENCC    }, // 91.209.191.0    - 91.209.204.255
	{ 0x5bd1ce00, 0x5bd1d0ff, REGISTRY_RIPENCC    }, // 91.209.206.0    - 91.209.208.255
	{ 0x5bd1d200, 0x5bd1d6ff, REGISTRY_RIPENCC    }, // 91.209.210.0    - 91.209.214.255
	{ 0x5bd1d800, 0x5bd1dfff, REGISTRY_RIPENCC    }, // 91.209.216.0    - 91.209.223.255
	{ 0x5bd1e100, 0x5bd1e2ff, REGISTRY_RIPENCC    }, // 91.209.225.0    - 91.209.226.255
	{ 0x5bd1e400, 0x5bd1e5ff, REGISTRY_RIPENCC    }, // 91.209.228.0    - 91.209.229.255
	{ 0x5bd1e800, 0x5bd237ff, REGISTRY_RIPENCC    }, // 91.209.232.0    - 91.210.55.255
	{ 0x5bd23800, 0x5bd23bff, REGISTRY_RIPENCC    }, // 91.210.56.0     - 91.210.59.255
	{ 0x5bd23c00, 0x5bd247ff, REGISTRY_RIPENCC    }, // 91.210.60.0     - 91.210.71.255
	{ 0x5bd24800, 0x5bd24fff, REGISTRY_RIPENCC    }, // 91.210.72.0     - 91.210.79.255
	{ 0x5bd25000, 0x5bd263ff, REGISTRY_RIPENCC    }, // 91.210.80.0     - 91.210.99.255
	{ 0x5bd26400, 0x5bd267ff, REGISTRY_RIPENCC    }, // 91.210.100.0    - 91.210.103.255
	{ 0x5bd26800, 0x5bd2d3ff, REGISTRY_RIPENCC    }, // 91.210.104.0    - 91.210.211.255
	{ 0x5bd2d800, 0x5bd2dfff, REGISTRY_RIPENCC    }, // 91.210.216.0    - 91.210.223.255
	{ 0x5bd2e000, 0x5bd2e3ff, REGISTRY_RIPENCC    }, // 91.210.224.0    - 91.210.227.255
	{ 0x5bd2e400, 0x5bd2ffff, REGISTRY_RIPENCC    }, // 91.210.228.0    - 91.210.255.255
	{ 0x5bd30000, 0x5bd303ff, REGISTRY_RIPENCC    }, // 91.211.0.0      - 91.211.3.255
	{ 0x5bd30400, 0x5bd307ff, REGISTRY_RIPENCC    }, // 91.211.4.0      - 91.211.7.255
	{ 0x5bd30800, 0x5bd30bff, REGISTRY_RIPENCC    }, // 91.211.8.0      - 91.211.11.255
	{ 0x5bd30c00, 0x5bd33fff, REGISTRY_RIPENCC    }, // 91.211.12.0     - 91.211.63.255
	{ 0x5bd34000, 0x5bd343ff, REGISTRY_RIPENCC    }, // 91.211.64.0     - 91.211.67.255
	{ 0x5bd34400, 0x5bd357ff, REGISTRY_RIPENCC    }, // 91.211.68.0     - 91.211.87.255
	{ 0x5bd35800, 0x5bd35bff, REGISTRY_RIPENCC    }, // 91.211.88.0     - 91.211.91.255
	{ 0x5bd35c00, 0x5bd387ff, REGISTRY_RIPENCC    }, // 91.211.92.0     - 91.211.135.255
	{ 0x5bd38800, 0x5bd38bff, REGISTRY_RIPENCC    }, // 91.211.136.0    - 91.211.139.255
	{ 0x5bd38c00, 0x5bd397ff, REGISTRY_RIPENCC    }, // 91.211.140.0    - 91.211.151.255
	{ 0x5bd39800, 0x5bd39bff, REGISTRY_RIPENCC    }, // 91.211.152.0    - 91.211.155.255
	{ 0x5bd39c00, 0x5bd39fff, REGISTRY_RIPENCC    }, // 91.211.156.0    - 91.211.159.255
	{ 0x5bd3a000, 0x5bd3a3ff, REGISTRY_RIPENCC    }, // 91.211.160.0    - 91.211.163.255
	{ 0x5bd3a400, 0x5bd3c3ff, REGISTRY_RIPENCC    }, // 91.211.164.0    - 91.211.195.255
	{ 0x5bd3c400, 0x5bd3c7ff, REGISTRY_RIPENCC    }, // 91.211.196.0    - 91.211.199.255
	{ 0x5bd3c800, 0x5bd3c9ff, REGISTRY_RIPENCC    }, // 91.211.200.0    - 91.211.201.255
	{ 0x5bd3ca00, 0x5bd3cbff, REGISTRY_RIPENCC    }, // 91.211.202.0    - 91.211.203.255
	{ 0x5bd3cc00, 0x5bd3dfff, REGISTRY_RIPENCC    }, // 91.211.204.0    - 91.211.223.255
	{ 0x5bd3e000, 0x5bd3e3ff, REGISTRY_RIPENCC    }, // 91.211.224.0    - 91.211.227.255
	{ 0x5bd3e400, 0x5bd3efff, REGISTRY_RIPENCC    }, // 91.211.228.0    - 91.211.239.255
	{ 0x5bd3f000, 0x5bd3f3ff, REGISTRY_RIPENCC    }, // 91.211.240.0    - 91.211.243.255
	{ 0x5bd3f400, 0x5bd3f7ff, REGISTRY_RIPENCC    }, // 91.211.244.0    - 91.211.247.255
	{ 0x5bd3f800, 0x5bd3fbff, REGISTRY_RIPENCC    }, // 91.211.248.0    - 91.211.251.255
	{ 0x5bd3fc00, 0x5bd40aff, REGISTRY_RIPENCC    }, // 91.211.252.0    - 91.212.10.255
	{ 0x5bd40c00, 0x5bd40dff, REGISTRY_RIPENCC    }, // 91.212.12.0     - 91.212.13.255
	{ 0x5bd40f00, 0x5bd412ff, REGISTRY_RIPENCC    }, // 91.212.15.0     - 91.212.18.255
	{ 0x5bd41500, 0x5bd419ff, REGISTRY_RIPENCC    }, // 91.212.21.0     - 91.212.25.255
	{ 0x5bd41a00, 0x5bd41aff, REGISTRY_RIPENCC    }, // 91.212.26.0     - 91.212.26.255
	{ 0x5bd41c00, 0x5bd425ff, REGISTRY_RIPENCC    }, // 91.212.28.0     - 91.212.37.255
	{ 0x5bd42700, 0x5bd427ff, REGISTRY_RIPENCC    }, // 91.212.39.0     - 91.212.39.255
	{ 0x5bd42a00, 0x5bd42cff, REGISTRY_RIPENCC    }, // 91.212.42.0     - 91.212.44.255
	{ 0x5bd42e00, 0x5bd430ff, REGISTRY_RIPENCC    }, // 91.212.46.0     - 91.212.48.255
	{ 0x5bd43200, 0x5bd432ff, REGISTRY_RIPENCC    }, // 91.212.50.0     - 91.212.50.255
	{ 0x5bd43400, 0x5bd435ff, REGISTRY_RIPENCC    }, // 91.212.52.0     - 91.212.53.255
	{ 0x5bd43800, 0x5bd440ff, REGISTRY_RIPENCC    }, // 91.212.56.0     - 91.212.64.255
	{ 0x5bd44200, 0x5bd447ff, REGISTRY_RIPENCC    }, // 91.212.66.0     - 91.212.71.255
	{ 0x5bd44a00, 0x5bd451ff, REGISTRY_RIPENCC    }, // 91.212.74.0     - 91.212.81.255
	{ 0x5bd45300, 0x5bd463ff, REGISTRY_RIPENCC    }, // 91.212.83.0     - 91.212.99.255
	{ 0x5bd46500, 0x5bd46aff, REGISTRY_RIPENCC    }, // 91.212.101.0    - 91.212.106.255
	{ 0x5bd46c00, 0x5bd477ff, REGISTRY_RIPENCC    }, // 91.212.108.0    - 91.212.119.255
	{ 0x5bd47900, 0x5bd47aff, REGISTRY_RIPENCC    }, // 91.212.121.0    - 91.212.122.255
	{ 0x5bd47c00, 0x5bd486ff, REGISTRY_RIPENCC    }, // 91.212.124.0    - 91.212.134.255
	{ 0x5bd48800, 0x5bd48cff, REGISTRY_RIPENCC    }, // 91.212.136.0    - 91.212.140.255
	{ 0x5bd48f00, 0x5bd48fff, REGISTRY_RIPENCC    }, // 91.212.143.0    - 91.212.143.255
	{ 0x5bd49000, 0x5bd490ff, REGISTRY_RIPENCC    }, // 91.212.144.0    - 91.212.144.255
	{ 0x5bd49100, 0x5bd494ff, REGISTRY_RIPENCC    }, // 91.212.145.0    - 91.212.148.255
	{ 0x5bd49600, 0x5bd498ff, REGISTRY_RIPENCC    }, // 91.212.150.0    - 91.212.152.255
	{ 0x5bd49a00, 0x5bd49eff, REGISTRY_RIPENCC    }, // 91.212.154.0    - 91.212.158.255
	{ 0x5bd4a200, 0x5bd4a2ff, REGISTRY_RIPENCC    }, // 91.212.162.0    - 91.212.162.255
	{ 0x5bd4a400, 0x5bd4c0ff, REGISTRY_RIPENCC    }, // 91.212.164.0    - 91.212.192.255
	{ 0x5bd4c200, 0x5bd4c5ff, REGISTRY_RIPENCC    }, // 91.212.194.0    - 91.212.197.255
	{ 0x5bd4c700, 0x5bd4c8ff, REGISTRY_RIPENCC    }, // 91.212.199.0    - 91.212.200.255
	{ 0x5bd4ca00, 0x5bd4dbff, REGISTRY_RIPENCC    }, // 91.212.202.0    - 91.212.219.255
	{ 0x5bd4dd00, 0x5bd4e1ff, REGISTRY_RIPENCC    }, // 91.212.221.0    - 91.212.225.255
	{ 0x5bd4e300, 0x5bd4e4ff, REGISTRY_RIPENCC    }, // 91.212.227.0    - 91.212.228.255
	{ 0x5bd4e500, 0x5bd4e5ff, REGISTRY_RIPENCC    }, // 91.212.229.0    - 91.212.229.255
	{ 0x5bd4e600, 0x5bd4e6ff, REGISTRY_RIPENCC    }, // 91.212.230.0    - 91.212.230.255
	{ 0x5bd4e800, 0x5bd4eeff, REGISTRY_RIPENCC    }, // 91.212.232.0    - 91.212.238.255
	{ 0x5bd4ef00, 0x5bd4efff, REGISTRY_RIPENCC    }, // 91.212.239.0    - 91.212.239.255
	{ 0x5bd4f100, 0x5bd4f5ff, REGISTRY_RIPENCC    }, // 91.212.241.0    - 91.212.245.255
	{ 0x5bd4f700, 0x5bd4feff, REGISTRY_RIPENCC    }, // 91.212.247.0    - 91.212.254.255
	{ 0x5bd50000, 0x5bd51cff, REGISTRY_RIPENCC    }, // 91.213.0.0      - 91.213.28.255
	{ 0x5bd51e00, 0x5bd522ff, REGISTRY_RIPENCC    }, // 91.213.30.0     - 91.213.34.255
	{ 0x5bd52400, 0x5bd526ff, REGISTRY_RIPENCC    }, // 91.213.36.0     - 91.213.38.255
	{ 0x5bd52700, 0x5bd527ff, REGISTRY_RIPENCC    }, // 91.213.39.0     - 91.213.39.255
	{ 0x5bd52800, 0x5bd530ff, REGISTRY_RIPENCC    }, // 91.213.40.0     - 91.213.48.255
	{ 0x5bd53300, 0x5bd547ff, REGISTRY_RIPENCC    }, // 91.213.51.0     - 91.213.71.255
	{ 0x5bd54900, 0x5bd549ff, REGISTRY_RIPENCC    }, // 91.213.73.0     - 91.213.73.255
	{ 0x5bd54c00, 0x5bd55cff, REGISTRY_RIPENCC    }, // 91.213.76.0     - 91.213.92.255
	{ 0x5bd55f00, 0x5bd56eff, REGISTRY_RIPENCC    }, // 91.213.95.0     - 91.213.110.255
	{ 0x5bd57000, 0x5bd574ff, REGISTRY_RIPENCC    }, // 91.213.112.0    - 91.213.116.255
	{ 0x5bd57600, 0x5bd577ff, REGISTRY_RIPENCC    }, // 91.213.118.0    - 91.213.119.255
	{ 0x5bd57a00, 0x5bd57dff, REGISTRY_RIPENCC    }, // 91.213.122.0    - 91.213.125.255
	{ 0x5bd57f00, 0x5bd589ff, REGISTRY_RIPENCC    }, // 91.213.127.0    - 91.213.137.255
	{ 0x5bd58b00, 0x5bd593ff, REGISTRY_RIPENCC    }, // 91.213.139.0    - 91.213.147.255
	{ 0x5bd59500, 0x5bd596ff, REGISTRY_RIPENCC    }, // 91.213.149.0    - 91.213.150.255
	{ 0x5bd59800, 0x5bd59cff, REGISTRY_RIPENCC    }, // 91.213.152.0    - 91.213.156.255
	{ 0x5bd59e00, 0x5bd5a6ff, REGISTRY_RIPENCC    }, // 91.213.158.0    - 91.213.166.255
	{ 0x5bd5a800, 0x5bd5adff, REGISTRY_RIPENCC    }, // 91.213.168.0    - 91.213.173.255
	{ 0x5bd5af00, 0x5bd5bcff, REGISTRY_RIPENCC    }, // 91.213.175.0    - 91.213.188.255
	{ 0x5bd5be00, 0x5bd5c7ff, REGISTRY_RIPENCC    }, // 91.213.190.0    - 91.213.199.255
	{ 0x5bd5c900, 0x5bd5cfff, REGISTRY_RIPENCC    }, // 91.213.201.0    - 91.213.207.255
	{ 0x5bd5d100, 0x5bd5d6ff, REGISTRY_RIPENCC    }, // 91.213.209.0    - 91.213.214.255
	{ 0x5bd5d800, 0x5bd5d8ff, REGISTRY_RIPENCC    }, // 91.213.216.0    - 91.213.216.255
	{ 0x5bd5da00, 0x5bd5dbff, REGISTRY_RIPENCC    }, // 91.213.218.0    - 91.213.219.255
	{ 0x5bd5dd00, 0x5bd5deff, REGISTRY_RIPENCC    }, // 91.213.221.0    - 91.213.222.255
	{ 0x5bd5e000, 0x5bd5e9ff, REGISTRY_RIPENCC    }, // 91.213.224.0    - 91.213.233.255
	{ 0x5bd5ea00, 0x5bd5eaff, REGISTRY_RIPENCC    }, // 91.213.234.0    - 91.213.234.255
	{ 0x5bd5eb00, 0x5bd5ecff, REGISTRY_RIPENCC    }, // 91.213.235.0    - 91.213.236.255
	{ 0x5bd5ed00, 0x5bd5edff, REGISTRY_RIPENCC    }, // 91.213.237.0    - 91.213.237.255
	{ 0x5bd5ee00, 0x5bd61fff, REGISTRY_RIPENCC    }, // 91.213.238.0    - 91.214.31.255
	{ 0x5bd62000, 0x5bd623ff, REGISTRY_RIPENCC    }, // 91.214.32.0     - 91.214.35.255
	{ 0x5bd62400, 0x5bd63fff, REGISTRY_RIPENCC    }, // 91.214.36.0     - 91.214.63.255
	{ 0x5bd64000, 0x5bd643ff, REGISTRY_RIPENCC    }, // 91.214.64.0     - 91.214.67.255
	{ 0x5bd64400, 0x5bd657ff, REGISTRY_RIPENCC    }, // 91.214.68.0     - 91.214.87.255
	{ 0x5bd65800, 0x5bd65fff, REGISTRY_RIPENCC    }, // 91.214.88.0     - 91.214.95.255
	{ 0x5bd66000, 0x5bd673ff, REGISTRY_RIPENCC    }, // 91.214.96.0     - 91.214.115.255
	{ 0x5bd67400, 0x5bd677ff, REGISTRY_RIPENCC    }, // 91.214.116.0    - 91.214.119.255
	{ 0x5bd67800, 0x5bd693ff, REGISTRY_RIPENCC    }, // 91.214.120.0    - 91.214.147.255
	{ 0x5bd69400, 0x5bd697ff, REGISTRY_RIPENCC    }, // 91.214.148.0    - 91.214.151.255
	{ 0x5bd69800, 0x5bd6d3ff, REGISTRY_RIPENCC    }, // 91.214.152.0    - 91.214.211.255
	{ 0x5bd6d400, 0x5bd6dbff, REGISTRY_RIPENCC    }, // 91.214.212.0    - 91.214.219.255
	{ 0x5bd6dc00, 0x5bd72fff, REGISTRY_RIPENCC    }, // 91.214.220.0    - 91.215.47.255
	{ 0x5bd73000, 0x5bd733ff, REGISTRY_RIPENCC    }, // 91.215.48.0     - 91.215.51.255
	{ 0x5bd73400, 0x5bd73fff, REGISTRY_RIPENCC    }, // 91.215.52.0     - 91.215.63.255
	{ 0x5bd74000, 0x5bd743ff, REGISTRY_RIPENCC    }, // 91.215.64.0     - 91.215.67.255
	{ 0x5bd74400, 0x5bd75bff, REGISTRY_RIPENCC    }, // 91.215.68.0     - 91.215.91.255
	{ 0x5bd75c00, 0x5bd763ff, REGISTRY_RIPENCC    }, // 91.215.92.0     - 91.215.99.255
	{ 0x5bd76400, 0x5bd787ff, REGISTRY_RIPENCC    }, // 91.215.100.0    - 91.215.135.255
	{ 0x5bd78800, 0x5bd78bff, REGISTRY_RIPENCC    }, // 91.215.136.0    - 91.215.139.255
	{ 0x5bd78c00, 0x5bd7abff, REGISTRY_RIPENCC    }, // 91.215.140.0    - 91.215.171.255
	{ 0x5bd7ac00, 0x5bd7afff, REGISTRY_RIPENCC    }, // 91.215.172.0    - 91.215.175.255
	{ 0x5bd7b000, 0x5bd80aff, REGISTRY_RIPENCC    }, // 91.215.176.0    - 91.216.10.255
	{ 0x5bd80c00, 0x5bd826ff, REGISTRY_RIPENCC    }, // 91.216.12.0     - 91.216.38.255
	{ 0x5bd82800, 0x5bd83aff, REGISTRY_RIPENCC    }, // 91.216.40.0     - 91.216.58.255
	{ 0x5bd83b00, 0x5bd83bff, REGISTRY_RIPENCC    }, // 91.216.59.0     - 91.216.59.255
	{ 0x5bd83c00, 0x5bd848ff, REGISTRY_RIPENCC    }, // 91.216.60.0     - 91.216.72.255
	{ 0x5bd84a00, 0x5bd84cff, REGISTRY_RIPENCC    }, // 91.216.74.0     - 91.216.76.255
	{ 0x5bd84e00, 0x5bd860ff, REGISTRY_RIPENCC    }, // 91.216.78.0     - 91.216.96.255
	{ 0x5bd86100, 0x5bd861ff, REGISTRY_RIPENCC    }, // 91.216.97.0     - 91.216.97.255
	{ 0x5bd86200, 0x5bd863ff, REGISTRY_RIPENCC    }, // 91.216.98.0     - 91.216.99.255
	{ 0x5bd86500, 0x5bd879ff, REGISTRY_RIPENCC    }, // 91.216.101.0    - 91.216.121.255
	{ 0x5bd87b00, 0x5bd8a1ff, REGISTRY_RIPENCC    }, // 91.216.123.0    - 91.216.161.255
	{ 0x5bd8a200, 0x5bd8a2ff, REGISTRY_RIPENCC    }, // 91.216.162.0    - 91.216.162.255
	{ 0x5bd8a300, 0x5bd8a8ff, REGISTRY_RIPENCC    }, // 91.216.163.0    - 91.216.168.255
	{ 0x5bd8aa00, 0x5bd8b1ff, REGISTRY_RIPENCC    }, // 91.216.170.0    - 91.216.177.255
	{ 0x5bd8b200, 0x5bd8b2ff, REGISTRY_RIPENCC    }, // 91.216.178.0    - 91.216.178.255
	{ 0x5bd8b300, 0x5bd8bdff, REGISTRY_RIPENCC    }, // 91.216.179.0    - 91.216.189.255
	{ 0x5bd8bf00, 0x5bd8d0ff, REGISTRY_RIPENCC    }, // 91.216.191.0    - 91.216.208.255
	{ 0x5bd8d100, 0x5bd8d1ff, REGISTRY_RIPENCC    }, // 91.216.209.0    - 91.216.209.255
	{ 0x5bd8d200, 0x5bd8d6ff, REGISTRY_RIPENCC    }, // 91.216.210.0    - 91.216.214.255
	{ 0x5bd8d800, 0x5bd8f6ff, REGISTRY_RIPENCC    }, // 91.216.216.0    - 91.216.246.255
	{ 0x5bd8f700, 0x5bd8f7ff, REGISTRY_RIPENCC    }, // 91.216.247.0    - 91.216.247.255
	{ 0x5bd8f800, 0x5bd905ff, REGISTRY_RIPENCC    }, // 91.216.248.0    - 91.217.5.255
	{ 0x5bd90800, 0x5bd911ff, REGISTRY_RIPENCC    }, // 91.217.8.0      - 91.217.17.255
	{ 0x5bd91200, 0x5bd913ff, REGISTRY_RIPENCC    }, // 91.217.18.0     - 91.217.19.255
	{ 0x5bd91400, 0x5bd919ff, REGISTRY_RIPENCC    }, // 91.217.20.0     - 91.217.25.255
	{ 0x5bd91a00, 0x5bd91bff, REGISTRY_RIPENCC    }, // 91.217.26.0     - 91.217.27.255
	{ 0x5bd91c00, 0x5bd947ff, REGISTRY_RIPENCC    }, // 91.217.28.0     - 91.217.71.255
	{ 0x5bd94a00, 0x5bd94bff, REGISTRY_RIPENCC    }, // 91.217.74.0     - 91.217.75.255
	{ 0x5bd94e00, 0x5bd94fff, REGISTRY_RIPENCC    }, // 91.217.78.0     - 91.217.79.255
	{ 0x5bd95200, 0x5bd977ff, REGISTRY_RIPENCC    }, // 91.217.82.0     - 91.217.119.255
	{ 0x5bd97a00, 0x5bd986ff, REGISTRY_RIPENCC    }, // 91.217.122.0    - 91.217.134.255
	{ 0x5bd98800, 0x5bd98aff, REGISTRY_RIPENCC    }, // 91.217.136.0    - 91.217.138.255
	{ 0x5bd98c00, 0x5bd98fff, REGISTRY_RIPENCC    }, // 91.217.140.0    - 91.217.143.255
	{ 0x5bd99000, 0x5bd990ff, REGISTRY_RIPENCC    }, // 91.217.144.0    - 91.217.144.255
	{ 0x5bd99100, 0x5bd9a1ff, REGISTRY_RIPENCC    }, // 91.217.145.0    - 91.217.161.255
	{ 0x5bd9a300, 0x5bd9a6ff, REGISTRY_RIPENCC    }, // 91.217.163.0    - 91.217.166.255
	{ 0x5bd9a800, 0x5bd9c2ff, REGISTRY_RIPENCC    }, // 91.217.168.0    - 91.217.194.255
	{ 0x5bd9c400, 0x5bd9c7ff, REGISTRY_RIPENCC    }, // 91.217.196.0    - 91.217.199.255
	{ 0x5bd9c900, 0x5bd9ceff, REGISTRY_RIPENCC    }, // 91.217.201.0    - 91.217.206.255
	{ 0x5bd9d000, 0x5bd9deff, REGISTRY_RIPENCC    }, // 91.217.208.0    - 91.217.222.255
	{ 0x5bd9e000, 0x5bd9ebff, REGISTRY_RIPENCC    }, // 91.217.224.0    - 91.217.235.255
	{ 0x5bd9ed00, 0x5bd9eeff, REGISTRY_RIPENCC    }, // 91.217.237.0    - 91.217.238.255
	{ 0x5bd9f000, 0x5bd9f8ff, REGISTRY_RIPENCC    }, // 91.217.240.0    - 91.217.248.255
	{ 0x5bd9fb00, 0x5bd9fcff, REGISTRY_RIPENCC    }, // 91.217.251.0    - 91.217.252.255
	{ 0x5bd9fe00, 0x5bda13ff, REGISTRY_RIPENCC    }, // 91.217.254.0    - 91.218.19.255
	{ 0x5bda1400, 0x5bda17ff, REGISTRY_RIPENCC    }, // 91.218.20.0     - 91.218.23.255
	{ 0x5bda1800, 0x5bda23ff, REGISTRY_RIPENCC    }, // 91.218.24.0     - 91.218.35.255
	{ 0x5bda2400, 0x5bda27ff, REGISTRY_RIPENCC    }, // 91.218.36.0     - 91.218.39.255
	{ 0x5bda2800, 0x5bda37ff, REGISTRY_RIPENCC    }, // 91.218.40.0     - 91.218.55.255
	{ 0x5bda3800, 0x5bda3bff, REGISTRY_RIPENCC    }, // 91.218.56.0     - 91.218.59.255
	{ 0x5bda3c00, 0x5bda3fff, REGISTRY_RIPENCC    }, // 91.218.60.0     - 91.218.63.255
	{ 0x5bda4000, 0x5bda43ff, REGISTRY_RIPENCC    }, // 91.218.64.0     - 91.218.67.255
	{ 0x5bda4400, 0x5bda83ff, REGISTRY_RIPENCC    }, // 91.218.68.0     - 91.218.131.255
	{ 0x5bda8400, 0x5bda87ff, REGISTRY_RIPENCC    }, // 91.218.132.0    - 91.218.135.255
	{ 0x5bda8800, 0x5bdacbff, REGISTRY_RIPENCC    }, // 91.218.136.0    - 91.218.203.255
	{ 0x5bdacc00, 0x5bdacfff, REGISTRY_RIPENCC    }, // 91.218.204.0    - 91.218.207.255
	{ 0x5bdad000, 0x5bdaebff, REGISTRY_RIPENCC    }, // 91.218.208.0    - 91.218.235.255
	{ 0x5bdaec00, 0x5bdaefff, REGISTRY_RIPENCC    }, // 91.218.236.0    - 91.218.239.255
	{ 0x5bdaf000, 0x5bdafbff, REGISTRY_RIPENCC    }, // 91.218.240.0    - 91.218.251.255
	{ 0x5bdafc00, 0x5bdaffff, REGISTRY_RIPENCC    }, // 91.218.252.0    - 91.218.255.255
	{ 0x5bdb0000, 0x5bdb07ff, REGISTRY_RIPENCC    }, // 91.219.0.0      - 91.219.7.255
	{ 0x5bdb0800, 0x5bdb0bff, REGISTRY_RIPENCC    }, // 91.219.8.0      - 91.219.11.255
	{ 0x5bdb0c00, 0x5bdb0fff, REGISTRY_RIPENCC    }, // 91.219.12.0     - 91.219.15.255
	{ 0x5bdb1000, 0x5bdb13ff, REGISTRY_RIPENCC    }, // 91.219.16.0     - 91.219.19.255
	{ 0x5bdb1400, 0x5bdb3fff, REGISTRY_RIPENCC    }, // 91.219.20.0     - 91.219.63.255
	{ 0x5bdb4000, 0x5bdb43ff, REGISTRY_RIPENCC    }, // 91.219.64.0     - 91.219.67.255
	{ 0x5bdb4400, 0x5bdb5bff, REGISTRY_RIPENCC    }, // 91.219.68.0     - 91.219.91.255
	{ 0x5bdb5c00, 0x5bdb5fff, REGISTRY_RIPENCC    }, // 91.219.92.0     - 91.219.95.255
	{ 0x5bdb6000, 0x5bdc1bff, REGISTRY_RIPENCC    }, // 91.219.96.0     - 91.220.27.255
	{ 0x5bdc1d00, 0x5bdc22ff, REGISTRY_RIPENCC    }, // 91.220.29.0     - 91.220.34.255
	{ 0x5bdc2400, 0x5bdc46ff, REGISTRY_RIPENCC    }, // 91.220.36.0     - 91.220.70.255
	{ 0x5bdc4800, 0x5bdc50ff, REGISTRY_RIPENCC    }, // 91.220.72.0     - 91.220.80.255
	{ 0x5bdc5200, 0x5bdc53ff, REGISTRY_RIPENCC    }, // 91.220.82.0     - 91.220.83.255
	{ 0x5bdc5500, 0x5bdc59ff, REGISTRY_RIPENCC    }, // 91.220.85.0     - 91.220.89.255
	{ 0x5bdc5b00, 0x5bdc7dff, REGISTRY_RIPENCC    }, // 91.220.91.0     - 91.220.125.255
	{ 0x5bdc7f00, 0x5bdc82ff, REGISTRY_RIPENCC    }, // 91.220.127.0    - 91.220.130.255
	{ 0x5bdc8400, 0x5bdcaaff, REGISTRY_RIPENCC    }, // 91.220.132.0    - 91.220.170.255
	{ 0x5bdcac00, 0x5bdcafff, REGISTRY_RIPENCC    }, // 91.220.172.0    - 91.220.175.255
	{ 0x5bdcb100, 0x5bdcb3ff, REGISTRY_RIPENCC    }, // 91.220.177.0    - 91.220.179.255
	{ 0x5bdcb400, 0x5bdcb4ff, REGISTRY_RIPENCC    }, // 91.220.180.0    - 91.220.180.255
	{ 0x5bdcb500, 0x5bdcb7ff, REGISTRY_RIPENCC    }, // 91.220.181.0    - 91.220.183.255
	{ 0x5bdcb900, 0x5bdcb9ff, REGISTRY_RIPENCC    }, // 91.220.185.0    - 91.220.185.255
	{ 0x5bdcbb00, 0x5bdcc9ff, REGISTRY_RIPENCC    }, // 91.220.187.0    - 91.220.201.255
	{ 0x5bdccc00, 0x5bdccdff, REGISTRY_RIPENCC    }, // 91.220.204.0    - 91.220.205.255
	{ 0x5bdccf00, 0x5bdcdeff, REGISTRY_RIPENCC    }, // 91.220.207.0    - 91.220.222.255
	{ 0x5bdce000, 0x5bdce4ff, REGISTRY_RIPENCC    }, // 91.220.224.0    - 91.220.228.255
	{ 0x5bdce600, 0x5bdd41ff, REGISTRY_RIPENCC    }, // 91.220.230.0    - 91.221.65.255
	{ 0x5bdd4200, 0x5bdd43ff, REGISTRY_RIPENCC    }, // 91.221.66.0     - 91.221.67.255
	{ 0x5bdd4400, 0x5bdd4bff, REGISTRY_RIPENCC    }, // 91.221.68.0     - 91.221.75.255
	{ 0x5bdd4e00, 0x5bdd55ff, REGISTRY_RIPENCC    }, // 91.221.78.0     - 91.221.85.255
	{ 0x5bdd5800, 0x5bdd5bff, REGISTRY_RIPENCC    }, // 91.221.88.0     - 91.221.91.255
	{ 0x5bdd5e00, 0x5bdd62ff, REGISTRY_RIPENCC    }, // 91.221.94.0     - 91.221.98.255
	{ 0x5bdd6300, 0x5bdd63ff, REGISTRY_RIPENCC    }, // 91.221.99.0     - 91.221.99.255
	{ 0x5bdd6400, 0x5bdd69ff, REGISTRY_RIPENCC    }, // 91.221.100.0    - 91.221.105.255
	{ 0x5bdd6c00, 0x5bdd6dff, REGISTRY_RIPENCC    }, // 91.221.108.0    - 91.221.109.255
	{ 0x5bdd6e00, 0x5bdd6fff, REGISTRY_RIPENCC    }, // 91.221.110.0    - 91.221.111.255
	{ 0x5bdd7000, 0x5bdd73ff, REGISTRY_RIPENCC    }, // 91.221.112.0    - 91.221.115.255
	{ 0x5bdd7600, 0x5bdde7ff, REGISTRY_RIPENCC    }, // 91.221.118.0    - 91.221.231.255
	{ 0x5bddea00, 0x5bddefff, REGISTRY_RIPENCC    }, // 91.221.234.0    - 91.221.239.255
	{ 0x5bddf200, 0x5bddf5ff, REGISTRY_RIPENCC    }, // 91.221.242.0    - 91.221.245.255
	{ 0x5bddf600, 0x5bddf7ff, REGISTRY_RIPENCC    }, // 91.221.246.0    - 91.221.247.255
	{ 0x5bddf800, 0x5bde07ff, REGISTRY_RIPENCC    }, // 91.221.248.0    - 91.222.7.255
	{ 0x5bde0800, 0x5bde0bff, REGISTRY_RIPENCC    }, // 91.222.8.0      - 91.222.11.255
	{ 0x5bde0c00, 0x5bde77ff, REGISTRY_RIPENCC    }, // 91.222.12.0     - 91.222.119.255
	{ 0x5bde7800, 0x5bde7bff, REGISTRY_RIPENCC    }, // 91.222.120.0    - 91.222.123.255
	{ 0x5bde7c00, 0x5bdecbff, REGISTRY_RIPENCC    }, // 91.222.124.0    - 91.222.203.255
	{ 0x5bdecc00, 0x5bdecfff, REGISTRY_RIPENCC    }, // 91.222.204.0    - 91.222.207.255
	{ 0x5bded000, 0x5bdeebff, REGISTRY_RIPENCC    }, // 91.222.208.0    - 91.222.235.255
	{ 0x5bdeec00, 0x5bdeefff, REGISTRY_RIPENCC    }, // 91.222.236.0    - 91.222.239.255
	{ 0x5bdef000, 0x5bdf1bff, REGISTRY_RIPENCC    }, // 91.222.240.0    - 91.223.27.255
	{ 0x5bdf1d00, 0x5bdf42ff, REGISTRY_RIPENCC    }, // 91.223.29.0     - 91.223.66.255
	{ 0x5bdf4300, 0x5bdf43ff, REGISTRY_RIPENCC    }, // 91.223.67.0     - 91.223.67.255
	{ 0x5bdf4400, 0x5bdf45ff, REGISTRY_RIPENCC    }, // 91.223.68.0     - 91.223.69.255
	{ 0x5bdf4700, 0x5bdf4aff, REGISTRY_RIPENCC    }, // 91.223.71.0     - 91.223.74.255
	{ 0x5bdf4c00, 0x5bdf58ff, REGISTRY_RIPENCC    }, // 91.223.76.0     - 91.223.88.255
	{ 0x5bdf5a00, 0x5bdf62ff, REGISTRY_RIPENCC    }, // 91.223.90.0     - 91.223.98.255
	{ 0x5bdf6400, 0x5bdf65ff, REGISTRY_RIPENCC    }, // 91.223.100.0    - 91.223.101.255
	{ 0x5bdf6700, 0x5bdf69ff, REGISTRY_RIPENCC    }, // 91.223.103.0    - 91.223.105.255
	{ 0x5bdf6a00, 0x5bdf6aff, REGISTRY_RIPENCC    }, // 91.223.106.0    - 91.223.106.255
	{ 0x5bdf6b00, 0x5bdf74ff, REGISTRY_RIPENCC    }, // 91.223.107.0    - 91.223.116.255
	{ 0x5bdf7500, 0x5bdf75ff, REGISTRY_RIPENCC    }, // 91.223.117.0    - 91.223.117.255
	{ 0x5bdf7600, 0x5bdf7dff, REGISTRY_RIPENCC    }, // 91.223.118.0    - 91.223.125.255
	{ 0x5bdf7f00, 0x5bdf96ff, REGISTRY_RIPENCC    }, // 91.223.127.0    - 91.223.150.255
	{ 0x5bdf9700, 0x5bdf97ff, REGISTRY_RIPENCC    }, // 91.223.151.0    - 91.223.151.255
	{ 0x5bdf9800, 0x5bdf9aff, REGISTRY_RIPENCC    }, // 91.223.152.0    - 91.223.154.255
	{ 0x5bdf9b00, 0x5bdf9bff, REGISTRY_RIPENCC    }, // 91.223.155.0    - 91.223.155.255
	{ 0x5bdf9c00, 0x5bdf9dff, REGISTRY_RIPENCC    }, // 91.223.156.0    - 91.223.157.255
	{ 0x5bdf9e00, 0x5bdf9eff, REGISTRY_RIPENCC    }, // 91.223.158.0    - 91.223.158.255
	{ 0x5bdf9f00, 0x5bdfa2ff, REGISTRY_RIPENCC    }, // 91.223.159.0    - 91.223.162.255
	{ 0x5bdfa400, 0x5bdfa8ff, REGISTRY_RIPENCC    }, // 91.223.164.0    - 91.223.168.255
	{ 0x5bdfaa00, 0x5bdfaaff, REGISTRY_RIPENCC    }, // 91.223.170.0    - 91.223.170.255
	{ 0x5bdfab00, 0x5bdfabff, REGISTRY_RIPENCC    }, // 91.223.171.0    - 91.223.171.255
	{ 0x5bdfac00, 0x5bdfebff, REGISTRY_RIPENCC    }, // 91.223.172.0    - 91.223.235.255
	{ 0x5bdfed00, 0x5bdffdff, REGISTRY_RIPENCC    }, // 91.223.237.0    - 91.223.253.255
	{ 0x5bdffe00, 0x5bdffeff, REGISTRY_RIPENCC    }, // 91.223.254.0    - 91.223.254.255
	{ 0x5bdfff00, 0x5be00bff, REGISTRY_RIPENCC    }, // 91.223.255.0    - 91.224.11.255
	{ 0x5be00c00, 0x5be00dff, REGISTRY_RIPENCC    }, // 91.224.12.0     - 91.224.13.255
	{ 0x5be00e00, 0x5be013ff, REGISTRY_RIPENCC    }, // 91.224.14.0     - 91.224.19.255
	{ 0x5be01600, 0x5be027ff, REGISTRY_RIPENCC    }, // 91.224.22.0     - 91.224.39.255
	{ 0x5be02800, 0x5be029ff, REGISTRY_RIPENCC    }, // 91.224.40.0     - 91.224.41.255
	{ 0x5be02a00, 0x5be03fff, REGISTRY_RIPENCC    }, // 91.224.42.0     - 91.224.63.255
	{ 0x5be04200, 0x5be05bff, REGISTRY_RIPENCC    }, // 91.224.66.0     - 91.224.91.255
	{ 0x5be05c00, 0x5be05dff, REGISTRY_RIPENCC    }, // 91.224.92.0     - 91.224.93.255
	{ 0x5be05e00, 0x5be063ff, REGISTRY_RIPENCC    }, // 91.224.94.0     - 91.224.99.255
	{ 0x5be06600, 0x5be06bff, REGISTRY_RIPENCC    }, // 91.224.102.0    - 91.224.107.255
	{ 0x5be06c00, 0x5be06dff, REGISTRY_RIPENCC    }, // 91.224.108.0    - 91.224.109.255
	{ 0x5be06e00, 0x5be09fff, REGISTRY_RIPENCC    }, // 91.224.110.0    - 91.224.159.255
	{ 0x5be0a200, 0x5be0d3ff, REGISTRY_RIPENCC    }, // 91.224.162.0    - 91.224.211.255
	{ 0x5be0d400, 0x5be0d5ff, REGISTRY_RIPENCC    }, // 91.224.212.0    - 91.224.213.255
	{ 0x5be0d600, 0x5be0dfff, REGISTRY_RIPENCC    }, // 91.224.214.0    - 91.224.223.255
	{ 0x5be0e000, 0x5be0e1ff, REGISTRY_RIPENCC    }, // 91.224.224.0    - 91.224.225.255
	{ 0x5be0e200, 0x5be0e3ff, REGISTRY_RIPENCC    }, // 91.224.226.0    - 91.224.227.255
	{ 0x5be0e600, 0x5be0f5ff, REGISTRY_RIPENCC    }, // 91.224.230.0    - 91.224.245.255
	{ 0x5be0f800, 0x5be107ff, REGISTRY_RIPENCC    }, // 91.224.248.0    - 91.225.7.255
	{ 0x5be10800, 0x5be10fff, REGISTRY_RIPENCC    }, // 91.225.8.0      - 91.225.15.255
	{ 0x5be11000, 0x5be11fff, REGISTRY_RIPENCC    }, // 91.225.16.0     - 91.225.31.255
	{ 0x5be12000, 0x5be121ff, REGISTRY_ARIN       }, // 91.225.32.0     - 91.225.33.255
	{ 0x5be12200, 0x5be123ff, REGISTRY_RIPENCC    }, // 91.225.34.0     - 91.225.35.255
	{ 0x5be12400, 0x5be1cbff, REGISTRY_RIPENCC    }, // 91.225.36.0     - 91.225.203.255
	{ 0x5be1cc00, 0x5be1cfff, REGISTRY_RIPENCC    }, // 91.225.204.0    - 91.225.207.255
	{ 0x5be1d000, 0x5be21dff, REGISTRY_RIPENCC    }, // 91.225.208.0    - 91.226.29.255
	{ 0x5be21e00, 0x5be21fff, REGISTRY_RIPENCC    }, // 91.226.30.0     - 91.226.31.255
	{ 0x5be22000, 0x5be227ff, REGISTRY_RIPENCC    }, // 91.226.32.0     - 91.226.39.255
	{ 0x5be22a00, 0x5be233ff, REGISTRY_RIPENCC    }, // 91.226.42.0     - 91.226.51.255
	{ 0x5be23400, 0x5be237ff, REGISTRY_RIPENCC    }, // 91.226.52.0     - 91.226.55.255
	{ 0x5be23800, 0x5be247ff, REGISTRY_RIPENCC    }, // 91.226.56.0     - 91.226.71.255
	{ 0x5be24900, 0x5be24bff, REGISTRY_RIPENCC    }, // 91.226.73.0     - 91.226.75.255
	{ 0x5be24d00, 0x5be24dff, REGISTRY_RIPENCC    }, // 91.226.77.0     - 91.226.77.255
	{ 0x5be24f00, 0x5be253ff, REGISTRY_RIPENCC    }, // 91.226.79.0     - 91.226.83.255
	{ 0x5be25400, 0x5be25bff, REGISTRY_RIPENCC    }, // 91.226.84.0     - 91.226.91.255
	{ 0x5be25c00, 0x5be25fff, REGISTRY_RIPENCC    }, // 91.226.92.0     - 91.226.95.255
	{ 0x5be26100, 0x5be29fff, REGISTRY_RIPENCC    }, // 91.226.97.0     - 91.226.159.255
	{ 0x5be2a100, 0x5be2b7ff, REGISTRY_RIPENCC    }, // 91.226.161.0    - 91.226.183.255
	{ 0x5be2b900, 0x5be2dcff, REGISTRY_RIPENCC    }, // 91.226.185.0    - 91.226.220.255
	{ 0x5be2de00, 0x5be353ff, REGISTRY_RIPENCC    }, // 91.226.222.0    - 91.227.83.255
	{ 0x5be35400, 0x5be357ff, REGISTRY_RIPENCC    }, // 91.227.84.0     - 91.227.87.255
	{ 0x5be35800, 0x5be365ff, REGISTRY_RIPENCC    }, // 91.227.88.0     - 91.227.101.255
	{ 0x5be36600, 0x5be36bff, REGISTRY_RIPENCC    }, // 91.227.102.0    - 91.227.107.255
	{ 0x5be36c00, 0x5be383ff, REGISTRY_RIPENCC    }, // 91.227.108.0    - 91.227.131.255
	{ 0x5be38600, 0x5be388ff, REGISTRY_RIPENCC    }, // 91.227.134.0    - 91.227.136.255
	{ 0x5be38a00, 0x5be397ff, REGISTRY_RIPENCC    }, // 91.227.138.0    - 91.227.151.255
	{ 0x5be39800, 0x5be39bff, REGISTRY_RIPENCC    }, // 91.227.152.0    - 91.227.155.255
	{ 0x5be39c00, 0x5be3a7ff, REGISTRY_RIPENCC    }, // 91.227.156.0    - 91.227.167.255
	{ 0x5be3a900, 0x5be3a9ff, REGISTRY_RIPENCC    }, // 91.227.169.0    - 91.227.169.255
	{ 0x5be3ac00, 0x5be3c7ff, REGISTRY_RIPENCC    }, // 91.227.172.0    - 91.227.199.255
	{ 0x5be3c800, 0x5be3cbff, REGISTRY_RIPENCC    }, // 91.227.200.0    - 91.227.203.255
	{ 0x5be3cc00, 0x5be3e5ff, REGISTRY_RIPENCC    }, // 91.227.204.0    - 91.227.229.255
	{ 0x5be3e600, 0x5be3e7ff, REGISTRY_RIPENCC    }, // 91.227.230.0    - 91.227.231.255
	{ 0x5be3e800, 0x5be3ebff, REGISTRY_RIPENCC    }, // 91.227.232.0    - 91.227.235.255
	{ 0x5be3ec00, 0x5be3efff, REGISTRY_RIPENCC    }, // 91.227.236.0    - 91.227.239.255
	{ 0x5be3f000, 0x5be3f5ff, REGISTRY_RIPENCC    }, // 91.227.240.0    - 91.227.245.255
	{ 0x5be3f800, 0x5be3fcff, REGISTRY_RIPENCC    }, // 91.227.248.0    - 91.227.252.255
	{ 0x5be3fe00, 0x5be415ff, REGISTRY_RIPENCC    }, // 91.227.254.0    - 91.228.21.255
	{ 0x5be41800, 0x5be419ff, REGISTRY_RIPENCC    }, // 91.228.24.0     - 91.228.25.255
	{ 0x5be41a00, 0x5be41cff, REGISTRY_RIPENCC    }, // 91.228.26.0     - 91.228.28.255
	{ 0x5be41d00, 0x5be41dff, REGISTRY_RIPENCC    }, // 91.228.29.0     - 91.228.29.255
	{ 0x5be41e00, 0x5be423ff, REGISTRY_RIPENCC    }, // 91.228.30.0     - 91.228.35.255
	{ 0x5be42400, 0x5be425ff, REGISTRY_RIPENCC    }, // 91.228.36.0     - 91.228.37.255
	{ 0x5be42600, 0x5be43fff, REGISTRY_RIPENCC    }, // 91.228.38.0     - 91.228.63.255
	{ 0x5be44000, 0x5be443ff, REGISTRY_RIPENCC    }, // 91.228.64.0     - 91.228.67.255
	{ 0x5be44400, 0x5be476ff, REGISTRY_RIPENCC    }, // 91.228.68.0     - 91.228.118.255
	{ 0x5be47700, 0x5be477ff, REGISTRY_RIPENCC    }, // 91.228.119.0    - 91.228.119.255
	{ 0x5be47800, 0x5be47dff, REGISTRY_RIPENCC    }, // 91.228.120.0    - 91.228.125.255
	{ 0x5be47e00, 0x5be483ff, REGISTRY_RIPENCC    }, // 91.228.126.0    - 91.228.131.255
	{ 0x5be48700, 0x5be494ff, REGISTRY_RIPENCC    }, // 91.228.135.0    - 91.228.148.255
	{ 0x5be49600, 0x5be496ff, REGISTRY_RIPENCC    }, // 91.228.150.0    - 91.228.150.255
	{ 0x5be49700, 0x5be497ff, REGISTRY_RIPENCC    }, // 91.228.151.0    - 91.228.151.255
	{ 0x5be49800, 0x5be49fff, REGISTRY_RIPENCC    }, // 91.228.152.0    - 91.228.159.255
	{ 0x5be4a100, 0x5be4abff, REGISTRY_RIPENCC    }, // 91.228.161.0    - 91.228.171.255
	{ 0x5be4ac00, 0x5be4afff, REGISTRY_RIPENCC    }, // 91.228.172.0    - 91.228.175.255
	{ 0x5be4b000, 0x5be4cdff, REGISTRY_RIPENCC    }, // 91.228.176.0    - 91.228.205.255
	{ 0x5be4cf00, 0x5be4e6ff, REGISTRY_RIPENCC    }, // 91.228.207.0    - 91.228.230.255
	{ 0x5be4e800, 0x5be4faff, REGISTRY_RIPENCC    }, // 91.228.232.0    - 91.228.250.255
	{ 0x5be4fc00, 0x5be504ff, REGISTRY_RIPENCC    }, // 91.228.252.0    - 91.229.4.255
	{ 0x5be50600, 0x5be506ff, REGISTRY_RIPENCC    }, // 91.229.6.0      - 91.229.6.255
	{ 0x5be50700, 0x5be50fff, REGISTRY_RIPENCC    }, // 91.229.7.0      - 91.229.15.255
	{ 0x5be51000, 0x5be513ff, REGISTRY_RIPENCC    }, // 91.229.16.0     - 91.229.19.255
	{ 0x5be51400, 0x5be518ff, REGISTRY_RIPENCC    }, // 91.229.20.0     - 91.229.24.255
	{ 0x5be51a00, 0x5be51dff, REGISTRY_RIPENCC    }, // 91.229.26.0     - 91.229.29.255
	{ 0x5be51e00, 0x5be51fff, REGISTRY_RIPENCC    }, // 91.229.30.0     - 91.229.31.255
	{ 0x5be52000, 0x5be52dff, REGISTRY_RIPENCC    }, // 91.229.32.0     - 91.229.45.255
	{ 0x5be53000, 0x5be537ff, REGISTRY_RIPENCC    }, // 91.229.48.0     - 91.229.55.255
	{ 0x5be53900, 0x5be54fff, REGISTRY_RIPENCC    }, // 91.229.57.0     - 91.229.79.255
	{ 0x5be55000, 0x5be553ff, REGISTRY_RIPENCC    }, // 91.229.80.0     - 91.229.83.255
	{ 0x5be55400, 0x5be559ff, REGISTRY_RIPENCC    }, // 91.229.84.0     - 91.229.89.255
	{ 0x5be55c00, 0x5be567ff, REGISTRY_RIPENCC    }, // 91.229.92.0     - 91.229.103.255
	{ 0x5be56a00, 0x5be583ff, REGISTRY_RIPENCC    }, // 91.229.106.0    - 91.229.131.255
	{ 0x5be58400, 0x5be587ff, REGISTRY_RIPENCC    }, // 91.229.132.0    - 91.229.135.255
	{ 0x5be58800, 0x5be592ff, REGISTRY_RIPENCC    }, // 91.229.136.0    - 91.229.146.255
	{ 0x5be59300, 0x5be593ff, REGISTRY_RIPENCC    }, // 91.229.147.0    - 91.229.147.255
	{ 0x5be59400, 0x5be59bff, REGISTRY_RIPENCC    }, // 91.229.148.0    - 91.229.155.255
	{ 0x5be59c00, 0x5be59fff, REGISTRY_RIPENCC    }, // 91.229.156.0    - 91.229.159.255
	{ 0x5be5a000, 0x5be5b5ff, REGISTRY_RIPENCC    }, // 91.229.160.0    - 91.229.181.255
	{ 0x5be5b700, 0x5be5b8ff, REGISTRY_RIPENCC    }, // 91.229.183.0    - 91.229.184.255
	{ 0x5be5ba00, 0x5be5d1ff, REGISTRY_RIPENCC    }, // 91.229.186.0    - 91.229.209.255
	{ 0x5be5d300, 0x5be5e4ff, REGISTRY_RIPENCC    }, // 91.229.211.0    - 91.229.228.255
	{ 0x5be5e600, 0x5be5e7ff, REGISTRY_RIPENCC    }, // 91.229.230.0    - 91.229.231.255
	{ 0x5be5e800, 0x5be5f3ff, REGISTRY_RIPENCC    }, // 91.229.232.0    - 91.229.243.255
	{ 0x5be5f600, 0x5be5f7ff, REGISTRY_RIPENCC    }, // 91.229.246.0    - 91.229.247.255
	{ 0x5be5f900, 0x5be61aff, REGISTRY_RIPENCC    }, // 91.229.249.0    - 91.230.26.255
	{ 0x5be61c00, 0x5be623ff, REGISTRY_RIPENCC    }, // 91.230.28.0     - 91.230.35.255
	{ 0x5be62400, 0x5be625ff, REGISTRY_RIPENCC    }, // 91.230.36.0     - 91.230.37.255
	{ 0x5be62800, 0x5be62eff, REGISTRY_RIPENCC    }, // 91.230.40.0     - 91.230.46.255
	{ 0x5be63000, 0x5be651ff, REGISTRY_RIPENCC    }, // 91.230.48.0     - 91.230.81.255
	{ 0x5be65300, 0x5be66dff, REGISTRY_RIPENCC    }, // 91.230.83.0     - 91.230.109.255
	{ 0x5be67000, 0x5be685ff, REGISTRY_RIPENCC    }, // 91.230.112.0    - 91.230.133.255
	{ 0x5be68700, 0x5be687ff, REGISTRY_RIPENCC    }, // 91.230.135.0    - 91.230.135.255
	{ 0x5be68800, 0x5be68bff, REGISTRY_RIPENCC    }, // 91.230.136.0    - 91.230.139.255
	{ 0x5be68c00, 0x5be68eff, REGISTRY_RIPENCC    }, // 91.230.140.0    - 91.230.142.255
	{ 0x5be69000, 0x5be692ff, REGISTRY_RIPENCC    }, // 91.230.144.0    - 91.230.146.255
	{ 0x5be69400, 0x5be695ff, REGISTRY_RIPENCC    }, // 91.230.148.0    - 91.230.149.255
	{ 0x5be69600, 0x5be696ff, REGISTRY_RIPENCC    }, // 91.230.150.0    - 91.230.150.255
	{ 0x5be69700, 0x5be697ff, REGISTRY_RIPENCC    }, // 91.230.151.0    - 91.230.151.255
	{ 0x5be69800, 0x5be69bff, REGISTRY_RIPENCC    }, // 91.230.152.0    - 91.230.155.255
	{ 0x5be69c00, 0x5be6a7ff, REGISTRY_RIPENCC    }, // 91.230.156.0    - 91.230.167.255
	{ 0x5be6a900, 0x5be6b5ff, REGISTRY_RIPENCC    }, // 91.230.169.0    - 91.230.181.255
	{ 0x5be6b800, 0x5be6bbff, REGISTRY_RIPENCC    }, // 91.230.184.0    - 91.230.187.255
	{ 0x5be6bd00, 0x5be6e3ff, REGISTRY_RIPENCC    }, // 91.230.189.0    - 91.230.227.255
	{ 0x5be6e600, 0x5be72eff, REGISTRY_RIPENCC    }, // 91.230.230.0    - 91.231.46.255
	{ 0x5be73000, 0x5be733ff, REGISTRY_RIPENCC    }, // 91.231.48.0     - 91.231.51.255
	{ 0x5be73400, 0x5be758ff, REGISTRY_RIPENCC    }, // 91.231.52.0     - 91.231.88.255
	{ 0x5be75a00, 0x5be77dff, REGISTRY_RIPENCC    }, // 91.231.90.0     - 91.231.125.255
	{ 0x5be77f00, 0x5be77fff, REGISTRY_RIPENCC    }, // 91.231.127.0    - 91.231.127.255
	{ 0x5be78000, 0x5be78dff, REGISTRY_RIPENCC    }, // 91.231.128.0    - 91.231.141.255
	{ 0x5be79000, 0x5be790ff, REGISTRY_RIPENCC    }, // 91.231.144.0    - 91.231.144.255
	{ 0x5be79100, 0x5be79bff, REGISTRY_RIPENCC    }, // 91.231.145.0    - 91.231.155.255
	{ 0x5be79d00, 0x5be7b9ff, REGISTRY_RIPENCC    }, // 91.231.157.0    - 91.231.185.255
	{ 0x5be7bc00, 0x5be7c7ff, REGISTRY_RIPENCC    }, // 91.231.188.0    - 91.231.199.255
	{ 0x5be7c800, 0x5be7cbff, REGISTRY_RIPENCC    }, // 91.231.200.0    - 91.231.203.255
	{ 0x5be7cc00, 0x5be7ceff, REGISTRY_RIPENCC    }, // 91.231.204.0    - 91.231.206.255
	{ 0x5be7cf00, 0x5be7d3ff, REGISTRY_RIPENCC    }, // 91.231.207.0    - 91.231.211.255
	{ 0x5be7d400, 0x5be7deff, REGISTRY_RIPENCC    }, // 91.231.212.0    - 91.231.222.255
	{ 0x5be7df00, 0x5be7e3ff, REGISTRY_RIPENCC    }, // 91.231.223.0    - 91.231.227.255
	{ 0x5be7e400, 0x5be80fff, REGISTRY_RIPENCC    }, // 91.231.228.0    - 91.232.15.255
	{ 0x5be81000, 0x5be814ff, REGISTRY_RIPENCC    }, // 91.232.16.0     - 91.232.20.255
	{ 0x5be81500, 0x5be815ff, REGISTRY_RIPENCC    }, // 91.232.21.0     - 91.232.21.255
	{ 0x5be81800, 0x5be82bff, REGISTRY_RIPENCC    }, // 91.232.24.0     - 91.232.43.255
	{ 0x5be82c00, 0x5be82dff, REGISTRY_RIPENCC    }, // 91.232.44.0     - 91.232.45.255
	{ 0x5be82e00, 0x5be836ff, REGISTRY_RIPENCC    }, // 91.232.46.0     - 91.232.54.255
	{ 0x5be83700, 0x5be839ff, REGISTRY_RIPENCC    }, // 91.232.55.0     - 91.232.57.255
	{ 0x5be83a00, 0x5be850ff, REGISTRY_RIPENCC    }, // 91.232.58.0     - 91.232.80.255
	{ 0x5be85100, 0x5be851ff, REGISTRY_RIPENCC    }, // 91.232.81.0     - 91.232.81.255
	{ 0x5be85200, 0x5be862ff, REGISTRY_RIPENCC    }, // 91.232.82.0     - 91.232.98.255
	{ 0x5be86400, 0x5be865ff, REGISTRY_RIPENCC    }, // 91.232.100.0    - 91.232.101.255
	{ 0x5be86600, 0x5be866ff, REGISTRY_RIPENCC    }, // 91.232.102.0    - 91.232.102.255
	{ 0x5be86800, 0x5be87eff, REGISTRY_RIPENCC    }, // 91.232.104.0    - 91.232.126.255
	{ 0x5be87f00, 0x5be87fff, REGISTRY_RIPENCC    }, // 91.232.127.0    - 91.232.127.255
	{ 0x5be88000, 0x5be880ff, REGISTRY_RIPENCC    }, // 91.232.128.0    - 91.232.128.255
	{ 0x5be88200, 0x5be895ff, REGISTRY_RIPENCC    }, // 91.232.130.0    - 91.232.149.255
	{ 0x5be89600, 0x5be897ff, REGISTRY_RIPENCC    }, // 91.232.150.0    - 91.232.151.255
	{ 0x5be89800, 0x5be8b4ff, REGISTRY_RIPENCC    }, // 91.232.152.0    - 91.232.180.255
	{ 0x5be8b500, 0x5be8b6ff, REGISTRY_RIPENCC    }, // 91.232.181.0    - 91.232.182.255
	{ 0x5be8b700, 0x5be8b7ff, REGISTRY_RIPENCC    }, // 91.232.183.0    - 91.232.183.255
	{ 0x5be8b800, 0x5be8b9ff, REGISTRY_RIPENCC    }, // 91.232.184.0    - 91.232.185.255
	{ 0x5be8ba00, 0x5be8c5ff, REGISTRY_RIPENCC    }, // 91.232.186.0    - 91.232.197.255
	{ 0x5be8c700, 0x5be8cfff, REGISTRY_RIPENCC    }, // 91.232.199.0    - 91.232.207.255
	{ 0x5be8d100, 0x5be8e1ff, REGISTRY_RIPENCC    }, // 91.232.209.0    - 91.232.225.255
	{ 0x5be8e200, 0x5be8e3ff, REGISTRY_RIPENCC    }, // 91.232.226.0    - 91.232.227.255
	{ 0x5be8e400, 0x5be8eaff, REGISTRY_RIPENCC    }, // 91.232.228.0    - 91.232.234.255
	{ 0x5be8ec00, 0x5be8fdff, REGISTRY_RIPENCC    }, // 91.232.236.0    - 91.232.253.255
	{ 0x5be8fe00, 0x5be8feff, REGISTRY_RIPENCC    }, // 91.232.254.0    - 91.232.254.255
	{ 0x5be90000, 0x5be903ff, REGISTRY_RIPENCC    }, // 91.233.0.0      - 91.233.3.255
	{ 0x5be90400, 0x5be913ff, REGISTRY_RIPENCC    }, // 91.233.4.0      - 91.233.19.255
	{ 0x5be91500, 0x5be925ff, REGISTRY_RIPENCC    }, // 91.233.21.0     - 91.233.37.255
	{ 0x5be92800, 0x5be935ff, REGISTRY_RIPENCC    }, // 91.233.40.0     - 91.233.53.255
	{ 0x5be93700, 0x5be958ff, REGISTRY_RIPENCC    }, // 91.233.55.0     - 91.233.88.255
	{ 0x5be95a00, 0x5be973ff, REGISTRY_RIPENCC    }, // 91.233.90.0     - 91.233.115.255
	{ 0x5be97400, 0x5be975ff, REGISTRY_RIPENCC    }, // 91.233.116.0    - 91.233.117.255
	{ 0x5be97600, 0x5be977ff, REGISTRY_RIPENCC    }, // 91.233.118.0    - 91.233.119.255
	{ 0x5be97a00, 0x5be981ff, REGISTRY_RIPENCC    }, // 91.233.122.0    - 91.233.129.255
	{ 0x5be98400, 0x5be995ff, REGISTRY_RIPENCC    }, // 91.233.132.0    - 91.233.149.255
	{ 0x5be99700, 0x5be9bdff, REGISTRY_RIPENCC    }, // 91.233.151.0    - 91.233.189.255
	{ 0x5be9be00, 0x5be9beff, REGISTRY_RIPENCC    }, // 91.233.190.0    - 91.233.190.255
	{ 0x5be9bf00, 0x5be9bfff, REGISTRY_RIPENCC    }, // 91.233.191.0    - 91.233.191.255
	{ 0x5be9c000, 0x5be9c3ff, REGISTRY_RIPENCC    }, // 91.233.192.0    - 91.233.195.255
	{ 0x5be9c400, 0x5be9c7ff, REGISTRY_RIPENCC    }, // 91.233.196.0    - 91.233.199.255
	{ 0x5be9c800, 0x5be9cbff, REGISTRY_RIPENCC    }, // 91.233.200.0    - 91.233.203.255
	{ 0x5be9cc00, 0x5be9d5ff, REGISTRY_RIPENCC    }, // 91.233.204.0    - 91.233.213.255
	{ 0x5be9d600, 0x5be9dbff, REGISTRY_RIPENCC    }, // 91.233.214.0    - 91.233.219.255
	{ 0x5be9dc00, 0x5be9f8ff, REGISTRY_RIPENCC    }, // 91.233.220.0    - 91.233.248.255
	{ 0x5be9f900, 0x5be9f9ff, REGISTRY_RIPENCC    }, // 91.233.249.0    - 91.233.249.255
	{ 0x5be9fa00, 0x5be9fbff, REGISTRY_RIPENCC    }, // 91.233.250.0    - 91.233.251.255
	{ 0x5be9fc00, 0x5be9ffff, REGISTRY_RIPENCC    }, // 91.233.252.0    - 91.233.255.255
	{ 0x5bea0000, 0x5bea09ff, REGISTRY_RIPENCC    }, // 91.234.0.0      - 91.234.9.255
	{ 0x5bea0b00, 0x5bea13ff, REGISTRY_RIPENCC    }, // 91.234.11.0     - 91.234.19.255
	{ 0x5bea1500, 0x5bea15ff, REGISTRY_RIPENCC    }, // 91.234.21.0     - 91.234.21.255
	{ 0x5bea1600, 0x5bea16ff, REGISTRY_RIPENCC    }, // 91.234.22.0     - 91.234.22.255
	{ 0x5bea1700, 0x5bea2dff, REGISTRY_RIPENCC    }, // 91.234.23.0     - 91.234.45.255
	{ 0x5bea2e00, 0x5bea2eff, REGISTRY_RIPENCC    }, // 91.234.46.0     - 91.234.46.255
	{ 0x5bea2f00, 0x5bea34ff, REGISTRY_RIPENCC    }, // 91.234.47.0     - 91.234.52.255
	{ 0x5bea3700, 0x5bea77ff, REGISTRY_RIPENCC    }, // 91.234.55.0     - 91.234.119.255
	{ 0x5bea7800, 0x5bea7bff, REGISTRY_RIPENCC    }, // 91.234.120.0    - 91.234.123.255
	{ 0x5bea7c00, 0x5bea7fff, REGISTRY_RIPENCC    }, // 91.234.124.0    - 91.234.127.255
	{ 0x5bea8000, 0x5bea83ff, REGISTRY_RIPENCC    }, // 91.234.128.0    - 91.234.131.255
	{ 0x5bea8400, 0x5bea95ff, REGISTRY_RIPENCC    }, // 91.234.132.0    - 91.234.149.255
	{ 0x5bea9600, 0x5bea97ff, REGISTRY_RIPENCC    }, // 91.234.150.0    - 91.234.151.255
	{ 0x5bea9800, 0x5bea9bff, REGISTRY_RIPENCC    }, // 91.234.152.0    - 91.234.155.255
	{ 0x5bea9c00, 0x5bea9fff, REGISTRY_RIPENCC    }, // 91.234.156.0    - 91.234.159.255
	{ 0x5beaa000, 0x5beadbff, REGISTRY_RIPENCC    }, // 91.234.160.0    - 91.234.219.255
	{ 0x5beadc00, 0x5beadfff, REGISTRY_RIPENCC    }, // 91.234.220.0    - 91.234.223.255
	{ 0x5beae000, 0x5beafdff, REGISTRY_RIPENCC    }, // 91.234.224.0    - 91.234.253.255
	{ 0x5beb0000, 0x5beb02ff, REGISTRY_RIPENCC    }, // 91.235.0.0      - 91.235.2.255
	{ 0x5beb0300, 0x5beb03ff, REGISTRY_RIPENCC    }, // 91.235.3.0      - 91.235.3.255
	{ 0x5beb0400, 0x5beb05ff, REGISTRY_ARIN       }, // 91.235.4.0      - 91.235.5.255
	{ 0x5beb0600, 0x5beb4cff, REGISTRY_RIPENCC    }, // 91.235.6.0      - 91.235.76.255
	{ 0x5beb4e00, 0x5beb6bff, REGISTRY_RIPENCC    }, // 91.235.78.0     - 91.235.107.255
	{ 0x5beb6c00, 0x5beb6fff, REGISTRY_RIPENCC    }, // 91.235.108.0    - 91.235.111.255
	{ 0x5beb7000, 0x5beb79ff, REGISTRY_RIPENCC    }, // 91.235.112.0    - 91.235.121.255
	{ 0x5beb7a00, 0x5beb7bff, REGISTRY_RIPENCC    }, // 91.235.122.0    - 91.235.123.255
	{ 0x5beb7c00, 0x5beb81ff, REGISTRY_RIPENCC    }, // 91.235.124.0    - 91.235.129.255
	{ 0x5beb8200, 0x5beb83ff, REGISTRY_RIPENCC    }, // 91.235.130.0    - 91.235.131.255
	{ 0x5beb8400, 0x5beb93ff, REGISTRY_RIPENCC    }, // 91.235.132.0    - 91.235.147.255
	{ 0x5beb9500, 0x5beba5ff, REGISTRY_RIPENCC    }, // 91.235.149.0    - 91.235.165.255
	{ 0x5beba600, 0x5beba7ff, REGISTRY_RIPENCC    }, // 91.235.166.0    - 91.235.167.255
	{ 0x5beba800, 0x5bebcfff, REGISTRY_RIPENCC    }, // 91.235.168.0    - 91.235.207.255
	{ 0x5bebd000, 0x5bebd3ff, REGISTRY_RIPENCC    }, // 91.235.208.0    - 91.235.211.255
	{ 0x5bebd400, 0x5bebe9ff, REGISTRY_RIPENCC    }, // 91.235.212.0    - 91.235.233.255
	{ 0x5bebec00, 0x5bebf0ff, REGISTRY_RIPENCC    }, // 91.235.236.0    - 91.235.240.255
	{ 0x5bebf200, 0x5bec0bff, REGISTRY_RIPENCC    }, // 91.235.242.0    - 91.236.11.255
	{ 0x5bec0d00, 0x5bec2dff, REGISTRY_RIPENCC    }, // 91.236.13.0     - 91.236.45.255
	{ 0x5bec2e00, 0x5bec2fff, REGISTRY_RIPENCC    }, // 91.236.46.0     - 91.236.47.255
	{ 0x5bec3000, 0x5bec33ff, REGISTRY_RIPENCC    }, // 91.236.48.0     - 91.236.51.255
	{ 0x5bec3400, 0x5bec34ff, REGISTRY_RIPENCC    }, // 91.236.52.0     - 91.236.52.255
	{ 0x5bec3500, 0x5bec35ff, REGISTRY_RIPENCC    }, // 91.236.53.0     - 91.236.53.255
	{ 0x5bec3600, 0x5bec37ff, REGISTRY_RIPENCC    }, // 91.236.54.0     - 91.236.55.255
	{ 0x5bec3800, 0x5bec4bff, REGISTRY_RIPENCC    }, // 91.236.56.0     - 91.236.75.255
	{ 0x5bec4c00, 0x5bec4dff, REGISTRY_RIPENCC    }, // 91.236.76.0     - 91.236.77.255
	{ 0x5bec4e00, 0x5bec57ff, REGISTRY_RIPENCC    }, // 91.236.78.0     - 91.236.87.255
	{ 0x5bec5800, 0x5bec5bff, REGISTRY_RIPENCC    }, // 91.236.88.0     - 91.236.91.255
	{ 0x5bec5c00, 0x5bec67ff, REGISTRY_RIPENCC    }, // 91.236.92.0     - 91.236.103.255
	{ 0x5bec6900, 0x5bec72ff, REGISTRY_RIPENCC    }, // 91.236.105.0    - 91.236.114.255
	{ 0x5bec7400, 0x5bec77ff, REGISTRY_RIPENCC    }, // 91.236.116.0    - 91.236.119.255
	{ 0x5bec7a00, 0x5becc3ff, REGISTRY_RIPENCC    }, // 91.236.122.0    - 91.236.195.255
	{ 0x5becc400, 0x5becc7ff, REGISTRY_RIPENCC    }, // 91.236.196.0    - 91.236.199.255
	{ 0x5becc800, 0x5beccdff, REGISTRY_RIPENCC    }, // 91.236.200.0    - 91.236.205.255
	{ 0x5becce00, 0x5becceff, REGISTRY_RIPENCC    }, // 91.236.206.0    - 91.236.206.255
	{ 0x5beccf00, 0x5becd4ff, REGISTRY_RIPENCC    }, // 91.236.207.0    - 91.236.212.255
	{ 0x5becd600, 0x5bececff, REGISTRY_RIPENCC    }, // 91.236.214.0    - 91.236.236.255
	{ 0x5beced00, 0x5becedff, REGISTRY_RIPENCC    }, // 91.236.237.0    - 91.236.237.255
	{ 0x5becee00, 0x5becefff, REGISTRY_RIPENCC    }, // 91.236.238.0    - 91.236.239.255
	{ 0x5becf000, 0x5becf3ff, REGISTRY_RIPENCC    }, // 91.236.240.0    - 91.236.243.255
	{ 0x5becf400, 0x5bed2bff, REGISTRY_RIPENCC    }, // 91.236.244.0    - 91.237.43.255
	{ 0x5bed2c00, 0x5bed31ff, REGISTRY_RIPENCC    }, // 91.237.44.0     - 91.237.49.255
	{ 0x5bed3200, 0x5bed34ff, REGISTRY_RIPENCC    }, // 91.237.50.0     - 91.237.52.255
	{ 0x5bed3600, 0x5bed5aff, REGISTRY_RIPENCC    }, // 91.237.54.0     - 91.237.90.255
	{ 0x5bed5b00, 0x5bed5dff, REGISTRY_RIPENCC    }, // 91.237.91.0     - 91.237.93.255
	{ 0x5bed5e00, 0x5bed61ff, REGISTRY_RIPENCC    }, // 91.237.94.0     - 91.237.97.255
	{ 0x5bed6200, 0x5bed63ff, REGISTRY_RIPENCC    }, // 91.237.98.0     - 91.237.99.255
	{ 0x5bed6400, 0x5bed67ff, REGISTRY_RIPENCC    }, // 91.237.100.0    - 91.237.103.255
	{ 0x5bed6a00, 0x5bed80ff, REGISTRY_RIPENCC    }, // 91.237.106.0    - 91.237.128.255
	{ 0x5bed8200, 0x5bed98ff, REGISTRY_RIPENCC    }, // 91.237.130.0    - 91.237.152.255
	{ 0x5bed9a00, 0x5bedb0ff, REGISTRY_RIPENCC    }, // 91.237.154.0    - 91.237.176.255
	{ 0x5bedb200, 0x5bedc0ff, REGISTRY_RIPENCC    }, // 91.237.178.0    - 91.237.192.255
	{ 0x5bedc100, 0x5bedc3ff, REGISTRY_RIPENCC    }, // 91.237.193.0    - 91.237.195.255
	{ 0x5bedc400, 0x5bedc5ff, REGISTRY_RIPENCC    }, // 91.237.196.0    - 91.237.197.255
	{ 0x5bedc700, 0x5bedcfff, REGISTRY_RIPENCC    }, // 91.237.199.0    - 91.237.207.255
	{ 0x5bedd100, 0x5bedd6ff, REGISTRY_RIPENCC    }, // 91.237.209.0    - 91.237.214.255
	{ 0x5bedd800, 0x5bee00ff, REGISTRY_RIPENCC    }, // 91.237.216.0    - 91.238.0.255
	{ 0x5bee0200, 0x5bee11ff, REGISTRY_RIPENCC    }, // 91.238.2.0      - 91.238.17.255
	{ 0x5bee1300, 0x5bee20ff, REGISTRY_RIPENCC    }, // 91.238.19.0     - 91.238.32.255
	{ 0x5bee2200, 0x5bee25ff, REGISTRY_RIPENCC    }, // 91.238.34.0     - 91.238.37.255
	{ 0x5bee2600, 0x5bee2bff, REGISTRY_RIPENCC    }, // 91.238.38.0     - 91.238.43.255
	{ 0x5bee2c00, 0x5bee45ff, REGISTRY_RIPENCC    }, // 91.238.44.0     - 91.238.69.255
	{ 0x5bee4600, 0x5bee47ff, REGISTRY_RIPENCC    }, // 91.238.70.0     - 91.238.71.255
	{ 0x5bee4800, 0x5bee52ff, REGISTRY_RIPENCC    }, // 91.238.72.0     - 91.238.82.255
	{ 0x5bee5500, 0x5bee5bff, REGISTRY_RIPENCC    }, // 91.238.85.0     - 91.238.91.255
	{ 0x5bee5e00, 0x5bee6fff, REGISTRY_RIPENCC    }, // 91.238.94.0     - 91.238.111.255
	{ 0x5bee7100, 0x5bee71ff, REGISTRY_RIPENCC    }, // 91.238.113.0    - 91.238.113.255
	{ 0x5bee7300, 0x5beecaff, REGISTRY_RIPENCC    }, // 91.238.115.0    - 91.238.202.255
	{ 0x5beecc00, 0x5beeceff, REGISTRY_RIPENCC    }, // 91.238.204.0    - 91.238.206.255
	{ 0x5beed000, 0x5beed4ff, REGISTRY_RIPENCC    }, // 91.238.208.0    - 91.238.212.255
	{ 0x5beed600, 0x5beed8ff, REGISTRY_RIPENCC    }, // 91.238.214.0    - 91.238.216.255
	{ 0x5beeda00, 0x5beedaff, REGISTRY_RIPENCC    }, // 91.238.218.0    - 91.238.218.255
	{ 0x5beedb00, 0x5beedbff, REGISTRY_RIPENCC    }, // 91.238.219.0    - 91.238.219.255
	{ 0x5beedc00, 0x5beedcff, REGISTRY_RIPENCC    }, // 91.238.220.0    - 91.238.220.255
	{ 0x5beedd00, 0x5beeddff, REGISTRY_RIPENCC    }, // 91.238.221.0    - 91.238.221.255
	{ 0x5beede00, 0x5beeffff, REGISTRY_RIPENCC    }, // 91.238.222.0    - 91.238.255.255
	{ 0x5bef0000, 0x5bef03ff, REGISTRY_RIPENCC    }, // 91.239.0.0      - 91.239.3.255
	{ 0x5bef0400, 0x5bef0eff, REGISTRY_RIPENCC    }, // 91.239.4.0      - 91.239.14.255
	{ 0x5bef1000, 0x5bef17ff, REGISTRY_RIPENCC    }, // 91.239.16.0     - 91.239.23.255
	{ 0x5bef1900, 0x5bef19ff, REGISTRY_RIPENCC    }, // 91.239.25.0     - 91.239.25.255
	{ 0x5bef1a00, 0x5bef1bff, REGISTRY_RIPENCC    }, // 91.239.26.0     - 91.239.27.255
	{ 0x5bef1c00, 0x5bef24ff, REGISTRY_RIPENCC    }, // 91.239.28.0     - 91.239.36.255
	{ 0x5bef2600, 0x5bef81ff, REGISTRY_RIPENCC    }, // 91.239.38.0     - 91.239.129.255
	{ 0x5bef8300, 0x5bef93ff, REGISTRY_RIPENCC    }, // 91.239.131.0    - 91.239.147.255
	{ 0x5bef9600, 0x5bef9cff, REGISTRY_RIPENCC    }, // 91.239.150.0    - 91.239.156.255
	{ 0x5bef9e00, 0x5befa3ff, REGISTRY_RIPENCC    }, // 91.239.158.0    - 91.239.163.255
	{ 0x5befa400, 0x5befa7ff, REGISTRY_RIPENCC    }, // 91.239.164.0    - 91.239.167.255
	{ 0x5befa800, 0x5befb1ff, REGISTRY_RIPENCC    }, // 91.239.168.0    - 91.239.177.255
	{ 0x5befb200, 0x5befb3ff, REGISTRY_RIPENCC    }, // 91.239.178.0    - 91.239.179.255
	{ 0x5befb400, 0x5befdbff, REGISTRY_RIPENCC    }, // 91.239.180.0    - 91.239.219.255
	{ 0x5befdc00, 0x5befe2ff, REGISTRY_RIPENCC    }, // 91.239.220.0    - 91.239.226.255
	{ 0x5befe400, 0x5befedff, REGISTRY_RIPENCC    }, // 91.239.228.0    - 91.239.237.255
	{ 0x5befef00, 0x5bf007ff, REGISTRY_RIPENCC    }, // 91.239.239.0    - 91.240.7.255
	{ 0x5bf00800, 0x5bf00bff, REGISTRY_RIPENCC    }, // 91.240.8.0      - 91.240.11.255
	{ 0x5bf00c00, 0x5bf013ff, REGISTRY_RIPENCC    }, // 91.240.12.0     - 91.240.19.255
	{ 0x5bf01400, 0x5bf017ff, REGISTRY_RIPENCC    }, // 91.240.20.0     - 91.240.23.255
	{ 0x5bf01800, 0x5bf020ff, REGISTRY_RIPENCC    }, // 91.240.24.0     - 91.240.32.255
	{ 0x5bf02200, 0x5bf046ff, REGISTRY_RIPENCC    }, // 91.240.34.0     - 91.240.70.255
	{ 0x5bf04800, 0x5bf053ff, REGISTRY_RIPENCC    }, // 91.240.72.0     - 91.240.83.255
	{ 0x5bf05400, 0x5bf057ff, REGISTRY_RIPENCC    }, // 91.240.84.0     - 91.240.87.255
	{ 0x5bf05800, 0x5bf058ff, REGISTRY_RIPENCC    }, // 91.240.88.0     - 91.240.88.255
	{ 0x5bf05a00, 0x5bf07fff, REGISTRY_RIPENCC    }, // 91.240.90.0     - 91.240.127.255
	{ 0x5bf08100, 0x5bf099ff, REGISTRY_RIPENCC    }, // 91.240.129.0    - 91.240.153.255
	{ 0x5bf09a00, 0x5bf09aff, REGISTRY_RIPENCC    }, // 91.240.154.0    - 91.240.154.255
	{ 0x5bf09b00, 0x5bf09bff, REGISTRY_RIPENCC    }, // 91.240.155.0    - 91.240.155.255
	{ 0x5bf09c00, 0x5bf09fff, REGISTRY_RIPENCC    }, // 91.240.156.0    - 91.240.159.255
	{ 0x5bf0a000, 0x5bf0a2ff, REGISTRY_RIPENCC    }, // 91.240.160.0    - 91.240.162.255
	{ 0x5bf0a400, 0x5bf0aeff, REGISTRY_RIPENCC    }, // 91.240.164.0    - 91.240.174.255
	{ 0x5bf0b000, 0x5bf0b1ff, REGISTRY_RIPENCC    }, // 91.240.176.0    - 91.240.177.255
	{ 0x5bf0b200, 0x5bf0b2ff, REGISTRY_RIPENCC    }, // 91.240.178.0    - 91.240.178.255
	{ 0x5bf0b300, 0x5bf0c9ff, REGISTRY_RIPENCC    }, // 91.240.179.0    - 91.240.201.255
	{ 0x5bf0cb00, 0x5bf0d5ff, REGISTRY_RIPENCC    }, // 91.240.203.0    - 91.240.213.255
	{ 0x5bf0d800, 0x5bf0e5ff, REGISTRY_RIPENCC    }, // 91.240.216.0    - 91.240.229.255
	{ 0x5bf0e600, 0x5bf0e7ff, REGISTRY_RIPENCC    }, // 91.240.230.0    - 91.240.231.255
	{ 0x5bf0e800, 0x5bf10dff, REGISTRY_RIPENCC    }, // 91.240.232.0    - 91.241.13.255
	{ 0x5bf11000, 0x5bf12fff, REGISTRY_RIPENCC    }, // 91.241.16.0     - 91.241.47.255
	{ 0x5bf13000, 0x5bf133ff, REGISTRY_RIPENCC    }, // 91.241.48.0     - 91.241.51.255
	{ 0x5bf13400, 0x5bf155ff, REGISTRY_RIPENCC    }, // 91.241.52.0     - 91.241.85.255
	{ 0x5bf15600, 0x5bf157ff, REGISTRY_RIPENCC    }, // 91.241.86.0     - 91.241.87.255
	{ 0x5bf15800, 0x5bf15cff, REGISTRY_RIPENCC    }, // 91.241.88.0     - 91.241.92.255
	{ 0x5bf15e00, 0x5bf22dff, REGISTRY_RIPENCC    }, // 91.241.94.0     - 91.242.45.255
	{ 0x5bf22e00, 0x5bf233ff, REGISTRY_RIPENCC    }, // 91.242.46.0     - 91.242.51.255
	{ 0x5bf23400, 0x5bf23fff, REGISTRY_RIPENCC    }, // 91.242.52.0     - 91.242.63.255
	{ 0x5bf24000, 0x5bf27fff, REGISTRY_RIPENCC    }, // 91.242.64.0     - 91.242.127.255
	{ 0x5bf28000, 0x5bf2d8ff, REGISTRY_RIPENCC    }, // 91.242.128.0    - 91.242.216.255
	{ 0x5bf2da00, 0x5bf2daff, REGISTRY_RIPENCC    }, // 91.242.218.0    - 91.242.218.255
	{ 0x5bf2dc00, 0x5bf31fff, REGISTRY_RIPENCC    }, // 91.242.220.0    - 91.243.31.255
	{ 0x5bf32000, 0x5bf33fff, REGISTRY_RIPENCC    }, // 91.243.32.0     - 91.243.63.255
	{ 0x5bf34000, 0x5bf34fff, REGISTRY_RIPENCC    }, // 91.243.64.0     - 91.243.79.255
	{ 0x5bf35000, 0x5bf35fff, REGISTRY_RIPENCC    }, // 91.243.80.0     - 91.243.95.255
	{ 0x5bf36000, 0x5bf372ff, REGISTRY_RIPENCC    }, // 91.243.96.0     - 91.243.114.255
	{ 0x5bf37400, 0x5bf3afff, REGISTRY_RIPENCC    }, // 91.243.116.0    - 91.243.175.255
	{ 0x5bf3b000, 0x5bf3bfff, REGISTRY_RIPENCC    }, // 91.243.176.0    - 91.243.191.255
	{ 0x5bf3c000, 0x5bf45fff, REGISTRY_RIPENCC    }, // 91.243.192.0    - 91.244.95.255
	{ 0x5bf46000, 0x5bf46fff, REGISTRY_RIPENCC    }, // 91.244.96.0     - 91.244.111.255
	{ 0x5bf47000, 0x5bf477ff, REGISTRY_RIPENCC    }, // 91.244.112.0    - 91.244.119.255
	{ 0x5bf47800, 0x5bf47bff, REGISTRY_RIPENCC    }, // 91.244.120.0    - 91.244.123.255
	{ 0x5bf47c00, 0x5bf4b5ff, REGISTRY_RIPENCC    }, // 91.244.124.0    - 91.244.181.255
	{ 0x5bf4b700, 0x5bf4bfff, REGISTRY_RIPENCC    }, // 91.244.183.0    - 91.244.191.255
	{ 0x5bf4c000, 0x5bf4cfff, REGISTRY_RIPENCC    }, // 91.244.192.0    - 91.244.207.255
	{ 0x5bf4d000, 0x5bf557ff, REGISTRY_RIPENCC    }, // 91.244.208.0    - 91.245.87.255
	{ 0x5bf55800, 0x5bf55fff, REGISTRY_RIPENCC    }, // 91.245.88.0     - 91.245.95.255
	{ 0x5bf56000, 0x5bf5afff, REGISTRY_RIPENCC    }, // 91.245.96.0     - 91.245.175.255
	{ 0x5bf5b000, 0x5bf5bfff, REGISTRY_RIPENCC    }, // 91.245.176.0    - 91.245.191.255
	{ 0x5bf5c000, 0x5bf5c3ff, REGISTRY_RIPENCC    }, // 91.245.192.0    - 91.245.195.255
	{ 0x5bf5c400, 0x5bf5c7ff, REGISTRY_RIPENCC    }, // 91.245.196.0    - 91.245.199.255
	{ 0x5bf5c800, 0x5bf5dcff, REGISTRY_RIPENCC    }, // 91.245.200.0    - 91.245.220.255
	{ 0x5bf5de00, 0x5bf5dfff, REGISTRY_RIPENCC    }, // 91.245.222.0    - 91.245.223.255
	{ 0x5bf5e000, 0x5bf5ffff, REGISTRY_RIPENCC    }, // 91.245.224.0    - 91.245.255.255
	{ 0x5bf60000, 0x5bf60cff, REGISTRY_RIPENCC    }, // 91.246.0.0      - 91.246.12.255
	{ 0x5bf60e00, 0x5bf63fff, REGISTRY_RIPENCC    }, // 91.246.14.0     - 91.246.63.255
	{ 0x5bf64000, 0x5bf64bff, REGISTRY_RIPENCC    }, // 91.246.64.0     - 91.246.75.255
	{ 0x5bf64c00, 0x5bf6abff, REGISTRY_RIPENCC    }, // 91.246.76.0     - 91.246.171.255
	{ 0x5bf6ac00, 0x5bf6c9ff, REGISTRY_RIPENCC    }, // 91.246.172.0    - 91.246.201.255
	{ 0x5bf6ca00, 0x5bf6caff, REGISTRY_RIPENCC    }, // 91.246.202.0    - 91.246.202.255
	{ 0x5bf6cb00, 0x5bf6cfff, REGISTRY_RIPENCC    }, // 91.246.203.0    - 91.246.207.255
	{ 0x5bf6d000, 0x5bf6d7ff, REGISTRY_RIPENCC    }, // 91.246.208.0    - 91.246.215.255
	{ 0x5bf6d800, 0x5bf6d9ff, REGISTRY_RIPENCC    }, // 91.246.216.0    - 91.246.217.255
	{ 0x5bf6da00, 0x5bf791ff, REGISTRY_RIPENCC    }, // 91.246.218.0    - 91.247.145.255
	{ 0x5bf79300, 0x5bf7ffff, REGISTRY_RIPENCC    }, // 91.247.147.0    - 91.247.255.255
	{ 0x5bf80000, 0x5cc9ffff, REGISTRY_RIPENCC    }, // 91.248.0.0      - 92.201.255.255
	{ 0x5cca0000, 0x5ccbffff, REGISTRY_APNIC      }, // 92.202.0.0      - 92.203.255.255
	{ 0x5ccc0000, 0x5cf93fff, REGISTRY_RIPENCC    }, // 92.204.0.0      - 92.249.63.255
	{ 0x5cf94000, 0x5cf97fff, REGISTRY_RIPENCC    }, // 92.249.64.0     - 92.249.127.255
	{ 0x5cf98000, 0x5d7dffff, REGISTRY_RIPENCC    }, // 92.249.128.0    - 93.125.255.255
	{ 0x5d7e0000, 0x5d7e7fff, REGISTRY_RIPENCC    }, // 93.126.0.0      - 93.126.127.255
	{ 0x5d7e8000, 0x5d9cffff, REGISTRY_RIPENCC    }, // 93.126.128.0    - 93.156.255.255
	{ 0x5d9d0000, 0x5d9d67ff, REGISTRY_RIPENCC    }, // 93.157.0.0      - 93.157.103.255
	{ 0x5d9d6800, 0x5d9d77ff, REGISTRY_RIPENCC    }, // 93.157.104.0    - 93.157.119.255
	{ 0x5d9d7800, 0x5d9db7ff, REGISTRY_RIPENCC    }, // 93.157.120.0    - 93.157.183.255
	{ 0x5d9db800, 0x5d9dbfff, REGISTRY_RIPENCC    }, // 93.157.184.0    - 93.157.191.255
	{ 0x5d9dc000, 0x5d9dcfff, REGISTRY_RIPENCC    }, // 93.157.192.0    - 93.157.207.255
	{ 0x5d9dd000, 0x5d9dd7ff, REGISTRY_RIPENCC    }, // 93.157.208.0    - 93.157.215.255
	{ 0x5d9dd800, 0x5d9df7ff, REGISTRY_RIPENCC    }, // 93.157.216.0    - 93.157.247.255
	{ 0x5d9df800, 0x5daeffff, REGISTRY_RIPENCC    }, // 93.157.248.0    - 93.174.255.255
	{ 0x5daf0000, 0x5dafefff, REGISTRY_RIPENCC    }, // 93.175.0.0      - 93.175.239.255
	{ 0x5daff000, 0x5db35fff, REGISTRY_RIPENCC    }, // 93.175.240.0    - 93.179.95.255
	{ 0x5db36000, 0x5db367ff, REGISTRY_ARIN       }, // 93.179.96.0     - 93.179.103.255
	{ 0x5db36800, 0x5db36fff, REGISTRY_RIPENCC    }, // 93.179.104.0    - 93.179.111.255
	{ 0x5db37000, 0x5db377ff, REGISTRY_ARIN       }, // 93.179.112.0    - 93.179.119.255
	{ 0x5db37800, 0x5db37bff, REGISTRY_RIPENCC    }, // 93.179.120.0    - 93.179.123.255
	{ 0x5db37c00, 0x5db37fff, REGISTRY_ARIN       }, // 93.179.124.0    - 93.179.127.255
	{ 0x5db38000, 0x5dbeefff, REGISTRY_RIPENCC    }, // 93.179.128.0    - 93.190.239.255
	{ 0x5dbef800, 0x5e1a1aff, REGISTRY_RIPENCC    }, // 93.190.248.0    - 94.26.26.255
	{ 0x5e1a1b00, 0x5e1a1bff, REGISTRY_ARIN       }, // 94.26.27.0      - 94.26.27.255
	{ 0x5e1a1c00, 0x5e1a1eff, REGISTRY_RIPENCC    }, // 94.26.28.0      - 94.26.30.255
	{ 0x5e1a1f00, 0x5e1a1fff, REGISTRY_ARIN       }, // 94.26.31.0      - 94.26.31.255
	{ 0x5e1a2000, 0x5e1a2bff, REGISTRY_RIPENCC    }, // 94.26.32.0      - 94.26.43.255
	{ 0x5e1a2c00, 0x5e1a2cff, REGISTRY_ARIN       }, // 94.26.44.0      - 94.26.44.255
	{ 0x5e1a2d00, 0x5e1a2dff, REGISTRY_RIPENCC    }, // 94.26.45.0      - 94.26.45.255
	{ 0x5e1a2e00, 0x5e1a2fff, REGISTRY_ARIN       }, // 94.26.46.0      - 94.26.47.255
	{ 0x5e1a3000, 0x5e1a42ff, REGISTRY_RIPENCC    }, // 94.26.48.0      - 94.26.66.255
	{ 0x5e1a4300, 0x5e1a43ff, REGISTRY_ARIN       }, // 94.26.67.0      - 94.26.67.255
	{ 0x5e1a4400, 0x5e1a48ff, REGISTRY_RIPENCC    }, // 94.26.68.0      - 94.26.72.255
	{ 0x5e1a4900, 0x5e1a49ff, REGISTRY_ARIN       }, // 94.26.73.0      - 94.26.73.255
	{ 0x5e1a4a00, 0x5e1a53ff, REGISTRY_RIPENCC    }, // 94.26.74.0      - 94.26.83.255
	{ 0x5e1a5400, 0x5e1a55ff, REGISTRY_ARIN       }, // 94.26.84.0      - 94.26.85.255
	{ 0x5e1a5600, 0x5e2cffff, REGISTRY_RIPENCC    }, // 94.26.86.0      - 94.44.255.255
	{ 0x5e2d0000, 0x5e2dffff, REGISTRY_RIPENCC    }, // 94.45.0.0       - 94.45.255.255
	{ 0x5e2e0000, 0x5e6703ff, REGISTRY_RIPENCC    }, // 94.46.0.0       - 94.103.3.255
	{ 0x5e670400, 0x5e6707ff, REGISTRY_ARIN       }, // 94.103.4.0      - 94.103.7.255
	{ 0x5e670800, 0x5e99ffff, REGISTRY_RIPENCC    }, // 94.103.8.0      - 94.153.255.255
	{ 0x5e9a0000, 0x5e9a6fff, REGISTRY_RIPENCC    }, // 94.154.0.0      - 94.154.111.255
	{ 0x5e9a8000, 0x5e9abfff, REGISTRY_RIPENCC    }, // 94.154.128.0    - 94.154.191.255
	{ 0x5e9ac000, 0x5e9affff, REGISTRY_RIPENCC    }, // 94.154.192.0    - 94.154.255.255
	{ 0x5e9b0000, 0x5e9e2fff, REGISTRY_RIPENCC    }, // 94.155.0.0      - 94.158.47.255
	{ 0x5e9e3000, 0x5e9eafff, REGISTRY_RIPENCC    }, // 94.158.48.0     - 94.158.175.255
	{ 0x5e9ec000, 0x5e9eefff, REGISTRY_RIPENCC    }, // 94.158.192.0    - 94.158.239.255
	{ 0x5e9ef000, 0x5ebecfff, REGISTRY_RIPENCC    }, // 94.158.240.0    - 94.190.207.255
	{ 0x5ebed000, 0x5ebeefff, REGISTRY_APNIC      }, // 94.190.208.0    - 94.190.239.255
	{ 0x5ebef000, 0x5ebeffff, REGISTRY_RIPENCC    }, // 94.190.240.0    - 94.190.255.255
	{ 0x5ebf0000, 0x5ebf7fff, REGISTRY_APNIC      }, // 94.191.0.0      - 94.191.127.255
	{ 0x5ebf8000, 0x5ec62fff, REGISTRY_RIPENCC    }, // 94.191.128.0    - 94.198.47.255
	{ 0x5ec63200, 0x5ee6ffff, REGISTRY_RIPENCC    }, // 94.198.50.0     - 94.230.255.255
	{ 0x5ee70000, 0x5ee76fff, REGISTRY_RIPENCC    }, // 94.231.0.0      - 94.231.111.255
	{ 0x5ee77000, 0x5ee77fff, REGISTRY_RIPENCC    }, // 94.231.112.0    - 94.231.127.255
	{ 0x5ee78000, 0x5ee7cfff, REGISTRY_RIPENCC    }, // 94.231.128.0    - 94.231.207.255
	{ 0x5ee7d000, 0x5ee7efff, REGISTRY_RIPENCC    }, // 94.231.208.0    - 94.231.239.255
	{ 0x5ee7f000, 0x5ee85fff, REGISTRY_RIPENCC    }, // 94.231.240.0    - 94.232.95.255
	{ 0x5ee86000, 0x5ee867ff, REGISTRY_RIPENCC    }, // 94.232.96.0     - 94.232.103.255
	{ 0x5ee86800, 0x5ee897ff, REGISTRY_RIPENCC    }, // 94.232.104.0    - 94.232.151.255
	{ 0x5ee89800, 0x5ee89fff, REGISTRY_RIPENCC    }, // 94.232.152.0    - 94.232.159.255
	{ 0x5ee8a000, 0x5ee8bfff, REGISTRY_RIPENCC    }, // 94.232.160.0    - 94.232.191.255
	{ 0x5ee8c000, 0x5ee8c7ff, REGISTRY_RIPENCC    }, // 94.232.192.0    - 94.232.199.255
	{ 0x5ee8c800, 0x5ee8efff, REGISTRY_RIPENCC    }, // 94.232.200.0    - 94.232.239.255
	{ 0x5ee8f000, 0x5ef3ffff, REGISTRY_RIPENCC    }, // 94.232.240.0    - 94.243.255.255
	{ 0x5ef40000, 0x5ef4ffff, REGISTRY_RIPENCC    }, // 94.244.0.0      - 94.244.255.255
	{ 0x5ef50000, 0x5f81ffff, REGISTRY_RIPENCC    }, // 94.245.0.0      - 95.129.255.255
	{ 0x5f820400, 0x5fa3bfff, REGISTRY_RIPENCC    }, // 95.130.4.0      - 95.163.191.255
	{ 0x5fa3c000, 0x5fa3cfff, REGISTRY_ARIN       }, // 95.163.192.0    - 95.163.207.255
	{ 0x5fa3d000, 0x5fa8ffff, REGISTRY_RIPENCC    }, // 95.163.208.0    - 95.168.255.255
	{ 0x5fa90000, 0x5fa91fff, REGISTRY_ARIN       }, // 95.169.0.0      - 95.169.31.255
	{ 0x5fa92000, 0x5fb5bbff, REGISTRY_RIPENCC    }, // 95.169.32.0     - 95.181.187.255
	{ 0x5fb5bc00, 0x5fb5bfff, REGISTRY_ARIN       }, // 95.181.188.0    - 95.181.191.255
	{ 0x5fb5c000, 0x5fd703ff, REGISTRY_RIPENCC    }, // 95.181.192.0    - 95.215.3.255
	{ 0x5fd70400, 0x5fd71fff, REGISTRY_RIPENCC    }, // 95.215.4.0      - 95.215.31.255
	{ 0x5fd72000, 0x5fd723ff, REGISTRY_RIPENCC    }, // 95.215.32.0     - 95.215.35.255
	{ 0x5fd72400, 0x5fd72bff, REGISTRY_RIPENCC    }, // 95.215.36.0     - 95.215.43.255
	{ 0x5fd72c00, 0x5fd72fff, REGISTRY_RIPENCC    }, // 95.215.44.0     - 95.215.47.255
	{ 0x5fd73000, 0x5fd73bff, REGISTRY_RIPENCC    }, // 95.215.48.0     - 95.215.59.255
	{ 0x5fd73c00, 0x5fd743ff, REGISTRY_RIPENCC    }, // 95.215.60.0     - 95.215.67.255
	{ 0x5fd74400, 0x5fd74fff, REGISTRY_RIPENCC    }, // 95.215.68.0     - 95.215.79.255
	{ 0x5fd75000, 0x5fd753ff, REGISTRY_RIPENCC    }, // 95.215.80.0     - 95.215.83.255
	{ 0x5fd75400, 0x5fd767ff, REGISTRY_RIPENCC    }, // 95.215.84.0     - 95.215.103.255
	{ 0x5fd76800, 0x5fd76bff, REGISTRY_RIPENCC    }, // 95.215.104.0    - 95.215.107.255
	{ 0x5fd76c00, 0x5fd77bff, REGISTRY_RIPENCC    }, // 95.215.108.0    - 95.215.123.255
	{ 0x5fd77c00, 0x5fd783ff, REGISTRY_RIPENCC    }, // 95.215.124.0    - 95.215.131.255
	{ 0x5fd78400, 0x5fd78bff, REGISTRY_RIPENCC    }, // 95.215.132.0    - 95.215.139.255
	{ 0x5fd78c00, 0x5fd78fff, REGISTRY_RIPENCC    }, // 95.215.140.0    - 95.215.143.255
	{ 0x5fd79000, 0x5fd7abff, REGISTRY_RIPENCC    }, // 95.215.144.0    - 95.215.171.255
	{ 0x5fd7ad00, 0x5fd7c7ff, REGISTRY_RIPENCC    }, // 95.215.173.0    - 95.215.199.255
	{ 0x5fd7d000, 0x5fd7ffff, REGISTRY_RIPENCC    }, // 95.215.208.0    - 95.215.255.255
	{ 0x5fd80000, 0x5fffffff, REGISTRY_RIPENCC    }, // 95.216.0.0      - 95.255.255.255
	{ 0x60000000, 0x60093fff, REGISTRY_ARIN       }, // 96.0.0.0        - 96.9.63.255
	{ 0x60094000, 0x60095fff, REGISTRY_APNIC      }, // 96.9.64.0       - 96.9.95.255
	{ 0x60096000, 0x60097fff, REGISTRY_ARIN       }, // 96.9.96.0       - 96.9.127.255
	{ 0x60098000, 0x60099fff, REGISTRY_RIPENCC    }, // 96.9.128.0      - 96.9.159.255
	{ 0x6009a000, 0x6009bfff, REGISTRY_APNIC      }, // 96.9.160.0      - 96.9.191.255
	{ 0x6009c000, 0x601e3fff, REGISTRY_ARIN       }, // 96.9.192.0      - 96.30.63.255
	{ 0x601e4000, 0x601e7fff, REGISTRY_APNIC      }, // 96.30.64.0      - 96.30.127.255
	{ 0x601e8000, 0x607d8fff, REGISTRY_ARIN       }, // 96.30.128.0     - 96.125.143.255
	{ 0x607d9000, 0x607d9fff, REGISTRY_RIPENCC    }, // 96.125.144.0    - 96.125.159.255
	{ 0x607da000, 0x627fffff, REGISTRY_ARIN       }, // 96.125.160.0    - 98.127.255.255
	{ 0x62800000, 0x6280ffff, REGISTRY_RIPENCC    }, // 98.128.0.0      - 98.128.255.255
	{ 0x62810000, 0x643fffff, REGISTRY_ARIN       }, // 98.129.0.0      - 100.63.255.255
	{ 0x64800000, 0x64ffffff, REGISTRY_ARIN       }, // 100.128.0.0     - 100.255.255.255
	{ 0x65000000, 0x6537ffff, REGISTRY_APNIC      }, // 101.0.0.0       - 101.55.255.255
	{ 0x65380000, 0x653fffff, REGISTRY_RIPENCC    }, // 101.56.0.0      - 101.63.255.255
	{ 0x65400000, 0x65655fff, REGISTRY_APNIC      }, // 101.64.0.0      - 101.101.95.255
	{ 0x65656400, 0x65ffffff, REGISTRY_APNIC      }, // 101.101.100.0   - 101.255.255.255
	{ 0x66300000, 0x663fffff, REGISTRY_AFRINIC    }, // 102.48.0.0      - 102.63.255.255
	{ 0x66410000, 0x6641ffff, REGISTRY_AFRINIC    }, // 102.65.0.0      - 102.65.255.255
	{ 0x66436000, 0x66437fff, REGISTRY_AFRINIC    }, // 102.67.96.0     - 102.67.127.255
	{ 0x66438800, 0x66438fff, REGISTRY_AFRINIC    }, // 102.67.136.0    - 102.67.143.255
	{ 0x66439c00, 0x66439fff, REGISTRY_AFRINIC    }, // 102.67.156.0    - 102.67.159.255
	{ 0x6643a800, 0x6643abff, REGISTRY_AFRINIC    }, // 102.67.168.0    - 102.67.171.255
	{ 0x6643b000, 0x6643b7ff, REGISTRY_AFRINIC    }, // 102.67.176.0    - 102.67.183.255
	{ 0x6643c000, 0x6643ffff, REGISTRY_AFRINIC    }, // 102.67.192.0    - 102.67.255.255
	{ 0x66440400, 0x664407ff, REGISTRY_AFRINIC    }, // 102.68.4.0      - 102.68.7.255
	{ 0x66440c00, 0x66440fff, REGISTRY_AFRINIC    }, // 102.68.12.0     - 102.68.15.255
	{ 0x66441600, 0x664416ff, REGISTRY_AFRINIC    }, // 102.68.22.0     - 102.68.22.255
	{ 0x66441800, 0x66442fff, REGISTRY_AFRINIC    }, // 102.68.24.0     - 102.68.47.255
	{ 0x66443400, 0x66443fff, REGISTRY_AFRINIC    }, // 102.68.52.0     - 102.68.63.255
	{ 0x66445000, 0x664467ff, REGISTRY_AFRINIC    }, // 102.68.80.0     - 102.68.103.255
	{ 0x66446c00, 0x664477ff, REGISTRY_AFRINIC    }, // 102.68.108.0    - 102.68.119.255
	{ 0x66447d00, 0x66447eff, REGISTRY_AFRINIC    }, // 102.68.125.0    - 102.68.126.255
	{ 0x66448000, 0x66448bff, REGISTRY_AFRINIC    }, // 102.68.128.0    - 102.68.139.255
	{ 0x66449000, 0x6644a7ff, REGISTRY_AFRINIC    }, // 102.68.144.0    - 102.68.167.255
	{ 0x6644ac00, 0x6644afff, REGISTRY_AFRINIC    }, // 102.68.172.0    - 102.68.175.255
	{ 0x6644b400, 0x664593ff, REGISTRY_AFRINIC    }, // 102.68.180.0    - 102.69.147.255
	{ 0x66459500, 0x664595ff, REGISTRY_AFRINIC    }, // 102.69.149.0    - 102.69.149.255
	{ 0x66459700, 0x66459fff, REGISTRY_AFRINIC    }, // 102.69.151.0    - 102.69.159.255
	{ 0x6645a400, 0x6645cfff, REGISTRY_AFRINIC    }, // 102.69.164.0    - 102.69.207.255
	{ 0x6645f000, 0x66bfffff, REGISTRY_AFRINIC    }, // 102.69.240.0    - 102.191.255.255
	{ 0x66f00000, 0x66ffffff, REGISTRY_AFRINIC    }, // 102.240.0.0     - 102.255.255.255
	{ 0x67000000, 0x67019bff, REGISTRY_APNIC      }, // 103.0.0.0       - 103.1.155.255
	{ 0x6701a000, 0x67044fff, REGISTRY_APNIC      }, // 103.1.160.0     - 103.4.79.255
	{ 0x67045400, 0x670486ff, REGISTRY_APNIC      }, // 103.4.84.0      - 103.4.134.255
	{ 0x67048800, 0x6705d7ff, REGISTRY_APNIC      }, // 103.4.136.0     - 103.5.215.255
	{ 0x6705dc00, 0x670676ff, REGISTRY_APNIC      }, // 103.5.220.0     - 103.6.118.255
	{ 0x67068000, 0x67069fff, REGISTRY_APNIC      }, // 103.6.128.0     - 103.6.159.255
	{ 0x6706a200, 0x6706a5ff, REGISTRY_APNIC      }, // 103.6.162.0     - 103.6.165.255
	{ 0x6706a700, 0x6706e7ff, REGISTRY_APNIC      }, // 103.6.167.0     - 103.6.231.255
	{ 0x6706ec00, 0x670777ff, REGISTRY_APNIC      }, // 103.6.236.0     - 103.7.119.255
	{ 0x67077c00, 0x67083fff, REGISTRY_APNIC      }, // 103.7.124.0     - 103.8.63.255
	{ 0x67084400, 0x6708b7ff, REGISTRY_APNIC      }, // 103.8.68.0      - 103.8.183.255
	{ 0x6708bc00, 0x67098bff, REGISTRY_APNIC      }, // 103.8.188.0     - 103.9.139.255
	{ 0x67099000, 0x670a09ff, REGISTRY_APNIC      }, // 103.9.144.0     - 103.10.9.255
	{ 0x670a0b00, 0x670a43ff, REGISTRY_APNIC      }, // 103.10.11.0     - 103.10.67.255
	{ 0x670a4800, 0x670a6bff, REGISTRY_APNIC      }, // 103.10.72.0     - 103.10.107.255
	{ 0x670a6d00, 0x670a6eff, REGISTRY_APNIC      }, // 103.10.109.0    - 103.10.110.255
	{ 0x670a7000, 0x670abfff, REGISTRY_APNIC      }, // 103.10.112.0    - 103.10.191.255
	{ 0x670ac400, 0x670b3fff, REGISTRY_APNIC      }, // 103.10.196.0    - 103.11.63.255
	{ 0x670b4000, 0x670b43ff, REGISTRY_ARIN       }, // 103.11.64.0     - 103.11.67.255
	{ 0x670b4400, 0x670bc3ff, REGISTRY_APNIC      }, // 103.11.68.0     - 103.11.195.255
	{ 0x670bc800, 0x670bffff, REGISTRY_APNIC      }, // 103.11.200.0    - 103.11.255.255
	{ 0x670c0100, 0x670c4bff, REGISTRY_APNIC      }, // 103.12.1.0      - 103.12.75.255
	{ 0x670c5000, 0x670cb3ff, REGISTRY_APNIC      }, // 103.12.80.0     - 103.12.179.255
	{ 0x670cb800, 0x670ccbff, REGISTRY_APNIC      }, // 103.12.184.0    - 103.12.203.255
	{ 0x670cd000, 0x670cd3ff, REGISTRY_APNIC      }, // 103.12.208.0    - 103.12.211.255
	{ 0x670cd400, 0x670cd7ff, REGISTRY_ARIN       }, // 103.12.212.0    - 103.12.215.255
	{ 0x670cd800, 0x670cdfff, REGISTRY_APNIC      }, // 103.12.216.0    - 103.12.223.255
	{ 0x670ce400, 0x670cf3ff, REGISTRY_APNIC      }, // 103.12.228.0    - 103.12.243.255
	{ 0x670cf500, 0x670d03ff, REGISTRY_APNIC      }, // 103.12.245.0    - 103.13.3.255
	{ 0x670d0800, 0x670d47ff, REGISTRY_APNIC      }, // 103.13.8.0      - 103.13.71.255
	{ 0x670d4a00, 0x670d87ff, REGISTRY_APNIC      }, // 103.13.74.0     - 103.13.135.255
	{ 0x670d8c00, 0x670da3ff, REGISTRY_APNIC      }, // 103.13.140.0    - 103.13.163.255
	{ 0x670da800, 0x670dbfff, REGISTRY_APNIC      }, // 103.13.168.0    - 103.13.191.255
	{ 0x670dc400, 0x670dcbff, REGISTRY_APNIC      }, // 103.13.196.0    - 103.13.203.255
	{ 0x670dd000, 0x670de7ff, REGISTRY_APNIC      }, // 103.13.208.0    - 103.13.231.255
	{ 0x670dec00, 0x670dffff, REGISTRY_APNIC      }, // 103.13.236.0    - 103.13.255.255
	{ 0x670e0100, 0x670e15ff, REGISTRY_APNIC      }, // 103.14.1.0      - 103.14.21.255
	{ 0x670e1800, 0x670e37ff, REGISTRY_APNIC      }, // 103.14.24.0     - 103.14.55.255
	{ 0x670e3c00, 0x670ea7ff, REGISTRY_APNIC      }, // 103.14.60.0     - 103.14.167.255
	{ 0x670eac00, 0x670edfff, REGISTRY_APNIC      }, // 103.14.172.0    - 103.14.223.255
	{ 0x670ee400, 0x670f0bff, REGISTRY_APNIC      }, // 103.14.228.0    - 103.15.11.255
	{ 0x670f1000, 0x670f25ff, REGISTRY_APNIC      }, // 103.15.16.0     - 103.15.37.255
	{ 0x670f2700, 0x670f57ff, REGISTRY_APNIC      }, // 103.15.39.0     - 103.15.87.255
	{ 0x670f6000, 0x670f9bff, REGISTRY_APNIC      }, // 103.15.96.0     - 103.15.155.255
	{ 0x670f9e00, 0x670f9fff, REGISTRY_APNIC      }, // 103.15.158.0    - 103.15.159.255
	{ 0x670fa400, 0x670fd3ff, REGISTRY_APNIC      }, // 103.15.164.0    - 103.15.211.255
	{ 0x670fd800, 0x670fdbff, REGISTRY_APNIC      }, // 103.15.216.0    - 103.15.219.255
	{ 0x670fe000, 0x670fe2ff, REGISTRY_APNIC      }, // 103.15.224.0    - 103.15.226.255
	{ 0x670fe400, 0x671073ff, REGISTRY_APNIC      }, // 103.15.228.0    - 103.16.115.255
	{ 0x67107800, 0x6710cfff, REGISTRY_APNIC      }, // 103.16.120.0    - 103.16.207.255
	{ 0x6710d200, 0x6710d3ff, REGISTRY_APNIC      }, // 103.16.210.0    - 103.16.211.255
	{ 0x6710d800, 0x6710f7ff, REGISTRY_APNIC      }, // 103.16.216.0    - 103.16.247.255
	{ 0x6710fc00, 0x671103ff, REGISTRY_APNIC      }, // 103.16.252.0    - 103.17.3.255
	{ 0x67110800, 0x67111fff, REGISTRY_APNIC      }, // 103.17.8.0      - 103.17.31.255
	{ 0x67112400, 0x671193ff, REGISTRY_APNIC      }, // 103.17.36.0     - 103.17.147.255
	{ 0x67119800, 0x67122bff, REGISTRY_APNIC      }, // 103.17.152.0    - 103.18.43.255
	{ 0x67123000, 0x67126fff, REGISTRY_APNIC      }, // 103.18.48.0     - 103.18.111.255
	{ 0x67127400, 0x6712b7ff, REGISTRY_APNIC      }, // 103.18.116.0    - 103.18.183.255
	{ 0x6712bc00, 0x6712cbff, REGISTRY_APNIC      }, // 103.18.188.0    - 103.18.203.255
	{ 0x6712d000, 0x6712e7ff, REGISTRY_APNIC      }, // 103.18.208.0    - 103.18.231.255
	{ 0x6712ec00, 0x67131bff, REGISTRY_APNIC      }, // 103.18.236.0    - 103.19.27.255
	{ 0x67132000, 0x67132fff, REGISTRY_APNIC      }, // 103.19.32.0     - 103.19.47.255
	{ 0x67133400, 0x671353ff, REGISTRY_APNIC      }, // 103.19.52.0     - 103.19.83.255
	{ 0x67135400, 0x671357ff, REGISTRY_ARIN       }, // 103.19.84.0     - 103.19.87.255
	{ 0x67135800, 0x671377ff, REGISTRY_APNIC      }, // 103.19.88.0     - 103.19.119.255
	{ 0x67137c00, 0x67139bff, REGISTRY_APNIC      }, // 103.19.124.0    - 103.19.155.255
	{ 0x6713a000, 0x67140fff, REGISTRY_APNIC      }, // 103.19.160.0    - 103.20.15.255
	{ 0x67141100, 0x671431ff, REGISTRY_APNIC      }, // 103.20.17.0     - 103.20.49.255
	{ 0x67143300, 0x67145fff, REGISTRY_APNIC      }, // 103.20.51.0     - 103.20.95.255
	{ 0x67146800, 0x67146bff, REGISTRY_APNIC      }, // 103.20.104.0    - 103.20.107.255
	{ 0x67147000, 0x6714c5ff, REGISTRY_APNIC      }, // 103.20.112.0    - 103.20.197.255
	{ 0x6714c800, 0x6714daff, REGISTRY_APNIC      }, // 103.20.200.0    - 103.20.218.255
	{ 0x6714dc00, 0x6714e3ff, REGISTRY_APNIC      }, // 103.20.220.0    - 103.20.227.255
	{ 0x6714e800, 0x6714efff, REGISTRY_APNIC      }, // 103.20.232.0    - 103.20.239.255
	{ 0x6714f400, 0x671503ff, REGISTRY_APNIC      }, // 103.20.244.0    - 103.21.3.255
	{ 0x67150800, 0x671543ff, REGISTRY_APNIC      }, // 103.21.8.0      - 103.21.67.255
	{ 0x67154800, 0x67155fff, REGISTRY_APNIC      }, // 103.21.72.0     - 103.21.95.255
	{ 0x67156600, 0x6715bbff, REGISTRY_APNIC      }, // 103.21.102.0    - 103.21.187.255
	{ 0x6715c000, 0x6715c2ff, REGISTRY_APNIC      }, // 103.21.192.0    - 103.21.194.255
	{ 0x6715c400, 0x6715dbff, REGISTRY_APNIC      }, // 103.21.196.0    - 103.21.219.255
	{ 0x6715e000, 0x67165fff, REGISTRY_APNIC      }, // 103.21.224.0    - 103.22.95.255
	{ 0x67166400, 0x6716cfff, REGISTRY_APNIC      }, // 103.22.100.0    - 103.22.207.255
	{ 0x6716d100, 0x6716d7ff, REGISTRY_APNIC      }, // 103.22.209.0    - 103.22.215.255
	{ 0x6716dc00, 0x67171bff, REGISTRY_APNIC      }, // 103.22.220.0    - 103.23.27.255
	{ 0x67171d00, 0x671743ff, REGISTRY_APNIC      }, // 103.23.29.0     - 103.23.67.255
	{ 0x67174600, 0x671757ff, REGISTRY_APNIC      }, // 103.23.70.0     - 103.23.87.255
	{ 0x67176000, 0x671793ff, REGISTRY_APNIC      }, // 103.23.96.0     - 103.23.147.255
	{ 0x67179600, 0x6717abff, REGISTRY_APNIC      }, // 103.23.150.0    - 103.23.171.255
	{ 0x6717ae00, 0x6717c3ff, REGISTRY_APNIC      }, // 103.23.174.0    - 103.23.195.255
	{ 0x6717c800, 0x6717f6ff, REGISTRY_APNIC      }, // 103.23.200.0    - 103.23.246.255
	{ 0x6717f800, 0x6717fbff, REGISTRY_APNIC      }, // 103.23.248.0    - 103.23.251.255
	{ 0x67180000, 0x671843ff, REGISTRY_APNIC      }, // 103.24.0.0      - 103.24.67.255
	{ 0x67184800, 0x67184dff, REGISTRY_APNIC      }, // 103.24.72.0     - 103.24.77.255
	{ 0x67185000, 0x671857ff, REGISTRY_APNIC      }, // 103.24.80.0     - 103.24.87.255
	{ 0x67185c00, 0x6718c3ff, REGISTRY_APNIC      }, // 103.24.92.0     - 103.24.195.255
	{ 0x6718c800, 0x6719a3ff, REGISTRY_APNIC      }, // 103.24.200.0    - 103.25.163.255
	{ 0x6719a500, 0x6719b7ff, REGISTRY_APNIC      }, // 103.25.165.0    - 103.25.183.255
	{ 0x6719bc00, 0x6719dbff, REGISTRY_APNIC      }, // 103.25.188.0    - 103.25.219.255
	{ 0x6719dd00, 0x6719e5ff, REGISTRY_APNIC      }, // 103.25.221.0    - 103.25.229.255
	{ 0x6719e600, 0x6719e6ff, REGISTRY_ARIN       }, // 103.25.230.0    - 103.25.230.255
	{ 0x6719e700, 0x671a1bff, REGISTRY_APNIC      }, // 103.25.231.0    - 103.26.27.255
	{ 0x671a2000, 0x671a73ff, REGISTRY_APNIC      }, // 103.26.32.0     - 103.26.115.255
	{ 0x671a7800, 0x671a8bff, REGISTRY_APNIC      }, // 103.26.120.0    - 103.26.139.255
	{ 0x671a8c00, 0x671a8fff, REGISTRY_ARIN       }, // 103.26.140.0    - 103.26.143.255
	{ 0x671a9000, 0x671aafff, REGISTRY_APNIC      }, // 103.26.144.0    - 103.26.175.255
	{ 0x671ab400, 0x671abbff, REGISTRY_APNIC      }, // 103.26.180.0    - 103.26.187.255
	{ 0x671ac000, 0x671bbfff, REGISTRY_APNIC      }, // 103.26.192.0    - 103.27.191.255
	{ 0x671bc400, 0x671c0fff, REGISTRY_APNIC      }, // 103.27.196.0    - 103.28.15.255
	{ 0x671c1400, 0x671c43ff, REGISTRY_APNIC      }, // 103.28.20.0     - 103.28.67.255
	{ 0x671c4400, 0x671c47ff, REGISTRY_ARIN       }, // 103.28.68.0     - 103.28.71.255
	{ 0x671c4800, 0x671cffff, REGISTRY_APNIC      }, // 103.28.72.0     - 103.28.255.255
	{ 0x671d0400, 0x671d07ff, REGISTRY_APNIC      }, // 103.29.4.0      - 103.29.7.255
	{ 0x671d0c00, 0x671d1cff, REGISTRY_APNIC      }, // 103.29.12.0     - 103.29.28.255
	{ 0x671d1e00, 0x671d29ff, REGISTRY_APNIC      }, // 103.29.30.0     - 103.29.41.255
	{ 0x671d2b00, 0x671d3bff, REGISTRY_APNIC      }, // 103.29.43.0     - 103.29.59.255
	{ 0x671d4000, 0x671d4fff, REGISTRY_APNIC      }, // 103.29.64.0     - 103.29.79.255
	{ 0x671d5400, 0x671db3ff, REGISTRY_APNIC      }, // 103.29.84.0     - 103.29.179.255
	{ 0x671db800, 0x671debff, REGISTRY_APNIC      }, // 103.29.184.0    - 103.29.235.255
	{ 0x671df000, 0x671e07ff, REGISTRY_APNIC      }, // 103.29.240.0    - 103.30.7.255
	{ 0x671e0c00, 0x671e3bff, REGISTRY_APNIC      }, // 103.30.12.0     - 103.30.59.255
	{ 0x671e4000, 0x671e47ff, REGISTRY_APNIC      }, // 103.30.64.0     - 103.30.71.255
	{ 0x671e4c00, 0x671e67ff, REGISTRY_APNIC      }, // 103.30.76.0     - 103.30.103.255
	{ 0x671e6c00, 0x671ed3ff, REGISTRY_APNIC      }, // 103.30.108.0    - 103.30.211.255
	{ 0x671ed500, 0x671f07ff, REGISTRY_APNIC      }, // 103.30.213.0    - 103.31.7.255
	{ 0x671f0c00, 0x671f27ff, REGISTRY_APNIC      }, // 103.31.12.0     - 103.31.39.255
	{ 0x671f2c00, 0x671f73ff, REGISTRY_APNIC      }, // 103.31.44.0     - 103.31.115.255
	{ 0x671f7800, 0x672371ff, REGISTRY_APNIC      }, // 103.31.120.0    - 103.35.113.255
	{ 0x67237400, 0x672397ff, REGISTRY_APNIC      }, // 103.35.116.0    - 103.35.151.255
	{ 0x67239c00, 0x6723afff, REGISTRY_APNIC      }, // 103.35.156.0    - 103.35.175.255
	{ 0x6723b400, 0x6723d7ff, REGISTRY_APNIC      }, // 103.35.180.0    - 103.35.215.255
	{ 0x6723d900, 0x6723daff, REGISTRY_APNIC      }, // 103.35.217.0    - 103.35.218.255
	{ 0x6723dc00, 0x672445ff, REGISTRY_APNIC      }, // 103.35.220.0    - 103.36.69.255
	{ 0x67244700, 0x672503ff, REGISTRY_APNIC      }, // 103.36.71.0     - 103.37.3.255
	{ 0x67250800, 0x672515ff, REGISTRY_APNIC      }, // 103.37.8.0      - 103.37.21.255
	{ 0x67251800, 0x672557ff, REGISTRY_APNIC      }, // 103.37.24.0     - 103.37.87.255
	{ 0x67255c00, 0x67255fff, REGISTRY_APNIC      }, // 103.37.92.0     - 103.37.95.255
	{ 0x67256300, 0x6725b7ff, REGISTRY_APNIC      }, // 103.37.99.0     - 103.37.183.255
	{ 0x6725bc00, 0x6725c9ff, REGISTRY_APNIC      }, // 103.37.188.0    - 103.37.201.255
	{ 0x6725cc00, 0x672607ff, REGISTRY_APNIC      }, // 103.37.204.0    - 103.38.7.255
	{ 0x67260900, 0x672633ff, REGISTRY_APNIC      }, // 103.38.9.0      - 103.38.51.255
	{ 0x67263800, 0x67266bff, REGISTRY_APNIC      }, // 103.38.56.0     - 103.38.107.255
	{ 0x67267000, 0x6726b3ff, REGISTRY_APNIC      }, // 103.38.112.0    - 103.38.179.255
	{ 0x6726b800, 0x6726cfff, REGISTRY_APNIC      }, // 103.38.184.0    - 103.38.207.255
	{ 0x6726d400, 0x6726d7ff, REGISTRY_APNIC      }, // 103.38.212.0    - 103.38.215.255
	{ 0x6726da00, 0x6726dbff, REGISTRY_APNIC      }, // 103.38.218.0    - 103.38.219.255
	{ 0x6726e000, 0x6726ebff, REGISTRY_APNIC      }, // 103.38.224.0    - 103.38.235.255
	{ 0x6726f000, 0x6726f3ff, REGISTRY_APNIC      }, // 103.38.240.0    - 103.38.243.255
	{ 0x6726fc00, 0x67271fff, REGISTRY_APNIC      }, // 103.38.252.0    - 103.39.31.255
	{ 0x67272400, 0x672743ff, REGISTRY_APNIC      }, // 103.39.36.0     - 103.39.67.255
	{ 0x67274c00, 0x672777ff, REGISTRY_APNIC      }, // 103.39.76.0     - 103.39.119.255
	{ 0x67277a00, 0x67277bff, REGISTRY_APNIC      }, // 103.39.122.0    - 103.39.123.255
	{ 0x67278000, 0x67278fff, REGISTRY_APNIC      }, // 103.39.128.0    - 103.39.143.255
	{ 0x67279400, 0x6727c3ff, REGISTRY_APNIC      }, // 103.39.148.0    - 103.39.195.255
	{ 0x6727c800, 0x672833ff, REGISTRY_APNIC      }, // 103.39.200.0    - 103.40.51.255
	{ 0x67283600, 0x67289bff, REGISTRY_APNIC      }, // 103.40.54.0     - 103.40.155.255
	{ 0x6728a000, 0x6728a5ff, REGISTRY_APNIC      }, // 103.40.160.0    - 103.40.165.255
	{ 0x6728a800, 0x672947ff, REGISTRY_APNIC      }, // 103.40.168.0    - 103.41.71.255
	{ 0x67295000, 0x67295bff, REGISTRY_APNIC      }, // 103.41.80.0     - 103.41.91.255
	{ 0x67296000, 0x67296fff, REGISTRY_APNIC      }, // 103.41.96.0     - 103.41.111.255
	{ 0x67297400, 0x6729a7ff, REGISTRY_APNIC      }, // 103.41.116.0    - 103.41.167.255
	{ 0x6729a900, 0x6729f7ff, REGISTRY_APNIC      }, // 103.41.169.0    - 103.41.247.255
	{ 0x6729fc00, 0x672a03ff, REGISTRY_APNIC      }, // 103.41.252.0    - 103.42.3.255
	{ 0x672a0800, 0x672a0bff, REGISTRY_APNIC      }, // 103.42.8.0      - 103.42.11.255
	{ 0x672a1000, 0x672a11ff, REGISTRY_APNIC      }, // 103.42.16.0     - 103.42.17.255
	{ 0x672a1300, 0x672a31ff, REGISTRY_APNIC      }, // 103.42.19.0     - 103.42.49.255
	{ 0x672a3800, 0x672a3bff, REGISTRY_APNIC      }, // 103.42.56.0     - 103.42.59.255
	{ 0x672a4000, 0x672a7fff, REGISTRY_APNIC      }, // 103.42.64.0     - 103.42.127.255
	{ 0x672a8400, 0x672aa3ff, REGISTRY_APNIC      }, // 103.42.132.0    - 103.42.163.255
	{ 0x672aa800, 0x672ac7ff, REGISTRY_APNIC      }, // 103.42.168.0    - 103.42.199.255
	{ 0x672acd00, 0x672adbff, REGISTRY_APNIC      }, // 103.42.205.0    - 103.42.219.255
	{ 0x672ae000, 0x672ae3ff, REGISTRY_APNIC      }, // 103.42.224.0    - 103.42.227.255
	{ 0x672ae800, 0x672aefff, REGISTRY_APNIC      }, // 103.42.232.0    - 103.42.239.255
	{ 0x672af800, 0x672b02ff, REGISTRY_APNIC      }, // 103.42.248.0    - 103.43.2.255
	{ 0x672b0400, 0x672b17ff, REGISTRY_APNIC      }, // 103.43.4.0      - 103.43.23.255
	{ 0x672b1c00, 0x672b3bff, REGISTRY_APNIC      }, // 103.43.28.0     - 103.43.59.255
	{ 0x672b4000, 0x672b5dff, REGISTRY_APNIC      }, // 103.43.64.0     - 103.43.93.255
	{ 0x672b6000, 0x672ba3ff, REGISTRY_APNIC      }, // 103.43.96.0     - 103.43.163.255
	{ 0x672ba800, 0x672c07ff, REGISTRY_APNIC      }, // 103.43.168.0    - 103.44.7.255
	{ 0x672c0c00, 0x672c12ff, REGISTRY_APNIC      }, // 103.44.12.0     - 103.44.18.255
	{ 0x672c1400, 0x672c97ff, REGISTRY_APNIC      }, // 103.44.20.0     - 103.44.151.255
	{ 0x672c9c00, 0x672e03ff, REGISTRY_APNIC      }, // 103.44.156.0    - 103.46.3.255
	{ 0x672e0c00, 0x672eb7ff, REGISTRY_APNIC      }, // 103.46.12.0     - 103.46.183.255
	{ 0x672ebc00, 0x672ec6ff, REGISTRY_APNIC      }, // 103.46.188.0    - 103.46.198.255
	{ 0x672ec800, 0x672f07ff, REGISTRY_APNIC      }, // 103.46.200.0    - 103.47.7.255
	{ 0x672f0c00, 0x672f3dff, REGISTRY_APNIC      }, // 103.47.12.0     - 103.47.61.255
	{ 0x672f3e00, 0x672f3fff, REGISTRY_ARIN       }, // 103.47.62.0     - 103.47.63.255
	{ 0x672f4000, 0x672f7fff, REGISTRY_APNIC      }, // 103.47.64.0     - 103.47.127.255
	{ 0x672f8400, 0x672fb3ff, REGISTRY_APNIC      }, // 103.47.132.0    - 103.47.179.255
	{ 0x672fb800, 0x673027ff, REGISTRY_APNIC      }, // 103.47.184.0    - 103.48.39.255
	{ 0x67302c00, 0x67309fff, REGISTRY_APNIC      }, // 103.48.44.0     - 103.48.159.255
	{ 0x6730a400, 0x6730c7ff, REGISTRY_APNIC      }, // 103.48.164.0    - 103.48.199.255
	{ 0x6730c900, 0x673145ff, REGISTRY_APNIC      }, // 103.48.201.0    - 103.49.69.255
	{ 0x67314800, 0x673163ff, REGISTRY_APNIC      }, // 103.49.72.0     - 103.49.99.255
	{ 0x67316800, 0x67316fff, REGISTRY_APNIC      }, // 103.49.104.0    - 103.49.111.255
	{ 0x67317400, 0x67317bff, REGISTRY_APNIC      }, // 103.49.116.0    - 103.49.123.255
	{ 0x67317e00, 0x673191ff, REGISTRY_APNIC      }, // 103.49.126.0    - 103.49.145.255
	{ 0x67319300, 0x673195ff, REGISTRY_APNIC      }, // 103.49.147.0    - 103.49.149.255
	{ 0x67319700, 0x6731a3ff, REGISTRY_APNIC      }, // 103.49.151.0    - 103.49.163.255
	{ 0x6731a800, 0x6731ebff, REGISTRY_APNIC      }, // 103.49.168.0    - 103.49.235.255
	{ 0x6731f000, 0x673213ff, REGISTRY_APNIC      }, // 103.49.240.0    - 103.50.19.255
	{ 0x67321800, 0x673294ff, REGISTRY_APNIC      }, // 103.50.24.0     - 103.50.148.255
	{ 0x67329600, 0x67333dff, REGISTRY_APNIC      }, // 103.50.150.0    - 103.51.61.255
	{ 0x67334000, 0x673353ff, REGISTRY_APNIC      }, // 103.51.64.0     - 103.51.83.255
	{ 0x67335800, 0x67335fff, REGISTRY_APNIC      }, // 103.51.88.0     - 103.51.95.255
	{ 0x67336400, 0x673367ff, REGISTRY_APNIC      }, // 103.51.100.0    - 103.51.103.255
	{ 0x67336c00, 0x673377ff, REGISTRY_APNIC      }, // 103.51.108.0    - 103.51.119.255
	{ 0x67337c00, 0x673380ff, REGISTRY_APNIC      }, // 103.51.124.0    - 103.51.128.255
	{ 0x67338200, 0x6733cbff, REGISTRY_APNIC      }, // 103.51.130.0    - 103.51.203.255
	{ 0x6733d000, 0x673403ff, REGISTRY_APNIC      }, // 103.51.208.0    - 103.52.3.255
	{ 0x67340700, 0x67343eff, REGISTRY_APNIC      }, // 103.52.7.0      - 103.52.62.255
	{ 0x67344000, 0x67346fff, REGISTRY_APNIC      }, // 103.52.64.0     - 103.52.111.255
	{ 0x67347400, 0x673484ff, REGISTRY_APNIC      }, // 103.52.116.0    - 103.52.132.255
	{ 0x67348600, 0x67351bff, REGISTRY_APNIC      }, // 103.52.134.0    - 103.53.27.255
	{ 0x67352000, 0x67359bff, REGISTRY_APNIC      }, // 103.53.32.0     - 103.53.155.255
	{ 0x6735a400, 0x67364bff, REGISTRY_APNIC      }, // 103.53.164.0    - 103.54.75.255
	{ 0x67365400, 0x67366bff, REGISTRY_APNIC      }, // 103.54.84.0     - 103.54.107.255
	{ 0x67366e00, 0x6736a7ff, REGISTRY_APNIC      }, // 103.54.110.0    - 103.54.167.255
	{ 0x6736ac00, 0x6736afff, REGISTRY_APNIC      }, // 103.54.172.0    - 103.54.175.255
	{ 0x6736b400, 0x6736e3ff, REGISTRY_APNIC      }, // 103.54.180.0    - 103.54.227.255
	{ 0x6736e800, 0x673703ff, REGISTRY_APNIC      }, // 103.54.232.0    - 103.55.3.255
	{ 0x67370800, 0x673713ff, REGISTRY_APNIC      }, // 103.55.8.0      - 103.55.19.255
	{ 0x67371800, 0x6737b1ff, REGISTRY_APNIC      }, // 103.55.24.0     - 103.55.177.255
	{ 0x6737b300, 0x6737dfff, REGISTRY_APNIC      }, // 103.55.179.0    - 103.55.223.255
	{ 0x6737e400, 0x6737efff, REGISTRY_APNIC      }, // 103.55.228.0    - 103.55.239.255
	{ 0x6737f400, 0x6737f7ff, REGISTRY_APNIC      }, // 103.55.244.0    - 103.55.247.255
	{ 0x67380000, 0x67384fff, REGISTRY_APNIC      }, // 103.56.0.0      - 103.56.79.255
	{ 0x67385400, 0x67385bff, REGISTRY_APNIC      }, // 103.56.84.0     - 103.56.91.255
	{ 0x67386000, 0x67393fff, REGISTRY_APNIC      }, // 103.56.96.0     - 103.57.63.255
	{ 0x67394400, 0x67395fff, REGISTRY_APNIC      }, // 103.57.68.0     - 103.57.95.255
	{ 0x67396400, 0x67397fff, REGISTRY_APNIC      }, // 103.57.100.0    - 103.57.127.255
	{ 0x67398400, 0x6739dfff, REGISTRY_APNIC      }, // 103.57.132.0    - 103.57.223.255
	{ 0x6739e200, 0x673a76ff, REGISTRY_APNIC      }, // 103.57.226.0    - 103.58.118.255
	{ 0x673a7800, 0x673ab3ff, REGISTRY_APNIC      }, // 103.58.120.0    - 103.58.179.255
	{ 0x673ab600, 0x673ac3ff, REGISTRY_APNIC      }, // 103.58.182.0    - 103.58.195.255
	{ 0x673ac800, 0x673ad7ff, REGISTRY_APNIC      }, // 103.58.200.0    - 103.58.215.255
	{ 0x673adc00, 0x673b9fff, REGISTRY_APNIC      }, // 103.58.220.0    - 103.59.159.255
	{ 0x673ba400, 0x673bd7ff, REGISTRY_APNIC      }, // 103.59.164.0    - 103.59.215.255
	{ 0x673bdc00, 0x673c03ff, REGISTRY_APNIC      }, // 103.59.220.0    - 103.60.3.255
	{ 0x673c0800, 0x673c0bff, REGISTRY_APNIC      }, // 103.60.8.0      - 103.60.11.255
	{ 0x673c0c00, 0x673c0fff, REGISTRY_ARIN       }, // 103.60.12.0     - 103.60.15.255
	{ 0x673c1000, 0x673c57ff, REGISTRY_APNIC      }, // 103.60.16.0     - 103.60.87.255
	{ 0x673c6000, 0x673c60ff, REGISTRY_APNIC      }, // 103.60.96.0     - 103.60.96.255
	{ 0x673c6200, 0x673cbbff, REGISTRY_APNIC      }, // 103.60.98.0     - 103.60.187.255
	{ 0x673cc000, 0x673ccbff, REGISTRY_APNIC      }, // 103.60.192.0    - 103.60.203.255
	{ 0x673cd000, 0x673cefff, REGISTRY_APNIC      }, // 103.60.208.0    - 103.60.239.255
	{ 0x673cf400, 0x673d03ff, REGISTRY_APNIC      }, // 103.60.244.0    - 103.61.3.255
	{ 0x673d0800, 0x673d0fff, REGISTRY_APNIC      }, // 103.61.8.0      - 103.61.15.255
	{ 0x673d1400, 0x673d27ff, REGISTRY_APNIC      }, // 103.61.20.0     - 103.61.39.255
	{ 0x673d2900, 0x673d77ff, REGISTRY_APNIC      }, // 103.61.41.0     - 103.61.119.255
	{ 0x673d7c00, 0x673de7ff, REGISTRY_APNIC      }, // 103.61.124.0    - 103.61.231.255
	{ 0x673dec00, 0x673e93ff, REGISTRY_APNIC      }, // 103.61.236.0    - 103.62.147.255
	{ 0x673e9800, 0x673fbeff, REGISTRY_APNIC      }, // 103.62.152.0    - 103.63.190.255
	{ 0x673fc000, 0x673fe7ff, REGISTRY_APNIC      }, // 103.63.192.0    - 103.63.231.255
	{ 0x673fe900, 0x67407fff, REGISTRY_APNIC      }, // 103.63.233.0    - 103.64.127.255
	{ 0x67408400, 0x674173ff, REGISTRY_APNIC      }, // 103.64.132.0    - 103.65.115.255
	{ 0x67419000, 0x6741cbff, REGISTRY_APNIC      }, // 103.65.144.0    - 103.65.203.255
	{ 0x6741d000, 0x6741dbff, REGISTRY_APNIC      }, // 103.65.208.0    - 103.65.219.255
	{ 0x6741e400, 0x6741efff, REGISTRY_APNIC      }, // 103.65.228.0    - 103.65.239.255
	{ 0x6741f400, 0x6741f7ff, REGISTRY_APNIC      }, // 103.65.244.0    - 103.65.247.255
	{ 0x6741fc00, 0x674225ff, REGISTRY_APNIC      }, // 103.65.252.0    - 103.66.37.255
	{ 0x67422700, 0x6742a7ff, REGISTRY_APNIC      }, // 103.66.39.0     - 103.66.167.255
	{ 0x6742aa00, 0x6742e3ff, REGISTRY_APNIC      }, // 103.66.170.0    - 103.66.227.255
	{ 0x6742e800, 0x6742ebff, REGISTRY_APNIC      }, // 103.66.232.0    - 103.66.235.255
	{ 0x6742f000, 0x674317ff, REGISTRY_APNIC      }, // 103.66.240.0    - 103.67.23.255
	{ 0x67431a00, 0x674327ff, REGISTRY_APNIC      }, // 103.67.26.0     - 103.67.39.255
	{ 0x67436400, 0x67439fff, REGISTRY_APNIC      }, // 103.67.100.0    - 103.67.159.255
	{ 0x6743a400, 0x6743b9ff, REGISTRY_APNIC      }, // 103.67.164.0    - 103.67.185.255
	{ 0x6743bc00, 0x674417ff, REGISTRY_APNIC      }, // 103.67.188.0    - 103.68.23.255
	{ 0x67441900, 0x674419ff, REGISTRY_APNIC      }, // 103.68.25.0     - 103.68.25.255
	{ 0x67441b00, 0x674437ff, REGISTRY_APNIC      }, // 103.68.27.0     - 103.68.55.255
	{ 0x67443a00, 0x674453ff, REGISTRY_APNIC      }, // 103.68.58.0     - 103.68.83.255
	{ 0x67445800, 0x67445eff, REGISTRY_APNIC      }, // 103.68.88.0     - 103.68.94.255
	{ 0x67446000, 0x67447dff, REGISTRY_APNIC      }, // 103.68.96.0     - 103.68.125.255
	{ 0x67448000, 0x67448aff, REGISTRY_APNIC      }, // 103.68.128.0    - 103.68.138.255
	{ 0x67448c00, 0x6744d3ff, REGISTRY_APNIC      }, // 103.68.140.0    - 103.68.211.255
	{ 0x6744d800, 0x6744e7ff, REGISTRY_APNIC      }, // 103.68.216.0    - 103.68.231.255
	{ 0x6744ec00, 0x674501ff, REGISTRY_APNIC      }, // 103.68.236.0    - 103.69.1.255
	{ 0x67450400, 0x67453bff, REGISTRY_APNIC      }, // 103.69.4.0      - 103.69.59.255
	{ 0x67454000, 0x674580ff, REGISTRY_APNIC      }, // 103.69.64.0     - 103.69.128.255
	{ 0x67458200, 0x67459fff, REGISTRY_APNIC      }, // 103.69.130.0    - 103.69.159.255
	{ 0x6745a400, 0x6745c7ff, REGISTRY_APNIC      }, // 103.69.164.0    - 103.69.199.255
	{ 0x6745cc00, 0x6745ebff, REGISTRY_APNIC      }, // 103.69.204.0    - 103.69.235.255
	{ 0x6745f000, 0x6745feff, REGISTRY_APNIC      }, // 103.69.240.0    - 103.69.254.255
	{ 0x67460000, 0x67460bff, REGISTRY_APNIC      }, // 103.70.0.0      - 103.70.11.255
	{ 0x67461000, 0x674623ff, REGISTRY_APNIC      }, // 103.70.16.0     - 103.70.35.255
	{ 0x67462600, 0x6746afff, REGISTRY_APNIC      }, // 103.70.38.0     - 103.70.175.255
	{ 0x6746b400, 0x674718ff, REGISTRY_APNIC      }, // 103.70.180.0    - 103.71.24.255
	{ 0x67471a00, 0x67475fff, REGISTRY_APNIC      }, // 103.71.26.0     - 103.71.95.255
	{ 0x67476200, 0x6747bbff, REGISTRY_APNIC      }, // 103.71.98.0     - 103.71.187.255
	{ 0x6747bd00, 0x6747dbff, REGISTRY_APNIC      }, // 103.71.189.0    - 103.71.219.255
	{ 0x6747e000, 0x674858ff, REGISTRY_APNIC      }, // 103.71.224.0    - 103.72.88.255
	{ 0x67485a00, 0x674887ff, REGISTRY_APNIC      }, // 103.72.90.0     - 103.72.135.255
	{ 0x67488c00, 0x6748c3ff, REGISTRY_APNIC      }, // 103.72.140.0    - 103.72.195.255
	{ 0x6748c900, 0x6748d3ff, REGISTRY_APNIC      }, // 103.72.201.0    - 103.72.211.255
	{ 0x6748d800, 0x674955ff, REGISTRY_APNIC      }, // 103.72.216.0    - 103.73.85.255
	{ 0x67495800, 0x67499dff, REGISTRY_APNIC      }, // 103.73.88.0     - 103.73.157.255
	{ 0x6749a000, 0x6749b7ff, REGISTRY_APNIC      }, // 103.73.160.0    - 103.73.183.255
	{ 0x6749bc00, 0x6749bfff, REGISTRY_APNIC      }, // 103.73.188.0    - 103.73.191.255
	{ 0x6749c200, 0x6749d7ff, REGISTRY_APNIC      }, // 103.73.194.0    - 103.73.215.255
	{ 0x6749dc00, 0x674a07ff, REGISTRY_APNIC      }, // 103.73.220.0    - 103.74.7.255
	{ 0x674a0c00, 0x674a40ff, REGISTRY_APNIC      }, // 103.74.12.0     - 103.74.64.255
	{ 0x674a4200, 0x674ae0ff, REGISTRY_APNIC      }, // 103.74.66.0     - 103.74.224.255
	{ 0x674ae200, 0x674b53ff, REGISTRY_APNIC      }, // 103.74.226.0    - 103.75.83.255
	{ 0x674b5800, 0x674bffff, REGISTRY_APNIC      }, // 103.75.88.0     - 103.75.255.255
	{ 0x674c0200, 0x674c5aff, REGISTRY_APNIC      }, // 103.76.2.0      - 103.76.90.255
	{ 0x674c5c00, 0x674c67ff, REGISTRY_APNIC      }, // 103.76.92.0     - 103.76.103.255
	{ 0x674c7000, 0x674c73ff, REGISTRY_APNIC      }, // 103.76.112.0    - 103.76.115.255
	{ 0x674c7c00, 0x674cbfff, REGISTRY_APNIC      }, // 103.76.124.0    - 103.76.191.255
	{ 0x674cc400, 0x674d0dff, REGISTRY_APNIC      }, // 103.76.196.0    - 103.77.13.255
	{ 0x674d0f00, 0x674d50ff, REGISTRY_APNIC      }, // 103.77.15.0     - 103.77.80.255
	{ 0x674d5200, 0x674e32ff, REGISTRY_APNIC      }, // 103.77.82.0     - 103.78.50.255
	{ 0x674e3400, 0x674eb9ff, REGISTRY_APNIC      }, // 103.78.52.0     - 103.78.185.255
	{ 0x674ebc00, 0x674eefff, REGISTRY_APNIC      }, // 103.78.188.0    - 103.78.239.255
	{ 0x674ef100, 0x674f2fff, REGISTRY_APNIC      }, // 103.78.241.0    - 103.79.47.255
	{ 0x674f3400, 0x674f7fff, REGISTRY_APNIC      }, // 103.79.52.0     - 103.79.127.255
	{ 0x674f8400, 0x674febff, REGISTRY_APNIC      }, // 103.79.132.0    - 103.79.235.255
	{ 0x674ff000, 0x67504dff, REGISTRY_APNIC      }, // 103.79.240.0    - 103.80.77.255
	{ 0x67505000, 0x675082ff, REGISTRY_APNIC      }, // 103.80.80.0     - 103.80.130.255
	{ 0x67508400, 0x6750d3ff, REGISTRY_APNIC      }, // 103.80.132.0    - 103.80.211.255
	{ 0x6750d800, 0x6750e3ff, REGISTRY_APNIC      }, // 103.80.216.0    - 103.80.227.255
	{ 0x6750e800, 0x67511bff, REGISTRY_APNIC      }, // 103.80.232.0    - 103.81.27.255
	{ 0x67512000, 0x675166ff, REGISTRY_APNIC      }, // 103.81.32.0     - 103.81.102.255
	{ 0x67516800, 0x67516bff, REGISTRY_APNIC      }, // 103.81.104.0    - 103.81.107.255
	{ 0x67517000, 0x6751f4ff, REGISTRY_APNIC      }, // 103.81.112.0    - 103.81.244.255
	{ 0x6751f600, 0x6751fbff, REGISTRY_APNIC      }, // 103.81.246.0    - 103.81.251.255
	{ 0x67520000, 0x67525bff, REGISTRY_APNIC      }, // 103.82.0.0      - 103.82.91.255
	{ 0x67526000, 0x6752c7ff, REGISTRY_APNIC      }, // 103.82.96.0     - 103.82.199.255
	{ 0x6752cc00, 0x6752f5ff, REGISTRY_APNIC      }, // 103.82.204.0    - 103.82.245.255
	{ 0x6752f700, 0x675383ff, REGISTRY_APNIC      }, // 103.82.247.0    - 103.83.131.255
	{ 0x67538800, 0x675396ff, REGISTRY_APNIC      }, // 103.83.136.0    - 103.83.150.255
	{ 0x67539800, 0x6753a1ff, REGISTRY_APNIC      }, // 103.83.152.0    - 103.83.161.255
	{ 0x6753a400, 0x6753ebff, REGISTRY_APNIC      }, // 103.83.164.0    - 103.83.235.255
	{ 0x6753f000, 0x675437ff, REGISTRY_APNIC      }, // 103.83.240.0    - 103.84.55.255
	{ 0x67543c00, 0x675463ff, REGISTRY_APNIC      }, // 103.84.60.0     - 103.84.99.255
	{ 0x67546800, 0x6754cbff, REGISTRY_APNIC      }, // 103.84.104.0    - 103.84.203.255
	{ 0x6754d000, 0x675533ff, REGISTRY_APNIC      }, // 103.84.208.0    - 103.85.51.255
	{ 0x67553c00, 0x6755b7ff, REGISTRY_APNIC      }, // 103.85.60.0     - 103.85.183.255
	{ 0x6755bc00, 0x6755f3ff, REGISTRY_APNIC      }, // 103.85.188.0    - 103.85.243.255
	{ 0x6755f800, 0x675673ff, REGISTRY_APNIC      }, // 103.85.248.0    - 103.86.115.255
	{ 0x67567800, 0x67567fff, REGISTRY_APNIC      }, // 103.86.120.0    - 103.86.127.255
	{ 0x67568200, 0x675793ff, REGISTRY_APNIC      }, // 103.86.130.0    - 103.87.147.255
	{ 0x67579800, 0x675857ff, REGISTRY_APNIC      }, // 103.87.152.0    - 103.88.87.255
	{ 0x67585c00, 0x67588aff, REGISTRY_APNIC      }, // 103.88.92.0     - 103.88.138.255
	{ 0x67588c00, 0x675897ff, REGISTRY_APNIC      }, // 103.88.140.0    - 103.88.151.255
	{ 0x67589a00, 0x675923ff, REGISTRY_APNIC      }, // 103.88.154.0    - 103.89.35.255
	{ 0x67592500, 0x67592bff, REGISTRY_APNIC      }, // 103.89.37.0     - 103.89.43.255
	{ 0x67593000, 0x6759efff, REGISTRY_APNIC      }, // 103.89.48.0     - 103.89.239.255
	{ 0x6759f400, 0x675a3bff, REGISTRY_APNIC      }, // 103.89.244.0    - 103.90.59.255
	{ 0x675a4000, 0x675b3bff, REGISTRY_APNIC      }, // 103.90.64.0     - 103.91.59.255
	{ 0x675b3e00, 0x675bc2ff, REGISTRY_APNIC      }, // 103.91.62.0     - 103.91.194.255
	{ 0x675bc400, 0x675bdfff, REGISTRY_APNIC      }, // 103.91.196.0    - 103.91.223.255
	{ 0x675be400, 0x675c0fff, REGISTRY_APNIC      }, // 103.91.228.0    - 103.92.15.255
	{ 0x675c1100, 0x675d13ff, REGISTRY_APNIC      }, // 103.92.17.0     - 103.93.19.255
	{ 0x675d1800, 0x675d1fff, REGISTRY_APNIC      }, // 103.93.24.0     - 103.93.31.255
	{ 0x675d2400, 0x675d5cff, REGISTRY_APNIC      }, // 103.93.36.0     - 103.93.92.255
	{ 0x675d5e00, 0x675e64ff, REGISTRY_APNIC      }, // 103.93.94.0     - 103.94.100.255
	{ 0x675e6600, 0x675e8bff, REGISTRY_APNIC      }, // 103.94.102.0    - 103.94.139.255
	{ 0x675e9000, 0x675ef9ff, REGISTRY_APNIC      }, // 103.94.144.0    - 103.94.249.255
	{ 0x675efc00, 0x675f13ff, REGISTRY_APNIC      }, // 103.94.252.0    - 103.95.19.255
	{ 0x675f1800, 0x676033ff, REGISTRY_APNIC      }, // 103.95.24.0     - 103.96.51.255
	{ 0x67603800, 0x676057ff, REGISTRY_APNIC      }, // 103.96.56.0     - 103.96.87.255
	{ 0x67605900, 0x6760dfff, REGISTRY_APNIC      }, // 103.96.89.0     - 103.96.223.255
	{ 0x6760e400, 0x676156ff, REGISTRY_APNIC      }, // 103.96.228.0    - 103.97.86.255
	{ 0x67615800, 0x676198ff, REGISTRY_APNIC      }, // 103.97.88.0     - 103.97.152.255
	{ 0x67619a00, 0x6761c3ff, REGISTRY_APNIC      }, // 103.97.154.0    - 103.97.195.255
	{ 0x6761c800, 0x6761ffff, REGISTRY_APNIC      }, // 103.97.200.0    - 103.97.255.255
	{ 0x67620400, 0x676279ff, REGISTRY_APNIC      }, // 103.98.4.0      - 103.98.121.255
	{ 0x67627b00, 0x67631aff, REGISTRY_APNIC      }, // 103.98.123.0    - 103.99.26.255
	{ 0x67631c00, 0x676341ff, REGISTRY_APNIC      }, // 103.99.28.0     - 103.99.65.255
	{ 0x67634400, 0x676383ff, REGISTRY_APNIC      }, // 103.99.68.0     - 103.99.131.255
	{ 0x67639400, 0x6763a7ff, REGISTRY_APNIC      }, // 103.99.148.0    - 103.99.167.255
	{ 0x6763ac00, 0x6763baff, REGISTRY_APNIC      }, // 103.99.172.0    - 103.99.186.255
	{ 0x6763bc00, 0x6764afff, REGISTRY_APNIC      }, // 103.99.188.0    - 103.100.175.255
	{ 0x6764b400, 0x6764f4ff, REGISTRY_APNIC      }, // 103.100.180.0   - 103.100.244.255
	{ 0x6764f600, 0x676527ff, REGISTRY_APNIC      }, // 103.100.246.0   - 103.101.39.255
	{ 0x67652a00, 0x67655fff, REGISTRY_APNIC      }, // 103.101.42.0    - 103.101.95.255
	{ 0x67656400, 0x6765a3ff, REGISTRY_APNIC      }, // 103.101.100.0   - 103.101.163.255
	{ 0x6765a600, 0x6765d7ff, REGISTRY_APNIC      }, // 103.101.166.0   - 103.101.215.255
	{ 0x6765dc00, 0x676619ff, REGISTRY_APNIC      }, // 103.101.220.0   - 103.102.25.255
	{ 0x67661b00, 0x67662fff, REGISTRY_APNIC      }, // 103.102.27.0    - 103.102.47.255
	{ 0x67663200, 0x676635ff, REGISTRY_APNIC      }, // 103.102.50.0    - 103.102.53.255
	{ 0x67663800, 0x676703ff, REGISTRY_APNIC      }, // 103.102.56.0    - 103.103.3.255
	{ 0x67670600, 0x6767acff, REGISTRY_APNIC      }, // 103.103.6.0     - 103.103.172.255
	{ 0x6767ae00, 0x6767d7ff, REGISTRY_APNIC      }, // 103.103.174.0   - 103.103.215.255
	{ 0x6767da00, 0x676855ff, REGISTRY_APNIC      }, // 103.103.218.0   - 103.104.85.255
	{ 0x67685700, 0x6768afff, REGISTRY_APNIC      }, // 103.104.87.0    - 103.104.175.255
	{ 0x6768b100, 0x676a67ff, REGISTRY_APNIC      }, // 103.104.177.0   - 103.106.103.255
	{ 0x676a6c00, 0x676b87ff, REGISTRY_APNIC      }, // 103.106.108.0   - 103.107.135.255
	{ 0x676b8c00, 0x676b93ff, REGISTRY_APNIC      }, // 103.107.140.0   - 103.107.147.255
	{ 0x676b9500, 0x676befff, REGISTRY_APNIC      }, // 103.107.149.0   - 103.107.239.255
	{ 0x676bf400, 0x676cabff, REGISTRY_APNIC      }, // 103.107.244.0   - 103.108.171.255
	{ 0x676cad00, 0x676cadff, REGISTRY_APNIC      }, // 103.108.173.0   - 103.108.173.255
	{ 0x676cb000, 0x676d68ff, REGISTRY_APNIC      }, // 103.108.176.0   - 103.109.104.255
	{ 0x676d6a00, 0x676dcbff, REGISTRY_APNIC      }, // 103.109.106.0   - 103.109.203.255
	{ 0x676dd000, 0x6771a5ff, REGISTRY_APNIC      }, // 103.109.208.0   - 103.113.165.255
	{ 0x6771a800, 0x67723eff, REGISTRY_APNIC      }, // 103.113.168.0   - 103.114.62.255
	{ 0x67724000, 0x677357ff, REGISTRY_APNIC      }, // 103.114.64.0    - 103.115.87.255
	{ 0x67735c00, 0x67736bff, REGISTRY_APNIC      }, // 103.115.92.0    - 103.115.107.255
	{ 0x67737000, 0x6779ffff, REGISTRY_APNIC      }, // 103.115.112.0   - 103.121.255.255
	{ 0x677a0400, 0x677a8fff, REGISTRY_APNIC      }, // 103.122.4.0     - 103.122.143.255
	{ 0x677a9400, 0x677fffff, REGISTRY_APNIC      }, // 103.122.148.0   - 103.127.255.255
	{ 0x67810000, 0x6782ebff, REGISTRY_APNIC      }, // 103.129.0.0     - 103.130.235.255
	{ 0x6782f000, 0x6788f3ff, REGISTRY_APNIC      }, // 103.130.240.0   - 103.136.243.255
	{ 0x6788f600, 0x6789d7ff, REGISTRY_APNIC      }, // 103.136.246.0   - 103.137.215.255
	{ 0x67c00000, 0x67c050ff, REGISTRY_APNIC      }, // 103.192.0.0     - 103.192.80.255
	{ 0x67c05200, 0x67c0adff, REGISTRY_APNIC      }, // 103.192.82.0    - 103.192.173.255
	{ 0x67c0af00, 0x67c147ff, REGISTRY_APNIC      }, // 103.192.175.0   - 103.193.71.255
	{ 0x67c14c00, 0x67c1a3ff, REGISTRY_APNIC      }, // 103.193.76.0    - 103.193.163.255
	{ 0x67c1a500, 0x67c1afff, REGISTRY_APNIC      }, // 103.193.165.0   - 103.193.175.255
	{ 0x67c1b400, 0x67c22dff, REGISTRY_APNIC      }, // 103.193.180.0   - 103.194.45.255
	{ 0x67c23000, 0x67c2e3ff, REGISTRY_APNIC      }, // 103.194.48.0    - 103.194.227.255
	{ 0x67c2e500, 0x67c310ff, REGISTRY_APNIC      }, // 103.194.229.0   - 103.195.16.255
	{ 0x67c31200, 0x67c31bff, REGISTRY_APNIC      }, // 103.195.18.0    - 103.195.27.255
	{ 0x67c31d00, 0x67c3ffff, REGISTRY_APNIC      }, // 103.195.29.0    - 103.195.255.255
	{ 0x67c40400, 0x67c40eff, REGISTRY_APNIC      }, // 103.196.4.0     - 103.196.14.255
	{ 0x67c41000, 0x67c419ff, REGISTRY_APNIC      }, // 103.196.16.0    - 103.196.25.255
	{ 0x67c41c00, 0x67c454ff, REGISTRY_APNIC      }, // 103.196.28.0    - 103.196.84.255
	{ 0x67c45600, 0x67c48fff, REGISTRY_APNIC      }, // 103.196.86.0    - 103.196.143.255
	{ 0x67c49400, 0x67c497ff, REGISTRY_APNIC      }, // 103.196.148.0   - 103.196.151.255
	{ 0x67c49c00, 0x67c4a3ff, REGISTRY_APNIC      }, // 103.196.156.0   - 103.196.163.255
	{ 0x67c4a800, 0x67c4afff, REGISTRY_APNIC      }, // 103.196.168.0   - 103.196.175.255
	{ 0x67c4b400, 0x67c4b7ff, REGISTRY_ARIN       }, // 103.196.180.0   - 103.196.183.255
	{ 0x67c4bc00, 0x67c531ff, REGISTRY_APNIC      }, // 103.196.188.0   - 103.197.49.255
	{ 0x67c53300, 0x67c54bff, REGISTRY_APNIC      }, // 103.197.51.0    - 103.197.75.255
	{ 0x67c55000, 0x67c559ff, REGISTRY_APNIC      }, // 103.197.80.0    - 103.197.89.255
	{ 0x67c55c00, 0x67c59bff, REGISTRY_APNIC      }, // 103.197.92.0    - 103.197.155.255
	{ 0x67c5a400, 0x67c5b7ff, REGISTRY_APNIC      }, // 103.197.164.0   - 103.197.183.255
	{ 0x67c5ba00, 0x67c5fbff, REGISTRY_APNIC      }, // 103.197.186.0   - 103.197.251.255
	{ 0x67c60000, 0x67c619ff, REGISTRY_APNIC      }, // 103.198.0.0     - 103.198.25.255
	{ 0x67c61c00, 0x67c65dff, REGISTRY_APNIC      }, // 103.198.28.0    - 103.198.93.255
	{ 0x67c66000, 0x67c680ff, REGISTRY_APNIC      }, // 103.198.96.0    - 103.198.128.255
	{ 0x67c68200, 0x67c697ff, REGISTRY_APNIC      }, // 103.198.130.0   - 103.198.151.255
	{ 0x67c69c00, 0x67c6d2ff, REGISTRY_APNIC      }, // 103.198.156.0   - 103.198.210.255
	{ 0x67c6d400, 0x67c774ff, REGISTRY_APNIC      }, // 103.198.212.0   - 103.199.116.255
	{ 0x67c77600, 0x67c78bff, REGISTRY_APNIC      }, // 103.199.118.0   - 103.199.139.255
	{ 0x67c79000, 0x67c8cbff, REGISTRY_APNIC      }, // 103.199.144.0   - 103.200.203.255
	{ 0x67c8d000, 0x67cae1ff, REGISTRY_APNIC      }, // 103.200.208.0   - 103.202.225.255
	{ 0x67cae300, 0x67cb57ff, REGISTRY_APNIC      }, // 103.202.227.0   - 103.203.87.255
	{ 0x67cb5b00, 0x67cc2bff, REGISTRY_APNIC      }, // 103.203.91.0    - 103.204.43.255
	{ 0x67cc3000, 0x67cc46ff, REGISTRY_APNIC      }, // 103.204.48.0    - 103.204.70.255
	{ 0x67cc4800, 0x67cc5bff, REGISTRY_APNIC      }, // 103.204.72.0    - 103.204.91.255
	{ 0x67cc6000, 0x67cc73ff, REGISTRY_APNIC      }, // 103.204.96.0    - 103.204.115.255
	{ 0x67cc7500, 0x67ccd7ff, REGISTRY_APNIC      }, // 103.204.117.0   - 103.204.215.255
	{ 0x67ccda00, 0x67cd23ff, REGISTRY_APNIC      }, // 103.204.218.0   - 103.205.35.255
	{ 0x67cd2600, 0x67cd3bff, REGISTRY_APNIC      }, // 103.205.38.0    - 103.205.59.255
	{ 0x67cd4000, 0x67cdb8ff, REGISTRY_APNIC      }, // 103.205.64.0    - 103.205.184.255
	{ 0x67cdba00, 0x67cddbff, REGISTRY_APNIC      }, // 103.205.186.0   - 103.205.219.255
	{ 0x67cde000, 0x67ce0fff, REGISTRY_APNIC      }, // 103.205.224.0   - 103.206.15.255
	{ 0x67ce1400, 0x67ce1cff, REGISTRY_APNIC      }, // 103.206.20.0    - 103.206.28.255
	{ 0x67ce1e00, 0x67ce47ff, REGISTRY_APNIC      }, // 103.206.30.0    - 103.206.71.255
	{ 0x67ce4a00, 0x67ce53ff, REGISTRY_APNIC      }, // 103.206.74.0    - 103.206.83.255
	{ 0x67ce5400, 0x67ce57ff, REGISTRY_ARIN       }, // 103.206.84.0    - 103.206.87.255
	{ 0x67ce5800, 0x67ce61ff, REGISTRY_APNIC      }, // 103.206.88.0    - 103.206.97.255
	{ 0x67ce6300, 0x67ce99ff, REGISTRY_APNIC      }, // 103.206.99.0    - 103.206.153.255
	{ 0x67ce9c00, 0x67ce9dff, REGISTRY_APNIC      }, // 103.206.156.0   - 103.206.157.255
	{ 0x67ce9f00, 0x67cf3bff, REGISTRY_APNIC      }, // 103.206.159.0   - 103.207.59.255
	{ 0x67cf4000, 0x67cf57ff, REGISTRY_APNIC      }, // 103.207.64.0    - 103.207.87.255
	{ 0x67cf5c00, 0x67cf66ff, REGISTRY_APNIC      }, // 103.207.92.0    - 103.207.102.255
	{ 0x67cf6800, 0x67d03fff, REGISTRY_APNIC      }, // 103.207.104.0   - 103.208.63.255
	{ 0x67d04400, 0x67d057ff, REGISTRY_APNIC      }, // 103.208.68.0    - 103.208.87.255
	{ 0x67d05c00, 0x67d11fff, REGISTRY_APNIC      }, // 103.208.92.0    - 103.209.31.255
	{ 0x67d12400, 0x67d13bff, REGISTRY_APNIC      }, // 103.209.36.0    - 103.209.59.255
	{ 0x67d14000, 0x67d15bff, REGISTRY_APNIC      }, // 103.209.64.0    - 103.209.91.255
	{ 0x67d15f00, 0x67d16bff, REGISTRY_APNIC      }, // 103.209.95.0    - 103.209.107.255
	{ 0x67d16e00, 0x67d17fff, REGISTRY_APNIC      }, // 103.209.110.0   - 103.209.127.255
	{ 0x67d18200, 0x67d183ff, REGISTRY_APNIC      }, // 103.209.130.0   - 103.209.131.255
	{ 0x67d18800, 0x67d199ff, REGISTRY_APNIC      }, // 103.209.136.0   - 103.209.153.255
	{ 0x67d19c00, 0x67d233ff, REGISTRY_APNIC      }, // 103.209.156.0   - 103.210.51.255
	{ 0x67d23800, 0x67d243ff, REGISTRY_APNIC      }, // 103.210.56.0    - 103.210.67.255
	{ 0x67d24800, 0x67d271ff, REGISTRY_APNIC      }, // 103.210.72.0    - 103.210.113.255
	{ 0x67d27400, 0x67d27dff, REGISTRY_APNIC      }, // 103.210.116.0   - 103.210.125.255
	{ 0x67d28400, 0x67d2d1ff, REGISTRY_APNIC      }, // 103.210.132.0   - 103.210.209.255
	{ 0x67d2d300, 0x67d2dfff, REGISTRY_APNIC      }, // 103.210.211.0   - 103.210.223.255
	{ 0x67d2e400, 0x67d303ff, REGISTRY_APNIC      }, // 103.210.228.0   - 103.211.3.255
	{ 0x67d30600, 0x67d31aff, REGISTRY_APNIC      }, // 103.211.6.0     - 103.211.26.255
	{ 0x67d31c00, 0x67d367ff, REGISTRY_APNIC      }, // 103.211.28.0    - 103.211.103.255
	{ 0x67d36c00, 0x67d39fff, REGISTRY_APNIC      }, // 103.211.108.0   - 103.211.159.255
	{ 0x67d3a400, 0x67d3a7ff, REGISTRY_APNIC      }, // 103.211.164.0   - 103.211.167.255
	{ 0x67d3ac00, 0x67d3c3ff, REGISTRY_APNIC      }, // 103.211.172.0   - 103.211.195.255
	{ 0x67d3c500, 0x67d3c7ff, REGISTRY_APNIC      }, // 103.211.197.0   - 103.211.199.255
	{ 0x67d3d000, 0x67d497ff, REGISTRY_APNIC      }, // 103.211.208.0   - 103.212.151.255
	{ 0x67d49c00, 0x67d49fff, REGISTRY_APNIC      }, // 103.212.156.0   - 103.212.159.255
	{ 0x67d4a400, 0x67d4abff, REGISTRY_APNIC      }, // 103.212.164.0   - 103.212.171.255
	{ 0x67d4b000, 0x67d4b0ff, REGISTRY_APNIC      }, // 103.212.176.0   - 103.212.176.255
	{ 0x67d4b400, 0x67d4b7ff, REGISTRY_APNIC      }, // 103.212.180.0   - 103.212.183.255
	{ 0x67d4bc00, 0x67d4d1ff, REGISTRY_APNIC      }, // 103.212.188.0   - 103.212.209.255
	{ 0x67d4d300, 0x67d5c3ff, REGISTRY_APNIC      }, // 103.212.211.0   - 103.213.195.255
	{ 0x67d5c800, 0x67d5e5ff, REGISTRY_APNIC      }, // 103.213.200.0   - 103.213.229.255
	{ 0x67d5ec00, 0x67d5fbff, REGISTRY_APNIC      }, // 103.213.236.0   - 103.213.251.255
	{ 0x67d60000, 0x67d627ff, REGISTRY_APNIC      }, // 103.214.0.0     - 103.214.39.255
	{ 0x67d62900, 0x67d65fff, REGISTRY_APNIC      }, // 103.214.41.0    - 103.214.95.255
	{ 0x67d66200, 0x67d69fff, REGISTRY_APNIC      }, // 103.214.98.0    - 103.214.159.255
	{ 0x67d6a400, 0x67d6b1ff, REGISTRY_APNIC      }, // 103.214.164.0   - 103.214.177.255
	{ 0x67d6b400, 0x67d6dfff, REGISTRY_APNIC      }, // 103.214.180.0   - 103.214.223.255
	{ 0x67d6e400, 0x67d73bff, REGISTRY_APNIC      }, // 103.214.228.0   - 103.215.59.255
	{ 0x67d74000, 0x67d748ff, REGISTRY_APNIC      }, // 103.215.64.0    - 103.215.72.255
	{ 0x67d74a00, 0x67d76fff, REGISTRY_APNIC      }, // 103.215.74.0    - 103.215.111.255
	{ 0x67d77400, 0x67d7b3ff, REGISTRY_APNIC      }, // 103.215.116.0   - 103.215.179.255
	{ 0x67d7b800, 0x67d7e7ff, REGISTRY_APNIC      }, // 103.215.184.0   - 103.215.231.255
	{ 0x67d7ea00, 0x67d862ff, REGISTRY_APNIC      }, // 103.215.234.0   - 103.216.98.255
	{ 0x67d86400, 0x67d885ff, REGISTRY_APNIC      }, // 103.216.100.0   - 103.216.133.255
	{ 0x67d88700, 0x67d94bff, REGISTRY_APNIC      }, // 103.216.135.0   - 103.217.75.255
	{ 0x67d94d00, 0x67d961ff, REGISTRY_APNIC      }, // 103.217.77.0    - 103.217.97.255
	{ 0x67d96400, 0x67da67ff, REGISTRY_APNIC      }, // 103.217.100.0   - 103.218.103.255
	{ 0x67da6c00, 0x67dab3ff, REGISTRY_APNIC      }, // 103.218.108.0   - 103.218.179.255
	{ 0x67dab800, 0x67dbdfff, REGISTRY_APNIC      }, // 103.218.184.0   - 103.219.223.255
	{ 0x67dbe400, 0x67dc15ff, REGISTRY_APNIC      }, // 103.219.228.0   - 103.220.21.255
	{ 0x67dc1800, 0x67dc2bff, REGISTRY_APNIC      }, // 103.220.24.0    - 103.220.43.255
	{ 0x67dc2d00, 0x67dd3fff, REGISTRY_APNIC      }, // 103.220.45.0    - 103.221.63.255
	{ 0x67dd4400, 0x67ddebff, REGISTRY_APNIC      }, // 103.221.68.0    - 103.221.235.255
	{ 0x67ddf000, 0x67defbff, REGISTRY_APNIC      }, // 103.221.240.0   - 103.222.251.255
	{ 0x67df0000, 0x67e00fff, REGISTRY_APNIC      }, // 103.223.0.0     - 103.224.15.255
	{ 0x67e01400, 0x67e036ff, REGISTRY_APNIC      }, // 103.224.20.0    - 103.224.54.255
	{ 0x67e03800, 0x67e04bff, REGISTRY_APNIC      }, // 103.224.56.0    - 103.224.75.255
	{ 0x67e05000, 0x67e05bff, REGISTRY_APNIC      }, // 103.224.80.0    - 103.224.91.255
	{ 0x67e06000, 0x67e07bff, REGISTRY_APNIC      }, // 103.224.96.0    - 103.224.123.255
	{ 0x67e07f00, 0x67e0abff, REGISTRY_APNIC      }, // 103.224.127.0   - 103.224.171.255
	{ 0x67e0b000, 0x67e12bff, REGISTRY_APNIC      }, // 103.224.176.0   - 103.225.43.255
	{ 0x67e12e00, 0x67e160ff, REGISTRY_APNIC      }, // 103.225.46.0    - 103.225.96.255
	{ 0x67e16200, 0x67e173ff, REGISTRY_APNIC      }, // 103.225.98.0    - 103.225.115.255
	{ 0x67e17800, 0x67e1c7ff, REGISTRY_APNIC      }, // 103.225.120.0   - 103.225.199.255
	{ 0x67e1c800, 0x67e1cbff, REGISTRY_RIPENCC    }, // 103.225.200.0   - 103.225.203.255
	{ 0x67e1cc00, 0x67e1d7ff, REGISTRY_APNIC      }, // 103.225.204.0   - 103.225.215.255
	{ 0x67e1dc00, 0x67e1f2ff, REGISTRY_APNIC      }, // 103.225.220.0   - 103.225.242.255
	{ 0x67e1f400, 0x67e1fbff, REGISTRY_APNIC      }, // 103.225.244.0   - 103.225.251.255
	{ 0x67e20000, 0x67e217ff, REGISTRY_APNIC      }, // 103.226.0.0     - 103.226.23.255
	{ 0x67e21c00, 0x67e273ff, REGISTRY_APNIC      }, // 103.226.28.0    - 103.226.115.255
	{ 0x67e27800, 0x67e303ff, REGISTRY_APNIC      }, // 103.226.120.0   - 103.227.3.255
	{ 0x67e30800, 0x67e35bff, REGISTRY_APNIC      }, // 103.227.8.0     - 103.227.91.255
	{ 0x67e36000, 0x67e3b7ff, REGISTRY_APNIC      }, // 103.227.96.0    - 103.227.183.255
	{ 0x67e3bc00, 0x67e3f7ff, REGISTRY_APNIC      }, // 103.227.188.0   - 103.227.247.255
	{ 0x67e3fc00, 0x67e407ff, REGISTRY_APNIC      }, // 103.227.252.0   - 103.228.7.255
	{ 0x67e40c00, 0x67e411ff, REGISTRY_APNIC      }, // 103.228.12.0    - 103.228.17.255
	{ 0x67e41300, 0x67e42fff, REGISTRY_APNIC      }, // 103.228.19.0    - 103.228.47.255
	{ 0x67e43100, 0x67e447ff, REGISTRY_APNIC      }, // 103.228.49.0    - 103.228.71.255
	{ 0x67e44c00, 0x67e466ff, REGISTRY_APNIC      }, // 103.228.76.0    - 103.228.102.255
	{ 0x67e46800, 0x67e4ffff, REGISTRY_APNIC      }, // 103.228.104.0   - 103.228.255.255
	{ 0x67e50100, 0x67e50dff, REGISTRY_APNIC      }, // 103.229.1.0     - 103.229.13.255
	{ 0x67e51000, 0x67e533ff, REGISTRY_APNIC      }, // 103.229.16.0    - 103.229.51.255
	{ 0x67e53800, 0x67e557ff, REGISTRY_APNIC      }, // 103.229.56.0    - 103.229.87.255
	{ 0x67e55c00, 0x67e560ff, REGISTRY_APNIC      }, // 103.229.92.0    - 103.229.96.255
	{ 0x67e56200, 0x67e582ff, REGISTRY_APNIC      }, // 103.229.98.0    - 103.229.130.255
	{ 0x67e58400, 0x67e5bbff, REGISTRY_APNIC      }, // 103.229.132.0   - 103.229.187.255
	{ 0x67e5c000, 0x67e5e7ff, REGISTRY_APNIC      }, // 103.229.192.0   - 103.229.231.255
	{ 0x67e5ec00, 0x67e627ff, REGISTRY_APNIC      }, // 103.229.236.0   - 103.230.39.255
	{ 0x67e62c00, 0x67e650ff, REGISTRY_APNIC      }, // 103.230.44.0    - 103.230.80.255
	{ 0x67e65300, 0x67e65bff, REGISTRY_APNIC      }, // 103.230.83.0    - 103.230.91.255
	{ 0x67e66000, 0x67e67fff, REGISTRY_APNIC      }, // 103.230.96.0    - 103.230.127.255
	{ 0x67e68400, 0x67e6afff, REGISTRY_APNIC      }, // 103.230.132.0   - 103.230.175.255
	{ 0x67e6b400, 0x67e6f3ff, REGISTRY_APNIC      }, // 103.230.180.0   - 103.230.243.255
	{ 0x67e6f800, 0x67e717ff, REGISTRY_APNIC      }, // 103.230.248.0   - 103.231.23.255
	{ 0x67e71b00, 0x67e787ff, REGISTRY_APNIC      }, // 103.231.27.0    - 103.231.135.255
	{ 0x67e78800, 0x67e78bff, REGISTRY_RIPENCC    }, // 103.231.136.0   - 103.231.139.255
	{ 0x67e78c00, 0x67e7edff, REGISTRY_APNIC      }, // 103.231.140.0   - 103.231.237.255
	{ 0x67e7f000, 0x67e813ff, REGISTRY_APNIC      }, // 103.231.240.0   - 103.232.19.255
	{ 0x67e81800, 0x67e8a3ff, REGISTRY_APNIC      }, // 103.232.24.0    - 103.232.163.255
	{ 0x67e8a800, 0x67e8cdff, REGISTRY_APNIC      }, // 103.232.168.0   - 103.232.205.255
	{ 0x67e8ce00, 0x67e8cfff, REGISTRY_ARIN       }, // 103.232.206.0   - 103.232.207.255
	{ 0x67e8d000, 0x67e9a1ff, REGISTRY_APNIC      }, // 103.232.208.0   - 103.233.161.255
	{ 0x67e9a400, 0x67e9afff, REGISTRY_APNIC      }, // 103.233.164.0   - 103.233.175.255
	{ 0x67e9b400, 0x67ea1bff, REGISTRY_APNIC      }, // 103.233.180.0   - 103.234.27.255
	{ 0x67ea2400, 0x67ea5eff, REGISTRY_APNIC      }, // 103.234.36.0    - 103.234.94.255
	{ 0x67ea6000, 0x67ea7bff, REGISTRY_APNIC      }, // 103.234.96.0    - 103.234.123.255
	{ 0x67ea8000, 0x67ea95ff, REGISTRY_APNIC      }, // 103.234.128.0   - 103.234.149.255
	{ 0x67ea9800, 0x67ea9fff, REGISTRY_APNIC      }, // 103.234.152.0   - 103.234.159.255
	{ 0x67eaa200, 0x67eabbff, REGISTRY_APNIC      }, // 103.234.162.0   - 103.234.187.255
	{ 0x67eac000, 0x67eb9fff, REGISTRY_APNIC      }, // 103.234.192.0   - 103.235.159.255
	{ 0x67eba400, 0x67ec67ff, REGISTRY_APNIC      }, // 103.235.164.0   - 103.236.103.255
	{ 0x67ec6c00, 0x67ec7fff, REGISTRY_APNIC      }, // 103.236.108.0   - 103.236.127.255
	{ 0x67ec8400, 0x67ec8bff, REGISTRY_APNIC      }, // 103.236.132.0   - 103.236.139.255
	{ 0x67ec9000, 0x67ecabff, REGISTRY_APNIC      }, // 103.236.144.0   - 103.236.171.255
	{ 0x67ecb000, 0x67ecc1ff, REGISTRY_APNIC      }, // 103.236.176.0   - 103.236.193.255
	{ 0x67ecc400, 0x67ecd3ff, REGISTRY_APNIC      }, // 103.236.196.0   - 103.236.211.255
	{ 0x67ecd800, 0x67ed2fff, REGISTRY_APNIC      }, // 103.236.216.0   - 103.237.47.255
	{ 0x67ed3400, 0x67ed53ff, REGISTRY_APNIC      }, // 103.237.52.0    - 103.237.83.255
	{ 0x67ed5800, 0x67ee3fff, REGISTRY_APNIC      }, // 103.237.88.0    - 103.238.63.255
	{ 0x67ee4400, 0x67ee6fff, REGISTRY_APNIC      }, // 103.238.68.0    - 103.238.111.255
	{ 0x67ee7400, 0x67ee7fff, REGISTRY_APNIC      }, // 103.238.116.0   - 103.238.127.255
	{ 0x67ee8400, 0x67ee97ff, REGISTRY_APNIC      }, // 103.238.132.0   - 103.238.151.255
	{ 0x67ee9c00, 0x67eed7ff, REGISTRY_APNIC      }, // 103.238.156.0   - 103.238.215.255
	{ 0x67eedc00, 0x67ef0bff, REGISTRY_APNIC      }, // 103.238.220.0   - 103.239.11.255
	{ 0x67ef1000, 0x67ef13ff, REGISTRY_APNIC      }, // 103.239.16.0    - 103.239.19.255
	{ 0x67ef1800, 0x67ef27ff, REGISTRY_APNIC      }, // 103.239.24.0    - 103.239.39.255
	{ 0x67ef2c00, 0x67ef3fff, REGISTRY_APNIC      }, // 103.239.44.0    - 103.239.63.255
	{ 0x67ef4400, 0x67ef57ff, REGISTRY_APNIC      }, // 103.239.68.0    - 103.239.87.255
	{ 0x67ef5c00, 0x67ef93ff, REGISTRY_APNIC      }, // 103.239.92.0    - 103.239.147.255
	{ 0x67ef9800, 0x67efabff, REGISTRY_APNIC      }, // 103.239.152.0   - 103.239.171.255
	{ 0x67efb000, 0x67efd5ff, REGISTRY_APNIC      }, // 103.239.176.0   - 103.239.213.255
	{ 0x67efd800, 0x67efffff, REGISTRY_APNIC      }, // 103.239.216.0   - 103.239.255.255
	{ 0x67f00800, 0x67f017ff, REGISTRY_APNIC      }, // 103.240.8.0     - 103.240.23.255
	{ 0x67f01c00, 0x67f037ff, REGISTRY_APNIC      }, // 103.240.28.0    - 103.240.55.255
	{ 0x67f03c00, 0x67f043ff, REGISTRY_APNIC      }, // 103.240.60.0    - 103.240.67.255
	{ 0x67f04800, 0x67f127ff, REGISTRY_APNIC      }, // 103.240.72.0    - 103.241.39.255
	{ 0x67f12c00, 0x67f16bff, REGISTRY_APNIC      }, // 103.241.44.0    - 103.241.107.255
	{ 0x67f16c00, 0x67f16fff, REGISTRY_RIPENCC    }, // 103.241.108.0   - 103.241.111.255
	{ 0x67f17000, 0x67f194ff, REGISTRY_APNIC      }, // 103.241.112.0   - 103.241.148.255
	{ 0x67f19600, 0x67f1abff, REGISTRY_APNIC      }, // 103.241.150.0   - 103.241.171.255
	{ 0x67f1b000, 0x67f1bfff, REGISTRY_APNIC      }, // 103.241.176.0   - 103.241.191.255
	{ 0x67f1c400, 0x67f207ff, REGISTRY_APNIC      }, // 103.241.196.0   - 103.242.7.255
	{ 0x67f20c00, 0x67f24bff, REGISTRY_APNIC      }, // 103.242.12.0    - 103.242.75.255
	{ 0x67f25400, 0x67f255ff, REGISTRY_APNIC      }, // 103.242.84.0    - 103.242.85.255
	{ 0x67f25700, 0x67f295ff, REGISTRY_APNIC      }, // 103.242.87.0    - 103.242.149.255
	{ 0x67f29800, 0x67f2bfff, REGISTRY_APNIC      }, // 103.242.152.0   - 103.242.191.255
	{ 0x67f2c000, 0x67f2c3ff, REGISTRY_ARIN       }, // 103.242.192.0   - 103.242.195.255
	{ 0x67f2c400, 0x67f2e9ff, REGISTRY_APNIC      }, // 103.242.196.0   - 103.242.233.255
	{ 0x67f2eb00, 0x67f307ff, REGISTRY_APNIC      }, // 103.242.235.0   - 103.243.7.255
	{ 0x67f30c00, 0x67f312ff, REGISTRY_APNIC      }, // 103.243.12.0    - 103.243.18.255
	{ 0x67f31400, 0x67f3a7ff, REGISTRY_APNIC      }, // 103.243.20.0    - 103.243.167.255
	{ 0x67f3ac00, 0x67f3afff, REGISTRY_APNIC      }, // 103.243.172.0   - 103.243.175.255
	{ 0x67f3b100, 0x67f3e3ff, REGISTRY_APNIC      }, // 103.243.177.0   - 103.243.227.255
	{ 0x67f3ec00, 0x67f3edff, REGISTRY_APNIC      }, // 103.243.236.0   - 103.243.237.255
	{ 0x67f3ef00, 0x67f3f3ff, REGISTRY_APNIC      }, // 103.243.239.0   - 103.243.243.255
	{ 0x67f3f600, 0x67f413ff, REGISTRY_APNIC      }, // 103.243.246.0   - 103.244.19.255
	{ 0x67f41c00, 0x67f430ff, REGISTRY_APNIC      }, // 103.244.28.0    - 103.244.48.255
	{ 0x67f43200, 0x67f4a2ff, REGISTRY_APNIC      }, // 103.244.50.0    - 103.244.162.255
	{ 0x67f4a400, 0x67f4bbff, REGISTRY_APNIC      }, // 103.244.164.0   - 103.244.187.255
	{ 0x67f4be00, 0x67f4dfff, REGISTRY_APNIC      }, // 103.244.190.0   - 103.244.223.255
	{ 0x67f4e400, 0x67f523ff, REGISTRY_APNIC      }, // 103.244.228.0   - 103.245.35.255
	{ 0x67f52800, 0x67f537ff, REGISTRY_APNIC      }, // 103.245.40.0    - 103.245.55.255
	{ 0x67f53c00, 0x67f59bff, REGISTRY_APNIC      }, // 103.245.60.0    - 103.245.155.255
	{ 0x67f5a000, 0x67f5a7ff, REGISTRY_APNIC      }, // 103.245.160.0   - 103.245.167.255
	{ 0x67f5ac00, 0x67f5b1ff, REGISTRY_APNIC      }, // 103.245.172.0   - 103.245.177.255
	{ 0x67f5b400, 0x67f5ebff, REGISTRY_APNIC      }, // 103.245.180.0   - 103.245.235.255
	{ 0x67f5f000, 0x67f63bff, REGISTRY_APNIC      }, // 103.245.240.0   - 103.246.59.255
	{ 0x67f64400, 0x67f647ff, REGISTRY_APNIC      }, // 103.246.68.0    - 103.246.71.255
	{ 0x67f64c00, 0x67f668ff, REGISTRY_APNIC      }, // 103.246.76.0    - 103.246.104.255
	{ 0x67f66a00, 0x67f6a7ff, REGISTRY_APNIC      }, // 103.246.106.0   - 103.246.167.255
	{ 0x67f6a900, 0x67f742ff, REGISTRY_APNIC      }, // 103.246.169.0   - 103.247.66.255
	{ 0x67f74400, 0x67f7bbff, REGISTRY_APNIC      }, // 103.247.68.0    - 103.247.187.255
	{ 0x67f7bd00, 0x67f7efff, REGISTRY_APNIC      }, // 103.247.189.0   - 103.247.239.255
	{ 0x67f7f400, 0x67f807ff, REGISTRY_APNIC      }, // 103.247.244.0   - 103.248.7.255
	{ 0x67f80c00, 0x67f82fff, REGISTRY_APNIC      }, // 103.248.12.0    - 103.248.47.255
	{ 0x67f83400, 0x67f88bff, REGISTRY_APNIC      }, // 103.248.52.0    - 103.248.139.255
	{ 0x67f89000, 0x67f8e3ff, REGISTRY_APNIC      }, // 103.248.144.0   - 103.248.227.255
	{ 0x67f8e800, 0x67f8efff, REGISTRY_APNIC      }, // 103.248.232.0   - 103.248.239.255
	{ 0x67f8f400, 0x67f8f9ff, REGISTRY_APNIC      }, // 103.248.244.0   - 103.248.249.255
	{ 0x67f8fb00, 0x67f911ff, REGISTRY_APNIC      }, // 103.248.251.0   - 103.249.17.255
	{ 0x67f91400, 0x67f973ff, REGISTRY_APNIC      }, // 103.249.20.0    - 103.249.115.255
	{ 0x67f97800, 0x67f9c7ff, REGISTRY_APNIC      }, // 103.249.120.0   - 103.249.199.255
	{ 0x67f9cc00, 0x67fa1bff, REGISTRY_APNIC      }, // 103.249.204.0   - 103.250.27.255
	{ 0x67fa1e00, 0x67fa27ff, REGISTRY_APNIC      }, // 103.250.30.0    - 103.250.39.255
	{ 0x67fa2900, 0x67fa4bff, REGISTRY_APNIC      }, // 103.250.41.0    - 103.250.75.255
	{ 0x67fa5000, 0x67fa5fff, REGISTRY_APNIC      }, // 103.250.80.0    - 103.250.95.255
	{ 0x67fa6800, 0x67fa6bff, REGISTRY_APNIC      }, // 103.250.104.0   - 103.250.107.255
	{ 0x67fa7000, 0x67fa77ff, REGISTRY_APNIC      }, // 103.250.112.0   - 103.250.119.255
	{ 0x67fa7c00, 0x67fabaff, REGISTRY_APNIC      }, // 103.250.124.0   - 103.250.186.255
	{ 0x67fabc00, 0x67fac3ff, REGISTRY_APNIC      }, // 103.250.188.0   - 103.250.195.255
	{ 0x67fac600, 0x67facfff, REGISTRY_APNIC      }, // 103.250.198.0   - 103.250.207.255
	{ 0x67fad400, 0x67fadbff, REGISTRY_APNIC      }, // 103.250.212.0   - 103.250.219.255
	{ 0x67fade00, 0x67fb07ff, REGISTRY_APNIC      }, // 103.250.222.0   - 103.251.7.255
	{ 0x67fb0c00, 0x67fb43ff, REGISTRY_APNIC      }, // 103.251.12.0    - 103.251.67.255
	{ 0x67fb4500, 0x67fb46ff, REGISTRY_APNIC      }, // 103.251.69.0    - 103.251.70.255
	{ 0x67fb4800, 0x67fba3ff, REGISTRY_APNIC      }, // 103.251.72.0    - 103.251.163.255
	{ 0x67fba400, 0x67fba7ff, REGISTRY_RIPENCC    }, // 103.251.164.0   - 103.251.167.255
	{ 0x67fba800, 0x67fba9ff, REGISTRY_APNIC      }, // 103.251.168.0   - 103.251.169.255
	{ 0x67fbab00, 0x67fbfbff, REGISTRY_APNIC      }, // 103.251.171.0   - 103.251.251.255
	{ 0x67fc0000, 0x67fc2eff, REGISTRY_APNIC      }, // 103.252.0.0     - 103.252.46.255
	{ 0x67fc3100, 0x67fc47ff, REGISTRY_APNIC      }, // 103.252.49.0    - 103.252.71.255
	{ 0x67fc4c00, 0x67fc55ff, REGISTRY_APNIC      }, // 103.252.76.0    - 103.252.85.255
	{ 0x67fc5800, 0x67fc5bff, REGISTRY_RIPENCC    }, // 103.252.88.0    - 103.252.91.255
	{ 0x67fc6000, 0x67fc77ff, REGISTRY_APNIC      }, // 103.252.96.0    - 103.252.119.255
	{ 0x67fc7c00, 0x67fc87ff, REGISTRY_APNIC      }, // 103.252.124.0   - 103.252.135.255
	{ 0x67fc8c00, 0x67fc9fff, REGISTRY_APNIC      }, // 103.252.140.0   - 103.252.159.255
	{ 0x67fca100, 0x67fcb3ff, REGISTRY_APNIC      }, // 103.252.161.0   - 103.252.179.255
	{ 0x67fcb800, 0x67fcbfff, REGISTRY_APNIC      }, // 103.252.184.0   - 103.252.191.255
	{ 0x67fcc400, 0x67fd0fff, REGISTRY_APNIC      }, // 103.252.196.0   - 103.253.15.255
	{ 0x67fd1800, 0x67fd5fff, REGISTRY_APNIC      }, // 103.253.24.0    - 103.253.95.255
	{ 0x67fd6000, 0x67fd63ff, REGISTRY_ARIN       }, // 103.253.96.0    - 103.253.99.255
	{ 0x67fd6800, 0x67fd7eff, REGISTRY_APNIC      }, // 103.253.104.0   - 103.253.126.255
	{ 0x67fd8000, 0x67fdafff, REGISTRY_APNIC      }, // 103.253.128.0   - 103.253.175.255
	{ 0x67fdb400, 0x67fde3ff, REGISTRY_APNIC      }, // 103.253.180.0   - 103.253.227.255
	{ 0x67fde800, 0x67fdf3ff, REGISTRY_APNIC      }, // 103.253.232.0   - 103.253.243.255
	{ 0x67fdf800, 0x67fe5aff, REGISTRY_APNIC      }, // 103.253.248.0   - 103.254.90.255
	{ 0x67fe5c00, 0x67fe7bff, REGISTRY_APNIC      }, // 103.254.92.0    - 103.254.123.255
	{ 0x67fe7e00, 0x67fec4ff, REGISTRY_APNIC      }, // 103.254.126.0   - 103.254.196.255
	{ 0x67fec600, 0x67fed3ff, REGISTRY_APNIC      }, // 103.254.198.0   - 103.254.211.255
	{ 0x67fed800, 0x67ff1bff, REGISTRY_APNIC      }, // 103.254.216.0   - 103.255.27.255
	{ 0x67ff1d00, 0x67ff27ff, REGISTRY_APNIC      }, // 103.255.29.0    - 103.255.39.255
	{ 0x67ff2c00, 0x67ff3fff, REGISTRY_APNIC      }, // 103.255.44.0    - 103.255.63.255
	{ 0x67ff4400, 0x67ff5fff, REGISTRY_APNIC      }, // 103.255.68.0    - 103.255.95.255
	{ 0x67ff6400, 0x67ff6bff, REGISTRY_APNIC      }, // 103.255.100.0   - 103.255.107.255
	{ 0x67ff7000, 0x67ff83ff, REGISTRY_APNIC      }, // 103.255.112.0   - 103.255.131.255
	{ 0x67ff8800, 0x67ff9fff, REGISTRY_APNIC      }, // 103.255.136.0   - 103.255.159.255
	{ 0x67ffa800, 0x67ffbfff, REGISTRY_APNIC      }, // 103.255.168.0   - 103.255.191.255
	{ 0x67ffc800, 0x67ffcbff, REGISTRY_APNIC      }, // 103.255.200.0   - 103.255.203.255
	{ 0x67ffd400, 0x67ffdbff, REGISTRY_APNIC      }, // 103.255.212.0   - 103.255.219.255
	{ 0x67ffe000, 0x67ffffff, REGISTRY_APNIC      }, // 103.255.224.0   - 103.255.255.255
	{ 0x68000000, 0x68251fff, REGISTRY_ARIN       }, // 104.0.0.0       - 104.37.31.255
	{ 0x68252000, 0x682527ff, REGISTRY_RIPENCC    }, // 104.37.32.0     - 104.37.39.255
	{ 0x68252800, 0x689953ff, REGISTRY_ARIN       }, // 104.37.40.0     - 104.153.83.255
	{ 0x68995400, 0x689957ff, REGISTRY_RIPENCC    }, // 104.153.84.0    - 104.153.87.255
	{ 0x68995800, 0x68a17fff, REGISTRY_ARIN       }, // 104.153.88.0    - 104.161.127.255
	{ 0x68a18000, 0x68a1ffff, REGISTRY_APNIC      }, // 104.161.128.0   - 104.161.255.255
	{ 0x68a20000, 0x68c86fff, REGISTRY_ARIN       }, // 104.162.0.0     - 104.200.111.255
	{ 0x68c87000, 0x68c87fff, REGISTRY_APNIC      }, // 104.200.112.0   - 104.200.127.255
	{ 0x68c88000, 0x68e823ff, REGISTRY_ARIN       }, // 104.200.128.0   - 104.232.35.255
	{ 0x68e82400, 0x68e825ff, REGISTRY_RIPENCC    }, // 104.232.36.0    - 104.232.37.255
	{ 0x68e82600, 0x68e93fff, REGISTRY_ARIN       }, // 104.232.38.0    - 104.233.63.255
	{ 0x68e94000, 0x68e97fff, REGISTRY_RIPENCC    }, // 104.233.64.0    - 104.233.127.255
	{ 0x68e98000, 0x68f3d7ff, REGISTRY_ARIN       }, // 104.233.128.0   - 104.243.215.255
	{ 0x68f3d800, 0x68f3dbff, REGISTRY_RIPENCC    }, // 104.243.216.0   - 104.243.219.255
	{ 0x68f3dc00, 0x68f407ff, REGISTRY_ARIN       }, // 104.243.220.0   - 104.244.7.255
	{ 0x68f40800, 0x68f40bff, REGISTRY_RIPENCC    }, // 104.244.8.0     - 104.244.11.255
	{ 0x68f40c00, 0x68fa1fff, REGISTRY_ARIN       }, // 104.244.12.0    - 104.250.31.255
	{ 0x68fa2000, 0x68fa3fff, REGISTRY_APNIC      }, // 104.250.32.0    - 104.250.63.255
	{ 0x68fa4000, 0x68fb8fff, REGISTRY_ARIN       }, // 104.250.64.0    - 104.251.143.255
	{ 0x68fb9000, 0x68fb9fff, REGISTRY_APNIC      }, // 104.251.144.0   - 104.251.159.255
	{ 0x68fba000, 0x68ffffff, REGISTRY_ARIN       }, // 104.251.160.0   - 104.255.255.255
	{ 0x69000000, 0x69b27fff, REGISTRY_AFRINIC    }, // 105.0.0.0       - 105.178.127.255
	{ 0x69b30000, 0x69b31fff, REGISTRY_AFRINIC    }, // 105.179.0.0     - 105.179.31.255
	{ 0x69b40000, 0x69ffffff, REGISTRY_AFRINIC    }, // 105.180.0.0     - 105.255.255.255
	{ 0x6a000000, 0x6affffff, REGISTRY_APNIC      }, // 106.0.0.0       - 106.255.255.255
	{ 0x6b000000, 0x6b96a1ff, REGISTRY_ARIN       }, // 107.0.0.0       - 107.150.161.255
	{ 0x6b96a200, 0x6b96b3ff, REGISTRY_RIPENCC    }, // 107.150.162.0   - 107.150.179.255
	{ 0x6b96b400, 0x6b98ffff, REGISTRY_ARIN       }, // 107.150.180.0   - 107.152.255.255
	{ 0x6b990000, 0x6b99ffff, REGISTRY_APNIC      }, // 107.153.0.0     - 107.153.255.255
	{ 0x6b9a0000, 0x6ba19fff, REGISTRY_ARIN       }, // 107.154.0.0     - 107.161.159.255
	{ 0x6ba1a000, 0x6ba1afff, REGISTRY_RIPENCC    }, // 107.161.160.0   - 107.161.175.255
	{ 0x6ba1b000, 0x6bb57fff, REGISTRY_ARIN       }, // 107.161.176.0   - 107.181.127.255
	{ 0x6bb58000, 0x6bb59fff, REGISTRY_RIPENCC    }, // 107.181.128.0   - 107.181.159.255
	{ 0x6bb5a000, 0x6bbf43ff, REGISTRY_ARIN       }, // 107.181.160.0   - 107.191.67.255
	{ 0x6bbf4400, 0x6bbf44ff, REGISTRY_RIPENCC    }, // 107.191.68.0    - 107.191.68.255
	{ 0x6bbf4500, 0x6cffffff, REGISTRY_ARIN       }, // 107.191.69.0    - 108.255.255.255
	{ 0x6d000000, 0x6d4797ff, REGISTRY_RIPENCC    }, // 109.0.0.0       - 109.71.151.255
	{ 0x6d479c00, 0x6d47fbff, REGISTRY_RIPENCC    }, // 109.71.156.0    - 109.71.251.255
	{ 0x6d480000, 0x6d5dffff, REGISTRY_RIPENCC    }, // 109.72.0.0      - 109.93.255.255
	{ 0x6d5e0000, 0x6d5e9fff, REGISTRY_RIPENCC    }, // 109.94.0.0      - 109.94.159.255
	{ 0x6d5ea000, 0x6d5eafff, REGISTRY_RIPENCC    }, // 109.94.160.0    - 109.94.175.255
	{ 0x6d5eb000, 0x6d5ecfff, REGISTRY_RIPENCC    }, // 109.94.176.0    - 109.94.207.255
	{ 0x6d5ed000, 0x6d5edfff, REGISTRY_RIPENCC    }, // 109.94.208.0    - 109.94.223.255
	{ 0x6d5ee000, 0x6d5f77ff, REGISTRY_RIPENCC    }, // 109.94.224.0    - 109.95.119.255
	{ 0x6d5f7800, 0x6d5f7fff, REGISTRY_RIPENCC    }, // 109.95.120.0    - 109.95.127.255
	{ 0x6d5f8000, 0x6d5f9fff, REGISTRY_RIPENCC    }, // 109.95.128.0    - 109.95.159.255
	{ 0x6d5fa000, 0x6d5fa7ff, REGISTRY_RIPENCC    }, // 109.95.160.0    - 109.95.167.255
	{ 0x6d5fa800, 0x6d5fffff, REGISTRY_RIPENCC    }, // 109.95.168.0    - 109.95.255.255
	{ 0x6d600000, 0x6dc3ffff, REGISTRY_RIPENCC    }, // 109.96.0.0      - 109.195.255.255
	{ 0x6dc40000, 0x6dc41fff, REGISTRY_RIPENCC    }, // 109.196.0.0     - 109.196.31.255
	{ 0x6dc42000, 0x6dc42fff, REGISTRY_RIPENCC    }, // 109.196.32.0    - 109.196.47.255
	{ 0x6dc43000, 0x6dc47fff, REGISTRY_RIPENCC    }, // 109.196.48.0    - 109.196.127.255
	{ 0x6dc48000, 0x6dc48fff, REGISTRY_RIPENCC    }, // 109.196.128.0   - 109.196.143.255
	{ 0x6dc49000, 0x6dc49fff, REGISTRY_RIPENCC    }, // 109.196.144.0   - 109.196.159.255
	{ 0x6dc4a000, 0x6dc4afff, REGISTRY_RIPENCC    }, // 109.196.160.0   - 109.196.175.255
	{ 0x6dc4b000, 0x6dc5cfff, REGISTRY_RIPENCC    }, // 109.196.176.0   - 109.197.207.255
	{ 0x6dc5d000, 0x6dc5d7ff, REGISTRY_RIPENCC    }, // 109.197.208.0   - 109.197.215.255
	{ 0x6dc5d800, 0x6dc5e7ff, REGISTRY_RIPENCC    }, // 109.197.216.0   - 109.197.231.255
	{ 0x6dc5e800, 0x6dc5efff, REGISTRY_RIPENCC    }, // 109.197.232.0   - 109.197.239.255
	{ 0x6dc5f000, 0x6dc5ffff, REGISTRY_RIPENCC    }, // 109.197.240.0   - 109.197.255.255
	{ 0x6dc60000, 0x6dce1fff, REGISTRY_RIPENCC    }, // 109.198.0.0     - 109.206.31.255
	{ 0x6dce2000, 0x6dce3fff, REGISTRY_RIPENCC    }, // 109.206.32.0    - 109.206.63.255
	{ 0x6dce4000, 0x6dce5fff, REGISTRY_RIPENCC    }, // 109.206.64.0    - 109.206.95.255
	{ 0x6dce6000, 0x6dcedfff, REGISTRY_RIPENCC    }, // 109.206.96.0    - 109.206.223.255
	{ 0x6dcee000, 0x6dceffff, REGISTRY_RIPENCC    }, // 109.206.224.0   - 109.206.255.255
	{ 0x6dcf0000, 0x6dcf2fff, REGISTRY_RIPENCC    }, // 109.207.0.0     - 109.207.47.255
	{ 0x6dcf3000, 0x6dcf4fff, REGISTRY_RIPENCC    }, // 109.207.48.0    - 109.207.79.255
	{ 0x6dcf5000, 0x6dcf7fff, REGISTRY_RIPENCC    }, // 109.207.80.0    - 109.207.127.255
	{ 0x6dcf8000, 0x6dcf8fff, REGISTRY_RIPENCC    }, // 109.207.128.0   - 109.207.143.255
	{ 0x6dcf9000, 0x6dcfcfff, REGISTRY_RIPENCC    }, // 109.207.144.0   - 109.207.207.255
	{ 0x6dcfd000, 0x6dcfdfff, REGISTRY_RIPENCC    }, // 109.207.208.0   - 109.207.223.255
	{ 0x6dcfe000, 0x6dcfffff, REGISTRY_RIPENCC    }, // 109.207.224.0   - 109.207.255.255
	{ 0x6dd00000, 0x6de4ffff, REGISTRY_RIPENCC    }, // 109.208.0.0     - 109.228.255.255
	{ 0x6de50000, 0x6de5ffff, REGISTRY_RIPENCC    }, // 109.229.0.0     - 109.229.255.255
	{ 0x6de60000, 0x6debffff, REGISTRY_RIPENCC    }, // 109.230.0.0     - 109.235.255.255
	{ 0x6dec0000, 0x6dec0fff, REGISTRY_APNIC      }, // 109.236.0.0     - 109.236.15.255
	{ 0x6dec1000, 0x6df3ffff, REGISTRY_RIPENCC    }, // 109.236.16.0    - 109.243.255.255
	{ 0x6df40000, 0x6df4ffff, REGISTRY_APNIC      }, // 109.244.0.0     - 109.244.255.255
	{ 0x6df50000, 0x6dffffff, REGISTRY_RIPENCC    }, // 109.245.0.0     - 109.255.255.255
	{ 0x6e000000, 0x71bfffff, REGISTRY_APNIC      }, // 110.0.0.0       - 113.191.255.255
	{ 0x71c04000, 0x71caffff, REGISTRY_APNIC      }, // 113.192.64.0    - 113.202.255.255
	{ 0x71cb0000, 0x71cbbfff, REGISTRY_RIPENCC    }, // 113.203.0.0     - 113.203.191.255
	{ 0x71cbc000, 0x71d43fff, REGISTRY_APNIC      }, // 113.203.192.0   - 113.212.63.255
	{ 0x71d46000, 0x7354a7ff, REGISTRY_APNIC      }, // 113.212.96.0    - 115.84.167.255
	{ 0x7354b000, 0x73bb0fff, REGISTRY_APNIC      }, // 115.84.176.0    - 115.187.15.255
	{ 0x73bb2000, 0x74c7c7ff, REGISTRY_APNIC      }, // 115.187.32.0    - 116.199.199.255
	{ 0x74c7d000, 0x74c9ffff, REGISTRY_APNIC      }, // 116.199.208.0   - 116.201.255.255
	{ 0x74ca0000, 0x74cbffff, REGISTRY_RIPENCC    }, // 116.202.0.0     - 116.203.255.255
	{ 0x74cc0000, 0x7bfcffff, REGISTRY_APNIC      }, // 116.204.0.0     - 123.252.255.255
	{ 0x7bfe0000, 0x7d3e47ff, REGISTRY_APNIC      }, // 123.254.0.0     - 125.62.71.255
	{ 0x7d3e4800, 0x7d3e4bff, REGISTRY_RIPENCC    }, // 125.62.72.0     - 125.62.75.255
	{ 0x7d3e4c00, 0x7effffff, REGISTRY_APNIC      }, // 125.62.76.0     - 126.255.255.255
	{ 0x80000000, 0x800067ff, REGISTRY_RIPENCC    }, // 128.0.0.0       - 128.0.103.255
	{ 0x80006800, 0x80006fff, REGISTRY_RIPENCC    }, // 128.0.104.0     - 128.0.111.255
	{ 0x80007000, 0x80007fff, REGISTRY_RIPENCC    }, // 128.0.112.0     - 128.0.127.255
	{ 0x80008000, 0x80008fff, REGISTRY_RIPENCC    }, // 128.0.128.0     - 128.0.143.255
	{ 0x80009000, 0x8000ffff, REGISTRY_RIPENCC    }, // 128.0.144.0     - 128.0.255.255
	{ 0x80010000, 0x8006ffff, REGISTRY_ARIN       }, // 128.1.0.0       - 128.6.255.255
	{ 0x80070000, 0x8007ffff, REGISTRY_RIPENCC    }, // 128.7.0.0       - 128.7.255.255
	{ 0x80080000, 0x800fffff, REGISTRY_ARIN       }, // 128.8.0.0       - 128.15.255.255
	{ 0x80100000, 0x8010ffff, REGISTRY_RIPENCC    }, // 128.16.0.0      - 128.16.255.255
	{ 0x80110000, 0x8015ffff, REGISTRY_ARIN       }, // 128.17.0.0      - 128.21.255.255
	{ 0x80160000, 0x8016ffff, REGISTRY_APNIC      }, // 128.22.0.0      - 128.22.255.255
	{ 0x80170000, 0x801affff, REGISTRY_ARIN       }, // 128.23.0.0      - 128.26.255.255
	{ 0x801b0000, 0x801cffff, REGISTRY_APNIC      }, // 128.27.0.0      - 128.28.255.255
	{ 0x801d0000, 0x8026ffff, REGISTRY_ARIN       }, // 128.29.0.0      - 128.38.255.255
	{ 0x80270000, 0x8029ffff, REGISTRY_RIPENCC    }, // 128.39.0.0      - 128.41.255.255
	{ 0x802a0000, 0x802cffff, REGISTRY_ARIN       }, // 128.42.0.0      - 128.44.255.255
	{ 0x802d0000, 0x802dffff, REGISTRY_RIPENCC    }, // 128.45.0.0      - 128.45.255.255
	{ 0x802e0000, 0x8034ffff, REGISTRY_ARIN       }, // 128.46.0.0      - 128.52.255.255
	{ 0x80350000, 0x8035ffff, REGISTRY_APNIC      }, // 128.53.0.0      - 128.53.255.255
	{ 0x80360000, 0x8040ffff, REGISTRY_ARIN       }, // 128.54.0.0      - 128.64.255.255
	{ 0x80410000, 0x804fffff, REGISTRY_RIPENCC    }, // 128.65.0.0      - 128.79.255.255
	{ 0x80500000, 0x8055ffff, REGISTRY_ARIN       }, // 128.80.0.0      - 128.85.255.255
	{ 0x80560000, 0x8057ffff, REGISTRY_RIPENCC    }, // 128.86.0.0      - 128.87.255.255
	{ 0x80580000, 0x805cffff, REGISTRY_ARIN       }, // 128.88.0.0      - 128.92.255.255
	{ 0x805d0000, 0x805dffff, REGISTRY_RIPENCC    }, // 128.93.0.0      - 128.93.255.255
	{ 0x805e0000, 0x805effff, REGISTRY_APNIC      }, // 128.94.0.0      - 128.94.255.255
	{ 0x805f0000, 0x8061ffff, REGISTRY_ARIN       }, // 128.95.0.0      - 128.97.255.255
	{ 0x80620000, 0x8062ffff, REGISTRY_RIPENCC    }, // 128.98.0.0      - 128.98.255.255
	{ 0x80630000, 0x8069ffff, REGISTRY_ARIN       }, // 128.99.0.0      - 128.105.255.255
	{ 0x806a0000, 0x806affff, REGISTRY_APNIC      }, // 128.106.0.0     - 128.106.255.255
	{ 0x806b0000, 0x806bffff, REGISTRY_ARIN       }, // 128.107.0.0     - 128.107.255.255
	{ 0x806c0000, 0x806cffff, REGISTRY_APNIC      }, // 128.108.0.0     - 128.108.255.255
	{ 0x806d0000, 0x80747fff, REGISTRY_ARIN       }, // 128.109.0.0     - 128.116.127.255
	{ 0x80748000, 0x8074ffff, REGISTRY_RIPENCC    }, // 128.116.128.0   - 128.116.255.255
	{ 0x80750000, 0x807bffff, REGISTRY_ARIN       }, // 128.117.0.0     - 128.123.255.255
	{ 0x807c0000, 0x807cffff, REGISTRY_RIPENCC    }, // 128.124.0.0     - 128.124.255.255
	{ 0x807d0000, 0x807effff, REGISTRY_ARIN       }, // 128.125.0.0     - 128.126.255.255
	{ 0x807f0000, 0x807fffff, REGISTRY_RIPENCC    }, // 128.127.0.0     - 128.127.255.255
	{ 0x80800000, 0x8081ffff, REGISTRY_ARIN       }, // 128.128.0.0     - 128.129.255.255
	{ 0x80820000, 0x8083ffff, REGISTRY_RIPENCC    }, // 128.130.0.0     - 128.131.255.255
	{ 0x80840000, 0x8085ffff, REGISTRY_ARIN       }, // 128.132.0.0     - 128.133.255.255
	{ 0x80860000, 0x8086ffff, REGISTRY_APNIC      }, // 128.134.0.0     - 128.134.255.255
	{ 0x80870000, 0x808affff, REGISTRY_ARIN       }, // 128.135.0.0     - 128.138.255.255
	{ 0x808b0000, 0x808bffff, REGISTRY_RIPENCC    }, // 128.139.0.0     - 128.139.255.255
	{ 0x808c0000, 0x808cffff, REGISTRY_RIPENCC    }, // 128.140.0.0     - 128.140.255.255
	{ 0x808d0000, 0x808effff, REGISTRY_RIPENCC    }, // 128.141.0.0     - 128.142.255.255
	{ 0x808f0000, 0x80a7ffff, REGISTRY_ARIN       }, // 128.143.0.0     - 128.167.255.255
	{ 0x80a80000, 0x80a8ffff, REGISTRY_RIPENCC    }, // 128.168.0.0     - 128.168.255.255
	{ 0x80a90000, 0x80afffff, REGISTRY_ARIN       }, // 128.169.0.0     - 128.175.255.255
	{ 0x80b00000, 0x80b0ffff, REGISTRY_RIPENCC    }, // 128.176.0.0     - 128.176.255.255
	{ 0x80b10000, 0x80b1ffff, REGISTRY_ARIN       }, // 128.177.0.0     - 128.177.255.255
	{ 0x80b20000, 0x80b3ffff, REGISTRY_RIPENCC    }, // 128.178.0.0     - 128.179.255.255
	{ 0x80b40000, 0x80b7ffff, REGISTRY_ARIN       }, // 128.180.0.0     - 128.183.255.255
	{ 0x80b80000, 0x80b9ffff, REGISTRY_APNIC      }, // 128.184.0.0     - 128.185.255.255
	{ 0x80ba0000, 0x80c6ffff, REGISTRY_ARIN       }, // 128.186.0.0     - 128.198.255.255
	{ 0x80c70000, 0x80c7ffff, REGISTRY_RIPENCC    }, // 128.199.0.0     - 128.199.255.255
	{ 0x80c80000, 0x80c8ffff, REGISTRY_ARIN       }, // 128.200.0.0     - 128.200.255.255
	{ 0x80c90000, 0x80c9ffff, REGISTRY_LACNIC     }, // 128.201.0.0     - 128.201.255.255
	{ 0x80ca0000, 0x80cbffff, REGISTRY_ARIN       }, // 128.202.0.0     - 128.203.255.255
	{ 0x80cc0000, 0x80ccffff, REGISTRY_RIPENCC    }, // 128.204.0.0     - 128.204.255.255
	{ 0x80cd0000, 0x80d5ffff, REGISTRY_ARIN       }, // 128.205.0.0     - 128.213.255.255
	{ 0x80d60000, 0x80d6ffff, REGISTRY_RIPENCC    }, // 128.214.0.0     - 128.214.255.255
	{ 0x80d70000, 0x80e7ffff, REGISTRY_ARIN       }, // 128.215.0.0     - 128.231.255.255
	{ 0x80e80000, 0x80e8ffff, REGISTRY_RIPENCC    }, // 128.232.0.0     - 128.232.255.255
	{ 0x80e90000, 0x80e9ffff, REGISTRY_ARIN       }, // 128.233.0.0     - 128.233.255.255
	{ 0x80ea0000, 0x80eaffff, REGISTRY_RIPENCC    }, // 128.234.0.0     - 128.234.255.255
	{ 0x80eb0000, 0x80efffff, REGISTRY_ARIN       }, // 128.235.0.0     - 128.239.255.255
	{ 0x80f00000, 0x80f0ffff, REGISTRY_RIPENCC    }, // 128.240.0.0     - 128.240.255.255
	{ 0x80f10000, 0x80f2ffff, REGISTRY_ARIN       }, // 128.241.0.0     - 128.242.255.255
	{ 0x80f30000, 0x80f3ffff, REGISTRY_RIPENCC    }, // 128.243.0.0     - 128.243.255.255
	{ 0x80f40000, 0x80f5ffff, REGISTRY_ARIN       }, // 128.244.0.0     - 128.245.255.255
	{ 0x80f60000, 0x80f6ffff, REGISTRY_RIPENCC    }, // 128.246.0.0     - 128.246.255.255
	{ 0x80f70000, 0x80f9ffff, REGISTRY_ARIN       }, // 128.247.0.0     - 128.249.255.255
	{ 0x80fa0000, 0x80faffff, REGISTRY_APNIC      }, // 128.250.0.0     - 128.250.255.255
	{ 0x80fb0000, 0x80ffffff, REGISTRY_ARIN       }, // 128.251.0.0     - 128.255.255.255
	{ 0x81000000, 0x8100ffff, REGISTRY_AFRINIC    }, // 129.0.0.0       - 129.0.255.255
	{ 0x81010000, 0x810affff, REGISTRY_ARIN       }, // 129.1.0.0       - 129.10.255.255
	{ 0x810b0000, 0x810dffff, REGISTRY_RIPENCC    }, // 129.11.0.0      - 129.13.255.255
	{ 0x810e0000, 0x810fffff, REGISTRY_ARIN       }, // 129.14.0.0      - 129.15.255.255
	{ 0x81100000, 0x8110ffff, REGISTRY_RIPENCC    }, // 129.16.0.0      - 129.16.255.255
	{ 0x81110000, 0x8111ffff, REGISTRY_ARIN       }, // 129.17.0.0      - 129.17.255.255
	{ 0x81120000, 0x8112ffff, REGISTRY_AFRINIC    }, // 129.18.0.0      - 129.18.255.255
	{ 0x81130000, 0x8113ffff, REGISTRY_ARIN       }, // 129.19.0.0      - 129.19.255.255
	{ 0x81140000, 0x8114ffff, REGISTRY_RIPENCC    }, // 129.20.0.0      - 129.20.255.255
	{ 0x81150000, 0x8119ffff, REGISTRY_ARIN       }, // 129.21.0.0      - 129.25.255.255
	{ 0x811a0000, 0x811bffff, REGISTRY_RIPENCC    }, // 129.26.0.0      - 129.27.255.255
	{ 0x811c0000, 0x811cffff, REGISTRY_APNIC      }, // 129.28.0.0      - 129.28.255.255
	{ 0x811d0000, 0x811effff, REGISTRY_ARIN       }, // 129.29.0.0      - 129.30.255.255
	{ 0x811f0000, 0x811fffff, REGISTRY_RIPENCC    }, // 129.31.0.0      - 129.31.255.255
	{ 0x81200000, 0x812cffff, REGISTRY_ARIN       }, // 129.32.0.0      - 129.44.255.255
	{ 0x812d0000, 0x812dffff, REGISTRY_AFRINIC    }, // 129.45.0.0      - 129.45.255.255
	{ 0x812e0000, 0x8137ffff, REGISTRY_ARIN       }, // 129.46.0.0      - 129.55.255.255
	{ 0x81380000, 0x8138ffff, REGISTRY_AFRINIC    }, // 129.56.0.0      - 129.56.255.255
	{ 0x81390000, 0x813bffff, REGISTRY_ARIN       }, // 129.57.0.0      - 129.59.255.255
	{ 0x813c0000, 0x813cffff, REGISTRY_APNIC      }, // 129.60.0.0      - 129.60.255.255
	{ 0x813d0000, 0x8142ffff, REGISTRY_ARIN       }, // 129.61.0.0      - 129.66.255.255
	{ 0x81430000, 0x8143ffff, REGISTRY_RIPENCC    }, // 129.67.0.0      - 129.67.255.255
	{ 0x81440000, 0x8144ffff, REGISTRY_ARIN       }, // 129.68.0.0      - 129.68.255.255
	{ 0x81450000, 0x8146ffff, REGISTRY_RIPENCC    }, // 129.69.0.0      - 129.70.255.255
	{ 0x81470000, 0x8148ffff, REGISTRY_ARIN       }, // 129.71.0.0      - 129.72.255.255
	{ 0x81490000, 0x8149ffff, REGISTRY_RIPENCC    }, // 129.73.0.0      - 129.73.255.255
	{ 0x814a0000, 0x814dffff, REGISTRY_ARIN       }, // 129.74.0.0      - 129.77.255.255
	{ 0x814e0000, 0x814effff, REGISTRY_APNIC      }, // 129.78.0.0      - 129.78.255.255
	{ 0x814f0000, 0x8157ffff, REGISTRY_ARIN       }, // 129.79.0.0      - 129.87.255.255
	{ 0x81580000, 0x8158ffff, REGISTRY_RIPENCC    }, // 129.88.0.0      - 129.88.255.255
	{ 0x81590000, 0x8159ffff, REGISTRY_ARIN       }, // 129.89.0.0      - 129.89.255.255
	{ 0x815a0000, 0x815affff, REGISTRY_LACNIC     }, // 129.90.0.0      - 129.90.255.255
	{ 0x815b0000, 0x815dffff, REGISTRY_ARIN       }, // 129.91.0.0      - 129.93.255.255
	{ 0x815e0000, 0x815effff, REGISTRY_APNIC      }, // 129.94.0.0      - 129.94.255.255
	{ 0x815f0000, 0x815fffff, REGISTRY_ARIN       }, // 129.95.0.0      - 129.95.255.255
	{ 0x81600000, 0x8160ffff, REGISTRY_APNIC      }, // 129.96.0.0      - 129.96.255.255
	{ 0x81610000, 0x8165ffff, REGISTRY_ARIN       }, // 129.97.0.0      - 129.101.255.255
	{ 0x81660000, 0x8166ffff, REGISTRY_RIPENCC    }, // 129.102.0.0     - 129.102.255.255
	{ 0x81670000, 0x8167ffff, REGISTRY_RIPENCC    }, // 129.103.0.0     - 129.103.255.255
	{ 0x81680000, 0x8168ffff, REGISTRY_RIPENCC    }, // 129.104.0.0     - 129.104.255.255
	{ 0x81690000, 0x8179ffff, REGISTRY_ARIN       }, // 129.105.0.0     - 129.121.255.255
	{ 0x817a0000, 0x817affff, REGISTRY_AFRINIC    }, // 129.122.0.0     - 129.122.255.255
	{ 0x817b0000, 0x817cffff, REGISTRY_ARIN       }, // 129.123.0.0     - 129.124.255.255
	{ 0x817d0000, 0x817dffff, REGISTRY_RIPENCC    }, // 129.125.0.0     - 129.125.255.255
	{ 0x817e0000, 0x817fffff, REGISTRY_APNIC      }, // 129.126.0.0     - 129.127.255.255
	{ 0x81800000, 0x8180ffff, REGISTRY_ARIN       }, // 129.128.0.0     - 129.128.255.255
	{ 0x81810000, 0x8181ffff, REGISTRY_RIPENCC    }, // 129.129.0.0     - 129.129.255.255
	{ 0x81820000, 0x8183ffff, REGISTRY_ARIN       }, // 129.130.0.0     - 129.131.255.255
	{ 0x81840000, 0x8184ffff, REGISTRY_RIPENCC    }, // 129.132.0.0     - 129.132.255.255
	{ 0x81850000, 0x8187ffff, REGISTRY_ARIN       }, // 129.133.0.0     - 129.135.255.255
	{ 0x81880000, 0x8188ffff, REGISTRY_APNIC      }, // 129.136.0.0     - 129.136.255.255
	{ 0x81890000, 0x818bffff, REGISTRY_ARIN       }, // 129.137.0.0     - 129.139.255.255
	{ 0x818c0000, 0x818cffff, REGISTRY_AFRINIC    }, // 129.140.0.0     - 129.140.255.255
	{ 0x818d0000, 0x818dffff, REGISTRY_ARIN       }, // 129.141.0.0     - 129.141.255.255
	{ 0x818e0000, 0x818fffff, REGISTRY_RIPENCC    }, // 129.142.0.0     - 129.143.255.255
	{ 0x81900000, 0x81a8ffff, REGISTRY_ARIN       }, // 129.144.0.0     - 129.168.255.255
	{ 0x81a90000, 0x81a9ffff, REGISTRY_RIPENCC    }, // 129.169.0.0     - 129.169.255.255
	{ 0x81aa0000, 0x81aeffff, REGISTRY_ARIN       }, // 129.170.0.0     - 129.174.255.255
	{ 0x81af0000, 0x81afffff, REGISTRY_RIPENCC    }, // 129.175.0.0     - 129.175.255.255
	{ 0x81b00000, 0x81b0ffff, REGISTRY_ARIN       }, // 129.176.0.0     - 129.176.255.255
	{ 0x81b10000, 0x81b2ffff, REGISTRY_RIPENCC    }, // 129.177.0.0     - 129.178.255.255
	{ 0x81b30000, 0x81b3ffff, REGISTRY_ARIN       }, // 129.179.0.0     - 129.179.255.255
	{ 0x81b40000, 0x81b4ffff, REGISTRY_APNIC      }, // 129.180.0.0     - 129.180.255.255
	{ 0x81b50000, 0x81b9ffff, REGISTRY_RIPENCC    }, // 129.181.0.0     - 129.185.255.255
	{ 0x81ba0000, 0x81baffff, REGISTRY_ARIN       }, // 129.186.0.0     - 129.186.255.255
	{ 0x81bb0000, 0x81bbffff, REGISTRY_RIPENCC    }, // 129.187.0.0     - 129.187.255.255
	{ 0x81bc0000, 0x81c1ffff, REGISTRY_ARIN       }, // 129.188.0.0     - 129.193.255.255
	{ 0x81c20000, 0x81c3ffff, REGISTRY_RIPENCC    }, // 129.194.0.0     - 129.195.255.255
	{ 0x81c40000, 0x81c6ffff, REGISTRY_ARIN       }, // 129.196.0.0     - 129.198.255.255
	{ 0x81c70000, 0x81c7ffff, REGISTRY_RIPENCC    }, // 129.199.0.0     - 129.199.255.255
	{ 0x81c80000, 0x81cbffff, REGISTRY_ARIN       }, // 129.200.0.0     - 129.203.255.255
	{ 0x81cc0000, 0x81ccffff, REGISTRY_APNIC      }, // 129.204.0.0     - 129.204.255.255
	{ 0x81cd0000, 0x81cdffff, REGISTRY_AFRINIC    }, // 129.205.0.0     - 129.205.255.255
	{ 0x81ce0000, 0x81ceffff, REGISTRY_RIPENCC    }, // 129.206.0.0     - 129.206.255.255
	{ 0x81cf0000, 0x81cfffff, REGISTRY_ARIN       }, // 129.207.0.0     - 129.207.255.255
	{ 0x81d00000, 0x81d0ffff, REGISTRY_RIPENCC    }, // 129.208.0.0     - 129.208.255.255
	{ 0x81d10000, 0x81d2ffff, REGISTRY_ARIN       }, // 129.209.0.0     - 129.210.255.255
	{ 0x81d30000, 0x81d3ffff, REGISTRY_APNIC      }, // 129.211.0.0     - 129.211.255.255
	{ 0x81d40000, 0x81d5ffff, REGISTRY_ARIN       }, // 129.212.0.0     - 129.213.255.255
	{ 0x81d60000, 0x81d6ffff, REGISTRY_RIPENCC    }, // 129.214.0.0     - 129.214.255.255
	{ 0x81d70000, 0x81d7ffff, REGISTRY_RIPENCC    }, // 129.215.0.0     - 129.215.255.255
	{ 0x81d80000, 0x81d8ffff, REGISTRY_ARIN       }, // 129.216.0.0     - 129.216.255.255
	{ 0x81d90000, 0x81d9ffff, REGISTRY_RIPENCC    }, // 129.217.0.0     - 129.217.255.255
	{ 0x81da0000, 0x81e1ffff, REGISTRY_ARIN       }, // 129.218.0.0     - 129.225.255.255
	{ 0x81e20000, 0x81e2ffff, REGISTRY_APNIC      }, // 129.226.0.0     - 129.226.255.255
	{ 0x81e30000, 0x81e7ffff, REGISTRY_ARIN       }, // 129.227.0.0     - 129.231.255.255
	{ 0x81e80000, 0x81e8ffff, REGISTRY_AFRINIC    }, // 129.232.0.0     - 129.232.255.255
	{ 0x81e90000, 0x81eaffff, REGISTRY_RIPENCC    }, // 129.233.0.0     - 129.234.255.255
	{ 0x81eb0000, 0x81efffff, REGISTRY_ARIN       }, // 129.235.0.0     - 129.239.255.255
	{ 0x81f00000, 0x81f2ffff, REGISTRY_RIPENCC    }, // 129.240.0.0     - 129.242.255.255
	{ 0x81f30000, 0x81f6ffff, REGISTRY_ARIN       }, // 129.243.0.0     - 129.246.255.255
	{ 0x81f70000, 0x81f7ffff, REGISTRY_RIPENCC    }, // 129.247.0.0     - 129.247.255.255
	{ 0x81f80000, 0x81f8ffff, REGISTRY_ARIN       }, // 129.248.0.0     - 129.248.255.255
	{ 0x81f90000, 0x81f9ffff, REGISTRY_APNIC      }, // 129.249.0.0     - 129.249.255.255
	{ 0x81fa0000, 0x81fdffff, REGISTRY_ARIN       }, // 129.250.0.0     - 129.253.255.255
	{ 0x81fe0000, 0x81feffff, REGISTRY_APNIC      }, // 129.254.0.0     - 129.254.255.255
	{ 0x81ff0000, 0x81ffffff, REGISTRY_ARIN       }, // 129.255.0.0     - 129.255.255.255
	{ 0x82000000, 0x8200ffff, REGISTRY_RIPENCC    }, // 130.0.0.0       - 130.0.255.255
	{ 0x82010000, 0x8217ffff, REGISTRY_ARIN       }, // 130.1.0.0       - 130.23.255.255
	{ 0x82180000, 0x8218ffff, REGISTRY_RIPENCC    }, // 130.24.0.0      - 130.24.255.255
	{ 0x82190000, 0x8219ffff, REGISTRY_RIPENCC    }, // 130.25.0.0      - 130.25.255.255
	{ 0x821a0000, 0x821affff, REGISTRY_APNIC      }, // 130.26.0.0      - 130.26.255.255
	{ 0x821b0000, 0x821bffff, REGISTRY_ARIN       }, // 130.27.0.0      - 130.27.255.255
	{ 0x821c0000, 0x821cffff, REGISTRY_RIPENCC    }, // 130.28.0.0      - 130.28.255.255
	{ 0x821d0000, 0x821fffff, REGISTRY_ARIN       }, // 130.29.0.0      - 130.31.255.255
	{ 0x82200000, 0x8220ffff, REGISTRY_RIPENCC    }, // 130.32.0.0      - 130.32.255.255
	{ 0x82210000, 0x8221ffff, REGISTRY_ARIN       }, // 130.33.0.0      - 130.33.255.255
	{ 0x82220000, 0x8222ffff, REGISTRY_APNIC      }, // 130.34.0.0      - 130.34.255.255
	{ 0x82230000, 0x8224ffff, REGISTRY_ARIN       }, // 130.35.0.0      - 130.36.255.255
	{ 0x82250000, 0x8225ffff, REGISTRY_RIPENCC    }, // 130.37.0.0      - 130.37.255.255
	{ 0x82260000, 0x822affff, REGISTRY_ARIN       }, // 130.38.0.0      - 130.42.255.255
	{ 0x822b0000, 0x822bffff, REGISTRY_RIPENCC    }, // 130.43.0.0      - 130.43.255.255
	{ 0x822c0000, 0x8235ffff, REGISTRY_ARIN       }, // 130.44.0.0      - 130.53.255.255
	{ 0x82360000, 0x8236ffff, REGISTRY_APNIC      }, // 130.54.0.0      - 130.54.255.255
	{ 0x82370000, 0x8237ffff, REGISTRY_ARIN       }, // 130.55.0.0      - 130.55.255.255
	{ 0x82380000, 0x8238ffff, REGISTRY_APNIC      }, // 130.56.0.0      - 130.56.255.255
	{ 0x82390000, 0x823affff, REGISTRY_ARIN       }, // 130.57.0.0      - 130.58.255.255
	{ 0x823b0000, 0x823cffff, REGISTRY_RIPENCC    }, // 130.59.0.0      - 130.60.255.255
	{ 0x823d0000, 0x8241ffff, REGISTRY_ARIN       }, // 130.61.0.0      - 130.65.255.255
	{ 0x82420000, 0x8243ffff, REGISTRY_RIPENCC    }, // 130.66.0.0      - 130.67.255.255
	{ 0x82440000, 0x8244ffff, REGISTRY_ARIN       }, // 130.68.0.0      - 130.68.255.255
	{ 0x82450000, 0x8245ffff, REGISTRY_APNIC      }, // 130.69.0.0      - 130.69.255.255
	{ 0x82460000, 0x8248ffff, REGISTRY_ARIN       }, // 130.70.0.0      - 130.72.255.255
	{ 0x82490000, 0x8249ffff, REGISTRY_RIPENCC    }, // 130.73.0.0      - 130.73.255.255
	{ 0x824a0000, 0x824affff, REGISTRY_ARIN       }, // 130.74.0.0      - 130.74.255.255
	{ 0x824b0000, 0x824bffff, REGISTRY_RIPENCC    }, // 130.75.0.0      - 130.75.255.255
	{ 0x824c0000, 0x824dffff, REGISTRY_ARIN       }, // 130.76.0.0      - 130.77.255.255
	{ 0x824e0000, 0x824fffff, REGISTRY_RIPENCC    }, // 130.78.0.0      - 130.79.255.255
	{ 0x82500000, 0x8251ffff, REGISTRY_ARIN       }, // 130.80.0.0      - 130.81.255.255
	{ 0x82520000, 0x8254ffff, REGISTRY_RIPENCC    }, // 130.82.0.0      - 130.84.255.255
	{ 0x82550000, 0x8256ffff, REGISTRY_ARIN       }, // 130.85.0.0      - 130.86.255.255
	{ 0x82570000, 0x8257ffff, REGISTRY_APNIC      }, // 130.87.0.0      - 130.87.255.255
	{ 0x82580000, 0x8259ffff, REGISTRY_RIPENCC    }, // 130.88.0.0      - 130.89.255.255
	{ 0x825a0000, 0x825bffff, REGISTRY_ARIN       }, // 130.90.0.0      - 130.91.255.255
	{ 0x825c0000, 0x825cffff, REGISTRY_RIPENCC    }, // 130.92.0.0      - 130.92.255.255
	{ 0x825d0000, 0x825dbfff, REGISTRY_RIPENCC    }, // 130.93.0.0      - 130.93.191.255
	{ 0x825dc000, 0x825dffff, REGISTRY_RIPENCC    }, // 130.93.192.0    - 130.93.255.255
	{ 0x825e0000, 0x825effff, REGISTRY_ARIN       }, // 130.94.0.0      - 130.94.255.255
	{ 0x825f0000, 0x825fffff, REGISTRY_APNIC      }, // 130.95.0.0      - 130.95.255.255
	{ 0x82600000, 0x8261ffff, REGISTRY_ARIN       }, // 130.96.0.0      - 130.97.255.255
	{ 0x82620000, 0x8262ffff, REGISTRY_RIPENCC    }, // 130.98.0.0      - 130.98.255.255
	{ 0x82630000, 0x8263ffff, REGISTRY_ARIN       }, // 130.99.0.0      - 130.99.255.255
	{ 0x82640000, 0x8264ffff, REGISTRY_RIPENCC    }, // 130.100.0.0     - 130.100.255.255
	{ 0x82650000, 0x8265ffff, REGISTRY_ARIN       }, // 130.101.0.0     - 130.101.255.255
	{ 0x82660000, 0x8266ffff, REGISTRY_APNIC      }, // 130.102.0.0     - 130.102.255.255
	{ 0x82670000, 0x8267ffff, REGISTRY_ARIN       }, // 130.103.0.0     - 130.103.255.255
	{ 0x82680000, 0x8268ffff, REGISTRY_RIPENCC    }, // 130.104.0.0     - 130.104.255.255
	{ 0x82690000, 0x8269ffff, REGISTRY_APNIC      }, // 130.105.0.0     - 130.105.255.255
	{ 0x826a0000, 0x826fffff, REGISTRY_ARIN       }, // 130.106.0.0     - 130.111.255.255
	{ 0x82700000, 0x8270ffff, REGISTRY_RIPENCC    }, // 130.112.0.0     - 130.112.255.255
	{ 0x82710000, 0x8272ffff, REGISTRY_ARIN       }, // 130.113.0.0     - 130.114.255.255
	{ 0x82730000, 0x8273ffff, REGISTRY_RIPENCC    }, // 130.115.0.0     - 130.115.255.255
	{ 0x82740000, 0x8274ffff, REGISTRY_APNIC      }, // 130.116.0.0     - 130.116.255.255
	{ 0x82750000, 0x8277ffff, REGISTRY_ARIN       }, // 130.117.0.0     - 130.119.255.255
	{ 0x82780000, 0x8278ffff, REGISTRY_RIPENCC    }, // 130.120.0.0     - 130.120.255.255
	{ 0x82790000, 0x827affff, REGISTRY_ARIN       }, // 130.121.0.0     - 130.122.255.255
	{ 0x827b0000, 0x827bffff, REGISTRY_APNIC      }, // 130.123.0.0     - 130.123.255.255
	{ 0x827c0000, 0x827cffff, REGISTRY_ARIN       }, // 130.124.0.0     - 130.124.255.255
	{ 0x827d0000, 0x827dffff, REGISTRY_RIPENCC    }, // 130.125.0.0     - 130.125.255.255
	{ 0x827e0000, 0x8281ffff, REGISTRY_ARIN       }, // 130.126.0.0     - 130.129.255.255
	{ 0x82820000, 0x8282ffff, REGISTRY_APNIC      }, // 130.130.0.0     - 130.130.255.255
	{ 0x82830000, 0x8284ffff, REGISTRY_ARIN       }, // 130.131.0.0     - 130.132.255.255
	{ 0x82850000, 0x8285ffff, REGISTRY_RIPENCC    }, // 130.133.0.0     - 130.133.255.255
	{ 0x82860000, 0x8287ffff, REGISTRY_ARIN       }, // 130.134.0.0     - 130.135.255.255
	{ 0x82880000, 0x8288ffff, REGISTRY_RIPENCC    }, // 130.136.0.0     - 130.136.255.255
	{ 0x82890000, 0x8289ffff, REGISTRY_ARIN       }, // 130.137.0.0     - 130.137.255.255
	{ 0x828a0000, 0x8295ffff, REGISTRY_RIPENCC    }, // 130.138.0.0     - 130.149.255.255
	{ 0x82960000, 0x8298ffff, REGISTRY_ARIN       }, // 130.150.0.0     - 130.152.255.255
	{ 0x82990000, 0x8299ffff, REGISTRY_APNIC      }, // 130.153.0.0     - 130.153.255.255
	{ 0x829a0000, 0x829affff, REGISTRY_ARIN       }, // 130.154.0.0     - 130.154.255.255
	{ 0x829b0000, 0x829bffff, REGISTRY_APNIC      }, // 130.155.0.0     - 130.155.255.255
	{ 0x829c0000, 0x829dffff, REGISTRY_ARIN       }, // 130.156.0.0     - 130.157.255.255
	{ 0x829e0000, 0x829effff, REGISTRY_APNIC      }, // 130.158.0.0     - 130.158.255.255
	{ 0x829f0000, 0x829fffff, REGISTRY_RIPENCC    }, // 130.159.0.0     - 130.159.255.255
	{ 0x82a00000, 0x82a0ffff, REGISTRY_ARIN       }, // 130.160.0.0     - 130.160.255.255
	{ 0x82a10000, 0x82a1ffff, REGISTRY_RIPENCC    }, // 130.161.0.0     - 130.161.255.255
	{ 0x82a20000, 0x82a47fff, REGISTRY_ARIN       }, // 130.162.0.0     - 130.164.127.255
	{ 0x82a48000, 0x82a4ffff, REGISTRY_RIPENCC    }, // 130.164.128.0   - 130.164.255.255
	{ 0x82a50000, 0x82b3ffff, REGISTRY_ARIN       }, // 130.165.0.0     - 130.179.255.255
	{ 0x82b40000, 0x82b4ffff, REGISTRY_RIPENCC    }, // 130.180.0.0     - 130.180.255.255
	{ 0x82b50000, 0x82b6ffff, REGISTRY_ARIN       }, // 130.181.0.0     - 130.182.255.255
	{ 0x82b70000, 0x82b7ffff, REGISTRY_RIPENCC    }, // 130.183.0.0     - 130.183.255.255
	{ 0x82b80000, 0x82b8ffff, REGISTRY_ARIN       }, // 130.184.0.0     - 130.184.255.255
	{ 0x82b90000, 0x82b9ffff, REGISTRY_RIPENCC    }, // 130.185.0.0     - 130.185.255.255
	{ 0x82ba0000, 0x82baffff, REGISTRY_RIPENCC    }, // 130.186.0.0     - 130.186.255.255
	{ 0x82bb0000, 0x82bbffff, REGISTRY_ARIN       }, // 130.187.0.0     - 130.187.255.255
	{ 0x82bc0000, 0x82bcffff, REGISTRY_RIPENCC    }, // 130.188.0.0     - 130.188.255.255
	{ 0x82bd0000, 0x82bdffff, REGISTRY_ARIN       }, // 130.189.0.0     - 130.189.255.255
	{ 0x82be0000, 0x82beffff, REGISTRY_RIPENCC    }, // 130.190.0.0     - 130.190.255.255
	{ 0x82bf0000, 0x82bfffff, REGISTRY_ARIN       }, // 130.191.0.0     - 130.191.255.255
	{ 0x82c00000, 0x82c0ffff, REGISTRY_RIPENCC    }, // 130.192.0.0     - 130.192.255.255
	{ 0x82c10000, 0x82c1ffff, REGISTRY_RIPENCC    }, // 130.193.0.0     - 130.193.255.255
	{ 0x82c20000, 0x82c3ffff, REGISTRY_APNIC      }, // 130.194.0.0     - 130.195.255.255
	{ 0x82c40000, 0x82c5ffff, REGISTRY_ARIN       }, // 130.196.0.0     - 130.197.255.255
	{ 0x82c60000, 0x82c6ffff, REGISTRY_RIPENCC    }, // 130.198.0.0     - 130.198.255.255
	{ 0x82c70000, 0x82cbffff, REGISTRY_ARIN       }, // 130.199.0.0     - 130.203.255.255
	{ 0x82cc0000, 0x82ccffff, REGISTRY_RIPENCC    }, // 130.204.0.0     - 130.204.255.255
	{ 0x82cd0000, 0x82cdffff, REGISTRY_ARIN       }, // 130.205.0.0     - 130.205.255.255
	{ 0x82ce0000, 0x82ceffff, REGISTRY_RIPENCC    }, // 130.206.0.0     - 130.206.255.255
	{ 0x82cf0000, 0x82cfffff, REGISTRY_ARIN       }, // 130.207.0.0     - 130.207.255.255
	{ 0x82d00000, 0x82d1ffff, REGISTRY_RIPENCC    }, // 130.208.0.0     - 130.209.255.255
	{ 0x82d20000, 0x82d7ffff, REGISTRY_ARIN       }, // 130.210.0.0     - 130.215.255.255
	{ 0x82d80000, 0x82d9ffff, REGISTRY_APNIC      }, // 130.216.0.0     - 130.217.255.255
	{ 0x82da0000, 0x82dbffff, REGISTRY_ARIN       }, // 130.218.0.0     - 130.219.255.255
	{ 0x82dc0000, 0x82dcffff, REGISTRY_APNIC      }, // 130.220.0.0     - 130.220.255.255
	{ 0x82dd0000, 0x82deffff, REGISTRY_ARIN       }, // 130.221.0.0     - 130.222.255.255
	{ 0x82df0000, 0x82dfffff, REGISTRY_RIPENCC    }, // 130.223.0.0     - 130.223.255.255
	{ 0x82e00000, 0x82e0ffff, REGISTRY_ARIN       }, // 130.224.0.0     - 130.224.255.255
	{ 0x82e10000, 0x82e2ffff, REGISTRY_RIPENCC    }, // 130.225.0.0     - 130.226.255.255
	{ 0x82e30000, 0x82f4ffff, REGISTRY_RIPENCC    }, // 130.227.0.0     - 130.244.255.255
	{ 0x82f50000, 0x82f5ffff, REGISTRY_ARIN       }, // 130.245.0.0     - 130.245.255.255
	{ 0x82f60000, 0x82f6ffff, REGISTRY_RIPENCC    }, // 130.246.0.0     - 130.246.255.255
	{ 0x82f70000, 0x82f82fff, REGISTRY_ARIN       }, // 130.247.0.0     - 130.248.47.255
	{ 0x82f83000, 0x82f837ff, REGISTRY_RIPENCC    }, // 130.248.48.0    - 130.248.55.255
	{ 0x82f83800, 0x82f839ff, REGISTRY_ARIN       }, // 130.248.56.0    - 130.248.57.255
	{ 0x82f83a00, 0x82f83fff, REGISTRY_RIPENCC    }, // 130.248.58.0    - 130.248.63.255
	{ 0x82f84000, 0x82f843ff, REGISTRY_ARIN       }, // 130.248.64.0    - 130.248.67.255
	{ 0x82f84400, 0x82f86bff, REGISTRY_RIPENCC    }, // 130.248.68.0    - 130.248.107.255
	{ 0x82f86c00, 0x82f87fff, REGISTRY_APNIC      }, // 130.248.108.0   - 130.248.127.255
	{ 0x82f88000, 0x82faffff, REGISTRY_ARIN       }, // 130.248.128.0   - 130.250.255.255
	{ 0x82fb0000, 0x82fbffff, REGISTRY_RIPENCC    }, // 130.251.0.0     - 130.251.255.255
	{ 0x82fc0000, 0x82feffff, REGISTRY_ARIN       }, // 130.252.0.0     - 130.254.255.255
	{ 0x82ff0000, 0x82ffffff, REGISTRY_RIPENCC    }, // 130.255.0.0     - 130.255.255.255
	{ 0x83000000, 0x83007bff, REGISTRY_LACNIC     }, // 131.0.0.0       - 131.0.123.255
	{ 0x83008000, 0x830083ff, REGISTRY_LACNIC     }, // 131.0.128.0     - 131.0.131.255
	{ 0x83008800, 0x8300ffff, REGISTRY_LACNIC     }, // 131.0.136.0     - 131.0.255.255
	{ 0x83010000, 0x8301ffff, REGISTRY_RIPENCC    }, // 131.1.0.0       - 131.1.255.255
	{ 0x83020000, 0x8347ffff, REGISTRY_ARIN       }, // 131.2.0.0       - 131.71.255.255
	{ 0x83480000, 0x834873ff, REGISTRY_LACNIC     }, // 131.72.0.0      - 131.72.115.255
	{ 0x83487c00, 0x8348ffff, REGISTRY_LACNIC     }, // 131.72.124.0    - 131.72.255.255
	{ 0x83490000, 0x8360ffff, REGISTRY_ARIN       }, // 131.73.0.0      - 131.96.255.255
	{ 0x83610000, 0x8361ffff, REGISTRY_RIPENCC    }, // 131.97.0.0      - 131.97.255.255
	{ 0x83620000, 0x8362ffff, REGISTRY_ARIN       }, // 131.98.0.0      - 131.98.255.255
	{ 0x83630000, 0x8363ffff, REGISTRY_RIPENCC    }, // 131.99.0.0      - 131.99.255.255
	{ 0x83640000, 0x836403ff, REGISTRY_LACNIC     }, // 131.100.0.0     - 131.100.3.255
	{ 0x83640800, 0x83642fff, REGISTRY_LACNIC     }, // 131.100.8.0     - 131.100.47.255
	{ 0x83643400, 0x8364dbff, REGISTRY_LACNIC     }, // 131.100.52.0    - 131.100.219.255
	{ 0x8364e000, 0x8364ffff, REGISTRY_LACNIC     }, // 131.100.224.0   - 131.100.255.255
	{ 0x83650000, 0x8365ffff, REGISTRY_ARIN       }, // 131.101.0.0     - 131.101.255.255
	{ 0x83660000, 0x8366ffff, REGISTRY_RIPENCC    }, // 131.102.0.0     - 131.102.255.255
	{ 0x83670000, 0x836bffff, REGISTRY_ARIN       }, // 131.103.0.0     - 131.107.255.255
	{ 0x836c0000, 0x836c97ff, REGISTRY_LACNIC     }, // 131.108.0.0     - 131.108.151.255
	{ 0x836c9c00, 0x836cafff, REGISTRY_LACNIC     }, // 131.108.156.0   - 131.108.175.255
	{ 0x836cb400, 0x836cc3ff, REGISTRY_LACNIC     }, // 131.108.180.0   - 131.108.195.255
	{ 0x836cc800, 0x836cebff, REGISTRY_LACNIC     }, // 131.108.200.0   - 131.108.235.255
	{ 0x836cf000, 0x836cffff, REGISTRY_LACNIC     }, // 131.108.240.0   - 131.108.255.255
	{ 0x836d0000, 0x836effff, REGISTRY_ARIN       }, // 131.109.0.0     - 131.110.255.255
	{ 0x836f0000, 0x836fffff, REGISTRY_RIPENCC    }, // 131.111.0.0     - 131.111.255.255
	{ 0x83700000, 0x8371ffff, REGISTRY_APNIC      }, // 131.112.0.0     - 131.113.255.255
	{ 0x83720000, 0x8372ffff, REGISTRY_RIPENCC    }, // 131.114.0.0     - 131.114.255.255
	{ 0x83730000, 0x8374ffff, REGISTRY_RIPENCC    }, // 131.115.0.0     - 131.116.255.255
	{ 0x83750000, 0x83757fff, REGISTRY_RIPENCC    }, // 131.117.0.0     - 131.117.127.255
	{ 0x83758000, 0x8375ffff, REGISTRY_RIPENCC    }, // 131.117.128.0   - 131.117.255.255
	{ 0x83760000, 0x8380ffff, REGISTRY_ARIN       }, // 131.118.0.0     - 131.128.255.255
	{ 0x83810000, 0x8381ffff, REGISTRY_APNIC      }, // 131.129.0.0     - 131.129.255.255
	{ 0x83820000, 0x8382ffff, REGISTRY_RIPENCC    }, // 131.130.0.0     - 131.130.255.255
	{ 0x83830000, 0x8392ffff, REGISTRY_ARIN       }, // 131.131.0.0     - 131.146.255.255
	{ 0x83930000, 0x8393ffff, REGISTRY_APNIC      }, // 131.147.0.0     - 131.147.255.255
	{ 0x83940000, 0x8397ffff, REGISTRY_ARIN       }, // 131.148.0.0     - 131.151.255.255
	{ 0x83980000, 0x8398ffff, REGISTRY_RIPENCC    }, // 131.152.0.0     - 131.152.255.255
	{ 0x83990000, 0x8399ffff, REGISTRY_ARIN       }, // 131.153.0.0     - 131.153.255.255
	{ 0x839a0000, 0x839bffff, REGISTRY_RIPENCC    }, // 131.154.0.0     - 131.155.255.255
	{ 0x839c0000, 0x839effff, REGISTRY_ARIN       }, // 131.156.0.0     - 131.158.255.255
	{ 0x839f0000, 0x83a0ffff, REGISTRY_RIPENCC    }, // 131.159.0.0     - 131.160.255.255
	{ 0x83a10000, 0x83a107ff, REGISTRY_LACNIC     }, // 131.161.0.0     - 131.161.7.255
	{ 0x83a10c00, 0x83a1dbff, REGISTRY_LACNIC     }, // 131.161.12.0    - 131.161.219.255
	{ 0x83a1e000, 0x83a1ffff, REGISTRY_LACNIC     }, // 131.161.224.0   - 131.161.255.255
	{ 0x83a20000, 0x83a3ffff, REGISTRY_ARIN       }, // 131.162.0.0     - 131.163.255.255
	{ 0x83a40000, 0x83a6ffff, REGISTRY_RIPENCC    }, // 131.164.0.0     - 131.166.255.255
	{ 0x83a70000, 0x83a8ffff, REGISTRY_ARIN       }, // 131.167.0.0     - 131.168.255.255
	{ 0x83a90000, 0x83a9ffff, REGISTRY_RIPENCC    }, // 131.169.0.0     - 131.169.255.255
	{ 0x83aa0000, 0x83aaffff, REGISTRY_APNIC      }, // 131.170.0.0     - 131.170.255.255
	{ 0x83ab0000, 0x83abffff, REGISTRY_ARIN       }, // 131.171.0.0     - 131.171.255.255
	{ 0x83ac0000, 0x83acffff, REGISTRY_APNIC      }, // 131.172.0.0     - 131.172.255.255
	{ 0x83ad0000, 0x83b1ffff, REGISTRY_RIPENCC    }, // 131.173.0.0     - 131.177.255.255
	{ 0x83b20000, 0x83b2ffff, REGISTRY_LACNIC     }, // 131.178.0.0     - 131.178.255.255
	{ 0x83b30000, 0x83b3ffff, REGISTRY_ARIN       }, // 131.179.0.0     - 131.179.255.255
	{ 0x83b40000, 0x83b4ffff, REGISTRY_RIPENCC    }, // 131.180.0.0     - 131.180.255.255
	{ 0x83b50000, 0x83b5ffff, REGISTRY_APNIC      }, // 131.181.0.0     - 131.181.255.255
	{ 0x83b60000, 0x83b8ffff, REGISTRY_ARIN       }, // 131.182.0.0     - 131.184.255.255
	{ 0x83b90000, 0x83b9ffff, REGISTRY_APNIC      }, // 131.185.0.0     - 131.185.255.255
	{ 0x83ba0000, 0x83bbffff, REGISTRY_ARIN       }, // 131.186.0.0     - 131.187.255.255
	{ 0x83bc0000, 0x83bcffff, REGISTRY_RIPENCC    }, // 131.188.0.0     - 131.188.255.255
	{ 0x83bd0000, 0x83c3ffff, REGISTRY_ARIN       }, // 131.189.0.0     - 131.195.255.255
	{ 0x83c40000, 0x83c4ffff, REGISTRY_LACNIC     }, // 131.196.0.0     - 131.196.255.255
	{ 0x83c50000, 0x83caffff, REGISTRY_ARIN       }, // 131.197.0.0     - 131.202.255.255
	{ 0x83cb0000, 0x83cbffff, REGISTRY_APNIC      }, // 131.203.0.0     - 131.203.255.255
	{ 0x83cc0000, 0x83ccffff, REGISTRY_ARIN       }, // 131.204.0.0     - 131.204.255.255
	{ 0x83cd0000, 0x83cdffff, REGISTRY_RIPENCC    }, // 131.205.0.0     - 131.205.255.255
	{ 0x83ce0000, 0x83ceffff, REGISTRY_APNIC      }, // 131.206.0.0     - 131.206.255.255
	{ 0x83cf0000, 0x83cfffff, REGISTRY_RIPENCC    }, // 131.207.0.0     - 131.207.255.255
	{ 0x83d00000, 0x83d2ffff, REGISTRY_ARIN       }, // 131.208.0.0     - 131.210.255.255
	{ 0x83d30000, 0x83d3ffff, REGISTRY_RIPENCC    }, // 131.211.0.0     - 131.211.255.255
	{ 0x83d40000, 0x83d4ffff, REGISTRY_ARIN       }, // 131.212.0.0     - 131.212.255.255
	{ 0x83d50000, 0x83d5ffff, REGISTRY_APNIC      }, // 131.213.0.0     - 131.213.255.255
	{ 0x83d60000, 0x83d8ffff, REGISTRY_ARIN       }, // 131.214.0.0     - 131.216.255.255
	{ 0x83d90000, 0x83d9ffff, REGISTRY_APNIC      }, // 131.217.0.0     - 131.217.255.255
	{ 0x83da0000, 0x83dbffff, REGISTRY_ARIN       }, // 131.218.0.0     - 131.219.255.255
	{ 0x83dc0000, 0x83dcffff, REGISTRY_RIPENCC    }, // 131.220.0.0     - 131.220.255.255
	{ 0x83dd0000, 0x83dd4bff, REGISTRY_LACNIC     }, // 131.221.0.0     - 131.221.75.255
	{ 0x83dd5000, 0x83dd8bff, REGISTRY_LACNIC     }, // 131.221.80.0    - 131.221.139.255
	{ 0x83dd9000, 0x83ddffff, REGISTRY_LACNIC     }, // 131.221.144.0   - 131.221.255.255
	{ 0x83de0000, 0x83dfffff, REGISTRY_ARIN       }, // 131.222.0.0     - 131.223.255.255
	{ 0x83e00000, 0x83e0ffff, REGISTRY_RIPENCC    }, // 131.224.0.0     - 131.224.255.255
	{ 0x83e10000, 0x83e2ffff, REGISTRY_ARIN       }, // 131.225.0.0     - 131.226.255.255
	{ 0x83e30000, 0x83e4ffff, REGISTRY_RIPENCC    }, // 131.227.0.0     - 131.228.255.255
	{ 0x83e50000, 0x83e6ffff, REGISTRY_ARIN       }, // 131.229.0.0     - 131.230.255.255
	{ 0x83e70000, 0x83e7ffff, REGISTRY_RIPENCC    }, // 131.231.0.0     - 131.231.255.255
	{ 0x83e80000, 0x83e9ffff, REGISTRY_ARIN       }, // 131.232.0.0     - 131.233.255.255
	{ 0x83ea0000, 0x83eaffff, REGISTRY_RIPENCC    }, // 131.234.0.0     - 131.234.255.255
	{ 0x83eb0000, 0x83ebffff, REGISTRY_ARIN       }, // 131.235.0.0     - 131.235.255.255
	{ 0x83ec0000, 0x83ecffff, REGISTRY_APNIC      }, // 131.236.0.0     - 131.236.255.255
	{ 0x83ed0000, 0x83edffff, REGISTRY_RIPENCC    }, // 131.237.0.0     - 131.237.255.255
	{ 0x83ee0000, 0x83f1ffff, REGISTRY_ARIN       }, // 131.238.0.0     - 131.241.255.255
	{ 0x83f20000, 0x83f2ffff, REGISTRY_APNIC      }, // 131.242.0.0     - 131.242.255.255
	{ 0x83f30000, 0x83f3ffff, REGISTRY_ARIN       }, // 131.243.0.0     - 131.243.255.255
	{ 0x83f40000, 0x83f5ffff, REGISTRY_APNIC      }, // 131.244.0.0     - 131.245.255.255
	{ 0x83f60000, 0x83f6ffff, REGISTRY_RIPENCC    }, // 131.246.0.0     - 131.246.255.255
	{ 0x83f70000, 0x83f7ffff, REGISTRY_ARIN       }, // 131.247.0.0     - 131.247.255.255
	{ 0x83f80000, 0x83f8ffff, REGISTRY_APNIC      }, // 131.248.0.0     - 131.248.255.255
	{ 0x83f90000, 0x83faffff, REGISTRY_ARIN       }, // 131.249.0.0     - 131.250.255.255
	{ 0x83fb0000, 0x83fbffff, REGISTRY_RIPENCC    }, // 131.251.0.0     - 131.251.255.255
	{ 0x83fc0000, 0x83fdffff, REGISTRY_ARIN       }, // 131.252.0.0     - 131.253.255.255
	{ 0x83fe0000, 0x83feffff, REGISTRY_RIPENCC    }, // 131.254.0.0     - 131.254.255.255
	{ 0x83ff0400, 0x83ffefff, REGISTRY_LACNIC     }, // 131.255.4.0     - 131.255.239.255
	{ 0x83fff400, 0x83ffffff, REGISTRY_LACNIC     }, // 131.255.244.0   - 131.255.255.255
	{ 0x84000000, 0x843fffff, REGISTRY_ARIN       }, // 132.0.0.0       - 132.63.255.255
	{ 0x84400000, 0x844effff, REGISTRY_RIPENCC    }, // 132.64.0.0      - 132.78.255.255
	{ 0x844f0000, 0x8491ffff, REGISTRY_ARIN       }, // 132.79.0.0      - 132.145.255.255
	{ 0x84920000, 0x8492ffff, REGISTRY_RIPENCC    }, // 132.146.0.0     - 132.146.255.255
	{ 0x84930000, 0x84933fff, REGISTRY_ARIN       }, // 132.147.0.0     - 132.147.63.255
	{ 0x84934000, 0x84937fff, REGISTRY_APNIC      }, // 132.147.64.0    - 132.147.127.255
	{ 0x84938000, 0x8494ffff, REGISTRY_ARIN       }, // 132.147.128.0   - 132.148.255.255
	{ 0x84950000, 0x8496ffff, REGISTRY_RIPENCC    }, // 132.149.0.0     - 132.150.255.255
	{ 0x84970000, 0x8498ffff, REGISTRY_ARIN       }, // 132.151.0.0     - 132.152.255.255
	{ 0x84990000, 0x8499ffff, REGISTRY_RIPENCC    }, // 132.153.0.0     - 132.153.255.255
	{ 0x849a0000, 0x849affff, REGISTRY_APNIC      }, // 132.154.0.0     - 132.154.255.255
	{ 0x849b0000, 0x849bffff, REGISTRY_RIPENCC    }, // 132.155.0.0     - 132.155.255.255
	{ 0x849c0000, 0x849cffff, REGISTRY_ARIN       }, // 132.156.0.0     - 132.156.255.255
	{ 0x849d0000, 0x849dffff, REGISTRY_LACNIC     }, // 132.157.0.0     - 132.157.255.255
	{ 0x849e0000, 0x84a4ffff, REGISTRY_ARIN       }, // 132.158.0.0     - 132.164.255.255
	{ 0x84a50000, 0x84a9ffff, REGISTRY_RIPENCC    }, // 132.165.0.0     - 132.169.255.255
	{ 0x84aa0000, 0x84aaffff, REGISTRY_ARIN       }, // 132.170.0.0     - 132.170.255.255
	{ 0x84ab0000, 0x84abffff, REGISTRY_RIPENCC    }, // 132.171.0.0     - 132.171.255.255
	{ 0x84ac0000, 0x84afffff, REGISTRY_ARIN       }, // 132.172.0.0     - 132.175.255.255
	{ 0x84b00000, 0x84b0ffff, REGISTRY_RIPENCC    }, // 132.176.0.0     - 132.176.255.255
	{ 0x84b10000, 0x84b2ffff, REGISTRY_ARIN       }, // 132.177.0.0     - 132.178.255.255
	{ 0x84b30000, 0x84b3ffff, REGISTRY_APNIC      }, // 132.179.0.0     - 132.179.255.255
	{ 0x84b40000, 0x84b4ffff, REGISTRY_RIPENCC    }, // 132.180.0.0     - 132.180.255.255
	{ 0x84b50000, 0x84b6ffff, REGISTRY_APNIC      }, // 132.181.0.0     - 132.182.255.255
	{ 0x84b70000, 0x84b7ffff, REGISTRY_ARIN       }, // 132.183.0.0     - 132.183.255.255
	{ 0x84b80000, 0x84b8ffff, REGISTRY_LACNIC     }, // 132.184.0.0     - 132.184.255.255
	{ 0x84b90000, 0x84b9ffff, REGISTRY_RIPENCC    }, // 132.185.0.0     - 132.185.255.255
	{ 0x84ba0000, 0x84baffff, REGISTRY_RIPENCC    }, // 132.186.0.0     - 132.186.255.255
	{ 0x84bb0000, 0x84bbffff, REGISTRY_RIPENCC    }, // 132.187.0.0     - 132.187.255.255
	{ 0x84bc0000, 0x84beffff, REGISTRY_ARIN       }, // 132.188.0.0     - 132.190.255.255
	{ 0x84bf0000, 0x84bfffff, REGISTRY_LACNIC     }, // 132.191.0.0     - 132.191.255.255
	{ 0x84c00000, 0x84c2ffff, REGISTRY_ARIN       }, // 132.192.0.0     - 132.194.255.255
	{ 0x84c30000, 0x84c4ffff, REGISTRY_RIPENCC    }, // 132.195.0.0     - 132.196.255.255
	{ 0x84c50000, 0x84c6ffff, REGISTRY_ARIN       }, // 132.197.0.0     - 132.198.255.255
	{ 0x84c70000, 0x84c7ffff, REGISTRY_RIPENCC    }, // 132.199.0.0     - 132.199.255.255
	{ 0x84c80000, 0x84ddffff, REGISTRY_ARIN       }, // 132.200.0.0     - 132.221.255.255
	{ 0x84de0000, 0x84deffff, REGISTRY_APNIC      }, // 132.222.0.0     - 132.222.255.255
	{ 0x84df0000, 0x84e2ffff, REGISTRY_ARIN       }, // 132.223.0.0     - 132.226.255.255
	{ 0x84e30000, 0x84e3ffff, REGISTRY_RIPENCC    }, // 132.227.0.0     - 132.227.255.255
	{ 0x84e40000, 0x84e4ffff, REGISTRY_ARIN       }, // 132.228.0.0     - 132.228.255.255
	{ 0x84e50000, 0x84e7ffff, REGISTRY_RIPENCC    }, // 132.229.0.0     - 132.231.255.255
	{ 0x84e80000, 0x84e8ffff, REGISTRY_APNIC      }, // 132.232.0.0     - 132.232.255.255
	{ 0x84e90000, 0x84e9ffff, REGISTRY_ARIN       }, // 132.233.0.0     - 132.233.255.255
	{ 0x84ea0000, 0x84eaffff, REGISTRY_APNIC      }, // 132.234.0.0     - 132.234.255.255
	{ 0x84eb0000, 0x84f3ffff, REGISTRY_ARIN       }, // 132.235.0.0     - 132.243.255.255
	{ 0x84f40000, 0x84f4ffff, REGISTRY_RIPENCC    }, // 132.244.0.0     - 132.244.255.255
	{ 0x84f50000, 0x84f6ffff, REGISTRY_ARIN       }, // 132.245.0.0     - 132.246.255.255
	{ 0x84f70000, 0x84f8ffff, REGISTRY_LACNIC     }, // 132.247.0.0     - 132.248.255.255
	{ 0x84f90000, 0x84faffff, REGISTRY_ARIN       }, // 132.249.0.0     - 132.250.255.255
	{ 0x84fb0000, 0x84fbffff, REGISTRY_LACNIC     }, // 132.251.0.0     - 132.251.255.255
	{ 0x84fc0000, 0x84fcffff, REGISTRY_RIPENCC    }, // 132.252.0.0     - 132.252.255.255
	{ 0x84fd0000, 0x84fdffff, REGISTRY_ARIN       }, // 132.253.0.0     - 132.253.255.255
	{ 0x84fe0000, 0x84ff7fff, REGISTRY_LACNIC     }, // 132.254.0.0     - 132.255.127.255
	{ 0x84ff8400, 0x84ffffff, REGISTRY_LACNIC     }, // 132.255.132.0   - 132.255.255.255
	{ 0x85000000, 0x85ffffff, REGISTRY_APNIC      }, // 133.0.0.0       - 133.255.255.255
	{ 0x86000000, 0x8600ffff, REGISTRY_RIPENCC    }, // 134.0.0.0       - 134.0.255.255
	{ 0x86010000, 0x8602ffff, REGISTRY_RIPENCC    }, // 134.1.0.0       - 134.2.255.255
	{ 0x86030000, 0x8603ffff, REGISTRY_RIPENCC    }, // 134.3.0.0       - 134.3.255.255
	{ 0x86040000, 0x8606ffff, REGISTRY_ARIN       }, // 134.4.0.0       - 134.6.255.255
	{ 0x86070000, 0x8607ffff, REGISTRY_APNIC      }, // 134.7.0.0       - 134.7.255.255
	{ 0x86080000, 0x8610ffff, REGISTRY_ARIN       }, // 134.8.0.0       - 134.16.255.255
	{ 0x86110000, 0x8611ffff, REGISTRY_RIPENCC    }, // 134.17.0.0      - 134.17.255.255
	{ 0x86120000, 0x8612ffff, REGISTRY_APNIC      }, // 134.18.0.0      - 134.18.255.255
	{ 0x86130000, 0x8613ffff, REGISTRY_RIPENCC    }, // 134.19.0.0      - 134.19.255.255
	{ 0x86140000, 0x8614ffff, REGISTRY_ARIN       }, // 134.20.0.0      - 134.20.255.255
	{ 0x86150000, 0x8615ffff, REGISTRY_RIPENCC    }, // 134.21.0.0      - 134.21.255.255
	{ 0x86160000, 0x8618ffff, REGISTRY_ARIN       }, // 134.22.0.0      - 134.24.255.255
	{ 0x86190000, 0x8619ffff, REGISTRY_RIPENCC    }, // 134.25.0.0      - 134.25.255.255
	{ 0x861a0000, 0x861affff, REGISTRY_ARIN       }, // 134.26.0.0      - 134.26.255.255
	{ 0x861b0000, 0x861cffff, REGISTRY_RIPENCC    }, // 134.27.0.0      - 134.28.255.255
	{ 0x861d0000, 0x861dffff, REGISTRY_ARIN       }, // 134.29.0.0      - 134.29.255.255
	{ 0x861e0000, 0x861effff, REGISTRY_RIPENCC    }, // 134.30.0.0      - 134.30.255.255
	{ 0x861f0000, 0x8621ffff, REGISTRY_ARIN       }, // 134.31.0.0      - 134.33.255.255
	{ 0x86220000, 0x8625ffff, REGISTRY_RIPENCC    }, // 134.34.0.0      - 134.37.255.255
	{ 0x86260000, 0x862adfff, REGISTRY_ARIN       }, // 134.38.0.0      - 134.42.223.255
	{ 0x862ae000, 0x862ae3ff, REGISTRY_APNIC      }, // 134.42.224.0    - 134.42.227.255
	{ 0x862ae400, 0x862effff, REGISTRY_ARIN       }, // 134.42.228.0    - 134.46.255.255
	{ 0x862f0000, 0x862fffff, REGISTRY_RIPENCC    }, // 134.47.0.0      - 134.47.255.255
	{ 0x86300000, 0x8635ffff, REGISTRY_ARIN       }, // 134.48.0.0      - 134.53.255.255
	{ 0x86360000, 0x8636ffff, REGISTRY_RIPENCC    }, // 134.54.0.0      - 134.54.255.255
	{ 0x86370000, 0x8639ffff, REGISTRY_ARIN       }, // 134.55.0.0      - 134.57.255.255
	{ 0x863a0000, 0x863dffff, REGISTRY_RIPENCC    }, // 134.58.0.0      - 134.61.255.255
	{ 0x863e0000, 0x864affff, REGISTRY_ARIN       }, // 134.62.0.0      - 134.74.255.255
	{ 0x864b0000, 0x864bffff, REGISTRY_APNIC      }, // 134.75.0.0      - 134.75.255.255
	{ 0x864c0000, 0x864cffff, REGISTRY_RIPENCC    }, // 134.76.0.0      - 134.76.255.255
	{ 0x864d0000, 0x8650ffff, REGISTRY_ARIN       }, // 134.77.0.0      - 134.80.255.255
	{ 0x86510000, 0x8651ffff, REGISTRY_RIPENCC    }, // 134.81.0.0      - 134.81.255.255
	{ 0x86520000, 0x8652ffff, REGISTRY_ARIN       }, // 134.82.0.0      - 134.82.255.255
	{ 0x86530000, 0x8653ffff, REGISTRY_RIPENCC    }, // 134.83.0.0      - 134.83.255.255
	{ 0x86540000, 0x8659ffff, REGISTRY_ARIN       }, // 134.84.0.0      - 134.89.255.255
	{ 0x865a0000, 0x865affff, REGISTRY_RIPENCC    }, // 134.90.0.0      - 134.90.255.255
	{ 0x865b0000, 0x86650fff, REGISTRY_RIPENCC    }, // 134.91.0.0      - 134.101.15.255
	{ 0x86651000, 0x86653fff, REGISTRY_RIPENCC    }, // 134.101.16.0    - 134.101.63.255
	{ 0x86654000, 0x86657fff, REGISTRY_RIPENCC    }, // 134.101.64.0    - 134.101.127.255
	{ 0x86658000, 0x8665ffff, REGISTRY_RIPENCC    }, // 134.101.128.0   - 134.101.255.255
	{ 0x86660000, 0x866effff, REGISTRY_RIPENCC    }, // 134.102.0.0     - 134.110.255.255
	{ 0x866f0000, 0x8672ffff, REGISTRY_ARIN       }, // 134.111.0.0     - 134.114.255.255
	{ 0x86730000, 0x8673ffff, REGISTRY_APNIC      }, // 134.115.0.0     - 134.115.255.255
	{ 0x86740000, 0x8676ffff, REGISTRY_ARIN       }, // 134.116.0.0     - 134.118.255.255
	{ 0x86770000, 0x8677ffff, REGISTRY_RIPENCC    }, // 134.119.0.0     - 134.119.255.255
	{ 0x86780000, 0x8681ffff, REGISTRY_ARIN       }, // 134.120.0.0     - 134.129.255.255
	{ 0x86820000, 0x8682ffff, REGISTRY_RIPENCC    }, // 134.130.0.0     - 134.130.255.255
	{ 0x86830000, 0x8689ffff, REGISTRY_ARIN       }, // 134.131.0.0     - 134.137.255.255
	{ 0x868a0000, 0x868affff, REGISTRY_RIPENCC    }, // 134.138.0.0     - 134.138.255.255
	{ 0x868b0000, 0x868dffff, REGISTRY_ARIN       }, // 134.139.0.0     - 134.141.255.255
	{ 0x868e0000, 0x868fffff, REGISTRY_RIPENCC    }, // 134.142.0.0     - 134.143.255.255
	{ 0x86900000, 0x8690ffff, REGISTRY_APNIC      }, // 134.144.0.0     - 134.144.255.255
	{ 0x86910000, 0x8692ffff, REGISTRY_RIPENCC    }, // 134.145.0.0     - 134.146.255.255
	{ 0x86930000, 0x8693ffff, REGISTRY_RIPENCC    }, // 134.147.0.0     - 134.147.255.255
	{ 0x86940000, 0x8694ffff, REGISTRY_APNIC      }, // 134.148.0.0     - 134.148.255.255
	{ 0x86950000, 0x8696ffff, REGISTRY_ARIN       }, // 134.149.0.0     - 134.150.255.255
	{ 0x86970000, 0x8697ffff, REGISTRY_RIPENCC    }, // 134.151.0.0     - 134.151.255.255
	{ 0x86980000, 0x869affff, REGISTRY_ARIN       }, // 134.152.0.0     - 134.154.255.255
	{ 0x869b0000, 0x869bffff, REGISTRY_RIPENCC    }, // 134.155.0.0     - 134.155.255.255
	{ 0x869c0000, 0x869cffff, REGISTRY_ARIN       }, // 134.156.0.0     - 134.156.255.255
	{ 0x869d0000, 0x869effff, REGISTRY_RIPENCC    }, // 134.157.0.0     - 134.158.255.255
	{ 0x869f0000, 0x86a0ffff, REGISTRY_APNIC      }, // 134.159.0.0     - 134.160.255.255
	{ 0x86a10000, 0x86a8ffff, REGISTRY_ARIN       }, // 134.161.0.0     - 134.168.255.255
	{ 0x86a90000, 0x86a9ffff, REGISTRY_RIPENCC    }, // 134.169.0.0     - 134.169.255.255
	{ 0x86aa0000, 0x86aaffff, REGISTRY_ARIN       }, // 134.170.0.0     - 134.170.255.255
	{ 0x86ab0000, 0x86abffff, REGISTRY_RIPENCC    }, // 134.171.0.0     - 134.171.255.255
	{ 0x86ac0000, 0x86aeffff, REGISTRY_ARIN       }, // 134.172.0.0     - 134.174.255.255
	{ 0x86af0000, 0x86afffff, REGISTRY_APNIC      }, // 134.175.0.0     - 134.175.255.255
	{ 0x86b00000, 0x86b0ffff, REGISTRY_RIPENCC    }, // 134.176.0.0     - 134.176.255.255
	{ 0x86b10000, 0x86b1ffff, REGISTRY_ARIN       }, // 134.177.0.0     - 134.177.255.255
	{ 0x86b20000, 0x86b2ffff, REGISTRY_APNIC      }, // 134.178.0.0     - 134.178.255.255
	{ 0x86b30000, 0x86b3ffff, REGISTRY_ARIN       }, // 134.179.0.0     - 134.179.255.255
	{ 0x86b40000, 0x86b4ffff, REGISTRY_APNIC      }, // 134.180.0.0     - 134.180.255.255
	{ 0x86b50000, 0x86b6ffff, REGISTRY_ARIN       }, // 134.181.0.0     - 134.182.255.255
	{ 0x86b70000, 0x86b8ffff, REGISTRY_RIPENCC    }, // 134.183.0.0     - 134.184.255.255
	{ 0x86b90000, 0x86bbffff, REGISTRY_ARIN       }, // 134.185.0.0     - 134.187.255.255
	{ 0x86bc0000, 0x86bcffff, REGISTRY_RIPENCC    }, // 134.188.0.0     - 134.188.255.255
	{ 0x86bd0000, 0x86beffff, REGISTRY_ARIN       }, // 134.189.0.0     - 134.190.255.255
	{ 0x86bf0000, 0x86bfffff, REGISTRY_RIPENCC    }, // 134.191.0.0     - 134.191.255.255
	{ 0x86c00000, 0x86c3ffff, REGISTRY_ARIN       }, // 134.192.0.0     - 134.195.255.255
	{ 0x86c40000, 0x86c4ffff, REGISTRY_APNIC      }, // 134.196.0.0     - 134.196.255.255
	{ 0x86c50000, 0x86caffff, REGISTRY_ARIN       }, // 134.197.0.0     - 134.202.255.255
	{ 0x86cb0000, 0x86cbffff, REGISTRY_RIPENCC    }, // 134.203.0.0     - 134.203.255.255
	{ 0x86cc0000, 0x86cdffff, REGISTRY_ARIN       }, // 134.204.0.0     - 134.205.255.255
	{ 0x86ce0000, 0x86ceffff, REGISTRY_RIPENCC    }, // 134.206.0.0     - 134.206.255.255
	{ 0x86cf0000, 0x86cfffff, REGISTRY_ARIN       }, // 134.207.0.0     - 134.207.255.255
	{ 0x86d00000, 0x86d0ffff, REGISTRY_APNIC      }, // 134.208.0.0     - 134.208.255.255
	{ 0x86d10000, 0x86d2ffff, REGISTRY_ARIN       }, // 134.209.0.0     - 134.210.255.255
	{ 0x86d30000, 0x86d3ffff, REGISTRY_APNIC      }, // 134.211.0.0     - 134.211.255.255
	{ 0x86d40000, 0x86d6ffff, REGISTRY_RIPENCC    }, // 134.212.0.0     - 134.214.255.255
	{ 0x86d70000, 0x86daffff, REGISTRY_ARIN       }, // 134.215.0.0     - 134.218.255.255
	{ 0x86db0000, 0x86deffff, REGISTRY_RIPENCC    }, // 134.219.0.0     - 134.222.255.255
	{ 0x86df0000, 0x86e0ffff, REGISTRY_ARIN       }, // 134.223.0.0     - 134.224.255.255
	{ 0x86e10000, 0x86e3ffff, REGISTRY_RIPENCC    }, // 134.225.0.0     - 134.227.255.255
	{ 0x86e40000, 0x86ebffff, REGISTRY_ARIN       }, // 134.228.0.0     - 134.235.255.255
	{ 0x86ec0000, 0x86edffff, REGISTRY_APNIC      }, // 134.236.0.0     - 134.237.255.255
	{ 0x86ee0000, 0x86eeffff, REGISTRY_ARIN       }, // 134.238.0.0     - 134.238.255.255
	{ 0x86ef0000, 0x86efffff, REGISTRY_RIPENCC    }, // 134.239.0.0     - 134.239.255.255
	{ 0x86f00000, 0x86f2dfff, REGISTRY_ARIN       }, // 134.240.0.0     - 134.242.223.255
	{ 0x86f2e000, 0x86f2ffff, REGISTRY_APNIC      }, // 134.242.224.0   - 134.242.255.255
	{ 0x86f30000, 0x86f4ffff, REGISTRY_ARIN       }, // 134.243.0.0     - 134.244.255.255
	{ 0x86f50000, 0x86f7ffff, REGISTRY_RIPENCC    }, // 134.245.0.0     - 134.247.255.255
	{ 0x86f80000, 0x86f8ffff, REGISTRY_ARIN       }, // 134.248.0.0     - 134.248.255.255
	{ 0x86f90000, 0x86f9ffff, REGISTRY_RIPENCC    }, // 134.249.0.0     - 134.249.255.255
	{ 0x86fa0000, 0x86feffff, REGISTRY_ARIN       }, // 134.250.0.0     - 134.254.255.255
	{ 0x86ff0000, 0x86ffffff, REGISTRY_RIPENCC    }, // 134.255.0.0     - 134.255.255.255
	{ 0x87000000, 0x875433ff, REGISTRY_ARIN       }, // 135.0.0.0       - 135.84.51.255
	{ 0x87543400, 0x875437ff, REGISTRY_RIPENCC    }, // 135.84.52.0     - 135.84.55.255
	{ 0x87543800, 0x875493ff, REGISTRY_ARIN       }, // 135.84.56.0     - 135.84.147.255
	{ 0x87549400, 0x875497ff, REGISTRY_RIPENCC    }, // 135.84.148.0    - 135.84.151.255
	{ 0x87549800, 0x8754e7ff, REGISTRY_ARIN       }, // 135.84.152.0    - 135.84.231.255
	{ 0x8754e800, 0x8754ffff, REGISTRY_APNIC      }, // 135.84.232.0    - 135.84.255.255
	{ 0x87550000, 0x8759ffff, REGISTRY_ARIN       }, // 135.85.0.0      - 135.89.255.255
	{ 0x875a0000, 0x875affff, REGISTRY_RIPENCC    }, // 135.90.0.0      - 135.90.255.255
	{ 0x875b0000, 0x8794ffff, REGISTRY_ARIN       }, // 135.91.0.0      - 135.148.255.255
	{ 0x87950000, 0x8795ffff, REGISTRY_APNIC      }, // 135.149.0.0     - 135.149.255.255
	{ 0x87960000, 0x87c3ffff, REGISTRY_ARIN       }, // 135.150.0.0     - 135.195.255.255
	{ 0x87c40000, 0x87c4ffff, REGISTRY_RIPENCC    }, // 135.196.0.0     - 135.196.255.255
	{ 0x87c50000, 0x88161fff, REGISTRY_ARIN       }, // 135.197.0.0     - 136.22.31.255
	{ 0x88162000, 0x88163fff, REGISTRY_APNIC      }, // 136.22.32.0     - 136.22.63.255
	{ 0x88164000, 0x888effff, REGISTRY_ARIN       }, // 136.22.64.0     - 136.142.255.255
	{ 0x888f0000, 0x888f7fff, REGISTRY_RIPENCC    }, // 136.143.0.0     - 136.143.127.255
	{ 0x888f8000, 0x888fdfff, REGISTRY_ARIN       }, // 136.143.128.0   - 136.143.223.255
	{ 0x888fe000, 0x888fffff, REGISTRY_APNIC      }, // 136.143.224.0   - 136.143.255.255
	{ 0x88900000, 0x88900fff, REGISTRY_ARIN       }, // 136.144.0.0     - 136.144.15.255
	{ 0x88901000, 0x8890ffff, REGISTRY_RIPENCC    }, // 136.144.16.0    - 136.144.255.255
	{ 0x88910000, 0x8893ffff, REGISTRY_ARIN       }, // 136.145.0.0     - 136.147.255.255
	{ 0x88940000, 0x8894ffff, REGISTRY_RIPENCC    }, // 136.148.0.0     - 136.148.255.255
	{ 0x88950000, 0x8898ffff, REGISTRY_ARIN       }, // 136.149.0.0     - 136.152.255.255
	{ 0x88990000, 0x889affff, REGISTRY_APNIC      }, // 136.153.0.0     - 136.154.255.255
	{ 0x889b0000, 0x889cffff, REGISTRY_RIPENCC    }, // 136.155.0.0     - 136.156.255.255
	{ 0x889d0000, 0x889dffff, REGISTRY_RIPENCC    }, // 136.157.0.0     - 136.157.255.255
	{ 0x889e0000, 0x889e7fff, REGISTRY_APNIC      }, // 136.158.0.0     - 136.158.127.255
	{ 0x889e8000, 0x889effff, REGISTRY_RIPENCC    }, // 136.158.128.0   - 136.158.255.255
	{ 0x889f0000, 0x88a2ffff, REGISTRY_ARIN       }, // 136.159.0.0     - 136.162.255.255
	{ 0x88a30000, 0x88a4ffff, REGISTRY_RIPENCC    }, // 136.163.0.0     - 136.164.255.255
	{ 0x88a50000, 0x88a8ffff, REGISTRY_ARIN       }, // 136.165.0.0     - 136.168.255.255
	{ 0x88a90000, 0x88a9ffff, REGISTRY_RIPENCC    }, // 136.169.0.0     - 136.169.255.255
	{ 0x88aa0000, 0x88aaffff, REGISTRY_RIPENCC    }, // 136.170.0.0     - 136.170.255.255
	{ 0x88ab0000, 0x88abffff, REGISTRY_ARIN       }, // 136.171.0.0     - 136.171.255.255
	{ 0x88ac0000, 0x88adffff, REGISTRY_RIPENCC    }, // 136.172.0.0     - 136.173.255.255
	{ 0x88ae0000, 0x88b8ffff, REGISTRY_ARIN       }, // 136.174.0.0     - 136.184.255.255
	{ 0x88b90000, 0x88bbffff, REGISTRY_APNIC      }, // 136.185.0.0     - 136.187.255.255
	{ 0x88bc0000, 0x88c5ffff, REGISTRY_ARIN       }, // 136.188.0.0     - 136.197.255.255
	{ 0x88c60000, 0x88c6ffff, REGISTRY_APNIC      }, // 136.198.0.0     - 136.198.255.255
	{ 0x88c70000, 0x88c7ffff, REGISTRY_RIPENCC    }, // 136.199.0.0     - 136.199.255.255
	{ 0x88c80000, 0x88c8ffff, REGISTRY_ARIN       }, // 136.200.0.0     - 136.200.255.255
	{ 0x88c90000, 0x88c9ffff, REGISTRY_RIPENCC    }, // 136.201.0.0     - 136.201.255.255
	{ 0x88ca0000, 0x88cdffff, REGISTRY_ARIN       }, // 136.202.0.0     - 136.205.255.255
	{ 0x88ce0000, 0x88ceffff, REGISTRY_RIPENCC    }, // 136.206.0.0     - 136.206.255.255
	{ 0x88cf0000, 0x88e0ffff, REGISTRY_ARIN       }, // 136.207.0.0     - 136.224.255.255
	{ 0x88e10000, 0x88e1ffff, REGISTRY_RIPENCC    }, // 136.225.0.0     - 136.225.255.255
	{ 0x88e20000, 0x88e47fff, REGISTRY_ARIN       }, // 136.226.0.0     - 136.228.127.255
	{ 0x88e48000, 0x88e4afff, REGISTRY_APNIC      }, // 136.228.128.0   - 136.228.175.255
	{ 0x88e4b000, 0x88e5ffff, REGISTRY_ARIN       }, // 136.228.176.0   - 136.229.255.255
	{ 0x88e60000, 0x88e7ffff, REGISTRY_RIPENCC    }, // 136.230.0.0     - 136.231.255.255
	{ 0x88e80000, 0x88e9ffff, REGISTRY_APNIC      }, // 136.232.0.0     - 136.233.255.255
	{ 0x88ea0000, 0x88f2ffff, REGISTRY_ARIN       }, // 136.234.0.0     - 136.242.255.255
	{ 0x88f30000, 0x88f3ffff, REGISTRY_RIPENCC    }, // 136.243.0.0     - 136.243.255.255
	{ 0x88f40000, 0x88feffff, REGISTRY_ARIN       }, // 136.244.0.0     - 136.254.255.255
	{ 0x88ff0000, 0x88ffffff, REGISTRY_RIPENCC    }, // 136.255.0.0     - 136.255.255.255
	{ 0x89000000, 0x8910ffff, REGISTRY_ARIN       }, // 137.0.0.0       - 137.16.255.255
	{ 0x89110000, 0x8911ffff, REGISTRY_RIPENCC    }, // 137.17.0.0      - 137.17.255.255
	{ 0x89120000, 0x8920ffff, REGISTRY_ARIN       }, // 137.18.0.0      - 137.32.255.255
	{ 0x89210000, 0x8922ffff, REGISTRY_RIPENCC    }, // 137.33.0.0      - 137.34.255.255
	{ 0x89230000, 0x892affff, REGISTRY_ARIN       }, // 137.35.0.0      - 137.42.255.255
	{ 0x892b0000, 0x892cffff, REGISTRY_RIPENCC    }, // 137.43.0.0      - 137.44.255.255
	{ 0x892d0000, 0x892effff, REGISTRY_ARIN       }, // 137.45.0.0      - 137.46.255.255
	{ 0x892f0000, 0x892fffff, REGISTRY_RIPENCC    }, // 137.47.0.0      - 137.47.255.255
	{ 0x89300000, 0x8931ffff, REGISTRY_ARIN       }, // 137.48.0.0      - 137.49.255.255
	{ 0x89320000, 0x8932ffff, REGISTRY_RIPENCC    }, // 137.50.0.0      - 137.50.255.255
	{ 0x89330000, 0x8936ffff, REGISTRY_ARIN       }, // 137.51.0.0      - 137.54.255.255
	{ 0x89370000, 0x8938ffff, REGISTRY_RIPENCC    }, // 137.55.0.0      - 137.56.255.255
	{ 0x89390000, 0x8939ffff, REGISTRY_ARIN       }, // 137.57.0.0      - 137.57.255.255
	{ 0x893a0000, 0x893affff, REGISTRY_RIPENCC    }, // 137.58.0.0      - 137.58.255.255
	{ 0x893b0000, 0x893bffff, REGISTRY_APNIC      }, // 137.59.0.0      - 137.59.255.255
	{ 0x893c0000, 0x893effff, REGISTRY_RIPENCC    }, // 137.60.0.0      - 137.62.255.255
	{ 0x893f0000, 0x8940ffff, REGISTRY_AFRINIC    }, // 137.63.0.0      - 137.64.255.255
	{ 0x89410000, 0x8943ffff, REGISTRY_ARIN       }, // 137.65.0.0      - 137.67.255.255
	{ 0x89440000, 0x8944ffff, REGISTRY_APNIC      }, // 137.68.0.0      - 137.68.255.255
	{ 0x89450000, 0x8948ffff, REGISTRY_ARIN       }, // 137.69.0.0      - 137.72.255.255
	{ 0x89490000, 0x8949ffff, REGISTRY_RIPENCC    }, // 137.73.0.0      - 137.73.255.255
	{ 0x894a0000, 0x894affff, REGISTRY_RIPENCC    }, // 137.74.0.0      - 137.74.255.255
	{ 0x894b0000, 0x894bffff, REGISTRY_ARIN       }, // 137.75.0.0      - 137.75.255.255
	{ 0x894c0000, 0x894cffff, REGISTRY_APNIC      }, // 137.76.0.0      - 137.76.255.255
	{ 0x894d0000, 0x895bffff, REGISTRY_ARIN       }, // 137.77.0.0      - 137.91.255.255
	{ 0x895c0000, 0x895cffff, REGISTRY_APNIC      }, // 137.92.0.0      - 137.92.255.255
	{ 0x895d0000, 0x895dffff, REGISTRY_RIPENCC    }, // 137.93.0.0      - 137.93.255.255
	{ 0x895e0000, 0x895fffff, REGISTRY_ARIN       }, // 137.94.0.0      - 137.95.255.255
	{ 0x89600000, 0x8960ffff, REGISTRY_RIPENCC    }, // 137.96.0.0      - 137.96.255.255
	{ 0x89610000, 0x8961ffff, REGISTRY_APNIC      }, // 137.97.0.0      - 137.97.255.255
	{ 0x89620000, 0x8964ffff, REGISTRY_ARIN       }, // 137.98.0.0      - 137.100.255.255
	{ 0x89650000, 0x8965ffff, REGISTRY_RIPENCC    }, // 137.101.0.0     - 137.101.255.255
	{ 0x89660000, 0x8968ffff, REGISTRY_ARIN       }, // 137.102.0.0     - 137.104.255.255
	{ 0x89690000, 0x8969ffff, REGISTRY_RIPENCC    }, // 137.105.0.0     - 137.105.255.255
	{ 0x896a0000, 0x896bffff, REGISTRY_ARIN       }, // 137.106.0.0     - 137.107.255.255
	{ 0x896c0000, 0x896cffff, REGISTRY_RIPENCC    }, // 137.108.0.0     - 137.108.255.255
	{ 0x896d0000, 0x896dffff, REGISTRY_APNIC      }, // 137.109.0.0     - 137.109.255.255
	{ 0x896e0000, 0x896effff, REGISTRY_ARIN       }, // 137.110.0.0     - 137.110.255.255
	{ 0x896f0000, 0x896fffff, REGISTRY_APNIC      }, // 137.111.0.0     - 137.111.255.255
	{ 0x89700000, 0x8972ffff, REGISTRY_ARIN       }, // 137.112.0.0     - 137.114.255.255
	{ 0x89730000, 0x8973ffff, REGISTRY_AFRINIC    }, // 137.115.0.0     - 137.115.255.255
	{ 0x89740000, 0x8977ffff, REGISTRY_ARIN       }, // 137.116.0.0     - 137.119.255.255
	{ 0x89780000, 0x8979ffff, REGISTRY_RIPENCC    }, // 137.120.0.0     - 137.121.255.255
	{ 0x897a0000, 0x8980ffff, REGISTRY_ARIN       }, // 137.122.0.0     - 137.128.255.255
	{ 0x89810000, 0x8981ffff, REGISTRY_RIPENCC    }, // 137.129.0.0     - 137.129.255.255
	{ 0x89820000, 0x8983ffff, REGISTRY_ARIN       }, // 137.130.0.0     - 137.131.255.255
	{ 0x89840000, 0x8984ffff, REGISTRY_APNIC      }, // 137.132.0.0     - 137.132.255.255
	{ 0x89850000, 0x8985ffff, REGISTRY_RIPENCC    }, // 137.133.0.0     - 137.133.255.255
	{ 0x89860000, 0x8989ffff, REGISTRY_ARIN       }, // 137.134.0.0     - 137.137.255.255
	{ 0x898a0000, 0x898affff, REGISTRY_RIPENCC    }, // 137.138.0.0     - 137.138.255.255
	{ 0x898b0000, 0x8992ffff, REGISTRY_ARIN       }, // 137.139.0.0     - 137.146.255.255
	{ 0x89930000, 0x8993ffff, REGISTRY_APNIC      }, // 137.147.0.0     - 137.147.255.255
	{ 0x89940000, 0x8998ffff, REGISTRY_ARIN       }, // 137.148.0.0     - 137.152.255.255
	{ 0x89990000, 0x899affff, REGISTRY_APNIC      }, // 137.153.0.0     - 137.154.255.255
	{ 0x899b0000, 0x899bffff, REGISTRY_ARIN       }, // 137.155.0.0     - 137.155.255.255
	{ 0x899c0000, 0x899cffff, REGISTRY_RIPENCC    }, // 137.156.0.0     - 137.156.255.255
	{ 0x899d0000, 0x899dffff, REGISTRY_APNIC      }, // 137.157.0.0     - 137.157.255.255
	{ 0x899e0000, 0x899effff, REGISTRY_AFRINIC    }, // 137.158.0.0     - 137.158.255.255
	{ 0x899f0000, 0x89a2ffff, REGISTRY_ARIN       }, // 137.159.0.0     - 137.162.255.255
	{ 0x89a30000, 0x89a3ffff, REGISTRY_RIPENCC    }, // 137.163.0.0     - 137.163.255.255
	{ 0x89a40000, 0x89a5ffff, REGISTRY_ARIN       }, // 137.164.0.0     - 137.165.255.255
	{ 0x89a60000, 0x89a6ffff, REGISTRY_APNIC      }, // 137.166.0.0     - 137.166.255.255
	{ 0x89a70000, 0x89aaffff, REGISTRY_ARIN       }, // 137.167.0.0     - 137.170.255.255
	{ 0x89ab0000, 0x89abffff, REGISTRY_AFRINIC    }, // 137.171.0.0     - 137.171.255.255
	{ 0x89ac0000, 0x89acffff, REGISTRY_APNIC      }, // 137.172.0.0     - 137.172.255.255
	{ 0x89ad0000, 0x89adffff, REGISTRY_ARIN       }, // 137.173.0.0     - 137.173.255.255
	{ 0x89ae0000, 0x89aeffff, REGISTRY_RIPENCC    }, // 137.174.0.0     - 137.174.255.255
	{ 0x89af0000, 0x89bcffff, REGISTRY_ARIN       }, // 137.175.0.0     - 137.188.255.255
	{ 0x89bd0000, 0x89bdffff, REGISTRY_APNIC      }, // 137.189.0.0     - 137.189.255.255
	{ 0x89be0000, 0x89beffff, REGISTRY_ARIN       }, // 137.190.0.0     - 137.190.255.255
	{ 0x89bf0000, 0x89bfffff, REGISTRY_RIPENCC    }, // 137.191.0.0     - 137.191.255.255
	{ 0x89c00000, 0x89c0ffff, REGISTRY_ARIN       }, // 137.192.0.0     - 137.192.255.255
	{ 0x89c10000, 0x89c3ffff, REGISTRY_RIPENCC    }, // 137.193.0.0     - 137.195.255.255
	{ 0x89c40000, 0x89c4ffff, REGISTRY_AFRINIC    }, // 137.196.0.0     - 137.196.255.255
	{ 0x89c50000, 0x89cbffff, REGISTRY_ARIN       }, // 137.197.0.0     - 137.203.255.255
	{ 0x89cc0000, 0x89cdffff, REGISTRY_RIPENCC    }, // 137.204.0.0     - 137.205.255.255
	{ 0x89ce0000, 0x89cfffff, REGISTRY_ARIN       }, // 137.206.0.0     - 137.207.255.255
	{ 0x89d00000, 0x89d0ffff, REGISTRY_RIPENCC    }, // 137.208.0.0     - 137.208.255.255
	{ 0x89d10000, 0x89d4ffff, REGISTRY_ARIN       }, // 137.209.0.0     - 137.212.255.255
	{ 0x89d50000, 0x89d5ffff, REGISTRY_RIPENCC    }, // 137.213.0.0     - 137.213.255.255
	{ 0x89d60000, 0x89d7ffff, REGISTRY_AFRINIC    }, // 137.214.0.0     - 137.215.255.255
	{ 0x89d80000, 0x89d8ffff, REGISTRY_ARIN       }, // 137.216.0.0     - 137.216.255.255
	{ 0x89d90000, 0x89daffff, REGISTRY_RIPENCC    }, // 137.217.0.0     - 137.218.255.255
	{ 0x89db0000, 0x89dbffff, REGISTRY_APNIC      }, // 137.219.0.0     - 137.219.255.255
	{ 0x89dc0000, 0x89dcffff, REGISTRY_ARIN       }, // 137.220.0.0     - 137.220.255.255
	{ 0x89dd0000, 0x89dd17ff, REGISTRY_RIPENCC    }, // 137.221.0.0     - 137.221.23.255
	{ 0x89dd1800, 0x89dd3fff, REGISTRY_RIPENCC    }, // 137.221.24.0    - 137.221.63.255
	{ 0x89dd4000, 0x89dd7fff, REGISTRY_RIPENCC    }, // 137.221.64.0    - 137.221.127.255
	{ 0x89dd8000, 0x89deffff, REGISTRY_RIPENCC    }, // 137.221.128.0   - 137.222.255.255
	{ 0x89df0000, 0x89dfffff, REGISTRY_RIPENCC    }, // 137.223.0.0     - 137.223.255.255
	{ 0x89e00000, 0x89e0ffff, REGISTRY_RIPENCC    }, // 137.224.0.0     - 137.224.255.255
	{ 0x89e10000, 0x89e1ffff, REGISTRY_ARIN       }, // 137.225.0.0     - 137.225.255.255
	{ 0x89e20000, 0x89e2ffff, REGISTRY_RIPENCC    }, // 137.226.0.0     - 137.226.255.255
	{ 0x89e30000, 0x89f7ffff, REGISTRY_ARIN       }, // 137.227.0.0     - 137.247.255.255
	{ 0x89f80000, 0x89f8ffff, REGISTRY_RIPENCC    }, // 137.248.0.0     - 137.248.255.255
	{ 0x89f90000, 0x89f9ffff, REGISTRY_ARIN       }, // 137.249.0.0     - 137.249.255.255
	{ 0x89fa0000, 0x89fbffff, REGISTRY_RIPENCC    }, // 137.250.0.0     - 137.251.255.255
	{ 0x89fc0000, 0x89fcffff, REGISTRY_ARIN       }, // 137.252.0.0     - 137.252.255.255
	{ 0x89fd0000, 0x89fdffff, REGISTRY_RIPENCC    }, // 137.253.0.0     - 137.253.255.255
	{ 0x89fe0000, 0x89feffff, REGISTRY_ARIN       }, // 137.254.0.0     - 137.254.255.255
	{ 0x89ff0000, 0x89ffffff, REGISTRY_AFRINIC    }, // 137.255.0.0     - 137.255.255.255
	{ 0x8a000000, 0x8a006bff, REGISTRY_LACNIC     }, // 138.0.0.0       - 138.0.107.255
	{ 0x8a007000, 0x8a00ffff, REGISTRY_LACNIC     }, // 138.0.112.0     - 138.0.255.255
	{ 0x8a010000, 0x8a02ffff, REGISTRY_ARIN       }, // 138.1.0.0       - 138.2.255.255
	{ 0x8a030000, 0x8a04ffff, REGISTRY_RIPENCC    }, // 138.3.0.0       - 138.4.255.255
	{ 0x8a050000, 0x8a05ffff, REGISTRY_ARIN       }, // 138.5.0.0       - 138.5.255.255
	{ 0x8a060000, 0x8a06ffff, REGISTRY_RIPENCC    }, // 138.6.0.0       - 138.6.255.255
	{ 0x8a070000, 0x8a07ffff, REGISTRY_APNIC      }, // 138.7.0.0       - 138.7.255.255
	{ 0x8a080000, 0x8a0dffff, REGISTRY_ARIN       }, // 138.8.0.0       - 138.13.255.255
	{ 0x8a0e0000, 0x8a0effff, REGISTRY_RIPENCC    }, // 138.14.0.0      - 138.14.255.255
	{ 0x8a0f0000, 0x8a12ffff, REGISTRY_ARIN       }, // 138.15.0.0      - 138.18.255.255
	{ 0x8a130000, 0x8a13ffff, REGISTRY_APNIC      }, // 138.19.0.0      - 138.19.255.255
	{ 0x8a140000, 0x8a14ffff, REGISTRY_ARIN       }, // 138.20.0.0      - 138.20.255.255
	{ 0x8a150000, 0x8a16ffff, REGISTRY_RIPENCC    }, // 138.21.0.0      - 138.22.255.255
	{ 0x8a170000, 0x8a17ffff, REGISTRY_ARIN       }, // 138.23.0.0      - 138.23.255.255
	{ 0x8a180000, 0x8a19ffff, REGISTRY_APNIC      }, // 138.24.0.0      - 138.25.255.255
	{ 0x8a1a0000, 0x8a1dffff, REGISTRY_ARIN       }, // 138.26.0.0      - 138.29.255.255
	{ 0x8a1e0000, 0x8a1effff, REGISTRY_APNIC      }, // 138.30.0.0      - 138.30.255.255
	{ 0x8a1f0000, 0x8a23ffff, REGISTRY_ARIN       }, // 138.31.0.0      - 138.35.255.255
	{ 0x8a240000, 0x8a2407ff, REGISTRY_LACNIC     }, // 138.36.0.0      - 138.36.7.255
	{ 0x8a241000, 0x8a24ffff, REGISTRY_LACNIC     }, // 138.36.16.0     - 138.36.255.255
	{ 0x8a250000, 0x8a26ffff, REGISTRY_RIPENCC    }, // 138.37.0.0      - 138.38.255.255
	{ 0x8a270000, 0x8a27ffff, REGISTRY_ARIN       }, // 138.39.0.0      - 138.39.255.255
	{ 0x8a280000, 0x8a29ffff, REGISTRY_RIPENCC    }, // 138.40.0.0      - 138.41.255.255
	{ 0x8a2a0000, 0x8a2bffff, REGISTRY_ARIN       }, // 138.42.0.0      - 138.43.255.255
	{ 0x8a2c0000, 0x8a2cffff, REGISTRY_APNIC      }, // 138.44.0.0      - 138.44.255.255
	{ 0x8a2d0000, 0x8a2fffff, REGISTRY_ARIN       }, // 138.45.0.0      - 138.47.255.255
	{ 0x8a300000, 0x8a30ffff, REGISTRY_RIPENCC    }, // 138.48.0.0      - 138.48.255.255
	{ 0x8a310000, 0x8a3affff, REGISTRY_ARIN       }, // 138.49.0.0      - 138.58.255.255
	{ 0x8a3b0000, 0x8a3b23ff, REGISTRY_LACNIC     }, // 138.59.0.0      - 138.59.35.255
	{ 0x8a3b2800, 0x8a3b87ff, REGISTRY_LACNIC     }, // 138.59.40.0     - 138.59.135.255
	{ 0x8a3b8c00, 0x8a3b97ff, REGISTRY_LACNIC     }, // 138.59.140.0    - 138.59.151.255
	{ 0x8a3b9c00, 0x8a3bb3ff, REGISTRY_LACNIC     }, // 138.59.156.0    - 138.59.179.255
	{ 0x8a3bb800, 0x8a3bdfff, REGISTRY_LACNIC     }, // 138.59.184.0    - 138.59.223.255
	{ 0x8a3be400, 0x8a3bffff, REGISTRY_LACNIC     }, // 138.59.228.0    - 138.59.255.255
	{ 0x8a3c0000, 0x8a3dffff, REGISTRY_ARIN       }, // 138.60.0.0      - 138.61.255.255
	{ 0x8a3e0000, 0x8a3fffff, REGISTRY_RIPENCC    }, // 138.62.0.0      - 138.63.255.255
	{ 0x8a400000, 0x8a40ffff, REGISTRY_APNIC      }, // 138.64.0.0      - 138.64.255.255
	{ 0x8a410000, 0x8a41ffff, REGISTRY_ARIN       }, // 138.65.0.0      - 138.65.255.255
	{ 0x8a420000, 0x8a42ffff, REGISTRY_RIPENCC    }, // 138.66.0.0      - 138.66.255.255
	{ 0x8a430000, 0x8a45ffff, REGISTRY_ARIN       }, // 138.67.0.0      - 138.69.255.255
	{ 0x8a460000, 0x8a46ffff, REGISTRY_RIPENCC    }, // 138.70.0.0      - 138.70.255.255
	{ 0x8a470000, 0x8a47ffff, REGISTRY_APNIC      }, // 138.71.0.0      - 138.71.255.255
	{ 0x8a480000, 0x8a4affff, REGISTRY_ARIN       }, // 138.72.0.0      - 138.74.255.255
	{ 0x8a4b0000, 0x8a4bffff, REGISTRY_APNIC      }, // 138.75.0.0      - 138.75.255.255
	{ 0x8a4c0000, 0x8a4cffff, REGISTRY_ARIN       }, // 138.76.0.0      - 138.76.255.255
	{ 0x8a4d0000, 0x8a4dffff, REGISTRY_APNIC      }, // 138.77.0.0      - 138.77.255.255
	{ 0x8a4e0000, 0x8a4effff, REGISTRY_ARIN       }, // 138.78.0.0      - 138.78.255.255
	{ 0x8a4f0000, 0x8a50ffff, REGISTRY_APNIC      }, // 138.79.0.0      - 138.80.255.255
	{ 0x8a510000, 0x8a51ffff, REGISTRY_RIPENCC    }, // 138.81.0.0      - 138.81.255.255
	{ 0x8a520000, 0x8a5dffff, REGISTRY_ARIN       }, // 138.82.0.0      - 138.93.255.255
	{ 0x8a5e0000, 0x8a5e27ff, REGISTRY_LACNIC     }, // 138.94.0.0      - 138.94.39.255
	{ 0x8a5e2c00, 0x8a5ea7ff, REGISTRY_LACNIC     }, // 138.94.44.0     - 138.94.167.255
	{ 0x8a5eac00, 0x8a5eb7ff, REGISTRY_LACNIC     }, // 138.94.172.0    - 138.94.183.255
	{ 0x8a5ebc00, 0x8a5effff, REGISTRY_LACNIC     }, // 138.94.188.0    - 138.94.255.255
	{ 0x8a5f0000, 0x8a5fffff, REGISTRY_ARIN       }, // 138.95.0.0      - 138.95.255.255
	{ 0x8a600000, 0x8a60ffff, REGISTRY_RIPENCC    }, // 138.96.0.0      - 138.96.255.255
	{ 0x8a610000, 0x8a614bff, REGISTRY_LACNIC     }, // 138.97.0.0      - 138.97.75.255
	{ 0x8a615000, 0x8a61ffff, REGISTRY_LACNIC     }, // 138.97.80.0     - 138.97.255.255
	{ 0x8a620000, 0x8a62ffff, REGISTRY_ARIN       }, // 138.98.0.0      - 138.98.255.255
	{ 0x8a630000, 0x8a637bff, REGISTRY_LACNIC     }, // 138.99.0.0      - 138.99.123.255
	{ 0x8a638000, 0x8a63e3ff, REGISTRY_LACNIC     }, // 138.99.128.0    - 138.99.227.255
	{ 0x8a63e800, 0x8a63ffff, REGISTRY_LACNIC     }, // 138.99.232.0    - 138.99.255.255
	{ 0x8a640000, 0x8a64ffff, REGISTRY_RIPENCC    }, // 138.100.0.0     - 138.100.255.255
	{ 0x8a650000, 0x8a65ffff, REGISTRY_APNIC      }, // 138.101.0.0     - 138.101.255.255
	{ 0x8a660000, 0x8a68ffff, REGISTRY_RIPENCC    }, // 138.102.0.0     - 138.104.255.255
	{ 0x8a690000, 0x8a69ffff, REGISTRY_ARIN       }, // 138.105.0.0     - 138.105.255.255
	{ 0x8a6a0000, 0x8a6affff, REGISTRY_RIPENCC    }, // 138.106.0.0     - 138.106.255.255
	{ 0x8a6b0000, 0x8a6bffff, REGISTRY_APNIC      }, // 138.107.0.0     - 138.107.255.255
	{ 0x8a6c0000, 0x8a74ffff, REGISTRY_ARIN       }, // 138.108.0.0     - 138.116.255.255
	{ 0x8a750000, 0x8a752bff, REGISTRY_LACNIC     }, // 138.117.0.0     - 138.117.43.255
	{ 0x8a753000, 0x8a75dfff, REGISTRY_LACNIC     }, // 138.117.48.0    - 138.117.223.255
	{ 0x8a760000, 0x8a76c7ff, REGISTRY_LACNIC     }, // 138.118.0.0     - 138.118.199.255
	{ 0x8a76cc00, 0x8a76ffff, REGISTRY_LACNIC     }, // 138.118.204.0   - 138.118.255.255
	{ 0x8a770000, 0x8a78ffff, REGISTRY_ARIN       }, // 138.119.0.0     - 138.120.255.255
	{ 0x8a790000, 0x8a7927ff, REGISTRY_LACNIC     }, // 138.121.0.0     - 138.121.39.255
	{ 0x8a792c00, 0x8a79a3ff, REGISTRY_LACNIC     }, // 138.121.44.0    - 138.121.163.255
	{ 0x8a79a800, 0x8a7ab7ff, REGISTRY_LACNIC     }, // 138.121.168.0   - 138.122.183.255
	{ 0x8a7abc00, 0x8a7affff, REGISTRY_LACNIC     }, // 138.122.188.0   - 138.122.255.255
	{ 0x8a7b0000, 0x8a7bffff, REGISTRY_ARIN       }, // 138.123.0.0     - 138.123.255.255
	{ 0x8a7c0000, 0x8a7cffff, REGISTRY_RIPENCC    }, // 138.124.0.0     - 138.124.255.255
	{ 0x8a7d0000, 0x8a8087ff, REGISTRY_ARIN       }, // 138.125.0.0     - 138.128.135.255
	{ 0x8a808800, 0x8a808fff, REGISTRY_RIPENCC    }, // 138.128.136.0   - 138.128.143.255
	{ 0x8a809000, 0x8a81ffff, REGISTRY_ARIN       }, // 138.128.144.0   - 138.129.255.255
	{ 0x8a820000, 0x8a82ffff, REGISTRY_APNIC      }, // 138.130.0.0     - 138.130.255.255
	{ 0x8a830000, 0x8a84ffff, REGISTRY_RIPENCC    }, // 138.131.0.0     - 138.132.255.255
	{ 0x8a850000, 0x8a85ffff, REGISTRY_ARIN       }, // 138.133.0.0     - 138.133.255.255
	{ 0x8a860000, 0x8a86ffff, REGISTRY_RIPENCC    }, // 138.134.0.0     - 138.134.255.255
	{ 0x8a870000, 0x8ab8ffff, REGISTRY_ARIN       }, // 138.135.0.0     - 138.184.255.255
	{ 0x8ab90000, 0x8ab943ff, REGISTRY_LACNIC     }, // 138.185.0.0     - 138.185.67.255
	{ 0x8ab94800, 0x8ab957ff, REGISTRY_LACNIC     }, // 138.185.72.0    - 138.185.87.255
	{ 0x8ab95c00, 0x8aba4bff, REGISTRY_LACNIC     }, // 138.185.92.0    - 138.186.75.255
	{ 0x8aba5000, 0x8abaffff, REGISTRY_LACNIC     }, // 138.186.80.0    - 138.186.255.255
	{ 0x8abb0000, 0x8abcffff, REGISTRY_RIPENCC    }, // 138.187.0.0     - 138.188.255.255
	{ 0x8abd0000, 0x8abdffff, REGISTRY_RIPENCC    }, // 138.189.0.0     - 138.189.255.255
	{ 0x8abe0000, 0x8abeffff, REGISTRY_RIPENCC    }, // 138.190.0.0     - 138.190.255.255
	{ 0x8abf0000, 0x8abfffff, REGISTRY_RIPENCC    }, // 138.191.0.0     - 138.191.255.255
	{ 0x8ac00000, 0x8ac1ffff, REGISTRY_ARIN       }, // 138.192.0.0     - 138.193.255.255
	{ 0x8ac20000, 0x8ac2ffff, REGISTRY_APNIC      }, // 138.194.0.0     - 138.194.255.255
	{ 0x8ac30000, 0x8ac3ffff, REGISTRY_RIPENCC    }, // 138.195.0.0     - 138.195.255.255
	{ 0x8ac40000, 0x8ac5ffff, REGISTRY_ARIN       }, // 138.196.0.0     - 138.197.255.255
	{ 0x8ac60000, 0x8ac9ffff, REGISTRY_RIPENCC    }, // 138.198.0.0     - 138.201.255.255
	{ 0x8aca0000, 0x8acaffff, REGISTRY_ARIN       }, // 138.202.0.0     - 138.202.255.255
	{ 0x8acb0000, 0x8acbffff, REGISTRY_RIPENCC    }, // 138.203.0.0     - 138.203.255.255
	{ 0x8acc0000, 0x8acc0fff, REGISTRY_LACNIC     }, // 138.204.0.0     - 138.204.15.255
	{ 0x8acc1400, 0x8acca3ff, REGISTRY_LACNIC     }, // 138.204.20.0    - 138.204.163.255
	{ 0x8acca800, 0x8accffff, REGISTRY_LACNIC     }, // 138.204.168.0   - 138.204.255.255
	{ 0x8acd0000, 0x8aceffff, REGISTRY_RIPENCC    }, // 138.205.0.0     - 138.206.255.255
	{ 0x8acf0000, 0x8ad2ffff, REGISTRY_ARIN       }, // 138.207.0.0     - 138.210.255.255
	{ 0x8ad30000, 0x8ad4ffff, REGISTRY_APNIC      }, // 138.211.0.0     - 138.212.255.255
	{ 0x8ad60000, 0x8ad6ffff, REGISTRY_ARIN       }, // 138.214.0.0     - 138.214.255.255
	{ 0x8ad70000, 0x8ad8ffff, REGISTRY_RIPENCC    }, // 138.215.0.0     - 138.216.255.255
	{ 0x8ad90000, 0x8ad9ffff, REGISTRY_APNIC      }, // 138.217.0.0     - 138.217.255.255
	{ 0x8ada0000, 0x8adaffff, REGISTRY_ARIN       }, // 138.218.0.0     - 138.218.255.255
	{ 0x8adb0000, 0x8adb1bff, REGISTRY_LACNIC     }, // 138.219.0.0     - 138.219.27.255
	{ 0x8adb2000, 0x8adbffff, REGISTRY_LACNIC     }, // 138.219.32.0    - 138.219.255.255
	{ 0x8adc0000, 0x8adcffff, REGISTRY_ARIN       }, // 138.220.0.0     - 138.220.255.255
	{ 0x8add0000, 0x8ae4ffff, REGISTRY_RIPENCC    }, // 138.221.0.0     - 138.228.255.255
	{ 0x8ae50000, 0x8ae6ffff, REGISTRY_ARIN       }, // 138.229.0.0     - 138.230.255.255
	{ 0x8ae70000, 0x8ae9ffff, REGISTRY_RIPENCC    }, // 138.231.0.0     - 138.233.255.255
	{ 0x8aea0000, 0x8aeaffff, REGISTRY_ARIN       }, // 138.234.0.0     - 138.234.255.255
	{ 0x8aeb0000, 0x8aebffff, REGISTRY_APNIC      }, // 138.235.0.0     - 138.235.255.255
	{ 0x8aec0000, 0x8aeeffff, REGISTRY_ARIN       }, // 138.236.0.0     - 138.238.255.255
	{ 0x8aef0000, 0x8aefffff, REGISTRY_APNIC      }, // 138.239.0.0     - 138.239.255.255
	{ 0x8af00000, 0x8af2ffff, REGISTRY_ARIN       }, // 138.240.0.0     - 138.242.255.255
	{ 0x8af30000, 0x8af3ffff, REGISTRY_APNIC      }, // 138.243.0.0     - 138.243.255.255
	{ 0x8af40000, 0x8af6ffff, REGISTRY_RIPENCC    }, // 138.244.0.0     - 138.246.255.255
	{ 0x8af70000, 0x8af7ffff, REGISTRY_ARIN       }, // 138.247.0.0     - 138.247.255.255
	{ 0x8af80000, 0x8afbffff, REGISTRY_RIPENCC    }, // 138.248.0.0     - 138.251.255.255
	{ 0x8afd0000, 0x8afdffff, REGISTRY_RIPENCC    }, // 138.253.0.0     - 138.253.255.255
	{ 0x8afe0000, 0x8afeffff, REGISTRY_ARIN       }, // 138.254.0.0     - 138.254.255.255
	{ 0x8aff0000, 0x8aff33ff, REGISTRY_LACNIC     }, // 138.255.0.0     - 138.255.51.255
	{ 0x8aff3800, 0x8affffff, REGISTRY_LACNIC     }, // 138.255.56.0    - 138.255.255.255
	{ 0x8b000000, 0x8b00ffff, REGISTRY_APNIC      }, // 139.0.0.0       - 139.0.255.255
	{ 0x8b010000, 0x8b04ffff, REGISTRY_RIPENCC    }, // 139.1.0.0       - 139.4.255.255
	{ 0x8b050000, 0x8b05ffff, REGISTRY_APNIC      }, // 139.5.0.0       - 139.5.255.255
	{ 0x8b060000, 0x8b08ffff, REGISTRY_RIPENCC    }, // 139.6.0.0       - 139.8.255.255
	{ 0x8b090000, 0x8b09ffff, REGISTRY_APNIC      }, // 139.9.0.0       - 139.9.255.255
	{ 0x8b0a0000, 0x8b0affff, REGISTRY_RIPENCC    }, // 139.10.0.0      - 139.10.255.255
	{ 0x8b0b0000, 0x8b0fffff, REGISTRY_RIPENCC    }, // 139.11.0.0      - 139.15.255.255
	{ 0x8b100000, 0x8b10ffff, REGISTRY_RIPENCC    }, // 139.16.0.0      - 139.16.255.255
	{ 0x8b110000, 0x8b14ffff, REGISTRY_RIPENCC    }, // 139.17.0.0      - 139.20.255.255
	{ 0x8b150000, 0x8b19ffff, REGISTRY_RIPENCC    }, // 139.21.0.0      - 139.25.255.255
	{ 0x8b1a0000, 0x8b1affff, REGISTRY_AFRINIC    }, // 139.26.0.0      - 139.26.255.255
	{ 0x8b1b0000, 0x8b1bffff, REGISTRY_RIPENCC    }, // 139.27.0.0      - 139.27.255.255
	{ 0x8b1c0000, 0x8b1cffff, REGISTRY_RIPENCC    }, // 139.28.0.0      - 139.28.255.255
	{ 0x8b1d0000, 0x8b1effff, REGISTRY_RIPENCC    }, // 139.29.0.0      - 139.30.255.255
	{ 0x8b1f0000, 0x8b2bffff, REGISTRY_ARIN       }, // 139.31.0.0      - 139.43.255.255
	{ 0x8b2c0000, 0x8b2cffff, REGISTRY_APNIC      }, // 139.44.0.0      - 139.44.255.255
	{ 0x8b2d0000, 0x8b2dffff, REGISTRY_RIPENCC    }, // 139.45.0.0      - 139.45.255.255
	{ 0x8b2e0000, 0x8b2effff, REGISTRY_ARIN       }, // 139.46.0.0      - 139.46.255.255
	{ 0x8b2f0000, 0x8b2fffff, REGISTRY_RIPENCC    }, // 139.47.0.0      - 139.47.255.255
	{ 0x8b300000, 0x8b31ffff, REGISTRY_ARIN       }, // 139.48.0.0      - 139.49.255.255
	{ 0x8b320000, 0x8b32ffff, REGISTRY_RIPENCC    }, // 139.50.0.0      - 139.50.255.255
	{ 0x8b330000, 0x8b34ffff, REGISTRY_ARIN       }, // 139.51.0.0      - 139.52.255.255
	{ 0x8b350000, 0x8b35ffff, REGISTRY_AFRINIC    }, // 139.53.0.0      - 139.53.255.255
	{ 0x8b360000, 0x8b36ffff, REGISTRY_RIPENCC    }, // 139.54.0.0      - 139.54.255.255
	{ 0x8b370000, 0x8b39ffff, REGISTRY_ARIN       }, // 139.55.0.0      - 139.57.255.255
	{ 0x8b3a0000, 0x8b3affff, REGISTRY_RIPENCC    }, // 139.58.0.0      - 139.58.255.255
	{ 0x8b3b0000, 0x8b3bffff, REGISTRY_APNIC      }, // 139.59.0.0      - 139.59.255.255
	{ 0x8b3c0000, 0x8b3effff, REGISTRY_ARIN       }, // 139.60.0.0      - 139.62.255.255
	{ 0x8b3f0000, 0x8b3fffff, REGISTRY_RIPENCC    }, // 139.63.0.0      - 139.63.255.255
	{ 0x8b400000, 0x8b407fff, REGISTRY_RIPENCC    }, // 139.64.0.0      - 139.64.127.255
	{ 0x8b408000, 0x8b41ffff, REGISTRY_ARIN       }, // 139.64.128.0    - 139.65.255.255
	{ 0x8b420000, 0x8b42ffff, REGISTRY_RIPENCC    }, // 139.66.0.0      - 139.66.255.255
	{ 0x8b430000, 0x8b49ffff, REGISTRY_ARIN       }, // 139.67.0.0      - 139.73.255.255
	{ 0x8b4a0000, 0x8b4bffff, REGISTRY_RIPENCC    }, // 139.74.0.0      - 139.75.255.255
	{ 0x8b4c0000, 0x8b4effff, REGISTRY_ARIN       }, // 139.76.0.0      - 139.78.255.255
	{ 0x8b4f0000, 0x8b4fffff, REGISTRY_RIPENCC    }, // 139.79.0.0      - 139.79.255.255
	{ 0x8b500000, 0x8b50ffff, REGISTRY_APNIC      }, // 139.80.0.0      - 139.80.255.255
	{ 0x8b510000, 0x8b51ffff, REGISTRY_ARIN       }, // 139.81.0.0      - 139.81.255.255
	{ 0x8b520000, 0x8b52ffff, REGISTRY_LACNIC     }, // 139.82.0.0      - 139.82.255.255
	{ 0x8b530000, 0x8b53ffff, REGISTRY_RIPENCC    }, // 139.83.0.0      - 139.83.255.255
	{ 0x8b540000, 0x8b55ffff, REGISTRY_ARIN       }, // 139.84.0.0      - 139.85.255.255
	{ 0x8b560000, 0x8b56ffff, REGISTRY_APNIC      }, // 139.86.0.0      - 139.86.255.255
	{ 0x8b570000, 0x8b58ffff, REGISTRY_ARIN       }, // 139.87.0.0      - 139.88.255.255
	{ 0x8b590000, 0x8b5cffff, REGISTRY_RIPENCC    }, // 139.89.0.0      - 139.92.255.255
	{ 0x8b5d0000, 0x8b5fffff, REGISTRY_ARIN       }, // 139.93.0.0      - 139.95.255.255
	{ 0x8b600000, 0x8b60ffff, REGISTRY_RIPENCC    }, // 139.96.0.0      - 139.96.255.255
	{ 0x8b610000, 0x8b61ffff, REGISTRY_RIPENCC    }, // 139.97.0.0      - 139.97.255.255
	{ 0x8b620000, 0x8b62ffff, REGISTRY_RIPENCC    }, // 139.98.0.0      - 139.98.255.255
	{ 0x8b630000, 0x8b63ffff, REGISTRY_ARIN       }, // 139.99.0.0      - 139.99.255.255
	{ 0x8b640000, 0x8b64ffff, REGISTRY_RIPENCC    }, // 139.100.0.0     - 139.100.255.255
	{ 0x8b650000, 0x8b65ffff, REGISTRY_APNIC      }, // 139.101.0.0     - 139.101.255.255
	{ 0x8b660000, 0x8b68ffff, REGISTRY_ARIN       }, // 139.102.0.0     - 139.104.255.255
	{ 0x8b690000, 0x8b78ffff, REGISTRY_RIPENCC    }, // 139.105.0.0     - 139.120.255.255
	{ 0x8b790000, 0x8b79ffff, REGISTRY_ARIN       }, // 139.121.0.0     - 139.121.255.255
	{ 0x8b7a0000, 0x8b7cffff, REGISTRY_RIPENCC    }, // 139.122.0.0     - 139.124.255.255
	{ 0x8b7d0000, 0x8b7fffff, REGISTRY_ARIN       }, // 139.125.0.0     - 139.127.255.255
	{ 0x8b800000, 0x8b80ffff, REGISTRY_RIPENCC    }, // 139.128.0.0     - 139.128.255.255
	{ 0x8b810000, 0x8b82ffff, REGISTRY_APNIC      }, // 139.129.0.0     - 139.130.255.255
	{ 0x8b830000, 0x8b83ffff, REGISTRY_ARIN       }, // 139.131.0.0     - 139.131.255.255
	{ 0x8b840000, 0x8b84ffff, REGISTRY_APNIC      }, // 139.132.0.0     - 139.132.255.255
	{ 0x8b850000, 0x8b85ffff, REGISTRY_RIPENCC    }, // 139.133.0.0     - 139.133.255.255
	{ 0x8b860000, 0x8b86ffff, REGISTRY_APNIC      }, // 139.134.0.0     - 139.134.255.255
	{ 0x8b870000, 0x8b8abfff, REGISTRY_ARIN       }, // 139.135.0.0     - 139.138.191.255
	{ 0x8b8ac000, 0x8b8adfff, REGISTRY_RIPENCC    }, // 139.138.192.0   - 139.138.223.255
	{ 0x8b8ae000, 0x8b8cffff, REGISTRY_ARIN       }, // 139.138.224.0   - 139.140.255.255
	{ 0x8b8d0000, 0x8b8dffff, REGISTRY_RIPENCC    }, // 139.141.0.0     - 139.141.255.255
	{ 0x8b8e0000, 0x8b8effff, REGISTRY_ARIN       }, // 139.142.0.0     - 139.142.255.255
	{ 0x8b8f0000, 0x8b8fffff, REGISTRY_RIPENCC    }, // 139.143.0.0     - 139.143.255.255
	{ 0x8b900000, 0x8b90ffff, REGISTRY_ARIN       }, // 139.144.0.0     - 139.144.255.255
	{ 0x8b910000, 0x8b91ffff, REGISTRY_RIPENCC    }, // 139.145.0.0     - 139.145.255.255
	{ 0x8b920000, 0x8b93ffff, REGISTRY_ARIN       }, // 139.146.0.0     - 139.147.255.255
	{ 0x8b940000, 0x8b94ffff, REGISTRY_APNIC      }, // 139.148.0.0     - 139.148.255.255
	{ 0x8b950000, 0x8b95ffff, REGISTRY_RIPENCC    }, // 139.149.0.0     - 139.149.255.255
	{ 0x8b960000, 0x8b96ffff, REGISTRY_APNIC      }, // 139.150.0.0     - 139.150.255.255
	{ 0x8b970000, 0x8b97ffff, REGISTRY_ARIN       }, // 139.151.0.0     - 139.151.255.255
	{ 0x8b980000, 0x8b98ffff, REGISTRY_APNIC      }, // 139.152.0.0     - 139.152.255.255
	{ 0x8b990000, 0x8b99ffff, REGISTRY_RIPENCC    }, // 139.153.0.0     - 139.153.255.255
	{ 0x8b9a0000, 0x8b9bffff, REGISTRY_APNIC      }, // 139.154.0.0     - 139.155.255.255
	{ 0x8b9c0000, 0x8b9effff, REGISTRY_RIPENCC    }, // 139.156.0.0     - 139.158.255.255
	{ 0x8b9f0000, 0x8b9fffff, REGISTRY_APNIC      }, // 139.159.0.0     - 139.159.255.255
	{ 0x8ba00000, 0x8ba0ffff, REGISTRY_RIPENCC    }, // 139.160.0.0     - 139.160.255.255
	{ 0x8ba10000, 0x8ba1ffff, REGISTRY_ARIN       }, // 139.161.0.0     - 139.161.255.255
	{ 0x8ba20000, 0x8ba2ffff, REGISTRY_RIPENCC    }, // 139.162.0.0     - 139.162.255.255
	{ 0x8ba30000, 0x8ba3ffff, REGISTRY_APNIC      }, // 139.163.0.0     - 139.163.255.255
	{ 0x8ba40000, 0x8ba6ffff, REGISTRY_RIPENCC    }, // 139.164.0.0     - 139.166.255.255
	{ 0x8ba70000, 0x8ba8ffff, REGISTRY_APNIC      }, // 139.167.0.0     - 139.168.255.255
	{ 0x8ba90000, 0x8ba9ffff, REGISTRY_ARIN       }, // 139.169.0.0     - 139.169.255.255
	{ 0x8baa0000, 0x8baaffff, REGISTRY_APNIC      }, // 139.170.0.0     - 139.170.255.255
	{ 0x8bab0000, 0x8badffff, REGISTRY_ARIN       }, // 139.171.0.0     - 139.173.255.255
	{ 0x8bae0000, 0x8baeffff, REGISTRY_RIPENCC    }, // 139.174.0.0     - 139.174.255.255
	{ 0x8baf0000, 0x8bb0ffff, REGISTRY_APNIC      }, // 139.175.0.0     - 139.176.255.255
	{ 0x8bb10000, 0x8bb1ffff, REGISTRY_ARIN       }, // 139.177.0.0     - 139.177.255.255
	{ 0x8bb20000, 0x8bb23fff, REGISTRY_RIPENCC    }, // 139.178.0.0     - 139.178.63.255
	{ 0x8bb24000, 0x8bb3ffff, REGISTRY_RIPENCC    }, // 139.178.64.0    - 139.179.255.255
	{ 0x8bb40000, 0x8bb407ff, REGISTRY_ARIN       }, // 139.180.0.0     - 139.180.7.255
	{ 0x8bb40800, 0x8bb40fff, REGISTRY_APNIC      }, // 139.180.8.0     - 139.180.15.255
	{ 0x8bb41000, 0x8bb43fff, REGISTRY_ARIN       }, // 139.180.16.0    - 139.180.63.255
	{ 0x8bb44000, 0x8bb4dfff, REGISTRY_APNIC      }, // 139.180.64.0    - 139.180.223.255
	{ 0x8bb4e000, 0x8bb6ffff, REGISTRY_ARIN       }, // 139.180.224.0   - 139.182.255.255
	{ 0x8bb70000, 0x8bb7ffff, REGISTRY_APNIC      }, // 139.183.0.0     - 139.183.255.255
	{ 0x8bb80000, 0x8bb8ffff, REGISTRY_RIPENCC    }, // 139.184.0.0     - 139.184.255.255
	{ 0x8bb90000, 0x8bb9ffff, REGISTRY_ARIN       }, // 139.185.0.0     - 139.185.255.255
	{ 0x8bba0000, 0x8bbaffff, REGISTRY_APNIC      }, // 139.186.0.0     - 139.186.255.255
	{ 0x8bbb0000, 0x8bbbffff, REGISTRY_ARIN       }, // 139.187.0.0     - 139.187.255.255
	{ 0x8bbc0000, 0x8bbeffff, REGISTRY_APNIC      }, // 139.188.0.0     - 139.190.255.255
	{ 0x8bbf0000, 0x8bbfffff, REGISTRY_RIPENCC    }, // 139.191.0.0     - 139.191.255.255
	{ 0x8bc00000, 0x8bddffff, REGISTRY_APNIC      }, // 139.192.0.0     - 139.221.255.255
	{ 0x8bde0000, 0x8bdeffff, REGISTRY_RIPENCC    }, // 139.222.0.0     - 139.222.255.255
	{ 0x8bdf0000, 0x8be0ffff, REGISTRY_APNIC      }, // 139.223.0.0     - 139.224.255.255
	{ 0x8be10000, 0x8be1ffff, REGISTRY_ARIN       }, // 139.225.0.0     - 139.225.255.255
	{ 0x8be20000, 0x8be4ffff, REGISTRY_APNIC      }, // 139.226.0.0     - 139.228.255.255
	{ 0x8be50000, 0x8be5ffff, REGISTRY_ARIN       }, // 139.229.0.0     - 139.229.255.255
	{ 0x8be60000, 0x8be6ffff, REGISTRY_APNIC      }, // 139.230.0.0     - 139.230.255.255
	{ 0x8be70000, 0x8bfeffff, REGISTRY_ARIN       }, // 139.231.0.0     - 139.254.255.255
	{ 0x8bff0000, 0x8c00ffff, REGISTRY_APNIC      }, // 139.255.0.0     - 140.0.255.255
	{ 0x8c010000, 0x8c4affff, REGISTRY_ARIN       }, // 140.1.0.0       - 140.74.255.255
	{ 0x8c4b0000, 0x8c4bffff, REGISTRY_APNIC      }, // 140.75.0.0      - 140.75.255.255
	{ 0x8c4c0000, 0x8c4cffff, REGISTRY_ARIN       }, // 140.76.0.0      - 140.76.255.255
	{ 0x8c4d0000, 0x8c4effff, REGISTRY_RIPENCC    }, // 140.77.0.0      - 140.78.255.255
	{ 0x8c4f0000, 0x8c4fffff, REGISTRY_APNIC      }, // 140.79.0.0      - 140.79.255.255
	{ 0x8c500000, 0x8c50ffff, REGISTRY_ARIN       }, // 140.80.0.0      - 140.80.255.255
	{ 0x8c520000, 0x8c52bfff, REGISTRY_ARIN       }, // 140.82.0.0      - 140.82.191.255
	{ 0x8c52c000, 0x8c52cfff, REGISTRY_APNIC      }, // 140.82.192.0    - 140.82.207.255
	{ 0x8c52d000, 0x8c52ffff, REGISTRY_ARIN       }, // 140.82.208.0    - 140.82.255.255
	{ 0x8c530000, 0x8c53ffff, REGISTRY_APNIC      }, // 140.83.0.0      - 140.83.255.255
	{ 0x8c540000, 0x8c56ffff, REGISTRY_RIPENCC    }, // 140.84.0.0      - 140.86.255.255
	{ 0x8c570000, 0x8c5bffff, REGISTRY_ARIN       }, // 140.87.0.0      - 140.91.255.255
	{ 0x8c5c0000, 0x8c5cffff, REGISTRY_APNIC      }, // 140.92.0.0      - 140.92.255.255
	{ 0x8c5d0000, 0x8c5effff, REGISTRY_RIPENCC    }, // 140.93.0.0      - 140.94.255.255
	{ 0x8c5f0000, 0x8c5fffff, REGISTRY_ARIN       }, // 140.95.0.0      - 140.95.255.255
	{ 0x8c600000, 0x8c60ffff, REGISTRY_APNIC      }, // 140.96.0.0      - 140.96.255.255
	{ 0x8c610000, 0x8c61ffff, REGISTRY_RIPENCC    }, // 140.97.0.0      - 140.97.255.255
	{ 0x8c620000, 0x8c68ffff, REGISTRY_ARIN       }, // 140.98.0.0      - 140.104.255.255
	{ 0x8c690000, 0x8c69ffff, REGISTRY_RIPENCC    }, // 140.105.0.0     - 140.105.255.255
	{ 0x8c6a0000, 0x8c6cffff, REGISTRY_ARIN       }, // 140.106.0.0     - 140.108.255.255
	{ 0x8c6d0000, 0x8c8affff, REGISTRY_APNIC      }, // 140.109.0.0     - 140.138.255.255
	{ 0x8c8b0000, 0x8c8effff, REGISTRY_ARIN       }, // 140.139.0.0     - 140.142.255.255
	{ 0x8c8f0000, 0x8c8fffff, REGISTRY_APNIC      }, // 140.143.0.0     - 140.143.255.255
	{ 0x8c900000, 0x8c93ffff, REGISTRY_ARIN       }, // 140.144.0.0     - 140.147.255.255
	{ 0x8c940000, 0x8c94ffff, REGISTRY_LACNIC     }, // 140.148.0.0     - 140.148.255.255
	{ 0x8c950000, 0x8c95ffff, REGISTRY_APNIC      }, // 140.149.0.0     - 140.149.255.255
	{ 0x8c960000, 0x8c97ffff, REGISTRY_RIPENCC    }, // 140.150.0.0     - 140.151.255.255
	{ 0x8c980000, 0x8c9effff, REGISTRY_ARIN       }, // 140.152.0.0     - 140.158.255.255
	{ 0x8c9f0000, 0x8c9fffff, REGISTRY_APNIC      }, // 140.159.0.0     - 140.159.255.255
	{ 0x8ca00000, 0x8ca3ffff, REGISTRY_ARIN       }, // 140.160.0.0     - 140.163.255.255
	{ 0x8ca40000, 0x8ca4ffff, REGISTRY_RIPENCC    }, // 140.164.0.0     - 140.164.255.255
	{ 0x8ca50000, 0x8ca5ffff, REGISTRY_ARIN       }, // 140.165.0.0     - 140.165.255.255
	{ 0x8ca60000, 0x8ca6ffff, REGISTRY_RIPENCC    }, // 140.166.0.0     - 140.166.255.255
	{ 0x8ca70000, 0x8ca7ffff, REGISTRY_ARIN       }, // 140.167.0.0     - 140.167.255.255
	{ 0x8ca80000, 0x8ca8ffff, REGISTRY_APNIC      }, // 140.168.0.0     - 140.168.255.255
	{ 0x8ca90000, 0x8cb2ffff, REGISTRY_ARIN       }, // 140.169.0.0     - 140.178.255.255
	{ 0x8cb30000, 0x8cb3ffff, REGISTRY_APNIC      }, // 140.179.0.0     - 140.179.255.255
	{ 0x8cb40000, 0x8cb4ffff, REGISTRY_ARIN       }, // 140.180.0.0     - 140.180.255.255
	{ 0x8cb50000, 0x8cb5ffff, REGISTRY_RIPENCC    }, // 140.181.0.0     - 140.181.255.255
	{ 0x8cb60000, 0x8cbeffff, REGISTRY_ARIN       }, // 140.182.0.0     - 140.190.255.255
	{ 0x8cbf0000, 0x8cbfffff, REGISTRY_LACNIC     }, // 140.191.0.0     - 140.191.255.255
	{ 0x8cc00000, 0x8cc7ffff, REGISTRY_ARIN       }, // 140.192.0.0     - 140.199.255.255
	{ 0x8cc80000, 0x8cc8ffff, REGISTRY_APNIC      }, // 140.200.0.0     - 140.200.255.255
	{ 0x8cc90000, 0x8ccaffff, REGISTRY_ARIN       }, // 140.201.0.0     - 140.202.255.255
	{ 0x8ccb0000, 0x8ccbffff, REGISTRY_RIPENCC    }, // 140.203.0.0     - 140.203.255.255
	{ 0x8ccc0000, 0x8cccffff, REGISTRY_ARIN       }, // 140.204.0.0     - 140.204.255.255
	{ 0x8ccd0000, 0x8ccfffff, REGISTRY_APNIC      }, // 140.205.0.0     - 140.207.255.255
	{ 0x8cd00000, 0x8cd1ffff, REGISTRY_ARIN       }, // 140.208.0.0     - 140.209.255.255
	{ 0x8cd20000, 0x8cd2ffff, REGISTRY_APNIC      }, // 140.210.0.0     - 140.210.255.255
	{ 0x8cd30000, 0x8cd4ffff, REGISTRY_ARIN       }, // 140.211.0.0     - 140.212.255.255
	{ 0x8cd50000, 0x8cd5ffff, REGISTRY_APNIC      }, // 140.213.0.0     - 140.213.255.255
	{ 0x8cd60000, 0x8cdfffff, REGISTRY_ARIN       }, // 140.214.0.0     - 140.223.255.255
	{ 0x8ce00000, 0x8ce0ffff, REGISTRY_APNIC      }, // 140.224.0.0     - 140.224.255.255
	{ 0x8ce10000, 0x8ce2ffff, REGISTRY_ARIN       }, // 140.225.0.0     - 140.226.255.255
	{ 0x8ce30000, 0x8ce3ffff, REGISTRY_APNIC      }, // 140.227.0.0     - 140.227.255.255
	{ 0x8ce40000, 0x8ce6ffff, REGISTRY_ARIN       }, // 140.228.0.0     - 140.230.255.255
	{ 0x8ce70000, 0x8ce7ffff, REGISTRY_RIPENCC    }, // 140.231.0.0     - 140.231.255.255
	{ 0x8ce80000, 0x8cecffff, REGISTRY_ARIN       }, // 140.232.0.0     - 140.236.255.255
	{ 0x8ced0000, 0x8cedffff, REGISTRY_APNIC      }, // 140.237.0.0     - 140.237.255.255
	{ 0x8cee0000, 0x8cefffff, REGISTRY_ARIN       }, // 140.238.0.0     - 140.239.255.255
	{ 0x8cf00000, 0x8cf0ffff, REGISTRY_APNIC      }, // 140.240.0.0     - 140.240.255.255
	{ 0x8cf10000, 0x8cf2ffff, REGISTRY_ARIN       }, // 140.241.0.0     - 140.242.255.255
	{ 0x8cf30000, 0x8cf3ffff, REGISTRY_APNIC      }, // 140.243.0.0     - 140.243.255.255
	{ 0x8cf40000, 0x8cf5ffff, REGISTRY_ARIN       }, // 140.244.0.0     - 140.245.255.255
	{ 0x8cf60000, 0x8cf6ffff, REGISTRY_APNIC      }, // 140.246.0.0     - 140.246.255.255
	{ 0x8cf70000, 0x8cf8ffff, REGISTRY_ARIN       }, // 140.247.0.0     - 140.248.255.255
	{ 0x8cf90000, 0x8cfaffff, REGISTRY_APNIC      }, // 140.249.0.0     - 140.250.255.255
	{ 0x8cfb0000, 0x8cfcffff, REGISTRY_ARIN       }, // 140.251.0.0     - 140.252.255.255
	{ 0x8cfd0000, 0x8cfdffff, REGISTRY_APNIC      }, // 140.253.0.0     - 140.253.255.255
	{ 0x8cfe0000, 0x8cfeffff, REGISTRY_ARIN       }, // 140.254.0.0     - 140.254.255.255
	{ 0x8cff0000, 0x8cffffff, REGISTRY_APNIC      }, // 140.255.0.0     - 140.255.255.255
	{ 0x8d000000, 0x8d00ffff, REGISTRY_RIPENCC    }, // 141.0.0.0       - 141.0.255.255
	{ 0x8d010000, 0x8d07ffff, REGISTRY_RIPENCC    }, // 141.1.0.0       - 141.7.255.255
	{ 0x8d080000, 0x8d08ffff, REGISTRY_RIPENCC    }, // 141.8.0.0       - 141.8.255.255
	{ 0x8d090000, 0x8d1cffff, REGISTRY_RIPENCC    }, // 141.9.0.0       - 141.28.255.255
	{ 0x8d1d0000, 0x8d1dffff, REGISTRY_RIPENCC    }, // 141.29.0.0      - 141.29.255.255
	{ 0x8d1e0000, 0x8d48ffff, REGISTRY_RIPENCC    }, // 141.30.0.0      - 141.72.255.255
	{ 0x8d490000, 0x8d49ffff, REGISTRY_RIPENCC    }, // 141.73.0.0      - 141.73.255.255
	{ 0x8d4a0000, 0x8d55ffff, REGISTRY_RIPENCC    }, // 141.74.0.0      - 141.85.255.255
	{ 0x8d560000, 0x8d56ffff, REGISTRY_ARIN       }, // 141.86.0.0      - 141.86.255.255
	{ 0x8d570000, 0x8d5cffff, REGISTRY_RIPENCC    }, // 141.87.0.0      - 141.92.255.255
	{ 0x8d5d0000, 0x8d5fffff, REGISTRY_RIPENCC    }, // 141.93.0.0      - 141.95.255.255
	{ 0x8d600000, 0x8d60ffff, REGISTRY_RIPENCC    }, // 141.96.0.0      - 141.96.255.255
	{ 0x8d610000, 0x8d62ffff, REGISTRY_RIPENCC    }, // 141.97.0.0      - 141.98.255.255
	{ 0x8d630000, 0x8d64ffff, REGISTRY_RIPENCC    }, // 141.99.0.0      - 141.100.255.255
	{ 0x8d650000, 0x8d65ffff, REGISTRY_RIPENCC    }, // 141.101.0.0     - 141.101.255.255
	{ 0x8d660000, 0x8d66ffff, REGISTRY_ARIN       }, // 141.102.0.0     - 141.102.255.255
	{ 0x8d670000, 0x8d67ffff, REGISTRY_APNIC      }, // 141.103.0.0     - 141.103.255.255
	{ 0x8d680000, 0x8d68ffff, REGISTRY_ARIN       }, // 141.104.0.0     - 141.104.255.255
	{ 0x8d690000, 0x8d69ffff, REGISTRY_RIPENCC    }, // 141.105.0.0     - 141.105.255.255
	{ 0x8d6a0000, 0x8d6bffff, REGISTRY_ARIN       }, // 141.106.0.0     - 141.107.255.255
	{ 0x8d6c0000, 0x8d6cffff, REGISTRY_RIPENCC    }, // 141.108.0.0     - 141.108.255.255
	{ 0x8d6d0000, 0x8d70ffff, REGISTRY_ARIN       }, // 141.109.0.0     - 141.112.255.255
	{ 0x8d710000, 0x8d71ffff, REGISTRY_RIPENCC    }, // 141.113.0.0     - 141.113.255.255
	{ 0x8d720000, 0x8d72ffff, REGISTRY_ARIN       }, // 141.114.0.0     - 141.114.255.255
	{ 0x8d730000, 0x8d73ffff, REGISTRY_RIPENCC    }, // 141.115.0.0     - 141.115.255.255
	{ 0x8d740000, 0x8d77ffff, REGISTRY_ARIN       }, // 141.116.0.0     - 141.119.255.255
	{ 0x8d780000, 0x8d78ffff, REGISTRY_APNIC      }, // 141.120.0.0     - 141.120.255.255
	{ 0x8d790000, 0x8d7cffff, REGISTRY_ARIN       }, // 141.121.0.0     - 141.124.255.255
	{ 0x8d7d0000, 0x8d7dffff, REGISTRY_RIPENCC    }, // 141.125.0.0     - 141.125.255.255
	{ 0x8d7e0000, 0x8d81ffff, REGISTRY_ARIN       }, // 141.126.0.0     - 141.129.255.255
	{ 0x8d820000, 0x8d82ffff, REGISTRY_RIPENCC    }, // 141.130.0.0     - 141.130.255.255
	{ 0x8d830000, 0x8d83ffff, REGISTRY_ARIN       }, // 141.131.0.0     - 141.131.255.255
	{ 0x8d840000, 0x8d84ffff, REGISTRY_APNIC      }, // 141.132.0.0     - 141.132.255.255
	{ 0x8d850000, 0x8d85ffff, REGISTRY_ARIN       }, // 141.133.0.0     - 141.133.255.255
	{ 0x8d860000, 0x8d88ffff, REGISTRY_RIPENCC    }, // 141.134.0.0     - 141.136.255.255
	{ 0x8d890000, 0x8d89ffff, REGISTRY_RIPENCC    }, // 141.137.0.0     - 141.137.255.255
	{ 0x8d8a0000, 0x8d8affff, REGISTRY_RIPENCC    }, // 141.138.0.0     - 141.138.255.255
	{ 0x8d8b0000, 0x8d8effff, REGISTRY_ARIN       }, // 141.139.0.0     - 141.142.255.255
	{ 0x8d8f0000, 0x8d94ffff, REGISTRY_RIPENCC    }, // 141.143.0.0     - 141.148.255.255
	{ 0x8d950000, 0x8da2ffff, REGISTRY_ARIN       }, // 141.149.0.0     - 141.162.255.255
	{ 0x8da30000, 0x8da3ffff, REGISTRY_RIPENCC    }, // 141.163.0.0     - 141.163.255.255
	{ 0x8da40000, 0x8da47fff, REGISTRY_ARIN       }, // 141.164.0.0     - 141.164.127.255
	{ 0x8da48000, 0x8da4ffff, REGISTRY_RIPENCC    }, // 141.164.128.0   - 141.164.255.255
	{ 0x8da50000, 0x8da7ffff, REGISTRY_ARIN       }, // 141.165.0.0     - 141.167.255.255
	{ 0x8da80000, 0x8da8ffff, REGISTRY_APNIC      }, // 141.168.0.0     - 141.168.255.255
	{ 0x8da90000, 0x8da9ffff, REGISTRY_RIPENCC    }, // 141.169.0.0     - 141.169.255.255
	{ 0x8daa0000, 0x8daaffff, REGISTRY_RIPENCC    }, // 141.170.0.0     - 141.170.255.255
	{ 0x8dab0000, 0x8dacffff, REGISTRY_RIPENCC    }, // 141.171.0.0     - 141.172.255.255
	{ 0x8dad0000, 0x8daeffff, REGISTRY_ARIN       }, // 141.173.0.0     - 141.174.255.255
	{ 0x8daf0000, 0x8db0ffff, REGISTRY_RIPENCC    }, // 141.175.0.0     - 141.176.255.255
	{ 0x8db10000, 0x8db1ffff, REGISTRY_ARIN       }, // 141.177.0.0     - 141.177.255.255
	{ 0x8db20000, 0x8db2ffff, REGISTRY_APNIC      }, // 141.178.0.0     - 141.178.255.255
	{ 0x8db30000, 0x8dbfffff, REGISTRY_ARIN       }, // 141.179.0.0     - 141.191.255.255
	{ 0x8dc00000, 0x8dc0ffff, REGISTRY_RIPENCC    }, // 141.192.0.0     - 141.192.255.255
	{ 0x8dc10000, 0x8dc113ff, REGISTRY_ARIN       }, // 141.193.0.0     - 141.193.19.255
	{ 0x8dc11400, 0x8dc114ff, REGISTRY_RIPENCC    }, // 141.193.20.0    - 141.193.20.255
	{ 0x8dc11500, 0x8dc127ff, REGISTRY_ARIN       }, // 141.193.21.0    - 141.193.39.255
	{ 0x8dc12800, 0x8dc12bff, REGISTRY_APNIC      }, // 141.193.40.0    - 141.193.43.255
	{ 0x8dc12c00, 0x8dc16bff, REGISTRY_ARIN       }, // 141.193.44.0    - 141.193.107.255
	{ 0x8dc16c00, 0x8dc16fff, REGISTRY_RIPENCC    }, // 141.193.108.0   - 141.193.111.255
	{ 0x8dc17000, 0x8dc197ff, REGISTRY_ARIN       }, // 141.193.112.0   - 141.193.151.255
	{ 0x8dc19800, 0x8dc19fff, REGISTRY_APNIC      }, // 141.193.152.0   - 141.193.159.255
	{ 0x8dc1a000, 0x8dc1d5ff, REGISTRY_ARIN       }, // 141.193.160.0   - 141.193.213.255
	{ 0x8dc1d600, 0x8dc1d7ff, REGISTRY_RIPENCC    }, // 141.193.214.0   - 141.193.215.255
	{ 0x8dc1d800, 0x8dc1ffff, REGISTRY_ARIN       }, // 141.193.216.0   - 141.193.255.255
	{ 0x8dc20000, 0x8dc2ffff, REGISTRY_RIPENCC    }, // 141.194.0.0     - 141.194.255.255
	{ 0x8dc30000, 0x8dc3ffff, REGISTRY_ARIN       }, // 141.195.0.0     - 141.195.255.255
	{ 0x8dc40000, 0x8dc4ffff, REGISTRY_RIPENCC    }, // 141.196.0.0     - 141.196.255.255
	{ 0x8dc50000, 0x8dc7ffff, REGISTRY_ARIN       }, // 141.197.0.0     - 141.199.255.255
	{ 0x8dc80000, 0x8dc9ffff, REGISTRY_RIPENCC    }, // 141.200.0.0     - 141.201.255.255
	{ 0x8dca0000, 0x8dcaffff, REGISTRY_ARIN       }, // 141.202.0.0     - 141.202.255.255
	{ 0x8dcb0000, 0x8dcbffff, REGISTRY_RIPENCC    }, // 141.203.0.0     - 141.203.255.255
	{ 0x8dcc0000, 0x8dcfffff, REGISTRY_ARIN       }, // 141.204.0.0     - 141.207.255.255
	{ 0x8dd00000, 0x8dd0ffff, REGISTRY_RIPENCC    }, // 141.208.0.0     - 141.208.255.255
	{ 0x8dd10000, 0x8ddeffff, REGISTRY_ARIN       }, // 141.209.0.0     - 141.222.255.255
	{ 0x8ddf0000, 0x8ddfffff, REGISTRY_APNIC      }, // 141.223.0.0     - 141.223.255.255
	{ 0x8de00000, 0x8de1ffff, REGISTRY_ARIN       }, // 141.224.0.0     - 141.225.255.255
	{ 0x8de20000, 0x8de257ff, REGISTRY_RIPENCC    }, // 141.226.0.0     - 141.226.87.255
	{ 0x8de25800, 0x8de25fff, REGISTRY_RIPENCC    }, // 141.226.88.0    - 141.226.95.255
	{ 0x8de26000, 0x8de277ff, REGISTRY_RIPENCC    }, // 141.226.96.0    - 141.226.119.255
	{ 0x8de27800, 0x8de27bff, REGISTRY_RIPENCC    }, // 141.226.120.0   - 141.226.123.255
	{ 0x8de27c00, 0x8de287ff, REGISTRY_RIPENCC    }, // 141.226.124.0   - 141.226.135.255
	{ 0x8de28800, 0x8de28aff, REGISTRY_ARIN       }, // 141.226.136.0   - 141.226.138.255
	{ 0x8de28b00, 0x8de28bff, REGISTRY_RIPENCC    }, // 141.226.139.0   - 141.226.139.255
	{ 0x8de28c00, 0x8de28fff, REGISTRY_ARIN       }, // 141.226.140.0   - 141.226.143.255
	{ 0x8de29000, 0x8de2bfff, REGISTRY_RIPENCC    }, // 141.226.144.0   - 141.226.191.255
	{ 0x8de2c000, 0x8de2dfff, REGISTRY_RIPENCC    }, // 141.226.192.0   - 141.226.223.255
	{ 0x8de2e000, 0x8de2ebff, REGISTRY_RIPENCC    }, // 141.226.224.0   - 141.226.235.255
	{ 0x8de2ec00, 0x8de2ffff, REGISTRY_RIPENCC    }, // 141.226.236.0   - 141.226.255.255
	{ 0x8de30000, 0x8de4ffff, REGISTRY_RIPENCC    }, // 141.227.0.0     - 141.228.255.255
	{ 0x8de60000, 0x8de6ffff, REGISTRY_ARIN       }, // 141.230.0.0     - 141.230.255.255
	{ 0x8de70000, 0x8de7ffff, REGISTRY_RIPENCC    }, // 141.231.0.0     - 141.231.255.255
	{ 0x8de80000, 0x8decffff, REGISTRY_ARIN       }, // 141.232.0.0     - 141.236.255.255
	{ 0x8ded0000, 0x8dedffff, REGISTRY_RIPENCC    }, // 141.237.0.0     - 141.237.255.255
	{ 0x8dee0000, 0x8df0ffff, REGISTRY_ARIN       }, // 141.238.0.0     - 141.240.255.255
	{ 0x8df10000, 0x8df1ffff, REGISTRY_RIPENCC    }, // 141.241.0.0     - 141.241.255.255
	{ 0x8df20000, 0x8df2ffff, REGISTRY_ARIN       }, // 141.242.0.0     - 141.242.255.255
	{ 0x8df30000, 0x8df3ffff, REGISTRY_APNIC      }, // 141.243.0.0     - 141.243.255.255
	{ 0x8df40000, 0x8df5ffff, REGISTRY_RIPENCC    }, // 141.244.0.0     - 141.245.255.255
	{ 0x8df60000, 0x8df8ffff, REGISTRY_ARIN       }, // 141.246.0.0     - 141.248.255.255
	{ 0x8df90000, 0x8dfaffff, REGISTRY_RIPENCC    }, // 141.249.0.0     - 141.250.255.255
	{ 0x8dfb0000, 0x8dfbffff, REGISTRY_ARIN       }, // 141.251.0.0     - 141.251.255.255
	{ 0x8dfc0000, 0x8dfdffff, REGISTRY_RIPENCC    }, // 141.252.0.0     - 141.253.255.255
	{ 0x8dfe0000, 0x8dfeffff, REGISTRY_ARIN       }, // 141.254.0.0     - 141.254.255.255
	{ 0x8dff0000, 0x8dffffff, REGISTRY_RIPENCC    }, // 141.255.0.0     - 141.255.255.255
	{ 0x8e000000, 0x8e5b07ff, REGISTRY_ARIN       }, // 142.0.0.0       - 142.91.7.255
	{ 0x8e5b0800, 0x8e5b0fff, REGISTRY_RIPENCC    }, // 142.91.8.0      - 142.91.15.255
	{ 0x8e5b1000, 0x8e5b77ff, REGISTRY_ARIN       }, // 142.91.16.0     - 142.91.119.255
	{ 0x8e5b7800, 0x8e5b7fff, REGISTRY_RIPENCC    }, // 142.91.120.0    - 142.91.127.255
	{ 0x8e5b8000, 0x8e5b97ff, REGISTRY_ARIN       }, // 142.91.128.0    - 142.91.151.255
	{ 0x8e5b9800, 0x8e5b9fff, REGISTRY_RIPENCC    }, // 142.91.152.0    - 142.91.159.255
	{ 0x8e5ba000, 0x8e99ffff, REGISTRY_ARIN       }, // 142.91.160.0    - 142.153.255.255
	{ 0x8e9a0000, 0x8e9a7fff, REGISTRY_RIPENCC    }, // 142.154.0.0     - 142.154.127.255
	{ 0x8e9a8000, 0x8eea1fff, REGISTRY_ARIN       }, // 142.154.128.0   - 142.234.31.255
	{ 0x8eea2000, 0x8eea27ff, REGISTRY_RIPENCC    }, // 142.234.32.0    - 142.234.39.255
	{ 0x8eea2800, 0x8ef6ffff, REGISTRY_ARIN       }, // 142.234.40.0    - 142.246.255.255
	{ 0x8ef70000, 0x8ef7ffff, REGISTRY_RIPENCC    }, // 142.247.0.0     - 142.247.255.255
	{ 0x8ef80000, 0x8effffff, REGISTRY_ARIN       }, // 142.248.0.0     - 142.255.255.255
	{ 0x8f000000, 0x8f00efff, REGISTRY_LACNIC     }, // 143.0.0.0       - 143.0.239.255
	{ 0x8f00f400, 0x8f00ffff, REGISTRY_LACNIC     }, // 143.0.244.0     - 143.0.255.255
	{ 0x8f010000, 0x8f28ffff, REGISTRY_ARIN       }, // 143.1.0.0       - 143.40.255.255
	{ 0x8f290000, 0x8f29ffff, REGISTRY_RIPENCC    }, // 143.41.0.0      - 143.41.255.255
	{ 0x8f2a0000, 0x8f2effff, REGISTRY_ARIN       }, // 143.42.0.0      - 143.46.255.255
	{ 0x8f2f0000, 0x8f2fffff, REGISTRY_RIPENCC    }, // 143.47.0.0      - 143.47.255.255
	{ 0x8f300000, 0x8f31ffff, REGISTRY_ARIN       }, // 143.48.0.0      - 143.49.255.255
	{ 0x8f320000, 0x8f35ffff, REGISTRY_RIPENCC    }, // 143.50.0.0      - 143.53.255.255
	{ 0x8f360000, 0x8f36ffff, REGISTRY_LACNIC     }, // 143.54.0.0      - 143.54.255.255
	{ 0x8f370000, 0x8f3fffff, REGISTRY_ARIN       }, // 143.55.0.0      - 143.63.255.255
	{ 0x8f400000, 0x8f40ffff, REGISTRY_APNIC      }, // 143.64.0.0      - 143.64.255.255
	{ 0x8f410000, 0x8f41ffff, REGISTRY_RIPENCC    }, // 143.65.0.0      - 143.65.255.255
	{ 0x8f420000, 0x8f58ffff, REGISTRY_ARIN       }, // 143.66.0.0      - 143.88.255.255
	{ 0x8f590000, 0x8f5affff, REGISTRY_APNIC      }, // 143.89.0.0      - 143.90.255.255
	{ 0x8f5b0000, 0x8f5bffff, REGISTRY_ARIN       }, // 143.91.0.0      - 143.91.255.255
	{ 0x8f5c0000, 0x8f5c7fff, REGISTRY_APNIC      }, // 143.92.0.0      - 143.92.127.255
	{ 0x8f5c8000, 0x8f5cffff, REGISTRY_RIPENCC    }, // 143.92.128.0    - 143.92.255.255
	{ 0x8f5d0000, 0x8f5dffff, REGISTRY_RIPENCC    }, // 143.93.0.0      - 143.93.255.255
	{ 0x8f5e0000, 0x8f5effff, REGISTRY_APNIC      }, // 143.94.0.0      - 143.94.255.255
	{ 0x8f5f0000, 0x8f5fffff, REGISTRY_ARIN       }, // 143.95.0.0      - 143.95.255.255
	{ 0x8f600000, 0x8f60ffff, REGISTRY_APNIC      }, // 143.96.0.0      - 143.96.255.255
	{ 0x8f610000, 0x8f61ffff, REGISTRY_RIPENCC    }, // 143.97.0.0      - 143.97.255.255
	{ 0x8f620000, 0x8f62ffff, REGISTRY_ARIN       }, // 143.98.0.0      - 143.98.255.255
	{ 0x8f630000, 0x8f63ffff, REGISTRY_RIPENCC    }, // 143.99.0.0      - 143.99.255.255
	{ 0x8f640000, 0x8f69ffff, REGISTRY_ARIN       }, // 143.100.0.0     - 143.105.255.255
	{ 0x8f6a0000, 0x8f6cffff, REGISTRY_LACNIC     }, // 143.106.0.0     - 143.108.255.255
	{ 0x8f6d0000, 0x8f74ffff, REGISTRY_ARIN       }, // 143.109.0.0     - 143.116.255.255
	{ 0x8f750000, 0x8f76ffff, REGISTRY_RIPENCC    }, // 143.117.0.0     - 143.118.255.255
	{ 0x8f770000, 0x8f77ffff, REGISTRY_APNIC      }, // 143.119.0.0     - 143.119.255.255
	{ 0x8f780000, 0x8f78ffff, REGISTRY_ARIN       }, // 143.120.0.0     - 143.120.255.255
	{ 0x8f790000, 0x8f79ffff, REGISTRY_RIPENCC    }, // 143.121.0.0     - 143.121.255.255
	{ 0x8f7a0000, 0x8f7cffff, REGISTRY_ARIN       }, // 143.122.0.0     - 143.124.255.255
	{ 0x8f7d0000, 0x8f7dffff, REGISTRY_APNIC      }, // 143.125.0.0     - 143.125.255.255
	{ 0x8f7e0000, 0x8f7effff, REGISTRY_RIPENCC    }, // 143.126.0.0     - 143.126.255.255
	{ 0x8f7f0000, 0x8f7fffff, REGISTRY_ARIN       }, // 143.127.0.0     - 143.127.255.255
	{ 0x8f800000, 0x8f80ffff, REGISTRY_AFRINIC    }, // 143.128.0.0     - 143.128.255.255
	{ 0x8f810000, 0x8f82ffff, REGISTRY_RIPENCC    }, // 143.129.0.0     - 143.130.255.255
	{ 0x8f830000, 0x8f87ffff, REGISTRY_ARIN       }, // 143.131.0.0     - 143.135.255.255
	{ 0x8f880000, 0x8f88ffff, REGISTRY_APNIC      }, // 143.136.0.0     - 143.136.255.255
	{ 0x8f890000, 0x8f8923ff, REGISTRY_LACNIC     }, // 143.137.0.0     - 143.137.35.255
	{ 0x8f892800, 0x8f89abff, REGISTRY_LACNIC     }, // 143.137.40.0    - 143.137.171.255
	{ 0x8f89b000, 0x8f89ffff, REGISTRY_LACNIC     }, // 143.137.176.0   - 143.137.255.255
	{ 0x8f8a0000, 0x8f9fffff, REGISTRY_ARIN       }, // 143.138.0.0     - 143.159.255.255
	{ 0x8fa00000, 0x8fa0ffff, REGISTRY_AFRINIC    }, // 143.160.0.0     - 143.160.255.255
	{ 0x8fa10000, 0x8fa1ffff, REGISTRY_RIPENCC    }, // 143.161.0.0     - 143.161.255.255
	{ 0x8fa20000, 0x8fa2ffff, REGISTRY_ARIN       }, // 143.162.0.0     - 143.162.255.255
	{ 0x8fa30000, 0x8fa4ffff, REGISTRY_RIPENCC    }, // 143.163.0.0     - 143.164.255.255
	{ 0x8fa50000, 0x8fa6ffff, REGISTRY_ARIN       }, // 143.165.0.0     - 143.166.255.255
	{ 0x8fa70000, 0x8fa7ffff, REGISTRY_RIPENCC    }, // 143.167.0.0     - 143.167.255.255
	{ 0x8fa80000, 0x8fa8ffff, REGISTRY_ARIN       }, // 143.168.0.0     - 143.168.255.255
	{ 0x8fa90000, 0x8fa9ffff, REGISTRY_RIPENCC    }, // 143.169.0.0     - 143.169.255.255
	{ 0x8faa0000, 0x8faaffff, REGISTRY_ARIN       }, // 143.170.0.0     - 143.170.255.255
	{ 0x8fac0000, 0x8fadffff, REGISTRY_ARIN       }, // 143.172.0.0     - 143.173.255.255
	{ 0x8fae0000, 0x8faeffff, REGISTRY_APNIC      }, // 143.174.0.0     - 143.174.255.255
	{ 0x8faf0000, 0x8fafffff, REGISTRY_ARIN       }, // 143.175.0.0     - 143.175.255.255
	{ 0x8fb00000, 0x8fb4ffff, REGISTRY_RIPENCC    }, // 143.176.0.0     - 143.180.255.255
	{ 0x8fb50000, 0x8fbbffff, REGISTRY_ARIN       }, // 143.181.0.0     - 143.187.255.255
	{ 0x8fbc0000, 0x8fbdffff, REGISTRY_APNIC      }, // 143.188.0.0     - 143.189.255.255
	{ 0x8fbe0000, 0x8fc05fff, REGISTRY_ARIN       }, // 143.190.0.0     - 143.192.95.255
	{ 0x8fc06000, 0x8fc07fff, REGISTRY_APNIC      }, // 143.192.96.0    - 143.192.127.255
	{ 0x8fc08000, 0x8fc3ffff, REGISTRY_ARIN       }, // 143.192.128.0   - 143.195.255.255
	{ 0x8fc40000, 0x8fc4ffff, REGISTRY_RIPENCC    }, // 143.196.0.0     - 143.196.255.255
	{ 0x8fc50000, 0x8fc8ffff, REGISTRY_ARIN       }, // 143.197.0.0     - 143.200.255.255
	{ 0x8fca0000, 0x8fcaffff, REGISTRY_LACNIC     }, // 143.202.0.0     - 143.202.255.255
	{ 0x8fcb0000, 0x8fccffff, REGISTRY_ARIN       }, // 143.203.0.0     - 143.204.255.255
	{ 0x8fcd0000, 0x8fcdffff, REGISTRY_RIPENCC    }, // 143.205.0.0     - 143.205.255.255
	{ 0x8fce0000, 0x8fcfffff, REGISTRY_ARIN       }, // 143.206.0.0     - 143.207.255.255
	{ 0x8fd00000, 0x8fd02fff, REGISTRY_LACNIC     }, // 143.208.0.0     - 143.208.47.255
	{ 0x8fd03400, 0x8fd0ffff, REGISTRY_LACNIC     }, // 143.208.52.0    - 143.208.255.255
	{ 0x8fd10000, 0x8fd1ffff, REGISTRY_ARIN       }, // 143.209.0.0     - 143.209.255.255
	{ 0x8fd20000, 0x8fd2ffff, REGISTRY_RIPENCC    }, // 143.210.0.0     - 143.210.255.255
	{ 0x8fd30000, 0x8fd7ffff, REGISTRY_ARIN       }, // 143.211.0.0     - 143.215.255.255
	{ 0x8fd80000, 0x8fd8ffff, REGISTRY_APNIC      }, // 143.216.0.0     - 143.216.255.255
	{ 0x8fd90000, 0x8fd9ffff, REGISTRY_RIPENCC    }, // 143.217.0.0     - 143.217.255.255
	{ 0x8fda0000, 0x8fdaffff, REGISTRY_APNIC      }, // 143.218.0.0     - 143.218.255.255
	{ 0x8fdb0000, 0x8fdcffff, REGISTRY_ARIN       }, // 143.219.0.0     - 143.220.255.255
	{ 0x8fdd0000, 0x8fddffff, REGISTRY_APNIC      }, // 143.221.0.0     - 143.221.255.255
	{ 0x8fde0000, 0x8fdfffff, REGISTRY_ARIN       }, // 143.222.0.0     - 143.223.255.255
	{ 0x8fe00000, 0x8fe1ffff, REGISTRY_RIPENCC    }, // 143.224.0.0     - 143.225.255.255
	{ 0x8fe20000, 0x8fe8ffff, REGISTRY_ARIN       }, // 143.226.0.0     - 143.232.255.255
	{ 0x8fe90000, 0x8feaffff, REGISTRY_RIPENCC    }, // 143.233.0.0     - 143.234.255.255
	{ 0x8feb0000, 0x8fecffff, REGISTRY_ARIN       }, // 143.235.0.0     - 143.236.255.255
	{ 0x8fed0000, 0x8fedffff, REGISTRY_RIPENCC    }, // 143.237.0.0     - 143.237.255.255
	{ 0x8fee0000, 0x8feeffff, REGISTRY_APNIC      }, // 143.238.0.0     - 143.238.255.255
	{ 0x8fef0000, 0x8fefffff, REGISTRY_RIPENCC    }, // 143.239.0.0     - 143.239.255.255
	{ 0x8ff00000, 0x8ff4ffff, REGISTRY_ARIN       }, // 143.240.0.0     - 143.244.255.255
	{ 0x8ff50000, 0x8ff5ffff, REGISTRY_RIPENCC    }, // 143.245.0.0     - 143.245.255.255
	{ 0x8ff60000, 0x8ff7ffff, REGISTRY_ARIN       }, // 143.246.0.0     - 143.247.255.255
	{ 0x8ff80000, 0x8ff8ffff, REGISTRY_APNIC      }, // 143.248.0.0     - 143.248.255.255
	{ 0x8ff90000, 0x8ffbffff, REGISTRY_ARIN       }, // 143.249.0.0     - 143.251.255.255
	{ 0x8ffc0000, 0x8ffcffff, REGISTRY_RIPENCC    }, // 143.252.0.0     - 143.252.255.255
	{ 0x8ffd0000, 0x8ffdffff, REGISTRY_APNIC      }, // 143.253.0.0     - 143.253.255.255
	{ 0x8ffe0000, 0x8ffeffff, REGISTRY_ARIN       }, // 143.254.0.0     - 143.254.255.255
	{ 0x8fff0000, 0x8fffb3ff, REGISTRY_LACNIC     }, // 143.255.0.0     - 143.255.179.255
	{ 0x8fffb800, 0x8fffffff, REGISTRY_LACNIC     }, // 143.255.184.0   - 143.255.255.255
	{ 0x90000000, 0x9000ffff, REGISTRY_APNIC      }, // 144.0.0.0       - 144.0.255.255
	{ 0x90020000, 0x9002ffff, REGISTRY_RIPENCC    }, // 144.2.0.0       - 144.2.255.255
	{ 0x90030000, 0x9003ffff, REGISTRY_ARIN       }, // 144.3.0.0       - 144.3.255.255
	{ 0x90040000, 0x9004ffff, REGISTRY_RIPENCC    }, // 144.4.0.0       - 144.4.255.255
	{ 0x90050000, 0x9005ffff, REGISTRY_ARIN       }, // 144.5.0.0       - 144.5.255.255
	{ 0x90060000, 0x9007ffff, REGISTRY_APNIC      }, // 144.6.0.0       - 144.7.255.255
	{ 0x90080000, 0x900bffff, REGISTRY_ARIN       }, // 144.8.0.0       - 144.11.255.255
	{ 0x900c0000, 0x900cffff, REGISTRY_APNIC      }, // 144.12.0.0      - 144.12.255.255
	{ 0x900d0000, 0x900fffff, REGISTRY_ARIN       }, // 144.13.0.0      - 144.15.255.255
	{ 0x90100000, 0x9010ffff, REGISTRY_APNIC      }, // 144.16.0.0      - 144.16.255.255
	{ 0x90110000, 0x9013ffff, REGISTRY_ARIN       }, // 144.17.0.0      - 144.19.255.255
	{ 0x90140000, 0x9015ffff, REGISTRY_RIPENCC    }, // 144.20.0.0      - 144.21.255.255
	{ 0x90160000, 0x9017ffff, REGISTRY_LACNIC     }, // 144.22.0.0      - 144.23.255.255
	{ 0x90180000, 0x9018ffff, REGISTRY_RIPENCC    }, // 144.24.0.0      - 144.24.255.255
	{ 0x90190000, 0x901affff, REGISTRY_ARIN       }, // 144.25.0.0      - 144.26.255.255
	{ 0x901b0000, 0x901bffff, REGISTRY_RIPENCC    }, // 144.27.0.0      - 144.27.255.255
	{ 0x901c0000, 0x901fffff, REGISTRY_ARIN       }, // 144.28.0.0      - 144.31.255.255
	{ 0x90200000, 0x9020ffff, REGISTRY_RIPENCC    }, // 144.32.0.0      - 144.32.255.255
	{ 0x90210000, 0x902445ff, REGISTRY_ARIN       }, // 144.33.0.0      - 144.36.69.255
	{ 0x90244600, 0x902449ff, REGISTRY_APNIC      }, // 144.36.70.0     - 144.36.73.255
	{ 0x90244a00, 0x902467ff, REGISTRY_ARIN       }, // 144.36.74.0     - 144.36.103.255
	{ 0x90246800, 0x902468ff, REGISTRY_APNIC      }, // 144.36.104.0    - 144.36.104.255
	{ 0x90246900, 0x90247fff, REGISTRY_ARIN       }, // 144.36.105.0    - 144.36.127.255
	{ 0x90248000, 0x902481ff, REGISTRY_APNIC      }, // 144.36.128.0    - 144.36.129.255
	{ 0x90248200, 0x902485ff, REGISTRY_ARIN       }, // 144.36.130.0    - 144.36.133.255
	{ 0x90248600, 0x902487ff, REGISTRY_APNIC      }, // 144.36.134.0    - 144.36.135.255
	{ 0x90248800, 0x90248bff, REGISTRY_ARIN       }, // 144.36.136.0    - 144.36.139.255
	{ 0x90248c00, 0x90248dff, REGISTRY_APNIC      }, // 144.36.140.0    - 144.36.141.255
	{ 0x90248e00, 0x90248fff, REGISTRY_ARIN       }, // 144.36.142.0    - 144.36.143.255
	{ 0x90249000, 0x902491ff, REGISTRY_APNIC      }, // 144.36.144.0    - 144.36.145.255
	{ 0x90249200, 0x902493ff, REGISTRY_ARIN       }, // 144.36.146.0    - 144.36.147.255
	{ 0x90249400, 0x902495ff, REGISTRY_APNIC      }, // 144.36.148.0    - 144.36.149.255
	{ 0x90249600, 0x9024afff, REGISTRY_ARIN       }, // 144.36.150.0    - 144.36.175.255
	{ 0x9024b000, 0x9024b0ff, REGISTRY_APNIC      }, // 144.36.176.0    - 144.36.176.255
	{ 0x9024b100, 0x9024b1ff, REGISTRY_ARIN       }, // 144.36.177.0    - 144.36.177.255
	{ 0x9024b200, 0x9024b2ff, REGISTRY_APNIC      }, // 144.36.178.0    - 144.36.178.255
	{ 0x9024b300, 0x9024b5ff, REGISTRY_ARIN       }, // 144.36.179.0    - 144.36.181.255
	{ 0x9024b600, 0x9024b9ff, REGISTRY_APNIC      }, // 144.36.182.0    - 144.36.185.255
	{ 0x9024ba00, 0x9024bbff, REGISTRY_ARIN       }, // 144.36.186.0    - 144.36.187.255
	{ 0x9024bc00, 0x9024bdff, REGISTRY_APNIC      }, // 144.36.188.0    - 144.36.189.255
	{ 0x9024be00, 0x9024cdff, REGISTRY_ARIN       }, // 144.36.190.0    - 144.36.205.255
	{ 0x9024ce00, 0x9024cfff, REGISTRY_APNIC      }, // 144.36.206.0    - 144.36.207.255
	{ 0x9024d000, 0x9024d1ff, REGISTRY_ARIN       }, // 144.36.208.0    - 144.36.209.255
	{ 0x9024d200, 0x9024d3ff, REGISTRY_APNIC      }, // 144.36.210.0    - 144.36.211.255
	{ 0x9024d400, 0x9024d5ff, REGISTRY_ARIN       }, // 144.36.212.0    - 144.36.213.255
	{ 0x9024d600, 0x9024d9ff, REGISTRY_APNIC      }, // 144.36.214.0    - 144.36.217.255
	{ 0x9024da00, 0x9024dbff, REGISTRY_ARIN       }, // 144.36.218.0    - 144.36.219.255
	{ 0x9024dc00, 0x9024ecff, REGISTRY_APNIC      }, // 144.36.220.0    - 144.36.236.255
	{ 0x9024ed00, 0x9024f3ff, REGISTRY_ARIN       }, // 144.36.237.0    - 144.36.243.255
	{ 0x9024f400, 0x9024f5ff, REGISTRY_APNIC      }, // 144.36.244.0    - 144.36.245.255
	{ 0x9024f600, 0x9024f7ff, REGISTRY_ARIN       }, // 144.36.246.0    - 144.36.247.255
	{ 0x9024f800, 0x9024fbff, REGISTRY_APNIC      }, // 144.36.248.0    - 144.36.251.255
	{ 0x9024fc00, 0x9024fdff, REGISTRY_ARIN       }, // 144.36.252.0    - 144.36.253.255
	{ 0x9024fe00, 0x9024ffff, REGISTRY_APNIC      }, // 144.36.254.0    - 144.36.255.255
	{ 0x90250000, 0x9028ffff, REGISTRY_ARIN       }, // 144.37.0.0      - 144.40.255.255
	{ 0x90290000, 0x9029ffff, REGISTRY_RIPENCC    }, // 144.41.0.0      - 144.41.255.255
	{ 0x902a0000, 0x902affff, REGISTRY_ARIN       }, // 144.42.0.0      - 144.42.255.255
	{ 0x902b0000, 0x902cffff, REGISTRY_RIPENCC    }, // 144.43.0.0      - 144.44.255.255
	{ 0x902d0000, 0x902fffff, REGISTRY_ARIN       }, // 144.45.0.0      - 144.47.255.255
	{ 0x90300000, 0x90300bff, REGISTRY_APNIC      }, // 144.48.0.0      - 144.48.11.255
	{ 0x90301000, 0x90303bff, REGISTRY_APNIC      }, // 144.48.16.0     - 144.48.59.255
	{ 0x90303c00, 0x90303fff, REGISTRY_RIPENCC    }, // 144.48.60.0     - 144.48.63.255
	{ 0x90304000, 0x9030abff, REGISTRY_APNIC      }, // 144.48.64.0     - 144.48.171.255
	{ 0x9030b000, 0x9030ffff, REGISTRY_APNIC      }, // 144.48.176.0    - 144.48.255.255
	{ 0x90310000, 0x9033ffff, REGISTRY_ARIN       }, // 144.49.0.0      - 144.51.255.255
	{ 0x90340000, 0x9035ffff, REGISTRY_APNIC      }, // 144.52.0.0      - 144.53.255.255
	{ 0x90360000, 0x9036ffff, REGISTRY_RIPENCC    }, // 144.54.0.0      - 144.54.255.255
	{ 0x90370000, 0x9037ffff, REGISTRY_APNIC      }, // 144.55.0.0      - 144.55.255.255
	{ 0x90380000, 0x9039ffff, REGISTRY_RIPENCC    }, // 144.56.0.0      - 144.57.255.255
	{ 0x903a0000, 0x903effff, REGISTRY_ARIN       }, // 144.58.0.0      - 144.62.255.255
	{ 0x903f0000, 0x903fffff, REGISTRY_RIPENCC    }, // 144.63.0.0      - 144.63.255.255
	{ 0x90400000, 0x9040ffff, REGISTRY_RIPENCC    }, // 144.64.0.0      - 144.64.255.255
	{ 0x90410000, 0x9041ffff, REGISTRY_RIPENCC    }, // 144.65.0.0      - 144.65.255.255
	{ 0x90420000, 0x9042ffff, REGISTRY_APNIC      }, // 144.66.0.0      - 144.66.255.255
	{ 0x90430000, 0x904bffff, REGISTRY_ARIN       }, // 144.67.0.0      - 144.75.255.255
	{ 0x904c0000, 0x904cffff, REGISTRY_RIPENCC    }, // 144.76.0.0      - 144.76.255.255
	{ 0x904d0000, 0x904effff, REGISTRY_ARIN       }, // 144.77.0.0      - 144.78.255.255
	{ 0x90500000, 0x9051ffff, REGISTRY_ARIN       }, // 144.80.0.0      - 144.81.255.255
	{ 0x90520000, 0x9052ffff, REGISTRY_RIPENCC    }, // 144.82.0.0      - 144.82.255.255
	{ 0x90530000, 0x9053ffff, REGISTRY_ARIN       }, // 144.83.0.0      - 144.83.255.255
	{ 0x90540000, 0x9055ffff, REGISTRY_RIPENCC    }, // 144.84.0.0      - 144.85.255.255
	{ 0x90560000, 0x90567fff, REGISTRY_RIPENCC    }, // 144.86.0.0      - 144.86.127.255
	{ 0x90568000, 0x9056ffff, REGISTRY_ARIN       }, // 144.86.128.0    - 144.86.255.255
	{ 0x90570000, 0x9057ffff, REGISTRY_RIPENCC    }, // 144.87.0.0      - 144.87.255.255
	{ 0x90580000, 0x905effff, REGISTRY_ARIN       }, // 144.88.0.0      - 144.94.255.255
	{ 0x905f0000, 0x905fffff, REGISTRY_RIPENCC    }, // 144.95.0.0      - 144.95.255.255
	{ 0x90600000, 0x9060ffff, REGISTRY_ARIN       }, // 144.96.0.0      - 144.96.255.255
	{ 0x90610000, 0x9061ffff, REGISTRY_APNIC      }, // 144.97.0.0      - 144.97.255.255
	{ 0x90620000, 0x9062ffff, REGISTRY_RIPENCC    }, // 144.98.0.0      - 144.98.255.255
	{ 0x90630000, 0x906dffff, REGISTRY_ARIN       }, // 144.99.0.0      - 144.109.255.255
	{ 0x906e0000, 0x906effff, REGISTRY_APNIC      }, // 144.110.0.0     - 144.110.255.255
	{ 0x906f0000, 0x9076ffff, REGISTRY_ARIN       }, // 144.111.0.0     - 144.118.255.255
	{ 0x90770000, 0x9077ffff, REGISTRY_RIPENCC    }, // 144.119.0.0     - 144.119.255.255
	{ 0x90780000, 0x9078ffff, REGISTRY_APNIC      }, // 144.120.0.0     - 144.120.255.255
	{ 0x90790000, 0x9079ffff, REGISTRY_ARIN       }, // 144.121.0.0     - 144.121.255.255
	{ 0x907a0000, 0x907affff, REGISTRY_RIPENCC    }, // 144.122.0.0     - 144.122.255.255
	{ 0x907b0000, 0x907bffff, REGISTRY_APNIC      }, // 144.123.0.0     - 144.123.255.255
	{ 0x907c0000, 0x907cffff, REGISTRY_RIPENCC    }, // 144.124.0.0     - 144.124.255.255
	{ 0x907d0000, 0x907effff, REGISTRY_ARIN       }, // 144.125.0.0     - 144.126.255.255
	{ 0x907f0000, 0x907fffff, REGISTRY_RIPENCC    }, // 144.127.0.0     - 144.127.255.255
	{ 0x90800000, 0x9081ffff, REGISTRY_ARIN       }, // 144.128.0.0     - 144.129.255.255
	{ 0x90820000, 0x908cffff, REGISTRY_APNIC      }, // 144.130.0.0     - 144.140.255.255
	{ 0x908d0000, 0x9090ffff, REGISTRY_ARIN       }, // 144.141.0.0     - 144.144.255.255
	{ 0x90910000, 0x9091ffff, REGISTRY_RIPENCC    }, // 144.145.0.0     - 144.145.255.255
	{ 0x90920000, 0x90a3ffff, REGISTRY_ARIN       }, // 144.146.0.0     - 144.163.255.255
	{ 0x90a40000, 0x90a5ffff, REGISTRY_RIPENCC    }, // 144.164.0.0     - 144.165.255.255
	{ 0x90a60000, 0x90acffff, REGISTRY_ARIN       }, // 144.166.0.0     - 144.172.255.255
	{ 0x90ad0000, 0x90adffff, REGISTRY_RIPENCC    }, // 144.173.0.0     - 144.173.255.255
	{ 0x90ae0000, 0x90afffff, REGISTRY_ARIN       }, // 144.174.0.0     - 144.175.255.255
	{ 0x90b00000, 0x90b5ffff, REGISTRY_RIPENCC    }, // 144.176.0.0     - 144.181.255.255
	{ 0x90b60000, 0x90c0ffff, REGISTRY_ARIN       }, // 144.182.0.0     - 144.192.255.255
	{ 0x90c10000, 0x90c1ffff, REGISTRY_RIPENCC    }, // 144.193.0.0     - 144.193.255.255
	{ 0x90c20000, 0x90c6ffff, REGISTRY_ARIN       }, // 144.194.0.0     - 144.198.255.255
	{ 0x90c70000, 0x90c7ffff, REGISTRY_APNIC      }, // 144.199.0.0     - 144.199.255.255
	{ 0x90c80000, 0x90c8ffff, REGISTRY_RIPENCC    }, // 144.200.0.0     - 144.200.255.255
	{ 0x90c90000, 0x90cbffff, REGISTRY_ARIN       }, // 144.201.0.0     - 144.203.255.255
	{ 0x90cc0000, 0x90ccffff, REGISTRY_RIPENCC    }, // 144.204.0.0     - 144.204.255.255
	{ 0x90cd0000, 0x90cdffff, REGISTRY_APNIC      }, // 144.205.0.0     - 144.205.255.255
	{ 0x90ce0000, 0x90ceffff, REGISTRY_RIPENCC    }, // 144.206.0.0     - 144.206.255.255
	{ 0x90cf0000, 0x90cfffff, REGISTRY_ARIN       }, // 144.207.0.0     - 144.207.255.255
	{ 0x90d00000, 0x90d03fff, REGISTRY_RIPENCC    }, // 144.208.0.0     - 144.208.63.255
	{ 0x90d04000, 0x90d07fff, REGISTRY_ARIN       }, // 144.208.64.0    - 144.208.127.255
	{ 0x90d08000, 0x90d1ffff, REGISTRY_RIPENCC    }, // 144.208.128.0   - 144.209.255.255
	{ 0x90d20000, 0x90d4ffff, REGISTRY_ARIN       }, // 144.210.0.0     - 144.212.255.255
	{ 0x90d50000, 0x90d6ffff, REGISTRY_APNIC      }, // 144.213.0.0     - 144.214.255.255
	{ 0x90d70000, 0x90d9ffff, REGISTRY_ARIN       }, // 144.215.0.0     - 144.217.255.255
	{ 0x90db0000, 0x90f7ffff, REGISTRY_ARIN       }, // 144.219.0.0     - 144.247.255.255
	{ 0x90f80000, 0x90f8ffff, REGISTRY_RIPENCC    }, // 144.248.0.0     - 144.248.255.255
	{ 0x90f90000, 0x90feffff, REGISTRY_ARIN       }, // 144.249.0.0     - 144.254.255.255
	{ 0x90ff0000, 0x90ffffff, REGISTRY_APNIC      }, // 144.255.0.0     - 144.255.255.255
	{ 0x91000000, 0x910e3fff, REGISTRY_RIPENCC    }, // 145.0.0.0       - 145.14.63.255
	{ 0x910e4000, 0x910e7fff, REGISTRY_RIPENCC    }, // 145.14.64.0     - 145.14.127.255
	{ 0x910e8000, 0x9151ffff, REGISTRY_RIPENCC    }, // 145.14.128.0    - 145.81.255.255
	{ 0x91520000, 0x9152ffff, REGISTRY_RIPENCC    }, // 145.82.0.0      - 145.82.255.255
	{ 0x91530000, 0x91e3ffff, REGISTRY_RIPENCC    }, // 145.83.0.0      - 145.227.255.255
	{ 0x91e40000, 0x91e4ffff, REGISTRY_RIPENCC    }, // 145.228.0.0     - 145.228.255.255
	{ 0x91e50000, 0x91e8ffff, REGISTRY_RIPENCC    }, // 145.229.0.0     - 145.232.255.255
	{ 0x91e90000, 0x91e9ffff, REGISTRY_RIPENCC    }, // 145.233.0.0     - 145.233.255.255
	{ 0x91ea0000, 0x91eeffff, REGISTRY_RIPENCC    }, // 145.234.0.0     - 145.238.255.255
	{ 0x91ef0000, 0x91efffff, REGISTRY_RIPENCC    }, // 145.239.0.0     - 145.239.255.255
	{ 0x91f00000, 0x91fcffff, REGISTRY_RIPENCC    }, // 145.240.0.0     - 145.252.255.255
	{ 0x91fd0000, 0x9200ffff, REGISTRY_RIPENCC    }, // 145.253.0.0     - 146.0.255.255
	{ 0x92010000, 0x9201ffff, REGISTRY_ARIN       }, // 146.1.0.0       - 146.1.255.255
	{ 0x92020000, 0x9203ffff, REGISTRY_RIPENCC    }, // 146.2.0.0       - 146.3.255.255
	{ 0x92040000, 0x9204ffff, REGISTRY_RIPENCC    }, // 146.4.0.0       - 146.4.255.255
	{ 0x92050000, 0x920affff, REGISTRY_ARIN       }, // 146.5.0.0       - 146.10.255.255
	{ 0x920b0000, 0x920bffff, REGISTRY_APNIC      }, // 146.11.0.0      - 146.11.255.255
	{ 0x920c0000, 0x9212ffff, REGISTRY_ARIN       }, // 146.12.0.0      - 146.18.255.255
	{ 0x92130000, 0x9213ffff, REGISTRY_RIPENCC    }, // 146.19.0.0      - 146.19.255.255
	{ 0x92140000, 0x9214ffff, REGISTRY_ARIN       }, // 146.20.0.0      - 146.20.255.255
	{ 0x92150000, 0x9215ffff, REGISTRY_RIPENCC    }, // 146.21.0.0      - 146.21.255.255
	{ 0x92160000, 0x922fffff, REGISTRY_ARIN       }, // 146.22.0.0      - 146.47.255.255
	{ 0x92300000, 0x9230ffff, REGISTRY_RIPENCC    }, // 146.48.0.0      - 146.48.255.255
	{ 0x92310000, 0x9231ffff, REGISTRY_ARIN       }, // 146.49.0.0      - 146.49.255.255
	{ 0x92320000, 0x9232ffff, REGISTRY_RIPENCC    }, // 146.50.0.0      - 146.50.255.255
	{ 0x92330000, 0x9233ffff, REGISTRY_APNIC      }, // 146.51.0.0      - 146.51.255.255
	{ 0x92340000, 0x9234ffff, REGISTRY_RIPENCC    }, // 146.52.0.0      - 146.52.255.255
	{ 0x92350000, 0x9237ffff, REGISTRY_ARIN       }, // 146.53.0.0      - 146.55.255.255
	{ 0x92380000, 0x9238ffff, REGISTRY_APNIC      }, // 146.56.0.0      - 146.56.255.255
	{ 0x92390000, 0x923affff, REGISTRY_ARIN       }, // 146.57.0.0      - 146.58.255.255
	{ 0x923b0000, 0x923bffff, REGISTRY_RIPENCC    }, // 146.59.0.0      - 146.59.255.255
	{ 0x923c0000, 0x923cffff, REGISTRY_RIPENCC    }, // 146.60.0.0      - 146.60.255.255
	{ 0x923d0000, 0x923dffff, REGISTRY_ARIN       }, // 146.61.0.0      - 146.61.255.255
	{ 0x923f0000, 0x923fffff, REGISTRY_ARIN       }, // 146.63.0.0      - 146.63.255.255
	{ 0x92400000, 0x9240ffff, REGISTRY_AFRINIC    }, // 146.64.0.0      - 146.64.255.255
	{ 0x92410000, 0x9241ffff, REGISTRY_ARIN       }, // 146.65.0.0      - 146.65.255.255
	{ 0x92420000, 0x9242ffff, REGISTRY_RIPENCC    }, // 146.66.0.0      - 146.66.255.255
	{ 0x92430000, 0x9243ffff, REGISTRY_RIPENCC    }, // 146.67.0.0      - 146.67.255.255
	{ 0x92440000, 0x9245ffff, REGISTRY_ARIN       }, // 146.68.0.0      - 146.69.255.255
	{ 0x92460000, 0x9246ffff, REGISTRY_RIPENCC    }, // 146.70.0.0      - 146.70.255.255
	{ 0x92470000, 0x92475dff, REGISTRY_ARIN       }, // 146.71.0.0      - 146.71.93.255
	{ 0x92475e00, 0x92475fff, REGISTRY_RIPENCC    }, // 146.71.94.0     - 146.71.95.255
	{ 0x92476000, 0x9247ffff, REGISTRY_ARIN       }, // 146.71.96.0     - 146.71.255.255
	{ 0x92480000, 0x9248ffff, REGISTRY_RIPENCC    }, // 146.72.0.0      - 146.72.255.255
	{ 0x92490000, 0x924affff, REGISTRY_ARIN       }, // 146.73.0.0      - 146.74.255.255
	{ 0x924b0000, 0x924bffff, REGISTRY_RIPENCC    }, // 146.75.0.0      - 146.75.255.255
	{ 0x924c0000, 0x924cffff, REGISTRY_ARIN       }, // 146.76.0.0      - 146.76.255.255
	{ 0x924d0000, 0x924dffff, REGISTRY_RIPENCC    }, // 146.77.0.0      - 146.77.255.255
	{ 0x924e0000, 0x924fffff, REGISTRY_ARIN       }, // 146.78.0.0      - 146.79.255.255
	{ 0x92500000, 0x9251ffff, REGISTRY_RIPENCC    }, // 146.80.0.0      - 146.81.255.255
	{ 0x92520000, 0x9252ffff, REGISTRY_ARIN       }, // 146.82.0.0      - 146.82.255.255
	{ 0x92530000, 0x9253ffff, REGISTRY_LACNIC     }, // 146.83.0.0      - 146.83.255.255
	{ 0x92540000, 0x9256ffff, REGISTRY_ARIN       }, // 146.84.0.0      - 146.86.255.255
	{ 0x92570000, 0x9257ffff, REGISTRY_RIPENCC    }, // 146.87.0.0      - 146.87.255.255
	{ 0x92580000, 0x92580fff, REGISTRY_ARIN       }, // 146.88.0.0      - 146.88.15.255
	{ 0x92581000, 0x92581cff, REGISTRY_APNIC      }, // 146.88.16.0     - 146.88.28.255
	{ 0x92581d00, 0x92581fff, REGISTRY_ARIN       }, // 146.88.29.0     - 146.88.31.255
	{ 0x92582000, 0x92585fff, REGISTRY_APNIC      }, // 146.88.32.0     - 146.88.95.255
	{ 0x92586000, 0x92587fff, REGISTRY_ARIN       }, // 146.88.96.0     - 146.88.127.255
	{ 0x92588000, 0x925887ff, REGISTRY_APNIC      }, // 146.88.128.0    - 146.88.135.255
	{ 0x92588800, 0x92588fff, REGISTRY_ARIN       }, // 146.88.136.0    - 146.88.143.255
	{ 0x92589000, 0x925893ff, REGISTRY_APNIC      }, // 146.88.144.0    - 146.88.147.255
	{ 0x92589400, 0x925897ff, REGISTRY_ARIN       }, // 146.88.148.0    - 146.88.151.255
	{ 0x92589800, 0x9258afff, REGISTRY_APNIC      }, // 146.88.152.0    - 146.88.175.255
	{ 0x9258b000, 0x9258c3ff, REGISTRY_ARIN       }, // 146.88.176.0    - 146.88.195.255
	{ 0x9258c400, 0x9258cfff, REGISTRY_APNIC      }, // 146.88.196.0    - 146.88.207.255
	{ 0x9258d000, 0x9258e7ff, REGISTRY_ARIN       }, // 146.88.208.0    - 146.88.231.255
	{ 0x9258e800, 0x9258efff, REGISTRY_RIPENCC    }, // 146.88.232.0    - 146.88.239.255
	{ 0x9258f000, 0x9259ffff, REGISTRY_ARIN       }, // 146.88.240.0    - 146.89.255.255
	{ 0x925a0000, 0x925affff, REGISTRY_RIPENCC    }, // 146.90.0.0      - 146.90.255.255
	{ 0x925b0000, 0x9260ffff, REGISTRY_ARIN       }, // 146.91.0.0      - 146.96.255.255
	{ 0x92610000, 0x9261ffff, REGISTRY_RIPENCC    }, // 146.97.0.0      - 146.97.255.255
	{ 0x92620000, 0x9262ffff, REGISTRY_ARIN       }, // 146.98.0.0      - 146.98.255.255
	{ 0x92630000, 0x9263ffff, REGISTRY_APNIC      }, // 146.99.0.0      - 146.99.255.255
	{ 0x92640000, 0x926cffff, REGISTRY_RIPENCC    }, // 146.100.0.0     - 146.108.255.255
	{ 0x926d0000, 0x926dffff, REGISTRY_RIPENCC    }, // 146.109.0.0     - 146.109.255.255
	{ 0x926e0000, 0x926effff, REGISTRY_RIPENCC    }, // 146.110.0.0     - 146.110.255.255
	{ 0x926f0000, 0x926fffff, REGISTRY_ARIN       }, // 146.111.0.0     - 146.111.255.255
	{ 0x92700000, 0x9270ffff, REGISTRY_RIPENCC    }, // 146.112.0.0     - 146.112.255.255
	{ 0x92710000, 0x9273ffff, REGISTRY_ARIN       }, // 146.113.0.0     - 146.115.255.255
	{ 0x92740000, 0x9274ffff, REGISTRY_APNIC      }, // 146.116.0.0     - 146.116.255.255
	{ 0x92760000, 0x9276ffff, REGISTRY_APNIC      }, // 146.118.0.0     - 146.118.255.255
	{ 0x92770000, 0x9277ffff, REGISTRY_RIPENCC    }, // 146.119.0.0     - 146.119.255.255
	{ 0x92780000, 0x9278ffff, REGISTRY_RIPENCC    }, // 146.120.0.0     - 146.120.255.255
	{ 0x92790000, 0x927bffff, REGISTRY_ARIN       }, // 146.121.0.0     - 146.123.255.255
	{ 0x927c0000, 0x927cffff, REGISTRY_RIPENCC    }, // 146.124.0.0     - 146.124.255.255
	{ 0x927d0000, 0x9284ffff, REGISTRY_ARIN       }, // 146.125.0.0     - 146.132.255.255
	{ 0x92850000, 0x9285ffff, REGISTRY_RIPENCC    }, // 146.133.0.0     - 146.133.255.255
	{ 0x92860000, 0x9286ffff, REGISTRY_LACNIC     }, // 146.134.0.0     - 146.134.255.255
	{ 0x92870000, 0x9287ffff, REGISTRY_ARIN       }, // 146.135.0.0     - 146.135.255.255
	{ 0x92880000, 0x9288ffff, REGISTRY_RIPENCC    }, // 146.136.0.0     - 146.136.255.255
	{ 0x92890000, 0x928bffff, REGISTRY_ARIN       }, // 146.137.0.0     - 146.139.255.255
	{ 0x928c0000, 0x928cffff, REGISTRY_RIPENCC    }, // 146.140.0.0     - 146.140.255.255
	{ 0x928d0000, 0x928dffff, REGISTRY_AFRINIC    }, // 146.141.0.0     - 146.141.255.255
	{ 0x928e0000, 0x928fffff, REGISTRY_ARIN       }, // 146.142.0.0     - 146.143.255.255
	{ 0x92910000, 0x929affff, REGISTRY_ARIN       }, // 146.145.0.0     - 146.154.255.255
	{ 0x929b0000, 0x929bffff, REGISTRY_LACNIC     }, // 146.155.0.0     - 146.155.255.255
	{ 0x929c0000, 0x929dffff, REGISTRY_ARIN       }, // 146.156.0.0     - 146.157.255.255
	{ 0x929e0000, 0x929effff, REGISTRY_RIPENCC    }, // 146.158.0.0     - 146.158.255.255
	{ 0x929f0000, 0x929fffff, REGISTRY_RIPENCC    }, // 146.159.0.0     - 146.159.255.255
	{ 0x92a00000, 0x92a0ffff, REGISTRY_APNIC      }, // 146.160.0.0     - 146.160.255.255
	{ 0x92a10000, 0x92a2ffff, REGISTRY_RIPENCC    }, // 146.161.0.0     - 146.162.255.255
	{ 0x92a30000, 0x92a3ffff, REGISTRY_ARIN       }, // 146.163.0.0     - 146.163.255.255
	{ 0x92a40000, 0x92a4ffff, REGISTRY_LACNIC     }, // 146.164.0.0     - 146.164.255.255
	{ 0x92a50000, 0x92a8ffff, REGISTRY_ARIN       }, // 146.165.0.0     - 146.168.255.255
	{ 0x92a90000, 0x92a9ffff, REGISTRY_RIPENCC    }, // 146.169.0.0     - 146.169.255.255
	{ 0x92aa0000, 0x92aaffff, REGISTRY_ARIN       }, // 146.170.0.0     - 146.170.255.255
	{ 0x92ab0000, 0x92abffff, REGISTRY_APNIC      }, // 146.171.0.0     - 146.171.255.255
	{ 0x92ac0000, 0x92adffff, REGISTRY_RIPENCC    }, // 146.172.0.0     - 146.173.255.255
	{ 0x92ae0000, 0x92aeffff, REGISTRY_ARIN       }, // 146.174.0.0     - 146.174.255.255
	{ 0x92af0000, 0x92b1ffff, REGISTRY_RIPENCC    }, // 146.175.0.0     - 146.177.255.255
	{ 0x92b20000, 0x92b2ffff, REGISTRY_APNIC      }, // 146.178.0.0     - 146.178.255.255
	{ 0x92b30000, 0x92b3ffff, REGISTRY_RIPENCC    }, // 146.179.0.0     - 146.179.255.255
	{ 0x92b40000, 0x92b5ffff, REGISTRY_ARIN       }, // 146.180.0.0     - 146.181.255.255
	{ 0x92b60000, 0x92b6ffff, REGISTRY_AFRINIC    }, // 146.182.0.0     - 146.182.255.255
	{ 0x92b70000, 0x92b8ffff, REGISTRY_ARIN       }, // 146.183.0.0     - 146.184.255.255
	{ 0x92b90000, 0x92b9ffff, REGISTRY_RIPENCC    }, // 146.185.0.0     - 146.185.255.255
	{ 0x92ba0000, 0x92bbffff, REGISTRY_ARIN       }, // 146.186.0.0     - 146.187.255.255
	{ 0x92bc0000, 0x92bcffff, REGISTRY_RIPENCC    }, // 146.188.0.0     - 146.188.255.255
	{ 0x92bd0000, 0x92beffff, REGISTRY_ARIN       }, // 146.189.0.0     - 146.190.255.255
	{ 0x92bf0000, 0x92c2ffff, REGISTRY_RIPENCC    }, // 146.191.0.0     - 146.194.255.255
	{ 0x92c30000, 0x92c47fff, REGISTRY_APNIC      }, // 146.195.0.0     - 146.196.127.255
	{ 0x92c48000, 0x92c4ffff, REGISTRY_AFRINIC    }, // 146.196.128.0   - 146.196.255.255
	{ 0x92c50000, 0x92d1ffff, REGISTRY_ARIN       }, // 146.197.0.0     - 146.209.255.255
	{ 0x92d20000, 0x92d3ffff, REGISTRY_RIPENCC    }, // 146.210.0.0     - 146.211.255.255
	{ 0x92d40000, 0x92d4ffff, REGISTRY_RIPENCC    }, // 146.212.0.0     - 146.212.255.255
	{ 0x92d50000, 0x92d5ffff, REGISTRY_RIPENCC    }, // 146.213.0.0     - 146.213.255.255
	{ 0x92d60000, 0x92d7ffff, REGISTRY_ARIN       }, // 146.214.0.0     - 146.215.255.255
	{ 0x92d80000, 0x92d8ffff, REGISTRY_RIPENCC    }, // 146.216.0.0     - 146.216.255.255
	{ 0x92d90000, 0x92daffff, REGISTRY_ARIN       }, // 146.217.0.0     - 146.218.255.255
	{ 0x92db0000, 0x92dcffff, REGISTRY_RIPENCC    }, // 146.219.0.0     - 146.220.255.255
	{ 0x92dd0000, 0x92ddffff, REGISTRY_APNIC      }, // 146.221.0.0     - 146.221.255.255
	{ 0x92de0000, 0x92dfffff, REGISTRY_ARIN       }, // 146.222.0.0     - 146.223.255.255
	{ 0x92e00000, 0x92e0ffff, REGISTRY_RIPENCC    }, // 146.224.0.0     - 146.224.255.255
	{ 0x92e10000, 0x92e2ffff, REGISTRY_ARIN       }, // 146.225.0.0     - 146.226.255.255
	{ 0x92e30000, 0x92e4ffff, REGISTRY_RIPENCC    }, // 146.227.0.0     - 146.228.255.255
	{ 0x92e50000, 0x92e5ffff, REGISTRY_ARIN       }, // 146.229.0.0     - 146.229.255.255
	{ 0x92e60000, 0x92e8ffff, REGISTRY_AFRINIC    }, // 146.230.0.0     - 146.232.255.255
	{ 0x92e90000, 0x92e9ffff, REGISTRY_ARIN       }, // 146.233.0.0     - 146.233.255.255
	{ 0x92ea0000, 0x92eaffff, REGISTRY_RIPENCC    }, // 146.234.0.0     - 146.234.255.255
	{ 0x92eb0000, 0x92f0ffff, REGISTRY_ARIN       }, // 146.235.0.0     - 146.240.255.255
	{ 0x92f10000, 0x92f1ffff, REGISTRY_RIPENCC    }, // 146.241.0.0     - 146.241.255.255
	{ 0x92f20000, 0x92f6ffff, REGISTRY_ARIN       }, // 146.242.0.0     - 146.246.255.255
	{ 0x92f70000, 0x92f7ffff, REGISTRY_RIPENCC    }, // 146.247.0.0     - 146.247.255.255
	{ 0x92f80000, 0x92f9ffff, REGISTRY_RIPENCC    }, // 146.248.0.0     - 146.249.255.255
	{ 0x92fa0000, 0x92faffff, REGISTRY_ARIN       }, // 146.250.0.0     - 146.250.255.255
	{ 0x92fb0000, 0x92fbffff, REGISTRY_RIPENCC    }, // 146.251.0.0     - 146.251.255.255
	{ 0x92fc0000, 0x92fcffff, REGISTRY_ARIN       }, // 146.252.0.0     - 146.252.255.255
	{ 0x92fd0000, 0x92ffffff, REGISTRY_RIPENCC    }, // 146.253.0.0     - 146.255.255.255
	{ 0x93000000, 0x9305ffff, REGISTRY_ARIN       }, // 147.0.0.0       - 147.5.255.255
	{ 0x93060000, 0x9306ffff, REGISTRY_APNIC      }, // 147.6.0.0       - 147.6.255.255
	{ 0x93070000, 0x9307ffff, REGISTRY_RIPENCC    }, // 147.7.0.0       - 147.7.255.255
	{ 0x93080000, 0x9308ffff, REGISTRY_APNIC      }, // 147.8.0.0       - 147.8.255.255
	{ 0x93090000, 0x9309ffff, REGISTRY_ARIN       }, // 147.9.0.0       - 147.9.255.255
	{ 0x930a0000, 0x930affff, REGISTRY_APNIC      }, // 147.10.0.0      - 147.10.255.255
	{ 0x930b0000, 0x930bffff, REGISTRY_ARIN       }, // 147.11.0.0      - 147.11.255.255
	{ 0x930c0000, 0x930effff, REGISTRY_RIPENCC    }, // 147.12.0.0      - 147.14.255.255
	{ 0x930f0000, 0x931affff, REGISTRY_ARIN       }, // 147.15.0.0      - 147.26.255.255
	{ 0x931b0000, 0x931dffff, REGISTRY_RIPENCC    }, // 147.27.0.0      - 147.29.255.255
	{ 0x931e0000, 0x931effff, REGISTRY_RIPENCC    }, // 147.30.0.0      - 147.30.255.255
	{ 0x931f0000, 0x931fffff, REGISTRY_ARIN       }, // 147.31.0.0      - 147.31.255.255
	{ 0x93200000, 0x9321ffff, REGISTRY_RIPENCC    }, // 147.32.0.0      - 147.33.255.255
	{ 0x93220000, 0x9328ffff, REGISTRY_ARIN       }, // 147.34.0.0      - 147.40.255.255
	{ 0x93290000, 0x9329ffff, REGISTRY_APNIC      }, // 147.41.0.0      - 147.41.255.255
	{ 0x932a0000, 0x932affff, REGISTRY_ARIN       }, // 147.42.0.0      - 147.42.255.255
	{ 0x932b0000, 0x932bffff, REGISTRY_APNIC      }, // 147.43.0.0      - 147.43.255.255
	{ 0x932c0000, 0x932dffff, REGISTRY_RIPENCC    }, // 147.44.0.0      - 147.45.255.255
	{ 0x932e0000, 0x932fffff, REGISTRY_APNIC      }, // 147.46.0.0      - 147.47.255.255
	{ 0x93300000, 0x9331ffff, REGISTRY_ARIN       }, // 147.48.0.0      - 147.49.255.255
	{ 0x93320000, 0x9332ffff, REGISTRY_APNIC      }, // 147.50.0.0      - 147.50.255.255
	{ 0x93330000, 0x9333ffff, REGISTRY_ARIN       }, // 147.51.0.0      - 147.51.255.255
	{ 0x93340000, 0x9334ffff, REGISTRY_RIPENCC    }, // 147.52.0.0      - 147.52.255.255
	{ 0x93350000, 0x9335ffff, REGISTRY_ARIN       }, // 147.53.0.0      - 147.53.255.255
	{ 0x93360000, 0x9336ffff, REGISTRY_RIPENCC    }, // 147.54.0.0      - 147.54.255.255
	{ 0x93370000, 0x933bffff, REGISTRY_ARIN       }, // 147.55.0.0      - 147.59.255.255
	{ 0x933c0000, 0x933cffff, REGISTRY_RIPENCC    }, // 147.60.0.0      - 147.60.255.255
	{ 0x933d0000, 0x9340ffff, REGISTRY_ARIN       }, // 147.61.0.0      - 147.64.255.255
	{ 0x93410000, 0x9341ffff, REGISTRY_LACNIC     }, // 147.65.0.0      - 147.65.255.255
	{ 0x93420000, 0x9342ffff, REGISTRY_APNIC      }, // 147.66.0.0      - 147.66.255.255
	{ 0x93430000, 0x9344ffff, REGISTRY_RIPENCC    }, // 147.67.0.0      - 147.68.255.255
	{ 0x93450000, 0x9345ffff, REGISTRY_APNIC      }, // 147.69.0.0      - 147.69.255.255
	{ 0x93460000, 0x934affff, REGISTRY_ARIN       }, // 147.70.0.0      - 147.74.255.255
	{ 0x934b0000, 0x934bffff, REGISTRY_RIPENCC    }, // 147.75.0.0      - 147.75.255.255
	{ 0x934c0000, 0x934cffff, REGISTRY_APNIC      }, // 147.76.0.0      - 147.76.255.255
	{ 0x934d0000, 0x934dffff, REGISTRY_RIPENCC    }, // 147.77.0.0      - 147.77.255.255
	{ 0x934e0000, 0x934effff, REGISTRY_RIPENCC    }, // 147.78.0.0      - 147.78.255.255
	{ 0x934f0000, 0x9351ffff, REGISTRY_ARIN       }, // 147.79.0.0      - 147.81.255.255
	{ 0x93520000, 0x9352ffff, REGISTRY_RIPENCC    }, // 147.82.0.0      - 147.82.255.255
	{ 0x93530000, 0x9354ffff, REGISTRY_RIPENCC    }, // 147.83.0.0      - 147.84.255.255
	{ 0x93550000, 0x9355ffff, REGISTRY_ARIN       }, // 147.85.0.0      - 147.85.255.255
	{ 0x93560000, 0x9359ffff, REGISTRY_RIPENCC    }, // 147.86.0.0      - 147.89.255.255
	{ 0x935a0000, 0x935affff, REGISTRY_ARIN       }, // 147.90.0.0      - 147.90.255.255
	{ 0x935b0000, 0x935bffff, REGISTRY_RIPENCC    }, // 147.91.0.0      - 147.91.255.255
	{ 0x935c0000, 0x935c1fff, REGISTRY_ARIN       }, // 147.92.0.0      - 147.92.31.255
	{ 0x935c2000, 0x935c2fff, REGISTRY_APNIC      }, // 147.92.32.0     - 147.92.47.255
	{ 0x935c3000, 0x935c7fff, REGISTRY_ARIN       }, // 147.92.48.0     - 147.92.127.255
	{ 0x935c8000, 0x935cffff, REGISTRY_APNIC      }, // 147.92.128.0    - 147.92.255.255
	{ 0x935d0000, 0x9360ffff, REGISTRY_RIPENCC    }, // 147.93.0.0      - 147.96.255.255
	{ 0x93610000, 0x9361ffff, REGISTRY_ARIN       }, // 147.97.0.0      - 147.97.255.255
	{ 0x93620000, 0x9364ffff, REGISTRY_RIPENCC    }, // 147.98.0.0      - 147.100.255.255
	{ 0x93650000, 0x9365ffff, REGISTRY_ARIN       }, // 147.101.0.0     - 147.101.255.255
	{ 0x93660000, 0x9366ffff, REGISTRY_RIPENCC    }, // 147.102.0.0     - 147.102.255.255
	{ 0x93670000, 0x936cffff, REGISTRY_ARIN       }, // 147.103.0.0     - 147.108.255.255
	{ 0x936d0000, 0x936dffff, REGISTRY_APNIC      }, // 147.109.0.0     - 147.109.255.255
	{ 0x936e0000, 0x936effff, REGISTRY_AFRINIC    }, // 147.110.0.0     - 147.110.255.255
	{ 0x936f0000, 0x9370ffff, REGISTRY_RIPENCC    }, // 147.111.0.0     - 147.112.255.255
	{ 0x93710000, 0x9376ffff, REGISTRY_ARIN       }, // 147.113.0.0     - 147.118.255.255
	{ 0x93770000, 0x9377ffff, REGISTRY_RIPENCC    }, // 147.119.0.0     - 147.119.255.255
	{ 0x93780000, 0x9379ffff, REGISTRY_ARIN       }, // 147.120.0.0     - 147.121.255.255
	{ 0x937a0000, 0x937bffff, REGISTRY_RIPENCC    }, // 147.122.0.0     - 147.123.255.255
	{ 0x937c0000, 0x937cffff, REGISTRY_ARIN       }, // 147.124.0.0     - 147.124.255.255
	{ 0x937d0000, 0x937dffff, REGISTRY_RIPENCC    }, // 147.125.0.0     - 147.125.255.255
	{ 0x937e0000, 0x937effff, REGISTRY_ARIN       }, // 147.126.0.0     - 147.126.255.255
	{ 0x937f0000, 0x937fffff, REGISTRY_RIPENCC    }, // 147.127.0.0     - 147.127.255.255
	{ 0x93800000, 0x9383ffff, REGISTRY_ARIN       }, // 147.128.0.0     - 147.131.255.255
	{ 0x93840000, 0x9384ffff, REGISTRY_APNIC      }, // 147.132.0.0     - 147.132.255.255
	{ 0x93850000, 0x93877fff, REGISTRY_ARIN       }, // 147.133.0.0     - 147.135.127.255
	{ 0x93878000, 0x9387ffff, REGISTRY_RIPENCC    }, // 147.135.128.0   - 147.135.255.255
	{ 0x93880000, 0x938dffff, REGISTRY_ARIN       }, // 147.136.0.0     - 147.141.255.255
	{ 0x938e0000, 0x938fffff, REGISTRY_RIPENCC    }, // 147.142.0.0     - 147.143.255.255
	{ 0x93900000, 0x9390ffff, REGISTRY_ARIN       }, // 147.144.0.0     - 147.144.255.255
	{ 0x93910000, 0x9391ffff, REGISTRY_APNIC      }, // 147.145.0.0     - 147.145.255.255
	{ 0x93920000, 0x9392ffff, REGISTRY_ARIN       }, // 147.146.0.0     - 147.146.255.255
	{ 0x93930000, 0x9398ffff, REGISTRY_RIPENCC    }, // 147.147.0.0     - 147.152.255.255
	{ 0x93990000, 0x939bffff, REGISTRY_ARIN       }, // 147.153.0.0     - 147.155.255.255
	{ 0x939c0000, 0x939cffff, REGISTRY_RIPENCC    }, // 147.156.0.0     - 147.156.255.255
	{ 0x939d0000, 0x939effff, REGISTRY_APNIC      }, // 147.157.0.0     - 147.158.255.255
	{ 0x939f0000, 0x93a0ffff, REGISTRY_ARIN       }, // 147.159.0.0     - 147.160.255.255
	{ 0x93a10000, 0x93a3ffff, REGISTRY_RIPENCC    }, // 147.161.0.0     - 147.163.255.255
	{ 0x93a40000, 0x93a6ffff, REGISTRY_ARIN       }, // 147.164.0.0     - 147.166.255.255
	{ 0x93a70000, 0x93a7ffff, REGISTRY_RIPENCC    }, // 147.167.0.0     - 147.167.255.255
	{ 0x93a80000, 0x93aaffff, REGISTRY_ARIN       }, // 147.168.0.0     - 147.170.255.255
	{ 0x93ab0000, 0x93adffff, REGISTRY_RIPENCC    }, // 147.171.0.0     - 147.173.255.255
	{ 0x93ae0000, 0x93aeffff, REGISTRY_ARIN       }, // 147.174.0.0     - 147.174.255.255
	{ 0x93af0000, 0x93afffff, REGISTRY_RIPENCC    }, // 147.175.0.0     - 147.175.255.255
	{ 0x93b00000, 0x93b0ffff, REGISTRY_APNIC      }, // 147.176.0.0     - 147.176.255.255
	{ 0x93b10000, 0x93b3ffff, REGISTRY_ARIN       }, // 147.177.0.0     - 147.179.255.255
	{ 0x93b40000, 0x93b5ffff, REGISTRY_RIPENCC    }, // 147.180.0.0     - 147.181.255.255
	{ 0x93b60000, 0x93b7ffff, REGISTRY_ARIN       }, // 147.182.0.0     - 147.183.255.255
	{ 0x93b80000, 0x93b8ffff, REGISTRY_RIPENCC    }, // 147.184.0.0     - 147.184.255.255
	{ 0x93b90000, 0x93b9ffff, REGISTRY_ARIN       }, // 147.185.0.0     - 147.185.255.255
	{ 0x93ba0000, 0x93baffff, REGISTRY_RIPENCC    }, // 147.186.0.0     - 147.186.255.255
	{ 0x93bb0000, 0x93bbffff, REGISTRY_ARIN       }, // 147.187.0.0     - 147.187.255.255
	{ 0x93bc0000, 0x93bdffff, REGISTRY_RIPENCC    }, // 147.188.0.0     - 147.189.255.255
	{ 0x93be0000, 0x93bfffff, REGISTRY_ARIN       }, // 147.190.0.0     - 147.191.255.255
	{ 0x93c00000, 0x93c0ffff, REGISTRY_APNIC      }, // 147.192.0.0     - 147.192.255.255
	{ 0x93c10000, 0x93c1ffff, REGISTRY_RIPENCC    }, // 147.193.0.0     - 147.193.255.255
	{ 0x93c20000, 0x93c3ffff, REGISTRY_ARIN       }, // 147.194.0.0     - 147.195.255.255
	{ 0x93c40000, 0x93c5ffff, REGISTRY_RIPENCC    }, // 147.196.0.0     - 147.197.255.255
	{ 0x93c60000, 0x93c7ffff, REGISTRY_ARIN       }, // 147.198.0.0     - 147.199.255.255
	{ 0x93c80000, 0x93c8ffff, REGISTRY_APNIC      }, // 147.200.0.0     - 147.200.255.255
	{ 0x93c90000, 0x93c9ffff, REGISTRY_RIPENCC    }, // 147.201.0.0     - 147.201.255.255
	{ 0x93ca0000, 0x93cbffff, REGISTRY_ARIN       }, // 147.202.0.0     - 147.203.255.255
	{ 0x93cc0000, 0x93ccffff, REGISTRY_RIPENCC    }, // 147.204.0.0     - 147.204.255.255
	{ 0x93cd0000, 0x93d0ffff, REGISTRY_ARIN       }, // 147.205.0.0     - 147.208.255.255
	{ 0x93d10000, 0x93d1ffff, REGISTRY_APNIC      }, // 147.209.0.0     - 147.209.255.255
	{ 0x93d20000, 0x93d2ffff, REGISTRY_RIPENCC    }, // 147.210.0.0     - 147.210.255.255
	{ 0x93d30000, 0x93d3ffff, REGISTRY_APNIC      }, // 147.211.0.0     - 147.211.255.255
	{ 0x93d50000, 0x93d7ffff, REGISTRY_RIPENCC    }, // 147.213.0.0     - 147.215.255.255
	{ 0x93d80000, 0x93dbffff, REGISTRY_ARIN       }, // 147.216.0.0     - 147.219.255.255
	{ 0x93dc0000, 0x93dcffff, REGISTRY_RIPENCC    }, // 147.220.0.0     - 147.220.255.255
	{ 0x93dd0000, 0x93e3ffff, REGISTRY_ARIN       }, // 147.221.0.0     - 147.227.255.255
	{ 0x93e40000, 0x93e4ffff, REGISTRY_RIPENCC    }, // 147.228.0.0     - 147.228.255.255
	{ 0x93e50000, 0x93e5ffff, REGISTRY_RIPENCC    }, // 147.229.0.0     - 147.229.255.255
	{ 0x93e60000, 0x93edffff, REGISTRY_RIPENCC    }, // 147.230.0.0     - 147.237.255.255
	{ 0x93ee0000, 0x93f2ffff, REGISTRY_ARIN       }, // 147.238.0.0     - 147.242.255.255
	{ 0x93f30000, 0x93f3ffff, REGISTRY_RIPENCC    }, // 147.243.0.0     - 147.243.255.255
	{ 0x93f40000, 0x93f9ffff, REGISTRY_ARIN       }, // 147.244.0.0     - 147.249.255.255
	{ 0x93fa0000, 0x93fcffff, REGISTRY_RIPENCC    }, // 147.250.0.0     - 147.252.255.255
	{ 0x93fd0000, 0x93ffffff, REGISTRY_ARIN       }, // 147.253.0.0     - 147.255.255.255
	{ 0x94000000, 0x9400ffff, REGISTRY_LACNIC     }, // 148.0.0.0       - 148.0.255.255
	{ 0x94010000, 0x9401ffff, REGISTRY_ARIN       }, // 148.1.0.0       - 148.1.255.255
	{ 0x94020000, 0x9403ffff, REGISTRY_RIPENCC    }, // 148.2.0.0       - 148.3.255.255
	{ 0x94040000, 0x9405ffff, REGISTRY_ARIN       }, // 148.4.0.0       - 148.5.255.255
	{ 0x94060000, 0x9406ffff, REGISTRY_RIPENCC    }, // 148.6.0.0       - 148.6.255.255
	{ 0x94070000, 0x9407ffff, REGISTRY_APNIC      }, // 148.7.0.0       - 148.7.255.255
	{ 0x94080000, 0x9435ffff, REGISTRY_ARIN       }, // 148.8.0.0       - 148.53.255.255
	{ 0x94360000, 0x9436ffff, REGISTRY_RIPENCC    }, // 148.54.0.0      - 148.54.255.255
	{ 0x94370000, 0x9437ffff, REGISTRY_ARIN       }, // 148.55.0.0      - 148.55.255.255
	{ 0x94380000, 0x9438ffff, REGISTRY_RIPENCC    }, // 148.56.0.0      - 148.56.255.255
	{ 0x94390000, 0x943b38ff, REGISTRY_ARIN       }, // 148.57.0.0      - 148.59.56.255
	{ 0x943b3900, 0x943b39ff, REGISTRY_APNIC      }, // 148.59.57.0     - 148.59.57.255
	{ 0x943b3a00, 0x943b72ff, REGISTRY_ARIN       }, // 148.59.58.0     - 148.59.114.255
	{ 0x943b7300, 0x943b73ff, REGISTRY_RIPENCC    }, // 148.59.115.0    - 148.59.115.255
	{ 0x943b7400, 0x943bffff, REGISTRY_ARIN       }, // 148.59.116.0    - 148.59.255.255
	{ 0x943c0000, 0x943cffff, REGISTRY_RIPENCC    }, // 148.60.0.0      - 148.60.255.255
	{ 0x943d0000, 0x943effff, REGISTRY_ARIN       }, // 148.61.0.0      - 148.62.255.255
	{ 0x943f0000, 0x943fffff, REGISTRY_RIPENCC    }, // 148.63.0.0      - 148.63.255.255
	{ 0x94400000, 0x944037ff, REGISTRY_ARIN       }, // 148.64.0.0      - 148.64.55.255
	{ 0x94403800, 0x94403bff, REGISTRY_RIPENCC    }, // 148.64.56.0     - 148.64.59.255
	{ 0x94403c00, 0x9441ffff, REGISTRY_ARIN       }, // 148.64.60.0     - 148.65.255.255
	{ 0x94420000, 0x94421fff, REGISTRY_APNIC      }, // 148.66.0.0      - 148.66.31.255
	{ 0x94422000, 0x94422fff, REGISTRY_ARIN       }, // 148.66.32.0     - 148.66.47.255
	{ 0x94423000, 0x94429fff, REGISTRY_APNIC      }, // 148.66.48.0     - 148.66.159.255
	{ 0x9442a000, 0x9442ffff, REGISTRY_ARIN       }, // 148.66.160.0    - 148.66.255.255
	{ 0x94430000, 0x9444ffff, REGISTRY_APNIC      }, // 148.67.0.0      - 148.68.255.255
	{ 0x94450000, 0x9445ffff, REGISTRY_RIPENCC    }, // 148.69.0.0      - 148.69.255.255
	{ 0x94460000, 0x9446ffff, REGISTRY_APNIC      }, // 148.70.0.0      - 148.70.255.255
	{ 0x94470000, 0x9447ffff, REGISTRY_RIPENCC    }, // 148.71.0.0      - 148.71.255.255
	{ 0x94480000, 0x944cdfff, REGISTRY_ARIN       }, // 148.72.0.0      - 148.76.223.255
	{ 0x944ce000, 0x944cffff, REGISTRY_RIPENCC    }, // 148.76.224.0    - 148.76.255.255
	{ 0x944d0000, 0x944effff, REGISTRY_ARIN       }, // 148.77.0.0      - 148.78.255.255
	{ 0x944f0000, 0x944fffff, REGISTRY_RIPENCC    }, // 148.79.0.0      - 148.79.255.255
	{ 0x94500000, 0x9450ffff, REGISTRY_ARIN       }, // 148.80.0.0      - 148.80.255.255
	{ 0x94510000, 0x9451ffff, REGISTRY_RIPENCC    }, // 148.81.0.0      - 148.81.255.255
	{ 0x94520000, 0x9453ffff, REGISTRY_RIPENCC    }, // 148.82.0.0      - 148.83.255.255
	{ 0x94540000, 0x9457ffff, REGISTRY_ARIN       }, // 148.84.0.0      - 148.87.255.255
	{ 0x94580000, 0x9458ffff, REGISTRY_RIPENCC    }, // 148.88.0.0      - 148.88.255.255
	{ 0x94590000, 0x9464ffff, REGISTRY_ARIN       }, // 148.89.0.0      - 148.100.255.255
	{ 0x94650000, 0x9467ffff, REGISTRY_LACNIC     }, // 148.101.0.0     - 148.103.255.255
	{ 0x94680000, 0x946dffff, REGISTRY_ARIN       }, // 148.104.0.0     - 148.109.255.255
	{ 0x946e0000, 0x946effff, REGISTRY_RIPENCC    }, // 148.110.0.0     - 148.110.255.255
	{ 0x946f0000, 0x946fffff, REGISTRY_RIPENCC    }, // 148.111.0.0     - 148.111.255.255
	{ 0x94700000, 0x9475ffff, REGISTRY_ARIN       }, // 148.112.0.0     - 148.117.255.255
	{ 0x94760000, 0x947bffff, REGISTRY_RIPENCC    }, // 148.118.0.0     - 148.123.255.255
	{ 0x947c0000, 0x9486ffff, REGISTRY_ARIN       }, // 148.124.0.0     - 148.134.255.255
	{ 0x94870000, 0x9488ffff, REGISTRY_RIPENCC    }, // 148.135.0.0     - 148.136.255.255
	{ 0x94890000, 0x9489ffff, REGISTRY_ARIN       }, // 148.137.0.0     - 148.137.255.255
	{ 0x948a0000, 0x948affff, REGISTRY_RIPENCC    }, // 148.138.0.0     - 148.138.255.255
	{ 0x948b0000, 0x948bffff, REGISTRY_ARIN       }, // 148.139.0.0     - 148.139.255.255
	{ 0x948c0000, 0x948cffff, REGISTRY_RIPENCC    }, // 148.140.0.0     - 148.140.255.255
	{ 0x948d0000, 0x948effff, REGISTRY_ARIN       }, // 148.141.0.0     - 148.142.255.255
	{ 0x948f0000, 0x948fffff, REGISTRY_RIPENCC    }, // 148.143.0.0     - 148.143.255.255
	{ 0x94900000, 0x9490ffff, REGISTRY_ARIN       }, // 148.144.0.0     - 148.144.255.255
	{ 0x94910000, 0x9491ffff, REGISTRY_APNIC      }, // 148.145.0.0     - 148.145.255.255
	{ 0x94920000, 0x9493ffff, REGISTRY_ARIN       }, // 148.146.0.0     - 148.147.255.255
	{ 0x94940000, 0x9494ffff, REGISTRY_RIPENCC    }, // 148.148.0.0     - 148.148.255.255
	{ 0x94950000, 0x9496ffff, REGISTRY_ARIN       }, // 148.149.0.0     - 148.150.255.255
	{ 0x94970000, 0x9497ffff, REGISTRY_RIPENCC    }, // 148.151.0.0     - 148.151.255.255
	{ 0x94980000, 0x949fffff, REGISTRY_ARIN       }, // 148.152.0.0     - 148.159.255.255
	{ 0x94a00000, 0x94a0ffff, REGISTRY_RIPENCC    }, // 148.160.0.0     - 148.160.255.255
	{ 0x94a10000, 0x94a1ffff, REGISTRY_APNIC      }, // 148.161.0.0     - 148.161.255.255
	{ 0x94a20000, 0x94a8ffff, REGISTRY_ARIN       }, // 148.162.0.0     - 148.168.255.255
	{ 0x94a90000, 0x94a9ffff, REGISTRY_RIPENCC    }, // 148.169.0.0     - 148.169.255.255
	{ 0x94aa0000, 0x94afffff, REGISTRY_ARIN       }, // 148.170.0.0     - 148.175.255.255
	{ 0x94b00000, 0x94b0ffff, REGISTRY_RIPENCC    }, // 148.176.0.0     - 148.176.255.255
	{ 0x94b10000, 0x94b4ffff, REGISTRY_ARIN       }, // 148.177.0.0     - 148.180.255.255
	{ 0x94b50000, 0x94b5ffff, REGISTRY_RIPENCC    }, // 148.181.0.0     - 148.181.255.255
	{ 0x94b60000, 0x94b6ffff, REGISTRY_APNIC      }, // 148.182.0.0     - 148.182.255.255
	{ 0x94b70000, 0x94b8ffff, REGISTRY_ARIN       }, // 148.183.0.0     - 148.184.255.255
	{ 0x94b90000, 0x94b9ffff, REGISTRY_RIPENCC    }, // 148.185.0.0     - 148.185.255.255
	{ 0x94ba0000, 0x94baffff, REGISTRY_ARIN       }, // 148.186.0.0     - 148.186.255.255
	{ 0x94bb0000, 0x94bbffff, REGISTRY_RIPENCC    }, // 148.187.0.0     - 148.187.255.255
	{ 0x94bc0000, 0x94c2ffff, REGISTRY_ARIN       }, // 148.188.0.0     - 148.194.255.255
	{ 0x94c30000, 0x94c3ffff, REGISTRY_APNIC      }, // 148.195.0.0     - 148.195.255.255
	{ 0x94c40000, 0x94c6ffff, REGISTRY_RIPENCC    }, // 148.196.0.0     - 148.198.255.255
	{ 0x94c70000, 0x94c7ffff, REGISTRY_ARIN       }, // 148.199.0.0     - 148.199.255.255
	{ 0x94c80000, 0x94c8ffff, REGISTRY_RIPENCC    }, // 148.200.0.0     - 148.200.255.255
	{ 0x94c90000, 0x94faffff, REGISTRY_LACNIC     }, // 148.201.0.0     - 148.250.255.255
	{ 0x94fb0000, 0x94fc0fff, REGISTRY_RIPENCC    }, // 148.251.0.0     - 148.252.15.255
	{ 0x94fc1000, 0x94fc1fff, REGISTRY_RIPENCC    }, // 148.252.16.0    - 148.252.31.255
	{ 0x94fc2000, 0x94fd0fff, REGISTRY_RIPENCC    }, // 148.252.32.0    - 148.253.15.255
	{ 0x94fd1000, 0x94fd1fff, REGISTRY_RIPENCC    }, // 148.253.16.0    - 148.253.31.255
	{ 0x94fd2000, 0x94fd7fff, REGISTRY_RIPENCC    }, // 148.253.32.0    - 148.253.127.255
	{ 0x94fd8000, 0x94fd9fff, REGISTRY_RIPENCC    }, // 148.253.128.0   - 148.253.159.255
	{ 0x94fda000, 0x94fdffff, REGISTRY_RIPENCC    }, // 148.253.160.0   - 148.253.255.255
	{ 0x94fe0000, 0x94feffff, REGISTRY_ARIN       }, // 148.254.0.0     - 148.254.255.255
	{ 0x94ff0000, 0x94ffffff, REGISTRY_LACNIC     }, // 148.255.0.0     - 148.255.255.255
	{ 0x95000000, 0x9500ffff, REGISTRY_RIPENCC    }, // 149.0.0.0       - 149.0.255.255
	{ 0x95010000, 0x9502ffff, REGISTRY_ARIN       }, // 149.1.0.0       - 149.2.255.255
	{ 0x95030000, 0x9503ffff, REGISTRY_RIPENCC    }, // 149.3.0.0       - 149.3.255.255
	{ 0x95040000, 0x951affff, REGISTRY_ARIN       }, // 149.4.0.0       - 149.26.255.255
	{ 0x951b0000, 0x951bffff, REGISTRY_RIPENCC    }, // 149.27.0.0      - 149.27.255.255
	{ 0x951c0000, 0x9530ffff, REGISTRY_ARIN       }, // 149.28.0.0      - 149.48.255.255
	{ 0x95310000, 0x9531ffff, REGISTRY_RIPENCC    }, // 149.49.0.0      - 149.49.255.255
	{ 0x95320000, 0x9535ffff, REGISTRY_ARIN       }, // 149.50.0.0      - 149.53.255.255
	{ 0x95360000, 0x9536ffff, REGISTRY_APNIC      }, // 149.54.0.0      - 149.54.255.255
	{ 0x95370000, 0x953affff, REGISTRY_ARIN       }, // 149.55.0.0      - 149.58.255.255
	{ 0x953b0000, 0x953bffff, REGISTRY_RIPENCC    }, // 149.59.0.0      - 149.59.255.255
	{ 0x953c0000, 0x953dffff, REGISTRY_ARIN       }, // 149.60.0.0      - 149.61.255.255
	{ 0x953e0000, 0x953effff, REGISTRY_RIPENCC    }, // 149.62.0.0      - 149.62.255.255
	{ 0x953f0000, 0x9550ffff, REGISTRY_ARIN       }, // 149.63.0.0      - 149.80.255.255
	{ 0x95510000, 0x9551ffff, REGISTRY_RIPENCC    }, // 149.81.0.0      - 149.81.255.255
	{ 0x95520000, 0x9559ffff, REGISTRY_ARIN       }, // 149.82.0.0      - 149.89.255.255
	{ 0x955a0000, 0x955affff, REGISTRY_RIPENCC    }, // 149.90.0.0      - 149.90.255.255
	{ 0x955b0000, 0x956cffff, REGISTRY_ARIN       }, // 149.91.0.0      - 149.108.255.255
	{ 0x956d0000, 0x956dffff, REGISTRY_RIPENCC    }, // 149.109.0.0     - 149.109.255.255
	{ 0x956e0000, 0x957dffff, REGISTRY_ARIN       }, // 149.110.0.0     - 149.125.255.255
	{ 0x957e0000, 0x957effff, REGISTRY_RIPENCC    }, // 149.126.0.0     - 149.126.255.255
	{ 0x957f0000, 0x9580ffff, REGISTRY_ARIN       }, // 149.127.0.0     - 149.128.255.255
	{ 0x95810000, 0x9581ffff, REGISTRY_APNIC      }, // 149.129.0.0     - 149.129.255.255
	{ 0x95820000, 0x9583ffff, REGISTRY_ARIN       }, // 149.130.0.0     - 149.131.255.255
	{ 0x95840000, 0x9586ffff, REGISTRY_RIPENCC    }, // 149.132.0.0     - 149.134.255.255
	{ 0x95870000, 0x9587ffff, REGISTRY_APNIC      }, // 149.135.0.0     - 149.135.255.255
	{ 0x95880000, 0x958affff, REGISTRY_ARIN       }, // 149.136.0.0     - 149.138.255.255
	{ 0x958b0000, 0x958bffff, REGISTRY_RIPENCC    }, // 149.139.0.0     - 149.139.255.255
	{ 0x958c0000, 0x958cffff, REGISTRY_RIPENCC    }, // 149.140.0.0     - 149.140.255.255
	{ 0x958d0000, 0x958fffff, REGISTRY_ARIN       }, // 149.141.0.0     - 149.143.255.255
	{ 0x95900000, 0x9590ffff, REGISTRY_APNIC      }, // 149.144.0.0     - 149.144.255.255
	{ 0x95910000, 0x9591ffff, REGISTRY_ARIN       }, // 149.145.0.0     - 149.145.255.255
	{ 0x95920000, 0x9592ffff, REGISTRY_RIPENCC    }, // 149.146.0.0     - 149.146.255.255
	{ 0x95930000, 0x9593ffff, REGISTRY_RIPENCC    }, // 149.147.0.0     - 149.147.255.255
	{ 0x95940000, 0x9594ffff, REGISTRY_RIPENCC    }, // 149.148.0.0     - 149.148.255.255
	{ 0x95950000, 0x9598ffff, REGISTRY_ARIN       }, // 149.149.0.0     - 149.152.255.255
	{ 0x95990000, 0x9599ffff, REGISTRY_RIPENCC    }, // 149.153.0.0     - 149.153.255.255
	{ 0x959a0000, 0x959affff, REGISTRY_RIPENCC    }, // 149.154.0.0     - 149.154.255.255
	{ 0x959b0000, 0x959dffff, REGISTRY_RIPENCC    }, // 149.155.0.0     - 149.157.255.255
	{ 0x959e0000, 0x95a6ffff, REGISTRY_ARIN       }, // 149.158.0.0     - 149.166.255.255
	{ 0x95a70000, 0x95a7ffff, REGISTRY_APNIC      }, // 149.167.0.0     - 149.167.255.255
	{ 0x95a80000, 0x95a9ffff, REGISTRY_ARIN       }, // 149.168.0.0     - 149.169.255.255
	{ 0x95aa0000, 0x95aaffff, REGISTRY_RIPENCC    }, // 149.170.0.0     - 149.170.255.255
	{ 0x95ab0000, 0x95abffff, REGISTRY_APNIC      }, // 149.171.0.0     - 149.171.255.255
	{ 0x95ac0000, 0x95acffff, REGISTRY_RIPENCC    }, // 149.172.0.0     - 149.172.255.255
	{ 0x95ad0000, 0x95afffff, REGISTRY_ARIN       }, // 149.173.0.0     - 149.175.255.255
	{ 0x95b00000, 0x95b0ffff, REGISTRY_APNIC      }, // 149.176.0.0     - 149.176.255.255
	{ 0x95b10000, 0x95c5ffff, REGISTRY_RIPENCC    }, // 149.177.0.0     - 149.197.255.255
	{ 0x95c60000, 0x95c7ffff, REGISTRY_ARIN       }, // 149.198.0.0     - 149.199.255.255
	{ 0x95c80000, 0x95c8ffff, REGISTRY_RIPENCC    }, // 149.200.0.0     - 149.200.255.255
	{ 0x95c90000, 0x95c9ffff, REGISTRY_RIPENCC    }, // 149.201.0.0     - 149.201.255.255
	{ 0x95ca0000, 0x95caffff, REGISTRY_RIPENCC    }, // 149.202.0.0     - 149.202.255.255
	{ 0x95cb0000, 0x95d1ffff, REGISTRY_RIPENCC    }, // 149.203.0.0     - 149.209.255.255
	{ 0x95d20000, 0x95d2ffff, REGISTRY_RIPENCC    }, // 149.210.0.0     - 149.210.255.255
	{ 0x95d30000, 0x95d3ffff, REGISTRY_RIPENCC    }, // 149.211.0.0     - 149.211.255.255
	{ 0x95d40000, 0x95d4ffff, REGISTRY_RIPENCC    }, // 149.212.0.0     - 149.212.255.255
	{ 0x95d50000, 0x95e8ffff, REGISTRY_RIPENCC    }, // 149.213.0.0     - 149.232.255.255
	{ 0x95e90000, 0x95e91fff, REGISTRY_RIPENCC    }, // 149.233.0.0     - 149.233.31.255
	{ 0x95e92000, 0x95e97fff, REGISTRY_RIPENCC    }, // 149.233.32.0    - 149.233.127.255
	{ 0x95e98000, 0x95e9ffff, REGISTRY_RIPENCC    }, // 149.233.128.0   - 149.233.255.255
	{ 0x95ea0000, 0x95ea07ff, REGISTRY_ARIN       }, // 149.234.0.0     - 149.234.7.255
	{ 0x95ea0800, 0x95ea7fff, REGISTRY_RIPENCC    }, // 149.234.8.0     - 149.234.127.255
	{ 0x95ea8000, 0x95eabfff, REGISTRY_APNIC      }, // 149.234.128.0   - 149.234.191.255
	{ 0x95eac000, 0x95eaffff, REGISTRY_ARIN       }, // 149.234.192.0   - 149.234.255.255
	{ 0x95eb0000, 0x95f0ffff, REGISTRY_RIPENCC    }, // 149.235.0.0     - 149.240.255.255
	{ 0x95f10000, 0x95f1ffff, REGISTRY_RIPENCC    }, // 149.241.0.0     - 149.241.255.255
	{ 0x95f20000, 0x95f5ffff, REGISTRY_RIPENCC    }, // 149.242.0.0     - 149.245.255.255
	{ 0x95f60000, 0x95f6ffff, REGISTRY_RIPENCC    }, // 149.246.0.0     - 149.246.255.255
	{ 0x95f70000, 0x95f7ffff, REGISTRY_RIPENCC    }, // 149.247.0.0     - 149.247.255.255
	{ 0x95f80000, 0x95f8ffff, REGISTRY_ARIN       }, // 149.248.0.0     - 149.248.255.255
	{ 0x95f90000, 0x95fbffff, REGISTRY_RIPENCC    }, // 149.249.0.0     - 149.251.255.255
	{ 0x95fc0000, 0x95fdffff, REGISTRY_ARIN       }, // 149.252.0.0     - 149.253.255.255
	{ 0x95fe0000, 0x95feffff, REGISTRY_RIPENCC    }, // 149.254.0.0     - 149.254.255.255
	{ 0x95ff0000, 0x95ffffff, REGISTRY_RIPENCC    }, // 149.255.0.0     - 149.255.255.255
	{ 0x96000000, 0x9665ffff, REGISTRY_APNIC      }, // 150.0.0.0       - 150.101.255.255
	{ 0x96660000, 0x9669ffff, REGISTRY_ARIN       }, // 150.102.0.0     - 150.105.255.255
	{ 0x966a0000, 0x966affff, REGISTRY_RIPENCC    }, // 150.106.0.0     - 150.106.255.255
	{ 0x966b0000, 0x966ba7ff, REGISTRY_APNIC      }, // 150.107.0.0     - 150.107.167.255
	{ 0x966bac00, 0x966bc7ff, REGISTRY_APNIC      }, // 150.107.172.0   - 150.107.199.255
	{ 0x966bc800, 0x966bcbff, REGISTRY_RIPENCC    }, // 150.107.200.0   - 150.107.203.255
	{ 0x966bcc00, 0x966bffff, REGISTRY_APNIC      }, // 150.107.204.0   - 150.107.255.255
	{ 0x966c0000, 0x966cffff, REGISTRY_ARIN       }, // 150.108.0.0     - 150.108.255.255
	{ 0x966d0000, 0x966dffff, REGISTRY_APNIC      }, // 150.109.0.0     - 150.109.255.255
	{ 0x966e0000, 0x966fffff, REGISTRY_ARIN       }, // 150.110.0.0     - 150.111.255.255
	{ 0x96700000, 0x9670ffff, REGISTRY_RIPENCC    }, // 150.112.0.0     - 150.112.255.255
	{ 0x96710000, 0x9672ffff, REGISTRY_ARIN       }, // 150.113.0.0     - 150.114.255.255
	{ 0x96730000, 0x9675ffff, REGISTRY_APNIC      }, // 150.115.0.0     - 150.117.255.255
	{ 0x96760000, 0x9678ffff, REGISTRY_ARIN       }, // 150.118.0.0     - 150.120.255.255
	{ 0x96790000, 0x967affff, REGISTRY_APNIC      }, // 150.121.0.0     - 150.122.255.255
	{ 0x967b0000, 0x967fffff, REGISTRY_ARIN       }, // 150.123.0.0     - 150.127.255.255
	{ 0x96800000, 0x9680ffff, REGISTRY_RIPENCC    }, // 150.128.0.0     - 150.128.255.255
	{ 0x96810000, 0x968107ff, REGISTRY_APNIC      }, // 150.129.0.0     - 150.129.7.255
	{ 0x96810800, 0x96810bff, REGISTRY_RIPENCC    }, // 150.129.8.0     - 150.129.11.255
	{ 0x96810c00, 0x9681ffff, REGISTRY_APNIC      }, // 150.129.12.0    - 150.129.255.255
	{ 0x96820000, 0x9683ffff, REGISTRY_ARIN       }, // 150.130.0.0     - 150.131.255.255
	{ 0x96840000, 0x9684ffff, REGISTRY_RIPENCC    }, // 150.132.0.0     - 150.132.255.255
	{ 0x96850000, 0x9689ffff, REGISTRY_ARIN       }, // 150.133.0.0     - 150.137.255.255
	{ 0x968a0000, 0x968bffff, REGISTRY_APNIC      }, // 150.138.0.0     - 150.139.255.255
	{ 0x968c0000, 0x968cffff, REGISTRY_RIPENCC    }, // 150.140.0.0     - 150.140.255.255
	{ 0x968d0000, 0x9690ffff, REGISTRY_ARIN       }, // 150.141.0.0     - 150.144.255.255
	{ 0x96910000, 0x9692ffff, REGISTRY_RIPENCC    }, // 150.145.0.0     - 150.146.255.255
	{ 0x96930000, 0x9693ffff, REGISTRY_APNIC      }, // 150.147.0.0     - 150.147.255.255
	{ 0x96940000, 0x9695ffff, REGISTRY_ARIN       }, // 150.148.0.0     - 150.149.255.255
	{ 0x96960000, 0x9697ffff, REGISTRY_APNIC      }, // 150.150.0.0     - 150.151.255.255
	{ 0x96980000, 0x969dffff, REGISTRY_ARIN       }, // 150.152.0.0     - 150.157.255.255
	{ 0x969e0000, 0x969effff, REGISTRY_APNIC      }, // 150.158.0.0     - 150.158.255.255
	{ 0x969f0000, 0x96a0ffff, REGISTRY_ARIN       }, // 150.159.0.0     - 150.160.255.255
	{ 0x96a10000, 0x96a5ffff, REGISTRY_LACNIC     }, // 150.161.0.0     - 150.165.255.255
	{ 0x96a60000, 0x96acffff, REGISTRY_ARIN       }, // 150.166.0.0     - 150.172.255.255
	{ 0x96ad0000, 0x96adffff, REGISTRY_APNIC      }, // 150.173.0.0     - 150.173.255.255
	{ 0x96ae0000, 0x96aeffff, REGISTRY_ARIN       }, // 150.174.0.0     - 150.174.255.255
	{ 0x96af0000, 0x96afffff, REGISTRY_RIPENCC    }, // 150.175.0.0     - 150.175.255.255
	{ 0x96b00000, 0x96b1ffff, REGISTRY_ARIN       }, // 150.176.0.0     - 150.177.255.255
	{ 0x96b20000, 0x96b2ffff, REGISTRY_RIPENCC    }, // 150.178.0.0     - 150.178.255.255
	{ 0x96b30000, 0x96b6ffff, REGISTRY_ARIN       }, // 150.179.0.0     - 150.182.255.255
	{ 0x96b70000, 0x96b7ffff, REGISTRY_APNIC      }, // 150.183.0.0     - 150.183.255.255
	{ 0x96b80000, 0x96b8ffff, REGISTRY_ARIN       }, // 150.184.0.0     - 150.184.255.255
	{ 0x96b90000, 0x96bdffff, REGISTRY_LACNIC     }, // 150.185.0.0     - 150.189.255.255
	{ 0x96be0000, 0x96beffff, REGISTRY_ARIN       }, // 150.190.0.0     - 150.190.255.255
	{ 0x96bf0000, 0x96bfffff, REGISTRY_APNIC      }, // 150.191.0.0     - 150.191.255.255
	{ 0x96c00000, 0x96c4ffff, REGISTRY_ARIN       }, // 150.192.0.0     - 150.196.255.255
	{ 0x96c50000, 0x96c5ffff, REGISTRY_APNIC      }, // 150.197.0.0     - 150.197.255.255
	{ 0x96c60000, 0x96caffff, REGISTRY_ARIN       }, // 150.198.0.0     - 150.202.255.255
	{ 0x96cb0000, 0x96cbffff, REGISTRY_APNIC      }, // 150.203.0.0     - 150.203.255.255
	{ 0x96cc0000, 0x96cdffff, REGISTRY_RIPENCC    }, // 150.204.0.0     - 150.205.255.255
	{ 0x96ce0000, 0x96cfffff, REGISTRY_APNIC      }, // 150.206.0.0     - 150.207.255.255
	{ 0x96d00000, 0x96d4ffff, REGISTRY_ARIN       }, // 150.208.0.0     - 150.212.255.255
	{ 0x96d50000, 0x96d6ffff, REGISTRY_RIPENCC    }, // 150.213.0.0     - 150.214.255.255
	{ 0x96d70000, 0x96d8ffff, REGISTRY_ARIN       }, // 150.215.0.0     - 150.216.255.255
	{ 0x96d90000, 0x96d9ffff, REGISTRY_RIPENCC    }, // 150.217.0.0     - 150.217.255.255
	{ 0x96da0000, 0x96deffff, REGISTRY_ARIN       }, // 150.218.0.0     - 150.222.255.255
	{ 0x96df0000, 0x96dfffff, REGISTRY_APNIC      }, // 150.223.0.0     - 150.223.255.255
	{ 0x96e00000, 0x96e2ffff, REGISTRY_ARIN       }, // 150.224.0.0     - 150.226.255.255
	{ 0x96e30000, 0x96e3ffff, REGISTRY_RIPENCC    }, // 150.227.0.0     - 150.227.255.255
	{ 0x96e40000, 0x96e4ffff, REGISTRY_ARIN       }, // 150.228.0.0     - 150.228.255.255
	{ 0x96e50000, 0x96e5ffff, REGISTRY_APNIC      }, // 150.229.0.0     - 150.229.255.255
	{ 0x96e60000, 0x96ebffff, REGISTRY_ARIN       }, // 150.230.0.0     - 150.235.255.255
	{ 0x96ec0000, 0x96edffff, REGISTRY_RIPENCC    }, // 150.236.0.0     - 150.237.255.255
	{ 0x96ee0000, 0x96f0ffff, REGISTRY_ARIN       }, // 150.238.0.0     - 150.240.255.255
	{ 0x96f10000, 0x96f1ffff, REGISTRY_RIPENCC    }, // 150.241.0.0     - 150.241.255.255
	{ 0x96f20000, 0x96f257ff, REGISTRY_APNIC      }, // 150.242.0.0     - 150.242.87.255
	{ 0x96f25800, 0x96f25bff, REGISTRY_ARIN       }, // 150.242.88.0    - 150.242.91.255
	{ 0x96f25c00, 0x96f2dbff, REGISTRY_APNIC      }, // 150.242.92.0    - 150.242.219.255
	{ 0x96f2dc00, 0x96f2dfff, REGISTRY_ARIN       }, // 150.242.220.0   - 150.242.223.255
	{ 0x96f2e000, 0x96f2ffff, REGISTRY_APNIC      }, // 150.242.224.0   - 150.242.255.255
	{ 0x96f30000, 0x96f3ffff, REGISTRY_ARIN       }, // 150.243.0.0     - 150.243.255.255
	{ 0x96f40000, 0x96f4ffff, REGISTRY_RIPENCC    }, // 150.244.0.0     - 150.244.255.255
	{ 0x96f50000, 0x96f5ffff, REGISTRY_ARIN       }, // 150.245.0.0     - 150.245.255.255
	{ 0x96f60000, 0x96f6ffff, REGISTRY_APNIC      }, // 150.246.0.0     - 150.246.255.255
	{ 0x96f70000, 0x96f8ffff, REGISTRY_ARIN       }, // 150.247.0.0     - 150.248.255.255
	{ 0x96f90000, 0x96f9ffff, REGISTRY_APNIC      }, // 150.249.0.0     - 150.249.255.255
	{ 0x96fa0000, 0x96faffff, REGISTRY_ARIN       }, // 150.250.0.0     - 150.250.255.255
	{ 0x96fb0000, 0x96fbffff, REGISTRY_RIPENCC    }, // 150.251.0.0     - 150.251.255.255
	{ 0x96fc0000, 0x96fdffff, REGISTRY_ARIN       }, // 150.252.0.0     - 150.253.255.255
	{ 0x96fe0000, 0x96feffff, REGISTRY_RIPENCC    }, // 150.254.0.0     - 150.254.255.255
	{ 0x96ff0000, 0x96ffffff, REGISTRY_APNIC      }, // 150.255.0.0     - 150.255.255.255
	{ 0x97000000, 0x9702ffff, REGISTRY_RIPENCC    }, // 151.0.0.0       - 151.2.255.255
	{ 0x97030000, 0x9762ffff, REGISTRY_RIPENCC    }, // 151.3.0.0       - 151.98.255.255
	{ 0x97630000, 0x9763ffff, REGISTRY_RIPENCC    }, // 151.99.0.0      - 151.99.255.255
	{ 0x97640000, 0x9764ffff, REGISTRY_RIPENCC    }, // 151.100.0.0     - 151.100.255.255
	{ 0x97650000, 0x9769ffff, REGISTRY_ARIN       }, // 151.101.0.0     - 151.105.255.255
	{ 0x976a0000, 0x976a9fff, REGISTRY_RIPENCC    }, // 151.106.0.0     - 151.106.159.255
	{ 0x976aa000, 0x976abfff, REGISTRY_ARIN       }, // 151.106.160.0   - 151.106.191.255
	{ 0x976ac000, 0x976aefff, REGISTRY_RIPENCC    }, // 151.106.192.0   - 151.106.239.255
	{ 0x976af000, 0x9772ffff, REGISTRY_ARIN       }, // 151.106.240.0   - 151.114.255.255
	{ 0x97730000, 0x9773ffff, REGISTRY_RIPENCC    }, // 151.115.0.0     - 151.115.255.255
	{ 0x97740000, 0x9777ffff, REGISTRY_ARIN       }, // 151.116.0.0     - 151.119.255.255
	{ 0x97780000, 0x9778ffff, REGISTRY_RIPENCC    }, // 151.120.0.0     - 151.120.255.255
	{ 0x97790000, 0x977effff, REGISTRY_ARIN       }, // 151.121.0.0     - 151.126.255.255
	{ 0x977f0000, 0x977fffff, REGISTRY_RIPENCC    }, // 151.127.0.0     - 151.127.255.255
	{ 0x97800000, 0x9780ffff, REGISTRY_ARIN       }, // 151.128.0.0     - 151.128.255.255
	{ 0x97810000, 0x9781ffff, REGISTRY_RIPENCC    }, // 151.129.0.0     - 151.129.255.255
	{ 0x97820000, 0x9782ffff, REGISTRY_APNIC      }, // 151.130.0.0     - 151.130.255.255
	{ 0x97830000, 0x9784ffff, REGISTRY_ARIN       }, // 151.131.0.0     - 151.132.255.255
	{ 0x97850000, 0x9785ffff, REGISTRY_RIPENCC    }, // 151.133.0.0     - 151.133.255.255
	{ 0x97860000, 0x9786ffff, REGISTRY_ARIN       }, // 151.134.0.0     - 151.134.255.255
	{ 0x97870000, 0x9787ffff, REGISTRY_RIPENCC    }, // 151.135.0.0     - 151.135.255.255
	{ 0x97880000, 0x9788ffff, REGISTRY_RIPENCC    }, // 151.136.0.0     - 151.136.255.255
	{ 0x97890000, 0x979bffff, REGISTRY_ARIN       }, // 151.137.0.0     - 151.155.255.255
	{ 0x979c0000, 0x979dffff, REGISTRY_RIPENCC    }, // 151.156.0.0     - 151.157.255.255
	{ 0x979f0000, 0x97a9ffff, REGISTRY_ARIN       }, // 151.159.0.0     - 151.169.255.255
	{ 0x97aa0000, 0x97aaffff, REGISTRY_RIPENCC    }, // 151.170.0.0     - 151.170.255.255
	{ 0x97ab0000, 0x97abffff, REGISTRY_ARIN       }, // 151.171.0.0     - 151.171.255.255
	{ 0x97ad0000, 0x97adffff, REGISTRY_RIPENCC    }, // 151.173.0.0     - 151.173.255.255
	{ 0x97ae0000, 0x97aeffff, REGISTRY_ARIN       }, // 151.174.0.0     - 151.174.255.255
	{ 0x97af0000, 0x97b0ffff, REGISTRY_RIPENCC    }, // 151.175.0.0     - 151.176.255.255
	{ 0x97b10000, 0x97b1ffff, REGISTRY_RIPENCC    }, // 151.177.0.0     - 151.177.255.255
	{ 0x97b20000, 0x97b2ffff, REGISTRY_APNIC      }, // 151.178.0.0     - 151.178.255.255
	{ 0x97b30000, 0x97b3ffff, REGISTRY_ARIN       }, // 151.179.0.0     - 151.179.255.255
	{ 0x97b40000, 0x97b4ffff, REGISTRY_RIPENCC    }, // 151.180.0.0     - 151.180.255.255
	{ 0x97b50000, 0x97b5ffff, REGISTRY_ARIN       }, // 151.181.0.0     - 151.181.255.255
	{ 0x97b60000, 0x97b8ffff, REGISTRY_RIPENCC    }, // 151.182.0.0     - 151.184.255.255
	{ 0x97b90000, 0x97baffff, REGISTRY_ARIN       }, // 151.185.0.0     - 151.186.255.255
	{ 0x97bb0000, 0x97bbffff, REGISTRY_RIPENCC    }, // 151.187.0.0     - 151.187.255.255
	{ 0x97bc0000, 0x97bcffff, REGISTRY_ARIN       }, // 151.188.0.0     - 151.188.255.255
	{ 0x97bd0000, 0x97bdffff, REGISTRY_RIPENCC    }, // 151.189.0.0     - 151.189.255.255
	{ 0x97be0000, 0x97d27fff, REGISTRY_ARIN       }, // 151.190.0.0     - 151.210.127.255
	{ 0x97d28000, 0x97d2ffff, REGISTRY_APNIC      }, // 151.210.128.0   - 151.210.255.255
	{ 0x97d30000, 0x97d4ffff, REGISTRY_RIPENCC    }, // 151.211.0.0     - 151.212.255.255
	{ 0x97d50000, 0x97d7ffff, REGISTRY_ARIN       }, // 151.213.0.0     - 151.215.255.255
	{ 0x97d80000, 0x97d803ff, REGISTRY_RIPENCC    }, // 151.216.0.0     - 151.216.3.255
	{ 0x97d81000, 0x97d813ff, REGISTRY_RIPENCC    }, // 151.216.16.0    - 151.216.19.255
	{ 0x97e00000, 0x97f80fff, REGISTRY_RIPENCC    }, // 151.224.0.0     - 151.248.15.255
	{ 0x97f81800, 0x97ffffff, REGISTRY_RIPENCC    }, // 151.248.24.0    - 151.255.255.255
	{ 0x98000000, 0x9800ffff, REGISTRY_LACNIC     }, // 152.0.0.0       - 152.0.255.255
	{ 0x98010000, 0x98203fff, REGISTRY_ARIN       }, // 152.1.0.0       - 152.32.63.255
	{ 0x98204000, 0x9820ffff, REGISTRY_APNIC      }, // 152.32.64.0     - 152.32.255.255
	{ 0x98210000, 0x9833ffff, REGISTRY_ARIN       }, // 152.33.0.0      - 152.51.255.255
	{ 0x98340000, 0x9834ffff, REGISTRY_APNIC      }, // 152.52.0.0      - 152.52.255.255
	{ 0x98350000, 0x9837ffff, REGISTRY_ARIN       }, // 152.53.0.0      - 152.55.255.255
	{ 0x98380000, 0x983bffff, REGISTRY_APNIC      }, // 152.56.0.0      - 152.59.255.255
	{ 0x983c0000, 0x9841ffff, REGISTRY_ARIN       }, // 152.60.0.0      - 152.65.255.255
	{ 0x98420000, 0x9842ffff, REGISTRY_RIPENCC    }, // 152.66.0.0      - 152.66.255.255
	{ 0x98430000, 0x9846ffff, REGISTRY_ARIN       }, // 152.67.0.0      - 152.70.255.255
	{ 0x98470000, 0x9847ffff, REGISTRY_RIPENCC    }, // 152.71.0.0      - 152.71.255.255
	{ 0x98480000, 0x9848ffff, REGISTRY_ARIN       }, // 152.72.0.0      - 152.72.255.255
	{ 0x98490000, 0x9849ffff, REGISTRY_RIPENCC    }, // 152.73.0.0      - 152.73.255.255
	{ 0x984a0000, 0x984affff, REGISTRY_LACNIC     }, // 152.74.0.0      - 152.74.255.255
	{ 0x984b0000, 0x984bffff, REGISTRY_ARIN       }, // 152.75.0.0      - 152.75.255.255
	{ 0x984c0000, 0x984cffff, REGISTRY_APNIC      }, // 152.76.0.0      - 152.76.255.255
	{ 0x984d0000, 0x984effff, REGISTRY_RIPENCC    }, // 152.77.0.0      - 152.78.255.255
	{ 0x984f0000, 0x9850ffff, REGISTRY_ARIN       }, // 152.79.0.0      - 152.80.255.255
	{ 0x98510000, 0x9851ffff, REGISTRY_RIPENCC    }, // 152.81.0.0      - 152.81.255.255
	{ 0x98520000, 0x9852ffff, REGISTRY_ARIN       }, // 152.82.0.0      - 152.82.255.255
	{ 0x98530000, 0x9853ffff, REGISTRY_APNIC      }, // 152.83.0.0      - 152.83.255.255
	{ 0x98540000, 0x9854ffff, REGISTRY_LACNIC     }, // 152.84.0.0      - 152.84.255.255
	{ 0x98550000, 0x9857ffff, REGISTRY_ARIN       }, // 152.85.0.0      - 152.87.255.255
	{ 0x98580000, 0x9858ffff, REGISTRY_RIPENCC    }, // 152.88.0.0      - 152.88.255.255
	{ 0x98590000, 0x9859ffff, REGISTRY_RIPENCC    }, // 152.89.0.0      - 152.89.255.255
	{ 0x985a0000, 0x985affff, REGISTRY_RIPENCC    }, // 152.90.0.0      - 152.90.255.255
	{ 0x985b0000, 0x985bffff, REGISTRY_APNIC      }, // 152.91.0.0      - 152.91.255.255
	{ 0x985c0000, 0x985cffff, REGISTRY_LACNIC     }, // 152.92.0.0      - 152.92.255.255
	{ 0x985d0000, 0x9860ffff, REGISTRY_RIPENCC    }, // 152.93.0.0      - 152.96.255.255
	{ 0x98610000, 0x9861ffff, REGISTRY_ARIN       }, // 152.97.0.0      - 152.97.255.255
	{ 0x98620000, 0x9863ffff, REGISTRY_APNIC      }, // 152.98.0.0      - 152.99.255.255
	{ 0x98640000, 0x9864ffff, REGISTRY_ARIN       }, // 152.100.0.0     - 152.100.255.255
	{ 0x98650000, 0x9868ffff, REGISTRY_APNIC      }, // 152.101.0.0     - 152.104.255.255
	{ 0x98690000, 0x9869ffff, REGISTRY_RIPENCC    }, // 152.105.0.0     - 152.105.255.255
	{ 0x986a0000, 0x9870ffff, REGISTRY_AFRINIC    }, // 152.106.0.0     - 152.112.255.255
	{ 0x98710000, 0x9871ffff, REGISTRY_ARIN       }, // 152.113.0.0     - 152.113.255.255
	{ 0x98720000, 0x9873ffff, REGISTRY_RIPENCC    }, // 152.114.0.0     - 152.115.255.255
	{ 0x98740000, 0x9875ffff, REGISTRY_ARIN       }, // 152.116.0.0     - 152.117.255.255
	{ 0x98760000, 0x9876ffff, REGISTRY_APNIC      }, // 152.118.0.0     - 152.118.255.255
	{ 0x98770000, 0x9885ffff, REGISTRY_ARIN       }, // 152.119.0.0     - 152.133.255.255
	{ 0x98860000, 0x9886ffff, REGISTRY_RIPENCC    }, // 152.134.0.0     - 152.134.255.255
	{ 0x98870000, 0x9887ffff, REGISTRY_ARIN       }, // 152.135.0.0     - 152.135.255.255
	{ 0x98880000, 0x9888ffff, REGISTRY_APNIC      }, // 152.136.0.0     - 152.136.255.255
	{ 0x98890000, 0x988affff, REGISTRY_ARIN       }, // 152.137.0.0     - 152.138.255.255
	{ 0x988b0000, 0x988bffff, REGISTRY_LACNIC     }, // 152.139.0.0     - 152.139.255.255
	{ 0x988c0000, 0x988effff, REGISTRY_ARIN       }, // 152.140.0.0     - 152.142.255.255
	{ 0x988f0000, 0x988fffff, REGISTRY_RIPENCC    }, // 152.143.0.0     - 152.143.255.255
	{ 0x98900000, 0x9892ffff, REGISTRY_ARIN       }, // 152.144.0.0     - 152.146.255.255
	{ 0x98930000, 0x9893ffff, REGISTRY_APNIC      }, // 152.147.0.0     - 152.147.255.255
	{ 0x98940000, 0x9894ffff, REGISTRY_ARIN       }, // 152.148.0.0     - 152.148.255.255
	{ 0x98950000, 0x9895ffff, REGISTRY_APNIC      }, // 152.149.0.0     - 152.149.255.255
	{ 0x98960000, 0x9896ffff, REGISTRY_RIPENCC    }, // 152.150.0.0     - 152.150.255.255
	{ 0x98970000, 0x9897ffff, REGISTRY_ARIN       }, // 152.151.0.0     - 152.151.255.255
	{ 0x98980000, 0x9898ffff, REGISTRY_RIPENCC    }, // 152.152.0.0     - 152.152.255.255
	{ 0x98990000, 0x9899ffff, REGISTRY_APNIC      }, // 152.153.0.0     - 152.153.255.255
	{ 0x989a0000, 0x989bffff, REGISTRY_ARIN       }, // 152.154.0.0     - 152.155.255.255
	{ 0x989c0000, 0x989cffff, REGISTRY_LACNIC     }, // 152.156.0.0     - 152.156.255.255
	{ 0x989d0000, 0x98a4ffff, REGISTRY_ARIN       }, // 152.157.0.0     - 152.164.255.255
	{ 0x98a50000, 0x98a5ffff, REGISTRY_APNIC      }, // 152.165.0.0     - 152.165.255.255
	{ 0x98a60000, 0x98afffff, REGISTRY_LACNIC     }, // 152.166.0.0     - 152.175.255.255
	{ 0x98b00000, 0x98c7ffff, REGISTRY_ARIN       }, // 152.176.0.0     - 152.199.255.255
	{ 0x98c80000, 0x98cfffff, REGISTRY_LACNIC     }, // 152.200.0.0     - 152.207.255.255
	{ 0x98d00000, 0x98e1ffff, REGISTRY_ARIN       }, // 152.208.0.0     - 152.225.255.255
	{ 0x98e20000, 0x98e2ffff, REGISTRY_APNIC      }, // 152.226.0.0     - 152.226.255.255
	{ 0x98e30000, 0x98e5ffff, REGISTRY_ARIN       }, // 152.227.0.0     - 152.229.255.255
	{ 0x98e60000, 0x98ffffff, REGISTRY_LACNIC     }, // 152.230.0.0     - 152.255.255.255
	{ 0x99000000, 0x9900ffff, REGISTRY_APNIC      }, // 153.0.0.0       - 153.0.255.255
	{ 0x99010000, 0x9901ffff, REGISTRY_RIPENCC    }, // 153.1.0.0       - 153.1.255.255
	{ 0x99020000, 0x9902ffff, REGISTRY_ARIN       }, // 153.2.0.0       - 153.2.255.255
	{ 0x99030000, 0x9903ffff, REGISTRY_APNIC      }, // 153.3.0.0       - 153.3.255.255
	{ 0x99040000, 0x9904ffff, REGISTRY_ARIN       }, // 153.4.0.0       - 153.4.255.255
	{ 0x99050000, 0x9905ffff, REGISTRY_RIPENCC    }, // 153.5.0.0       - 153.5.255.255
	{ 0x99060000, 0x990effff, REGISTRY_ARIN       }, // 153.6.0.0       - 153.14.255.255
	{ 0x990f0000, 0x990fffff, REGISTRY_RIPENCC    }, // 153.15.0.0      - 153.15.255.255
	{ 0x99100000, 0x9910ffff, REGISTRY_ARIN       }, // 153.16.0.0      - 153.16.255.255
	{ 0x99110000, 0x9911ffff, REGISTRY_RIPENCC    }, // 153.17.0.0      - 153.17.255.255
	{ 0x99120000, 0x9912ffff, REGISTRY_ARIN       }, // 153.18.0.0      - 153.18.255.255
	{ 0x99130000, 0x9913ffff, REGISTRY_RIPENCC    }, // 153.19.0.0      - 153.19.255.255
	{ 0x99140000, 0x9914ffff, REGISTRY_APNIC      }, // 153.20.0.0      - 153.20.255.255
	{ 0x99150000, 0x9921ffff, REGISTRY_ARIN       }, // 153.21.0.0      - 153.33.255.255
	{ 0x99220000, 0x9925ffff, REGISTRY_APNIC      }, // 153.34.0.0      - 153.37.255.255
	{ 0x99260000, 0x9957ffff, REGISTRY_ARIN       }, // 153.38.0.0      - 153.87.255.255
	{ 0x99580000, 0x9958ffff, REGISTRY_RIPENCC    }, // 153.88.0.0      - 153.88.255.255
	{ 0x99590000, 0x995bffff, REGISTRY_ARIN       }, // 153.89.0.0      - 153.91.255.255
	{ 0x995c0000, 0x995c47ff, REGISTRY_RIPENCC    }, // 153.92.0.0      - 153.92.71.255
	{ 0x995c4800, 0x995c4fff, REGISTRY_RIPENCC    }, // 153.92.72.0     - 153.92.79.255
	{ 0x995c5000, 0x995c6fff, REGISTRY_RIPENCC    }, // 153.92.80.0     - 153.92.111.255
	{ 0x995c7000, 0x995c7bff, REGISTRY_RIPENCC    }, // 153.92.112.0    - 153.92.123.255
	{ 0x995c7c00, 0x995e0fff, REGISTRY_RIPENCC    }, // 153.92.124.0    - 153.94.15.255
	{ 0x995e1000, 0x995effff, REGISTRY_RIPENCC    }, // 153.94.16.0     - 153.94.255.255
	{ 0x995f0000, 0x9962ffff, REGISTRY_RIPENCC    }, // 153.95.0.0      - 153.98.255.255
	{ 0x99630000, 0x9963ffff, REGISTRY_APNIC      }, // 153.99.0.0      - 153.99.255.255
	{ 0x99640000, 0x9964ffff, REGISTRY_RIPENCC    }, // 153.100.0.0     - 153.100.255.255
	{ 0x99650000, 0x9965ffff, REGISTRY_APNIC      }, // 153.101.0.0     - 153.101.255.255
	{ 0x99660000, 0x996affff, REGISTRY_ARIN       }, // 153.102.0.0     - 153.106.255.255
	{ 0x996b0000, 0x996bffff, REGISTRY_APNIC      }, // 153.107.0.0     - 153.107.255.255
	{ 0x996c0000, 0x996effff, REGISTRY_RIPENCC    }, // 153.108.0.0     - 153.110.255.255
	{ 0x996f0000, 0x996fffff, REGISTRY_APNIC      }, // 153.111.0.0     - 153.111.255.255
	{ 0x99700000, 0x9970ffff, REGISTRY_RIPENCC    }, // 153.112.0.0     - 153.112.255.255
	{ 0x99710000, 0x9975ffff, REGISTRY_ARIN       }, // 153.113.0.0     - 153.117.255.255
	{ 0x99760000, 0x99ffffff, REGISTRY_APNIC      }, // 153.118.0.0     - 153.255.255.255
	{ 0x9a000000, 0x9a008fff, REGISTRY_AFRINIC    }, // 154.0.0.0       - 154.0.143.255
	{ 0x9a009800, 0x9a00ffff, REGISTRY_AFRINIC    }, // 154.0.152.0     - 154.0.255.255
	{ 0x9a010000, 0x9a07ffff, REGISTRY_ARIN       }, // 154.1.0.0       - 154.7.255.255
	{ 0x9a080000, 0x9a082fff, REGISTRY_RIPENCC    }, // 154.8.0.0       - 154.8.47.255
	{ 0x9a083000, 0x9a083fff, REGISTRY_APNIC      }, // 154.8.48.0      - 154.8.63.255
	{ 0x9a084000, 0x9a087fff, REGISTRY_RIPENCC    }, // 154.8.64.0      - 154.8.127.255
	{ 0x9a088000, 0x9a08ffff, REGISTRY_APNIC      }, // 154.8.128.0     - 154.8.255.255
	{ 0x9a090000, 0x9a09ffff, REGISTRY_ARIN       }, // 154.9.0.0       - 154.9.255.255
	{ 0x9a0a0000, 0x9a0affff, REGISTRY_APNIC      }, // 154.10.0.0      - 154.10.255.255
	{ 0x9a0b0000, 0x9a0dffff, REGISTRY_ARIN       }, // 154.11.0.0      - 154.13.255.255
	{ 0x9a0e0000, 0x9a0fffff, REGISTRY_RIPENCC    }, // 154.14.0.0      - 154.15.255.255
	{ 0x9a100000, 0x9a10ffff, REGISTRY_AFRINIC    }, // 154.16.0.0      - 154.16.255.255
	{ 0x9a110000, 0x9a1fffff, REGISTRY_ARIN       }, // 154.17.0.0      - 154.31.255.255
	{ 0x9a200000, 0x9a20ffff, REGISTRY_RIPENCC    }, // 154.32.0.0      - 154.32.255.255
	{ 0x9a210000, 0x9a22ffff, REGISTRY_APNIC      }, // 154.33.0.0      - 154.34.255.255
	{ 0x9a230000, 0x9a40ffff, REGISTRY_ARIN       }, // 154.35.0.0      - 154.64.255.255
	{ 0x9a410000, 0x9a4137ff, REGISTRY_AFRINIC    }, // 154.65.0.0      - 154.65.55.255
	{ 0x9a413c00, 0x9a425fff, REGISTRY_AFRINIC    }, // 154.65.60.0     - 154.66.95.255
	{ 0x9a426800, 0x9a4273ff, REGISTRY_AFRINIC    }, // 154.66.104.0    - 154.66.115.255
	{ 0x9a427800, 0x9a42d3ff, REGISTRY_AFRINIC    }, // 154.66.120.0    - 154.66.211.255
	{ 0x9a42d800, 0x9a471fff, REGISTRY_AFRINIC    }, // 154.66.216.0    - 154.71.31.255
	{ 0x9a480400, 0x9a481bff, REGISTRY_AFRINIC    }, // 154.72.4.0      - 154.72.27.255
	{ 0x9a482000, 0x9a494bff, REGISTRY_AFRINIC    }, // 154.72.32.0     - 154.73.75.255
	{ 0x9a495000, 0x9a498fff, REGISTRY_AFRINIC    }, // 154.73.80.0     - 154.73.143.255
	{ 0x9a499800, 0x9a49ebff, REGISTRY_AFRINIC    }, // 154.73.152.0    - 154.73.235.255
	{ 0x9a49f000, 0x9a74ffff, REGISTRY_AFRINIC    }, // 154.73.240.0    - 154.116.255.255
	{ 0x9a754000, 0x9a777fff, REGISTRY_AFRINIC    }, // 154.117.64.0    - 154.119.127.255
	{ 0x9a779000, 0x9b00ffff, REGISTRY_AFRINIC    }, // 154.119.144.0   - 155.0.255.255
	{ 0x9b010000, 0x9b03ffff, REGISTRY_ARIN       }, // 155.1.0.0       - 155.3.255.255
	{ 0x9b040000, 0x9b04ffff, REGISTRY_RIPENCC    }, // 155.4.0.0       - 155.4.255.255
	{ 0x9b050000, 0x9b0affff, REGISTRY_ARIN       }, // 155.5.0.0       - 155.10.255.255
	{ 0x9b0b0000, 0x9b0cffff, REGISTRY_AFRINIC    }, // 155.11.0.0      - 155.12.255.255
	{ 0x9b0d0000, 0x9b1fffff, REGISTRY_ARIN       }, // 155.13.0.0      - 155.31.255.255
	{ 0x9b200000, 0x9b20ffff, REGISTRY_APNIC      }, // 155.32.0.0      - 155.32.255.255
	{ 0x9b210000, 0x9b2300ff, REGISTRY_ARIN       }, // 155.33.0.0      - 155.35.0.255
	{ 0x9b230100, 0x9b2301ff, REGISTRY_APNIC      }, // 155.35.1.0      - 155.35.1.255
	{ 0x9b230200, 0x9b2321ff, REGISTRY_ARIN       }, // 155.35.2.0      - 155.35.33.255
	{ 0x9b232200, 0x9b2323ff, REGISTRY_APNIC      }, // 155.35.34.0     - 155.35.35.255
	{ 0x9b232400, 0x9b232dff, REGISTRY_ARIN       }, // 155.35.36.0     - 155.35.45.255
	{ 0x9b232e00, 0x9b232fff, REGISTRY_APNIC      }, // 155.35.46.0     - 155.35.47.255
	{ 0x9b233000, 0x9b23e1ff, REGISTRY_ARIN       }, // 155.35.48.0     - 155.35.225.255
	{ 0x9b23e200, 0x9b23e2ff, REGISTRY_APNIC      }, // 155.35.226.0    - 155.35.226.255
	{ 0x9b23e300, 0x9b23e7ff, REGISTRY_ARIN       }, // 155.35.227.0    - 155.35.231.255
	{ 0x9b23e800, 0x9b23e8ff, REGISTRY_APNIC      }, // 155.35.232.0    - 155.35.232.255
	{ 0x9b23e900, 0x9b2cffff, REGISTRY_ARIN       }, // 155.35.233.0    - 155.44.255.255
	{ 0x9b2d0000, 0x9b2dffff, REGISTRY_RIPENCC    }, // 155.45.0.0      - 155.45.255.255
	{ 0x9b2e0000, 0x9b35ffff, REGISTRY_ARIN       }, // 155.46.0.0      - 155.53.255.255
	{ 0x9b360000, 0x9b38ffff, REGISTRY_RIPENCC    }, // 155.54.0.0      - 155.56.255.255
	{ 0x9b390000, 0x9b3affff, REGISTRY_ARIN       }, // 155.57.0.0      - 155.58.255.255
	{ 0x9b3b0000, 0x9b3cffff, REGISTRY_APNIC      }, // 155.59.0.0      - 155.60.255.255
	{ 0x9b3d0000, 0x9b3dffff, REGISTRY_ARIN       }, // 155.61.0.0      - 155.61.255.255
	{ 0x9b3e0000, 0x9b3effff, REGISTRY_APNIC      }, // 155.62.0.0      - 155.62.255.255
	{ 0x9b3f0000, 0x9b41ffff, REGISTRY_ARIN       }, // 155.63.0.0      - 155.65.255.255
	{ 0x9b420000, 0x9b42ffff, REGISTRY_RIPENCC    }, // 155.66.0.0      - 155.66.255.255
	{ 0x9b430000, 0x9b44ffff, REGISTRY_ARIN       }, // 155.67.0.0      - 155.68.255.255
	{ 0x9b450000, 0x9b45ffff, REGISTRY_APNIC      }, // 155.69.0.0      - 155.69.255.255
	{ 0x9b460000, 0x9b46ffff, REGISTRY_ARIN       }, // 155.70.0.0      - 155.70.255.255
	{ 0x9b470000, 0x9b47ffff, REGISTRY_APNIC      }, // 155.71.0.0      - 155.71.255.255
	{ 0x9b480000, 0x9b48ffff, REGISTRY_ARIN       }, // 155.72.0.0      - 155.72.255.255
	{ 0x9b490000, 0x9b49ffff, REGISTRY_RIPENCC    }, // 155.73.0.0      - 155.73.255.255
	{ 0x9b4a0000, 0x9b58ffff, REGISTRY_ARIN       }, // 155.74.0.0      - 155.88.255.255
	{ 0x9b590000, 0x9b59ffff, REGISTRY_AFRINIC    }, // 155.89.0.0      - 155.89.255.255
	{ 0x9b5a0000, 0x9b5cffff, REGISTRY_ARIN       }, // 155.90.0.0      - 155.92.255.255
	{ 0x9b5d0000, 0x9b5dffff, REGISTRY_AFRINIC    }, // 155.93.0.0      - 155.93.255.255
	{ 0x9b5e0000, 0x9b68ffff, REGISTRY_ARIN       }, // 155.94.0.0      - 155.104.255.255
	{ 0x9b690000, 0x9b69ffff, REGISTRY_RIPENCC    }, // 155.105.0.0     - 155.105.255.255
	{ 0x9b6a0000, 0x9b82ffff, REGISTRY_ARIN       }, // 155.106.0.0     - 155.130.255.255
	{ 0x9b830000, 0x9b85ffff, REGISTRY_RIPENCC    }, // 155.131.0.0     - 155.133.255.255
	{ 0x9b860000, 0x9b87ffff, REGISTRY_ARIN       }, // 155.134.0.0     - 155.135.255.255
	{ 0x9b880000, 0x9b89ffff, REGISTRY_RIPENCC    }, // 155.136.0.0     - 155.137.255.255
	{ 0x9b8a0000, 0x9b8a3fff, REGISTRY_ARIN       }, // 155.138.0.0     - 155.138.63.255
	{ 0x9b8a4000, 0x9b8a7fff, REGISTRY_RIPENCC    }, // 155.138.64.0    - 155.138.127.255
	{ 0x9b8a8000, 0x9b8bffff, REGISTRY_ARIN       }, // 155.138.128.0   - 155.139.255.255
	{ 0x9b8c0000, 0x9b8cffff, REGISTRY_RIPENCC    }, // 155.140.0.0     - 155.140.255.255
	{ 0x9b8d0000, 0x9b8effff, REGISTRY_ARIN       }, // 155.141.0.0     - 155.142.255.255
	{ 0x9b8f0000, 0x9b90ffff, REGISTRY_APNIC      }, // 155.143.0.0     - 155.144.255.255
	{ 0x9b910000, 0x9b91ffff, REGISTRY_RIPENCC    }, // 155.145.0.0     - 155.145.255.255
	{ 0x9b920000, 0x9b9dffff, REGISTRY_ARIN       }, // 155.146.0.0     - 155.157.255.255
	{ 0x9b9e0000, 0x9b9effff, REGISTRY_RIPENCC    }, // 155.158.0.0     - 155.158.255.255
	{ 0x9b9f0000, 0x9b9fffff, REGISTRY_AFRINIC    }, // 155.159.0.0     - 155.159.255.255
	{ 0x9ba00000, 0x9ba0ffff, REGISTRY_APNIC      }, // 155.160.0.0     - 155.160.255.255
	{ 0x9ba10000, 0x9bb8ffff, REGISTRY_ARIN       }, // 155.161.0.0     - 155.184.255.255
	{ 0x9bb90000, 0x9bb9ffff, REGISTRY_RIPENCC    }, // 155.185.0.0     - 155.185.255.255
	{ 0x9bba0000, 0x9bbaffff, REGISTRY_ARIN       }, // 155.186.0.0     - 155.186.255.255
	{ 0x9bbb0000, 0x9bbbffff, REGISTRY_APNIC      }, // 155.187.0.0     - 155.187.255.255
	{ 0x9bbc0000, 0x9bbfffff, REGISTRY_ARIN       }, // 155.188.0.0     - 155.191.255.255
	{ 0x9bc00000, 0x9bc0ffff, REGISTRY_RIPENCC    }, // 155.192.0.0     - 155.192.255.255
	{ 0x9bc10000, 0x9bc3ffff, REGISTRY_ARIN       }, // 155.193.0.0     - 155.195.255.255
	{ 0x9bc40000, 0x9bc4ffff, REGISTRY_AFRINIC    }, // 155.196.0.0     - 155.196.255.255
	{ 0x9bc50000, 0x9bc5ffff, REGISTRY_ARIN       }, // 155.197.0.0     - 155.197.255.255
	{ 0x9bc60000, 0x9bc6ffff, REGISTRY_RIPENCC    }, // 155.198.0.0     - 155.198.255.255
	{ 0x9bc70000, 0x9bc9ffff, REGISTRY_ARIN       }, // 155.199.0.0     - 155.201.255.255
	{ 0x9bca0000, 0x9bcaffff, REGISTRY_RIPENCC    }, // 155.202.0.0     - 155.202.255.255
	{ 0x9bcb0000, 0x9bcbffff, REGISTRY_ARIN       }, // 155.203.0.0     - 155.203.255.255
	{ 0x9bcc0000, 0x9bccffff, REGISTRY_RIPENCC    }, // 155.204.0.0     - 155.204.255.255
	{ 0x9bcd0000, 0x9bcdffff, REGISTRY_APNIC      }, // 155.205.0.0     - 155.205.255.255
	{ 0x9bce0000, 0x9bceffff, REGISTRY_ARIN       }, // 155.206.0.0     - 155.206.255.255
	{ 0x9bcf0000, 0x9bcfffff, REGISTRY_RIPENCC    }, // 155.207.0.0     - 155.207.255.255
	{ 0x9bd00000, 0x9bd0ffff, REGISTRY_ARIN       }, // 155.208.0.0     - 155.208.255.255
	{ 0x9bd10000, 0x9bd2ffff, REGISTRY_RIPENCC    }, // 155.209.0.0     - 155.210.255.255
	{ 0x9bd30000, 0x9bd3ffff, REGISTRY_LACNIC     }, // 155.211.0.0     - 155.211.255.255
	{ 0x9bd40000, 0x9bdeffff, REGISTRY_ARIN       }, // 155.212.0.0     - 155.222.255.255
	{ 0x9bdf0000, 0x9bdfffff, REGISTRY_RIPENCC    }, // 155.223.0.0     - 155.223.255.255
	{ 0x9be00000, 0x9be2ffff, REGISTRY_ARIN       }, // 155.224.0.0     - 155.226.255.255
	{ 0x9be30000, 0x9be4ffff, REGISTRY_RIPENCC    }, // 155.227.0.0     - 155.228.255.255
	{ 0x9be50000, 0x9be5ffff, REGISTRY_ARIN       }, // 155.229.0.0     - 155.229.255.255
	{ 0x9be60000, 0x9be6ffff, REGISTRY_APNIC      }, // 155.230.0.0     - 155.230.255.255
	{ 0x9be70000, 0x9be7ffff, REGISTRY_RIPENCC    }, // 155.231.0.0     - 155.231.255.255
	{ 0x9be80000, 0x9bf0ffff, REGISTRY_AFRINIC    }, // 155.232.0.0     - 155.240.255.255
	{ 0x9bf10000, 0x9bf4ffff, REGISTRY_ARIN       }, // 155.241.0.0     - 155.244.255.255
	{ 0x9bf50000, 0x9bf5ffff, REGISTRY_RIPENCC    }, // 155.245.0.0     - 155.245.255.255
	{ 0x9bf60000, 0x9bf8ffff, REGISTRY_ARIN       }, // 155.246.0.0     - 155.248.255.255
	{ 0x9bf90000, 0x9bfaffff, REGISTRY_RIPENCC    }, // 155.249.0.0     - 155.250.255.255
	{ 0x9bfb0000, 0x9bfbffff, REGISTRY_AFRINIC    }, // 155.251.0.0     - 155.251.255.255
	{ 0x9bfc0000, 0x9bfcffff, REGISTRY_ARIN       }, // 155.252.0.0     - 155.252.255.255
	{ 0x9bfd0000, 0x9bfdffff, REGISTRY_RIPENCC    }, // 155.253.0.0     - 155.253.255.255
	{ 0x9bfe0000, 0x9bfe1fff, REGISTRY_ARIN       }, // 155.254.0.0     - 155.254.31.255
	{ 0x9bfe2000, 0x9bfe3fff, REGISTRY_RIPENCC    }, // 155.254.32.0    - 155.254.63.255
	{ 0x9bfe4000, 0x9bfeffff, REGISTRY_ARIN       }, // 155.254.64.0    - 155.254.255.255
	{ 0x9bff0000, 0x9c00cbff, REGISTRY_AFRINIC    }, // 155.255.0.0     - 156.0.203.255
	{ 0x9c00d000, 0x9c00ffff, REGISTRY_AFRINIC    }, // 156.0.208.0     - 156.0.255.255
	{ 0x9c010000, 0x9c07ffff, REGISTRY_ARIN       }, // 156.1.0.0       - 156.7.255.255
	{ 0x9c080000, 0x9c08ffff, REGISTRY_AFRINIC    }, // 156.8.0.0       - 156.8.255.255
	{ 0x9c090000, 0x9c09ffff, REGISTRY_ARIN       }, // 156.9.0.0       - 156.9.255.255
	{ 0x9c0a0000, 0x9c0affff, REGISTRY_RIPENCC    }, // 156.10.0.0      - 156.10.255.255
	{ 0x9c0b0000, 0x9c0cffff, REGISTRY_ARIN       }, // 156.11.0.0      - 156.12.255.255
	{ 0x9c0d0000, 0x9c0dffff, REGISTRY_APNIC      }, // 156.13.0.0      - 156.13.255.255
	{ 0x9c0e0000, 0x9c0effff, REGISTRY_RIPENCC    }, // 156.14.0.0      - 156.14.255.255
	{ 0x9c0f0000, 0x9c0fffff, REGISTRY_ARIN       }, // 156.15.0.0      - 156.15.255.255
	{ 0x9c110000, 0x9c12ffff, REGISTRY_RIPENCC    }, // 156.17.0.0      - 156.18.255.255
	{ 0x9c130000, 0x9c15ffff, REGISTRY_ARIN       }, // 156.19.0.0      - 156.21.255.255
	{ 0x9c160000, 0x9c16ffff, REGISTRY_APNIC      }, // 156.22.0.0      - 156.22.255.255
	{ 0x9c170000, 0x9c18ffff, REGISTRY_ARIN       }, // 156.23.0.0      - 156.24.255.255
	{ 0x9c190000, 0x9c19ffff, REGISTRY_RIPENCC    }, // 156.25.0.0      - 156.25.255.255
	{ 0x9c1a0000, 0x9c1bffff, REGISTRY_ARIN       }, // 156.26.0.0      - 156.27.255.255
	{ 0x9c1c0000, 0x9c1cffff, REGISTRY_RIPENCC    }, // 156.28.0.0      - 156.28.255.255
	{ 0x9c1d0000, 0x9c1effff, REGISTRY_ARIN       }, // 156.29.0.0      - 156.30.255.255
	{ 0x9c1f0000, 0x9c1fffff, REGISTRY_APNIC      }, // 156.31.0.0      - 156.31.255.255
	{ 0x9c200000, 0x9c22ffff, REGISTRY_ARIN       }, // 156.32.0.0      - 156.34.255.255
	{ 0x9c230000, 0x9c23ffff, REGISTRY_RIPENCC    }, // 156.35.0.0      - 156.35.255.255
	{ 0x9c240000, 0x9c25ffff, REGISTRY_ARIN       }, // 156.36.0.0      - 156.37.255.255
	{ 0x9c260000, 0x9c26ffff, REGISTRY_AFRINIC    }, // 156.38.0.0      - 156.38.255.255
	{ 0x9c270000, 0x9c2affff, REGISTRY_ARIN       }, // 156.39.0.0      - 156.42.255.255
	{ 0x9c2b0000, 0x9c2bffff, REGISTRY_RIPENCC    }, // 156.43.0.0      - 156.43.255.255
	{ 0x9c2c0000, 0x9c2fffff, REGISTRY_ARIN       }, // 156.44.0.0      - 156.47.255.255
	{ 0x9c300000, 0x9c31ffff, REGISTRY_RIPENCC    }, // 156.48.0.0      - 156.49.255.255
	{ 0x9c320000, 0x9c32ffff, REGISTRY_APNIC      }, // 156.50.0.0      - 156.50.255.255
	{ 0x9c330000, 0x9c34ffff, REGISTRY_RIPENCC    }, // 156.51.0.0      - 156.52.255.255
	{ 0x9c350000, 0x9c35ffff, REGISTRY_ARIN       }, // 156.53.0.0      - 156.53.255.255
	{ 0x9c360000, 0x9c36ffff, REGISTRY_RIPENCC    }, // 156.54.0.0      - 156.54.255.255
	{ 0x9c370000, 0x9c39ffff, REGISTRY_ARIN       }, // 156.55.0.0      - 156.57.255.255
	{ 0x9c3a0000, 0x9c3affff, REGISTRY_RIPENCC    }, // 156.58.0.0      - 156.58.255.255
	{ 0x9c3b0000, 0x9c3bffff, REGISTRY_APNIC      }, // 156.59.0.0      - 156.59.255.255
	{ 0x9c3c0000, 0x9c3cffff, REGISTRY_ARIN       }, // 156.60.0.0      - 156.60.255.255
	{ 0x9c3d0000, 0x9c3dffff, REGISTRY_RIPENCC    }, // 156.61.0.0      - 156.61.255.255
	{ 0x9c3e0000, 0x9c3effff, REGISTRY_APNIC      }, // 156.62.0.0      - 156.62.255.255
	{ 0x9c3f0000, 0x9c42ffff, REGISTRY_ARIN       }, // 156.63.0.0      - 156.66.255.255
	{ 0x9c430000, 0x9c4307ff, REGISTRY_RIPENCC    }, // 156.67.0.0      - 156.67.7.255
	{ 0x9c430800, 0x9c430bff, REGISTRY_RIPENCC    }, // 156.67.8.0      - 156.67.11.255
	{ 0x9c430c00, 0x9c4337ff, REGISTRY_RIPENCC    }, // 156.67.12.0     - 156.67.55.255
	{ 0x9c433800, 0x9c433bff, REGISTRY_RIPENCC    }, // 156.67.56.0     - 156.67.59.255
	{ 0x9c433c00, 0x9c43c7ff, REGISTRY_RIPENCC    }, // 156.67.60.0     - 156.67.199.255
	{ 0x9c43c800, 0x9c43cfff, REGISTRY_RIPENCC    }, // 156.67.200.0    - 156.67.207.255
	{ 0x9c43d000, 0x9c43ffff, REGISTRY_RIPENCC    }, // 156.67.208.0    - 156.67.255.255
	{ 0x9c440000, 0x9c44ffff, REGISTRY_ARIN       }, // 156.68.0.0      - 156.68.255.255
	{ 0x9c450000, 0x9c45ffff, REGISTRY_APNIC      }, // 156.69.0.0      - 156.69.255.255
	{ 0x9c460000, 0x9c52ffff, REGISTRY_ARIN       }, // 156.70.0.0      - 156.82.255.255
	{ 0x9c530000, 0x9c53ffff, REGISTRY_RIPENCC    }, // 156.83.0.0      - 156.83.255.255
	{ 0x9c540000, 0x9c60ffff, REGISTRY_ARIN       }, // 156.84.0.0      - 156.96.255.255
	{ 0x9c610000, 0x9c61ffff, REGISTRY_LACNIC     }, // 156.97.0.0      - 156.97.255.255
	{ 0x9c620000, 0x9c69ffff, REGISTRY_ARIN       }, // 156.98.0.0      - 156.105.255.255
	{ 0x9c6a0000, 0x9c6affff, REGISTRY_RIPENCC    }, // 156.106.0.0     - 156.106.255.255
	{ 0x9c6b0000, 0x9c71ffff, REGISTRY_ARIN       }, // 156.107.0.0     - 156.113.255.255
	{ 0x9c720000, 0x9c74ffff, REGISTRY_RIPENCC    }, // 156.114.0.0     - 156.116.255.255
	{ 0x9c750000, 0x9c75ffff, REGISTRY_ARIN       }, // 156.117.0.0     - 156.117.255.255
	{ 0x9c760000, 0x9c76ffff, REGISTRY_RIPENCC    }, // 156.118.0.0     - 156.118.255.255
	{ 0x9c770000, 0x9c84ffff, REGISTRY_ARIN       }, // 156.119.0.0     - 156.132.255.255
	{ 0x9c850000, 0x9c85ffff, REGISTRY_RIPENCC    }, // 156.133.0.0     - 156.133.255.255
	{ 0x9c860000, 0x9c86ffff, REGISTRY_ARIN       }, // 156.134.0.0     - 156.134.255.255
	{ 0x9c870000, 0x9c87ffff, REGISTRY_RIPENCC    }, // 156.135.0.0     - 156.135.255.255
	{ 0x9c880000, 0x9c92ffff, REGISTRY_ARIN       }, // 156.136.0.0     - 156.146.255.255
	{ 0x9c930000, 0x9c93ffff, REGISTRY_APNIC      }, // 156.147.0.0     - 156.147.255.255
	{ 0x9c940000, 0x9c94ffff, REGISTRY_RIPENCC    }, // 156.148.0.0     - 156.148.255.255
	{ 0x9c950000, 0x9c95ffff, REGISTRY_APNIC      }, // 156.149.0.0     - 156.149.255.255
	{ 0x9c960000, 0x9c96ffff, REGISTRY_RIPENCC    }, // 156.150.0.0     - 156.150.255.255
	{ 0x9c970000, 0x9c9affff, REGISTRY_ARIN       }, // 156.151.0.0     - 156.154.255.255
	{ 0x9c9b0000, 0x9cffffff, REGISTRY_AFRINIC    }, // 156.155.0.0     - 156.255.255.255
	{ 0x9d000000, 0x9d04ffff, REGISTRY_APNIC      }, // 157.0.0.0       - 157.4.255.255
	{ 0x9d060000, 0x9d09ffff, REGISTRY_APNIC      }, // 157.6.0.0       - 157.9.255.255
	{ 0x9d0b0000, 0x9d0effff, REGISTRY_APNIC      }, // 157.11.0.0      - 157.14.255.255
	{ 0x9d100000, 0x9d13ffff, REGISTRY_APNIC      }, // 157.16.0.0      - 157.19.255.255
	{ 0x9d150000, 0x9d16ffff, REGISTRY_ARIN       }, // 157.21.0.0      - 157.22.255.255
	{ 0x9d170000, 0x9d1dffff, REGISTRY_RIPENCC    }, // 157.23.0.0      - 157.29.255.255
	{ 0x9d1e0000, 0x9d1fffff, REGISTRY_ARIN       }, // 157.30.0.0      - 157.31.255.255
	{ 0x9d200000, 0x9d33ffff, REGISTRY_APNIC      }, // 157.32.0.0      - 157.51.255.255
	{ 0x9d340000, 0x9d3cffff, REGISTRY_ARIN       }, // 157.52.0.0      - 157.60.255.255
	{ 0x9d3d0000, 0x9d3dffff, REGISTRY_APNIC      }, // 157.61.0.0      - 157.61.255.255
	{ 0x9d3e0000, 0x9d3effff, REGISTRY_ARIN       }, // 157.62.0.0      - 157.62.255.255
	{ 0x9d3f0000, 0x9d41ffff, REGISTRY_APNIC      }, // 157.63.0.0      - 157.65.255.255
	{ 0x9d430000, 0x9d50ffff, REGISTRY_APNIC      }, // 157.67.0.0      - 157.80.255.255
	{ 0x9d520000, 0x9d52ffff, REGISTRY_APNIC      }, // 157.82.0.0      - 157.82.255.255
	{ 0x9d530000, 0x9d54ffff, REGISTRY_RIPENCC    }, // 157.83.0.0      - 157.84.255.255
	{ 0x9d550000, 0x9d55ffff, REGISTRY_APNIC      }, // 157.85.0.0      - 157.85.255.255
	{ 0x9d560000, 0x9d56ffff, REGISTRY_LACNIC     }, // 157.86.0.0      - 157.86.255.255
	{ 0x9d570000, 0x9d57ffff, REGISTRY_ARIN       }, // 157.87.0.0      - 157.87.255.255
	{ 0x9d580000, 0x9d58ffff, REGISTRY_RIPENCC    }, // 157.88.0.0      - 157.88.255.255
	{ 0x9d590000, 0x9d5bffff, REGISTRY_ARIN       }, // 157.89.0.0      - 157.91.255.255
	{ 0x9d5c0000, 0x9d5cffff, REGISTRY_LACNIC     }, // 157.92.0.0      - 157.92.255.255
	{ 0x9d5d0000, 0x9d5dffff, REGISTRY_ARIN       }, // 157.93.0.0      - 157.93.255.255
	{ 0x9d5e0000, 0x9d5effff, REGISTRY_RIPENCC    }, // 157.94.0.0      - 157.94.255.255
	{ 0x9d5f0000, 0x9d5fffff, REGISTRY_ARIN       }, // 157.95.0.0      - 157.95.255.255
	{ 0x9d600000, 0x9d6157ff, REGISTRY_RIPENCC    }, // 157.96.0.0      - 157.97.87.255
	{ 0x9d615800, 0x9d615fff, REGISTRY_RIPENCC    }, // 157.97.88.0     - 157.97.95.255
	{ 0x9d616000, 0x9d61ffff, REGISTRY_RIPENCC    }, // 157.97.96.0     - 157.97.255.255
	{ 0x9d620000, 0x9d62ffff, REGISTRY_ARIN       }, // 157.98.0.0      - 157.98.255.255
	{ 0x9d630000, 0x9d63ffff, REGISTRY_RIPENCC    }, // 157.99.0.0      - 157.99.255.255
	{ 0x9d640000, 0x9d64ffff, REGISTRY_LACNIC     }, // 157.100.0.0     - 157.100.255.255
	{ 0x9d650000, 0x9d78bfff, REGISTRY_APNIC      }, // 157.101.0.0     - 157.120.191.255
	{ 0x9d78c000, 0x9d78dfff, REGISTRY_ARIN       }, // 157.120.192.0   - 157.120.223.255
	{ 0x9d78e000, 0x9d78e7ff, REGISTRY_RIPENCC    }, // 157.120.224.0   - 157.120.231.255
	{ 0x9d78e800, 0x9d78ebff, REGISTRY_APNIC      }, // 157.120.232.0   - 157.120.235.255
	{ 0x9d78ec00, 0x9d78ffff, REGISTRY_RIPENCC    }, // 157.120.236.0   - 157.120.255.255
	{ 0x9d790000, 0x9d79ffff, REGISTRY_ARIN       }, // 157.121.0.0     - 157.121.255.255
	{ 0x9d7a0000, 0x9d7affff, REGISTRY_APNIC      }, // 157.122.0.0     - 157.122.255.255
	{ 0x9d7b0000, 0x9d7bffff, REGISTRY_ARIN       }, // 157.123.0.0     - 157.123.255.255
	{ 0x9d7c0000, 0x9d7dffff, REGISTRY_RIPENCC    }, // 157.124.0.0     - 157.125.255.255
	{ 0x9d7e0000, 0x9d7fffff, REGISTRY_ARIN       }, // 157.126.0.0     - 157.127.255.255
	{ 0x9d800000, 0x9d80ffff, REGISTRY_APNIC      }, // 157.128.0.0     - 157.128.255.255
	{ 0x9d810000, 0x9d81ffff, REGISTRY_RIPENCC    }, // 157.129.0.0     - 157.129.255.255
	{ 0x9d820000, 0x9d87ffff, REGISTRY_ARIN       }, // 157.130.0.0     - 157.135.255.255
	{ 0x9d880000, 0x9d88ffff, REGISTRY_RIPENCC    }, // 157.136.0.0     - 157.136.255.255
	{ 0x9d890000, 0x9d89ffff, REGISTRY_ARIN       }, // 157.137.0.0     - 157.137.255.255
	{ 0x9d8a0000, 0x9d8affff, REGISTRY_RIPENCC    }, // 157.138.0.0     - 157.138.255.255
	{ 0x9d8b0000, 0x9d8bffff, REGISTRY_ARIN       }, // 157.139.0.0     - 157.139.255.255
	{ 0x9d8c0000, 0x9d8cffff, REGISTRY_RIPENCC    }, // 157.140.0.0     - 157.140.255.255
	{ 0x9d8d0000, 0x9d8fffff, REGISTRY_ARIN       }, // 157.141.0.0     - 157.143.255.255
	{ 0x9d900000, 0x9d90ffff, REGISTRY_RIPENCC    }, // 157.144.0.0     - 157.144.255.255
	{ 0x9d910000, 0x9d92ffff, REGISTRY_ARIN       }, // 157.145.0.0     - 157.146.255.255
	{ 0x9d930000, 0x9d94ffff, REGISTRY_APNIC      }, // 157.147.0.0     - 157.148.255.255
	{ 0x9d950000, 0x9d9affff, REGISTRY_ARIN       }, // 157.149.0.0     - 157.154.255.255
	{ 0x9d9b0000, 0x9d9cffff, REGISTRY_APNIC      }, // 157.155.0.0     - 157.156.255.255
	{ 0x9d9d0000, 0x9d9fffff, REGISTRY_RIPENCC    }, // 157.157.0.0     - 157.159.255.255
	{ 0x9da00000, 0x9da0ffff, REGISTRY_ARIN       }, // 157.160.0.0     - 157.160.255.255
	{ 0x9da10000, 0x9da2ffff, REGISTRY_RIPENCC    }, // 157.161.0.0     - 157.162.255.255
	{ 0x9da30000, 0x9da3ffff, REGISTRY_RIPENCC    }, // 157.163.0.0     - 157.163.255.255
	{ 0x9da40000, 0x9da4ffff, REGISTRY_RIPENCC    }, // 157.164.0.0     - 157.164.255.255
	{ 0x9da50000, 0x9da6ffff, REGISTRY_ARIN       }, // 157.165.0.0     - 157.166.255.255
	{ 0x9da70000, 0x9da9ffff, REGISTRY_RIPENCC    }, // 157.167.0.0     - 157.169.255.255
	{ 0x9daa0000, 0x9daaffff, REGISTRY_ARIN       }, // 157.170.0.0     - 157.170.255.255
	{ 0x9dab0000, 0x9dadffff, REGISTRY_RIPENCC    }, // 157.171.0.0     - 157.173.255.255
	{ 0x9dae0000, 0x9db0ffff, REGISTRY_ARIN       }, // 157.174.0.0     - 157.176.255.255
	{ 0x9db10000, 0x9db1ffff, REGISTRY_RIPENCC    }, // 157.177.0.0     - 157.177.255.255
	{ 0x9db20000, 0x9db2ffff, REGISTRY_ARIN       }, // 157.178.0.0     - 157.178.255.255
	{ 0x9db30000, 0x9db3ffff, REGISTRY_APNIC      }, // 157.179.0.0     - 157.179.255.255
	{ 0x9db40000, 0x9db5ffff, REGISTRY_RIPENCC    }, // 157.180.0.0     - 157.181.255.255
	{ 0x9db60000, 0x9db9bfff, REGISTRY_ARIN       }, // 157.182.0.0     - 157.185.191.255
	{ 0x9db9c000, 0x9db9ffff, REGISTRY_APNIC      }, // 157.185.192.0   - 157.185.255.255
	{ 0x9dba0000, 0x9dbaffff, REGISTRY_RIPENCC    }, // 157.186.0.0     - 157.186.255.255
	{ 0x9dbb0000, 0x9dbdffff, REGISTRY_ARIN       }, // 157.187.0.0     - 157.189.255.255
	{ 0x9dbe0000, 0x9dbeffff, REGISTRY_RIPENCC    }, // 157.190.0.0     - 157.190.255.255
	{ 0x9dbf0000, 0x9dbfffff, REGISTRY_ARIN       }, // 157.191.0.0     - 157.191.255.255
	{ 0x9dc00000, 0x9dc0ffff, REGISTRY_APNIC      }, // 157.192.0.0     - 157.192.255.255
	{ 0x9dc10000, 0x9dc1ffff, REGISTRY_RIPENCC    }, // 157.193.0.0     - 157.193.255.255
	{ 0x9dc20000, 0x9dc4ffff, REGISTRY_ARIN       }, // 157.194.0.0     - 157.196.255.255
	{ 0x9dc50000, 0x9dc5ffff, REGISTRY_APNIC      }, // 157.197.0.0     - 157.197.255.255
	{ 0x9dc60000, 0x9dc7ffff, REGISTRY_ARIN       }, // 157.198.0.0     - 157.199.255.255
	{ 0x9dc80000, 0x9dc8ffff, REGISTRY_RIPENCC    }, // 157.200.0.0     - 157.200.255.255
	{ 0x9dc90000, 0x9dcaffff, REGISTRY_ARIN       }, // 157.201.0.0     - 157.202.255.255
	{ 0x9dcb0000, 0x9dcbffff, REGISTRY_RIPENCC    }, // 157.203.0.0     - 157.203.255.255
	{ 0x9dcc0000, 0x9dccffff, REGISTRY_ARIN       }, // 157.204.0.0     - 157.204.255.255
	{ 0x9dcd0000, 0x9dcdffff, REGISTRY_APNIC      }, // 157.205.0.0     - 157.205.255.255
	{ 0x9dce0000, 0x9dd2ffff, REGISTRY_ARIN       }, // 157.206.0.0     - 157.210.255.255
	{ 0x9dd30000, 0x9dd3ffff, REGISTRY_APNIC      }, // 157.211.0.0     - 157.211.255.255
	{ 0x9dd40000, 0x9de2ffff, REGISTRY_ARIN       }, // 157.212.0.0     - 157.226.255.255
	{ 0x9de30000, 0x9de3ffff, REGISTRY_APNIC      }, // 157.227.0.0     - 157.227.255.255
	{ 0x9de40000, 0x9de4ffff, REGISTRY_RIPENCC    }, // 157.228.0.0     - 157.228.255.255
	{ 0x9de50000, 0x9de6ffff, REGISTRY_ARIN       }, // 157.229.0.0     - 157.230.255.255
	{ 0x9de70000, 0x9de7ffff, REGISTRY_RIPENCC    }, // 157.231.0.0     - 157.231.255.255
	{ 0x9de80000, 0x9debffff, REGISTRY_ARIN       }, // 157.232.0.0     - 157.235.255.255
	{ 0x9dec0000, 0x9dedffff, REGISTRY_RIPENCC    }, // 157.236.0.0     - 157.237.255.255
	{ 0x9dee0000, 0x9df2ffff, REGISTRY_ARIN       }, // 157.238.0.0     - 157.242.255.255
	{ 0x9df30000, 0x9df3ffff, REGISTRY_RIPENCC    }, // 157.243.0.0     - 157.243.255.255
	{ 0x9df40000, 0x9df6ffff, REGISTRY_ARIN       }, // 157.244.0.0     - 157.246.255.255
	{ 0x9df70000, 0x9df7ffff, REGISTRY_RIPENCC    }, // 157.247.0.0     - 157.247.255.255
	{ 0x9df80000, 0x9df8ffff, REGISTRY_ARIN       }, // 157.248.0.0     - 157.248.255.255
	{ 0x9df90000, 0x9df9ffff, REGISTRY_RIPENCC    }, // 157.249.0.0     - 157.249.255.255
	{ 0x9dfa0000, 0x9dfa3fff, REGISTRY_ARIN       }, // 157.250.0.0     - 157.250.63.255
	{ 0x9dfa4000, 0x9dfaffff, REGISTRY_APNIC      }, // 157.250.64.0    - 157.250.255.255
	{ 0x9dfb0000, 0x9dfcffff, REGISTRY_ARIN       }, // 157.251.0.0     - 157.252.255.255
	{ 0x9dfd0000, 0x9dfdffff, REGISTRY_LACNIC     }, // 157.253.0.0     - 157.253.255.255
	{ 0x9dfe0000, 0x9dfeffff, REGISTRY_ARIN       }, // 157.254.0.0     - 157.254.255.255
	{ 0x9dff0000, 0x9dffffff, REGISTRY_APNIC      }, // 157.255.0.0     - 157.255.255.255
	{ 0x9e000000, 0x9e23ffff, REGISTRY_ARIN       }, // 158.0.0.0       - 158.35.255.255
	{ 0x9e240000, 0x9e27ffff, REGISTRY_RIPENCC    }, // 158.36.0.0      - 158.39.255.255
	{ 0x9e280000, 0x9e28ffff, REGISTRY_APNIC      }, // 158.40.0.0      - 158.40.255.255
	{ 0x9e290000, 0x9e2bffff, REGISTRY_RIPENCC    }, // 158.41.0.0      - 158.43.255.255
	{ 0x9e2c0000, 0x9e2dffff, REGISTRY_APNIC      }, // 158.44.0.0      - 158.45.255.255
	{ 0x9e2e0000, 0x9e2effff, REGISTRY_RIPENCC    }, // 158.46.0.0      - 158.46.255.255
	{ 0x9e2f0000, 0x9e2fffff, REGISTRY_RIPENCC    }, // 158.47.0.0      - 158.47.255.255
	{ 0x9e300000, 0x9e30ffff, REGISTRY_ARIN       }, // 158.48.0.0      - 158.48.255.255
	{ 0x9e310000, 0x9e32ffff, REGISTRY_RIPENCC    }, // 158.49.0.0      - 158.50.255.255
	{ 0x9e330000, 0x9e35ffff, REGISTRY_ARIN       }, // 158.51.0.0      - 158.53.255.255
	{ 0x9e360000, 0x9e36ffff, REGISTRY_APNIC      }, // 158.54.0.0      - 158.54.255.255
	{ 0x9e370000, 0x9e39ffff, REGISTRY_ARIN       }, // 158.55.0.0      - 158.57.255.255
	{ 0x9e3a0000, 0x9e3affff, REGISTRY_RIPENCC    }, // 158.58.0.0      - 158.58.255.255
	{ 0x9e3b0000, 0x9e3bffff, REGISTRY_ARIN       }, // 158.59.0.0      - 158.59.255.255
	{ 0x9e3c0000, 0x9e3cffff, REGISTRY_RIPENCC    }, // 158.60.0.0      - 158.60.255.255
	{ 0x9e3d0000, 0x9e3fffff, REGISTRY_ARIN       }, // 158.61.0.0      - 158.63.255.255
	{ 0x9e400000, 0x9e40ffff, REGISTRY_RIPENCC    }, // 158.64.0.0      - 158.64.255.255
	{ 0x9e410000, 0x9e41ffff, REGISTRY_ARIN       }, // 158.65.0.0      - 158.65.255.255
	{ 0x9e420000, 0x9e43ffff, REGISTRY_RIPENCC    }, // 158.66.0.0      - 158.67.255.255
	{ 0x9e440000, 0x9e4affff, REGISTRY_ARIN       }, // 158.68.0.0      - 158.74.255.255
	{ 0x9e4b0000, 0x9e4bffff, REGISTRY_RIPENCC    }, // 158.75.0.0      - 158.75.255.255
	{ 0x9e4c0000, 0x9e58ffff, REGISTRY_ARIN       }, // 158.76.0.0      - 158.88.255.255
	{ 0x9e590000, 0x9e59ffff, REGISTRY_APNIC      }, // 158.89.0.0      - 158.89.255.255
	{ 0x9e5a0000, 0x9e5affff, REGISTRY_RIPENCC    }, // 158.90.0.0      - 158.90.255.255
	{ 0x9e5b0000, 0x9e5bffff, REGISTRY_ARIN       }, // 158.91.0.0      - 158.91.255.255
	{ 0x9e5c0000, 0x9e5cffff, REGISTRY_RIPENCC    }, // 158.92.0.0      - 158.92.255.255
	{ 0x9e5d0000, 0x9e5dffff, REGISTRY_ARIN       }, // 158.93.0.0      - 158.93.255.255
	{ 0x9e5e0000, 0x9e5effff, REGISTRY_RIPENCC    }, // 158.94.0.0      - 158.94.255.255
	{ 0x9e5f0000, 0x9e60ffff, REGISTRY_ARIN       }, // 158.95.0.0      - 158.96.255.255
	{ 0x9e610000, 0x9e61ffff, REGISTRY_LACNIC     }, // 158.97.0.0      - 158.97.255.255
	{ 0x9e620000, 0x9e62ffff, REGISTRY_ARIN       }, // 158.98.0.0      - 158.98.255.255
	{ 0x9e630000, 0x9e63ffff, REGISTRY_RIPENCC    }, // 158.99.0.0      - 158.99.255.255
	{ 0x9e640000, 0x9e65ffff, REGISTRY_ARIN       }, // 158.100.0.0     - 158.101.255.255
	{ 0x9e660000, 0x9e66ffff, REGISTRY_RIPENCC    }, // 158.102.0.0     - 158.102.255.255
	{ 0x9e670000, 0x9e68ffff, REGISTRY_ARIN       }, // 158.103.0.0     - 158.104.255.255
	{ 0x9e690000, 0x9e69ffff, REGISTRY_RIPENCC    }, // 158.105.0.0     - 158.105.255.255
	{ 0x9e6a0000, 0x9e6bffff, REGISTRY_ARIN       }, // 158.106.0.0     - 158.107.255.255
	{ 0x9e6c0000, 0x9e6cffff, REGISTRY_APNIC      }, // 158.108.0.0     - 158.108.255.255
	{ 0x9e6d0000, 0x9e6effff, REGISTRY_RIPENCC    }, // 158.109.0.0     - 158.110.255.255
	{ 0x9e6f0000, 0x9e6fffff, REGISTRY_ARIN       }, // 158.111.0.0     - 158.111.255.255
	{ 0x9e700000, 0x9e70ffff, REGISTRY_RIPENCC    }, // 158.112.0.0     - 158.112.255.255
	{ 0x9e710000, 0x9e76ffff, REGISTRY_ARIN       }, // 158.113.0.0     - 158.118.255.255
	{ 0x9e770000, 0x9e77ffff, REGISTRY_RIPENCC    }, // 158.119.0.0     - 158.119.255.255
	{ 0x9e780000, 0x9e7bffff, REGISTRY_ARIN       }, // 158.120.0.0     - 158.123.255.255
	{ 0x9e7c0000, 0x9e7fffff, REGISTRY_RIPENCC    }, // 158.124.0.0     - 158.127.255.255
	{ 0x9e800000, 0x9e80ffff, REGISTRY_ARIN       }, // 158.128.0.0     - 158.128.255.255
	{ 0x9e810000, 0x9e81ffff, REGISTRY_RIPENCC    }, // 158.129.0.0     - 158.129.255.255
	{ 0x9e820000, 0x9e82ffff, REGISTRY_ARIN       }, // 158.130.0.0     - 158.130.255.255
	{ 0x9e830000, 0x9e83ffff, REGISTRY_RIPENCC    }, // 158.131.0.0     - 158.131.255.255
	{ 0x9e840000, 0x9e84ffff, REGISTRY_APNIC      }, // 158.132.0.0     - 158.132.255.255
	{ 0x9e850000, 0x9e85ffff, REGISTRY_RIPENCC    }, // 158.133.0.0     - 158.133.255.255
	{ 0x9e860000, 0x9e8c0fff, REGISTRY_ARIN       }, // 158.134.0.0     - 158.140.15.255
	{ 0x9e8c1000, 0x9e8c1fff, REGISTRY_RIPENCC    }, // 158.140.16.0    - 158.140.31.255
	{ 0x9e8c2000, 0x9e8c3fff, REGISTRY_ARIN       }, // 158.140.32.0    - 158.140.63.255
	{ 0x9e8c4000, 0x9e8c7fff, REGISTRY_RIPENCC    }, // 158.140.64.0    - 158.140.127.255
	{ 0x9e8c8000, 0x9e8cffff, REGISTRY_APNIC      }, // 158.140.128.0   - 158.140.255.255
	{ 0x9e8d0000, 0x9e8effff, REGISTRY_ARIN       }, // 158.141.0.0     - 158.142.255.255
	{ 0x9e8f0000, 0x9e8fffff, REGISTRY_RIPENCC    }, // 158.143.0.0     - 158.143.255.255
	{ 0x9e900000, 0x9e90ffff, REGISTRY_APNIC      }, // 158.144.0.0     - 158.144.255.255
	{ 0x9e910000, 0x9e927fff, REGISTRY_ARIN       }, // 158.145.0.0     - 158.146.127.255
	{ 0x9e928000, 0x9e928fff, REGISTRY_RIPENCC    }, // 158.146.128.0   - 158.146.143.255
	{ 0x9e929000, 0x9e93ffff, REGISTRY_ARIN       }, // 158.146.144.0   - 158.147.255.255
	{ 0x9e940000, 0x9e94ffff, REGISTRY_RIPENCC    }, // 158.148.0.0     - 158.148.255.255
	{ 0x9e950000, 0x9e96ffff, REGISTRY_RIPENCC    }, // 158.149.0.0     - 158.150.255.255
	{ 0x9e970000, 0x9e97ffff, REGISTRY_ARIN       }, // 158.151.0.0     - 158.151.255.255
	{ 0x9e980000, 0x9e98ffff, REGISTRY_RIPENCC    }, // 158.152.0.0     - 158.152.255.255
	{ 0x9e990000, 0x9e9bffff, REGISTRY_ARIN       }, // 158.153.0.0     - 158.155.255.255
	{ 0x9e9c0000, 0x9e9cffff, REGISTRY_RIPENCC    }, // 158.156.0.0     - 158.156.255.255
	{ 0x9e9d0000, 0x9e9fffff, REGISTRY_ARIN       }, // 158.157.0.0     - 158.159.255.255
	{ 0x9ea00000, 0x9ea0ffff, REGISTRY_LACNIC     }, // 158.160.0.0     - 158.160.255.255
	{ 0x9ea10000, 0x9ea1ffff, REGISTRY_APNIC      }, // 158.161.0.0     - 158.161.255.255
	{ 0x9ea20000, 0x9ea2ffff, REGISTRY_RIPENCC    }, // 158.162.0.0     - 158.162.255.255
	{ 0x9ea30000, 0x9ea5ffff, REGISTRY_ARIN       }, // 158.163.0.0     - 158.165.255.255
	{ 0x9ea60000, 0x9ea9ffff, REGISTRY_RIPENCC    }, // 158.166.0.0     - 158.169.255.255
	{ 0x9eaa0000, 0x9eaaffff, REGISTRY_LACNIC     }, // 158.170.0.0     - 158.170.255.255
	{ 0x9eab0000, 0x9eabffff, REGISTRY_ARIN       }, // 158.171.0.0     - 158.171.255.255
	{ 0x9eac0000, 0x9eb4ffff, REGISTRY_RIPENCC    }, // 158.172.0.0     - 158.180.255.255
	{ 0x9eb50000, 0x9eb5ffff, REGISTRY_RIPENCC    }, // 158.181.0.0     - 158.181.255.255
	{ 0x9eb60000, 0x9eb6ffff, REGISTRY_APNIC      }, // 158.182.0.0     - 158.182.255.255
	{ 0x9eb70000, 0x9ebdffff, REGISTRY_ARIN       }, // 158.183.0.0     - 158.189.255.255
	{ 0x9ebe0000, 0x9ec5ffff, REGISTRY_RIPENCC    }, // 158.190.0.0     - 158.197.255.255
	{ 0x9ec60000, 0x9ed7ffff, REGISTRY_APNIC      }, // 158.198.0.0     - 158.215.255.255
	{ 0x9ed80000, 0x9ed8ffff, REGISTRY_RIPENCC    }, // 158.216.0.0     - 158.216.255.255
	{ 0x9ed90000, 0x9ed9ffff, REGISTRY_APNIC      }, // 158.217.0.0     - 158.217.255.255
	{ 0x9eda0000, 0x9edaffff, REGISTRY_RIPENCC    }, // 158.218.0.0     - 158.218.255.255
	{ 0x9edb0000, 0x9edbffff, REGISTRY_ARIN       }, // 158.219.0.0     - 158.219.255.255
	{ 0x9edc0000, 0x9edcffff, REGISTRY_RIPENCC    }, // 158.220.0.0     - 158.220.255.255
	{ 0x9edd0000, 0x9edeffff, REGISTRY_ARIN       }, // 158.221.0.0     - 158.222.255.255
	{ 0x9edf0000, 0x9edfffff, REGISTRY_RIPENCC    }, // 158.223.0.0     - 158.223.255.255
	{ 0x9ee00000, 0x9ee0ffff, REGISTRY_ARIN       }, // 158.224.0.0     - 158.224.255.255
	{ 0x9ee10000, 0x9ee1ffff, REGISTRY_RIPENCC    }, // 158.225.0.0     - 158.225.255.255
	{ 0x9ee20000, 0x9ee2ffff, REGISTRY_RIPENCC    }, // 158.226.0.0     - 158.226.255.255
	{ 0x9ee30000, 0x9ee3ffff, REGISTRY_RIPENCC    }, // 158.227.0.0     - 158.227.255.255
	{ 0x9ee40000, 0x9ee5ffff, REGISTRY_ARIN       }, // 158.228.0.0     - 158.229.255.255
	{ 0x9ee60000, 0x9eeaffff, REGISTRY_RIPENCC    }, // 158.230.0.0     - 158.234.255.255
	{ 0x9eeb0000, 0x9ef7ffff, REGISTRY_ARIN       }, // 158.235.0.0     - 158.247.255.255
	{ 0x9ef80000, 0x9efaffff, REGISTRY_RIPENCC    }, // 158.248.0.0     - 158.250.255.255
	{ 0x9efb0000, 0x9efbffff, REGISTRY_LACNIC     }, // 158.251.0.0     - 158.251.255.255
	{ 0x9efc0000, 0x9efeffff, REGISTRY_ARIN       }, // 158.252.0.0     - 158.254.255.255
	{ 0x9eff0000, 0x9f00ffff, REGISTRY_RIPENCC    }, // 158.255.0.0     - 159.0.255.255
	{ 0x9f010000, 0x9f06ffff, REGISTRY_ARIN       }, // 159.1.0.0       - 159.6.255.255
	{ 0x9f070000, 0x9f08ffff, REGISTRY_RIPENCC    }, // 159.7.0.0       - 159.8.255.255
	{ 0x9f090000, 0x9f0bffff, REGISTRY_ARIN       }, // 159.9.0.0       - 159.11.255.255
	{ 0x9f0c0000, 0x9f0cffff, REGISTRY_RIPENCC    }, // 159.12.0.0      - 159.12.255.255
	{ 0x9f0d0000, 0x9f0dffff, REGISTRY_APNIC      }, // 159.13.0.0      - 159.13.255.255
	{ 0x9f0e0000, 0x9f0effff, REGISTRY_ARIN       }, // 159.14.0.0      - 159.14.255.255
	{ 0x9f0f0000, 0x9f0fffff, REGISTRY_RIPENCC    }, // 159.15.0.0      - 159.15.255.255
	{ 0x9f100000, 0x9f10ffff, REGISTRY_LACNIC     }, // 159.16.0.0      - 159.16.255.255
	{ 0x9f110000, 0x9f13ffff, REGISTRY_ARIN       }, // 159.17.0.0      - 159.19.255.255
	{ 0x9f140000, 0x9f14ffff, REGISTRY_RIPENCC    }, // 159.20.0.0      - 159.20.255.255
	{ 0x9f150000, 0x9f15ffff, REGISTRY_ARIN       }, // 159.21.0.0      - 159.21.255.255
	{ 0x9f160000, 0x9f17ffff, REGISTRY_RIPENCC    }, // 159.22.0.0      - 159.23.255.255
	{ 0x9f180000, 0x9f18ffff, REGISTRY_ARIN       }, // 159.24.0.0      - 159.24.255.255
	{ 0x9f190000, 0x9f19ffff, REGISTRY_RIPENCC    }, // 159.25.0.0      - 159.25.255.255
	{ 0x9f1a0000, 0x9f1affff, REGISTRY_ARIN       }, // 159.26.0.0      - 159.26.255.255
	{ 0x9f1b0000, 0x9f1bffff, REGISTRY_APNIC      }, // 159.27.0.0      - 159.27.255.255
	{ 0x9f1c0000, 0x9f1c3fff, REGISTRY_ARIN       }, // 159.28.0.0      - 159.28.63.255
	{ 0x9f1c4000, 0x9f1cffff, REGISTRY_APNIC      }, // 159.28.64.0     - 159.28.255.255
	{ 0x9f1d0000, 0x9f1fffff, REGISTRY_RIPENCC    }, // 159.29.0.0      - 159.31.255.255
	{ 0x9f200000, 0x9f21ffff, REGISTRY_ARIN       }, // 159.32.0.0      - 159.33.255.255
	{ 0x9f220000, 0x9f22ffff, REGISTRY_RIPENCC    }, // 159.34.0.0      - 159.34.255.255
	{ 0x9f230000, 0x9f25ffff, REGISTRY_ARIN       }, // 159.35.0.0      - 159.37.255.255
	{ 0x9f260000, 0x9f26ffff, REGISTRY_RIPENCC    }, // 159.38.0.0      - 159.38.255.255
	{ 0x9f270000, 0x9f2dffff, REGISTRY_ARIN       }, // 159.39.0.0      - 159.45.255.255
	{ 0x9f2e0000, 0x9f2effff, REGISTRY_RIPENCC    }, // 159.46.0.0      - 159.46.255.255
	{ 0x9f2f0000, 0x9f31ffff, REGISTRY_ARIN       }, // 159.47.0.0      - 159.49.255.255
	{ 0x9f320000, 0x9f33ffff, REGISTRY_RIPENCC    }, // 159.50.0.0      - 159.51.255.255
	{ 0x9f340000, 0x9f34ffff, REGISTRY_APNIC      }, // 159.52.0.0      - 159.52.255.255
	{ 0x9f350000, 0x9f39ffff, REGISTRY_ARIN       }, // 159.53.0.0      - 159.57.255.255
	{ 0x9f3a0000, 0x9f3affff, REGISTRY_RIPENCC    }, // 159.58.0.0      - 159.58.255.255
	{ 0x9f3b0000, 0x9f3bffff, REGISTRY_ARIN       }, // 159.59.0.0      - 159.59.255.255
	{ 0x9f3c0000, 0x9f3cffff, REGISTRY_RIPENCC    }, // 159.60.0.0      - 159.60.255.255
	{ 0x9f3d0000, 0x9f44ffff, REGISTRY_ARIN       }, // 159.61.0.0      - 159.68.255.255
	{ 0x9f450000, 0x9f45ffff, REGISTRY_RIPENCC    }, // 159.69.0.0      - 159.69.255.255
	{ 0x9f460000, 0x9f47ffff, REGISTRY_ARIN       }, // 159.70.0.0      - 159.71.255.255
	{ 0x9f480000, 0x9f48ffff, REGISTRY_RIPENCC    }, // 159.72.0.0      - 159.72.255.255
	{ 0x9f490000, 0x9f49ffff, REGISTRY_APNIC      }, // 159.73.0.0      - 159.73.255.255
	{ 0x9f4a0000, 0x9f4affff, REGISTRY_ARIN       }, // 159.74.0.0      - 159.74.255.255
	{ 0x9f4b0000, 0x9f4bffff, REGISTRY_APNIC      }, // 159.75.0.0      - 159.75.255.255
	{ 0x9f4c0000, 0x9f4fffff, REGISTRY_ARIN       }, // 159.76.0.0      - 159.79.255.255
	{ 0x9f500000, 0x9f50ffff, REGISTRY_APNIC      }, // 159.80.0.0      - 159.80.255.255
	{ 0x9f510000, 0x9f51ffff, REGISTRY_RIPENCC    }, // 159.81.0.0      - 159.81.255.255
	{ 0x9f520000, 0x9f53ffff, REGISTRY_ARIN       }, // 159.82.0.0      - 159.83.255.255
	{ 0x9f540000, 0x9f54ffff, REGISTRY_RIPENCC    }, // 159.84.0.0      - 159.84.255.255
	{ 0x9f550000, 0x9f55ffff, REGISTRY_ARIN       }, // 159.85.0.0      - 159.85.255.255
	{ 0x9f560000, 0x9f56ffff, REGISTRY_RIPENCC    }, // 159.86.0.0      - 159.86.255.255
	{ 0x9f570000, 0x9f59ffff, REGISTRY_ARIN       }, // 159.87.0.0      - 159.89.255.255
	{ 0x9f5a0000, 0x9f5affff, REGISTRY_LACNIC     }, // 159.90.0.0      - 159.90.255.255
	{ 0x9f5b0000, 0x9f5bffff, REGISTRY_ARIN       }, // 159.91.0.0      - 159.91.255.255
	{ 0x9f5c0000, 0x9f5dffff, REGISTRY_RIPENCC    }, // 159.92.0.0      - 159.93.255.255
	{ 0x9f5e0000, 0x9f5effff, REGISTRY_ARIN       }, // 159.94.0.0      - 159.94.255.255
	{ 0x9f5f0000, 0x9f5fffff, REGISTRY_RIPENCC    }, // 159.95.0.0      - 159.95.255.255
	{ 0x9f600000, 0x9f63ffff, REGISTRY_ARIN       }, // 159.96.0.0      - 159.99.255.255
	{ 0x9f640000, 0x9f65ffff, REGISTRY_RIPENCC    }, // 159.100.0.0     - 159.101.255.255
	{ 0x9f660000, 0x9f66ffff, REGISTRY_ARIN       }, // 159.102.0.0     - 159.102.255.255
	{ 0x9f670000, 0x9f68ffff, REGISTRY_RIPENCC    }, // 159.103.0.0     - 159.104.255.255
	{ 0x9f690000, 0x9f6affff, REGISTRY_ARIN       }, // 159.105.0.0     - 159.106.255.255
	{ 0x9f6b0000, 0x9f6bffff, REGISTRY_RIPENCC    }, // 159.107.0.0     - 159.107.255.255
	{ 0x9f6c0000, 0x9f6cffff, REGISTRY_ARIN       }, // 159.108.0.0     - 159.108.255.255
	{ 0x9f6d0000, 0x9f6dffff, REGISTRY_RIPENCC    }, // 159.109.0.0     - 159.109.255.255
	{ 0x9f6e0000, 0x9f71ffff, REGISTRY_ARIN       }, // 159.110.0.0     - 159.113.255.255
	{ 0x9f720000, 0x9f72ffff, REGISTRY_RIPENCC    }, // 159.114.0.0     - 159.114.255.255
	{ 0x9f730000, 0x9f74ffff, REGISTRY_ARIN       }, // 159.115.0.0     - 159.116.255.255
	{ 0x9f750000, 0x9f752fff, REGISTRY_APNIC      }, // 159.117.0.0     - 159.117.47.255
	{ 0x9f753000, 0x9f753fff, REGISTRY_ARIN       }, // 159.117.48.0    - 159.117.63.255
	{ 0x9f754000, 0x9f759fff, REGISTRY_APNIC      }, // 159.117.64.0    - 159.117.159.255
	{ 0x9f75a000, 0x9f75bfff, REGISTRY_ARIN       }, // 159.117.160.0   - 159.117.191.255
	{ 0x9f75c000, 0x9f75c7ff, REGISTRY_RIPENCC    }, // 159.117.192.0   - 159.117.199.255
	{ 0x9f75c800, 0x9f75c9ff, REGISTRY_APNIC      }, // 159.117.200.0   - 159.117.201.255
	{ 0x9f75ca00, 0x9f75cfff, REGISTRY_RIPENCC    }, // 159.117.202.0   - 159.117.207.255
	{ 0x9f75d000, 0x9f75dbff, REGISTRY_ARIN       }, // 159.117.208.0   - 159.117.219.255
	{ 0x9f75dc00, 0x9f75ffff, REGISTRY_APNIC      }, // 159.117.220.0   - 159.117.255.255
	{ 0x9f760000, 0x9f79ffff, REGISTRY_ARIN       }, // 159.118.0.0     - 159.121.255.255
	{ 0x9f7a0000, 0x9f7affff, REGISTRY_RIPENCC    }, // 159.122.0.0     - 159.122.255.255
	{ 0x9f7b0000, 0x9f81ffff, REGISTRY_ARIN       }, // 159.123.0.0     - 159.129.255.255
	{ 0x9f820000, 0x9f82ffff, REGISTRY_RIPENCC    }, // 159.130.0.0     - 159.130.255.255
	{ 0x9f830000, 0x9f85ffff, REGISTRY_ARIN       }, // 159.131.0.0     - 159.133.255.255
	{ 0x9f860000, 0x9f86ffff, REGISTRY_RIPENCC    }, // 159.134.0.0     - 159.134.255.255
	{ 0x9f870000, 0x9f877fff, REGISTRY_ARIN       }, // 159.135.0.0     - 159.135.127.255
	{ 0x9f878000, 0x9f879fff, REGISTRY_RIPENCC    }, // 159.135.128.0   - 159.135.159.255
	{ 0x9f87a000, 0x9f89ffff, REGISTRY_ARIN       }, // 159.135.160.0   - 159.137.255.255
	{ 0x9f8a0000, 0x9f8affff, REGISTRY_APNIC      }, // 159.138.0.0     - 159.138.255.255
	{ 0x9f8b0000, 0x9f8fffff, REGISTRY_ARIN       }, // 159.139.0.0     - 159.143.255.255
	{ 0x9f900000, 0x9f90ffff, REGISTRY_RIPENCC    }, // 159.144.0.0     - 159.144.255.255
	{ 0x9f910000, 0x9f91ffff, REGISTRY_ARIN       }, // 159.145.0.0     - 159.145.255.255
	{ 0x9f920000, 0x9f92ffff, REGISTRY_RIPENCC    }, // 159.146.0.0     - 159.146.255.255
	{ 0x9f930000, 0x9f95ffff, REGISTRY_RIPENCC    }, // 159.147.0.0     - 159.149.255.255
	{ 0x9f960000, 0x9f96ffff, REGISTRY_ARIN       }, // 159.150.0.0     - 159.150.255.255
	{ 0x9f970000, 0x9f98ffff, REGISTRY_RIPENCC    }, // 159.151.0.0     - 159.152.255.255
	{ 0x9f990000, 0x9f99ffff, REGISTRY_ARIN       }, // 159.153.0.0     - 159.153.255.255
	{ 0x9f9a0000, 0x9f9affff, REGISTRY_RIPENCC    }, // 159.154.0.0     - 159.154.255.255
	{ 0x9f9b0000, 0x9f9bffff, REGISTRY_ARIN       }, // 159.155.0.0     - 159.155.255.255
	{ 0x9f9c0000, 0x9f9cffff, REGISTRY_RIPENCC    }, // 159.156.0.0     - 159.156.255.255
	{ 0x9f9d0000, 0x9f9fffff, REGISTRY_ARIN       }, // 159.157.0.0     - 159.159.255.255
	{ 0x9fa00000, 0x9fa0ffff, REGISTRY_RIPENCC    }, // 159.160.0.0     - 159.160.255.255
	{ 0x9fa10000, 0x9fa1ffff, REGISTRY_ARIN       }, // 159.161.0.0     - 159.161.255.255
	{ 0x9fa20000, 0x9fa2ffff, REGISTRY_RIPENCC    }, // 159.162.0.0     - 159.162.255.255
	{ 0x9fa30000, 0x9fa6ffff, REGISTRY_ARIN       }, // 159.163.0.0     - 159.166.255.255
	{ 0x9fa70000, 0x9fa8ffff, REGISTRY_RIPENCC    }, // 159.167.0.0     - 159.168.255.255
	{ 0x9fa90000, 0x9fa9ffff, REGISTRY_ARIN       }, // 159.169.0.0     - 159.169.255.255
	{ 0x9faa0000, 0x9fabffff, REGISTRY_RIPENCC    }, // 159.170.0.0     - 159.171.255.255
	{ 0x9fac0000, 0x9facffff, REGISTRY_ARIN       }, // 159.172.0.0     - 159.172.255.255
	{ 0x9fad0000, 0x9fadffff, REGISTRY_RIPENCC    }, // 159.173.0.0     - 159.173.255.255
	{ 0x9fae0000, 0x9fb2ffff, REGISTRY_ARIN       }, // 159.174.0.0     - 159.178.255.255
	{ 0x9fb30000, 0x9fb4dfff, REGISTRY_RIPENCC    }, // 159.179.0.0     - 159.180.223.255
	{ 0x9fb4e000, 0x9fb4ffff, REGISTRY_RIPENCC    }, // 159.180.224.0   - 159.180.255.255
	{ 0x9fb50000, 0x9fbdffff, REGISTRY_ARIN       }, // 159.181.0.0     - 159.189.255.255
	{ 0x9fbe0000, 0x9fbeffff, REGISTRY_RIPENCC    }, // 159.190.0.0     - 159.190.255.255
	{ 0x9fbf0000, 0x9fbfffff, REGISTRY_ARIN       }, // 159.191.0.0     - 159.191.255.255
	{ 0x9fc00000, 0x9fc0ffff, REGISTRY_APNIC      }, // 159.192.0.0     - 159.192.255.255
	{ 0x9fc10000, 0x9fc3ffff, REGISTRY_RIPENCC    }, // 159.193.0.0     - 159.195.255.255
	{ 0x9fc40000, 0x9fc4ffff, REGISTRY_APNIC      }, // 159.196.0.0     - 159.196.255.255
	{ 0x9fc50000, 0x9fc5ffff, REGISTRY_RIPENCC    }, // 159.197.0.0     - 159.197.255.255
	{ 0x9fc60000, 0x9fc7ffff, REGISTRY_ARIN       }, // 159.198.0.0     - 159.199.255.255
	{ 0x9fc80000, 0x9fc8ffff, REGISTRY_RIPENCC    }, // 159.200.0.0     - 159.200.255.255
	{ 0x9fc90000, 0x9fccffff, REGISTRY_ARIN       }, // 159.201.0.0     - 159.204.255.255
	{ 0x9fcd0000, 0x9fcdffff, REGISTRY_RIPENCC    }, // 159.205.0.0     - 159.205.255.255
	{ 0x9fce0000, 0x9fceffff, REGISTRY_ARIN       }, // 159.206.0.0     - 159.206.255.255
	{ 0x9fcf0000, 0x9fcfffff, REGISTRY_APNIC      }, // 159.207.0.0     - 159.207.255.255
	{ 0x9fd00000, 0x9fd1ffff, REGISTRY_ARIN       }, // 159.208.0.0     - 159.209.255.255
	{ 0x9fd20000, 0x9fd2ffff, REGISTRY_RIPENCC    }, // 159.210.0.0     - 159.210.255.255
	{ 0x9fd30000, 0x9fd3ffff, REGISTRY_APNIC      }, // 159.211.0.0     - 159.211.255.255
	{ 0x9fd40000, 0x9fd4ffff, REGISTRY_ARIN       }, // 159.212.0.0     - 159.212.255.255
	{ 0x9fd50000, 0x9fd5ffff, REGISTRY_RIPENCC    }, // 159.213.0.0     - 159.213.255.255
	{ 0x9fd60000, 0x9fd7ffff, REGISTRY_ARIN       }, // 159.214.0.0     - 159.215.255.255
	{ 0x9fd80000, 0x9fd9ffff, REGISTRY_RIPENCC    }, // 159.216.0.0     - 159.217.255.255
	{ 0x9fda0000, 0x9fdaffff, REGISTRY_ARIN       }, // 159.218.0.0     - 159.218.255.255
	{ 0x9fdb0000, 0x9fdbffff, REGISTRY_RIPENCC    }, // 159.219.0.0     - 159.219.255.255
	{ 0x9fdc0000, 0x9fdfffff, REGISTRY_ARIN       }, // 159.220.0.0     - 159.223.255.255
	{ 0x9fe00000, 0x9fe0ffff, REGISTRY_RIPENCC    }, // 159.224.0.0     - 159.224.255.255
	{ 0x9fe10000, 0x9fe1ffff, REGISTRY_ARIN       }, // 159.225.0.0     - 159.225.255.255
	{ 0x9fe20000, 0x9fe2ffff, REGISTRY_APNIC      }, // 159.226.0.0     - 159.226.255.255
	{ 0x9fe30000, 0x9fe3ffff, REGISTRY_ARIN       }, // 159.227.0.0     - 159.227.255.255
	{ 0x9fe50000, 0x9fe7ffff, REGISTRY_ARIN       }, // 159.229.0.0     - 159.231.255.255
	{ 0x9fe80000, 0x9fe8ffff, REGISTRY_RIPENCC    }, // 159.232.0.0     - 159.232.255.255
	{ 0x9fe90000, 0x9febffff, REGISTRY_ARIN       }, // 159.233.0.0     - 159.235.255.255
	{ 0x9fec0000, 0x9fedffff, REGISTRY_RIPENCC    }, // 159.236.0.0     - 159.237.255.255
	{ 0x9fee0000, 0x9feeffff, REGISTRY_ARIN       }, // 159.238.0.0     - 159.238.255.255
	{ 0x9fef0000, 0x9fefffff, REGISTRY_RIPENCC    }, // 159.239.0.0     - 159.239.255.255
	{ 0x9ff00000, 0x9ff0ffff, REGISTRY_ARIN       }, // 159.240.0.0     - 159.240.255.255
	{ 0x9ff10000, 0x9ff1ffff, REGISTRY_RIPENCC    }, // 159.241.0.0     - 159.241.255.255
	{ 0x9ff20000, 0x9ff207ff, REGISTRY_ARIN       }, // 159.242.0.0     - 159.242.7.255
	{ 0x9ff20800, 0x9ff20fff, REGISTRY_RIPENCC    }, // 159.242.8.0     - 159.242.15.255
	{ 0x9ff21000, 0x9ff21fff, REGISTRY_APNIC      }, // 159.242.16.0    - 159.242.31.255
	{ 0x9ff22000, 0x9ff23fff, REGISTRY_ARIN       }, // 159.242.32.0    - 159.242.63.255
	{ 0x9ff24000, 0x9ff27fff, REGISTRY_RIPENCC    }, // 159.242.64.0    - 159.242.127.255
	{ 0x9ff28000, 0x9ff2dfff, REGISTRY_ARIN       }, // 159.242.128.0   - 159.242.223.255
	{ 0x9ff2e000, 0x9ff2efff, REGISTRY_RIPENCC    }, // 159.242.224.0   - 159.242.239.255
	{ 0x9ff2f000, 0x9ff3ffff, REGISTRY_ARIN       }, // 159.242.240.0   - 159.243.255.255
	{ 0x9ff40000, 0x9ff5ffff, REGISTRY_RIPENCC    }, // 159.244.0.0     - 159.245.255.255
	{ 0x9ff60000, 0x9ff7ffff, REGISTRY_ARIN       }, // 159.246.0.0     - 159.247.255.255
	{ 0x9ff80000, 0x9ff8ffff, REGISTRY_APNIC      }, // 159.248.0.0     - 159.248.255.255
	{ 0x9ff90000, 0x9ffcffff, REGISTRY_ARIN       }, // 159.249.0.0     - 159.252.255.255
	{ 0x9ffd0000, 0x9ffdffff, REGISTRY_RIPENCC    }, // 159.253.0.0     - 159.253.255.255
	{ 0x9ffe0000, 0x9ffeffff, REGISTRY_RIPENCC    }, // 159.254.0.0     - 159.254.255.255
	{ 0x9fff0000, 0x9fffffff, REGISTRY_RIPENCC    }, // 159.255.0.0     - 159.255.255.255
	{ 0xa0000000, 0xa000ffff, REGISTRY_AFRINIC    }, // 160.0.0.0       - 160.0.255.255
	{ 0xa0010000, 0xa003ffff, REGISTRY_ARIN       }, // 160.1.0.0       - 160.3.255.255
	{ 0xa0040000, 0xa004ffff, REGISTRY_APNIC      }, // 160.4.0.0       - 160.4.255.255
	{ 0xa0050000, 0xa006ffff, REGISTRY_RIPENCC    }, // 160.5.0.0       - 160.6.255.255
	{ 0xa0070000, 0xa007ffff, REGISTRY_ARIN       }, // 160.7.0.0       - 160.7.255.255
	{ 0xa0080000, 0xa009ffff, REGISTRY_RIPENCC    }, // 160.8.0.0       - 160.9.255.255
	{ 0xa00a0000, 0xa00affff, REGISTRY_ARIN       }, // 160.10.0.0      - 160.10.255.255
	{ 0xa00b0000, 0xa012ffff, REGISTRY_APNIC      }, // 160.11.0.0      - 160.18.255.255
	{ 0xa0130000, 0xa0130fff, REGISTRY_ARIN       }, // 160.19.0.0      - 160.19.15.255
	{ 0xa0131400, 0xa01317ff, REGISTRY_APNIC      }, // 160.19.20.0     - 160.19.23.255
	{ 0xa0131800, 0xa0131fff, REGISTRY_ARIN       }, // 160.19.24.0     - 160.19.31.255
	{ 0xa0132400, 0xa01327ff, REGISTRY_AFRINIC    }, // 160.19.36.0     - 160.19.39.255
	{ 0xa0132c00, 0xa0132fff, REGISTRY_LACNIC     }, // 160.19.44.0     - 160.19.47.255
	{ 0xa0133000, 0xa01337ff, REGISTRY_APNIC      }, // 160.19.48.0     - 160.19.55.255
	{ 0xa0133c00, 0xa0133fff, REGISTRY_AFRINIC    }, // 160.19.60.0     - 160.19.63.255
	{ 0xa0134000, 0xa01343ff, REGISTRY_APNIC      }, // 160.19.64.0     - 160.19.67.255
	{ 0xa0135c00, 0xa0135fff, REGISTRY_RIPENCC    }, // 160.19.92.0     - 160.19.95.255
	{ 0xa0136000, 0xa01367ff, REGISTRY_AFRINIC    }, // 160.19.96.0     - 160.19.103.255
	{ 0xa0136800, 0xa0136bff, REGISTRY_ARIN       }, // 160.19.104.0    - 160.19.107.255
	{ 0xa0137000, 0xa0138fff, REGISTRY_AFRINIC    }, // 160.19.112.0    - 160.19.143.255
	{ 0xa0139800, 0xa0139bff, REGISTRY_AFRINIC    }, // 160.19.152.0    - 160.19.155.255
	{ 0xa013a000, 0xa013a3ff, REGISTRY_ARIN       }, // 160.19.160.0    - 160.19.163.255
	{ 0xa013a800, 0xa013afff, REGISTRY_LACNIC     }, // 160.19.168.0    - 160.19.175.255
	{ 0xa013b400, 0xa013b7ff, REGISTRY_RIPENCC    }, // 160.19.180.0    - 160.19.183.255
	{ 0xa013bc00, 0xa013c7ff, REGISTRY_AFRINIC    }, // 160.19.188.0    - 160.19.199.255
	{ 0xa013c800, 0xa013cbff, REGISTRY_LACNIC     }, // 160.19.200.0    - 160.19.203.255
	{ 0xa013d000, 0xa013e3ff, REGISTRY_APNIC      }, // 160.19.208.0    - 160.19.227.255
	{ 0xa013e800, 0xa013efff, REGISTRY_AFRINIC    }, // 160.19.232.0    - 160.19.239.255
	{ 0xa013f000, 0xa013ffff, REGISTRY_LACNIC     }, // 160.19.240.0    - 160.19.255.255
	{ 0xa0140000, 0xa0140fff, REGISTRY_APNIC      }, // 160.20.0.0      - 160.20.15.255
	{ 0xa0141400, 0xa01417ff, REGISTRY_LACNIC     }, // 160.20.20.0     - 160.20.23.255
	{ 0xa0141800, 0xa0141fff, REGISTRY_AFRINIC    }, // 160.20.24.0     - 160.20.31.255
	{ 0xa0142000, 0xa01423ff, REGISTRY_LACNIC     }, // 160.20.32.0     - 160.20.35.255
	{ 0xa0142800, 0xa0143fff, REGISTRY_APNIC      }, // 160.20.40.0     - 160.20.63.255
	{ 0xa0144000, 0xa01447ff, REGISTRY_LACNIC     }, // 160.20.64.0     - 160.20.71.255
	{ 0xa0144800, 0xa0144bff, REGISTRY_APNIC      }, // 160.20.72.0     - 160.20.75.255
	{ 0xa0145000, 0xa0145fff, REGISTRY_LACNIC     }, // 160.20.80.0     - 160.20.95.255
	{ 0xa0146000, 0xa01467ff, REGISTRY_RIPENCC    }, // 160.20.96.0     - 160.20.103.255
	{ 0xa0146c00, 0xa0146fff, REGISTRY_RIPENCC    }, // 160.20.108.0    - 160.20.111.255
	{ 0xa0147000, 0xa01473ff, REGISTRY_AFRINIC    }, // 160.20.112.0    - 160.20.115.255
	{ 0xa0149000, 0xa0149fff, REGISTRY_RIPENCC    }, // 160.20.144.0    - 160.20.159.255
	{ 0xa014a000, 0xa014cfff, REGISTRY_LACNIC     }, // 160.20.160.0    - 160.20.207.255
	{ 0xa014d000, 0xa014d3ff, REGISTRY_ARIN       }, // 160.20.208.0    - 160.20.211.255
	{ 0xa014da00, 0xa014dbff, REGISTRY_LACNIC     }, // 160.20.218.0    - 160.20.219.255
	{ 0xa014de00, 0xa014dfff, REGISTRY_APNIC      }, // 160.20.222.0    - 160.20.223.255
	{ 0xa014e100, 0xa014e1ff, REGISTRY_LACNIC     }, // 160.20.225.0    - 160.20.225.255
	{ 0xa014e600, 0xa014efff, REGISTRY_ARIN       }, // 160.20.230.0    - 160.20.239.255
	{ 0xa014f200, 0xa014f3ff, REGISTRY_LACNIC     }, // 160.20.242.0    - 160.20.243.255
	{ 0xa014f600, 0xa014f7ff, REGISTRY_LACNIC     }, // 160.20.246.0    - 160.20.247.255
	{ 0xa014fb00, 0xa014fbff, REGISTRY_ARIN       }, // 160.20.251.0    - 160.20.251.255
	{ 0xa014fc00, 0xa014ffff, REGISTRY_AFRINIC    }, // 160.20.252.0    - 160.20.255.255
	{ 0xa0150000, 0xa015ffff, REGISTRY_APNIC      }, // 160.21.0.0      - 160.21.255.255
	{ 0xa0170000, 0xa018ffff, REGISTRY_APNIC      }, // 160.23.0.0      - 160.24.255.255
	{ 0xa01a0000, 0xa01dffff, REGISTRY_APNIC      }, // 160.26.0.0      - 160.29.255.255
	{ 0xa01f0000, 0xa020efff, REGISTRY_ARIN       }, // 160.31.0.0      - 160.32.239.255
	{ 0xa020f000, 0xa020f7ff, REGISTRY_APNIC      }, // 160.32.240.0    - 160.32.247.255
	{ 0xa020f800, 0xa025ffff, REGISTRY_ARIN       }, // 160.32.248.0    - 160.37.255.255
	{ 0xa0260000, 0xa026ffff, REGISTRY_RIPENCC    }, // 160.38.0.0      - 160.38.255.255
	{ 0xa0270000, 0xa027ffff, REGISTRY_ARIN       }, // 160.39.0.0      - 160.39.255.255
	{ 0xa0280000, 0xa028ffff, REGISTRY_RIPENCC    }, // 160.40.0.0      - 160.40.255.255
	{ 0xa0290000, 0xa02bffff, REGISTRY_ARIN       }, // 160.41.0.0      - 160.43.255.255
	{ 0xa02c0000, 0xa02cffff, REGISTRY_RIPENCC    }, // 160.44.0.0      - 160.44.255.255
	{ 0xa02d0000, 0xa03cffff, REGISTRY_RIPENCC    }, // 160.45.0.0      - 160.60.255.255
	{ 0xa03d0000, 0xa03effff, REGISTRY_RIPENCC    }, // 160.61.0.0      - 160.62.255.255
	{ 0xa03f0000, 0xa03fffff, REGISTRY_RIPENCC    }, // 160.63.0.0      - 160.63.255.255
	{ 0xa0400000, 0xa040ffff, REGISTRY_APNIC      }, // 160.64.0.0      - 160.64.255.255
	{ 0xa0410000, 0xa041ffff, REGISTRY_ARIN       }, // 160.65.0.0      - 160.65.255.255
	{ 0xa0420000, 0xa044ffff, REGISTRY_RIPENCC    }, // 160.66.0.0      - 160.68.255.255
	{ 0xa0450000, 0xa045ffff, REGISTRY_ARIN       }, // 160.69.0.0      - 160.69.255.255
	{ 0xa0460000, 0xa047ffff, REGISTRY_RIPENCC    }, // 160.70.0.0      - 160.71.255.255
	{ 0xa0480000, 0xa049ffff, REGISTRY_ARIN       }, // 160.72.0.0      - 160.73.255.255
	{ 0xa04a0000, 0xa04affff, REGISTRY_APNIC      }, // 160.74.0.0      - 160.74.255.255
	{ 0xa04b0000, 0xa04bffff, REGISTRY_RIPENCC    }, // 160.75.0.0      - 160.75.255.255
	{ 0xa04c0000, 0xa04cffff, REGISTRY_ARIN       }, // 160.76.0.0      - 160.76.255.255
	{ 0xa04d0000, 0xa04dffff, REGISTRY_AFRINIC    }, // 160.77.0.0      - 160.77.255.255
	{ 0xa04e0000, 0xa04effff, REGISTRY_RIPENCC    }, // 160.78.0.0      - 160.78.255.255
	{ 0xa04f0000, 0xa04fffff, REGISTRY_ARIN       }, // 160.79.0.0      - 160.79.255.255
	{ 0xa0500000, 0xa050ffff, REGISTRY_RIPENCC    }, // 160.80.0.0      - 160.80.255.255
	{ 0xa0510000, 0xa054ffff, REGISTRY_ARIN       }, // 160.81.0.0      - 160.84.255.255
	{ 0xa0550000, 0xa055ffff, REGISTRY_RIPENCC    }, // 160.85.0.0      - 160.85.255.255
	{ 0xa0560000, 0xa056ffff, REGISTRY_APNIC      }, // 160.86.0.0      - 160.86.255.255
	{ 0xa0570000, 0xa058ffff, REGISTRY_ARIN       }, // 160.87.0.0      - 160.88.255.255
	{ 0xa0590000, 0xa05affff, REGISTRY_AFRINIC    }, // 160.89.0.0      - 160.90.255.255
	{ 0xa05b0000, 0xa05bffff, REGISTRY_ARIN       }, // 160.91.0.0      - 160.91.255.255
	{ 0xa05c0000, 0xa05cffff, REGISTRY_RIPENCC    }, // 160.92.0.0      - 160.92.255.255
	{ 0xa05d0000, 0xa05fffff, REGISTRY_ARIN       }, // 160.93.0.0      - 160.95.255.255
	{ 0xa0600000, 0xa060ffff, REGISTRY_APNIC      }, // 160.96.0.0      - 160.96.255.255
	{ 0xa0610000, 0xa064ffff, REGISTRY_RIPENCC    }, // 160.97.0.0      - 160.100.255.255
	{ 0xa0650000, 0xa066ffff, REGISTRY_ARIN       }, // 160.101.0.0     - 160.102.255.255
	{ 0xa0670000, 0xa068ffff, REGISTRY_RIPENCC    }, // 160.103.0.0     - 160.104.255.255
	{ 0xa0690000, 0xa069ffff, REGISTRY_AFRINIC    }, // 160.105.0.0     - 160.105.255.255
	{ 0xa06a0000, 0xa070ffff, REGISTRY_ARIN       }, // 160.106.0.0     - 160.112.255.255
	{ 0xa0710000, 0xa071ffff, REGISTRY_AFRINIC    }, // 160.113.0.0     - 160.113.255.255
	{ 0xa0720000, 0xa072ffff, REGISTRY_RIPENCC    }, // 160.114.0.0     - 160.114.255.255
	{ 0xa0730000, 0xa07cffff, REGISTRY_AFRINIC    }, // 160.115.0.0     - 160.124.255.255
	{ 0xa07d0000, 0xa097ffff, REGISTRY_ARIN       }, // 160.125.0.0     - 160.151.255.255
	{ 0xa0980000, 0xa098ffff, REGISTRY_AFRINIC    }, // 160.152.0.0     - 160.152.255.255
	{ 0xa0990000, 0xa099ffff, REGISTRY_ARIN       }, // 160.153.0.0     - 160.153.255.255
	{ 0xa09a0000, 0xa0b3ffff, REGISTRY_AFRINIC    }, // 160.154.0.0     - 160.179.255.255
	{ 0xa0b40000, 0xa0b4ffff, REGISTRY_RIPENCC    }, // 160.180.0.0     - 160.180.255.255
	{ 0xa0b50000, 0xa0b8ffff, REGISTRY_AFRINIC    }, // 160.181.0.0     - 160.184.255.255
	{ 0xa0b90000, 0xa0baffff, REGISTRY_APNIC      }, // 160.185.0.0     - 160.186.255.255
	{ 0xa0bc0000, 0xa0beffff, REGISTRY_APNIC      }, // 160.188.0.0     - 160.190.255.255
	{ 0xa0c00000, 0xa0ca0fff, REGISTRY_APNIC      }, // 160.192.0.0     - 160.202.15.255
	{ 0xa0ca1000, 0xa0ca1fff, REGISTRY_RIPENCC    }, // 160.202.16.0    - 160.202.31.255
	{ 0xa0ca2000, 0xa0ca3fff, REGISTRY_APNIC      }, // 160.202.32.0    - 160.202.63.255
	{ 0xa0ca4000, 0xa0ca7fff, REGISTRY_ARIN       }, // 160.202.64.0    - 160.202.127.255
	{ 0xa0ca8000, 0xa0ccffff, REGISTRY_APNIC      }, // 160.202.128.0   - 160.204.255.255
	{ 0xa0cd0000, 0xa0cdffff, REGISTRY_ARIN       }, // 160.205.0.0     - 160.205.255.255
	{ 0xa0ce0000, 0xa0ceffff, REGISTRY_APNIC      }, // 160.206.0.0     - 160.206.255.255
	{ 0xa0cf0000, 0xa0d1ffff, REGISTRY_ARIN       }, // 160.207.0.0     - 160.209.255.255
	{ 0xa0d20000, 0xa0d3ffff, REGISTRY_RIPENCC    }, // 160.210.0.0     - 160.211.255.255
	{ 0xa0d40000, 0xa0d4ffff, REGISTRY_ARIN       }, // 160.212.0.0     - 160.212.255.255
	{ 0xa0d50000, 0xa0d6ffff, REGISTRY_RIPENCC    }, // 160.213.0.0     - 160.214.255.255
	{ 0xa0d70000, 0xa0d7ffff, REGISTRY_APNIC      }, // 160.215.0.0     - 160.215.255.255
	{ 0xa0d80000, 0xa0d9ffff, REGISTRY_RIPENCC    }, // 160.216.0.0     - 160.217.255.255
	{ 0xa0da0000, 0xa0daffff, REGISTRY_RIPENCC    }, // 160.218.0.0     - 160.218.255.255
	{ 0xa0db0000, 0xa0ddffff, REGISTRY_RIPENCC    }, // 160.219.0.0     - 160.221.255.255
	{ 0xa0de0000, 0xa0deffff, REGISTRY_APNIC      }, // 160.222.0.0     - 160.222.255.255
	{ 0xa0df0000, 0xa0dfffff, REGISTRY_ARIN       }, // 160.223.0.0     - 160.223.255.255
	{ 0xa0e00000, 0xa0e2b1ff, REGISTRY_AFRINIC    }, // 160.224.0.0     - 160.226.177.255
	{ 0xa0e2b300, 0xa0e2ffff, REGISTRY_AFRINIC    }, // 160.226.179.0   - 160.226.255.255
	{ 0xa0e30000, 0xa0e3ffff, REGISTRY_ARIN       }, // 160.227.0.0     - 160.227.255.255
	{ 0xa0e40000, 0xa0e4ffff, REGISTRY_RIPENCC    }, // 160.228.0.0     - 160.228.255.255
	{ 0xa0e50000, 0xa0e73fff, REGISTRY_ARIN       }, // 160.229.0.0     - 160.231.63.255
	{ 0xa0e74000, 0xa0e77fff, REGISTRY_RIPENCC    }, // 160.231.64.0    - 160.231.127.255
	{ 0xa0e78000, 0xa0e7bfff, REGISTRY_APNIC      }, // 160.231.128.0   - 160.231.191.255
	{ 0xa0e7c000, 0xa0e8ffff, REGISTRY_ARIN       }, // 160.231.192.0   - 160.232.255.255
	{ 0xa0e90000, 0xa0e9ffff, REGISTRY_APNIC      }, // 160.233.0.0     - 160.233.255.255
	{ 0xa0eb0000, 0xa0ebffff, REGISTRY_APNIC      }, // 160.235.0.0     - 160.235.255.255
	{ 0xa0ed0000, 0xa0ee0aff, REGISTRY_APNIC      }, // 160.237.0.0     - 160.238.10.255
	{ 0xa0ee0c00, 0xa0ee14ff, REGISTRY_APNIC      }, // 160.238.12.0    - 160.238.20.255
	{ 0xa0ee1600, 0xa0ee17ff, REGISTRY_ARIN       }, // 160.238.22.0    - 160.238.23.255
	{ 0xa0ee1800, 0xa0ee1dff, REGISTRY_LACNIC     }, // 160.238.24.0    - 160.238.29.255
	{ 0xa0ee1e00, 0xa0ee1eff, REGISTRY_APNIC      }, // 160.238.30.0    - 160.238.30.255
	{ 0xa0ee1f00, 0xa0ee1fff, REGISTRY_ARIN       }, // 160.238.31.0    - 160.238.31.255
	{ 0xa0ee2000, 0xa0ee23ff, REGISTRY_APNIC      }, // 160.238.32.0    - 160.238.35.255
	{ 0xa0ee2400, 0xa0ee27ff, REGISTRY_RIPENCC    }, // 160.238.36.0    - 160.238.39.255
	{ 0xa0ee2800, 0xa0ee28ff, REGISTRY_APNIC      }, // 160.238.40.0    - 160.238.40.255
	{ 0xa0ee2900, 0xa0ee2fff, REGISTRY_ARIN       }, // 160.238.41.0    - 160.238.47.255
	{ 0xa0ee3000, 0xa0ee31ff, REGISTRY_AFRINIC    }, // 160.238.48.0    - 160.238.49.255
	{ 0xa0ee3300, 0xa0ee33ff, REGISTRY_APNIC      }, // 160.238.51.0    - 160.238.51.255
	{ 0xa0ee3400, 0xa0ee37ff, REGISTRY_RIPENCC    }, // 160.238.52.0    - 160.238.55.255
	{ 0xa0ee3800, 0xa0ee38ff, REGISTRY_APNIC      }, // 160.238.56.0    - 160.238.56.255
	{ 0xa0ee3a00, 0xa0ee3bff, REGISTRY_APNIC      }, // 160.238.58.0    - 160.238.59.255
	{ 0xa0ee3e00, 0xa0ee3eff, REGISTRY_APNIC      }, // 160.238.62.0    - 160.238.62.255
	{ 0xa0ee3f00, 0xa0ee3fff, REGISTRY_LACNIC     }, // 160.238.63.0    - 160.238.63.255
	{ 0xa0ee4000, 0xa0ee5fff, REGISTRY_APNIC      }, // 160.238.64.0    - 160.238.95.255
	{ 0xa0ee6000, 0xa0ee63ff, REGISTRY_RIPENCC    }, // 160.238.96.0    - 160.238.99.255
	{ 0xa0ee6400, 0xa0ee64ff, REGISTRY_APNIC      }, // 160.238.100.0   - 160.238.100.255
	{ 0xa0ee6600, 0xa0ee67ff, REGISTRY_ARIN       }, // 160.238.102.0   - 160.238.103.255
	{ 0xa0ee6800, 0xa0ee6fff, REGISTRY_LACNIC     }, // 160.238.104.0   - 160.238.111.255
	{ 0xa0ee7000, 0xa0ee7fff, REGISTRY_RIPENCC    }, // 160.238.112.0   - 160.238.127.255
	{ 0xa0ee8000, 0xa0eeffff, REGISTRY_LACNIC     }, // 160.238.128.0   - 160.238.255.255
	{ 0xa0ef0000, 0xa0f1ffff, REGISTRY_APNIC      }, // 160.239.0.0     - 160.241.255.255
	{ 0xa0f20000, 0xa0f2ffff, REGISTRY_AFRINIC    }, // 160.242.0.0     - 160.242.255.255
	{ 0xa0f30000, 0xa0f9ffff, REGISTRY_APNIC      }, // 160.243.0.0     - 160.249.255.255
	{ 0xa0fb0000, 0xa0fcffff, REGISTRY_APNIC      }, // 160.251.0.0     - 160.252.255.255
	{ 0xa0fd0000, 0xa0feffff, REGISTRY_ARIN       }, // 160.253.0.0     - 160.254.255.255
	{ 0xa0ff0000, 0xa0ffffff, REGISTRY_AFRINIC    }, // 160.255.0.0     - 160.255.255.255
	{ 0xa1000000, 0xa100ffff, REGISTRY_LACNIC     }, // 161.0.0.0       - 161.0.255.255
	{ 0xa1010000, 0xa101ffff, REGISTRY_ARIN       }, // 161.1.0.0       - 161.1.255.255
	{ 0xa1020000, 0xa105ffff, REGISTRY_RIPENCC    }, // 161.2.0.0       - 161.5.255.255
	{ 0xa1060000, 0xa107ffff, REGISTRY_ARIN       }, // 161.6.0.0       - 161.7.255.255
	{ 0xa1080000, 0xa109ffff, REGISTRY_RIPENCC    }, // 161.8.0.0       - 161.9.255.255
	{ 0xa10a0000, 0xa10affff, REGISTRY_LACNIC     }, // 161.10.0.0      - 161.10.255.255
	{ 0xa10b0000, 0xa10bffff, REGISTRY_ARIN       }, // 161.11.0.0      - 161.11.255.255
	{ 0xa10c0000, 0xa10cffff, REGISTRY_RIPENCC    }, // 161.12.0.0      - 161.12.255.255
	{ 0xa10d0000, 0xa110ffff, REGISTRY_ARIN       }, // 161.13.0.0      - 161.16.255.255
	{ 0xa1110000, 0xa111ffff, REGISTRY_RIPENCC    }, // 161.17.0.0      - 161.17.255.255
	{ 0xa1120000, 0xa112ffff, REGISTRY_LACNIC     }, // 161.18.0.0      - 161.18.255.255
	{ 0xa1130000, 0xa113ffff, REGISTRY_ARIN       }, // 161.19.0.0      - 161.19.255.255
	{ 0xa1140000, 0xa114ffff, REGISTRY_RIPENCC    }, // 161.20.0.0      - 161.20.255.255
	{ 0xa1150000, 0xa115ffff, REGISTRY_ARIN       }, // 161.21.0.0      - 161.21.255.255
	{ 0xa1160000, 0xa116ffff, REGISTRY_LACNIC     }, // 161.22.0.0      - 161.22.255.255
	{ 0xa1170000, 0xa117ffff, REGISTRY_RIPENCC    }, // 161.23.0.0      - 161.23.255.255
	{ 0xa1180000, 0xa119ffff, REGISTRY_LACNIC     }, // 161.24.0.0      - 161.25.255.255
	{ 0xa11a0000, 0xa11affff, REGISTRY_ARIN       }, // 161.26.0.0      - 161.26.255.255
	{ 0xa11b0000, 0xa11bffff, REGISTRY_RIPENCC    }, // 161.27.0.0      - 161.27.255.255
	{ 0xa11c0000, 0xa11cffff, REGISTRY_ARIN       }, // 161.28.0.0      - 161.28.255.255
	{ 0xa11d0000, 0xa11dffff, REGISTRY_APNIC      }, // 161.29.0.0      - 161.29.255.255
	{ 0xa11e0000, 0xa11effff, REGISTRY_RIPENCC    }, // 161.30.0.0      - 161.30.255.255
	{ 0xa11f0000, 0xa121ffff, REGISTRY_ARIN       }, // 161.31.0.0      - 161.33.255.255
	{ 0xa1220000, 0xa122ffff, REGISTRY_APNIC      }, // 161.34.0.0      - 161.34.255.255
	{ 0xa1230000, 0xa124ffff, REGISTRY_ARIN       }, // 161.35.0.0      - 161.36.255.255
	{ 0xa1250000, 0xa125ffff, REGISTRY_RIPENCC    }, // 161.37.0.0      - 161.37.255.255
	{ 0xa1260000, 0xa128ffff, REGISTRY_ARIN       }, // 161.38.0.0      - 161.40.255.255
	{ 0xa1290000, 0xa12affff, REGISTRY_RIPENCC    }, // 161.41.0.0      - 161.42.255.255
	{ 0xa12b0000, 0xa12bffff, REGISTRY_APNIC      }, // 161.43.0.0      - 161.43.255.255
	{ 0xa12c0000, 0xa12fffff, REGISTRY_ARIN       }, // 161.44.0.0      - 161.47.255.255
	{ 0xa1300000, 0xa130ffff, REGISTRY_RIPENCC    }, // 161.48.0.0      - 161.48.255.255
	{ 0xa1310000, 0xa131bbff, REGISTRY_APNIC      }, // 161.49.0.0      - 161.49.187.255
	{ 0xa131bc00, 0xa131bfff, REGISTRY_ARIN       }, // 161.49.188.0    - 161.49.191.255
	{ 0xa131c000, 0xa131e7ff, REGISTRY_APNIC      }, // 161.49.192.0    - 161.49.231.255
	{ 0xa131e800, 0xa131ffff, REGISTRY_ARIN       }, // 161.49.232.0    - 161.49.255.255
	{ 0xa1320000, 0xa132ffff, REGISTRY_APNIC      }, // 161.50.0.0      - 161.50.255.255
	{ 0xa1330000, 0xa133ffff, REGISTRY_ARIN       }, // 161.51.0.0      - 161.51.255.255
	{ 0xa1340000, 0xa134ffff, REGISTRY_RIPENCC    }, // 161.52.0.0      - 161.52.255.255
	{ 0xa1350000, 0xa135ffff, REGISTRY_RIPENCC    }, // 161.53.0.0      - 161.53.255.255
	{ 0xa1360000, 0xa136ffff, REGISTRY_RIPENCC    }, // 161.54.0.0      - 161.54.255.255
	{ 0xa1370000, 0xa137ffff, REGISTRY_ARIN       }, // 161.55.0.0      - 161.55.255.255
	{ 0xa1380000, 0xa138ffff, REGISTRY_LACNIC     }, // 161.56.0.0      - 161.56.255.255
	{ 0xa1390000, 0xa13affff, REGISTRY_ARIN       }, // 161.57.0.0      - 161.58.255.255
	{ 0xa13b0000, 0xa13bffff, REGISTRY_RIPENCC    }, // 161.59.0.0      - 161.59.255.255
	{ 0xa13c0000, 0xa13dffff, REGISTRY_ARIN       }, // 161.60.0.0      - 161.61.255.255
	{ 0xa13e0000, 0xa13effff, REGISTRY_RIPENCC    }, // 161.62.0.0      - 161.62.255.255
	{ 0xa13f0000, 0xa13fffff, REGISTRY_ARIN       }, // 161.63.0.0      - 161.63.255.255
	{ 0xa1400000, 0xa142ffff, REGISTRY_APNIC      }, // 161.64.0.0      - 161.66.255.255
	{ 0xa1430000, 0xa143ffff, REGISTRY_RIPENCC    }, // 161.67.0.0      - 161.67.255.255
	{ 0xa1440000, 0xa145ffff, REGISTRY_ARIN       }, // 161.68.0.0      - 161.69.255.255
	{ 0xa1460000, 0xa146ffff, REGISTRY_RIPENCC    }, // 161.70.0.0      - 161.70.255.255
	{ 0xa1470000, 0xa14affff, REGISTRY_RIPENCC    }, // 161.71.0.0      - 161.74.255.255
	{ 0xa14b0000, 0xa14bffff, REGISTRY_APNIC      }, // 161.75.0.0      - 161.75.255.255
	{ 0xa14c0000, 0xa14cffff, REGISTRY_RIPENCC    }, // 161.76.0.0      - 161.76.255.255
	{ 0xa14d0000, 0xa14dffff, REGISTRY_ARIN       }, // 161.77.0.0      - 161.77.255.255
	{ 0xa14e0000, 0xa14effff, REGISTRY_RIPENCC    }, // 161.78.0.0      - 161.78.255.255
	{ 0xa14f0000, 0xa14fffff, REGISTRY_LACNIC     }, // 161.79.0.0      - 161.79.255.255
	{ 0xa1500000, 0xa152ffff, REGISTRY_ARIN       }, // 161.80.0.0      - 161.82.255.255
	{ 0xa1530000, 0xa15cffff, REGISTRY_RIPENCC    }, // 161.83.0.0      - 161.92.255.255
	{ 0xa15d0000, 0xa160ffff, REGISTRY_APNIC      }, // 161.93.0.0      - 161.96.255.255
	{ 0xa1610000, 0xa167ffff, REGISTRY_ARIN       }, // 161.97.0.0      - 161.103.255.255
	{ 0xa1680000, 0xa16affff, REGISTRY_RIPENCC    }, // 161.104.0.0     - 161.106.255.255
	{ 0xa16b0000, 0xa16dffff, REGISTRY_ARIN       }, // 161.107.0.0     - 161.109.255.255
	{ 0xa16e0000, 0xa170ffff, REGISTRY_RIPENCC    }, // 161.110.0.0     - 161.112.255.255
	{ 0xa1710000, 0xa173ffff, REGISTRY_ARIN       }, // 161.113.0.0     - 161.115.255.255
	{ 0xa1740000, 0xa174ffff, REGISTRY_RIPENCC    }, // 161.116.0.0     - 161.116.255.255
	{ 0xa1750000, 0xa176ffff, REGISTRY_APNIC      }, // 161.117.0.0     - 161.118.255.255
	{ 0xa1770000, 0xa179ffff, REGISTRY_ARIN       }, // 161.119.0.0     - 161.121.255.255
	{ 0xa17a0000, 0xa17affff, REGISTRY_APNIC      }, // 161.122.0.0     - 161.122.255.255
	{ 0xa17b0000, 0xa17bffff, REGISTRY_AFRINIC    }, // 161.123.0.0     - 161.123.255.255
	{ 0xa17c0000, 0xa17dffff, REGISTRY_ARIN       }, // 161.124.0.0     - 161.125.255.255
	{ 0xa17e0000, 0xa17effff, REGISTRY_APNIC      }, // 161.126.0.0     - 161.126.255.255
	{ 0xa17f0000, 0xa182ffff, REGISTRY_ARIN       }, // 161.127.0.0     - 161.130.255.255
	{ 0xa1830000, 0xa184ffff, REGISTRY_LACNIC     }, // 161.131.0.0     - 161.132.255.255
	{ 0xa1850000, 0xa185ffff, REGISTRY_ARIN       }, // 161.133.0.0     - 161.133.255.255
	{ 0xa1860000, 0xa186ffff, REGISTRY_RIPENCC    }, // 161.134.0.0     - 161.134.255.255
	{ 0xa1870000, 0xa189ffff, REGISTRY_ARIN       }, // 161.135.0.0     - 161.137.255.255
	{ 0xa18a0000, 0xa18affff, REGISTRY_LACNIC     }, // 161.138.0.0     - 161.138.255.255
	{ 0xa18b0000, 0xa18bffff, REGISTRY_APNIC      }, // 161.139.0.0     - 161.139.255.255
	{ 0xa18c0000, 0xa18cffff, REGISTRY_LACNIC     }, // 161.140.0.0     - 161.140.255.255
	{ 0xa18d0000, 0xa18dffff, REGISTRY_ARIN       }, // 161.141.0.0     - 161.141.255.255
	{ 0xa18e0000, 0xa18fffff, REGISTRY_APNIC      }, // 161.142.0.0     - 161.143.255.255
	{ 0xa1900000, 0xa191ffff, REGISTRY_ARIN       }, // 161.144.0.0     - 161.145.255.255
	{ 0xa1920000, 0xa192ffff, REGISTRY_APNIC      }, // 161.146.0.0     - 161.146.255.255
	{ 0xa1930000, 0xa193ffff, REGISTRY_RIPENCC    }, // 161.147.0.0     - 161.147.255.255
	{ 0xa1940000, 0xa194ffff, REGISTRY_LACNIC     }, // 161.148.0.0     - 161.148.255.255
	{ 0xa1950000, 0xa197ffff, REGISTRY_ARIN       }, // 161.149.0.0     - 161.151.255.255
	{ 0xa1980000, 0xa198ffff, REGISTRY_APNIC      }, // 161.152.0.0     - 161.152.255.255
	{ 0xa1990000, 0xa19bffff, REGISTRY_ARIN       }, // 161.153.0.0     - 161.155.255.255
	{ 0xa19c0000, 0xa19cffff, REGISTRY_RIPENCC    }, // 161.156.0.0     - 161.156.255.255
	{ 0xa19d0000, 0xa19dffff, REGISTRY_ARIN       }, // 161.157.0.0     - 161.157.255.255
	{ 0xa19e0000, 0xa19effff, REGISTRY_RIPENCC    }, // 161.158.0.0     - 161.158.255.255
	{ 0xa19f0000, 0xa1bcffff, REGISTRY_ARIN       }, // 161.159.0.0     - 161.188.255.255
	{ 0xa1bd0000, 0xa1bdffff, REGISTRY_APNIC      }, // 161.189.0.0     - 161.189.255.255
	{ 0xa1be0000, 0xa1beffff, REGISTRY_LACNIC     }, // 161.190.0.0     - 161.190.255.255
	{ 0xa1bf0000, 0xa1c3ffff, REGISTRY_ARIN       }, // 161.191.0.0     - 161.195.255.255
	{ 0xa1c40000, 0xa1c4ffff, REGISTRY_LACNIC     }, // 161.196.0.0     - 161.196.255.255
	{ 0xa1c50000, 0xa1c7ffff, REGISTRY_ARIN       }, // 161.197.0.0     - 161.199.255.255
	{ 0xa1c80000, 0xa1c8ffff, REGISTRY_APNIC      }, // 161.200.0.0     - 161.200.255.255
	{ 0xa1c90000, 0xa1c9ffff, REGISTRY_ARIN       }, // 161.201.0.0     - 161.201.255.255
	{ 0xa1ca0000, 0xa1caffff, REGISTRY_RIPENCC    }, // 161.202.0.0     - 161.202.255.255
	{ 0xa1cb0000, 0xa1ceffff, REGISTRY_ARIN       }, // 161.203.0.0     - 161.206.255.255
	{ 0xa1cf0000, 0xa1cfffff, REGISTRY_APNIC      }, // 161.207.0.0     - 161.207.255.255
	{ 0xa1d00000, 0xa1d3ffff, REGISTRY_ARIN       }, // 161.208.0.0     - 161.211.255.255
	{ 0xa1d40000, 0xa1d4ffff, REGISTRY_LACNIC     }, // 161.212.0.0     - 161.212.255.255
	{ 0xa1d50000, 0xa1d9ffff, REGISTRY_ARIN       }, // 161.213.0.0     - 161.217.255.255
	{ 0xa1da0000, 0xa1daffff, REGISTRY_RIPENCC    }, // 161.218.0.0     - 161.218.255.255
	{ 0xa1db0000, 0xa1e4ffff, REGISTRY_ARIN       }, // 161.219.0.0     - 161.228.255.255
	{ 0xa1e50000, 0xa1e5ffff, REGISTRY_APNIC      }, // 161.229.0.0     - 161.229.255.255
	{ 0xa1e60000, 0xa1e6ffff, REGISTRY_RIPENCC    }, // 161.230.0.0     - 161.230.255.255
	{ 0xa1e70000, 0xa1e9ffff, REGISTRY_ARIN       }, // 161.231.0.0     - 161.233.255.255
	{ 0xa1ea0000, 0xa1eaffff, REGISTRY_LACNIC     }, // 161.234.0.0     - 161.234.255.255
	{ 0xa1eb0000, 0xa1edffff, REGISTRY_ARIN       }, // 161.235.0.0     - 161.237.255.255
	{ 0xa1ee0000, 0xa1eeffff, REGISTRY_LACNIC     }, // 161.238.0.0     - 161.238.255.255
	{ 0xa1ef0000, 0xa1f5ffff, REGISTRY_ARIN       }, // 161.239.0.0     - 161.245.255.255
	{ 0xa1f60000, 0xa1f6ffff, REGISTRY_APNIC      }, // 161.246.0.0     - 161.246.255.255
	{ 0xa1f70000, 0xa1f7ffff, REGISTRY_ARIN       }, // 161.247.0.0     - 161.247.255.255
	{ 0xa1f90000, 0xa1faffff, REGISTRY_ARIN       }, // 161.249.0.0     - 161.250.255.255
	{ 0xa1fb0000, 0xa1fbffff, REGISTRY_RIPENCC    }, // 161.251.0.0     - 161.251.255.255
	{ 0xa1fc0000, 0xa1fcffff, REGISTRY_RIPENCC    }, // 161.252.0.0     - 161.252.255.255
	{ 0xa1fd0000, 0xa1feffff, REGISTRY_ARIN       }, // 161.253.0.0     - 161.254.255.255
	{ 0xa1ff0000, 0xa1ffffff, REGISTRY_LACNIC     }, // 161.255.0.0     - 161.255.255.255
	{ 0xa2000000, 0xa203ffff, REGISTRY_ARIN       }, // 162.0.0.0       - 162.3.255.255
	{ 0xa2050000, 0xa20affff, REGISTRY_ARIN       }, // 162.5.0.0       - 162.10.255.255
	{ 0xa20b0000, 0xa20bffff, REGISTRY_RIPENCC    }, // 162.11.0.0      - 162.11.255.255
	{ 0xa20c0000, 0xa20cc3ff, REGISTRY_ARIN       }, // 162.12.0.0      - 162.12.195.255
	{ 0xa20cc400, 0xa20cc7ff, REGISTRY_LACNIC     }, // 162.12.196.0    - 162.12.199.255
	{ 0xa20cc800, 0xa20ccfff, REGISTRY_RIPENCC    }, // 162.12.200.0    - 162.12.207.255
	{ 0xa20cd000, 0xa20cd7ff, REGISTRY_APNIC      }, // 162.12.208.0    - 162.12.215.255
	{ 0xa20cd800, 0xa20cefff, REGISTRY_ARIN       }, // 162.12.216.0    - 162.12.239.255
	{ 0xa20cf000, 0xa20cf7ff, REGISTRY_APNIC      }, // 162.12.240.0    - 162.12.247.255
	{ 0xa20cf800, 0xa20cffff, REGISTRY_ARIN       }, // 162.12.248.0    - 162.12.255.255
	{ 0xa20d0000, 0xa20dffff, REGISTRY_RIPENCC    }, // 162.13.0.0      - 162.13.255.255
	{ 0xa20e0000, 0xa20effff, REGISTRY_APNIC      }, // 162.14.0.0      - 162.14.255.255
	{ 0xa20f0000, 0xa214ffff, REGISTRY_ARIN       }, // 162.15.0.0      - 162.20.255.255
	{ 0xa2150000, 0xa215ffff, REGISTRY_RIPENCC    }, // 162.21.0.0      - 162.21.255.255
	{ 0xa2160000, 0xa216ffff, REGISTRY_ARIN       }, // 162.22.0.0      - 162.22.255.255
	{ 0xa2170000, 0xa217ffff, REGISTRY_RIPENCC    }, // 162.23.0.0      - 162.23.255.255
	{ 0xa2180000, 0xa218ffff, REGISTRY_ARIN       }, // 162.24.0.0      - 162.24.255.255
	{ 0xa2190000, 0xa21affff, REGISTRY_RIPENCC    }, // 162.25.0.0      - 162.26.255.255
	{ 0xa21b0000, 0xa225ffff, REGISTRY_ARIN       }, // 162.27.0.0      - 162.37.255.255
	{ 0xa2260000, 0xa226ffff, REGISTRY_RIPENCC    }, // 162.38.0.0      - 162.38.255.255
	{ 0xa2270000, 0xa237ffff, REGISTRY_ARIN       }, // 162.39.0.0      - 162.55.255.255
	{ 0xa2380000, 0xa238ffff, REGISTRY_APNIC      }, // 162.56.0.0      - 162.56.255.255
	{ 0xa2390000, 0xa23dffff, REGISTRY_ARIN       }, // 162.57.0.0      - 162.61.255.255
	{ 0xa23e0000, 0xa23effff, REGISTRY_APNIC      }, // 162.62.0.0      - 162.62.255.255
	{ 0xa23f0000, 0xa255ffff, REGISTRY_ARIN       }, // 162.63.0.0      - 162.85.255.255
	{ 0xa2560000, 0xa256ffff, REGISTRY_RIPENCC    }, // 162.86.0.0      - 162.86.255.255
	{ 0xa2570000, 0xa268ffff, REGISTRY_ARIN       }, // 162.87.0.0      - 162.104.255.255
	{ 0xa2690000, 0xa269ffff, REGISTRY_APNIC      }, // 162.105.0.0     - 162.105.255.255
	{ 0xa26a0000, 0xa26fffff, REGISTRY_ARIN       }, // 162.106.0.0     - 162.111.255.255
	{ 0xa2700000, 0xa270ffff, REGISTRY_APNIC      }, // 162.112.0.0     - 162.112.255.255
	{ 0xa2710000, 0xa279ffff, REGISTRY_ARIN       }, // 162.113.0.0     - 162.121.255.255
	{ 0xa27a0000, 0xa27affff, REGISTRY_LACNIC     }, // 162.122.0.0     - 162.122.255.255
	{ 0xa27b0000, 0xa284ffff, REGISTRY_ARIN       }, // 162.123.0.0     - 162.132.255.255
	{ 0xa2850000, 0xa285ffff, REGISTRY_RIPENCC    }, // 162.133.0.0     - 162.133.255.255
	{ 0xa2860000, 0xa28e7fff, REGISTRY_ARIN       }, // 162.134.0.0     - 162.142.127.255
	{ 0xa28e8000, 0xa28effff, REGISTRY_RIPENCC    }, // 162.142.128.0   - 162.142.255.255
	{ 0xa28f0000, 0xa290ffff, REGISTRY_ARIN       }, // 162.143.0.0     - 162.144.255.255
	{ 0xa2910000, 0xa293ffff, REGISTRY_APNIC      }, // 162.145.0.0     - 162.147.255.255
	{ 0xa2940000, 0xa2d889ff, REGISTRY_ARIN       }, // 162.148.0.0     - 162.216.137.255
	{ 0xa2d88a00, 0xa2d88bff, REGISTRY_RIPENCC    }, // 162.216.138.0   - 162.216.139.255
	{ 0xa2d88c00, 0xa2d88fff, REGISTRY_APNIC      }, // 162.216.140.0   - 162.216.143.255
	{ 0xa2d89000, 0xa2d9f7ff, REGISTRY_ARIN       }, // 162.216.144.0   - 162.217.247.255
	{ 0xa2d9f800, 0xa2d9fbff, REGISTRY_RIPENCC    }, // 162.217.248.0   - 162.217.251.255
	{ 0xa2d9fc00, 0xa2da57ff, REGISTRY_ARIN       }, // 162.217.252.0   - 162.218.87.255
	{ 0xa2da5800, 0xa2da5fff, REGISTRY_RIPENCC    }, // 162.218.88.0    - 162.218.95.255
	{ 0xa2da6000, 0xa2daafff, REGISTRY_ARIN       }, // 162.218.96.0    - 162.218.175.255
	{ 0xa2dab000, 0xa2dab3ff, REGISTRY_RIPENCC    }, // 162.218.176.0   - 162.218.179.255
	{ 0xa2dab400, 0xa2db1fff, REGISTRY_ARIN       }, // 162.218.180.0   - 162.219.31.255
	{ 0xa2db2000, 0xa2db27ff, REGISTRY_APNIC      }, // 162.219.32.0    - 162.219.39.255
	{ 0xa2db2800, 0xa2db4fff, REGISTRY_ARIN       }, // 162.219.40.0    - 162.219.79.255
	{ 0xa2db5000, 0xa2db57ff, REGISTRY_APNIC      }, // 162.219.80.0    - 162.219.87.255
	{ 0xa2db5800, 0xa2dcefff, REGISTRY_ARIN       }, // 162.219.88.0    - 162.220.239.255
	{ 0xa2dcf000, 0xa2dcf7ff, REGISTRY_RIPENCC    }, // 162.220.240.0   - 162.220.247.255
	{ 0xa2dcf800, 0xa2dd4bff, REGISTRY_ARIN       }, // 162.220.248.0   - 162.221.75.255
	{ 0xa2dd4c00, 0xa2dd4fff, REGISTRY_APNIC      }, // 162.221.76.0    - 162.221.79.255
	{ 0xa2dd5000, 0xa2de57ff, REGISTRY_ARIN       }, // 162.221.80.0    - 162.222.87.255
	{ 0xa2de5800, 0xa2de5aff, REGISTRY_RIPENCC    }, // 162.222.88.0    - 162.222.90.255
	{ 0xa2de5b00, 0xa2dfa7ff, REGISTRY_ARIN       }, // 162.222.91.0    - 162.223.167.255
	{ 0xa2dfa800, 0xa2dfafff, REGISTRY_APNIC      }, // 162.223.168.0   - 162.223.175.255
	{ 0xa2dfb000, 0xa2f433ff, REGISTRY_ARIN       }, // 162.223.176.0   - 162.244.51.255
	{ 0xa2f43400, 0xa2f437ff, REGISTRY_RIPENCC    }, // 162.244.52.0    - 162.244.55.255
	{ 0xa2f43800, 0xa2f57bff, REGISTRY_ARIN       }, // 162.244.56.0    - 162.245.123.255
	{ 0xa2f57c00, 0xa2f57fff, REGISTRY_APNIC      }, // 162.245.124.0   - 162.245.127.255
	{ 0xa2f58000, 0xa2f5cbff, REGISTRY_ARIN       }, // 162.245.128.0   - 162.245.203.255
	{ 0xa2f5cc00, 0xa2f5cfff, REGISTRY_RIPENCC    }, // 162.245.204.0   - 162.245.207.255
	{ 0xa2f5d000, 0xa2f6ffff, REGISTRY_ARIN       }, // 162.245.208.0   - 162.246.255.255
	{ 0xa2f70000, 0xa2f707ff, REGISTRY_APNIC      }, // 162.247.0.0     - 162.247.7.255
	{ 0xa2f70800, 0xa2f8c3ff, REGISTRY_ARIN       }, // 162.247.8.0     - 162.248.195.255
	{ 0xa2f8c400, 0xa2f8c7ff, REGISTRY_RIPENCC    }, // 162.248.196.0   - 162.248.199.255
	{ 0xa2f8c800, 0xa2fad7ff, REGISTRY_ARIN       }, // 162.248.200.0   - 162.250.215.255
	{ 0xa2fad800, 0xa2fadbff, REGISTRY_RIPENCC    }, // 162.250.216.0   - 162.250.219.255
	{ 0xa2fadc00, 0xa2fb1fff, REGISTRY_ARIN       }, // 162.250.220.0   - 162.251.31.255
	{ 0xa2fb2000, 0xa2fb27ff, REGISTRY_RIPENCC    }, // 162.251.32.0    - 162.251.39.255
	{ 0xa2fb2800, 0xa2fd0fff, REGISTRY_ARIN       }, // 162.251.40.0    - 162.253.15.255
	{ 0xa2fd1000, 0xa2fd13ff, REGISTRY_APNIC      }, // 162.253.16.0    - 162.253.19.255
	{ 0xa2fd1400, 0xa2ff2fff, REGISTRY_ARIN       }, // 162.253.20.0    - 162.255.47.255
	{ 0xa2ff3000, 0xa2ff33ff, REGISTRY_APNIC      }, // 162.255.48.0    - 162.255.51.255
	{ 0xa2ff3400, 0xa2ffc3ff, REGISTRY_ARIN       }, // 162.255.52.0    - 162.255.195.255
	{ 0xa2ffc400, 0xa2ffc7ff, REGISTRY_RIPENCC    }, // 162.255.196.0   - 162.255.199.255
	{ 0xa2ffc800, 0xa2ffffff, REGISTRY_ARIN       }, // 162.255.200.0   - 162.255.255.255
	{ 0xa3000000, 0xa300ffff, REGISTRY_APNIC      }, // 163.0.0.0       - 163.0.255.255
	{ 0xa3010000, 0xa301ffff, REGISTRY_RIPENCC    }, // 163.1.0.0       - 163.1.255.255
	{ 0xa3020000, 0xa302ffff, REGISTRY_ARIN       }, // 163.2.0.0       - 163.2.255.255
	{ 0xa3030000, 0xa303ffff, REGISTRY_RIPENCC    }, // 163.3.0.0       - 163.3.255.255
	{ 0xa3040000, 0xa304ffff, REGISTRY_ARIN       }, // 163.4.0.0       - 163.4.255.255
	{ 0xa3050000, 0xa305ffff, REGISTRY_RIPENCC    }, // 163.5.0.0       - 163.5.255.255
	{ 0xa3060000, 0xa306ffff, REGISTRY_ARIN       }, // 163.6.0.0       - 163.6.255.255
	{ 0xa3070000, 0xa308ffff, REGISTRY_APNIC      }, // 163.7.0.0       - 163.8.255.255
	{ 0xa3090000, 0xa309ffff, REGISTRY_RIPENCC    }, // 163.9.0.0       - 163.9.255.255
	{ 0xa30a0000, 0xa30affff, REGISTRY_LACNIC     }, // 163.10.0.0      - 163.10.255.255
	{ 0xa30b0000, 0xa30cffff, REGISTRY_ARIN       }, // 163.11.0.0      - 163.12.255.255
	{ 0xa30d0000, 0xa320ffff, REGISTRY_APNIC      }, // 163.13.0.0      - 163.32.255.255
	{ 0xa3210000, 0xa321ffff, REGISTRY_ARIN       }, // 163.33.0.0      - 163.33.255.255
	{ 0xa3220000, 0xa322ffff, REGISTRY_RIPENCC    }, // 163.34.0.0      - 163.34.255.255
	{ 0xa3230000, 0xa329ffff, REGISTRY_ARIN       }, // 163.35.0.0      - 163.41.255.255
	{ 0xa32a0000, 0xa32f15ff, REGISTRY_APNIC      }, // 163.42.0.0      - 163.47.21.255
	{ 0xa32f1700, 0xa32f18ff, REGISTRY_APNIC      }, // 163.47.23.0     - 163.47.24.255
	{ 0xa32f1d00, 0xa32f1dff, REGISTRY_APNIC      }, // 163.47.29.0     - 163.47.29.255
	{ 0xa32f2000, 0xa32f2dff, REGISTRY_APNIC      }, // 163.47.32.0     - 163.47.45.255
	{ 0xa32f2f00, 0xa32f4bff, REGISTRY_APNIC      }, // 163.47.47.0     - 163.47.75.255
	{ 0xa32f4c00, 0xa32f4fff, REGISTRY_ARIN       }, // 163.47.76.0     - 163.47.79.255
	{ 0xa32f5000, 0xa333ffff, REGISTRY_APNIC      }, // 163.47.80.0     - 163.51.255.255
	{ 0xa3350000, 0xa338ffff, REGISTRY_APNIC      }, // 163.53.0.0      - 163.56.255.255
	{ 0xa33a0000, 0xa33cffff, REGISTRY_APNIC      }, // 163.58.0.0      - 163.60.255.255
	{ 0xa33e0000, 0xa375ffff, REGISTRY_RIPENCC    }, // 163.62.0.0      - 163.117.255.255
	{ 0xa3760000, 0xa376ffff, REGISTRY_ARIN       }, // 163.118.0.0     - 163.118.255.255
	{ 0xa3770000, 0xa377ffff, REGISTRY_RIPENCC    }, // 163.119.0.0     - 163.119.255.255
	{ 0xa3780000, 0xa378ffff, REGISTRY_ARIN       }, // 163.120.0.0     - 163.120.255.255
	{ 0xa3790000, 0xa379ffff, REGISTRY_AFRINIC    }, // 163.121.0.0     - 163.121.255.255
	{ 0xa37a0000, 0xa37affff, REGISTRY_APNIC      }, // 163.122.0.0     - 163.122.255.255
	{ 0xa37b0000, 0xa37cffff, REGISTRY_ARIN       }, // 163.123.0.0     - 163.124.255.255
	{ 0xa37d0000, 0xa37dffff, REGISTRY_APNIC      }, // 163.125.0.0     - 163.125.255.255
	{ 0xa37e0000, 0xa37effff, REGISTRY_ARIN       }, // 163.126.0.0     - 163.126.255.255
	{ 0xa3810000, 0xa381ffff, REGISTRY_ARIN       }, // 163.129.0.0     - 163.129.255.255
	{ 0xa3820000, 0xa395ffff, REGISTRY_APNIC      }, // 163.130.0.0     - 163.149.255.255
	{ 0xa3960000, 0xa397ffff, REGISTRY_ARIN       }, // 163.150.0.0     - 163.151.255.255
	{ 0xa3980000, 0xa398ffff, REGISTRY_APNIC      }, // 163.152.0.0     - 163.152.255.255
	{ 0xa3990000, 0xa39bffff, REGISTRY_ARIN       }, // 163.153.0.0     - 163.155.255.255
	{ 0xa39c0000, 0xa3afffff, REGISTRY_RIPENCC    }, // 163.156.0.0     - 163.175.255.255
	{ 0xa3b00000, 0xa3b0ffff, REGISTRY_ARIN       }, // 163.176.0.0     - 163.176.255.255
	{ 0xa3b10000, 0xa3b1ffff, REGISTRY_APNIC      }, // 163.177.0.0     - 163.177.255.255
	{ 0xa3b20000, 0xa3b2ffff, REGISTRY_LACNIC     }, // 163.178.0.0     - 163.178.255.255
	{ 0xa3b30000, 0xa3b4ffff, REGISTRY_APNIC      }, // 163.179.0.0     - 163.180.255.255
	{ 0xa3b50000, 0xa3bcffff, REGISTRY_ARIN       }, // 163.181.0.0     - 163.188.255.255
	{ 0xa3bd0000, 0xa3bdffff, REGISTRY_APNIC      }, // 163.189.0.0     - 163.189.255.255
	{ 0xa3be0000, 0xa3c2ffff, REGISTRY_ARIN       }, // 163.190.0.0     - 163.194.255.255
	{ 0xa3c30000, 0xa3cbffff, REGISTRY_AFRINIC    }, // 163.195.0.0     - 163.203.255.255
	{ 0xa3cc0000, 0xa3ccffff, REGISTRY_APNIC      }, // 163.204.0.0     - 163.204.255.255
	{ 0xa3cd0000, 0xa3cfffff, REGISTRY_ARIN       }, // 163.205.0.0     - 163.207.255.255
	{ 0xa3d00000, 0xa3d7ffff, REGISTRY_APNIC      }, // 163.208.0.0     - 163.215.255.255
	{ 0xa3d90000, 0xa3deffff, REGISTRY_APNIC      }, // 163.217.0.0     - 163.222.255.255
	{ 0xa3e00000, 0xa3e2ffff, REGISTRY_APNIC      }, // 163.224.0.0     - 163.226.255.255
	{ 0xa3e30100, 0xa3e301ff, REGISTRY_APNIC      }, // 163.227.1.0     - 163.227.1.255
	{ 0xa3e31100, 0xa3e311ff, REGISTRY_APNIC      }, // 163.227.17.0    - 163.227.17.255
	{ 0xa3e37d00, 0xa3e37dff, REGISTRY_APNIC      }, // 163.227.125.0   - 163.227.125.255
	{ 0xa3e3dd00, 0xa3e3ddff, REGISTRY_APNIC      }, // 163.227.221.0   - 163.227.221.255
	{ 0xa3e3e100, 0xa3e3e3ff, REGISTRY_APNIC      }, // 163.227.225.0   - 163.227.227.255
	{ 0xa3e3e900, 0xa3e3eaff, REGISTRY_APNIC      }, // 163.227.233.0   - 163.227.234.255
	{ 0xa3e3f100, 0xa3e3f3ff, REGISTRY_APNIC      }, // 163.227.241.0   - 163.227.243.255
	{ 0xa3e3fe00, 0xa3e3feff, REGISTRY_APNIC      }, // 163.227.254.0   - 163.227.254.255
	{ 0xa3e40000, 0xa3e5ffff, REGISTRY_APNIC      }, // 163.228.0.0     - 163.229.255.255
	{ 0xa3e60000, 0xa3e7ffff, REGISTRY_ARIN       }, // 163.230.0.0     - 163.231.255.255
	{ 0xa3e80000, 0xa3e9ffff, REGISTRY_APNIC      }, // 163.232.0.0     - 163.233.255.255
	{ 0xa3ea0000, 0xa3eeffff, REGISTRY_ARIN       }, // 163.234.0.0     - 163.238.255.255
	{ 0xa3ef0000, 0xa3efffff, REGISTRY_APNIC      }, // 163.239.0.0     - 163.239.255.255
	{ 0xa3f00000, 0xa3f1ffff, REGISTRY_ARIN       }, // 163.240.0.0     - 163.241.255.255
	{ 0xa3f20000, 0xa3f2ffff, REGISTRY_RIPENCC    }, // 163.242.0.0     - 163.242.255.255
	{ 0xa3f30000, 0xa3f6ffff, REGISTRY_ARIN       }, // 163.243.0.0     - 163.246.255.255
	{ 0xa3f70000, 0xa3f7ffff, REGISTRY_LACNIC     }, // 163.247.0.0     - 163.247.255.255
	{ 0xa3f80000, 0xa3f9ffff, REGISTRY_ARIN       }, // 163.248.0.0     - 163.249.255.255
	{ 0xa3fa0000, 0xa3faffff, REGISTRY_LACNIC     }, // 163.250.0.0     - 163.250.255.255
	{ 0xa3fb0000, 0xa3feffff, REGISTRY_ARIN       }, // 163.251.0.0     - 163.254.255.255
	{ 0xa3ff0000, 0xa3ffffff, REGISTRY_APNIC      }, // 163.255.0.0     - 163.255.255.255
	{ 0xa4000000, 0xa400ffff, REGISTRY_RIPENCC    }, // 164.0.0.0       - 164.0.255.255
	{ 0xa4010000, 0xa40fffff, REGISTRY_RIPENCC    }, // 164.1.0.0       - 164.15.255.255
	{ 0xa4100000, 0xa423ffff, REGISTRY_RIPENCC    }, // 164.16.0.0      - 164.35.255.255
	{ 0xa4240000, 0xa427ffff, REGISTRY_RIPENCC    }, // 164.36.0.0      - 164.39.255.255
	{ 0xa4280000, 0xa428ffff, REGISTRY_RIPENCC    }, // 164.40.0.0      - 164.40.255.255
	{ 0xa4290000, 0xa429ffff, REGISTRY_LACNIC     }, // 164.41.0.0      - 164.41.255.255
	{ 0xa42a0000, 0xa42affff, REGISTRY_ARIN       }, // 164.42.0.0      - 164.42.255.255
	{ 0xa42b0000, 0xa42bffff, REGISTRY_APNIC      }, // 164.43.0.0      - 164.43.255.255
	{ 0xa42c0000, 0xa42dffff, REGISTRY_ARIN       }, // 164.44.0.0      - 164.45.255.255
	{ 0xa42e0000, 0xa42effff, REGISTRY_APNIC      }, // 164.46.0.0      - 164.46.255.255
	{ 0xa42f0000, 0xa42fffff, REGISTRY_ARIN       }, // 164.47.0.0      - 164.47.255.255
	{ 0xa4300000, 0xa430ffff, REGISTRY_RIPENCC    }, // 164.48.0.0      - 164.48.255.255
	{ 0xa4310000, 0xa433ffff, REGISTRY_ARIN       }, // 164.49.0.0      - 164.51.255.255
	{ 0xa4340000, 0xa4347fff, REGISTRY_APNIC      }, // 164.52.0.0      - 164.52.127.255
	{ 0xa4348000, 0xa434bfff, REGISTRY_ARIN       }, // 164.52.128.0    - 164.52.191.255
	{ 0xa434c000, 0xa434dfff, REGISTRY_APNIC      }, // 164.52.192.0    - 164.52.223.255
	{ 0xa434e000, 0xa434ffff, REGISTRY_ARIN       }, // 164.52.224.0    - 164.52.255.255
	{ 0xa4350000, 0xa435ffff, REGISTRY_APNIC      }, // 164.53.0.0      - 164.53.255.255
	{ 0xa4360000, 0xa43affff, REGISTRY_ARIN       }, // 164.54.0.0      - 164.58.255.255
	{ 0xa43b0000, 0xa43dffff, REGISTRY_RIPENCC    }, // 164.59.0.0      - 164.61.255.255
	{ 0xa43e0000, 0xa444ffff, REGISTRY_ARIN       }, // 164.62.0.0      - 164.68.255.255
	{ 0xa4450000, 0xa447ffff, REGISTRY_APNIC      }, // 164.69.0.0      - 164.71.255.255
	{ 0xa4480000, 0xa448ffff, REGISTRY_ARIN       }, // 164.72.0.0      - 164.72.255.255
	{ 0xa4490000, 0xa449ffff, REGISTRY_LACNIC     }, // 164.73.0.0      - 164.73.255.255
	{ 0xa44a0000, 0xa44affff, REGISTRY_ARIN       }, // 164.74.0.0      - 164.74.255.255
	{ 0xa44b0000, 0xa44bffff, REGISTRY_APNIC      }, // 164.75.0.0      - 164.75.255.255
	{ 0xa44c0000, 0xa44cffff, REGISTRY_ARIN       }, // 164.76.0.0      - 164.76.255.255
	{ 0xa44d0000, 0xa44dffff, REGISTRY_LACNIC     }, // 164.77.0.0      - 164.77.255.255
	{ 0xa44e0000, 0xa44effff, REGISTRY_APNIC      }, // 164.78.0.0      - 164.78.255.255
	{ 0xa44f0000, 0xa44fffff, REGISTRY_ARIN       }, // 164.79.0.0      - 164.79.255.255
	{ 0xa4500000, 0xa450ffff, REGISTRY_APNIC      }, // 164.80.0.0      - 164.80.255.255
	{ 0xa4510000, 0xa451ffff, REGISTRY_RIPENCC    }, // 164.81.0.0      - 164.81.255.255
	{ 0xa4520000, 0xa454ffff, REGISTRY_ARIN       }, // 164.82.0.0      - 164.84.255.255
	{ 0xa4550000, 0xa455ffff, REGISTRY_LACNIC     }, // 164.85.0.0      - 164.85.255.255
	{ 0xa4560000, 0xa457ffff, REGISTRY_ARIN       }, // 164.86.0.0      - 164.87.255.255
	{ 0xa4580000, 0xa458ffff, REGISTRY_AFRINIC    }, // 164.88.0.0      - 164.88.255.255
	{ 0xa4590000, 0xa45d7fff, REGISTRY_ARIN       }, // 164.89.0.0      - 164.93.127.255
	{ 0xa45d8000, 0xa45dffff, REGISTRY_RIPENCC    }, // 164.93.128.0    - 164.93.255.255
	{ 0xa45e0000, 0xa45fffff, REGISTRY_ARIN       }, // 164.94.0.0      - 164.95.255.255
	{ 0xa4600000, 0xa460ffff, REGISTRY_LACNIC     }, // 164.96.0.0      - 164.96.255.255
	{ 0xa4610000, 0xa461ffff, REGISTRY_APNIC      }, // 164.97.0.0      - 164.97.255.255
	{ 0xa4620000, 0xa462ffff, REGISTRY_LACNIC     }, // 164.98.0.0      - 164.98.255.255
	{ 0xa4630000, 0xa463ffff, REGISTRY_ARIN       }, // 164.99.0.0      - 164.99.255.255
	{ 0xa4640000, 0xa464ffff, REGISTRY_APNIC      }, // 164.100.0.0     - 164.100.255.255
	{ 0xa4650000, 0xa46bffff, REGISTRY_ARIN       }, // 164.101.0.0     - 164.107.255.255
	{ 0xa46c0000, 0xa46cffff, REGISTRY_APNIC      }, // 164.108.0.0     - 164.108.255.255
	{ 0xa46d0000, 0xa46fffff, REGISTRY_ARIN       }, // 164.109.0.0     - 164.111.255.255
	{ 0xa4700000, 0xa470ffff, REGISTRY_APNIC      }, // 164.112.0.0     - 164.112.255.255
	{ 0xa4710000, 0xa472ffff, REGISTRY_ARIN       }, // 164.113.0.0     - 164.114.255.255
	{ 0xa4730000, 0xa473ffff, REGISTRY_APNIC      }, // 164.115.0.0     - 164.115.255.255
	{ 0xa4740000, 0xa47bffff, REGISTRY_ARIN       }, // 164.116.0.0     - 164.123.255.255
	{ 0xa47c0000, 0xa47dffff, REGISTRY_APNIC      }, // 164.124.0.0     - 164.125.255.255
	{ 0xa47e0000, 0xa480ffff, REGISTRY_RIPENCC    }, // 164.126.0.0     - 164.128.255.255
	{ 0xa4810000, 0xa489ffff, REGISTRY_RIPENCC    }, // 164.129.0.0     - 164.137.255.255
	{ 0xa48a0000, 0xa48affff, REGISTRY_RIPENCC    }, // 164.138.0.0     - 164.138.255.255
	{ 0xa48b0000, 0xa48fffff, REGISTRY_RIPENCC    }, // 164.139.0.0     - 164.143.255.255
	{ 0xa4900000, 0xa491ffff, REGISTRY_ARIN       }, // 164.144.0.0     - 164.145.255.255
	{ 0xa4920000, 0xa497ffff, REGISTRY_AFRINIC    }, // 164.146.0.0     - 164.151.255.255
	{ 0xa4980000, 0xa49affff, REGISTRY_ARIN       }, // 164.152.0.0     - 164.154.255.255
	{ 0xa49b0000, 0xa49bffff, REGISTRY_AFRINIC    }, // 164.155.0.0     - 164.155.255.255
	{ 0xa49c0000, 0xa49fffff, REGISTRY_ARIN       }, // 164.156.0.0     - 164.159.255.255
	{ 0xa4a00000, 0xa4a037ff, REGISTRY_AFRINIC    }, // 164.160.0.0     - 164.160.55.255
	{ 0xa4a03c00, 0xa4a05fff, REGISTRY_AFRINIC    }, // 164.160.60.0    - 164.160.95.255
	{ 0xa4a06800, 0xa4a0c7ff, REGISTRY_AFRINIC    }, // 164.160.104.0   - 164.160.199.255
	{ 0xa4a0d000, 0xa4a0ffff, REGISTRY_AFRINIC    }, // 164.160.208.0   - 164.160.255.255
	{ 0xa4a10000, 0xa4a2ffff, REGISTRY_APNIC      }, // 164.161.0.0     - 164.162.255.255
	{ 0xa4a30000, 0xa4a3ffff, REGISTRY_LACNIC     }, // 164.163.0.0     - 164.163.255.255
	{ 0xa4a40000, 0xa4a4ffff, REGISTRY_APNIC      }, // 164.164.0.0     - 164.164.255.255
	{ 0xa4a50000, 0xa4b0ffff, REGISTRY_ARIN       }, // 164.165.0.0     - 164.176.255.255
	{ 0xa4b10000, 0xa4b1ffff, REGISTRY_RIPENCC    }, // 164.177.0.0     - 164.177.255.255
	{ 0xa4b20000, 0xa4d6ffff, REGISTRY_ARIN       }, // 164.178.0.0     - 164.214.255.255
	{ 0xa4d70000, 0xa4d7ffff, REGISTRY_RIPENCC    }, // 164.215.0.0     - 164.215.255.255
	{ 0xa4d80000, 0xa4ffffff, REGISTRY_ARIN       }, // 164.216.0.0     - 164.255.255.255
	{ 0xa5000000, 0xa500ffff, REGISTRY_AFRINIC    }, // 165.0.0.0       - 165.0.255.255
	{ 0xa5010000, 0xa502ffff, REGISTRY_ARIN       }, // 165.1.0.0       - 165.2.255.255
	{ 0xa5030000, 0xa505ffff, REGISTRY_AFRINIC    }, // 165.3.0.0       - 165.5.255.255
	{ 0xa5060000, 0xa507ffff, REGISTRY_ARIN       }, // 165.6.0.0       - 165.7.255.255
	{ 0xa5080000, 0xa50bffff, REGISTRY_AFRINIC    }, // 165.8.0.0       - 165.11.255.255
	{ 0xa50c0000, 0xa50cffff, REGISTRY_APNIC      }, // 165.12.0.0      - 165.12.255.255
	{ 0xa50d0000, 0xa50dffff, REGISTRY_ARIN       }, // 165.13.0.0      - 165.13.255.255
	{ 0xa50e0000, 0xa50effff, REGISTRY_APNIC      }, // 165.14.0.0      - 165.14.255.255
	{ 0xa5100000, 0xa510ffff, REGISTRY_AFRINIC    }, // 165.16.0.0      - 165.16.255.255
	{ 0xa5130000, 0xa514ffff, REGISTRY_ARIN       }, // 165.19.0.0      - 165.20.255.255
	{ 0xa5150000, 0xa515ffff, REGISTRY_APNIC      }, // 165.21.0.0      - 165.21.255.255
	{ 0xa5160000, 0xa518ffff, REGISTRY_ARIN       }, // 165.22.0.0      - 165.24.255.255
	{ 0xa5190000, 0xa519ffff, REGISTRY_AFRINIC    }, // 165.25.0.0      - 165.25.255.255
	{ 0xa51a0000, 0xa51effff, REGISTRY_ARIN       }, // 165.26.0.0      - 165.30.255.255
	{ 0xa51f0000, 0xa51fffff, REGISTRY_APNIC      }, // 165.31.0.0      - 165.31.255.255
	{ 0xa5200000, 0xa529ffff, REGISTRY_ARIN       }, // 165.32.0.0      - 165.41.255.255
	{ 0xa52a0000, 0xa52bffff, REGISTRY_APNIC      }, // 165.42.0.0      - 165.43.255.255
	{ 0xa52c0000, 0xa530ffff, REGISTRY_ARIN       }, // 165.44.0.0      - 165.48.255.255
	{ 0xa5310000, 0xa53fffff, REGISTRY_AFRINIC    }, // 165.49.0.0      - 165.63.255.255
	{ 0xa5400000, 0xa542ffff, REGISTRY_ARIN       }, // 165.64.0.0      - 165.66.255.255
	{ 0xa5440000, 0xa544ffff, REGISTRY_ARIN       }, // 165.68.0.0      - 165.68.255.255
	{ 0xa5450000, 0xa545ffff, REGISTRY_APNIC      }, // 165.69.0.0      - 165.69.255.255
	{ 0xa5460000, 0xa548ffff, REGISTRY_ARIN       }, // 165.70.0.0      - 165.72.255.255
	{ 0xa5490000, 0xa549ffff, REGISTRY_AFRINIC    }, // 165.73.0.0      - 165.73.255.255
	{ 0xa54a0000, 0xa54bffff, REGISTRY_ARIN       }, // 165.74.0.0      - 165.75.255.255
	{ 0xa54c0000, 0xa54cffff, REGISTRY_APNIC      }, // 165.76.0.0      - 165.76.255.255
	{ 0xa54d0000, 0xa54dffff, REGISTRY_ARIN       }, // 165.77.0.0      - 165.77.255.255
	{ 0xa54e0000, 0xa54effff, REGISTRY_RIPENCC    }, // 165.78.0.0      - 165.78.255.255
	{ 0xa54f0000, 0xa553ffff, REGISTRY_ARIN       }, // 165.79.0.0      - 165.83.255.255
	{ 0xa5540000, 0xa554cfff, REGISTRY_APNIC      }, // 165.84.0.0      - 165.84.207.255
	{ 0xa554d000, 0xa554dfff, REGISTRY_RIPENCC    }, // 165.84.208.0    - 165.84.223.255
	{ 0xa554e000, 0xa554e7ff, REGISTRY_ARIN       }, // 165.84.224.0    - 165.84.231.255
	{ 0xa554e800, 0xa554ffff, REGISTRY_APNIC      }, // 165.84.232.0    - 165.84.255.255
	{ 0xa5550000, 0xa555ffff, REGISTRY_ARIN       }, // 165.85.0.0      - 165.85.255.255
	{ 0xa5560000, 0xa556ffff, REGISTRY_APNIC      }, // 165.86.0.0      - 165.86.255.255
	{ 0xa5570000, 0xa559ffff, REGISTRY_ARIN       }, // 165.87.0.0      - 165.89.255.255
	{ 0xa55a0000, 0xa55affff, REGISTRY_AFRINIC    }, // 165.90.0.0      - 165.90.255.255
	{ 0xa55b0000, 0xa55cffff, REGISTRY_ARIN       }, // 165.91.0.0      - 165.92.255.255
	{ 0xa55d0000, 0xa55dffff, REGISTRY_APNIC      }, // 165.93.0.0      - 165.93.255.255
	{ 0xa55e0000, 0xa55fffff, REGISTRY_ARIN       }, // 165.94.0.0      - 165.95.255.255
	{ 0xa5600000, 0xa560ffff, REGISTRY_APNIC      }, // 165.96.0.0      - 165.96.255.255
	{ 0xa5610000, 0xa561ffff, REGISTRY_ARIN       }, // 165.97.0.0      - 165.97.255.255
	{ 0xa5620000, 0xa562ffff, REGISTRY_LACNIC     }, // 165.98.0.0      - 165.98.255.255
	{ 0xa5640000, 0xa56503ff, REGISTRY_APNIC      }, // 165.100.0.0     - 165.101.3.255
	{ 0xa5660000, 0xa566ffff, REGISTRY_APNIC      }, // 165.102.0.0     - 165.102.255.255
	{ 0xa5670000, 0xa56bffff, REGISTRY_ARIN       }, // 165.103.0.0     - 165.107.255.255
	{ 0xa56c0000, 0xa56cffff, REGISTRY_APNIC      }, // 165.108.0.0     - 165.108.255.255
	{ 0xa56d0000, 0xa571ffff, REGISTRY_ARIN       }, // 165.109.0.0     - 165.113.255.255
	{ 0xa5720000, 0xa572ffff, REGISTRY_RIPENCC    }, // 165.114.0.0     - 165.114.255.255
	{ 0xa5730000, 0xa575ffff, REGISTRY_ARIN       }, // 165.115.0.0     - 165.117.255.255
	{ 0xa5760000, 0xa576ffff, REGISTRY_APNIC      }, // 165.118.0.0     - 165.118.255.255
	{ 0xa5770000, 0xa583ffff, REGISTRY_ARIN       }, // 165.119.0.0     - 165.131.255.255
	{ 0xa5840000, 0xa585ffff, REGISTRY_APNIC      }, // 165.132.0.0     - 165.133.255.255
	{ 0xa5860000, 0xa58cffff, REGISTRY_ARIN       }, // 165.134.0.0     - 165.140.255.255
	{ 0xa58d0000, 0xa58effff, REGISTRY_APNIC      }, // 165.141.0.0     - 165.142.255.255
	{ 0xa58f0000, 0xa595ffff, REGISTRY_AFRINIC    }, // 165.143.0.0     - 165.149.255.255
	{ 0xa5960000, 0xa5a4ffff, REGISTRY_ARIN       }, // 165.150.0.0     - 165.164.255.255
	{ 0xa5a50000, 0xa5a5ffff, REGISTRY_AFRINIC    }, // 165.165.0.0     - 165.165.255.255
	{ 0xa5a60000, 0xa5a8ffff, REGISTRY_ARIN       }, // 165.166.0.0     - 165.168.255.255
	{ 0xa5a90000, 0xa5a9ffff, REGISTRY_AFRINIC    }, // 165.169.0.0     - 165.169.255.255
	{ 0xa5aa0000, 0xa5acffff, REGISTRY_ARIN       }, // 165.170.0.0     - 165.172.255.255
	{ 0xa5ad0000, 0xa5ad3fff, REGISTRY_APNIC      }, // 165.173.0.0     - 165.173.63.255
	{ 0xa5ad4000, 0xa5b3ffff, REGISTRY_ARIN       }, // 165.173.64.0    - 165.179.255.255
	{ 0xa5b40000, 0xa5b4ffff, REGISTRY_AFRINIC    }, // 165.180.0.0     - 165.180.255.255
	{ 0xa5b50000, 0xa5b5ffff, REGISTRY_ARIN       }, // 165.181.0.0     - 165.181.255.255
	{ 0xa5b60000, 0xa5b7ffff, REGISTRY_LACNIC     }, // 165.182.0.0     - 165.183.255.255
	{ 0xa5b80000, 0xa5b9ffff, REGISTRY_ARIN       }, // 165.184.0.0     - 165.185.255.255
	{ 0xa5ba0000, 0xa5bbffff, REGISTRY_APNIC      }, // 165.186.0.0     - 165.187.255.255
	{ 0xa5bc0000, 0xa5beffff, REGISTRY_ARIN       }, // 165.188.0.0     - 165.190.255.255
	{ 0xa5bf0000, 0xa5bfffff, REGISTRY_APNIC      }, // 165.191.0.0     - 165.191.255.255
	{ 0xa5c00000, 0xa5c0ffff, REGISTRY_RIPENCC    }, // 165.192.0.0     - 165.192.255.255
	{ 0xa5c10000, 0xa5c1ffff, REGISTRY_ARIN       }, // 165.193.0.0     - 165.193.255.255
	{ 0xa5c20000, 0xa5c2ffff, REGISTRY_APNIC      }, // 165.194.0.0     - 165.194.255.255
	{ 0xa5c30000, 0xa5c9ffff, REGISTRY_ARIN       }, // 165.195.0.0     - 165.201.255.255
	{ 0xa5ca0000, 0xa5caffff, REGISTRY_APNIC      }, // 165.202.0.0     - 165.202.255.255
	{ 0xa5cb0000, 0xa5ccffff, REGISTRY_ARIN       }, // 165.203.0.0     - 165.204.255.255
	{ 0xa5cd0000, 0xa5cdffff, REGISTRY_APNIC      }, // 165.205.0.0     - 165.205.255.255
	{ 0xa5ce0000, 0xa5d0ffff, REGISTRY_ARIN       }, // 165.206.0.0     - 165.208.255.255
	{ 0xa5d10000, 0xa5d1ffff, REGISTRY_APNIC      }, // 165.209.0.0     - 165.209.255.255
	{ 0xa5d20000, 0xa5d3ffff, REGISTRY_AFRINIC    }, // 165.210.0.0     - 165.211.255.255
	{ 0xa5d40000, 0xa5d4ffff, REGISTRY_ARIN       }, // 165.212.0.0     - 165.212.255.255
	{ 0xa5d50000, 0xa5d5ffff, REGISTRY_APNIC      }, // 165.213.0.0     - 165.213.255.255
	{ 0xa5d60000, 0xa5d9ffff, REGISTRY_ARIN       }, // 165.214.0.0     - 165.217.255.255
	{ 0xa5da0000, 0xa5daffff, REGISTRY_RIPENCC    }, // 165.218.0.0     - 165.218.255.255
	{ 0xa5db0000, 0xa5dbffff, REGISTRY_ARIN       }, // 165.219.0.0     - 165.219.255.255
	{ 0xa5dc0000, 0xa5dcffff, REGISTRY_APNIC      }, // 165.220.0.0     - 165.220.255.255
	{ 0xa5dd0000, 0xa5ddffff, REGISTRY_ARIN       }, // 165.221.0.0     - 165.221.255.255
	{ 0xa5de0000, 0xa5deffff, REGISTRY_RIPENCC    }, // 165.222.0.0     - 165.222.255.255
	{ 0xa5df0000, 0xa5e3ffff, REGISTRY_ARIN       }, // 165.223.0.0     - 165.227.255.255
	{ 0xa5e40000, 0xa5e5ffff, REGISTRY_APNIC      }, // 165.228.0.0     - 165.229.255.255
	{ 0xa5e60000, 0xa5e6ffff, REGISTRY_ARIN       }, // 165.230.0.0     - 165.230.255.255
	{ 0xa5e70000, 0xa5e7ffff, REGISTRY_AFRINIC    }, // 165.231.0.0     - 165.231.255.255
	{ 0xa5e80000, 0xa5e8ffff, REGISTRY_ARIN       }, // 165.232.0.0     - 165.232.255.255
	{ 0xa5e90000, 0xa5e9ffff, REGISTRY_AFRINIC    }, // 165.233.0.0     - 165.233.255.255
	{ 0xa5ea0000, 0xa5efffff, REGISTRY_ARIN       }, // 165.234.0.0     - 165.239.255.255
	{ 0xa5f00000, 0xa5f4ffff, REGISTRY_APNIC      }, // 165.240.0.0     - 165.244.255.255
	{ 0xa5f50000, 0xa5f5ffff, REGISTRY_ARIN       }, // 165.245.0.0     - 165.245.255.255
	{ 0xa5f60000, 0xa5f6ffff, REGISTRY_APNIC      }, // 165.246.0.0     - 165.246.255.255
	{ 0xa5f70000, 0xa5feffff, REGISTRY_ARIN       }, // 165.247.0.0     - 165.254.255.255
	{ 0xa5ff0000, 0xa5ffffff, REGISTRY_AFRINIC    }, // 165.255.0.0     - 165.255.255.255
	{ 0xa6000000, 0xa607ffff, REGISTRY_ARIN       }, // 166.0.0.0       - 166.7.255.255
	{ 0xa6080000, 0xa60fffff, REGISTRY_RIPENCC    }, // 166.8.0.0       - 166.15.255.255
	{ 0xa6100000, 0xa6317fff, REGISTRY_ARIN       }, // 166.16.0.0      - 166.49.127.255
	{ 0xa6318000, 0xa631ffff, REGISTRY_RIPENCC    }, // 166.49.128.0    - 166.49.255.255
	{ 0xa6320000, 0xa63fffff, REGISTRY_ARIN       }, // 166.50.0.0      - 166.63.255.255
	{ 0xa6400000, 0xa641ffff, REGISTRY_APNIC      }, // 166.64.0.0      - 166.65.255.255
	{ 0xa6420000, 0xa64affff, REGISTRY_ARIN       }, // 166.66.0.0      - 166.74.255.255
	{ 0xa64b0000, 0xa64bffff, REGISTRY_LACNIC     }, // 166.75.0.0      - 166.75.255.255
	{ 0xa64c0000, 0xa64effff, REGISTRY_ARIN       }, // 166.76.0.0      - 166.78.255.255
	{ 0xa64f0000, 0xa64fffff, REGISTRY_APNIC      }, // 166.79.0.0      - 166.79.255.255
	{ 0xa6500000, 0xa650ffff, REGISTRY_ARIN       }, // 166.80.0.0      - 166.80.255.255
	{ 0xa6510000, 0xa651ffff, REGISTRY_APNIC      }, // 166.81.0.0      - 166.81.255.255
	{ 0xa6520000, 0xa652ffff, REGISTRY_ARIN       }, // 166.82.0.0      - 166.82.255.255
	{ 0xa6530000, 0xa653ffff, REGISTRY_APNIC      }, // 166.83.0.0      - 166.83.255.255
	{ 0xa6540000, 0xa654ffff, REGISTRY_ARIN       }, // 166.84.0.0      - 166.84.255.255
	{ 0xa6550000, 0xa655ffff, REGISTRY_AFRINIC    }, // 166.85.0.0      - 166.85.255.255
	{ 0xa6560000, 0xa656ffff, REGISTRY_ARIN       }, // 166.86.0.0      - 166.86.255.255
	{ 0xa6570000, 0xa657ffff, REGISTRY_RIPENCC    }, // 166.87.0.0      - 166.87.255.255
	{ 0xa6580000, 0xa663ffff, REGISTRY_ARIN       }, // 166.88.0.0      - 166.99.255.255
	{ 0xa6640000, 0xa664ffff, REGISTRY_APNIC      }, // 166.100.0.0     - 166.100.255.255
	{ 0xa6650000, 0xa666ffff, REGISTRY_ARIN       }, // 166.101.0.0     - 166.102.255.255
	{ 0xa6670000, 0xa668ffff, REGISTRY_APNIC      }, // 166.103.0.0     - 166.104.255.255
	{ 0xa6690000, 0xa669ffff, REGISTRY_ARIN       }, // 166.105.0.0     - 166.105.255.255
	{ 0xa66b0000, 0xa66dffff, REGISTRY_ARIN       }, // 166.107.0.0     - 166.109.255.255
	{ 0xa66e0000, 0xa66effff, REGISTRY_LACNIC     }, // 166.110.0.0     - 166.110.255.255
	{ 0xa66f0000, 0xa66fffff, REGISTRY_APNIC      }, // 166.111.0.0     - 166.111.255.255
	{ 0xa6700000, 0xa671ffff, REGISTRY_ARIN       }, // 166.112.0.0     - 166.113.255.255
	{ 0xa6720000, 0xa672ffff, REGISTRY_LACNIC     }, // 166.114.0.0     - 166.114.255.255
	{ 0xa6730000, 0xa675ffff, REGISTRY_ARIN       }, // 166.115.0.0     - 166.117.255.255
	{ 0xa6760000, 0xa679ffff, REGISTRY_APNIC      }, // 166.118.0.0     - 166.121.255.255
	{ 0xa67a0000, 0xa67cffff, REGISTRY_ARIN       }, // 166.122.0.0     - 166.124.255.255
	{ 0xa67d0000, 0xa67dffff, REGISTRY_APNIC      }, // 166.125.0.0     - 166.125.255.255
	{ 0xa67e0000, 0xa6ffffff, REGISTRY_ARIN       }, // 166.126.0.0     - 166.255.255.255
	{ 0xa7000000, 0xa700ffff, REGISTRY_LACNIC     }, // 167.0.0.0       - 167.0.255.255
	{ 0xa7010000, 0xa71bffff, REGISTRY_ARIN       }, // 167.1.0.0       - 167.27.255.255
	{ 0xa71c0000, 0xa71cffff, REGISTRY_LACNIC     }, // 167.28.0.0      - 167.28.255.255
	{ 0xa71d0000, 0xa71dffff, REGISTRY_ARIN       }, // 167.29.0.0      - 167.29.255.255
	{ 0xa71e0000, 0xa71effff, REGISTRY_APNIC      }, // 167.30.0.0      - 167.30.255.255
	{ 0xa71f0000, 0xa737ffff, REGISTRY_ARIN       }, // 167.31.0.0      - 167.55.255.255
	{ 0xa7380000, 0xa73fffff, REGISTRY_LACNIC     }, // 167.56.0.0      - 167.63.255.255
	{ 0xa7400000, 0xa750ffff, REGISTRY_ARIN       }, // 167.64.0.0      - 167.80.255.255
	{ 0xa7510000, 0xa751ffff, REGISTRY_RIPENCC    }, // 167.81.0.0      - 167.81.255.255
	{ 0xa7520000, 0xa75641ff, REGISTRY_ARIN       }, // 167.82.0.0      - 167.86.65.255
	{ 0xa7564200, 0xa757ffff, REGISTRY_RIPENCC    }, // 167.86.66.0     - 167.87.255.255
	{ 0xa7580000, 0xa761ffff, REGISTRY_ARIN       }, // 167.88.0.0      - 167.97.255.255
	{ 0xa7620000, 0xa762ffff, REGISTRY_RIPENCC    }, // 167.98.0.0      - 167.98.255.255
	{ 0xa7630000, 0xa7647fff, REGISTRY_ARIN       }, // 167.99.0.0      - 167.100.127.255
	{ 0xa7648000, 0xa764ffff, REGISTRY_RIPENCC    }, // 167.100.128.0   - 167.100.255.255
	{ 0xa7650000, 0xa766ffff, REGISTRY_ARIN       }, // 167.101.0.0     - 167.102.255.255
	{ 0xa7670000, 0xa767ffff, REGISTRY_APNIC      }, // 167.103.0.0     - 167.103.255.255
	{ 0xa7680000, 0xa76bffff, REGISTRY_ARIN       }, // 167.104.0.0     - 167.107.255.255
	{ 0xa76c0000, 0xa76cffff, REGISTRY_LACNIC     }, // 167.108.0.0     - 167.108.255.255
	{ 0xa76d0000, 0xa76effff, REGISTRY_ARIN       }, // 167.109.0.0     - 167.110.255.255
	{ 0xa76f0000, 0xa76fffff, REGISTRY_RIPENCC    }, // 167.111.0.0     - 167.111.255.255
	{ 0xa7700000, 0xa773ffff, REGISTRY_ARIN       }, // 167.112.0.0     - 167.115.255.255
	{ 0xa7740000, 0xa774ffff, REGISTRY_LACNIC     }, // 167.116.0.0     - 167.116.255.255
	{ 0xa7750000, 0xa77affff, REGISTRY_ARIN       }, // 167.117.0.0     - 167.122.255.255
	{ 0xa77b0000, 0xa77bffff, REGISTRY_APNIC      }, // 167.123.0.0     - 167.123.255.255
	{ 0xa77c0000, 0xa781ffff, REGISTRY_ARIN       }, // 167.124.0.0     - 167.129.255.255
	{ 0xa7820000, 0xa782ffff, REGISTRY_APNIC      }, // 167.130.0.0     - 167.130.255.255
	{ 0xa7830000, 0xa785ffff, REGISTRY_ARIN       }, // 167.131.0.0     - 167.133.255.255
	{ 0xa7860000, 0xa786ffff, REGISTRY_LACNIC     }, // 167.134.0.0     - 167.134.255.255
	{ 0xa7870000, 0xa78affff, REGISTRY_ARIN       }, // 167.135.0.0     - 167.138.255.255
	{ 0xa78b0000, 0xa78bffff, REGISTRY_APNIC      }, // 167.139.0.0     - 167.139.255.255
	{ 0xa78c0000, 0xa79cffff, REGISTRY_ARIN       }, // 167.140.0.0     - 167.156.255.255
	{ 0xa79d0000, 0xa79dffff, REGISTRY_LACNIC     }, // 167.157.0.0     - 167.157.255.255
	{ 0xa79e0000, 0xa79fffff, REGISTRY_ARIN       }, // 167.158.0.0     - 167.159.255.255
	{ 0xa7a00000, 0xa7a01fff, REGISTRY_RIPENCC    }, // 167.160.0.0     - 167.160.31.255
	{ 0xa7a02000, 0xa7a1ffff, REGISTRY_ARIN       }, // 167.160.32.0    - 167.161.255.255
	{ 0xa7a20000, 0xa7a2ffff, REGISTRY_APNIC      }, // 167.162.0.0     - 167.162.255.255
	{ 0xa7a30000, 0xa7a7ffff, REGISTRY_ARIN       }, // 167.163.0.0     - 167.167.255.255
	{ 0xa7a80000, 0xa7a8ffff, REGISTRY_RIPENCC    }, // 167.168.0.0     - 167.168.255.255
	{ 0xa7a90000, 0xa7a9ffff, REGISTRY_APNIC      }, // 167.169.0.0     - 167.169.255.255
	{ 0xa7aa0000, 0xa7abffff, REGISTRY_ARIN       }, // 167.170.0.0     - 167.171.255.255
	{ 0xa7ac0000, 0xa7acffff, REGISTRY_RIPENCC    }, // 167.172.0.0     - 167.172.255.255
	{ 0xa7ad0000, 0xa7aeffff, REGISTRY_ARIN       }, // 167.173.0.0     - 167.174.255.255
	{ 0xa7af0000, 0xa7afffff, REGISTRY_APNIC      }, // 167.175.0.0     - 167.175.255.255
	{ 0xa7b00000, 0xa7b2ffff, REGISTRY_ARIN       }, // 167.176.0.0     - 167.178.255.255
	{ 0xa7b30000, 0xa7b3ffff, REGISTRY_APNIC      }, // 167.179.0.0     - 167.179.255.255
	{ 0xa7b40000, 0xa7bcffff, REGISTRY_ARIN       }, // 167.180.0.0     - 167.188.255.255
	{ 0xa7bd0000, 0xa7bdffff, REGISTRY_APNIC      }, // 167.189.0.0     - 167.189.255.255
	{ 0xa7be0000, 0xa7caffff, REGISTRY_ARIN       }, // 167.190.0.0     - 167.202.255.255
	{ 0xa7cb0000, 0xa7cbffff, REGISTRY_RIPENCC    }, // 167.203.0.0     - 167.203.255.255
	{ 0xa7cc0000, 0xa7ccffff, REGISTRY_ARIN       }, // 167.204.0.0     - 167.204.255.255
	{ 0xa7cd0000, 0xa7cdffff, REGISTRY_APNIC      }, // 167.205.0.0     - 167.205.255.255
	{ 0xa7ce0000, 0xa7db2fff, REGISTRY_ARIN       }, // 167.206.0.0     - 167.219.47.255
	{ 0xa7db3000, 0xa7db3fff, REGISTRY_APNIC      }, // 167.219.48.0    - 167.219.63.255
	{ 0xa7db4000, 0xa7dcdfff, REGISTRY_ARIN       }, // 167.219.64.0    - 167.220.223.255
	{ 0xa7dce000, 0xa7dcffff, REGISTRY_APNIC      }, // 167.220.224.0   - 167.220.255.255
	{ 0xa7dd0000, 0xa7e8ffff, REGISTRY_ARIN       }, // 167.221.0.0     - 167.232.255.255
	{ 0xa7e90000, 0xa7e9ffff, REGISTRY_RIPENCC    }, // 167.233.0.0     - 167.233.255.255
	{ 0xa7ea0000, 0xa7f8ffff, REGISTRY_ARIN       }, // 167.234.0.0     - 167.248.255.255
	{ 0xa7f90000, 0xa7f91bff, REGISTRY_LACNIC     }, // 167.249.0.0     - 167.249.27.255
	{ 0xa7f92000, 0xa7f95fff, REGISTRY_LACNIC     }, // 167.249.32.0    - 167.249.95.255
	{ 0xa7f96400, 0xa7faffff, REGISTRY_LACNIC     }, // 167.249.100.0   - 167.250.255.255
	{ 0xa7fb0000, 0xa7fbffff, REGISTRY_ARIN       }, // 167.251.0.0     - 167.251.255.255
	{ 0xa7fc0000, 0xa7fcffff, REGISTRY_LACNIC     }, // 167.252.0.0     - 167.252.255.255
	{ 0xa7fd0000, 0xa7ffffff, REGISTRY_ARIN       }, // 167.253.0.0     - 167.255.255.255
	{ 0xa8000000, 0xa800ffff, REGISTRY_LACNIC     }, // 168.0.0.0       - 168.0.255.255
	{ 0xa8010000, 0xa801ffff, REGISTRY_RIPENCC    }, // 168.1.0.0       - 168.1.255.255
	{ 0xa8020000, 0xa845ffff, REGISTRY_ARIN       }, // 168.2.0.0       - 168.69.255.255
	{ 0xa8460000, 0xa846ffff, REGISTRY_APNIC      }, // 168.70.0.0      - 168.70.255.255
	{ 0xa8470000, 0xa84bffff, REGISTRY_ARIN       }, // 168.71.0.0      - 168.75.255.255
	{ 0xa84c0000, 0xa84cffff, REGISTRY_AFRINIC    }, // 168.76.0.0      - 168.76.255.255
	{ 0xa84d0000, 0xa84dffff, REGISTRY_LACNIC     }, // 168.77.0.0      - 168.77.255.255
	{ 0xa84e0000, 0xa84effff, REGISTRY_APNIC      }, // 168.78.0.0      - 168.78.255.255
	{ 0xa8500000, 0xa851ffff, REGISTRY_AFRINIC    }, // 168.80.0.0      - 168.81.255.255
	{ 0xa8520000, 0xa852ffff, REGISTRY_ARIN       }, // 168.82.0.0      - 168.82.255.255
	{ 0xa8530000, 0xa853ffff, REGISTRY_LACNIC     }, // 168.83.0.0      - 168.83.255.255
	{ 0xa8540000, 0xa858ffff, REGISTRY_ARIN       }, // 168.84.0.0      - 168.88.255.255
	{ 0xa8590000, 0xa859ffff, REGISTRY_AFRINIC    }, // 168.89.0.0      - 168.89.255.255
	{ 0xa85a0000, 0xa85affff, REGISTRY_LACNIC     }, // 168.90.0.0      - 168.90.255.255
	{ 0xa85b0000, 0xa85effff, REGISTRY_ARIN       }, // 168.91.0.0      - 168.94.255.255
	{ 0xa85f0000, 0xa85fffff, REGISTRY_APNIC      }, // 168.95.0.0      - 168.95.255.255
	{ 0xa8600000, 0xa860ffff, REGISTRY_LACNIC     }, // 168.96.0.0      - 168.96.255.255
	{ 0xa8610000, 0xa864ffff, REGISTRY_ARIN       }, // 168.97.0.0      - 168.100.255.255
	{ 0xa8650000, 0xa865ffff, REGISTRY_LACNIC     }, // 168.101.0.0     - 168.101.255.255
	{ 0xa8660000, 0xa869ffff, REGISTRY_ARIN       }, // 168.102.0.0     - 168.105.255.255
	{ 0xa86a0000, 0xa86affff, REGISTRY_APNIC      }, // 168.106.0.0     - 168.106.255.255
	{ 0xa86b0000, 0xa872ffff, REGISTRY_ARIN       }, // 168.107.0.0     - 168.114.255.255
	{ 0xa8730000, 0xa873ffff, REGISTRY_APNIC      }, // 168.115.0.0     - 168.115.255.255
	{ 0xa8740000, 0xa877ffff, REGISTRY_ARIN       }, // 168.116.0.0     - 168.119.255.255
	{ 0xa8780000, 0xa878ffff, REGISTRY_APNIC      }, // 168.120.0.0     - 168.120.255.255
	{ 0xa8790000, 0xa879ffff, REGISTRY_LACNIC     }, // 168.121.0.0     - 168.121.255.255
	{ 0xa87a0000, 0xa87dffff, REGISTRY_ARIN       }, // 168.122.0.0     - 168.125.255.255
	{ 0xa87e0000, 0xa87effff, REGISTRY_APNIC      }, // 168.126.0.0     - 168.126.255.255
	{ 0xa87f0000, 0xa87fffff, REGISTRY_ARIN       }, // 168.127.0.0     - 168.127.255.255
	{ 0xa8800000, 0xa880ffff, REGISTRY_AFRINIC    }, // 168.128.0.0     - 168.128.255.255
	{ 0xa8810000, 0xa881ffff, REGISTRY_ARIN       }, // 168.129.0.0     - 168.129.255.255
	{ 0xa8820000, 0xa884ffff, REGISTRY_APNIC      }, // 168.130.0.0     - 168.132.255.255
	{ 0xa8850000, 0xa885ffff, REGISTRY_ARIN       }, // 168.133.0.0     - 168.133.255.255
	{ 0xa8860000, 0xa886ffff, REGISTRY_APNIC      }, // 168.134.0.0     - 168.134.255.255
	{ 0xa8870000, 0xa88affff, REGISTRY_ARIN       }, // 168.135.0.0     - 168.138.255.255
	{ 0xa88b0000, 0xa88bffff, REGISTRY_RIPENCC    }, // 168.139.0.0     - 168.139.255.255
	{ 0xa88c0000, 0xa88cffff, REGISTRY_APNIC      }, // 168.140.0.0     - 168.140.255.255
	{ 0xa88d0000, 0xa88dffff, REGISTRY_ARIN       }, // 168.141.0.0     - 168.141.255.255
	{ 0xa88e0000, 0xa88effff, REGISTRY_AFRINIC    }, // 168.142.0.0     - 168.142.255.255
	{ 0xa88f0000, 0xa894ffff, REGISTRY_ARIN       }, // 168.143.0.0     - 168.148.255.255
	{ 0xa8950000, 0xa8957fff, REGISTRY_RIPENCC    }, // 168.149.0.0     - 168.149.127.255
	{ 0xa8958000, 0xa895f7ff, REGISTRY_ARIN       }, // 168.149.128.0   - 168.149.247.255
	{ 0xa895f800, 0xa895f9ff, REGISTRY_RIPENCC    }, // 168.149.248.0   - 168.149.249.255
	{ 0xa895fa00, 0xa897ffff, REGISTRY_ARIN       }, // 168.149.250.0   - 168.151.255.255
	{ 0xa8980000, 0xa89affff, REGISTRY_APNIC      }, // 168.152.0.0     - 168.154.255.255
	{ 0xa89b0000, 0xa89bffff, REGISTRY_AFRINIC    }, // 168.155.0.0     - 168.155.255.255
	{ 0xa89c0000, 0xa89fffff, REGISTRY_ARIN       }, // 168.156.0.0     - 168.159.255.255
	{ 0xa8a00000, 0xa8a0ffff, REGISTRY_APNIC      }, // 168.160.0.0     - 168.160.255.255
	{ 0xa8a10000, 0xa8a3ffff, REGISTRY_ARIN       }, // 168.161.0.0     - 168.163.255.255
	{ 0xa8a40000, 0xa8a4ffff, REGISTRY_AFRINIC    }, // 168.164.0.0     - 168.164.255.255
	{ 0xa8a50000, 0xa8a5ffff, REGISTRY_LACNIC     }, // 168.165.0.0     - 168.165.255.255
	{ 0xa8a60000, 0xa8a6ffff, REGISTRY_ARIN       }, // 168.166.0.0     - 168.166.255.255
	{ 0xa8a70000, 0xa8a7ffff, REGISTRY_AFRINIC    }, // 168.167.0.0     - 168.167.255.255
	{ 0xa8a80000, 0xa8abffff, REGISTRY_ARIN       }, // 168.168.0.0     - 168.171.255.255
	{ 0xa8ac0000, 0xa8acffff, REGISTRY_AFRINIC    }, // 168.172.0.0     - 168.172.255.255
	{ 0xa8ad0000, 0xa8afffff, REGISTRY_ARIN       }, // 168.173.0.0     - 168.175.255.255
	{ 0xa8b00000, 0xa8b0ffff, REGISTRY_LACNIC     }, // 168.176.0.0     - 168.176.255.255
	{ 0xa8b10000, 0xa8b4ffff, REGISTRY_ARIN       }, // 168.177.0.0     - 168.180.255.255
	{ 0xa8b50000, 0xa8b563ff, REGISTRY_LACNIC     }, // 168.181.0.0     - 168.181.99.255
	{ 0xa8b56800, 0xa8b5ffff, REGISTRY_LACNIC     }, // 168.181.104.0   - 168.181.255.255
	{ 0xa8b60000, 0xa8b9ffff, REGISTRY_ARIN       }, // 168.182.0.0     - 168.185.255.255
	{ 0xa8ba0000, 0xa8baffff, REGISTRY_APNIC      }, // 168.186.0.0     - 168.186.255.255
	{ 0xa8bb0000, 0xa8bbffff, REGISTRY_RIPENCC    }, // 168.187.0.0     - 168.187.255.255
	{ 0xa8bc0000, 0xa8bcffff, REGISTRY_APNIC      }, // 168.188.0.0     - 168.188.255.255
	{ 0xa8bd0000, 0xa8c1ffff, REGISTRY_ARIN       }, // 168.189.0.0     - 168.193.255.255
	{ 0xa8c20000, 0xa8c33bff, REGISTRY_LACNIC     }, // 168.194.0.0     - 168.195.59.255
	{ 0xa8c34000, 0xa8c4c3ff, REGISTRY_LACNIC     }, // 168.195.64.0    - 168.196.195.255
	{ 0xa8c4c800, 0xa8c4e3ff, REGISTRY_LACNIC     }, // 168.196.200.0   - 168.196.227.255
	{ 0xa8c4e800, 0xa8c5ffff, REGISTRY_LACNIC     }, // 168.196.232.0   - 168.197.255.255
	{ 0xa8c60000, 0xa8c6ffff, REGISTRY_APNIC      }, // 168.198.0.0     - 168.198.255.255
	{ 0xa8c70000, 0xa8ccffff, REGISTRY_ARIN       }, // 168.199.0.0     - 168.204.255.255
	{ 0xa8cd0000, 0xa8cdffff, REGISTRY_LACNIC     }, // 168.205.0.0     - 168.205.255.255
	{ 0xa8ce0000, 0xa8ceffff, REGISTRY_AFRINIC    }, // 168.206.0.0     - 168.206.255.255
	{ 0xa8cf0000, 0xa8d0ffff, REGISTRY_ARIN       }, // 168.207.0.0     - 168.208.255.255
	{ 0xa8d10000, 0xa8d3ffff, REGISTRY_AFRINIC    }, // 168.209.0.0     - 168.211.255.255
	{ 0xa8d40000, 0xa8d8ffff, REGISTRY_ARIN       }, // 168.212.0.0     - 168.216.255.255
	{ 0xa8d90000, 0xa8d9ffff, REGISTRY_APNIC      }, // 168.217.0.0     - 168.217.255.255
	{ 0xa8da0000, 0xa8daffff, REGISTRY_ARIN       }, // 168.218.0.0     - 168.218.255.255
	{ 0xa8db0000, 0xa8dbffff, REGISTRY_APNIC      }, // 168.219.0.0     - 168.219.255.255
	{ 0xa8dc0000, 0xa8e1ffff, REGISTRY_ARIN       }, // 168.220.0.0     - 168.225.255.255
	{ 0xa8e20000, 0xa8e41fff, REGISTRY_LACNIC     }, // 168.226.0.0     - 168.228.31.255
	{ 0xa8e42400, 0xa8e4ffff, REGISTRY_LACNIC     }, // 168.228.36.0    - 168.228.255.255
	{ 0xa8e50000, 0xa8e6ffff, REGISTRY_ARIN       }, // 168.229.0.0     - 168.230.255.255
	{ 0xa8e70000, 0xa8e8ffff, REGISTRY_LACNIC     }, // 168.231.0.0     - 168.232.255.255
	{ 0xa8e90000, 0xa8e9ffff, REGISTRY_ARIN       }, // 168.233.0.0     - 168.233.255.255
	{ 0xa8ea0000, 0xa8eaffff, REGISTRY_LACNIC     }, // 168.234.0.0     - 168.234.255.255
	{ 0xa8eb0000, 0xa8f2ffff, REGISTRY_ARIN       }, // 168.235.0.0     - 168.242.255.255
	{ 0xa8f30000, 0xa8f3ffff, REGISTRY_LACNIC     }, // 168.243.0.0     - 168.243.255.255
	{ 0xa8f40000, 0xa8f5bbff, REGISTRY_ARIN       }, // 168.244.0.0     - 168.245.187.255
	{ 0xa8f5bc00, 0xa8f5bfff, REGISTRY_APNIC      }, // 168.245.188.0   - 168.245.191.255
	{ 0xa8f5c000, 0xa8f5c3ff, REGISTRY_ARIN       }, // 168.245.192.0   - 168.245.195.255
	{ 0xa8f5c400, 0xa8f5c5ff, REGISTRY_RIPENCC    }, // 168.245.196.0   - 168.245.197.255
	{ 0xa8f5c600, 0xa8f7ffff, REGISTRY_ARIN       }, // 168.245.198.0   - 168.247.255.255
	{ 0xa8f80000, 0xa8f9ffff, REGISTRY_APNIC      }, // 168.248.0.0     - 168.249.255.255
	{ 0xa8fa0000, 0xa8fbffff, REGISTRY_ARIN       }, // 168.250.0.0     - 168.251.255.255
	{ 0xa8fc0000, 0xa8fcffff, REGISTRY_APNIC      }, // 168.252.0.0     - 168.252.255.255
	{ 0xa8fd0000, 0xa8fdffff, REGISTRY_AFRINIC    }, // 168.253.0.0     - 168.253.255.255
	{ 0xa8fe0000, 0xa8feffff, REGISTRY_ARIN       }, // 168.254.0.0     - 168.254.255.255
	{ 0xa8ff0000, 0xa8ffffff, REGISTRY_LACNIC     }, // 168.255.0.0     - 168.255.255.255
	{ 0xa9000000, 0xa901ffff, REGISTRY_AFRINIC    }, // 169.0.0.0       - 169.1.255.255
	{ 0xa9020000, 0xa91fffff, REGISTRY_ARIN       }, // 169.2.0.0       - 169.31.255.255
	{ 0xa9200000, 0xa93fffff, REGISTRY_RIPENCC    }, // 169.32.0.0      - 169.63.255.255
	{ 0xa9400000, 0xa980ffff, REGISTRY_ARIN       }, // 169.64.0.0      - 169.128.255.255
	{ 0xa9810000, 0xa981ffff, REGISTRY_AFRINIC    }, // 169.129.0.0     - 169.129.255.255
	{ 0xa9820000, 0xa98bffff, REGISTRY_ARIN       }, // 169.130.0.0     - 169.139.255.255
	{ 0xa98c0000, 0xa98cffff, REGISTRY_APNIC      }, // 169.140.0.0     - 169.140.255.255
	{ 0xa98d0000, 0xa993ffff, REGISTRY_ARIN       }, // 169.141.0.0     - 169.147.255.255
	{ 0xa9940000, 0xa9947fff, REGISTRY_RIPENCC    }, // 169.148.0.0     - 169.148.127.255
	{ 0xa9948000, 0xa994ffff, REGISTRY_ARIN       }, // 169.148.128.0   - 169.148.255.255
	{ 0xa9950000, 0xa995ffff, REGISTRY_APNIC      }, // 169.149.0.0     - 169.149.255.255
	{ 0xa9960000, 0xa99dffff, REGISTRY_ARIN       }, // 169.150.0.0     - 169.157.255.255
	{ 0xa99e0000, 0xa99effff, REGISTRY_LACNIC     }, // 169.158.0.0     - 169.158.255.255
	{ 0xa99f0000, 0xa99fffff, REGISTRY_AFRINIC    }, // 169.159.0.0     - 169.159.255.255
	{ 0xa9a00000, 0xa9c8ffff, REGISTRY_ARIN       }, // 169.160.0.0     - 169.200.255.255
	{ 0xa9ca0000, 0xa9caffff, REGISTRY_AFRINIC    }, // 169.202.0.0     - 169.202.255.255
	{ 0xa9cb0000, 0xa9cfffff, REGISTRY_ARIN       }, // 169.203.0.0     - 169.207.255.255
	{ 0xa9d00000, 0xa9dfffff, REGISTRY_APNIC      }, // 169.208.0.0     - 169.223.255.255
	{ 0xa9e00000, 0xa9eeffff, REGISTRY_ARIN       }, // 169.224.0.0     - 169.238.255.255
	{ 0xa9ef0000, 0xa9ef57ff, REGISTRY_AFRINIC    }, // 169.239.0.0     - 169.239.87.255
	{ 0xa9ef5c00, 0xa9ef8fff, REGISTRY_AFRINIC    }, // 169.239.92.0    - 169.239.143.255
	{ 0xa9ef9400, 0xa9efffff, REGISTRY_AFRINIC    }, // 169.239.148.0   - 169.239.255.255
	{ 0xa9f00000, 0xa9fdffff, REGISTRY_ARIN       }, // 169.240.0.0     - 169.253.255.255
	{ 0xa9ff0000, 0xa9ff0fff, REGISTRY_AFRINIC    }, // 169.255.0.0     - 169.255.15.255
	{ 0xa9ff1400, 0xa9ff53ff, REGISTRY_AFRINIC    }, // 169.255.20.0    - 169.255.83.255
	{ 0xa9ff5800, 0xa9ff5fff, REGISTRY_AFRINIC    }, // 169.255.88.0    - 169.255.95.255
	{ 0xa9ff6400, 0xa9ff6bff, REGISTRY_AFRINIC    }, // 169.255.100.0   - 169.255.107.255
	{ 0xa9ff7000, 0xa9ff9bff, REGISTRY_AFRINIC    }, // 169.255.112.0   - 169.255.155.255
	{ 0xa9ffa000, 0xa9ffffff, REGISTRY_AFRINIC    }, // 169.255.160.0   - 169.255.255.255
	{ 0xaa000000, 0xaa00ffff, REGISTRY_LACNIC     }, // 170.0.0.0       - 170.0.255.255
	{ 0xaa010000, 0xaa0a6fff, REGISTRY_ARIN       }, // 170.1.0.0       - 170.10.111.255
	{ 0xaa0a7000, 0xaa0a7fff, REGISTRY_RIPENCC    }, // 170.10.112.0    - 170.10.127.255
	{ 0xaa0a8000, 0xaa117fff, REGISTRY_ARIN       }, // 170.10.128.0    - 170.17.127.255
	{ 0xaa118000, 0xaa11ffff, REGISTRY_RIPENCC    }, // 170.17.128.0    - 170.17.255.255
	{ 0xaa120000, 0xaa12ffff, REGISTRY_LACNIC     }, // 170.18.0.0      - 170.18.255.255
	{ 0xaa130000, 0xaa18ffff, REGISTRY_ARIN       }, // 170.19.0.0      - 170.24.255.255
	{ 0xaa190000, 0xaa19ffff, REGISTRY_LACNIC     }, // 170.25.0.0      - 170.25.255.255
	{ 0xaa1a0000, 0xaa20ffff, REGISTRY_ARIN       }, // 170.26.0.0      - 170.32.255.255
	{ 0xaa210000, 0xaa21ffff, REGISTRY_APNIC      }, // 170.33.0.0      - 170.33.255.255
	{ 0xaa220000, 0xaa25caff, REGISTRY_ARIN       }, // 170.34.0.0      - 170.37.202.255
	{ 0xaa25cb00, 0xaa25ceff, REGISTRY_RIPENCC    }, // 170.37.203.0    - 170.37.206.255
	{ 0xaa25cf00, 0xaa25ffff, REGISTRY_ARIN       }, // 170.37.207.0    - 170.37.255.255
	{ 0xaa260000, 0xaa26ffff, REGISTRY_APNIC      }, // 170.38.0.0      - 170.38.255.255
	{ 0xaa270000, 0xaa32ffff, REGISTRY_ARIN       }, // 170.39.0.0      - 170.50.255.255
	{ 0xaa330000, 0xaa33ffff, REGISTRY_LACNIC     }, // 170.51.0.0      - 170.51.255.255
	{ 0xaa340000, 0xaa3bffff, REGISTRY_ARIN       }, // 170.52.0.0      - 170.59.255.255
	{ 0xaa3c0000, 0xaa3cffff, REGISTRY_RIPENCC    }, // 170.60.0.0      - 170.60.255.255
	{ 0xaa3d0000, 0xaa41ffff, REGISTRY_ARIN       }, // 170.61.0.0      - 170.65.255.255
	{ 0xaa420000, 0xaa42ffff, REGISTRY_LACNIC     }, // 170.66.0.0      - 170.66.255.255
	{ 0xaa430000, 0xaa45ffff, REGISTRY_ARIN       }, // 170.67.0.0      - 170.69.255.255
	{ 0xaa460000, 0xaa46ffff, REGISTRY_LACNIC     }, // 170.70.0.0      - 170.70.255.255
	{ 0xaa470000, 0xaa4cafff, REGISTRY_ARIN       }, // 170.71.0.0      - 170.76.175.255
	{ 0xaa4cb000, 0xaa4cb3ff, REGISTRY_APNIC      }, // 170.76.176.0    - 170.76.179.255
	{ 0xaa4cb400, 0xaa4dffff, REGISTRY_ARIN       }, // 170.76.180.0    - 170.77.255.255
	{ 0xaa4e0000, 0xaa54ffff, REGISTRY_LACNIC     }, // 170.78.0.0      - 170.84.255.255
	{ 0xaa550000, 0xaa5effff, REGISTRY_ARIN       }, // 170.85.0.0      - 170.94.255.255
	{ 0xaa600000, 0xaa657fff, REGISTRY_ARIN       }, // 170.96.0.0      - 170.101.127.255
	{ 0xaa658000, 0xaa65ffff, REGISTRY_RIPENCC    }, // 170.101.128.0   - 170.101.255.255
	{ 0xaa660000, 0xaa667fff, REGISTRY_ARIN       }, // 170.102.0.0     - 170.102.127.255
	{ 0xaa668000, 0xaa66ffff, REGISTRY_RIPENCC    }, // 170.102.128.0   - 170.102.255.255
	{ 0xaa670000, 0xaa69ffff, REGISTRY_ARIN       }, // 170.103.0.0     - 170.105.255.255
	{ 0xaa6a0000, 0xaa6affff, REGISTRY_APNIC      }, // 170.106.0.0     - 170.106.255.255
	{ 0xaa6b0000, 0xaa84ffff, REGISTRY_ARIN       }, // 170.107.0.0     - 170.132.255.255
	{ 0xaa850000, 0xaa857fff, REGISTRY_RIPENCC    }, // 170.133.0.0     - 170.133.127.255
	{ 0xaa858000, 0xaa95ffff, REGISTRY_ARIN       }, // 170.133.128.0   - 170.149.255.255
	{ 0xaa960000, 0xaa968fff, REGISTRY_LACNIC     }, // 170.150.0.0     - 170.150.143.255
	{ 0xaa969400, 0xaa96ffff, REGISTRY_LACNIC     }, // 170.150.148.0   - 170.150.255.255
	{ 0xaa970000, 0xaa9affff, REGISTRY_ARIN       }, // 170.151.0.0     - 170.154.255.255
	{ 0xaa9b0000, 0xaa9bffff, REGISTRY_LACNIC     }, // 170.155.0.0     - 170.155.255.255
	{ 0xaa9c0000, 0xaa9cffff, REGISTRY_ARIN       }, // 170.156.0.0     - 170.156.255.255
	{ 0xaa9d0000, 0xaa9dffff, REGISTRY_APNIC      }, // 170.157.0.0     - 170.157.255.255
	{ 0xaa9e0000, 0xaaa8ffff, REGISTRY_ARIN       }, // 170.158.0.0     - 170.168.255.255
	{ 0xaaa90000, 0xaaa9ffff, REGISTRY_LACNIC     }, // 170.169.0.0     - 170.169.255.255
	{ 0xaaaa0000, 0xaab2ffff, REGISTRY_ARIN       }, // 170.170.0.0     - 170.178.255.255
	{ 0xaab30000, 0xaab3ffff, REGISTRY_APNIC      }, // 170.179.0.0     - 170.179.255.255
	{ 0xaab40000, 0xaac7f5ff, REGISTRY_ARIN       }, // 170.180.0.0     - 170.199.245.255
	{ 0xaac7f600, 0xaac7f6ff, REGISTRY_APNIC      }, // 170.199.246.0   - 170.199.246.255
	{ 0xaac7f700, 0xaad1ffff, REGISTRY_ARIN       }, // 170.199.247.0   - 170.209.255.255
	{ 0xaad20000, 0xaad2ffff, REGISTRY_LACNIC     }, // 170.210.0.0     - 170.210.255.255
	{ 0xaad30000, 0xaae6ffff, REGISTRY_ARIN       }, // 170.211.0.0     - 170.230.255.255
	{ 0xaae70000, 0xaae7ffff, REGISTRY_LACNIC     }, // 170.231.0.0     - 170.231.255.255
	{ 0xaae80000, 0xaae8ffff, REGISTRY_ARIN       }, // 170.232.0.0     - 170.232.255.255
	{ 0xaae90000, 0xaae9ffff, REGISTRY_LACNIC     }, // 170.233.0.0     - 170.233.255.255
	{ 0xaaea0000, 0xaaebffff, REGISTRY_ARIN       }, // 170.234.0.0     - 170.235.255.255
	{ 0xaaec0000, 0xaaedffff, REGISTRY_RIPENCC    }, // 170.236.0.0     - 170.237.255.255
	{ 0xaaee0000, 0xaaefffff, REGISTRY_LACNIC     }, // 170.238.0.0     - 170.239.255.255
	{ 0xaaf00000, 0xaaf3ffff, REGISTRY_ARIN       }, // 170.240.0.0     - 170.243.255.255
	{ 0xaaf40000, 0xaaf503ff, REGISTRY_LACNIC     }, // 170.244.0.0     - 170.245.3.255
	{ 0xaaf50800, 0xaaf64bff, REGISTRY_LACNIC     }, // 170.245.8.0     - 170.246.75.255
	{ 0xaaf64d00, 0xaaf7ffff, REGISTRY_LACNIC     }, // 170.246.77.0    - 170.247.255.255
	{ 0xaaf80000, 0xaaf801ff, REGISTRY_APNIC      }, // 170.248.0.0     - 170.248.1.255
	{ 0xaaf80200, 0xaaf80bff, REGISTRY_ARIN       }, // 170.248.2.0     - 170.248.11.255
	{ 0xaaf80c00, 0xaaf80dff, REGISTRY_APNIC      }, // 170.248.12.0    - 170.248.13.255
	{ 0xaaf80e00, 0xaaf829ff, REGISTRY_ARIN       }, // 170.248.14.0    - 170.248.41.255
	{ 0xaaf82a00, 0xaaf82bff, REGISTRY_APNIC      }, // 170.248.42.0    - 170.248.43.255
	{ 0xaaf82c00, 0xaaf82dff, REGISTRY_ARIN       }, // 170.248.44.0    - 170.248.45.255
	{ 0xaaf82e00, 0xaaf82fff, REGISTRY_APNIC      }, // 170.248.46.0    - 170.248.47.255
	{ 0xaaf83000, 0xaaf889ff, REGISTRY_ARIN       }, // 170.248.48.0    - 170.248.137.255
	{ 0xaaf88a00, 0xaaf88bff, REGISTRY_APNIC      }, // 170.248.138.0   - 170.248.139.255
	{ 0xaaf88c00, 0xaaf89fff, REGISTRY_ARIN       }, // 170.248.140.0   - 170.248.159.255
	{ 0xaaf8a000, 0xaaf8abff, REGISTRY_APNIC      }, // 170.248.160.0   - 170.248.171.255
	{ 0xaaf8ac00, 0xaaf8bdff, REGISTRY_ARIN       }, // 170.248.172.0   - 170.248.189.255
	{ 0xaaf8be00, 0xaaf8bfff, REGISTRY_APNIC      }, // 170.248.190.0   - 170.248.191.255
	{ 0xaaf8c000, 0xaaf93fff, REGISTRY_ARIN       }, // 170.248.192.0   - 170.249.63.255
	{ 0xaaf94000, 0xaaf947ff, REGISTRY_APNIC      }, // 170.249.64.0    - 170.249.71.255
	{ 0xaaf94800, 0xaaf95fff, REGISTRY_ARIN       }, // 170.249.72.0    - 170.249.95.255
	{ 0xaaf96000, 0xaaf97fff, REGISTRY_APNIC      }, // 170.249.96.0    - 170.249.127.255
	{ 0xaaf98000, 0xaafb09ff, REGISTRY_ARIN       }, // 170.249.128.0   - 170.251.9.255
	{ 0xaafb0a00, 0xaafb0bff, REGISTRY_APNIC      }, // 170.251.10.0    - 170.251.11.255
	{ 0xaafb0c00, 0xaafb13ff, REGISTRY_ARIN       }, // 170.251.12.0    - 170.251.19.255
	{ 0xaafb1400, 0xaafb15ff, REGISTRY_APNIC      }, // 170.251.20.0    - 170.251.21.255
	{ 0xaafb1600, 0xaafb27ff, REGISTRY_ARIN       }, // 170.251.22.0    - 170.251.39.255
	{ 0xaafb2800, 0xaafb2fff, REGISTRY_APNIC      }, // 170.251.40.0    - 170.251.47.255
	{ 0xaafb3000, 0xaafb3bff, REGISTRY_ARIN       }, // 170.251.48.0    - 170.251.59.255
	{ 0xaafb3c00, 0xaafb3dff, REGISTRY_APNIC      }, // 170.251.60.0    - 170.251.61.255
	{ 0xaafb3e00, 0xaafb59ff, REGISTRY_ARIN       }, // 170.251.62.0    - 170.251.89.255
	{ 0xaafb5a00, 0xaafb5bff, REGISTRY_APNIC      }, // 170.251.90.0    - 170.251.91.255
	{ 0xaafb5c00, 0xaafb6dff, REGISTRY_ARIN       }, // 170.251.92.0    - 170.251.109.255
	{ 0xaafb6e00, 0xaafb6fff, REGISTRY_APNIC      }, // 170.251.110.0   - 170.251.111.255
	{ 0xaafb7000, 0xaafb8dff, REGISTRY_ARIN       }, // 170.251.112.0   - 170.251.141.255
	{ 0xaafb8e00, 0xaafb8fff, REGISTRY_APNIC      }, // 170.251.142.0   - 170.251.143.255
	{ 0xaafb9000, 0xaafb94ff, REGISTRY_ARIN       }, // 170.251.144.0   - 170.251.148.255
	{ 0xaafb9500, 0xaafb97ff, REGISTRY_APNIC      }, // 170.251.149.0   - 170.251.151.255
	{ 0xaafb9800, 0xaafb99ff, REGISTRY_ARIN       }, // 170.251.152.0   - 170.251.153.255
	{ 0xaafb9a00, 0xaafb9dff, REGISTRY_APNIC      }, // 170.251.154.0   - 170.251.157.255
	{ 0xaafb9e00, 0xaafba9ff, REGISTRY_ARIN       }, // 170.251.158.0   - 170.251.169.255
	{ 0xaafbaa00, 0xaafbabff, REGISTRY_APNIC      }, // 170.251.170.0   - 170.251.171.255
	{ 0xaafbac00, 0xaafbadff, REGISTRY_ARIN       }, // 170.251.172.0   - 170.251.173.255
	{ 0xaafbae00, 0xaafbafff, REGISTRY_APNIC      }, // 170.251.174.0   - 170.251.175.255
	{ 0xaafbb000, 0xaafdffff, REGISTRY_ARIN       }, // 170.251.176.0   - 170.253.255.255
	{ 0xaafe0000, 0xaafe77ff, REGISTRY_LACNIC     }, // 170.254.0.0     - 170.254.119.255
	{ 0xaafe7c00, 0xaafeebff, REGISTRY_LACNIC     }, // 170.254.124.0   - 170.254.235.255
	{ 0xaafef000, 0xaafeffff, REGISTRY_LACNIC     }, // 170.254.240.0   - 170.254.255.255
	{ 0xaaff0000, 0xaaffffff, REGISTRY_RIPENCC    }, // 170.255.0.0     - 170.255.255.255
	{ 0xab000000, 0xab0fffff, REGISTRY_APNIC      }, // 171.0.0.0       - 171.15.255.255
	{ 0xab100000, 0xab15ffff, REGISTRY_RIPENCC    }, // 171.16.0.0      - 171.21.255.255
	{ 0xab160000, 0xab16ffff, REGISTRY_RIPENCC    }, // 171.22.0.0      - 171.22.255.255
	{ 0xab170000, 0xab197fff, REGISTRY_RIPENCC    }, // 171.23.0.0      - 171.25.127.255
	{ 0xab198000, 0xab198fff, REGISTRY_RIPENCC    }, // 171.25.128.0    - 171.25.143.255
	{ 0xab199000, 0xab19c7ff, REGISTRY_RIPENCC    }, // 171.25.144.0    - 171.25.199.255
	{ 0xab19c800, 0xab19c9ff, REGISTRY_RIPENCC    }, // 171.25.200.0    - 171.25.201.255
	{ 0xab19ca00, 0xab19d9ff, REGISTRY_RIPENCC    }, // 171.25.202.0    - 171.25.217.255
	{ 0xab19da00, 0xab19dbff, REGISTRY_RIPENCC    }, // 171.25.218.0    - 171.25.219.255
	{ 0xab19dc00, 0xab19deff, REGISTRY_RIPENCC    }, // 171.25.220.0    - 171.25.222.255
	{ 0xab19df00, 0xab19dfff, REGISTRY_RIPENCC    }, // 171.25.223.0    - 171.25.223.255
	{ 0xab19e000, 0xab19efff, REGISTRY_RIPENCC    }, // 171.25.224.0    - 171.25.239.255
	{ 0xab19f000, 0xab19f0ff, REGISTRY_RIPENCC    }, // 171.25.240.0    - 171.25.240.255
	{ 0xab19f100, 0xab213fff, REGISTRY_RIPENCC    }, // 171.25.241.0    - 171.33.63.255
	{ 0xab214000, 0xab21ffff, REGISTRY_RIPENCC    }, // 171.33.64.0     - 171.33.255.255
	{ 0xab220000, 0xab3fffff, REGISTRY_APNIC      }, // 171.34.0.0      - 171.63.255.255
	{ 0xab400000, 0xab4bffff, REGISTRY_ARIN       }, // 171.64.0.0      - 171.75.255.255
	{ 0xab4c0000, 0xab7fffff, REGISTRY_APNIC      }, // 171.76.0.0      - 171.127.255.255
	{ 0xab800000, 0xabceffff, REGISTRY_ARIN       }, // 171.128.0.0     - 171.206.255.255
	{ 0xabcf0000, 0xabffffff, REGISTRY_APNIC      }, // 171.207.0.0     - 171.255.255.255
	{ 0xac000000, 0xac0fffff, REGISTRY_ARIN       }, // 172.0.0.0       - 172.15.255.255
	{ 0xac200000, 0xac507fff, REGISTRY_ARIN       }, // 172.32.0.0      - 172.80.127.255
	{ 0xac508000, 0xac50ffff, REGISTRY_RIPENCC    }, // 172.80.128.0    - 172.80.255.255
	{ 0xac510000, 0xac51bfff, REGISTRY_ARIN       }, // 172.81.0.0      - 172.81.191.255
	{ 0xac51c000, 0xac51ffff, REGISTRY_APNIC      }, // 172.81.192.0    - 172.81.255.255
	{ 0xac520000, 0xac56cfff, REGISTRY_ARIN       }, // 172.82.0.0      - 172.86.207.255
	{ 0xac56d000, 0xac56dfff, REGISTRY_APNIC      }, // 172.86.208.0    - 172.86.223.255
	{ 0xac56e000, 0xac6757ff, REGISTRY_ARIN       }, // 172.86.224.0    - 172.103.87.255
	{ 0xac675800, 0xac675fff, REGISTRY_RIPENCC    }, // 172.103.88.0    - 172.103.95.255
	{ 0xac676000, 0xac79ffff, REGISTRY_ARIN       }, // 172.103.96.0    - 172.121.255.255
	{ 0xac7a0000, 0xac7bffff, REGISTRY_APNIC      }, // 172.122.0.0     - 172.123.255.255
	{ 0xac7c0000, 0xacbfffff, REGISTRY_ARIN       }, // 172.124.0.0     - 172.191.255.255
	{ 0xacc00000, 0xacc7ffff, REGISTRY_APNIC      }, // 172.192.0.0     - 172.199.255.255
	{ 0xacc80000, 0xacf0ffff, REGISTRY_ARIN       }, // 172.200.0.0     - 172.240.255.255
	{ 0xacf10000, 0xacf107ff, REGISTRY_RIPENCC    }, // 172.241.0.0     - 172.241.7.255
	{ 0xacf10800, 0xacf127ff, REGISTRY_ARIN       }, // 172.241.8.0     - 172.241.39.255
	{ 0xacf12800, 0xacf137ff, REGISTRY_RIPENCC    }, // 172.241.40.0    - 172.241.55.255
	{ 0xacf13800, 0xacf13fff, REGISTRY_ARIN       }, // 172.241.56.0    - 172.241.63.255
	{ 0xacf14000, 0xacf147ff, REGISTRY_RIPENCC    }, // 172.241.64.0    - 172.241.71.255
	{ 0xacf14800, 0xacf153ff, REGISTRY_ARIN       }, // 172.241.72.0    - 172.241.83.255
	{ 0xacf15400, 0xacf157ff, REGISTRY_RIPENCC    }, // 172.241.84.0    - 172.241.87.255
	{ 0xacf15800, 0xacf1f7ff, REGISTRY_ARIN       }, // 172.241.88.0    - 172.241.247.255
	{ 0xacf1f800, 0xacf1ffff, REGISTRY_APNIC      }, // 172.241.248.0   - 172.241.255.255
	{ 0xacf20000, 0xacfeffff, REGISTRY_ARIN       }, // 172.242.0.0     - 172.254.255.255
	{ 0xacff0000, 0xacff0fff, REGISTRY_RIPENCC    }, // 172.255.0.0     - 172.255.15.255
	{ 0xacff1000, 0xacff5fff, REGISTRY_ARIN       }, // 172.255.16.0    - 172.255.95.255
	{ 0xacff6000, 0xacff6fff, REGISTRY_RIPENCC    }, // 172.255.96.0    - 172.255.111.255
	{ 0xacff7000, 0xacff87ff, REGISTRY_ARIN       }, // 172.255.112.0   - 172.255.135.255
	{ 0xacff8800, 0xacff8fff, REGISTRY_RIPENCC    }, // 172.255.136.0   - 172.255.143.255
	{ 0xacff9000, 0xacffbfff, REGISTRY_ARIN       }, // 172.255.144.0   - 172.255.191.255
	{ 0xacffc000, 0xacffcfff, REGISTRY_RIPENCC    }, // 172.255.192.0   - 172.255.207.255
	{ 0xacffd000, 0xacffdfff, REGISTRY_ARIN       }, // 172.255.208.0   - 172.255.223.255
	{ 0xacffe000, 0xacffefff, REGISTRY_RIPENCC    }, // 172.255.224.0   - 172.255.239.255
	{ 0xacfff000, 0xacfff7ff, REGISTRY_ARIN       }, // 172.255.240.0   - 172.255.247.255
	{ 0xacfff800, 0xacffffff, REGISTRY_RIPENCC    }, // 172.255.248.0   - 172.255.255.255
	{ 0xad000000, 0xadd4bfff, REGISTRY_ARIN       }, // 173.0.0.0       - 173.212.191.255
	{ 0xadd4c000, 0xadd4ffff, REGISTRY_RIPENCC    }, // 173.212.192.0   - 173.212.255.255
	{ 0xadd50000, 0xadd6c7ff, REGISTRY_ARIN       }, // 173.213.0.0     - 173.214.199.255
	{ 0xadd6c800, 0xadd6cbff, REGISTRY_RIPENCC    }, // 173.214.200.0   - 173.214.203.255
	{ 0xadd6cc00, 0xadea7fff, REGISTRY_ARIN       }, // 173.214.204.0   - 173.234.127.255
	{ 0xadea8000, 0xadea87ff, REGISTRY_RIPENCC    }, // 173.234.128.0   - 173.234.135.255
	{ 0xadea8800, 0xadf48fff, REGISTRY_ARIN       }, // 173.234.136.0   - 173.244.143.255
	{ 0xadf49000, 0xadf49fff, REGISTRY_RIPENCC    }, // 173.244.144.0   - 173.244.159.255
	{ 0xadf4a000, 0xadf8dfff, REGISTRY_ARIN       }, // 173.244.160.0   - 173.248.223.255
	{ 0xadf8e000, 0xadf8ffff, REGISTRY_APNIC      }, // 173.248.224.0   - 173.248.255.255
	{ 0xadf90000, 0xadf93fff, REGISTRY_RIPENCC    }, // 173.249.0.0     - 173.249.63.255
	{ 0xadf94000, 0xadff8fff, REGISTRY_ARIN       }, // 173.249.64.0    - 173.255.143.255
	{ 0xadff9000, 0xadff97ff, REGISTRY_RIPENCC    }, // 173.255.144.0   - 173.255.151.255
	{ 0xadff9800, 0xae8a8fff, REGISTRY_ARIN       }, // 173.255.152.0   - 174.138.143.255
	{ 0xae8a9000, 0xae8a9fff, REGISTRY_APNIC      }, // 174.138.144.0   - 174.138.159.255
	{ 0xae8aa000, 0xae8bffff, REGISTRY_ARIN       }, // 174.138.160.0   - 174.139.255.255
	{ 0xae8c0000, 0xae8c3fff, REGISTRY_RIPENCC    }, // 174.140.0.0     - 174.140.63.255
	{ 0xae8c4000, 0xaeffffff, REGISTRY_ARIN       }, // 174.140.64.0    - 174.255.255.255
	{ 0xaf000000, 0xaf6e7fff, REGISTRY_APNIC      }, // 175.0.0.0       - 175.110.127.255
	{ 0xaf6e8000, 0xaf6effff, REGISTRY_RIPENCC    }, // 175.110.128.0   - 175.110.255.255
	{ 0xaf6f0000, 0xaf6f5fff, REGISTRY_APNIC      }, // 175.111.0.0     - 175.111.95.255
	{ 0xaf6f6400, 0xaf6f6bff, REGISTRY_APNIC      }, // 175.111.100.0   - 175.111.107.255
	{ 0xaf6f7000, 0xafffffff, REGISTRY_APNIC      }, // 175.111.112.0   - 175.255.255.255
	{ 0xb0000000, 0xb05fffff, REGISTRY_RIPENCC    }, // 176.0.0.0       - 176.95.255.255
	{ 0xb0600000, 0xb0602fff, REGISTRY_RIPENCC    }, // 176.96.0.0      - 176.96.47.255
	{ 0xb0603000, 0xb0603fff, REGISTRY_RIPENCC    }, // 176.96.48.0     - 176.96.63.255
	{ 0xb0604000, 0xb06057ff, REGISTRY_RIPENCC    }, // 176.96.64.0     - 176.96.87.255
	{ 0xb0605800, 0xb0608fff, REGISTRY_RIPENCC    }, // 176.96.88.0     - 176.96.143.255
	{ 0xb0609000, 0xb060afff, REGISTRY_RIPENCC    }, // 176.96.144.0    - 176.96.175.255
	{ 0xb060b000, 0xb060bfff, REGISTRY_RIPENCC    }, // 176.96.176.0    - 176.96.191.255
	{ 0xb060c000, 0xb060dfff, REGISTRY_RIPENCC    }, // 176.96.192.0    - 176.96.223.255
	{ 0xb060e000, 0xb060ffff, REGISTRY_RIPENCC    }, // 176.96.224.0    - 176.96.255.255
	{ 0xb0610000, 0xb0618fff, REGISTRY_RIPENCC    }, // 176.97.0.0      - 176.97.143.255
	{ 0xb0619000, 0xb0619bff, REGISTRY_RIPENCC    }, // 176.97.144.0    - 176.97.155.255
	{ 0xb0619c00, 0xb061e3ff, REGISTRY_RIPENCC    }, // 176.97.156.0    - 176.97.227.255
	{ 0xb061e400, 0xb061e7ff, REGISTRY_RIPENCC    }, // 176.97.228.0    - 176.97.231.255
	{ 0xb061e800, 0xb0621fff, REGISTRY_RIPENCC    }, // 176.97.232.0    - 176.98.31.255
	{ 0xb0622000, 0xb0622fff, REGISTRY_RIPENCC    }, // 176.98.32.0     - 176.98.47.255
	{ 0xb0623000, 0xb06237ff, REGISTRY_RIPENCC    }, // 176.98.48.0     - 176.98.55.255
	{ 0xb0623800, 0xb0623fff, REGISTRY_RIPENCC    }, // 176.98.56.0     - 176.98.63.255
	{ 0xb0624000, 0xb0630fff, REGISTRY_RIPENCC    }, // 176.98.64.0     - 176.99.15.255
	{ 0xb0631000, 0xb0632fff, REGISTRY_RIPENCC    }, // 176.99.16.0     - 176.99.47.255
	{ 0xb0633000, 0xb0642fff, REGISTRY_RIPENCC    }, // 176.99.48.0     - 176.100.47.255
	{ 0xb0643000, 0xb06437ff, REGISTRY_RIPENCC    }, // 176.100.48.0    - 176.100.55.255
	{ 0xb0643800, 0xb065a7ff, REGISTRY_RIPENCC    }, // 176.100.56.0    - 176.101.167.255
	{ 0xb065a800, 0xb065afff, REGISTRY_RIPENCC    }, // 176.101.168.0   - 176.101.175.255
	{ 0xb065b000, 0xb0663fff, REGISTRY_RIPENCC    }, // 176.101.176.0   - 176.102.63.255
	{ 0xb0664000, 0xb06647ff, REGISTRY_RIPENCC    }, // 176.102.64.0    - 176.102.71.255
	{ 0xb0664800, 0xb06677ff, REGISTRY_RIPENCC    }, // 176.102.72.0    - 176.102.119.255
	{ 0xb0667800, 0xb0669fff, REGISTRY_RIPENCC    }, // 176.102.120.0   - 176.102.159.255
	{ 0xb066a000, 0xb0675fff, REGISTRY_RIPENCC    }, // 176.102.160.0   - 176.103.95.255
	{ 0xb0676000, 0xb0676fff, REGISTRY_RIPENCC    }, // 176.103.96.0    - 176.103.111.255
	{ 0xb0677000, 0xb06777ff, REGISTRY_RIPENCC    }, // 176.103.112.0   - 176.103.119.255
	{ 0xb0677800, 0xb0677fff, REGISTRY_RIPENCC    }, // 176.103.120.0   - 176.103.127.255
	{ 0xb0678000, 0xb067afff, REGISTRY_RIPENCC    }, // 176.103.128.0   - 176.103.175.255
	{ 0xb067b000, 0xb067c7ff, REGISTRY_RIPENCC    }, // 176.103.176.0   - 176.103.199.255
	{ 0xb067c800, 0xb067efff, REGISTRY_RIPENCC    }, // 176.103.200.0   - 176.103.239.255
	{ 0xb067f000, 0xb067f7ff, REGISTRY_RIPENCC    }, // 176.103.240.0   - 176.103.247.255
	{ 0xb067f800, 0xb0683fff, REGISTRY_RIPENCC    }, // 176.103.248.0   - 176.104.63.255
	{ 0xb0684000, 0xb0685fff, REGISTRY_RIPENCC    }, // 176.104.64.0    - 176.104.95.255
	{ 0xb0686000, 0xb068bfff, REGISTRY_RIPENCC    }, // 176.104.96.0    - 176.104.191.255
	{ 0xb068c000, 0xb068dfff, REGISTRY_RIPENCC    }, // 176.104.192.0   - 176.104.223.255
	{ 0xb068e000, 0xb0698fff, REGISTRY_RIPENCC    }, // 176.104.224.0   - 176.105.143.255
	{ 0xb0699000, 0xb0699fff, REGISTRY_RIPENCC    }, // 176.105.144.0   - 176.105.159.255
	{ 0xb069a000, 0xb069dfff, REGISTRY_RIPENCC    }, // 176.105.160.0   - 176.105.223.255
	{ 0xb069e000, 0xb069ffff, REGISTRY_RIPENCC    }, // 176.105.224.0   - 176.105.255.255
	{ 0xb06a0000, 0xb06a2fff, REGISTRY_RIPENCC    }, // 176.106.0.0     - 176.106.47.255
	{ 0xb06a3000, 0xb06a3fff, REGISTRY_RIPENCC    }, // 176.106.48.0    - 176.106.63.255
	{ 0xb06a4000, 0xb06a5fff, REGISTRY_RIPENCC    }, // 176.106.64.0    - 176.106.95.255
	{ 0xb06a6000, 0xb06a67ff, REGISTRY_RIPENCC    }, // 176.106.96.0    - 176.106.103.255
	{ 0xb06a6800, 0xb06a6fff, REGISTRY_RIPENCC    }, // 176.106.104.0   - 176.106.111.255
	{ 0xb06a7000, 0xb06a77ff, REGISTRY_RIPENCC    }, // 176.106.112.0   - 176.106.119.255
	{ 0xb06a7800, 0xb06a87ff, REGISTRY_RIPENCC    }, // 176.106.120.0   - 176.106.135.255
	{ 0xb06a8800, 0xb06a8fff, REGISTRY_RIPENCC    }, // 176.106.136.0   - 176.106.143.255
	{ 0xb06a9000, 0xb06a9fff, REGISTRY_RIPENCC    }, // 176.106.144.0   - 176.106.159.255
	{ 0xb06aa000, 0xb06ab7ff, REGISTRY_RIPENCC    }, // 176.106.160.0   - 176.106.183.255
	{ 0xb06ab800, 0xb06b1fff, REGISTRY_RIPENCC    }, // 176.106.184.0   - 176.107.31.255
	{ 0xb06b2000, 0xb06b27ff, REGISTRY_RIPENCC    }, // 176.107.32.0    - 176.107.39.255
	{ 0xb06b2800, 0xb06b3fff, REGISTRY_RIPENCC    }, // 176.107.40.0    - 176.107.63.255
	{ 0xb06b4000, 0xb06b4fff, REGISTRY_RIPENCC    }, // 176.107.64.0    - 176.107.79.255
	{ 0xb06b5000, 0xb06b7fff, REGISTRY_RIPENCC    }, // 176.107.80.0    - 176.107.127.255
	{ 0xb06b8000, 0xb06ba7ff, REGISTRY_RIPENCC    }, // 176.107.128.0   - 176.107.167.255
	{ 0xb06ba800, 0xb06bafff, REGISTRY_RIPENCC    }, // 176.107.168.0   - 176.107.175.255
	{ 0xb06bb000, 0xb06bbfff, REGISTRY_RIPENCC    }, // 176.107.176.0   - 176.107.191.255
	{ 0xb06bc000, 0xb06cdfff, REGISTRY_RIPENCC    }, // 176.107.192.0   - 176.108.223.255
	{ 0xb06ce000, 0xb06ce7ff, REGISTRY_RIPENCC    }, // 176.108.224.0   - 176.108.231.255
	{ 0xb06ce800, 0xb06d87ff, REGISTRY_RIPENCC    }, // 176.108.232.0   - 176.109.135.255
	{ 0xb06d8800, 0xb06d8fff, REGISTRY_RIPENCC    }, // 176.109.136.0   - 176.109.143.255
	{ 0xb06d9000, 0xb06dafff, REGISTRY_RIPENCC    }, // 176.109.144.0   - 176.109.175.255
	{ 0xb06db000, 0xb06dbfff, REGISTRY_RIPENCC    }, // 176.109.176.0   - 176.109.191.255
	{ 0xb06dc000, 0xb06ddfff, REGISTRY_RIPENCC    }, // 176.109.192.0   - 176.109.223.255
	{ 0xb06de000, 0xb06dffff, REGISTRY_RIPENCC    }, // 176.109.224.0   - 176.109.255.255
	{ 0xb06e0000, 0xb06e64ff, REGISTRY_RIPENCC    }, // 176.110.0.0     - 176.110.100.255
	{ 0xb06e6600, 0xb06e68ff, REGISTRY_RIPENCC    }, // 176.110.102.0   - 176.110.104.255
	{ 0xb06e6a00, 0xb06e6bff, REGISTRY_RIPENCC    }, // 176.110.106.0   - 176.110.107.255
	{ 0xb06e6c00, 0xb06e6fff, REGISTRY_RIPENCC    }, // 176.110.108.0   - 176.110.111.255
	{ 0xb06e7000, 0xb06e73ff, REGISTRY_RIPENCC    }, // 176.110.112.0   - 176.110.115.255
	{ 0xb06e7400, 0xb06ed7ff, REGISTRY_RIPENCC    }, // 176.110.116.0   - 176.110.215.255
	{ 0xb06ed800, 0xb06edfff, REGISTRY_RIPENCC    }, // 176.110.216.0   - 176.110.223.255
	{ 0xb06ee000, 0xb06effff, REGISTRY_RIPENCC    }, // 176.110.224.0   - 176.110.255.255
	{ 0xb06f0000, 0xb06f07ff, REGISTRY_RIPENCC    }, // 176.111.0.0     - 176.111.7.255
	{ 0xb06f0800, 0xb06f37ff, REGISTRY_RIPENCC    }, // 176.111.8.0     - 176.111.55.255
	{ 0xb06f3800, 0xb06f38ff, REGISTRY_ARIN       }, // 176.111.56.0    - 176.111.56.255
	{ 0xb06f3900, 0xb06f67ff, REGISTRY_RIPENCC    }, // 176.111.57.0    - 176.111.103.255
	{ 0xb06f6800, 0xb06f6fff, REGISTRY_RIPENCC    }, // 176.111.104.0   - 176.111.111.255
	{ 0xb06f7000, 0xb06f9fff, REGISTRY_RIPENCC    }, // 176.111.112.0   - 176.111.159.255
	{ 0xb06fa000, 0xb06fafff, REGISTRY_RIPENCC    }, // 176.111.160.0   - 176.111.175.255
	{ 0xb06fb000, 0xb0704fff, REGISTRY_RIPENCC    }, // 176.111.176.0   - 176.112.79.255
	{ 0xb0705000, 0xb07057ff, REGISTRY_RIPENCC    }, // 176.112.80.0    - 176.112.87.255
	{ 0xb0705800, 0xb0707fff, REGISTRY_RIPENCC    }, // 176.112.88.0    - 176.112.127.255
	{ 0xb0708000, 0xb0709fff, REGISTRY_RIPENCC    }, // 176.112.128.0   - 176.112.159.255
	{ 0xb070a000, 0xb07127ff, REGISTRY_RIPENCC    }, // 176.112.160.0   - 176.113.39.255
	{ 0xb0712800, 0xb0712fff, REGISTRY_RIPENCC    }, // 176.113.40.0    - 176.113.47.255
	{ 0xb0713000, 0xb0713fff, REGISTRY_RIPENCC    }, // 176.113.48.0    - 176.113.63.255
	{ 0xb0714000, 0xb07167ff, REGISTRY_RIPENCC    }, // 176.113.64.0    - 176.113.103.255
	{ 0xb0716800, 0xb071afff, REGISTRY_RIPENCC    }, // 176.113.104.0   - 176.113.175.255
	{ 0xb071b000, 0xb071bfff, REGISTRY_RIPENCC    }, // 176.113.176.0   - 176.113.191.255
	{ 0xb071c000, 0xb0725fff, REGISTRY_RIPENCC    }, // 176.113.192.0   - 176.114.95.255
	{ 0xb0726000, 0xb0726fff, REGISTRY_RIPENCC    }, // 176.114.96.0    - 176.114.111.255
	{ 0xb0727000, 0xb073afff, REGISTRY_RIPENCC    }, // 176.114.112.0   - 176.115.175.255
	{ 0xb073b000, 0xb073b7ff, REGISTRY_ARIN       }, // 176.115.176.0   - 176.115.183.255
	{ 0xb073b800, 0xb073bfff, REGISTRY_RIPENCC    }, // 176.115.184.0   - 176.115.191.255
	{ 0xb073c000, 0xb073dfff, REGISTRY_RIPENCC    }, // 176.115.192.0   - 176.115.223.255
	{ 0xb073e000, 0xb073efff, REGISTRY_RIPENCC    }, // 176.115.224.0   - 176.115.239.255
	{ 0xb073f000, 0xb0741fff, REGISTRY_RIPENCC    }, // 176.115.240.0   - 176.116.31.255
	{ 0xb0742000, 0xb0742fff, REGISTRY_RIPENCC    }, // 176.116.32.0    - 176.116.47.255
	{ 0xb0743000, 0xb074dfff, REGISTRY_RIPENCC    }, // 176.116.48.0    - 176.116.223.255
	{ 0xb074e000, 0xb074efff, REGISTRY_RIPENCC    }, // 176.116.224.0   - 176.116.239.255
	{ 0xb074f000, 0xb07539ff, REGISTRY_RIPENCC    }, // 176.116.240.0   - 176.117.57.255
	{ 0xb0753a00, 0xb0753bff, REGISTRY_RIPENCC    }, // 176.117.58.0    - 176.117.59.255
	{ 0xb0753c00, 0xb075ffff, REGISTRY_RIPENCC    }, // 176.117.60.0    - 176.117.255.255
	{ 0xb0760000, 0xb0762fff, REGISTRY_RIPENCC    }, // 176.118.0.0     - 176.118.47.255
	{ 0xb0763000, 0xb07637ff, REGISTRY_RIPENCC    }, // 176.118.48.0    - 176.118.55.255
	{ 0xb0763800, 0xb0763fff, REGISTRY_RIPENCC    }, // 176.118.56.0    - 176.118.63.255
	{ 0xb0764000, 0xb0764fff, REGISTRY_RIPENCC    }, // 176.118.64.0    - 176.118.79.255
	{ 0xb0765000, 0xb0765fff, REGISTRY_RIPENCC    }, // 176.118.80.0    - 176.118.95.255
	{ 0xb0766000, 0xb0769fff, REGISTRY_RIPENCC    }, // 176.118.96.0    - 176.118.159.255
	{ 0xb076a000, 0xb076ffff, REGISTRY_RIPENCC    }, // 176.118.160.0   - 176.118.255.255
	{ 0xb0770000, 0xb0773fff, REGISTRY_RIPENCC    }, // 176.119.0.0     - 176.119.63.255
	{ 0xb0774000, 0xb0779fff, REGISTRY_RIPENCC    }, // 176.119.64.0    - 176.119.159.255
	{ 0xb077a000, 0xb077dfff, REGISTRY_RIPENCC    }, // 176.119.160.0   - 176.119.223.255
	{ 0xb077e000, 0xb077e7ff, REGISTRY_RIPENCC    }, // 176.119.224.0   - 176.119.231.255
	{ 0xb077e800, 0xb0791fff, REGISTRY_RIPENCC    }, // 176.119.232.0   - 176.121.31.255
	{ 0xb0792000, 0xb0792fff, REGISTRY_RIPENCC    }, // 176.121.32.0    - 176.121.47.255
	{ 0xb0793000, 0xb0795fff, REGISTRY_RIPENCC    }, // 176.121.48.0    - 176.121.95.255
	{ 0xb0796000, 0xb0796fff, REGISTRY_RIPENCC    }, // 176.121.96.0    - 176.121.111.255
	{ 0xb0797000, 0xb07a7fff, REGISTRY_RIPENCC    }, // 176.121.112.0   - 176.122.127.255
	{ 0xb07a8000, 0xb07abfff, REGISTRY_ARIN       }, // 176.122.128.0   - 176.122.191.255
	{ 0xb07ac000, 0xb07acfff, REGISTRY_RIPENCC    }, // 176.122.192.0   - 176.122.207.255
	{ 0xb07ad200, 0xb07aefff, REGISTRY_RIPENCC    }, // 176.122.210.0   - 176.122.239.255
	{ 0xb07af000, 0xb07af3ff, REGISTRY_RIPENCC    }, // 176.122.240.0   - 176.122.243.255
	{ 0xb07af400, 0xb07b1fff, REGISTRY_RIPENCC    }, // 176.122.244.0   - 176.123.31.255
	{ 0xb07b2000, 0xb07b2fff, REGISTRY_RIPENCC    }, // 176.123.32.0    - 176.123.47.255
	{ 0xb07b3000, 0xb07c1fff, REGISTRY_RIPENCC    }, // 176.123.48.0    - 176.124.31.255
	{ 0xb07c2000, 0xb07c3fff, REGISTRY_RIPENCC    }, // 176.124.32.0    - 176.124.63.255
	{ 0xb07c4000, 0xb07c4fff, REGISTRY_RIPENCC    }, // 176.124.64.0    - 176.124.79.255
	{ 0xb07c5000, 0xb07c5fff, REGISTRY_RIPENCC    }, // 176.124.80.0    - 176.124.95.255
	{ 0xb07c6000, 0xb07cabff, REGISTRY_RIPENCC    }, // 176.124.96.0    - 176.124.171.255
	{ 0xb07cac00, 0xb07cb7ff, REGISTRY_RIPENCC    }, // 176.124.172.0   - 176.124.183.255
	{ 0xb07cb800, 0xb07ddfff, REGISTRY_RIPENCC    }, // 176.124.184.0   - 176.125.223.255
	{ 0xb07de000, 0xb07dffff, REGISTRY_RIPENCC    }, // 176.125.224.0   - 176.125.255.255
	{ 0xb07e0000, 0xb07e37ff, REGISTRY_RIPENCC    }, // 176.126.0.0     - 176.126.55.255
	{ 0xb07e3800, 0xb07e3bff, REGISTRY_RIPENCC    }, // 176.126.56.0    - 176.126.59.255
	{ 0xb07e3c00, 0xb07e3fff, REGISTRY_RIPENCC    }, // 176.126.60.0    - 176.126.63.255
	{ 0xb07e4000, 0xb07e5fff, REGISTRY_RIPENCC    }, // 176.126.64.0    - 176.126.95.255
	{ 0xb07e6000, 0xb07ea7ff, REGISTRY_RIPENCC    }, // 176.126.96.0    - 176.126.167.255
	{ 0xb07ea800, 0xb0de2fff, REGISTRY_RIPENCC    }, // 176.126.168.0   - 176.222.47.255
	{ 0xb0de4000, 0xb0ffffff, REGISTRY_RIPENCC    }, // 176.222.64.0    - 176.255.255.255
	{ 0xb1000000, 0xb1087fff, REGISTRY_LACNIC     }, // 177.0.0.0       - 177.8.127.255
	{ 0xb1089000, 0xb10a0fff, REGISTRY_LACNIC     }, // 177.8.144.0     - 177.10.15.255
	{ 0xb10a1400, 0xb10a47ff, REGISTRY_LACNIC     }, // 177.10.20.0     - 177.10.71.255
	{ 0xb10a4c00, 0xb10a83ff, REGISTRY_LACNIC     }, // 177.10.76.0     - 177.10.131.255
	{ 0xb10a8800, 0xb10aafff, REGISTRY_LACNIC     }, // 177.10.136.0    - 177.10.175.255
	{ 0xb10ab400, 0xb10abbff, REGISTRY_LACNIC     }, // 177.10.180.0    - 177.10.187.255
	{ 0xb10ac000, 0xb10b17ff, REGISTRY_LACNIC     }, // 177.10.192.0    - 177.11.23.255
	{ 0xb10b1e00, 0xb10b67ff, REGISTRY_LACNIC     }, // 177.11.30.0     - 177.11.103.255
	{ 0xb10b6c00, 0xb10b7fff, REGISTRY_LACNIC     }, // 177.11.108.0    - 177.11.127.255
	{ 0xb10b8800, 0xb10bd7ff, REGISTRY_LACNIC     }, // 177.11.136.0    - 177.11.215.255
	{ 0xb10bdc00, 0xb10c57ff, REGISTRY_LACNIC     }, // 177.11.220.0    - 177.12.87.255
	{ 0xb10c5c00, 0xb10ccfff, REGISTRY_LACNIC     }, // 177.12.92.0     - 177.12.207.255
	{ 0xb10ce000, 0xb11717ff, REGISTRY_LACNIC     }, // 177.12.224.0    - 177.23.23.255
	{ 0xb1171c00, 0xb1172fff, REGISTRY_LACNIC     }, // 177.23.28.0     - 177.23.47.255
	{ 0xb1173800, 0xb1177fff, REGISTRY_LACNIC     }, // 177.23.56.0     - 177.23.127.255
	{ 0xb1178800, 0xb1243fff, REGISTRY_LACNIC     }, // 177.23.136.0    - 177.36.63.255
	{ 0xb1245000, 0xb1250fff, REGISTRY_LACNIC     }, // 177.36.80.0     - 177.37.15.255
	{ 0xb1253000, 0xb12707ff, REGISTRY_LACNIC     }, // 177.37.48.0     - 177.39.7.255
	{ 0xb1270c00, 0xb13423ff, REGISTRY_LACNIC     }, // 177.39.12.0     - 177.52.35.255
	{ 0xb1342800, 0xb1348bff, REGISTRY_LACNIC     }, // 177.52.40.0     - 177.52.139.255
	{ 0xb1349000, 0xb13517ff, REGISTRY_LACNIC     }, // 177.52.144.0    - 177.53.23.255
	{ 0xb1352000, 0xb13577ff, REGISTRY_LACNIC     }, // 177.53.32.0     - 177.53.119.255
	{ 0xb1357c00, 0xb13597ff, REGISTRY_LACNIC     }, // 177.53.124.0    - 177.53.151.255
	{ 0xb135a400, 0xb135b3ff, REGISTRY_LACNIC     }, // 177.53.164.0    - 177.53.179.255
	{ 0xb135b800, 0xb14206ff, REGISTRY_LACNIC     }, // 177.53.184.0    - 177.66.6.255
	{ 0xb1420800, 0xb143a7ff, REGISTRY_LACNIC     }, // 177.66.8.0      - 177.67.167.255
	{ 0xb143ac00, 0xb143f9ff, REGISTRY_LACNIC     }, // 177.67.172.0    - 177.67.249.255
	{ 0xb143fb00, 0xb146efff, REGISTRY_LACNIC     }, // 177.67.251.0    - 177.70.239.255
	{ 0xb1470000, 0xb14897ff, REGISTRY_LACNIC     }, // 177.71.0.0      - 177.72.151.255
	{ 0xb1489c00, 0xb148c7ff, REGISTRY_LACNIC     }, // 177.72.156.0    - 177.72.199.255
	{ 0xb148cc00, 0xb148d7ff, REGISTRY_LACNIC     }, // 177.72.204.0    - 177.72.215.255
	{ 0xb148dc00, 0xb14927ff, REGISTRY_LACNIC     }, // 177.72.220.0    - 177.73.39.255
	{ 0xb1492c00, 0xb1499bff, REGISTRY_LACNIC     }, // 177.73.44.0     - 177.73.155.255
	{ 0xb149a000, 0xb149d7ff, REGISTRY_LACNIC     }, // 177.73.160.0    - 177.73.215.255
	{ 0xb149e000, 0xb149fcff, REGISTRY_LACNIC     }, // 177.73.224.0    - 177.73.252.255
	{ 0xb14a0000, 0xb14a5fff, REGISTRY_LACNIC     }, // 177.74.0.0      - 177.74.95.255
	{ 0xb14a7000, 0xb14abfff, REGISTRY_LACNIC     }, // 177.74.112.0    - 177.74.191.255
	{ 0xb14ad000, 0xb154cbff, REGISTRY_LACNIC     }, // 177.74.208.0    - 177.84.203.255
	{ 0xb154d000, 0xb155b7ff, REGISTRY_LACNIC     }, // 177.84.208.0    - 177.85.183.255
	{ 0xb155bc00, 0xb155edff, REGISTRY_LACNIC     }, // 177.85.188.0    - 177.85.237.255
	{ 0xb155ef00, 0xb155efff, REGISTRY_LACNIC     }, // 177.85.239.0    - 177.85.239.255
	{ 0xb155f800, 0xb1568dff, REGISTRY_LACNIC     }, // 177.85.248.0    - 177.86.141.255
	{ 0xb1568f00, 0xb15733ff, REGISTRY_LACNIC     }, // 177.86.143.0    - 177.87.51.255
	{ 0xb1573800, 0xb15753ff, REGISTRY_LACNIC     }, // 177.87.56.0     - 177.87.83.255
	{ 0xb1575800, 0xb157f9ff, REGISTRY_LACNIC     }, // 177.87.88.0     - 177.87.249.255
	{ 0xb157fc00, 0xb15affff, REGISTRY_LACNIC     }, // 177.87.252.0    - 177.90.255.255
	{ 0xb15b0400, 0xb15b37ff, REGISTRY_LACNIC     }, // 177.91.4.0      - 177.91.55.255
	{ 0xb15b3c00, 0xb15be3ff, REGISTRY_LACNIC     }, // 177.91.60.0     - 177.91.227.255
	{ 0xb15be800, 0xb17c9bff, REGISTRY_LACNIC     }, // 177.91.232.0    - 177.124.155.255
	{ 0xb17ca000, 0xb1802fff, REGISTRY_LACNIC     }, // 177.124.160.0   - 177.128.47.255
	{ 0xb1803800, 0xb1806fff, REGISTRY_LACNIC     }, // 177.128.56.0    - 177.128.111.255
	{ 0xb1807400, 0xb180c7ff, REGISTRY_LACNIC     }, // 177.128.116.0   - 177.128.199.255
	{ 0xb180cc00, 0xb1811fff, REGISTRY_LACNIC     }, // 177.128.204.0   - 177.129.31.255
	{ 0xb1812800, 0xb18163ff, REGISTRY_LACNIC     }, // 177.129.40.0    - 177.129.99.255
	{ 0xb1816800, 0xb181efff, REGISTRY_LACNIC     }, // 177.129.104.0   - 177.129.239.255
	{ 0xb181f800, 0xb1837fff, REGISTRY_LACNIC     }, // 177.129.248.0   - 177.131.127.255
	{ 0xb1839000, 0xb18853ff, REGISTRY_LACNIC     }, // 177.131.144.0   - 177.136.83.255
	{ 0xb1885800, 0xb1985fff, REGISTRY_LACNIC     }, // 177.136.88.0    - 177.152.95.255
	{ 0xb1987000, 0xb19877ff, REGISTRY_LACNIC     }, // 177.152.112.0   - 177.152.119.255
	{ 0xb1987c00, 0xb19a5cff, REGISTRY_LACNIC     }, // 177.152.124.0   - 177.154.92.255
	{ 0xb19a5e00, 0xb1c87fff, REGISTRY_LACNIC     }, // 177.154.94.0    - 177.200.127.255
	{ 0xb1c89000, 0xb1c8dfff, REGISTRY_LACNIC     }, // 177.200.144.0   - 177.200.223.255
	{ 0xb1c8f000, 0xb1dd7fff, REGISTRY_LACNIC     }, // 177.200.240.0   - 177.221.127.255
	{ 0xb1dda000, 0xb1ddb7ff, REGISTRY_LACNIC     }, // 177.221.160.0   - 177.221.183.255
	{ 0xb1ddc000, 0xb1df7fff, REGISTRY_LACNIC     }, // 177.221.192.0   - 177.223.127.255
	{ 0xb1dfa000, 0xb1ffffff, REGISTRY_LACNIC     }, // 177.223.160.0   - 177.255.255.255
	{ 0xb2000000, 0xb235ffff, REGISTRY_RIPENCC    }, // 178.0.0.0       - 178.53.255.255
	{ 0xb2360000, 0xb236ffff, REGISTRY_RIPENCC    }, // 178.54.0.0      - 178.54.255.255
	{ 0xb2370000, 0xb29dffff, REGISTRY_RIPENCC    }, // 178.55.0.0      - 178.157.255.255
	{ 0xb29e0000, 0xb29effff, REGISTRY_RIPENCC    }, // 178.158.0.0     - 178.158.255.255
	{ 0xb29f0000, 0xb29f0fff, REGISTRY_RIPENCC    }, // 178.159.0.0     - 178.159.15.255
	{ 0xb29f1000, 0xb29f1fff, REGISTRY_RIPENCC    }, // 178.159.16.0    - 178.159.31.255
	{ 0xb29f2000, 0xb29f21ff, REGISTRY_RIPENCC    }, // 178.159.32.0    - 178.159.33.255
	{ 0xb29f2200, 0xb29f25ff, REGISTRY_RIPENCC    }, // 178.159.34.0    - 178.159.37.255
	{ 0xb29f2600, 0xb29f27ff, REGISTRY_RIPENCC    }, // 178.159.38.0    - 178.159.39.255
	{ 0xb29f2800, 0xb29f29ff, REGISTRY_RIPENCC    }, // 178.159.40.0    - 178.159.41.255
	{ 0xb29f2a00, 0xb29f2fff, REGISTRY_RIPENCC    }, // 178.159.42.0    - 178.159.47.255
	{ 0xb29f3000, 0xb29f4fff, REGISTRY_RIPENCC    }, // 178.159.48.0    - 178.159.79.255
	{ 0xb29f5000, 0xb29f6fff, REGISTRY_RIPENCC    }, // 178.159.80.0    - 178.159.111.255
	{ 0xb29f7000, 0xb29f8fff, REGISTRY_RIPENCC    }, // 178.159.112.0   - 178.159.143.255
	{ 0xb29f9000, 0xb29f9fff, REGISTRY_RIPENCC    }, // 178.159.144.0   - 178.159.159.255
	{ 0xb29fa000, 0xb29fffff, REGISTRY_RIPENCC    }, // 178.159.160.0   - 178.159.255.255
	{ 0xb2a00000, 0xb2d3ffff, REGISTRY_RIPENCC    }, // 178.160.0.0     - 178.211.255.255
	{ 0xb2d40000, 0xb2d41fff, REGISTRY_RIPENCC    }, // 178.212.0.0     - 178.212.31.255
	{ 0xb2d42000, 0xb2d427ff, REGISTRY_RIPENCC    }, // 178.212.32.0    - 178.212.39.255
	{ 0xb2d42800, 0xb2d4b7ff, REGISTRY_RIPENCC    }, // 178.212.40.0    - 178.212.183.255
	{ 0xb2d4b800, 0xb2d4bfff, REGISTRY_RIPENCC    }, // 178.212.184.0   - 178.212.191.255
	{ 0xb2d4c000, 0xb2d4c7ff, REGISTRY_RIPENCC    }, // 178.212.192.0   - 178.212.199.255
	{ 0xb2d4c800, 0xb2d4cfff, REGISTRY_RIPENCC    }, // 178.212.200.0   - 178.212.207.255
	{ 0xb2d4d000, 0xb2d50fff, REGISTRY_RIPENCC    }, // 178.212.208.0   - 178.213.15.255
	{ 0xb2d51000, 0xb2d517ff, REGISTRY_RIPENCC    }, // 178.213.16.0    - 178.213.23.255
	{ 0xb2d51800, 0xb2d5afff, REGISTRY_RIPENCC    }, // 178.213.24.0    - 178.213.175.255
	{ 0xb2d5b000, 0xb2d5b7ff, REGISTRY_RIPENCC    }, // 178.213.176.0   - 178.213.183.255
	{ 0xb2d5b800, 0xb2d67fff, REGISTRY_RIPENCC    }, // 178.213.184.0   - 178.214.127.255
	{ 0xb2d68000, 0xb2d69fff, REGISTRY_RIPENCC    }, // 178.214.128.0   - 178.214.159.255
	{ 0xb2d6a000, 0xb2d6dfff, REGISTRY_RIPENCC    }, // 178.214.160.0   - 178.214.223.255
	{ 0xb2d6e000, 0xb2d6ffff, REGISTRY_RIPENCC    }, // 178.214.224.0   - 178.214.255.255
	{ 0xb2d70000, 0xb2d7dfff, REGISTRY_RIPENCC    }, // 178.215.0.0     - 178.215.223.255
	{ 0xb2d7e000, 0xb2d7efff, REGISTRY_RIPENCC    }, // 178.215.224.0   - 178.215.239.255
	{ 0xb2d7f000, 0xb2d827ff, REGISTRY_RIPENCC    }, // 178.215.240.0   - 178.216.39.255
	{ 0xb2d82800, 0xb2d837ff, REGISTRY_RIPENCC    }, // 178.216.40.0    - 178.216.55.255
	{ 0xb2d83800, 0xb2d847ff, REGISTRY_RIPENCC    }, // 178.216.56.0    - 178.216.71.255
	{ 0xb2d84800, 0xb2d84fff, REGISTRY_RIPENCC    }, // 178.216.72.0    - 178.216.79.255
	{ 0xb2d85000, 0xb2d857ff, REGISTRY_RIPENCC    }, // 178.216.80.0    - 178.216.87.255
	{ 0xb2d85800, 0xb2d85fff, REGISTRY_RIPENCC    }, // 178.216.88.0    - 178.216.95.255
	{ 0xb2d86000, 0xb2d8efff, REGISTRY_RIPENCC    }, // 178.216.96.0    - 178.216.239.255
	{ 0xb2d8f400, 0xb2d8ffff, REGISTRY_RIPENCC    }, // 178.216.244.0   - 178.216.255.255
	{ 0xb2d90000, 0xb2d927ff, REGISTRY_RIPENCC    }, // 178.217.0.0     - 178.217.39.255
	{ 0xb2d92800, 0xb2d92fff, REGISTRY_RIPENCC    }, // 178.217.40.0    - 178.217.47.255
	{ 0xb2d93000, 0xb2d957ff, REGISTRY_RIPENCC    }, // 178.217.48.0    - 178.217.87.255
	{ 0xb2d95800, 0xb2d95fff, REGISTRY_RIPENCC    }, // 178.217.88.0    - 178.217.95.255
	{ 0xb2d96000, 0xb2d9e7ff, REGISTRY_RIPENCC    }, // 178.217.96.0    - 178.217.231.255
	{ 0xb2d9e800, 0xb2d9efff, REGISTRY_RIPENCC    }, // 178.217.232.0   - 178.217.239.255
	{ 0xb2d9f000, 0xb2da8fff, REGISTRY_RIPENCC    }, // 178.217.240.0   - 178.218.143.255
	{ 0xb2da9000, 0xb2dac7ff, REGISTRY_RIPENCC    }, // 178.218.144.0   - 178.218.199.255
	{ 0xb2dac800, 0xb2daefff, REGISTRY_RIPENCC    }, // 178.218.200.0   - 178.218.239.255
	{ 0xb2daf000, 0xb2db0fff, REGISTRY_RIPENCC    }, // 178.218.240.0   - 178.219.15.255
	{ 0xb2db1000, 0xb2dbffff, REGISTRY_RIPENCC    }, // 178.219.16.0    - 178.219.255.255
	{ 0xb2dc0000, 0xb2ee4fff, REGISTRY_RIPENCC    }, // 178.220.0.0     - 178.238.79.255
	{ 0xb2ee5000, 0xb2ee5fff, REGISTRY_ARIN       }, // 178.238.80.0    - 178.238.95.255
	{ 0xb2ee6000, 0xb2ffffff, REGISTRY_RIPENCC    }, // 178.238.96.0    - 178.255.255.255
	{ 0xb3000000, 0xb30017ff, REGISTRY_LACNIC     }, // 179.0.0.0       - 179.0.23.255
	{ 0xb3001900, 0xb3007fff, REGISTRY_LACNIC     }, // 179.0.25.0      - 179.0.127.255
	{ 0xb3008100, 0xb3009fff, REGISTRY_LACNIC     }, // 179.0.129.0     - 179.0.159.255
	{ 0xb300c000, 0xb32affff, REGISTRY_LACNIC     }, // 179.0.192.0     - 179.42.255.255
	{ 0xb32b4000, 0xb33c7fff, REGISTRY_LACNIC     }, // 179.43.64.0     - 179.60.127.255
	{ 0xb33c9000, 0xb33cdfff, REGISTRY_LACNIC     }, // 179.60.144.0    - 179.60.223.255
	{ 0xb33ce400, 0xb36d5fff, REGISTRY_LACNIC     }, // 179.60.228.0    - 179.109.95.255
	{ 0xb36d8000, 0xb37d07ff, REGISTRY_LACNIC     }, // 179.109.128.0   - 179.125.7.255
	{ 0xb37d1000, 0xb3bd4fff, REGISTRY_LACNIC     }, // 179.125.16.0    - 179.189.79.255
	{ 0xb3bd5400, 0xb3bd57ff, REGISTRY_LACNIC     }, // 179.189.84.0    - 179.189.87.255
	{ 0xb3bd5c00, 0xb3beffff, REGISTRY_LACNIC     }, // 179.189.92.0    - 179.190.255.255
	{ 0xb3bf0800, 0xb3bf23ff, REGISTRY_LACNIC     }, // 179.191.8.0     - 179.191.35.255
	{ 0xb3bf3000, 0xb3ffffff, REGISTRY_LACNIC     }, // 179.191.48.0    - 179.255.255.255
	{ 0xb4000000, 0xb45dffff, REGISTRY_APNIC      }, // 180.0.0.0       - 180.93.255.255
	{ 0xb45e2000, 0xb4837fff, REGISTRY_APNIC      }, // 180.94.32.0     - 180.131.127.255
	{ 0xb4838800, 0xb4e9ffff, REGISTRY_APNIC      }, // 180.131.136.0   - 180.233.255.255
	{ 0xb4ea0000, 0xb4eaffff, REGISTRY_RIPENCC    }, // 180.234.0.0     - 180.234.255.255
	{ 0xb4eb0000, 0xb4ffffff, REGISTRY_APNIC      }, // 180.235.0.0     - 180.255.255.255
	{ 0xb5000000, 0xb5c05fff, REGISTRY_LACNIC     }, // 181.0.0.0       - 181.192.95.255
	{ 0xb5c08000, 0xb5e0a7ff, REGISTRY_LACNIC     }, // 181.192.128.0   - 181.224.167.255
	{ 0xb5e0ac00, 0xb5e197ff, REGISTRY_LACNIC     }, // 181.224.172.0   - 181.225.151.255
	{ 0xb5e1c000, 0xb5ffffff, REGISTRY_LACNIC     }, // 181.225.192.0   - 181.255.255.255
	{ 0xb6000000, 0xb7ffffff, REGISTRY_APNIC      }, // 182.0.0.0       - 183.255.255.255
	{ 0xb8000000, 0xb815ffff, REGISTRY_ARIN       }, // 184.0.0.0       - 184.21.255.255
	{ 0xb8160000, 0xb816ffff, REGISTRY_APNIC      }, // 184.22.0.0      - 184.22.255.255
	{ 0xb8170000, 0xb851ffff, REGISTRY_ARIN       }, // 184.23.0.0      - 184.81.255.255
	{ 0xb8520000, 0xb852ffff, REGISTRY_APNIC      }, // 184.82.0.0      - 184.82.255.255
	{ 0xb8530000, 0xb8ffffff, REGISTRY_ARIN       }, // 184.83.0.0      - 184.255.255.255
	{ 0xb9010000, 0xb90186ff, REGISTRY_RIPENCC    }, // 185.1.0.0       - 185.1.134.255
	{ 0xb9020000, 0xb90863ff, REGISTRY_RIPENCC    }, // 185.2.0.0       - 185.8.99.255
	{ 0xb9086400, 0xb90867ff, REGISTRY_APNIC      }, // 185.8.100.0     - 185.8.103.255
	{ 0xb9086800, 0xb914dbff, REGISTRY_RIPENCC    }, // 185.8.104.0     - 185.20.219.255
	{ 0xb914dc00, 0xb914dfff, REGISTRY_ARIN       }, // 185.20.220.0    - 185.20.223.255
	{ 0xb914e000, 0xb91e47ff, REGISTRY_RIPENCC    }, // 185.20.224.0    - 185.30.71.255
	{ 0xb91e4800, 0xb91e4bff, REGISTRY_ARIN       }, // 185.30.72.0     - 185.30.75.255
	{ 0xb91e4c00, 0xb926d1ff, REGISTRY_RIPENCC    }, // 185.30.76.0     - 185.38.209.255
	{ 0xb926d200, 0xb926d3ff, REGISTRY_ARIN       }, // 185.38.210.0    - 185.38.211.255
	{ 0xb926d400, 0xb92a93ff, REGISTRY_RIPENCC    }, // 185.38.212.0    - 185.42.147.255
	{ 0xb92a9800, 0xb92d5bff, REGISTRY_RIPENCC    }, // 185.42.152.0    - 185.45.91.255
	{ 0xb92d6000, 0xb9311fff, REGISTRY_RIPENCC    }, // 185.45.96.0     - 185.49.31.255
	{ 0xb9312400, 0xb93737ff, REGISTRY_RIPENCC    }, // 185.49.36.0     - 185.55.55.255
	{ 0xb9373c00, 0xb93c8fff, REGISTRY_RIPENCC    }, // 185.55.60.0     - 185.60.143.255
	{ 0xb93c9400, 0xb9479bff, REGISTRY_RIPENCC    }, // 185.60.148.0    - 185.71.155.255
	{ 0xb947a000, 0xb94d27ff, REGISTRY_RIPENCC    }, // 185.71.160.0    - 185.77.39.255
	{ 0xb94d2c00, 0xb94ddfff, REGISTRY_RIPENCC    }, // 185.77.44.0     - 185.77.223.255
	{ 0xb94de400, 0xb950c7ff, REGISTRY_RIPENCC    }, // 185.77.228.0    - 185.80.199.255
	{ 0xb950cc00, 0xb95343ff, REGISTRY_RIPENCC    }, // 185.80.204.0    - 185.83.67.255
	{ 0xb9534800, 0xb95af3ff, REGISTRY_RIPENCC    }, // 185.83.72.0     - 185.90.243.255
	{ 0xb95af400, 0xb95af7ff, REGISTRY_ARIN       }, // 185.90.244.0    - 185.90.247.255
	{ 0xb95af800, 0xb96427ff, REGISTRY_RIPENCC    }, // 185.90.248.0    - 185.100.39.255
	{ 0xb9642800, 0xb9642bff, REGISTRY_APNIC      }, // 185.100.40.0    - 185.100.43.255
	{ 0xb9642c00, 0xb965d7ff, REGISTRY_RIPENCC    }, // 185.100.44.0    - 185.101.215.255
	{ 0xb965dc00, 0xb96906ff, REGISTRY_RIPENCC    }, // 185.101.220.0   - 185.105.6.255
	{ 0xb9690700, 0xb96907ff, REGISTRY_ARIN       }, // 185.105.7.0     - 185.105.7.255
	{ 0xb9690800, 0xb9694fff, REGISTRY_RIPENCC    }, // 185.105.8.0     - 185.105.79.255
	{ 0xb9695400, 0xb96aafff, REGISTRY_RIPENCC    }, // 185.105.84.0    - 185.106.175.255
	{ 0xb96ab400, 0xb970b3ff, REGISTRY_RIPENCC    }, // 185.106.180.0   - 185.112.179.255
	{ 0xb970b800, 0xb972cbff, REGISTRY_RIPENCC    }, // 185.112.184.0   - 185.114.203.255
	{ 0xb972d000, 0xb975ffff, REGISTRY_RIPENCC    }, // 185.114.208.0   - 185.117.255.255
	{ 0xb9760400, 0xb97967ff, REGISTRY_RIPENCC    }, // 185.118.4.0     - 185.121.103.255
	{ 0xb9796c00, 0xb9839fff, REGISTRY_RIPENCC    }, // 185.121.108.0   - 185.131.159.255
	{ 0xb983a400, 0xb98f57ff, REGISTRY_RIPENCC    }, // 185.131.164.0   - 185.143.87.255
	{ 0xb98f5c00, 0xb991fbff, REGISTRY_RIPENCC    }, // 185.143.92.0    - 185.145.251.255
	{ 0xb9920000, 0xb9921fff, REGISTRY_RIPENCC    }, // 185.146.0.0     - 185.146.31.255
	{ 0xb9922000, 0xb99223ff, REGISTRY_ARIN       }, // 185.146.32.0    - 185.146.35.255
	{ 0xb9922400, 0xb9973bff, REGISTRY_RIPENCC    }, // 185.146.36.0    - 185.151.59.255
	{ 0xb9974000, 0xb9a023ff, REGISTRY_RIPENCC    }, // 185.151.64.0    - 185.160.35.255
	{ 0xb9a02800, 0xb9a5bfff, REGISTRY_RIPENCC    }, // 185.160.40.0    - 185.165.191.255
	{ 0xb9a5c400, 0xb9a96bff, REGISTRY_RIPENCC    }, // 185.165.196.0   - 185.169.107.255
	{ 0xb9a96c00, 0xb9a96fff, REGISTRY_ARIN       }, // 185.169.108.0   - 185.169.111.255
	{ 0xb9a97000, 0xb9a9e3ff, REGISTRY_RIPENCC    }, // 185.169.112.0   - 185.169.227.255
	{ 0xb9a9e800, 0xb9abcfff, REGISTRY_RIPENCC    }, // 185.169.232.0   - 185.171.207.255
	{ 0xb9abd000, 0xb9abd3ff, REGISTRY_ARIN       }, // 185.171.208.0   - 185.171.211.255
	{ 0xb9abd400, 0xb9acb7ff, REGISTRY_RIPENCC    }, // 185.171.212.0   - 185.172.183.255
	{ 0xb9acbc00, 0xb9ad2bff, REGISTRY_RIPENCC    }, // 185.172.188.0   - 185.173.43.255
	{ 0xb9ad3000, 0xb9b033ff, REGISTRY_RIPENCC    }, // 185.173.48.0    - 185.176.51.255
	{ 0xb9b03400, 0xb9b037ff, REGISTRY_ARIN       }, // 185.176.52.0    - 185.176.55.255
	{ 0xb9b03800, 0xb9b0bfff, REGISTRY_RIPENCC    }, // 185.176.56.0    - 185.176.191.255
	{ 0xb9b0c400, 0xb9b1dbff, REGISTRY_RIPENCC    }, // 185.176.196.0   - 185.177.219.255
	{ 0xb9b1e000, 0xb9b28fff, REGISTRY_RIPENCC    }, // 185.177.224.0   - 185.178.143.255
	{ 0xb9b29000, 0xb9b293ff, REGISTRY_APNIC      }, // 185.178.144.0   - 185.178.147.255
	{ 0xb9b29400, 0xb9b36fff, REGISTRY_RIPENCC    }, // 185.178.148.0   - 185.179.111.255
	{ 0xb9b37400, 0xb9bedbff, REGISTRY_RIPENCC    }, // 185.179.116.0   - 185.190.219.255
	{ 0xb9bee000, 0xb9bfabff, REGISTRY_RIPENCC    }, // 185.190.224.0   - 185.191.171.255
	{ 0xb9bfb000, 0xb9c00fff, REGISTRY_RIPENCC    }, // 185.191.176.0   - 185.192.15.255
	{ 0xb9c01400, 0xb9c54bff, REGISTRY_RIPENCC    }, // 185.192.20.0    - 185.197.75.255
	{ 0xb9c55000, 0xb9c59fff, REGISTRY_RIPENCC    }, // 185.197.80.0    - 185.197.159.255
	{ 0xb9c5a400, 0xb9ca5fff, REGISTRY_RIPENCC    }, // 185.197.164.0   - 185.202.95.255
	{ 0xb9ca6800, 0xb9cabfff, REGISTRY_RIPENCC    }, // 185.202.104.0   - 185.202.191.255
	{ 0xb9cac400, 0xb9ced3ff, REGISTRY_RIPENCC    }, // 185.202.196.0   - 185.206.211.255
	{ 0xb9ced800, 0xb9cfa3ff, REGISTRY_RIPENCC    }, // 185.206.216.0   - 185.207.163.255
	{ 0xb9cfa800, 0xb9ded7ff, REGISTRY_RIPENCC    }, // 185.207.168.0   - 185.222.215.255
	{ 0xb9dedc00, 0xb9dfa3ff, REGISTRY_RIPENCC    }, // 185.222.220.0   - 185.223.163.255
	{ 0xb9dfa800, 0xb9e0dfff, REGISTRY_RIPENCC    }, // 185.223.168.0   - 185.224.223.255
	{ 0xb9e0e400, 0xb9e117ff, REGISTRY_RIPENCC    }, // 185.224.228.0   - 185.225.23.255
	{ 0xb9e11c00, 0xb9e2a3ff, REGISTRY_RIPENCC    }, // 185.225.28.0    - 185.226.163.255
	{ 0xb9e2a800, 0xb9e563ff, REGISTRY_RIPENCC    }, // 185.226.168.0   - 185.229.99.255
	{ 0xb9e56800, 0xb9e80fff, REGISTRY_RIPENCC    }, // 185.229.104.0   - 185.232.15.255
	{ 0xb9e81400, 0xb9e853ff, REGISTRY_RIPENCC    }, // 185.232.20.0    - 185.232.83.255
	{ 0xb9e85800, 0xb9e953ff, REGISTRY_RIPENCC    }, // 185.232.88.0    - 185.233.83.255
	{ 0xb9e95800, 0xb9e96fff, REGISTRY_RIPENCC    }, // 185.233.88.0    - 185.233.111.255
	{ 0xb9e97400, 0xb9e9d7ff, REGISTRY_RIPENCC    }, // 185.233.116.0   - 185.233.215.255
	{ 0xb9e9dc00, 0xb9eb57ff, REGISTRY_RIPENCC    }, // 185.233.220.0   - 185.235.87.255
	{ 0xb9eb5c00, 0xb9eefbff, REGISTRY_RIPENCC    }, // 185.235.92.0    - 185.238.251.255
	{ 0xb9ef0000, 0xb9f053ff, REGISTRY_RIPENCC    }, // 185.239.0.0     - 185.240.83.255
	{ 0xb9f05800, 0xb9f0ebff, REGISTRY_RIPENCC    }, // 185.240.88.0    - 185.240.235.255
	{ 0xb9f0f000, 0xb9f0ffff, REGISTRY_RIPENCC    }, // 185.240.240.0   - 185.240.255.255
	{ 0xb9f10400, 0xb9f147ff, REGISTRY_RIPENCC    }, // 185.241.4.0     - 185.241.71.255
	{ 0xb9f14c00, 0xb9f39bff, REGISTRY_RIPENCC    }, // 185.241.76.0    - 185.243.155.255
	{ 0xb9f3a000, 0xb9f3f3ff, REGISTRY_RIPENCC    }, // 185.243.160.0   - 185.243.243.255
	{ 0xb9f3f800, 0xb9fa27ff, REGISTRY_RIPENCC    }, // 185.243.248.0   - 185.250.39.255
	{ 0xb9fa2c00, 0xb9fcb7ff, REGISTRY_RIPENCC    }, // 185.250.44.0    - 185.252.183.255
	{ 0xb9fcbc00, 0xb9fcd7ff, REGISTRY_RIPENCC    }, // 185.252.188.0   - 185.252.215.255
	{ 0xb9fce000, 0xb9ffffff, REGISTRY_RIPENCC    }, // 185.252.224.0   - 185.255.255.255
	{ 0xba000000, 0xba008fff, REGISTRY_LACNIC     }, // 186.0.0.0       - 186.0.143.255
	{ 0xba009800, 0xba02fbff, REGISTRY_LACNIC     }, // 186.0.152.0     - 186.2.251.255
	{ 0xba030000, 0xba1a3fff, REGISTRY_LACNIC     }, // 186.3.0.0       - 186.26.63.255
	{ 0xba1a7000, 0xba415bff, REGISTRY_LACNIC     }, // 186.26.112.0    - 186.65.91.255
	{ 0xba416000, 0xba94bfff, REGISTRY_LACNIC     }, // 186.65.96.0     - 186.148.191.255
	{ 0xba94c800, 0xba94dfff, REGISTRY_LACNIC     }, // 186.148.200.0   - 186.148.223.255
	{ 0xba94e800, 0xbac1ffff, REGISTRY_LACNIC     }, // 186.148.232.0   - 186.193.255.255
	{ 0xbac21000, 0xbac29fff, REGISTRY_LACNIC     }, // 186.194.16.0    - 186.194.159.255
	{ 0xbac2b000, 0xbac3efff, REGISTRY_LACNIC     }, // 186.194.176.0   - 186.195.239.255
	{ 0xbac40000, 0xbad177ff, REGISTRY_LACNIC     }, // 186.196.0.0     - 186.209.119.255
	{ 0xbad18000, 0xbadb2fff, REGISTRY_LACNIC     }, // 186.209.128.0   - 186.219.47.255
	{ 0xbadb3800, 0xbadbdfff, REGISTRY_LACNIC     }, // 186.219.56.0    - 186.219.223.255
	{ 0xbadbf000, 0xbae867ff, REGISTRY_LACNIC     }, // 186.219.240.0   - 186.232.103.255
	{ 0xbae86c00, 0xbae8d7ff, REGISTRY_LACNIC     }, // 186.232.108.0   - 186.232.215.255
	{ 0xbae8e000, 0xbae8f1ff, REGISTRY_LACNIC     }, // 186.232.224.0   - 186.232.241.255
	{ 0xbae8f300, 0xbae8ffff, REGISTRY_LACNIC     }, // 186.232.243.0   - 186.232.255.255
	{ 0xbae90800, 0xbae917ff, REGISTRY_LACNIC     }, // 186.233.8.0     - 186.233.23.255
	{ 0xbae92000, 0xbae987ff, REGISTRY_LACNIC     }, // 186.233.32.0    - 186.233.135.255
	{ 0xbae98c00, 0xbaed5fff, REGISTRY_LACNIC     }, // 186.233.140.0   - 186.237.95.255
	{ 0xbaed7000, 0xbafa1fff, REGISTRY_LACNIC     }, // 186.237.112.0   - 186.250.31.255
	{ 0xbafa2400, 0xbafa3bff, REGISTRY_LACNIC     }, // 186.250.36.0    - 186.250.59.255
	{ 0xbafa4000, 0xbafa8fff, REGISTRY_LACNIC     }, // 186.250.64.0    - 186.250.143.255
	{ 0xbafa9400, 0xbafad7ff, REGISTRY_LACNIC     }, // 186.250.148.0   - 186.250.215.255
	{ 0xbafadc00, 0xbafb1fff, REGISTRY_LACNIC     }, // 186.250.220.0   - 186.251.31.255
	{ 0xbafb2400, 0xbb001fff, REGISTRY_LACNIC     }, // 186.251.36.0    - 187.0.31.255
	{ 0xbb003000, 0xbb117fff, REGISTRY_LACNIC     }, // 187.0.48.0      - 187.17.127.255
	{ 0xbb119000, 0xbb318fff, REGISTRY_LACNIC     }, // 187.17.144.0    - 187.49.143.255
	{ 0xbb31c000, 0xbb3e3fff, REGISTRY_LACNIC     }, // 187.49.192.0    - 187.62.63.255
	{ 0xbb3e8000, 0xbb3f77ff, REGISTRY_LACNIC     }, // 187.62.128.0    - 187.63.119.255
	{ 0xbb3f8000, 0xbb3fdfff, REGISTRY_LACNIC     }, // 187.63.128.0    - 187.63.223.255
	{ 0xbb3ff000, 0xbb49afff, REGISTRY_LACNIC     }, // 187.63.240.0    - 187.73.175.255
	{ 0xbb49c000, 0xbb546fff, REGISTRY_LACNIC     }, // 187.73.192.0    - 187.84.111.255
	{ 0xbb548000, 0xbb569fff, REGISTRY_LACNIC     }, // 187.84.128.0    - 187.86.159.255
	{ 0xbb56b000, 0xbb5dffff, REGISTRY_LACNIC     }, // 187.86.176.0    - 187.93.255.255
	{ 0xbb5e1000, 0xbb5fcfff, REGISTRY_LACNIC     }, // 187.94.16.0     - 187.95.207.255
	{ 0xbb5fe000, 0xbb66bfff, REGISTRY_LACNIC     }, // 187.95.224.0    - 187.102.191.255
	{ 0xbb670000, 0xbb670fff, REGISTRY_LACNIC     }, // 187.103.0.0     - 187.103.15.255
	{ 0xbb672000, 0xbb67bfff, REGISTRY_LACNIC     }, // 187.103.32.0    - 187.103.191.255
	{ 0xbb67d000, 0xbb6e97ff, REGISTRY_LACNIC     }, // 187.103.208.0   - 187.110.151.255
	{ 0xbb6ea000, 0xbb789fff, REGISTRY_LACNIC     }, // 187.110.160.0   - 187.120.159.255
	{ 0xbb78b000, 0xbb7997ff, REGISTRY_LACNIC     }, // 187.120.176.0   - 187.121.151.255
	{ 0xbb79a000, 0xbbffffff, REGISTRY_LACNIC     }, // 187.121.160.0   - 187.255.255.255
	{ 0xbc000000, 0xbc007fff, REGISTRY_RIPENCC    }, // 188.0.0.0       - 188.0.127.255
	{ 0xbc008000, 0xbc009fff, REGISTRY_RIPENCC    }, // 188.0.128.0     - 188.0.159.255
	{ 0xbc00a000, 0xbc00dfff, REGISTRY_RIPENCC    }, // 188.0.160.0     - 188.0.223.255
	{ 0xbc00e000, 0xbc00efff, REGISTRY_RIPENCC    }, // 188.0.224.0     - 188.0.239.255
	{ 0xbc00f000, 0xbc01ffff, REGISTRY_RIPENCC    }, // 188.0.240.0     - 188.1.255.255
	{ 0xbc020000, 0xbc7ffbff, REGISTRY_RIPENCC    }, // 188.2.0.0       - 188.127.251.255
	{ 0xbc7ffd00, 0xbc837fff, REGISTRY_RIPENCC    }, // 188.127.253.0   - 188.131.127.255
	{ 0xbc838000, 0xbc83ffff, REGISTRY_APNIC      }, // 188.131.128.0   - 188.131.255.255
	{ 0xbc840000, 0xbcbdffff, REGISTRY_RIPENCC    }, // 188.132.0.0     - 188.189.255.255
	{ 0xbcbe0000, 0xbcbe5fff, REGISTRY_RIPENCC    }, // 188.190.0.0     - 188.190.95.255
	{ 0xbcbe6000, 0xbcbe7fff, REGISTRY_RIPENCC    }, // 188.190.96.0    - 188.190.127.255
	{ 0xbcbe8000, 0xbcbf87ff, REGISTRY_RIPENCC    }, // 188.190.128.0   - 188.191.135.255
	{ 0xbcbf8800, 0xbcbf8fff, REGISTRY_RIPENCC    }, // 188.191.136.0   - 188.191.143.255
	{ 0xbcbf9000, 0xbcbff7ff, REGISTRY_RIPENCC    }, // 188.191.144.0   - 188.191.247.255
	{ 0xbcbff800, 0xbcd18fff, REGISTRY_RIPENCC    }, // 188.191.248.0   - 188.209.143.255
	{ 0xbcd19000, 0xbcd197ff, REGISTRY_ARIN       }, // 188.209.144.0   - 188.209.151.255
	{ 0xbcd19800, 0xbcd63fff, REGISTRY_RIPENCC    }, // 188.209.152.0   - 188.214.63.255
	{ 0xbcd64000, 0xbcd64fff, REGISTRY_APNIC      }, // 188.214.64.0    - 188.214.79.255
	{ 0xbcd65000, 0xbceeffff, REGISTRY_RIPENCC    }, // 188.214.80.0    - 188.238.255.255
	{ 0xbcef0000, 0xbcefb7ff, REGISTRY_RIPENCC    }, // 188.239.0.0     - 188.239.183.255
	{ 0xbcefb800, 0xbcefbbff, REGISTRY_RIPENCC    }, // 188.239.184.0   - 188.239.187.255
	{ 0xbcefbc00, 0xbcefffff, REGISTRY_RIPENCC    }, // 188.239.188.0   - 188.239.255.255
	{ 0xbcf00000, 0xbcffffff, REGISTRY_RIPENCC    }, // 188.240.0.0     - 188.255.255.255
	{ 0xbd000000, 0xbd086fff, REGISTRY_LACNIC     }, // 189.0.0.0       - 189.8.111.255
	{ 0xbd088000, 0xbd0e6fff, REGISTRY_LACNIC     }, // 189.8.128.0     - 189.14.111.255
	{ 0xbd0e8000, 0xbd247fff, REGISTRY_LACNIC     }, // 189.14.128.0    - 189.36.127.255
	{ 0xbd249000, 0xbd24efff, REGISTRY_LACNIC     }, // 189.36.144.0    - 189.36.239.255
	{ 0xbd250000, 0xbd27b3ff, REGISTRY_LACNIC     }, // 189.37.0.0      - 189.39.179.255
	{ 0xbd27bc00, 0xbd2dafff, REGISTRY_LACNIC     }, // 189.39.188.0    - 189.45.175.255
	{ 0xbd2dc000, 0xbd321fff, REGISTRY_LACNIC     }, // 189.45.192.0    - 189.50.31.255
	{ 0xbd322800, 0xbd3233ff, REGISTRY_LACNIC     }, // 189.50.40.0     - 189.50.51.255
	{ 0xbd324000, 0xbd32cfff, REGISTRY_LACNIC     }, // 189.50.64.0     - 189.50.207.255
	{ 0xbd32e000, 0xbd331fff, REGISTRY_LACNIC     }, // 189.50.224.0    - 189.51.31.255
	{ 0xbd333000, 0xbd339fff, REGISTRY_LACNIC     }, // 189.51.48.0     - 189.51.159.255
	{ 0xbd33b000, 0xbd541fff, REGISTRY_LACNIC     }, // 189.51.176.0    - 189.84.31.255
	{ 0xbd543000, 0xbd545fff, REGISTRY_LACNIC     }, // 189.84.48.0     - 189.84.95.255
	{ 0xbd547000, 0xbd551fff, REGISTRY_LACNIC     }, // 189.84.112.0    - 189.85.31.255
	{ 0xbd553000, 0xbd555fff, REGISTRY_LACNIC     }, // 189.85.48.0     - 189.85.95.255
	{ 0xbd558000, 0xbd5adfff, REGISTRY_LACNIC     }, // 189.85.128.0    - 189.90.223.255
	{ 0xbd5af000, 0xbd71afff, REGISTRY_LACNIC     }, // 189.90.240.0    - 189.113.175.255
	{ 0xbd71c000, 0xbd7dffff, REGISTRY_LACNIC     }, // 189.113.192.0   - 189.125.255.255
	{ 0xbd7e1000, 0xbd7e4fff, REGISTRY_LACNIC     }, // 189.126.16.0    - 189.126.79.255
	{ 0xbd7e6000, 0xbd7f7fff, REGISTRY_LACNIC     }, // 189.126.96.0    - 189.127.127.255
	{ 0xbd7fc000, 0xbdc9f7ff, REGISTRY_LACNIC     }, // 189.127.192.0   - 189.201.247.255
	{ 0xbdc9fc00, 0xbe023fff, REGISTRY_LACNIC     }, // 189.201.252.0   - 190.2.63.255
	{ 0xbe024800, 0xbe039fff, REGISTRY_LACNIC     }, // 190.2.72.0      - 190.3.159.255
	{ 0xbe03a800, 0xbe080fff, REGISTRY_LACNIC     }, // 190.3.168.0     - 190.8.15.255
	{ 0xbe082000, 0xbe089fff, REGISTRY_LACNIC     }, // 190.8.32.0      - 190.8.159.255
	{ 0xbe08a400, 0xbe08abff, REGISTRY_LACNIC     }, // 190.8.164.0     - 190.8.171.255
	{ 0xbe08b000, 0xbe0bcfff, REGISTRY_LACNIC     }, // 190.8.176.0     - 190.11.207.255
	{ 0xbe0be000, 0xbe52ffff, REGISTRY_LACNIC     }, // 190.11.224.0    - 190.82.255.255
	{ 0xbe538000, 0xbe58ffff, REGISTRY_LACNIC     }, // 190.83.128.0    - 190.88.255.255
	{ 0xbe5a0000, 0xbe5d1fff, REGISTRY_LACNIC     }, // 190.90.0.0      - 190.93.31.255
	{ 0xbe5d2400, 0xbe5db3ff, REGISTRY_LACNIC     }, // 190.93.36.0     - 190.93.179.255
	{ 0xbe5dc000, 0xbe61abff, REGISTRY_LACNIC     }, // 190.93.192.0    - 190.97.171.255
	{ 0xbe61b000, 0xbe662fff, REGISTRY_LACNIC     }, // 190.97.176.0    - 190.102.47.255
	{ 0xbe663800, 0xbe678fff, REGISTRY_LACNIC     }, // 190.102.56.0    - 190.103.143.255
	{ 0xbe67a000, 0xbe69c3ff, REGISTRY_LACNIC     }, // 190.103.160.0   - 190.105.195.255
	{ 0xbe69c800, 0xbe6a57ff, REGISTRY_LACNIC     }, // 190.105.200.0   - 190.106.87.255
	{ 0xbe6a6000, 0xbe6adfff, REGISTRY_LACNIC     }, // 190.106.96.0    - 190.106.223.255
	{ 0xbe6af000, 0xbe6b9fff, REGISTRY_LACNIC     }, // 190.106.240.0   - 190.107.159.255
	{ 0xbe6bb000, 0xbe6c4bff, REGISTRY_LACNIC     }, // 190.107.176.0   - 190.108.75.255
	{ 0xbe6c5000, 0xbe6f5fff, REGISTRY_LACNIC     }, // 190.108.80.0    - 190.111.95.255
	{ 0xbe6f7000, 0xbe6f7fff, REGISTRY_LACNIC     }, // 190.111.112.0   - 190.111.127.255
	{ 0xbe6fc000, 0xbe707fff, REGISTRY_LACNIC     }, // 190.111.192.0   - 190.112.127.255
	{ 0xbe70b000, 0xbe733fff, REGISTRY_LACNIC     }, // 190.112.176.0   - 190.115.63.255
	{ 0xbe736000, 0xbe73bfff, REGISTRY_LACNIC     }, // 190.115.96.0    - 190.115.191.255
	{ 0xbe73e000, 0xbe781fff, REGISTRY_LACNIC     }, // 190.115.224.0   - 190.120.31.255
	{ 0xbe783000, 0xbe78dfff, REGISTRY_LACNIC     }, // 190.120.48.0    - 190.120.223.255
	{ 0xbe78f000, 0xbe7b01ff, REGISTRY_LACNIC     }, // 190.120.240.0   - 190.123.1.255
	{ 0xbe7b0a00, 0xbe7b0eff, REGISTRY_LACNIC     }, // 190.123.10.0    - 190.123.14.255
	{ 0xbe7b1000, 0xbe7b7bff, REGISTRY_LACNIC     }, // 190.123.16.0    - 190.123.123.255
	{ 0xbe7b8000, 0xbe7c2fff, REGISTRY_LACNIC     }, // 190.123.128.0   - 190.124.47.255
	{ 0xbe7c3800, 0xbe7cf3ff, REGISTRY_LACNIC     }, // 190.124.56.0    - 190.124.243.255
	{ 0xbe7cf800, 0xbe7cfbff, REGISTRY_LACNIC     }, // 190.124.248.0   - 190.124.251.255
	{ 0xbe7d0000, 0xbeb8d7ff, REGISTRY_LACNIC     }, // 190.125.0.0     - 190.184.215.255
	{ 0xbeb8dc00, 0xbf0767ff, REGISTRY_LACNIC     }, // 190.184.220.0   - 191.7.103.255
	{ 0xbf077000, 0xbf254fff, REGISTRY_LACNIC     }, // 191.7.112.0     - 191.37.79.255
	{ 0xbf255800, 0xbf25a7ff, REGISTRY_LACNIC     }, // 191.37.88.0     - 191.37.167.255
	{ 0xbf25ac00, 0xbf25fbff, REGISTRY_LACNIC     }, // 191.37.172.0    - 191.37.251.255
	{ 0xbf25fd00, 0xbf34cfff, REGISTRY_LACNIC     }, // 191.37.253.0    - 191.52.207.255
	{ 0xbf34e000, 0xbff13bff, REGISTRY_LACNIC     }, // 191.52.224.0    - 191.241.59.255
	{ 0xbff14000, 0xbff18bff, REGISTRY_LACNIC     }, // 191.241.64.0    - 191.241.139.255
	{ 0xbff19000, 0xbfffffff, REGISTRY_LACNIC     }, // 191.241.144.0   - 191.255.255.255
	{ 0xc0000100, 0xc00001ff, REGISTRY_ARIN       }, // 192.0.1.0       - 192.0.1.255
	{ 0xc0000300, 0xc0051bff, REGISTRY_ARIN       }, // 192.0.3.0       - 192.5.27.255
	{ 0xc0051c00, 0xc0051eff, REGISTRY_RIPENCC    }, // 192.5.28.0      - 192.5.30.255
	{ 0xc0051f00, 0xc00523ff, REGISTRY_ARIN       }, // 192.5.31.0      - 192.5.35.255
	{ 0xc0052400, 0xc00524ff, REGISTRY_RIPENCC    }, // 192.5.36.0      - 192.5.36.255
	{ 0xc0052500, 0xc00531ff, REGISTRY_ARIN       }, // 192.5.37.0      - 192.5.49.255
	{ 0xc0053200, 0xc00532ff, REGISTRY_RIPENCC    }, // 192.5.50.0      - 192.5.50.255
	{ 0xc0053300, 0xc0053aff, REGISTRY_ARIN       }, // 192.5.51.0      - 192.5.58.255
	{ 0xc0053b00, 0xc0053bff, REGISTRY_RIPENCC    }, // 192.5.59.0      - 192.5.59.255
	{ 0xc0053c00, 0xc0053cff, REGISTRY_ARIN       }, // 192.5.60.0      - 192.5.60.255
	{ 0xc0053d00, 0xc0053eff, REGISTRY_RIPENCC    }, // 192.5.61.0      - 192.5.62.255
	{ 0xc0053f00, 0xc00559ff, REGISTRY_ARIN       }, // 192.5.63.0      - 192.5.89.255
	{ 0xc0055a00, 0xc0055aff, REGISTRY_APNIC      }, // 192.5.90.0      - 192.5.90.255
	{ 0xc0055b00, 0xc00560ff, REGISTRY_ARIN       }, // 192.5.91.0      - 192.5.96.255
	{ 0xc0056100, 0xc00561ff, REGISTRY_RIPENCC    }, // 192.5.97.0      - 192.5.97.255
	{ 0xc0056200, 0xc0058dff, REGISTRY_ARIN       }, // 192.5.98.0      - 192.5.141.255
	{ 0xc0058e00, 0xc0058eff, REGISTRY_RIPENCC    }, // 192.5.142.0     - 192.5.142.255
	{ 0xc0058f00, 0xc00590ff, REGISTRY_ARIN       }, // 192.5.143.0     - 192.5.144.255
	{ 0xc0059100, 0xc00591ff, REGISTRY_RIPENCC    }, // 192.5.145.0     - 192.5.145.255
	{ 0xc0059200, 0xc005a1ff, REGISTRY_ARIN       }, // 192.5.146.0     - 192.5.161.255
	{ 0xc005a200, 0xc005a2ff, REGISTRY_RIPENCC    }, // 192.5.162.0     - 192.5.162.255
	{ 0xc005a300, 0xc005d7ff, REGISTRY_ARIN       }, // 192.5.163.0     - 192.5.215.255
	{ 0xc005d800, 0xc005d8ff, REGISTRY_APNIC      }, // 192.5.216.0     - 192.5.216.255
	{ 0xc005d900, 0xc005eeff, REGISTRY_ARIN       }, // 192.5.217.0     - 192.5.238.255
	{ 0xc005ef00, 0xc005efff, REGISTRY_RIPENCC    }, // 192.5.239.0     - 192.5.239.255
	{ 0xc005f000, 0xc005f0ff, REGISTRY_APNIC      }, // 192.5.240.0     - 192.5.240.255
	{ 0xc005f100, 0xc005fdff, REGISTRY_ARIN       }, // 192.5.241.0     - 192.5.253.255
	{ 0xc005fe00, 0xc005feff, REGISTRY_RIPENCC    }, // 192.5.254.0     - 192.5.254.255
	{ 0xc005ff00, 0xc0081fff, REGISTRY_ARIN       }, // 192.5.255.0     - 192.8.31.255
	{ 0xc0082000, 0xc0082bff, REGISTRY_APNIC      }, // 192.8.32.0      - 192.8.43.255
	{ 0xc0082c00, 0xc00873ff, REGISTRY_ARIN       }, // 192.8.44.0      - 192.8.115.255
	{ 0xc0087400, 0xc00877ff, REGISTRY_APNIC      }, // 192.8.116.0     - 192.8.119.255
	{ 0xc0087800, 0xc0089fff, REGISTRY_ARIN       }, // 192.8.120.0     - 192.8.159.255
	{ 0xc008a000, 0xc008b0ff, REGISTRY_APNIC      }, // 192.8.160.0     - 192.8.176.255
	{ 0xc008b100, 0xc008b2ff, REGISTRY_ARIN       }, // 192.8.177.0     - 192.8.178.255
	{ 0xc008b300, 0xc008b4ff, REGISTRY_APNIC      }, // 192.8.179.0     - 192.8.180.255
	{ 0xc008b500, 0xc008b5ff, REGISTRY_ARIN       }, // 192.8.181.0     - 192.8.181.255
	{ 0xc008b600, 0xc008b6ff, REGISTRY_APNIC      }, // 192.8.182.0     - 192.8.182.255
	{ 0xc008b700, 0xc008b7ff, REGISTRY_ARIN       }, // 192.8.183.0     - 192.8.183.255
	{ 0xc008b800, 0xc008ffff, REGISTRY_APNIC      }, // 192.8.184.0     - 192.8.255.255
	{ 0xc0090000, 0xc00c00ff, REGISTRY_ARIN       }, // 192.9.0.0       - 192.12.0.255
	{ 0xc00c0100, 0xc00c01ff, REGISTRY_RIPENCC    }, // 192.12.1.0      - 192.12.1.255
	{ 0xc00c0200, 0xc00c2eff, REGISTRY_ARIN       }, // 192.12.2.0      - 192.12.46.255
	{ 0xc00c2f00, 0xc00c2fff, REGISTRY_RIPENCC    }, // 192.12.47.0     - 192.12.47.255
	{ 0xc00c3000, 0xc00c35ff, REGISTRY_ARIN       }, // 192.12.48.0     - 192.12.53.255
	{ 0xc00c3600, 0xc00c36ff, REGISTRY_RIPENCC    }, // 192.12.54.0     - 192.12.54.255
	{ 0xc00c3700, 0xc00c47ff, REGISTRY_ARIN       }, // 192.12.55.0     - 192.12.71.255
	{ 0xc00c4800, 0xc00c49ff, REGISTRY_RIPENCC    }, // 192.12.72.0     - 192.12.73.255
	{ 0xc00c4a00, 0xc00c4bff, REGISTRY_ARIN       }, // 192.12.74.0     - 192.12.75.255
	{ 0xc00c4c00, 0xc00c4cff, REGISTRY_APNIC      }, // 192.12.76.0     - 192.12.76.255
	{ 0xc00c4d00, 0xc00c4dff, REGISTRY_RIPENCC    }, // 192.12.77.0     - 192.12.77.255
	{ 0xc00c4e00, 0xc00c50ff, REGISTRY_ARIN       }, // 192.12.78.0     - 192.12.80.255
	{ 0xc00c5100, 0xc00c51ff, REGISTRY_RIPENCC    }, // 192.12.81.0     - 192.12.81.255
	{ 0xc00c5200, 0xc00c5fff, REGISTRY_ARIN       }, // 192.12.82.0     - 192.12.95.255
	{ 0xc00c6000, 0xc00c60ff, REGISTRY_RIPENCC    }, // 192.12.96.0     - 192.12.96.255
	{ 0xc00c6100, 0xc00c62ff, REGISTRY_ARIN       }, // 192.12.97.0     - 192.12.98.255
	{ 0xc00c6300, 0xc00c63ff, REGISTRY_RIPENCC    }, // 192.12.99.0     - 192.12.99.255
	{ 0xc00c6400, 0xc00c6cff, REGISTRY_ARIN       }, // 192.12.100.0    - 192.12.108.255
	{ 0xc00c6f00, 0xc00c6fff, REGISTRY_AFRINIC    }, // 192.12.111.0    - 192.12.111.255
	{ 0xc00c7000, 0xc00c73ff, REGISTRY_LACNIC     }, // 192.12.112.0    - 192.12.115.255
	{ 0xc00c7400, 0xc00c75ff, REGISTRY_AFRINIC    }, // 192.12.116.0    - 192.12.117.255
	{ 0xc00c7600, 0xc00c76ff, REGISTRY_LACNIC     }, // 192.12.118.0    - 192.12.118.255
	{ 0xc00c7700, 0xc00cbfff, REGISTRY_ARIN       }, // 192.12.119.0    - 192.12.191.255
	{ 0xc00cc000, 0xc00cc2ff, REGISTRY_RIPENCC    }, // 192.12.192.0    - 192.12.194.255
	{ 0xc00cc300, 0xc00cd8ff, REGISTRY_ARIN       }, // 192.12.195.0    - 192.12.216.255
	{ 0xc00cd900, 0xc00cdaff, REGISTRY_RIPENCC    }, // 192.12.217.0    - 192.12.218.255
	{ 0xc00cdb00, 0xc00ce6ff, REGISTRY_ARIN       }, // 192.12.219.0    - 192.12.230.255
	{ 0xc00ce700, 0xc00ce8ff, REGISTRY_RIPENCC    }, // 192.12.231.0    - 192.12.232.255
	{ 0xc00ce900, 0xc00ceaff, REGISTRY_ARIN       }, // 192.12.233.0    - 192.12.234.255
	{ 0xc00ceb00, 0xc00cebff, REGISTRY_RIPENCC    }, // 192.12.235.0    - 192.12.235.255
	{ 0xc00cec00, 0xc00cf6ff, REGISTRY_ARIN       }, // 192.12.236.0    - 192.12.246.255
	{ 0xc00cf700, 0xc00cf7ff, REGISTRY_RIPENCC    }, // 192.12.247.0    - 192.12.247.255
	{ 0xc00cf800, 0xc00effff, REGISTRY_ARIN       }, // 192.12.248.0    - 192.14.255.255
	{ 0xc00f0000, 0xc00fffff, REGISTRY_RIPENCC    }, // 192.15.0.0      - 192.15.255.255
	{ 0xc0100000, 0xc0107aff, REGISTRY_ARIN       }, // 192.16.0.0      - 192.16.122.255
	{ 0xc0107b00, 0xc01097ff, REGISTRY_RIPENCC    }, // 192.16.123.0    - 192.16.151.255
	{ 0xc0109800, 0xc0109aff, REGISTRY_RIPENCC    }, // 192.16.152.0    - 192.16.154.255
	{ 0xc0109b00, 0xc010a6ff, REGISTRY_RIPENCC    }, // 192.16.155.0    - 192.16.166.255
	{ 0xc010a700, 0xc010b1ff, REGISTRY_ARIN       }, // 192.16.167.0    - 192.16.177.255
	{ 0xc010b200, 0xc010b4ff, REGISTRY_APNIC      }, // 192.16.178.0    - 192.16.180.255
	{ 0xc010b500, 0xc010b6ff, REGISTRY_ARIN       }, // 192.16.181.0    - 192.16.182.255
	{ 0xc010b700, 0xc010caff, REGISTRY_RIPENCC    }, // 192.16.183.0    - 192.16.202.255
	{ 0xc010cb00, 0xc012c2ff, REGISTRY_ARIN       }, // 192.16.203.0    - 192.18.194.255
	{ 0xc012c300, 0xc012c3ff, REGISTRY_RIPENCC    }, // 192.18.195.0    - 192.18.195.255
	{ 0xc012c400, 0xc01a1bff, REGISTRY_ARIN       }, // 192.18.196.0    - 192.26.27.255
	{ 0xc01a1c00, 0xc01a2fff, REGISTRY_RIPENCC    }, // 192.26.28.0     - 192.26.47.255
	{ 0xc01a3000, 0xc01a5aff, REGISTRY_ARIN       }, // 192.26.48.0     - 192.26.90.255
	{ 0xc01a5b00, 0xc01a5bff, REGISTRY_APNIC      }, // 192.26.91.0     - 192.26.91.255
	{ 0xc01a5c00, 0xc01a5cff, REGISTRY_ARIN       }, // 192.26.92.0     - 192.26.92.255
	{ 0xc01a5d00, 0xc01a5eff, REGISTRY_APNIC      }, // 192.26.93.0     - 192.26.94.255
	{ 0xc01a5f00, 0xc01a5fff, REGISTRY_ARIN       }, // 192.26.95.0     - 192.26.95.255
	{ 0xc01a6000, 0xc01a60ff, REGISTRY_APNIC      }, // 192.26.96.0     - 192.26.96.255
	{ 0xc01a6100, 0xc01a68ff, REGISTRY_ARIN       }, // 192.26.97.0     - 192.26.104.255
	{ 0xc01a6900, 0xc01a6dff, REGISTRY_RIPENCC    }, // 192.26.105.0    - 192.26.109.255
	{ 0xc01a6e00, 0xc01a6eff, REGISTRY_APNIC      }, // 192.26.110.0    - 192.26.110.255
	{ 0xc01a6f00, 0xc01a80ff, REGISTRY_RIPENCC    }, // 192.26.111.0    - 192.26.128.255
	{ 0xc01a8100, 0xc01a84ff, REGISTRY_ARIN       }, // 192.26.129.0    - 192.26.132.255
	{ 0xc01a8500, 0xc01a87ff, REGISTRY_RIPENCC    }, // 192.26.133.0    - 192.26.135.255
	{ 0xc01a8800, 0xc01a99ff, REGISTRY_ARIN       }, // 192.26.136.0    - 192.26.153.255
	{ 0xc01a9a00, 0xc01ac1ff, REGISTRY_RIPENCC    }, // 192.26.154.0    - 192.26.193.255
	{ 0xc01ac200, 0xc01ad6ff, REGISTRY_ARIN       }, // 192.26.194.0    - 192.26.214.255
	{ 0xc01ad800, 0xc01ae6ff, REGISTRY_APNIC      }, // 192.26.216.0    - 192.26.230.255
	{ 0xc01ae700, 0xc01ae7ff, REGISTRY_RIPENCC    }, // 192.26.231.0    - 192.26.231.255
	{ 0xc01ae800, 0xc01ae8ff, REGISTRY_APNIC      }, // 192.26.232.0    - 192.26.232.255
	{ 0xc01ae900, 0xc01ae9ff, REGISTRY_ARIN       }, // 192.26.233.0    - 192.26.233.255
	{ 0xc01aea00, 0xc01aeaff, REGISTRY_RIPENCC    }, // 192.26.234.0    - 192.26.234.255
	{ 0xc01aeb00, 0xc01aebff, REGISTRY_ARIN       }, // 192.26.235.0    - 192.26.235.255
	{ 0xc01aec00, 0xc01aefff, REGISTRY_RIPENCC    }, // 192.26.236.0    - 192.26.239.255
	{ 0xc01af000, 0xc01c77ff, REGISTRY_ARIN       }, // 192.26.240.0    - 192.28.119.255
	{ 0xc01c7800, 0xc01c7bff, REGISTRY_APNIC      }, // 192.28.120.0    - 192.28.123.255
	{ 0xc01c7c00, 0xc01c83ff, REGISTRY_RIPENCC    }, // 192.28.124.0    - 192.28.131.255
	{ 0xc01c8400, 0xc01f0dff, REGISTRY_ARIN       }, // 192.28.132.0    - 192.31.13.255
	{ 0xc01f0e00, 0xc01f0eff, REGISTRY_RIPENCC    }, // 192.31.14.0     - 192.31.14.255
	{ 0xc01f0f00, 0xc01f16ff, REGISTRY_ARIN       }, // 192.31.15.0     - 192.31.22.255
	{ 0xc01f1700, 0xc01f17ff, REGISTRY_RIPENCC    }, // 192.31.23.0     - 192.31.23.255
	{ 0xc01f1800, 0xc01f19ff, REGISTRY_ARIN       }, // 192.31.24.0     - 192.31.25.255
	{ 0xc01f1a00, 0xc01f1bff, REGISTRY_RIPENCC    }, // 192.31.26.0     - 192.31.27.255
	{ 0xc01f1c00, 0xc01f1eff, REGISTRY_ARIN       }, // 192.31.28.0     - 192.31.30.255
	{ 0xc01f1f00, 0xc01f1fff, REGISTRY_RIPENCC    }, // 192.31.31.0     - 192.31.31.255
	{ 0xc01f2000, 0xc01f27ff, REGISTRY_ARIN       }, // 192.31.32.0     - 192.31.39.255
	{ 0xc01f2800, 0xc01f28ff, REGISTRY_RIPENCC    }, // 192.31.40.0     - 192.31.40.255
	{ 0xc01f2900, 0xc01f3dff, REGISTRY_ARIN       }, // 192.31.41.0     - 192.31.61.255
	{ 0xc01f3e00, 0xc01f3eff, REGISTRY_RIPENCC    }, // 192.31.62.0     - 192.31.62.255
	{ 0xc01f3f00, 0xc01f65ff, REGISTRY_ARIN       }, // 192.31.63.0     - 192.31.101.255
	{ 0xc01f6600, 0xc01f66ff, REGISTRY_RIPENCC    }, // 192.31.102.0    - 192.31.102.255
	{ 0xc01f6700, 0xc01f73ff, REGISTRY_ARIN       }, // 192.31.103.0    - 192.31.115.255
	{ 0xc01f7400, 0xc01f7cff, REGISTRY_APNIC      }, // 192.31.116.0    - 192.31.124.255
	{ 0xc01f7d00, 0xc01fa5ff, REGISTRY_ARIN       }, // 192.31.125.0    - 192.31.165.255
	{ 0xc01fa600, 0xc01fabff, REGISTRY_RIPENCC    }, // 192.31.166.0    - 192.31.171.255
	{ 0xc01fac00, 0xc01fc3ff, REGISTRY_ARIN       }, // 192.31.172.0    - 192.31.195.255
	{ 0xc01fc500, 0xc01fceff, REGISTRY_APNIC      }, // 192.31.197.0    - 192.31.206.255
	{ 0xc01fcf00, 0xc01fd2ff, REGISTRY_ARIN       }, // 192.31.207.0    - 192.31.210.255
	{ 0xc01fd300, 0xc01fd3ff, REGISTRY_RIPENCC    }, // 192.31.211.0    - 192.31.211.255
	{ 0xc01fd400, 0xc01fe6ff, REGISTRY_ARIN       }, // 192.31.212.0    - 192.31.230.255
	{ 0xc01fe700, 0xc01fe7ff, REGISTRY_RIPENCC    }, // 192.31.231.0    - 192.31.231.255
	{ 0xc01fe800, 0xc01ffbff, REGISTRY_ARIN       }, // 192.31.232.0    - 192.31.251.255
	{ 0xc01ffc00, 0xc01ffcff, REGISTRY_RIPENCC    }, // 192.31.252.0    - 192.31.252.255
	{ 0xc01ffd00, 0xc02109ff, REGISTRY_ARIN       }, // 192.31.253.0    - 192.33.9.255
	{ 0xc0210a00, 0xc0210aff, REGISTRY_AFRINIC    }, // 192.33.10.0     - 192.33.10.255
	{ 0xc0210b00, 0xc0210eff, REGISTRY_ARIN       }, // 192.33.11.0     - 192.33.14.255
	{ 0xc0210f00, 0xc02110ff, REGISTRY_RIPENCC    }, // 192.33.15.0     - 192.33.16.255
	{ 0xc0211100, 0xc02123ff, REGISTRY_ARIN       }, // 192.33.17.0     - 192.33.35.255
	{ 0xc0212400, 0xc02124ff, REGISTRY_RIPENCC    }, // 192.33.36.0     - 192.33.36.255
	{ 0xc0212500, 0xc02156ff, REGISTRY_ARIN       }, // 192.33.37.0     - 192.33.86.255
	{ 0xc0215700, 0xc0216fff, REGISTRY_RIPENCC    }, // 192.33.87.0     - 192.33.111.255
	{ 0xc0217000, 0xc02170ff, REGISTRY_ARIN       }, // 192.33.112.0    - 192.33.112.255
	{ 0xc0217100, 0xc02172ff, REGISTRY_RIPENCC    }, // 192.33.113.0    - 192.33.114.255
	{ 0xc0217300, 0xc02175ff, REGISTRY_ARIN       }, // 192.33.115.0    - 192.33.117.255
	{ 0xc0217600, 0xc0217fff, REGISTRY_RIPENCC    }, // 192.33.118.0    - 192.33.127.255
	{ 0xc0218000, 0xc02181ff, REGISTRY_ARIN       }, // 192.33.128.0    - 192.33.129.255
	{ 0xc0218200, 0xc02183ff, REGISTRY_RIPENCC    }, // 192.33.130.0    - 192.33.131.255
	{ 0xc0218400, 0xc02186ff, REGISTRY_ARIN       }, // 192.33.132.0    - 192.33.134.255
	{ 0xc0218700, 0xc02187ff, REGISTRY_APNIC      }, // 192.33.135.0    - 192.33.135.255
	{ 0xc0218800, 0xc0218eff, REGISTRY_ARIN       }, // 192.33.136.0    - 192.33.142.255
	{ 0xc0218f00, 0xc02191ff, REGISTRY_RIPENCC    }, // 192.33.143.0    - 192.33.145.255
	{ 0xc0219200, 0xc02192ff, REGISTRY_ARIN       }, // 192.33.146.0    - 192.33.146.255
	{ 0xc0219300, 0xc021a2ff, REGISTRY_RIPENCC    }, // 192.33.147.0    - 192.33.162.255
	{ 0xc021a400, 0xc021a6ff, REGISTRY_RIPENCC    }, // 192.33.164.0    - 192.33.166.255
	{ 0xc021a700, 0xc021a8ff, REGISTRY_ARIN       }, // 192.33.167.0    - 192.33.168.255
	{ 0xc021a900, 0xc021abff, REGISTRY_RIPENCC    }, // 192.33.169.0    - 192.33.171.255
	{ 0xc021ac00, 0xc021afff, REGISTRY_ARIN       }, // 192.33.172.0    - 192.33.175.255
	{ 0xc021b000, 0xc021b6ff, REGISTRY_RIPENCC    }, // 192.33.176.0    - 192.33.182.255
	{ 0xc021b700, 0xc021bfff, REGISTRY_ARIN       }, // 192.33.183.0    - 192.33.191.255
	{ 0xc021c000, 0xc021e7ff, REGISTRY_RIPENCC    }, // 192.33.192.0    - 192.33.231.255
	{ 0xc021e800, 0xc021e8ff, REGISTRY_ARIN       }, // 192.33.232.0    - 192.33.232.255
	{ 0xc021e900, 0xc021efff, REGISTRY_RIPENCC    }, // 192.33.233.0    - 192.33.239.255
	{ 0xc021f000, 0xc021fdff, REGISTRY_ARIN       }, // 192.33.240.0    - 192.33.253.255
	{ 0xc021fe00, 0xc021feff, REGISTRY_RIPENCC    }, // 192.33.254.0    - 192.33.254.255
	{ 0xc021ff00, 0xc02212ff, REGISTRY_ARIN       }, // 192.33.255.0    - 192.34.18.255
	{ 0xc0221300, 0xc02213ff, REGISTRY_RIPENCC    }, // 192.34.19.0     - 192.34.19.255
	{ 0xc0221400, 0xc02231ff, REGISTRY_ARIN       }, // 192.34.20.0     - 192.34.49.255
	{ 0xc0223200, 0xc02232ff, REGISTRY_RIPENCC    }, // 192.34.50.0     - 192.34.50.255
	{ 0xc0223300, 0xc0226aff, REGISTRY_ARIN       }, // 192.34.51.0     - 192.34.106.255
	{ 0xc0226b00, 0xc0226bff, REGISTRY_RIPENCC    }, // 192.34.107.0    - 192.34.107.255
	{ 0xc0226c00, 0xc02273ff, REGISTRY_ARIN       }, // 192.34.108.0    - 192.34.115.255
	{ 0xc0227400, 0xc02274ff, REGISTRY_RIPENCC    }, // 192.34.116.0    - 192.34.116.255
	{ 0xc0227500, 0xc022b2ff, REGISTRY_ARIN       }, // 192.34.117.0    - 192.34.178.255
	{ 0xc022b300, 0xc022b3ff, REGISTRY_RIPENCC    }, // 192.34.179.0    - 192.34.179.255
	{ 0xc022b400, 0xc022ffff, REGISTRY_ARIN       }, // 192.34.180.0    - 192.34.255.255
	{ 0xc0230000, 0xc02313ff, REGISTRY_RIPENCC    }, // 192.35.0.0      - 192.35.19.255
	{ 0xc0231400, 0xc0233aff, REGISTRY_ARIN       }, // 192.35.20.0     - 192.35.58.255
	{ 0xc0233b00, 0xc0233bff, REGISTRY_APNIC      }, // 192.35.59.0     - 192.35.59.255
	{ 0xc0233c00, 0xc0233eff, REGISTRY_ARIN       }, // 192.35.60.0     - 192.35.62.255
	{ 0xc0233f00, 0xc02348ff, REGISTRY_RIPENCC    }, // 192.35.63.0     - 192.35.72.255
	{ 0xc0234900, 0xc02359ff, REGISTRY_ARIN       }, // 192.35.73.0     - 192.35.89.255
	{ 0xc0235a00, 0xc0235aff, REGISTRY_RIPENCC    }, // 192.35.90.0     - 192.35.90.255
	{ 0xc0235b00, 0xc0235dff, REGISTRY_ARIN       }, // 192.35.91.0     - 192.35.93.255
	{ 0xc0235e00, 0xc0235eff, REGISTRY_RIPENCC    }, // 192.35.94.0     - 192.35.94.255
	{ 0xc0235f00, 0xc0236bff, REGISTRY_ARIN       }, // 192.35.95.0     - 192.35.107.255
	{ 0xc0236c00, 0xc0236cff, REGISTRY_RIPENCC    }, // 192.35.108.0    - 192.35.108.255
	{ 0xc0236d00, 0xc02381ff, REGISTRY_ARIN       }, // 192.35.109.0    - 192.35.129.255
	{ 0xc0238200, 0xc02385ff, REGISTRY_RIPENCC    }, // 192.35.130.0    - 192.35.133.255
	{ 0xc0238600, 0xc02389ff, REGISTRY_ARIN       }, // 192.35.134.0    - 192.35.137.255
	{ 0xc0238a00, 0xc0238aff, REGISTRY_RIPENCC    }, // 192.35.138.0    - 192.35.138.255
	{ 0xc0238b00, 0xc02391ff, REGISTRY_ARIN       }, // 192.35.139.0    - 192.35.145.255
	{ 0xc0239200, 0xc02392ff, REGISTRY_RIPENCC    }, // 192.35.146.0    - 192.35.146.255
	{ 0xc0239300, 0xc02394ff, REGISTRY_ARIN       }, // 192.35.147.0    - 192.35.148.255
	{ 0xc0239500, 0xc02399ff, REGISTRY_RIPENCC    }, // 192.35.149.0    - 192.35.153.255
	{ 0xc0239a00, 0xc023abff, REGISTRY_ARIN       }, // 192.35.154.0    - 192.35.171.255
	{ 0xc023ac00, 0xc023acff, REGISTRY_RIPENCC    }, // 192.35.172.0    - 192.35.172.255
	{ 0xc023ad00, 0xc023b6ff, REGISTRY_ARIN       }, // 192.35.173.0    - 192.35.182.255
	{ 0xc023b700, 0xc023c0ff, REGISTRY_RIPENCC    }, // 192.35.183.0    - 192.35.192.255
	{ 0xc023c100, 0xc023c4ff, REGISTRY_ARIN       }, // 192.35.193.0    - 192.35.196.255
	{ 0xc023c500, 0xc023c6ff, REGISTRY_RIPENCC    }, // 192.35.197.0    - 192.35.198.255
	{ 0xc023c700, 0xc023ccff, REGISTRY_ARIN       }, // 192.35.199.0    - 192.35.204.255
	{ 0xc023cf00, 0xc023cfff, REGISTRY_RIPENCC    }, // 192.35.207.0    - 192.35.207.255
	{ 0xc023d000, 0xc023e4ff, REGISTRY_ARIN       }, // 192.35.208.0    - 192.35.228.255
	{ 0xc023e500, 0xc023e5ff, REGISTRY_RIPENCC    }, // 192.35.229.0    - 192.35.229.255
	{ 0xc023e600, 0xc023efff, REGISTRY_ARIN       }, // 192.35.230.0    - 192.35.239.255
	{ 0xc023f000, 0xc023f4ff, REGISTRY_RIPENCC    }, // 192.35.240.0    - 192.35.244.255
	{ 0xc023f500, 0xc023f5ff, REGISTRY_ARIN       }, // 192.35.245.0    - 192.35.245.255
	{ 0xc023f600, 0xc023f7ff, REGISTRY_RIPENCC    }, // 192.35.246.0    - 192.35.247.255
	{ 0xc023f800, 0xc023f8ff, REGISTRY_APNIC      }, // 192.35.248.0    - 192.35.248.255
	{ 0xc023f900, 0xc023ffff, REGISTRY_ARIN       }, // 192.35.249.0    - 192.35.255.255
	{ 0xc0240000, 0xc025ffff, REGISTRY_RIPENCC    }, // 192.36.0.0      - 192.37.255.255
	{ 0xc0260000, 0xc0267fff, REGISTRY_RIPENCC    }, // 192.38.0.0      - 192.38.127.255
	{ 0xc0268000, 0xc026ffff, REGISTRY_RIPENCC    }, // 192.38.128.0    - 192.38.255.255
	{ 0xc0270000, 0xc02844ff, REGISTRY_ARIN       }, // 192.39.0.0      - 192.40.68.255
	{ 0xc0284600, 0xc02850ff, REGISTRY_RIPENCC    }, // 192.40.70.0     - 192.40.80.255
	{ 0xc0285100, 0xc028e3ff, REGISTRY_ARIN       }, // 192.40.81.0     - 192.40.227.255
	{ 0xc028e400, 0xc028e4ff, REGISTRY_RIPENCC    }, // 192.40.228.0    - 192.40.228.255
	{ 0xc028e500, 0xc02966ff, REGISTRY_ARIN       }, // 192.40.229.0    - 192.41.102.255
	{ 0xc0296700, 0xc02988ff, REGISTRY_RIPENCC    }, // 192.41.103.0    - 192.41.136.255
	{ 0xc0298900, 0xc0298bff, REGISTRY_ARIN       }, // 192.41.137.0    - 192.41.139.255
	{ 0xc0298c00, 0xc02991ff, REGISTRY_RIPENCC    }, // 192.41.140.0    - 192.41.145.255
	{ 0xc0299200, 0xc02992ff, REGISTRY_APNIC      }, // 192.41.146.0    - 192.41.146.255
	{ 0xc0299300, 0xc02993ff, REGISTRY_RIPENCC    }, // 192.41.147.0    - 192.41.147.255
	{ 0xc0299400, 0xc02994ff, REGISTRY_ARIN       }, // 192.41.148.0    - 192.41.148.255
	{ 0xc0299500, 0xc029a0ff, REGISTRY_RIPENCC    }, // 192.41.149.0    - 192.41.160.255
	{ 0xc029a100, 0xc029a9ff, REGISTRY_ARIN       }, // 192.41.161.0    - 192.41.169.255
	{ 0xc029aa00, 0xc029aaff, REGISTRY_APNIC      }, // 192.41.170.0    - 192.41.170.255
	{ 0xc029ab00, 0xc029b1ff, REGISTRY_ARIN       }, // 192.41.171.0    - 192.41.177.255
	{ 0xc029b200, 0xc029c5ff, REGISTRY_APNIC      }, // 192.41.178.0    - 192.41.197.255
	{ 0xc029c600, 0xc029caff, REGISTRY_ARIN       }, // 192.41.198.0    - 192.41.202.255
	{ 0xc029cb00, 0xc029cbff, REGISTRY_APNIC      }, // 192.41.203.0    - 192.41.203.255
	{ 0xc029cc00, 0xc029cdff, REGISTRY_ARIN       }, // 192.41.204.0    - 192.41.205.255
	{ 0xc029ce00, 0xc029ceff, REGISTRY_APNIC      }, // 192.41.206.0    - 192.41.206.255
	{ 0xc029cf00, 0xc029d1ff, REGISTRY_ARIN       }, // 192.41.207.0    - 192.41.209.255
	{ 0xc029d200, 0xc029d2ff, REGISTRY_RIPENCC    }, // 192.41.210.0    - 192.41.210.255
	{ 0xc029d300, 0xc029d7ff, REGISTRY_ARIN       }, // 192.41.211.0    - 192.41.215.255
	{ 0xc029d800, 0xc029d8ff, REGISTRY_RIPENCC    }, // 192.41.216.0    - 192.41.216.255
	{ 0xc029d900, 0xc029d9ff, REGISTRY_ARIN       }, // 192.41.217.0    - 192.41.217.255
	{ 0xc029da00, 0xc029daff, REGISTRY_RIPENCC    }, // 192.41.218.0    - 192.41.218.255
	{ 0xc029db00, 0xc029e2ff, REGISTRY_ARIN       }, // 192.41.219.0    - 192.41.226.255
	{ 0xc029e300, 0xc029e3ff, REGISTRY_RIPENCC    }, // 192.41.227.0    - 192.41.227.255
	{ 0xc029e400, 0xc02a00ff, REGISTRY_ARIN       }, // 192.41.228.0    - 192.42.0.255
	{ 0xc02a0100, 0xc02a01ff, REGISTRY_RIPENCC    }, // 192.42.1.0      - 192.42.1.255
	{ 0xc02a0200, 0xc02a29ff, REGISTRY_ARIN       }, // 192.42.2.0      - 192.42.41.255
	{ 0xc02a2a00, 0xc02a2fff, REGISTRY_RIPENCC    }, // 192.42.42.0     - 192.42.47.255
	{ 0xc02a3000, 0xc02a33ff, REGISTRY_ARIN       }, // 192.42.48.0     - 192.42.51.255
	{ 0xc02a3500, 0xc02a35ff, REGISTRY_RIPENCC    }, // 192.42.53.0     - 192.42.53.255
	{ 0xc02a3600, 0xc02a3bff, REGISTRY_ARIN       }, // 192.42.54.0     - 192.42.59.255
	{ 0xc02a3c00, 0xc02a3eff, REGISTRY_APNIC      }, // 192.42.60.0     - 192.42.62.255
	{ 0xc02a3f00, 0xc02a40ff, REGISTRY_RIPENCC    }, // 192.42.63.0     - 192.42.64.255
	{ 0xc02a4200, 0xc02a53ff, REGISTRY_ARIN       }, // 192.42.66.0     - 192.42.83.255
	{ 0xc02a5700, 0xc02a57ff, REGISTRY_RIPENCC    }, // 192.42.87.0     - 192.42.87.255
	{ 0xc02a5800, 0xc02a60ff, REGISTRY_ARIN       }, // 192.42.88.0     - 192.42.96.255
	{ 0xc02a6100, 0xc02a61ff, REGISTRY_RIPENCC    }, // 192.42.97.0     - 192.42.97.255
	{ 0xc02a6200, 0xc02a62ff, REGISTRY_ARIN       }, // 192.42.98.0     - 192.42.98.255
	{ 0xc02a6300, 0xc02a63ff, REGISTRY_AFRINIC    }, // 192.42.99.0     - 192.42.99.255
	{ 0xc02a6400, 0xc02a64ff, REGISTRY_RIPENCC    }, // 192.42.100.0    - 192.42.100.255
	{ 0xc02a6500, 0xc02a65ff, REGISTRY_ARIN       }, // 192.42.101.0    - 192.42.101.255
	{ 0xc02a6600, 0xc02a66ff, REGISTRY_RIPENCC    }, // 192.42.102.0    - 192.42.102.255
	{ 0xc02a6700, 0xc02a6bff, REGISTRY_APNIC      }, // 192.42.103.0    - 192.42.107.255
	{ 0xc02a6c00, 0xc02a70ff, REGISTRY_ARIN       }, // 192.42.108.0    - 192.42.112.255
	{ 0xc02a7100, 0xc02a84ff, REGISTRY_RIPENCC    }, // 192.42.113.0    - 192.42.132.255
	{ 0xc02a8500, 0xc02a8eff, REGISTRY_ARIN       }, // 192.42.133.0    - 192.42.142.255
	{ 0xc02a8f00, 0xc02a8fff, REGISTRY_RIPENCC    }, // 192.42.143.0    - 192.42.143.255
	{ 0xc02a9000, 0xc02a96ff, REGISTRY_ARIN       }, // 192.42.144.0    - 192.42.150.255
	{ 0xc02a9700, 0xc02a97ff, REGISTRY_APNIC      }, // 192.42.151.0    - 192.42.151.255
	{ 0xc02a9800, 0xc02ab3ff, REGISTRY_ARIN       }, // 192.42.152.0    - 192.42.179.255
	{ 0xc02ab400, 0xc02ac9ff, REGISTRY_RIPENCC    }, // 192.42.180.0    - 192.42.201.255
	{ 0xc02aca00, 0xc02aecff, REGISTRY_ARIN       }, // 192.42.202.0    - 192.42.236.255
	{ 0xc02aed00, 0xc02aedff, REGISTRY_APNIC      }, // 192.42.237.0    - 192.42.237.255
	{ 0xc02aee00, 0xc02afcff, REGISTRY_ARIN       }, // 192.42.238.0    - 192.42.252.255
	{ 0xc02afe00, 0xc02ba1ff, REGISTRY_ARIN       }, // 192.42.254.0    - 192.43.161.255
	{ 0xc02ba200, 0xc02babff, REGISTRY_RIPENCC    }, // 192.43.162.0    - 192.43.171.255
	{ 0xc02bac00, 0xc02badff, REGISTRY_ARIN       }, // 192.43.172.0    - 192.43.173.255
	{ 0xc02baf00, 0xc02bb8ff, REGISTRY_ARIN       }, // 192.43.175.0    - 192.43.184.255
	{ 0xc02bb900, 0xc02bb9ff, REGISTRY_APNIC      }, // 192.43.185.0    - 192.43.185.255
	{ 0xc02bba00, 0xc02bbcff, REGISTRY_ARIN       }, // 192.43.186.0    - 192.43.188.255
	{ 0xc02bbe00, 0xc02bbfff, REGISTRY_ARIN       }, // 192.43.190.0    - 192.43.191.255
	{ 0xc02bc000, 0xc02bc4ff, REGISTRY_RIPENCC    }, // 192.43.192.0    - 192.43.196.255
	{ 0xc02bc500, 0xc02bc5ff, REGISTRY_ARIN       }, // 192.43.197.0    - 192.43.197.255
	{ 0xc02bc600, 0xc02bc6ff, REGISTRY_APNIC      }, // 192.43.198.0    - 192.43.198.255
	{ 0xc02bc700, 0xc02bc8ff, REGISTRY_ARIN       }, // 192.43.199.0    - 192.43.200.255
	{ 0xc02bcb00, 0xc02bceff, REGISTRY_ARIN       }, // 192.43.203.0    - 192.43.206.255
	{ 0xc02bcf00, 0xc02bd1ff, REGISTRY_APNIC      }, // 192.43.207.0    - 192.43.209.255
	{ 0xc02bd200, 0xc02bd2ff, REGISTRY_RIPENCC    }, // 192.43.210.0    - 192.43.210.255
	{ 0xc02bd300, 0xc02bd3ff, REGISTRY_ARIN       }, // 192.43.211.0    - 192.43.211.255
	{ 0xc02bd400, 0xc02bd4ff, REGISTRY_RIPENCC    }, // 192.43.212.0    - 192.43.212.255
	{ 0xc02bd500, 0xc02be1ff, REGISTRY_ARIN       }, // 192.43.213.0    - 192.43.225.255
	{ 0xc02be200, 0xc02be5ff, REGISTRY_APNIC      }, // 192.43.226.0    - 192.43.229.255
	{ 0xc02be600, 0xc02be9ff, REGISTRY_ARIN       }, // 192.43.230.0    - 192.43.233.255
	{ 0xc02bea00, 0xc02beaff, REGISTRY_RIPENCC    }, // 192.43.234.0    - 192.43.234.255
	{ 0xc02beb00, 0xc02beeff, REGISTRY_ARIN       }, // 192.43.235.0    - 192.43.238.255
	{ 0xc02bef00, 0xc02befff, REGISTRY_APNIC      }, // 192.43.239.0    - 192.43.239.255
	{ 0xc02bf000, 0xc02bffff, REGISTRY_ARIN       }, // 192.43.240.0    - 192.43.255.255
	{ 0xc02c0000, 0xc02c43ff, REGISTRY_RIPENCC    }, // 192.44.0.0      - 192.44.67.255
	{ 0xc02c4400, 0xc02c46ff, REGISTRY_ARIN       }, // 192.44.68.0     - 192.44.70.255
	{ 0xc02c4700, 0xc02c5aff, REGISTRY_RIPENCC    }, // 192.44.71.0     - 192.44.90.255
	{ 0xc02c5b00, 0xc02cefff, REGISTRY_ARIN       }, // 192.44.91.0     - 192.44.239.255
	{ 0xc02cf000, 0xc02cfbff, REGISTRY_RIPENCC    }, // 192.44.240.0    - 192.44.251.255
	{ 0xc02cfc00, 0xc02effff, REGISTRY_ARIN       }, // 192.44.252.0    - 192.46.255.255
	{ 0xc02f0000, 0xc02f1bff, REGISTRY_APNIC      }, // 192.47.0.0      - 192.47.27.255
	{ 0xc02f1d00, 0xc02f23ff, REGISTRY_APNIC      }, // 192.47.29.0     - 192.47.35.255
	{ 0xc02f2500, 0xc02ff1ff, REGISTRY_APNIC      }, // 192.47.37.0     - 192.47.241.255
	{ 0xc02ff200, 0xc02ff3ff, REGISTRY_ARIN       }, // 192.47.242.0    - 192.47.243.255
	{ 0xc02ff400, 0xc02ff9ff, REGISTRY_RIPENCC    }, // 192.47.244.0    - 192.47.249.255
	{ 0xc02ffa00, 0xc0301eff, REGISTRY_ARIN       }, // 192.47.250.0    - 192.48.30.255
	{ 0xc0301f00, 0xc0301fff, REGISTRY_RIPENCC    }, // 192.48.31.0     - 192.48.31.255
	{ 0xc0302000, 0xc0306aff, REGISTRY_ARIN       }, // 192.48.32.0     - 192.48.106.255
	{ 0xc0306b00, 0xc0306bff, REGISTRY_RIPENCC    }, // 192.48.107.0    - 192.48.107.255
	{ 0xc0306c00, 0xc0306cff, REGISTRY_ARIN       }, // 192.48.108.0    - 192.48.108.255
	{ 0xc0306d00, 0xc0306eff, REGISTRY_APNIC      }, // 192.48.109.0    - 192.48.110.255
	{ 0xc0306f00, 0xc03090ff, REGISTRY_ARIN       }, // 192.48.111.0    - 192.48.144.255
	{ 0xc0309100, 0xc03091ff, REGISTRY_RIPENCC    }, // 192.48.145.0    - 192.48.145.255
	{ 0xc0309200, 0xc030dfff, REGISTRY_ARIN       }, // 192.48.146.0    - 192.48.223.255
	{ 0xc030e000, 0xc030e0ff, REGISTRY_RIPENCC    }, // 192.48.224.0    - 192.48.224.255
	{ 0xc030e100, 0xc030e6ff, REGISTRY_ARIN       }, // 192.48.225.0    - 192.48.230.255
	{ 0xc030e700, 0xc030e7ff, REGISTRY_RIPENCC    }, // 192.48.231.0    - 192.48.231.255
	{ 0xc030e800, 0xc030f7ff, REGISTRY_ARIN       }, // 192.48.232.0    - 192.48.247.255
	{ 0xc030f900, 0xc030fcff, REGISTRY_ARIN       }, // 192.48.249.0    - 192.48.252.255
	{ 0xc030fd00, 0xc030fdff, REGISTRY_AFRINIC    }, // 192.48.253.0    - 192.48.253.255
	{ 0xc030fe00, 0xc030ffff, REGISTRY_ARIN       }, // 192.48.254.0    - 192.48.255.255
	{ 0xc0310000, 0xc031ffff, REGISTRY_RIPENCC    }, // 192.49.0.0      - 192.49.255.255
	{ 0xc0320000, 0xc032ffff, REGISTRY_APNIC      }, // 192.50.0.0      - 192.50.255.255
	{ 0xc0330000, 0xc0330fff, REGISTRY_RIPENCC    }, // 192.51.0.0      - 192.51.15.255
	{ 0xc0331000, 0xc0332fff, REGISTRY_APNIC      }, // 192.51.16.0     - 192.51.47.255
	{ 0xc0333000, 0xc03330ff, REGISTRY_ARIN       }, // 192.51.48.0     - 192.51.48.255
	{ 0xc0333100, 0xc033abff, REGISTRY_APNIC      }, // 192.51.49.0     - 192.51.171.255
	{ 0xc033b000, 0xc033bfff, REGISTRY_APNIC      }, // 192.51.176.0    - 192.51.191.255
	{ 0xc033c000, 0xc033c1ff, REGISTRY_ARIN       }, // 192.51.192.0    - 192.51.193.255
	{ 0xc033c200, 0xc033efff, REGISTRY_APNIC      }, // 192.51.194.0    - 192.51.239.255
	{ 0xc033f100, 0xc033fdff, REGISTRY_APNIC      }, // 192.51.241.0    - 192.51.253.255
	{ 0xc033ff00, 0xc033ffff, REGISTRY_APNIC      }, // 192.51.255.0    - 192.51.255.255
	{ 0xc0340000, 0xc03432ff, REGISTRY_RIPENCC    }, // 192.52.0.0      - 192.52.50.255
	{ 0xc0343300, 0xc03447ff, REGISTRY_ARIN       }, // 192.52.51.0     - 192.52.71.255
	{ 0xc0344800, 0xc03449ff, REGISTRY_APNIC      }, // 192.52.72.0     - 192.52.73.255
	{ 0xc0344a00, 0xc03476ff, REGISTRY_ARIN       }, // 192.52.74.0     - 192.52.118.255
	{ 0xc0349700, 0xc03497ff, REGISTRY_ARIN       }, // 192.52.151.0    - 192.52.151.255
	{ 0xc0349800, 0xc03498ff, REGISTRY_RIPENCC    }, // 192.52.152.0    - 192.52.152.255
	{ 0xc0349900, 0xc0349eff, REGISTRY_ARIN       }, // 192.52.153.0    - 192.52.158.255
	{ 0xc0349f00, 0xc034a1ff, REGISTRY_RIPENCC    }, // 192.52.159.0    - 192.52.161.255
	{ 0xc034a200, 0xc034aaff, REGISTRY_ARIN       }, // 192.52.162.0    - 192.52.170.255
	{ 0xc034ab00, 0xc034b0ff, REGISTRY_APNIC      }, // 192.52.171.0    - 192.52.176.255
	{ 0xc034b100, 0xc034b8ff, REGISTRY_ARIN       }, // 192.52.177.0    - 192.52.184.255
	{ 0xc034ba00, 0xc034c0ff, REGISTRY_ARIN       }, // 192.52.186.0    - 192.52.192.255
	{ 0xc034c200, 0xc034c3ff, REGISTRY_ARIN       }, // 192.52.194.0    - 192.52.195.255
	{ 0xc034c600, 0xc034dcff, REGISTRY_ARIN       }, // 192.52.198.0    - 192.52.220.255
	{ 0xc034dd00, 0xc034dfff, REGISTRY_RIPENCC    }, // 192.52.221.0    - 192.52.223.255
	{ 0xc034e000, 0xc034e7ff, REGISTRY_ARIN       }, // 192.52.224.0    - 192.52.231.255
	{ 0xc034e800, 0xc034e8ff, REGISTRY_AFRINIC    }, // 192.52.232.0    - 192.52.232.255
	{ 0xc034e900, 0xc034fcff, REGISTRY_ARIN       }, // 192.52.233.0    - 192.52.252.255
	{ 0xc034fd00, 0xc034feff, REGISTRY_RIPENCC    }, // 192.52.253.0    - 192.52.254.255
	{ 0xc034ff00, 0xc03566ff, REGISTRY_ARIN       }, // 192.52.255.0    - 192.53.102.255
	{ 0xc0356700, 0xc03568ff, REGISTRY_RIPENCC    }, // 192.53.103.0    - 192.53.104.255
	{ 0xc0356900, 0xc0361eff, REGISTRY_ARIN       }, // 192.53.105.0    - 192.54.30.255
	{ 0xc0361f00, 0xc03634ff, REGISTRY_RIPENCC    }, // 192.54.31.0     - 192.54.52.255
	{ 0xc0363500, 0xc03635ff, REGISTRY_ARIN       }, // 192.54.53.0     - 192.54.53.255
	{ 0xc0363800, 0xc0363bff, REGISTRY_RIPENCC    }, // 192.54.56.0     - 192.54.59.255
	{ 0xc0363c00, 0xc03642ff, REGISTRY_RIPENCC    }, // 192.54.60.0     - 192.54.66.255
	{ 0xc0364300, 0xc03647ff, REGISTRY_RIPENCC    }, // 192.54.67.0     - 192.54.71.255
	{ 0xc0364800, 0xc0364bff, REGISTRY_RIPENCC    }, // 192.54.72.0     - 192.54.75.255
	{ 0xc0364e00, 0xc03650ff, REGISTRY_RIPENCC    }, // 192.54.78.0     - 192.54.80.255
	{ 0xc0365100, 0xc03667ff, REGISTRY_ARIN       }, // 192.54.81.0     - 192.54.103.255
	{ 0xc0366800, 0xc03668ff, REGISTRY_RIPENCC    }, // 192.54.104.0    - 192.54.104.255
	{ 0xc0366900, 0xc0366aff, REGISTRY_APNIC      }, // 192.54.105.0    - 192.54.106.255
	{ 0xc0366b00, 0xc03670ff, REGISTRY_ARIN       }, // 192.54.107.0    - 192.54.112.255
	{ 0xc0367100, 0xc03671ff, REGISTRY_RIPENCC    }, // 192.54.113.0    - 192.54.113.255
	{ 0xc0367200, 0xc03672ff, REGISTRY_ARIN       }, // 192.54.114.0    - 192.54.114.255
	{ 0xc0367300, 0xc03678ff, REGISTRY_RIPENCC    }, // 192.54.115.0    - 192.54.120.255
	{ 0xc0367900, 0xc03679ff, REGISTRY_ARIN       }, // 192.54.121.0    - 192.54.121.255
	{ 0xc0367a00, 0xc0367aff, REGISTRY_RIPENCC    }, // 192.54.122.0    - 192.54.122.255
	{ 0xc0367b00, 0xc0367cff, REGISTRY_ARIN       }, // 192.54.123.0    - 192.54.124.255
	{ 0xc0367d00, 0xc03680ff, REGISTRY_RIPENCC    }, // 192.54.125.0    - 192.54.128.255
	{ 0xc0368100, 0xc03681ff, REGISTRY_ARIN       }, // 192.54.129.0    - 192.54.129.255
	{ 0xc0368200, 0xc03682ff, REGISTRY_APNIC      }, // 192.54.130.0    - 192.54.130.255
	{ 0xc0368300, 0xc03683ff, REGISTRY_ARIN       }, // 192.54.131.0    - 192.54.131.255
	{ 0xc0368400, 0xc03684ff, REGISTRY_RIPENCC    }, // 192.54.132.0    - 192.54.132.255
	{ 0xc0368500, 0xc03686ff, REGISTRY_ARIN       }, // 192.54.133.0    - 192.54.134.255
	{ 0xc0368700, 0xc03687ff, REGISTRY_APNIC      }, // 192.54.135.0    - 192.54.135.255
	{ 0xc0368800, 0xc03688ff, REGISTRY_ARIN       }, // 192.54.136.0    - 192.54.136.255
	{ 0xc0368a00, 0xc0368aff, REGISTRY_ARIN       }, // 192.54.138.0    - 192.54.138.255
	{ 0xc0368b00, 0xc0368bff, REGISTRY_RIPENCC    }, // 192.54.139.0    - 192.54.139.255
	{ 0xc0368c00, 0xc0368cff, REGISTRY_ARIN       }, // 192.54.140.0    - 192.54.140.255
	{ 0xc0368d00, 0xc036b9ff, REGISTRY_RIPENCC    }, // 192.54.141.0    - 192.54.185.255
	{ 0xc036bc00, 0xc036ddff, REGISTRY_RIPENCC    }, // 192.54.188.0    - 192.54.221.255
	{ 0xc036de00, 0xc036e0ff, REGISTRY_ARIN       }, // 192.54.222.0    - 192.54.224.255
	{ 0xc036e100, 0xc036e1ff, REGISTRY_RIPENCC    }, // 192.54.225.0    - 192.54.225.255
	{ 0xc036e200, 0xc036f3ff, REGISTRY_ARIN       }, // 192.54.226.0    - 192.54.243.255
	{ 0xc036f500, 0xc036f5ff, REGISTRY_RIPENCC    }, // 192.54.245.0    - 192.54.245.255
	{ 0xc036f600, 0xc036f6ff, REGISTRY_ARIN       }, // 192.54.246.0    - 192.54.246.255
	{ 0xc036f800, 0xc036faff, REGISTRY_ARIN       }, // 192.54.248.0    - 192.54.250.255
	{ 0xc036fb00, 0xc036fbff, REGISTRY_APNIC      }, // 192.54.251.0    - 192.54.251.255
	{ 0xc036fc00, 0xc036fdff, REGISTRY_ARIN       }, // 192.54.252.0    - 192.54.253.255
	{ 0xc036fe00, 0xc036feff, REGISTRY_RIPENCC    }, // 192.54.254.0    - 192.54.254.255
	{ 0xc036ff00, 0xc0372dff, REGISTRY_ARIN       }, // 192.54.255.0    - 192.55.45.255
	{ 0xc0372e00, 0xc0372eff, REGISTRY_APNIC      }, // 192.55.46.0     - 192.55.46.255
	{ 0xc0372f00, 0xc03743ff, REGISTRY_ARIN       }, // 192.55.47.0     - 192.55.67.255
	{ 0xc0374400, 0xc03747ff, REGISTRY_APNIC      }, // 192.55.68.0     - 192.55.71.255
	{ 0xc0374800, 0xc03753ff, REGISTRY_ARIN       }, // 192.55.72.0     - 192.55.83.255
	{ 0xc0375400, 0xc03754ff, REGISTRY_RIPENCC    }, // 192.55.84.0     - 192.55.84.255
	{ 0xc0375500, 0xc03758ff, REGISTRY_ARIN       }, // 192.55.85.0     - 192.55.88.255
	{ 0xc0375900, 0xc03759ff, REGISTRY_RIPENCC    }, // 192.55.89.0     - 192.55.89.255
	{ 0xc0375a00, 0xc03761ff, REGISTRY_ARIN       }, // 192.55.90.0     - 192.55.97.255
	{ 0xc0376200, 0xc03763ff, REGISTRY_APNIC      }, // 192.55.98.0     - 192.55.99.255
	{ 0xc0376400, 0xc03764ff, REGISTRY_ARIN       }, // 192.55.100.0    - 192.55.100.255
	{ 0xc0376500, 0xc03765ff, REGISTRY_RIPENCC    }, // 192.55.101.0    - 192.55.101.255
	{ 0xc0376600, 0xc03768ff, REGISTRY_ARIN       }, // 192.55.102.0    - 192.55.104.255
	{ 0xc0376900, 0xc03769ff, REGISTRY_RIPENCC    }, // 192.55.105.0    - 192.55.105.255
	{ 0xc0376a00, 0xc0376cff, REGISTRY_ARIN       }, // 192.55.106.0    - 192.55.108.255
	{ 0xc0376d00, 0xc0376dff, REGISTRY_RIPENCC    }, // 192.55.109.0    - 192.55.109.255
	{ 0xc0376f00, 0xc0376fff, REGISTRY_ARIN       }, // 192.55.111.0    - 192.55.111.255
	{ 0xc0377000, 0xc03770ff, REGISTRY_APNIC      }, // 192.55.112.0    - 192.55.112.255
	{ 0xc0377100, 0xc03772ff, REGISTRY_ARIN       }, // 192.55.113.0    - 192.55.114.255
	{ 0xc0377300, 0xc03773ff, REGISTRY_RIPENCC    }, // 192.55.115.0    - 192.55.115.255
	{ 0xc0377400, 0xc03775ff, REGISTRY_ARIN       }, // 192.55.116.0    - 192.55.117.255
	{ 0xc0377600, 0xc03776ff, REGISTRY_APNIC      }, // 192.55.118.0    - 192.55.118.255
	{ 0xc0377700, 0xc03780ff, REGISTRY_ARIN       }, // 192.55.119.0    - 192.55.128.255
	{ 0xc0378100, 0xc03781ff, REGISTRY_RIPENCC    }, // 192.55.129.0    - 192.55.129.255
	{ 0xc0378200, 0xc03783ff, REGISTRY_ARIN       }, // 192.55.130.0    - 192.55.131.255
	{ 0xc0378400, 0xc03784ff, REGISTRY_RIPENCC    }, // 192.55.132.0    - 192.55.132.255
	{ 0xc0378500, 0xc037bbff, REGISTRY_ARIN       }, // 192.55.133.0    - 192.55.187.255
	{ 0xc037bc00, 0xc037bcff, REGISTRY_RIPENCC    }, // 192.55.188.0    - 192.55.188.255
	{ 0xc037bd00, 0xc037bdff, REGISTRY_ARIN       }, // 192.55.189.0    - 192.55.189.255
	{ 0xc037be00, 0xc037beff, REGISTRY_APNIC      }, // 192.55.190.0    - 192.55.190.255
	{ 0xc037bf00, 0xc037c0ff, REGISTRY_ARIN       }, // 192.55.191.0    - 192.55.192.255
	{ 0xc037c100, 0xc037c1ff, REGISTRY_RIPENCC    }, // 192.55.193.0    - 192.55.193.255
	{ 0xc037c200, 0xc037c4ff, REGISTRY_ARIN       }, // 192.55.194.0    - 192.55.196.255
	{ 0xc037c500, 0xc037c5ff, REGISTRY_RIPENCC    }, // 192.55.197.0    - 192.55.197.255
	{ 0xc037c600, 0xc037c6ff, REGISTRY_APNIC      }, // 192.55.198.0    - 192.55.198.255
	{ 0xc037c700, 0xc037d0ff, REGISTRY_ARIN       }, // 192.55.199.0    - 192.55.208.255
	{ 0xc037d200, 0xc037d3ff, REGISTRY_ARIN       }, // 192.55.210.0    - 192.55.211.255
	{ 0xc037d400, 0xc037d4ff, REGISTRY_RIPENCC    }, // 192.55.212.0    - 192.55.212.255
	{ 0xc037d500, 0xc037daff, REGISTRY_ARIN       }, // 192.55.213.0    - 192.55.218.255
	{ 0xc037db00, 0xc037dcff, REGISTRY_APNIC      }, // 192.55.219.0    - 192.55.220.255
	{ 0xc037dd00, 0xc037e7ff, REGISTRY_ARIN       }, // 192.55.221.0    - 192.55.231.255
	{ 0xc037e800, 0xc037e8ff, REGISTRY_APNIC      }, // 192.55.232.0    - 192.55.232.255
	{ 0xc037e900, 0xc037edff, REGISTRY_ARIN       }, // 192.55.233.0    - 192.55.237.255
	{ 0xc037ef00, 0xc037f3ff, REGISTRY_ARIN       }, // 192.55.239.0    - 192.55.243.255
	{ 0xc037f400, 0xc037f4ff, REGISTRY_RIPENCC    }, // 192.55.244.0    - 192.55.244.255
	{ 0xc037f500, 0xc03a08ff, REGISTRY_ARIN       }, // 192.55.245.0    - 192.58.8.255
	{ 0xc03a0900, 0xc03a12ff, REGISTRY_APNIC      }, // 192.58.9.0      - 192.58.18.255
	{ 0xc03a1300, 0xc03a1bff, REGISTRY_ARIN       }, // 192.58.19.0     - 192.58.27.255
	{ 0xc03a1c00, 0xc03a23ff, REGISTRY_RIPENCC    }, // 192.58.28.0     - 192.58.35.255
	{ 0xc03a2400, 0xc03a28ff, REGISTRY_ARIN       }, // 192.58.36.0     - 192.58.40.255
	{ 0xc03a2900, 0xc03a59ff, REGISTRY_RIPENCC    }, // 192.58.41.0     - 192.58.89.255
	{ 0xc03a5a00, 0xc03a60ff, REGISTRY_ARIN       }, // 192.58.90.0     - 192.58.96.255
	{ 0xc03a6600, 0xc03a84ff, REGISTRY_ARIN       }, // 192.58.102.0    - 192.58.132.255
	{ 0xc03a8500, 0xc03a88ff, REGISTRY_APNIC      }, // 192.58.133.0    - 192.58.136.255
	{ 0xc03a8900, 0xc03ac4ff, REGISTRY_ARIN       }, // 192.58.137.0    - 192.58.196.255
	{ 0xc03ac500, 0xc03ac5ff, REGISTRY_RIPENCC    }, // 192.58.197.0    - 192.58.197.255
	{ 0xc03ac600, 0xc03ad9ff, REGISTRY_ARIN       }, // 192.58.198.0    - 192.58.217.255
	{ 0xc03ada00, 0xc03adaff, REGISTRY_RIPENCC    }, // 192.58.218.0    - 192.58.218.255
	{ 0xc03adb00, 0xc03ae1ff, REGISTRY_ARIN       }, // 192.58.219.0    - 192.58.225.255
	{ 0xc03ae200, 0xc03ae5ff, REGISTRY_RIPENCC    }, // 192.58.226.0    - 192.58.229.255
	{ 0xc03ae600, 0xc0401bff, REGISTRY_ARIN       }, // 192.58.230.0    - 192.64.27.255
	{ 0xc0401c00, 0xc0401cff, REGISTRY_RIPENCC    }, // 192.64.28.0     - 192.64.28.255
	{ 0xc0401d00, 0xc0402bff, REGISTRY_ARIN       }, // 192.64.29.0     - 192.64.43.255
	{ 0xc0402c00, 0xc0402dff, REGISTRY_RIPENCC    }, // 192.64.44.0     - 192.64.45.255
	{ 0xc0402e00, 0xc04063ff, REGISTRY_ARIN       }, // 192.64.46.0     - 192.64.99.255
	{ 0xc0406400, 0xc04067ff, REGISTRY_RIPENCC    }, // 192.64.100.0    - 192.64.103.255
	{ 0xc0406800, 0xc0407cff, REGISTRY_ARIN       }, // 192.64.104.0    - 192.64.124.255
	{ 0xc0407e00, 0xc040c9ff, REGISTRY_ARIN       }, // 192.64.126.0    - 192.64.201.255
	{ 0xc040ca00, 0xc040caff, REGISTRY_RIPENCC    }, // 192.64.202.0    - 192.64.202.255
	{ 0xc040cb00, 0xc040ccff, REGISTRY_APNIC      }, // 192.64.203.0    - 192.64.204.255
	{ 0xc040cd00, 0xc04132ff, REGISTRY_ARIN       }, // 192.64.205.0    - 192.65.50.255
	{ 0xc0413300, 0xc04146ff, REGISTRY_RIPENCC    }, // 192.65.51.0     - 192.65.70.255
	{ 0xc0414700, 0xc04151ff, REGISTRY_ARIN       }, // 192.65.71.0     - 192.65.81.255
	{ 0xc0415200, 0xc0415bff, REGISTRY_APNIC      }, // 192.65.82.0     - 192.65.91.255
	{ 0xc0415c00, 0xc0415eff, REGISTRY_RIPENCC    }, // 192.65.92.0     - 192.65.94.255
	{ 0xc0415f00, 0xc0415fff, REGISTRY_ARIN       }, // 192.65.95.0     - 192.65.95.255
	{ 0xc0416000, 0xc04160ff, REGISTRY_RIPENCC    }, // 192.65.96.0     - 192.65.96.255
	{ 0xc0416100, 0xc04181ff, REGISTRY_ARIN       }, // 192.65.97.0     - 192.65.129.255
	{ 0xc0418200, 0xc04182ff, REGISTRY_APNIC      }, // 192.65.130.0    - 192.65.130.255
	{ 0xc0418300, 0xc04184ff, REGISTRY_RIPENCC    }, // 192.65.131.0    - 192.65.132.255
	{ 0xc0418500, 0xc0418aff, REGISTRY_ARIN       }, // 192.65.133.0    - 192.65.138.255
	{ 0xc0418b00, 0xc0418bff, REGISTRY_RIPENCC    }, // 192.65.139.0    - 192.65.139.255
	{ 0xc0418c00, 0xc0418fff, REGISTRY_ARIN       }, // 192.65.140.0    - 192.65.143.255
	{ 0xc0419000, 0xc04192ff, REGISTRY_RIPENCC    }, // 192.65.144.0    - 192.65.146.255
	{ 0xc0419300, 0xc04197ff, REGISTRY_ARIN       }, // 192.65.147.0    - 192.65.151.255
	{ 0xc0419800, 0xc04198ff, REGISTRY_LACNIC     }, // 192.65.152.0    - 192.65.152.255
	{ 0xc0419900, 0xc04199ff, REGISTRY_RIPENCC    }, // 192.65.153.0    - 192.65.153.255
	{ 0xc0419a00, 0xc041b5ff, REGISTRY_ARIN       }, // 192.65.154.0    - 192.65.181.255
	{ 0xc041b600, 0xc041b6ff, REGISTRY_APNIC      }, // 192.65.182.0    - 192.65.182.255
	{ 0xc041b700, 0xc041c5ff, REGISTRY_RIPENCC    }, // 192.65.183.0    - 192.65.197.255
	{ 0xc041c600, 0xc041d8ff, REGISTRY_ARIN       }, // 192.65.198.0    - 192.65.216.255
	{ 0xc041d900, 0xc041d9ff, REGISTRY_APNIC      }, // 192.65.217.0    - 192.65.217.255
	{ 0xc041da00, 0xc041daff, REGISTRY_ARIN       }, // 192.65.218.0    - 192.65.218.255
	{ 0xc041db00, 0xc041e4ff, REGISTRY_RIPENCC    }, // 192.65.219.0    - 192.65.228.255
	{ 0xc041e500, 0xc041f7ff, REGISTRY_ARIN       }, // 192.65.229.0    - 192.65.247.255
	{ 0xc041f900, 0xc041f9ff, REGISTRY_ARIN       }, // 192.65.249.0    - 192.65.249.255
	{ 0xc041fb00, 0xc041ffff, REGISTRY_ARIN       }, // 192.65.251.0    - 192.65.255.255
	{ 0xc0420000, 0xc042ffff, REGISTRY_RIPENCC    }, // 192.66.0.0      - 192.66.255.255
	{ 0xc0430000, 0xc04300ff, REGISTRY_ARIN       }, // 192.67.0.0      - 192.67.0.255
	{ 0xc0430200, 0xc04302ff, REGISTRY_ARIN       }, // 192.67.2.0      - 192.67.2.255
	{ 0xc0430300, 0xc04304ff, REGISTRY_RIPENCC    }, // 192.67.3.0      - 192.67.4.255
	{ 0xc0430500, 0xc0430bff, REGISTRY_ARIN       }, // 192.67.5.0      - 192.67.11.255
	{ 0xc0430c00, 0xc0430cff, REGISTRY_APNIC      }, // 192.67.12.0     - 192.67.12.255
	{ 0xc0430d00, 0xc04316ff, REGISTRY_ARIN       }, // 192.67.13.0     - 192.67.22.255
	{ 0xc0431700, 0xc04317ff, REGISTRY_LACNIC     }, // 192.67.23.0     - 192.67.23.255
	{ 0xc0431800, 0xc04326ff, REGISTRY_ARIN       }, // 192.67.24.0     - 192.67.38.255
	{ 0xc0432700, 0xc04327ff, REGISTRY_RIPENCC    }, // 192.67.39.0     - 192.67.39.255
	{ 0xc0432800, 0xc0432aff, REGISTRY_ARIN       }, // 192.67.40.0     - 192.67.42.255
	{ 0xc0432b00, 0xc0432bff, REGISTRY_RIPENCC    }, // 192.67.43.0     - 192.67.43.255
	{ 0xc0432c00, 0xc0432eff, REGISTRY_ARIN       }, // 192.67.44.0     - 192.67.46.255
	{ 0xc0432f00, 0xc0432fff, REGISTRY_RIPENCC    }, // 192.67.47.0     - 192.67.47.255
	{ 0xc0433000, 0xc04331ff, REGISTRY_ARIN       }, // 192.67.48.0     - 192.67.49.255
	{ 0xc0433200, 0xc04332ff, REGISTRY_RIPENCC    }, // 192.67.50.0     - 192.67.50.255
	{ 0xc0433300, 0xc04333ff, REGISTRY_ARIN       }, // 192.67.51.0     - 192.67.51.255
	{ 0xc0433400, 0xc04334ff, REGISTRY_RIPENCC    }, // 192.67.52.0     - 192.67.52.255
	{ 0xc0433500, 0xc04336ff, REGISTRY_ARIN       }, // 192.67.53.0     - 192.67.54.255
	{ 0xc0433700, 0xc04337ff, REGISTRY_RIPENCC    }, // 192.67.55.0     - 192.67.55.255
	{ 0xc0433800, 0xc04339ff, REGISTRY_ARIN       }, // 192.67.56.0     - 192.67.57.255
	{ 0xc0433a00, 0xc0433aff, REGISTRY_RIPENCC    }, // 192.67.58.0     - 192.67.58.255
	{ 0xc0433b00, 0xc0434bff, REGISTRY_ARIN       }, // 192.67.59.0     - 192.67.75.255
	{ 0xc0434c00, 0xc0434cff, REGISTRY_RIPENCC    }, // 192.67.76.0     - 192.67.76.255
	{ 0xc0434d00, 0xc0434eff, REGISTRY_ARIN       }, // 192.67.77.0     - 192.67.78.255
	{ 0xc0434f00, 0xc0434fff, REGISTRY_RIPENCC    }, // 192.67.79.0     - 192.67.79.255
	{ 0xc0435000, 0xc04353ff, REGISTRY_ARIN       }, // 192.67.80.0     - 192.67.83.255
	{ 0xc0435400, 0xc04354ff, REGISTRY_APNIC      }, // 192.67.84.0     - 192.67.84.255
	{ 0xc0435600, 0xc04356ff, REGISTRY_ARIN       }, // 192.67.86.0     - 192.67.86.255
	{ 0xc0435700, 0xc04357ff, REGISTRY_RIPENCC    }, // 192.67.87.0     - 192.67.87.255
	{ 0xc0435800, 0xc0435dff, REGISTRY_ARIN       }, // 192.67.88.0     - 192.67.93.255
	{ 0xc0435e00, 0xc0435eff, REGISTRY_RIPENCC    }, // 192.67.94.0     - 192.67.94.255
	{ 0xc0435f00, 0xc04363ff, REGISTRY_ARIN       }, // 192.67.95.0     - 192.67.99.255
	{ 0xc0436400, 0xc04368ff, REGISTRY_RIPENCC    }, // 192.67.100.0    - 192.67.104.255
	{ 0xc0436900, 0xc04386ff, REGISTRY_ARIN       }, // 192.67.105.0    - 192.67.134.255
	{ 0xc0438700, 0xc04387ff, REGISTRY_RIPENCC    }, // 192.67.135.0    - 192.67.135.255
	{ 0xc0438800, 0xc043a6ff, REGISTRY_ARIN       }, // 192.67.136.0    - 192.67.166.255
	{ 0xc043a700, 0xc043a7ff, REGISTRY_RIPENCC    }, // 192.67.167.0    - 192.67.167.255
	{ 0xc043a900, 0xc043a9ff, REGISTRY_ARIN       }, // 192.67.169.0    - 192.67.169.255
	{ 0xc043aa00, 0xc043aaff, REGISTRY_RIPENCC    }, // 192.67.170.0    - 192.67.170.255
	{ 0xc043ab00, 0xc043abff, REGISTRY_APNIC      }, // 192.67.171.0    - 192.67.171.255
	{ 0xc043ac00, 0xc043bcff, REGISTRY_ARIN       }, // 192.67.172.0    - 192.67.188.255
	{ 0xc043bd00, 0xc043c6ff, REGISTRY_RIPENCC    }, // 192.67.189.0    - 192.67.198.255
	{ 0xc043c800, 0xc043d0ff, REGISTRY_RIPENCC    }, // 192.67.200.0    - 192.67.208.255
	{ 0xc043d100, 0xc043d8ff, REGISTRY_ARIN       }, // 192.67.209.0    - 192.67.216.255
	{ 0xc043da00, 0xc043daff, REGISTRY_RIPENCC    }, // 192.67.218.0    - 192.67.218.255
	{ 0xc043db00, 0xc043dbff, REGISTRY_ARIN       }, // 192.67.219.0    - 192.67.219.255
	{ 0xc043dc00, 0xc043ddff, REGISTRY_RIPENCC    }, // 192.67.220.0    - 192.67.221.255
	{ 0xc043de00, 0xc043deff, REGISTRY_ARIN       }, // 192.67.222.0    - 192.67.222.255
	{ 0xc043df00, 0xc043dfff, REGISTRY_RIPENCC    }, // 192.67.223.0    - 192.67.223.255
	{ 0xc043e000, 0xc043f7ff, REGISTRY_ARIN       }, // 192.67.224.0    - 192.67.247.255
	{ 0xc043f800, 0xc043f8ff, REGISTRY_APNIC      }, // 192.67.248.0    - 192.67.248.255
	{ 0xc043f900, 0xc043f9ff, REGISTRY_RIPENCC    }, // 192.67.249.0    - 192.67.249.255
	{ 0xc043fa00, 0xc043ffff, REGISTRY_ARIN       }, // 192.67.250.0    - 192.67.255.255
	{ 0xc0440000, 0xc04413ff, REGISTRY_RIPENCC    }, // 192.68.0.0      - 192.68.19.255
	{ 0xc0441400, 0xc04416ff, REGISTRY_ARIN       }, // 192.68.20.0     - 192.68.22.255
	{ 0xc0441700, 0xc04417ff, REGISTRY_RIPENCC    }, // 192.68.23.0     - 192.68.23.255
	{ 0xc0441800, 0xc0441eff, REGISTRY_ARIN       }, // 192.68.24.0     - 192.68.30.255
	{ 0xc0441f00, 0xc04433ff, REGISTRY_RIPENCC    }, // 192.68.31.0     - 192.68.51.255
	{ 0xc0443400, 0xc0444bff, REGISTRY_ARIN       }, // 192.68.52.0     - 192.68.75.255
	{ 0xc0444c00, 0xc0446bff, REGISTRY_RIPENCC    }, // 192.68.76.0     - 192.68.107.255
	{ 0xc0446c00, 0xc0446dff, REGISTRY_ARIN       }, // 192.68.108.0    - 192.68.109.255
	{ 0xc0447000, 0xc04483ff, REGISTRY_ARIN       }, // 192.68.112.0    - 192.68.131.255
	{ 0xc0448400, 0xc04484ff, REGISTRY_APNIC      }, // 192.68.132.0    - 192.68.132.255
	{ 0xc0448500, 0xc04489ff, REGISTRY_ARIN       }, // 192.68.133.0    - 192.68.137.255
	{ 0xc0448a00, 0xc0448aff, REGISTRY_AFRINIC    }, // 192.68.138.0    - 192.68.138.255
	{ 0xc0448c00, 0xc04496ff, REGISTRY_ARIN       }, // 192.68.140.0    - 192.68.150.255
	{ 0xc0449700, 0xc04499ff, REGISTRY_RIPENCC    }, // 192.68.151.0    - 192.68.153.255
	{ 0xc0449a00, 0xc044a4ff, REGISTRY_ARIN       }, // 192.68.154.0    - 192.68.164.255
	{ 0xc044a500, 0xc044aaff, REGISTRY_RIPENCC    }, // 192.68.165.0    - 192.68.170.255
	{ 0xc044ab00, 0xc044acff, REGISTRY_APNIC      }, // 192.68.171.0    - 192.68.172.255
	{ 0xc044ad00, 0xc044adff, REGISTRY_ARIN       }, // 192.68.173.0    - 192.68.173.255
	{ 0xc044ae00, 0xc044aeff, REGISTRY_RIPENCC    }, // 192.68.174.0    - 192.68.174.255
	{ 0xc044af00, 0xc044afff, REGISTRY_ARIN       }, // 192.68.175.0    - 192.68.175.255
	{ 0xc044b000, 0xc044b0ff, REGISTRY_RIPENCC    }, // 192.68.176.0    - 192.68.176.255
	{ 0xc044b100, 0xc044b2ff, REGISTRY_ARIN       }, // 192.68.177.0    - 192.68.178.255
	{ 0xc044b400, 0xc044b5ff, REGISTRY_ARIN       }, // 192.68.180.0    - 192.68.181.255
	{ 0xc044b600, 0xc044b6ff, REGISTRY_RIPENCC    }, // 192.68.182.0    - 192.68.182.255
	{ 0xc044b700, 0xc044b8ff, REGISTRY_ARIN       }, // 192.68.183.0    - 192.68.184.255
	{ 0xc044b900, 0xc044b9ff, REGISTRY_LACNIC     }, // 192.68.185.0    - 192.68.185.255
	{ 0xc044ba00, 0xc044baff, REGISTRY_RIPENCC    }, // 192.68.186.0    - 192.68.186.255
	{ 0xc044bb00, 0xc044d0ff, REGISTRY_ARIN       }, // 192.68.187.0    - 192.68.208.255
	{ 0xc044d100, 0xc044d1ff, REGISTRY_RIPENCC    }, // 192.68.209.0    - 192.68.209.255
	{ 0xc044d200, 0xc044d2ff, REGISTRY_ARIN       }, // 192.68.210.0    - 192.68.210.255
	{ 0xc044d300, 0xc044d8ff, REGISTRY_RIPENCC    }, // 192.68.211.0    - 192.68.216.255
	{ 0xc044d900, 0xc044dcff, REGISTRY_ARIN       }, // 192.68.217.0    - 192.68.220.255
	{ 0xc044dd00, 0xc044ddff, REGISTRY_RIPENCC    }, // 192.68.221.0    - 192.68.221.255
	{ 0xc044de00, 0xc044dfff, REGISTRY_ARIN       }, // 192.68.222.0    - 192.68.223.255
	{ 0xc044e000, 0xc044e0ff, REGISTRY_RIPENCC    }, // 192.68.224.0    - 192.68.224.255
	{ 0xc044e100, 0xc044e5ff, REGISTRY_ARIN       }, // 192.68.225.0    - 192.68.229.255
	{ 0xc044e600, 0xc044e6ff, REGISTRY_RIPENCC    }, // 192.68.230.0    - 192.68.230.255
	{ 0xc044e700, 0xc044eaff, REGISTRY_ARIN       }, // 192.68.231.0    - 192.68.234.255
	{ 0xc044eb00, 0xc044f9ff, REGISTRY_APNIC      }, // 192.68.235.0    - 192.68.249.255
	{ 0xc044fa00, 0xc044fcff, REGISTRY_RIPENCC    }, // 192.68.250.0    - 192.68.252.255
	{ 0xc044fd00, 0xc044fdff, REGISTRY_ARIN       }, // 192.68.253.0    - 192.68.253.255
	{ 0xc044fe00, 0xc044feff, REGISTRY_RIPENCC    }, // 192.68.254.0    - 192.68.254.255
	{ 0xc044ff00, 0xc045ffff, REGISTRY_ARIN       }, // 192.68.255.0    - 192.69.255.255
	{ 0xc0460000, 0xc04677ff, REGISTRY_RIPENCC    }, // 192.70.0.0      - 192.70.119.255
	{ 0xc0467800, 0xc04684ff, REGISTRY_ARIN       }, // 192.70.120.0    - 192.70.132.255
	{ 0xc0468500, 0xc04686ff, REGISTRY_RIPENCC    }, // 192.70.133.0    - 192.70.134.255
	{ 0xc0468700, 0xc04687ff, REGISTRY_APNIC      }, // 192.70.135.0    - 192.70.135.255
	{ 0xc0468800, 0xc04688ff, REGISTRY_RIPENCC    }, // 192.70.136.0    - 192.70.136.255
	{ 0xc0468900, 0xc0468bff, REGISTRY_ARIN       }, // 192.70.137.0    - 192.70.139.255
	{ 0xc0468c00, 0xc0469fff, REGISTRY_RIPENCC    }, // 192.70.140.0    - 192.70.159.255
	{ 0xc046a000, 0xc046adff, REGISTRY_ARIN       }, // 192.70.160.0    - 192.70.173.255
	{ 0xc046ae00, 0xc046aeff, REGISTRY_APNIC      }, // 192.70.174.0    - 192.70.174.255
	{ 0xc046af00, 0xc046b2ff, REGISTRY_ARIN       }, // 192.70.175.0    - 192.70.178.255
	{ 0xc046b300, 0xc046b5ff, REGISTRY_APNIC      }, // 192.70.179.0    - 192.70.181.255
	{ 0xc046b800, 0xc046bfff, REGISTRY_ARIN       }, // 192.70.184.0    - 192.70.191.255
	{ 0xc046c000, 0xc046c7ff, REGISTRY_RIPENCC    }, // 192.70.192.0    - 192.70.199.255
	{ 0xc046c800, 0xc046c8ff, REGISTRY_AFRINIC    }, // 192.70.200.0    - 192.70.200.255
	{ 0xc046ca00, 0xc046d7ff, REGISTRY_ARIN       }, // 192.70.202.0    - 192.70.215.255
	{ 0xc046d800, 0xc046d8ff, REGISTRY_APNIC      }, // 192.70.216.0    - 192.70.216.255
	{ 0xc046d900, 0xc046daff, REGISTRY_ARIN       }, // 192.70.217.0    - 192.70.218.255
	{ 0xc046db00, 0xc046dbff, REGISTRY_APNIC      }, // 192.70.219.0    - 192.70.219.255
	{ 0xc046dc00, 0xc046ecff, REGISTRY_ARIN       }, // 192.70.220.0    - 192.70.236.255
	{ 0xc046ed00, 0xc046edff, REGISTRY_AFRINIC    }, // 192.70.237.0    - 192.70.237.255
	{ 0xc046ee00, 0xc046f1ff, REGISTRY_ARIN       }, // 192.70.238.0    - 192.70.241.255
	{ 0xc046f200, 0xc046f2ff, REGISTRY_RIPENCC    }, // 192.70.242.0    - 192.70.242.255
	{ 0xc046f300, 0xc046ffff, REGISTRY_ARIN       }, // 192.70.243.0    - 192.70.255.255
	{ 0xc0470000, 0xc047ffff, REGISTRY_RIPENCC    }, // 192.71.0.0      - 192.71.255.255
	{ 0xc0480000, 0xc04802ff, REGISTRY_ARIN       }, // 192.72.0.0      - 192.72.2.255
	{ 0xc0480300, 0xc048fcff, REGISTRY_APNIC      }, // 192.72.3.0      - 192.72.252.255
	{ 0xc048fd00, 0xc0490bff, REGISTRY_ARIN       }, // 192.72.253.0    - 192.73.11.255
	{ 0xc0490c00, 0xc0490cff, REGISTRY_APNIC      }, // 192.73.12.0     - 192.73.12.255
	{ 0xc0490d00, 0xc04912ff, REGISTRY_ARIN       }, // 192.73.13.0     - 192.73.18.255
	{ 0xc0491300, 0xc04914ff, REGISTRY_RIPENCC    }, // 192.73.19.0     - 192.73.20.255
	{ 0xc0491500, 0xc04916ff, REGISTRY_APNIC      }, // 192.73.21.0     - 192.73.22.255
	{ 0xc0491700, 0xc04917ff, REGISTRY_ARIN       }, // 192.73.23.0     - 192.73.23.255
	{ 0xc0491800, 0xc04919ff, REGISTRY_APNIC      }, // 192.73.24.0     - 192.73.25.255
	{ 0xc0491a00, 0xc04921ff, REGISTRY_ARIN       }, // 192.73.26.0     - 192.73.33.255
	{ 0xc0492200, 0xc0492cff, REGISTRY_RIPENCC    }, // 192.73.34.0     - 192.73.44.255
	{ 0xc0492d00, 0xc04941ff, REGISTRY_ARIN       }, // 192.73.45.0     - 192.73.65.255
	{ 0xc0494200, 0xc04942ff, REGISTRY_APNIC      }, // 192.73.66.0     - 192.73.66.255
	{ 0xc0494300, 0xc049e1ff, REGISTRY_ARIN       }, // 192.73.67.0     - 192.73.225.255
	{ 0xc049e200, 0xc049e2ff, REGISTRY_RIPENCC    }, // 192.73.226.0    - 192.73.226.255
	{ 0xc049e300, 0xc049e4ff, REGISTRY_ARIN       }, // 192.73.227.0    - 192.73.228.255
	{ 0xc049e500, 0xc049e5ff, REGISTRY_RIPENCC    }, // 192.73.229.0    - 192.73.229.255
	{ 0xc049e600, 0xc04a8aff, REGISTRY_ARIN       }, // 192.73.230.0    - 192.74.138.255
	{ 0xc04a8b00, 0xc04ad0ff, REGISTRY_APNIC      }, // 192.74.139.0    - 192.74.208.255
	{ 0xc04ad100, 0xc04b03ff, REGISTRY_ARIN       }, // 192.74.209.0    - 192.75.3.255
	{ 0xc04b0400, 0xc04b04ff, REGISTRY_LACNIC     }, // 192.75.4.0      - 192.75.4.255
	{ 0xc04b0500, 0xc04b88ff, REGISTRY_ARIN       }, // 192.75.5.0      - 192.75.136.255
	{ 0xc04b8900, 0xc04b89ff, REGISTRY_APNIC      }, // 192.75.137.0    - 192.75.137.255
	{ 0xc04b8a00, 0xc04bebff, REGISTRY_ARIN       }, // 192.75.138.0    - 192.75.235.255
	{ 0xc04bed00, 0xc04c05ff, REGISTRY_ARIN       }, // 192.75.237.0    - 192.76.5.255
	{ 0xc04c0600, 0xc04c23ff, REGISTRY_RIPENCC    }, // 192.76.6.0      - 192.76.35.255
	{ 0xc04c2400, 0xc04c79ff, REGISTRY_ARIN       }, // 192.76.36.0     - 192.76.121.255
	{ 0xc04c7a00, 0xc04c7aff, REGISTRY_APNIC      }, // 192.76.122.0    - 192.76.122.255
	{ 0xc04c7b00, 0xc04c84ff, REGISTRY_RIPENCC    }, // 192.76.123.0    - 192.76.132.255
	{ 0xc04c8500, 0xc04c85ff, REGISTRY_ARIN       }, // 192.76.133.0    - 192.76.133.255
	{ 0xc04c8600, 0xc04c94ff, REGISTRY_RIPENCC    }, // 192.76.134.0    - 192.76.148.255
	{ 0xc04c9700, 0xc04c98ff, REGISTRY_RIPENCC    }, // 192.76.151.0    - 192.76.152.255
	{ 0xc04c9a00, 0xc04c9fff, REGISTRY_RIPENCC    }, // 192.76.154.0    - 192.76.159.255
	{ 0xc04ca100, 0xc04ca2ff, REGISTRY_RIPENCC    }, // 192.76.161.0    - 192.76.162.255
	{ 0xc04ca500, 0xc04caaff, REGISTRY_RIPENCC    }, // 192.76.165.0    - 192.76.170.255
	{ 0xc04cac00, 0xc04cacff, REGISTRY_RIPENCC    }, // 192.76.172.0    - 192.76.172.255
	{ 0xc04cad00, 0xc04cafff, REGISTRY_ARIN       }, // 192.76.173.0    - 192.76.175.255
	{ 0xc04cb000, 0xc04cb0ff, REGISTRY_RIPENCC    }, // 192.76.176.0    - 192.76.176.255
	{ 0xc04cb100, 0xc04cf0ff, REGISTRY_ARIN       }, // 192.76.177.0    - 192.76.240.255
	{ 0xc04cf100, 0xc04cf8ff, REGISTRY_RIPENCC    }, // 192.76.241.0    - 192.76.248.255
	{ 0xc04cf900, 0xc04cfbff, REGISTRY_ARIN       }, // 192.76.249.0    - 192.76.251.255
	{ 0xc04cff00, 0xc04d07ff, REGISTRY_ARIN       }, // 192.76.255.0    - 192.77.7.255
	{ 0xc04d0900, 0xc04d0aff, REGISTRY_ARIN       }, // 192.77.9.0      - 192.77.10.255
	{ 0xc04d0b00, 0xc04d0bff, REGISTRY_RIPENCC    }, // 192.77.11.0     - 192.77.11.255
	{ 0xc04d0c00, 0xc04d10ff, REGISTRY_ARIN       }, // 192.77.12.0     - 192.77.16.255
	{ 0xc04d1200, 0xc04d71ff, REGISTRY_ARIN       }, // 192.77.18.0     - 192.77.113.255
	{ 0xc04d7200, 0xc04d73ff, REGISTRY_RIPENCC    }, // 192.77.114.0    - 192.77.115.255
	{ 0xc04d7400, 0xc04d77ff, REGISTRY_ARIN       }, // 192.77.116.0    - 192.77.119.255
	{ 0xc04d7800, 0xc04d7bff, REGISTRY_RIPENCC    }, // 192.77.120.0    - 192.77.123.255
	{ 0xc04d7c00, 0xc04d83ff, REGISTRY_ARIN       }, // 192.77.124.0    - 192.77.131.255
	{ 0xc04d8400, 0xc04d8aff, REGISTRY_RIPENCC    }, // 192.77.132.0    - 192.77.138.255
	{ 0xc04d8b00, 0xc04d8bff, REGISTRY_ARIN       }, // 192.77.139.0    - 192.77.139.255
	{ 0xc04d8c00, 0xc04d8dff, REGISTRY_RIPENCC    }, // 192.77.140.0    - 192.77.141.255
	{ 0xc04d8e00, 0xc05013ff, REGISTRY_ARIN       }, // 192.77.142.0    - 192.80.19.255
	{ 0xc0501400, 0xc05015ff, REGISTRY_RIPENCC    }, // 192.80.20.0     - 192.80.21.255
	{ 0xc0501600, 0xc05017ff, REGISTRY_ARIN       }, // 192.80.22.0     - 192.80.23.255
	{ 0xc0501800, 0xc05018ff, REGISTRY_LACNIC     }, // 192.80.24.0     - 192.80.24.255
	{ 0xc0501900, 0xc0501eff, REGISTRY_ARIN       }, // 192.80.25.0     - 192.80.30.255
	{ 0xc0501f00, 0xc0502aff, REGISTRY_RIPENCC    }, // 192.80.31.0     - 192.80.42.255
	{ 0xc0502b00, 0xc0502dff, REGISTRY_ARIN       }, // 192.80.43.0     - 192.80.45.255
	{ 0xc0502e00, 0xc0502eff, REGISTRY_RIPENCC    }, // 192.80.46.0     - 192.80.46.255
	{ 0xc0502f00, 0xc05032ff, REGISTRY_ARIN       }, // 192.80.47.0     - 192.80.50.255
	{ 0xc0503300, 0xc05033ff, REGISTRY_RIPENCC    }, // 192.80.51.0     - 192.80.51.255
	{ 0xc0503400, 0xc050d0ff, REGISTRY_ARIN       }, // 192.80.52.0     - 192.80.208.255
	{ 0xc050d100, 0xc050d1ff, REGISTRY_LACNIC     }, // 192.80.209.0    - 192.80.209.255
	{ 0xc050d200, 0xc0513aff, REGISTRY_ARIN       }, // 192.80.210.0    - 192.81.58.255
	{ 0xc0513b00, 0xc0513bff, REGISTRY_RIPENCC    }, // 192.81.59.0     - 192.81.59.255
	{ 0xc0513c00, 0xc0513cff, REGISTRY_ARIN       }, // 192.81.60.0     - 192.81.60.255
	{ 0xc0513d00, 0xc0513eff, REGISTRY_RIPENCC    }, // 192.81.61.0     - 192.81.62.255
	{ 0xc0513f00, 0xc0516cff, REGISTRY_ARIN       }, // 192.81.63.0     - 192.81.108.255
	{ 0xc0516d00, 0xc0516dff, REGISTRY_RIPENCC    }, // 192.81.109.0    - 192.81.109.255
	{ 0xc0516e00, 0xc05178ff, REGISTRY_ARIN       }, // 192.81.110.0    - 192.81.120.255
	{ 0xc0517900, 0xc05179ff, REGISTRY_RIPENCC    }, // 192.81.121.0    - 192.81.121.255
	{ 0xc0517a00, 0xc0517aff, REGISTRY_ARIN       }, // 192.81.122.0    - 192.81.122.255
	{ 0xc0517b00, 0xc0517bff, REGISTRY_RIPENCC    }, // 192.81.123.0    - 192.81.123.255
	{ 0xc0517c00, 0xc0519fff, REGISTRY_ARIN       }, // 192.81.124.0    - 192.81.159.255
	{ 0xc051a000, 0xc051a0ff, REGISTRY_RIPENCC    }, // 192.81.160.0    - 192.81.160.255
	{ 0xc051a100, 0xc051b5ff, REGISTRY_ARIN       }, // 192.81.161.0    - 192.81.181.255
	{ 0xc051b600, 0xc051b8ff, REGISTRY_RIPENCC    }, // 192.81.182.0    - 192.81.184.255
	{ 0xc051b900, 0xc051c1ff, REGISTRY_ARIN       }, // 192.81.185.0    - 192.81.193.255
	{ 0xc051c200, 0xc051c2ff, REGISTRY_RIPENCC    }, // 192.81.194.0    - 192.81.194.255
	{ 0xc051c300, 0xc051e5ff, REGISTRY_ARIN       }, // 192.81.195.0    - 192.81.229.255
	{ 0xc051e600, 0xc051e6ff, REGISTRY_RIPENCC    }, // 192.81.230.0    - 192.81.230.255
	{ 0xc051e700, 0xc051e9ff, REGISTRY_ARIN       }, // 192.81.231.0    - 192.81.233.255
	{ 0xc051ea00, 0xc051eaff, REGISTRY_RIPENCC    }, // 192.81.234.0    - 192.81.234.255
	{ 0xc051eb00, 0xc05233ff, REGISTRY_ARIN       }, // 192.81.235.0    - 192.82.51.255
	{ 0xc0523400, 0xc0525fff, REGISTRY_APNIC      }, // 192.82.52.0     - 192.82.95.255
	{ 0xc0526000, 0xc05263ff, REGISTRY_ARIN       }, // 192.82.96.0     - 192.82.99.255
	{ 0xc0526400, 0xc05264ff, REGISTRY_APNIC      }, // 192.82.100.0    - 192.82.100.255
	{ 0xc0526500, 0xc05278ff, REGISTRY_ARIN       }, // 192.82.101.0    - 192.82.120.255
	{ 0xc0527900, 0xc05279ff, REGISTRY_RIPENCC    }, // 192.82.121.0    - 192.82.121.255
	{ 0xc0527a00, 0xc0527bff, REGISTRY_ARIN       }, // 192.82.122.0    - 192.82.123.255
	{ 0xc0527c00, 0xc0527cff, REGISTRY_RIPENCC    }, // 192.82.124.0    - 192.82.124.255
	{ 0xc0527d00, 0xc0527eff, REGISTRY_ARIN       }, // 192.82.125.0    - 192.82.126.255
	{ 0xc0527f00, 0xc0527fff, REGISTRY_RIPENCC    }, // 192.82.127.0    - 192.82.127.255
	{ 0xc0528000, 0xc05283ff, REGISTRY_ARIN       }, // 192.82.128.0    - 192.82.131.255
	{ 0xc0528500, 0xc0528bff, REGISTRY_ARIN       }, // 192.82.133.0    - 192.82.139.255
	{ 0xc0528c00, 0xc0528cff, REGISTRY_APNIC      }, // 192.82.140.0    - 192.82.140.255
	{ 0xc0528d00, 0xc0528dff, REGISTRY_ARIN       }, // 192.82.141.0    - 192.82.141.255
	{ 0xc0528e00, 0xc0528eff, REGISTRY_AFRINIC    }, // 192.82.142.0    - 192.82.142.255
	{ 0xc0528f00, 0xc0528fff, REGISTRY_APNIC      }, // 192.82.143.0    - 192.82.143.255
	{ 0xc0529000, 0xc05298ff, REGISTRY_ARIN       }, // 192.82.144.0    - 192.82.152.255
	{ 0xc0529900, 0xc05299ff, REGISTRY_RIPENCC    }, // 192.82.153.0    - 192.82.153.255
	{ 0xc0529a00, 0xc0529cff, REGISTRY_ARIN       }, // 192.82.154.0    - 192.82.156.255
	{ 0xc0529d00, 0xc0529eff, REGISTRY_RIPENCC    }, // 192.82.157.0    - 192.82.158.255
	{ 0xc0529f00, 0xc052a0ff, REGISTRY_ARIN       }, // 192.82.159.0    - 192.82.160.255
	{ 0xc052a100, 0xc052a1ff, REGISTRY_APNIC      }, // 192.82.161.0    - 192.82.161.255
	{ 0xc052a200, 0xc052d5ff, REGISTRY_ARIN       }, // 192.82.162.0    - 192.82.213.255
	{ 0xc052d600, 0xc052d6ff, REGISTRY_RIPENCC    }, // 192.82.214.0    - 192.82.214.255
	{ 0xc052d700, 0xc052dbff, REGISTRY_ARIN       }, // 192.82.215.0    - 192.82.219.255
	{ 0xc052dc00, 0xc052ddff, REGISTRY_RIPENCC    }, // 192.82.220.0    - 192.82.221.255
	{ 0xc052de00, 0xc052deff, REGISTRY_APNIC      }, // 192.82.222.0    - 192.82.222.255
	{ 0xc052df00, 0xc052e5ff, REGISTRY_ARIN       }, // 192.82.223.0    - 192.82.229.255
	{ 0xc052e700, 0xc052f0ff, REGISTRY_ARIN       }, // 192.82.231.0    - 192.82.240.255
	{ 0xc052f100, 0xc052f1ff, REGISTRY_RIPENCC    }, // 192.82.241.0    - 192.82.241.255
	{ 0xc052f200, 0xc052ffff, REGISTRY_ARIN       }, // 192.82.242.0    - 192.82.255.255
	{ 0xc0530000, 0xc05364ff, REGISTRY_RIPENCC    }, // 192.83.0.0      - 192.83.100.255
	{ 0xc0536500, 0xc05365ff, REGISTRY_ARIN       }, // 192.83.101.0    - 192.83.101.255
	{ 0xc0536600, 0xc05366ff, REGISTRY_RIPENCC    }, // 192.83.102.0    - 192.83.102.255
	{ 0xc0536700, 0xc05367ff, REGISTRY_ARIN       }, // 192.83.103.0    - 192.83.103.255
	{ 0xc0536900, 0xc05375ff, REGISTRY_ARIN       }, // 192.83.105.0    - 192.83.117.255
	{ 0xc0537600, 0xc05377ff, REGISTRY_APNIC      }, // 192.83.118.0    - 192.83.119.255
	{ 0xc0537800, 0xc05379ff, REGISTRY_ARIN       }, // 192.83.120.0    - 192.83.121.255
	{ 0xc0537b00, 0xc0537bff, REGISTRY_APNIC      }, // 192.83.123.0    - 192.83.123.255
	{ 0xc0537c00, 0xc0539cff, REGISTRY_ARIN       }, // 192.83.124.0    - 192.83.156.255
	{ 0xc0539e00, 0xc0539fff, REGISTRY_ARIN       }, // 192.83.158.0    - 192.83.159.255
	{ 0xc053a000, 0xc053a0ff, REGISTRY_RIPENCC    }, // 192.83.160.0    - 192.83.160.255
	{ 0xc053a100, 0xc053a4ff, REGISTRY_ARIN       }, // 192.83.161.0    - 192.83.164.255
	{ 0xc053a500, 0xc053a5ff, REGISTRY_RIPENCC    }, // 192.83.165.0    - 192.83.165.255
	{ 0xc053a600, 0xc053c4ff, REGISTRY_APNIC      }, // 192.83.166.0    - 192.83.196.255
	{ 0xc053c500, 0xc053c5ff, REGISTRY_ARIN       }, // 192.83.197.0    - 192.83.197.255
	{ 0xc053c600, 0xc053c6ff, REGISTRY_APNIC      }, // 192.83.198.0    - 192.83.198.255
	{ 0xc053c700, 0xc053c7ff, REGISTRY_ARIN       }, // 192.83.199.0    - 192.83.199.255
	{ 0xc053c800, 0xc053c8ff, REGISTRY_RIPENCC    }, // 192.83.200.0    - 192.83.200.255
	{ 0xc053c900, 0xc053c9ff, REGISTRY_ARIN       }, // 192.83.201.0    - 192.83.201.255
	{ 0xc053ca00, 0xc053caff, REGISTRY_RIPENCC    }, // 192.83.202.0    - 192.83.202.255
	{ 0xc053cb00, 0xc053ceff, REGISTRY_ARIN       }, // 192.83.203.0    - 192.83.206.255
	{ 0xc053cf00, 0xc053cfff, REGISTRY_LACNIC     }, // 192.83.207.0    - 192.83.207.255
	{ 0xc053d000, 0xc053d7ff, REGISTRY_AFRINIC    }, // 192.83.208.0    - 192.83.215.255
	{ 0xc053da00, 0xc053dbff, REGISTRY_APNIC      }, // 192.83.218.0    - 192.83.219.255
	{ 0xc053dc00, 0xc053deff, REGISTRY_ARIN       }, // 192.83.220.0    - 192.83.222.255
	{ 0xc053df00, 0xc053dfff, REGISTRY_RIPENCC    }, // 192.83.223.0    - 192.83.223.255
	{ 0xc053e000, 0xc053e0ff, REGISTRY_APNIC      }, // 192.83.224.0    - 192.83.224.255
	{ 0xc053e100, 0xc053e4ff, REGISTRY_ARIN       }, // 192.83.225.0    - 192.83.228.255
	{ 0xc053e500, 0xc053e6ff, REGISTRY_RIPENCC    }, // 192.83.229.0    - 192.83.230.255
	{ 0xc053e700, 0xc053e7ff, REGISTRY_APNIC      }, // 192.83.231.0    - 192.83.231.255
	{ 0xc053e800, 0xc053ecff, REGISTRY_ARIN       }, // 192.83.232.0    - 192.83.236.255
	{ 0xc053ed00, 0xc053eeff, REGISTRY_APNIC      }, // 192.83.237.0    - 192.83.238.255
	{ 0xc053ef00, 0xc05404ff, REGISTRY_ARIN       }, // 192.83.239.0    - 192.84.4.255
	{ 0xc0540500, 0xc05405ff, REGISTRY_RIPENCC    }, // 192.84.5.0      - 192.84.5.255
	{ 0xc0540600, 0xc0540bff, REGISTRY_ARIN       }, // 192.84.6.0      - 192.84.11.255
	{ 0xc0540c00, 0xc0540cff, REGISTRY_LACNIC     }, // 192.84.12.0     - 192.84.12.255
	{ 0xc0540d00, 0xc0540dff, REGISTRY_RIPENCC    }, // 192.84.13.0     - 192.84.13.255
	{ 0xc0540e00, 0xc0540eff, REGISTRY_ARIN       }, // 192.84.14.0     - 192.84.14.255
	{ 0xc0540f00, 0xc0540fff, REGISTRY_RIPENCC    }, // 192.84.15.0     - 192.84.15.255
	{ 0xc0541000, 0xc0541aff, REGISTRY_ARIN       }, // 192.84.16.0     - 192.84.26.255
	{ 0xc0541b00, 0xc0541bff, REGISTRY_RIPENCC    }, // 192.84.27.0     - 192.84.27.255
	{ 0xc0541c00, 0xc0541dff, REGISTRY_ARIN       }, // 192.84.28.0     - 192.84.29.255
	{ 0xc0541e00, 0xc0541eff, REGISTRY_RIPENCC    }, // 192.84.30.0     - 192.84.30.255
	{ 0xc0541f00, 0xc0541fff, REGISTRY_ARIN       }, // 192.84.31.0     - 192.84.31.255
	{ 0xc0542000, 0xc05421ff, REGISTRY_RIPENCC    }, // 192.84.32.0     - 192.84.33.255
	{ 0xc0542200, 0xc0543dff, REGISTRY_ARIN       }, // 192.84.34.0     - 192.84.61.255
	{ 0xc0543e00, 0xc0543eff, REGISTRY_RIPENCC    }, // 192.84.62.0     - 192.84.62.255
	{ 0xc0543f00, 0xc05446ff, REGISTRY_ARIN       }, // 192.84.63.0     - 192.84.70.255
	{ 0xc0544a00, 0xc0544aff, REGISTRY_ARIN       }, // 192.84.74.0     - 192.84.74.255
	{ 0xc0544b00, 0xc05454ff, REGISTRY_RIPENCC    }, // 192.84.75.0     - 192.84.84.255
	{ 0xc0545500, 0xc05456ff, REGISTRY_ARIN       }, // 192.84.85.0     - 192.84.86.255
	{ 0xc0545700, 0xc05457ff, REGISTRY_RIPENCC    }, // 192.84.87.0     - 192.84.87.255
	{ 0xc0545800, 0xc05458ff, REGISTRY_ARIN       }, // 192.84.88.0     - 192.84.88.255
	{ 0xc0545900, 0xc05459ff, REGISTRY_APNIC      }, // 192.84.89.0     - 192.84.89.255
	{ 0xc0545a00, 0xc05463ff, REGISTRY_RIPENCC    }, // 192.84.90.0     - 192.84.99.255
	{ 0xc0546400, 0xc05464ff, REGISTRY_ARIN       }, // 192.84.100.0    - 192.84.100.255
	{ 0xc0546500, 0xc0546dff, REGISTRY_RIPENCC    }, // 192.84.101.0    - 192.84.109.255
	{ 0xc0546e00, 0xc0547eff, REGISTRY_ARIN       }, // 192.84.110.0    - 192.84.126.255
	{ 0xc0547f00, 0xc0549cff, REGISTRY_RIPENCC    }, // 192.84.127.0    - 192.84.156.255
	{ 0xc0549d00, 0xc054a5ff, REGISTRY_ARIN       }, // 192.84.157.0    - 192.84.165.255
	{ 0xc054a600, 0xc054a6ff, REGISTRY_RIPENCC    }, // 192.84.166.0    - 192.84.166.255
	{ 0xc054a700, 0xc054acff, REGISTRY_ARIN       }, // 192.84.167.0    - 192.84.172.255
	{ 0xc054ad00, 0xc054adff, REGISTRY_RIPENCC    }, // 192.84.173.0    - 192.84.173.255
	{ 0xc054ae00, 0xc054afff, REGISTRY_ARIN       }, // 192.84.174.0    - 192.84.175.255
	{ 0xc054b000, 0xc054cfff, REGISTRY_RIPENCC    }, // 192.84.176.0    - 192.84.207.255
	{ 0xc054d000, 0xc054d3ff, REGISTRY_ARIN       }, // 192.84.208.0    - 192.84.211.255
	{ 0xc054d400, 0xc054d4ff, REGISTRY_RIPENCC    }, // 192.84.212.0    - 192.84.212.255
	{ 0xc054d500, 0xc054daff, REGISTRY_ARIN       }, // 192.84.213.0    - 192.84.218.255
	{ 0xc054dc00, 0xc054ddff, REGISTRY_RIPENCC    }, // 192.84.220.0    - 192.84.221.255
	{ 0xc054de00, 0xc054e1ff, REGISTRY_ARIN       }, // 192.84.222.0    - 192.84.225.255
	{ 0xc054e200, 0xc054e5ff, REGISTRY_RIPENCC    }, // 192.84.226.0    - 192.84.229.255
	{ 0xc054e600, 0xc054e6ff, REGISTRY_APNIC      }, // 192.84.230.0    - 192.84.230.255
	{ 0xc054e700, 0xc054ecff, REGISTRY_ARIN       }, // 192.84.231.0    - 192.84.236.255
	{ 0xc054ed00, 0xc054eeff, REGISTRY_APNIC      }, // 192.84.237.0    - 192.84.238.255
	{ 0xc054ef00, 0xc054f0ff, REGISTRY_ARIN       }, // 192.84.239.0    - 192.84.240.255
	{ 0xc054f200, 0xc054f2ff, REGISTRY_APNIC      }, // 192.84.242.0    - 192.84.242.255
	{ 0xc054f300, 0xc054f3ff, REGISTRY_ARIN       }, // 192.84.243.0    - 192.84.243.255
	{ 0xc054f400, 0xc054f4ff, REGISTRY_AFRINIC    }, // 192.84.244.0    - 192.84.244.255
	{ 0xc054f500, 0xc054f7ff, REGISTRY_RIPENCC    }, // 192.84.245.0    - 192.84.247.255
	{ 0xc054f800, 0xc054fcff, REGISTRY_ARIN       }, // 192.84.248.0    - 192.84.252.255
	{ 0xc054fd00, 0xc054fdff, REGISTRY_APNIC      }, // 192.84.253.0    - 192.84.253.255
	{ 0xc054fe00, 0xc0560aff, REGISTRY_ARIN       }, // 192.84.254.0    - 192.86.10.255
	{ 0xc0560b00, 0xc0560bff, REGISTRY_RIPENCC    }, // 192.86.11.0     - 192.86.11.255
	{ 0xc0560d00, 0xc0560dff, REGISTRY_ARIN       }, // 192.86.13.0     - 192.86.13.255
	{ 0xc0560e00, 0xc0560eff, REGISTRY_RIPENCC    }, // 192.86.14.0     - 192.86.14.255
	{ 0xc0560f00, 0xc05611ff, REGISTRY_ARIN       }, // 192.86.15.0     - 192.86.17.255
	{ 0xc0561200, 0xc05612ff, REGISTRY_RIPENCC    }, // 192.86.18.0     - 192.86.18.255
	{ 0xc0561300, 0xc05618ff, REGISTRY_ARIN       }, // 192.86.19.0     - 192.86.24.255
	{ 0xc0561900, 0xc05619ff, REGISTRY_RIPENCC    }, // 192.86.25.0     - 192.86.25.255
	{ 0xc0561a00, 0xc0561aff, REGISTRY_ARIN       }, // 192.86.26.0     - 192.86.26.255
	{ 0xc0561b00, 0xc0561bff, REGISTRY_RIPENCC    }, // 192.86.27.0     - 192.86.27.255
	{ 0xc0561c00, 0xc05658ff, REGISTRY_ARIN       }, // 192.86.28.0     - 192.86.88.255
	{ 0xc0565900, 0xc05659ff, REGISTRY_RIPENCC    }, // 192.86.89.0     - 192.86.89.255
	{ 0xc0565a00, 0xc0567cff, REGISTRY_ARIN       }, // 192.86.90.0     - 192.86.124.255
	{ 0xc0567d00, 0xc0567fff, REGISTRY_RIPENCC    }, // 192.86.125.0    - 192.86.127.255
	{ 0xc0568000, 0xc05680ff, REGISTRY_ARIN       }, // 192.86.128.0    - 192.86.128.255
	{ 0xc0568200, 0xc05683ff, REGISTRY_ARIN       }, // 192.86.130.0    - 192.86.131.255
	{ 0xc0568600, 0xc05686ff, REGISTRY_RIPENCC    }, // 192.86.134.0    - 192.86.134.255
	{ 0xc0568700, 0xc05688ff, REGISTRY_ARIN       }, // 192.86.135.0    - 192.86.136.255
	{ 0xc0568900, 0xc0568aff, REGISTRY_RIPENCC    }, // 192.86.137.0    - 192.86.138.255
	{ 0xc0568b00, 0xc056a2ff, REGISTRY_ARIN       }, // 192.86.139.0    - 192.86.162.255
	{ 0xc056a300, 0xc056a3ff, REGISTRY_RIPENCC    }, // 192.86.163.0    - 192.86.163.255
	{ 0xc056a400, 0xc056a4ff, REGISTRY_ARIN       }, // 192.86.164.0    - 192.86.164.255
	{ 0xc056a500, 0xc056a5ff, REGISTRY_APNIC      }, // 192.86.165.0    - 192.86.165.255
	{ 0xc056a600, 0xc056a7ff, REGISTRY_RIPENCC    }, // 192.86.166.0    - 192.86.167.255
	{ 0xc056a800, 0xc056a8ff, REGISTRY_ARIN       }, // 192.86.168.0    - 192.86.168.255
	{ 0xc056a900, 0xc056a9ff, REGISTRY_RIPENCC    }, // 192.86.169.0    - 192.86.169.255
	{ 0xc056aa00, 0xc056fdff, REGISTRY_ARIN       }, // 192.86.170.0    - 192.86.253.255
	{ 0xc056fe00, 0xc056feff, REGISTRY_RIPENCC    }, // 192.86.254.0    - 192.86.254.255
	{ 0xc056ff00, 0xc056ffff, REGISTRY_ARIN       }, // 192.86.255.0    - 192.86.255.255
	{ 0xc0570000, 0xc057ffff, REGISTRY_RIPENCC    }, // 192.87.0.0      - 192.87.255.255
	{ 0xc0580000, 0xc05800ff, REGISTRY_ARIN       }, // 192.88.0.0      - 192.88.0.255
	{ 0xc0580100, 0xc05801ff, REGISTRY_RIPENCC    }, // 192.88.1.0      - 192.88.1.255
	{ 0xc0580200, 0xc05803ff, REGISTRY_ARIN       }, // 192.88.2.0      - 192.88.3.255
	{ 0xc0580400, 0xc05804ff, REGISTRY_RIPENCC    }, // 192.88.4.0      - 192.88.4.255
	{ 0xc0580500, 0xc05805ff, REGISTRY_ARIN       }, // 192.88.5.0      - 192.88.5.255
	{ 0xc0580600, 0xc05807ff, REGISTRY_APNIC      }, // 192.88.6.0      - 192.88.7.255
	{ 0xc0580800, 0xc05808ff, REGISTRY_ARIN       }, // 192.88.8.0      - 192.88.8.255
	{ 0xc0580900, 0xc0580aff, REGISTRY_RIPENCC    }, // 192.88.9.0      - 192.88.10.255
	{ 0xc0580b00, 0xc05810ff, REGISTRY_ARIN       }, // 192.88.11.0     - 192.88.16.255
	{ 0xc0581100, 0xc05811ff, REGISTRY_RIPENCC    }, // 192.88.17.0     - 192.88.17.255
	{ 0xc0581200, 0xc05816ff, REGISTRY_ARIN       }, // 192.88.18.0     - 192.88.22.255
	{ 0xc0581700, 0xc05818ff, REGISTRY_RIPENCC    }, // 192.88.23.0     - 192.88.24.255
	{ 0xc0581900, 0xc0584fff, REGISTRY_ARIN       }, // 192.88.25.0     - 192.88.79.255
	{ 0xc0585100, 0xc05852ff, REGISTRY_ARIN       }, // 192.88.81.0     - 192.88.82.255
	{ 0xc0585300, 0xc05854ff, REGISTRY_RIPENCC    }, // 192.88.83.0     - 192.88.84.255
	{ 0xc0585500, 0xc05855ff, REGISTRY_APNIC      }, // 192.88.85.0     - 192.88.85.255
	{ 0xc0585600, 0xc05856ff, REGISTRY_RIPENCC    }, // 192.88.86.0     - 192.88.86.255
	{ 0xc0585700, 0xc05860ff, REGISTRY_ARIN       }, // 192.88.87.0     - 192.88.96.255
	{ 0xc0586100, 0xc05862ff, REGISTRY_RIPENCC    }, // 192.88.97.0     - 192.88.98.255
	{ 0xc0586400, 0xc05864ff, REGISTRY_ARIN       }, // 192.88.100.0    - 192.88.100.255
	{ 0xc0586700, 0xc0586bff, REGISTRY_ARIN       }, // 192.88.103.0    - 192.88.107.255
	{ 0xc0586c00, 0xc0586cff, REGISTRY_RIPENCC    }, // 192.88.108.0    - 192.88.108.255
	{ 0xc0586d00, 0xc05875ff, REGISTRY_ARIN       }, // 192.88.109.0    - 192.88.117.255
	{ 0xc0587600, 0xc05876ff, REGISTRY_RIPENCC    }, // 192.88.118.0    - 192.88.118.255
	{ 0xc0587800, 0xc0587aff, REGISTRY_ARIN       }, // 192.88.120.0    - 192.88.122.255
	{ 0xc0587b00, 0xc0587bff, REGISTRY_RIPENCC    }, // 192.88.123.0    - 192.88.123.255
	{ 0xc0587c00, 0xc0587fff, REGISTRY_ARIN       }, // 192.88.124.0    - 192.88.127.255
	{ 0xc0588000, 0xc05880ff, REGISTRY_RIPENCC    }, // 192.88.128.0    - 192.88.128.255
	{ 0xc0588100, 0xc05881ff, REGISTRY_ARIN       }, // 192.88.129.0    - 192.88.129.255
	{ 0xc0588200, 0xc05882ff, REGISTRY_RIPENCC    }, // 192.88.130.0    - 192.88.130.255
	{ 0xc0588300, 0xc05884ff, REGISTRY_ARIN       }, // 192.88.131.0    - 192.88.132.255
	{ 0xc0588500, 0xc05885ff, REGISTRY_RIPENCC    }, // 192.88.133.0    - 192.88.133.255
	{ 0xc0588600, 0xc058baff, REGISTRY_ARIN       }, // 192.88.134.0    - 192.88.186.255
	{ 0xc058bb00, 0xc058bbff, REGISTRY_APNIC      }, // 192.88.187.0    - 192.88.187.255
	{ 0xc058bc00, 0xc058bdff, REGISTRY_ARIN       }, // 192.88.188.0    - 192.88.189.255
	{ 0xc058be00, 0xc058beff, REGISTRY_APNIC      }, // 192.88.190.0    - 192.88.190.255
	{ 0xc058bf00, 0xc058c3ff, REGISTRY_ARIN       }, // 192.88.191.0    - 192.88.195.255
	{ 0xc058c400, 0xc058c4ff, REGISTRY_RIPENCC    }, // 192.88.196.0    - 192.88.196.255
	{ 0xc058c500, 0xc058cbff, REGISTRY_ARIN       }, // 192.88.197.0    - 192.88.203.255
	{ 0xc058cc00, 0xc058ccff, REGISTRY_RIPENCC    }, // 192.88.204.0    - 192.88.204.255
	{ 0xc058cd00, 0xc058edff, REGISTRY_ARIN       }, // 192.88.205.0    - 192.88.237.255
	{ 0xc058ee00, 0xc058efff, REGISTRY_RIPENCC    }, // 192.88.238.0    - 192.88.239.255
	{ 0xc058f000, 0xc058f9ff, REGISTRY_ARIN       }, // 192.88.240.0    - 192.88.249.255
	{ 0xc058fa00, 0xc058feff, REGISTRY_RIPENCC    }, // 192.88.250.0    - 192.88.254.255
	{ 0xc058ff00, 0xc058ffff, REGISTRY_ARIN       }, // 192.88.255.0    - 192.88.255.255
	{ 0xc0590000, 0xc059ffff, REGISTRY_RIPENCC    }, // 192.89.0.0      - 192.89.255.255
	{ 0xc05a0000, 0xc05b8bff, REGISTRY_ARIN       }, // 192.90.0.0      - 192.91.139.255
	{ 0xc05b8c00, 0xc05b8dff, REGISTRY_RIPENCC    }, // 192.91.140.0    - 192.91.141.255
	{ 0xc05b8e00, 0xc05bb0ff, REGISTRY_ARIN       }, // 192.91.142.0    - 192.91.176.255
	{ 0xc05bb100, 0xc05bb1ff, REGISTRY_RIPENCC    }, // 192.91.177.0    - 192.91.177.255
	{ 0xc05bb200, 0xc05bb2ff, REGISTRY_ARIN       }, // 192.91.178.0    - 192.91.178.255
	{ 0xc05bb300, 0xc05bb3ff, REGISTRY_APNIC      }, // 192.91.179.0    - 192.91.179.255
	{ 0xc05bb400, 0xc05bb8ff, REGISTRY_ARIN       }, // 192.91.180.0    - 192.91.184.255
	{ 0xc05bb900, 0xc05bb9ff, REGISTRY_APNIC      }, // 192.91.185.0    - 192.91.185.255
	{ 0xc05bba00, 0xc05bbaff, REGISTRY_RIPENCC    }, // 192.91.186.0    - 192.91.186.255
	{ 0xc05bbb00, 0xc05bbcff, REGISTRY_ARIN       }, // 192.91.187.0    - 192.91.188.255
	{ 0xc05bbd00, 0xc05bbdff, REGISTRY_RIPENCC    }, // 192.91.189.0    - 192.91.189.255
	{ 0xc05bbe00, 0xc05bbeff, REGISTRY_ARIN       }, // 192.91.190.0    - 192.91.190.255
	{ 0xc05bbf00, 0xc05bbfff, REGISTRY_RIPENCC    }, // 192.91.191.0    - 192.91.191.255
	{ 0xc05bc000, 0xc05bc6ff, REGISTRY_ARIN       }, // 192.91.192.0    - 192.91.198.255
	{ 0xc05bc700, 0xc05bc7ff, REGISTRY_RIPENCC    }, // 192.91.199.0    - 192.91.199.255
	{ 0xc05bc900, 0xc05bc9ff, REGISTRY_RIPENCC    }, // 192.91.201.0    - 192.91.201.255
	{ 0xc05bca00, 0xc05bd2ff, REGISTRY_ARIN       }, // 192.91.202.0    - 192.91.210.255
	{ 0xc05bd300, 0xc05bd3ff, REGISTRY_RIPENCC    }, // 192.91.211.0    - 192.91.211.255
	{ 0xc05bd400, 0xc05bd4ff, REGISTRY_ARIN       }, // 192.91.212.0    - 192.91.212.255
	{ 0xc05bd600, 0xc05be9ff, REGISTRY_RIPENCC    }, // 192.91.214.0    - 192.91.233.255
	{ 0xc05bea00, 0xc05bebff, REGISTRY_ARIN       }, // 192.91.234.0    - 192.91.235.255
	{ 0xc05bec00, 0xc05bf7ff, REGISTRY_RIPENCC    }, // 192.91.236.0    - 192.91.247.255
	{ 0xc05bf800, 0xc05bfdff, REGISTRY_ARIN       }, // 192.91.248.0    - 192.91.253.255
	{ 0xc05bfe00, 0xc05bfeff, REGISTRY_LACNIC     }, // 192.91.254.0    - 192.91.254.255
	{ 0xc05bff00, 0xc05c0eff, REGISTRY_ARIN       }, // 192.91.255.0    - 192.92.14.255
	{ 0xc05c1000, 0xc05c55ff, REGISTRY_ARIN       }, // 192.92.16.0     - 192.92.85.255
	{ 0xc05c5600, 0xc05c56ff, REGISTRY_RIPENCC    }, // 192.92.86.0     - 192.92.86.255
	{ 0xc05c5700, 0xc05c5dff, REGISTRY_ARIN       }, // 192.92.87.0     - 192.92.93.255
	{ 0xc05c5e00, 0xc05c5eff, REGISTRY_RIPENCC    }, // 192.92.94.0     - 192.92.94.255
	{ 0xc05c5f00, 0xc05c67ff, REGISTRY_ARIN       }, // 192.92.95.0     - 192.92.103.255
	{ 0xc05c6800, 0xc05c6aff, REGISTRY_RIPENCC    }, // 192.92.104.0    - 192.92.106.255
	{ 0xc05c6b00, 0xc05c6bff, REGISTRY_ARIN       }, // 192.92.107.0    - 192.92.107.255
	{ 0xc05c6c00, 0xc05c6dff, REGISTRY_RIPENCC    }, // 192.92.108.0    - 192.92.109.255
	{ 0xc05c6e00, 0xc05c73ff, REGISTRY_ARIN       }, // 192.92.110.0    - 192.92.115.255
	{ 0xc05c7400, 0xc05c74ff, REGISTRY_RIPENCC    }, // 192.92.116.0    - 192.92.116.255
	{ 0xc05c7500, 0xc05c7cff, REGISTRY_ARIN       }, // 192.92.117.0    - 192.92.124.255
	{ 0xc05c7d00, 0xc05c8bff, REGISTRY_RIPENCC    }, // 192.92.125.0    - 192.92.139.255
	{ 0xc05c8c00, 0xc05c8cff, REGISTRY_ARIN       }, // 192.92.140.0    - 192.92.140.255
	{ 0xc05c8d00, 0xc05c99ff, REGISTRY_RIPENCC    }, // 192.92.141.0    - 192.92.153.255
	{ 0xc05c9b00, 0xc05c9cff, REGISTRY_RIPENCC    }, // 192.92.155.0    - 192.92.156.255
	{ 0xc05c9d00, 0xc05cd7ff, REGISTRY_ARIN       }, // 192.92.157.0    - 192.92.215.255
	{ 0xc05cd800, 0xc05cd8ff, REGISTRY_RIPENCC    }, // 192.92.216.0    - 192.92.216.255
	{ 0xc05cd900, 0xc05cf7ff, REGISTRY_ARIN       }, // 192.92.217.0    - 192.92.247.255
	{ 0xc05cf800, 0xc05cffff, REGISTRY_APNIC      }, // 192.92.248.0    - 192.92.255.255
	{ 0xc05d0000, 0xc05dffff, REGISTRY_RIPENCC    }, // 192.93.0.0      - 192.93.255.255
	{ 0xc05e0000, 0xc05e17ff, REGISTRY_ARIN       }, // 192.94.0.0      - 192.94.23.255
	{ 0xc05e1800, 0xc05e18ff, REGISTRY_RIPENCC    }, // 192.94.24.0     - 192.94.24.255
	{ 0xc05e1900, 0xc05e1bff, REGISTRY_ARIN       }, // 192.94.25.0     - 192.94.27.255
	{ 0xc05e1c00, 0xc05e1cff, REGISTRY_RIPENCC    }, // 192.94.28.0     - 192.94.28.255
	{ 0xc05e1d00, 0xc05e28ff, REGISTRY_ARIN       }, // 192.94.29.0     - 192.94.40.255
	{ 0xc05e2900, 0xc05e29ff, REGISTRY_APNIC      }, // 192.94.41.0     - 192.94.41.255
	{ 0xc05e2a00, 0xc05e38ff, REGISTRY_ARIN       }, // 192.94.42.0     - 192.94.56.255
	{ 0xc05e3900, 0xc05e3aff, REGISTRY_RIPENCC    }, // 192.94.57.0     - 192.94.58.255
	{ 0xc05e3b00, 0xc05e3cff, REGISTRY_ARIN       }, // 192.94.59.0     - 192.94.60.255
	{ 0xc05e3d00, 0xc05e3dff, REGISTRY_AFRINIC    }, // 192.94.61.0     - 192.94.61.255
	{ 0xc05e3e00, 0xc05e40ff, REGISTRY_APNIC      }, // 192.94.62.0     - 192.94.64.255
	{ 0xc05e4100, 0xc05e42ff, REGISTRY_ARIN       }, // 192.94.65.0     - 192.94.66.255
	{ 0xc05e4300, 0xc05e44ff, REGISTRY_RIPENCC    }, // 192.94.67.0     - 192.94.68.255
	{ 0xc05e4500, 0xc05e4bff, REGISTRY_ARIN       }, // 192.94.69.0     - 192.94.75.255
	{ 0xc05e4c00, 0xc05e4cff, REGISTRY_RIPENCC    }, // 192.94.76.0     - 192.94.76.255
	{ 0xc05e4d00, 0xc05e4dff, REGISTRY_ARIN       }, // 192.94.77.0     - 192.94.77.255
	{ 0xc05e4f00, 0xc05e6eff, REGISTRY_ARIN       }, // 192.94.79.0     - 192.94.110.255
	{ 0xc05e6f00, 0xc05e75ff, REGISTRY_RIPENCC    }, // 192.94.111.0    - 192.94.117.255
	{ 0xc05e7600, 0xc05e79ff, REGISTRY_ARIN       }, // 192.94.118.0    - 192.94.121.255
	{ 0xc05e7a00, 0xc05e7aff, REGISTRY_APNIC      }, // 192.94.122.0    - 192.94.122.255
	{ 0xc05e7b00, 0xc05e9bff, REGISTRY_ARIN       }, // 192.94.123.0    - 192.94.155.255
	{ 0xc05e9c00, 0xc05ea3ff, REGISTRY_RIPENCC    }, // 192.94.156.0    - 192.94.163.255
	{ 0xc05ea400, 0xc05ea8ff, REGISTRY_ARIN       }, // 192.94.164.0    - 192.94.168.255
	{ 0xc05ea900, 0xc05ea9ff, REGISTRY_APNIC      }, // 192.94.169.0    - 192.94.169.255
	{ 0xc05eaa00, 0xc05eabff, REGISTRY_ARIN       }, // 192.94.170.0    - 192.94.171.255
	{ 0xc05eac00, 0xc05eacff, REGISTRY_RIPENCC    }, // 192.94.172.0    - 192.94.172.255
	{ 0xc05ead00, 0xc05eadff, REGISTRY_ARIN       }, // 192.94.173.0    - 192.94.173.255
	{ 0xc05eae00, 0xc05eaeff, REGISTRY_APNIC      }, // 192.94.174.0    - 192.94.174.255
	{ 0xc05eaf00, 0xc05ec7ff, REGISTRY_RIPENCC    }, // 192.94.175.0    - 192.94.199.255
	{ 0xc05ec900, 0xc05ecfff, REGISTRY_ARIN       }, // 192.94.201.0    - 192.94.207.255
	{ 0xc05ed000, 0xc05ed1ff, REGISTRY_APNIC      }, // 192.94.208.0    - 192.94.209.255
	{ 0xc05ed200, 0xc05ed2ff, REGISTRY_AFRINIC    }, // 192.94.210.0    - 192.94.210.255
	{ 0xc05ed300, 0xc05ed3ff, REGISTRY_ARIN       }, // 192.94.211.0    - 192.94.211.255
	{ 0xc05ed400, 0xc05ed4ff, REGISTRY_RIPENCC    }, // 192.94.212.0    - 192.94.212.255
	{ 0xc05ed500, 0xc05edbff, REGISTRY_ARIN       }, // 192.94.213.0    - 192.94.219.255
	{ 0xc05edd00, 0xc05eddff, REGISTRY_RIPENCC    }, // 192.94.221.0    - 192.94.221.255
	{ 0xc05ede00, 0xc05ee1ff, REGISTRY_ARIN       }, // 192.94.222.0    - 192.94.225.255
	{ 0xc05ee200, 0xc05ee2ff, REGISTRY_RIPENCC    }, // 192.94.226.0    - 192.94.226.255
	{ 0xc05ee300, 0xc05ee3ff, REGISTRY_APNIC      }, // 192.94.227.0    - 192.94.227.255
	{ 0xc05ee400, 0xc05ee8ff, REGISTRY_ARIN       }, // 192.94.228.0    - 192.94.232.255
	{ 0xc05ee900, 0xc05ee9ff, REGISTRY_RIPENCC    }, // 192.94.233.0    - 192.94.233.255
	{ 0xc05eea00, 0xc05eeaff, REGISTRY_ARIN       }, // 192.94.234.0    - 192.94.234.255
	{ 0xc05eeb00, 0xc05eebff, REGISTRY_RIPENCC    }, // 192.94.235.0    - 192.94.235.255
	{ 0xc05eec00, 0xc05eedff, REGISTRY_ARIN       }, // 192.94.236.0    - 192.94.237.255
	{ 0xc05eef00, 0xc05eefff, REGISTRY_RIPENCC    }, // 192.94.239.0    - 192.94.239.255
	{ 0xc05ef000, 0xc05ef1ff, REGISTRY_AFRINIC    }, // 192.94.240.0    - 192.94.241.255
	{ 0xc05ef200, 0xc05ef2ff, REGISTRY_ARIN       }, // 192.94.242.0    - 192.94.242.255
	{ 0xc05ef300, 0xc05ef4ff, REGISTRY_APNIC      }, // 192.94.243.0    - 192.94.244.255
	{ 0xc05ef500, 0xc05ef5ff, REGISTRY_ARIN       }, // 192.94.245.0    - 192.94.245.255
	{ 0xc05ef600, 0xc05ef6ff, REGISTRY_AFRINIC    }, // 192.94.246.0    - 192.94.246.255
	{ 0xc05ef700, 0xc06000ff, REGISTRY_ARIN       }, // 192.94.247.0    - 192.96.0.255
	{ 0xc0600100, 0xc06010ff, REGISTRY_AFRINIC    }, // 192.96.1.0      - 192.96.16.255
	{ 0xc0601100, 0xc06012ff, REGISTRY_ARIN       }, // 192.96.17.0     - 192.96.18.255
	{ 0xc0601300, 0xc06016ff, REGISTRY_AFRINIC    }, // 192.96.19.0     - 192.96.22.255
	{ 0xc0601700, 0xc06017ff, REGISTRY_ARIN       }, // 192.96.23.0     - 192.96.23.255
	{ 0xc0601800, 0xc06023ff, REGISTRY_AFRINIC    }, // 192.96.24.0     - 192.96.35.255
	{ 0xc0602400, 0xc06024ff, REGISTRY_ARIN       }, // 192.96.36.0     - 192.96.36.255
	{ 0xc0602500, 0xc06028ff, REGISTRY_AFRINIC    }, // 192.96.37.0     - 192.96.40.255
	{ 0xc0602900, 0xc0602aff, REGISTRY_ARIN       }, // 192.96.41.0     - 192.96.42.255
	{ 0xc0602b00, 0xc0602bff, REGISTRY_AFRINIC    }, // 192.96.43.0     - 192.96.43.255
	{ 0xc0602c00, 0xc0602cff, REGISTRY_ARIN       }, // 192.96.44.0     - 192.96.44.255
	{ 0xc0602d00, 0xc0603aff, REGISTRY_AFRINIC    }, // 192.96.45.0     - 192.96.58.255
	{ 0xc0603b00, 0xc0603bff, REGISTRY_ARIN       }, // 192.96.59.0     - 192.96.59.255
	{ 0xc0603c00, 0xc0603dff, REGISTRY_AFRINIC    }, // 192.96.60.0     - 192.96.61.255
	{ 0xc0603e00, 0xc06043ff, REGISTRY_ARIN       }, // 192.96.62.0     - 192.96.67.255
	{ 0xc0604400, 0xc06048ff, REGISTRY_AFRINIC    }, // 192.96.68.0     - 192.96.72.255
	{ 0xc0604900, 0xc06049ff, REGISTRY_ARIN       }, // 192.96.73.0     - 192.96.73.255
	{ 0xc0604a00, 0xc0604dff, REGISTRY_AFRINIC    }, // 192.96.74.0     - 192.96.77.255
	{ 0xc0604e00, 0xc0604eff, REGISTRY_ARIN       }, // 192.96.78.0     - 192.96.78.255
	{ 0xc0604f00, 0xc06066ff, REGISTRY_AFRINIC    }, // 192.96.79.0     - 192.96.102.255
	{ 0xc0606700, 0xc06067ff, REGISTRY_ARIN       }, // 192.96.103.0    - 192.96.103.255
	{ 0xc0606800, 0xc06086ff, REGISTRY_AFRINIC    }, // 192.96.104.0    - 192.96.134.255
	{ 0xc0608700, 0xc06089ff, REGISTRY_ARIN       }, // 192.96.135.0    - 192.96.137.255
	{ 0xc0608a00, 0xc0608eff, REGISTRY_AFRINIC    }, // 192.96.138.0    - 192.96.142.255
	{ 0xc0608f00, 0xc0608fff, REGISTRY_ARIN       }, // 192.96.143.0    - 192.96.143.255
	{ 0xc0609000, 0xc06090ff, REGISTRY_AFRINIC    }, // 192.96.144.0    - 192.96.144.255
	{ 0xc0609100, 0xc06091ff, REGISTRY_ARIN       }, // 192.96.145.0    - 192.96.145.255
	{ 0xc0609200, 0xc0609bff, REGISTRY_AFRINIC    }, // 192.96.146.0    - 192.96.155.255
	{ 0xc0609c00, 0xc0609dff, REGISTRY_ARIN       }, // 192.96.156.0    - 192.96.157.255
	{ 0xc0609e00, 0xc0609eff, REGISTRY_AFRINIC    }, // 192.96.158.0    - 192.96.158.255
	{ 0xc0609f00, 0xc060a3ff, REGISTRY_ARIN       }, // 192.96.159.0    - 192.96.163.255
	{ 0xc060a400, 0xc060a7ff, REGISTRY_AFRINIC    }, // 192.96.164.0    - 192.96.167.255
	{ 0xc060a800, 0xc060b0ff, REGISTRY_ARIN       }, // 192.96.168.0    - 192.96.176.255
	{ 0xc060b100, 0xc060bfff, REGISTRY_AFRINIC    }, // 192.96.177.0    - 192.96.191.255
	{ 0xc060c000, 0xc060c0ff, REGISTRY_ARIN       }, // 192.96.192.0    - 192.96.192.255
	{ 0xc060c100, 0xc060c7ff, REGISTRY_AFRINIC    }, // 192.96.193.0    - 192.96.199.255
	{ 0xc060c800, 0xc060dfff, REGISTRY_ARIN       }, // 192.96.200.0    - 192.96.223.255
	{ 0xc060e000, 0xc060e8ff, REGISTRY_AFRINIC    }, // 192.96.224.0    - 192.96.232.255
	{ 0xc060e900, 0xc060e9ff, REGISTRY_ARIN       }, // 192.96.233.0    - 192.96.233.255
	{ 0xc060ea00, 0xc060f3ff, REGISTRY_AFRINIC    }, // 192.96.234.0    - 192.96.243.255
	{ 0xc060f400, 0xc060f4ff, REGISTRY_ARIN       }, // 192.96.244.0    - 192.96.244.255
	{ 0xc060f500, 0xc060feff, REGISTRY_AFRINIC    }, // 192.96.245.0    - 192.96.254.255
	{ 0xc060ff00, 0xc061ffff, REGISTRY_ARIN       }, // 192.96.255.0    - 192.97.255.255
	{ 0xc0620000, 0xc062ffff, REGISTRY_RIPENCC    }, // 192.98.0.0      - 192.98.255.255
	{ 0xc0630000, 0xc06400ff, REGISTRY_ARIN       }, // 192.99.0.0      - 192.100.0.255
	{ 0xc0640100, 0xc06401ff, REGISTRY_AFRINIC    }, // 192.100.1.0     - 192.100.1.255
	{ 0xc0640200, 0xc06402ff, REGISTRY_APNIC      }, // 192.100.2.0     - 192.100.2.255
	{ 0xc0640300, 0xc06411ff, REGISTRY_ARIN       }, // 192.100.3.0     - 192.100.17.255
	{ 0xc0641200, 0xc06412ff, REGISTRY_RIPENCC    }, // 192.100.18.0    - 192.100.18.255
	{ 0xc0641300, 0xc06415ff, REGISTRY_ARIN       }, // 192.100.19.0    - 192.100.21.255
	{ 0xc0641600, 0xc06416ff, REGISTRY_APNIC      }, // 192.100.22.0    - 192.100.22.255
	{ 0xc0641700, 0xc06419ff, REGISTRY_RIPENCC    }, // 192.100.23.0    - 192.100.25.255
	{ 0xc0641a00, 0xc06433ff, REGISTRY_ARIN       }, // 192.100.26.0    - 192.100.51.255
	{ 0xc0643400, 0xc06434ff, REGISTRY_RIPENCC    }, // 192.100.52.0    - 192.100.52.255
	{ 0xc0643500, 0xc06435ff, REGISTRY_APNIC      }, // 192.100.53.0    - 192.100.53.255
	{ 0xc0643600, 0xc0643cff, REGISTRY_ARIN       }, // 192.100.54.0    - 192.100.60.255
	{ 0xc0643d00, 0xc0643dff, REGISTRY_RIPENCC    }, // 192.100.61.0    - 192.100.61.255
	{ 0xc0643e00, 0xc0643eff, REGISTRY_ARIN       }, // 192.100.62.0    - 192.100.62.255
	{ 0xc0643f00, 0xc0643fff, REGISTRY_RIPENCC    }, // 192.100.63.0    - 192.100.63.255
	{ 0xc0644000, 0xc0644cff, REGISTRY_ARIN       }, // 192.100.64.0    - 192.100.76.255
	{ 0xc0644d00, 0xc0644dff, REGISTRY_APNIC      }, // 192.100.77.0    - 192.100.77.255
	{ 0xc0644e00, 0xc0644eff, REGISTRY_RIPENCC    }, // 192.100.78.0    - 192.100.78.255
	{ 0xc0644f00, 0xc0644fff, REGISTRY_ARIN       }, // 192.100.79.0    - 192.100.79.255
	{ 0xc0645000, 0xc06450ff, REGISTRY_APNIC      }, // 192.100.80.0    - 192.100.80.255
	{ 0xc0645100, 0xc0645fff, REGISTRY_ARIN       }, // 192.100.81.0    - 192.100.95.255
	{ 0xc0646000, 0xc06463ff, REGISTRY_RIPENCC    }, // 192.100.96.0    - 192.100.99.255
	{ 0xc0646400, 0xc06465ff, REGISTRY_ARIN       }, // 192.100.100.0   - 192.100.101.255
	{ 0xc0646600, 0xc06485ff, REGISTRY_RIPENCC    }, // 192.100.102.0   - 192.100.133.255
	{ 0xc0648600, 0xc06486ff, REGISTRY_ARIN       }, // 192.100.134.0   - 192.100.134.255
	{ 0xc0648700, 0xc0648cff, REGISTRY_RIPENCC    }, // 192.100.135.0   - 192.100.140.255
	{ 0xc0648d00, 0xc0648fff, REGISTRY_ARIN       }, // 192.100.141.0   - 192.100.143.255
	{ 0xc0649000, 0xc06490ff, REGISTRY_RIPENCC    }, // 192.100.144.0   - 192.100.144.255
	{ 0xc0649100, 0xc06499ff, REGISTRY_ARIN       }, // 192.100.145.0   - 192.100.153.255
	{ 0xc0649a00, 0xc0649aff, REGISTRY_RIPENCC    }, // 192.100.154.0   - 192.100.154.255
	{ 0xc0649b00, 0xc064a7ff, REGISTRY_LACNIC     }, // 192.100.155.0   - 192.100.167.255
	{ 0xc064a900, 0xc064beff, REGISTRY_LACNIC     }, // 192.100.169.0   - 192.100.190.255
	{ 0xc064c000, 0xc064feff, REGISTRY_LACNIC     }, // 192.100.192.0   - 192.100.254.255
	{ 0xc064ff00, 0xc06500ff, REGISTRY_ARIN       }, // 192.100.255.0   - 192.101.0.255
	{ 0xc0650100, 0xc06501ff, REGISTRY_RIPENCC    }, // 192.101.1.0     - 192.101.1.255
	{ 0xc0650200, 0xc06503ff, REGISTRY_ARIN       }, // 192.101.2.0     - 192.101.3.255
	{ 0xc0650400, 0xc06504ff, REGISTRY_RIPENCC    }, // 192.101.4.0     - 192.101.4.255
	{ 0xc0650500, 0xc06507ff, REGISTRY_ARIN       }, // 192.101.5.0     - 192.101.7.255
	{ 0xc0650800, 0xc06508ff, REGISTRY_RIPENCC    }, // 192.101.8.0     - 192.101.8.255
	{ 0xc0650900, 0xc0650aff, REGISTRY_ARIN       }, // 192.101.9.0     - 192.101.10.255
	{ 0xc0650b00, 0xc0650bff, REGISTRY_RIPENCC    }, // 192.101.11.0    - 192.101.11.255
	{ 0xc0650c00, 0xc0650fff, REGISTRY_ARIN       }, // 192.101.12.0    - 192.101.15.255
	{ 0xc0651000, 0xc06510ff, REGISTRY_APNIC      }, // 192.101.16.0    - 192.101.16.255
	{ 0xc0651100, 0xc0651bff, REGISTRY_ARIN       }, // 192.101.17.0    - 192.101.27.255
	{ 0xc0651c00, 0xc0651cff, REGISTRY_RIPENCC    }, // 192.101.28.0    - 192.101.28.255
	{ 0xc0651d00, 0xc06521ff, REGISTRY_ARIN       }, // 192.101.29.0    - 192.101.33.255
	{ 0xc0652200, 0xc06522ff, REGISTRY_RIPENCC    }, // 192.101.34.0    - 192.101.34.255
	{ 0xc0652300, 0xc0654aff, REGISTRY_ARIN       }, // 192.101.35.0    - 192.101.74.255
	{ 0xc0654b00, 0xc0654bff, REGISTRY_RIPENCC    }, // 192.101.75.0    - 192.101.75.255
	{ 0xc0654c00, 0xc06550ff, REGISTRY_ARIN       }, // 192.101.76.0    - 192.101.80.255
	{ 0xc0655100, 0xc0655aff, REGISTRY_RIPENCC    }, // 192.101.81.0    - 192.101.90.255
	{ 0xc0655b00, 0xc0655bff, REGISTRY_APNIC      }, // 192.101.91.0    - 192.101.91.255
	{ 0xc0655c00, 0xc0656eff, REGISTRY_ARIN       }, // 192.101.92.0    - 192.101.110.255
	{ 0xc0656f00, 0xc06572ff, REGISTRY_RIPENCC    }, // 192.101.111.0   - 192.101.114.255
	{ 0xc0657300, 0xc06575ff, REGISTRY_ARIN       }, // 192.101.115.0   - 192.101.117.255
	{ 0xc0657600, 0xc06576ff, REGISTRY_RIPENCC    }, // 192.101.118.0   - 192.101.118.255
	{ 0xc0657700, 0xc06585ff, REGISTRY_ARIN       }, // 192.101.119.0   - 192.101.133.255
	{ 0xc0658600, 0xc06586ff, REGISTRY_APNIC      }, // 192.101.134.0   - 192.101.134.255
	{ 0xc0658700, 0xc06588ff, REGISTRY_ARIN       }, // 192.101.135.0   - 192.101.136.255
	{ 0xc0658900, 0xc06589ff, REGISTRY_RIPENCC    }, // 192.101.137.0   - 192.101.137.255
	{ 0xc0658a00, 0xc0658dff, REGISTRY_ARIN       }, // 192.101.138.0   - 192.101.141.255
	{ 0xc0658e00, 0xc0658eff, REGISTRY_AFRINIC    }, // 192.101.142.0   - 192.101.142.255
	{ 0xc0658f00, 0xc065a0ff, REGISTRY_ARIN       }, // 192.101.143.0   - 192.101.160.255
	{ 0xc065a100, 0xc065a8ff, REGISTRY_RIPENCC    }, // 192.101.161.0   - 192.101.168.255
	{ 0xc065a900, 0xc065a9ff, REGISTRY_ARIN       }, // 192.101.169.0   - 192.101.169.255
	{ 0xc065aa00, 0xc065aaff, REGISTRY_RIPENCC    }, // 192.101.170.0   - 192.101.170.255
	{ 0xc065ab00, 0xc065afff, REGISTRY_ARIN       }, // 192.101.171.0   - 192.101.175.255
	{ 0xc065b000, 0xc065b0ff, REGISTRY_RIPENCC    }, // 192.101.176.0   - 192.101.176.255
	{ 0xc065b100, 0xc065b2ff, REGISTRY_ARIN       }, // 192.101.177.0   - 192.101.178.255
	{ 0xc065b300, 0xc065b4ff, REGISTRY_RIPENCC    }, // 192.101.179.0   - 192.101.180.255
	{ 0xc065b500, 0xc065b6ff, REGISTRY_ARIN       }, // 192.101.181.0   - 192.101.182.255
	{ 0xc065b700, 0xc065b7ff, REGISTRY_APNIC      }, // 192.101.183.0   - 192.101.183.255
	{ 0xc065b800, 0xc065bfff, REGISTRY_ARIN       }, // 192.101.184.0   - 192.101.191.255
	{ 0xc065c000, 0xc065c0ff, REGISTRY_RIPENCC    }, // 192.101.192.0   - 192.101.192.255
	{ 0xc065c100, 0xc065c4ff, REGISTRY_ARIN       }, // 192.101.193.0   - 192.101.196.255
	{ 0xc065c500, 0xc065c6ff, REGISTRY_RIPENCC    }, // 192.101.197.0   - 192.101.198.255
	{ 0xc065c700, 0xc065fbff, REGISTRY_ARIN       }, // 192.101.199.0   - 192.101.251.255
	{ 0xc065fc00, 0xc065fcff, REGISTRY_RIPENCC    }, // 192.101.252.0   - 192.101.252.255
	{ 0xc065fd00, 0xc065fdff, REGISTRY_ARIN       }, // 192.101.253.0   - 192.101.253.255
	{ 0xc065fe00, 0xc065feff, REGISTRY_APNIC      }, // 192.101.254.0   - 192.101.254.255
	{ 0xc065ff00, 0xc06600ff, REGISTRY_ARIN       }, // 192.101.255.0   - 192.102.0.255
	{ 0xc0660100, 0xc06601ff, REGISTRY_RIPENCC    }, // 192.102.1.0     - 192.102.1.255
	{ 0xc0660200, 0xc06605ff, REGISTRY_ARIN       }, // 192.102.2.0     - 192.102.5.255
	{ 0xc0660600, 0xc06608ff, REGISTRY_RIPENCC    }, // 192.102.6.0     - 192.102.8.255
	{ 0xc0660900, 0xc06609ff, REGISTRY_AFRINIC    }, // 192.102.9.0     - 192.102.9.255
	{ 0xc0660a00, 0xc06610ff, REGISTRY_ARIN       }, // 192.102.10.0    - 192.102.16.255
	{ 0xc0661100, 0xc06611ff, REGISTRY_RIPENCC    }, // 192.102.17.0    - 192.102.17.255
	{ 0xc0661200, 0xc0663fff, REGISTRY_RIPENCC    }, // 192.102.18.0    - 192.102.63.255
	{ 0xc0664000, 0xc06641ff, REGISTRY_RIPENCC    }, // 192.102.64.0    - 192.102.65.255
	{ 0xc0664200, 0xc06651ff, REGISTRY_RIPENCC    }, // 192.102.66.0    - 192.102.81.255
	{ 0xc0665200, 0xc06652ff, REGISTRY_ARIN       }, // 192.102.82.0    - 192.102.82.255
	{ 0xc0665300, 0xc06653ff, REGISTRY_APNIC      }, // 192.102.83.0    - 192.102.83.255
	{ 0xc0665400, 0xc06654ff, REGISTRY_LACNIC     }, // 192.102.84.0    - 192.102.84.255
	{ 0xc0665500, 0xc06658ff, REGISTRY_ARIN       }, // 192.102.85.0    - 192.102.88.255
	{ 0xc0665900, 0xc06659ff, REGISTRY_RIPENCC    }, // 192.102.89.0    - 192.102.89.255
	{ 0xc0665a00, 0xc0665bff, REGISTRY_ARIN       }, // 192.102.90.0    - 192.102.91.255
	{ 0xc0665c00, 0xc0665cff, REGISTRY_APNIC      }, // 192.102.92.0    - 192.102.92.255
	{ 0xc0665d00, 0xc0665eff, REGISTRY_ARIN       }, // 192.102.93.0    - 192.102.94.255
	{ 0xc0665f00, 0xc0665fff, REGISTRY_RIPENCC    }, // 192.102.95.0    - 192.102.95.255
	{ 0xc0666000, 0xc06691ff, REGISTRY_ARIN       }, // 192.102.96.0    - 192.102.145.255
	{ 0xc0669200, 0xc066b1ff, REGISTRY_RIPENCC    }, // 192.102.146.0   - 192.102.177.255
	{ 0xc066b200, 0xc066cbff, REGISTRY_ARIN       }, // 192.102.178.0   - 192.102.203.255
	{ 0xc066cc00, 0xc066cdff, REGISTRY_APNIC      }, // 192.102.204.0   - 192.102.205.255
	{ 0xc066ce00, 0xc066d5ff, REGISTRY_ARIN       }, // 192.102.206.0   - 192.102.213.255
	{ 0xc066d600, 0xc066d6ff, REGISTRY_RIPENCC    }, // 192.102.214.0   - 192.102.214.255
	{ 0xc066d700, 0xc066dfff, REGISTRY_ARIN       }, // 192.102.215.0   - 192.102.223.255
	{ 0xc066e000, 0xc066e1ff, REGISTRY_RIPENCC    }, // 192.102.224.0   - 192.102.225.255
	{ 0xc066e200, 0xc066e2ff, REGISTRY_ARIN       }, // 192.102.226.0   - 192.102.226.255
	{ 0xc066e300, 0xc066e5ff, REGISTRY_RIPENCC    }, // 192.102.227.0   - 192.102.229.255
	{ 0xc066e600, 0xc066eeff, REGISTRY_ARIN       }, // 192.102.230.0   - 192.102.238.255
	{ 0xc066ef00, 0xc066efff, REGISTRY_APNIC      }, // 192.102.239.0   - 192.102.239.255
	{ 0xc066f000, 0xc066f9ff, REGISTRY_ARIN       }, // 192.102.240.0   - 192.102.249.255
	{ 0xc066fa00, 0xc066fbff, REGISTRY_APNIC      }, // 192.102.250.0   - 192.102.251.255
	{ 0xc066fc00, 0xc06701ff, REGISTRY_ARIN       }, // 192.102.252.0   - 192.103.1.255
	{ 0xc0670200, 0xc06702ff, REGISTRY_RIPENCC    }, // 192.103.2.0     - 192.103.2.255
	{ 0xc0670300, 0xc06706ff, REGISTRY_ARIN       }, // 192.103.3.0     - 192.103.6.255
	{ 0xc0670700, 0xc06707ff, REGISTRY_RIPENCC    }, // 192.103.7.0     - 192.103.7.255
	{ 0xc0670800, 0xc0670dff, REGISTRY_ARIN       }, // 192.103.8.0     - 192.103.13.255
	{ 0xc0670e00, 0xc0670eff, REGISTRY_RIPENCC    }, // 192.103.14.0    - 192.103.14.255
	{ 0xc0670f00, 0xc06713ff, REGISTRY_ARIN       }, // 192.103.15.0    - 192.103.19.255
	{ 0xc0671400, 0xc06714ff, REGISTRY_RIPENCC    }, // 192.103.20.0    - 192.103.20.255
	{ 0xc0671500, 0xc06716ff, REGISTRY_ARIN       }, // 192.103.21.0    - 192.103.22.255
	{ 0xc0671700, 0xc06717ff, REGISTRY_RIPENCC    }, // 192.103.23.0    - 192.103.23.255
	{ 0xc0671800, 0xc0671aff, REGISTRY_ARIN       }, // 192.103.24.0    - 192.103.26.255
	{ 0xc0671b00, 0xc0671bff, REGISTRY_RIPENCC    }, // 192.103.27.0    - 192.103.27.255
	{ 0xc0671c00, 0xc06728ff, REGISTRY_RIPENCC    }, // 192.103.28.0    - 192.103.40.255
	{ 0xc0672900, 0xc06729ff, REGISTRY_ARIN       }, // 192.103.41.0    - 192.103.41.255
	{ 0xc0672b00, 0xc0672bff, REGISTRY_APNIC      }, // 192.103.43.0    - 192.103.43.255
	{ 0xc0672c00, 0xc0672dff, REGISTRY_ARIN       }, // 192.103.44.0    - 192.103.45.255
	{ 0xc0672f00, 0xc06754ff, REGISTRY_ARIN       }, // 192.103.47.0    - 192.103.84.255
	{ 0xc0675500, 0xc06774ff, REGISTRY_RIPENCC    }, // 192.103.85.0    - 192.103.116.255
	{ 0xc0677500, 0xc06781ff, REGISTRY_ARIN       }, // 192.103.117.0   - 192.103.129.255
	{ 0xc0678200, 0xc06782ff, REGISTRY_APNIC      }, // 192.103.130.0   - 192.103.130.255
	{ 0xc0678300, 0xc06783ff, REGISTRY_ARIN       }, // 192.103.131.0   - 192.103.131.255
	{ 0xc0678500, 0xc06788ff, REGISTRY_ARIN       }, // 192.103.133.0   - 192.103.136.255
	{ 0xc0678900, 0xc0678bff, REGISTRY_RIPENCC    }, // 192.103.137.0   - 192.103.139.255
	{ 0xc0678c00, 0xc06792ff, REGISTRY_ARIN       }, // 192.103.140.0   - 192.103.146.255
	{ 0xc0679300, 0xc06793ff, REGISTRY_RIPENCC    }, // 192.103.147.0   - 192.103.147.255
	{ 0xc0679400, 0xc0680eff, REGISTRY_ARIN       }, // 192.103.148.0   - 192.104.14.255
	{ 0xc0680f00, 0xc0680fff, REGISTRY_APNIC      }, // 192.104.15.0    - 192.104.15.255
	{ 0xc0681000, 0xc06816ff, REGISTRY_ARIN       }, // 192.104.16.0    - 192.104.22.255
	{ 0xc0681700, 0xc06817ff, REGISTRY_RIPENCC    }, // 192.104.23.0    - 192.104.23.255
	{ 0xc0681800, 0xc0681bff, REGISTRY_ARIN       }, // 192.104.24.0    - 192.104.27.255
	{ 0xc0681c00, 0xc0681dff, REGISTRY_RIPENCC    }, // 192.104.28.0    - 192.104.29.255
	{ 0xc0681e00, 0xc06822ff, REGISTRY_ARIN       }, // 192.104.30.0    - 192.104.34.255
	{ 0xc0682300, 0xc06825ff, REGISTRY_RIPENCC    }, // 192.104.35.0    - 192.104.37.255
	{ 0xc0682600, 0xc06827ff, REGISTRY_ARIN       }, // 192.104.38.0    - 192.104.39.255
	{ 0xc0682900, 0xc06829ff, REGISTRY_RIPENCC    }, // 192.104.41.0    - 192.104.41.255
	{ 0xc0682a00, 0xc0682aff, REGISTRY_ARIN       }, // 192.104.42.0    - 192.104.42.255
	{ 0xc0682b00, 0xc0682dff, REGISTRY_APNIC      }, // 192.104.43.0    - 192.104.45.255
	{ 0xc0682e00, 0xc0682fff, REGISTRY_ARIN       }, // 192.104.46.0    - 192.104.47.255
	{ 0xc0683000, 0xc06830ff, REGISTRY_RIPENCC    }, // 192.104.48.0    - 192.104.48.255
	{ 0xc0683100, 0xc06834ff, REGISTRY_ARIN       }, // 192.104.49.0    - 192.104.52.255
	{ 0xc0683500, 0xc06835ff, REGISTRY_RIPENCC    }, // 192.104.53.0    - 192.104.53.255
	{ 0xc0683600, 0xc06836ff, REGISTRY_ARIN       }, // 192.104.54.0    - 192.104.54.255
	{ 0xc0683700, 0xc0683aff, REGISTRY_RIPENCC    }, // 192.104.55.0    - 192.104.58.255
	{ 0xc0683b00, 0xc06847ff, REGISTRY_ARIN       }, // 192.104.59.0    - 192.104.71.255
	{ 0xc0684800, 0xc06848ff, REGISTRY_RIPENCC    }, // 192.104.72.0    - 192.104.72.255
	{ 0xc0684900, 0xc0684cff, REGISTRY_ARIN       }, // 192.104.73.0    - 192.104.76.255
	{ 0xc0684d00, 0xc0684dff, REGISTRY_RIPENCC    }, // 192.104.77.0    - 192.104.77.255
	{ 0xc0684e00, 0xc0684fff, REGISTRY_ARIN       }, // 192.104.78.0    - 192.104.79.255
	{ 0xc0685100, 0xc06851ff, REGISTRY_ARIN       }, // 192.104.81.0    - 192.104.81.255
	{ 0xc0685200, 0xc06852ff, REGISTRY_RIPENCC    }, // 192.104.82.0    - 192.104.82.255
	{ 0xc0685300, 0xc0688bff, REGISTRY_ARIN       }, // 192.104.83.0    - 192.104.139.255
	{ 0xc0688c00, 0xc0688cff, REGISTRY_RIPENCC    }, // 192.104.140.0   - 192.104.140.255
	{ 0xc0688d00, 0xc0688dff, REGISTRY_ARIN       }, // 192.104.141.0   - 192.104.141.255
	{ 0xc0688e00, 0xc0688eff, REGISTRY_RIPENCC    }, // 192.104.142.0   - 192.104.142.255
	{ 0xc0688f00, 0xc06892ff, REGISTRY_ARIN       }, // 192.104.143.0   - 192.104.146.255
	{ 0xc0689300, 0xc06893ff, REGISTRY_RIPENCC    }, // 192.104.147.0   - 192.104.147.255
	{ 0xc0689400, 0xc06899ff, REGISTRY_ARIN       }, // 192.104.148.0   - 192.104.153.255
	{ 0xc0689a00, 0xc0689bff, REGISTRY_RIPENCC    }, // 192.104.154.0   - 192.104.155.255
	{ 0xc0689c00, 0xc068a6ff, REGISTRY_ARIN       }, // 192.104.156.0   - 192.104.166.255
	{ 0xc068a700, 0xc068a8ff, REGISTRY_RIPENCC    }, // 192.104.167.0   - 192.104.168.255
	{ 0xc068a900, 0xc068abff, REGISTRY_ARIN       }, // 192.104.169.0   - 192.104.171.255
	{ 0xc068ac00, 0xc068acff, REGISTRY_APNIC      }, // 192.104.172.0   - 192.104.172.255
	{ 0xc068ad00, 0xc068e7ff, REGISTRY_ARIN       }, // 192.104.173.0   - 192.104.231.255
	{ 0xc068e800, 0xc068e9ff, REGISTRY_APNIC      }, // 192.104.232.0   - 192.104.233.255
	{ 0xc068ea00, 0xc068edff, REGISTRY_ARIN       }, // 192.104.234.0   - 192.104.237.255
	{ 0xc068ee00, 0xc068eeff, REGISTRY_RIPENCC    }, // 192.104.238.0   - 192.104.238.255
	{ 0xc068ef00, 0xc068f4ff, REGISTRY_ARIN       }, // 192.104.239.0   - 192.104.244.255
	{ 0xc068f500, 0xc068f5ff, REGISTRY_RIPENCC    }, // 192.104.245.0   - 192.104.245.255
	{ 0xc068f600, 0xc068f7ff, REGISTRY_APNIC      }, // 192.104.246.0   - 192.104.247.255
	{ 0xc068f800, 0xc068f8ff, REGISTRY_RIPENCC    }, // 192.104.248.0   - 192.104.248.255
	{ 0xc068f900, 0xc068faff, REGISTRY_ARIN       }, // 192.104.249.0   - 192.104.250.255
	{ 0xc068fb00, 0xc068fbff, REGISTRY_RIPENCC    }, // 192.104.251.0   - 192.104.251.255
	{ 0xc068fd00, 0xc06909ff, REGISTRY_ARIN       }, // 192.104.253.0   - 192.105.9.255
	{ 0xc0690a00, 0xc0690aff, REGISTRY_APNIC      }, // 192.105.10.0    - 192.105.10.255
	{ 0xc0690b00, 0xc0694aff, REGISTRY_ARIN       }, // 192.105.11.0    - 192.105.74.255
	{ 0xc0694b00, 0xc0694bff, REGISTRY_RIPENCC    }, // 192.105.75.0    - 192.105.75.255
	{ 0xc0694c00, 0xc069ffff, REGISTRY_ARIN       }, // 192.105.76.0    - 192.105.255.255
	{ 0xc06a0000, 0xc06affff, REGISTRY_RIPENCC    }, // 192.106.0.0     - 192.106.255.255
	{ 0xc06b0000, 0xc06b01ff, REGISTRY_ARIN       }, // 192.107.0.0     - 192.107.1.255
	{ 0xc06b0200, 0xc06b02ff, REGISTRY_RIPENCC    }, // 192.107.2.0     - 192.107.2.255
	{ 0xc06b0300, 0xc06b03ff, REGISTRY_ARIN       }, // 192.107.3.0     - 192.107.3.255
	{ 0xc06b0400, 0xc06b05ff, REGISTRY_RIPENCC    }, // 192.107.4.0     - 192.107.5.255
	{ 0xc06b0600, 0xc06b08ff, REGISTRY_ARIN       }, // 192.107.6.0     - 192.107.8.255
	{ 0xc06b0900, 0xc06b09ff, REGISTRY_APNIC      }, // 192.107.9.0     - 192.107.9.255
	{ 0xc06b0b00, 0xc06b0dff, REGISTRY_RIPENCC    }, // 192.107.11.0    - 192.107.13.255
	{ 0xc06b0e00, 0xc06b32ff, REGISTRY_ARIN       }, // 192.107.14.0    - 192.107.50.255
	{ 0xc06b3300, 0xc06b64ff, REGISTRY_RIPENCC    }, // 192.107.51.0    - 192.107.100.255
	{ 0xc06b6500, 0xc06b65ff, REGISTRY_APNIC      }, // 192.107.101.0   - 192.107.101.255
	{ 0xc06b6600, 0xc06b67ff, REGISTRY_ARIN       }, // 192.107.102.0   - 192.107.103.255
	{ 0xc06b6800, 0xc06b68ff, REGISTRY_LACNIC     }, // 192.107.104.0   - 192.107.104.255
	{ 0xc06b6900, 0xc06b6dff, REGISTRY_ARIN       }, // 192.107.105.0   - 192.107.109.255
	{ 0xc06b6e00, 0xc06b6eff, REGISTRY_RIPENCC    }, // 192.107.110.0   - 192.107.110.255
	{ 0xc06b6f00, 0xc06b6fff, REGISTRY_ARIN       }, // 192.107.111.0   - 192.107.111.255
	{ 0xc06b7100, 0xc06b71ff, REGISTRY_APNIC      }, // 192.107.113.0   - 192.107.113.255
	{ 0xc06b7200, 0xc06b72ff, REGISTRY_RIPENCC    }, // 192.107.114.0   - 192.107.114.255
	{ 0xc06b7300, 0xc06b79ff, REGISTRY_ARIN       }, // 192.107.115.0   - 192.107.121.255
	{ 0xc06b7a00, 0xc06b81ff, REGISTRY_RIPENCC    }, // 192.107.122.0   - 192.107.129.255
	{ 0xc06b8200, 0xc06b83ff, REGISTRY_ARIN       }, // 192.107.130.0   - 192.107.131.255
	{ 0xc06b8400, 0xc06b84ff, REGISTRY_RIPENCC    }, // 192.107.132.0   - 192.107.132.255
	{ 0xc06b8500, 0xc06ba7ff, REGISTRY_ARIN       }, // 192.107.133.0   - 192.107.167.255
	{ 0xc06ba800, 0xc06ba8ff, REGISTRY_RIPENCC    }, // 192.107.168.0   - 192.107.168.255
	{ 0xc06ba900, 0xc06baaff, REGISTRY_ARIN       }, // 192.107.169.0   - 192.107.170.255
	{ 0xc06bab00, 0xc06bacff, REGISTRY_APNIC      }, // 192.107.171.0   - 192.107.172.255
	{ 0xc06bad00, 0xc06badff, REGISTRY_ARIN       }, // 192.107.173.0   - 192.107.173.255
	{ 0xc06bae00, 0xc06baeff, REGISTRY_RIPENCC    }, // 192.107.174.0   - 192.107.174.255
	{ 0xc06baf00, 0xc06bb0ff, REGISTRY_ARIN       }, // 192.107.175.0   - 192.107.176.255
	{ 0xc06bb100, 0xc06bb2ff, REGISTRY_RIPENCC    }, // 192.107.177.0   - 192.107.178.255
	{ 0xc06bb300, 0xc06bbaff, REGISTRY_ARIN       }, // 192.107.179.0   - 192.107.186.255
	{ 0xc06bbb00, 0xc06bbbff, REGISTRY_RIPENCC    }, // 192.107.187.0   - 192.107.187.255
	{ 0xc06bbc00, 0xc06bc7ff, REGISTRY_ARIN       }, // 192.107.188.0   - 192.107.199.255
	{ 0xc06bc800, 0xc06be7ff, REGISTRY_RIPENCC    }, // 192.107.200.0   - 192.107.231.255
	{ 0xc06be800, 0xc06be9ff, REGISTRY_RIPENCC    }, // 192.107.232.0   - 192.107.233.255
	{ 0xc06bea00, 0xc06beaff, REGISTRY_ARIN       }, // 192.107.234.0   - 192.107.234.255
	{ 0xc06beb00, 0xc06becff, REGISTRY_RIPENCC    }, // 192.107.235.0   - 192.107.236.255
	{ 0xc06bed00, 0xc06c16ff, REGISTRY_ARIN       }, // 192.107.237.0   - 192.108.22.255
	{ 0xc06c1700, 0xc06c31ff, REGISTRY_RIPENCC    }, // 192.108.23.0    - 192.108.49.255
	{ 0xc06c3200, 0xc06c32ff, REGISTRY_ARIN       }, // 192.108.50.0    - 192.108.50.255
	{ 0xc06c3300, 0xc06c5cff, REGISTRY_RIPENCC    }, // 192.108.51.0    - 192.108.92.255
	{ 0xc06c5d00, 0xc06c62ff, REGISTRY_ARIN       }, // 192.108.93.0    - 192.108.98.255
	{ 0xc06c6300, 0xc06c63ff, REGISTRY_APNIC      }, // 192.108.99.0    - 192.108.99.255
	{ 0xc06c6400, 0xc06c65ff, REGISTRY_RIPENCC    }, // 192.108.100.0   - 192.108.101.255
	{ 0xc06c6600, 0xc06c6aff, REGISTRY_ARIN       }, // 192.108.102.0   - 192.108.106.255
	{ 0xc06c6b00, 0xc06c6cff, REGISTRY_RIPENCC    }, // 192.108.107.0   - 192.108.108.255
	{ 0xc06c6d00, 0xc06c70ff, REGISTRY_ARIN       }, // 192.108.109.0   - 192.108.112.255
	{ 0xc06c7200, 0xc06c79ff, REGISTRY_RIPENCC    }, // 192.108.114.0   - 192.108.121.255
	{ 0xc06c7a00, 0xc06c7cff, REGISTRY_ARIN       }, // 192.108.122.0   - 192.108.124.255
	{ 0xc06c7d00, 0xc06c7eff, REGISTRY_RIPENCC    }, // 192.108.125.0   - 192.108.126.255
	{ 0xc06c7f00, 0xc06c7fff, REGISTRY_ARIN       }, // 192.108.127.0   - 192.108.127.255
	{ 0xc06c8000, 0xc06caeff, REGISTRY_RIPENCC    }, // 192.108.128.0   - 192.108.174.255
	{ 0xc06caf00, 0xc06cc2ff, REGISTRY_ARIN       }, // 192.108.175.0   - 192.108.194.255
	{ 0xc06cc300, 0xc06cd6ff, REGISTRY_RIPENCC    }, // 192.108.195.0   - 192.108.214.255
	{ 0xc06cd700, 0xc06ce5ff, REGISTRY_ARIN       }, // 192.108.215.0   - 192.108.229.255
	{ 0xc06ce600, 0xc06ce6ff, REGISTRY_APNIC      }, // 192.108.230.0   - 192.108.230.255
	{ 0xc06ce700, 0xc06ce9ff, REGISTRY_ARIN       }, // 192.108.231.0   - 192.108.233.255
	{ 0xc06cea00, 0xc06ceaff, REGISTRY_RIPENCC    }, // 192.108.234.0   - 192.108.234.255
	{ 0xc06ceb00, 0xc06cedff, REGISTRY_ARIN       }, // 192.108.235.0   - 192.108.237.255
	{ 0xc06cee00, 0xc06ceeff, REGISTRY_RIPENCC    }, // 192.108.238.0   - 192.108.238.255
	{ 0xc06cef00, 0xc06cffff, REGISTRY_ARIN       }, // 192.108.239.0   - 192.108.255.255
	{ 0xc06d0000, 0xc06d09ff, REGISTRY_RIPENCC    }, // 192.109.0.0     - 192.109.9.255
	{ 0xc06d0c00, 0xc06d0eff, REGISTRY_RIPENCC    }, // 192.109.12.0    - 192.109.14.255
	{ 0xc06d1000, 0xc06d10ff, REGISTRY_RIPENCC    }, // 192.109.16.0    - 192.109.16.255
	{ 0xc06d1200, 0xc06d16ff, REGISTRY_RIPENCC    }, // 192.109.18.0    - 192.109.22.255
	{ 0xc06d1800, 0xc06d18ff, REGISTRY_RIPENCC    }, // 192.109.24.0    - 192.109.24.255
	{ 0xc06d1a00, 0xc06d1dff, REGISTRY_RIPENCC    }, // 192.109.26.0    - 192.109.29.255
	{ 0xc06d1f00, 0xc06d1fff, REGISTRY_RIPENCC    }, // 192.109.31.0    - 192.109.31.255
	{ 0xc06d2000, 0xc06d23ff, REGISTRY_RIPENCC    }, // 192.109.32.0    - 192.109.35.255
	{ 0xc06d2400, 0xc06d24ff, REGISTRY_RIPENCC    }, // 192.109.36.0    - 192.109.36.255
	{ 0xc06d2700, 0xc06d27ff, REGISTRY_RIPENCC    }, // 192.109.39.0    - 192.109.39.255
	{ 0xc06d2a00, 0xc06d2cff, REGISTRY_RIPENCC    }, // 192.109.42.0    - 192.109.44.255
	{ 0xc06d2d00, 0xc06d2dff, REGISTRY_ARIN       }, // 192.109.45.0    - 192.109.45.255
	{ 0xc06d2e00, 0xc06d2eff, REGISTRY_RIPENCC    }, // 192.109.46.0    - 192.109.46.255
	{ 0xc06d3000, 0xc06d36ff, REGISTRY_RIPENCC    }, // 192.109.48.0    - 192.109.54.255
	{ 0xc06d3700, 0xc06d37ff, REGISTRY_RIPENCC    }, // 192.109.55.0    - 192.109.55.255
	{ 0xc06d3800, 0xc06d38ff, REGISTRY_RIPENCC    }, // 192.109.56.0    - 192.109.56.255
	{ 0xc06d3900, 0xc06d39ff, REGISTRY_RIPENCC    }, // 192.109.57.0    - 192.109.57.255
	{ 0xc06d3a00, 0xc06d46ff, REGISTRY_RIPENCC    }, // 192.109.58.0    - 192.109.70.255
	{ 0xc06d4800, 0xc06d49ff, REGISTRY_RIPENCC    }, // 192.109.72.0    - 192.109.73.255
	{ 0xc06d4b00, 0xc06d4bff, REGISTRY_ARIN       }, // 192.109.75.0    - 192.109.75.255
	{ 0xc06d4c00, 0xc06d4cff, REGISTRY_RIPENCC    }, // 192.109.76.0    - 192.109.76.255
	{ 0xc06d4e00, 0xc06d4eff, REGISTRY_RIPENCC    }, // 192.109.78.0    - 192.109.78.255
	{ 0xc06d5000, 0xc06d53ff, REGISTRY_RIPENCC    }, // 192.109.80.0    - 192.109.83.255
	{ 0xc06d5600, 0xc06d5aff, REGISTRY_RIPENCC    }, // 192.109.86.0    - 192.109.90.255
	{ 0xc06d5c00, 0xc06d5dff, REGISTRY_ARIN       }, // 192.109.92.0    - 192.109.93.255
	{ 0xc06d5e00, 0xc06d60ff, REGISTRY_RIPENCC    }, // 192.109.94.0    - 192.109.96.255
	{ 0xc06d6300, 0xc06d63ff, REGISTRY_ARIN       }, // 192.109.99.0    - 192.109.99.255
	{ 0xc06d6500, 0xc06d66ff, REGISTRY_RIPENCC    }, // 192.109.101.0   - 192.109.102.255
	{ 0xc06d6700, 0xc06d68ff, REGISTRY_ARIN       }, // 192.109.103.0   - 192.109.104.255
	{ 0xc06d6900, 0xc06d6cff, REGISTRY_RIPENCC    }, // 192.109.105.0   - 192.109.108.255
	{ 0xc06d6f00, 0xc06d6fff, REGISTRY_RIPENCC    }, // 192.109.111.0   - 192.109.111.255
	{ 0xc06d7000, 0xc06d71ff, REGISTRY_RIPENCC    }, // 192.109.112.0   - 192.109.113.255
	{ 0xc06d7200, 0xc06d74ff, REGISTRY_RIPENCC    }, // 192.109.114.0   - 192.109.116.255
	{ 0xc06d7600, 0xc06d76ff, REGISTRY_RIPENCC    }, // 192.109.118.0   - 192.109.118.255
	{ 0xc06d7800, 0xc06d78ff, REGISTRY_ARIN       }, // 192.109.120.0   - 192.109.120.255
	{ 0xc06d7900, 0xc06d7aff, REGISTRY_RIPENCC    }, // 192.109.121.0   - 192.109.122.255
	{ 0xc06d7c00, 0xc06d7cff, REGISTRY_RIPENCC    }, // 192.109.124.0   - 192.109.124.255
	{ 0xc06d7e00, 0xc06d7eff, REGISTRY_RIPENCC    }, // 192.109.126.0   - 192.109.126.255
	{ 0xc06d8000, 0xc06d82ff, REGISTRY_RIPENCC    }, // 192.109.128.0   - 192.109.130.255
	{ 0xc06d8600, 0xc06d87ff, REGISTRY_RIPENCC    }, // 192.109.134.0   - 192.109.135.255
	{ 0xc06d8900, 0xc06d89ff, REGISTRY_RIPENCC    }, // 192.109.137.0   - 192.109.137.255
	{ 0xc06d8c00, 0xc06d94ff, REGISTRY_RIPENCC    }, // 192.109.140.0   - 192.109.148.255
	{ 0xc06d9600, 0xc06d9eff, REGISTRY_RIPENCC    }, // 192.109.150.0   - 192.109.158.255
	{ 0xc06da000, 0xc06da4ff, REGISTRY_RIPENCC    }, // 192.109.160.0   - 192.109.164.255
	{ 0xc06da600, 0xc06dabff, REGISTRY_RIPENCC    }, // 192.109.166.0   - 192.109.171.255
	{ 0xc06dad00, 0xc06daeff, REGISTRY_RIPENCC    }, // 192.109.173.0   - 192.109.174.255
	{ 0xc06daf00, 0xc06dbeff, REGISTRY_RIPENCC    }, // 192.109.175.0   - 192.109.190.255
	{ 0xc06dbf00, 0xc06dc2ff, REGISTRY_RIPENCC    }, // 192.109.191.0   - 192.109.194.255
	{ 0xc06dc300, 0xc06dc3ff, REGISTRY_RIPENCC    }, // 192.109.195.0   - 192.109.195.255
	{ 0xc06dc500, 0xc06dc7ff, REGISTRY_RIPENCC    }, // 192.109.197.0   - 192.109.199.255
	{ 0xc06dca00, 0xc06dcaff, REGISTRY_RIPENCC    }, // 192.109.202.0   - 192.109.202.255
	{ 0xc06dcc00, 0xc06dcfff, REGISTRY_RIPENCC    }, // 192.109.204.0   - 192.109.207.255
	{ 0xc06dd100, 0xc06dd1ff, REGISTRY_RIPENCC    }, // 192.109.209.0   - 192.109.209.255
	{ 0xc06dd300, 0xc06dd5ff, REGISTRY_RIPENCC    }, // 192.109.211.0   - 192.109.213.255
	{ 0xc06dd800, 0xc06dd8ff, REGISTRY_RIPENCC    }, // 192.109.216.0   - 192.109.216.255
	{ 0xc06dda00, 0xc06ddaff, REGISTRY_RIPENCC    }, // 192.109.218.0   - 192.109.218.255
	{ 0xc06ddd00, 0xc06ddeff, REGISTRY_RIPENCC    }, // 192.109.221.0   - 192.109.222.255
	{ 0xc06de200, 0xc06de3ff, REGISTRY_RIPENCC    }, // 192.109.226.0   - 192.109.227.255
	{ 0xc06de600, 0xc06de6ff, REGISTRY_RIPENCC    }, // 192.109.230.0   - 192.109.230.255
	{ 0xc06dea00, 0xc06deaff, REGISTRY_RIPENCC    }, // 192.109.234.0   - 192.109.234.255
	{ 0xc06dec00, 0xc06deeff, REGISTRY_RIPENCC    }, // 192.109.236.0   - 192.109.238.255
	{ 0xc06df200, 0xc06df2ff, REGISTRY_AFRINIC    }, // 192.109.242.0   - 192.109.242.255
	{ 0xc06df600, 0xc06df7ff, REGISTRY_RIPENCC    }, // 192.109.246.0   - 192.109.247.255
	{ 0xc06df900, 0xc06df9ff, REGISTRY_RIPENCC    }, // 192.109.249.0   - 192.109.249.255
	{ 0xc06dfb00, 0xc06dfcff, REGISTRY_RIPENCC    }, // 192.109.251.0   - 192.109.252.255
	{ 0xc06dfe00, 0xc06dffff, REGISTRY_RIPENCC    }, // 192.109.254.0   - 192.109.255.255
	{ 0xc06e0000, 0xc06f1fff, REGISTRY_ARIN       }, // 192.110.0.0     - 192.111.31.255
	{ 0xc06f2000, 0xc06f20ff, REGISTRY_APNIC      }, // 192.111.32.0    - 192.111.32.255
	{ 0xc06f2100, 0xc06f21ff, REGISTRY_RIPENCC    }, // 192.111.33.0    - 192.111.33.255
	{ 0xc06f2200, 0xc06f26ff, REGISTRY_ARIN       }, // 192.111.34.0    - 192.111.38.255
	{ 0xc06f2700, 0xc06f27ff, REGISTRY_RIPENCC    }, // 192.111.39.0    - 192.111.39.255
	{ 0xc06f2800, 0xc06f2bff, REGISTRY_ARIN       }, // 192.111.40.0    - 192.111.43.255
	{ 0xc06f2c00, 0xc06f2cff, REGISTRY_RIPENCC    }, // 192.111.44.0    - 192.111.44.255
	{ 0xc06f2d00, 0xc06f2eff, REGISTRY_ARIN       }, // 192.111.45.0    - 192.111.46.255
	{ 0xc06f2f00, 0xc06f30ff, REGISTRY_RIPENCC    }, // 192.111.47.0    - 192.111.48.255
	{ 0xc06f3100, 0xc06f57ff, REGISTRY_ARIN       }, // 192.111.49.0    - 192.111.87.255
	{ 0xc06f5800, 0xc06f58ff, REGISTRY_RIPENCC    }, // 192.111.88.0    - 192.111.88.255
	{ 0xc06f5900, 0xc06f64ff, REGISTRY_ARIN       }, // 192.111.89.0    - 192.111.100.255
	{ 0xc06f6500, 0xc06f65ff, REGISTRY_RIPENCC    }, // 192.111.101.0   - 192.111.101.255
	{ 0xc06f6600, 0xc06f66ff, REGISTRY_APNIC      }, // 192.111.102.0   - 192.111.102.255
	{ 0xc06f6700, 0xc06f68ff, REGISTRY_RIPENCC    }, // 192.111.103.0   - 192.111.104.255
	{ 0xc06f6900, 0xc06f69ff, REGISTRY_APNIC      }, // 192.111.105.0   - 192.111.105.255
	{ 0xc06f6a00, 0xc06f7bff, REGISTRY_ARIN       }, // 192.111.106.0   - 192.111.123.255
	{ 0xc06f7c00, 0xc06f7dff, REGISTRY_RIPENCC    }, // 192.111.124.0   - 192.111.125.255
	{ 0xc06f7e00, 0xc06f7eff, REGISTRY_ARIN       }, // 192.111.126.0   - 192.111.126.255
	{ 0xc06f7f00, 0xc06f7fff, REGISTRY_RIPENCC    }, // 192.111.127.0   - 192.111.127.255
	{ 0xc06f8000, 0xc06fe4ff, REGISTRY_ARIN       }, // 192.111.128.0   - 192.111.228.255
	{ 0xc06fe500, 0xc06fe6ff, REGISTRY_LACNIC     }, // 192.111.229.0   - 192.111.230.255
	{ 0xc06fe700, 0xc06ffbff, REGISTRY_ARIN       }, // 192.111.231.0   - 192.111.251.255
	{ 0xc06ffc00, 0xc06ffcff, REGISTRY_RIPENCC    }, // 192.111.252.0   - 192.111.252.255
	{ 0xc06ffd00, 0xc0701dff, REGISTRY_ARIN       }, // 192.111.253.0   - 192.112.29.255
	{ 0xc0701e00, 0xc07020ff, REGISTRY_RIPENCC    }, // 192.112.30.0    - 192.112.32.255
	{ 0xc0702100, 0xc0702cff, REGISTRY_ARIN       }, // 192.112.33.0    - 192.112.44.255
	{ 0xc0702d00, 0xc0702dff, REGISTRY_RIPENCC    }, // 192.112.45.0    - 192.112.45.255
	{ 0xc0702e00, 0xc07030ff, REGISTRY_ARIN       }, // 192.112.46.0    - 192.112.48.255
	{ 0xc0703100, 0xc07031ff, REGISTRY_RIPENCC    }, // 192.112.49.0    - 192.112.49.255
	{ 0xc0703200, 0xc0703cff, REGISTRY_ARIN       }, // 192.112.50.0    - 192.112.60.255
	{ 0xc0703d00, 0xc0703dff, REGISTRY_RIPENCC    }, // 192.112.61.0    - 192.112.61.255
	{ 0xc0703e00, 0xc07045ff, REGISTRY_ARIN       }, // 192.112.62.0    - 192.112.69.255
	{ 0xc0704600, 0xc0704fff, REGISTRY_RIPENCC    }, // 192.112.70.0    - 192.112.79.255
	{ 0xc0705000, 0xc07061ff, REGISTRY_ARIN       }, // 192.112.80.0    - 192.112.97.255
	{ 0xc0706200, 0xc07064ff, REGISTRY_RIPENCC    }, // 192.112.98.0    - 192.112.100.255
	{ 0xc0706500, 0xc070cbff, REGISTRY_ARIN       }, // 192.112.101.0   - 192.112.203.255
	{ 0xc070cc00, 0xc070ccff, REGISTRY_RIPENCC    }, // 192.112.204.0   - 192.112.204.255
	{ 0xc070cd00, 0xc070cdff, REGISTRY_ARIN       }, // 192.112.205.0   - 192.112.205.255
	{ 0xc070ce00, 0xc070ceff, REGISTRY_RIPENCC    }, // 192.112.206.0   - 192.112.206.255
	{ 0xc070cf00, 0xc070cfff, REGISTRY_ARIN       }, // 192.112.207.0   - 192.112.207.255
	{ 0xc070d000, 0xc070d0ff, REGISTRY_RIPENCC    }, // 192.112.208.0   - 192.112.208.255
	{ 0xc070d100, 0xc070d4ff, REGISTRY_ARIN       }, // 192.112.209.0   - 192.112.212.255
	{ 0xc070d500, 0xc070d6ff, REGISTRY_RIPENCC    }, // 192.112.213.0   - 192.112.214.255
	{ 0xc070d700, 0xc070d7ff, REGISTRY_APNIC      }, // 192.112.215.0   - 192.112.215.255
	{ 0xc070d800, 0xc070f6ff, REGISTRY_ARIN       }, // 192.112.216.0   - 192.112.246.255
	{ 0xc070f700, 0xc070f7ff, REGISTRY_RIPENCC    }, // 192.112.247.0   - 192.112.247.255
	{ 0xc070f800, 0xc070fdff, REGISTRY_ARIN       }, // 192.112.248.0   - 192.112.253.255
	{ 0xc070fe00, 0xc070feff, REGISTRY_RIPENCC    }, // 192.112.254.0   - 192.112.254.255
	{ 0xc070ff00, 0xc070ffff, REGISTRY_ARIN       }, // 192.112.255.0   - 192.112.255.255
	{ 0xc0710000, 0xc071ffff, REGISTRY_RIPENCC    }, // 192.113.0.0     - 192.113.255.255
	{ 0xc0720000, 0xc07253ff, REGISTRY_RIPENCC    }, // 192.114.0.0     - 192.114.83.255
	{ 0xc0725400, 0xc07257ff, REGISTRY_RIPENCC    }, // 192.114.84.0    - 192.114.87.255
	{ 0xc0725800, 0xc0729fff, REGISTRY_RIPENCC    }, // 192.114.88.0    - 192.114.159.255
	{ 0xc072a000, 0xc072bfff, REGISTRY_RIPENCC    }, // 192.114.160.0   - 192.114.191.255
	{ 0xc072c000, 0xc074bfff, REGISTRY_RIPENCC    }, // 192.114.192.0   - 192.116.191.255
	{ 0xc074c000, 0xc074ffff, REGISTRY_RIPENCC    }, // 192.116.192.0   - 192.116.255.255
	{ 0xc0750000, 0xc0757fff, REGISTRY_RIPENCC    }, // 192.117.0.0     - 192.117.127.255
	{ 0xc0758000, 0xc075bfff, REGISTRY_RIPENCC    }, // 192.117.128.0   - 192.117.191.255
	{ 0xc075c000, 0xc076ffff, REGISTRY_RIPENCC    }, // 192.117.192.0   - 192.118.255.255
	{ 0xc0770000, 0xc078ffff, REGISTRY_ARIN       }, // 192.119.0.0     - 192.120.255.255
	{ 0xc0790000, 0xc079ffff, REGISTRY_RIPENCC    }, // 192.121.0.0     - 192.121.255.255
	{ 0xc07a0000, 0xc07a00ff, REGISTRY_ARIN       }, // 192.122.0.0     - 192.122.0.255
	{ 0xc07a0100, 0xc07a82ff, REGISTRY_RIPENCC    }, // 192.122.1.0     - 192.122.130.255
	{ 0xc07a8300, 0xc07a8cff, REGISTRY_APNIC      }, // 192.122.131.0   - 192.122.140.255
	{ 0xc07a8d00, 0xc07a92ff, REGISTRY_RIPENCC    }, // 192.122.141.0   - 192.122.146.255
	{ 0xc07a9300, 0xc07a96ff, REGISTRY_ARIN       }, // 192.122.147.0   - 192.122.150.255
	{ 0xc07a9700, 0xc07aaaff, REGISTRY_RIPENCC    }, // 192.122.151.0   - 192.122.170.255
	{ 0xc07aab00, 0xc07aabff, REGISTRY_APNIC      }, // 192.122.171.0   - 192.122.171.255
	{ 0xc07aac00, 0xc07aafff, REGISTRY_ARIN       }, // 192.122.172.0   - 192.122.175.255
	{ 0xc07ab000, 0xc07ab0ff, REGISTRY_APNIC      }, // 192.122.176.0   - 192.122.176.255
	{ 0xc07ab100, 0xc07ab3ff, REGISTRY_ARIN       }, // 192.122.177.0   - 192.122.179.255
	{ 0xc07ab400, 0xc07ab4ff, REGISTRY_APNIC      }, // 192.122.180.0   - 192.122.180.255
	{ 0xc07ab500, 0xc07ad1ff, REGISTRY_ARIN       }, // 192.122.181.0   - 192.122.209.255
	{ 0xc07ad300, 0xc07ad5ff, REGISTRY_ARIN       }, // 192.122.211.0   - 192.122.213.255
	{ 0xc07ad600, 0xc07ad6ff, REGISTRY_RIPENCC    }, // 192.122.214.0   - 192.122.214.255
	{ 0xc07ad700, 0xc07ad7ff, REGISTRY_ARIN       }, // 192.122.215.0   - 192.122.215.255
	{ 0xc07ad800, 0xc07aeaff, REGISTRY_RIPENCC    }, // 192.122.216.0   - 192.122.234.255
	{ 0xc07aeb00, 0xc07aedff, REGISTRY_ARIN       }, // 192.122.235.0   - 192.122.237.255
	{ 0xc07aee00, 0xc07af2ff, REGISTRY_RIPENCC    }, // 192.122.238.0   - 192.122.242.255
	{ 0xc07af300, 0xc07afdff, REGISTRY_ARIN       }, // 192.122.243.0   - 192.122.253.255
	{ 0xc07aff00, 0xc07c09ff, REGISTRY_ARIN       }, // 192.122.255.0   - 192.124.9.255
	{ 0xc07c0a00, 0xc07c0eff, REGISTRY_APNIC      }, // 192.124.10.0    - 192.124.14.255
	{ 0xc07c0f00, 0xc07c17ff, REGISTRY_ARIN       }, // 192.124.15.0    - 192.124.23.255
	{ 0xc07c1900, 0xc07c1cff, REGISTRY_RIPENCC    }, // 192.124.25.0    - 192.124.28.255
	{ 0xc07c1d00, 0xc07c1fff, REGISTRY_ARIN       }, // 192.124.29.0    - 192.124.31.255
	{ 0xc07c2000, 0xc07c20ff, REGISTRY_RIPENCC    }, // 192.124.32.0    - 192.124.32.255
	{ 0xc07c2100, 0xc07c26ff, REGISTRY_ARIN       }, // 192.124.33.0    - 192.124.38.255
	{ 0xc07c2700, 0xc07c27ff, REGISTRY_RIPENCC    }, // 192.124.39.0    - 192.124.39.255
	{ 0xc07c2800, 0xc07c2dff, REGISTRY_ARIN       }, // 192.124.40.0    - 192.124.45.255
	{ 0xc07c2e00, 0xc07c2eff, REGISTRY_RIPENCC    }, // 192.124.46.0    - 192.124.46.255
	{ 0xc07c2f00, 0xc07c6fff, REGISTRY_ARIN       }, // 192.124.47.0    - 192.124.111.255
	{ 0xc07c7000, 0xc07c70ff, REGISTRY_RIPENCC    }, // 192.124.112.0   - 192.124.112.255
	{ 0xc07c7100, 0xc07c72ff, REGISTRY_ARIN       }, // 192.124.113.0   - 192.124.114.255
	{ 0xc07c7300, 0xc07c74ff, REGISTRY_RIPENCC    }, // 192.124.115.0   - 192.124.116.255
	{ 0xc07c7500, 0xc07c75ff, REGISTRY_APNIC      }, // 192.124.117.0   - 192.124.117.255
	{ 0xc07c7600, 0xc07c97ff, REGISTRY_ARIN       }, // 192.124.118.0   - 192.124.151.255
	{ 0xc07c9800, 0xc07c98ff, REGISTRY_APNIC      }, // 192.124.152.0   - 192.124.152.255
	{ 0xc07c9900, 0xc07c99ff, REGISTRY_ARIN       }, // 192.124.153.0   - 192.124.153.255
	{ 0xc07c9a00, 0xc07c9aff, REGISTRY_APNIC      }, // 192.124.154.0   - 192.124.154.255
	{ 0xc07c9b00, 0xc07c9bff, REGISTRY_RIPENCC    }, // 192.124.155.0   - 192.124.155.255
	{ 0xc07c9c00, 0xc07ca9ff, REGISTRY_ARIN       }, // 192.124.156.0   - 192.124.169.255
	{ 0xc07caa00, 0xc07cdbff, REGISTRY_RIPENCC    }, // 192.124.170.0   - 192.124.219.255
	{ 0xc07cdc00, 0xc07ceaff, REGISTRY_ARIN       }, // 192.124.220.0   - 192.124.234.255
	{ 0xc07ceb00, 0xc07cebff, REGISTRY_RIPENCC    }, // 192.124.235.0   - 192.124.235.255
	{ 0xc07cec00, 0xc07cecff, REGISTRY_ARIN       }, // 192.124.236.0   - 192.124.236.255
	{ 0xc07ced00, 0xc07cf5ff, REGISTRY_RIPENCC    }, // 192.124.237.0   - 192.124.245.255
	{ 0xc07cf600, 0xc07cf6ff, REGISTRY_ARIN       }, // 192.124.246.0   - 192.124.246.255
	{ 0xc07cf700, 0xc07cf8ff, REGISTRY_RIPENCC    }, // 192.124.247.0   - 192.124.248.255
	{ 0xc07cf900, 0xc07cf9ff, REGISTRY_ARIN       }, // 192.124.249.0   - 192.124.249.255
	{ 0xc07cfa00, 0xc07cfeff, REGISTRY_RIPENCC    }, // 192.124.250.0   - 192.124.254.255
	{ 0xc07cff00, 0xc07cffff, REGISTRY_ARIN       }, // 192.124.255.0   - 192.124.255.255
	{ 0xc07d0000, 0xc07dffff, REGISTRY_RIPENCC    }, // 192.125.0.0     - 192.125.255.255
	{ 0xc07e0000, 0xc07e00ff, REGISTRY_ARIN       }, // 192.126.0.0     - 192.126.0.255
	{ 0xc07e0100, 0xc07e40ff, REGISTRY_RIPENCC    }, // 192.126.1.0     - 192.126.64.255
	{ 0xc07e4100, 0xc08100ff, REGISTRY_ARIN       }, // 192.126.65.0    - 192.129.0.255
	{ 0xc0810100, 0xc08128ff, REGISTRY_RIPENCC    }, // 192.129.1.0     - 192.129.40.255
	{ 0xc0812900, 0xc08129ff, REGISTRY_RIPENCC    }, // 192.129.41.0    - 192.129.41.255
	{ 0xc0812a00, 0xc0813dff, REGISTRY_RIPENCC    }, // 192.129.42.0    - 192.129.61.255
	{ 0xc0813e00, 0xc0814fff, REGISTRY_ARIN       }, // 192.129.62.0    - 192.129.79.255
	{ 0xc0815000, 0xc08150ff, REGISTRY_RIPENCC    }, // 192.129.80.0    - 192.129.80.255
	{ 0xc0815100, 0xc08156ff, REGISTRY_ARIN       }, // 192.129.81.0    - 192.129.86.255
	{ 0xc0815700, 0xc08157ff, REGISTRY_RIPENCC    }, // 192.129.87.0    - 192.129.87.255
	{ 0xc0815800, 0xc08161ff, REGISTRY_ARIN       }, // 192.129.88.0    - 192.129.97.255
	{ 0xc0816200, 0xc08162ff, REGISTRY_RIPENCC    }, // 192.129.98.0    - 192.129.98.255
	{ 0xc0816300, 0xc081ffff, REGISTRY_ARIN       }, // 192.129.99.0    - 192.129.255.255
	{ 0xc0820000, 0xc082ffff, REGISTRY_RIPENCC    }, // 192.130.0.0     - 192.130.255.255
	{ 0xc0830000, 0xc0830cff, REGISTRY_ARIN       }, // 192.131.0.0     - 192.131.12.255
	{ 0xc0830d00, 0xc0830dff, REGISTRY_APNIC      }, // 192.131.13.0    - 192.131.13.255
	{ 0xc0830e00, 0xc08313ff, REGISTRY_ARIN       }, // 192.131.14.0    - 192.131.19.255
	{ 0xc0831400, 0xc08314ff, REGISTRY_RIPENCC    }, // 192.131.20.0    - 192.131.20.255
	{ 0xc0831500, 0xc08318ff, REGISTRY_ARIN       }, // 192.131.21.0    - 192.131.24.255
	{ 0xc0831900, 0xc0831aff, REGISTRY_RIPENCC    }, // 192.131.25.0    - 192.131.26.255
	{ 0xc0831b00, 0xc0831eff, REGISTRY_APNIC      }, // 192.131.27.0    - 192.131.30.255
	{ 0xc0831f00, 0xc0834eff, REGISTRY_ARIN       }, // 192.131.31.0    - 192.131.78.255
	{ 0xc0834f00, 0xc0834fff, REGISTRY_RIPENCC    }, // 192.131.79.0    - 192.131.79.255
	{ 0xc0835000, 0xc08358ff, REGISTRY_ARIN       }, // 192.131.80.0    - 192.131.88.255
	{ 0xc0835900, 0xc08359ff, REGISTRY_RIPENCC    }, // 192.131.89.0    - 192.131.89.255
	{ 0xc0835a00, 0xc0835cff, REGISTRY_APNIC      }, // 192.131.90.0    - 192.131.92.255
	{ 0xc0835d00, 0xc0835fff, REGISTRY_ARIN       }, // 192.131.93.0    - 192.131.95.255
	{ 0xc0836000, 0xc08360ff, REGISTRY_RIPENCC    }, // 192.131.96.0    - 192.131.96.255
	{ 0xc0836100, 0xc0836bff, REGISTRY_ARIN       }, // 192.131.97.0    - 192.131.107.255
	{ 0xc0836c00, 0xc0836cff, REGISTRY_RIPENCC    }, // 192.131.108.0   - 192.131.108.255
	{ 0xc0836d00, 0xc08383ff, REGISTRY_ARIN       }, // 192.131.109.0   - 192.131.131.255
	{ 0xc0838400, 0xc08384ff, REGISTRY_RIPENCC    }, // 192.131.132.0   - 192.131.132.255
	{ 0xc0838500, 0xc083faff, REGISTRY_ARIN       }, // 192.131.133.0   - 192.131.250.255
	{ 0xc083fb00, 0xc083fcff, REGISTRY_APNIC      }, // 192.131.251.0   - 192.131.252.255
	{ 0xc083fd00, 0xc08408ff, REGISTRY_ARIN       }, // 192.131.253.0   - 192.132.8.255
	{ 0xc0840900, 0xc0840bff, REGISTRY_RIPENCC    }, // 192.132.9.0     - 192.132.11.255
	{ 0xc0840c00, 0xc0840eff, REGISTRY_ARIN       }, // 192.132.12.0    - 192.132.14.255
	{ 0xc0840f00, 0xc0840fff, REGISTRY_APNIC      }, // 192.132.15.0    - 192.132.15.255
	{ 0xc0841000, 0xc0841eff, REGISTRY_ARIN       }, // 192.132.16.0    - 192.132.30.255
	{ 0xc0841f00, 0xc0841fff, REGISTRY_APNIC      }, // 192.132.31.0    - 192.132.31.255
	{ 0xc0842000, 0xc08421ff, REGISTRY_ARIN       }, // 192.132.32.0    - 192.132.33.255
	{ 0xc0842200, 0xc08422ff, REGISTRY_RIPENCC    }, // 192.132.34.0    - 192.132.34.255
	{ 0xc0842300, 0xc08423ff, REGISTRY_LACNIC     }, // 192.132.35.0    - 192.132.35.255
	{ 0xc0842400, 0xc08428ff, REGISTRY_ARIN       }, // 192.132.36.0    - 192.132.40.255
	{ 0xc0842900, 0xc08429ff, REGISTRY_APNIC      }, // 192.132.41.0    - 192.132.41.255
	{ 0xc0842a00, 0xc08434ff, REGISTRY_ARIN       }, // 192.132.42.0    - 192.132.52.255
	{ 0xc0843500, 0xc08435ff, REGISTRY_RIPENCC    }, // 192.132.53.0    - 192.132.53.255
	{ 0xc0843600, 0xc08436ff, REGISTRY_ARIN       }, // 192.132.54.0    - 192.132.54.255
	{ 0xc0843700, 0xc08437ff, REGISTRY_RIPENCC    }, // 192.132.55.0    - 192.132.55.255
	{ 0xc0843800, 0xc0845cff, REGISTRY_ARIN       }, // 192.132.56.0    - 192.132.92.255
	{ 0xc0845d00, 0xc0845dff, REGISTRY_APNIC      }, // 192.132.93.0    - 192.132.93.255
	{ 0xc0845e00, 0xc08462ff, REGISTRY_ARIN       }, // 192.132.94.0    - 192.132.98.255
	{ 0xc0846300, 0xc08463ff, REGISTRY_RIPENCC    }, // 192.132.99.0    - 192.132.99.255
	{ 0xc0846400, 0xc08465ff, REGISTRY_ARIN       }, // 192.132.100.0   - 192.132.101.255
	{ 0xc0846700, 0xc084eeff, REGISTRY_ARIN       }, // 192.132.103.0   - 192.132.238.255
	{ 0xc084ef00, 0xc084efff, REGISTRY_RIPENCC    }, // 192.132.239.0   - 192.132.239.255
	{ 0xc084f000, 0xc084f3ff, REGISTRY_ARIN       }, // 192.132.240.0   - 192.132.243.255
	{ 0xc084f400, 0xc084f5ff, REGISTRY_RIPENCC    }, // 192.132.244.0   - 192.132.245.255
	{ 0xc084f600, 0xc084f6ff, REGISTRY_ARIN       }, // 192.132.246.0   - 192.132.246.255
	{ 0xc084f700, 0xc084fbff, REGISTRY_APNIC      }, // 192.132.247.0   - 192.132.251.255
	{ 0xc084fc00, 0xc084fcff, REGISTRY_RIPENCC    }, // 192.132.252.0   - 192.132.252.255
	{ 0xc084fd00, 0xc084fdff, REGISTRY_APNIC      }, // 192.132.253.0   - 192.132.253.255
	{ 0xc084fe00, 0xc08509ff, REGISTRY_ARIN       }, // 192.132.254.0   - 192.133.9.255
	{ 0xc0850b00, 0xc0850dff, REGISTRY_ARIN       }, // 192.133.11.0    - 192.133.13.255
	{ 0xc0850f00, 0xc0850fff, REGISTRY_RIPENCC    }, // 192.133.15.0    - 192.133.15.255
	{ 0xc0851000, 0xc08514ff, REGISTRY_ARIN       }, // 192.133.16.0    - 192.133.20.255
	{ 0xc0851500, 0xc08515ff, REGISTRY_APNIC      }, // 192.133.21.0    - 192.133.21.255
	{ 0xc0851600, 0xc0851bff, REGISTRY_ARIN       }, // 192.133.22.0    - 192.133.27.255
	{ 0xc0851c00, 0xc0851cff, REGISTRY_RIPENCC    }, // 192.133.28.0    - 192.133.28.255
	{ 0xc0851d00, 0xc0851eff, REGISTRY_ARIN       }, // 192.133.29.0    - 192.133.30.255
	{ 0xc0851f00, 0xc0851fff, REGISTRY_APNIC      }, // 192.133.31.0    - 192.133.31.255
	{ 0xc0852000, 0xc08520ff, REGISTRY_RIPENCC    }, // 192.133.32.0    - 192.133.32.255
	{ 0xc0852100, 0xc08523ff, REGISTRY_ARIN       }, // 192.133.33.0    - 192.133.35.255
	{ 0xc0852400, 0xc08524ff, REGISTRY_RIPENCC    }, // 192.133.36.0    - 192.133.36.255
	{ 0xc0852500, 0xc08528ff, REGISTRY_ARIN       }, // 192.133.37.0    - 192.133.40.255
	{ 0xc0852900, 0xc08529ff, REGISTRY_APNIC      }, // 192.133.41.0    - 192.133.41.255
	{ 0xc0852a00, 0xc08534ff, REGISTRY_ARIN       }, // 192.133.42.0    - 192.133.52.255
	{ 0xc0853500, 0xc08537ff, REGISTRY_RIPENCC    }, // 192.133.53.0    - 192.133.55.255
	{ 0xc0853800, 0xc08539ff, REGISTRY_ARIN       }, // 192.133.56.0    - 192.133.57.255
	{ 0xc0853a00, 0xc0853aff, REGISTRY_RIPENCC    }, // 192.133.58.0    - 192.133.58.255
	{ 0xc0853b00, 0xc0853fff, REGISTRY_ARIN       }, // 192.133.59.0    - 192.133.63.255
	{ 0xc0854000, 0xc08540ff, REGISTRY_RIPENCC    }, // 192.133.64.0    - 192.133.64.255
	{ 0xc0854100, 0xc08541ff, REGISTRY_ARIN       }, // 192.133.65.0    - 192.133.65.255
	{ 0xc0854300, 0xc08543ff, REGISTRY_APNIC      }, // 192.133.67.0    - 192.133.67.255
	{ 0xc0854400, 0xc0856bff, REGISTRY_ARIN       }, // 192.133.68.0    - 192.133.107.255
	{ 0xc0856c00, 0xc0856fff, REGISTRY_RIPENCC    }, // 192.133.108.0   - 192.133.111.255
	{ 0xc0857000, 0xc08578ff, REGISTRY_ARIN       }, // 192.133.112.0   - 192.133.120.255
	{ 0xc0857900, 0xc08579ff, REGISTRY_RIPENCC    }, // 192.133.121.0   - 192.133.121.255
	{ 0xc0857a00, 0xc08582ff, REGISTRY_ARIN       }, // 192.133.122.0   - 192.133.130.255
	{ 0xc0858300, 0xc08583ff, REGISTRY_RIPENCC    }, // 192.133.131.0   - 192.133.131.255
	{ 0xc0858400, 0xc085f3ff, REGISTRY_ARIN       }, // 192.133.132.0   - 192.133.243.255
	{ 0xc085f400, 0xc085f4ff, REGISTRY_RIPENCC    }, // 192.133.244.0   - 192.133.244.255
	{ 0xc085f500, 0xc085f9ff, REGISTRY_ARIN       }, // 192.133.245.0   - 192.133.249.255
	{ 0xc085fa00, 0xc085faff, REGISTRY_AFRINIC    }, // 192.133.250.0   - 192.133.250.255
	{ 0xc085fb00, 0xc085ffff, REGISTRY_ARIN       }, // 192.133.251.0   - 192.133.255.255
	{ 0xc0860000, 0xc086ffff, REGISTRY_RIPENCC    }, // 192.134.0.0     - 192.134.255.255
	{ 0xc0870000, 0xc08706ff, REGISTRY_ARIN       }, // 192.135.0.0     - 192.135.6.255
	{ 0xc0870700, 0xc08725ff, REGISTRY_RIPENCC    }, // 192.135.7.0     - 192.135.37.255
	{ 0xc0872600, 0xc0872dff, REGISTRY_ARIN       }, // 192.135.38.0    - 192.135.45.255
	{ 0xc0872e00, 0xc0872eff, REGISTRY_RIPENCC    }, // 192.135.46.0    - 192.135.46.255
	{ 0xc0872f00, 0xc08732ff, REGISTRY_ARIN       }, // 192.135.47.0    - 192.135.50.255
	{ 0xc0873300, 0xc08735ff, REGISTRY_RIPENCC    }, // 192.135.51.0    - 192.135.53.255
	{ 0xc0873600, 0xc0873eff, REGISTRY_ARIN       }, // 192.135.54.0    - 192.135.62.255
	{ 0xc0874000, 0xc08741ff, REGISTRY_ARIN       }, // 192.135.64.0    - 192.135.65.255
	{ 0xc0874200, 0xc08742ff, REGISTRY_RIPENCC    }, // 192.135.66.0    - 192.135.66.255
	{ 0xc0874300, 0xc08743ff, REGISTRY_ARIN       }, // 192.135.67.0    - 192.135.67.255
	{ 0xc0874400, 0xc08744ff, REGISTRY_RIPENCC    }, // 192.135.68.0    - 192.135.68.255
	{ 0xc0874500, 0xc08751ff, REGISTRY_ARIN       }, // 192.135.69.0    - 192.135.81.255
	{ 0xc0875200, 0xc08752ff, REGISTRY_RIPENCC    }, // 192.135.82.0    - 192.135.82.255
	{ 0xc0875300, 0xc08758ff, REGISTRY_ARIN       }, // 192.135.83.0    - 192.135.88.255
	{ 0xc0875a00, 0xc0875bff, REGISTRY_APNIC      }, // 192.135.90.0    - 192.135.91.255
	{ 0xc0875d00, 0xc0875dff, REGISTRY_ARIN       }, // 192.135.93.0    - 192.135.93.255
	{ 0xc0875e00, 0xc0875eff, REGISTRY_APNIC      }, // 192.135.94.0    - 192.135.94.255
	{ 0xc0875f00, 0xc0875fff, REGISTRY_LACNIC     }, // 192.135.95.0    - 192.135.95.255
	{ 0xc0876000, 0xc08760ff, REGISTRY_APNIC      }, // 192.135.96.0    - 192.135.96.255
	{ 0xc0876300, 0xc08763ff, REGISTRY_APNIC      }, // 192.135.99.0    - 192.135.99.255
	{ 0xc0876500, 0xc08765ff, REGISTRY_APNIC      }, // 192.135.101.0   - 192.135.101.255
	{ 0xc0876700, 0xc0876cff, REGISTRY_APNIC      }, // 192.135.103.0   - 192.135.108.255
	{ 0xc0876d00, 0xc08780ff, REGISTRY_ARIN       }, // 192.135.109.0   - 192.135.128.255
	{ 0xc0878100, 0xc08781ff, REGISTRY_RIPENCC    }, // 192.135.129.0   - 192.135.129.255
	{ 0xc0878200, 0xc08784ff, REGISTRY_ARIN       }, // 192.135.130.0   - 192.135.132.255
	{ 0xc0878500, 0xc08785ff, REGISTRY_RIPENCC    }, // 192.135.133.0   - 192.135.133.255
	{ 0xc0878600, 0xc0878eff, REGISTRY_ARIN       }, // 192.135.134.0   - 192.135.142.255
	{ 0xc0878f00, 0xc0878fff, REGISTRY_RIPENCC    }, // 192.135.143.0   - 192.135.143.255
	{ 0xc0879000, 0xc08790ff, REGISTRY_ARIN       }, // 192.135.144.0   - 192.135.144.255
	{ 0xc0879100, 0xc087a8ff, REGISTRY_RIPENCC    }, // 192.135.145.0   - 192.135.168.255
	{ 0xc087a900, 0xc087aeff, REGISTRY_ARIN       }, // 192.135.169.0   - 192.135.174.255
	{ 0xc087af00, 0xc087afff, REGISTRY_RIPENCC    }, // 192.135.175.0   - 192.135.175.255
	{ 0xc087b000, 0xc087b8ff, REGISTRY_ARIN       }, // 192.135.176.0   - 192.135.184.255
	{ 0xc087b900, 0xc087b9ff, REGISTRY_LACNIC     }, // 192.135.185.0   - 192.135.185.255
	{ 0xc087ba00, 0xc087baff, REGISTRY_ARIN       }, // 192.135.186.0   - 192.135.186.255
	{ 0xc087bb00, 0xc087bbff, REGISTRY_RIPENCC    }, // 192.135.187.0   - 192.135.187.255
	{ 0xc087bc00, 0xc087ceff, REGISTRY_ARIN       }, // 192.135.188.0   - 192.135.206.255
	{ 0xc087cf00, 0xc087d0ff, REGISTRY_APNIC      }, // 192.135.207.0   - 192.135.208.255
	{ 0xc087d100, 0xc087d1ff, REGISTRY_ARIN       }, // 192.135.209.0   - 192.135.209.255
	{ 0xc087d300, 0xc087daff, REGISTRY_ARIN       }, // 192.135.211.0   - 192.135.218.255
	{ 0xc087db00, 0xc087dbff, REGISTRY_RIPENCC    }, // 192.135.219.0   - 192.135.219.255
	{ 0xc087dc00, 0xc087ddff, REGISTRY_ARIN       }, // 192.135.220.0   - 192.135.221.255
	{ 0xc087de00, 0xc087deff, REGISTRY_APNIC      }, // 192.135.222.0   - 192.135.222.255
	{ 0xc087df00, 0xc087e0ff, REGISTRY_ARIN       }, // 192.135.223.0   - 192.135.224.255
	{ 0xc087e100, 0xc087e1ff, REGISTRY_RIPENCC    }, // 192.135.225.0   - 192.135.225.255
	{ 0xc087e200, 0xc087e6ff, REGISTRY_ARIN       }, // 192.135.226.0   - 192.135.230.255
	{ 0xc087e700, 0xc087eaff, REGISTRY_RIPENCC    }, // 192.135.231.0   - 192.135.234.255
	{ 0xc087eb00, 0xc087fcff, REGISTRY_ARIN       }, // 192.135.235.0   - 192.135.252.255
	{ 0xc087fd00, 0xc087feff, REGISTRY_RIPENCC    }, // 192.135.253.0   - 192.135.254.255
	{ 0xc087ff00, 0xc08806ff, REGISTRY_ARIN       }, // 192.135.255.0   - 192.136.6.255
	{ 0xc0880700, 0xc08807ff, REGISTRY_RIPENCC    }, // 192.136.7.0     - 192.136.7.255
	{ 0xc0880800, 0xc08808ff, REGISTRY_ARIN       }, // 192.136.8.0     - 192.136.8.255
	{ 0xc0880900, 0xc08809ff, REGISTRY_RIPENCC    }, // 192.136.9.0     - 192.136.9.255
	{ 0xc0880a00, 0xc08811ff, REGISTRY_ARIN       }, // 192.136.10.0    - 192.136.17.255
	{ 0xc0881200, 0xc08813ff, REGISTRY_RIPENCC    }, // 192.136.18.0    - 192.136.19.255
	{ 0xc0881400, 0xc08816ff, REGISTRY_ARIN       }, // 192.136.20.0    - 192.136.22.255
	{ 0xc0881700, 0xc08817ff, REGISTRY_RIPENCC    }, // 192.136.23.0    - 192.136.23.255
	{ 0xc0881800, 0xc0881cff, REGISTRY_ARIN       }, // 192.136.24.0    - 192.136.28.255
	{ 0xc0881d00, 0xc0881fff, REGISTRY_RIPENCC    }, // 192.136.29.0    - 192.136.31.255
	{ 0xc0882000, 0xc08826ff, REGISTRY_ARIN       }, // 192.136.32.0    - 192.136.38.255
	{ 0xc0882700, 0xc08827ff, REGISTRY_APNIC      }, // 192.136.39.0    - 192.136.39.255
	{ 0xc0882800, 0xc08829ff, REGISTRY_RIPENCC    }, // 192.136.40.0    - 192.136.41.255
	{ 0xc0882a00, 0xc0882fff, REGISTRY_LACNIC     }, // 192.136.42.0    - 192.136.47.255
	{ 0xc0883000, 0xc08830ff, REGISTRY_ARIN       }, // 192.136.48.0    - 192.136.48.255
	{ 0xc0883100, 0xc08831ff, REGISTRY_RIPENCC    }, // 192.136.49.0    - 192.136.49.255
	{ 0xc0883200, 0xc08832ff, REGISTRY_ARIN       }, // 192.136.50.0    - 192.136.50.255
	{ 0xc0883300, 0xc08834ff, REGISTRY_RIPENCC    }, // 192.136.51.0    - 192.136.52.255
	{ 0xc0883500, 0xc08836ff, REGISTRY_ARIN       }, // 192.136.53.0    - 192.136.54.255
	{ 0xc0883700, 0xc08839ff, REGISTRY_AFRINIC    }, // 192.136.55.0    - 192.136.57.255
	{ 0xc0883a00, 0xc0883aff, REGISTRY_ARIN       }, // 192.136.58.0    - 192.136.58.255
	{ 0xc0883b00, 0xc0883bff, REGISTRY_APNIC      }, // 192.136.59.0    - 192.136.59.255
	{ 0xc0883c00, 0xc0883cff, REGISTRY_ARIN       }, // 192.136.60.0    - 192.136.60.255
	{ 0xc0883d00, 0xc0883dff, REGISTRY_RIPENCC    }, // 192.136.61.0    - 192.136.61.255
	{ 0xc0883e00, 0xc08846ff, REGISTRY_ARIN       }, // 192.136.62.0    - 192.136.70.255
	{ 0xc0884700, 0xc08866ff, REGISTRY_RIPENCC    }, // 192.136.71.0    - 192.136.102.255
	{ 0xc0886700, 0xc0888cff, REGISTRY_ARIN       }, // 192.136.103.0   - 192.136.140.255
	{ 0xc0889000, 0xc08899ff, REGISTRY_ARIN       }, // 192.136.144.0   - 192.136.153.255
	{ 0xc0889a00, 0xc0889cff, REGISTRY_RIPENCC    }, // 192.136.154.0   - 192.136.156.255
	{ 0xc0889d00, 0xc08a00ff, REGISTRY_ARIN       }, // 192.136.157.0   - 192.138.0.255
	{ 0xc08a0100, 0xc08a08ff, REGISTRY_RIPENCC    }, // 192.138.1.0     - 192.138.8.255
	{ 0xc08a0900, 0xc08a55ff, REGISTRY_ARIN       }, // 192.138.9.0     - 192.138.85.255
	{ 0xc08a5600, 0xc08a56ff, REGISTRY_RIPENCC    }, // 192.138.86.0    - 192.138.86.255
	{ 0xc08a5700, 0xc08a63ff, REGISTRY_ARIN       }, // 192.138.87.0    - 192.138.99.255
	{ 0xc08a6400, 0xc08a64ff, REGISTRY_APNIC      }, // 192.138.100.0   - 192.138.100.255
	{ 0xc08a6500, 0xc08a68ff, REGISTRY_ARIN       }, // 192.138.101.0   - 192.138.104.255
	{ 0xc08a6900, 0xc08a75ff, REGISTRY_RIPENCC    }, // 192.138.105.0   - 192.138.117.255
	{ 0xc08a7e00, 0xc08a9aff, REGISTRY_ARIN       }, // 192.138.126.0   - 192.138.154.255
	{ 0xc08a9b00, 0xc08a9eff, REGISTRY_RIPENCC    }, // 192.138.155.0   - 192.138.158.255
	{ 0xc08a9f00, 0xc08ab6ff, REGISTRY_ARIN       }, // 192.138.159.0   - 192.138.182.255
	{ 0xc08ab700, 0xc08ab7ff, REGISTRY_RIPENCC    }, // 192.138.183.0   - 192.138.183.255
	{ 0xc08ab800, 0xc08abbff, REGISTRY_ARIN       }, // 192.138.184.0   - 192.138.187.255
	{ 0xc08abd00, 0xc08abfff, REGISTRY_ARIN       }, // 192.138.189.0   - 192.138.191.255
	{ 0xc08ac000, 0xc08ac0ff, REGISTRY_RIPENCC    }, // 192.138.192.0   - 192.138.192.255
	{ 0xc08ac100, 0xc08acbff, REGISTRY_ARIN       }, // 192.138.193.0   - 192.138.203.255
	{ 0xc08acc00, 0xc08accff, REGISTRY_RIPENCC    }, // 192.138.204.0   - 192.138.204.255
	{ 0xc08acd00, 0xc08ae3ff, REGISTRY_ARIN       }, // 192.138.205.0   - 192.138.227.255
	{ 0xc08ae400, 0xc08ae8ff, REGISTRY_RIPENCC    }, // 192.138.228.0   - 192.138.232.255
	{ 0xc08ae900, 0xc08af7ff, REGISTRY_ARIN       }, // 192.138.233.0   - 192.138.247.255
	{ 0xc08af800, 0xc08af8ff, REGISTRY_RIPENCC    }, // 192.138.248.0   - 192.138.248.255
	{ 0xc08af900, 0xc08afaff, REGISTRY_ARIN       }, // 192.138.249.0   - 192.138.250.255
	{ 0xc08afb00, 0xc08afbff, REGISTRY_APNIC      }, // 192.138.251.0   - 192.138.251.255
	{ 0xc08afc00, 0xc08b4dff, REGISTRY_ARIN       }, // 192.138.252.0   - 192.139.77.255
	{ 0xc08b4e00, 0xc08b4eff, REGISTRY_RIPENCC    }, // 192.139.78.0    - 192.139.78.255
	{ 0xc08b4f00, 0xc08c00ff, REGISTRY_ARIN       }, // 192.139.79.0    - 192.140.0.255
	{ 0xc08c0100, 0xc08c01ff, REGISTRY_LACNIC     }, // 192.140.1.0     - 192.140.1.255
	{ 0xc08c0400, 0xc08c07ff, REGISTRY_ARIN       }, // 192.140.4.0     - 192.140.7.255
	{ 0xc08c0800, 0xc08c7fff, REGISTRY_LACNIC     }, // 192.140.8.0     - 192.140.127.255
	{ 0xc08c8000, 0xc08cffff, REGISTRY_APNIC      }, // 192.140.128.0   - 192.140.255.255
	{ 0xc08d0000, 0xc08dffff, REGISTRY_LACNIC     }, // 192.141.0.0     - 192.141.255.255
	{ 0xc08e0000, 0xc08fffff, REGISTRY_AFRINIC    }, // 192.142.0.0     - 192.143.255.255
	{ 0xc0900000, 0xc0903fff, REGISTRY_RIPENCC    }, // 192.144.0.0     - 192.144.63.255
	{ 0xc0904000, 0xc09049ff, REGISTRY_LACNIC     }, // 192.144.64.0    - 192.144.73.255
	{ 0xc0904a00, 0xc0904aff, REGISTRY_RIPENCC    }, // 192.144.74.0    - 192.144.74.255
	{ 0xc0904c00, 0xc0904dff, REGISTRY_RIPENCC    }, // 192.144.76.0    - 192.144.77.255
	{ 0xc0904e00, 0xc0905fff, REGISTRY_APNIC      }, // 192.144.78.0    - 192.144.95.255
	{ 0xc0906000, 0xc0907fff, REGISTRY_LACNIC     }, // 192.144.96.0    - 192.144.127.255
	{ 0xc0908000, 0xc090ffff, REGISTRY_APNIC      }, // 192.144.128.0   - 192.144.255.255
	{ 0xc0910000, 0xc0917fff, REGISTRY_RIPENCC    }, // 192.145.0.0     - 192.145.127.255
	{ 0xc091c000, 0xc091dfff, REGISTRY_LACNIC     }, // 192.145.192.0   - 192.145.223.255
	{ 0xc091e000, 0xc091e3ff, REGISTRY_RIPENCC    }, // 192.145.224.0   - 192.145.227.255
	{ 0xc091e400, 0xc091e5ff, REGISTRY_APNIC      }, // 192.145.228.0   - 192.145.229.255
	{ 0xc091e700, 0xc09274ff, REGISTRY_ARIN       }, // 192.145.231.0   - 192.146.116.255
	{ 0xc0927500, 0xc09275ff, REGISTRY_RIPENCC    }, // 192.146.117.0   - 192.146.117.255
	{ 0xc0927600, 0xc09276ff, REGISTRY_ARIN       }, // 192.146.118.0   - 192.146.118.255
	{ 0xc0927700, 0xc09277ff, REGISTRY_RIPENCC    }, // 192.146.119.0   - 192.146.119.255
	{ 0xc0927800, 0xc0927aff, REGISTRY_ARIN       }, // 192.146.120.0   - 192.146.122.255
	{ 0xc0927b00, 0xc0927eff, REGISTRY_RIPENCC    }, // 192.146.123.0   - 192.146.126.255
	{ 0xc0927f00, 0xc09283ff, REGISTRY_ARIN       }, // 192.146.127.0   - 192.146.131.255
	{ 0xc0928400, 0xc09284ff, REGISTRY_RIPENCC    }, // 192.146.132.0   - 192.146.132.255
	{ 0xc0928500, 0xc09285ff, REGISTRY_APNIC      }, // 192.146.133.0   - 192.146.133.255
	{ 0xc0928600, 0xc09289ff, REGISTRY_RIPENCC    }, // 192.146.134.0   - 192.146.137.255
	{ 0xc0928c00, 0xc0928dff, REGISTRY_RIPENCC    }, // 192.146.140.0   - 192.146.141.255
	{ 0xc0928e00, 0xc09295ff, REGISTRY_ARIN       }, // 192.146.142.0   - 192.146.149.255
	{ 0xc0929600, 0xc09296ff, REGISTRY_APNIC      }, // 192.146.150.0   - 192.146.150.255
	{ 0xc0929700, 0xc09297ff, REGISTRY_ARIN       }, // 192.146.151.0   - 192.146.151.255
	{ 0xc0929800, 0xc09298ff, REGISTRY_RIPENCC    }, // 192.146.152.0   - 192.146.152.255
	{ 0xc0929900, 0xc0929cff, REGISTRY_ARIN       }, // 192.146.153.0   - 192.146.156.255
	{ 0xc0929d00, 0xc0929dff, REGISTRY_LACNIC     }, // 192.146.157.0   - 192.146.157.255
	{ 0xc0929e00, 0xc092a2ff, REGISTRY_ARIN       }, // 192.146.158.0   - 192.146.162.255
	{ 0xc092a300, 0xc092aaff, REGISTRY_RIPENCC    }, // 192.146.163.0   - 192.146.170.255
	{ 0xc092ab00, 0xc092abff, REGISTRY_ARIN       }, // 192.146.171.0   - 192.146.171.255
	{ 0xc092ac00, 0xc092b6ff, REGISTRY_RIPENCC    }, // 192.146.172.0   - 192.146.182.255
	{ 0xc092b700, 0xc092b7ff, REGISTRY_ARIN       }, // 192.146.183.0   - 192.146.183.255
	{ 0xc092b800, 0xc092b8ff, REGISTRY_APNIC      }, // 192.146.184.0   - 192.146.184.255
	{ 0xc092b900, 0xc092b9ff, REGISTRY_RIPENCC    }, // 192.146.185.0   - 192.146.185.255
	{ 0xc092ba00, 0xc092baff, REGISTRY_ARIN       }, // 192.146.186.0   - 192.146.186.255
	{ 0xc092bb00, 0xc092bbff, REGISTRY_RIPENCC    }, // 192.146.187.0   - 192.146.187.255
	{ 0xc092bc00, 0xc092bcff, REGISTRY_ARIN       }, // 192.146.188.0   - 192.146.188.255
	{ 0xc092be00, 0xc092c0ff, REGISTRY_ARIN       }, // 192.146.190.0   - 192.146.192.255
	{ 0xc092c100, 0xc092c1ff, REGISTRY_RIPENCC    }, // 192.146.193.0   - 192.146.193.255
	{ 0xc092c200, 0xc092c7ff, REGISTRY_ARIN       }, // 192.146.194.0   - 192.146.199.255
	{ 0xc092c800, 0xc092c8ff, REGISTRY_APNIC      }, // 192.146.200.0   - 192.146.200.255
	{ 0xc092c900, 0xc092cbff, REGISTRY_ARIN       }, // 192.146.201.0   - 192.146.203.255
	{ 0xc092cc00, 0xc092ccff, REGISTRY_RIPENCC    }, // 192.146.204.0   - 192.146.204.255
	{ 0xc092cd00, 0xc092d9ff, REGISTRY_ARIN       }, // 192.146.205.0   - 192.146.217.255
	{ 0xc092da00, 0xc092dbff, REGISTRY_APNIC      }, // 192.146.218.0   - 192.146.219.255
	{ 0xc092dc00, 0xc092e2ff, REGISTRY_ARIN       }, // 192.146.220.0   - 192.146.226.255
	{ 0xc092e300, 0xc092e4ff, REGISTRY_RIPENCC    }, // 192.146.227.0   - 192.146.228.255
	{ 0xc092e500, 0xc092e5ff, REGISTRY_LACNIC     }, // 192.146.229.0   - 192.146.229.255
	{ 0xc092e600, 0xc092e7ff, REGISTRY_ARIN       }, // 192.146.230.0   - 192.146.231.255
	{ 0xc092e900, 0xc092eaff, REGISTRY_RIPENCC    }, // 192.146.233.0   - 192.146.234.255
	{ 0xc092eb00, 0xc092ecff, REGISTRY_ARIN       }, // 192.146.235.0   - 192.146.236.255
	{ 0xc092ed00, 0xc092edff, REGISTRY_LACNIC     }, // 192.146.237.0   - 192.146.237.255
	{ 0xc092ee00, 0xc092efff, REGISTRY_RIPENCC    }, // 192.146.238.0   - 192.146.239.255
	{ 0xc092f000, 0xc092f1ff, REGISTRY_ARIN       }, // 192.146.240.0   - 192.146.241.255
	{ 0xc092f200, 0xc092f2ff, REGISTRY_RIPENCC    }, // 192.146.242.0   - 192.146.242.255
	{ 0xc092f300, 0xc092faff, REGISTRY_ARIN       }, // 192.146.243.0   - 192.146.250.255
	{ 0xc092fb00, 0xc092fdff, REGISTRY_APNIC      }, // 192.146.251.0   - 192.146.253.255
	{ 0xc092fe00, 0xc09316ff, REGISTRY_ARIN       }, // 192.146.254.0   - 192.147.22.255
	{ 0xc0931700, 0xc09317ff, REGISTRY_RIPENCC    }, // 192.147.23.0    - 192.147.23.255
	{ 0xc0931800, 0xc09321ff, REGISTRY_ARIN       }, // 192.147.24.0    - 192.147.33.255
	{ 0xc0932200, 0xc09322ff, REGISTRY_RIPENCC    }, // 192.147.34.0    - 192.147.34.255
	{ 0xc0932300, 0xc09323ff, REGISTRY_ARIN       }, // 192.147.35.0    - 192.147.35.255
	{ 0xc0932400, 0xc09324ff, REGISTRY_RIPENCC    }, // 192.147.36.0    - 192.147.36.255
	{ 0xc0932500, 0xc09329ff, REGISTRY_ARIN       }, // 192.147.37.0    - 192.147.41.255
	{ 0xc0932a00, 0xc0932aff, REGISTRY_RIPENCC    }, // 192.147.42.0    - 192.147.42.255
	{ 0xc0932b00, 0xc0934bff, REGISTRY_ARIN       }, // 192.147.43.0    - 192.147.75.255
	{ 0xc0934c00, 0xc0934fff, REGISTRY_RIPENCC    }, // 192.147.76.0    - 192.147.79.255
	{ 0xc0935000, 0xc09371ff, REGISTRY_ARIN       }, // 192.147.80.0    - 192.147.113.255
	{ 0xc0937300, 0xc0938cff, REGISTRY_ARIN       }, // 192.147.115.0   - 192.147.140.255
	{ 0xc0938d00, 0xc0938dff, REGISTRY_RIPENCC    }, // 192.147.141.0   - 192.147.141.255
	{ 0xc0938e00, 0xc09395ff, REGISTRY_ARIN       }, // 192.147.142.0   - 192.147.149.255
	{ 0xc0939600, 0xc09396ff, REGISTRY_RIPENCC    }, // 192.147.150.0   - 192.147.150.255
	{ 0xc0939a00, 0xc0939aff, REGISTRY_ARIN       }, // 192.147.154.0   - 192.147.154.255
	{ 0xc0939b00, 0xc0939bff, REGISTRY_RIPENCC    }, // 192.147.155.0   - 192.147.155.255
	{ 0xc0939c00, 0xc093d1ff, REGISTRY_ARIN       }, // 192.147.156.0   - 192.147.209.255
	{ 0xc093d200, 0xc093d2ff, REGISTRY_LACNIC     }, // 192.147.210.0   - 192.147.210.255
	{ 0xc093d300, 0xc093d3ff, REGISTRY_ARIN       }, // 192.147.211.0   - 192.147.211.255
	{ 0xc093d400, 0xc093d4ff, REGISTRY_RIPENCC    }, // 192.147.212.0   - 192.147.212.255
	{ 0xc093d500, 0xc093d6ff, REGISTRY_ARIN       }, // 192.147.213.0   - 192.147.214.255
	{ 0xc093d700, 0xc093d9ff, REGISTRY_RIPENCC    }, // 192.147.215.0   - 192.147.217.255
	{ 0xc093da00, 0xc093daff, REGISTRY_LACNIC     }, // 192.147.218.0   - 192.147.218.255
	{ 0xc093db00, 0xc093dbff, REGISTRY_RIPENCC    }, // 192.147.219.0   - 192.147.219.255
	{ 0xc093dc00, 0xc093e3ff, REGISTRY_ARIN       }, // 192.147.220.0   - 192.147.227.255
	{ 0xc093e400, 0xc093e4ff, REGISTRY_RIPENCC    }, // 192.147.228.0   - 192.147.228.255
	{ 0xc093e500, 0xc093eaff, REGISTRY_ARIN       }, // 192.147.229.0   - 192.147.234.255
	{ 0xc093eb00, 0xc093ebff, REGISTRY_APNIC      }, // 192.147.235.0   - 192.147.235.255
	{ 0xc093ec00, 0xc093f5ff, REGISTRY_ARIN       }, // 192.147.236.0   - 192.147.245.255
	{ 0xc093f600, 0xc093f6ff, REGISTRY_APNIC      }, // 192.147.246.0   - 192.147.246.255
	{ 0xc093f700, 0xc093f7ff, REGISTRY_RIPENCC    }, // 192.147.247.0   - 192.147.247.255
	{ 0xc093f800, 0xc093faff, REGISTRY_ARIN       }, // 192.147.248.0   - 192.147.250.255
	{ 0xc093fb00, 0xc093fbff, REGISTRY_RIPENCC    }, // 192.147.251.0   - 192.147.251.255
	{ 0xc093fc00, 0xc093fcff, REGISTRY_ARIN       }, // 192.147.252.0   - 192.147.252.255
	{ 0xc093fe00, 0xc09420ff, REGISTRY_ARIN       }, // 192.147.254.0   - 192.148.32.255
	{ 0xc0942100, 0xc0945cff, REGISTRY_RIPENCC    }, // 192.148.33.0    - 192.148.92.255
	{ 0xc0945d00, 0xc09466ff, REGISTRY_ARIN       }, // 192.148.93.0    - 192.148.102.255
	{ 0xc0946700, 0xc09467ff, REGISTRY_RIPENCC    }, // 192.148.103.0   - 192.148.103.255
	{ 0xc0946800, 0xc09473ff, REGISTRY_ARIN       }, // 192.148.104.0   - 192.148.115.255
	{ 0xc0947400, 0xc094a5ff, REGISTRY_APNIC      }, // 192.148.116.0   - 192.148.165.255
	{ 0xc094a600, 0xc094a6ff, REGISTRY_RIPENCC    }, // 192.148.166.0   - 192.148.166.255
	{ 0xc094a700, 0xc094a7ff, REGISTRY_RIPENCC    }, // 192.148.167.0   - 192.148.167.255
	{ 0xc094a800, 0xc094aeff, REGISTRY_ARIN       }, // 192.148.168.0   - 192.148.174.255
	{ 0xc094af00, 0xc094afff, REGISTRY_LACNIC     }, // 192.148.175.0   - 192.148.175.255
	{ 0xc094b000, 0xc094b0ff, REGISTRY_ARIN       }, // 192.148.176.0   - 192.148.176.255
	{ 0xc094b100, 0xc094baff, REGISTRY_RIPENCC    }, // 192.148.177.0   - 192.148.186.255
	{ 0xc094bb00, 0xc094bfff, REGISTRY_ARIN       }, // 192.148.187.0   - 192.148.191.255
	{ 0xc094c000, 0xc094c2ff, REGISTRY_RIPENCC    }, // 192.148.192.0   - 192.148.194.255
	{ 0xc094c300, 0xc094c5ff, REGISTRY_ARIN       }, // 192.148.195.0   - 192.148.197.255
	{ 0xc094c600, 0xc094cfff, REGISTRY_RIPENCC    }, // 192.148.198.0   - 192.148.207.255
	{ 0xc094d000, 0xc094d7ff, REGISTRY_RIPENCC    }, // 192.148.208.0   - 192.148.215.255
	{ 0xc094d800, 0xc094d8ff, REGISTRY_RIPENCC    }, // 192.148.216.0   - 192.148.216.255
	{ 0xc094d900, 0xc094dbff, REGISTRY_ARIN       }, // 192.148.217.0   - 192.148.219.255
	{ 0xc094dc00, 0xc094dcff, REGISTRY_RIPENCC    }, // 192.148.220.0   - 192.148.220.255
	{ 0xc094dd00, 0xc094ddff, REGISTRY_APNIC      }, // 192.148.221.0   - 192.148.221.255
	{ 0xc094de00, 0xc094deff, REGISTRY_ARIN       }, // 192.148.222.0   - 192.148.222.255
	{ 0xc094df00, 0xc094e6ff, REGISTRY_APNIC      }, // 192.148.223.0   - 192.148.230.255
	{ 0xc094e700, 0xc09502ff, REGISTRY_ARIN       }, // 192.148.231.0   - 192.149.2.255
	{ 0xc0950300, 0xc09503ff, REGISTRY_RIPENCC    }, // 192.149.3.0     - 192.149.3.255
	{ 0xc0950400, 0xc09504ff, REGISTRY_ARIN       }, // 192.149.4.0     - 192.149.4.255
	{ 0xc0950500, 0xc09505ff, REGISTRY_RIPENCC    }, // 192.149.5.0     - 192.149.5.255
	{ 0xc0950600, 0xc0950eff, REGISTRY_ARIN       }, // 192.149.6.0     - 192.149.14.255
	{ 0xc0950f00, 0xc0950fff, REGISTRY_RIPENCC    }, // 192.149.15.0    - 192.149.15.255
	{ 0xc0951000, 0xc09512ff, REGISTRY_ARIN       }, // 192.149.16.0    - 192.149.18.255
	{ 0xc0951300, 0xc09513ff, REGISTRY_RIPENCC    }, // 192.149.19.0    - 192.149.19.255
	{ 0xc0951400, 0xc09514ff, REGISTRY_APNIC      }, // 192.149.20.0    - 192.149.20.255
	{ 0xc0951500, 0xc0951aff, REGISTRY_ARIN       }, // 192.149.21.0    - 192.149.26.255
	{ 0xc0951b00, 0xc0951bff, REGISTRY_RIPENCC    }, // 192.149.27.0    - 192.149.27.255
	{ 0xc0951c00, 0xc0951cff, REGISTRY_ARIN       }, // 192.149.28.0    - 192.149.28.255
	{ 0xc0951d00, 0xc09521ff, REGISTRY_RIPENCC    }, // 192.149.29.0    - 192.149.33.255
	{ 0xc0952200, 0xc09522ff, REGISTRY_ARIN       }, // 192.149.34.0    - 192.149.34.255
	{ 0xc0952300, 0xc09523ff, REGISTRY_RIPENCC    }, // 192.149.35.0    - 192.149.35.255
	{ 0xc0952400, 0xc09524ff, REGISTRY_APNIC      }, // 192.149.36.0    - 192.149.36.255
	{ 0xc0952500, 0xc09528ff, REGISTRY_ARIN       }, // 192.149.37.0    - 192.149.40.255
	{ 0xc0952900, 0xc09529ff, REGISTRY_RIPENCC    }, // 192.149.41.0    - 192.149.41.255
	{ 0xc0952a00, 0xc09535ff, REGISTRY_ARIN       }, // 192.149.42.0    - 192.149.53.255
	{ 0xc0953600, 0xc09536ff, REGISTRY_APNIC      }, // 192.149.54.0    - 192.149.54.255
	{ 0xc0953700, 0xc09538ff, REGISTRY_ARIN       }, // 192.149.55.0    - 192.149.56.255
	{ 0xc0953900, 0xc09539ff, REGISTRY_RIPENCC    }, // 192.149.57.0    - 192.149.57.255
	{ 0xc0953a00, 0xc0953aff, REGISTRY_ARIN       }, // 192.149.58.0    - 192.149.58.255
	{ 0xc0953b00, 0xc0953cff, REGISTRY_RIPENCC    }, // 192.149.59.0    - 192.149.60.255
	{ 0xc0953d00, 0xc0954cff, REGISTRY_ARIN       }, // 192.149.61.0    - 192.149.76.255
	{ 0xc0954d00, 0xc0954fff, REGISTRY_RIPENCC    }, // 192.149.77.0    - 192.149.79.255
	{ 0xc0955000, 0xc09561ff, REGISTRY_ARIN       }, // 192.149.80.0    - 192.149.97.255
	{ 0xc0956200, 0xc09562ff, REGISTRY_RIPENCC    }, // 192.149.98.0    - 192.149.98.255
	{ 0xc0956300, 0xc09563ff, REGISTRY_ARIN       }, // 192.149.99.0    - 192.149.99.255
	{ 0xc0956400, 0xc09564ff, REGISTRY_RIPENCC    }, // 192.149.100.0   - 192.149.100.255
	{ 0xc0956500, 0xc09565ff, REGISTRY_ARIN       }, // 192.149.101.0   - 192.149.101.255
	{ 0xc0956600, 0xc09566ff, REGISTRY_RIPENCC    }, // 192.149.102.0   - 192.149.102.255
	{ 0xc0956700, 0xc0956dff, REGISTRY_ARIN       }, // 192.149.103.0   - 192.149.109.255
	{ 0xc0956e00, 0xc0956fff, REGISTRY_RIPENCC    }, // 192.149.110.0   - 192.149.111.255
	{ 0xc0957000, 0xc09574ff, REGISTRY_ARIN       }, // 192.149.112.0   - 192.149.116.255
	{ 0xc0957500, 0xc09579ff, REGISTRY_RIPENCC    }, // 192.149.117.0   - 192.149.121.255
	{ 0xc0957a00, 0xc0957dff, REGISTRY_ARIN       }, // 192.149.122.0   - 192.149.125.255
	{ 0xc0957e00, 0xc0957eff, REGISTRY_RIPENCC    }, // 192.149.126.0   - 192.149.126.255
	{ 0xc0957f00, 0xc09594ff, REGISTRY_ARIN       }, // 192.149.127.0   - 192.149.148.255
	{ 0xc0959600, 0xc095d0ff, REGISTRY_ARIN       }, // 192.149.150.0   - 192.149.208.255
	{ 0xc095d100, 0xc095d1ff, REGISTRY_APNIC      }, // 192.149.209.0   - 192.149.209.255
	{ 0xc095d200, 0xc095e2ff, REGISTRY_ARIN       }, // 192.149.210.0   - 192.149.226.255
	{ 0xc095e300, 0xc095e3ff, REGISTRY_RIPENCC    }, // 192.149.227.0   - 192.149.227.255
	{ 0xc095e400, 0xc095e7ff, REGISTRY_ARIN       }, // 192.149.228.0   - 192.149.231.255
	{ 0xc095e800, 0xc095e8ff, REGISTRY_RIPENCC    }, // 192.149.232.0   - 192.149.232.255
	{ 0xc095e900, 0xc095edff, REGISTRY_ARIN       }, // 192.149.233.0   - 192.149.237.255
	{ 0xc095ee00, 0xc095eeff, REGISTRY_RIPENCC    }, // 192.149.238.0   - 192.149.238.255
	{ 0xc095f000, 0xc0960fff, REGISTRY_ARIN       }, // 192.149.240.0   - 192.150.15.255
	{ 0xc0961000, 0xc09610ff, REGISTRY_APNIC      }, // 192.150.16.0    - 192.150.16.255
	{ 0xc0961100, 0xc09613ff, REGISTRY_ARIN       }, // 192.150.17.0    - 192.150.19.255
	{ 0xc0961400, 0xc09614ff, REGISTRY_RIPENCC    }, // 192.150.20.0    - 192.150.20.255
	{ 0xc0961500, 0xc09639ff, REGISTRY_ARIN       }, // 192.150.21.0    - 192.150.57.255
	{ 0xc0963a00, 0xc09645ff, REGISTRY_RIPENCC    }, // 192.150.58.0    - 192.150.69.255
	{ 0xc0964600, 0xc09648ff, REGISTRY_RIPENCC    }, // 192.150.70.0    - 192.150.72.255
	{ 0xc0964900, 0xc0964aff, REGISTRY_ARIN       }, // 192.150.73.0    - 192.150.74.255
	{ 0xc0964b00, 0xc0964cff, REGISTRY_RIPENCC    }, // 192.150.75.0    - 192.150.76.255
	{ 0xc0964d00, 0xc0964dff, REGISTRY_ARIN       }, // 192.150.77.0    - 192.150.77.255
	{ 0xc0964e00, 0xc09652ff, REGISTRY_RIPENCC    }, // 192.150.78.0    - 192.150.82.255
	{ 0xc0965300, 0xc09653ff, REGISTRY_RIPENCC    }, // 192.150.83.0    - 192.150.83.255
	{ 0xc0965400, 0xc09654ff, REGISTRY_RIPENCC    }, // 192.150.84.0    - 192.150.84.255
	{ 0xc0965500, 0xc09658ff, REGISTRY_ARIN       }, // 192.150.85.0    - 192.150.88.255
	{ 0xc0965900, 0xc09659ff, REGISTRY_RIPENCC    }, // 192.150.89.0    - 192.150.89.255
	{ 0xc0965a00, 0xc0965bff, REGISTRY_ARIN       }, // 192.150.90.0    - 192.150.91.255
	{ 0xc0965c00, 0xc0965cff, REGISTRY_RIPENCC    }, // 192.150.92.0    - 192.150.92.255
	{ 0xc0965d00, 0xc0965dff, REGISTRY_ARIN       }, // 192.150.93.0    - 192.150.93.255
	{ 0xc0965e00, 0xc0965eff, REGISTRY_RIPENCC    }, // 192.150.94.0    - 192.150.94.255
	{ 0xc0965f00, 0xc0965fff, REGISTRY_ARIN       }, // 192.150.95.0    - 192.150.95.255
	{ 0xc0966100, 0xc09667ff, REGISTRY_ARIN       }, // 192.150.97.0    - 192.150.103.255
	{ 0xc0966800, 0xc09668ff, REGISTRY_RIPENCC    }, // 192.150.104.0   - 192.150.104.255
	{ 0xc0966900, 0xc09669ff, REGISTRY_ARIN       }, // 192.150.105.0   - 192.150.105.255
	{ 0xc0966a00, 0xc0966aff, REGISTRY_RIPENCC    }, // 192.150.106.0   - 192.150.106.255
	{ 0xc0966c00, 0xc0967bff, REGISTRY_ARIN       }, // 192.150.108.0   - 192.150.123.255
	{ 0xc0967c00, 0xc0967cff, REGISTRY_RIPENCC    }, // 192.150.124.0   - 192.150.124.255
	{ 0xc0967d00, 0xc0967dff, REGISTRY_ARIN       }, // 192.150.125.0   - 192.150.125.255
	{ 0xc0967e00, 0xc0967eff, REGISTRY_LACNIC     }, // 192.150.126.0   - 192.150.126.255
	{ 0xc0967f00, 0xc09680ff, REGISTRY_ARIN       }, // 192.150.127.0   - 192.150.128.255
	{ 0xc0968100, 0xc09687ff, REGISTRY_APNIC      }, // 192.150.129.0   - 192.150.135.255
	{ 0xc0968900, 0xc0968bff, REGISTRY_APNIC      }, // 192.150.137.0   - 192.150.139.255
	{ 0xc0968c00, 0xc0968cff, REGISTRY_RIPENCC    }, // 192.150.140.0   - 192.150.140.255
	{ 0xc0968d00, 0xc0968fff, REGISTRY_ARIN       }, // 192.150.141.0   - 192.150.143.255
	{ 0xc0969100, 0xc09691ff, REGISTRY_ARIN       }, // 192.150.145.0   - 192.150.145.255
	{ 0xc0969200, 0xc09692ff, REGISTRY_RIPENCC    }, // 192.150.146.0   - 192.150.146.255
	{ 0xc0969300, 0xc096b0ff, REGISTRY_ARIN       }, // 192.150.147.0   - 192.150.176.255
	{ 0xc096b100, 0xc096b8ff, REGISTRY_RIPENCC    }, // 192.150.177.0   - 192.150.184.255
	{ 0xc096b900, 0xc096bbff, REGISTRY_ARIN       }, // 192.150.185.0   - 192.150.187.255
	{ 0xc096bc00, 0xc096beff, REGISTRY_RIPENCC    }, // 192.150.188.0   - 192.150.190.255
	{ 0xc096bf00, 0xc096bfff, REGISTRY_ARIN       }, // 192.150.191.0   - 192.150.191.255
	{ 0xc096c000, 0xc096c6ff, REGISTRY_RIPENCC    }, // 192.150.192.0   - 192.150.198.255
	{ 0xc096c700, 0xc096c7ff, REGISTRY_ARIN       }, // 192.150.199.0   - 192.150.199.255
	{ 0xc096c900, 0xc096c9ff, REGISTRY_ARIN       }, // 192.150.201.0   - 192.150.201.255
	{ 0xc096ca00, 0xc096caff, REGISTRY_APNIC      }, // 192.150.202.0   - 192.150.202.255
	{ 0xc096cb00, 0xc096cdff, REGISTRY_RIPENCC    }, // 192.150.203.0   - 192.150.205.255
	{ 0xc096ce00, 0xc096cfff, REGISTRY_ARIN       }, // 192.150.206.0   - 192.150.207.255
	{ 0xc096d000, 0xc096d1ff, REGISTRY_RIPENCC    }, // 192.150.208.0   - 192.150.209.255
	{ 0xc096d200, 0xc096d9ff, REGISTRY_ARIN       }, // 192.150.210.0   - 192.150.217.255
	{ 0xc096da00, 0xc096dbff, REGISTRY_APNIC      }, // 192.150.218.0   - 192.150.219.255
	{ 0xc096dd00, 0xc096deff, REGISTRY_ARIN       }, // 192.150.221.0   - 192.150.222.255
	{ 0xc096df00, 0xc096dfff, REGISTRY_RIPENCC    }, // 192.150.223.0   - 192.150.223.255
	{ 0xc096e000, 0xc096e2ff, REGISTRY_ARIN       }, // 192.150.224.0   - 192.150.226.255
	{ 0xc096e300, 0xc096e9ff, REGISTRY_RIPENCC    }, // 192.150.227.0   - 192.150.233.255
	{ 0xc096ea00, 0xc096edff, REGISTRY_APNIC      }, // 192.150.234.0   - 192.150.237.255
	{ 0xc096ee00, 0xc096eeff, REGISTRY_RIPENCC    }, // 192.150.238.0   - 192.150.238.255
	{ 0xc096ef00, 0xc096f5ff, REGISTRY_ARIN       }, // 192.150.239.0   - 192.150.245.255
	{ 0xc096f600, 0xc096f6ff, REGISTRY_APNIC      }, // 192.150.246.0   - 192.150.246.255
	{ 0xc096f700, 0xc096f7ff, REGISTRY_ARIN       }, // 192.150.247.0   - 192.150.247.255
	{ 0xc096f800, 0xc096f8ff, REGISTRY_RIPENCC    }, // 192.150.248.0   - 192.150.248.255
	{ 0xc096f900, 0xc096fbff, REGISTRY_APNIC      }, // 192.150.249.0   - 192.150.251.255
	{ 0xc096fc00, 0xc096fcff, REGISTRY_RIPENCC    }, // 192.150.252.0   - 192.150.252.255
	{ 0xc096fd00, 0xc096fdff, REGISTRY_ARIN       }, // 192.150.253.0   - 192.150.253.255
	{ 0xc096fe00, 0xc096feff, REGISTRY_RIPENCC    }, // 192.150.254.0   - 192.150.254.255
	{ 0xc096ff00, 0xc09780ff, REGISTRY_ARIN       }, // 192.150.255.0   - 192.151.128.255
	{ 0xc0978200, 0xc09805ff, REGISTRY_ARIN       }, // 192.151.130.0   - 192.152.5.255
	{ 0xc0980600, 0xc09806ff, REGISTRY_RIPENCC    }, // 192.152.6.0     - 192.152.6.255
	{ 0xc0980700, 0xc0980dff, REGISTRY_ARIN       }, // 192.152.7.0     - 192.152.13.255
	{ 0xc0980e00, 0xc0980eff, REGISTRY_RIPENCC    }, // 192.152.14.0    - 192.152.14.255
	{ 0xc0980f00, 0xc09810ff, REGISTRY_ARIN       }, // 192.152.15.0    - 192.152.16.255
	{ 0xc0981100, 0xc09811ff, REGISTRY_RIPENCC    }, // 192.152.17.0    - 192.152.17.255
	{ 0xc0981200, 0xc09819ff, REGISTRY_ARIN       }, // 192.152.18.0    - 192.152.25.255
	{ 0xc0981a00, 0xc0981bff, REGISTRY_RIPENCC    }, // 192.152.26.0    - 192.152.27.255
	{ 0xc0981c00, 0xc09829ff, REGISTRY_ARIN       }, // 192.152.28.0    - 192.152.41.255
	{ 0xc0982a00, 0xc0982aff, REGISTRY_RIPENCC    }, // 192.152.42.0    - 192.152.42.255
	{ 0xc0982b00, 0xc0982bff, REGISTRY_ARIN       }, // 192.152.43.0    - 192.152.43.255
	{ 0xc0982c00, 0xc0982cff, REGISTRY_RIPENCC    }, // 192.152.44.0    - 192.152.44.255
	{ 0xc0982d00, 0xc0982eff, REGISTRY_ARIN       }, // 192.152.45.0    - 192.152.46.255
	{ 0xc0982f00, 0xc09833ff, REGISTRY_RIPENCC    }, // 192.152.47.0    - 192.152.51.255
	{ 0xc0983400, 0xc09835ff, REGISTRY_ARIN       }, // 192.152.52.0    - 192.152.53.255
	{ 0xc0983600, 0xc09836ff, REGISTRY_RIPENCC    }, // 192.152.54.0    - 192.152.54.255
	{ 0xc0983700, 0xc0983cff, REGISTRY_ARIN       }, // 192.152.55.0    - 192.152.60.255
	{ 0xc0983d00, 0xc0983fff, REGISTRY_RIPENCC    }, // 192.152.61.0    - 192.152.63.255
	{ 0xc0984000, 0xc09843ff, REGISTRY_ARIN       }, // 192.152.64.0    - 192.152.67.255
	{ 0xc0984400, 0xc09844ff, REGISTRY_RIPENCC    }, // 192.152.68.0    - 192.152.68.255
	{ 0xc0984500, 0xc09845ff, REGISTRY_APNIC      }, // 192.152.69.0    - 192.152.69.255
	{ 0xc0984600, 0xc09851ff, REGISTRY_ARIN       }, // 192.152.70.0    - 192.152.81.255
	{ 0xc0985200, 0xc09852ff, REGISTRY_RIPENCC    }, // 192.152.82.0    - 192.152.82.255
	{ 0xc0985300, 0xc09855ff, REGISTRY_ARIN       }, // 192.152.83.0    - 192.152.85.255
	{ 0xc0985800, 0xc09861ff, REGISTRY_ARIN       }, // 192.152.88.0    - 192.152.97.255
	{ 0xc0986200, 0xc09862ff, REGISTRY_RIPENCC    }, // 192.152.98.0    - 192.152.98.255
	{ 0xc0986300, 0xc0986eff, REGISTRY_ARIN       }, // 192.152.99.0    - 192.152.110.255
	{ 0xc0986f00, 0xc09870ff, REGISTRY_RIPENCC    }, // 192.152.111.0   - 192.152.112.255
	{ 0xc0987100, 0xc09876ff, REGISTRY_ARIN       }, // 192.152.113.0   - 192.152.118.255
	{ 0xc0987700, 0xc09877ff, REGISTRY_APNIC      }, // 192.152.119.0   - 192.152.119.255
	{ 0xc0987800, 0xc09879ff, REGISTRY_ARIN       }, // 192.152.120.0   - 192.152.121.255
	{ 0xc0987a00, 0xc0987aff, REGISTRY_RIPENCC    }, // 192.152.122.0   - 192.152.122.255
	{ 0xc0987b00, 0xc0987bff, REGISTRY_ARIN       }, // 192.152.123.0   - 192.152.123.255
	{ 0xc0987c00, 0xc0987cff, REGISTRY_RIPENCC    }, // 192.152.124.0   - 192.152.124.255
	{ 0xc0987d00, 0xc0988cff, REGISTRY_ARIN       }, // 192.152.125.0   - 192.152.140.255
	{ 0xc0988d00, 0xc0988dff, REGISTRY_RIPENCC    }, // 192.152.141.0   - 192.152.141.255
	{ 0xc0988e00, 0xc0988fff, REGISTRY_ARIN       }, // 192.152.142.0   - 192.152.143.255
	{ 0xc0989100, 0xc09891ff, REGISTRY_ARIN       }, // 192.152.145.0   - 192.152.145.255
	{ 0xc0989300, 0xc09896ff, REGISTRY_ARIN       }, // 192.152.147.0   - 192.152.150.255
	{ 0xc0989700, 0xc09897ff, REGISTRY_RIPENCC    }, // 192.152.151.0   - 192.152.151.255
	{ 0xc0989800, 0xc0989bff, REGISTRY_ARIN       }, // 192.152.152.0   - 192.152.155.255
	{ 0xc0989c00, 0xc0989cff, REGISTRY_RIPENCC    }, // 192.152.156.0   - 192.152.156.255
	{ 0xc0989d00, 0xc098a5ff, REGISTRY_ARIN       }, // 192.152.157.0   - 192.152.165.255
	{ 0xc098a600, 0xc098a7ff, REGISTRY_RIPENCC    }, // 192.152.166.0   - 192.152.167.255
	{ 0xc098a800, 0xc098adff, REGISTRY_ARIN       }, // 192.152.168.0   - 192.152.173.255
	{ 0xc098ae00, 0xc098aeff, REGISTRY_RIPENCC    }, // 192.152.174.0   - 192.152.174.255
	{ 0xc098af00, 0xc098b7ff, REGISTRY_ARIN       }, // 192.152.175.0   - 192.152.183.255
	{ 0xc098b800, 0xc098bbff, REGISTRY_RIPENCC    }, // 192.152.184.0   - 192.152.187.255
	{ 0xc098bc00, 0xc098c4ff, REGISTRY_ARIN       }, // 192.152.188.0   - 192.152.196.255
	{ 0xc098c600, 0xc098d3ff, REGISTRY_ARIN       }, // 192.152.198.0   - 192.152.211.255
	{ 0xc098d400, 0xc098d4ff, REGISTRY_APNIC      }, // 192.152.212.0   - 192.152.212.255
	{ 0xc098d500, 0xc098f0ff, REGISTRY_ARIN       }, // 192.152.213.0   - 192.152.240.255
	{ 0xc098f100, 0xc098f1ff, REGISTRY_RIPENCC    }, // 192.152.241.0   - 192.152.241.255
	{ 0xc098f200, 0xc098f3ff, REGISTRY_ARIN       }, // 192.152.242.0   - 192.152.243.255
	{ 0xc098f400, 0xc098f4ff, REGISTRY_RIPENCC    }, // 192.152.244.0   - 192.152.244.255
	{ 0xc098f500, 0xc098fcff, REGISTRY_ARIN       }, // 192.152.245.0   - 192.152.252.255
	{ 0xc098fd00, 0xc098feff, REGISTRY_RIPENCC    }, // 192.152.253.0   - 192.152.254.255
	{ 0xc098ff00, 0xc09901ff, REGISTRY_ARIN       }, // 192.152.255.0   - 192.153.1.255
	{ 0xc0990200, 0xc09903ff, REGISTRY_RIPENCC    }, // 192.153.2.0     - 192.153.3.255
	{ 0xc0990400, 0xc09908ff, REGISTRY_ARIN       }, // 192.153.4.0     - 192.153.8.255
	{ 0xc0990a00, 0xc0990bff, REGISTRY_ARIN       }, // 192.153.10.0    - 192.153.11.255
	{ 0xc0990c00, 0xc0990cff, REGISTRY_LACNIC     }, // 192.153.12.0    - 192.153.12.255
	{ 0xc0990d00, 0xc0990dff, REGISTRY_RIPENCC    }, // 192.153.13.0    - 192.153.13.255
	{ 0xc0990e00, 0xc09911ff, REGISTRY_ARIN       }, // 192.153.14.0    - 192.153.17.255
	{ 0xc0991200, 0xc09913ff, REGISTRY_RIPENCC    }, // 192.153.18.0    - 192.153.19.255
	{ 0xc0991400, 0xc09957ff, REGISTRY_ARIN       }, // 192.153.20.0    - 192.153.87.255
	{ 0xc0995800, 0xc09958ff, REGISTRY_LACNIC     }, // 192.153.88.0    - 192.153.88.255
	{ 0xc0995900, 0xc09959ff, REGISTRY_RIPENCC    }, // 192.153.89.0    - 192.153.89.255
	{ 0xc0995a00, 0xc0995cff, REGISTRY_ARIN       }, // 192.153.90.0    - 192.153.92.255
	{ 0xc0995d00, 0xc0995dff, REGISTRY_APNIC      }, // 192.153.93.0    - 192.153.93.255
	{ 0xc0995e00, 0xc0995eff, REGISTRY_ARIN       }, // 192.153.94.0    - 192.153.94.255
	{ 0xc0995f00, 0xc09972ff, REGISTRY_APNIC      }, // 192.153.95.0    - 192.153.114.255
	{ 0xc0997300, 0xc09973ff, REGISTRY_ARIN       }, // 192.153.115.0   - 192.153.115.255
	{ 0xc0997400, 0xc09974ff, REGISTRY_RIPENCC    }, // 192.153.116.0   - 192.153.116.255
	{ 0xc0997500, 0xc09976ff, REGISTRY_ARIN       }, // 192.153.117.0   - 192.153.118.255
	{ 0xc0997700, 0xc09978ff, REGISTRY_LACNIC     }, // 192.153.119.0   - 192.153.120.255
	{ 0xc0997900, 0xc0997eff, REGISTRY_ARIN       }, // 192.153.121.0   - 192.153.126.255
	{ 0xc0997f00, 0xc0997fff, REGISTRY_RIPENCC    }, // 192.153.127.0   - 192.153.127.255
	{ 0xc0998000, 0xc09998ff, REGISTRY_ARIN       }, // 192.153.128.0   - 192.153.152.255
	{ 0xc0999900, 0xc09999ff, REGISTRY_RIPENCC    }, // 192.153.153.0   - 192.153.153.255
	{ 0xc0999a00, 0xc0999aff, REGISTRY_ARIN       }, // 192.153.154.0   - 192.153.154.255
	{ 0xc0999b00, 0xc0999bff, REGISTRY_LACNIC     }, // 192.153.155.0   - 192.153.155.255
	{ 0xc0999c00, 0xc0999dff, REGISTRY_ARIN       }, // 192.153.156.0   - 192.153.157.255
	{ 0xc0999e00, 0xc0999eff, REGISTRY_APNIC      }, // 192.153.158.0   - 192.153.158.255
	{ 0xc0999f00, 0xc099a5ff, REGISTRY_ARIN       }, // 192.153.159.0   - 192.153.165.255
	{ 0xc099a600, 0xc099a6ff, REGISTRY_RIPENCC    }, // 192.153.166.0   - 192.153.166.255
	{ 0xc099a700, 0xc099a7ff, REGISTRY_LACNIC     }, // 192.153.167.0   - 192.153.167.255
	{ 0xc099a800, 0xc099a8ff, REGISTRY_RIPENCC    }, // 192.153.168.0   - 192.153.168.255
	{ 0xc099a900, 0xc099aaff, REGISTRY_ARIN       }, // 192.153.169.0   - 192.153.170.255
	{ 0xc099ac00, 0xc099acff, REGISTRY_ARIN       }, // 192.153.172.0   - 192.153.172.255
	{ 0xc099ad00, 0xc099b6ff, REGISTRY_RIPENCC    }, // 192.153.173.0   - 192.153.182.255
	{ 0xc099b700, 0xc099bbff, REGISTRY_ARIN       }, // 192.153.183.0   - 192.153.187.255
	{ 0xc099bc00, 0xc099bdff, REGISTRY_RIPENCC    }, // 192.153.188.0   - 192.153.189.255
	{ 0xc099be00, 0xc099c1ff, REGISTRY_ARIN       }, // 192.153.190.0   - 192.153.193.255
	{ 0xc099c200, 0xc099c2ff, REGISTRY_RIPENCC    }, // 192.153.194.0   - 192.153.194.255
	{ 0xc099c300, 0xc099c3ff, REGISTRY_ARIN       }, // 192.153.195.0   - 192.153.195.255
	{ 0xc099c400, 0xc099c5ff, REGISTRY_APNIC      }, // 192.153.196.0   - 192.153.197.255
	{ 0xc099c600, 0xc099d4ff, REGISTRY_ARIN       }, // 192.153.198.0   - 192.153.212.255
	{ 0xc099d500, 0xc099d5ff, REGISTRY_RIPENCC    }, // 192.153.213.0   - 192.153.213.255
	{ 0xc099d600, 0xc099dcff, REGISTRY_ARIN       }, // 192.153.214.0   - 192.153.220.255
	{ 0xc099e500, 0xc099faff, REGISTRY_ARIN       }, // 192.153.229.0   - 192.153.250.255
	{ 0xc099fb00, 0xc099fbff, REGISTRY_APNIC      }, // 192.153.251.0   - 192.153.251.255
	{ 0xc099fc00, 0xc09a0fff, REGISTRY_ARIN       }, // 192.153.252.0   - 192.154.15.255
	{ 0xc09a1000, 0xc09a19ff, REGISTRY_APNIC      }, // 192.154.16.0    - 192.154.25.255
	{ 0xc09a1a00, 0xc09b00ff, REGISTRY_ARIN       }, // 192.154.26.0    - 192.155.0.255
	{ 0xc09b0100, 0xc09b06ff, REGISTRY_RIPENCC    }, // 192.155.1.0     - 192.155.6.255
	{ 0xc09b0700, 0xc09c83ff, REGISTRY_ARIN       }, // 192.155.7.0     - 192.156.131.255
	{ 0xc09c8400, 0xc09c84ff, REGISTRY_RIPENCC    }, // 192.156.132.0   - 192.156.132.255
	{ 0xc09c8500, 0xc09c8bff, REGISTRY_ARIN       }, // 192.156.133.0   - 192.156.139.255
	{ 0xc09c8c00, 0xc09c8dff, REGISTRY_APNIC      }, // 192.156.140.0   - 192.156.141.255
	{ 0xc09c8f00, 0xc09c97ff, REGISTRY_APNIC      }, // 192.156.143.0   - 192.156.151.255
	{ 0xc09c9a00, 0xc09c9aff, REGISTRY_APNIC      }, // 192.156.154.0   - 192.156.154.255
	{ 0xc09c9d00, 0xc09c9dff, REGISTRY_ARIN       }, // 192.156.157.0   - 192.156.157.255
	{ 0xc09c9e00, 0xc09c9fff, REGISTRY_APNIC      }, // 192.156.158.0   - 192.156.159.255
	{ 0xc09ca000, 0xc09ca1ff, REGISTRY_ARIN       }, // 192.156.160.0   - 192.156.161.255
	{ 0xc09ca200, 0xc09ca2ff, REGISTRY_RIPENCC    }, // 192.156.162.0   - 192.156.162.255
	{ 0xc09ca300, 0xc09ca4ff, REGISTRY_ARIN       }, // 192.156.163.0   - 192.156.164.255
	{ 0xc09ca500, 0xc09ca5ff, REGISTRY_APNIC      }, // 192.156.165.0   - 192.156.165.255
	{ 0xc09ca600, 0xc09ca6ff, REGISTRY_ARIN       }, // 192.156.166.0   - 192.156.166.255
	{ 0xc09ca700, 0xc09ca7ff, REGISTRY_RIPENCC    }, // 192.156.167.0   - 192.156.167.255
	{ 0xc09ca800, 0xc09cceff, REGISTRY_ARIN       }, // 192.156.168.0   - 192.156.206.255
	{ 0xc09ccf00, 0xc09ccfff, REGISTRY_APNIC      }, // 192.156.207.0   - 192.156.207.255
	{ 0xc09cd100, 0xc09cd1ff, REGISTRY_ARIN       }, // 192.156.209.0   - 192.156.209.255
	{ 0xc09cd200, 0xc09cd2ff, REGISTRY_RIPENCC    }, // 192.156.210.0   - 192.156.210.255
	{ 0xc09cd300, 0xc09cd4ff, REGISTRY_ARIN       }, // 192.156.211.0   - 192.156.212.255
	{ 0xc09cd500, 0xc09cd5ff, REGISTRY_RIPENCC    }, // 192.156.213.0   - 192.156.213.255
	{ 0xc09cd600, 0xc09cd8ff, REGISTRY_ARIN       }, // 192.156.214.0   - 192.156.216.255
	{ 0xc09cda00, 0xc09cdbff, REGISTRY_ARIN       }, // 192.156.218.0   - 192.156.219.255
	{ 0xc09cdc00, 0xc09cdcff, REGISTRY_APNIC      }, // 192.156.220.0   - 192.156.220.255
	{ 0xc09cdd00, 0xc09ce0ff, REGISTRY_ARIN       }, // 192.156.221.0   - 192.156.224.255
	{ 0xc09ce100, 0xc09ce1ff, REGISTRY_APNIC      }, // 192.156.225.0   - 192.156.225.255
	{ 0xc09ce200, 0xc09ce2ff, REGISTRY_ARIN       }, // 192.156.226.0   - 192.156.226.255
	{ 0xc09ce300, 0xc09ce3ff, REGISTRY_RIPENCC    }, // 192.156.227.0   - 192.156.227.255
	{ 0xc09ce400, 0xc09ceeff, REGISTRY_ARIN       }, // 192.156.228.0   - 192.156.238.255
	{ 0xc09cef00, 0xc09cefff, REGISTRY_RIPENCC    }, // 192.156.239.0   - 192.156.239.255
	{ 0xc09cf000, 0xc09cf7ff, REGISTRY_ARIN       }, // 192.156.240.0   - 192.156.247.255
	{ 0xc09cf800, 0xc09cf8ff, REGISTRY_RIPENCC    }, // 192.156.248.0   - 192.156.248.255
	{ 0xc09cfa00, 0xc09d00ff, REGISTRY_ARIN       }, // 192.156.250.0   - 192.157.0.255
	{ 0xc09d0100, 0xc09d03ff, REGISTRY_RIPENCC    }, // 192.157.1.0     - 192.157.3.255
	{ 0xc09d0400, 0xc09d07ff, REGISTRY_ARIN       }, // 192.157.4.0     - 192.157.7.255
	{ 0xc09d0800, 0xc09d11ff, REGISTRY_RIPENCC    }, // 192.157.8.0     - 192.157.17.255
	{ 0xc09d1200, 0xc09d80ff, REGISTRY_ARIN       }, // 192.157.18.0    - 192.157.128.255
	{ 0xc09d8100, 0xc09d81ff, REGISTRY_RIPENCC    }, // 192.157.129.0   - 192.157.129.255
	{ 0xc09d8200, 0xc09da1ff, REGISTRY_ARIN       }, // 192.157.130.0   - 192.157.161.255
	{ 0xc09da300, 0xc09da4ff, REGISTRY_ARIN       }, // 192.157.163.0   - 192.157.164.255
	{ 0xc09da500, 0xc09dacff, REGISTRY_RIPENCC    }, // 192.157.165.0   - 192.157.172.255
	{ 0xc09dad00, 0xc09dadff, REGISTRY_ARIN       }, // 192.157.173.0   - 192.157.173.255
	{ 0xc09dae00, 0xc09daeff, REGISTRY_RIPENCC    }, // 192.157.174.0   - 192.157.174.255
	{ 0xc09daf00, 0xc09dafff, REGISTRY_ARIN       }, // 192.157.175.0   - 192.157.175.255
	{ 0xc09db000, 0xc09db0ff, REGISTRY_RIPENCC    }, // 192.157.176.0   - 192.157.176.255
	{ 0xc09db100, 0xc09db8ff, REGISTRY_ARIN       }, // 192.157.177.0   - 192.157.184.255
	{ 0xc09db900, 0xc09db9ff, REGISTRY_RIPENCC    }, // 192.157.185.0   - 192.157.185.255
	{ 0xc09dba00, 0xc09dbaff, REGISTRY_ARIN       }, // 192.157.186.0   - 192.157.186.255
	{ 0xc09dbb00, 0xc09dbbff, REGISTRY_RIPENCC    }, // 192.157.187.0   - 192.157.187.255
	{ 0xc09dbc00, 0xc09dbcff, REGISTRY_ARIN       }, // 192.157.188.0   - 192.157.188.255
	{ 0xc09dbd00, 0xc09dbdff, REGISTRY_RIPENCC    }, // 192.157.189.0   - 192.157.189.255
	{ 0xc09dbe00, 0xc09dbeff, REGISTRY_AFRINIC    }, // 192.157.190.0   - 192.157.190.255
	{ 0xc09dc000, 0xc09f0fff, REGISTRY_ARIN       }, // 192.157.192.0   - 192.159.15.255
	{ 0xc09f1000, 0xc09f1eff, REGISTRY_APNIC      }, // 192.159.16.0    - 192.159.30.255
	{ 0xc09f1f00, 0xc09f25ff, REGISTRY_ARIN       }, // 192.159.31.0    - 192.159.37.255
	{ 0xc09f2600, 0xc09f27ff, REGISTRY_RIPENCC    }, // 192.159.38.0    - 192.159.39.255
	{ 0xc09f2800, 0xc09f45ff, REGISTRY_ARIN       }, // 192.159.40.0    - 192.159.69.255
	{ 0xc09f4600, 0xc09f46ff, REGISTRY_RIPENCC    }, // 192.159.70.0    - 192.159.70.255
	{ 0xc09f4700, 0xc09f48ff, REGISTRY_ARIN       }, // 192.159.71.0    - 192.159.72.255
	{ 0xc09f4900, 0xc09f49ff, REGISTRY_RIPENCC    }, // 192.159.73.0    - 192.159.73.255
	{ 0xc09f4a00, 0xc09f4cff, REGISTRY_ARIN       }, // 192.159.74.0    - 192.159.76.255
	{ 0xc09f4d00, 0xc09f4dff, REGISTRY_RIPENCC    }, // 192.159.77.0    - 192.159.77.255
	{ 0xc09f4e00, 0xc09f53ff, REGISTRY_ARIN       }, // 192.159.78.0    - 192.159.83.255
	{ 0xc09f5400, 0xc09f55ff, REGISTRY_RIPENCC    }, // 192.159.84.0    - 192.159.85.255
	{ 0xc09f5600, 0xc09f59ff, REGISTRY_ARIN       }, // 192.159.86.0    - 192.159.89.255
	{ 0xc09f5a00, 0xc09f5aff, REGISTRY_RIPENCC    }, // 192.159.90.0    - 192.159.90.255
	{ 0xc09f5b00, 0xc09f5eff, REGISTRY_ARIN       }, // 192.159.91.0    - 192.159.94.255
	{ 0xc09f5f00, 0xc09f5fff, REGISTRY_RIPENCC    }, // 192.159.95.0    - 192.159.95.255
	{ 0xc09f6000, 0xc09f62ff, REGISTRY_ARIN       }, // 192.159.96.0    - 192.159.98.255
	{ 0xc09f6300, 0xc09f67ff, REGISTRY_RIPENCC    }, // 192.159.99.0    - 192.159.103.255
	{ 0xc09f6800, 0xc09f68ff, REGISTRY_ARIN       }, // 192.159.104.0   - 192.159.104.255
	{ 0xc09f6900, 0xc09f69ff, REGISTRY_RIPENCC    }, // 192.159.105.0   - 192.159.105.255
	{ 0xc09f6a00, 0xc09f6bff, REGISTRY_ARIN       }, // 192.159.106.0   - 192.159.107.255
	{ 0xc09f6c00, 0xc09f6dff, REGISTRY_RIPENCC    }, // 192.159.108.0   - 192.159.109.255
	{ 0xc09f6e00, 0xc09f73ff, REGISTRY_ARIN       }, // 192.159.110.0   - 192.159.115.255
	{ 0xc09f7400, 0xc09f75ff, REGISTRY_LACNIC     }, // 192.159.116.0   - 192.159.117.255
	{ 0xc09f7600, 0xc09f76ff, REGISTRY_RIPENCC    }, // 192.159.118.0   - 192.159.118.255
	{ 0xc09f7700, 0xc09f78ff, REGISTRY_ARIN       }, // 192.159.119.0   - 192.159.120.255
	{ 0xc09f7900, 0xc09f7aff, REGISTRY_RIPENCC    }, // 192.159.121.0   - 192.159.122.255
	{ 0xc09f7b00, 0xc0a009ff, REGISTRY_ARIN       }, // 192.159.123.0   - 192.160.9.255
	{ 0xc0a00a00, 0xc0a00aff, REGISTRY_RIPENCC    }, // 192.160.10.0    - 192.160.10.255
	{ 0xc0a00b00, 0xc0a00eff, REGISTRY_ARIN       }, // 192.160.11.0    - 192.160.14.255
	{ 0xc0a00f00, 0xc0a00fff, REGISTRY_RIPENCC    }, // 192.160.15.0    - 192.160.15.255
	{ 0xc0a01000, 0xc0a010ff, REGISTRY_APNIC      }, // 192.160.16.0    - 192.160.16.255
	{ 0xc0a01100, 0xc0a012ff, REGISTRY_ARIN       }, // 192.160.17.0    - 192.160.18.255
	{ 0xc0a01300, 0xc0a013ff, REGISTRY_APNIC      }, // 192.160.19.0    - 192.160.19.255
	{ 0xc0a01400, 0xc0a014ff, REGISTRY_ARIN       }, // 192.160.20.0    - 192.160.20.255
	{ 0xc0a01500, 0xc0a017ff, REGISTRY_RIPENCC    }, // 192.160.21.0    - 192.160.23.255
	{ 0xc0a01800, 0xc0a01aff, REGISTRY_ARIN       }, // 192.160.24.0    - 192.160.26.255
	{ 0xc0a01b00, 0xc0a01bff, REGISTRY_RIPENCC    }, // 192.160.27.0    - 192.160.27.255
	{ 0xc0a01c00, 0xc0a01cff, REGISTRY_ARIN       }, // 192.160.28.0    - 192.160.28.255
	{ 0xc0a01e00, 0xc0a020ff, REGISTRY_ARIN       }, // 192.160.30.0    - 192.160.32.255
	{ 0xc0a02100, 0xc0a021ff, REGISTRY_RIPENCC    }, // 192.160.33.0    - 192.160.33.255
	{ 0xc0a02200, 0xc0a024ff, REGISTRY_ARIN       }, // 192.160.34.0    - 192.160.36.255
	{ 0xc0a02500, 0xc0a025ff, REGISTRY_RIPENCC    }, // 192.160.37.0    - 192.160.37.255
	{ 0xc0a02600, 0xc0a02cff, REGISTRY_ARIN       }, // 192.160.38.0    - 192.160.44.255
	{ 0xc0a02d00, 0xc0a02dff, REGISTRY_LACNIC     }, // 192.160.45.0    - 192.160.45.255
	{ 0xc0a02e00, 0xc0a031ff, REGISTRY_ARIN       }, // 192.160.46.0    - 192.160.49.255
	{ 0xc0a03200, 0xc0a032ff, REGISTRY_LACNIC     }, // 192.160.50.0    - 192.160.50.255
	{ 0xc0a03300, 0xc0a040ff, REGISTRY_ARIN       }, // 192.160.51.0    - 192.160.64.255
	{ 0xc0a04100, 0xc0a041ff, REGISTRY_RIPENCC    }, // 192.160.65.0    - 192.160.65.255
	{ 0xc0a04200, 0xc0a042ff, REGISTRY_ARIN       }, // 192.160.66.0    - 192.160.66.255
	{ 0xc0a04300, 0xc0a043ff, REGISTRY_RIPENCC    }, // 192.160.67.0    - 192.160.67.255
	{ 0xc0a04400, 0xc0a046ff, REGISTRY_ARIN       }, // 192.160.68.0    - 192.160.70.255
	{ 0xc0a04700, 0xc0a047ff, REGISTRY_APNIC      }, // 192.160.71.0    - 192.160.71.255
	{ 0xc0a04800, 0xc0a05eff, REGISTRY_ARIN       }, // 192.160.72.0    - 192.160.94.255
	{ 0xc0a05f00, 0xc0a060ff, REGISTRY_RIPENCC    }, // 192.160.95.0    - 192.160.96.255
	{ 0xc0a06100, 0xc0a069ff, REGISTRY_ARIN       }, // 192.160.97.0    - 192.160.105.255
	{ 0xc0a06a00, 0xc0a06aff, REGISTRY_RIPENCC    }, // 192.160.106.0   - 192.160.106.255
	{ 0xc0a06b00, 0xc0a06cff, REGISTRY_ARIN       }, // 192.160.107.0   - 192.160.108.255
	{ 0xc0a06d00, 0xc0a06eff, REGISTRY_RIPENCC    }, // 192.160.109.0   - 192.160.110.255
	{ 0xc0a07000, 0xc0a07aff, REGISTRY_ARIN       }, // 192.160.112.0   - 192.160.122.255
	{ 0xc0a07b00, 0xc0a07bff, REGISTRY_RIPENCC    }, // 192.160.123.0   - 192.160.123.255
	{ 0xc0a07c00, 0xc0a07dff, REGISTRY_ARIN       }, // 192.160.124.0   - 192.160.125.255
	{ 0xc0a07e00, 0xc0a07eff, REGISTRY_RIPENCC    }, // 192.160.126.0   - 192.160.126.255
	{ 0xc0a07f00, 0xc0a07fff, REGISTRY_ARIN       }, // 192.160.127.0   - 192.160.127.255
	{ 0xc0a08000, 0xc0a080ff, REGISTRY_LACNIC     }, // 192.160.128.0   - 192.160.128.255
	{ 0xc0a08100, 0xc0a08dff, REGISTRY_ARIN       }, // 192.160.129.0   - 192.160.141.255
	{ 0xc0a08e00, 0xc0a08fff, REGISTRY_RIPENCC    }, // 192.160.142.0   - 192.160.143.255
	{ 0xc0a09000, 0xc0a097ff, REGISTRY_ARIN       }, // 192.160.144.0   - 192.160.151.255
	{ 0xc0a09800, 0xc0a098ff, REGISTRY_RIPENCC    }, // 192.160.152.0   - 192.160.152.255
	{ 0xc0a09900, 0xc0a09aff, REGISTRY_ARIN       }, // 192.160.153.0   - 192.160.154.255
	{ 0xc0a09c00, 0xc0a09cff, REGISTRY_RIPENCC    }, // 192.160.156.0   - 192.160.156.255
	{ 0xc0a09d00, 0xc0a09fff, REGISTRY_ARIN       }, // 192.160.157.0   - 192.160.159.255
	{ 0xc0a0a000, 0xc0a0a0ff, REGISTRY_RIPENCC    }, // 192.160.160.0   - 192.160.160.255
	{ 0xc0a0a100, 0xc0a0a1ff, REGISTRY_APNIC      }, // 192.160.161.0   - 192.160.161.255
	{ 0xc0a0a200, 0xc0a0a8ff, REGISTRY_ARIN       }, // 192.160.162.0   - 192.160.168.255
	{ 0xc0a0a900, 0xc0a0abff, REGISTRY_APNIC      }, // 192.160.169.0   - 192.160.171.255
	{ 0xc0a0ac00, 0xc0a0acff, REGISTRY_RIPENCC    }, // 192.160.172.0   - 192.160.172.255
	{ 0xc0a0ad00, 0xc0a0b0ff, REGISTRY_ARIN       }, // 192.160.173.0   - 192.160.176.255
	{ 0xc0a0b100, 0xc0a0b3ff, REGISTRY_RIPENCC    }, // 192.160.177.0   - 192.160.179.255
	{ 0xc0a0b400, 0xc0a0bbff, REGISTRY_ARIN       }, // 192.160.180.0   - 192.160.187.255
	{ 0xc0a0bc00, 0xc0a0bcff, REGISTRY_LACNIC     }, // 192.160.188.0   - 192.160.188.255
	{ 0xc0a0bd00, 0xc0a0c1ff, REGISTRY_ARIN       }, // 192.160.189.0   - 192.160.193.255
	{ 0xc0a0c200, 0xc0a0c3ff, REGISTRY_RIPENCC    }, // 192.160.194.0   - 192.160.195.255
	{ 0xc0a0c400, 0xc0a0ccff, REGISTRY_ARIN       }, // 192.160.196.0   - 192.160.204.255
	{ 0xc0a0cd00, 0xc0a0cdff, REGISTRY_APNIC      }, // 192.160.205.0   - 192.160.205.255
	{ 0xc0a0ce00, 0xc0a0dfff, REGISTRY_ARIN       }, // 192.160.206.0   - 192.160.223.255
	{ 0xc0a0e000, 0xc0a0e1ff, REGISTRY_RIPENCC    }, // 192.160.224.0   - 192.160.225.255
	{ 0xc0a0e300, 0xc0a0e4ff, REGISTRY_ARIN       }, // 192.160.227.0   - 192.160.228.255
	{ 0xc0a0e500, 0xc0a0e5ff, REGISTRY_APNIC      }, // 192.160.229.0   - 192.160.229.255
	{ 0xc0a0e600, 0xc0a0e6ff, REGISTRY_ARIN       }, // 192.160.230.0   - 192.160.230.255
	{ 0xc0a0e700, 0xc0a0e9ff, REGISTRY_RIPENCC    }, // 192.160.231.0   - 192.160.233.255
	{ 0xc0a0ea00, 0xc0a0f4ff, REGISTRY_ARIN       }, // 192.160.234.0   - 192.160.244.255
	{ 0xc0a0f500, 0xc0a0f9ff, REGISTRY_RIPENCC    }, // 192.160.245.0   - 192.160.249.255
	{ 0xc0a0fa00, 0xc0a0faff, REGISTRY_ARIN       }, // 192.160.250.0   - 192.160.250.255
	{ 0xc0a0fb00, 0xc0a0fcff, REGISTRY_RIPENCC    }, // 192.160.251.0   - 192.160.252.255
	{ 0xc0a0fd00, 0xc0a105ff, REGISTRY_ARIN       }, // 192.160.253.0   - 192.161.5.255
	{ 0xc0a10600, 0xc0a107ff, REGISTRY_RIPENCC    }, // 192.161.6.0     - 192.161.7.255
	{ 0xc0a10800, 0xc0a13fff, REGISTRY_ARIN       }, // 192.161.8.0     - 192.161.63.255
	{ 0xc0a14000, 0xc0a141ff, REGISTRY_RIPENCC    }, // 192.161.64.0    - 192.161.65.255
	{ 0xc0a14200, 0xc0a17fff, REGISTRY_ARIN       }, // 192.161.66.0    - 192.161.127.255
	{ 0xc0a18000, 0xc0a181ff, REGISTRY_APNIC      }, // 192.161.128.0   - 192.161.129.255
	{ 0xc0a18200, 0xc0a1ffff, REGISTRY_ARIN       }, // 192.161.130.0   - 192.161.255.255
	{ 0xc0a20000, 0xc0a217ff, REGISTRY_RIPENCC    }, // 192.162.0.0     - 192.162.23.255
	{ 0xc0a21800, 0xc0a21bff, REGISTRY_RIPENCC    }, // 192.162.24.0    - 192.162.27.255
	{ 0xc0a21c00, 0xc0a263ff, REGISTRY_RIPENCC    }, // 192.162.28.0    - 192.162.99.255
	{ 0xc0a26400, 0xc0a267ff, REGISTRY_RIPENCC    }, // 192.162.100.0   - 192.162.103.255
	{ 0xc0a26800, 0xc0a29bff, REGISTRY_RIPENCC    }, // 192.162.104.0   - 192.162.155.255
	{ 0xc0a29c00, 0xc0a29fff, REGISTRY_RIPENCC    }, // 192.162.156.0   - 192.162.159.255
	{ 0xc0a2a000, 0xc0a2b7ff, REGISTRY_RIPENCC    }, // 192.162.160.0   - 192.162.183.255
	{ 0xc0a2b800, 0xc0a2bbff, REGISTRY_RIPENCC    }, // 192.162.184.0   - 192.162.187.255
	{ 0xc0a2bc00, 0xc0a2c3ff, REGISTRY_RIPENCC    }, // 192.162.188.0   - 192.162.195.255
	{ 0xc0a2c400, 0xc0a2c7ff, REGISTRY_RIPENCC    }, // 192.162.196.0   - 192.162.199.255
	{ 0xc0a2c800, 0xc0a2cbff, REGISTRY_RIPENCC    }, // 192.162.200.0   - 192.162.203.255
	{ 0xc0a2cc00, 0xc0a2cfff, REGISTRY_RIPENCC    }, // 192.162.204.0   - 192.162.207.255
	{ 0xc0a2d000, 0xc0a2ffff, REGISTRY_RIPENCC    }, // 192.162.208.0   - 192.162.255.255
	{ 0xc0a30000, 0xc0a31fff, REGISTRY_ARIN       }, // 192.163.0.0     - 192.163.31.255
	{ 0xc0a32000, 0xc0a39fff, REGISTRY_RIPENCC    }, // 192.163.32.0    - 192.163.159.255
	{ 0xc0a3a000, 0xc0a3ffff, REGISTRY_ARIN       }, // 192.163.160.0   - 192.163.255.255
	{ 0xc0a40000, 0xc0a425ff, REGISTRY_RIPENCC    }, // 192.164.0.0     - 192.164.37.255
	{ 0xc0a42600, 0xc0a426ff, REGISTRY_RIPENCC    }, // 192.164.38.0    - 192.164.38.255
	{ 0xc0a42700, 0xc0a447ff, REGISTRY_RIPENCC    }, // 192.164.39.0    - 192.164.71.255
	{ 0xc0a44800, 0xc0a44fff, REGISTRY_RIPENCC    }, // 192.164.72.0    - 192.164.79.255
	{ 0xc0a45000, 0xc0a49fff, REGISTRY_RIPENCC    }, // 192.164.80.0    - 192.164.159.255
	{ 0xc0a4a000, 0xc0a4cfff, REGISTRY_RIPENCC    }, // 192.164.160.0   - 192.164.207.255
	{ 0xc0a4d000, 0xc0a5ffff, REGISTRY_RIPENCC    }, // 192.164.208.0   - 192.165.255.255
	{ 0xc0a60000, 0xc0a607ff, REGISTRY_RIPENCC    }, // 192.166.0.0     - 192.166.7.255
	{ 0xc0a60800, 0xc0a60bff, REGISTRY_RIPENCC    }, // 192.166.8.0     - 192.166.11.255
	{ 0xc0a60c00, 0xc0a61fff, REGISTRY_RIPENCC    }, // 192.166.12.0    - 192.166.31.255
	{ 0xc0a62000, 0xc0a62fff, REGISTRY_RIPENCC    }, // 192.166.32.0    - 192.166.47.255
	{ 0xc0a63000, 0xc0a650ff, REGISTRY_RIPENCC    }, // 192.166.48.0    - 192.166.80.255
	{ 0xc0a65400, 0xc0a663ff, REGISTRY_RIPENCC    }, // 192.166.84.0    - 192.166.99.255
	{ 0xc0a66400, 0xc0a667ff, REGISTRY_RIPENCC    }, // 192.166.100.0   - 192.166.103.255
	{ 0xc0a66800, 0xc0a671ff, REGISTRY_RIPENCC    }, // 192.166.104.0   - 192.166.113.255
	{ 0xc0a67400, 0xc0a698ff, REGISTRY_RIPENCC    }, // 192.166.116.0   - 192.166.152.255
	{ 0xc0a69e00, 0xc0a6cbff, REGISTRY_RIPENCC    }, // 192.166.158.0   - 192.166.203.255
	{ 0xc0a6cc00, 0xc0a6cfff, REGISTRY_RIPENCC    }, // 192.166.204.0   - 192.166.207.255
	{ 0xc0a6d000, 0xc0a6dbff, REGISTRY_RIPENCC    }, // 192.166.208.0   - 192.166.219.255
	{ 0xc0a6dc00, 0xc0a6e7ff, REGISTRY_RIPENCC    }, // 192.166.220.0   - 192.166.231.255
	{ 0xc0a6e800, 0xc0a6efff, REGISTRY_RIPENCC    }, // 192.166.232.0   - 192.166.239.255
	{ 0xc0a6f000, 0xc0a6fbff, REGISTRY_RIPENCC    }, // 192.166.240.0   - 192.166.251.255
	{ 0xc0a6fd00, 0xc0a6ffff, REGISTRY_RIPENCC    }, // 192.166.253.0   - 192.166.255.255
	{ 0xc0a70000, 0xc0a7ffff, REGISTRY_RIPENCC    }, // 192.167.0.0     - 192.167.255.255
	{ 0xc0a90000, 0xc0a91fff, REGISTRY_ARIN       }, // 192.169.0.0     - 192.169.31.255
	{ 0xc0a92000, 0xc0a929ff, REGISTRY_APNIC      }, // 192.169.32.0    - 192.169.41.255
	{ 0xc0a92a00, 0xc0ab00ff, REGISTRY_ARIN       }, // 192.169.42.0    - 192.171.0.255
	{ 0xc0ab0100, 0xc0ab05ff, REGISTRY_RIPENCC    }, // 192.171.1.0     - 192.171.5.255
	{ 0xc0ab0600, 0xc0ab7fff, REGISTRY_ARIN       }, // 192.171.6.0     - 192.171.127.255
	{ 0xc0ab8000, 0xc0abc7ff, REGISTRY_RIPENCC    }, // 192.171.128.0   - 192.171.199.255
	{ 0xc0abc800, 0xc0ace2ff, REGISTRY_ARIN       }, // 192.171.200.0   - 192.172.226.255
	{ 0xc0ace300, 0xc0ace7ff, REGISTRY_APNIC      }, // 192.172.227.0   - 192.172.231.255
	{ 0xc0ace900, 0xc0ace9ff, REGISTRY_ARIN       }, // 192.172.233.0   - 192.172.233.255
	{ 0xc0acea00, 0xc0acefff, REGISTRY_APNIC      }, // 192.172.234.0   - 192.172.239.255
	{ 0xc0acf000, 0xc0acf0ff, REGISTRY_ARIN       }, // 192.172.240.0   - 192.172.240.255
	{ 0xc0acf100, 0xc0acf3ff, REGISTRY_APNIC      }, // 192.172.241.0   - 192.172.243.255
	{ 0xc0acf400, 0xc0acf4ff, REGISTRY_ARIN       }, // 192.172.244.0   - 192.172.244.255
	{ 0xc0acf700, 0xc0acfcff, REGISTRY_ARIN       }, // 192.172.247.0   - 192.172.252.255
	{ 0xc0acfd00, 0xc0acfdff, REGISTRY_RIPENCC    }, // 192.172.253.0   - 192.172.253.255
	{ 0xc0acfe00, 0xc0ad00ff, REGISTRY_ARIN       }, // 192.172.254.0   - 192.173.0.255
	{ 0xc0ad0100, 0xc0ad04ff, REGISTRY_RIPENCC    }, // 192.173.1.0     - 192.173.4.255
	{ 0xc0ad0500, 0xc0ad0fff, REGISTRY_ARIN       }, // 192.173.5.0     - 192.173.15.255
	{ 0xc0ad1000, 0xc0ad18ff, REGISTRY_APNIC      }, // 192.173.16.0    - 192.173.24.255
	{ 0xc0ad1900, 0xc0ad7fff, REGISTRY_ARIN       }, // 192.173.25.0    - 192.173.127.255
	{ 0xc0ad8000, 0xc0ad87ff, REGISTRY_RIPENCC    }, // 192.173.128.0   - 192.173.135.255
	{ 0xc0ad8800, 0xc0ae3fff, REGISTRY_ARIN       }, // 192.173.136.0   - 192.174.63.255
	{ 0xc0ae4000, 0xc0ae44ff, REGISTRY_RIPENCC    }, // 192.174.64.0    - 192.174.68.255
	{ 0xc0ae4500, 0xc0ae7fff, REGISTRY_ARIN       }, // 192.174.69.0    - 192.174.127.255
	{ 0xc0ae8000, 0xc0aeffff, REGISTRY_APNIC      }, // 192.174.128.0   - 192.174.255.255
	{ 0xc0af0000, 0xc0af0dff, REGISTRY_ARIN       }, // 192.175.0.0     - 192.175.13.255
	{ 0xc0af0e00, 0xc0af0fff, REGISTRY_RIPENCC    }, // 192.175.14.0    - 192.175.15.255
	{ 0xc0af1000, 0xc0af1fff, REGISTRY_ARIN       }, // 192.175.16.0    - 192.175.31.255
	{ 0xc0af2000, 0xc0af20ff, REGISTRY_RIPENCC    }, // 192.175.32.0    - 192.175.32.255
	{ 0xc0af2100, 0xc0af27ff, REGISTRY_RIPENCC    }, // 192.175.33.0    - 192.175.39.255
	{ 0xc0af2800, 0xc0af2bff, REGISTRY_RIPENCC    }, // 192.175.40.0    - 192.175.43.255
	{ 0xc0af2c00, 0xc0af2cff, REGISTRY_RIPENCC    }, // 192.175.44.0    - 192.175.44.255
	{ 0xc0af2d00, 0xc0af2dff, REGISTRY_RIPENCC    }, // 192.175.45.0    - 192.175.45.255
	{ 0xc0af2e00, 0xc0af2fff, REGISTRY_RIPENCC    }, // 192.175.46.0    - 192.175.47.255
	{ 0xc0af3000, 0xc0afffff, REGISTRY_ARIN       }, // 192.175.48.0    - 192.175.255.255
	{ 0xc0b00000, 0xc0b0ffff, REGISTRY_RIPENCC    }, // 192.176.0.0     - 192.176.255.255
	{ 0xc0b10000, 0xc0bb0fff, REGISTRY_ARIN       }, // 192.177.0.0     - 192.187.15.255
	{ 0xc0bb1000, 0xc0bb17ff, REGISTRY_RIPENCC    }, // 192.187.16.0    - 192.187.23.255
	{ 0xc0bb1800, 0xc0bb19ff, REGISTRY_RIPENCC    }, // 192.187.24.0    - 192.187.25.255
	{ 0xc0bb1a00, 0xc0bc09ff, REGISTRY_ARIN       }, // 192.187.26.0    - 192.188.9.255
	{ 0xc0bc0a00, 0xc0bc0aff, REGISTRY_RIPENCC    }, // 192.188.10.0    - 192.188.10.255
	{ 0xc0bc0b00, 0xc0bc0bff, REGISTRY_LACNIC     }, // 192.188.11.0    - 192.188.11.255
	{ 0xc0bc0c00, 0xc0bc2aff, REGISTRY_ARIN       }, // 192.188.12.0    - 192.188.42.255
	{ 0xc0bc2b00, 0xc0bc2bff, REGISTRY_APNIC      }, // 192.188.43.0    - 192.188.43.255
	{ 0xc0bc2c00, 0xc0bc3cff, REGISTRY_LACNIC     }, // 192.188.44.0    - 192.188.60.255
	{ 0xc0bc3d00, 0xc0bc3eff, REGISTRY_ARIN       }, // 192.188.61.0    - 192.188.62.255
	{ 0xc0bc3f00, 0xc0bc41ff, REGISTRY_RIPENCC    }, // 192.188.63.0    - 192.188.65.255
	{ 0xc0bc4200, 0xc0bc44ff, REGISTRY_ARIN       }, // 192.188.66.0    - 192.188.68.255
	{ 0xc0bc4500, 0xc0bc45ff, REGISTRY_RIPENCC    }, // 192.188.69.0    - 192.188.69.255
	{ 0xc0bc4600, 0xc0bc46ff, REGISTRY_ARIN       }, // 192.188.70.0    - 192.188.70.255
	{ 0xc0bc4700, 0xc0bc47ff, REGISTRY_APNIC      }, // 192.188.71.0    - 192.188.71.255
	{ 0xc0bc4800, 0xc0bc48ff, REGISTRY_ARIN       }, // 192.188.72.0    - 192.188.72.255
	{ 0xc0bc4900, 0xc0bc4fff, REGISTRY_APNIC      }, // 192.188.73.0    - 192.188.79.255
	{ 0xc0bc5100, 0xc0bc51ff, REGISTRY_ARIN       }, // 192.188.81.0    - 192.188.81.255
	{ 0xc0bc5200, 0xc0bc53ff, REGISTRY_APNIC      }, // 192.188.82.0    - 192.188.83.255
	{ 0xc0bc5400, 0xc0bc54ff, REGISTRY_ARIN       }, // 192.188.84.0    - 192.188.84.255
	{ 0xc0bc5800, 0xc0bc58ff, REGISTRY_ARIN       }, // 192.188.88.0    - 192.188.88.255
	{ 0xc0bc5b00, 0xc0bc5bff, REGISTRY_ARIN       }, // 192.188.91.0    - 192.188.91.255
	{ 0xc0bc5c00, 0xc0bc5cff, REGISTRY_APNIC      }, // 192.188.92.0    - 192.188.92.255
	{ 0xc0bc5d00, 0xc0bc5fff, REGISTRY_ARIN       }, // 192.188.93.0    - 192.188.95.255
	{ 0xc0bc6000, 0xc0bc60ff, REGISTRY_RIPENCC    }, // 192.188.96.0    - 192.188.96.255
	{ 0xc0bc6100, 0xc0bc64ff, REGISTRY_ARIN       }, // 192.188.97.0    - 192.188.100.255
	{ 0xc0bc6500, 0xc0bc65ff, REGISTRY_APNIC      }, // 192.188.101.0   - 192.188.101.255
	{ 0xc0bc6600, 0xc0bc68ff, REGISTRY_ARIN       }, // 192.188.102.0   - 192.188.104.255
	{ 0xc0bc6900, 0xc0bc69ff, REGISTRY_RIPENCC    }, // 192.188.105.0   - 192.188.105.255
	{ 0xc0bc6a00, 0xc0bc6aff, REGISTRY_ARIN       }, // 192.188.106.0   - 192.188.106.255
	{ 0xc0bc6b00, 0xc0bc6bff, REGISTRY_APNIC      }, // 192.188.107.0   - 192.188.107.255
	{ 0xc0bc6c00, 0xc0bc72ff, REGISTRY_ARIN       }, // 192.188.108.0   - 192.188.114.255
	{ 0xc0bc7300, 0xc0bc73ff, REGISTRY_APNIC      }, // 192.188.115.0   - 192.188.115.255
	{ 0xc0bc7400, 0xc0bc75ff, REGISTRY_RIPENCC    }, // 192.188.116.0   - 192.188.117.255
	{ 0xc0bc7600, 0xc0bc78ff, REGISTRY_ARIN       }, // 192.188.118.0   - 192.188.120.255
	{ 0xc0bc7900, 0xc0bc7aff, REGISTRY_RIPENCC    }, // 192.188.121.0   - 192.188.122.255
	{ 0xc0bc7b00, 0xc0bc7cff, REGISTRY_ARIN       }, // 192.188.123.0   - 192.188.124.255
	{ 0xc0bc7d00, 0xc0bc7dff, REGISTRY_RIPENCC    }, // 192.188.125.0   - 192.188.125.255
	{ 0xc0bc7e00, 0xc0bc7eff, REGISTRY_ARIN       }, // 192.188.126.0   - 192.188.126.255
	{ 0xc0bc7f00, 0xc0bc7fff, REGISTRY_RIPENCC    }, // 192.188.127.0   - 192.188.127.255
	{ 0xc0bc8100, 0xc0bc81ff, REGISTRY_RIPENCC    }, // 192.188.129.0   - 192.188.129.255
	{ 0xc0bc8200, 0xc0bc83ff, REGISTRY_ARIN       }, // 192.188.130.0   - 192.188.131.255
	{ 0xc0bc8400, 0xc0bc84ff, REGISTRY_RIPENCC    }, // 192.188.132.0   - 192.188.132.255
	{ 0xc0bc8500, 0xc0bc87ff, REGISTRY_ARIN       }, // 192.188.133.0   - 192.188.135.255
	{ 0xc0bc8800, 0xc0bc88ff, REGISTRY_RIPENCC    }, // 192.188.136.0   - 192.188.136.255
	{ 0xc0bc8900, 0xc0bc90ff, REGISTRY_ARIN       }, // 192.188.137.0   - 192.188.144.255
	{ 0xc0bc9100, 0xc0bc91ff, REGISTRY_RIPENCC    }, // 192.188.145.0   - 192.188.145.255
	{ 0xc0bc9200, 0xc0bc96ff, REGISTRY_ARIN       }, // 192.188.146.0   - 192.188.150.255
	{ 0xc0bc9700, 0xc0bc97ff, REGISTRY_APNIC      }, // 192.188.151.0   - 192.188.151.255
	{ 0xc0bc9800, 0xc0bc9cff, REGISTRY_ARIN       }, // 192.188.152.0   - 192.188.156.255
	{ 0xc0bc9d00, 0xc0bc9eff, REGISTRY_RIPENCC    }, // 192.188.157.0   - 192.188.158.255
	{ 0xc0bc9f00, 0xc0bca3ff, REGISTRY_ARIN       }, // 192.188.159.0   - 192.188.163.255
	{ 0xc0bca400, 0xc0bca7ff, REGISTRY_AFRINIC    }, // 192.188.164.0   - 192.188.167.255
	{ 0xc0bca800, 0xc0bca9ff, REGISTRY_ARIN       }, // 192.188.168.0   - 192.188.169.255
	{ 0xc0bcaa00, 0xc0bcacff, REGISTRY_APNIC      }, // 192.188.170.0   - 192.188.172.255
	{ 0xc0bcad00, 0xc0bcadff, REGISTRY_ARIN       }, // 192.188.173.0   - 192.188.173.255
	{ 0xc0bcae00, 0xc0bcafff, REGISTRY_APNIC      }, // 192.188.174.0   - 192.188.175.255
	{ 0xc0bcb000, 0xc0bcb8ff, REGISTRY_ARIN       }, // 192.188.176.0   - 192.188.184.255
	{ 0xc0bcb900, 0xc0bcbaff, REGISTRY_APNIC      }, // 192.188.185.0   - 192.188.186.255
	{ 0xc0bcbb00, 0xc0bcbbff, REGISTRY_RIPENCC    }, // 192.188.187.0   - 192.188.187.255
	{ 0xc0bcbc00, 0xc0bcbcff, REGISTRY_ARIN       }, // 192.188.188.0   - 192.188.188.255
	{ 0xc0bcbd00, 0xc0bcbdff, REGISTRY_RIPENCC    }, // 192.188.189.0   - 192.188.189.255
	{ 0xc0bcbe00, 0xc0bcc1ff, REGISTRY_ARIN       }, // 192.188.190.0   - 192.188.193.255
	{ 0xc0bcc200, 0xc0bcc5ff, REGISTRY_LACNIC     }, // 192.188.194.0   - 192.188.197.255
	{ 0xc0bcc600, 0xc0bce8ff, REGISTRY_ARIN       }, // 192.188.198.0   - 192.188.232.255
	{ 0xc0bce900, 0xc0bcedff, REGISTRY_RIPENCC    }, // 192.188.233.0   - 192.188.237.255
	{ 0xc0bcee00, 0xc0bcf0ff, REGISTRY_ARIN       }, // 192.188.238.0   - 192.188.240.255
	{ 0xc0bcf100, 0xc0bcf1ff, REGISTRY_APNIC      }, // 192.188.241.0   - 192.188.241.255
	{ 0xc0bcf200, 0xc0bcf7ff, REGISTRY_RIPENCC    }, // 192.188.242.0   - 192.188.247.255
	{ 0xc0bcf900, 0xc0bd00ff, REGISTRY_ARIN       }, // 192.188.249.0   - 192.189.0.255
	{ 0xc0bd0100, 0xc0bd01ff, REGISTRY_RIPENCC    }, // 192.189.1.0     - 192.189.1.255
	{ 0xc0bd0200, 0xc0bd07ff, REGISTRY_ARIN       }, // 192.189.2.0     - 192.189.7.255
	{ 0xc0bd0800, 0xc0bd0bff, REGISTRY_RIPENCC    }, // 192.189.8.0     - 192.189.11.255
	{ 0xc0bd0c00, 0xc0bd0dff, REGISTRY_ARIN       }, // 192.189.12.0    - 192.189.13.255
	{ 0xc0bd0e00, 0xc0bd0eff, REGISTRY_RIPENCC    }, // 192.189.14.0    - 192.189.14.255
	{ 0xc0bd0f00, 0xc0bd16ff, REGISTRY_ARIN       }, // 192.189.15.0    - 192.189.22.255
	{ 0xc0bd1700, 0xc0bd17ff, REGISTRY_RIPENCC    }, // 192.189.23.0    - 192.189.23.255
	{ 0xc0bd1800, 0xc0bd18ff, REGISTRY_APNIC      }, // 192.189.24.0    - 192.189.24.255
	{ 0xc0bd1900, 0xc0bd21ff, REGISTRY_ARIN       }, // 192.189.25.0    - 192.189.33.255
	{ 0xc0bd2200, 0xc0bd22ff, REGISTRY_APNIC      }, // 192.189.34.0    - 192.189.34.255
	{ 0xc0bd2300, 0xc0bd28ff, REGISTRY_ARIN       }, // 192.189.35.0    - 192.189.40.255
	{ 0xc0bd2900, 0xc0bd29ff, REGISTRY_RIPENCC    }, // 192.189.41.0    - 192.189.41.255
	{ 0xc0bd2a00, 0xc0bd32ff, REGISTRY_ARIN       }, // 192.189.42.0    - 192.189.50.255
	{ 0xc0bd3300, 0xc0bd34ff, REGISTRY_RIPENCC    }, // 192.189.51.0    - 192.189.52.255
	{ 0xc0bd3500, 0xc0bd35ff, REGISTRY_ARIN       }, // 192.189.53.0    - 192.189.53.255
	{ 0xc0bd3600, 0xc0bd36ff, REGISTRY_APNIC      }, // 192.189.54.0    - 192.189.54.255
	{ 0xc0bd3700, 0xc0bd37ff, REGISTRY_RIPENCC    }, // 192.189.55.0    - 192.189.55.255
	{ 0xc0bd3800, 0xc0bd41ff, REGISTRY_ARIN       }, // 192.189.56.0    - 192.189.65.255
	{ 0xc0bd4200, 0xc0bd42ff, REGISTRY_RIPENCC    }, // 192.189.66.0    - 192.189.66.255
	{ 0xc0bd4300, 0xc0bd44ff, REGISTRY_ARIN       }, // 192.189.67.0    - 192.189.68.255
	{ 0xc0bd4500, 0xc0bd46ff, REGISTRY_RIPENCC    }, // 192.189.69.0    - 192.189.70.255
	{ 0xc0bd4700, 0xc0bd48ff, REGISTRY_ARIN       }, // 192.189.71.0    - 192.189.72.255
	{ 0xc0bd4900, 0xc0bd49ff, REGISTRY_RIPENCC    }, // 192.189.73.0    - 192.189.73.255
	{ 0xc0bd4a00, 0xc0bd4aff, REGISTRY_ARIN       }, // 192.189.74.0    - 192.189.74.255
	{ 0xc0bd4b00, 0xc0bd4bff, REGISTRY_AFRINIC    }, // 192.189.75.0    - 192.189.75.255
	{ 0xc0bd4c00, 0xc0bd4cff, REGISTRY_RIPENCC    }, // 192.189.76.0    - 192.189.76.255
	{ 0xc0bd4d00, 0xc0bd5dff, REGISTRY_ARIN       }, // 192.189.77.0    - 192.189.93.255
	{ 0xc0bd5f00, 0xc0bd76ff, REGISTRY_ARIN       }, // 192.189.95.0    - 192.189.118.255
	{ 0xc0bd7700, 0xc0bd77ff, REGISTRY_RIPENCC    }, // 192.189.119.0   - 192.189.119.255
	{ 0xc0bd7800, 0xc0bd87ff, REGISTRY_ARIN       }, // 192.189.120.0   - 192.189.135.255
	{ 0xc0bd8800, 0xc0bd88ff, REGISTRY_APNIC      }, // 192.189.136.0   - 192.189.136.255
	{ 0xc0bd8900, 0xc0bd8aff, REGISTRY_ARIN       }, // 192.189.137.0   - 192.189.138.255
	{ 0xc0bd8b00, 0xc0bd8cff, REGISTRY_AFRINIC    }, // 192.189.139.0   - 192.189.140.255
	{ 0xc0bd8d00, 0xc0bd93ff, REGISTRY_ARIN       }, // 192.189.141.0   - 192.189.147.255
	{ 0xc0bd9400, 0xc0bd94ff, REGISTRY_APNIC      }, // 192.189.148.0   - 192.189.148.255
	{ 0xc0bd9500, 0xc0bd96ff, REGISTRY_ARIN       }, // 192.189.149.0   - 192.189.150.255
	{ 0xc0bd9700, 0xc0bd97ff, REGISTRY_RIPENCC    }, // 192.189.151.0   - 192.189.151.255
	{ 0xc0bd9800, 0xc0bd99ff, REGISTRY_ARIN       }, // 192.189.152.0   - 192.189.153.255
	{ 0xc0bd9a00, 0xc0bd9aff, REGISTRY_RIPENCC    }, // 192.189.154.0   - 192.189.154.255
	{ 0xc0bd9b00, 0xc0bd9cff, REGISTRY_ARIN       }, // 192.189.155.0   - 192.189.156.255
	{ 0xc0bd9d00, 0xc0bd9dff, REGISTRY_RIPENCC    }, // 192.189.157.0   - 192.189.157.255
	{ 0xc0bd9e00, 0xc0bd9eff, REGISTRY_ARIN       }, // 192.189.158.0   - 192.189.158.255
	{ 0xc0bda000, 0xc0bda0ff, REGISTRY_RIPENCC    }, // 192.189.160.0   - 192.189.160.255
	{ 0xc0bda100, 0xc0bda5ff, REGISTRY_ARIN       }, // 192.189.161.0   - 192.189.165.255
	{ 0xc0bda600, 0xc0bdaaff, REGISTRY_RIPENCC    }, // 192.189.166.0   - 192.189.170.255
	{ 0xc0bdab00, 0xc0bdc9ff, REGISTRY_ARIN       }, // 192.189.171.0   - 192.189.201.255
	{ 0xc0bdca00, 0xc0bdcbff, REGISTRY_RIPENCC    }, // 192.189.202.0   - 192.189.203.255
	{ 0xc0bdcc00, 0xc0bdcfff, REGISTRY_ARIN       }, // 192.189.204.0   - 192.189.207.255
	{ 0xc0bdd000, 0xc0bdd3ff, REGISTRY_APNIC      }, // 192.189.208.0   - 192.189.211.255
	{ 0xc0bdd400, 0xc0bddeff, REGISTRY_ARIN       }, // 192.189.212.0   - 192.189.222.255
	{ 0xc0bddf00, 0xc0bddfff, REGISTRY_APNIC      }, // 192.189.223.0   - 192.189.223.255
	{ 0xc0bde000, 0xc0bde4ff, REGISTRY_ARIN       }, // 192.189.224.0   - 192.189.228.255
	{ 0xc0bde500, 0xc0bde5ff, REGISTRY_APNIC      }, // 192.189.229.0   - 192.189.229.255
	{ 0xc0bdea00, 0xc0bdfaff, REGISTRY_ARIN       }, // 192.189.234.0   - 192.189.250.255
	{ 0xc0bdfb00, 0xc0bdfbff, REGISTRY_RIPENCC    }, // 192.189.251.0   - 192.189.251.255
	{ 0xc0bdfc00, 0xc0be1dff, REGISTRY_ARIN       }, // 192.189.252.0   - 192.190.29.255
	{ 0xc0be1e00, 0xc0be1fff, REGISTRY_LACNIC     }, // 192.190.30.0    - 192.190.31.255
	{ 0xc0be2000, 0xc0be2bff, REGISTRY_ARIN       }, // 192.190.32.0    - 192.190.43.255
	{ 0xc0be2c00, 0xc0be2cff, REGISTRY_RIPENCC    }, // 192.190.44.0    - 192.190.44.255
	{ 0xc0be2d00, 0xc0be39ff, REGISTRY_ARIN       }, // 192.190.45.0    - 192.190.57.255
	{ 0xc0be3a00, 0xc0be3bff, REGISTRY_RIPENCC    }, // 192.190.58.0    - 192.190.59.255
	{ 0xc0be3c00, 0xc0be3cff, REGISTRY_ARIN       }, // 192.190.60.0    - 192.190.60.255
	{ 0xc0be3d00, 0xc0be3dff, REGISTRY_APNIC      }, // 192.190.61.0    - 192.190.61.255
	{ 0xc0be3e00, 0xc0be3fff, REGISTRY_ARIN       }, // 192.190.62.0    - 192.190.63.255
	{ 0xc0be4000, 0xc0be40ff, REGISTRY_RIPENCC    }, // 192.190.64.0    - 192.190.64.255
	{ 0xc0be4100, 0xc0be41ff, REGISTRY_ARIN       }, // 192.190.65.0    - 192.190.65.255
	{ 0xc0be4200, 0xc0be42ff, REGISTRY_APNIC      }, // 192.190.66.0    - 192.190.66.255
	{ 0xc0be4300, 0xc0be43ff, REGISTRY_RIPENCC    }, // 192.190.67.0    - 192.190.67.255
	{ 0xc0be4400, 0xc0be44ff, REGISTRY_ARIN       }, // 192.190.68.0    - 192.190.68.255
	{ 0xc0be4500, 0xc0be45ff, REGISTRY_RIPENCC    }, // 192.190.69.0    - 192.190.69.255
	{ 0xc0be4600, 0xc0be5eff, REGISTRY_ARIN       }, // 192.190.70.0    - 192.190.94.255
	{ 0xc0be5f00, 0xc0be5fff, REGISTRY_RIPENCC    }, // 192.190.95.0    - 192.190.95.255
	{ 0xc0be6000, 0xc0be6bff, REGISTRY_ARIN       }, // 192.190.96.0    - 192.190.107.255
	{ 0xc0be6c00, 0xc0be6cff, REGISTRY_APNIC      }, // 192.190.108.0   - 192.190.108.255
	{ 0xc0be6d00, 0xc0be80ff, REGISTRY_ARIN       }, // 192.190.109.0   - 192.190.128.255
	{ 0xc0be8100, 0xc0be84ff, REGISTRY_RIPENCC    }, // 192.190.129.0   - 192.190.132.255
	{ 0xc0be8500, 0xc0beacff, REGISTRY_ARIN       }, // 192.190.133.0   - 192.190.172.255
	{ 0xc0bead00, 0xc0beaeff, REGISTRY_RIPENCC    }, // 192.190.173.0   - 192.190.174.255
	{ 0xc0beaf00, 0xc0beb3ff, REGISTRY_ARIN       }, // 192.190.175.0   - 192.190.179.255
	{ 0xc0beb400, 0xc0beb4ff, REGISTRY_APNIC      }, // 192.190.180.0   - 192.190.180.255
	{ 0xc0beb600, 0xc0beb7ff, REGISTRY_RIPENCC    }, // 192.190.182.0   - 192.190.183.255
	{ 0xc0beb800, 0xc0bebdff, REGISTRY_ARIN       }, // 192.190.184.0   - 192.190.189.255
	{ 0xc0bebe00, 0xc0bec1ff, REGISTRY_RIPENCC    }, // 192.190.190.0   - 192.190.193.255
	{ 0xc0bec200, 0xc0bec8ff, REGISTRY_ARIN       }, // 192.190.194.0   - 192.190.200.255
	{ 0xc0bec900, 0xc0becaff, REGISTRY_RIPENCC    }, // 192.190.201.0   - 192.190.202.255
	{ 0xc0becb00, 0xc0becbff, REGISTRY_ARIN       }, // 192.190.203.0   - 192.190.203.255
	{ 0xc0becc00, 0xc0becdff, REGISTRY_APNIC      }, // 192.190.204.0   - 192.190.205.255
	{ 0xc0bece00, 0xc0becfff, REGISTRY_ARIN       }, // 192.190.206.0   - 192.190.207.255
	{ 0xc0bed000, 0xc0bed7ff, REGISTRY_APNIC      }, // 192.190.208.0   - 192.190.215.255
	{ 0xc0bed800, 0xc0bee8ff, REGISTRY_ARIN       }, // 192.190.216.0   - 192.190.232.255
	{ 0xc0bee900, 0xc0beecff, REGISTRY_RIPENCC    }, // 192.190.233.0   - 192.190.236.255
	{ 0xc0beed00, 0xc0beefff, REGISTRY_ARIN       }, // 192.190.237.0   - 192.190.239.255
	{ 0xc0bef000, 0xc0bef0ff, REGISTRY_RIPENCC    }, // 192.190.240.0   - 192.190.240.255
	{ 0xc0bef100, 0xc0bef1ff, REGISTRY_ARIN       }, // 192.190.241.0   - 192.190.241.255
	{ 0xc0bef200, 0xc0bef2ff, REGISTRY_RIPENCC    }, // 192.190.242.0   - 192.190.242.255
	{ 0xc0bef300, 0xc0bef6ff, REGISTRY_ARIN       }, // 192.190.243.0   - 192.190.246.255
	{ 0xc0bef700, 0xc0bef9ff, REGISTRY_RIPENCC    }, // 192.190.247.0   - 192.190.249.255
	{ 0xc0befa00, 0xc0bfffff, REGISTRY_ARIN       }, // 192.190.250.0   - 192.191.255.255
	{ 0xc0c00000, 0xc0c0ffff, REGISTRY_APNIC      }, // 192.192.0.0     - 192.192.255.255
	{ 0xc0c10000, 0xc0c1ffff, REGISTRY_ARIN       }, // 192.193.0.0     - 192.193.255.255
	{ 0xc0c20000, 0xc0c2ffff, REGISTRY_RIPENCC    }, // 192.194.0.0     - 192.194.255.255
	{ 0xc0c30000, 0xc0c300ff, REGISTRY_ARIN       }, // 192.195.0.0     - 192.195.0.255
	{ 0xc0c30100, 0xc0c301ff, REGISTRY_RIPENCC    }, // 192.195.1.0     - 192.195.1.255
	{ 0xc0c30300, 0xc0c307ff, REGISTRY_ARIN       }, // 192.195.3.0     - 192.195.7.255
	{ 0xc0c30800, 0xc0c308ff, REGISTRY_RIPENCC    }, // 192.195.8.0     - 192.195.8.255
	{ 0xc0c30900, 0xc0c309ff, REGISTRY_ARIN       }, // 192.195.9.0     - 192.195.9.255
	{ 0xc0c30b00, 0xc0c30bff, REGISTRY_ARIN       }, // 192.195.11.0    - 192.195.11.255
	{ 0xc0c30c00, 0xc0c30eff, REGISTRY_APNIC      }, // 192.195.12.0    - 192.195.14.255
	{ 0xc0c30f00, 0xc0c321ff, REGISTRY_ARIN       }, // 192.195.15.0    - 192.195.33.255
	{ 0xc0c32200, 0xc0c322ff, REGISTRY_APNIC      }, // 192.195.34.0    - 192.195.34.255
	{ 0xc0c32300, 0xc0c326ff, REGISTRY_ARIN       }, // 192.195.35.0    - 192.195.38.255
	{ 0xc0c32700, 0xc0c328ff, REGISTRY_APNIC      }, // 192.195.39.0    - 192.195.40.255
	{ 0xc0c32900, 0xc0c329ff, REGISTRY_ARIN       }, // 192.195.41.0    - 192.195.41.255
	{ 0xc0c32a00, 0xc0c32bff, REGISTRY_RIPENCC    }, // 192.195.42.0    - 192.195.43.255
	{ 0xc0c32c00, 0xc0c337ff, REGISTRY_APNIC      }, // 192.195.44.0    - 192.195.55.255
	{ 0xc0c33a00, 0xc0c347ff, REGISTRY_ARIN       }, // 192.195.58.0    - 192.195.71.255
	{ 0xc0c34800, 0xc0c348ff, REGISTRY_RIPENCC    }, // 192.195.72.0    - 192.195.72.255
	{ 0xc0c34900, 0xc0c361ff, REGISTRY_ARIN       }, // 192.195.73.0    - 192.195.97.255
	{ 0xc0c36200, 0xc0c362ff, REGISTRY_RIPENCC    }, // 192.195.98.0    - 192.195.98.255
	{ 0xc0c36300, 0xc0c365ff, REGISTRY_ARIN       }, // 192.195.99.0    - 192.195.101.255
	{ 0xc0c36600, 0xc0c366ff, REGISTRY_APNIC      }, // 192.195.102.0   - 192.195.102.255
	{ 0xc0c36700, 0xc0c368ff, REGISTRY_ARIN       }, // 192.195.103.0   - 192.195.104.255
	{ 0xc0c36900, 0xc0c36aff, REGISTRY_RIPENCC    }, // 192.195.105.0   - 192.195.106.255
	{ 0xc0c36b00, 0xc0c36dff, REGISTRY_ARIN       }, // 192.195.107.0   - 192.195.109.255
	{ 0xc0c36e00, 0xc0c36eff, REGISTRY_RIPENCC    }, // 192.195.110.0   - 192.195.110.255
	{ 0xc0c36f00, 0xc0c36fff, REGISTRY_ARIN       }, // 192.195.111.0   - 192.195.111.255
	{ 0xc0c37000, 0xc0c370ff, REGISTRY_APNIC      }, // 192.195.112.0   - 192.195.112.255
	{ 0xc0c37100, 0xc0c373ff, REGISTRY_ARIN       }, // 192.195.113.0   - 192.195.115.255
	{ 0xc0c37400, 0xc0c376ff, REGISTRY_RIPENCC    }, // 192.195.116.0   - 192.195.118.255
	{ 0xc0c37700, 0xc0c385ff, REGISTRY_ARIN       }, // 192.195.119.0   - 192.195.133.255
	{ 0xc0c38600, 0xc0c394ff, REGISTRY_RIPENCC    }, // 192.195.134.0   - 192.195.148.255
	{ 0xc0c39500, 0xc0c397ff, REGISTRY_ARIN       }, // 192.195.149.0   - 192.195.151.255
	{ 0xc0c39800, 0xc0c398ff, REGISTRY_APNIC      }, // 192.195.152.0   - 192.195.152.255
	{ 0xc0c39900, 0xc0c3a9ff, REGISTRY_ARIN       }, // 192.195.153.0   - 192.195.169.255
	{ 0xc0c3aa00, 0xc0c3aaff, REGISTRY_APNIC      }, // 192.195.170.0   - 192.195.170.255
	{ 0xc0c3ab00, 0xc0c3b6ff, REGISTRY_ARIN       }, // 192.195.171.0   - 192.195.182.255
	{ 0xc0c3b700, 0xc0c3b8ff, REGISTRY_RIPENCC    }, // 192.195.183.0   - 192.195.184.255
	{ 0xc0c3b900, 0xc0c3b9ff, REGISTRY_ARIN       }, // 192.195.185.0   - 192.195.185.255
	{ 0xc0c3bb00, 0xc0c3c2ff, REGISTRY_ARIN       }, // 192.195.187.0   - 192.195.194.255
	{ 0xc0c3c300, 0xc0c3c3ff, REGISTRY_RIPENCC    }, // 192.195.195.0   - 192.195.195.255
	{ 0xc0c3c400, 0xc0c3c4ff, REGISTRY_ARIN       }, // 192.195.196.0   - 192.195.196.255
	{ 0xc0c3c500, 0xc0c3c5ff, REGISTRY_APNIC      }, // 192.195.197.0   - 192.195.197.255
	{ 0xc0c3c600, 0xc0c3daff, REGISTRY_ARIN       }, // 192.195.198.0   - 192.195.218.255
	{ 0xc0c3db00, 0xc0c3dbff, REGISTRY_APNIC      }, // 192.195.219.0   - 192.195.219.255
	{ 0xc0c3dc00, 0xc0c3e8ff, REGISTRY_ARIN       }, // 192.195.220.0   - 192.195.232.255
	{ 0xc0c3ea00, 0xc0c3ebff, REGISTRY_ARIN       }, // 192.195.234.0   - 192.195.235.255
	{ 0xc0c3ec00, 0xc0c3ecff, REGISTRY_RIPENCC    }, // 192.195.236.0   - 192.195.236.255
	{ 0xc0c3ed00, 0xc0c3edff, REGISTRY_LACNIC     }, // 192.195.237.0   - 192.195.237.255
	{ 0xc0c3ee00, 0xc0c400ff, REGISTRY_ARIN       }, // 192.195.238.0   - 192.196.0.255
	{ 0xc0c40100, 0xc0c49bff, REGISTRY_RIPENCC    }, // 192.196.1.0     - 192.196.155.255
	{ 0xc0c49c00, 0xc0c570ff, REGISTRY_ARIN       }, // 192.196.156.0   - 192.197.112.255
	{ 0xc0c57100, 0xc0c571ff, REGISTRY_APNIC      }, // 192.197.113.0   - 192.197.113.255
	{ 0xc0c57200, 0xc0c607ff, REGISTRY_ARIN       }, // 192.197.114.0   - 192.198.7.255
	{ 0xc0c60800, 0xc0c60fff, REGISTRY_LACNIC     }, // 192.198.8.0     - 192.198.15.255
	{ 0xc0c61000, 0xc0c70fff, REGISTRY_ARIN       }, // 192.198.16.0    - 192.199.15.255
	{ 0xc0c71000, 0xc0c71fff, REGISTRY_RIPENCC    }, // 192.199.16.0    - 192.199.31.255
	{ 0xc0c72000, 0xc0c72fff, REGISTRY_APNIC      }, // 192.199.32.0    - 192.199.47.255
	{ 0xc0c73000, 0xc0c83fff, REGISTRY_ARIN       }, // 192.199.48.0    - 192.200.63.255
	{ 0xc0c84000, 0xc0c84fff, REGISTRY_APNIC      }, // 192.200.64.0    - 192.200.79.255
	{ 0xc0c85000, 0xc0cb25ff, REGISTRY_ARIN       }, // 192.200.80.0    - 192.203.37.255
	{ 0xc0cb2800, 0xc0cb4fff, REGISTRY_ARIN       }, // 192.203.40.0    - 192.203.79.255
	{ 0xc0cb5000, 0xc0cb50ff, REGISTRY_RIPENCC    }, // 192.203.80.0    - 192.203.80.255
	{ 0xc0cb6000, 0xc0cb62ff, REGISTRY_ARIN       }, // 192.203.96.0    - 192.203.98.255
	{ 0xc0cb6400, 0xc0cb6bff, REGISTRY_ARIN       }, // 192.203.100.0   - 192.203.107.255
	{ 0xc0cb6c00, 0xc0cb6dff, REGISTRY_RIPENCC    }, // 192.203.108.0   - 192.203.109.255
	{ 0xc0cb6e00, 0xc0cb89ff, REGISTRY_ARIN       }, // 192.203.110.0   - 192.203.137.255
	{ 0xc0cb8a00, 0xc0cb92ff, REGISTRY_APNIC      }, // 192.203.138.0   - 192.203.146.255
	{ 0xc0cb9300, 0xc0cb99ff, REGISTRY_ARIN       }, // 192.203.147.0   - 192.203.153.255
	{ 0xc0cb9a00, 0xc0cb9aff, REGISTRY_APNIC      }, // 192.203.154.0   - 192.203.154.255
	{ 0xc0cb9b00, 0xc0cb9bff, REGISTRY_ARIN       }, // 192.203.155.0   - 192.203.155.255
	{ 0xc0cb9e00, 0xc0cb9eff, REGISTRY_LACNIC     }, // 192.203.158.0   - 192.203.158.255
	{ 0xc0cb9f00, 0xc0cbafff, REGISTRY_ARIN       }, // 192.203.159.0   - 192.203.175.255
	{ 0xc0cbb000, 0xc0cbb0ff, REGISTRY_APNIC      }, // 192.203.176.0   - 192.203.176.255
	{ 0xc0cbb100, 0xc0cbb1ff, REGISTRY_LACNIC     }, // 192.203.177.0   - 192.203.177.255
	{ 0xc0cbb200, 0xc0cbb6ff, REGISTRY_ARIN       }, // 192.203.178.0   - 192.203.182.255
	{ 0xc0cbba00, 0xc0cbc0ff, REGISTRY_ARIN       }, // 192.203.186.0   - 192.203.192.255
	{ 0xc0cbc200, 0xc0cbcfff, REGISTRY_ARIN       }, // 192.203.194.0   - 192.203.207.255
	{ 0xc0cbd200, 0xc0cbd4ff, REGISTRY_ARIN       }, // 192.203.210.0   - 192.203.212.255
	{ 0xc0cbd500, 0xc0cbd5ff, REGISTRY_APNIC      }, // 192.203.213.0   - 192.203.213.255
	{ 0xc0cbd600, 0xc0cbd7ff, REGISTRY_ARIN       }, // 192.203.214.0   - 192.203.215.255
	{ 0xc0cbd800, 0xc0cbd8ff, REGISTRY_APNIC      }, // 192.203.216.0   - 192.203.216.255
	{ 0xc0cbd900, 0xc0cbe2ff, REGISTRY_ARIN       }, // 192.203.217.0   - 192.203.226.255
	{ 0xc0cbe300, 0xc0cbe3ff, REGISTRY_RIPENCC    }, // 192.203.227.0   - 192.203.227.255
	{ 0xc0cbe400, 0xc0cbe7ff, REGISTRY_ARIN       }, // 192.203.228.0   - 192.203.231.255
	{ 0xc0cbe800, 0xc0cbe8ff, REGISTRY_APNIC      }, // 192.203.232.0   - 192.203.232.255
	{ 0xc0cbe900, 0xc0cbeaff, REGISTRY_ARIN       }, // 192.203.233.0   - 192.203.234.255
	{ 0xc0cbeb00, 0xc0cbebff, REGISTRY_APNIC      }, // 192.203.235.0   - 192.203.235.255
	{ 0xc0cbec00, 0xc0cbf6ff, REGISTRY_ARIN       }, // 192.203.236.0   - 192.203.246.255
	{ 0xc0cbf700, 0xc0cbf7ff, REGISTRY_APNIC      }, // 192.203.247.0   - 192.203.247.255
	{ 0xc0cbf800, 0xc0ce4cff, REGISTRY_ARIN       }, // 192.203.248.0   - 192.206.76.255
	{ 0xc0ce4d00, 0xc0ce51ff, REGISTRY_RIPENCC    }, // 192.206.77.0    - 192.206.81.255
	{ 0xc0ce5200, 0xc0ce55ff, REGISTRY_ARIN       }, // 192.206.82.0    - 192.206.85.255
	{ 0xc0ce5600, 0xc0ce56ff, REGISTRY_RIPENCC    }, // 192.206.86.0    - 192.206.86.255
	{ 0xc0ce5700, 0xc0ce65ff, REGISTRY_ARIN       }, // 192.206.87.0    - 192.206.101.255
	{ 0xc0ce6700, 0xc0ce6bff, REGISTRY_ARIN       }, // 192.206.103.0   - 192.206.107.255
	{ 0xc0ce6d00, 0xc0ce74ff, REGISTRY_ARIN       }, // 192.206.109.0   - 192.206.116.255
	{ 0xc0ce7600, 0xc0ce97ff, REGISTRY_ARIN       }, // 192.206.118.0   - 192.206.151.255
	{ 0xc0ce9800, 0xc0ce9dff, REGISTRY_APNIC      }, // 192.206.152.0   - 192.206.157.255
	{ 0xc0ce9e00, 0xc0ceddff, REGISTRY_ARIN       }, // 192.206.158.0   - 192.206.221.255
	{ 0xc0cede00, 0xc0cee2ff, REGISTRY_RIPENCC    }, // 192.206.222.0   - 192.206.226.255
	{ 0xc0cee300, 0xc0cf0dff, REGISTRY_ARIN       }, // 192.206.227.0   - 192.207.13.255
	{ 0xc0cf0f00, 0xc0cf1eff, REGISTRY_ARIN       }, // 192.207.15.0    - 192.207.30.255
	{ 0xc0cf1f00, 0xc0cf1fff, REGISTRY_RIPENCC    }, // 192.207.31.0    - 192.207.31.255
	{ 0xc0cf2000, 0xc0cf20ff, REGISTRY_ARIN       }, // 192.207.32.0    - 192.207.32.255
	{ 0xc0cf2100, 0xc0cf21ff, REGISTRY_APNIC      }, // 192.207.33.0    - 192.207.33.255
	{ 0xc0cf2200, 0xc0cf23ff, REGISTRY_ARIN       }, // 192.207.34.0    - 192.207.35.255
	{ 0xc0cf2400, 0xc0cf24ff, REGISTRY_APNIC      }, // 192.207.36.0    - 192.207.36.255
	{ 0xc0cf2500, 0xc0cf27ff, REGISTRY_ARIN       }, // 192.207.37.0    - 192.207.39.255
	{ 0xc0cf2800, 0xc0cf2aff, REGISTRY_LACNIC     }, // 192.207.40.0    - 192.207.42.255
	{ 0xc0cf2b00, 0xc0cf3fff, REGISTRY_ARIN       }, // 192.207.43.0    - 192.207.63.255
	{ 0xc0cf4000, 0xc0cf40ff, REGISTRY_APNIC      }, // 192.207.64.0    - 192.207.64.255
	{ 0xc0cf4100, 0xc0cf44ff, REGISTRY_LACNIC     }, // 192.207.65.0    - 192.207.68.255
	{ 0xc0cf4500, 0xc0cf5aff, REGISTRY_ARIN       }, // 192.207.69.0    - 192.207.90.255
	{ 0xc0cf5b00, 0xc0cf5bff, REGISTRY_APNIC      }, // 192.207.91.0    - 192.207.91.255
	{ 0xc0cf5c00, 0xc0cf5fff, REGISTRY_ARIN       }, // 192.207.92.0    - 192.207.95.255
	{ 0xc0cf6000, 0xc0cf62ff, REGISTRY_APNIC      }, // 192.207.96.0    - 192.207.98.255
	{ 0xc0cf6300, 0xc0cf70ff, REGISTRY_ARIN       }, // 192.207.99.0    - 192.207.112.255
	{ 0xc0cf7100, 0xc0cf71ff, REGISTRY_APNIC      }, // 192.207.113.0   - 192.207.113.255
	{ 0xc0cf7200, 0xc0cf76ff, REGISTRY_ARIN       }, // 192.207.114.0   - 192.207.118.255
	{ 0xc0cf7700, 0xc0cf79ff, REGISTRY_APNIC      }, // 192.207.119.0   - 192.207.121.255
	{ 0xc0cf7a00, 0xc0cf8cff, REGISTRY_ARIN       }, // 192.207.122.0   - 192.207.140.255
	{ 0xc0cf8d00, 0xc0cf8eff, REGISTRY_RIPENCC    }, // 192.207.141.0   - 192.207.142.255
	{ 0xc0cf8f00, 0xc0cf8fff, REGISTRY_APNIC      }, // 192.207.143.0   - 192.207.143.255
	{ 0xc0cf9000, 0xc0cf91ff, REGISTRY_ARIN       }, // 192.207.144.0   - 192.207.145.255
	{ 0xc0cf9200, 0xc0cf92ff, REGISTRY_LACNIC     }, // 192.207.146.0   - 192.207.146.255
	{ 0xc0cf9300, 0xc0cf96ff, REGISTRY_ARIN       }, // 192.207.147.0   - 192.207.150.255
	{ 0xc0cf9700, 0xc0cf99ff, REGISTRY_APNIC      }, // 192.207.151.0   - 192.207.153.255
	{ 0xc0cf9c00, 0xc0cf9eff, REGISTRY_APNIC      }, // 192.207.156.0   - 192.207.158.255
	{ 0xc0cf9f00, 0xc0cfa0ff, REGISTRY_ARIN       }, // 192.207.159.0   - 192.207.160.255
	{ 0xc0cfa100, 0xc0cfa1ff, REGISTRY_APNIC      }, // 192.207.161.0   - 192.207.161.255
	{ 0xc0cfa200, 0xc0cfa4ff, REGISTRY_ARIN       }, // 192.207.162.0   - 192.207.164.255
	{ 0xc0cfa500, 0xc0cfa5ff, REGISTRY_APNIC      }, // 192.207.165.0   - 192.207.165.255
	{ 0xc0cfa600, 0xc0cfb6ff, REGISTRY_ARIN       }, // 192.207.166.0   - 192.207.182.255
	{ 0xc0cfb700, 0xc0cfb7ff, REGISTRY_LACNIC     }, // 192.207.183.0   - 192.207.183.255
	{ 0xc0cfb800, 0xc0cfbaff, REGISTRY_ARIN       }, // 192.207.184.0   - 192.207.186.255
	{ 0xc0cfbb00, 0xc0cfbbff, REGISTRY_APNIC      }, // 192.207.187.0   - 192.207.187.255
	{ 0xc0cfbc00, 0xc0cfc1ff, REGISTRY_ARIN       }, // 192.207.188.0   - 192.207.193.255
	{ 0xc0cfc200, 0xc0cfc3ff, REGISTRY_LACNIC     }, // 192.207.194.0   - 192.207.195.255
	{ 0xc0cfc400, 0xc0cfc4ff, REGISTRY_RIPENCC    }, // 192.207.196.0   - 192.207.196.255
	{ 0xc0cfc500, 0xc0cfc6ff, REGISTRY_APNIC      }, // 192.207.197.0   - 192.207.198.255
	{ 0xc0cfc700, 0xc0cfc7ff, REGISTRY_ARIN       }, // 192.207.199.0   - 192.207.199.255
	{ 0xc0cfc800, 0xc0cfceff, REGISTRY_LACNIC     }, // 192.207.200.0   - 192.207.206.255
	{ 0xc0cfcf00, 0xc0cff1ff, REGISTRY_ARIN       }, // 192.207.207.0   - 192.207.241.255
	{ 0xc0cff200, 0xc0cff2ff, REGISTRY_APNIC      }, // 192.207.242.0   - 192.207.242.255
	{ 0xc0cff300, 0xc0cff3ff, REGISTRY_ARIN       }, // 192.207.243.0   - 192.207.243.255
	{ 0xc0cff400, 0xc0cff4ff, REGISTRY_LACNIC     }, // 192.207.244.0   - 192.207.244.255
	{ 0xc0cff500, 0xc0cff7ff, REGISTRY_ARIN       }, // 192.207.245.0   - 192.207.247.255
	{ 0xc0cff800, 0xc0cff8ff, REGISTRY_APNIC      }, // 192.207.248.0   - 192.207.248.255
	{ 0xc0cff900, 0xc0cffdff, REGISTRY_ARIN       }, // 192.207.249.0   - 192.207.253.255
	{ 0xc0cfff00, 0xc0d9ffff, REGISTRY_ARIN       }, // 192.207.255.0   - 192.217.255.255
	{ 0xc0da0000, 0xc0daffff, REGISTRY_APNIC      }, // 192.218.0.0     - 192.218.255.255
	{ 0xc0db0000, 0xc0df3fff, REGISTRY_ARIN       }, // 192.219.0.0     - 192.223.63.255
	{ 0xc0df4000, 0xc0df7fff, REGISTRY_LACNIC     }, // 192.223.64.0    - 192.223.127.255
	{ 0xc0df8000, 0xc0e300ff, REGISTRY_ARIN       }, // 192.223.128.0   - 192.227.0.255
	{ 0xc0e30100, 0xc0e30fff, REGISTRY_APNIC      }, // 192.227.1.0     - 192.227.15.255
	{ 0xc0e31000, 0xc0e47fff, REGISTRY_ARIN       }, // 192.227.16.0    - 192.228.127.255
	{ 0xc0e48000, 0xc0e4ffff, REGISTRY_APNIC      }, // 192.228.128.0   - 192.228.255.255
	{ 0xc0e50000, 0xc0e60fff, REGISTRY_ARIN       }, // 192.229.0.0     - 192.230.15.255
	{ 0xc0e62000, 0xc0e70eff, REGISTRY_ARIN       }, // 192.230.32.0    - 192.231.14.255
	{ 0xc0e70f00, 0xc0e70fff, REGISTRY_APNIC      }, // 192.231.15.0    - 192.231.15.255
	{ 0xc0e71000, 0xc0e721ff, REGISTRY_ARIN       }, // 192.231.16.0    - 192.231.33.255
	{ 0xc0e72200, 0xc0e722ff, REGISTRY_APNIC      }, // 192.231.34.0    - 192.231.34.255
	{ 0xc0e72300, 0xc0e73aff, REGISTRY_ARIN       }, // 192.231.35.0    - 192.231.58.255
	{ 0xc0e73b00, 0xc0e73bff, REGISTRY_APNIC      }, // 192.231.59.0    - 192.231.59.255
	{ 0xc0e73c00, 0xc0e742ff, REGISTRY_ARIN       }, // 192.231.60.0    - 192.231.66.255
	{ 0xc0e74300, 0xc0e743ff, REGISTRY_RIPENCC    }, // 192.231.67.0    - 192.231.67.255
	{ 0xc0e74400, 0xc0e74cff, REGISTRY_ARIN       }, // 192.231.68.0    - 192.231.76.255
	{ 0xc0e74e00, 0xc0e751ff, REGISTRY_ARIN       }, // 192.231.78.0    - 192.231.81.255
	{ 0xc0e75200, 0xc0e752ff, REGISTRY_RIPENCC    }, // 192.231.82.0    - 192.231.82.255
	{ 0xc0e75300, 0xc0e76dff, REGISTRY_ARIN       }, // 192.231.83.0    - 192.231.109.255
	{ 0xc0e76e00, 0xc0e76eff, REGISTRY_LACNIC     }, // 192.231.110.0   - 192.231.110.255
	{ 0xc0e76f00, 0xc0e771ff, REGISTRY_ARIN       }, // 192.231.111.0   - 192.231.113.255
	{ 0xc0e77200, 0xc0e779ff, REGISTRY_LACNIC     }, // 192.231.114.0   - 192.231.121.255
	{ 0xc0e77a00, 0xc0e77eff, REGISTRY_ARIN       }, // 192.231.122.0   - 192.231.126.255
	{ 0xc0e77f00, 0xc0e77fff, REGISTRY_APNIC      }, // 192.231.127.0   - 192.231.127.255
	{ 0xc0e78000, 0xc0e786ff, REGISTRY_ARIN       }, // 192.231.128.0   - 192.231.134.255
	{ 0xc0e78700, 0xc0e788ff, REGISTRY_APNIC      }, // 192.231.135.0   - 192.231.136.255
	{ 0xc0e78a00, 0xc0e78bff, REGISTRY_ARIN       }, // 192.231.138.0   - 192.231.139.255
	{ 0xc0e78c00, 0xc0e78cff, REGISTRY_LACNIC     }, // 192.231.140.0   - 192.231.140.255
	{ 0xc0e78d00, 0xc0e78fff, REGISTRY_ARIN       }, // 192.231.141.0   - 192.231.143.255
	{ 0xc0e79100, 0xc0e7a5ff, REGISTRY_ARIN       }, // 192.231.145.0   - 192.231.165.255
	{ 0xc0e7a600, 0xc0e7aaff, REGISTRY_APNIC      }, // 192.231.166.0   - 192.231.170.255
	{ 0xc0e7ab00, 0xc0e7aeff, REGISTRY_ARIN       }, // 192.231.171.0   - 192.231.174.255
	{ 0xc0e7af00, 0xc0e7b0ff, REGISTRY_LACNIC     }, // 192.231.175.0   - 192.231.176.255
	{ 0xc0e7b100, 0xc0e7b6ff, REGISTRY_ARIN       }, // 192.231.177.0   - 192.231.182.255
	{ 0xc0e7b800, 0xc0e7c0ff, REGISTRY_ARIN       }, // 192.231.184.0   - 192.231.192.255
	{ 0xc0e7c100, 0xc0e7c1ff, REGISTRY_APNIC      }, // 192.231.193.0   - 192.231.193.255
	{ 0xc0e7c200, 0xc0e7caff, REGISTRY_ARIN       }, // 192.231.194.0   - 192.231.202.255
	{ 0xc0e7cb00, 0xc0e7cbff, REGISTRY_APNIC      }, // 192.231.203.0   - 192.231.203.255
	{ 0xc0e7cc00, 0xc0e7d2ff, REGISTRY_ARIN       }, // 192.231.204.0   - 192.231.210.255
	{ 0xc0e7d400, 0xc0e7d4ff, REGISTRY_APNIC      }, // 192.231.212.0   - 192.231.212.255
	{ 0xc0e7d500, 0xc0e7d7ff, REGISTRY_ARIN       }, // 192.231.213.0   - 192.231.215.255
	{ 0xc0e7d900, 0xc0e7d9ff, REGISTRY_ARIN       }, // 192.231.217.0   - 192.231.217.255
	{ 0xc0e7db00, 0xc0e7ecff, REGISTRY_ARIN       }, // 192.231.219.0   - 192.231.236.255
	{ 0xc0e7ee00, 0xc0e7f7ff, REGISTRY_ARIN       }, // 192.231.238.0   - 192.231.247.255
	{ 0xc0e7f900, 0xc0e7fdff, REGISTRY_ARIN       }, // 192.231.249.0   - 192.231.253.255
	{ 0xc0e7fe00, 0xc0e7feff, REGISTRY_AFRINIC    }, // 192.231.254.0   - 192.231.254.255
	{ 0xc0e7ff00, 0xc0e81fff, REGISTRY_ARIN       }, // 192.231.255.0   - 192.232.31.255
	{ 0xc0e84000, 0xc0e87fff, REGISTRY_ARIN       }, // 192.232.64.0    - 192.232.127.255
	{ 0xc0e88000, 0xc0e89fff, REGISTRY_APNIC      }, // 192.232.128.0   - 192.232.159.255
	{ 0xc0e8a000, 0xc0ea39ff, REGISTRY_ARIN       }, // 192.232.160.0   - 192.234.57.255
	{ 0xc0ea3b00, 0xc0eae6ff, REGISTRY_ARIN       }, // 192.234.59.0    - 192.234.230.255
	{ 0xc0eae800, 0xc0eaf4ff, REGISTRY_ARIN       }, // 192.234.232.0   - 192.234.244.255
	{ 0xc0eaf500, 0xc0eaf5ff, REGISTRY_APNIC      }, // 192.234.245.0   - 192.234.245.255
	{ 0xc0eaf600, 0xc0ee00ff, REGISTRY_ARIN       }, // 192.234.246.0   - 192.238.0.255
	{ 0xc0ee0100, 0xc0ee0aff, REGISTRY_RIPENCC    }, // 192.238.1.0     - 192.238.10.255
	{ 0xc0ee0b00, 0xc0f00fff, REGISTRY_ARIN       }, // 192.238.11.0    - 192.240.15.255
	{ 0xc0f01000, 0xc0f01fff, REGISTRY_APNIC      }, // 192.240.16.0    - 192.240.31.255
	{ 0xc0f02000, 0xc0f3ffff, REGISTRY_ARIN       }, // 192.240.32.0    - 192.243.255.255
	{ 0xc0f40000, 0xc0f4ffff, REGISTRY_APNIC      }, // 192.244.0.0     - 192.244.255.255
	{ 0xc0f50000, 0xc0f50aff, REGISTRY_ARIN       }, // 192.245.0.0     - 192.245.10.255
	{ 0xc0f50c00, 0xc0f50cff, REGISTRY_ARIN       }, // 192.245.12.0    - 192.245.12.255
	{ 0xc0f50d00, 0xc0f50eff, REGISTRY_APNIC      }, // 192.245.13.0    - 192.245.14.255
	{ 0xc0f50f00, 0xc0f51dff, REGISTRY_ARIN       }, // 192.245.15.0    - 192.245.29.255
	{ 0xc0f51f00, 0xc0f521ff, REGISTRY_ARIN       }, // 192.245.31.0    - 192.245.33.255
	{ 0xc0f52400, 0xc0f524ff, REGISTRY_APNIC      }, // 192.245.36.0    - 192.245.36.255
	{ 0xc0f52500, 0xc0f539ff, REGISTRY_ARIN       }, // 192.245.37.0    - 192.245.57.255
	{ 0xc0f53a00, 0xc0f53bff, REGISTRY_APNIC      }, // 192.245.58.0    - 192.245.59.255
	{ 0xc0f53c00, 0xc0f53cff, REGISTRY_LACNIC     }, // 192.245.60.0    - 192.245.60.255
	{ 0xc0f53d00, 0xc0f548ff, REGISTRY_ARIN       }, // 192.245.61.0    - 192.245.72.255
	{ 0xc0f55100, 0xc0f55dff, REGISTRY_ARIN       }, // 192.245.81.0    - 192.245.93.255
	{ 0xc0f55f00, 0xc0f568ff, REGISTRY_ARIN       }, // 192.245.95.0    - 192.245.104.255
	{ 0xc0f56900, 0xc0f570ff, REGISTRY_APNIC      }, // 192.245.105.0   - 192.245.112.255
	{ 0xc0f57100, 0xc0f578ff, REGISTRY_ARIN       }, // 192.245.113.0   - 192.245.120.255
	{ 0xc0f57900, 0xc0f579ff, REGISTRY_LACNIC     }, // 192.245.121.0   - 192.245.121.255
	{ 0xc0f57a00, 0xc0f593ff, REGISTRY_ARIN       }, // 192.245.122.0   - 192.245.147.255
	{ 0xc0f59400, 0xc0f594ff, REGISTRY_AFRINIC    }, // 192.245.148.0   - 192.245.148.255
	{ 0xc0f59500, 0xc0f597ff, REGISTRY_ARIN       }, // 192.245.149.0   - 192.245.151.255
	{ 0xc0f59800, 0xc0f598ff, REGISTRY_RIPENCC    }, // 192.245.152.0   - 192.245.152.255
	{ 0xc0f59900, 0xc0f59aff, REGISTRY_ARIN       }, // 192.245.153.0   - 192.245.154.255
	{ 0xc0f59c00, 0xc0f5a1ff, REGISTRY_ARIN       }, // 192.245.156.0   - 192.245.161.255
	{ 0xc0f5a200, 0xc0f5a2ff, REGISTRY_APNIC      }, // 192.245.162.0   - 192.245.162.255
	{ 0xc0f5a300, 0xc0f5a8ff, REGISTRY_ARIN       }, // 192.245.163.0   - 192.245.168.255
	{ 0xc0f5a900, 0xc0f5a9ff, REGISTRY_RIPENCC    }, // 192.245.169.0   - 192.245.169.255
	{ 0xc0f5aa00, 0xc0f5b8ff, REGISTRY_ARIN       }, // 192.245.170.0   - 192.245.184.255
	{ 0xc0f5b900, 0xc0f5b9ff, REGISTRY_APNIC      }, // 192.245.185.0   - 192.245.185.255
	{ 0xc0f5ba00, 0xc0f5bfff, REGISTRY_ARIN       }, // 192.245.186.0   - 192.245.191.255
	{ 0xc0f5c000, 0xc0f5c0ff, REGISTRY_APNIC      }, // 192.245.192.0   - 192.245.192.255
	{ 0xc0f5c100, 0xc0f5c3ff, REGISTRY_ARIN       }, // 192.245.193.0   - 192.245.195.255
	{ 0xc0f5c400, 0xc0f5c4ff, REGISTRY_APNIC      }, // 192.245.196.0   - 192.245.196.255
	{ 0xc0f5c500, 0xc0f5cfff, REGISTRY_ARIN       }, // 192.245.197.0   - 192.245.207.255
	{ 0xc0f5d000, 0xc0f5d0ff, REGISTRY_APNIC      }, // 192.245.208.0   - 192.245.208.255
	{ 0xc0f5d100, 0xc0f5d1ff, REGISTRY_ARIN       }, // 192.245.209.0   - 192.245.209.255
	{ 0xc0f5d200, 0xc0f5d9ff, REGISTRY_APNIC      }, // 192.245.210.0   - 192.245.217.255
	{ 0xc0f5da00, 0xc0f5daff, REGISTRY_ARIN       }, // 192.245.218.0   - 192.245.218.255
	{ 0xc0f5dd00, 0xc0f5e0ff, REGISTRY_ARIN       }, // 192.245.221.0   - 192.245.224.255
	{ 0xc0f5e100, 0xc0f5e1ff, REGISTRY_RIPENCC    }, // 192.245.225.0   - 192.245.225.255
	{ 0xc0f5e200, 0xc0f5f8ff, REGISTRY_ARIN       }, // 192.245.226.0   - 192.245.248.255
	{ 0xc0f5f900, 0xc0f5fbff, REGISTRY_APNIC      }, // 192.245.249.0   - 192.245.251.255
	{ 0xc0f5fc00, 0xc0f700ff, REGISTRY_ARIN       }, // 192.245.252.0   - 192.247.0.255
	{ 0xc0f70100, 0xc0f70aff, REGISTRY_RIPENCC    }, // 192.247.1.0     - 192.247.10.255
	{ 0xc0f70b00, 0xc0f7ffff, REGISTRY_ARIN       }, // 192.247.11.0    - 192.247.255.255
	{ 0xc0f80000, 0xc0f87fff, REGISTRY_APNIC      }, // 192.248.0.0     - 192.248.127.255
	{ 0xc0f88000, 0xc0f90fff, REGISTRY_ARIN       }, // 192.248.128.0   - 192.249.15.255
	{ 0xc0f91000, 0xc0f91fff, REGISTRY_APNIC      }, // 192.249.16.0    - 192.249.31.255
	{ 0xc0f92000, 0xc0f929ff, REGISTRY_ARIN       }, // 192.249.32.0    - 192.249.41.255
	{ 0xc0f92a00, 0xc0f92bff, REGISTRY_APNIC      }, // 192.249.42.0    - 192.249.43.255
	{ 0xc0f92c00, 0xc0fb26ff, REGISTRY_ARIN       }, // 192.249.44.0    - 192.251.38.255
	{ 0xc0fb2700, 0xc0fb27ff, REGISTRY_LACNIC     }, // 192.251.39.0    - 192.251.39.255
	{ 0xc0fb2800, 0xc0fb3cff, REGISTRY_ARIN       }, // 192.251.40.0    - 192.251.60.255
	{ 0xc0fb3d00, 0xc0fb41ff, REGISTRY_RIPENCC    }, // 192.251.61.0    - 192.251.65.255
	{ 0xc0fb4200, 0xc0fb93ff, REGISTRY_ARIN       }, // 192.251.66.0    - 192.251.147.255
	{ 0xc0fb9400, 0xc0fb94ff, REGISTRY_APNIC      }, // 192.251.148.0   - 192.251.148.255
	{ 0xc0fb9500, 0xc0fbc2ff, REGISTRY_ARIN       }, // 192.251.149.0   - 192.251.194.255
	{ 0xc0fbc300, 0xc0fbc3ff, REGISTRY_APNIC      }, // 192.251.195.0   - 192.251.195.255
	{ 0xc0fbc400, 0xc0fbc8ff, REGISTRY_ARIN       }, // 192.251.196.0   - 192.251.200.255
	{ 0xc0fbca00, 0xc0fbcaff, REGISTRY_AFRINIC    }, // 192.251.202.0   - 192.251.202.255
	{ 0xc0fbcb00, 0xc0fbcbff, REGISTRY_ARIN       }, // 192.251.203.0   - 192.251.203.255
	{ 0xc0fbcd00, 0xc0fbcfff, REGISTRY_APNIC      }, // 192.251.205.0   - 192.251.207.255
	{ 0xc0fbd000, 0xc0fbe1ff, REGISTRY_ARIN       }, // 192.251.208.0   - 192.251.225.255
	{ 0xc0fbe200, 0xc0fbe2ff, REGISTRY_RIPENCC    }, // 192.251.226.0   - 192.251.226.255
	{ 0xc0fbe700, 0xc0ffffff, REGISTRY_ARIN       }, // 192.251.231.0   - 192.255.255.255
	{ 0xc1000000, 0xc1001fff, REGISTRY_RIPENCC    }, // 193.0.0.0       - 193.0.31.255
	{ 0xc1002000, 0xc10080ff, REGISTRY_RIPENCC    }, // 193.0.32.0      - 193.0.128.255
	{ 0xc1008200, 0xc10091ff, REGISTRY_RIPENCC    }, // 193.0.130.0     - 193.0.145.255
	{ 0xc1009400, 0xc100a3ff, REGISTRY_RIPENCC    }, // 193.0.148.0     - 193.0.163.255
	{ 0xc100a600, 0xc100afff, REGISTRY_RIPENCC    }, // 193.0.166.0     - 193.0.175.255
	{ 0xc100b000, 0xc100b1ff, REGISTRY_RIPENCC    }, // 193.0.176.0     - 193.0.177.255
	{ 0xc100b200, 0xc100b7ff, REGISTRY_RIPENCC    }, // 193.0.178.0     - 193.0.183.255
	{ 0xc100b900, 0xc100bcff, REGISTRY_RIPENCC    }, // 193.0.185.0     - 193.0.188.255
	{ 0xc100bd00, 0xc100beff, REGISTRY_RIPENCC    }, // 193.0.189.0     - 193.0.190.255
	{ 0xc100bf00, 0xc100c7ff, REGISTRY_RIPENCC    }, // 193.0.191.0     - 193.0.199.255
	{ 0xc100c800, 0xc100cbff, REGISTRY_RIPENCC    }, // 193.0.200.0     - 193.0.203.255
	{ 0xc100cc00, 0xc100d3ff, REGISTRY_RIPENCC    }, // 193.0.204.0     - 193.0.211.255
	{ 0xc100d500, 0xc100e2ff, REGISTRY_RIPENCC    }, // 193.0.213.0     - 193.0.226.255
	{ 0xc100e400, 0xc100e4ff, REGISTRY_RIPENCC    }, // 193.0.228.0     - 193.0.228.255
	{ 0xc100e700, 0xc100e9ff, REGISTRY_RIPENCC    }, // 193.0.231.0     - 193.0.233.255
	{ 0xc100ec00, 0xc100eeff, REGISTRY_RIPENCC    }, // 193.0.236.0     - 193.0.238.255
	{ 0xc100f000, 0xc100f4ff, REGISTRY_RIPENCC    }, // 193.0.240.0     - 193.0.244.255
	{ 0xc100f600, 0xc100ffff, REGISTRY_RIPENCC    }, // 193.0.246.0     - 193.0.255.255
	{ 0xc1010000, 0xc10439ff, REGISTRY_RIPENCC    }, // 193.1.0.0       - 193.4.57.255
	{ 0xc1043a00, 0xc1043bff, REGISTRY_RIPENCC    }, // 193.4.58.0      - 193.4.59.255
	{ 0xc1043c00, 0xc10500ff, REGISTRY_RIPENCC    }, // 193.4.60.0      - 193.5.0.255
	{ 0xc1050200, 0xc10502ff, REGISTRY_RIPENCC    }, // 193.5.2.0       - 193.5.2.255
	{ 0xc1050300, 0xc10507ff, REGISTRY_RIPENCC    }, // 193.5.3.0       - 193.5.7.255
	{ 0xc1050800, 0xc10509ff, REGISTRY_RIPENCC    }, // 193.5.8.0       - 193.5.9.255
	{ 0xc1050c00, 0xc10515ff, REGISTRY_RIPENCC    }, // 193.5.12.0      - 193.5.21.255
	{ 0xc1051600, 0xc10516ff, REGISTRY_RIPENCC    }, // 193.5.22.0      - 193.5.22.255
	{ 0xc1051700, 0xc10517ff, REGISTRY_RIPENCC    }, // 193.5.23.0      - 193.5.23.255
	{ 0xc1051a00, 0xc1051bff, REGISTRY_RIPENCC    }, // 193.5.26.0      - 193.5.27.255
	{ 0xc1051d00, 0xc1051eff, REGISTRY_RIPENCC    }, // 193.5.29.0      - 193.5.30.255
	{ 0xc1052000, 0xc10526ff, REGISTRY_RIPENCC    }, // 193.5.32.0      - 193.5.38.255
	{ 0xc1052800, 0xc10528ff, REGISTRY_RIPENCC    }, // 193.5.40.0      - 193.5.40.255
	{ 0xc1052a00, 0xc1052dff, REGISTRY_RIPENCC    }, // 193.5.42.0      - 193.5.45.255
	{ 0xc1053000, 0xc10533ff, REGISTRY_RIPENCC    }, // 193.5.48.0      - 193.5.51.255
	{ 0xc1053400, 0xc10534ff, REGISTRY_RIPENCC    }, // 193.5.52.0      - 193.5.52.255
	{ 0xc1053500, 0xc1053aff, REGISTRY_RIPENCC    }, // 193.5.53.0      - 193.5.58.255
	{ 0xc1053b00, 0xc1053bff, REGISTRY_RIPENCC    }, // 193.5.59.0      - 193.5.59.255
	{ 0xc1053c00, 0xc1053cff, REGISTRY_RIPENCC    }, // 193.5.60.0      - 193.5.60.255
	{ 0xc1053d00, 0xc1053dff, REGISTRY_RIPENCC    }, // 193.5.61.0      - 193.5.61.255
	{ 0xc1053e00, 0xc1053eff, REGISTRY_RIPENCC    }, // 193.5.62.0      - 193.5.62.255
	{ 0xc1053f00, 0xc1053fff, REGISTRY_RIPENCC    }, // 193.5.63.0      - 193.5.63.255
	{ 0xc1054200, 0xc10543ff, REGISTRY_RIPENCC    }, // 193.5.66.0      - 193.5.67.255
	{ 0xc1054400, 0xc10545ff, REGISTRY_RIPENCC    }, // 193.5.68.0      - 193.5.69.255
	{ 0xc1054600, 0xc1054fff, REGISTRY_RIPENCC    }, // 193.5.70.0      - 193.5.79.255
	{ 0xc1055000, 0xc1056fff, REGISTRY_RIPENCC    }, // 193.5.80.0      - 193.5.111.255
	{ 0xc1057000, 0xc10573ff, REGISTRY_RIPENCC    }, // 193.5.112.0     - 193.5.115.255
	{ 0xc1057400, 0xc10577ff, REGISTRY_RIPENCC    }, // 193.5.116.0     - 193.5.119.255
	{ 0xc1057900, 0xc10579ff, REGISTRY_RIPENCC    }, // 193.5.121.0     - 193.5.121.255
	{ 0xc1057a00, 0xc1057aff, REGISTRY_RIPENCC    }, // 193.5.122.0     - 193.5.122.255
	{ 0xc1057b00, 0xc1059bff, REGISTRY_RIPENCC    }, // 193.5.123.0     - 193.5.155.255
	{ 0xc1059c00, 0xc105a7ff, REGISTRY_RIPENCC    }, // 193.5.156.0     - 193.5.167.255
	{ 0xc105a800, 0xc105b2ff, REGISTRY_RIPENCC    }, // 193.5.168.0     - 193.5.178.255
	{ 0xc105b300, 0xc105b3ff, REGISTRY_RIPENCC    }, // 193.5.179.0     - 193.5.179.255
	{ 0xc105b400, 0xc105dfff, REGISTRY_RIPENCC    }, // 193.5.180.0     - 193.5.223.255
	{ 0xc105e000, 0xc105efff, REGISTRY_RIPENCC    }, // 193.5.224.0     - 193.5.239.255
	{ 0xc105f000, 0xc105f9ff, REGISTRY_RIPENCC    }, // 193.5.240.0     - 193.5.249.255
	{ 0xc105fc00, 0xc105fcff, REGISTRY_RIPENCC    }, // 193.5.252.0     - 193.5.252.255
	{ 0xc105fd00, 0xc105feff, REGISTRY_RIPENCC    }, // 193.5.253.0     - 193.5.254.255
	{ 0xc1060000, 0xc106ffff, REGISTRY_RIPENCC    }, // 193.6.0.0       - 193.6.255.255
	{ 0xc1070000, 0xc1077fff, REGISTRY_RIPENCC    }, // 193.7.0.0       - 193.7.127.255
	{ 0xc1078000, 0xc1079fff, REGISTRY_RIPENCC    }, // 193.7.128.0     - 193.7.159.255
	{ 0xc107a000, 0xc107bfff, REGISTRY_RIPENCC    }, // 193.7.160.0     - 193.7.191.255
	{ 0xc107c000, 0xc107dfff, REGISTRY_RIPENCC    }, // 193.7.192.0     - 193.7.223.255
	{ 0xc107e000, 0xc10800ff, REGISTRY_RIPENCC    }, // 193.7.224.0     - 193.8.0.255
	{ 0xc1080400, 0xc10807ff, REGISTRY_RIPENCC    }, // 193.8.4.0       - 193.8.7.255
	{ 0xc1080900, 0xc1080bff, REGISTRY_RIPENCC    }, // 193.8.9.0       - 193.8.11.255
	{ 0xc1080c00, 0xc1080fff, REGISTRY_RIPENCC    }, // 193.8.12.0      - 193.8.15.255
	{ 0xc1081000, 0xc10835ff, REGISTRY_RIPENCC    }, // 193.8.16.0      - 193.8.53.255
	{ 0xc1083900, 0xc1083dff, REGISTRY_RIPENCC    }, // 193.8.57.0      - 193.8.61.255
	{ 0xc1084000, 0xc10843ff, REGISTRY_RIPENCC    }, // 193.8.64.0      - 193.8.67.255
	{ 0xc1084400, 0xc10847ff, REGISTRY_RIPENCC    }, // 193.8.68.0      - 193.8.71.255
	{ 0xc1084a00, 0xc1084fff, REGISTRY_RIPENCC    }, // 193.8.74.0      - 193.8.79.255
	{ 0xc1085000, 0xc10853ff, REGISTRY_RIPENCC    }, // 193.8.80.0      - 193.8.83.255
	{ 0xc1085600, 0xc1085bff, REGISTRY_RIPENCC    }, // 193.8.86.0      - 193.8.91.255
	{ 0xc1085f00, 0xc1086fff, REGISTRY_RIPENCC    }, // 193.8.95.0      - 193.8.111.255
	{ 0xc1087000, 0xc1087bff, REGISTRY_RIPENCC    }, // 193.8.112.0     - 193.8.123.255
	{ 0xc1087e00, 0xc1087eff, REGISTRY_RIPENCC    }, // 193.8.126.0     - 193.8.126.255
	{ 0xc1088000, 0xc10889ff, REGISTRY_RIPENCC    }, // 193.8.128.0     - 193.8.137.255
	{ 0xc1088b00, 0xc108a3ff, REGISTRY_RIPENCC    }, // 193.8.139.0     - 193.8.163.255
	{ 0xc108a500, 0xc108a6ff, REGISTRY_RIPENCC    }, // 193.8.165.0     - 193.8.166.255
	{ 0xc108aa00, 0xc108aaff, REGISTRY_RIPENCC    }, // 193.8.170.0     - 193.8.170.255
	{ 0xc108ae00, 0xc108aeff, REGISTRY_RIPENCC    }, // 193.8.174.0     - 193.8.174.255
	{ 0xc108b000, 0xc108b7ff, REGISTRY_RIPENCC    }, // 193.8.176.0     - 193.8.183.255
	{ 0xc108b800, 0xc108bbff, REGISTRY_RIPENCC    }, // 193.8.184.0     - 193.8.187.255
	{ 0xc108bc00, 0xc108bdff, REGISTRY_RIPENCC    }, // 193.8.188.0     - 193.8.189.255
	{ 0xc108be00, 0xc108bfff, REGISTRY_RIPENCC    }, // 193.8.190.0     - 193.8.191.255
	{ 0xc108c100, 0xc108c1ff, REGISTRY_RIPENCC    }, // 193.8.193.0     - 193.8.193.255
	{ 0xc108c400, 0xc108c9ff, REGISTRY_RIPENCC    }, // 193.8.196.0     - 193.8.201.255
	{ 0xc108cb00, 0xc108ccff, REGISTRY_RIPENCC    }, // 193.8.203.0     - 193.8.204.255
	{ 0xc108d000, 0xc108d3ff, REGISTRY_RIPENCC    }, // 193.8.208.0     - 193.8.211.255
	{ 0xc108d500, 0xc108d6ff, REGISTRY_RIPENCC    }, // 193.8.213.0     - 193.8.214.255
	{ 0xc108d800, 0xc108dbff, REGISTRY_RIPENCC    }, // 193.8.216.0     - 193.8.219.255
	{ 0xc108de00, 0xc108dfff, REGISTRY_RIPENCC    }, // 193.8.222.0     - 193.8.223.255
	{ 0xc108e000, 0xc108e3ff, REGISTRY_RIPENCC    }, // 193.8.224.0     - 193.8.227.255
	{ 0xc108e600, 0xc108e6ff, REGISTRY_RIPENCC    }, // 193.8.230.0     - 193.8.230.255
	{ 0xc108eb00, 0xc108ebff, REGISTRY_RIPENCC    }, // 193.8.235.0     - 193.8.235.255
	{ 0xc108ef00, 0xc108efff, REGISTRY_RIPENCC    }, // 193.8.239.0     - 193.8.239.255
	{ 0xc108f000, 0xc108f3ff, REGISTRY_RIPENCC    }, // 193.8.240.0     - 193.8.243.255
	{ 0xc108f500, 0xc108f6ff, REGISTRY_RIPENCC    }, // 193.8.245.0     - 193.8.246.255
	{ 0xc108f800, 0xc108f8ff, REGISTRY_RIPENCC    }, // 193.8.248.0     - 193.8.248.255
	{ 0xc108fa00, 0xc108feff, REGISTRY_RIPENCC    }, // 193.8.250.0     - 193.8.254.255
	{ 0xc1090000, 0xc1090eff, REGISTRY_RIPENCC    }, // 193.9.0.0       - 193.9.14.255
	{ 0xc1091000, 0xc10911ff, REGISTRY_RIPENCC    }, // 193.9.16.0      - 193.9.17.255
	{ 0xc1091200, 0xc10912ff, REGISTRY_RIPENCC    }, // 193.9.18.0      - 193.9.18.255
	{ 0xc1091300, 0xc1091cff, REGISTRY_RIPENCC    }, // 193.9.19.0      - 193.9.28.255
	{ 0xc1092000, 0xc1093fff, REGISTRY_RIPENCC    }, // 193.9.32.0      - 193.9.63.255
	{ 0xc1094000, 0xc1096fff, REGISTRY_RIPENCC    }, // 193.9.64.0      - 193.9.111.255
	{ 0xc1097000, 0xc10977ff, REGISTRY_RIPENCC    }, // 193.9.112.0     - 193.9.119.255
	{ 0xc1097800, 0xc10997ff, REGISTRY_RIPENCC    }, // 193.9.120.0     - 193.9.151.255
	{ 0xc1099800, 0xc1099bff, REGISTRY_RIPENCC    }, // 193.9.152.0     - 193.9.155.255
	{ 0xc1099e00, 0xc1099eff, REGISTRY_RIPENCC    }, // 193.9.158.0     - 193.9.158.255
	{ 0xc1099f00, 0xc109feff, REGISTRY_RIPENCC    }, // 193.9.159.0     - 193.9.254.255
	{ 0xc10a0000, 0xc10fffff, REGISTRY_RIPENCC    }, // 193.10.0.0      - 193.15.255.255
	{ 0xc1100100, 0xc11001ff, REGISTRY_RIPENCC    }, // 193.16.1.0      - 193.16.1.255
	{ 0xc1100300, 0xc11007ff, REGISTRY_RIPENCC    }, // 193.16.3.0      - 193.16.7.255
	{ 0xc1100800, 0xc1100fff, REGISTRY_RIPENCC    }, // 193.16.8.0      - 193.16.15.255
	{ 0xc1101000, 0xc1101fff, REGISTRY_RIPENCC    }, // 193.16.16.0     - 193.16.31.255
	{ 0xc1102400, 0xc11027ff, REGISTRY_RIPENCC    }, // 193.16.36.0     - 193.16.39.255
	{ 0xc1102b00, 0xc11069ff, REGISTRY_RIPENCC    }, // 193.16.43.0     - 193.16.105.255
	{ 0xc1106b00, 0xc1106dff, REGISTRY_RIPENCC    }, // 193.16.107.0    - 193.16.109.255
	{ 0xc1106f00, 0xc1108fff, REGISTRY_RIPENCC    }, // 193.16.111.0    - 193.16.143.255
	{ 0xc1109100, 0xc11094ff, REGISTRY_RIPENCC    }, // 193.16.145.0    - 193.16.148.255
	{ 0xc1109600, 0xc11096ff, REGISTRY_RIPENCC    }, // 193.16.150.0    - 193.16.150.255
	{ 0xc1109800, 0xc1109bff, REGISTRY_RIPENCC    }, // 193.16.152.0    - 193.16.155.255
	{ 0xc1109d00, 0xc1109fff, REGISTRY_RIPENCC    }, // 193.16.157.0    - 193.16.159.255
	{ 0xc110a000, 0xc110a7ff, REGISTRY_RIPENCC    }, // 193.16.160.0    - 193.16.167.255
	{ 0xc110a800, 0xc110d3ff, REGISTRY_RIPENCC    }, // 193.16.168.0    - 193.16.211.255
	{ 0xc110d400, 0xc110d4ff, REGISTRY_RIPENCC    }, // 193.16.212.0    - 193.16.212.255
	{ 0xc110d600, 0xc110d7ff, REGISTRY_RIPENCC    }, // 193.16.214.0    - 193.16.215.255
	{ 0xc110d800, 0xc110dcff, REGISTRY_RIPENCC    }, // 193.16.216.0    - 193.16.220.255
	{ 0xc110de00, 0xc110dfff, REGISTRY_RIPENCC    }, // 193.16.222.0    - 193.16.223.255
	{ 0xc110e000, 0xc110e3ff, REGISTRY_RIPENCC    }, // 193.16.224.0    - 193.16.227.255
	{ 0xc110e400, 0xc110e4ff, REGISTRY_RIPENCC    }, // 193.16.228.0    - 193.16.228.255
	{ 0xc110e500, 0xc110e5ff, REGISTRY_RIPENCC    }, // 193.16.229.0    - 193.16.229.255
	{ 0xc110e600, 0xc110e7ff, REGISTRY_RIPENCC    }, // 193.16.230.0    - 193.16.231.255
	{ 0xc110e800, 0xc110ebff, REGISTRY_RIPENCC    }, // 193.16.232.0    - 193.16.235.255
	{ 0xc110ed00, 0xc110eeff, REGISTRY_RIPENCC    }, // 193.16.237.0    - 193.16.238.255
	{ 0xc110f000, 0xc110f7ff, REGISTRY_RIPENCC    }, // 193.16.240.0    - 193.16.247.255
	{ 0xc110f800, 0xc110feff, REGISTRY_RIPENCC    }, // 193.16.248.0    - 193.16.254.255
	{ 0xc110ff00, 0xc11102ff, REGISTRY_RIPENCC    }, // 193.16.255.0    - 193.17.2.255
	{ 0xc1110400, 0xc11107ff, REGISTRY_RIPENCC    }, // 193.17.4.0      - 193.17.7.255
	{ 0xc1110800, 0xc1110eff, REGISTRY_RIPENCC    }, // 193.17.8.0      - 193.17.14.255
	{ 0xc1111000, 0xc11110ff, REGISTRY_RIPENCC    }, // 193.17.16.0     - 193.17.16.255
	{ 0xc1111100, 0xc11111ff, REGISTRY_RIPENCC    }, // 193.17.17.0     - 193.17.17.255
	{ 0xc1111200, 0xc11113ff, REGISTRY_RIPENCC    }, // 193.17.18.0     - 193.17.19.255
	{ 0xc1111500, 0xc11116ff, REGISTRY_RIPENCC    }, // 193.17.21.0     - 193.17.22.255
	{ 0xc1111900, 0xc11119ff, REGISTRY_RIPENCC    }, // 193.17.25.0     - 193.17.25.255
	{ 0xc1111b00, 0xc1111bff, REGISTRY_RIPENCC    }, // 193.17.27.0     - 193.17.27.255
	{ 0xc1111c00, 0xc11127ff, REGISTRY_RIPENCC    }, // 193.17.28.0     - 193.17.39.255
	{ 0xc1112900, 0xc11136ff, REGISTRY_RIPENCC    }, // 193.17.41.0     - 193.17.54.255
	{ 0xc1113800, 0xc1113bff, REGISTRY_RIPENCC    }, // 193.17.56.0     - 193.17.59.255
	{ 0xc1113c00, 0xc1113fff, REGISTRY_RIPENCC    }, // 193.17.60.0     - 193.17.63.255
	{ 0xc1114100, 0xc11145ff, REGISTRY_RIPENCC    }, // 193.17.65.0     - 193.17.69.255
	{ 0xc1114700, 0xc1114fff, REGISTRY_RIPENCC    }, // 193.17.71.0     - 193.17.79.255
	{ 0xc1115000, 0xc11153ff, REGISTRY_RIPENCC    }, // 193.17.80.0     - 193.17.83.255
	{ 0xc1115400, 0xc11155ff, REGISTRY_RIPENCC    }, // 193.17.84.0     - 193.17.85.255
	{ 0xc1115800, 0xc1117fff, REGISTRY_RIPENCC    }, // 193.17.88.0     - 193.17.127.255
	{ 0xc1118000, 0xc111afff, REGISTRY_RIPENCC    }, // 193.17.128.0    - 193.17.175.255
	{ 0xc111b200, 0xc111b2ff, REGISTRY_RIPENCC    }, // 193.17.178.0    - 193.17.178.255
	{ 0xc111b400, 0xc111b7ff, REGISTRY_RIPENCC    }, // 193.17.180.0    - 193.17.183.255
	{ 0xc111b800, 0xc111bbff, REGISTRY_RIPENCC    }, // 193.17.184.0    - 193.17.187.255
	{ 0xc111bc00, 0xc111bfff, REGISTRY_RIPENCC    }, // 193.17.188.0    - 193.17.191.255
	{ 0xc111c000, 0xc111c0ff, REGISTRY_RIPENCC    }, // 193.17.192.0    - 193.17.192.255
	{ 0xc111c200, 0xc111d6ff, REGISTRY_RIPENCC    }, // 193.17.194.0    - 193.17.214.255
	{ 0xc111d800, 0xc111d9ff, REGISTRY_RIPENCC    }, // 193.17.216.0    - 193.17.217.255
	{ 0xc111da00, 0xc111dbff, REGISTRY_RIPENCC    }, // 193.17.218.0    - 193.17.219.255
	{ 0xc111dd00, 0xc111dfff, REGISTRY_RIPENCC    }, // 193.17.221.0    - 193.17.223.255
	{ 0xc111e100, 0xc111e3ff, REGISTRY_RIPENCC    }, // 193.17.225.0    - 193.17.227.255
	{ 0xc111e500, 0xc111e6ff, REGISTRY_RIPENCC    }, // 193.17.229.0    - 193.17.230.255
	{ 0xc111e800, 0xc111fcff, REGISTRY_RIPENCC    }, // 193.17.232.0    - 193.17.252.255
	{ 0xc111fe00, 0xc111feff, REGISTRY_RIPENCC    }, // 193.17.254.0    - 193.17.254.255
	{ 0xc1120000, 0xc11347ff, REGISTRY_RIPENCC    }, // 193.18.0.0      - 193.19.71.255
	{ 0xc1134a00, 0xc1135fff, REGISTRY_RIPENCC    }, // 193.19.74.0     - 193.19.95.255
	{ 0xc1136200, 0xc11363ff, REGISTRY_RIPENCC    }, // 193.19.98.0     - 193.19.99.255
	{ 0xc1136400, 0xc11365ff, REGISTRY_RIPENCC    }, // 193.19.100.0    - 193.19.101.255
	{ 0xc1136600, 0xc11369ff, REGISTRY_RIPENCC    }, // 193.19.102.0    - 193.19.105.255
	{ 0xc1136e00, 0xc11377ff, REGISTRY_RIPENCC    }, // 193.19.110.0    - 193.19.119.255
	{ 0xc1137a00, 0xc1137fff, REGISTRY_RIPENCC    }, // 193.19.122.0    - 193.19.127.255
	{ 0xc1138000, 0xc11383ff, REGISTRY_RIPENCC    }, // 193.19.128.0    - 193.19.131.255
	{ 0xc1138400, 0xc11393ff, REGISTRY_RIPENCC    }, // 193.19.132.0    - 193.19.147.255
	{ 0xc1139400, 0xc11397ff, REGISTRY_RIPENCC    }, // 193.19.148.0    - 193.19.151.255
	{ 0xc1139800, 0xc113c7ff, REGISTRY_RIPENCC    }, // 193.19.152.0    - 193.19.199.255
	{ 0xc113c800, 0xc113cfff, REGISTRY_RIPENCC    }, // 193.19.200.0    - 193.19.207.255
	{ 0xc113d000, 0xc113dfff, REGISTRY_RIPENCC    }, // 193.19.208.0    - 193.19.223.255
	{ 0xc113e000, 0xc113e3ff, REGISTRY_RIPENCC    }, // 193.19.224.0    - 193.19.227.255
	{ 0xc113e400, 0xc113e7ff, REGISTRY_RIPENCC    }, // 193.19.228.0    - 193.19.231.255
	{ 0xc113e800, 0xc113ebff, REGISTRY_AFRINIC    }, // 193.19.232.0    - 193.19.235.255
	{ 0xc113ec00, 0xc113f7ff, REGISTRY_RIPENCC    }, // 193.19.236.0    - 193.19.247.255
	{ 0xc113f800, 0xc113fbff, REGISTRY_RIPENCC    }, // 193.19.248.0    - 193.19.251.255
	{ 0xc113fc00, 0xc11600ff, REGISTRY_RIPENCC    }, // 193.19.252.0    - 193.22.0.255
	{ 0xc1160200, 0xc11605ff, REGISTRY_RIPENCC    }, // 193.22.2.0      - 193.22.5.255
	{ 0xc1160600, 0xc11606ff, REGISTRY_RIPENCC    }, // 193.22.6.0      - 193.22.6.255
	{ 0xc1160700, 0xc1160bff, REGISTRY_RIPENCC    }, // 193.22.7.0      - 193.22.11.255
	{ 0xc1160c00, 0xc1160fff, REGISTRY_RIPENCC    }, // 193.22.12.0     - 193.22.15.255
	{ 0xc1161000, 0xc11613ff, REGISTRY_RIPENCC    }, // 193.22.16.0     - 193.22.19.255
	{ 0xc1161400, 0xc1161bff, REGISTRY_RIPENCC    }, // 193.22.20.0     - 193.22.27.255
	{ 0xc1161c00, 0xc1164fff, REGISTRY_RIPENCC    }, // 193.22.28.0     - 193.22.79.255
	{ 0xc1165100, 0xc11655ff, REGISTRY_RIPENCC    }, // 193.22.81.0     - 193.22.85.255
	{ 0xc1165700, 0xc1165fff, REGISTRY_RIPENCC    }, // 193.22.87.0     - 193.22.95.255
	{ 0xc1166000, 0xc11663ff, REGISTRY_RIPENCC    }, // 193.22.96.0     - 193.22.99.255
	{ 0xc1166400, 0xc11667ff, REGISTRY_RIPENCC    }, // 193.22.100.0    - 193.22.103.255
	{ 0xc1166b00, 0xc1166bff, REGISTRY_RIPENCC    }, // 193.22.107.0    - 193.22.107.255
	{ 0xc1166d00, 0xc1167fff, REGISTRY_RIPENCC    }, // 193.22.109.0    - 193.22.127.255
	{ 0xc1168000, 0xc1168bff, REGISTRY_RIPENCC    }, // 193.22.128.0    - 193.22.139.255
	{ 0xc1168c00, 0xc1168cff, REGISTRY_RIPENCC    }, // 193.22.140.0    - 193.22.140.255
	{ 0xc1168e00, 0xc1168fff, REGISTRY_RIPENCC    }, // 193.22.142.0    - 193.22.143.255
	{ 0xc1169000, 0xc1169fff, REGISTRY_RIPENCC    }, // 193.22.144.0    - 193.22.159.255
	{ 0xc116a000, 0xc116a7ff, REGISTRY_RIPENCC    }, // 193.22.160.0    - 193.22.167.255
	{ 0xc116a900, 0xc116a9ff, REGISTRY_RIPENCC    }, // 193.22.169.0    - 193.22.169.255
	{ 0xc116ab00, 0xc116dfff, REGISTRY_RIPENCC    }, // 193.22.171.0    - 193.22.223.255
	{ 0xc116e000, 0xc116efff, REGISTRY_RIPENCC    }, // 193.22.224.0    - 193.22.239.255
	{ 0xc116f200, 0xc116f3ff, REGISTRY_RIPENCC    }, // 193.22.242.0    - 193.22.243.255
	{ 0xc116f500, 0xc116f5ff, REGISTRY_RIPENCC    }, // 193.22.245.0    - 193.22.245.255
	{ 0xc116f800, 0xc116feff, REGISTRY_RIPENCC    }, // 193.22.248.0    - 193.22.254.255
	{ 0xc116ff00, 0xc116ffff, REGISTRY_RIPENCC    }, // 193.22.255.0    - 193.22.255.255
	{ 0xc1170200, 0xc11702ff, REGISTRY_RIPENCC    }, // 193.23.2.0      - 193.23.2.255
	{ 0xc1170400, 0xc11707ff, REGISTRY_RIPENCC    }, // 193.23.4.0      - 193.23.7.255
	{ 0xc1170800, 0xc1170fff, REGISTRY_RIPENCC    }, // 193.23.8.0      - 193.23.15.255
	{ 0xc1171000, 0xc1171fff, REGISTRY_RIPENCC    }, // 193.23.16.0     - 193.23.31.255
	{ 0xc1172000, 0xc1172dff, REGISTRY_RIPENCC    }, // 193.23.32.0     - 193.23.45.255
	{ 0xc1173000, 0xc11731ff, REGISTRY_RIPENCC    }, // 193.23.48.0     - 193.23.49.255
	{ 0xc1173300, 0xc11735ff, REGISTRY_RIPENCC    }, // 193.23.51.0     - 193.23.53.255
	{ 0xc1173600, 0xc11736ff, REGISTRY_RIPENCC    }, // 193.23.54.0     - 193.23.54.255
	{ 0xc1173800, 0xc1173bff, REGISTRY_RIPENCC    }, // 193.23.56.0     - 193.23.59.255
	{ 0xc1173d00, 0xc11771ff, REGISTRY_RIPENCC    }, // 193.23.61.0     - 193.23.113.255
	{ 0xc1177200, 0xc11772ff, REGISTRY_RIPENCC    }, // 193.23.114.0    - 193.23.114.255
	{ 0xc1177300, 0xc11775ff, REGISTRY_RIPENCC    }, // 193.23.115.0    - 193.23.117.255
	{ 0xc1177700, 0xc1177cff, REGISTRY_RIPENCC    }, // 193.23.119.0    - 193.23.124.255
	{ 0xc1178000, 0xc11783ff, REGISTRY_RIPENCC    }, // 193.23.128.0    - 193.23.131.255
	{ 0xc1178400, 0xc11784ff, REGISTRY_RIPENCC    }, // 193.23.132.0    - 193.23.132.255
	{ 0xc1178600, 0xc11786ff, REGISTRY_RIPENCC    }, // 193.23.134.0    - 193.23.134.255
	{ 0xc1178800, 0xc1178fff, REGISTRY_RIPENCC    }, // 193.23.136.0    - 193.23.143.255
	{ 0xc1179000, 0xc11793ff, REGISTRY_RIPENCC    }, // 193.23.144.0    - 193.23.147.255
	{ 0xc1179400, 0xc1179fff, REGISTRY_RIPENCC    }, // 193.23.148.0    - 193.23.159.255
	{ 0xc117a200, 0xc117a3ff, REGISTRY_RIPENCC    }, // 193.23.162.0    - 193.23.163.255
	{ 0xc117a700, 0xc117acff, REGISTRY_RIPENCC    }, // 193.23.167.0    - 193.23.172.255
	{ 0xc117ae00, 0xc117afff, REGISTRY_RIPENCC    }, // 193.23.174.0    - 193.23.175.255
	{ 0xc117b000, 0xc117b3ff, REGISTRY_RIPENCC    }, // 193.23.176.0    - 193.23.179.255
	{ 0xc117b400, 0xc117f1ff, REGISTRY_RIPENCC    }, // 193.23.180.0    - 193.23.241.255
	{ 0xc117f300, 0xc117f4ff, REGISTRY_RIPENCC    }, // 193.23.243.0    - 193.23.244.255
	{ 0xc117f800, 0xc117f8ff, REGISTRY_RIPENCC    }, // 193.23.248.0    - 193.23.248.255
	{ 0xc117fb00, 0xc117fcff, REGISTRY_RIPENCC    }, // 193.23.251.0    - 193.23.252.255
	{ 0xc117fe00, 0xc117ffff, REGISTRY_RIPENCC    }, // 193.23.254.0    - 193.23.255.255
	{ 0xc1180200, 0xc11802ff, REGISTRY_RIPENCC    }, // 193.24.2.0      - 193.24.2.255
	{ 0xc1180700, 0xc11807ff, REGISTRY_RIPENCC    }, // 193.24.7.0      - 193.24.7.255
	{ 0xc1180800, 0xc1180bff, REGISTRY_RIPENCC    }, // 193.24.8.0      - 193.24.11.255
	{ 0xc1180c00, 0xc1180cff, REGISTRY_RIPENCC    }, // 193.24.12.0     - 193.24.12.255
	{ 0xc1180e00, 0xc1181eff, REGISTRY_RIPENCC    }, // 193.24.14.0     - 193.24.30.255
	{ 0xc1182000, 0xc11823ff, REGISTRY_RIPENCC    }, // 193.24.32.0     - 193.24.35.255
	{ 0xc1182500, 0xc11825ff, REGISTRY_RIPENCC    }, // 193.24.37.0     - 193.24.37.255
	{ 0xc1182800, 0xc1182fff, REGISTRY_RIPENCC    }, // 193.24.40.0     - 193.24.47.255
	{ 0xc1183000, 0xc118d3ff, REGISTRY_RIPENCC    }, // 193.24.48.0     - 193.24.211.255
	{ 0xc118d400, 0xc118d7ff, REGISTRY_RIPENCC    }, // 193.24.212.0    - 193.24.215.255
	{ 0xc118d800, 0xc118e3ff, REGISTRY_RIPENCC    }, // 193.24.216.0    - 193.24.227.255
	{ 0xc118e400, 0xc118ebff, REGISTRY_RIPENCC    }, // 193.24.228.0    - 193.24.235.255
	{ 0xc118ec00, 0xc118f7ff, REGISTRY_RIPENCC    }, // 193.24.236.0    - 193.24.247.255
	{ 0xc118f800, 0xc118ffff, REGISTRY_RIPENCC    }, // 193.24.248.0    - 193.24.255.255
	{ 0xc1190000, 0xc1195fff, REGISTRY_RIPENCC    }, // 193.25.0.0      - 193.25.95.255
	{ 0xc1196200, 0xc11969ff, REGISTRY_RIPENCC    }, // 193.25.98.0     - 193.25.105.255
	{ 0xc1196e00, 0xc11971ff, REGISTRY_RIPENCC    }, // 193.25.110.0    - 193.25.113.255
	{ 0xc1197200, 0xc11973ff, REGISTRY_RIPENCC    }, // 193.25.114.0    - 193.25.115.255
	{ 0xc1197400, 0xc11979ff, REGISTRY_RIPENCC    }, // 193.25.116.0    - 193.25.121.255
	{ 0xc1197c00, 0xc119a7ff, REGISTRY_RIPENCC    }, // 193.25.124.0    - 193.25.167.255
	{ 0xc119aa00, 0xc119bbff, REGISTRY_RIPENCC    }, // 193.25.170.0    - 193.25.187.255
	{ 0xc119be00, 0xc119c1ff, REGISTRY_RIPENCC    }, // 193.25.190.0    - 193.25.193.255
	{ 0xc119c300, 0xc119c3ff, REGISTRY_RIPENCC    }, // 193.25.195.0    - 193.25.195.255
	{ 0xc119c500, 0xc119d1ff, REGISTRY_RIPENCC    }, // 193.25.197.0    - 193.25.209.255
	{ 0xc119d400, 0xc119d5ff, REGISTRY_RIPENCC    }, // 193.25.212.0    - 193.25.213.255
	{ 0xc119d800, 0xc119dbff, REGISTRY_RIPENCC    }, // 193.25.216.0    - 193.25.219.255
	{ 0xc119dc00, 0xc119deff, REGISTRY_RIPENCC    }, // 193.25.220.0    - 193.25.222.255
	{ 0xc119e000, 0xc119f7ff, REGISTRY_RIPENCC    }, // 193.25.224.0    - 193.25.247.255
	{ 0xc119f800, 0xc119fbff, REGISTRY_RIPENCC    }, // 193.25.248.0    - 193.25.251.255
	{ 0xc119fe00, 0xc119feff, REGISTRY_RIPENCC    }, // 193.25.254.0    - 193.25.254.255
	{ 0xc11a0100, 0xc11a01ff, REGISTRY_RIPENCC    }, // 193.26.1.0      - 193.26.1.255
	{ 0xc11a0300, 0xc11a0bff, REGISTRY_RIPENCC    }, // 193.26.3.0      - 193.26.11.255
	{ 0xc11a0d00, 0xc11a0dff, REGISTRY_RIPENCC    }, // 193.26.13.0     - 193.26.13.255
	{ 0xc11a0f00, 0xc11a14ff, REGISTRY_RIPENCC    }, // 193.26.15.0     - 193.26.20.255
	{ 0xc11a1700, 0xc11a6fff, REGISTRY_RIPENCC    }, // 193.26.23.0     - 193.26.111.255
	{ 0xc11a7000, 0xc11a77ff, REGISTRY_RIPENCC    }, // 193.26.112.0    - 193.26.119.255
	{ 0xc11a7800, 0xc11a78ff, REGISTRY_RIPENCC    }, // 193.26.120.0    - 193.26.120.255
	{ 0xc11a7b00, 0xc11a7eff, REGISTRY_RIPENCC    }, // 193.26.123.0    - 193.26.126.255
	{ 0xc11a8000, 0xc11a84ff, REGISTRY_RIPENCC    }, // 193.26.128.0    - 193.26.132.255
	{ 0xc11a8600, 0xc11a93ff, REGISTRY_RIPENCC    }, // 193.26.134.0    - 193.26.147.255
	{ 0xc11a9400, 0xc11a9fff, REGISTRY_RIPENCC    }, // 193.26.148.0    - 193.26.159.255
	{ 0xc11aa000, 0xc11acfff, REGISTRY_RIPENCC    }, // 193.26.160.0    - 193.26.207.255
	{ 0xc11ad100, 0xc11ad1ff, REGISTRY_RIPENCC    }, // 193.26.209.0    - 193.26.209.255
	{ 0xc11ad600, 0xc11ad6ff, REGISTRY_RIPENCC    }, // 193.26.214.0    - 193.26.214.255
	{ 0xc11ad800, 0xc11adaff, REGISTRY_RIPENCC    }, // 193.26.216.0    - 193.26.218.255
	{ 0xc11adc00, 0xc11adeff, REGISTRY_RIPENCC    }, // 193.26.220.0    - 193.26.222.255
	{ 0xc11ae000, 0xc11b07ff, REGISTRY_RIPENCC    }, // 193.26.224.0    - 193.27.7.255
	{ 0xc11b0900, 0xc11b09ff, REGISTRY_RIPENCC    }, // 193.27.9.0      - 193.27.9.255
	{ 0xc11b0b00, 0xc11b0bff, REGISTRY_RIPENCC    }, // 193.27.11.0     - 193.27.11.255
	{ 0xc11b0c00, 0xc11b0fff, REGISTRY_RIPENCC    }, // 193.27.12.0     - 193.27.15.255
	{ 0xc11b1200, 0xc11b12ff, REGISTRY_RIPENCC    }, // 193.27.18.0     - 193.27.18.255
	{ 0xc11b1400, 0xc11b14ff, REGISTRY_RIPENCC    }, // 193.27.20.0     - 193.27.20.255
	{ 0xc11b1600, 0xc11b16ff, REGISTRY_RIPENCC    }, // 193.27.22.0     - 193.27.22.255
	{ 0xc11b1800, 0xc11b27ff, REGISTRY_RIPENCC    }, // 193.27.24.0     - 193.27.39.255
	{ 0xc11b2800, 0xc11b2cff, REGISTRY_RIPENCC    }, // 193.27.40.0     - 193.27.44.255
	{ 0xc11b2e00, 0xc11b3fff, REGISTRY_RIPENCC    }, // 193.27.46.0     - 193.27.63.255
	{ 0xc11b4000, 0xc11b41ff, REGISTRY_RIPENCC    }, // 193.27.64.0     - 193.27.65.255
	{ 0xc11b4200, 0xc11b4bff, REGISTRY_RIPENCC    }, // 193.27.66.0     - 193.27.75.255
	{ 0xc11b4e00, 0xc11bc1ff, REGISTRY_RIPENCC    }, // 193.27.78.0     - 193.27.193.255
	{ 0xc11bc200, 0xc11bc3ff, REGISTRY_RIPENCC    }, // 193.27.194.0    - 193.27.195.255
	{ 0xc11bc400, 0xc11bd3ff, REGISTRY_RIPENCC    }, // 193.27.196.0    - 193.27.211.255
	{ 0xc11bd400, 0xc11bd5ff, REGISTRY_RIPENCC    }, // 193.27.212.0    - 193.27.213.255
	{ 0xc11bd600, 0xc11bdfff, REGISTRY_RIPENCC    }, // 193.27.214.0    - 193.27.223.255
	{ 0xc11be200, 0xc11be3ff, REGISTRY_RIPENCC    }, // 193.27.226.0    - 193.27.227.255
	{ 0xc11be600, 0xc11be7ff, REGISTRY_RIPENCC    }, // 193.27.230.0    - 193.27.231.255
	{ 0xc11be800, 0xc11bebff, REGISTRY_RIPENCC    }, // 193.27.232.0    - 193.27.235.255
	{ 0xc11bec00, 0xc11bf5ff, REGISTRY_RIPENCC    }, // 193.27.236.0    - 193.27.245.255
	{ 0xc11bfa00, 0xc11c00ff, REGISTRY_RIPENCC    }, // 193.27.250.0    - 193.28.0.255
	{ 0xc11c0500, 0xc11c06ff, REGISTRY_RIPENCC    }, // 193.28.5.0      - 193.28.6.255
	{ 0xc11c0800, 0xc11c0dff, REGISTRY_RIPENCC    }, // 193.28.8.0      - 193.28.13.255
	{ 0xc11c0f00, 0xc11c23ff, REGISTRY_RIPENCC    }, // 193.28.15.0     - 193.28.35.255
	{ 0xc11c2400, 0xc11c27ff, REGISTRY_RIPENCC    }, // 193.28.36.0     - 193.28.39.255
	{ 0xc11c2800, 0xc11c2aff, REGISTRY_RIPENCC    }, // 193.28.40.0     - 193.28.42.255
	{ 0xc11c2c00, 0xc11c32ff, REGISTRY_RIPENCC    }, // 193.28.44.0     - 193.28.50.255
	{ 0xc11c3400, 0xc11c35ff, REGISTRY_RIPENCC    }, // 193.28.52.0     - 193.28.53.255
	{ 0xc11c3700, 0xc11c38ff, REGISTRY_RIPENCC    }, // 193.28.55.0     - 193.28.56.255
	{ 0xc11c3d00, 0xc11c3dff, REGISTRY_RIPENCC    }, // 193.28.61.0     - 193.28.61.255
	{ 0xc11c4000, 0xc11c5cff, REGISTRY_RIPENCC    }, // 193.28.64.0     - 193.28.92.255
	{ 0xc11c5e00, 0xc11c5fff, REGISTRY_RIPENCC    }, // 193.28.94.0     - 193.28.95.255
	{ 0xc11c6000, 0xc11c67ff, REGISTRY_RIPENCC    }, // 193.28.96.0     - 193.28.103.255
	{ 0xc11c6b00, 0xc11c8fff, REGISTRY_RIPENCC    }, // 193.28.107.0    - 193.28.143.255
	{ 0xc11c9100, 0xc11c93ff, REGISTRY_RIPENCC    }, // 193.28.145.0    - 193.28.147.255
	{ 0xc11c9500, 0xc11c9cff, REGISTRY_RIPENCC    }, // 193.28.149.0    - 193.28.156.255
	{ 0xc11c9e00, 0xc11cb0ff, REGISTRY_RIPENCC    }, // 193.28.158.0    - 193.28.176.255
	{ 0xc11cb100, 0xc11cb1ff, REGISTRY_RIPENCC    }, // 193.28.177.0    - 193.28.177.255
	{ 0xc11cb200, 0xc11cb2ff, REGISTRY_RIPENCC    }, // 193.28.178.0    - 193.28.178.255
	{ 0xc11cb400, 0xc11cb5ff, REGISTRY_RIPENCC    }, // 193.28.180.0    - 193.28.181.255
	{ 0xc11cb700, 0xc11cbeff, REGISTRY_RIPENCC    }, // 193.28.183.0    - 193.28.190.255
	{ 0xc11cc000, 0xc11cc9ff, REGISTRY_RIPENCC    }, // 193.28.192.0    - 193.28.201.255
	{ 0xc11ccb00, 0xc11cdbff, REGISTRY_RIPENCC    }, // 193.28.203.0    - 193.28.219.255
	{ 0xc11cdc00, 0xc11cdfff, REGISTRY_RIPENCC    }, // 193.28.220.0    - 193.28.223.255
	{ 0xc11ce000, 0xc11ce3ff, REGISTRY_RIPENCC    }, // 193.28.224.0    - 193.28.227.255
	{ 0xc11ce400, 0xc11ce4ff, REGISTRY_RIPENCC    }, // 193.28.228.0    - 193.28.228.255
	{ 0xc11ce500, 0xc11cecff, REGISTRY_RIPENCC    }, // 193.28.229.0    - 193.28.236.255
	{ 0xc11cee00, 0xc11cfaff, REGISTRY_RIPENCC    }, // 193.28.238.0    - 193.28.250.255
	{ 0xc11cfb00, 0xc11cfbff, REGISTRY_RIPENCC    }, // 193.28.251.0    - 193.28.251.255
	{ 0xc11cfe00, 0xc11cfeff, REGISTRY_RIPENCC    }, // 193.28.254.0    - 193.28.254.255
	{ 0xc11d0000, 0xc11d00ff, REGISTRY_RIPENCC    }, // 193.29.0.0      - 193.29.0.255
	{ 0xc11d0200, 0xc11d03ff, REGISTRY_RIPENCC    }, // 193.29.2.0      - 193.29.3.255
	{ 0xc11d0500, 0xc11d05ff, REGISTRY_RIPENCC    }, // 193.29.5.0      - 193.29.5.255
	{ 0xc11d0900, 0xc11d09ff, REGISTRY_RIPENCC    }, // 193.29.9.0      - 193.29.9.255
	{ 0xc11d0c00, 0xc11d0fff, REGISTRY_RIPENCC    }, // 193.29.12.0     - 193.29.15.255
	{ 0xc11d1000, 0xc11d10ff, REGISTRY_RIPENCC    }, // 193.29.16.0     - 193.29.16.255
	{ 0xc11d1300, 0xc11d13ff, REGISTRY_RIPENCC    }, // 193.29.19.0     - 193.29.19.255
	{ 0xc11d1600, 0xc11d17ff, REGISTRY_RIPENCC    }, // 193.29.22.0     - 193.29.23.255
	{ 0xc11d1900, 0xc11d19ff, REGISTRY_RIPENCC    }, // 193.29.25.0     - 193.29.25.255
	{ 0xc11d1b00, 0xc11d1bff, REGISTRY_RIPENCC    }, // 193.29.27.0     - 193.29.27.255
	{ 0xc11d1c00, 0xc11d23ff, REGISTRY_RIPENCC    }, // 193.29.28.0     - 193.29.35.255
	{ 0xc11d2600, 0xc11d27ff, REGISTRY_RIPENCC    }, // 193.29.38.0     - 193.29.39.255
	{ 0xc11d2b00, 0xc11d2bff, REGISTRY_RIPENCC    }, // 193.29.43.0     - 193.29.43.255
	{ 0xc11d2c00, 0xc11d2fff, REGISTRY_RIPENCC    }, // 193.29.44.0     - 193.29.47.255
	{ 0xc11d3000, 0xc11d34ff, REGISTRY_RIPENCC    }, // 193.29.48.0     - 193.29.52.255
	{ 0xc11d3500, 0xc11d35ff, REGISTRY_RIPENCC    }, // 193.29.53.0     - 193.29.53.255
	{ 0xc11d3600, 0xc11d37ff, REGISTRY_RIPENCC    }, // 193.29.54.0     - 193.29.55.255
	{ 0xc11d3800, 0xc11d3fff, REGISTRY_RIPENCC    }, // 193.29.56.0     - 193.29.63.255
	{ 0xc11d4000, 0xc11d5fff, REGISTRY_RIPENCC    }, // 193.29.64.0     - 193.29.95.255
	{ 0xc11d6000, 0xc11d6fff, REGISTRY_RIPENCC    }, // 193.29.96.0     - 193.29.111.255
	{ 0xc11d7000, 0xc11d7fff, REGISTRY_RIPENCC    }, // 193.29.112.0    - 193.29.127.255
	{ 0xc11d8200, 0xc11db0ff, REGISTRY_RIPENCC    }, // 193.29.130.0    - 193.29.176.255
	{ 0xc11db400, 0xc11db7ff, REGISTRY_RIPENCC    }, // 193.29.180.0    - 193.29.183.255
	{ 0xc11dba00, 0xc11dbcff, REGISTRY_RIPENCC    }, // 193.29.186.0    - 193.29.188.255
	{ 0xc11dc000, 0xc11dc8ff, REGISTRY_RIPENCC    }, // 193.29.192.0    - 193.29.200.255
	{ 0xc11dc900, 0xc11dc9ff, REGISTRY_RIPENCC    }, // 193.29.201.0    - 193.29.201.255
	{ 0xc11dca00, 0xc11ddfff, REGISTRY_RIPENCC    }, // 193.29.202.0    - 193.29.223.255
	{ 0xc11de200, 0xc11de5ff, REGISTRY_RIPENCC    }, // 193.29.226.0    - 193.29.229.255
	{ 0xc11de800, 0xc11df7ff, REGISTRY_RIPENCC    }, // 193.29.232.0    - 193.29.247.255
	{ 0xc11dfa00, 0xc11dfaff, REGISTRY_RIPENCC    }, // 193.29.250.0    - 193.29.250.255
	{ 0xc11dfc00, 0xc11dfdff, REGISTRY_RIPENCC    }, // 193.29.252.0    - 193.29.253.255
	{ 0xc11dff00, 0xc11e00ff, REGISTRY_RIPENCC    }, // 193.29.255.0    - 193.30.0.255
	{ 0xc11e0300, 0xc11e04ff, REGISTRY_RIPENCC    }, // 193.30.3.0      - 193.30.4.255
	{ 0xc11e0800, 0xc11e0fff, REGISTRY_RIPENCC    }, // 193.30.8.0      - 193.30.15.255
	{ 0xc11e1000, 0xc11e12ff, REGISTRY_RIPENCC    }, // 193.30.16.0     - 193.30.18.255
	{ 0xc11e1400, 0xc11e14ff, REGISTRY_RIPENCC    }, // 193.30.20.0     - 193.30.20.255
	{ 0xc11e1800, 0xc11e1fff, REGISTRY_RIPENCC    }, // 193.30.24.0     - 193.30.31.255
	{ 0xc11e2000, 0xc11e23ff, REGISTRY_RIPENCC    }, // 193.30.32.0     - 193.30.35.255
	{ 0xc11e2400, 0xc11e27ff, REGISTRY_RIPENCC    }, // 193.30.36.0     - 193.30.39.255
	{ 0xc11e2900, 0xc11e2aff, REGISTRY_RIPENCC    }, // 193.30.41.0     - 193.30.42.255
	{ 0xc11e2c00, 0xc11e57ff, REGISTRY_RIPENCC    }, // 193.30.44.0     - 193.30.87.255
	{ 0xc11e5900, 0xc11e59ff, REGISTRY_RIPENCC    }, // 193.30.89.0     - 193.30.89.255
	{ 0xc11e5d00, 0xc11e5dff, REGISTRY_RIPENCC    }, // 193.30.93.0     - 193.30.93.255
	{ 0xc11e6000, 0xc11e67ff, REGISTRY_RIPENCC    }, // 193.30.96.0     - 193.30.103.255
	{ 0xc11e6800, 0xc11e6cff, REGISTRY_RIPENCC    }, // 193.30.104.0    - 193.30.108.255
	{ 0xc11e6e00, 0xc11e70ff, REGISTRY_RIPENCC    }, // 193.30.110.0    - 193.30.112.255
	{ 0xc11e7400, 0xc11e7bff, REGISTRY_RIPENCC    }, // 193.30.116.0    - 193.30.123.255
	{ 0xc11e7e00, 0xc11e7fff, REGISTRY_RIPENCC    }, // 193.30.126.0    - 193.30.127.255
	{ 0xc11e8200, 0xc11e85ff, REGISTRY_RIPENCC    }, // 193.30.130.0    - 193.30.133.255
	{ 0xc11e8700, 0xc11ea1ff, REGISTRY_RIPENCC    }, // 193.30.135.0    - 193.30.161.255
	{ 0xc11ea300, 0xc11ea4ff, REGISTRY_RIPENCC    }, // 193.30.163.0    - 193.30.164.255
	{ 0xc11ea700, 0xc11efdff, REGISTRY_RIPENCC    }, // 193.30.167.0    - 193.30.253.255
	{ 0xc11efe00, 0xc11effff, REGISTRY_RIPENCC    }, // 193.30.254.0    - 193.30.255.255
	{ 0xc11f0000, 0xc11f03ff, REGISTRY_RIPENCC    }, // 193.31.0.0      - 193.31.3.255
	{ 0xc11f0700, 0xc11f0bff, REGISTRY_RIPENCC    }, // 193.31.7.0      - 193.31.11.255
	{ 0xc11f0e00, 0xc11f0eff, REGISTRY_RIPENCC    }, // 193.31.14.0     - 193.31.14.255
	{ 0xc11f1200, 0xc11f13ff, REGISTRY_RIPENCC    }, // 193.31.18.0     - 193.31.19.255
	{ 0xc11f1400, 0xc11f3bff, REGISTRY_RIPENCC    }, // 193.31.20.0     - 193.31.59.255
	{ 0xc11f3d00, 0xc11f3dff, REGISTRY_RIPENCC    }, // 193.31.61.0     - 193.31.61.255
	{ 0xc11f3f00, 0xc11f3fff, REGISTRY_RIPENCC    }, // 193.31.63.0     - 193.31.63.255
	{ 0xc11f4000, 0xc11f4fff, REGISTRY_RIPENCC    }, // 193.31.64.0     - 193.31.79.255
	{ 0xc11f5000, 0xc11f5fff, REGISTRY_RIPENCC    }, // 193.31.80.0     - 193.31.95.255
	{ 0xc11f6000, 0xc11f7fff, REGISTRY_RIPENCC    }, // 193.31.96.0     - 193.31.127.255
	{ 0xc11f8000, 0xc11fcfff, REGISTRY_RIPENCC    }, // 193.31.128.0    - 193.31.207.255
	{ 0xc11fd000, 0xc11fdfff, REGISTRY_RIPENCC    }, // 193.31.208.0    - 193.31.223.255
	{ 0xc11fe000, 0xc11ff7ff, REGISTRY_RIPENCC    }, // 193.31.224.0    - 193.31.247.255
	{ 0xc11ff800, 0xc11ffbff, REGISTRY_RIPENCC    }, // 193.31.248.0    - 193.31.251.255
	{ 0xc11ffc00, 0xc11ffdff, REGISTRY_RIPENCC    }, // 193.31.252.0    - 193.31.253.255
	{ 0xc1200300, 0xc12003ff, REGISTRY_RIPENCC    }, // 193.32.3.0      - 193.32.3.255
	{ 0xc1200600, 0xc12007ff, REGISTRY_RIPENCC    }, // 193.32.6.0      - 193.32.7.255
	{ 0xc1200900, 0xc12009ff, REGISTRY_RIPENCC    }, // 193.32.9.0      - 193.32.9.255
	{ 0xc1200c00, 0xc1200fff, REGISTRY_RIPENCC    }, // 193.32.12.0     - 193.32.15.255
	{ 0xc1201100, 0xc12016ff, REGISTRY_RIPENCC    }, // 193.32.17.0     - 193.32.22.255
	{ 0xc1201800, 0xc1201bff, REGISTRY_RIPENCC    }, // 193.32.24.0     - 193.32.27.255
	{ 0xc1201e00, 0xc12027ff, REGISTRY_RIPENCC    }, // 193.32.30.0     - 193.32.39.255
	{ 0xc1202900, 0xc12039ff, REGISTRY_RIPENCC    }, // 193.32.41.0     - 193.32.57.255
	{ 0xc1203a00, 0xc1203bff, REGISTRY_RIPENCC    }, // 193.32.58.0     - 193.32.59.255
	{ 0xc1203c00, 0xc12041ff, REGISTRY_RIPENCC    }, // 193.32.60.0     - 193.32.65.255
	{ 0xc1204200, 0xc12047ff, REGISTRY_RIPENCC    }, // 193.32.66.0     - 193.32.71.255
	{ 0xc1204800, 0xc12053ff, REGISTRY_RIPENCC    }, // 193.32.72.0     - 193.32.83.255
	{ 0xc1205400, 0xc12057ff, REGISTRY_RIPENCC    }, // 193.32.84.0     - 193.32.87.255
	{ 0xc1205800, 0xc1205bff, REGISTRY_RIPENCC    }, // 193.32.88.0     - 193.32.91.255
	{ 0xc1205c00, 0xc12063ff, REGISTRY_RIPENCC    }, // 193.32.92.0     - 193.32.99.255
	{ 0xc1206400, 0xc12065ff, REGISTRY_RIPENCC    }, // 193.32.100.0    - 193.32.101.255
	{ 0xc1206700, 0xc12067ff, REGISTRY_RIPENCC    }, // 193.32.103.0    - 193.32.103.255
	{ 0xc1206a00, 0xc1206dff, REGISTRY_RIPENCC    }, // 193.32.106.0    - 193.32.109.255
	{ 0xc1206f00, 0xc1206fff, REGISTRY_RIPENCC    }, // 193.32.111.0    - 193.32.111.255
	{ 0xc1207000, 0xc12073ff, REGISTRY_RIPENCC    }, // 193.32.112.0    - 193.32.115.255
	{ 0xc1207600, 0xc1207dff, REGISTRY_RIPENCC    }, // 193.32.118.0    - 193.32.125.255
	{ 0xc1208000, 0xc120f7ff, REGISTRY_RIPENCC    }, // 193.32.128.0    - 193.32.247.255
	{ 0xc120fa00, 0xc12105ff, REGISTRY_RIPENCC    }, // 193.32.250.0    - 193.33.5.255
	{ 0xc1210800, 0xc1211dff, REGISTRY_RIPENCC    }, // 193.33.8.0      - 193.33.29.255
	{ 0xc1211e00, 0xc1211fff, REGISTRY_RIPENCC    }, // 193.33.30.0     - 193.33.31.255
	{ 0xc1212000, 0xc12127ff, REGISTRY_RIPENCC    }, // 193.33.32.0     - 193.33.39.255
	{ 0xc1212a00, 0xc12131ff, REGISTRY_RIPENCC    }, // 193.33.42.0     - 193.33.49.255
	{ 0xc1213400, 0xc12139ff, REGISTRY_RIPENCC    }, // 193.33.52.0     - 193.33.57.255
	{ 0xc1213c00, 0xc1213fff, REGISTRY_RIPENCC    }, // 193.33.60.0     - 193.33.63.255
	{ 0xc1214000, 0xc12141ff, REGISTRY_RIPENCC    }, // 193.33.64.0     - 193.33.65.255
	{ 0xc1214400, 0xc12155ff, REGISTRY_RIPENCC    }, // 193.33.68.0     - 193.33.85.255
	{ 0xc1215800, 0xc12169ff, REGISTRY_RIPENCC    }, // 193.33.88.0     - 193.33.105.255
	{ 0xc1216c00, 0xc1216fff, REGISTRY_RIPENCC    }, // 193.33.108.0    - 193.33.111.255
	{ 0xc1217200, 0xc12181ff, REGISTRY_RIPENCC    }, // 193.33.114.0    - 193.33.129.255
	{ 0xc1218400, 0xc12185ff, REGISTRY_RIPENCC    }, // 193.33.132.0    - 193.33.133.255
	{ 0xc1218600, 0xc12187ff, REGISTRY_RIPENCC    }, // 193.33.134.0    - 193.33.135.255
	{ 0xc1218a00, 0xc1218bff, REGISTRY_RIPENCC    }, // 193.33.138.0    - 193.33.139.255
	{ 0xc1218e00, 0xc121a1ff, REGISTRY_RIPENCC    }, // 193.33.142.0    - 193.33.161.255
	{ 0xc121a600, 0xc121cbff, REGISTRY_RIPENCC    }, // 193.33.166.0    - 193.33.203.255
	{ 0xc121ce00, 0xc121f1ff, REGISTRY_RIPENCC    }, // 193.33.206.0    - 193.33.241.255
	{ 0xc121f400, 0xc121fbff, REGISTRY_RIPENCC    }, // 193.33.244.0    - 193.33.251.255
	{ 0xc121fe00, 0xc12207ff, REGISTRY_RIPENCC    }, // 193.33.254.0    - 193.34.7.255
	{ 0xc1220800, 0xc1220bff, REGISTRY_RIPENCC    }, // 193.34.8.0      - 193.34.11.255
	{ 0xc1220c00, 0xc1224bff, REGISTRY_RIPENCC    }, // 193.34.12.0     - 193.34.75.255
	{ 0xc1224c00, 0xc1224fff, REGISTRY_RIPENCC    }, // 193.34.76.0     - 193.34.79.255
	{ 0xc1225000, 0xc12267ff, REGISTRY_RIPENCC    }, // 193.34.80.0     - 193.34.103.255
	{ 0xc1226800, 0xc1226bff, REGISTRY_RIPENCC    }, // 193.34.104.0    - 193.34.107.255
	{ 0xc1226c00, 0xc12273ff, REGISTRY_RIPENCC    }, // 193.34.108.0    - 193.34.115.255
	{ 0xc1227400, 0xc12277ff, REGISTRY_RIPENCC    }, // 193.34.116.0    - 193.34.119.255
	{ 0xc1227800, 0xc1228fff, REGISTRY_RIPENCC    }, // 193.34.120.0    - 193.34.143.255
	{ 0xc1229000, 0xc12291ff, REGISTRY_RIPENCC    }, // 193.34.144.0    - 193.34.145.255
	{ 0xc1229200, 0xc122abff, REGISTRY_RIPENCC    }, // 193.34.146.0    - 193.34.171.255
	{ 0xc122ac00, 0xc122adff, REGISTRY_RIPENCC    }, // 193.34.172.0    - 193.34.173.255
	{ 0xc122ae00, 0xc122b9ff, REGISTRY_RIPENCC    }, // 193.34.174.0    - 193.34.185.255
	{ 0xc122ba00, 0xc122bbff, REGISTRY_RIPENCC    }, // 193.34.186.0    - 193.34.187.255
	{ 0xc122bc00, 0xc122c17f, REGISTRY_RIPENCC    }, // 193.34.188.0    - 193.34.193.127
	{ 0xc122c300, 0xc122c47f, REGISTRY_RIPENCC    }, // 193.34.195.0    - 193.34.196.127
	{ 0xc122c500, 0xc122c97f, REGISTRY_RIPENCC    }, // 193.34.197.0    - 193.34.201.127
	{ 0xc122ca00, 0xc122dfff, REGISTRY_RIPENCC    }, // 193.34.202.0    - 193.34.223.255
	{ 0xc122e000, 0xc122e3ff, REGISTRY_RIPENCC    }, // 193.34.224.0    - 193.34.227.255
	{ 0xc122e600, 0xc122e7ff, REGISTRY_RIPENCC    }, // 193.34.230.0    - 193.34.231.255
	{ 0xc122e800, 0xc122f7ff, REGISTRY_RIPENCC    }, // 193.34.232.0    - 193.34.247.255
	{ 0xc122f800, 0xc12300ff, REGISTRY_RIPENCC    }, // 193.34.248.0    - 193.35.0.255
	{ 0xc1230400, 0xc12307ff, REGISTRY_RIPENCC    }, // 193.35.4.0      - 193.35.7.255
	{ 0xc1230800, 0xc1230dff, REGISTRY_RIPENCC    }, // 193.35.8.0      - 193.35.13.255
	{ 0xc1231000, 0xc12317ff, REGISTRY_RIPENCC    }, // 193.35.16.0     - 193.35.23.255
	{ 0xc1231900, 0xc12319ff, REGISTRY_RIPENCC    }, // 193.35.25.0     - 193.35.25.255
	{ 0xc1231c00, 0xc1231fff, REGISTRY_RIPENCC    }, // 193.35.28.0     - 193.35.31.255
	{ 0xc1232000, 0xc1233cff, REGISTRY_RIPENCC    }, // 193.35.32.0     - 193.35.60.255
	{ 0xc1233e00, 0xc1233eff, REGISTRY_RIPENCC    }, // 193.35.62.0     - 193.35.62.255
	{ 0xc1234000, 0xc1234fff, REGISTRY_RIPENCC    }, // 193.35.64.0     - 193.35.79.255
	{ 0xc1235000, 0xc1235fff, REGISTRY_RIPENCC    }, // 193.35.80.0     - 193.35.95.255
	{ 0xc1236000, 0xc12361ff, REGISTRY_RIPENCC    }, // 193.35.96.0     - 193.35.97.255
	{ 0xc1236300, 0xc12364ff, REGISTRY_RIPENCC    }, // 193.35.99.0     - 193.35.100.255
	{ 0xc1236600, 0xc12390ff, REGISTRY_RIPENCC    }, // 193.35.102.0    - 193.35.144.255
	{ 0xc1239200, 0xc12393ff, REGISTRY_RIPENCC    }, // 193.35.146.0    - 193.35.147.255
	{ 0xc1239400, 0xc1239bff, REGISTRY_RIPENCC    }, // 193.35.148.0    - 193.35.155.255
	{ 0xc1239d00, 0xc123a1ff, REGISTRY_RIPENCC    }, // 193.35.157.0    - 193.35.161.255
	{ 0xc123a200, 0xc123b5ff, REGISTRY_RIPENCC    }, // 193.35.162.0    - 193.35.181.255
	{ 0xc123b600, 0xc123c5ff, REGISTRY_RIPENCC    }, // 193.35.182.0    - 193.35.197.255
	{ 0xc123c800, 0xc123d7ff, REGISTRY_RIPENCC    }, // 193.35.200.0    - 193.35.215.255
	{ 0xc123d900, 0xc123d9ff, REGISTRY_RIPENCC    }, // 193.35.217.0    - 193.35.217.255
	{ 0xc123dc00, 0xc123dfff, REGISTRY_RIPENCC    }, // 193.35.220.0    - 193.35.223.255
	{ 0xc123e000, 0xc123e7ff, REGISTRY_RIPENCC    }, // 193.35.224.0    - 193.35.231.255
	{ 0xc123e800, 0xc12402ff, REGISTRY_RIPENCC    }, // 193.35.232.0    - 193.36.2.255
	{ 0xc1240400, 0xc12429ff, REGISTRY_RIPENCC    }, // 193.36.4.0      - 193.36.41.255
	{ 0xc1242b00, 0xc1242fff, REGISTRY_RIPENCC    }, // 193.36.43.0     - 193.36.47.255
	{ 0xc1243000, 0xc1243fff, REGISTRY_RIPENCC    }, // 193.36.48.0     - 193.36.63.255
	{ 0xc1244000, 0xc12447ff, REGISTRY_RIPENCC    }, // 193.36.64.0     - 193.36.71.255
	{ 0xc1244b00, 0xc1244bff, REGISTRY_RIPENCC    }, // 193.36.75.0     - 193.36.75.255
	{ 0xc1244d00, 0xc12453ff, REGISTRY_RIPENCC    }, // 193.36.77.0     - 193.36.83.255
	{ 0xc1245700, 0xc12457ff, REGISTRY_RIPENCC    }, // 193.36.87.0     - 193.36.87.255
	{ 0xc1245800, 0xc12483ff, REGISTRY_RIPENCC    }, // 193.36.88.0     - 193.36.131.255
	{ 0xc1248500, 0xc12485ff, REGISTRY_RIPENCC    }, // 193.36.133.0    - 193.36.133.255
	{ 0xc1248800, 0xc1248fff, REGISTRY_RIPENCC    }, // 193.36.136.0    - 193.36.143.255
	{ 0xc1249000, 0xc12497ff, REGISTRY_RIPENCC    }, // 193.36.144.0    - 193.36.151.255
	{ 0xc1249800, 0xc124a1ff, REGISTRY_RIPENCC    }, // 193.36.152.0    - 193.36.161.255
	{ 0xc124a400, 0xc124abff, REGISTRY_RIPENCC    }, // 193.36.164.0    - 193.36.171.255
	{ 0xc124ad00, 0xc124adff, REGISTRY_RIPENCC    }, // 193.36.173.0    - 193.36.173.255
	{ 0xc124b000, 0xc124b2ff, REGISTRY_RIPENCC    }, // 193.36.176.0    - 193.36.178.255
	{ 0xc124b600, 0xc124b8ff, REGISTRY_RIPENCC    }, // 193.36.182.0    - 193.36.184.255
	{ 0xc124ba00, 0xc124baff, REGISTRY_RIPENCC    }, // 193.36.186.0    - 193.36.186.255
	{ 0xc124bc00, 0xc124bfff, REGISTRY_RIPENCC    }, // 193.36.188.0    - 193.36.191.255
	{ 0xc124c000, 0xc124dfff, REGISTRY_RIPENCC    }, // 193.36.192.0    - 193.36.223.255
	{ 0xc124e200, 0xc124e2ff, REGISTRY_RIPENCC    }, // 193.36.226.0    - 193.36.226.255
	{ 0xc124e500, 0xc124e6ff, REGISTRY_RIPENCC    }, // 193.36.229.0    - 193.36.230.255
	{ 0xc124e800, 0xc124efff, REGISTRY_RIPENCC    }, // 193.36.232.0    - 193.36.239.255
	{ 0xc124f000, 0xc1251fff, REGISTRY_RIPENCC    }, // 193.36.240.0    - 193.37.31.255
	{ 0xc1252300, 0xc12527ff, REGISTRY_RIPENCC    }, // 193.37.35.0     - 193.37.39.255
	{ 0xc1252800, 0xc12557ff, REGISTRY_RIPENCC    }, // 193.37.40.0     - 193.37.87.255
	{ 0xc1255800, 0xc1256bff, REGISTRY_RIPENCC    }, // 193.37.88.0     - 193.37.107.255
	{ 0xc1256c00, 0xc1256fff, REGISTRY_RIPENCC    }, // 193.37.108.0    - 193.37.111.255
	{ 0xc1257000, 0xc12584ff, REGISTRY_RIPENCC    }, // 193.37.112.0    - 193.37.132.255
	{ 0xc1258700, 0xc12597ff, REGISTRY_RIPENCC    }, // 193.37.135.0    - 193.37.151.255
	{ 0xc1259800, 0xc12598ff, REGISTRY_RIPENCC    }, // 193.37.152.0    - 193.37.152.255
	{ 0xc1259900, 0xc1259aff, REGISTRY_RIPENCC    }, // 193.37.153.0    - 193.37.154.255
	{ 0xc1259c00, 0xc125bfff, REGISTRY_RIPENCC    }, // 193.37.156.0    - 193.37.191.255
	{ 0xc125c000, 0xc125dfff, REGISTRY_RIPENCC    }, // 193.37.192.0    - 193.37.223.255
	{ 0xc125e100, 0xc125e1ff, REGISTRY_RIPENCC    }, // 193.37.225.0    - 193.37.225.255
	{ 0xc125e400, 0xc125e4ff, REGISTRY_RIPENCC    }, // 193.37.228.0    - 193.37.228.255
	{ 0xc125e800, 0xc125ebff, REGISTRY_RIPENCC    }, // 193.37.232.0    - 193.37.235.255
	{ 0xc125ec00, 0xc125eeff, REGISTRY_RIPENCC    }, // 193.37.236.0    - 193.37.238.255
	{ 0xc125f000, 0xc125f7ff, REGISTRY_RIPENCC    }, // 193.37.240.0    - 193.37.247.255
	{ 0xc125f800, 0xc125ffff, REGISTRY_RIPENCC    }, // 193.37.248.0    - 193.37.255.255
	{ 0xc1260000, 0xc1261fff, REGISTRY_RIPENCC    }, // 193.38.0.0      - 193.38.31.255
	{ 0xc1262000, 0xc1262fff, REGISTRY_RIPENCC    }, // 193.38.32.0     - 193.38.47.255
	{ 0xc1263000, 0xc12631ff, REGISTRY_RIPENCC    }, // 193.38.48.0     - 193.38.49.255
	{ 0xc1263400, 0xc12634ff, REGISTRY_RIPENCC    }, // 193.38.52.0     - 193.38.52.255
	{ 0xc1263800, 0xc1267fff, REGISTRY_RIPENCC    }, // 193.38.56.0     - 193.38.127.255
	{ 0xc1268000, 0xc1268bff, REGISTRY_RIPENCC    }, // 193.38.128.0    - 193.38.139.255
	{ 0xc1268e00, 0xc1268fff, REGISTRY_RIPENCC    }, // 193.38.142.0    - 193.38.143.255
	{ 0xc1269000, 0xc1269fff, REGISTRY_RIPENCC    }, // 193.38.144.0    - 193.38.159.255
	{ 0xc126a000, 0xc126dfff, REGISTRY_RIPENCC    }, // 193.38.160.0    - 193.38.223.255
	{ 0xc126e000, 0xc12703ff, REGISTRY_RIPENCC    }, // 193.38.224.0    - 193.39.3.255
	{ 0xc1270400, 0xc12705ff, REGISTRY_RIPENCC    }, // 193.39.4.0      - 193.39.5.255
	{ 0xc1270800, 0xc12708ff, REGISTRY_RIPENCC    }, // 193.39.8.0      - 193.39.8.255
	{ 0xc1270b00, 0xc1270bff, REGISTRY_RIPENCC    }, // 193.39.11.0     - 193.39.11.255
	{ 0xc1270c00, 0xc1270fff, REGISTRY_RIPENCC    }, // 193.39.12.0     - 193.39.15.255
	{ 0xc1271000, 0xc1274dff, REGISTRY_RIPENCC    }, // 193.39.16.0     - 193.39.77.255
	{ 0xc1274f00, 0xc12757ff, REGISTRY_RIPENCC    }, // 193.39.79.0     - 193.39.87.255
	{ 0xc1275800, 0xc1275fff, REGISTRY_RIPENCC    }, // 193.39.88.0     - 193.39.95.255
	{ 0xc1276000, 0xc12788ff, REGISTRY_RIPENCC    }, // 193.39.96.0     - 193.39.136.255
	{ 0xc1278b00, 0xc1278dff, REGISTRY_RIPENCC    }, // 193.39.139.0    - 193.39.141.255
	{ 0xc1279000, 0xc1279fff, REGISTRY_RIPENCC    }, // 193.39.144.0    - 193.39.159.255
	{ 0xc127a000, 0xc127abff, REGISTRY_RIPENCC    }, // 193.39.160.0    - 193.39.171.255
	{ 0xc127ac00, 0xc127b7ff, REGISTRY_RIPENCC    }, // 193.39.172.0    - 193.39.183.255
	{ 0xc127b800, 0xc127c7ff, REGISTRY_RIPENCC    }, // 193.39.184.0    - 193.39.199.255
	{ 0xc127c800, 0xc127cfff, REGISTRY_RIPENCC    }, // 193.39.200.0    - 193.39.207.255
	{ 0xc127d200, 0xc127d4ff, REGISTRY_RIPENCC    }, // 193.39.210.0    - 193.39.212.255
	{ 0xc127d600, 0xc127d6ff, REGISTRY_RIPENCC    }, // 193.39.214.0    - 193.39.214.255
	{ 0xc127d800, 0xc127dfff, REGISTRY_RIPENCC    }, // 193.39.216.0    - 193.39.223.255
	{ 0xc127e000, 0xc127efff, REGISTRY_RIPENCC    }, // 193.39.224.0    - 193.39.239.255
	{ 0xc127f000, 0xc127f3ff, REGISTRY_RIPENCC    }, // 193.39.240.0    - 193.39.243.255
	{ 0xc127f700, 0xc127f9ff, REGISTRY_RIPENCC    }, // 193.39.247.0    - 193.39.249.255
	{ 0xc127fb00, 0xc127fbff, REGISTRY_RIPENCC    }, // 193.39.251.0    - 193.39.251.255
	{ 0xc127fc00, 0xc128ffff, REGISTRY_RIPENCC    }, // 193.39.252.0    - 193.40.255.255
	{ 0xc1290000, 0xc1291fff, REGISTRY_RIPENCC    }, // 193.41.0.0      - 193.41.31.255
	{ 0xc1292100, 0xc12921ff, REGISTRY_RIPENCC    }, // 193.41.33.0     - 193.41.33.255
	{ 0xc1292300, 0xc12925ff, REGISTRY_RIPENCC    }, // 193.41.35.0     - 193.41.37.255
	{ 0xc1292800, 0xc1292eff, REGISTRY_RIPENCC    }, // 193.41.40.0     - 193.41.46.255
	{ 0xc1293000, 0xc12933ff, REGISTRY_RIPENCC    }, // 193.41.48.0     - 193.41.51.255
	{ 0xc1293400, 0xc12937ff, REGISTRY_RIPENCC    }, // 193.41.52.0     - 193.41.55.255
	{ 0xc1293800, 0xc12943ff, REGISTRY_RIPENCC    }, // 193.41.56.0     - 193.41.67.255
	{ 0xc1294700, 0xc12947ff, REGISTRY_RIPENCC    }, // 193.41.71.0     - 193.41.71.255
	{ 0xc1294800, 0xc1294bff, REGISTRY_RIPENCC    }, // 193.41.72.0     - 193.41.75.255
	{ 0xc1294c00, 0xc12951ff, REGISTRY_RIPENCC    }, // 193.41.76.0     - 193.41.81.255
	{ 0xc1295300, 0xc12955ff, REGISTRY_RIPENCC    }, // 193.41.83.0     - 193.41.85.255
	{ 0xc1295800, 0xc1295aff, REGISTRY_RIPENCC    }, // 193.41.88.0     - 193.41.90.255
	{ 0xc1295d00, 0xc12971ff, REGISTRY_RIPENCC    }, // 193.41.93.0     - 193.41.113.255
	{ 0xc1297400, 0xc12975ff, REGISTRY_RIPENCC    }, // 193.41.116.0    - 193.41.117.255
	{ 0xc1297600, 0xc12979ff, REGISTRY_RIPENCC    }, // 193.41.118.0    - 193.41.121.255
	{ 0xc1297c00, 0xc12991ff, REGISTRY_RIPENCC    }, // 193.41.124.0    - 193.41.145.255
	{ 0xc1299200, 0xc12993ff, REGISTRY_AFRINIC    }, // 193.41.146.0    - 193.41.147.255
	{ 0xc1299400, 0xc12999ff, REGISTRY_RIPENCC    }, // 193.41.148.0    - 193.41.153.255
	{ 0xc1299c00, 0xc129bfff, REGISTRY_RIPENCC    }, // 193.41.156.0    - 193.41.191.255
	{ 0xc129c100, 0xc129c6ff, REGISTRY_RIPENCC    }, // 193.41.193.0    - 193.41.198.255
	{ 0xc129c800, 0xc129cbff, REGISTRY_RIPENCC    }, // 193.41.200.0    - 193.41.203.255
	{ 0xc129cd00, 0xc129d3ff, REGISTRY_RIPENCC    }, // 193.41.205.0    - 193.41.211.255
	{ 0xc129d600, 0xc129e1ff, REGISTRY_RIPENCC    }, // 193.41.214.0    - 193.41.225.255
	{ 0xc129e300, 0xc129ecff, REGISTRY_RIPENCC    }, // 193.41.227.0    - 193.41.236.255
	{ 0xc129ee00, 0xc129ffff, REGISTRY_RIPENCC    }, // 193.41.238.0    - 193.41.255.255
	{ 0xc12a0200, 0xc12a03ff, REGISTRY_RIPENCC    }, // 193.42.2.0      - 193.42.3.255
	{ 0xc12a0400, 0xc12a07ff, REGISTRY_RIPENCC    }, // 193.42.4.0      - 193.42.7.255
	{ 0xc12a0800, 0xc12a0aff, REGISTRY_RIPENCC    }, // 193.42.8.0      - 193.42.10.255
	{ 0xc12a0d00, 0xc12a0eff, REGISTRY_RIPENCC    }, // 193.42.13.0     - 193.42.14.255
	{ 0xc12a1000, 0xc12a3fff, REGISTRY_RIPENCC    }, // 193.42.16.0     - 193.42.63.255
	{ 0xc12a4000, 0xc12a5fff, REGISTRY_RIPENCC    }, // 193.42.64.0     - 193.42.95.255
	{ 0xc12a6000, 0xc12a83ff, REGISTRY_RIPENCC    }, // 193.42.96.0     - 193.42.131.255
	{ 0xc12a8500, 0xc12a86ff, REGISTRY_RIPENCC    }, // 193.42.133.0    - 193.42.134.255
	{ 0xc12a8a00, 0xc12a94ff, REGISTRY_RIPENCC    }, // 193.42.138.0    - 193.42.148.255
	{ 0xc12a9600, 0xc12a99ff, REGISTRY_RIPENCC    }, // 193.42.150.0    - 193.42.153.255
	{ 0xc12a9a00, 0xc12a9aff, REGISTRY_RIPENCC    }, // 193.42.154.0    - 193.42.154.255
	{ 0xc12a9b00, 0xc12a9cff, REGISTRY_RIPENCC    }, // 193.42.155.0    - 193.42.156.255
	{ 0xc12a9e00, 0xc12ad1ff, REGISTRY_RIPENCC    }, // 193.42.158.0    - 193.42.209.255
	{ 0xc12ad300, 0xc12ad5ff, REGISTRY_RIPENCC    }, // 193.42.211.0    - 193.42.213.255
	{ 0xc12ad700, 0xc12ad8ff, REGISTRY_RIPENCC    }, // 193.42.215.0    - 193.42.216.255
	{ 0xc12ada00, 0xc12adaff, REGISTRY_RIPENCC    }, // 193.42.218.0    - 193.42.218.255
	{ 0xc12adc00, 0xc12adfff, REGISTRY_RIPENCC    }, // 193.42.220.0    - 193.42.223.255
	{ 0xc12ae000, 0xc12ae3ff, REGISTRY_RIPENCC    }, // 193.42.224.0    - 193.42.227.255
	{ 0xc12ae400, 0xc12aefff, REGISTRY_RIPENCC    }, // 193.42.228.0    - 193.42.239.255
	{ 0xc12af000, 0xc12af7ff, REGISTRY_RIPENCC    }, // 193.42.240.0    - 193.42.247.255
	{ 0xc12af800, 0xc12b07ff, REGISTRY_RIPENCC    }, // 193.42.248.0    - 193.43.7.255
	{ 0xc12b0800, 0xc12b0bff, REGISTRY_RIPENCC    }, // 193.43.8.0      - 193.43.11.255
	{ 0xc12b0c00, 0xc12b0dff, REGISTRY_RIPENCC    }, // 193.43.12.0     - 193.43.13.255
	{ 0xc12b0f00, 0xc12b13ff, REGISTRY_RIPENCC    }, // 193.43.15.0     - 193.43.19.255
	{ 0xc12b1400, 0xc12b17ff, REGISTRY_RIPENCC    }, // 193.43.20.0     - 193.43.23.255
	{ 0xc12b1800, 0xc12b1bff, REGISTRY_RIPENCC    }, // 193.43.24.0     - 193.43.27.255
	{ 0xc12b1d00, 0xc12b1dff, REGISTRY_RIPENCC    }, // 193.43.29.0     - 193.43.29.255
	{ 0xc12b2200, 0xc12b24ff, REGISTRY_RIPENCC    }, // 193.43.34.0     - 193.43.36.255
	{ 0xc12b2600, 0xc12b27ff, REGISTRY_RIPENCC    }, // 193.43.38.0     - 193.43.39.255
	{ 0xc12b2800, 0xc12b2bff, REGISTRY_RIPENCC    }, // 193.43.40.0     - 193.43.43.255
	{ 0xc12b2c00, 0xc12b3fff, REGISTRY_RIPENCC    }, // 193.43.44.0     - 193.43.63.255
	{ 0xc12b4000, 0xc12b47ff, REGISTRY_RIPENCC    }, // 193.43.64.0     - 193.43.71.255
	{ 0xc12b4900, 0xc12b49ff, REGISTRY_RIPENCC    }, // 193.43.73.0     - 193.43.73.255
	{ 0xc12b4c00, 0xc12b4eff, REGISTRY_RIPENCC    }, // 193.43.76.0     - 193.43.78.255
	{ 0xc12b5000, 0xc12b5aff, REGISTRY_RIPENCC    }, // 193.43.80.0     - 193.43.90.255
	{ 0xc12b5c00, 0xc12b5dff, REGISTRY_RIPENCC    }, // 193.43.92.0     - 193.43.93.255
	{ 0xc12b5f00, 0xc12b61ff, REGISTRY_RIPENCC    }, // 193.43.95.0     - 193.43.97.255
	{ 0xc12b6500, 0xc12b6dff, REGISTRY_RIPENCC    }, // 193.43.101.0    - 193.43.109.255
	{ 0xc12b6f00, 0xc12b75ff, REGISTRY_RIPENCC    }, // 193.43.111.0    - 193.43.117.255
	{ 0xc12b7800, 0xc12b7dff, REGISTRY_RIPENCC    }, // 193.43.120.0    - 193.43.125.255
	{ 0xc12b7f00, 0xc12b85ff, REGISTRY_RIPENCC    }, // 193.43.127.0    - 193.43.133.255
	{ 0xc12b8900, 0xc12b89ff, REGISTRY_RIPENCC    }, // 193.43.137.0    - 193.43.137.255
	{ 0xc12b8d00, 0xc12b8dff, REGISTRY_RIPENCC    }, // 193.43.141.0    - 193.43.141.255
	{ 0xc12b9000, 0xc12b90ff, REGISTRY_RIPENCC    }, // 193.43.144.0    - 193.43.144.255
	{ 0xc12b9400, 0xc12b94ff, REGISTRY_RIPENCC    }, // 193.43.148.0    - 193.43.148.255
	{ 0xc12b9600, 0xc12b9eff, REGISTRY_RIPENCC    }, // 193.43.150.0    - 193.43.158.255
	{ 0xc12ba000, 0xc12bffff, REGISTRY_RIPENCC    }, // 193.43.160.0    - 193.43.255.255
	{ 0xc12c0000, 0xc12dffff, REGISTRY_RIPENCC    }, // 193.44.0.0      - 193.45.255.255
	{ 0xc12e0100, 0xc12e13ff, REGISTRY_RIPENCC    }, // 193.46.1.0      - 193.46.19.255
	{ 0xc12e1400, 0xc12e27ff, REGISTRY_RIPENCC    }, // 193.46.20.0     - 193.46.39.255
	{ 0xc12e2800, 0xc12e37ff, REGISTRY_RIPENCC    }, // 193.46.40.0     - 193.46.55.255
	{ 0xc12e3a00, 0xc12e42ff, REGISTRY_RIPENCC    }, // 193.46.58.0     - 193.46.66.255
	{ 0xc12e4400, 0xc12e48ff, REGISTRY_RIPENCC    }, // 193.46.68.0     - 193.46.72.255
	{ 0xc12e4900, 0xc12e49ff, REGISTRY_RIPENCC    }, // 193.46.73.0     - 193.46.73.255
	{ 0xc12e4b00, 0xc12e4dff, REGISTRY_RIPENCC    }, // 193.46.75.0     - 193.46.77.255
	{ 0xc12e5000, 0xc12e52ff, REGISTRY_RIPENCC    }, // 193.46.80.0     - 193.46.82.255
	{ 0xc12e5300, 0xc12e53ff, REGISTRY_RIPENCC    }, // 193.46.83.0     - 193.46.83.255
	{ 0xc12e5400, 0xc12eabff, REGISTRY_RIPENCC    }, // 193.46.84.0     - 193.46.171.255
	{ 0xc12eac00, 0xc12eb3ff, REGISTRY_RIPENCC    }, // 193.46.172.0    - 193.46.179.255
	{ 0xc12eb400, 0xc12ebfff, REGISTRY_RIPENCC    }, // 193.46.180.0    - 193.46.191.255
	{ 0xc12ec000, 0xc12ec7ff, REGISTRY_RIPENCC    }, // 193.46.192.0    - 193.46.199.255
	{ 0xc12ec900, 0xc12ecbff, REGISTRY_RIPENCC    }, // 193.46.201.0    - 193.46.203.255
	{ 0xc12ecd00, 0xc12ed2ff, REGISTRY_RIPENCC    }, // 193.46.205.0    - 193.46.210.255
	{ 0xc12ed400, 0xc12ed5ff, REGISTRY_RIPENCC    }, // 193.46.212.0    - 193.46.213.255
	{ 0xc12ed700, 0xc12ed7ff, REGISTRY_RIPENCC    }, // 193.46.215.0    - 193.46.215.255
	{ 0xc12ed800, 0xc12edbff, REGISTRY_RIPENCC    }, // 193.46.216.0    - 193.46.219.255
	{ 0xc12edd00, 0xc12eddff, REGISTRY_RIPENCC    }, // 193.46.221.0    - 193.46.221.255
	{ 0xc12ee000, 0xc12ee7ff, REGISTRY_RIPENCC    }, // 193.46.224.0    - 193.46.231.255
	{ 0xc12eea00, 0xc12eefff, REGISTRY_RIPENCC    }, // 193.46.234.0    - 193.46.239.255
	{ 0xc12ef000, 0xc12ef7ff, REGISTRY_RIPENCC    }, // 193.46.240.0    - 193.46.247.255
	{ 0xc12ef800, 0xc12ef9ff, REGISTRY_RIPENCC    }, // 193.46.248.0    - 193.46.249.255
	{ 0xc12efd00, 0xc12efdff, REGISTRY_RIPENCC    }, // 193.46.253.0    - 193.46.253.255
	{ 0xc12f0000, 0xc12f1fff, REGISTRY_RIPENCC    }, // 193.47.0.0      - 193.47.31.255
	{ 0xc12f2000, 0xc12f43ff, REGISTRY_RIPENCC    }, // 193.47.32.0     - 193.47.67.255
	{ 0xc12f4700, 0xc12f4aff, REGISTRY_RIPENCC    }, // 193.47.71.0     - 193.47.74.255
	{ 0xc12f4c00, 0xc12f55ff, REGISTRY_RIPENCC    }, // 193.47.76.0     - 193.47.85.255
	{ 0xc12f5700, 0xc12f95ff, REGISTRY_RIPENCC    }, // 193.47.87.0     - 193.47.149.255
	{ 0xc12f9700, 0xc12fc0ff, REGISTRY_RIPENCC    }, // 193.47.151.0    - 193.47.192.255
	{ 0xc12fc200, 0xc12fe9ff, REGISTRY_RIPENCC    }, // 193.47.194.0    - 193.47.233.255
	{ 0xc12fec00, 0xc12ff3ff, REGISTRY_RIPENCC    }, // 193.47.236.0    - 193.47.243.255
	{ 0xc12ff600, 0xc12ffdff, REGISTRY_RIPENCC    }, // 193.47.246.0    - 193.47.253.255
	{ 0xc12fff00, 0xc12fffff, REGISTRY_RIPENCC    }, // 193.47.255.0    - 193.47.255.255
	{ 0xc1300000, 0xc134ffff, REGISTRY_RIPENCC    }, // 193.48.0.0      - 193.52.255.255
	{ 0xc1350300, 0xc13504ff, REGISTRY_RIPENCC    }, // 193.53.3.0      - 193.53.4.255
	{ 0xc1350600, 0xc13506ff, REGISTRY_RIPENCC    }, // 193.53.6.0      - 193.53.6.255
	{ 0xc1350800, 0xc13509ff, REGISTRY_RIPENCC    }, // 193.53.8.0      - 193.53.9.255
	{ 0xc1350d00, 0xc13516ff, REGISTRY_RIPENCC    }, // 193.53.13.0     - 193.53.22.255
	{ 0xc1351700, 0xc13517ff, REGISTRY_RIPENCC    }, // 193.53.23.0     - 193.53.23.255
	{ 0xc1351800, 0xc13522ff, REGISTRY_RIPENCC    }, // 193.53.24.0     - 193.53.34.255
	{ 0xc1352400, 0xc13527ff, REGISTRY_RIPENCC    }, // 193.53.36.0     - 193.53.39.255
	{ 0xc1352900, 0xc13550ff, REGISTRY_RIPENCC    }, // 193.53.41.0     - 193.53.80.255
	{ 0xc1355300, 0xc13556ff, REGISTRY_RIPENCC    }, // 193.53.83.0     - 193.53.86.255
	{ 0xc1355800, 0xc13559ff, REGISTRY_RIPENCC    }, // 193.53.88.0     - 193.53.89.255
	{ 0xc1355c00, 0xc1355fff, REGISTRY_RIPENCC    }, // 193.53.92.0     - 193.53.95.255
	{ 0xc1356300, 0xc13566ff, REGISTRY_RIPENCC    }, // 193.53.99.0     - 193.53.102.255
	{ 0xc1356a00, 0xc1356cff, REGISTRY_RIPENCC    }, // 193.53.106.0    - 193.53.108.255
	{ 0xc1356d00, 0xc13570ff, REGISTRY_RIPENCC    }, // 193.53.109.0    - 193.53.112.255
	{ 0xc1357100, 0xc1357dff, REGISTRY_RIPENCC    }, // 193.53.113.0    - 193.53.125.255
	{ 0xc1358000, 0xc1359fff, REGISTRY_RIPENCC    }, // 193.53.128.0    - 193.53.159.255
	{ 0xc135a000, 0xc135a7ff, REGISTRY_RIPENCC    }, // 193.53.160.0    - 193.53.167.255
	{ 0xc135aa00, 0xc135f4ff, REGISTRY_RIPENCC    }, // 193.53.170.0    - 193.53.244.255
	{ 0xc135f800, 0xc135f8ff, REGISTRY_RIPENCC    }, // 193.53.248.0    - 193.53.248.255
	{ 0xc135ff00, 0xc135ffff, REGISTRY_RIPENCC    }, // 193.53.255.0    - 193.53.255.255
	{ 0xc1360000, 0xc13803ff, REGISTRY_RIPENCC    }, // 193.54.0.0      - 193.56.3.255
	{ 0xc1380400, 0xc13807ff, REGISTRY_RIPENCC    }, // 193.56.4.0      - 193.56.7.255
	{ 0xc1380800, 0xc1380bff, REGISTRY_RIPENCC    }, // 193.56.8.0      - 193.56.11.255
	{ 0xc1380f00, 0xc1381fff, REGISTRY_RIPENCC    }, // 193.56.15.0     - 193.56.31.255
	{ 0xc1382000, 0xc13828ff, REGISTRY_RIPENCC    }, // 193.56.32.0     - 193.56.40.255
	{ 0xc1382a00, 0xc13835ff, REGISTRY_RIPENCC    }, // 193.56.42.0     - 193.56.53.255
	{ 0xc1383a00, 0xc1383aff, REGISTRY_RIPENCC    }, // 193.56.58.0     - 193.56.58.255
	{ 0xc1383c00, 0xc1383cff, REGISTRY_RIPENCC    }, // 193.56.60.0     - 193.56.60.255
	{ 0xc1384000, 0xc1384fff, REGISTRY_RIPENCC    }, // 193.56.64.0     - 193.56.79.255
	{ 0xc1385000, 0xc13867ff, REGISTRY_RIPENCC    }, // 193.56.80.0     - 193.56.103.255
	{ 0xc1386a00, 0xc1386aff, REGISTRY_RIPENCC    }, // 193.56.106.0    - 193.56.106.255
	{ 0xc1386c00, 0xc1386fff, REGISTRY_RIPENCC    }, // 193.56.108.0    - 193.56.111.255
	{ 0xc1387200, 0xc13873ff, REGISTRY_RIPENCC    }, // 193.56.114.0    - 193.56.115.255
	{ 0xc1387700, 0xc13877ff, REGISTRY_RIPENCC    }, // 193.56.119.0    - 193.56.119.255
	{ 0xc1387800, 0xc1387bff, REGISTRY_RIPENCC    }, // 193.56.120.0    - 193.56.123.255
	{ 0xc1387f00, 0xc13880ff, REGISTRY_RIPENCC    }, // 193.56.127.0    - 193.56.128.255
	{ 0xc1388400, 0xc13887ff, REGISTRY_RIPENCC    }, // 193.56.132.0    - 193.56.135.255
	{ 0xc1388800, 0xc1388fff, REGISTRY_RIPENCC    }, // 193.56.136.0    - 193.56.143.255
	{ 0xc1389000, 0xc1389bff, REGISTRY_RIPENCC    }, // 193.56.144.0    - 193.56.155.255
	{ 0xc1389d00, 0xc1389dff, REGISTRY_RIPENCC    }, // 193.56.157.0    - 193.56.157.255
	{ 0xc138a000, 0xc138a1ff, REGISTRY_RIPENCC    }, // 193.56.160.0    - 193.56.161.255
	{ 0xc138a400, 0xc138abff, REGISTRY_RIPENCC    }, // 193.56.164.0    - 193.56.171.255
	{ 0xc138ac00, 0xc138acff, REGISTRY_RIPENCC    }, // 193.56.172.0    - 193.56.172.255
	{ 0xc138b000, 0xc138b7ff, REGISTRY_RIPENCC    }, // 193.56.176.0    - 193.56.183.255
	{ 0xc138b800, 0xc138b8ff, REGISTRY_RIPENCC    }, // 193.56.184.0    - 193.56.184.255
	{ 0xc138bb00, 0xc138bbff, REGISTRY_RIPENCC    }, // 193.56.187.0    - 193.56.187.255
	{ 0xc138bd00, 0xc138bdff, REGISTRY_RIPENCC    }, // 193.56.189.0    - 193.56.189.255
	{ 0xc138bf00, 0xc138bfff, REGISTRY_RIPENCC    }, // 193.56.191.0    - 193.56.191.255
	{ 0xc138c100, 0xc138c1ff, REGISTRY_RIPENCC    }, // 193.56.193.0    - 193.56.193.255
	{ 0xc138c400, 0xc138c7ff, REGISTRY_RIPENCC    }, // 193.56.196.0    - 193.56.199.255
	{ 0xc138ca00, 0xc138cbff, REGISTRY_RIPENCC    }, // 193.56.202.0    - 193.56.203.255
	{ 0xc138cc00, 0xc138cfff, REGISTRY_RIPENCC    }, // 193.56.204.0    - 193.56.207.255
	{ 0xc138d100, 0xc138d3ff, REGISTRY_RIPENCC    }, // 193.56.209.0    - 193.56.211.255
	{ 0xc138d400, 0xc138d7ff, REGISTRY_RIPENCC    }, // 193.56.212.0    - 193.56.215.255
	{ 0xc138d800, 0xc138dbff, REGISTRY_RIPENCC    }, // 193.56.216.0    - 193.56.219.255
	{ 0xc138dc00, 0xc138dfff, REGISTRY_RIPENCC    }, // 193.56.220.0    - 193.56.223.255
	{ 0xc138e100, 0xc138e1ff, REGISTRY_RIPENCC    }, // 193.56.225.0    - 193.56.225.255
	{ 0xc138e400, 0xc138edff, REGISTRY_RIPENCC    }, // 193.56.228.0    - 193.56.237.255
	{ 0xc138f100, 0xc138f6ff, REGISTRY_RIPENCC    }, // 193.56.241.0    - 193.56.246.255
	{ 0xc138f800, 0xc13903ff, REGISTRY_RIPENCC    }, // 193.56.248.0    - 193.57.3.255
	{ 0xc1390500, 0xc13906ff, REGISTRY_RIPENCC    }, // 193.57.5.0      - 193.57.6.255
	{ 0xc1390a00, 0xc1390dff, REGISTRY_RIPENCC    }, // 193.57.10.0     - 193.57.13.255
	{ 0xc1391000, 0xc13913ff, REGISTRY_RIPENCC    }, // 193.57.16.0     - 193.57.19.255
	{ 0xc1391400, 0xc13914ff, REGISTRY_RIPENCC    }, // 193.57.20.0     - 193.57.20.255
	{ 0xc1391800, 0xc1391aff, REGISTRY_RIPENCC    }, // 193.57.24.0     - 193.57.26.255
	{ 0xc1391c00, 0xc1391fff, REGISTRY_RIPENCC    }, // 193.57.28.0     - 193.57.31.255
	{ 0xc1392000, 0xc13920ff, REGISTRY_RIPENCC    }, // 193.57.32.0     - 193.57.32.255
	{ 0xc1392200, 0xc13922ff, REGISTRY_RIPENCC    }, // 193.57.34.0     - 193.57.34.255
	{ 0xc1392400, 0xc1392fff, REGISTRY_RIPENCC    }, // 193.57.36.0     - 193.57.47.255
	{ 0xc1393000, 0xc13931ff, REGISTRY_RIPENCC    }, // 193.57.48.0     - 193.57.49.255
	{ 0xc1393400, 0xc13937ff, REGISTRY_RIPENCC    }, // 193.57.52.0     - 193.57.55.255
	{ 0xc1393800, 0xc13938ff, REGISTRY_RIPENCC    }, // 193.57.56.0     - 193.57.56.255
	{ 0xc1393c00, 0xc1393fff, REGISTRY_RIPENCC    }, // 193.57.60.0     - 193.57.63.255
	{ 0xc1394000, 0xc13940ff, REGISTRY_RIPENCC    }, // 193.57.64.0     - 193.57.64.255
	{ 0xc1394200, 0xc13947ff, REGISTRY_RIPENCC    }, // 193.57.66.0     - 193.57.71.255
	{ 0xc1394800, 0xc1394bff, REGISTRY_RIPENCC    }, // 193.57.72.0     - 193.57.75.255
	{ 0xc1394d00, 0xc1394fff, REGISTRY_RIPENCC    }, // 193.57.77.0     - 193.57.79.255
	{ 0xc1395000, 0xc13953ff, REGISTRY_RIPENCC    }, // 193.57.80.0     - 193.57.83.255
	{ 0xc1395400, 0xc13957ff, REGISTRY_RIPENCC    }, // 193.57.84.0     - 193.57.87.255
	{ 0xc1395b00, 0xc1395cff, REGISTRY_RIPENCC    }, // 193.57.91.0     - 193.57.92.255
	{ 0xc1396000, 0xc13961ff, REGISTRY_RIPENCC    }, // 193.57.96.0     - 193.57.97.255
	{ 0xc1396400, 0xc13967ff, REGISTRY_RIPENCC    }, // 193.57.100.0    - 193.57.103.255
	{ 0xc1396900, 0xc1396bff, REGISTRY_RIPENCC    }, // 193.57.105.0    - 193.57.107.255
	{ 0xc1396d00, 0xc1397eff, REGISTRY_RIPENCC    }, // 193.57.109.0    - 193.57.126.255
	{ 0xc1398000, 0xc13983ff, REGISTRY_RIPENCC    }, // 193.57.128.0    - 193.57.131.255
	{ 0xc1398400, 0xc13987ff, REGISTRY_RIPENCC    }, // 193.57.132.0    - 193.57.135.255
	{ 0xc1398800, 0xc1398bff, REGISTRY_RIPENCC    }, // 193.57.136.0    - 193.57.139.255
	{ 0xc1398d00, 0xc1398dff, REGISTRY_RIPENCC    }, // 193.57.141.0    - 193.57.141.255
	{ 0xc1399100, 0xc13991ff, REGISTRY_RIPENCC    }, // 193.57.145.0    - 193.57.145.255
	{ 0xc1399400, 0xc13997ff, REGISTRY_RIPENCC    }, // 193.57.148.0    - 193.57.151.255
	{ 0xc1399800, 0xc1399eff, REGISTRY_RIPENCC    }, // 193.57.152.0    - 193.57.158.255
	{ 0xc139a000, 0xc139a3ff, REGISTRY_RIPENCC    }, // 193.57.160.0    - 193.57.163.255
	{ 0xc139a600, 0xc139a6ff, REGISTRY_RIPENCC    }, // 193.57.166.0    - 193.57.166.255
	{ 0xc139a900, 0xc139acff, REGISTRY_RIPENCC    }, // 193.57.169.0    - 193.57.172.255
	{ 0xc139b000, 0xc139c7ff, REGISTRY_RIPENCC    }, // 193.57.176.0    - 193.57.199.255
	{ 0xc139c900, 0xc139c9ff, REGISTRY_RIPENCC    }, // 193.57.201.0    - 193.57.201.255
	{ 0xc139cc00, 0xc139cdff, REGISTRY_RIPENCC    }, // 193.57.204.0    - 193.57.205.255
	{ 0xc139d000, 0xc139d7ff, REGISTRY_RIPENCC    }, // 193.57.208.0    - 193.57.215.255
	{ 0xc139da00, 0xc139deff, REGISTRY_RIPENCC    }, // 193.57.218.0    - 193.57.222.255
	{ 0xc139e100, 0xc139e1ff, REGISTRY_RIPENCC    }, // 193.57.225.0    - 193.57.225.255
	{ 0xc139e400, 0xc139e7ff, REGISTRY_RIPENCC    }, // 193.57.228.0    - 193.57.231.255
	{ 0xc139e800, 0xc139f7ff, REGISTRY_RIPENCC    }, // 193.57.232.0    - 193.57.247.255
	{ 0xc139f900, 0xc13a06ff, REGISTRY_RIPENCC    }, // 193.57.249.0    - 193.58.6.255
	{ 0xc13a0700, 0xc13a0fff, REGISTRY_RIPENCC    }, // 193.58.7.0      - 193.58.15.255
	{ 0xc13a1000, 0xc13a23ff, REGISTRY_RIPENCC    }, // 193.58.16.0     - 193.58.35.255
	{ 0xc13a2400, 0xc13a27ff, REGISTRY_RIPENCC    }, // 193.58.36.0     - 193.58.39.255
	{ 0xc13a2800, 0xc13a29ff, REGISTRY_RIPENCC    }, // 193.58.40.0     - 193.58.41.255
	{ 0xc13a2c00, 0xc13a57ff, REGISTRY_RIPENCC    }, // 193.58.44.0     - 193.58.87.255
	{ 0xc13a5800, 0xc13a5bff, REGISTRY_RIPENCC    }, // 193.58.88.0     - 193.58.91.255
	{ 0xc13a5c00, 0xc13a5fff, REGISTRY_RIPENCC    }, // 193.58.92.0     - 193.58.95.255
	{ 0xc13a6000, 0xc13a7fff, REGISTRY_RIPENCC    }, // 193.58.96.0     - 193.58.127.255
	{ 0xc13a8000, 0xc13a83ff, REGISTRY_RIPENCC    }, // 193.58.128.0    - 193.58.131.255
	{ 0xc13a8400, 0xc13a87ff, REGISTRY_RIPENCC    }, // 193.58.132.0    - 193.58.135.255
	{ 0xc13a8800, 0xc13a8fff, REGISTRY_RIPENCC    }, // 193.58.136.0    - 193.58.143.255
	{ 0xc13a9000, 0xc13a93ff, REGISTRY_RIPENCC    }, // 193.58.144.0    - 193.58.147.255
	{ 0xc13a9400, 0xc13a95ff, REGISTRY_RIPENCC    }, // 193.58.148.0    - 193.58.149.255
	{ 0xc13a9b00, 0xc13aa3ff, REGISTRY_RIPENCC    }, // 193.58.155.0    - 193.58.163.255
	{ 0xc13aa400, 0xc13aa7ff, REGISTRY_RIPENCC    }, // 193.58.164.0    - 193.58.167.255
	{ 0xc13aac00, 0xc13aacff, REGISTRY_RIPENCC    }, // 193.58.172.0    - 193.58.172.255
	{ 0xc13ab000, 0xc13abfff, REGISTRY_RIPENCC    }, // 193.58.176.0    - 193.58.191.255
	{ 0xc13ac000, 0xc13aecff, REGISTRY_RIPENCC    }, // 193.58.192.0    - 193.58.236.255
	{ 0xc13aee00, 0xc13aefff, REGISTRY_RIPENCC    }, // 193.58.238.0    - 193.58.239.255
	{ 0xc13af100, 0xc13af7ff, REGISTRY_RIPENCC    }, // 193.58.241.0    - 193.58.247.255
	{ 0xc13afa00, 0xc13afdff, REGISTRY_RIPENCC    }, // 193.58.250.0    - 193.58.253.255
	{ 0xc13aff00, 0xc13affff, REGISTRY_RIPENCC    }, // 193.58.255.0    - 193.58.255.255
	{ 0xc13b0000, 0xc1484eff, REGISTRY_RIPENCC    }, // 193.59.0.0      - 193.72.78.255
	{ 0xc1485000, 0xc14850ff, REGISTRY_RIPENCC    }, // 193.72.80.0     - 193.72.80.255
	{ 0xc1485100, 0xc1488fff, REGISTRY_RIPENCC    }, // 193.72.81.0     - 193.72.143.255
	{ 0xc1489000, 0xc14893ff, REGISTRY_RIPENCC    }, // 193.72.144.0    - 193.72.147.255
	{ 0xc1489400, 0xc148a5ff, REGISTRY_RIPENCC    }, // 193.72.148.0    - 193.72.165.255
	{ 0xc148a600, 0xc148a6ff, REGISTRY_RIPENCC    }, // 193.72.166.0    - 193.72.166.255
	{ 0xc148a700, 0xc148b9ff, REGISTRY_RIPENCC    }, // 193.72.167.0    - 193.72.185.255
	{ 0xc148ba00, 0xc148baff, REGISTRY_RIPENCC    }, // 193.72.186.0    - 193.72.186.255
	{ 0xc148bb00, 0xc148d7ff, REGISTRY_RIPENCC    }, // 193.72.187.0    - 193.72.215.255
	{ 0xc148d800, 0xc148d8ff, REGISTRY_RIPENCC    }, // 193.72.216.0    - 193.72.216.255
	{ 0xc148d900, 0xc14969ff, REGISTRY_RIPENCC    }, // 193.72.217.0    - 193.73.105.255
	{ 0xc1496a00, 0xc1496bff, REGISTRY_RIPENCC    }, // 193.73.106.0    - 193.73.107.255
	{ 0xc1496c00, 0xc14970ff, REGISTRY_RIPENCC    }, // 193.73.108.0    - 193.73.112.255
	{ 0xc1497100, 0xc14972ff, REGISTRY_RIPENCC    }, // 193.73.113.0    - 193.73.114.255
	{ 0xc1497300, 0xc14979ff, REGISTRY_RIPENCC    }, // 193.73.115.0    - 193.73.121.255
	{ 0xc1497a00, 0xc1497aff, REGISTRY_RIPENCC    }, // 193.73.122.0    - 193.73.122.255
	{ 0xc1497b00, 0xc1497cff, REGISTRY_RIPENCC    }, // 193.73.123.0    - 193.73.124.255
	{ 0xc1497d00, 0xc1497dff, REGISTRY_RIPENCC    }, // 193.73.125.0    - 193.73.125.255
	{ 0xc1497e00, 0xc149d2ff, REGISTRY_RIPENCC    }, // 193.73.126.0    - 193.73.210.255
	{ 0xc149d300, 0xc149d3ff, REGISTRY_RIPENCC    }, // 193.73.211.0    - 193.73.211.255
	{ 0xc149d400, 0xc149edff, REGISTRY_RIPENCC    }, // 193.73.212.0    - 193.73.237.255
	{ 0xc149ee00, 0xc149eeff, REGISTRY_RIPENCC    }, // 193.73.238.0    - 193.73.238.255
	{ 0xc149ef00, 0xc149f1ff, REGISTRY_RIPENCC    }, // 193.73.239.0    - 193.73.241.255
	{ 0xc149f200, 0xc149f3ff, REGISTRY_RIPENCC    }, // 193.73.242.0    - 193.73.243.255
	{ 0xc149f400, 0xc149f9ff, REGISTRY_RIPENCC    }, // 193.73.244.0    - 193.73.249.255
	{ 0xc149fb00, 0xc149fbff, REGISTRY_RIPENCC    }, // 193.73.251.0    - 193.73.251.255
	{ 0xc149fc00, 0xc1523fff, REGISTRY_RIPENCC    }, // 193.73.252.0    - 193.82.63.255
	{ 0xc1524000, 0xc1525fff, REGISTRY_APNIC      }, // 193.82.64.0     - 193.82.95.255
	{ 0xc1526000, 0xc152dfff, REGISTRY_RIPENCC    }, // 193.82.96.0     - 193.82.223.255
	{ 0xc152e000, 0xc152ffff, REGISTRY_APNIC      }, // 193.82.224.0    - 193.82.255.255
	{ 0xc1530000, 0xc153ffff, REGISTRY_RIPENCC    }, // 193.83.0.0      - 193.83.255.255
	{ 0xc1540000, 0xc15400ff, REGISTRY_RIPENCC    }, // 193.84.0.0      - 193.84.0.255
	{ 0xc1540700, 0xc1540aff, REGISTRY_RIPENCC    }, // 193.84.7.0      - 193.84.10.255
	{ 0xc1540c00, 0xc1540fff, REGISTRY_RIPENCC    }, // 193.84.12.0     - 193.84.15.255
	{ 0xc1541100, 0xc15412ff, REGISTRY_RIPENCC    }, // 193.84.17.0     - 193.84.18.255
	{ 0xc1541400, 0xc1541dff, REGISTRY_RIPENCC    }, // 193.84.20.0     - 193.84.29.255
	{ 0xc1541f00, 0xc1542fff, REGISTRY_RIPENCC    }, // 193.84.31.0     - 193.84.47.255
	{ 0xc1543200, 0xc15445ff, REGISTRY_RIPENCC    }, // 193.84.50.0     - 193.84.69.255
	{ 0xc1544700, 0xc15449ff, REGISTRY_RIPENCC    }, // 193.84.71.0     - 193.84.73.255
	{ 0xc1544b00, 0xc1544dff, REGISTRY_RIPENCC    }, // 193.84.75.0     - 193.84.77.255
	{ 0xc1544f00, 0xc15454ff, REGISTRY_RIPENCC    }, // 193.84.79.0     - 193.84.84.255
	{ 0xc1545600, 0xc15457ff, REGISTRY_RIPENCC    }, // 193.84.86.0     - 193.84.87.255
	{ 0xc1545900, 0xc15459ff, REGISTRY_RIPENCC    }, // 193.84.89.0     - 193.84.89.255
	{ 0xc1545b00, 0xc1545bff, REGISTRY_RIPENCC    }, // 193.84.91.0     - 193.84.91.255
	{ 0xc1545e00, 0xc15463ff, REGISTRY_RIPENCC    }, // 193.84.94.0     - 193.84.99.255
	{ 0xc1546400, 0xc15467ff, REGISTRY_RIPENCC    }, // 193.84.100.0    - 193.84.103.255
	{ 0xc1546800, 0xc1546bff, REGISTRY_RIPENCC    }, // 193.84.104.0    - 193.84.107.255
	{ 0xc1546c00, 0xc1546fff, REGISTRY_RIPENCC    }, // 193.84.108.0    - 193.84.111.255
	{ 0xc1547000, 0xc15470ff, REGISTRY_RIPENCC    }, // 193.84.112.0    - 193.84.112.255
	{ 0xc1547400, 0xc15475ff, REGISTRY_RIPENCC    }, // 193.84.116.0    - 193.84.117.255
	{ 0xc1547800, 0xc1547fff, REGISTRY_RIPENCC    }, // 193.84.120.0    - 193.84.127.255
	{ 0xc1548000, 0xc15481ff, REGISTRY_RIPENCC    }, // 193.84.128.0    - 193.84.129.255
	{ 0xc1548400, 0xc1548bff, REGISTRY_RIPENCC    }, // 193.84.132.0    - 193.84.139.255
	{ 0xc1548e00, 0xc154b2ff, REGISTRY_RIPENCC    }, // 193.84.142.0    - 193.84.178.255
	{ 0xc154b500, 0xc154baff, REGISTRY_RIPENCC    }, // 193.84.181.0    - 193.84.186.255
	{ 0xc154bc00, 0xc154bfff, REGISTRY_RIPENCC    }, // 193.84.188.0    - 193.84.191.255
	{ 0xc154c000, 0xc154dfff, REGISTRY_RIPENCC    }, // 193.84.192.0    - 193.84.223.255
	{ 0xc154e000, 0xc154f3ff, REGISTRY_RIPENCC    }, // 193.84.224.0    - 193.84.243.255
	{ 0xc154f500, 0xc154f6ff, REGISTRY_RIPENCC    }, // 193.84.245.0    - 193.84.246.255
	{ 0xc154fb00, 0xc154fcff, REGISTRY_RIPENCC    }, // 193.84.251.0    - 193.84.252.255
	{ 0xc154ff00, 0xc154ffff, REGISTRY_RIPENCC    }, // 193.84.255.0    - 193.84.255.255
	{ 0xc1550000, 0xc15cffff, REGISTRY_RIPENCC    }, // 193.85.0.0      - 193.92.255.255
	{ 0xc15d0000, 0xc15d03ff, REGISTRY_RIPENCC    }, // 193.93.0.0      - 193.93.3.255
	{ 0xc15d0400, 0xc15d07ff, REGISTRY_RIPENCC    }, // 193.93.4.0      - 193.93.7.255
	{ 0xc15d0800, 0xc15d1bff, REGISTRY_RIPENCC    }, // 193.93.8.0      - 193.93.27.255
	{ 0xc15d1c00, 0xc15d1fff, REGISTRY_RIPENCC    }, // 193.93.28.0     - 193.93.31.255
	{ 0xc15d2000, 0xc15d4fff, REGISTRY_RIPENCC    }, // 193.93.32.0     - 193.93.79.255
	{ 0xc15d5000, 0xc15d53ff, REGISTRY_RIPENCC    }, // 193.93.80.0     - 193.93.83.255
	{ 0xc15d5400, 0xc15d6bff, REGISTRY_RIPENCC    }, // 193.93.84.0     - 193.93.107.255
	{ 0xc15d6c00, 0xc15d6fff, REGISTRY_RIPENCC    }, // 193.93.108.0    - 193.93.111.255
	{ 0xc15d7000, 0xc15dbfff, REGISTRY_RIPENCC    }, // 193.93.112.0    - 193.93.191.255
	{ 0xc15dc000, 0xc15dc3ff, REGISTRY_RIPENCC    }, // 193.93.192.0    - 193.93.195.255
	{ 0xc15dc400, 0xc15de7ff, REGISTRY_RIPENCC    }, // 193.93.196.0    - 193.93.231.255
	{ 0xc15de800, 0xc15debff, REGISTRY_RIPENCC    }, // 193.93.232.0    - 193.93.235.255
	{ 0xc15dec00, 0xc15df7ff, REGISTRY_RIPENCC    }, // 193.93.236.0    - 193.93.247.255
	{ 0xc15df800, 0xc15dfbff, REGISTRY_RIPENCC    }, // 193.93.248.0    - 193.93.251.255
	{ 0xc15dfc00, 0xc15dffff, REGISTRY_RIPENCC    }, // 193.93.252.0    - 193.93.255.255
	{ 0xc15e0000, 0xc15effff, REGISTRY_RIPENCC    }, // 193.94.0.0      - 193.94.255.255
	{ 0xc15f0000, 0xc15f7fff, REGISTRY_AFRINIC    }, // 193.95.0.0      - 193.95.127.255
	{ 0xc15f8000, 0xc167ffff, REGISTRY_RIPENCC    }, // 193.95.128.0    - 193.103.255.255
	{ 0xc1680000, 0xc16806ff, REGISTRY_RIPENCC    }, // 193.104.0.0     - 193.104.6.255
	{ 0xc1680800, 0xc1680bff, REGISTRY_RIPENCC    }, // 193.104.8.0     - 193.104.11.255
	{ 0xc1680d00, 0xc16828ff, REGISTRY_RIPENCC    }, // 193.104.13.0    - 193.104.40.255
	{ 0xc1682a00, 0xc16842ff, REGISTRY_RIPENCC    }, // 193.104.42.0    - 193.104.66.255
	{ 0xc1684400, 0xc1684bff, REGISTRY_RIPENCC    }, // 193.104.68.0    - 193.104.75.255
	{ 0xc1684d00, 0xc1684fff, REGISTRY_RIPENCC    }, // 193.104.77.0    - 193.104.79.255
	{ 0xc1685100, 0xc1685cff, REGISTRY_RIPENCC    }, // 193.104.81.0    - 193.104.92.255
	{ 0xc1685f00, 0xc16861ff, REGISTRY_RIPENCC    }, // 193.104.95.0    - 193.104.97.255
	{ 0xc1686300, 0xc1686dff, REGISTRY_RIPENCC    }, // 193.104.99.0    - 193.104.109.255
	{ 0xc1686f00, 0xc16881ff, REGISTRY_RIPENCC    }, // 193.104.111.0   - 193.104.129.255
	{ 0xc1688300, 0xc1688cff, REGISTRY_RIPENCC    }, // 193.104.131.0   - 193.104.140.255
	{ 0xc1688f00, 0xc16898ff, REGISTRY_RIPENCC    }, // 193.104.143.0   - 193.104.152.255
	{ 0xc1689a00, 0xc168afff, REGISTRY_RIPENCC    }, // 193.104.154.0   - 193.104.175.255
	{ 0xc168b100, 0xc168bdff, REGISTRY_RIPENCC    }, // 193.104.177.0   - 193.104.189.255
	{ 0xc168bf00, 0xc168c5ff, REGISTRY_RIPENCC    }, // 193.104.191.0   - 193.104.197.255
	{ 0xc168c700, 0xc168d2ff, REGISTRY_RIPENCC    }, // 193.104.199.0   - 193.104.210.255
	{ 0xc168d400, 0xc168ddff, REGISTRY_RIPENCC    }, // 193.104.212.0   - 193.104.221.255
	{ 0xc168df00, 0xc168fbff, REGISTRY_RIPENCC    }, // 193.104.223.0   - 193.104.251.255
	{ 0xc168fd00, 0xc1691bff, REGISTRY_RIPENCC    }, // 193.104.253.0   - 193.105.27.255
	{ 0xc1691d00, 0xc1691eff, REGISTRY_RIPENCC    }, // 193.105.29.0    - 193.105.30.255
	{ 0xc1692000, 0xc16939ff, REGISTRY_RIPENCC    }, // 193.105.32.0    - 193.105.57.255
	{ 0xc1693b00, 0xc16950ff, REGISTRY_RIPENCC    }, // 193.105.59.0    - 193.105.80.255
	{ 0xc1695200, 0xc16952ff, REGISTRY_RIPENCC    }, // 193.105.82.0    - 193.105.82.255
	{ 0xc1695500, 0xc16957ff, REGISTRY_RIPENCC    }, // 193.105.85.0    - 193.105.87.255
	{ 0xc1695900, 0xc1695eff, REGISTRY_RIPENCC    }, // 193.105.89.0    - 193.105.94.255
	{ 0xc1696100, 0xc16965ff, REGISTRY_RIPENCC    }, // 193.105.97.0    - 193.105.101.255
	{ 0xc1696700, 0xc16974ff, REGISTRY_RIPENCC    }, // 193.105.103.0   - 193.105.116.255
	{ 0xc1697600, 0xc16978ff, REGISTRY_RIPENCC    }, // 193.105.118.0   - 193.105.120.255
	{ 0xc1697a00, 0xc1698cff, REGISTRY_RIPENCC    }, // 193.105.122.0   - 193.105.140.255
	{ 0xc1698e00, 0xc16996ff, REGISTRY_RIPENCC    }, // 193.105.142.0   - 193.105.150.255
	{ 0xc1699800, 0xc16999ff, REGISTRY_RIPENCC    }, // 193.105.152.0   - 193.105.153.255
	{ 0xc1699b00, 0xc169a1ff, REGISTRY_RIPENCC    }, // 193.105.155.0   - 193.105.161.255
	{ 0xc169a300, 0xc169a4ff, REGISTRY_RIPENCC    }, // 193.105.163.0   - 193.105.164.255
	{ 0xc169a600, 0xc169b0ff, REGISTRY_RIPENCC    }, // 193.105.166.0   - 193.105.176.255
	{ 0xc169b200, 0xc169b7ff, REGISTRY_RIPENCC    }, // 193.105.178.0   - 193.105.183.255
	{ 0xc169b900, 0xc169bbff, REGISTRY_RIPENCC    }, // 193.105.185.0   - 193.105.187.255
	{ 0xc169bc00, 0xc169bcff, REGISTRY_RIPENCC    }, // 193.105.188.0   - 193.105.188.255
	{ 0xc169bd00, 0xc169ceff, REGISTRY_RIPENCC    }, // 193.105.189.0   - 193.105.206.255
	{ 0xc169d100, 0xc169d8ff, REGISTRY_RIPENCC    }, // 193.105.209.0   - 193.105.216.255
	{ 0xc169da00, 0xc169f3ff, REGISTRY_RIPENCC    }, // 193.105.218.0   - 193.105.243.255
	{ 0xc169f600, 0xc169f9ff, REGISTRY_RIPENCC    }, // 193.105.246.0   - 193.105.249.255
	{ 0xc169fb00, 0xc16a13ff, REGISTRY_RIPENCC    }, // 193.105.251.0   - 193.106.19.255
	{ 0xc16a1400, 0xc16a17ff, REGISTRY_RIPENCC    }, // 193.106.20.0    - 193.106.23.255
	{ 0xc16a1800, 0xc16a1fff, REGISTRY_RIPENCC    }, // 193.106.24.0    - 193.106.31.255
	{ 0xc16a2000, 0xc16a23ff, REGISTRY_RIPENCC    }, // 193.106.32.0    - 193.106.35.255
	{ 0xc16a2400, 0xc16aeeff, REGISTRY_RIPENCC    }, // 193.106.36.0    - 193.106.238.255
	{ 0xc16af000, 0xc16b4bff, REGISTRY_RIPENCC    }, // 193.106.240.0   - 193.107.75.255
	{ 0xc16b4c00, 0xc16b4fff, REGISTRY_RIPENCC    }, // 193.107.76.0    - 193.107.79.255
	{ 0xc16b5000, 0xc16b53ff, REGISTRY_RIPENCC    }, // 193.107.80.0    - 193.107.83.255
	{ 0xc16b5400, 0xc16b57ff, REGISTRY_RIPENCC    }, // 193.107.84.0    - 193.107.87.255
	{ 0xc16b5800, 0xc16bb7ff, REGISTRY_RIPENCC    }, // 193.107.88.0    - 193.107.183.255
	{ 0xc16bb800, 0xc16bbbff, REGISTRY_RIPENCC    }, // 193.107.184.0   - 193.107.187.255
	{ 0xc16bbc00, 0xc16bc3ff, REGISTRY_RIPENCC    }, // 193.107.188.0   - 193.107.195.255
	{ 0xc16bc400, 0xc16bc7ff, REGISTRY_RIPENCC    }, // 193.107.196.0   - 193.107.199.255
	{ 0xc16bc800, 0xc16bcfff, REGISTRY_RIPENCC    }, // 193.107.200.0   - 193.107.207.255
	{ 0xc16bd000, 0xc16bd3ff, REGISTRY_RIPENCC    }, // 193.107.208.0   - 193.107.211.255
	{ 0xc16bd400, 0xc16bd7ff, REGISTRY_RIPENCC    }, // 193.107.212.0   - 193.107.215.255
	{ 0xc16bd800, 0xc16bdbff, REGISTRY_RIPENCC    }, // 193.107.216.0   - 193.107.219.255
	{ 0xc16bdc00, 0xc16c13ff, REGISTRY_RIPENCC    }, // 193.107.220.0   - 193.108.19.255
	{ 0xc16c1500, 0xc16c16ff, REGISTRY_RIPENCC    }, // 193.108.21.0    - 193.108.22.255
	{ 0xc16c1700, 0xc16c17ff, REGISTRY_AFRINIC    }, // 193.108.23.0    - 193.108.23.255
	{ 0xc16c1800, 0xc16c18ff, REGISTRY_RIPENCC    }, // 193.108.24.0    - 193.108.24.255
	{ 0xc16c1b00, 0xc16c1bff, REGISTRY_RIPENCC    }, // 193.108.27.0    - 193.108.27.255
	{ 0xc16c1c00, 0xc16c1cff, REGISTRY_AFRINIC    }, // 193.108.28.0    - 193.108.28.255
	{ 0xc16c1d00, 0xc16c29ff, REGISTRY_RIPENCC    }, // 193.108.29.0    - 193.108.41.255
	{ 0xc16c2a00, 0xc16c2bff, REGISTRY_RIPENCC    }, // 193.108.42.0    - 193.108.43.255
	{ 0xc16c2c00, 0xc16c2dff, REGISTRY_RIPENCC    }, // 193.108.44.0    - 193.108.45.255
	{ 0xc16c3000, 0xc16c3fff, REGISTRY_RIPENCC    }, // 193.108.48.0    - 193.108.63.255
	{ 0xc16c4000, 0xc16c47ff, REGISTRY_RIPENCC    }, // 193.108.64.0    - 193.108.71.255
	{ 0xc16c4800, 0xc16c5fff, REGISTRY_RIPENCC    }, // 193.108.72.0    - 193.108.95.255
	{ 0xc16c6200, 0xc16c6fff, REGISTRY_RIPENCC    }, // 193.108.98.0    - 193.108.111.255
	{ 0xc16c7000, 0xc16c73ff, REGISTRY_RIPENCC    }, // 193.108.112.0   - 193.108.115.255
	{ 0xc16c7400, 0xc16c8fff, REGISTRY_RIPENCC    }, // 193.108.116.0   - 193.108.143.255
	{ 0xc16c9000, 0xc16c93ff, REGISTRY_RIPENCC    }, // 193.108.144.0   - 193.108.147.255
	{ 0xc16c9400, 0xc16cb1ff, REGISTRY_RIPENCC    }, // 193.108.148.0   - 193.108.177.255
	{ 0xc16cb300, 0xc16cb6ff, REGISTRY_RIPENCC    }, // 193.108.179.0   - 193.108.182.255
	{ 0xc16cb800, 0xc16cb8ff, REGISTRY_RIPENCC    }, // 193.108.184.0   - 193.108.184.255
	{ 0xc16cb900, 0xc16cb9ff, REGISTRY_RIPENCC    }, // 193.108.185.0   - 193.108.185.255
	{ 0xc16cba00, 0xc16cc0ff, REGISTRY_RIPENCC    }, // 193.108.186.0   - 193.108.192.255
	{ 0xc16cc100, 0xc16cc1ff, REGISTRY_RIPENCC    }, // 193.108.193.0   - 193.108.193.255
	{ 0xc16cc200, 0xc16cc5ff, REGISTRY_RIPENCC    }, // 193.108.194.0   - 193.108.197.255
	{ 0xc16cc700, 0xc16ccdff, REGISTRY_RIPENCC    }, // 193.108.199.0   - 193.108.205.255
	{ 0xc16cd100, 0xc16cd2ff, REGISTRY_RIPENCC    }, // 193.108.209.0   - 193.108.210.255
	{ 0xc16cd400, 0xc16cd5ff, REGISTRY_RIPENCC    }, // 193.108.212.0   - 193.108.213.255
	{ 0xc16cd600, 0xc16cd6ff, REGISTRY_AFRINIC    }, // 193.108.214.0   - 193.108.214.255
	{ 0xc16cd800, 0xc16cdaff, REGISTRY_RIPENCC    }, // 193.108.216.0   - 193.108.218.255
	{ 0xc16cdc00, 0xc16ce5ff, REGISTRY_RIPENCC    }, // 193.108.220.0   - 193.108.229.255
	{ 0xc16ce800, 0xc16ce9ff, REGISTRY_RIPENCC    }, // 193.108.232.0   - 193.108.233.255
	{ 0xc16cec00, 0xc16cfbff, REGISTRY_RIPENCC    }, // 193.108.236.0   - 193.108.251.255
	{ 0xc16cfc00, 0xc16cffff, REGISTRY_AFRINIC    }, // 193.108.252.0   - 193.108.255.255
	{ 0xc16d0000, 0xc16d0bff, REGISTRY_RIPENCC    }, // 193.109.0.0     - 193.109.11.255
	{ 0xc16d0c00, 0xc16d0fff, REGISTRY_RIPENCC    }, // 193.109.12.0    - 193.109.15.255
	{ 0xc16d1000, 0xc16d1fff, REGISTRY_RIPENCC    }, // 193.109.16.0    - 193.109.31.255
	{ 0xc16d2000, 0xc16d27ff, REGISTRY_RIPENCC    }, // 193.109.32.0    - 193.109.39.255
	{ 0xc16d2800, 0xc16d3fff, REGISTRY_RIPENCC    }, // 193.109.40.0    - 193.109.63.255
	{ 0xc16d4200, 0xc16d43ff, REGISTRY_AFRINIC    }, // 193.109.66.0    - 193.109.67.255
	{ 0xc16d4400, 0xc16d4dff, REGISTRY_RIPENCC    }, // 193.109.68.0    - 193.109.77.255
	{ 0xc16d5000, 0xc16d50ff, REGISTRY_RIPENCC    }, // 193.109.80.0    - 193.109.80.255
	{ 0xc16d5100, 0xc16d51ff, REGISTRY_RIPENCC    }, // 193.109.81.0    - 193.109.81.255
	{ 0xc16d5200, 0xc16d53ff, REGISTRY_RIPENCC    }, // 193.109.82.0    - 193.109.83.255
	{ 0xc16d5600, 0xc16d5bff, REGISTRY_RIPENCC    }, // 193.109.86.0    - 193.109.91.255
	{ 0xc16d5d00, 0xc16d5dff, REGISTRY_RIPENCC    }, // 193.109.93.0    - 193.109.93.255
	{ 0xc16d5f00, 0xc16d63ff, REGISTRY_RIPENCC    }, // 193.109.95.0    - 193.109.99.255
	{ 0xc16d6400, 0xc16d67ff, REGISTRY_RIPENCC    }, // 193.109.100.0   - 193.109.103.255
	{ 0xc16d6800, 0xc16d6bff, REGISTRY_RIPENCC    }, // 193.109.104.0   - 193.109.107.255
	{ 0xc16d6c00, 0xc16d6fff, REGISTRY_RIPENCC    }, // 193.109.108.0   - 193.109.111.255
	{ 0xc16d7000, 0xc16d77ff, REGISTRY_RIPENCC    }, // 193.109.112.0   - 193.109.119.255
	{ 0xc16d7900, 0xc16d87ff, REGISTRY_RIPENCC    }, // 193.109.121.0   - 193.109.135.255
	{ 0xc16d8a00, 0xc16da7ff, REGISTRY_RIPENCC    }, // 193.109.138.0   - 193.109.167.255
	{ 0xc16da800, 0xc16dabff, REGISTRY_RIPENCC    }, // 193.109.168.0   - 193.109.171.255
	{ 0xc16dac00, 0xc16dd4ff, REGISTRY_RIPENCC    }, // 193.109.172.0   - 193.109.212.255
	{ 0xc16dd600, 0xc16dd8ff, REGISTRY_RIPENCC    }, // 193.109.214.0   - 193.109.216.255
	{ 0xc16dda00, 0xc16ddaff, REGISTRY_RIPENCC    }, // 193.109.218.0   - 193.109.218.255
	{ 0xc16ddc00, 0xc16ddcff, REGISTRY_RIPENCC    }, // 193.109.220.0   - 193.109.220.255
	{ 0xc16dde00, 0xc16ddfff, REGISTRY_RIPENCC    }, // 193.109.222.0   - 193.109.223.255
	{ 0xc16de100, 0xc16de1ff, REGISTRY_RIPENCC    }, // 193.109.225.0   - 193.109.225.255
	{ 0xc16de300, 0xc16de5ff, REGISTRY_RIPENCC    }, // 193.109.227.0   - 193.109.229.255
	{ 0xc16de700, 0xc16dffff, REGISTRY_RIPENCC    }, // 193.109.231.0   - 193.109.255.255
	{ 0xc16e0000, 0xc16e03ff, REGISTRY_RIPENCC    }, // 193.110.0.0     - 193.110.3.255
	{ 0xc16e0600, 0xc16e1bff, REGISTRY_RIPENCC    }, // 193.110.6.0     - 193.110.27.255
	{ 0xc16e1c00, 0xc16e1fff, REGISTRY_RIPENCC    }, // 193.110.28.0    - 193.110.31.255
	{ 0xc16e2000, 0xc16e27ff, REGISTRY_RIPENCC    }, // 193.110.32.0    - 193.110.39.255
	{ 0xc16e2800, 0xc16e2fff, REGISTRY_RIPENCC    }, // 193.110.40.0    - 193.110.47.255
	{ 0xc16e3000, 0xc16e47ff, REGISTRY_RIPENCC    }, // 193.110.48.0    - 193.110.71.255
	{ 0xc16e4800, 0xc16e4bff, REGISTRY_RIPENCC    }, // 193.110.72.0    - 193.110.75.255
	{ 0xc16e4c00, 0xc16e51ff, REGISTRY_RIPENCC    }, // 193.110.76.0    - 193.110.81.255
	{ 0xc16e5300, 0xc16e5cff, REGISTRY_RIPENCC    }, // 193.110.83.0    - 193.110.92.255
	{ 0xc16e5e00, 0xc16e67ff, REGISTRY_RIPENCC    }, // 193.110.94.0    - 193.110.103.255
	{ 0xc16e6800, 0xc16e69ff, REGISTRY_AFRINIC    }, // 193.110.104.0   - 193.110.105.255
	{ 0xc16e6a00, 0xc16e82ff, REGISTRY_RIPENCC    }, // 193.110.106.0   - 193.110.130.255
	{ 0xc16e8400, 0xc16e85ff, REGISTRY_RIPENCC    }, // 193.110.132.0   - 193.110.133.255
	{ 0xc16e8900, 0xc16e8bff, REGISTRY_RIPENCC    }, // 193.110.137.0   - 193.110.139.255
	{ 0xc16e8c00, 0xc16e8cff, REGISTRY_RIPENCC    }, // 193.110.140.0   - 193.110.140.255
	{ 0xc16e8e00, 0xc16e8eff, REGISTRY_RIPENCC    }, // 193.110.142.0   - 193.110.142.255
	{ 0xc16e9000, 0xc16e93ff, REGISTRY_RIPENCC    }, // 193.110.144.0   - 193.110.147.255
	{ 0xc16e9500, 0xc16e9dff, REGISTRY_RIPENCC    }, // 193.110.149.0   - 193.110.157.255
	{ 0xc16e9f00, 0xc16e9fff, REGISTRY_RIPENCC    }, // 193.110.159.0   - 193.110.159.255
	{ 0xc16ea200, 0xc16ec7ff, REGISTRY_RIPENCC    }, // 193.110.162.0   - 193.110.199.255
	{ 0xc16ec800, 0xc16ecbff, REGISTRY_RIPENCC    }, // 193.110.200.0   - 193.110.203.255
	{ 0xc16ecc00, 0xc16effff, REGISTRY_RIPENCC    }, // 193.110.204.0   - 193.110.255.255
	{ 0xc16f0000, 0xc16f01ff, REGISTRY_RIPENCC    }, // 193.111.0.0     - 193.111.1.255
	{ 0xc16f0200, 0xc16f03ff, REGISTRY_RIPENCC    }, // 193.111.2.0     - 193.111.3.255
	{ 0xc16f0600, 0xc16f11ff, REGISTRY_RIPENCC    }, // 193.111.6.0     - 193.111.17.255
	{ 0xc16f1400, 0xc16f15ff, REGISTRY_RIPENCC    }, // 193.111.20.0    - 193.111.21.255
	{ 0xc16f1600, 0xc16f17ff, REGISTRY_RIPENCC    }, // 193.111.22.0    - 193.111.23.255
	{ 0xc16f1800, 0xc16f1dff, REGISTRY_RIPENCC    }, // 193.111.24.0    - 193.111.29.255
	{ 0xc16f2100, 0xc16f23ff, REGISTRY_RIPENCC    }, // 193.111.33.0    - 193.111.35.255
	{ 0xc16f2400, 0xc16f26ff, REGISTRY_RIPENCC    }, // 193.111.36.0    - 193.111.38.255
	{ 0xc16f2700, 0xc16f2cff, REGISTRY_RIPENCC    }, // 193.111.39.0    - 193.111.44.255
	{ 0xc16f2e00, 0xc16f2fff, REGISTRY_RIPENCC    }, // 193.111.46.0    - 193.111.47.255
	{ 0xc16f3000, 0xc16f37ff, REGISTRY_RIPENCC    }, // 193.111.48.0    - 193.111.55.255
	{ 0xc16f3800, 0xc16f4bff, REGISTRY_RIPENCC    }, // 193.111.56.0    - 193.111.75.255
	{ 0xc16f4c00, 0xc16f4fff, REGISTRY_RIPENCC    }, // 193.111.76.0    - 193.111.79.255
	{ 0xc16f5100, 0xc16f55ff, REGISTRY_RIPENCC    }, // 193.111.81.0    - 193.111.85.255
	{ 0xc16f5700, 0xc16f57ff, REGISTRY_RIPENCC    }, // 193.111.87.0    - 193.111.87.255
	{ 0xc16f5900, 0xc16f59ff, REGISTRY_RIPENCC    }, // 193.111.89.0    - 193.111.89.255
	{ 0xc16f5c00, 0xc16f73ff, REGISTRY_RIPENCC    }, // 193.111.92.0    - 193.111.115.255
	{ 0xc16f7600, 0xc16f7bff, REGISTRY_RIPENCC    }, // 193.111.118.0   - 193.111.123.255
	{ 0xc16f7e00, 0xc16f87ff, REGISTRY_RIPENCC    }, // 193.111.126.0   - 193.111.135.255
	{ 0xc16f9000, 0xc16f93ff, REGISTRY_RIPENCC    }, // 193.111.144.0   - 193.111.147.255
	{ 0xc16f9400, 0xc16f9bff, REGISTRY_RIPENCC    }, // 193.111.148.0   - 193.111.155.255
	{ 0xc16f9c00, 0xc16f9fff, REGISTRY_RIPENCC    }, // 193.111.156.0   - 193.111.159.255
	{ 0xc16fa100, 0xc16fa7ff, REGISTRY_RIPENCC    }, // 193.111.161.0   - 193.111.167.255
	{ 0xc16fa900, 0xc16fa9ff, REGISTRY_RIPENCC    }, // 193.111.169.0   - 193.111.169.255
	{ 0xc16fac00, 0xc16fadff, REGISTRY_RIPENCC    }, // 193.111.172.0   - 193.111.173.255
	{ 0xc16faf00, 0xc16fb3ff, REGISTRY_RIPENCC    }, // 193.111.175.0   - 193.111.179.255
	{ 0xc16fb400, 0xc16fb7ff, REGISTRY_RIPENCC    }, // 193.111.180.0   - 193.111.183.255
	{ 0xc16fbc00, 0xc16fc3ff, REGISTRY_RIPENCC    }, // 193.111.188.0   - 193.111.195.255
	{ 0xc16fc600, 0xc16fe1ff, REGISTRY_RIPENCC    }, // 193.111.198.0   - 193.111.225.255
	{ 0xc16fe300, 0xc16fe4ff, REGISTRY_RIPENCC    }, // 193.111.227.0   - 193.111.228.255
	{ 0xc16fe600, 0xc16fe8ff, REGISTRY_RIPENCC    }, // 193.111.230.0   - 193.111.232.255
	{ 0xc16fec00, 0xc16ff3ff, REGISTRY_RIPENCC    }, // 193.111.236.0   - 193.111.243.255
	{ 0xc16ff400, 0xc16ffbff, REGISTRY_RIPENCC    }, // 193.111.244.0   - 193.111.251.255
	{ 0xc16ffc00, 0xc16fffff, REGISTRY_RIPENCC    }, // 193.111.252.0   - 193.111.255.255
	{ 0xc1700000, 0xc170ffff, REGISTRY_APNIC      }, // 193.112.0.0     - 193.112.255.255
	{ 0xc1710000, 0xc171ffff, REGISTRY_RIPENCC    }, // 193.113.0.0     - 193.113.255.255
	{ 0xc1720000, 0xc1721fff, REGISTRY_APNIC      }, // 193.114.0.0     - 193.114.31.255
	{ 0xc1722000, 0xc1725fff, REGISTRY_RIPENCC    }, // 193.114.32.0    - 193.114.95.255
	{ 0xc1726000, 0xc1729fff, REGISTRY_APNIC      }, // 193.114.96.0    - 193.114.159.255
	{ 0xc172a000, 0xc1731fff, REGISTRY_RIPENCC    }, // 193.114.160.0   - 193.115.31.255
	{ 0xc1732000, 0xc1737fff, REGISTRY_APNIC      }, // 193.115.32.0    - 193.115.127.255
	{ 0xc1738000, 0xc1741fff, REGISTRY_RIPENCC    }, // 193.115.128.0   - 193.116.31.255
	{ 0xc1742000, 0xc1747fff, REGISTRY_APNIC      }, // 193.116.32.0    - 193.116.127.255
	{ 0xc1748000, 0xc174bfff, REGISTRY_RIPENCC    }, // 193.116.128.0   - 193.116.191.255
	{ 0xc174c000, 0xc174ffff, REGISTRY_APNIC      }, // 193.116.192.0   - 193.116.255.255
	{ 0xc1750000, 0xc1753fff, REGISTRY_RIPENCC    }, // 193.117.0.0     - 193.117.63.255
	{ 0xc1754000, 0xc1755fff, REGISTRY_APNIC      }, // 193.117.64.0    - 193.117.95.255
	{ 0xc1756000, 0xc176ffff, REGISTRY_RIPENCC    }, // 193.117.96.0    - 193.118.255.255
	{ 0xc1770000, 0xc1777fff, REGISTRY_APNIC      }, // 193.119.0.0     - 193.119.127.255
	{ 0xc1778000, 0xc179ffff, REGISTRY_RIPENCC    }, // 193.119.128.0   - 193.121.255.255
	{ 0xc17a0000, 0xc17bffff, REGISTRY_ARIN       }, // 193.122.0.0     - 193.123.255.255
	{ 0xc17c0000, 0xc18006ff, REGISTRY_RIPENCC    }, // 193.124.0.0     - 193.128.6.255
	{ 0xc1800700, 0xc18007ff, REGISTRY_RIPENCC    }, // 193.128.7.0     - 193.128.7.255
	{ 0xc1800800, 0xc1801eff, REGISTRY_RIPENCC    }, // 193.128.8.0     - 193.128.30.255
	{ 0xc1801f00, 0xc1801fff, REGISTRY_RIPENCC    }, // 193.128.31.0    - 193.128.31.255
	{ 0xc1802000, 0xc1804bff, REGISTRY_RIPENCC    }, // 193.128.32.0    - 193.128.75.255
	{ 0xc1804c00, 0xc1804cff, REGISTRY_RIPENCC    }, // 193.128.76.0    - 193.128.76.255
	{ 0xc1804d00, 0xc180bfff, REGISTRY_RIPENCC    }, // 193.128.77.0    - 193.128.191.255
	{ 0xc180c000, 0xc180cfff, REGISTRY_RIPENCC    }, // 193.128.192.0   - 193.128.207.255
	{ 0xc180d000, 0xc18227ff, REGISTRY_RIPENCC    }, // 193.128.208.0   - 193.130.39.255
	{ 0xc1822800, 0xc18229ff, REGISTRY_RIPENCC    }, // 193.130.40.0    - 193.130.41.255
	{ 0xc1822a00, 0xc182bfff, REGISTRY_RIPENCC    }, // 193.130.42.0    - 193.130.191.255
	{ 0xc182c000, 0xc182dfff, REGISTRY_RIPENCC    }, // 193.130.192.0   - 193.130.223.255
	{ 0xc182e000, 0xc18371ff, REGISTRY_RIPENCC    }, // 193.130.224.0   - 193.131.113.255
	{ 0xc1837200, 0xc18373ff, REGISTRY_RIPENCC    }, // 193.131.114.0   - 193.131.115.255
	{ 0xc1837400, 0xc18473ff, REGISTRY_RIPENCC    }, // 193.131.116.0   - 193.132.115.255
	{ 0xc1847400, 0xc18477ff, REGISTRY_RIPENCC    }, // 193.132.116.0   - 193.132.119.255
	{ 0xc1847800, 0xc1851bff, REGISTRY_RIPENCC    }, // 193.132.120.0   - 193.133.27.255
	{ 0xc1851c00, 0xc1851dff, REGISTRY_RIPENCC    }, // 193.133.28.0    - 193.133.29.255
	{ 0xc1851e00, 0xc185ffff, REGISTRY_RIPENCC    }, // 193.133.30.0    - 193.133.255.255
	{ 0xc1860000, 0xc18603ff, REGISTRY_RIPENCC    }, // 193.134.0.0     - 193.134.3.255
	{ 0xc1860400, 0xc18607ff, REGISTRY_RIPENCC    }, // 193.134.4.0     - 193.134.7.255
	{ 0xc1860800, 0xc18623ff, REGISTRY_RIPENCC    }, // 193.134.8.0     - 193.134.35.255
	{ 0xc1862400, 0xc1863fff, REGISTRY_RIPENCC    }, // 193.134.36.0    - 193.134.63.255
	{ 0xc1864000, 0xc18657ff, REGISTRY_RIPENCC    }, // 193.134.64.0    - 193.134.87.255
	{ 0xc1865800, 0xc1865bff, REGISTRY_RIPENCC    }, // 193.134.88.0    - 193.134.91.255
	{ 0xc1865c00, 0xc1865cff, REGISTRY_RIPENCC    }, // 193.134.92.0    - 193.134.92.255
	{ 0xc1865e00, 0xc1865fff, REGISTRY_RIPENCC    }, // 193.134.94.0    - 193.134.95.255
	{ 0xc1866000, 0xc18663ff, REGISTRY_RIPENCC    }, // 193.134.96.0    - 193.134.99.255
	{ 0xc1866600, 0xc186cfff, REGISTRY_RIPENCC    }, // 193.134.102.0   - 193.134.207.255
	{ 0xc186d800, 0xc186f7ff, REGISTRY_RIPENCC    }, // 193.134.216.0   - 193.134.247.255
	{ 0xc186f800, 0xc186f9ff, REGISTRY_RIPENCC    }, // 193.134.248.0   - 193.134.249.255
	{ 0xc186fb00, 0xc186fcff, REGISTRY_RIPENCC    }, // 193.134.251.0   - 193.134.252.255
	{ 0xc186fe00, 0xc186feff, REGISTRY_RIPENCC    }, // 193.134.254.0   - 193.134.254.255
	{ 0xc186ff00, 0xc18703ff, REGISTRY_RIPENCC    }, // 193.134.255.0   - 193.135.3.255
	{ 0xc1870400, 0xc18707ff, REGISTRY_RIPENCC    }, // 193.135.4.0     - 193.135.7.255
	{ 0xc1870800, 0xc1870bff, REGISTRY_RIPENCC    }, // 193.135.8.0     - 193.135.11.255
	{ 0xc1870e00, 0xc1870eff, REGISTRY_RIPENCC    }, // 193.135.14.0    - 193.135.14.255
	{ 0xc1871000, 0xc18713ff, REGISTRY_RIPENCC    }, // 193.135.16.0    - 193.135.19.255
	{ 0xc1871400, 0xc18715ff, REGISTRY_RIPENCC    }, // 193.135.20.0    - 193.135.21.255
	{ 0xc1871600, 0xc18717ff, REGISTRY_RIPENCC    }, // 193.135.22.0    - 193.135.23.255
	{ 0xc1871900, 0xc18719ff, REGISTRY_RIPENCC    }, // 193.135.25.0    - 193.135.25.255
	{ 0xc1871a00, 0xc1871bff, REGISTRY_RIPENCC    }, // 193.135.26.0    - 193.135.27.255
	{ 0xc1871c00, 0xc18763ff, REGISTRY_RIPENCC    }, // 193.135.28.0    - 193.135.99.255
	{ 0xc1876400, 0xc18764ff, REGISTRY_RIPENCC    }, // 193.135.100.0   - 193.135.100.255
	{ 0xc1876600, 0xc1876dff, REGISTRY_RIPENCC    }, // 193.135.102.0   - 193.135.109.255
	{ 0xc1876e00, 0xc18785ff, REGISTRY_RIPENCC    }, // 193.135.110.0   - 193.135.133.255
	{ 0xc1878800, 0xc18788ff, REGISTRY_RIPENCC    }, // 193.135.136.0   - 193.135.136.255
	{ 0xc1878a00, 0xc1878aff, REGISTRY_RIPENCC    }, // 193.135.138.0   - 193.135.138.255
	{ 0xc1878b00, 0xc18791ff, REGISTRY_RIPENCC    }, // 193.135.139.0   - 193.135.145.255
	{ 0xc1879200, 0xc18793ff, REGISTRY_RIPENCC    }, // 193.135.146.0   - 193.135.147.255
	{ 0xc1879400, 0xc18795ff, REGISTRY_RIPENCC    }, // 193.135.148.0   - 193.135.149.255
	{ 0xc1879600, 0xc18796ff, REGISTRY_RIPENCC    }, // 193.135.150.0   - 193.135.150.255
	{ 0xc1879800, 0xc18799ff, REGISTRY_RIPENCC    }, // 193.135.152.0   - 193.135.153.255
	{ 0xc1879a00, 0xc1879bff, REGISTRY_RIPENCC    }, // 193.135.154.0   - 193.135.155.255
	{ 0xc1879c00, 0xc1879cff, REGISTRY_RIPENCC    }, // 193.135.156.0   - 193.135.156.255
	{ 0xc1879e00, 0xc187a1ff, REGISTRY_RIPENCC    }, // 193.135.158.0   - 193.135.161.255
	{ 0xc187a200, 0xc187acff, REGISTRY_RIPENCC    }, // 193.135.162.0   - 193.135.172.255
	{ 0xc187ad00, 0xc187adff, REGISTRY_RIPENCC    }, // 193.135.173.0   - 193.135.173.255
	{ 0xc187af00, 0xc187d5ff, REGISTRY_RIPENCC    }, // 193.135.175.0   - 193.135.213.255
	{ 0xc187d600, 0xc187d7ff, REGISTRY_RIPENCC    }, // 193.135.214.0   - 193.135.215.255
	{ 0xc187d800, 0xc187d9ff, REGISTRY_RIPENCC    }, // 193.135.216.0   - 193.135.217.255
	{ 0xc187da00, 0xc187daff, REGISTRY_RIPENCC    }, // 193.135.218.0   - 193.135.218.255
	{ 0xc187db00, 0xc187dbff, REGISTRY_RIPENCC    }, // 193.135.219.0   - 193.135.219.255
	{ 0xc187dc00, 0xc187efff, REGISTRY_RIPENCC    }, // 193.135.220.0   - 193.135.239.255
	{ 0xc187f000, 0xc187f7ff, REGISTRY_RIPENCC    }, // 193.135.240.0   - 193.135.247.255
	{ 0xc187f800, 0xc187fbff, REGISTRY_RIPENCC    }, // 193.135.248.0   - 193.135.251.255
	{ 0xc187fc00, 0xc187feff, REGISTRY_RIPENCC    }, // 193.135.252.0   - 193.135.254.255
	{ 0xc187ff00, 0xc189ffff, REGISTRY_RIPENCC    }, // 193.135.255.0   - 193.137.255.255
	{ 0xc18a0000, 0xc18a03ff, REGISTRY_RIPENCC    }, // 193.138.0.0     - 193.138.3.255
	{ 0xc18a0600, 0xc18a1bff, REGISTRY_RIPENCC    }, // 193.138.6.0     - 193.138.27.255
	{ 0xc18a1d00, 0xc18a1fff, REGISTRY_RIPENCC    }, // 193.138.29.0    - 193.138.31.255
	{ 0xc18a2000, 0xc18a3fff, REGISTRY_RIPENCC    }, // 193.138.32.0    - 193.138.63.255
	{ 0xc18a4000, 0xc18a47ff, REGISTRY_RIPENCC    }, // 193.138.64.0    - 193.138.71.255
	{ 0xc18a4900, 0xc18a49ff, REGISTRY_RIPENCC    }, // 193.138.73.0    - 193.138.73.255
	{ 0xc18a4a00, 0xc18a4aff, REGISTRY_RIPENCC    }, // 193.138.74.0    - 193.138.74.255
	{ 0xc18a4c00, 0xc18a50ff, REGISTRY_RIPENCC    }, // 193.138.76.0    - 193.138.80.255
	{ 0xc18a5100, 0xc18a51ff, REGISTRY_RIPENCC    }, // 193.138.81.0    - 193.138.81.255
	{ 0xc18a5200, 0xc18a52ff, REGISTRY_RIPENCC    }, // 193.138.82.0    - 193.138.82.255
	{ 0xc18a5300, 0xc18a53ff, REGISTRY_RIPENCC    }, // 193.138.83.0    - 193.138.83.255
	{ 0xc18a5400, 0xc18a54ff, REGISTRY_RIPENCC    }, // 193.138.84.0    - 193.138.84.255
	{ 0xc18a5600, 0xc18a5fff, REGISTRY_RIPENCC    }, // 193.138.86.0    - 193.138.95.255
	{ 0xc18a6000, 0xc18a60ff, REGISTRY_RIPENCC    }, // 193.138.96.0    - 193.138.96.255
	{ 0xc18a6100, 0xc18a63ff, REGISTRY_RIPENCC    }, // 193.138.97.0    - 193.138.99.255
	{ 0xc18a6400, 0xc18a64ff, REGISTRY_RIPENCC    }, // 193.138.100.0   - 193.138.100.255
	{ 0xc18a6500, 0xc18a6eff, REGISTRY_RIPENCC    }, // 193.138.101.0   - 193.138.110.255
	{ 0xc18a7000, 0xc18a77ff, REGISTRY_RIPENCC    }, // 193.138.112.0   - 193.138.119.255
	{ 0xc18a7b00, 0xc18a8fff, REGISTRY_RIPENCC    }, // 193.138.123.0   - 193.138.143.255
	{ 0xc18a9000, 0xc18a93ff, REGISTRY_RIPENCC    }, // 193.138.144.0   - 193.138.147.255
	{ 0xc18a9400, 0xc18aa7ff, REGISTRY_RIPENCC    }, // 193.138.148.0   - 193.138.167.255
	{ 0xc18aa800, 0xc18aafff, REGISTRY_RIPENCC    }, // 193.138.168.0   - 193.138.175.255
	{ 0xc18ab000, 0xc18afbff, REGISTRY_RIPENCC    }, // 193.138.176.0   - 193.138.251.255
	{ 0xc18afc00, 0xc18d02ff, REGISTRY_RIPENCC    }, // 193.138.252.0   - 193.141.2.255
	{ 0xc18d0300, 0xc18d03ff, REGISTRY_RIPENCC    }, // 193.141.3.0     - 193.141.3.255
	{ 0xc18d0400, 0xc18d13ff, REGISTRY_RIPENCC    }, // 193.141.4.0     - 193.141.19.255
	{ 0xc18d1400, 0xc18d14ff, REGISTRY_RIPENCC    }, // 193.141.20.0    - 193.141.20.255
	{ 0xc18d1500, 0xc18d16ff, REGISTRY_RIPENCC    }, // 193.141.21.0    - 193.141.22.255
	{ 0xc18d1700, 0xc18d18ff, REGISTRY_RIPENCC    }, // 193.141.23.0    - 193.141.24.255
	{ 0xc18d1900, 0xc18d1aff, REGISTRY_RIPENCC    }, // 193.141.25.0    - 193.141.26.255
	{ 0xc18d1b00, 0xc18d1bff, REGISTRY_RIPENCC    }, // 193.141.27.0    - 193.141.27.255
	{ 0xc18d1c00, 0xc18d34ff, REGISTRY_RIPENCC    }, // 193.141.28.0    - 193.141.52.255
	{ 0xc18d3600, 0xc18d36ff, REGISTRY_RIPENCC    }, // 193.141.54.0    - 193.141.54.255
	{ 0xc18d3700, 0xc18d37ff, REGISTRY_RIPENCC    }, // 193.141.55.0    - 193.141.55.255
	{ 0xc18d3800, 0xc18d38ff, REGISTRY_RIPENCC    }, // 193.141.56.0    - 193.141.56.255
	{ 0xc18d3900, 0xc18d3aff, REGISTRY_RIPENCC    }, // 193.141.57.0    - 193.141.58.255
	{ 0xc18d3b00, 0xc18d3bff, REGISTRY_RIPENCC    }, // 193.141.59.0    - 193.141.59.255
	{ 0xc18d3d00, 0xc18d3dff, REGISTRY_RIPENCC    }, // 193.141.61.0    - 193.141.61.255
	{ 0xc18d3e00, 0xc18d3fff, REGISTRY_RIPENCC    }, // 193.141.62.0    - 193.141.63.255
	{ 0xc18d4200, 0xc18d42ff, REGISTRY_RIPENCC    }, // 193.141.66.0    - 193.141.66.255
	{ 0xc18d4300, 0xc18d43ff, REGISTRY_RIPENCC    }, // 193.141.67.0    - 193.141.67.255
	{ 0xc18d4400, 0xc18d5aff, REGISTRY_RIPENCC    }, // 193.141.68.0    - 193.141.90.255
	{ 0xc18d5b00, 0xc18d5cff, REGISTRY_RIPENCC    }, // 193.141.91.0    - 193.141.92.255
	{ 0xc18d5d00, 0xc18d5fff, REGISTRY_RIPENCC    }, // 193.141.93.0    - 193.141.95.255
	{ 0xc18d6000, 0xc18d63ff, REGISTRY_RIPENCC    }, // 193.141.96.0    - 193.141.99.255
	{ 0xc18d6400, 0xc18d64ff, REGISTRY_RIPENCC    }, // 193.141.100.0   - 193.141.100.255
	{ 0xc18d6500, 0xc18d65ff, REGISTRY_RIPENCC    }, // 193.141.101.0   - 193.141.101.255
	{ 0xc18d6600, 0xc18d67ff, REGISTRY_RIPENCC    }, // 193.141.102.0   - 193.141.103.255
	{ 0xc18d6800, 0xc18d68ff, REGISTRY_RIPENCC    }, // 193.141.104.0   - 193.141.104.255
	{ 0xc18d6900, 0xc18d6aff, REGISTRY_RIPENCC    }, // 193.141.105.0   - 193.141.106.255
	{ 0xc18d6b00, 0xc18d6bff, REGISTRY_RIPENCC    }, // 193.141.107.0   - 193.141.107.255
	{ 0xc18d6c00, 0xc18d6cff, REGISTRY_RIPENCC    }, // 193.141.108.0   - 193.141.108.255
	{ 0xc18d6e00, 0xc18d6eff, REGISTRY_RIPENCC    }, // 193.141.110.0   - 193.141.110.255
	{ 0xc18d6f00, 0xc18d78ff, REGISTRY_RIPENCC    }, // 193.141.111.0   - 193.141.120.255
	{ 0xc18d7a00, 0xc18d7dff, REGISTRY_RIPENCC    }, // 193.141.122.0   - 193.141.125.255
	{ 0xc18d8000, 0xc18d8aff, REGISTRY_RIPENCC    }, // 193.141.128.0   - 193.141.138.255
	{ 0xc18d8b00, 0xc18d8bff, REGISTRY_RIPENCC    }, // 193.141.139.0   - 193.141.139.255
	{ 0xc18d8c00, 0xc18d8eff, REGISTRY_RIPENCC    }, // 193.141.140.0   - 193.141.142.255
	{ 0xc18d8f00, 0xc18d8fff, REGISTRY_RIPENCC    }, // 193.141.143.0   - 193.141.143.255
	{ 0xc18d9000, 0xc18dafff, REGISTRY_RIPENCC    }, // 193.141.144.0   - 193.141.175.255
	{ 0xc18db000, 0xc18db0ff, REGISTRY_RIPENCC    }, // 193.141.176.0   - 193.141.176.255
	{ 0xc18db200, 0xc18db3ff, REGISTRY_RIPENCC    }, // 193.141.178.0   - 193.141.179.255
	{ 0xc18db400, 0xc18db7ff, REGISTRY_RIPENCC    }, // 193.141.180.0   - 193.141.183.255
	{ 0xc18db800, 0xc18dbbff, REGISTRY_RIPENCC    }, // 193.141.184.0   - 193.141.187.255
	{ 0xc18dbc00, 0xc18dbcff, REGISTRY_RIPENCC    }, // 193.141.188.0   - 193.141.188.255
	{ 0xc18dbd00, 0xc18dbfff, REGISTRY_RIPENCC    }, // 193.141.189.0   - 193.141.191.255
	{ 0xc18dc000, 0xc18de2ff, REGISTRY_RIPENCC    }, // 193.141.192.0   - 193.141.226.255
	{ 0xc18de300, 0xc18de5ff, REGISTRY_RIPENCC    }, // 193.141.227.0   - 193.141.229.255
	{ 0xc18de800, 0xc18dffff, REGISTRY_RIPENCC    }, // 193.141.232.0   - 193.141.255.255
	{ 0xc18e0000, 0xc18e02ff, REGISTRY_RIPENCC    }, // 193.142.0.0     - 193.142.2.255
	{ 0xc18e0500, 0xc18e05ff, REGISTRY_RIPENCC    }, // 193.142.5.0     - 193.142.5.255
	{ 0xc18e0700, 0xc18e11ff, REGISTRY_RIPENCC    }, // 193.142.7.0     - 193.142.17.255
	{ 0xc18e1300, 0xc18e13ff, REGISTRY_RIPENCC    }, // 193.142.19.0    - 193.142.19.255
	{ 0xc18e1700, 0xc18e1aff, REGISTRY_RIPENCC    }, // 193.142.23.0    - 193.142.26.255
	{ 0xc18e1e00, 0xc18e1fff, REGISTRY_RIPENCC    }, // 193.142.30.0    - 193.142.31.255
	{ 0xc18e2000, 0xc18e2fff, REGISTRY_RIPENCC    }, // 193.142.32.0    - 193.142.47.255
	{ 0xc18e3200, 0xc18e33ff, REGISTRY_RIPENCC    }, // 193.142.50.0    - 193.142.51.255
	{ 0xc18e3500, 0xc18e35ff, REGISTRY_RIPENCC    }, // 193.142.53.0    - 193.142.53.255
	{ 0xc18e3700, 0xc18e39ff, REGISTRY_RIPENCC    }, // 193.142.55.0    - 193.142.57.255
	{ 0xc18e3d00, 0xc18e3eff, REGISTRY_RIPENCC    }, // 193.142.61.0    - 193.142.62.255
	{ 0xc18e4000, 0xc18e63ff, REGISTRY_RIPENCC    }, // 193.142.64.0    - 193.142.99.255
	{ 0xc18e6500, 0xc18e74ff, REGISTRY_RIPENCC    }, // 193.142.101.0   - 193.142.116.255
	{ 0xc18e7600, 0xc18e7dff, REGISTRY_RIPENCC    }, // 193.142.118.0   - 193.142.125.255
	{ 0xc18e7f00, 0xc18e7fff, REGISTRY_RIPENCC    }, // 193.142.127.0   - 193.142.127.255
	{ 0xc18e8000, 0xc18e87ff, REGISTRY_RIPENCC    }, // 193.142.128.0   - 193.142.135.255
	{ 0xc18e8800, 0xc18e8fff, REGISTRY_RIPENCC    }, // 193.142.136.0   - 193.142.143.255
	{ 0xc18e9100, 0xc18e91ff, REGISTRY_RIPENCC    }, // 193.142.145.0   - 193.142.145.255
	{ 0xc18e9500, 0xc18e97ff, REGISTRY_RIPENCC    }, // 193.142.149.0   - 193.142.151.255
	{ 0xc18e9900, 0xc18e99ff, REGISTRY_RIPENCC    }, // 193.142.153.0   - 193.142.153.255
	{ 0xc18e9d00, 0xc18ebbff, REGISTRY_RIPENCC    }, // 193.142.157.0   - 193.142.187.255
	{ 0xc18ebc00, 0xc18ecbff, REGISTRY_RIPENCC    }, // 193.142.188.0   - 193.142.203.255
	{ 0xc18ecc00, 0xc18eccff, REGISTRY_RIPENCC    }, // 193.142.204.0   - 193.142.204.255
	{ 0xc18ed000, 0xc18edeff, REGISTRY_RIPENCC    }, // 193.142.208.0   - 193.142.222.255
	{ 0xc18ee000, 0xc18ee7ff, REGISTRY_RIPENCC    }, // 193.142.224.0   - 193.142.231.255
	{ 0xc18eeb00, 0xc18ef0ff, REGISTRY_RIPENCC    }, // 193.142.235.0   - 193.142.240.255
	{ 0xc18ef300, 0xc18ef8ff, REGISTRY_RIPENCC    }, // 193.142.243.0   - 193.142.248.255
	{ 0xc18efa00, 0xc18efcff, REGISTRY_RIPENCC    }, // 193.142.250.0   - 193.142.252.255
	{ 0xc18f0000, 0xc18f00ff, REGISTRY_RIPENCC    }, // 193.143.0.0     - 193.143.0.255
	{ 0xc18f0400, 0xc18f05ff, REGISTRY_RIPENCC    }, // 193.143.4.0     - 193.143.5.255
	{ 0xc18f0800, 0xc18f0fff, REGISTRY_RIPENCC    }, // 193.143.8.0     - 193.143.15.255
	{ 0xc18f1300, 0xc18f13ff, REGISTRY_RIPENCC    }, // 193.143.19.0    - 193.143.19.255
	{ 0xc18f1400, 0xc18f1fff, REGISTRY_RIPENCC    }, // 193.143.20.0    - 193.143.31.255
	{ 0xc18f2000, 0xc18f3fff, REGISTRY_RIPENCC    }, // 193.143.32.0    - 193.143.63.255
	{ 0xc18f4000, 0xc18f43ff, REGISTRY_RIPENCC    }, // 193.143.64.0    - 193.143.67.255
	{ 0xc18f4600, 0xc18f47ff, REGISTRY_RIPENCC    }, // 193.143.70.0    - 193.143.71.255
	{ 0xc18f4900, 0xc18f49ff, REGISTRY_RIPENCC    }, // 193.143.73.0    - 193.143.73.255
	{ 0xc18f4a00, 0xc18f4aff, REGISTRY_RIPENCC    }, // 193.143.74.0    - 193.143.74.255
	{ 0xc18f4d00, 0xc18f4dff, REGISTRY_RIPENCC    }, // 193.143.77.0    - 193.143.77.255
	{ 0xc18f4f00, 0xc18f59ff, REGISTRY_RIPENCC    }, // 193.143.79.0    - 193.143.89.255
	{ 0xc18f5b00, 0xc18f5bff, REGISTRY_RIPENCC    }, // 193.143.91.0    - 193.143.91.255
	{ 0xc18f5c00, 0xc18f5cff, REGISTRY_RIPENCC    }, // 193.143.92.0    - 193.143.92.255
	{ 0xc18f5d00, 0xc18f5fff, REGISTRY_RIPENCC    }, // 193.143.93.0    - 193.143.95.255
	{ 0xc18f6300, 0xc18f7aff, REGISTRY_RIPENCC    }, // 193.143.99.0    - 193.143.122.255
	{ 0xc18f7c00, 0xc18fdfff, REGISTRY_RIPENCC    }, // 193.143.124.0   - 193.143.223.255
	{ 0xc18fe100, 0xc18fe2ff, REGISTRY_RIPENCC    }, // 193.143.225.0   - 193.143.226.255
	{ 0xc18fe400, 0xc18fe6ff, REGISTRY_RIPENCC    }, // 193.143.228.0   - 193.143.230.255
	{ 0xc18fe800, 0xc18ff7ff, REGISTRY_RIPENCC    }, // 193.143.232.0   - 193.143.247.255
	{ 0xc18ff900, 0xc18ff9ff, REGISTRY_RIPENCC    }, // 193.143.249.0   - 193.143.249.255
	{ 0xc18ffd00, 0xc18ffeff, REGISTRY_RIPENCC    }, // 193.143.253.0   - 193.143.254.255
	{ 0xc1900000, 0xc193ffff, REGISTRY_RIPENCC    }, // 193.144.0.0     - 193.147.255.255
	{ 0xc1940000, 0xc19400ff, REGISTRY_RIPENCC    }, // 193.148.0.0     - 193.148.0.255
	{ 0xc1940200, 0xc19404ff, REGISTRY_RIPENCC    }, // 193.148.2.0     - 193.148.4.255
	{ 0xc1940600, 0xc19407ff, REGISTRY_RIPENCC    }, // 193.148.6.0     - 193.148.7.255
	{ 0xc1940800, 0xc1940bff, REGISTRY_RIPENCC    }, // 193.148.8.0     - 193.148.11.255
	{ 0xc1940f00, 0xc1940fff, REGISTRY_RIPENCC    }, // 193.148.15.0    - 193.148.15.255
	{ 0xc1941000, 0xc19417ff, REGISTRY_RIPENCC    }, // 193.148.16.0    - 193.148.23.255
	{ 0xc1941800, 0xc19427ff, REGISTRY_RIPENCC    }, // 193.148.24.0    - 193.148.39.255
	{ 0xc1942800, 0xc1942bff, REGISTRY_RIPENCC    }, // 193.148.40.0    - 193.148.43.255
	{ 0xc1942c00, 0xc1942cff, REGISTRY_RIPENCC    }, // 193.148.44.0    - 193.148.44.255
	{ 0xc1942e00, 0xc1942eff, REGISTRY_RIPENCC    }, // 193.148.46.0    - 193.148.46.255
	{ 0xc1943000, 0xc1945fff, REGISTRY_RIPENCC    }, // 193.148.48.0    - 193.148.95.255
	{ 0xc1946000, 0xc1949fff, REGISTRY_RIPENCC    }, // 193.148.96.0    - 193.148.159.255
	{ 0xc194a000, 0xc194bfff, REGISTRY_RIPENCC    }, // 193.148.160.0   - 193.148.191.255
	{ 0xc194c000, 0xc194dfff, REGISTRY_RIPENCC    }, // 193.148.192.0   - 193.148.223.255
	{ 0xc194e000, 0xc194f3ff, REGISTRY_RIPENCC    }, // 193.148.224.0   - 193.148.243.255
	{ 0xc194f600, 0xc194f6ff, REGISTRY_RIPENCC    }, // 193.148.246.0   - 193.148.246.255
	{ 0xc194f800, 0xc194fbff, REGISTRY_RIPENCC    }, // 193.148.248.0   - 193.148.251.255
	{ 0xc194fe00, 0xc194feff, REGISTRY_RIPENCC    }, // 193.148.254.0   - 193.148.254.255
	{ 0xc1950000, 0xc19501ff, REGISTRY_RIPENCC    }, // 193.149.0.0     - 193.149.1.255
	{ 0xc1950400, 0xc1950fff, REGISTRY_RIPENCC    }, // 193.149.4.0     - 193.149.15.255
	{ 0xc1951000, 0xc1953fff, REGISTRY_RIPENCC    }, // 193.149.16.0    - 193.149.63.255
	{ 0xc1954000, 0xc1955fff, REGISTRY_RIPENCC    }, // 193.149.64.0    - 193.149.95.255
	{ 0xc1956000, 0xc1957fff, REGISTRY_RIPENCC    }, // 193.149.96.0    - 193.149.127.255
	{ 0xc1958000, 0xc195bfff, REGISTRY_RIPENCC    }, // 193.149.128.0   - 193.149.191.255
	{ 0xc195c000, 0xc195d8ff, REGISTRY_RIPENCC    }, // 193.149.192.0   - 193.149.216.255
	{ 0xc195d900, 0xc195d9ff, REGISTRY_RIPENCC    }, // 193.149.217.0   - 193.149.217.255
	{ 0xc195da00, 0xc195e0ff, REGISTRY_RIPENCC    }, // 193.149.218.0   - 193.149.224.255
	{ 0xc195e200, 0xc195efff, REGISTRY_RIPENCC    }, // 193.149.226.0   - 193.149.239.255
	{ 0xc195f000, 0xc19661ff, REGISTRY_RIPENCC    }, // 193.149.240.0   - 193.150.97.255
	{ 0xc1966400, 0xc19677ff, REGISTRY_RIPENCC    }, // 193.150.100.0   - 193.150.119.255
	{ 0xc1967900, 0xc196a7ff, REGISTRY_RIPENCC    }, // 193.150.121.0   - 193.150.167.255
	{ 0xc196a900, 0xc196a9ff, REGISTRY_RIPENCC    }, // 193.150.169.0   - 193.150.169.255
	{ 0xc196ac00, 0xc196bfff, REGISTRY_RIPENCC    }, // 193.150.172.0   - 193.150.191.255
	{ 0xc196c000, 0xc196ffff, REGISTRY_RIPENCC    }, // 193.150.192.0   - 193.150.255.255
	{ 0xc1970000, 0xc1972fff, REGISTRY_RIPENCC    }, // 193.151.0.0     - 193.151.47.255
	{ 0xc1973000, 0xc19733ff, REGISTRY_RIPENCC    }, // 193.151.48.0    - 193.151.51.255
	{ 0xc1973400, 0xc1973bff, REGISTRY_RIPENCC    }, // 193.151.52.0    - 193.151.59.255
	{ 0xc1973c00, 0xc19743ff, REGISTRY_RIPENCC    }, // 193.151.60.0    - 193.151.67.255
	{ 0xc1974400, 0xc19747ff, REGISTRY_RIPENCC    }, // 193.151.68.0    - 193.151.71.255
	{ 0xc1974800, 0xc1974bff, REGISTRY_RIPENCC    }, // 193.151.72.0    - 193.151.75.255
	{ 0xc1974c00, 0xc1979fff, REGISTRY_RIPENCC    }, // 193.151.76.0    - 193.151.159.255
	{ 0xc197a000, 0xc197bfff, REGISTRY_RIPENCC    }, // 193.151.160.0   - 193.151.191.255
	{ 0xc197c000, 0xc197ffff, REGISTRY_RIPENCC    }, // 193.151.192.0   - 193.151.255.255
	{ 0xc1980000, 0xc19fffff, REGISTRY_RIPENCC    }, // 193.152.0.0     - 193.159.255.255
	{ 0xc1a00000, 0xc1a007ff, REGISTRY_RIPENCC    }, // 193.160.0.0     - 193.160.7.255
	{ 0xc1a00900, 0xc1a009ff, REGISTRY_RIPENCC    }, // 193.160.9.0     - 193.160.9.255
	{ 0xc1a00c00, 0xc1a00dff, REGISTRY_RIPENCC    }, // 193.160.12.0    - 193.160.13.255
	{ 0xc1a01000, 0xc1a013ff, REGISTRY_RIPENCC    }, // 193.160.16.0    - 193.160.19.255
	{ 0xc1a01400, 0xc1a014ff, REGISTRY_RIPENCC    }, // 193.160.20.0    - 193.160.20.255
	{ 0xc1a01800, 0xc1a01dff, REGISTRY_RIPENCC    }, // 193.160.24.0    - 193.160.29.255
	{ 0xc1a02100, 0xc1a03fff, REGISTRY_RIPENCC    }, // 193.160.33.0    - 193.160.63.255
	{ 0xc1a04000, 0xc1a05fff, REGISTRY_RIPENCC    }, // 193.160.64.0    - 193.160.95.255
	{ 0xc1a06100, 0xc1a063ff, REGISTRY_RIPENCC    }, // 193.160.97.0    - 193.160.99.255
	{ 0xc1a06700, 0xc1a070ff, REGISTRY_RIPENCC    }, // 193.160.103.0   - 193.160.112.255
	{ 0xc1a07200, 0xc1a075ff, REGISTRY_RIPENCC    }, // 193.160.114.0   - 193.160.117.255
	{ 0xc1a07800, 0xc1a07fff, REGISTRY_RIPENCC    }, // 193.160.120.0   - 193.160.127.255
	{ 0xc1a08300, 0xc1a085ff, REGISTRY_RIPENCC    }, // 193.160.131.0   - 193.160.133.255
	{ 0xc1a08900, 0xc1a08aff, REGISTRY_RIPENCC    }, // 193.160.137.0   - 193.160.138.255
	{ 0xc1a08c00, 0xc1a093ff, REGISTRY_RIPENCC    }, // 193.160.140.0   - 193.160.147.255
	{ 0xc1a09400, 0xc1a097ff, REGISTRY_RIPENCC    }, // 193.160.148.0   - 193.160.151.255
	{ 0xc1a09800, 0xc1a09bff, REGISTRY_RIPENCC    }, // 193.160.152.0   - 193.160.155.255
	{ 0xc1a09c00, 0xc1a09eff, REGISTRY_RIPENCC    }, // 193.160.156.0   - 193.160.158.255
	{ 0xc1a0a000, 0xc1a0bbff, REGISTRY_RIPENCC    }, // 193.160.160.0   - 193.160.187.255
	{ 0xc1a0bc00, 0xc1a0bfff, REGISTRY_RIPENCC    }, // 193.160.188.0   - 193.160.191.255
	{ 0xc1a0c000, 0xc1a0cfff, REGISTRY_RIPENCC    }, // 193.160.192.0   - 193.160.207.255
	{ 0xc1a0d000, 0xc1a0dfff, REGISTRY_RIPENCC    }, // 193.160.208.0   - 193.160.223.255
	{ 0xc1a0e000, 0xc1a0e7ff, REGISTRY_RIPENCC    }, // 193.160.224.0   - 193.160.231.255
	{ 0xc1a0e800, 0xc1a0ebff, REGISTRY_RIPENCC    }, // 193.160.232.0   - 193.160.235.255
	{ 0xc1a0ef00, 0xc1a0efff, REGISTRY_RIPENCC    }, // 193.160.239.0   - 193.160.239.255
	{ 0xc1a0f000, 0xc1a0f7ff, REGISTRY_RIPENCC    }, // 193.160.240.0   - 193.160.247.255
	{ 0xc1a0f800, 0xc1a0fcff, REGISTRY_RIPENCC    }, // 193.160.248.0   - 193.160.252.255
	{ 0xc1a0ff00, 0xc1a100ff, REGISTRY_RIPENCC    }, // 193.160.255.0   - 193.161.0.255
	{ 0xc1a10400, 0xc1a10bff, REGISTRY_RIPENCC    }, // 193.161.4.0     - 193.161.11.255
	{ 0xc1a10c00, 0xc1a117ff, REGISTRY_RIPENCC    }, // 193.161.12.0    - 193.161.23.255
	{ 0xc1a11b00, 0xc1a11bff, REGISTRY_RIPENCC    }, // 193.161.27.0    - 193.161.27.255
	{ 0xc1a11e00, 0xc1a11fff, REGISTRY_RIPENCC    }, // 193.161.30.0    - 193.161.31.255
	{ 0xc1a12000, 0xc1a16fff, REGISTRY_RIPENCC    }, // 193.161.32.0    - 193.161.111.255
	{ 0xc1a17000, 0xc1a177ff, REGISTRY_RIPENCC    }, // 193.161.112.0   - 193.161.119.255
	{ 0xc1a17800, 0xc1a17fff, REGISTRY_RIPENCC    }, // 193.161.120.0   - 193.161.127.255
	{ 0xc1a18000, 0xc1a187ff, REGISTRY_RIPENCC    }, // 193.161.128.0   - 193.161.135.255
	{ 0xc1a18a00, 0xc1a18bff, REGISTRY_RIPENCC    }, // 193.161.138.0   - 193.161.139.255
	{ 0xc1a18c00, 0xc1a18fff, REGISTRY_RIPENCC    }, // 193.161.140.0   - 193.161.143.255
	{ 0xc1a19000, 0xc1a192ff, REGISTRY_RIPENCC    }, // 193.161.144.0   - 193.161.146.255
	{ 0xc1a19400, 0xc1a197ff, REGISTRY_RIPENCC    }, // 193.161.148.0   - 193.161.151.255
	{ 0xc1a19800, 0xc1a19bff, REGISTRY_RIPENCC    }, // 193.161.152.0   - 193.161.155.255
	{ 0xc1a19e00, 0xc1a1c3ff, REGISTRY_RIPENCC    }, // 193.161.158.0   - 193.161.195.255
	{ 0xc1a1c400, 0xc1a1cbff, REGISTRY_RIPENCC    }, // 193.161.196.0   - 193.161.203.255
	{ 0xc1a1cf00, 0xc1a1d3ff, REGISTRY_RIPENCC    }, // 193.161.207.0   - 193.161.211.255
	{ 0xc1a1d400, 0xc1a1d7ff, REGISTRY_RIPENCC    }, // 193.161.212.0   - 193.161.215.255
	{ 0xc1a1d800, 0xc1a1dbff, REGISTRY_RIPENCC    }, // 193.161.216.0   - 193.161.219.255
	{ 0xc1a1dc00, 0xc1a1dfff, REGISTRY_RIPENCC    }, // 193.161.220.0   - 193.161.223.255
	{ 0xc1a1e000, 0xc1a1f4ff, REGISTRY_RIPENCC    }, // 193.161.224.0   - 193.161.244.255
	{ 0xc1a1f800, 0xc1a1fdff, REGISTRY_RIPENCC    }, // 193.161.248.0   - 193.161.253.255
	{ 0xc1a20000, 0xc1a3ffff, REGISTRY_RIPENCC    }, // 193.162.0.0     - 193.163.255.255
	{ 0xc1a40000, 0xc1a400ff, REGISTRY_RIPENCC    }, // 193.164.0.0     - 193.164.0.255
	{ 0xc1a40400, 0xc1a407ff, REGISTRY_RIPENCC    }, // 193.164.4.0     - 193.164.7.255
	{ 0xc1a40800, 0xc1a409ff, REGISTRY_RIPENCC    }, // 193.164.8.0     - 193.164.9.255
	{ 0xc1a40b00, 0xc1a40fff, REGISTRY_RIPENCC    }, // 193.164.11.0    - 193.164.15.255
	{ 0xc1a41000, 0xc1a41fff, REGISTRY_RIPENCC    }, // 193.164.16.0    - 193.164.31.255
	{ 0xc1a42000, 0xc1a45fff, REGISTRY_RIPENCC    }, // 193.164.32.0    - 193.164.95.255
	{ 0xc1a46000, 0xc1a480ff, REGISTRY_RIPENCC    }, // 193.164.96.0    - 193.164.128.255
	{ 0xc1a48100, 0xc1a482ff, REGISTRY_RIPENCC    }, // 193.164.129.0   - 193.164.130.255
	{ 0xc1a48300, 0xc1a485ff, REGISTRY_RIPENCC    }, // 193.164.131.0   - 193.164.133.255
	{ 0xc1a48800, 0xc1a494ff, REGISTRY_RIPENCC    }, // 193.164.136.0   - 193.164.148.255
	{ 0xc1a49700, 0xc1a497ff, REGISTRY_RIPENCC    }, // 193.164.151.0   - 193.164.151.255
	{ 0xc1a49900, 0xc1a49fff, REGISTRY_RIPENCC    }, // 193.164.153.0   - 193.164.159.255
	{ 0xc1a4a000, 0xc1a4c1ff, REGISTRY_RIPENCC    }, // 193.164.160.0   - 193.164.193.255
	{ 0xc1a4c200, 0xc1a4cfff, REGISTRY_RIPENCC    }, // 193.164.194.0   - 193.164.207.255
	{ 0xc1a4d200, 0xc1a4ddff, REGISTRY_RIPENCC    }, // 193.164.210.0   - 193.164.221.255
	{ 0xc1a4e000, 0xc1a4e85f, REGISTRY_RIPENCC    }, // 193.164.224.0   - 193.164.232.95
	{ 0xc1a4e8a0, 0xc1a4e8df, REGISTRY_RIPENCC    }, // 193.164.232.160 - 193.164.232.223
	{ 0xc1a4e900, 0xc1a4f7ff, REGISTRY_RIPENCC    }, // 193.164.233.0   - 193.164.247.255
	{ 0xc1a4f800, 0xc1a4fbff, REGISTRY_RIPENCC    }, // 193.164.248.0   - 193.164.251.255
	{ 0xc1a4fc00, 0xc1a4ffff, REGISTRY_RIPENCC    }, // 193.164.252.0   - 193.164.255.255
	{ 0xc1a50000, 0xc1a7ffff, REGISTRY_RIPENCC    }, // 193.165.0.0     - 193.167.255.255
	{ 0xc1a80000, 0xc1a802ff, REGISTRY_RIPENCC    }, // 193.168.0.0     - 193.168.2.255
	{ 0xc1a80600, 0xc1a807ff, REGISTRY_RIPENCC    }, // 193.168.6.0     - 193.168.7.255
	{ 0xc1a80800, 0xc1a82dff, REGISTRY_RIPENCC    }, // 193.168.8.0     - 193.168.45.255
	{ 0xc1a83200, 0xc1a832ff, REGISTRY_RIPENCC    }, // 193.168.50.0    - 193.168.50.255
	{ 0xc1a83600, 0xc1a836ff, REGISTRY_RIPENCC    }, // 193.168.54.0    - 193.168.54.255
	{ 0xc1a83a00, 0xc1a83fff, REGISTRY_RIPENCC    }, // 193.168.58.0    - 193.168.63.255
	{ 0xc1a84000, 0xc1a8ffff, REGISTRY_RIPENCC    }, // 193.168.64.0    - 193.168.255.255
	{ 0xc1a90000, 0xc1a919ff, REGISTRY_RIPENCC    }, // 193.169.0.0     - 193.169.25.255
	{ 0xc1a91c00, 0xc1a95bff, REGISTRY_RIPENCC    }, // 193.169.28.0    - 193.169.91.255
	{ 0xc1a95e00, 0xc1a969ff, REGISTRY_RIPENCC    }, // 193.169.94.0    - 193.169.105.255
	{ 0xc1a96c00, 0xc1a9a9ff, REGISTRY_RIPENCC    }, // 193.169.108.0   - 193.169.169.255
	{ 0xc1a9ac00, 0xc1a9bfff, REGISTRY_RIPENCC    }, // 193.169.172.0   - 193.169.191.255
	{ 0xc1a9c000, 0xc1a9c1ff, REGISTRY_RIPENCC    }, // 193.169.192.0   - 193.169.193.255
	{ 0xc1a9c200, 0xc1a9c7ff, REGISTRY_RIPENCC    }, // 193.169.194.0   - 193.169.199.255
	{ 0xc1a9ca00, 0xc1a9cdff, REGISTRY_RIPENCC    }, // 193.169.202.0   - 193.169.205.255
	{ 0xc1a9ce00, 0xc1a9cfff, REGISTRY_RIPENCC    }, // 193.169.206.0   - 193.169.207.255
	{ 0xc1a9d000, 0xc1a9d9ff, REGISTRY_RIPENCC    }, // 193.169.208.0   - 193.169.217.255
	{ 0xc1a9dc00, 0xc1a9edff, REGISTRY_RIPENCC    }, // 193.169.220.0   - 193.169.237.255
	{ 0xc1a9f000, 0xc1a9f9ff, REGISTRY_RIPENCC    }, // 193.169.240.0   - 193.169.249.255
	{ 0xc1a9fc00, 0xc1afffff, REGISTRY_RIPENCC    }, // 193.169.252.0   - 193.175.255.255
	{ 0xc1b00000, 0xc1b000ff, REGISTRY_RIPENCC    }, // 193.176.0.0     - 193.176.0.255
	{ 0xc1b00300, 0xc1b003ff, REGISTRY_RIPENCC    }, // 193.176.3.0     - 193.176.3.255
	{ 0xc1b00500, 0xc1b00fff, REGISTRY_RIPENCC    }, // 193.176.5.0     - 193.176.15.255
	{ 0xc1b01000, 0xc1b01fff, REGISTRY_RIPENCC    }, // 193.176.16.0    - 193.176.31.255
	{ 0xc1b02000, 0xc1b027ff, REGISTRY_RIPENCC    }, // 193.176.32.0    - 193.176.39.255
	{ 0xc1b02800, 0xc1b02bff, REGISTRY_RIPENCC    }, // 193.176.40.0    - 193.176.43.255
	{ 0xc1b02d00, 0xc1b035ff, REGISTRY_RIPENCC    }, // 193.176.45.0    - 193.176.53.255
	{ 0xc1b03800, 0xc1b03dff, REGISTRY_RIPENCC    }, // 193.176.56.0    - 193.176.61.255
	{ 0xc1b03f00, 0xc1b03fff, REGISTRY_RIPENCC    }, // 193.176.63.0    - 193.176.63.255
	{ 0xc1b04000, 0xc1b05fff, REGISTRY_RIPENCC    }, // 193.176.64.0    - 193.176.95.255
	{ 0xc1b06000, 0xc1b06fff, REGISTRY_RIPENCC    }, // 193.176.96.0    - 193.176.111.255
	{ 0xc1b07000, 0xc1b07fff, REGISTRY_RIPENCC    }, // 193.176.112.0   - 193.176.127.255
	{ 0xc1b08200, 0xc1b092ff, REGISTRY_RIPENCC    }, // 193.176.130.0   - 193.176.146.255
	{ 0xc1b09400, 0xc1b098ff, REGISTRY_RIPENCC    }, // 193.176.148.0   - 193.176.152.255
	{ 0xc1b09f00, 0xc1b0b2ff, REGISTRY_RIPENCC    }, // 193.176.159.0   - 193.176.178.255
	{ 0xc1b0b400, 0xc1b0bdff, REGISTRY_RIPENCC    }, // 193.176.180.0   - 193.176.189.255
	{ 0xc1b0bf00, 0xc1b0d1ff, REGISTRY_RIPENCC    }, // 193.176.191.0   - 193.176.209.255
	{ 0xc1b0d400, 0xc1b0d7ff, REGISTRY_RIPENCC    }, // 193.176.212.0   - 193.176.215.255
	{ 0xc1b0d800, 0xc1b0dbff, REGISTRY_RIPENCC    }, // 193.176.216.0   - 193.176.219.255
	{ 0xc1b0dd00, 0xc1b0e2ff, REGISTRY_RIPENCC    }, // 193.176.221.0   - 193.176.226.255
	{ 0xc1b0e400, 0xc1b0e7ff, REGISTRY_RIPENCC    }, // 193.176.228.0   - 193.176.231.255
	{ 0xc1b0e800, 0xc1b0e8ff, REGISTRY_RIPENCC    }, // 193.176.232.0   - 193.176.232.255
	{ 0xc1b0ea00, 0xc1b0ecff, REGISTRY_RIPENCC    }, // 193.176.234.0   - 193.176.236.255
	{ 0xc1b0ef00, 0xc1b0efff, REGISTRY_RIPENCC    }, // 193.176.239.0   - 193.176.239.255
	{ 0xc1b0f000, 0xc1b0f3ff, REGISTRY_RIPENCC    }, // 193.176.240.0   - 193.176.243.255
	{ 0xc1b0f700, 0xc1b0fbff, REGISTRY_RIPENCC    }, // 193.176.247.0   - 193.176.251.255
	{ 0xc1b0fd00, 0xc1b0fdff, REGISTRY_RIPENCC    }, // 193.176.253.0   - 193.176.253.255
	{ 0xc1b0ff00, 0xc1b0ffff, REGISTRY_RIPENCC    }, // 193.176.255.0   - 193.176.255.255
	{ 0xc1b10100, 0xc1b17fff, REGISTRY_RIPENCC    }, // 193.177.1.0     - 193.177.127.255
	{ 0xc1b18000, 0xc1b187ff, REGISTRY_RIPENCC    }, // 193.177.128.0   - 193.177.135.255
	{ 0xc1b18800, 0xc1b193ff, REGISTRY_RIPENCC    }, // 193.177.136.0   - 193.177.147.255
	{ 0xc1b19400, 0xc1b197ff, REGISTRY_RIPENCC    }, // 193.177.148.0   - 193.177.151.255
	{ 0xc1b19800, 0xc1b1a1ff, REGISTRY_RIPENCC    }, // 193.177.152.0   - 193.177.161.255
	{ 0xc1b1a300, 0xc1b1a3ff, REGISTRY_RIPENCC    }, // 193.177.163.0   - 193.177.163.255
	{ 0xc1b1a600, 0xc1b1b5ff, REGISTRY_RIPENCC    }, // 193.177.166.0   - 193.177.181.255
	{ 0xc1b1b700, 0xc1b1bbff, REGISTRY_RIPENCC    }, // 193.177.183.0   - 193.177.187.255
	{ 0xc1b1bc00, 0xc1b1bfff, REGISTRY_RIPENCC    }, // 193.177.188.0   - 193.177.191.255
	{ 0xc1b1c000, 0xc1b1cfff, REGISTRY_RIPENCC    }, // 193.177.192.0   - 193.177.207.255
	{ 0xc1b1d000, 0xc1b1dfff, REGISTRY_RIPENCC    }, // 193.177.208.0   - 193.177.223.255
	{ 0xc1b1e000, 0xc1b1ffff, REGISTRY_RIPENCC    }, // 193.177.224.0   - 193.177.255.255
	{ 0xc1b20100, 0xc1b21eff, REGISTRY_RIPENCC    }, // 193.178.1.0     - 193.178.30.255
	{ 0xc1b22000, 0xc1b220ff, REGISTRY_RIPENCC    }, // 193.178.32.0    - 193.178.32.255
	{ 0xc1b22200, 0xc1b223ff, REGISTRY_RIPENCC    }, // 193.178.34.0    - 193.178.35.255
	{ 0xc1b22400, 0xc1b227ff, REGISTRY_RIPENCC    }, // 193.178.36.0    - 193.178.39.255
	{ 0xc1b22800, 0xc1b229ff, REGISTRY_RIPENCC    }, // 193.178.40.0    - 193.178.41.255
	{ 0xc1b22c00, 0xc1b233ff, REGISTRY_RIPENCC    }, // 193.178.44.0    - 193.178.51.255
	{ 0xc1b23500, 0xc1b235ff, REGISTRY_RIPENCC    }, // 193.178.53.0    - 193.178.53.255
	{ 0xc1b23800, 0xc1b23bff, REGISTRY_RIPENCC    }, // 193.178.56.0    - 193.178.59.255
	{ 0xc1b23c00, 0xc1b23fff, REGISTRY_RIPENCC    }, // 193.178.60.0    - 193.178.63.255
	{ 0xc1b24000, 0xc1b26fff, REGISTRY_RIPENCC    }, // 193.178.64.0    - 193.178.111.255
	{ 0xc1b27200, 0xc1b272ff, REGISTRY_RIPENCC    }, // 193.178.114.0   - 193.178.114.255
	{ 0xc1b27400, 0xc1b277ff, REGISTRY_RIPENCC    }, // 193.178.116.0   - 193.178.119.255
	{ 0xc1b27800, 0xc1b27fff, REGISTRY_RIPENCC    }, // 193.178.120.0   - 193.178.127.255
	{ 0xc1b28100, 0xc1b288ff, REGISTRY_RIPENCC    }, // 193.178.129.0   - 193.178.136.255
	{ 0xc1b28a00, 0xc1b28aff, REGISTRY_RIPENCC    }, // 193.178.138.0   - 193.178.138.255
	{ 0xc1b28c00, 0xc1b28dff, REGISTRY_RIPENCC    }, // 193.178.140.0   - 193.178.141.255
	{ 0xc1b28f00, 0xc1b2a8ff, REGISTRY_RIPENCC    }, // 193.178.143.0   - 193.178.168.255
	{ 0xc1b2ab00, 0xc1b2abff, REGISTRY_RIPENCC    }, // 193.178.171.0   - 193.178.171.255
	{ 0xc1b2ad00, 0xc1b2adff, REGISTRY_RIPENCC    }, // 193.178.173.0   - 193.178.173.255
	{ 0xc1b2af00, 0xc1b2c3ff, REGISTRY_RIPENCC    }, // 193.178.175.0   - 193.178.195.255
	{ 0xc1b2c400, 0xc1b2c7ff, REGISTRY_RIPENCC    }, // 193.178.196.0   - 193.178.199.255
	{ 0xc1b2c800, 0xc1b2d3ff, REGISTRY_RIPENCC    }, // 193.178.200.0   - 193.178.211.255
	{ 0xc1b2d500, 0xc1b2d9ff, REGISTRY_RIPENCC    }, // 193.178.213.0   - 193.178.217.255
	{ 0xc1b2db00, 0xc1b2dbff, REGISTRY_RIPENCC    }, // 193.178.219.0   - 193.178.219.255
	{ 0xc1b2de00, 0xc1b2e5ff, REGISTRY_RIPENCC    }, // 193.178.222.0   - 193.178.229.255
	{ 0xc1b2e800, 0xc1b2f3ff, REGISTRY_RIPENCC    }, // 193.178.232.0   - 193.178.243.255
	{ 0xc1b2f400, 0xc1b2f7ff, REGISTRY_RIPENCC    }, // 193.178.244.0   - 193.178.247.255
	{ 0xc1b2f800, 0xc1b2ffff, REGISTRY_RIPENCC    }, // 193.178.248.0   - 193.178.255.255
	{ 0xc1b30000, 0xc1b9ffff, REGISTRY_RIPENCC    }, // 193.179.0.0     - 193.185.255.255
	{ 0xc1ba0000, 0xc1ba00ff, REGISTRY_RIPENCC    }, // 193.186.0.0     - 193.186.0.255
	{ 0xc1ba0200, 0xc1ba0aff, REGISTRY_RIPENCC    }, // 193.186.2.0     - 193.186.10.255
	{ 0xc1ba0c00, 0xc1ba0dff, REGISTRY_RIPENCC    }, // 193.186.12.0    - 193.186.13.255
	{ 0xc1ba0f00, 0xc1ba47ff, REGISTRY_RIPENCC    }, // 193.186.15.0    - 193.186.71.255
	{ 0xc1ba4800, 0xc1ba57ff, REGISTRY_RIPENCC    }, // 193.186.72.0    - 193.186.87.255
	{ 0xc1ba5800, 0xc1ba9fff, REGISTRY_RIPENCC    }, // 193.186.88.0    - 193.186.159.255
	{ 0xc1baa100, 0xc1babfff, REGISTRY_RIPENCC    }, // 193.186.161.0   - 193.186.191.255
	{ 0xc1bac000, 0xc1bacfff, REGISTRY_RIPENCC    }, // 193.186.192.0   - 193.186.207.255
	{ 0xc1bad000, 0xc1bad2ff, REGISTRY_RIPENCC    }, // 193.186.208.0   - 193.186.210.255
	{ 0xc1bad400, 0xc1bad6ff, REGISTRY_RIPENCC    }, // 193.186.212.0   - 193.186.214.255
	{ 0xc1bad800, 0xc1bafcff, REGISTRY_RIPENCC    }, // 193.186.216.0   - 193.186.252.255
	{ 0xc1bafe00, 0xc1bb00ff, REGISTRY_RIPENCC    }, // 193.186.254.0   - 193.187.0.255
	{ 0xc1bb0200, 0xc1bb53ff, REGISTRY_RIPENCC    }, // 193.187.2.0     - 193.187.83.255
	{ 0xc1bb5400, 0xc1bbc3ff, REGISTRY_RIPENCC    }, // 193.187.84.0    - 193.187.195.255
	{ 0xc1bbc400, 0xc1bc00ff, REGISTRY_RIPENCC    }, // 193.187.196.0   - 193.188.0.255
	{ 0xc1bc0400, 0xc1bc06ff, REGISTRY_RIPENCC    }, // 193.188.4.0     - 193.188.6.255
	{ 0xc1bc0700, 0xc1bc07ff, REGISTRY_AFRINIC    }, // 193.188.7.0     - 193.188.7.255
	{ 0xc1bc0800, 0xc1bc0bff, REGISTRY_RIPENCC    }, // 193.188.8.0     - 193.188.11.255
	{ 0xc1bc0c00, 0xc1bc0dff, REGISTRY_RIPENCC    }, // 193.188.12.0    - 193.188.13.255
	{ 0xc1bc1000, 0xc1bc1fff, REGISTRY_RIPENCC    }, // 193.188.16.0    - 193.188.31.255
	{ 0xc1bc2000, 0xc1bc3fff, REGISTRY_RIPENCC    }, // 193.188.32.0    - 193.188.63.255
	{ 0xc1bc4000, 0xc1bc7fff, REGISTRY_RIPENCC    }, // 193.188.64.0    - 193.188.127.255
	{ 0xc1bc8000, 0xc1bc8687, REGISTRY_RIPENCC    }, // 193.188.128.0   - 193.188.134.135
	{ 0xc1bc8690, 0xc1bc86c7, REGISTRY_RIPENCC    }, // 193.188.134.144 - 193.188.134.199
	{ 0xc1bc8700, 0xc1bc89ff, REGISTRY_RIPENCC    }, // 193.188.135.0   - 193.188.137.255
	{ 0xc1bc8c00, 0xc1bcc2ff, REGISTRY_RIPENCC    }, // 193.188.140.0   - 193.188.194.255
	{ 0xc1bcc400, 0xc1bcc7ff, REGISTRY_RIPENCC    }, // 193.188.196.0   - 193.188.199.255
	{ 0xc1bcc900, 0xc1bcfaff, REGISTRY_RIPENCC    }, // 193.188.201.0   - 193.188.250.255
	{ 0xc1bcfd00, 0xc1bcffff, REGISTRY_RIPENCC    }, // 193.188.253.0   - 193.188.255.255
	{ 0xc1bd0000, 0xc1bd41ff, REGISTRY_AFRINIC    }, // 193.189.0.0     - 193.189.65.255
	{ 0xc1bd4200, 0xc1bd49ff, REGISTRY_RIPENCC    }, // 193.189.66.0    - 193.189.73.255
	{ 0xc1bd4a00, 0xc1bd4bff, REGISTRY_RIPENCC    }, // 193.189.74.0    - 193.189.75.255
	{ 0xc1bd4c00, 0xc1bd51ff, REGISTRY_RIPENCC    }, // 193.189.76.0    - 193.189.81.255
	{ 0xc1bd5200, 0xc1bd53ff, REGISTRY_RIPENCC    }, // 193.189.82.0    - 193.189.83.255
	{ 0xc1bd5600, 0xc1bd59ff, REGISTRY_RIPENCC    }, // 193.189.86.0    - 193.189.89.255
	{ 0xc1bd5c00, 0xc1bd69ff, REGISTRY_RIPENCC    }, // 193.189.92.0    - 193.189.105.255
	{ 0xc1bd6a00, 0xc1bd6bff, REGISTRY_RIPENCC    }, // 193.189.106.0   - 193.189.107.255
	{ 0xc1bd6c00, 0xc1bd75ff, REGISTRY_RIPENCC    }, // 193.189.108.0   - 193.189.117.255
	{ 0xc1bd7800, 0xc1bd7fff, REGISTRY_RIPENCC    }, // 193.189.120.0   - 193.189.127.255
	{ 0xc1bd8000, 0xc1bd80ff, REGISTRY_AFRINIC    }, // 193.189.128.0   - 193.189.128.255
	{ 0xc1bd8100, 0xc1bd8bff, REGISTRY_RIPENCC    }, // 193.189.129.0   - 193.189.139.255
	{ 0xc1bd8c00, 0xc1bd8cff, REGISTRY_RIPENCC    }, // 193.189.140.0   - 193.189.140.255
	{ 0xc1bd8d00, 0xc1bd8eff, REGISTRY_RIPENCC    }, // 193.189.141.0   - 193.189.142.255
	{ 0xc1bd8f00, 0xc1bd8fff, REGISTRY_RIPENCC    }, // 193.189.143.0   - 193.189.143.255
	{ 0xc1bd9000, 0xc1bd90ff, REGISTRY_RIPENCC    }, // 193.189.144.0   - 193.189.144.255
	{ 0xc1bd9200, 0xc1bd9fff, REGISTRY_RIPENCC    }, // 193.189.146.0   - 193.189.159.255
	{ 0xc1bda000, 0xc1bfffff, REGISTRY_RIPENCC    }, // 193.189.160.0   - 193.191.255.255
	{ 0xc1c00000, 0xc1c000ff, REGISTRY_RIPENCC    }, // 193.192.0.0     - 193.192.0.255
	{ 0xc1c00400, 0xc1c00bff, REGISTRY_RIPENCC    }, // 193.192.4.0     - 193.192.11.255
	{ 0xc1c00c80, 0xc1c00eff, REGISTRY_RIPENCC    }, // 193.192.12.128  - 193.192.14.255
	{ 0xc1c01000, 0xc1c023ff, REGISTRY_RIPENCC    }, // 193.192.16.0    - 193.192.35.255
	{ 0xc1c02400, 0xc1c025ff, REGISTRY_RIPENCC    }, // 193.192.36.0    - 193.192.37.255
	{ 0xc1c02600, 0xc1c03fff, REGISTRY_RIPENCC    }, // 193.192.38.0    - 193.192.63.255
	{ 0xc1c04000, 0xc1c19fff, REGISTRY_RIPENCC    }, // 193.192.64.0    - 193.193.159.255
	{ 0xc1c1a100, 0xc1c1a1ff, REGISTRY_RIPENCC    }, // 193.193.161.0   - 193.193.161.255
	{ 0xc1c1a500, 0xc1c1aaff, REGISTRY_RIPENCC    }, // 193.193.165.0   - 193.193.170.255
	{ 0xc1c1ac00, 0xc1c1adff, REGISTRY_RIPENCC    }, // 193.193.172.0   - 193.193.173.255
	{ 0xc1c1ae00, 0xc1c1b5ff, REGISTRY_RIPENCC    }, // 193.193.174.0   - 193.193.181.255
	{ 0xc1c1b700, 0xc1c1bfff, REGISTRY_RIPENCC    }, // 193.193.183.0   - 193.193.191.255
	{ 0xc1c1c000, 0xc1c1ffff, REGISTRY_RIPENCC    }, // 193.193.192.0   - 193.193.255.255
	{ 0xc1c20000, 0xc1c200ff, REGISTRY_RIPENCC    }, // 193.194.0.0     - 193.194.0.255
	{ 0xc1c20100, 0xc1c205ff, REGISTRY_AFRINIC    }, // 193.194.1.0     - 193.194.5.255
	{ 0xc1c20600, 0xc1c21fff, REGISTRY_RIPENCC    }, // 193.194.6.0     - 193.194.31.255
	{ 0xc1c22000, 0xc1c25fff, REGISTRY_AFRINIC    }, // 193.194.32.0    - 193.194.95.255
	{ 0xc1c26000, 0xc1c27fff, REGISTRY_RIPENCC    }, // 193.194.96.0    - 193.194.127.255
	{ 0xc1c28000, 0xc1c280ff, REGISTRY_AFRINIC    }, // 193.194.128.0   - 193.194.128.255
	{ 0xc1c28100, 0xc1c281ff, REGISTRY_RIPENCC    }, // 193.194.129.0   - 193.194.129.255
	{ 0xc1c28400, 0xc1c288ff, REGISTRY_RIPENCC    }, // 193.194.132.0   - 193.194.136.255
	{ 0xc1c28a00, 0xc1c28dff, REGISTRY_RIPENCC    }, // 193.194.138.0   - 193.194.141.255
	{ 0xc1c29000, 0xc1c292ff, REGISTRY_RIPENCC    }, // 193.194.144.0   - 193.194.146.255
	{ 0xc1c29400, 0xc1c295ff, REGISTRY_RIPENCC    }, // 193.194.148.0   - 193.194.149.255
	{ 0xc1c29800, 0xc1c29aff, REGISTRY_RIPENCC    }, // 193.194.152.0   - 193.194.154.255
	{ 0xc1c29c00, 0xc1c29cff, REGISTRY_RIPENCC    }, // 193.194.156.0   - 193.194.156.255
	{ 0xc1c29e00, 0xc1c29fff, REGISTRY_RIPENCC    }, // 193.194.158.0   - 193.194.159.255
	{ 0xc1c2a000, 0xc1c2bfff, REGISTRY_AFRINIC    }, // 193.194.160.0   - 193.194.191.255
	{ 0xc1c2c000, 0xc1c7ffff, REGISTRY_RIPENCC    }, // 193.194.192.0   - 193.199.255.255
	{ 0xc1c80300, 0xc1c807ff, REGISTRY_RIPENCC    }, // 193.200.3.0     - 193.200.7.255
	{ 0xc1c80900, 0xc1c80bff, REGISTRY_RIPENCC    }, // 193.200.9.0     - 193.200.11.255
	{ 0xc1c80e00, 0xc1c80fff, REGISTRY_RIPENCC    }, // 193.200.14.0    - 193.200.15.255
	{ 0xc1c81200, 0xc1c817ff, REGISTRY_RIPENCC    }, // 193.200.18.0    - 193.200.23.255
	{ 0xc1c81900, 0xc1c819ff, REGISTRY_RIPENCC    }, // 193.200.25.0    - 193.200.25.255
	{ 0xc1c81c00, 0xc1c82fff, REGISTRY_RIPENCC    }, // 193.200.28.0    - 193.200.47.255
	{ 0xc1c83200, 0xc1c833ff, REGISTRY_RIPENCC    }, // 193.200.50.0    - 193.200.51.255
	{ 0xc1c83600, 0xc1c837ff, REGISTRY_RIPENCC    }, // 193.200.54.0    - 193.200.55.255
	{ 0xc1c83a00, 0xc1c83dff, REGISTRY_RIPENCC    }, // 193.200.58.0    - 193.200.61.255
	{ 0xc1c84000, 0xc1c847ff, REGISTRY_RIPENCC    }, // 193.200.64.0    - 193.200.71.255
	{ 0xc1c84800, 0xc1c84bff, REGISTRY_RIPENCC    }, // 193.200.72.0    - 193.200.75.255
	{ 0xc1c84c00, 0xc1c85fff, REGISTRY_RIPENCC    }, // 193.200.76.0    - 193.200.95.255
	{ 0xc1c86200, 0xc1c865ff, REGISTRY_RIPENCC    }, // 193.200.98.0    - 193.200.101.255
	{ 0xc1c86800, 0xc1c881ff, REGISTRY_RIPENCC    }, // 193.200.104.0   - 193.200.129.255
	{ 0xc1c88300, 0xc1c885ff, REGISTRY_RIPENCC    }, // 193.200.131.0   - 193.200.133.255
	{ 0xc1c88700, 0xc1c894ff, REGISTRY_RIPENCC    }, // 193.200.135.0   - 193.200.148.255
	{ 0xc1c89600, 0xc1c897ff, REGISTRY_RIPENCC    }, // 193.200.150.0   - 193.200.151.255
	{ 0xc1c89900, 0xc1c89eff, REGISTRY_RIPENCC    }, // 193.200.153.0   - 193.200.158.255
	{ 0xc1c8a000, 0xc1c8a2ff, REGISTRY_RIPENCC    }, // 193.200.160.0   - 193.200.162.255
	{ 0xc1c8a400, 0xc1c8a6ff, REGISTRY_RIPENCC    }, // 193.200.164.0   - 193.200.166.255
	{ 0xc1c8a800, 0xc1c8a8ff, REGISTRY_RIPENCC    }, // 193.200.168.0   - 193.200.168.255
	{ 0xc1c8aa00, 0xc1c8b4ff, REGISTRY_RIPENCC    }, // 193.200.170.0   - 193.200.180.255
	{ 0xc1c8b600, 0xc1c8b9ff, REGISTRY_RIPENCC    }, // 193.200.182.0   - 193.200.185.255
	{ 0xc1c8bb00, 0xc1c8c1ff, REGISTRY_RIPENCC    }, // 193.200.187.0   - 193.200.193.255
	{ 0xc1c8c300, 0xc1c8c3ff, REGISTRY_RIPENCC    }, // 193.200.195.0   - 193.200.195.255
	{ 0xc1c8c500, 0xc1c8d8ff, REGISTRY_RIPENCC    }, // 193.200.197.0   - 193.200.216.255
	{ 0xc1c8da00, 0xc1c8dcff, REGISTRY_RIPENCC    }, // 193.200.218.0   - 193.200.220.255
	{ 0xc1c8de00, 0xc1c8e4ff, REGISTRY_RIPENCC    }, // 193.200.222.0   - 193.200.228.255
	{ 0xc1c8e600, 0xc1c8edff, REGISTRY_RIPENCC    }, // 193.200.230.0   - 193.200.237.255
	{ 0xc1c8ef00, 0xc1c8f0ff, REGISTRY_RIPENCC    }, // 193.200.239.0   - 193.200.240.255
	{ 0xc1c8f100, 0xc1c8f1ff, REGISTRY_RIPENCC    }, // 193.200.241.0   - 193.200.241.255
	{ 0xc1c8f200, 0xc1c8f3ff, REGISTRY_RIPENCC    }, // 193.200.242.0   - 193.200.243.255
	{ 0xc1c8f500, 0xc1c8f5ff, REGISTRY_RIPENCC    }, // 193.200.245.0   - 193.200.245.255
	{ 0xc1c8f700, 0xc1c8faff, REGISTRY_RIPENCC    }, // 193.200.247.0   - 193.200.250.255
	{ 0xc1c8fd00, 0xc1c922ff, REGISTRY_RIPENCC    }, // 193.200.253.0   - 193.201.34.255
	{ 0xc1c92400, 0xc1c924ff, REGISTRY_RIPENCC    }, // 193.201.36.0    - 193.201.36.255
	{ 0xc1c92700, 0xc1c92aff, REGISTRY_RIPENCC    }, // 193.201.39.0    - 193.201.42.255
	{ 0xc1c92c00, 0xc1c92dff, REGISTRY_RIPENCC    }, // 193.201.44.0    - 193.201.45.255
	{ 0xc1c92f00, 0xc1c937ff, REGISTRY_RIPENCC    }, // 193.201.47.0    - 193.201.55.255
	{ 0xc1c93800, 0xc1c93bff, REGISTRY_RIPENCC    }, // 193.201.56.0    - 193.201.59.255
	{ 0xc1c93c00, 0xc1c947ff, REGISTRY_RIPENCC    }, // 193.201.60.0    - 193.201.71.255
	{ 0xc1c94a00, 0xc1c962ff, REGISTRY_RIPENCC    }, // 193.201.74.0    - 193.201.98.255
	{ 0xc1c96400, 0xc1c96fff, REGISTRY_RIPENCC    }, // 193.201.100.0   - 193.201.111.255
	{ 0xc1c97400, 0xc1c97dff, REGISTRY_RIPENCC    }, // 193.201.116.0   - 193.201.125.255
	{ 0xc1c98000, 0xc1c9917f, REGISTRY_RIPENCC    }, // 193.201.128.0   - 193.201.145.127
	{ 0xc1c99200, 0xc1c993bf, REGISTRY_RIPENCC    }, // 193.201.146.0   - 193.201.147.191
	{ 0xc1c993e0, 0xc1c9947f, REGISTRY_RIPENCC    }, // 193.201.147.224 - 193.201.148.127
	{ 0xc1c994c0, 0xc1c994ff, REGISTRY_RIPENCC    }, // 193.201.148.192 - 193.201.148.255
	{ 0xc1c99540, 0xc1c9957f, REGISTRY_RIPENCC    }, // 193.201.149.64  - 193.201.149.127
	{ 0xc1c995c0, 0xc1c996bf, REGISTRY_RIPENCC    }, // 193.201.149.192 - 193.201.150.191
	{ 0xc1c99700, 0xc1c9973f, REGISTRY_RIPENCC    }, // 193.201.151.0   - 193.201.151.63
	{ 0xc1c997c0, 0xc1c99aff, REGISTRY_RIPENCC    }, // 193.201.151.192 - 193.201.154.255
	{ 0xc1c99b80, 0xc1c99d7f, REGISTRY_RIPENCC    }, // 193.201.155.128 - 193.201.157.127
	{ 0xc1c99e00, 0xc1c99eff, REGISTRY_RIPENCC    }, // 193.201.158.0   - 193.201.158.255
	{ 0xc1c99f80, 0xc1c9a1ff, REGISTRY_RIPENCC    }, // 193.201.159.128 - 193.201.161.255
	{ 0xc1c9a200, 0xc1c9a2ff, REGISTRY_RIPENCC    }, // 193.201.162.0   - 193.201.162.255
	{ 0xc1c9a300, 0xc1c9bfff, REGISTRY_RIPENCC    }, // 193.201.163.0   - 193.201.191.255
	{ 0xc1c9c000, 0xc1c9c3ff, REGISTRY_RIPENCC    }, // 193.201.192.0   - 193.201.195.255
	{ 0xc1c9c400, 0xc1c9c9ff, REGISTRY_RIPENCC    }, // 193.201.196.0   - 193.201.201.255
	{ 0xc1c9cc00, 0xc1c9cfff, REGISTRY_RIPENCC    }, // 193.201.204.0   - 193.201.207.255
	{ 0xc1c9d000, 0xc1c9d3ff, REGISTRY_RIPENCC    }, // 193.201.208.0   - 193.201.211.255
	{ 0xc1c9d400, 0xc1c9f3ff, REGISTRY_RIPENCC    }, // 193.201.212.0   - 193.201.243.255
	{ 0xc1c9f400, 0xc1c9fbff, REGISTRY_RIPENCC    }, // 193.201.244.0   - 193.201.251.255
	{ 0xc1c9fc00, 0xc1ca07ff, REGISTRY_RIPENCC    }, // 193.201.252.0   - 193.202.7.255
	{ 0xc1ca0800, 0xc1ca0fff, REGISTRY_RIPENCC    }, // 193.202.8.0     - 193.202.15.255
	{ 0xc1ca1000, 0xc1ca1eff, REGISTRY_RIPENCC    }, // 193.202.16.0    - 193.202.30.255
	{ 0xc1ca2000, 0xc1ca27ff, REGISTRY_RIPENCC    }, // 193.202.32.0    - 193.202.39.255
	{ 0xc1ca2800, 0xc1ca2bff, REGISTRY_RIPENCC    }, // 193.202.40.0    - 193.202.43.255
	{ 0xc1ca2e00, 0xc1ca49ff, REGISTRY_RIPENCC    }, // 193.202.46.0    - 193.202.73.255
	{ 0xc1ca4d00, 0xc1ca4fff, REGISTRY_RIPENCC    }, // 193.202.77.0    - 193.202.79.255
	{ 0xc1ca5000, 0xc1ca57ff, REGISTRY_RIPENCC    }, // 193.202.80.0    - 193.202.87.255
	{ 0xc1ca5b00, 0xc1ca6fff, REGISTRY_RIPENCC    }, // 193.202.91.0    - 193.202.111.255
	{ 0xc1ca7100, 0xc1ca71ff, REGISTRY_RIPENCC    }, // 193.202.113.0   - 193.202.113.255
	{ 0xc1ca7300, 0xc1cb01ff, REGISTRY_RIPENCC    }, // 193.202.115.0   - 193.203.1.255
	{ 0xc1cb0500, 0xc1cb07ff, REGISTRY_RIPENCC    }, // 193.203.5.0     - 193.203.7.255
	{ 0xc1cb0800, 0xc1cb0fff, REGISTRY_RIPENCC    }, // 193.203.8.0     - 193.203.15.255
	{ 0xc1cb1200, 0xc1cb15ff, REGISTRY_RIPENCC    }, // 193.203.18.0    - 193.203.21.255
	{ 0xc1cb1700, 0xc1cb17ff, REGISTRY_RIPENCC    }, // 193.203.23.0    - 193.203.23.255
	{ 0xc1cb1a00, 0xc1cb1bff, REGISTRY_RIPENCC    }, // 193.203.26.0    - 193.203.27.255
	{ 0xc1cb1c00, 0xc1cb1fff, REGISTRY_RIPENCC    }, // 193.203.28.0    - 193.203.31.255
	{ 0xc1cb2000, 0xc1cb23ff, REGISTRY_RIPENCC    }, // 193.203.32.0    - 193.203.35.255
	{ 0xc1cb2400, 0xc1cb27ff, REGISTRY_RIPENCC    }, // 193.203.36.0    - 193.203.39.255
	{ 0xc1cb2800, 0xc1cb33ff, REGISTRY_RIPENCC    }, // 193.203.40.0    - 193.203.51.255
	{ 0xc1cb3400, 0xc1cb37ff, REGISTRY_RIPENCC    }, // 193.203.52.0    - 193.203.55.255
	{ 0xc1cb3800, 0xc1cb3fff, REGISTRY_RIPENCC    }, // 193.203.56.0    - 193.203.63.255
	{ 0xc1cb4000, 0xc1cb5fff, REGISTRY_RIPENCC    }, // 193.203.64.0    - 193.203.95.255
	{ 0xc1cb6000, 0xc1cb6dff, REGISTRY_RIPENCC    }, // 193.203.96.0    - 193.203.109.255
	{ 0xc1cb7000, 0xc1cb7fff, REGISTRY_RIPENCC    }, // 193.203.112.0   - 193.203.127.255
	{ 0xc1cb8000, 0xc1cbbfff, REGISTRY_RIPENCC    }, // 193.203.128.0   - 193.203.191.255
	{ 0xc1cbc000, 0xc1cbd5ff, REGISTRY_RIPENCC    }, // 193.203.192.0   - 193.203.213.255
	{ 0xc1cbd800, 0xc1cbdfff, REGISTRY_RIPENCC    }, // 193.203.216.0   - 193.203.223.255
	{ 0xc1cbe100, 0xc1cbffff, REGISTRY_RIPENCC    }, // 193.203.225.0   - 193.203.255.255
	{ 0xc1cc0000, 0xc1d9ffff, REGISTRY_RIPENCC    }, // 193.204.0.0     - 193.217.255.255
	{ 0xc1da0000, 0xc1da06ff, REGISTRY_RIPENCC    }, // 193.218.0.0     - 193.218.6.255
	{ 0xc1da0800, 0xc1da1fff, REGISTRY_RIPENCC    }, // 193.218.8.0     - 193.218.31.255
	{ 0xc1da2000, 0xc1da23ff, REGISTRY_RIPENCC    }, // 193.218.32.0    - 193.218.35.255
	{ 0xc1da2400, 0xc1da24ff, REGISTRY_RIPENCC    }, // 193.218.36.0    - 193.218.36.255
	{ 0xc1da2900, 0xc1da2aff, REGISTRY_RIPENCC    }, // 193.218.41.0    - 193.218.42.255
	{ 0xc1da2c00, 0xc1da51ff, REGISTRY_RIPENCC    }, // 193.218.44.0    - 193.218.81.255
	{ 0xc1da5400, 0xc1da62ff, REGISTRY_RIPENCC    }, // 193.218.84.0    - 193.218.98.255
	{ 0xc1da6300, 0xc1da63ff, REGISTRY_RIPENCC    }, // 193.218.99.0    - 193.218.99.255
	{ 0xc1da6400, 0xc1da68ff, REGISTRY_RIPENCC    }, // 193.218.100.0   - 193.218.104.255
	{ 0xc1da6a00, 0xc1da75ff, REGISTRY_RIPENCC    }, // 193.218.106.0   - 193.218.117.255
	{ 0xc1da7800, 0xc1da78ff, REGISTRY_RIPENCC    }, // 193.218.120.0   - 193.218.120.255
	{ 0xc1da7a00, 0xc1da7aff, REGISTRY_RIPENCC    }, // 193.218.122.0   - 193.218.122.255
	{ 0xc1da7c00, 0xc1da7fff, REGISTRY_RIPENCC    }, // 193.218.124.0   - 193.218.127.255
	{ 0xc1da8000, 0xc1da83ff, REGISTRY_RIPENCC    }, // 193.218.128.0   - 193.218.131.255
	{ 0xc1da8400, 0xc1da9bff, REGISTRY_RIPENCC    }, // 193.218.132.0   - 193.218.155.255
	{ 0xc1da9c00, 0xc1daafff, REGISTRY_RIPENCC    }, // 193.218.156.0   - 193.218.175.255
	{ 0xc1dab000, 0xc1dac7ff, REGISTRY_RIPENCC    }, // 193.218.176.0   - 193.218.199.255
	{ 0xc1daca00, 0xc1dacaff, REGISTRY_RIPENCC    }, // 193.218.202.0   - 193.218.202.255
	{ 0xc1dacd00, 0xc1dacf3f, REGISTRY_RIPENCC    }, // 193.218.205.0   - 193.218.207.63
	{ 0xc1dacf50, 0xc1dacf7f, REGISTRY_RIPENCC    }, // 193.218.207.80  - 193.218.207.127
	{ 0xc1dacf80, 0xc1daddff, REGISTRY_RIPENCC    }, // 193.218.207.128 - 193.218.221.255
	{ 0xc1dadf00, 0xc1daffff, REGISTRY_RIPENCC    }, // 193.218.223.0   - 193.218.255.255
	{ 0xc1db0100, 0xc1db06ff, REGISTRY_RIPENCC    }, // 193.219.1.0     - 193.219.6.255
	{ 0xc1db0800, 0xc1db1fff, REGISTRY_RIPENCC    }, // 193.219.8.0     - 193.219.31.255
	{ 0xc1db2000, 0xc1db5fff, REGISTRY_RIPENCC    }, // 193.219.32.0    - 193.219.95.255
	{ 0xc1db6000, 0xc1db62ff, REGISTRY_RIPENCC    }, // 193.219.96.0    - 193.219.98.255
	{ 0xc1db6400, 0xc1db64ff, REGISTRY_RIPENCC    }, // 193.219.100.0   - 193.219.100.255
	{ 0xc1db6600, 0xc1db78ff, REGISTRY_RIPENCC    }, // 193.219.102.0   - 193.219.120.255
	{ 0xc1db7a00, 0xc1db7fff, REGISTRY_RIPENCC    }, // 193.219.122.0   - 193.219.127.255
	{ 0xc1db8000, 0xc1dcffff, REGISTRY_RIPENCC    }, // 193.219.128.0   - 193.220.255.255
	{ 0xc1dd0000, 0xc1dd0fff, REGISTRY_RIPENCC    }, // 193.221.0.0     - 193.221.15.255
	{ 0xc1dd1000, 0xc1dd53ff, REGISTRY_RIPENCC    }, // 193.221.16.0    - 193.221.83.255
	{ 0xc1dd5400, 0xc1dd5cff, REGISTRY_RIPENCC    }, // 193.221.84.0    - 193.221.92.255
	{ 0xc1dd6000, 0xc1dd77ff, REGISTRY_RIPENCC    }, // 193.221.96.0    - 193.221.119.255
	{ 0xc1dd7900, 0xc1dd7aff, REGISTRY_RIPENCC    }, // 193.221.121.0   - 193.221.122.255
	{ 0xc1dd7c00, 0xc1ddbfff, REGISTRY_RIPENCC    }, // 193.221.124.0   - 193.221.191.255
	{ 0xc1ddc000, 0xc1ddd7ff, REGISTRY_RIPENCC    }, // 193.221.192.0   - 193.221.215.255
	{ 0xc1ddda00, 0xc1dddaff, REGISTRY_AFRINIC    }, // 193.221.218.0   - 193.221.218.255
	{ 0xc1dddc00, 0xc1dddfff, REGISTRY_RIPENCC    }, // 193.221.220.0   - 193.221.223.255
	{ 0xc1dde000, 0xc1de31ff, REGISTRY_RIPENCC    }, // 193.221.224.0   - 193.222.49.255
	{ 0xc1de3300, 0xc1de3bff, REGISTRY_RIPENCC    }, // 193.222.51.0    - 193.222.59.255
	{ 0xc1de3d00, 0xc1de5fff, REGISTRY_RIPENCC    }, // 193.222.61.0    - 193.222.95.255
	{ 0xc1de6000, 0xc1de67ff, REGISTRY_RIPENCC    }, // 193.222.96.0    - 193.222.103.255
	{ 0xc1de6a00, 0xc1de6eff, REGISTRY_RIPENCC    }, // 193.222.106.0   - 193.222.110.255
	{ 0xc1de7000, 0xc1de8aff, REGISTRY_RIPENCC    }, // 193.222.112.0   - 193.222.138.255
	{ 0xc1de8c00, 0xc1de8dff, REGISTRY_RIPENCC    }, // 193.222.140.0   - 193.222.141.255
	{ 0xc1de9000, 0xc1de93ff, REGISTRY_RIPENCC    }, // 193.222.144.0   - 193.222.147.255
	{ 0xc1de9400, 0xc1debbff, REGISTRY_RIPENCC    }, // 193.222.148.0   - 193.222.187.255
	{ 0xc1debe00, 0xc1defaff, REGISTRY_RIPENCC    }, // 193.222.190.0   - 193.222.250.255
	{ 0xc1defe00, 0xc1df3fff, REGISTRY_RIPENCC    }, // 193.222.254.0   - 193.223.63.255
	{ 0xc1df4000, 0xc1df44ff, REGISTRY_RIPENCC    }, // 193.223.64.0    - 193.223.68.255
	{ 0xc1df4800, 0xc1df4bff, REGISTRY_RIPENCC    }, // 193.223.72.0    - 193.223.75.255
	{ 0xc1df4c00, 0xc1df5fff, REGISTRY_RIPENCC    }, // 193.223.76.0    - 193.223.95.255
	{ 0xc1df6200, 0xc1df66ff, REGISTRY_RIPENCC    }, // 193.223.98.0    - 193.223.102.255
	{ 0xc1df6800, 0xc1df6bff, REGISTRY_RIPENCC    }, // 193.223.104.0   - 193.223.107.255
	{ 0xc1df6d00, 0xc1df6dff, REGISTRY_RIPENCC    }, // 193.223.109.0   - 193.223.109.255
	{ 0xc1df7000, 0xc1dff7ff, REGISTRY_RIPENCC    }, // 193.223.112.0   - 193.223.247.255
	{ 0xc1dffe00, 0xc1dfffff, REGISTRY_RIPENCC    }, // 193.223.254.0   - 193.223.255.255
	{ 0xc1e00000, 0xc1e2ffff, REGISTRY_RIPENCC    }, // 193.224.0.0     - 193.226.255.255
	{ 0xc1e30000, 0xc1e33fff, REGISTRY_AFRINIC    }, // 193.227.0.0     - 193.227.63.255
	{ 0xc1e34000, 0xc1e35fff, REGISTRY_RIPENCC    }, // 193.227.64.0    - 193.227.95.255
	{ 0xc1e36000, 0xc1e366ff, REGISTRY_RIPENCC    }, // 193.227.96.0    - 193.227.102.255
	{ 0xc1e36800, 0xc1e36cff, REGISTRY_RIPENCC    }, // 193.227.104.0   - 193.227.108.255
	{ 0xc1e36e00, 0xc1e371ff, REGISTRY_RIPENCC    }, // 193.227.110.0   - 193.227.113.255
	{ 0xc1e37300, 0xc1e378ff, REGISTRY_RIPENCC    }, // 193.227.115.0   - 193.227.120.255
	{ 0xc1e37b00, 0xc1e37cff, REGISTRY_RIPENCC    }, // 193.227.123.0   - 193.227.124.255
	{ 0xc1e37e00, 0xc1e37fff, REGISTRY_RIPENCC    }, // 193.227.126.0   - 193.227.127.255
	{ 0xc1e38000, 0xc1e380ff, REGISTRY_AFRINIC    }, // 193.227.128.0   - 193.227.128.255
	{ 0xc1e38200, 0xc1e386ff, REGISTRY_RIPENCC    }, // 193.227.130.0   - 193.227.134.255
	{ 0xc1e38800, 0xc1e39fff, REGISTRY_RIPENCC    }, // 193.227.136.0   - 193.227.159.255
	{ 0xc1e3a000, 0xc1e3bfff, REGISTRY_RIPENCC    }, // 193.227.160.0   - 193.227.191.255
	{ 0xc1e3c000, 0xc1e3ebff, REGISTRY_RIPENCC    }, // 193.227.192.0   - 193.227.235.255
	{ 0xc1e3ee00, 0xc1e3f1ff, REGISTRY_RIPENCC    }, // 193.227.238.0   - 193.227.241.255
	{ 0xc1e3f400, 0xc1e402ff, REGISTRY_RIPENCC    }, // 193.227.244.0   - 193.228.2.255
	{ 0xc1e40400, 0xc1e409ff, REGISTRY_RIPENCC    }, // 193.228.4.0     - 193.228.9.255
	{ 0xc1e40c00, 0xc1e40fff, REGISTRY_RIPENCC    }, // 193.228.12.0    - 193.228.15.255
	{ 0xc1e41000, 0xc1e42fff, REGISTRY_RIPENCC    }, // 193.228.16.0    - 193.228.47.255
	{ 0xc1e43000, 0xc1e43bff, REGISTRY_RIPENCC    }, // 193.228.48.0    - 193.228.59.255
	{ 0xc1e43d00, 0xc1e447ff, REGISTRY_RIPENCC    }, // 193.228.61.0    - 193.228.71.255
	{ 0xc1e44800, 0xc1e44fff, REGISTRY_RIPENCC    }, // 193.228.72.0    - 193.228.79.255
	{ 0xc1e45000, 0xc1e459ff, REGISTRY_RIPENCC    }, // 193.228.80.0    - 193.228.89.255
	{ 0xc1e45c00, 0xc1e464ff, REGISTRY_RIPENCC    }, // 193.228.92.0    - 193.228.100.255
	{ 0xc1e46600, 0xc1e46bff, REGISTRY_RIPENCC    }, // 193.228.102.0   - 193.228.107.255
	{ 0xc1e47000, 0xc1e47aff, REGISTRY_RIPENCC    }, // 193.228.112.0   - 193.228.122.255
	{ 0xc1e47c00, 0xc1e48bff, REGISTRY_RIPENCC    }, // 193.228.124.0   - 193.228.139.255
	{ 0xc1e48d00, 0xc1e48dff, REGISTRY_RIPENCC    }, // 193.228.141.0   - 193.228.141.255
	{ 0xc1e48f00, 0xc1e490ff, REGISTRY_RIPENCC    }, // 193.228.143.0   - 193.228.144.255
	{ 0xc1e49200, 0xc1e493ff, REGISTRY_RIPENCC    }, // 193.228.146.0   - 193.228.147.255
	{ 0xc1e49500, 0xc1e49fff, REGISTRY_RIPENCC    }, // 193.228.149.0   - 193.228.159.255
	{ 0xc1e4a000, 0xc1e4a7ff, REGISTRY_RIPENCC    }, // 193.228.160.0   - 193.228.167.255
	{ 0xc1e4aa00, 0xc1e4abff, REGISTRY_RIPENCC    }, // 193.228.170.0   - 193.228.171.255
	{ 0xc1e4ae00, 0xc1e4aeff, REGISTRY_RIPENCC    }, // 193.228.174.0   - 193.228.174.255
	{ 0xc1e4b000, 0xc1e4b4ff, REGISTRY_RIPENCC    }, // 193.228.176.0   - 193.228.180.255
	{ 0xc1e4b800, 0xc1e4b8ff, REGISTRY_RIPENCC    }, // 193.228.184.0   - 193.228.184.255
	{ 0xc1e4bb00, 0xc1e4bbff, REGISTRY_RIPENCC    }, // 193.228.187.0   - 193.228.187.255
	{ 0xc1e4bc00, 0xc1e4bfff, REGISTRY_RIPENCC    }, // 193.228.188.0   - 193.228.191.255
	{ 0xc1e4c000, 0xc1e4c0ff, REGISTRY_RIPENCC    }, // 193.228.192.0   - 193.228.192.255
	{ 0xc1e4c500, 0xc1e4c6ff, REGISTRY_RIPENCC    }, // 193.228.197.0   - 193.228.198.255
	{ 0xc1e4c800, 0xc1e4cbff, REGISTRY_RIPENCC    }, // 193.228.200.0   - 193.228.203.255
	{ 0xc1e4cf00, 0xc1e4dfff, REGISTRY_RIPENCC    }, // 193.228.207.0   - 193.228.223.255
	{ 0xc1e4e300, 0xc1e4e3ff, REGISTRY_RIPENCC    }, // 193.228.227.0   - 193.228.227.255
	{ 0xc1e4e400, 0xc1e4e7ff, REGISTRY_RIPENCC    }, // 193.228.228.0   - 193.228.231.255
	{ 0xc1e4e800, 0xc1e4eaff, REGISTRY_RIPENCC    }, // 193.228.232.0   - 193.228.234.255
	{ 0xc1e4ec00, 0xc1ec1fff, REGISTRY_RIPENCC    }, // 193.228.236.0   - 193.236.31.255
	{ 0xc1ec2000, 0xc1ec5fff, REGISTRY_RIPENCC    }, // 193.236.32.0    - 193.236.95.255
	{ 0xc1ec6000, 0xc1ec77ff, REGISTRY_RIPENCC    }, // 193.236.96.0    - 193.236.119.255
	{ 0xc1ec7800, 0xc1ec7bff, REGISTRY_RIPENCC    }, // 193.236.120.0   - 193.236.123.255
	{ 0xc1ec7c00, 0xc1ec7fff, REGISTRY_RIPENCC    }, // 193.236.124.0   - 193.236.127.255
	{ 0xc1ec8000, 0xc1ec97ff, REGISTRY_RIPENCC    }, // 193.236.128.0   - 193.236.151.255
	{ 0xc1ec9800, 0xc1ecafff, REGISTRY_RIPENCC    }, // 193.236.152.0   - 193.236.175.255
	{ 0xc1ecb000, 0xc1ecb1ff, REGISTRY_RIPENCC    }, // 193.236.176.0   - 193.236.177.255
	{ 0xc1ecb200, 0xc1ee03ff, REGISTRY_RIPENCC    }, // 193.236.178.0   - 193.238.3.255
	{ 0xc1ee0400, 0xc1ee27ff, REGISTRY_RIPENCC    }, // 193.238.4.0     - 193.238.39.255
	{ 0xc1ee2800, 0xc1ee2fff, REGISTRY_RIPENCC    }, // 193.238.40.0    - 193.238.47.255
	{ 0xc1ee3000, 0xc1ee53ff, REGISTRY_RIPENCC    }, // 193.238.48.0    - 193.238.83.255
	{ 0xc1ee5400, 0xc1ee57ff, REGISTRY_RIPENCC    }, // 193.238.84.0    - 193.238.87.255
	{ 0xc1ee5800, 0xc1ee77ff, REGISTRY_RIPENCC    }, // 193.238.88.0    - 193.238.119.255
	{ 0xc1ee7800, 0xc1ee7bff, REGISTRY_RIPENCC    }, // 193.238.120.0   - 193.238.123.255
	{ 0xc1ee7c00, 0xc1ee9bff, REGISTRY_RIPENCC    }, // 193.238.124.0   - 193.238.155.255
	{ 0xc1ee9c00, 0xc1ee9fff, REGISTRY_RIPENCC    }, // 193.238.156.0   - 193.238.159.255
	{ 0xc1eea000, 0xc1eeb7ff, REGISTRY_RIPENCC    }, // 193.238.160.0   - 193.238.183.255
	{ 0xc1eeb800, 0xc1eebbff, REGISTRY_RIPENCC    }, // 193.238.184.0   - 193.238.187.255
	{ 0xc1eebc00, 0xc1eebfff, REGISTRY_RIPENCC    }, // 193.238.188.0   - 193.238.191.255
	{ 0xc1eec000, 0xc1eec3ff, REGISTRY_RIPENCC    }, // 193.238.192.0   - 193.238.195.255
	{ 0xc1eec400, 0xc1eed3ff, REGISTRY_RIPENCC    }, // 193.238.196.0   - 193.238.211.255
	{ 0xc1eed400, 0xc1eedfff, REGISTRY_RIPENCC    }, // 193.238.212.0   - 193.238.223.255
	{ 0xc1eee000, 0xc1eeebff, REGISTRY_RIPENCC    }, // 193.238.224.0   - 193.238.235.255
	{ 0xc1eeec00, 0xc1eeefff, REGISTRY_RIPENCC    }, // 193.238.236.0   - 193.238.239.255
	{ 0xc1eef000, 0xc1eef3ff, REGISTRY_RIPENCC    }, // 193.238.240.0   - 193.238.243.255
	{ 0xc1eef400, 0xc1eef7ff, REGISTRY_RIPENCC    }, // 193.238.244.0   - 193.238.247.255
	{ 0xc1eef800, 0xc1ef1fff, REGISTRY_RIPENCC    }, // 193.238.248.0   - 193.239.31.255
	{ 0xc1ef2000, 0xc1ef23ff, REGISTRY_RIPENCC    }, // 193.239.32.0    - 193.239.35.255
	{ 0xc1ef2400, 0xc1ef53ff, REGISTRY_RIPENCC    }, // 193.239.36.0    - 193.239.83.255
	{ 0xc1ef5400, 0xc1ef57ff, REGISTRY_RIPENCC    }, // 193.239.84.0    - 193.239.87.255
	{ 0xc1ef5800, 0xc1ef91ff, REGISTRY_RIPENCC    }, // 193.239.88.0    - 193.239.145.255
	{ 0xc1ef9400, 0xc1ef95ff, REGISTRY_RIPENCC    }, // 193.239.148.0   - 193.239.149.255
	{ 0xc1ef9800, 0xc1ef99ff, REGISTRY_RIPENCC    }, // 193.239.152.0   - 193.239.153.255
	{ 0xc1ef9c00, 0xc1ef9fff, REGISTRY_RIPENCC    }, // 193.239.156.0   - 193.239.159.255
	{ 0xc1efa200, 0xc1efa3ff, REGISTRY_RIPENCC    }, // 193.239.162.0   - 193.239.163.255
	{ 0xc1efa400, 0xc1efa5ff, REGISTRY_RIPENCC    }, // 193.239.164.0   - 193.239.165.255
	{ 0xc1efa800, 0xc1efb1ff, REGISTRY_RIPENCC    }, // 193.239.168.0   - 193.239.177.255
	{ 0xc1efb400, 0xc1efbdff, REGISTRY_RIPENCC    }, // 193.239.180.0   - 193.239.189.255
	{ 0xc1efc000, 0xc1efc1ff, REGISTRY_RIPENCC    }, // 193.239.192.0   - 193.239.193.255
	{ 0xc1efc200, 0xc1efc3ff, REGISTRY_RIPENCC    }, // 193.239.194.0   - 193.239.195.255
	{ 0xc1efc600, 0xc1efd7ff, REGISTRY_RIPENCC    }, // 193.239.198.0   - 193.239.215.255
	{ 0xc1efd800, 0xc1efd9ff, REGISTRY_RIPENCC    }, // 193.239.216.0   - 193.239.217.255
	{ 0xc1efda00, 0xc1efebff, REGISTRY_RIPENCC    }, // 193.239.218.0   - 193.239.235.255
	{ 0xc1efee00, 0xc1eff3ff, REGISTRY_RIPENCC    }, // 193.239.238.0   - 193.239.243.255
	{ 0xc1eff600, 0xc1efffff, REGISTRY_RIPENCC    }, // 193.239.246.0   - 193.239.255.255
	{ 0xc1f00000, 0xc1f0ffff, REGISTRY_RIPENCC    }, // 193.240.0.0     - 193.240.255.255
	{ 0xc1f10000, 0xc1f262ff, REGISTRY_RIPENCC    }, // 193.241.0.0     - 193.242.98.255
	{ 0xc1f26400, 0xc1f268ff, REGISTRY_RIPENCC    }, // 193.242.100.0   - 193.242.104.255
	{ 0xc1f26b00, 0xc1f26cff, REGISTRY_RIPENCC    }, // 193.242.107.0   - 193.242.108.255
	{ 0xc1f26e00, 0xc1f276ff, REGISTRY_RIPENCC    }, // 193.242.110.0   - 193.242.118.255
	{ 0xc1f27700, 0xc1f277ff, REGISTRY_RIPENCC    }, // 193.242.119.0   - 193.242.119.255
	{ 0xc1f27800, 0xc1f290ff, REGISTRY_RIPENCC    }, // 193.242.120.0   - 193.242.144.255
	{ 0xc1f29200, 0xc1f298ff, REGISTRY_RIPENCC    }, // 193.242.146.0   - 193.242.152.255
	{ 0xc1f29a00, 0xc1f2a3ff, REGISTRY_RIPENCC    }, // 193.242.154.0   - 193.242.163.255
	{ 0xc1f2a400, 0xc1f2a5ff, REGISTRY_RIPENCC    }, // 193.242.164.0   - 193.242.165.255
	{ 0xc1f2a600, 0xc1f2adff, REGISTRY_RIPENCC    }, // 193.242.166.0   - 193.242.173.255
	{ 0xc1f2ae00, 0xc1f2afff, REGISTRY_RIPENCC    }, // 193.242.174.0   - 193.242.175.255
	{ 0xc1f2b000, 0xc1f385ff, REGISTRY_RIPENCC    }, // 193.242.176.0   - 193.243.133.255
	{ 0xc1f38800, 0xc1f395ff, REGISTRY_RIPENCC    }, // 193.243.136.0   - 193.243.149.255
	{ 0xc1f39800, 0xc1f3a0ff, REGISTRY_RIPENCC    }, // 193.243.152.0   - 193.243.160.255
	{ 0xc1f3a200, 0xc1f3a3ff, REGISTRY_RIPENCC    }, // 193.243.162.0   - 193.243.163.255
	{ 0xc1f3a700, 0xc1f3b5ff, REGISTRY_RIPENCC    }, // 193.243.167.0   - 193.243.181.255
	{ 0xc1f3b740, 0xc1f3b77f, REGISTRY_RIPENCC    }, // 193.243.183.64  - 193.243.183.127
	{ 0xc1f3b7c0, 0xc1f3bfff, REGISTRY_RIPENCC    }, // 193.243.183.192 - 193.243.191.255
	{ 0xc1f3c000, 0xc1f603ff, REGISTRY_RIPENCC    }, // 193.243.192.0   - 193.246.3.255
	{ 0xc1f60600, 0xc1f60bff, REGISTRY_RIPENCC    }, // 193.246.6.0     - 193.246.11.255
	{ 0xc1f60c00, 0xc1f60fff, REGISTRY_RIPENCC    }, // 193.246.12.0    - 193.246.15.255
	{ 0xc1f61000, 0xc1f617ff, REGISTRY_RIPENCC    }, // 193.246.16.0    - 193.246.23.255
	{ 0xc1f61800, 0xc1f61fff, REGISTRY_RIPENCC    }, // 193.246.24.0    - 193.246.31.255
	{ 0xc1f62000, 0xc1f632ff, REGISTRY_RIPENCC    }, // 193.246.32.0    - 193.246.50.255
	{ 0xc1f63400, 0xc1f637ff, REGISTRY_RIPENCC    }, // 193.246.52.0    - 193.246.55.255
	{ 0xc1f63800, 0xc1f63dff, REGISTRY_RIPENCC    }, // 193.246.56.0    - 193.246.61.255
	{ 0xc1f63e00, 0xc1f661ff, REGISTRY_RIPENCC    }, // 193.246.62.0    - 193.246.97.255
	{ 0xc1f66200, 0xc1f664ff, REGISTRY_RIPENCC    }, // 193.246.98.0    - 193.246.100.255
	{ 0xc1f66500, 0xc1f665ff, REGISTRY_RIPENCC    }, // 193.246.101.0   - 193.246.101.255
	{ 0xc1f66800, 0xc1f669ff, REGISTRY_RIPENCC    }, // 193.246.104.0   - 193.246.105.255
	{ 0xc1f66a00, 0xc1f66fff, REGISTRY_RIPENCC    }, // 193.246.106.0   - 193.246.111.255
	{ 0xc1f67000, 0xc1f677ff, REGISTRY_RIPENCC    }, // 193.246.112.0   - 193.246.119.255
	{ 0xc1f67800, 0xc1f67aff, REGISTRY_RIPENCC    }, // 193.246.120.0   - 193.246.122.255
	{ 0xc1f67b00, 0xc1f67bff, REGISTRY_RIPENCC    }, // 193.246.123.0   - 193.246.123.255
	{ 0xc1f67c00, 0xc1f67eff, REGISTRY_RIPENCC    }, // 193.246.124.0   - 193.246.126.255
	{ 0xc1f67f00, 0xc1f67fff, REGISTRY_RIPENCC    }, // 193.246.127.0   - 193.246.127.255
	{ 0xc1f68000, 0xc1f68fff, REGISTRY_RIPENCC    }, // 193.246.128.0   - 193.246.143.255
	{ 0xc1f69100, 0xc1f691ff, REGISTRY_RIPENCC    }, // 193.246.145.0   - 193.246.145.255
	{ 0xc1f69700, 0xc1f698ff, REGISTRY_RIPENCC    }, // 193.246.151.0   - 193.246.152.255
	{ 0xc1f69e00, 0xc1f69eff, REGISTRY_RIPENCC    }, // 193.246.158.0   - 193.246.158.255
	{ 0xc1f6a300, 0xc1f6a3ff, REGISTRY_RIPENCC    }, // 193.246.163.0   - 193.246.163.255
	{ 0xc1f6a600, 0xc1f6a6ff, REGISTRY_RIPENCC    }, // 193.246.166.0   - 193.246.166.255
	{ 0xc1f6a800, 0xc1f6abff, REGISTRY_RIPENCC    }, // 193.246.168.0   - 193.246.171.255
	{ 0xc1f6ac00, 0xc1f6adff, REGISTRY_RIPENCC    }, // 193.246.172.0   - 193.246.173.255
	{ 0xc1f6b000, 0xc1f6c7ff, REGISTRY_RIPENCC    }, // 193.246.176.0   - 193.246.199.255
	{ 0xc1f6ca00, 0xc1f6cdff, REGISTRY_RIPENCC    }, // 193.246.202.0   - 193.246.205.255
	{ 0xc1f6cf00, 0xc1f6cfff, REGISTRY_RIPENCC    }, // 193.246.207.0   - 193.246.207.255
	{ 0xc1f6d000, 0xc1f6dfff, REGISTRY_RIPENCC    }, // 193.246.208.0   - 193.246.223.255
	{ 0xc1f6e000, 0xc1f6f1ff, REGISTRY_RIPENCC    }, // 193.246.224.0   - 193.246.241.255
	{ 0xc1f6f200, 0xc1f6f4ff, REGISTRY_RIPENCC    }, // 193.246.242.0   - 193.246.244.255
	{ 0xc1f6f600, 0xc1f6f6ff, REGISTRY_RIPENCC    }, // 193.246.246.0   - 193.246.246.255
	{ 0xc1f6f700, 0xc1f6f7ff, REGISTRY_RIPENCC    }, // 193.246.247.0   - 193.246.247.255
	{ 0xc1f6f800, 0xc1f6fbff, REGISTRY_RIPENCC    }, // 193.246.248.0   - 193.246.251.255
	{ 0xc1f6fc00, 0xc1f723ff, REGISTRY_RIPENCC    }, // 193.246.252.0   - 193.247.35.255
	{ 0xc1f72400, 0xc1f72fff, REGISTRY_RIPENCC    }, // 193.247.36.0    - 193.247.47.255
	{ 0xc1f73000, 0xc1f73fff, REGISTRY_RIPENCC    }, // 193.247.48.0    - 193.247.63.255
	{ 0xc1f74000, 0xc1f741ff, REGISTRY_RIPENCC    }, // 193.247.64.0    - 193.247.65.255
	{ 0xc1f74200, 0xc1f743ff, REGISTRY_RIPENCC    }, // 193.247.66.0    - 193.247.67.255
	{ 0xc1f74400, 0xc1f747ff, REGISTRY_RIPENCC    }, // 193.247.68.0    - 193.247.71.255
	{ 0xc1f74800, 0xc1f748ff, REGISTRY_RIPENCC    }, // 193.247.72.0    - 193.247.72.255
	{ 0xc1f74c00, 0xc1f74cff, REGISTRY_RIPENCC    }, // 193.247.76.0    - 193.247.76.255
	{ 0xc1f74e00, 0xc1f74fff, REGISTRY_RIPENCC    }, // 193.247.78.0    - 193.247.79.255
	{ 0xc1f75000, 0xc1f750ff, REGISTRY_RIPENCC    }, // 193.247.80.0    - 193.247.80.255
	{ 0xc1f75300, 0xc1f755ff, REGISTRY_RIPENCC    }, // 193.247.83.0    - 193.247.85.255
	{ 0xc1f75600, 0xc1f756ff, REGISTRY_RIPENCC    }, // 193.247.86.0    - 193.247.86.255
	{ 0xc1f75700, 0xc1f759ff, REGISTRY_RIPENCC    }, // 193.247.87.0    - 193.247.89.255
	{ 0xc1f75a00, 0xc1f75cff, REGISTRY_RIPENCC    }, // 193.247.90.0    - 193.247.92.255
	{ 0xc1f75d00, 0xc1f75dff, REGISTRY_RIPENCC    }, // 193.247.93.0    - 193.247.93.255
	{ 0xc1f75f00, 0xc1f764ff, REGISTRY_RIPENCC    }, // 193.247.95.0    - 193.247.100.255
	{ 0xc1f76600, 0xc1f766ff, REGISTRY_RIPENCC    }, // 193.247.102.0   - 193.247.102.255
	{ 0xc1f76800, 0xc1f76aff, REGISTRY_RIPENCC    }, // 193.247.104.0   - 193.247.106.255
	{ 0xc1f76b00, 0xc1f77dff, REGISTRY_RIPENCC    }, // 193.247.107.0   - 193.247.125.255
	{ 0xc1f78000, 0xc1f790ff, REGISTRY_RIPENCC    }, // 193.247.128.0   - 193.247.144.255
	{ 0xc1f79100, 0xc1f791ff, REGISTRY_RIPENCC    }, // 193.247.145.0   - 193.247.145.255
	{ 0xc1f79200, 0xc1f796ff, REGISTRY_RIPENCC    }, // 193.247.146.0   - 193.247.150.255
	{ 0xc1f79700, 0xc1f797ff, REGISTRY_RIPENCC    }, // 193.247.151.0   - 193.247.151.255
	{ 0xc1f79800, 0xc1f79fff, REGISTRY_RIPENCC    }, // 193.247.152.0   - 193.247.159.255
	{ 0xc1f7a000, 0xc1f7a1ff, REGISTRY_RIPENCC    }, // 193.247.160.0   - 193.247.161.255
	{ 0xc1f7a200, 0xc1f7a4ff, REGISTRY_RIPENCC    }, // 193.247.162.0   - 193.247.164.255
	{ 0xc1f7a600, 0xc1f7b3ff, REGISTRY_RIPENCC    }, // 193.247.166.0   - 193.247.179.255
	{ 0xc1f7b400, 0xc1f7b4ff, REGISTRY_RIPENCC    }, // 193.247.180.0   - 193.247.180.255
	{ 0xc1f7b600, 0xc1f7b6ff, REGISTRY_RIPENCC    }, // 193.247.182.0   - 193.247.182.255
	{ 0xc1f7b800, 0xc1f7b9ff, REGISTRY_RIPENCC    }, // 193.247.184.0   - 193.247.185.255
	{ 0xc1f7ba00, 0xc1f7baff, REGISTRY_RIPENCC    }, // 193.247.186.0   - 193.247.186.255
	{ 0xc1f7bb00, 0xc1f7bfff, REGISTRY_RIPENCC    }, // 193.247.187.0   - 193.247.191.255
	{ 0xc1f7c100, 0xc1f7c1ff, REGISTRY_RIPENCC    }, // 193.247.193.0   - 193.247.193.255
	{ 0xc1f7c400, 0xc1f7c7ff, REGISTRY_RIPENCC    }, // 193.247.196.0   - 193.247.199.255
	{ 0xc1f7c800, 0xc1f7c8ff, REGISTRY_RIPENCC    }, // 193.247.200.0   - 193.247.200.255
	{ 0xc1f7c900, 0xc1f7c9ff, REGISTRY_RIPENCC    }, // 193.247.201.0   - 193.247.201.255
	{ 0xc1f7cb00, 0xc1f7cbff, REGISTRY_RIPENCC    }, // 193.247.203.0   - 193.247.203.255
	{ 0xc1f7cc00, 0xc1f7ccff, REGISTRY_RIPENCC    }, // 193.247.204.0   - 193.247.204.255
	{ 0xc1f7cd00, 0xc1f7d3ff, REGISTRY_RIPENCC    }, // 193.247.205.0   - 193.247.211.255
	{ 0xc1f7d400, 0xc1f7d4ff, REGISTRY_RIPENCC    }, // 193.247.212.0   - 193.247.212.255
	{ 0xc1f7d900, 0xc1f7ebff, REGISTRY_RIPENCC    }, // 193.247.217.0   - 193.247.235.255
	{ 0xc1f7ee00, 0xc1f7f3ff, REGISTRY_RIPENCC    }, // 193.247.238.0   - 193.247.243.255
	{ 0xc1f7f400, 0xc1f7f7ff, REGISTRY_RIPENCC    }, // 193.247.244.0   - 193.247.247.255
	{ 0xc1f7f800, 0xc1f7f9ff, REGISTRY_RIPENCC    }, // 193.247.248.0   - 193.247.249.255
	{ 0xc1f7fa00, 0xc1f7faff, REGISTRY_RIPENCC    }, // 193.247.250.0   - 193.247.250.255
	{ 0xc1f7fb00, 0xc1f7feff, REGISTRY_RIPENCC    }, // 193.247.251.0   - 193.247.254.255
	{ 0xc1f7ff00, 0xc1fdffff, REGISTRY_RIPENCC    }, // 193.247.255.0   - 193.253.255.255
	{ 0xc1fe0100, 0xc1fe02ff, REGISTRY_RIPENCC    }, // 193.254.1.0     - 193.254.2.255
	{ 0xc1fe0400, 0xc1fe07ff, REGISTRY_RIPENCC    }, // 193.254.4.0     - 193.254.7.255
	{ 0xc1fe0800, 0xc1fe0fff, REGISTRY_RIPENCC    }, // 193.254.8.0     - 193.254.15.255
	{ 0xc1fe1200, 0xc1fe1aff, REGISTRY_RIPENCC    }, // 193.254.18.0    - 193.254.26.255
	{ 0xc1fe1d00, 0xc1fe1fff, REGISTRY_RIPENCC    }, // 193.254.29.0    - 193.254.31.255
	{ 0xc1fe2000, 0xc1feafff, REGISTRY_RIPENCC    }, // 193.254.32.0    - 193.254.175.255
	{ 0xc1feb000, 0xc1feb7ff, REGISTRY_RIPENCC    }, // 193.254.176.0   - 193.254.183.255
	{ 0xc1feb800, 0xc1febfff, REGISTRY_RIPENCC    }, // 193.254.184.0   - 193.254.191.255
	{ 0xc1fec000, 0xc1fecbff, REGISTRY_RIPENCC    }, // 193.254.192.0   - 193.254.203.255
	{ 0xc1fece00, 0xc1fed9ff, REGISTRY_RIPENCC    }, // 193.254.206.0   - 193.254.217.255
	{ 0xc1fedc00, 0xc1fee9ff, REGISTRY_RIPENCC    }, // 193.254.220.0   - 193.254.233.255
	{ 0xc1feec00, 0xc1fef3ff, REGISTRY_RIPENCC    }, // 193.254.236.0   - 193.254.243.255
	{ 0xc1fef600, 0xc1fef7ff, REGISTRY_RIPENCC    }, // 193.254.246.0   - 193.254.247.255
	{ 0xc1fef800, 0xc1fef9ff, REGISTRY_RIPENCC    }, // 193.254.248.0   - 193.254.249.255
	{ 0xc1fefa00, 0xc1feffff, REGISTRY_RIPENCC    }, // 193.254.250.0   - 193.254.255.255
	{ 0xc1ff0000, 0xc1ffffff, REGISTRY_RIPENCC    }, // 193.255.0.0     - 193.255.255.255
	{ 0xc2000000, 0xc20047ff, REGISTRY_RIPENCC    }, // 194.0.0.0       - 194.0.71.255
	{ 0xc2004800, 0xc2004fff, REGISTRY_RIPENCC    }, // 194.0.72.0      - 194.0.79.255
	{ 0xc2005000, 0xc20067ff, REGISTRY_RIPENCC    }, // 194.0.80.0      - 194.0.103.255
	{ 0xc2006800, 0xc2006bff, REGISTRY_RIPENCC    }, // 194.0.104.0     - 194.0.107.255
	{ 0xc2006c00, 0xc20073ff, REGISTRY_RIPENCC    }, // 194.0.108.0     - 194.0.115.255
	{ 0xc2007400, 0xc20077ff, REGISTRY_RIPENCC    }, // 194.0.116.0     - 194.0.119.255
	{ 0xc2007800, 0xc2007bff, REGISTRY_RIPENCC    }, // 194.0.120.0     - 194.0.123.255
	{ 0xc2007c00, 0xc2007fff, REGISTRY_RIPENCC    }, // 194.0.124.0     - 194.0.127.255
	{ 0xc2008000, 0xc20084ff, REGISTRY_RIPENCC    }, // 194.0.128.0     - 194.0.132.255
	{ 0xc2008600, 0xc20087ff, REGISTRY_RIPENCC    }, // 194.0.134.0     - 194.0.135.255
	{ 0xc2008900, 0xc2008aff, REGISTRY_RIPENCC    }, // 194.0.137.0     - 194.0.138.255
	{ 0xc2008c00, 0xc2008cff, REGISTRY_RIPENCC    }, // 194.0.140.0     - 194.0.140.255
	{ 0xc2008e00, 0xc2009eff, REGISTRY_RIPENCC    }, // 194.0.142.0     - 194.0.158.255
	{ 0xc200a000, 0xc200a7ff, REGISTRY_RIPENCC    }, // 194.0.160.0     - 194.0.167.255
	{ 0xc200a900, 0xc200a9ff, REGISTRY_RIPENCC    }, // 194.0.169.0     - 194.0.169.255
	{ 0xc200ab00, 0xc200b1ff, REGISTRY_RIPENCC    }, // 194.0.171.0     - 194.0.177.255
	{ 0xc200b300, 0xc200b3ff, REGISTRY_RIPENCC    }, // 194.0.179.0     - 194.0.179.255
	{ 0xc200b500, 0xc200b9ff, REGISTRY_RIPENCC    }, // 194.0.181.0     - 194.0.185.255
	{ 0xc200bb00, 0xc200bbff, REGISTRY_RIPENCC    }, // 194.0.187.0     - 194.0.187.255
	{ 0xc200be00, 0xc200c0ff, REGISTRY_RIPENCC    }, // 194.0.190.0     - 194.0.192.255
	{ 0xc200c200, 0xc200ceff, REGISTRY_RIPENCC    }, // 194.0.194.0     - 194.0.206.255
	{ 0xc200d000, 0xc200dcff, REGISTRY_RIPENCC    }, // 194.0.208.0     - 194.0.220.255
	{ 0xc200de00, 0xc200deff, REGISTRY_RIPENCC    }, // 194.0.222.0     - 194.0.222.255
	{ 0xc200e000, 0xc200e0ff, REGISTRY_RIPENCC    }, // 194.0.224.0     - 194.0.224.255
	{ 0xc200e200, 0xc200e2ff, REGISTRY_RIPENCC    }, // 194.0.226.0     - 194.0.226.255
	{ 0xc200e500, 0xc200e6ff, REGISTRY_RIPENCC    }, // 194.0.229.0     - 194.0.230.255
	{ 0xc200e800, 0xc200f2ff, REGISTRY_RIPENCC    }, // 194.0.232.0     - 194.0.242.255
	{ 0xc200f600, 0xc200f7ff, REGISTRY_RIPENCC    }, // 194.0.246.0     - 194.0.247.255
	{ 0xc200f900, 0xc201b0ff, REGISTRY_RIPENCC    }, // 194.0.249.0     - 194.1.176.255
	{ 0xc201b200, 0xc201b2ff, REGISTRY_RIPENCC    }, // 194.1.178.0     - 194.1.178.255
	{ 0xc201b400, 0xc201b7ff, REGISTRY_RIPENCC    }, // 194.1.180.0     - 194.1.183.255
	{ 0xc201b900, 0xc201b9ff, REGISTRY_RIPENCC    }, // 194.1.185.0     - 194.1.185.255
	{ 0xc201bc00, 0xc201bfff, REGISTRY_RIPENCC    }, // 194.1.188.0     - 194.1.191.255
	{ 0xc201c100, 0xc201d9ff, REGISTRY_RIPENCC    }, // 194.1.193.0     - 194.1.217.255
	{ 0xc201db00, 0xc201f3ff, REGISTRY_RIPENCC    }, // 194.1.219.0     - 194.1.243.255
	{ 0xc201f5