/*  PCSX2 - PS2 Emulator for PCs
 *  Copyright (C) 2002-2022  PCSX2 Dev Team
 *
 *  PCSX2 is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU Lesser General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  PCSX2 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with PCSX2.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "PCSX2Base.h"
#include <string>
#include <vector>

namespace GSDumpReplayer
{
bool IsReplayingDump();

/// If set, playback will repeat once it reaches the last frame.
void SetLoopCount(s32 loop_count = 0);

bool Initialize(const char* filename);
void Reset();
void Shutdown();

std::string GetDumpSerial();
u32 GetDumpCRC();

u32 GetFrameNumber();

void RenderUI();
}