/*  PCSX2 - PS2 Emulator for PCs
 *  Copyright (C) 2002-2021  PCSX2 Dev Team
 *
 *  PCSX2 is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU Lesser General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  PCSX2 is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with PCSX2.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

// We abuse the preprocessor here to only need to specify function names once.
// Function names are prefixed so to not conflict with system symbols at runtime.
#define VULKAN_MODULE_ENTRY_POINT(name, required) extern PFN_##name pcsx2_##name;
#define VULKAN_INSTANCE_ENTRY_POINT(name, required) extern PFN_##name pcsx2_##name;
#define VULKAN_DEVICE_ENTRY_POINT(name, required) extern PFN_##name pcsx2_##name;
#define VULKAN_DEFINE_NAME_PREFIX pcsx2_
#include "EntryPoints.inl"
#undef VULKAN_DEFINE_NAME_PREFIX
#undef VULKAN_DEVICE_ENTRY_POINT
#undef VULKAN_INSTANCE_ENTRY_POINT
#undef VULKAN_MODULE_ENTRY_POINT

#ifdef __cplusplus
}
#endif

#define vkCreateInstance pcsx2_vkCreateInstance
#define vkGetInstanceProcAddr pcsx2_vkGetInstanceProcAddr
#define vkEnumerateInstanceExtensionProperties pcsx2_vkEnumerateInstanceExtensionProperties
#define vkEnumerateInstanceLayerProperties pcsx2_vkEnumerateInstanceLayerProperties
#define vkEnumerateInstanceVersion pcsx2_vkEnumerateInstanceVersion

#define vkGetDeviceProcAddr pcsx2_vkGetDeviceProcAddr
#define vkDestroyInstance pcsx2_vkDestroyInstance
#define vkEnumeratePhysicalDevices pcsx2_vkEnumeratePhysicalDevices
#define vkGetPhysicalDeviceFeatures pcsx2_vkGetPhysicalDeviceFeatures
#define vkGetPhysicalDeviceFormatProperties pcsx2_vkGetPhysicalDeviceFormatProperties
#define vkGetPhysicalDeviceImageFormatProperties pcsx2_vkGetPhysicalDeviceImageFormatProperties
#define vkGetPhysicalDeviceProperties pcsx2_vkGetPhysicalDeviceProperties
#define vkGetPhysicalDeviceQueueFamilyProperties pcsx2_vkGetPhysicalDeviceQueueFamilyProperties
#define vkGetPhysicalDeviceMemoryProperties pcsx2_vkGetPhysicalDeviceMemoryProperties
#define vkCreateDevice pcsx2_vkCreateDevice
#define vkEnumerateDeviceExtensionProperties pcsx2_vkEnumerateDeviceExtensionProperties
#define vkEnumerateDeviceLayerProperties pcsx2_vkEnumerateDeviceLayerProperties
#define vkGetPhysicalDeviceSparseImageFormatProperties pcsx2_vkGetPhysicalDeviceSparseImageFormatProperties
#define vkDestroySurfaceKHR pcsx2_vkDestroySurfaceKHR
#define vkGetPhysicalDeviceSurfaceSupportKHR pcsx2_vkGetPhysicalDeviceSurfaceSupportKHR
#define vkGetPhysicalDeviceSurfaceCapabilitiesKHR pcsx2_vkGetPhysicalDeviceSurfaceCapabilitiesKHR
#define vkGetPhysicalDeviceSurfaceFormatsKHR pcsx2_vkGetPhysicalDeviceSurfaceFormatsKHR
#define vkGetPhysicalDeviceSurfacePresentModesKHR pcsx2_vkGetPhysicalDeviceSurfacePresentModesKHR
#define vkCreateWin32SurfaceKHR pcsx2_vkCreateWin32SurfaceKHR
#define vkGetPhysicalDeviceWin32PresentationSupportKHR pcsx2_vkGetPhysicalDeviceWin32PresentationSupportKHR
#define vkCreateXlibSurfaceKHR pcsx2_vkCreateXlibSurfaceKHR
#define vkGetPhysicalDeviceXlibPresentationSupportKHR pcsx2_vkGetPhysicalDeviceXlibPresentationSupportKHR
#define vkCreateWaylandSurfaceKHR pcsx2_vkCreateWaylandSurfaceKHR
#define vkCreateAndroidSurfaceKHR pcsx2_vkCreateAndroidSurfaceKHR
#define vkCreateMacOSSurfaceMVK pcsx2_vkCreateMacOSSurfaceMVK
#define vkCreateMetalSurfaceEXT pcsx2_vkCreateMetalSurfaceEXT

// VK_EXT_debug_utils
#define vkCmdBeginDebugUtilsLabelEXT pcsx2_vkCmdBeginDebugUtilsLabelEXT
#define vkCmdEndDebugUtilsLabelEXT pcsx2_vkCmdEndDebugUtilsLabelEXT
#define vkCmdInsertDebugUtilsLabelEXT pcsx2_vkCmdInsertDebugUtilsLabelEXT
#define vkCreateDebugUtilsMessengerEXT pcsx2_vkCreateDebugUtilsMessengerEXT
#define vkDestroyDebugUtilsMessengerEXT pcsx2_vkDestroyDebugUtilsMessengerEXT
#define vkQueueBeginDebugUtilsLabelEXT pcsx2_vkQueueBeginDebugUtilsLabelEXT
#define vkQueueEndDebugUtilsLabelEXT pcsx2_vkQueueEndDebugUtilsLabelEXT
#define vkQueueInsertDebugUtilsLabelEXT pcsx2_vkQueueInsertDebugUtilsLabelEXT
#define vkSetDebugUtilsObjectNameEXT pcsx2_vkSetDebugUtilsObjectNameEXT
#define vkSetDebugUtilsObjectTagEXT pcsx2_vkSetDebugUtilsObjectTagEXT
#define vkSubmitDebugUtilsMessageEXT pcsx2_vkSubmitDebugUtilsMessageEXT

#define vkGetPhysicalDeviceSurfaceCapabilities2KHR pcsx2_vkGetPhysicalDeviceSurfaceCapabilities2KHR
#define vkGetPhysicalDeviceDisplayPropertiesKHR pcsx2_vkGetPhysicalDeviceDisplayPropertiesKHR
#define vkGetPhysicalDeviceDisplayPlanePropertiesKHR pcsx2_vkGetPhysicalDeviceDisplayPlanePropertiesKHR
#define vkGetDisplayPlaneSupportedDisplaysKHR pcsx2_vkGetDisplayPlaneSupportedDisplaysKHR
#define vkGetDisplayModePropertiesKHR pcsx2_vkGetDisplayModePropertiesKHR
#define vkCreateDisplayModeKHR pcsx2_vkCreateDisplayModeKHR
#define vkGetDisplayPlaneCapabilitiesKHR pcsx2_vkGetDisplayPlaneCapabilitiesKHR
#define vkCreateDisplayPlaneSurfaceKHR pcsx2_vkCreateDisplayPlaneSurfaceKHR

// Vulkan 1.1 functions.
#define vkGetPhysicalDeviceFeatures2 pcsx2_vkGetPhysicalDeviceFeatures2
#define vkGetPhysicalDeviceProperties2 pcsx2_vkGetPhysicalDeviceProperties2
#define vkGetPhysicalDeviceMemoryProperties2 pcsx2_vkGetPhysicalDeviceMemoryProperties2

#define vkDestroyDevice pcsx2_vkDestroyDevice
#define vkGetDeviceQueue pcsx2_vkGetDeviceQueue
#define vkQueueSubmit pcsx2_vkQueueSubmit
#define vkQueueWaitIdle pcsx2_vkQueueWaitIdle
#define vkDeviceWaitIdle pcsx2_vkDeviceWaitIdle
#define vkAllocateMemory pcsx2_vkAllocateMemory
#define vkFreeMemory pcsx2_vkFreeMemory
#define vkMapMemory pcsx2_vkMapMemory
#define vkUnmapMemory pcsx2_vkUnmapMemory
#define vkFlushMappedMemoryRanges pcsx2_vkFlushMappedMemoryRanges
#define vkInvalidateMappedMemoryRanges pcsx2_vkInvalidateMappedMemoryRanges
#define vkGetDeviceMemoryCommitment pcsx2_vkGetDeviceMemoryCommitment
#define vkBindBufferMemory pcsx2_vkBindBufferMemory
#define vkBindImageMemory pcsx2_vkBindImageMemory
#define vkGetBufferMemoryRequirements pcsx2_vkGetBufferMemoryRequirements
#define vkGetImageMemoryRequirements pcsx2_vkGetImageMemoryRequirements
#define vkGetImageSparseMemoryRequirements pcsx2_vkGetImageSparseMemoryRequirements
#define vkQueueBindSparse pcsx2_vkQueueBindSparse
#define vkCreateFence pcsx2_vkCreateFence
#define vkDestroyFence pcsx2_vkDestroyFence
#define vkResetFences pcsx2_vkResetFences
#define vkGetFenceStatus pcsx2_vkGetFenceStatus
#define vkWaitForFences pcsx2_vkWaitForFences
#define vkCreateSemaphore pcsx2_vkCreateSemaphore
#define vkDestroySemaphore pcsx2_vkDestroySemaphore
#define vkCreateEvent pcsx2_vkCreateEvent
#define vkDestroyEvent pcsx2_vkDestroyEvent
#define vkGetEventStatus pcsx2_vkGetEventStatus
#define vkSetEvent pcsx2_vkSetEvent
#define vkResetEvent pcsx2_vkResetEvent
#define vkCreateQueryPool pcsx2_vkCreateQueryPool
#define vkDestroyQueryPool pcsx2_vkDestroyQueryPool
#define vkGetQueryPoolResults pcsx2_vkGetQueryPoolResults
#define vkCreateBuffer pcsx2_vkCreateBuffer
#define vkDestroyBuffer pcsx2_vkDestroyBuffer
#define vkCreateBufferView pcsx2_vkCreateBufferView
#define vkDestroyBufferView pcsx2_vkDestroyBufferView
#define vkCreateImage pcsx2_vkCreateImage
#define vkDestroyImage pcsx2_vkDestroyImage
#define vkGetImageSubresourceLayout pcsx2_vkGetImageSubresourceLayout
#define vkCreateImageView pcsx2_vkCreateImageView
#define vkDestroyImageView pcsx2_vkDestroyImageView
#define vkCreateShaderModule pcsx2_vkCreateShaderModule
#define vkDestroyShaderModule pcsx2_vkDestroyShaderModule
#define vkCreatePipelineCache pcsx2_vkCreatePipelineCache
#define vkDestroyPipelineCache pcsx2_vkDestroyPipelineCache
#define vkGetPipelineCacheData pcsx2_vkGetPipelineCacheData
#define vkMergePipelineCaches pcsx2_vkMergePipelineCaches
#define vkCreateGraphicsPipelines pcsx2_vkCreateGraphicsPipelines
#define vkCreateComputePipelines pcsx2_vkCreateComputePipelines
#define vkDestroyPipeline pcsx2_vkDestroyPipeline
#define vkCreatePipelineLayout pcsx2_vkCreatePipelineLayout
#define vkDestroyPipelineLayout pcsx2_vkDestroyPipelineLayout
#define vkCreateSampler pcsx2_vkCreateSampler
#define vkDestroySampler pcsx2_vkDestroySampler
#define vkCreateDescriptorSetLayout pcsx2_vkCreateDescriptorSetLayout
#define vkDestroyDescriptorSetLayout pcsx2_vkDestroyDescriptorSetLayout
#define vkCreateDescriptorPool pcsx2_vkCreateDescriptorPool
#define vkDestroyDescriptorPool pcsx2_vkDestroyDescriptorPool
#define vkResetDescriptorPool pcsx2_vkResetDescriptorPool
#define vkAllocateDescriptorSets pcsx2_vkAllocateDescriptorSets
#define vkFreeDescriptorSets pcsx2_vkFreeDescriptorSets
#define vkUpdateDescriptorSets pcsx2_vkUpdateDescriptorSets
#define vkCreateFramebuffer pcsx2_vkCreateFramebuffer
#define vkDestroyFramebuffer pcsx2_vkDestroyFramebuffer
#define vkCreateRenderPass pcsx2_vkCreateRenderPass
#define vkDestroyRenderPass pcsx2_vkDestroyRenderPass
#define vkGetRenderAreaGranularity pcsx2_vkGetRenderAreaGranularity
#define vkCreateCommandPool pcsx2_vkCreateCommandPool
#define vkDestroyCommandPool pcsx2_vkDestroyCommandPool
#define vkResetCommandPool pcsx2_vkResetCommandPool
#define vkAllocateCommandBuffers pcsx2_vkAllocateCommandBuffers
#define vkFreeCommandBuffers pcsx2_vkFreeCommandBuffers
#define vkBeginCommandBuffer pcsx2_vkBeginCommandBuffer
#define vkEndCommandBuffer pcsx2_vkEndCommandBuffer
#define vkResetCommandBuffer pcsx2_vkResetCommandBuffer
#define vkCmdBindPipeline pcsx2_vkCmdBindPipeline
#define vkCmdSetViewport pcsx2_vkCmdSetViewport
#define vkCmdSetScissor pcsx2_vkCmdSetScissor
#define vkCmdSetLineWidth pcsx2_vkCmdSetLineWidth
#define vkCmdSetDepthBias pcsx2_vkCmdSetDepthBias
#define vkCmdSetBlendConstants pcsx2_vkCmdSetBlendConstants
#define vkCmdSetDepthBounds pcsx2_vkCmdSetDepthBounds
#define vkCmdSetStencilCompareMask pcsx2_vkCmdSetStencilCompareMask
#define vkCmdSetStencilWriteMask pcsx2_vkCmdSetStencilWriteMask
#define vkCmdSetStencilReference pcsx2_vkCmdSetStencilReference
#define vkCmdBindDescriptorSets pcsx2_vkCmdBindDescriptorSets
#define vkCmdBindIndexBuffer pcsx2_vkCmdBindIndexBuffer
#define vkCmdBindVertexBuffers pcsx2_vkCmdBindVertexBuffers
#define vkCmdDraw pcsx2_vkCmdDraw
#define vkCmdDrawIndexed pcsx2_vkCmdDrawIndexed
#define vkCmdDrawIndirect pcsx2_vkCmdDrawIndirect
#define vkCmdDrawIndexedIndirect pcsx2_vkCmdDrawIndexedIndirect
#define vkCmdDispatch pcsx2_vkCmdDispatch
#define vkCmdDispatchIndirect pcsx2_vkCmdDispatchIndirect
#define vkCmdCopyBuffer pcsx2_vkCmdCopyBuffer
#define vkCmdCopyImage pcsx2_vkCmdCopyImage
#define vkCmdBlitImage pcsx2_vkCmdBlitImage
#define vkCmdCopyBufferToImage pcsx2_vkCmdCopyBufferToImage
#define vkCmdCopyImageToBuffer pcsx2_vkCmdCopyImageToBuffer
#define vkCmdUpdateBuffer pcsx2_vkCmdUpdateBuffer
#define vkCmdFillBuffer pcsx2_vkCmdFillBuffer
#define vkCmdClearColorImage pcsx2_vkCmdClearColorImage
#define vkCmdClearDepthStencilImage pcsx2_vkCmdClearDepthStencilImage
#define vkCmdClearAttachments pcsx2_vkCmdClearAttachments
#define vkCmdResolveImage pcsx2_vkCmdResolveImage
#define vkCmdSetEvent pcsx2_vkCmdSetEvent
#define vkCmdResetEvent pcsx2_vkCmdResetEvent
#define vkCmdWaitEvents pcsx2_vkCmdWaitEvents
#define vkCmdPipelineBarrier pcsx2_vkCmdPipelineBarrier
#define vkCmdBeginQuery pcsx2_vkCmdBeginQuery
#define vkCmdEndQuery pcsx2_vkCmdEndQuery
#define vkCmdResetQueryPool pcsx2_vkCmdResetQueryPool
#define vkCmdWriteTimestamp pcsx2_vkCmdWriteTimestamp
#define vkCmdCopyQueryPoolResults pcsx2_vkCmdCopyQueryPoolResults
#define vkCmdPushConstants pcsx2_vkCmdPushConstants
#define vkCmdBeginRenderPass pcsx2_vkCmdBeginRenderPass
#define vkCmdNextSubpass pcsx2_vkCmdNextSubpass
#define vkCmdEndRenderPass pcsx2_vkCmdEndRenderPass
#define vkCmdExecuteCommands pcsx2_vkCmdExecuteCommands
#define vkCreateSwapchainKHR pcsx2_vkCreateSwapchainKHR
#define vkDestroySwapchainKHR pcsx2_vkDestroySwapchainKHR
#define vkGetSwapchainImagesKHR pcsx2_vkGetSwapchainImagesKHR
#define vkAcquireNextImageKHR pcsx2_vkAcquireNextImageKHR
#define vkQueuePresentKHR pcsx2_vkQueuePresentKHR

// Vulkan 1.1 functions.
#define vkGetBufferMemoryRequirements2 pcsx2_vkGetBufferMemoryRequirements2
#define vkGetImageMemoryRequirements2 pcsx2_vkGetImageMemoryRequirements2
#define vkBindBufferMemory2 pcsx2_vkBindBufferMemory2
#define vkBindImageMemory2 pcsx2_vkBindImageMemory2

#ifdef SUPPORTS_VULKAN_EXCLUSIVE_FULLSCREEN
#define vkAcquireFullScreenExclusiveModeEXT pcsx2_vkAcquireFullScreenExclusiveModeEXT
#define vkReleaseFullScreenExclusiveModeEXT pcsx2_vkReleaseFullScreenExclusiveModeEXT
#endif

// VK_EXT_calibrated_timestamps
#define vkGetCalibratedTimestampsEXT pcsx2_vkGetCalibratedTimestampsEXT
#define vkGetPhysicalDeviceCalibrateableTimeDomainsEXT pcsx2_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT
