/**
* @file src/demangler/stgrammars/gccll.cpp
* @brief Internal LL grammar for demangler.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include <cstdlib>

#include "demangler/stgrammars/gccll.h"

namespace demangler {

/**
 * @brief Static version of the root element.
 */
cGram::gelem_t cIgram_gccll::root = {cGram::GE_NONTERM,const_cast<char *>("mangled-name"),0,'\0'};

/**
 * @brief Static table of used terminals. Used to reduce size of static LL table.
 */
unsigned char cIgram_gccll::terminal_static[256] = {
	45, // 0
	0, // 1
	0, // 2
	0, // 3
	0, // 4
	0, // 5
	0, // 6
	0, // 7
	0, // 8
	0, // 9
	0, // 10
	0, // 11
	0, // 12
	0, // 13
	0, // 14
	0, // 15
	0, // 16
	0, // 17
	0, // 18
	0, // 19
	0, // 20
	0, // 21
	0, // 22
	0, // 23
	0, // 24
	0, // 25
	0, // 26
	0, // 27
	0, // 28
	0, // 29
	0, // 30
	0, // 31
	0, // 32
	0, // 33
	0, // 34
	0, // 35
	0, // 36
	0, // 37
	0, // 38
	0, // 39
	0, // 40
	0, // 41
	0, // 42
	0, // 43
	0, // 44
	0, // 45
	0, // 46
	0, // 47
	3, // 48
	4, // 49
	5, // 50
	6, // 51
	7, // 52
	8, // 53
	9, // 54
	10, // 55
	11, // 56
	12, // 57
	0, // 58
	0, // 59
	0, // 60
	0, // 61
	0, // 62
	0, // 63
	0, // 64
	16, // 65
	17, // 66
	18, // 67
	19, // 68
	20, // 69
	21, // 70
	22, // 71
	23, // 72
	24, // 73
	25, // 74
	26, // 75
	27, // 76
	28, // 77
	13, // 78
	29, // 79
	30, // 80
	31, // 81
	32, // 82
	14, // 83
	33, // 84
	34, // 85
	35, // 86
	36, // 87
	37, // 88
	38, // 89
	2, // 90
	0, // 91
	0, // 92
	0, // 93
	0, // 94
	1, // 95
	0, // 96
	39, // 97
	40, // 98
	46, // 99
	41, // 100
	47, // 101
	48, // 102
	49, // 103
	50, // 104
	42, // 105
	51, // 106
	0, // 107
	52, // 108
	53, // 109
	54, // 110
	43, // 111
	55, // 112
	56, // 113
	57, // 114
	44, // 115
	15, // 116
	63, // 117
	58, // 118
	59, // 119
	60, // 120
	61, // 121
	62, // 122
	0, // 123
	0, // 124
	0, // 125
	0, // 126
	0, // 127
	0, // 128
	0, // 129
	0, // 130
	0, // 131
	0, // 132
	0, // 133
	0, // 134
	0, // 135
	0, // 136
	0, // 137
	0, // 138
	0, // 139
	0, // 140
	0, // 141
	0, // 142
	0, // 143
	0, // 144
	0, // 145
	0, // 146
	0, // 147
	0, // 148
	0, // 149
	0, // 150
	0, // 151
	0, // 152
	0, // 153
	0, // 154
	0, // 155
	0, // 156
	0, // 157
	0, // 158
	0, // 159
	0, // 160
	0, // 161
	0, // 162
	0, // 163
	0, // 164
	0, // 165
	0, // 166
	0, // 167
	0, // 168
	0, // 169
	0, // 170
	0, // 171
	0, // 172
	0, // 173
	0, // 174
	0, // 175
	0, // 176
	0, // 177
	0, // 178
	0, // 179
	0, // 180
	0, // 181
	0, // 182
	0, // 183
	0, // 184
	0, // 185
	0, // 186
	0, // 187
	0, // 188
	0, // 189
	0, // 190
	0, // 191
	0, // 192
	0, // 193
	0, // 194
	0, // 195
	0, // 196
	0, // 197
	0, // 198
	0, // 199
	0, // 200
	0, // 201
	0, // 202
	0, // 203
	0, // 204
	0, // 205
	0, // 206
	0, // 207
	0, // 208
	0, // 209
	0, // 210
	0, // 211
	0, // 212
	0, // 213
	0, // 214
	0, // 215
	0, // 216
	0, // 217
	0, // 218
	0, // 219
	0, // 220
	0, // 221
	0, // 222
	0, // 223
	0, // 224
	0, // 225
	0, // 226
	0, // 227
	0, // 228
	0, // 229
	0, // 230
	0, // 231
	0, // 232
	0, // 233
	0, // 234
	0, // 235
	0, // 236
	0, // 237
	0, // 238
	0, // 239
	0, // 240
	0, // 241
	0, // 242
	0, // 243
	0, // 244
	0, // 245
	0, // 246
	0, // 247
	0, // 248
	0, // 249
	0, // 250
	0, // 251
	0, // 252
	0, // 253
	0, // 254
	0 // 255
};

/**
 * @brief Static adress table for grammar elements in rules. First value is offset from the start of ruleelements array, second value is the number of elements in the current rule.
 */
cGram::ruleaddr_t cIgram_gccll::ruleaddrs[423] = {
	{0,2},{2,2},{4,3},{7,2},{9,2},{11,1},{12,2},{14,2},{16,3},{19,3},
	{22,1},{23,5},{28,1},{29,5},{34,3},{37,1},{38,1},{39,1},{40,1},{41,1},
	{42,3},{45,1},{46,2},{48,2},{50,3},{53,6},{59,0},{59,1},{60,1},{61,1},
	{62,2},{64,1},{65,3},{68,2},{70,2},{72,2},{74,2},{76,0},{76,1},{77,2},
	{79,1},{80,1},{81,1},{82,1},{83,1},{84,1},{85,1},{86,1},{87,1},{88,1},
	{89,3},{92,1},{93,1},{94,1},{95,3},{98,1},{99,1},{100,1},{101,3},{104,2},
	{106,0},{106,2},{108,0},{108,2},{110,0},{110,2},{112,3},{115,1},{116,3},{119,0},
	{119,2},{121,0},{121,3},{124,3},{127,3},{130,3},{133,3},{136,3},{139,3},{142,3},
	{145,1},{146,1},{147,1},{148,1},{149,4},{153,2},{155,1},{156,2},{158,2},{160,2},
	{162,2},{164,2},{166,2},{168,2},{170,2},{172,2},{174,2},{176,2},{178,2},{180,2},
	{182,2},{184,2},{186,2},{188,2},{190,2},{192,2},{194,2},{196,2},{198,2},{200,1},
	{201,1},{202,1},{203,1},{204,1},{205,1},{206,1},{207,1},{208,2},{210,1},{211,1},
	{212,2},{214,2},{216,2},{218,2},{220,2},{222,2},{224,2},{226,2},{228,2},{230,2},
	{232,2},{234,2},{236,2},{238,2},{240,2},{242,2},{244,2},{246,2},{248,2},{250,2},
	{252,2},{254,2},{256,2},{258,2},{260,2},{262,2},{264,2},{266,2},{268,2},{270,2},
	{272,2},{274,2},{276,2},{278,2},{280,2},{282,2},{284,2},{286,2},{288,2},{290,2},
	{292,2},{294,2},{296,2},{298,2},{300,2},{302,2},{304,2},{306,2},{308,2},{310,2},
	{312,2},{314,2},{316,2},{318,2},{320,2},{322,2},{324,2},{326,2},{328,2},{330,2},
	{332,2},{334,2},{336,2},{338,2},{340,2},{342,2},{344,2},{346,2},{348,2},{350,4},
	{354,2},{356,2},{358,2},{360,2},{362,2},{364,2},{366,2},{368,2},{370,2},{372,2},
	{374,2},{376,2},{378,2},{380,2},{382,2},{384,2},{386,2},{388,2},{390,2},{392,2},
	{394,2},{396,2},{398,2},{400,2},{402,2},{404,2},{406,2},{408,2},{410,2},{412,2},
	{414,2},{416,2},{418,2},{420,2},{422,2},{424,2},{426,2},{428,2},{430,2},{432,2},
	{434,2},{436,7},{443,2},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},{445,0},
	{445,0},{445,0},{445,0}
};

/**
 * @brief Static table of grammar elements in all rules.
 */
cGram::gelem_t cIgram_gccll::ruleelements[445] = {
	{cGram::GE_TERM,const_cast<char *>(""),0,'_'},{cGram::GE_NONTERM,const_cast<char *>("mangled-name2"),1,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("mangled-name3"),2,'\0'},{cGram::GE_NONTERM,const_cast<char *>("sem-end"),3,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'_'},{cGram::GE_NONTERM,const_cast<char *>("mangled-name3"),2,'\0'},{cGram::GE_NONTERM,const_cast<char *>("sem-end"),3,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'Z'},{cGram::GE_NONTERM,const_cast<char *>("encoding"),4,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("name"),5,'\0'},{cGram::GE_NONTERM,const_cast<char *>("bare-function-type"),6,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("nested-name"),7,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("source-name"),8,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-args"),9,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'S'},{cGram::GE_NONTERM,const_cast<char *>("name-sub"),10,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-ssno"),11,'\0'},{cGram::GE_NONTERM,const_cast<char *>("substitution2-t"),12,'\0'},{cGram::GE_NONTERM,const_cast<char *>("unqualified-name"),13,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-ssno"),11,'\0'},{cGram::GE_NONTERM,const_cast<char *>("substitution2"),14,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-args"),9,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-skiptempl"),15,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-begintempl"),16,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'I'},{cGram::GE_NONTERM,const_cast<char *>("template-arg"),17,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-arg-more"),18,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'E'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-skiptempl"),15,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-begintempl"),16,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'I'},{cGram::GE_NONTERM,const_cast<char *>("template-arg-nostore"),20,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-arg-nostore-more"),21,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'E'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-storetemparg"),22,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-arg"),17,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-arg-more"),18,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-storetemplate"),23,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("type"),24,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("expr-primary"),25,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("type"),24,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("expr-primary"),25,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-storetemparg"),22,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-arg"),17,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-arg-more"),18,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-templ2tftpl"),26,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'T'},{cGram::GE_NONTERM,const_cast<char *>("template-param2"),28,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadtsub"),29,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'_'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadtsub"),29,'\0'},{cGram::GE_NONTERM,const_cast<char *>("number"),30,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'_'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-ssnest"),31,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'N'},{cGram::GE_NONTERM,const_cast<char *>("CV-qualifiers"),32,'\0'},{cGram::GE_NONTERM,const_cast<char *>("unqualified-name"),13,'\0'},{cGram::GE_NONTERM,const_cast<char *>("unqualified-name-more"),33,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'E'},
	{cGram::GE_NONTERM,const_cast<char *>("substitution"),35,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("template-param"),27,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("unqualified-name"),13,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("ctor-dtor-name"),37,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-args-nostore"),19,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("operator-name-setname"),38,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setnameo"),39,'\0'},{cGram::GE_NONTERM,const_cast<char *>("operator-name"),40,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-args"),9,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setnameo"),39,'\0'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-cv"),41,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("source-name"),8,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-args"),9,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("substitution"),35,'\0'},{cGram::GE_NONTERM,const_cast<char *>("template-args"),9,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("unqualified-function-name"),36,'\0'},{cGram::GE_NONTERM,const_cast<char *>("unqualified-name-more"),33,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("source-number"),42,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadid"),43,'\0'},{cGram::GE_NONTERM,const_cast<char *>("number"),30,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'1'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'2'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'3'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'4'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'5'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'6'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'7'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'8'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'9'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setnamec"),44,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'C'},{cGram::GE_NONTERM,const_cast<char *>("ctor"),45,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'1'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'2'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'3'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setnamed"),46,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'D'},{cGram::GE_NONTERM,const_cast<char *>("dtor"),47,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'1'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'2'},
	{cGram::GE_NONTERM,const_cast<char *>("r"),48,'\0'},{cGram::GE_NONTERM,const_cast<char *>("V"),49,'\0'},{cGram::GE_NONTERM,const_cast<char *>("K"),50,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setrestrict"),51,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'r'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setvolatile"),52,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'V'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setconst"),53,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'K'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-unq2f"),54,'\0'},{cGram::GE_NONTERM,const_cast<char *>("bare-function-type2"),55,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("type"),24,'\0'},{cGram::GE_NONTERM,const_cast<char *>("another-type"),56,'\0'},{cGram::GE_NONTERM,const_cast<char *>("sem-par2f"),57,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setnamex"),58,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-storepar"),59,'\0'},{cGram::GE_NONTERM,const_cast<char *>("type"),24,'\0'},{cGram::GE_NONTERM,const_cast<char *>("another-type"),56,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},{cGram::GE_NONTERM,const_cast<char *>("type2"),61,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setrestrict"),51,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'r'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setvolatile"),52,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'V'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setconst"),53,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'K'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setptr"),62,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'P'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setref"),63,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'R'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setrval"),64,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'O'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setcpair"),65,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'C'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setim"),66,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'G'},{cGram::GE_NONTERM,const_cast<char *>("type-qualifier"),60,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("template-param"),27,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("builtin-type"),67,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("class-enum-type"),68,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("array-type"),69,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'A'},{cGram::GE_NONTERM,const_cast<char *>("array-number"),70,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'_'},{cGram::GE_NONTERM,const_cast<char *>("type"),24,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadarr"),71,'\0'},{cGram::GE_NONTERM,const_cast<char *>("number"),30,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("name"),5,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypev"),72,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'v'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypew"),73,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'w'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypeb"),74,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'b'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypec"),75,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'c'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypea"),76,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'a'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypeh"),77,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'h'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypes"),78,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'s'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypet"),79,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypei"),80,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'i'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypej"),81,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'j'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypel"),82,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'l'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypem"),83,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'m'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypex"),84,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'x'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypey"),85,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'y'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypen"),86,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'n'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypeo"),87,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'o'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypef"),88,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'f'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settyped"),89,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'d'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypee"),90,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'e'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypeg"),91,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'g'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-settypez"),92,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'z'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'D'},{cGram::GE_NONTERM,const_cast<char *>("builtin-type2"),93,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'d'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'e'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'f'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'h'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'i'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'s'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'a'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'n'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'S'},{cGram::GE_NONTERM,const_cast<char *>("subst"),94,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("substitution2-t"),12,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("substitution2"),14,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("seq-id"),95,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'_'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'_'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'1'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'2'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'3'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'4'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'5'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'6'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'7'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'8'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'9'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'A'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'B'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'C'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'D'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'E'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'F'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'G'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'H'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'I'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'J'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'K'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'L'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'M'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'N'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'O'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'P'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'Q'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'R'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'S'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'T'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'U'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'V'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'W'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'X'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'Y'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-loadsub"),96,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'Z'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-substd"),97,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-subalc"),98,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'a'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-substr"),99,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'b'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-substrs"),100,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'s'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-subistr"),101,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'i'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-subostr"),102,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'o'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-subiostr"),103,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'d'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'a'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-a"),104,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'c'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-c"),105,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'d'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-d"),106,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'e'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-e"),107,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'g'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-g"),108,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'i'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-i"),109,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'l'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-l"),110,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'m'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-m"),111,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'n'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-n"),112,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'o'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-o"),113,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'p'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-p"),114,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'q'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-q"),115,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'r'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-r"),116,'\0'},
	{cGram::GE_TERM,const_cast<char *>(""),0,'s'},{cGram::GE_NONTERM,const_cast<char *>("operator-name-s"),117,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopaa"),118,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'a'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopad"),119,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'d'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopan"),120,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'n'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopat"),121,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopaz"),122,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'z'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopass"),123,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'S'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopann"),124,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'N'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopcm"),125,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'m'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopcl"),126,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'l'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopco"),127,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'o'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopcv"),128,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'v'},{cGram::GE_NONTERM,const_cast<char *>("type"),24,'\0'},{cGram::GE_NONTERM,const_cast<char *>("sem-par2spec"),129,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopdl"),130,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'l'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopda"),131,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'a'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopde"),132,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'e'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopdv"),133,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'v'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopdvv"),134,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'V'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopeo"),135,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'o'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopeoo"),136,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'O'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopeq"),137,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'q'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopgt"),138,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopge"),139,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'e'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopix"),140,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'x'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopls"),141,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'s'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoplss"),142,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'S'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoplt"),143,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setople"),144,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'e'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopmi"),145,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'i'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopml"),146,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'l'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopmii"),147,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'I'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopmll"),148,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'L'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopmm"),149,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'m'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopnw"),150,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'w'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopna"),151,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'a'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopng"),152,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'g'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopne"),153,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'e'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopnt"),154,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopor"),155,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'r'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoporr"),156,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'R'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopoo"),157,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'o'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopps"),158,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'s'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoppl"),159,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'l'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoppll"),160,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'L'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoppp"),161,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'p'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoppm"),162,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'m'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoppt"),163,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopqu"),164,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'u'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoprm"),165,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'m'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoprmm"),166,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'M'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoprs"),167,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'s'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setoprss"),168,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'S'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopst"),169,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'t'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-setopsz"),170,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'z'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-beginexpr"),171,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'L'},{cGram::GE_NONTERM,const_cast<char *>("builtin-type"),67,'\0'},{cGram::GE_NONTERM,const_cast<char *>("sem-type2expr"),172,'\0'},{cGram::GE_NONTERM,const_cast<char *>("expr-number"),173,'\0'},{cGram::GE_TERM,const_cast<char *>(""),0,'E'},{cGram::GE_NONTERM,const_cast<char *>("sem-storeexpr"),174,'\0'},
	{cGram::GE_NONTERM,const_cast<char *>("sem-exprval"),175,'\0'},{cGram::GE_NONTERM,const_cast<char *>("number"),30,'\0'}
};

/**
 * @brief Static LL table
 */
cGram::llelem_t cIgram_gccll::llst[254][64] = {
	{
		{0, cGram::SA_NULL}, {1, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {3, cGram::SA_NULL}, {2, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {4, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {423, cGram::SA_END}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {5, cGram::SA_NULL},
		{5, cGram::SA_NULL}, {5, cGram::SA_NULL}, {5, cGram::SA_NULL}, {5, cGram::SA_NULL},
		{5, cGram::SA_NULL}, {5, cGram::SA_NULL}, {5, cGram::SA_NULL}, {5, cGram::SA_NULL},
		{5, cGram::SA_NULL}, {5, cGram::SA_NULL}, {5, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {7, cGram::SA_NULL},
		{7, cGram::SA_NULL}, {7, cGram::SA_NULL}, {7, cGram::SA_NULL}, {7, cGram::SA_NULL},
		{7, cGram::SA_NULL}, {7, cGram::SA_NULL}, {7, cGram::SA_NULL}, {7, cGram::SA_NULL},
		{7, cGram::SA_NULL}, {6, cGram::SA_NULL}, {8, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {0, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {66, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {66, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {0, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL},
		{66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {66, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {26, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {39, cGram::SA_NULL},
		{39, cGram::SA_NULL}, {39, cGram::SA_NULL}, {39, cGram::SA_NULL}, {39, cGram::SA_NULL},
		{39, cGram::SA_NULL}, {39, cGram::SA_NULL}, {39, cGram::SA_NULL}, {39, cGram::SA_NULL},
		{39, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {0, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {0, cGram::SA_NULL}, {11, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{12, cGram::SA_NULL}, {0, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {0, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL},
		{11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {11, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {9, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL}, {10, cGram::SA_NULL},
		{10, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO}, {238, cGram::SA_SSNO},
		{238, cGram::SA_SSNO}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {159, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {35, cGram::SA_NULL},
		{35, cGram::SA_NULL}, {35, cGram::SA_NULL}, {35, cGram::SA_NULL}, {35, cGram::SA_NULL},
		{35, cGram::SA_NULL}, {35, cGram::SA_NULL}, {35, cGram::SA_NULL}, {35, cGram::SA_NULL},
		{35, cGram::SA_NULL}, {0, cGram::SA_NULL}, {36, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {122, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL},
		{121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {121, cGram::SA_NULL}, {160, cGram::SA_NULL},
		{161, cGram::SA_NULL}, {165, cGram::SA_NULL}, {163, cGram::SA_NULL}, {164, cGram::SA_NULL},
		{162, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {0, cGram::SA_NULL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {0, cGram::SA_NULL}, {249, cGram::SA_SKIPTEMPL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{0, cGram::SA_NULL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {0, cGram::SA_NULL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {0, cGram::SA_NULL}, {249, cGram::SA_SKIPTEMPL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL},
		{249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {249, cGram::SA_SKIPTEMPL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{248, cGram::SA_BEGINTEMPL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {0, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {17, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {17, cGram::SA_NULL}, {18, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {0, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {0, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL},
		{17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {17, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {0, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{16, cGram::SA_NULL}, {0, cGram::SA_NULL}, {15, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {0, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {0, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL},
		{15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {15, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{13, cGram::SA_NULL}, {0, cGram::SA_NULL}, {13, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{13, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{14, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{13, cGram::SA_NULL}, {0, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {13, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL},
		{13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {13, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {0, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {19, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {19, cGram::SA_NULL}, {20, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {0, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {0, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL},
		{19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {19, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {0, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{22, cGram::SA_NULL}, {0, cGram::SA_NULL}, {21, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {0, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {0, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL},
		{21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {21, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {0, cGram::SA_NULL},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG},
		{250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {250, cGram::SA_STORETEMPARG}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{251, cGram::SA_STORETEMPLATE}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {0, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {71, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {71, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {0, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {0, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL},
		{71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {71, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {232, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{409, cGram::SA_TEMPL2TFTPL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {23, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {24, cGram::SA_NULL}, {0, cGram::SA_NULL}, {25, cGram::SA_NULL},
		{25, cGram::SA_NULL}, {25, cGram::SA_NULL}, {25, cGram::SA_NULL}, {25, cGram::SA_NULL},
		{25, cGram::SA_NULL}, {25, cGram::SA_NULL}, {25, cGram::SA_NULL}, {25, cGram::SA_NULL},
		{25, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {241, cGram::SA_LOADTSUB}, {0, cGram::SA_NULL}, {241, cGram::SA_LOADTSUB},
		{241, cGram::SA_LOADTSUB}, {241, cGram::SA_LOADTSUB}, {241, cGram::SA_LOADTSUB}, {241, cGram::SA_LOADTSUB},
		{241, cGram::SA_LOADTSUB}, {241, cGram::SA_LOADTSUB}, {241, cGram::SA_LOADTSUB}, {241, cGram::SA_LOADTSUB},
		{241, cGram::SA_LOADTSUB}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {41, cGram::SA_NULL},
		{42, cGram::SA_NULL}, {43, cGram::SA_NULL}, {44, cGram::SA_NULL}, {45, cGram::SA_NULL},
		{46, cGram::SA_NULL}, {47, cGram::SA_NULL}, {48, cGram::SA_NULL}, {49, cGram::SA_NULL},
		{50, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {239, cGram::SA_SSNEST}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {59, cGram::SA_NULL},
		{59, cGram::SA_NULL}, {59, cGram::SA_NULL}, {59, cGram::SA_NULL}, {59, cGram::SA_NULL},
		{59, cGram::SA_NULL}, {59, cGram::SA_NULL}, {59, cGram::SA_NULL}, {59, cGram::SA_NULL},
		{59, cGram::SA_NULL}, {0, cGram::SA_NULL}, {59, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {59, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {59, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {59, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{37, cGram::SA_NULL}, {0, cGram::SA_NULL}, {37, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{38, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{37, cGram::SA_NULL}, {0, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {37, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL},
		{37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {37, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {28, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {29, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {118, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {30, cGram::SA_NULL},
		{30, cGram::SA_NULL}, {30, cGram::SA_NULL}, {30, cGram::SA_NULL}, {30, cGram::SA_NULL},
		{30, cGram::SA_NULL}, {30, cGram::SA_NULL}, {30, cGram::SA_NULL}, {30, cGram::SA_NULL},
		{30, cGram::SA_NULL}, {0, cGram::SA_NULL}, {30, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {31, cGram::SA_NULL}, {31, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {32, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {32, cGram::SA_NULL}, {32, cGram::SA_NULL}, {32, cGram::SA_NULL},
		{32, cGram::SA_NULL}, {0, cGram::SA_NULL}, {32, cGram::SA_NULL}, {32, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {32, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{32, cGram::SA_NULL}, {32, cGram::SA_NULL}, {32, cGram::SA_NULL}, {32, cGram::SA_NULL},
		{32, cGram::SA_NULL}, {32, cGram::SA_NULL}, {32, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {51, cGram::SA_NULL}, {55, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {33, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {33, cGram::SA_NULL}, {33, cGram::SA_NULL}, {33, cGram::SA_NULL},
		{33, cGram::SA_NULL}, {0, cGram::SA_NULL}, {33, cGram::SA_NULL}, {33, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {33, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{33, cGram::SA_NULL}, {33, cGram::SA_NULL}, {33, cGram::SA_NULL}, {33, cGram::SA_NULL},
		{33, cGram::SA_NULL}, {33, cGram::SA_NULL}, {34, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {257, cGram::SA_SETNAMEO},
		{0, cGram::SA_NULL}, {257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO},
		{257, cGram::SA_SETNAMEO}, {0, cGram::SA_NULL}, {257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO},
		{0, cGram::SA_NULL}, {257, cGram::SA_SETNAMEO}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO},
		{257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO}, {257, cGram::SA_SETNAMEO}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {166, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {168, cGram::SA_NULL}, {171, cGram::SA_NULL}, {175, cGram::SA_NULL},
		{179, cGram::SA_NULL}, {0, cGram::SA_NULL}, {167, cGram::SA_NULL}, {169, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {170, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{172, cGram::SA_NULL}, {173, cGram::SA_NULL}, {174, cGram::SA_NULL}, {176, cGram::SA_NULL},
		{177, cGram::SA_NULL}, {178, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {190, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {40, cGram::SA_NULL},
		{40, cGram::SA_NULL}, {40, cGram::SA_NULL}, {40, cGram::SA_NULL}, {40, cGram::SA_NULL},
		{40, cGram::SA_NULL}, {40, cGram::SA_NULL}, {40, cGram::SA_NULL}, {40, cGram::SA_NULL},
		{40, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {236, cGram::SA_LOADID},
		{236, cGram::SA_LOADID}, {236, cGram::SA_LOADID}, {236, cGram::SA_LOADID}, {236, cGram::SA_LOADID},
		{236, cGram::SA_LOADID}, {236, cGram::SA_LOADID}, {236, cGram::SA_LOADID}, {236, cGram::SA_LOADID},
		{236, cGram::SA_LOADID}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {297, cGram::SA_SETNAMEC}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{52, cGram::SA_NULL}, {53, cGram::SA_NULL}, {54, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {298, cGram::SA_SETNAMED},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {56, cGram::SA_NULL},
		{57, cGram::SA_NULL}, {58, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {61, cGram::SA_NULL},
		{61, cGram::SA_NULL}, {61, cGram::SA_NULL}, {61, cGram::SA_NULL}, {61, cGram::SA_NULL},
		{61, cGram::SA_NULL}, {61, cGram::SA_NULL}, {61, cGram::SA_NULL}, {61, cGram::SA_NULL},
		{61, cGram::SA_NULL}, {0, cGram::SA_NULL}, {61, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {61, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {61, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {60, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {63, cGram::SA_NULL},
		{63, cGram::SA_NULL}, {63, cGram::SA_NULL}, {63, cGram::SA_NULL}, {63, cGram::SA_NULL},
		{63, cGram::SA_NULL}, {63, cGram::SA_NULL}, {63, cGram::SA_NULL}, {63, cGram::SA_NULL},
		{63, cGram::SA_NULL}, {0, cGram::SA_NULL}, {63, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {63, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {62, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {65, cGram::SA_NULL},
		{65, cGram::SA_NULL}, {65, cGram::SA_NULL}, {65, cGram::SA_NULL}, {65, cGram::SA_NULL},
		{65, cGram::SA_NULL}, {65, cGram::SA_NULL}, {65, cGram::SA_NULL}, {65, cGram::SA_NULL},
		{65, cGram::SA_NULL}, {0, cGram::SA_NULL}, {65, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {64, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {281, cGram::SA_SETRESTRICT}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {282, cGram::SA_SETVOLATILE},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {283, cGram::SA_SETCONST}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {0, cGram::SA_NULL},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F},
		{254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {254, cGram::SA_UNQ2F}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {0, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {67, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {67, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {0, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {68, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL},
		{67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {67, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {0, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {69, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {69, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {0, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {70, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL},
		{69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {69, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {253, cGram::SA_PAR2F}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {256, cGram::SA_SETNAMEX}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR},
		{247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {247, cGram::SA_STOREPAR}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {0, cGram::SA_NULL}, {79, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {80, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {75, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {78, cGram::SA_NULL}, {76, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{77, cGram::SA_NULL}, {72, cGram::SA_NULL}, {0, cGram::SA_NULL}, {74, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {0, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {73, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL},
		{72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {72, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {83, cGram::SA_NULL},
		{83, cGram::SA_NULL}, {83, cGram::SA_NULL}, {83, cGram::SA_NULL}, {83, cGram::SA_NULL},
		{83, cGram::SA_NULL}, {83, cGram::SA_NULL}, {83, cGram::SA_NULL}, {83, cGram::SA_NULL},
		{83, cGram::SA_NULL}, {83, cGram::SA_NULL}, {83, cGram::SA_NULL}, {82, cGram::SA_NULL},
		{84, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {82, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {81, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {82, cGram::SA_NULL},
		{82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL},
		{82, cGram::SA_NULL}, {0, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL},
		{82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL},
		{82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL},
		{82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {82, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {284, cGram::SA_SETPTR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{285, cGram::SA_SETREF}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {286, cGram::SA_SETRVAL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {287, cGram::SA_SETCPAIR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {288, cGram::SA_SETIM}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {95, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {109, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {92, cGram::SA_NULL},
		{90, cGram::SA_NULL}, {105, cGram::SA_NULL}, {96, cGram::SA_NULL}, {103, cGram::SA_NULL},
		{94, cGram::SA_NULL}, {0, cGram::SA_NULL}, {91, cGram::SA_NULL}, {106, cGram::SA_NULL},
		{104, cGram::SA_NULL}, {107, cGram::SA_NULL}, {93, cGram::SA_NULL}, {97, cGram::SA_NULL},
		{98, cGram::SA_NULL}, {99, cGram::SA_NULL}, {102, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {88, cGram::SA_NULL}, {89, cGram::SA_NULL},
		{100, cGram::SA_NULL}, {101, cGram::SA_NULL}, {108, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {87, cGram::SA_NULL},
		{87, cGram::SA_NULL}, {87, cGram::SA_NULL}, {87, cGram::SA_NULL}, {87, cGram::SA_NULL},
		{87, cGram::SA_NULL}, {87, cGram::SA_NULL}, {87, cGram::SA_NULL}, {87, cGram::SA_NULL},
		{87, cGram::SA_NULL}, {87, cGram::SA_NULL}, {87, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{85, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {86, cGram::SA_NULL},
		{86, cGram::SA_NULL}, {86, cGram::SA_NULL}, {86, cGram::SA_NULL}, {86, cGram::SA_NULL},
		{86, cGram::SA_NULL}, {86, cGram::SA_NULL}, {86, cGram::SA_NULL}, {86, cGram::SA_NULL},
		{86, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {237, cGram::SA_LOADARR},
		{237, cGram::SA_LOADARR}, {237, cGram::SA_LOADARR}, {237, cGram::SA_LOADARR}, {237, cGram::SA_LOADARR},
		{237, cGram::SA_LOADARR}, {237, cGram::SA_LOADARR}, {237, cGram::SA_LOADARR}, {237, cGram::SA_LOADARR},
		{237, cGram::SA_LOADARR}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {260, cGram::SA_SETTYPEV}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {261, cGram::SA_SETTYPEW},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{262, cGram::SA_SETTYPEB}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {263, cGram::SA_SETTYPEC}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {264, cGram::SA_SETTYPEA},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {265, cGram::SA_SETTYPEH}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{266, cGram::SA_SETTYPES}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {267, cGram::SA_SETTYPET},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {268, cGram::SA_SETTYPEI}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {269, cGram::SA_SETTYPEJ},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{270, cGram::SA_SETTYPEL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {271, cGram::SA_SETTYPEM}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{272, cGram::SA_SETTYPEX}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {273, cGram::SA_SETTYPEY}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {274, cGram::SA_SETTYPEN}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {275, cGram::SA_SETTYPEO},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{276, cGram::SA_SETTYPEF}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {277, cGram::SA_SETTYPED}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {278, cGram::SA_SETTYPEE},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {279, cGram::SA_SETTYPEG}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {280, cGram::SA_SETTYPEZ}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {116, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {110, cGram::SA_NULL}, {114, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{115, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {111, cGram::SA_NULL},
		{112, cGram::SA_NULL}, {0, cGram::SA_NULL}, {113, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {117, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {119, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL}, {120, cGram::SA_NULL},
		{120, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {158, cGram::SA_NULL}, {123, cGram::SA_NULL},
		{124, cGram::SA_NULL}, {125, cGram::SA_NULL}, {126, cGram::SA_NULL}, {127, cGram::SA_NULL},
		{128, cGram::SA_NULL}, {129, cGram::SA_NULL}, {130, cGram::SA_NULL}, {131, cGram::SA_NULL},
		{132, cGram::SA_NULL}, {146, cGram::SA_NULL}, {151, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{133, cGram::SA_NULL}, {134, cGram::SA_NULL}, {135, cGram::SA_NULL}, {136, cGram::SA_NULL},
		{137, cGram::SA_NULL}, {138, cGram::SA_NULL}, {139, cGram::SA_NULL}, {140, cGram::SA_NULL},
		{141, cGram::SA_NULL}, {142, cGram::SA_NULL}, {143, cGram::SA_NULL}, {144, cGram::SA_NULL},
		{145, cGram::SA_NULL}, {147, cGram::SA_NULL}, {148, cGram::SA_NULL}, {149, cGram::SA_NULL},
		{150, cGram::SA_NULL}, {152, cGram::SA_NULL}, {153, cGram::SA_NULL}, {154, cGram::SA_NULL},
		{155, cGram::SA_NULL}, {156, cGram::SA_NULL}, {157, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {0, cGram::SA_NULL},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB},
		{296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {296, cGram::SA_LOADSUB}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {289, cGram::SA_SUBSTD},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {290, cGram::SA_SUBALC},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{291, cGram::SA_SUBSTR}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{292, cGram::SA_SUBSTRS}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {293, cGram::SA_SUBISTR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {294, cGram::SA_SUBOSTR},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {295, cGram::SA_SUBIOSTR}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {186, cGram::SA_NULL}, {185, cGram::SA_NULL}, {183, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {180, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {181, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {182, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {184, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {189, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{188, cGram::SA_NULL}, {187, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {195, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {192, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {193, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{191, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {194, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {197, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {196, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{198, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {199, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {200, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{201, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {203, cGram::SA_NULL}, {204, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{202, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {205, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{208, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {209, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {206, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{207, cGram::SA_NULL}, {210, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {215, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {212, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {214, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {213, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {211, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{217, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {218, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {216, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {224, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {221, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{219, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{220, cGram::SA_NULL}, {223, cGram::SA_NULL}, {0, cGram::SA_NULL}, {222, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {225, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {229, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{227, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{228, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {226, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {230, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {231, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {335, cGram::SA_SETOPAA},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {305, cGram::SA_SETOPAD}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {313, cGram::SA_SETOPAN}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {348, cGram::SA_SETOPAT},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {349, cGram::SA_SETOPAZ}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {316, cGram::SA_SETOPASS}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {322, cGram::SA_SETOPANN}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {339, cGram::SA_SETOPCM}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{342, cGram::SA_SETOPCL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {307, cGram::SA_SETOPCO},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {350, cGram::SA_SETOPCV}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {258, cGram::SA_PAR2SPEC},
		{258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC},
		{258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC},
		{258, cGram::SA_PAR2SPEC}, {0, cGram::SA_NULL}, {258, cGram::SA_PAR2SPEC}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC},
		{258, cGram::SA_PAR2SPEC}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {258, cGram::SA_PAR2SPEC},
		{0, cGram::SA_NULL}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC},
		{258, cGram::SA_PAR2SPEC}, {0, cGram::SA_NULL}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC},
		{0, cGram::SA_NULL}, {258, cGram::SA_PAR2SPEC}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC},
		{258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {258, cGram::SA_PAR2SPEC}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{301, cGram::SA_SETOPDL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {302, cGram::SA_SETOPDA},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {306, cGram::SA_SETOPDE},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {311, cGram::SA_SETOPDV}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {320, cGram::SA_SETOPDVV},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {315, cGram::SA_SETOPEO},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {324, cGram::SA_SETOPEOO}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{329, cGram::SA_SETOPEQ}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {332, cGram::SA_SETOPGT},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {344, cGram::SA_SETOPGE},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{343, cGram::SA_SETOPIX}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{325, cGram::SA_SETOPLS}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {327, cGram::SA_SETOPLSS}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {331, cGram::SA_SETOPLT},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {333, cGram::SA_SETOPLE},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {309, cGram::SA_SETOPMI}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{310, cGram::SA_SETOPML}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{318, cGram::SA_SETOPMII}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {319, cGram::SA_SETOPMLL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {338, cGram::SA_SETOPMM}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {299, cGram::SA_SETOPNW},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {300, cGram::SA_SETOPNA},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {304, cGram::SA_SETOPNG}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {330, cGram::SA_SETOPNE},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {334, cGram::SA_SETOPNT},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {314, cGram::SA_SETOPOR}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{323, cGram::SA_SETOPORR}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {336, cGram::SA_SETOPOO},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{303, cGram::SA_SETOPPS}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{308, cGram::SA_SETOPPL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {317, cGram::SA_SETOPPLL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {337, cGram::SA_SETOPPP},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {340, cGram::SA_SETOPPM}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {341, cGram::SA_SETOPPT},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {345, cGram::SA_SETOPQU}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {312, cGram::SA_SETOPRM}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{321, cGram::SA_SETOPRMM}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{326, cGram::SA_SETOPRS}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {328, cGram::SA_SETOPRSS}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {346, cGram::SA_SETOPST},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {347, cGram::SA_SETOPSZ}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {244, cGram::SA_BEGINPEXPR},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {242, cGram::SA_TYPE2EXPR},
		{242, cGram::SA_TYPE2EXPR}, {242, cGram::SA_TYPE2EXPR}, {242, cGram::SA_TYPE2EXPR}, {242, cGram::SA_TYPE2EXPR},
		{242, cGram::SA_TYPE2EXPR}, {242, cGram::SA_TYPE2EXPR}, {242, cGram::SA_TYPE2EXPR}, {242, cGram::SA_TYPE2EXPR},
		{242, cGram::SA_TYPE2EXPR}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {233, cGram::SA_NULL},
		{233, cGram::SA_NULL}, {233, cGram::SA_NULL}, {233, cGram::SA_NULL}, {233, cGram::SA_NULL},
		{233, cGram::SA_NULL}, {233, cGram::SA_NULL}, {233, cGram::SA_NULL}, {233, cGram::SA_NULL},
		{233, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR},
		{245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {245, cGram::SA_STOREPEXPR}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {243, cGram::SA_EXPRVAL},
		{243, cGram::SA_EXPRVAL}, {243, cGram::SA_EXPRVAL}, {243, cGram::SA_EXPRVAL}, {243, cGram::SA_EXPRVAL},
		{243, cGram::SA_EXPRVAL}, {243, cGram::SA_EXPRVAL}, {243, cGram::SA_EXPRVAL}, {243, cGram::SA_EXPRVAL},
		{243, cGram::SA_EXPRVAL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	},
	{
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL},
		{0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}, {0, cGram::SA_NULL}
	}
};

/**
 * @brief Export internal grammar data for use in demangler.
 * @return igram_t structure containing the internal grammar data.
 */
cGram::igram_t cIgram_gccll::getInternalGrammar() {
	cGram::igram_t retvalue = {
		256, //terminal_static_x
		423, //ruleaddrs_x
		445, //ruleelements_x
		254, //llst_x
		64, //llst_y
		root,
		terminal_static,
		ruleaddrs,
		ruleelements,
		nullptr
	};

	//dynamic allocation of the llst
	retvalue.llst = static_cast<cGram::llelem_t**>(malloc(sizeof(cGram::llelem_t*) * retvalue.llst_x));
	for (unsigned int i=0; i<retvalue.llst_x; i++) {
		retvalue.llst[i] = llst[i];
	}

	return retvalue;
}

} // namespace demangler
