/**
 * A javascript module to handle calendar drag and drop in the calendar
 * month view navigation.
 *
 * This code is run each time the calendar month view is re-rendered. We
 * only register the event handlers once per page load so that the in place
 * DOM updates that happen on month change don't continue to register handlers.
 *
 * @module     core_calendar/month_navigation_drag_drop
 * @copyright  2017 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_calendar/month_navigation_drag_drop",["jquery","core_calendar/drag_drop_data_store"],(function($,DataStore){var SELECTORS_DRAGGABLE='[draggable="true"][data-region="event-item"]',SELECTORS_DROP_ZONE='[data-drop-zone="nav-link"]',registered=!1,hoverTimer=null,root=null,updateHoverState=function(target,hovered){hovered?target.addClass("bg-primary text-white"):target.removeClass("bg-primary text-white")},addDropZoneIndicator=function(){root.find(SELECTORS_DROP_ZONE).addClass("drop-target")},removeDropZoneIndicator=function(){root.find(SELECTORS_DROP_ZONE).removeClass("drop-target")},getTargetFromEvent=function(e){var target=$(e.target).closest(SELECTORS_DROP_ZONE);return target.length?target:null},dragstartHandler=function(e){$(e.target).closest(SELECTORS_DRAGGABLE).length&&addDropZoneIndicator()},dragoverHandler=function(e){if(DataStore.hasEventId()){e.preventDefault();var target=getTargetFromEvent(e);target&&DataStore.hasEventId()&&(hoverTimer||(hoverTimer=setTimeout((function(){target.click(),hoverTimer=null}),1e3)),updateHoverState(target,!0),removeDropZoneIndicator())}},dragleaveHandler=function(e){if(DataStore.hasEventId()){var target=getTargetFromEvent(e);target&&(hoverTimer&&(clearTimeout(hoverTimer),hoverTimer=null),updateHoverState(target,!1),addDropZoneIndicator(),e.preventDefault())}},dropHandler=function(e){if(DataStore.hasEventId()){removeDropZoneIndicator();var target=getTargetFromEvent(e);target&&(updateHoverState(target,!1),e.preventDefault())}};return{init:function(rootElement){registered||(document.addEventListener("dragstart",dragstartHandler,!1),document.addEventListener("dragover",dragoverHandler,!1),document.addEventListener("dragleave",dragleaveHandler,!1),document.addEventListener("drop",dropHandler,!1),document.addEventListener("dragend",removeDropZoneIndicator,!1),registered=!0),root=$(rootElement),DataStore.hasEventId()&&addDropZoneIndicator()}}}));

//# sourceMappingURL=month_navigation_drag_drop.min.js.map