# Contribution Guidelines

Thanks for considering to contribute to this project! Some guidelines:

- Go through the issue list and if needed create a relevant issue to discuss the change design. On disagreements, maintainer(s) will have the final word.
- You can expect a response from a maintainer within 7 days. If you haven’t heard anything by then, feel free to ping the thread.
- This package tries to be as simple as possible for the user (hide any complexity from the user). New options are only added when there is clear value to the majority of users.
- When issues or pull requests are not going to be resolved or merged, they should be closed as soon as possible. This is kinder than deciding this after a long period. Our issue tracker should reflect work to be done.

## Vision

There are multiple mkdocs plugins that use information from the local git repo. 

In order to simplify user experience and maintenance,
I intend to merge functionality in this plugin with [mkdocs-git-authors-plugin](https://github.com/timvink/mkdocs-git-authors-plugin).
See https://github.com/timvink/mkdocs-git-authors-plugin/issues/16 for a similar roadmap issue with more details.

That means not extending the functionality of this plugin, but rather aiming to create a simple, stable release that can go into 'maintenance mode'.
If users want more information extracted from Git, they can go to [mkdocs-git-authors-plugin](https://github.com/timvink/mkdocs-git-authors-plugin).

## Unit Tests

Make sure to install an editable version before running the tests:

```python
pip install -r tests/test_requirements.txt
pip install -e .
pytest --cov=mkdocs_git_revision_date_localized_plugin --cov-report term-missing tests/
```

If it makes sense, writing tests for your PRs is always appreciated and will help get them merged.

In addition, this project uses [flake8](https://github.com/PyCQA/flake8) for static code checking:

```python
pip install pyflakes
pyflakes tests/ mkdocs_git_revision_date_localized_plugin/
```

## Manual testing

To quickly serve a test website with your latest changes to the plugin use the sites in our tests suite.
For example:

```python
pip install -r tests/test_requirements.txt
pip install -e .
mkdocs serve -f tests/fixtures/basic_project/mkdocs.yml
```

## Code Style

Make sure your code *roughly* follows [PEP-8](https://www.python.org/dev/peps/pep-0008/)
and keeps things consistent with the rest of the code.

We use Google-style docstrings.
