// $Id: installreffile.cpp,v 1.12 2006/02/19 23:59:14 hvengel Exp $
//  Little cms - profiler construction set
//Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.08a

#include "installreffile.h"
#include <lprofmain.h>
#include <qtlcmswidgets.h>

#if !defined(__WIN32__) && (defined(_WIN32) || defined(WIN32))
#define __WIN32__
#endif


static ref_file_parms dirs;
static targetTemplate files;

InstallRefFile::InstallRefFile(QWidget *parent) 
    :InstallRefFileBase(parent)
{
    ref_file a;
    a.get(a);
    dirs = a.items;
    SelectTemplate->Dir = QDir::convertSeparators(dirs.temp_dir);   
    SelectTemplate->FillValues();
    SelectTemplate->setCurrItem(0);
    TargetSelector->Dir=QDir::convertSeparators(dirs.home_dir);
    TargetSelector->setFilename("");
    
    // gray OK button
    buttonOk -> setEnabled(FALSE);
}

InstallRefFile::~InstallRefFile()
{
}

void InstallRefFile::slotOK()
{  
    char ref_file[128];
    char ref_temp[128];
    
    // pull file names out of the dialog
    
    // files.items.targetFile=TargetSelector->getFilename().mid(TargetSelector->Dir.length(), TargetSelector->getFilename().length());
    files.items.templateFile=SelectTemplate->getFilename();
    strcpy(ref_temp, dirs.ref_dir.local8Bit());
    strcat(ref_temp, "/");
    strcat(ref_temp, TargetSelector->getFilename().mid(TargetSelector->Dir.length(), TargetSelector->getFilename().length()));
    files.items.targetFile=ref_temp;
    
    // write new reference file to the reference file directory
    // Needs work to make it portable to Windows and Mac
   # ifdef __WIN32__
       strcpy(ref_file, "copy \"");  // Windows port
   # else
        strcpy(ref_file, "cp \"");
   # endif /* __WIN32__ */
        
        // Inclose the file names in "" in case there are spaces in the file names
         
    strcat(ref_file,QDir::convertSeparators(TargetSelector->getFilename().local8Bit()));
    strcat(ref_file, "\" \"");
    strcat(ref_file,QDir::convertSeparators(files.items.targetFile.local8Bit()));
    strcat(ref_file, "\"");
    system(ref_file);
    // pass new reference file/template info back to main dialog
    files.put(files);
    
}


void InstallRefFile::slotValueChanged()
{
     // qDebug("slotValueChanged install ref file");
     // if both selectors have a value ungray OK button
     if (TargetSelector->getFilename() != "" && SelectTemplate -> getFilename() != "")
         buttonOk -> setEnabled(TRUE);
}

static QAssistantClient *help;

QString inst_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

void InstallRefFile::slotHelpButton()
{
     QString execpath = (QString) inst_get_QTDIR() + (QString) "/bin";
     QStringList cmdLst;
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/inst-ref.html";
     help->openAssistant ();
     // qDebug(path);
     help->showPage(path);
}
