// $Id: monitorvalues.cpp,v 1.8 2006/02/19 23:59:14 hvengel Exp $
//  Little cms Profiler
//  Copyright (C) 1998-2001 Marti Maria 
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11

#include "monitorvalues.h"
#include "setgamma.h"
#include "lcmsprf.h"
#include "qtlcmswidgets.h"
#include "lprofmain.h"
#include <qlineedit.h>
#include <qpixmap.h>

static PROFILERDATA sys; 
// QButtonGroup* RGB_button_group;

QAssistantClient *help;

// Primaries table
static struct PrimTag {

               const char *Name;
               double xRed, yRed, xGreen, yGreen, xBlue, yBlue;

               } PrimTable[] = {

{ "ITU-R BT.709 (sRGB) - DEFAULT",   0.640, 0.330, 0.300, 0.600, 0.150, 0.060 },
{ "SMPTE RP145-1994",                0.64,  0.33,  0.29,  0.60,  0.15,  0.06 },
{ "SMPTE-C (CCIR 601-1)",			 0.630, 0.340, 0.310, 0.595, 0.155, 0.070},
{ "EBU Tech.3213-E",                 0.630, 0.340, 0.310, 0.595, 0.155, 0.070 },
{ "EBU [Walker98]",					 0.64,  0.33,  0.30,  0.60,  0.15,  0.06 },
{ "P22",                             0.625, 0.340, 0.280, 0.595, 0.155, 0.070},
{ "NTSC",                            0.67,  0.33,  0.21,  0.71,  0.14,  0.08 },
{ "HDTV",                            0.670, 0.330, 0.210, 0.710, 0.150, 0.060 },
{ "CIE",                             0.7355,0.2645,0.2658,0.7243,0.1669,0.0085},
{ "Dell",                            0.625, 0.340, 0.275, 0.605, 0.150, 0.065},
{ "LCD",							 0.700, 0.300, 0.170, 0.700, 0.130, 0.075},
{ "Samsung TFT",				     0.610, 0.350, 0.315, 0.580, 0.150, 0.140},
{ "Apple RGB",						 0.625, 0.34,  0.28,  0.595, 0.155, 0.07 },
{ "Wide Gamut RGB (700/525/450nm)",  0.7347,0.2653,0.1152,0.8264,0.1566,0.0177},  
{ "Short persistence [Foley96]",     0.61,  0.35,  0.29,  0.59,  0.15,  0.063},
{ "Long persistence  [Foley96]",     0.62,  0.33,  0.21,  0.685, 0.15,  0.063},
{ "Adobe RGB",                       0.64,  0.33,  0.21,  0.71,  0.15,  0.06 },
{ "User defined",                    0.640, 0.330, 0.300, 0.600, 0.150, 0.060 }};

#define NPRIMARIES (int) (sizeof(PrimTable) / sizeof(struct PrimTag))

static struct WhitePntTag {
			const char* Name;
			double xw, yw;
			int TempK;

			} WhitePoints[] = {

				{ "D50 (Warm white)", 0, 0, 5000},
				{ "D65 (daylight)",   0.3127, 0.3291, 0},
				{ "D70",              0, 0, 7000 },
				{ "D75",              0, 0, 7500 },
				{ "D80",              0, 0, 8000 },
				{ "D85",              0, 0, 8500 },
				{ "D90",              0, 0, 9000 },
				{ "D91",              0, 0, 9100 },
				{ "D93 - Cold white", 0, 0, 9300 },
				{ "CIE illuminant A", 0.4476, 0.4074, 0},
				{ "CIE illuminant B", 0.34842, 0.35161, 0},
                                                         { "CIE illuminant C", 0.3101, 0.3162, 0},
				{ "CIE Illuminant E", 0.333, 0.333, 0}, 
				{ "User defined (blackbody locus)", 0, 0, 0}};
                

				
#define NWHITES (int) (sizeof(WhitePoints) / sizeof(struct WhitePntTag))

monVal mon;

QString v(double b)
{	
   static char Buffer[128];
   ::sprintf(Buffer, "%g", b);
   return (QString) Buffer;
}

MonitorValues::MonitorValues(QWidget *parent )
  : MonitorValuesBase(parent)
{      
    passSys a;
    a.get(&sys);
    mon.get(&mon);
    	 
    // Fill primaries combo

    QValidator* Chromaticity = new QDoubleValidator(0.0, 2.0, 4, this);

    xRed   -> setValidator(Chromaticity);
    yRed   -> setValidator(Chromaticity);
    xGreen -> setValidator(Chromaticity);
    yGreen -> setValidator(Chromaticity);
    xBlue  -> setValidator(Chromaticity);
    yBlue  -> setValidator(Chromaticity);

 
    int i;
    ComboPrimaries->clear();
    for (i=0; i < NPRIMARIES; i++)
        ComboPrimaries -> insertItem(PrimTable[i].Name);

    ComboPrimaries -> setCurrentItem(mon.items.ppos);
             
    if (mon.items.ppos< (NPRIMARIES-1)) 
        slotChangePrimaries();
    else 
    {
        xRed -> setText(v(sys.hdr.Primaries.Red.x));
        yRed -> setText(v(sys.hdr.Primaries.Red.y));
        xGreen -> setText(v(sys.hdr.Primaries.Green.x ));
        yGreen -> setText(v(sys.hdr.Primaries.Green.y ));
        xBlue-> setText(v(sys.hdr.Primaries.Blue.x));
        yBlue-> setText(v(sys.hdr.Primaries.Blue.y));
    }
    
    ComboBoxWP -> clear();
    for (i=0; i < NWHITES; i++)
        ComboBoxWP -> insertItem(WhitePoints[i].Name);

    ComboBoxWP-> setCurrentItem(mon.items.wppos);
    slotChangeWhitePoint();
	
    TempWhitePoint -> setValue(mon.items.temp);
    
    GammaR -> setText(mon.items.rgamma);
    GammaG -> setText(mon.items.ggamma);
    GammaB-> setText(mon.items.bgamma);
}


void MonitorValues::slotChangePrimaries()
{
    // char buff[32];
    
    int nSel = ComboPrimaries -> currentItem();

    BOOL IsUser = (nSel == NPRIMARIES - 1);

    xRed -> setEnabled(IsUser);
    yRed -> setEnabled(IsUser);
    xGreen -> setEnabled(IsUser);
    yGreen -> setEnabled(IsUser);
    xBlue -> setEnabled(IsUser);
    yBlue -> setEnabled(IsUser);

    if (nSel >= 0 && nSel < (NPRIMARIES -1)) 
    {
        // qDebug("slotChangePrimaries in if");

        sys.hdr.Primaries.Red.x = PrimTable[nSel].xRed;
        sys.hdr.Primaries.Red.y = PrimTable[nSel].yRed;
        sys.hdr.Primaries.Red.Y = 1;

        sys.hdr.Primaries.Green.x = PrimTable[nSel].xGreen;
        sys.hdr.Primaries.Green.y = PrimTable[nSel].yGreen;
        sys.hdr.Primaries.Green.Y = 1;

        sys.hdr.Primaries.Blue.x = PrimTable[nSel].xBlue;
        sys.hdr.Primaries.Blue.y = PrimTable[nSel].yBlue;
        sys.hdr.Primaries.Blue.Y = 1;

        xRed -> setText(v(sys.hdr.Primaries.Red.x));
        yRed -> setText(v(sys.hdr.Primaries.Red.y));
        xGreen -> setText(v(sys.hdr.Primaries.Green.x ));
        yGreen -> setText(v(sys.hdr.Primaries.Green.y ));
        xBlue-> setText(v(sys.hdr.Primaries.Blue.x));
        yBlue-> setText(v(sys.hdr.Primaries.Blue.y));
    }
    else	
    {
        sys.hdr.Primaries.Red.x = xRed->text().toDouble();
        sys.hdr.Primaries.Red.y = yRed->text().toDouble();
        sys.hdr.Primaries.Red.Y = 1;

        sys.hdr.Primaries.Green.x = xGreen->text().toDouble();
        sys.hdr.Primaries.Green.y = yGreen->text().toDouble();
        sys.hdr.Primaries.Green.Y = 1;

        sys.hdr.Primaries.Blue.x = xBlue->text().toDouble();
        sys.hdr.Primaries.Blue.y = yBlue->text().toDouble();
        sys.hdr.Primaries.Blue.Y = 1;

    }
}

void MonitorValues::slotChangeWhitePoint()
{             
    // qDebug("In slotChangeWhitePoint");
    cmsCIExyY wp;

    int nSel = ComboBoxWP-> currentItem();

    if (nSel == NWHITES - 1)
        TempWhitePoint -> show();
    else 
        TempWhitePoint -> hide();
			
    if (nSel >= 0 && nSel < NWHITES) 
    {
        wp.x = WhitePoints[nSel].xw;
        wp.y = WhitePoints[nSel].yw;
        wp.Y = 1;
        if (wp.x == 0 && wp.y == 0) 
        {
            int Temp = WhitePoints[nSel].TempK;
            if (Temp == 0)
               Temp = TempWhitePoint -> value();
        cmsWhitePointFromTemp(Temp, &wp);
        }
    }
	
    cmsxyY2XYZ(&sys.hdr.WhitePoint, &wp);
}


void MonitorValues::slotOK()
{
    passSys a;
    
     // qDebug("In slot OK");
    slotChangeWhitePoint();
    slotChangePrimaries();

    if (sys.Prelinearization[0]) cmsFreeGamma(sys.Prelinearization[0]);
    
    if (sys.Prelinearization[1]) cmsFreeGamma(sys.Prelinearization[1]);
    
    if (sys.Prelinearization[2]) cmsFreeGamma(sys.Prelinearization[2]);
        
    sys.Prelinearization[0] = cmsBuildGamma(256, GammaR -> text().toDouble());
    sys.Prelinearization[1] = cmsBuildGamma(256, GammaG -> text().toDouble());
    sys.Prelinearization[2] = cmsBuildGamma(256, GammaB -> text().toDouble());
    
    a.put(sys);
    mon.items.rgamma = GammaR -> text();
    mon.items.ggamma = GammaG -> text();
    mon.items.bgamma = GammaB -> text();
    mon.items.valid_mon=TRUE; 
    if (ComboBoxWP-> currentItem() == NWHITES -1)
        mon.items.temp=TempWhitePoint -> value();
    else
        mon.items.temp = 0;
    mon.items.wppos=ComboBoxWP-> currentItem();
    mon.items.ppos=ComboPrimaries -> currentItem();
    mon.put(mon); 
}

void MonitorValues::slotSetGamma_dialog()
{
    //  qDebug("monitorvalues::slotSetGamma_dialog");
    SetGamma gammaVals(this);
    gammaVals.show();
    gammaVals.exec();
    mon.get(&mon);
    GammaR -> setText(mon.items.rgamma);
    GammaG -> setText(mon.items.ggamma);
    GammaB-> setText(mon.items.bgamma);
        
}

QString mon_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

void MonitorValues::slotHelpButton()
{
     QString execpath = (QString) mon_get_QTDIR() + (QString) "/bin";
     QStringList cmdLst;
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/mon-val.html";
     help->openAssistant ();
     help->showPage(path);
}
