// $Id: lprofmain.cpp,v 1.40 2006/02/21 18:57:14 hvengel Exp $
//  Lttle cms Profiler
//  Copyright (C) 1998-2001 Marti Maria 
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11

// #include <qdir.h>
#include <qtextbrowser.h>
#include <profileid.h>
#include <profileparms.h>
#include <monitorvalues.h>
#include <profilechecker.h>
#include <qtlcmswidgets.h>
#include "lprofmain.h"
#include <string.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <stdlib.h>
#include <qlist.h>
#include <qsettings.h>
#include "installreffile.h"

#include "vigra/imageiterator.hxx"
#include "vigra/rgbvalue.hxx"
#include <vigra/accessor.hxx>
#include "vigra/impex.hxx"
#include "vigra/stdimage.hxx"
#include "vigra/inspectimage.hxx"
#include <lcmsprf.h>
#include <qcolor.h>

static BOOL int16, int32;

static QPointArray grid_corners;
static QPtrList<target_template> *targetList=0;
QDir dir;
BOOL corners_ready;
static monVal monitorValues;
static PROFILERDATA sys;
uint last_tab;
typedef struct
{
     char Description[256];
     char Manufacturer[256];
     char Model[256];
     char Copyright[256];
     char Comments[256];
     cmsCIExyYTRIPLE Primaries;
     int CLUTPoints;                 /* Final CLUT resolution */
     int ProfileVerbosityLevel;	   /* 0=minimum, 1=additional, 2=Verbose, 3=Any suitable */
     bool lUseCIECAM97s;              /* Use CIECAM97s for chromatic adaptation? */

     cmsViewingConditions device;     /* Viewing condition of source */
     cmsViewingConditions PCS;        /* Viewing condition of PCS */

    LCMSHANDLE hDevice;              /* CIECAM97s models used for adaptation */
    LCMSHANDLE hPCS;                 /* and viewing conditions */ 
    double       RsplSmoothness;		/* smoothing factor */
    double       AvgDev;
}  parms_ID_data;

parms_ID_data data[3];


// Console and Gauger

static QMultiLineEdit*    Console;
static QProgressBar*      ProgBar;

char ConfigFile[256];
char measfile[256];
char templates[256];
char mon_profile[256];
char in_profile[256];
char ref_dir[256];
char WorkTempFileName[256];
char outprofile[256];
char measurement_dir[256];
QString image_file_name;

const int measure_view_H=1500;
const int measure_view_V=1000;

vigra::ImageImportInfo *image_data = NULL;
// vigra::destImage *in;

struct mark_pos
{ 
    int  ur_x, ur_y;
    int ul_x, ul_y;
    int lr_x, lr_y;
    int ll_x, ll_y;
  }  Marks; 

QString get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

#if !defined(__WIN32__) && (defined(_WIN32) || defined(WIN32))
#define __WIN32__
#endif

 # ifdef __WIN32__
         
 # else
    static int min (int a, int b) 
    {
        if (a < b) return a;
        return b;
    }
# endif /* __WIN32__ */

void add_target(target_template &in)
{
    BOOL found;
    target_template* item;
    
    found = FALSE;
    // look to see if this target is already installed.
    // if it is update the template file
    if (!targetList->isEmpty())  // taragetList has items so check it to see if this is a dupelicate 
    {
        for (uint i = 0;  i < targetList->count();  i++)
          if (targetList->at(i)->targetFile == in.targetFile)
              { 
                   targetList->at(i)->templateFile = in.templateFile;
                   found=TRUE;
                   break;
              }
    }
    if (!found) // not a dupicate target file so create new entry
    {
        item = new target_template;
        item->targetFile = in.targetFile;
        item->templateFile = in.templateFile;    
        // place new target ref file in list of target ref files
        targetList->insert(targetList->count(), item);
    }
}


void init_env()
{    
    const char* ConfigFileconst="/.lprof/config/lprof.cfg";
    const char* measfileconst="/.lprof/temp/meaurement.cgt";
    const char* WorkTempFileNameconst = "/.lprof/temp/$$q60$$.$$$";
    const char* templateconst = "/.lprof/templates";
    const char* measure_dir_const = "/.lprof/measurements";
    QDir d;
    # ifdef __WIN32__
          
          QString win;
          BOOL win_found = FALSE;
          for (  char drive = 'c'; drive <= 'z'; drive++)
	  {
	      win =  drive + (QString)  ":\WINDOWS\system32\spool\drivers\color";
	      if ( d.exists( win)) break;
	  }
          const char* mon_profileconst=(const char*) win;
          const char* in_profileconst=(const char*) win;;
          const char* outprofileconst=(const char*) win;;
    # else
        const char* mon_profileconst="/usr/share/color/icc";
        const char* in_profileconst="/usr/share/color/icc";
        const char* outprofileconst="/.color/icc";
    # endif /* __WIN32__ */
    const char* ref_dirconst="/.lprof/target_refs";

    char home[128];
    char temp[128];
 
    // qDebug("init_env"); 
   
    strcpy(home, d.convertSeparators(d.homeDirPath().local8Bit()));
    strcpy(temp, home);
    strcat(temp, ConfigFileconst);
    strcpy(ConfigFile, d.convertSeparators((QString) temp));
    // qDebug(ConfigFile);

    strcpy(temp,home);
    strcat(temp, measure_dir_const);
    strcpy(measurement_dir, d.convertSeparators((QString) temp));
    
    strcpy(temp,home);
    strcat(temp, measfileconst); 
    strcpy(measfile, d.convertSeparators((QString) temp));
        
    strcpy(temp, home);
    strcat(temp, templateconst);
    strcpy(templates, d.convertSeparators((QString) temp));
    
    strcpy(mon_profile, mon_profileconst);
    strcpy(in_profile, in_profileconst);
    
    strcpy(WorkTempFileName, home);
    strcat(WorkTempFileName, WorkTempFileNameconst);
    
    strcpy(temp,home);
    strcat(temp,ref_dirconst);
    strcpy(ref_dir, d.convertSeparators((QString) temp));

    strcpy(temp,home);
    strcat(temp, WorkTempFileNameconst);
    strcpy(sys.hdr.temp_file, d.convertSeparators((QString) temp));
    
    # ifdef __WIN32__
        strcpy(temp, outprofileconst);
    # else
        strcpy(temp, home);
        strcat(temp, outprofileconst);
        strcpy(outprofile, d.convertSeparators((QString) temp));
    # endif /* __WIN32__ */
    
}
    

static int ConsolePrintf(const char *frm, ...)
{
    char Buffer[1024];
    va_list args;
    
    // qDebug("ConsolePrintf");
    va_start(args, frm); 
    vsprintf(Buffer, frm, args);
    Console -> append(Buffer);      
    va_end(args);  
    return 1;
}

static int Gauger(const char *Label, int nMin, int nMax, int Pos)
{
    
    // qDebug("Gauger");
    if (nMin < 0 && nMax < 0)       
    {         
        return 1; 
    }
    
    ProgBar -> setTotalSteps(nMax);
    ProgBar -> setProgress(Pos);
    return 1;
}

void lprofMain::init_mon()
{
    // qDebug("init_mon");
    monitorValues.items.wppos=0;
    monitorValues.items.ppos=0;
    monitorValues.items.temp=6500;
    monitorValues.items.linked=1;
    monitorValues.items.rchecked=TRUE;
    monitorValues.items.gchecked=FALSE;
    monitorValues.items.bchecked=FALSE;
    monitorValues.items.rgamma="2.4";
    monitorValues.items.ggamma="2.4";
    monitorValues.items.bgamma="2.4";
    connect(MonMeasurementSheet, SIGNAL(valueChanged()), this, SLOT(slotChangeStrategy()));
    
}

static void init_marks()
{
    Marks.ur_x=measure_view_H; 
    Marks.ur_y=0;
    
    Marks.ul_x=0; 
    Marks.ul_y=0;
    
    Marks.lr_x=measure_view_H; 
    Marks.lr_y=measure_view_V;
    
    Marks.ll_x=0; 
    Marks.ll_y=measure_view_H;
    
    corners_ready=FALSE;
    
}

// Measurement tool stuff
// GridLayout, represents one patch

void lprofMain::Reload()
{
    // qDebug("lprof::Reload");
    TheImage -> Reload(fn, MonitorProfileSelector ->getFilename(),
                                 InputProfileSelector->getFilename(),  
                                 Canvas);
}

int GridLayout::Scale(int n, int amax)   
{ 
    // qDebug("Gridlatout::Scale");
    return (int) (((double) (n*amax)/LAYOUT_MAX)+.5); 
}


// This is where the template patches are layed out over the IT8 image.

void GridLayout::ScaleTo(int w, int h, QRect& Scaled)
{
    
    QPoint A, B, C, D;
    int length_w, length_h, offset_x, offset_y, offset_x2, offset_y2, dDA, dBA, dCD, dCB, adj_x, adj_y; 
    
    A=grid_corners.point(0);
    B=grid_corners.point(1);
    C=grid_corners.point(2);
    D=grid_corners.point(3);
    
    adj_x=min(A.x(),D.x());
    A.setX(A.x()-adj_x);
    B.setX(B.x()-adj_x);
    C.setX(C.x()-adj_x);
    D.setX(D.x()-adj_x);
    adj_y=min(A.y(),B.y());
    A.setY(A.y()-adj_y);
    B.setY(B.y()-adj_y);
    C.setY(C.y()-adj_y);
    D.setY(D.y()-adj_y);
    
    dDA=A.x()-D.x();
    dBA=A.y()-B.y();
    dCD=C.y()-D.y();
    dCB=B.x()-C.x();
    
    if (dDA>0) 
        offset_x= abs(dDA-((int) (dDA  * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    else
        offset_x= -abs(dDA-((int) (dDA  * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    
    if (dCB>0) 
        offset_x2= -abs(dCB-((int) (dCB * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    else
        offset_x2= abs(dCB-((int) (dCB * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    
    if (dBA>0)
        offset_y=abs(dBA-((int) (dBA * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    else 
        offset_y=-abs(dBA-((int) (dBA * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    
    if (dCD<0)
         offset_y2=-abs(dCD-((int) (dCD * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    else
        offset_y2=abs(dCD-((int) (dCD * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    
    length_w = w - (offset_x + offset_x2);
    length_h = h - (offset_y + offset_y2);
    
    // qDebug("Gridlayout::ScaleTo");
     Scaled.setRect(Scale(rect.x(), length_w ) + offset_x,
                   Scale(rect.y(), length_h) + offset_y,
                   Scale(rect.width(), length_w),
                   Scale(rect.height(), length_h));
}

// A ICC profile transform on whole image


void ImageItem::TransformImage(const QString OutputProfile, 
                               const QString InputProfile, 
                               QImage& p)
{
    
    // qDebug("ImageItem::TransformImage");
    cmsHTRANSFORM xform;
    cmsHPROFILE hIn, hOut;

    if (p.isNull()) qDebug("Image not valid");
    qDebug(OutputProfile);
    qDebug(InputProfile);

    hIn  = cmsOpenProfileFromFile(InputProfile.local8Bit(), "r");
    hOut = cmsOpenProfileFromFile(OutputProfile.local8Bit(), "r");

    xform = cmsCreateTransform(hIn, TYPE_RGBA_8, hOut, TYPE_RGBA_8, 
                        INTENT_PERCEPTUAL, cmsFLAGS_WHITEBLACKCOMPENSATION);

    for (int i=0; i < p.height(); i++) {
        LPBYTE ptr = p.scanLine(i);
        cmsDoTransform(xform, ptr, ptr, p.width());
    }

    cmsDeleteTransform(xform);
    cmsCloseProfile(hIn);
    cmsCloseProfile(hOut);
}



ImageItem::ImageItem(QString ImageFile, const QString Monitor, const QString Scanner, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image()
{

    // qDebug("ImageItem::ImageItem");
    lProof = FALSE;
    Reload(ImageFile, Monitor, Scanner, canvas);
}


void ImageItem::Reload(QString ImageFile, const QString Monitor, const QString Scanner, QCanvas *canvas )
{

    // qDebug("ImageItem::Reload");
   
     char file[256];
     uint  rvi = 0;
     uint  gvi = 0;
     uint  bvi = 0;
   
    if (ImageFile == QString::null) return;  // make sure there is a file name
    strcpy(file,  ImageFile.local8Bit());

    // check to see if the file name point to a valid image file   
    if (!vigra::isImage(file)) 
    {
        QMessageBox mb( "Load image failure",
                        "This image format is unsupported by LPROF\n"
                        "on your system. Sorry. Supported ones \n"
                        "are BMP, GIF, JPEG, PNG, PBM, PGM,\n"
                        "PNM, PPM, SUN, TIFF and VIFF.",
                        QMessageBox::Critical,
                        QMessageBox::Ok | QMessageBox::Default,
                        QMessageBox::NoButton,  QMessageBox::NoButton);

    mb.exec();  
    return;
    } 
     image_data = new vigra::ImageImportInfo(file);
     
     // make sure it is a color image
     if (!(image_data->isColor())) 
     {
        QMessageBox mb( "Load image failure",
                        "This image is not a color RGB image.\n"
                        "Only color images are supported at this time.",
                        QMessageBox::Critical,
                        QMessageBox::Ok | QMessageBox::Default,
                        QMessageBox::NoButton,  QMessageBox::NoButton);

    mb.exec();  
    return;
    } 
         
    image_file_name = (QString) ImageFile;
    QString pixtype = (QString) image_data->getPixelType();
    int16 = (pixtype.contains( "INT16") > 0);
    int32 = (pixtype.contains( "INT32") > 0);
    BOOL uint8 = (pixtype.contains( "UINT8") > 0);
    BOOL fltpix = (pixtype.contains( "FLOAT") > 0);
    BOOL dblpix = (pixtype.contains( "DOUBLE") > 0);

    // try again   
    vigra::DRGBImage in(image_data->width(), image_data->height());
    vigra::importImage(*image_data, destImage(in));
    vigra::DRGBImage::Iterator point=in.upperLeft();
    
    double min = 99999999.0;
    double max = -99999999.0;
 
    if (fltpix || dblpix) 
    {
      for (int i=0; i < image_data->height(); i++)
        for (int j=0; j < image_data->width(); j++) 
           {    
                double r = point(j, i).red();
                double g = point(j, i).green();
                double b = point(j, i).blue();
                if (r > max) max = r; 
                if (g > max) max = g;
                if (b > max) max = b;
                if (r < min) min = r; 
                if (g < min) min = g;
                if (b < min) min = b; 
             } 
    }  
      
      if (! image.create (image_data->width(), 
                          image_data->height(), 32, 0, 
                          QImage::IgnoreEndian)) 
          qDebug( "image create failed");  // should never happen
      
      for (int i=0; i < image_data->height(); i++)
        for (int j=0; j < image_data->width(); j++) 
           {    
                double rv = point(j, i).red();
                double gv = point(j, i).green();
                double bv = point(j, i).blue();
                
                // normalize rgb values to 8 bit uints
                if (uint8) 
                {
                    rvi=(uint)rv;
                    gvi=(uint)gv;
                    bvi=(uint)bv;
                }
               else if (int16) 
               {
                   if ( rv < 0.0) 
                       rv = rv + 65536.0;
                  if (gv < 0.0)
                      gv = gv + 65536.0;
                 if (bv < 0.0)
                      bv = bv + 65536.0;
                  rvi=(uint)(rv/257.0);
                  gvi=(uint)(gv/257.0);
                  bvi=(uint)(bv/257.0);                      
               }
               else if (int32)
               {
                  if ( rv < 0.0) 
                       rv= rv + 4294967296.0;
                   if (gv < 0.0)
                       gv= gv + 4294967296.0;
                  if (bv < 0.0)
                      bv= bv + 4294967296.0;
                  rvi=(uint)(rv/16843009.0);
                  gvi=(uint)(gv/16843009.0);
                  bvi=(uint)(bv/16843009.0);
               }
               else if (fltpix || dblpix ) 
               {  // this may be wrong fix me
                  // normalize to zero then
                  // divide to normalize the range
                  // max of 255
                  rvi=(uint)((rv-min)/((max-min)/255.0));
                  gvi=(uint)((gv-min)/((max-min)/255.0));
                  bvi=(uint)((bv-min)/((max-min)/255.0));                      
               }
         
           image.setPixel(j,i, qRgba ( rvi, gvi, bvi, 0xff));
           
         } 

    QImage scaled = image.smoothScale(canvas->width(), canvas->height());

    setSize( scaled.width(), scaled.height() );
    
    sx = (double) image.width() / scaled.width();
    sy = (double) image.height() / scaled.height();

    pixmap.convertFromImage(scaled); 

    if (lProof) {
        if (Monitor != QString::null && Scanner != QString::null)  
            TransformImage(Monitor, Scanner, scaled);
        qDebug("lProof is true");
    }
    else
      qDebug("lProof is false");
	
    proof.convertFromImage(scaled);

    move(0, 0);
    setZ(5);
    show();
}


void ImageItem::drawShape( QPainter &p )
{
    // qDebug("ImageItem::drawShape");
    p.drawPixmap( int(x()), int(y()), lProof? proof : pixmap );
}



// ---------------------------------------------------------------- The grid item

GridItem::GridItem( QCanvas *canvas, QString Template, int SafeFrame )
    : QCanvasRectangle( 10, 10, canvas->width() - 10, canvas->height() - 10, canvas)
{
    // qDebug("GridItem::GridItem");
    // UnShearFactor = 0.0;
    SafeFrameFactor = SafeFrame / 100.;
    setBrush( NoBrush) ; 

    Layout.setAutoDelete(TRUE);
    LCMSHANDLE hIT8 = cmsxIT8LoadFromFile(Template.local8Bit());
    
    if (hIT8) {

        int nRects = (int) cmsxIT8GetPropertyDbl(hIT8, "NUMBER_OF_SETS");
        char PatchName[256];

        for (int i=0; i < nRects; i++) {

            if (cmsxIT8GetDataSetByPos(hIT8, 0, i, PatchName, 256)) {

                GridLayout* Patch = new GridLayout;

                double x, y, xSize, ySize;
                
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "POS_X", &x);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "POS_Y", &y);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "SIZE_X", &xSize);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "SIZE_Y", &ySize);

                strcpy(Patch -> p.Name, (const char *) PatchName);
                Patch -> rect.setRect(int(x), int(y), int(xSize), int (ySize));

                Layout.append(Patch);

            }
        }

        cmsxIT8Free(hIT8);
    }

    setZ(10);
    show();
}



static
void DoDeflateRect(QRect& rect, int sx, int sy)
{
    // qDebug("DoDeflateRect");
    rect.setRect(rect.x() + sx, rect.y() + sy, 
                  rect.width()-sx*2, rect.height()-sx*2);
}


void GridItem::ComputePatchRects(QRect& OurViewport, GridLayout* Patch, 
                                 QRect& Frame, QRect& HotZone)
{
        QRect Scaled;

        // qDebug("GridItem::ComputePatchRects");
        Patch ->ScaleTo(OurViewport.width(), OurViewport.height(), Scaled);

        int translateX = OurViewport.x();
        int translateY = OurViewport.y();
        
        Scaled.moveBy(translateX, translateY);

        Frame = Scaled;
        
        int SafeFrame = (int) ((double) Scaled.width() * SafeFrameFactor / 2.);
                
        DoDeflateRect(Scaled, SafeFrame, SafeFrame);

        HotZone = Scaled;
}


// Compute our viewport extension

void GridItem::ComputeViewport(QRect& OurViewport, double sx, double sy)
{

    int x;
    int y;
    int w;
    int h;
    
    x=(int) (min(Marks.ll_x, Marks.ur_x) * sx);
    y=(int) (min( Marks.ur_y, Marks.ul_y) * sy);
    w=(int) (mmax(Marks.ur_x, Marks.lr_x) * sx - x);
    h=(int) (mmax(Marks.lr_y, Marks.ll_y) * sy - y);
    OurViewport.setRect(x, y, w, h);
}


void GridItem::drawShape( QPainter &p )
{   
    GridLayout* Patch;
    QRect OurViewport;

    // qDebug("GridItem::drawShape");
    
    ComputeViewport(OurViewport, 1.0, 1.0);
    
    if (corners_ready) {
        for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {
                
                QRect Frame, HotZone;

                // Scale to our viewport
                ComputePatchRects(OurViewport, Patch, Frame, HotZone);
            
                // Draw
                // p.setPen( Qt::white );    
                // p.drawRect(Frame);

                p.setPen( Qt::green );    
                p.drawRect(HotZone);
                
            }  // end for
        } // enf if
    
    // Do this allways to mark corners but only mark corners after the user 
    // clicks to add a mark
    
    p.setPen( Qt::red );   
    
    // upper right corner only draw the corner mark of the user has clicked 
    if (Marks.ur_x<measure_view_H && Marks.ur_y>0) {
        p.drawLine(Marks.ur_x, Marks.ur_y, Marks.ur_x - 50, Marks.ur_y);
        p.drawLine(Marks.ur_x, Marks.ur_y, Marks.ur_x, Marks.ur_y + 50);
    }
    
    // upper left corner
    if (Marks.ul_x>0 && Marks.ul_y>0) {
        p.drawLine(Marks.ul_x, Marks.ul_y, Marks.ul_x + 50, Marks.ul_y);
        p.drawLine(Marks.ul_x, Marks.ul_y, Marks.ul_x, Marks.ul_y + 50);
    }
    
    // lower right corner
    if (Marks.lr_x>0 && Marks.lr_y<measure_view_V) {
        p.drawLine(Marks.lr_x, Marks.lr_y, Marks.lr_x - 50, Marks.lr_y);
        p.drawLine(Marks.lr_x, Marks.lr_y, Marks.lr_x, Marks.lr_y - 50);
    }
            
    // lower left corner
    if (Marks.ll_x<measure_view_H && Marks.ll_y<measure_view_V) {        
        p.drawLine(Marks.ll_x, Marks.ll_y, Marks.ll_x + 50, Marks.ll_y);
        p.drawLine(Marks.ll_x, Marks.ll_y, Marks.ll_x, Marks.ll_y - 50);
    }
}


void GridItem::Pick(QString InputProfileName, QImage& Image, double sx, double sy )
{      
    GridLayout* Patch;
    QRect OurViewport;
     // qDebug("GridItem::Pick");
    cmsHTRANSFORM hInputXFORM;
    cmsHPROFILE hLab = NULL, hInputProfile = NULL;
    
    // Will not compile with QT_NO_ASCII_CAST turned on
    // when changed to 
    // const char* cInputProfile = InputProfileName.local8Bit();
    // Will get runtime errors for bad file name
    // Needs to be fixed
    const char* cInputProfile = InputProfileName;
    
    if (cInputProfile) {

        hLab          = cmsCreateLabProfile(NULL);
        hInputProfile = cmsOpenProfileFromFile(cInputProfile, "r");
        hInputXFORM   = cmsCreateTransform(hInputProfile, TYPE_RGB_16, 
                                        hLab, TYPE_Lab_16, INTENT_ABSOLUTE_COLORIMETRIC, 
                                        cmsFLAGS_NOTPRECALC);
    }
    else hInputXFORM = NULL;
    ComputeViewport(OurViewport, sx, sy);
           
    vigra::DRGBImage in(image_data->width(), image_data->height());
    vigra::importImage(*image_data, destImage(in));
    vigra::DRGBImage::Iterator point=in.upperLeft();
      
    for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {
                
                // Scale to our viewport

                QRect Frame, HotZone;
                
                ComputePatchRects(OurViewport, Patch, Frame, HotZone);

                // Ok, take

                Statistic r, g, b;  // These are doubles
                
                int xstart = HotZone.x();
                int ystart = HotZone.y();
                int xsize  = HotZone.width();
                int ysize  = HotZone.height();

                Patch ->p.Colorant.RGB[0] = 0;
                Patch ->p.Colorant.RGB[1] = 0;
                Patch ->p.Colorant.RGB[2] = 0;
                Patch ->p.dwFlags         = 0;
                

                if ((xstart < 0) || (ystart < 0) || 
                    ((xstart + xsize) > Image.width()) ||
                    ((ystart + ysize > Image.height()))) 
                                continue;
                
                // qDebug("interating image");
                for (int i=0; i < ysize; i++)
                    for (int j=0; j < xsize; j++) {
                                                                   
                        double rv = point(xstart+j, ystart+i).red();
                        double gv = point(xstart+j, ystart+i).green();
                        double bv = point(xstart+j, ystart+i).blue();
                        if (int16) 
                        {
                            if ( rv < 0.0) 
                                 rv = rv + 65536.0;
                            if (gv < 0.0)
                                gv = gv + 65536.0;
                            if (bv < 0.0)
                                bv = bv + 65536.0;
                        }
                        else if (int32)
                        {
                               if ( rv < 0.0) 
                                    rv= rv + 4294967296.0;
                               if (gv < 0.0)
                                   gv= gv + 4294967296.0;
                              if (bv < 0.0)
                                   bv= bv + 4294967296.0;
                          }
                        
                        r.Add(rv); g.Add(gv); b.Add(bv);   
                        
                    }

                Patch ->p.dwFlags = PATCH_HAS_RGB|PATCH_HAS_CHISQ;

                Patch ->p.Colorant.RGB[0] = r.Mean();
                Patch ->p.Colorant.RGB[1] = g.Mean();
                Patch ->p.Colorant.RGB[2] = b.Mean();

                
                Patch->p.ChiSq = (r.Std() + g.Std() + b.Std()) / 3.0;


                if (hInputXFORM) {

                    WORD RGB[3];
                    WORD LabEncoded[3];
                
                    RGB[0] =(WORD) floor(Patch -> p.Colorant.RGB[0] * 257. + .5);
                    RGB[1] =(WORD) floor(Patch -> p.Colorant.RGB[1] * 257. + .5);
                    RGB[2] =(WORD) floor(Patch -> p.Colorant.RGB[2] * 257. + .5);

                    cmsDoTransform(hInputXFORM, RGB, LabEncoded, 1);
                    cmsLabEncoded2Float(&Patch ->p.Lab, LabEncoded);
                    cmsLab2XYZ(NULL, &Patch ->p.XYZ, &Patch ->p.Lab);
                }
    }
        
    if (hInputXFORM) {

        cmsDeleteTransform(hInputXFORM);
        cmsCloseProfile(hInputProfile);
        cmsCloseProfile(hLab);
    }

}


// ------------------------------------------------------------ The figure editor

void FigureEditor::resizeEvent( QResizeEvent* e )
{
     // qDebug("FigureEditor::resizeEvent");
  QCanvasView::resizeEvent( e );
  maindialog.FigEditor-> resize(width(), height());
  
}

void FigureEditor::contentsMousePressEvent(QMouseEvent* e)
{
    
     // qDebug("FigureEditor::contentsMousePressEvent");
    if (e->x()<measure_view_H/2 && e->y()<measure_view_V/2) {
         // upper left quadrant 
         Marks.ul_x=e->x();
         Marks.ul_y=e->y();
          }
    else
        if (e->x()>measure_view_H/2 && e->y()<measure_view_V/2) {
           // upper right quadrant 
            Marks.ur_x=e->x();
            Marks.ur_y=e->y();
        }
    else
        if (e->x()>measure_view_H/2 && e->y()>measure_view_V/2) {
            // lower right quadrant
            Marks.lr_x=e->x();
            Marks.lr_y=e->y();
        }
    else
        if (e->x()<measure_view_H/2 && e->y()>measure_view_V/2) {
            // lower left quadrant
            Marks.ll_x=e->x();
            Marks.ll_y=e->y();
        }
     
    
    // place corner markers to give user feed back that the corner has been marked
    
    grid_corners.putPoints(0, 4, Marks.ul_x,  Marks.ul_y, 
                                                                         Marks.ur_x, Marks.ur_y, 
                                                                         Marks.lr_x, Marks.lr_y, 
                                                                         Marks.ll_x, Marks.ll_y);
    maindialog.AddTemplate();
    
    // check to see if all corners are marked and it is time to place full template and pick
    
    if (Marks.ul_x>0 && Marks.ur_x<measure_view_H && Marks.ll_x>0 && Marks.lr_x<measure_view_H) {
        
        corners_ready=TRUE;
        maindialog.slotPick();
    }  

}


void FigureEditor::clear()
{
    // qDebug("FigureEditor::clear");
    QCanvasItemList list = canvas()->allItems();
    QCanvasItemList::Iterator it = list.begin();
    for (; it != list.end(); ++it) {
        if ( *it )
            delete *it;
    }

    moving = NULL;
    sizing = NULL;
    unshearing = NULL;
}

void lprofMain::AddTemplate()
{    
    // qDebug("lprofMain::AddTemplate");
     QString Template     = SelectTemplate -> getFilename();
     double  SafeFrameVal = SafeFrame->value();
    if ((TheImage != NULL) && (Template != QString::null)) {
        
        if (TheGrid != NULL)
            delete TheGrid;

       TheGrid = new GridItem(Canvas, Template, (int) SafeFrameVal);
       CurrentTemplate  = Template;
       CurrentSafeFrame = SafeFrameVal;
    }
}              


void lprofMain::slotLoad()
{
    // qDebug("lprofMain::slotLoad");

    fn = QFileDialog::getOpenFileName( dir.homeDirPath(), 
                                                "Image files (*.gif *.png *.jpg *.bmp *.pbm *.pgm *.pnm *.sun *.tif *.tiff *.viff *.GIF *.PNG *.JPG *.BMP *.PBM *.PGM *.PNM *.SUN *.TIF *.TIFF *.VIFF)\nAll files (*.*)",
                                                this,
                                                "",
                                                "Select target image");

    if (fn == QString::null) return;

    FigEditor->clear();
    TheGrid = NULL;
    CurrentTemplate = "";
                // fix me ?? what does ProofTogle do ???
    if (ProofToggle -> isOn()) ProofToggle -> toggle();

    TheImage = new ImageItem(fn, MonitorProfileSelector ->getFilename(),
                                InputProfileSelector->getFilename(),  
                                Canvas);
    init_marks();
    
}

void lprofMain::slotProof()
{
    if (TheImage) {
            TheImage -> lProof = ProofToggle -> isOn();

		TheImage -> Reload(fn, MonitorProfileSelector ->getFilename(),
                                 InputProfileSelector->getFilename(),  
                                 Canvas);
                
            Canvas->setChanged(rect());
            Canvas->update();
            ControlsToValues();
    }

}

/* void lprofMain::SaveIT8(const char *filename)
{    
    // fix me raw edit no longer supported
    
    QString text = IT8Edit->text();
    QFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
    return;
    }

    QTextStream t( &f );
    t << text;
    f.close();

    IT8Edit->setEdited( FALSE );  
} */




void lprofMain::DumpResultsToIT8(QList<GridLayout>& Layout)
{
      // qDebug("lprofMain::DumpResultsToIT8");  
    LCMSHANDLE it8 = cmsxIT8Alloc();
    
    cmsxIT8SetSheetType(it8, "LCMS/MEASUREMENT");
    cmsxIT8SetProperty(it8, "ORIGINATOR",   (const char *) "LPROF");
    cmsxIT8SetProperty(it8, "DESCRIPTOR",   (const char *) "hidden measurement sheet");
    cmsxIT8SetProperty(it8, "MANUFACTURER", (const char *) "LPROF");
    cmsxIT8SetProperty(it8, "CREATED",      (const char *) "");
    cmsxIT8SetProperty(it8, "SERIAL",       (const char *) "");
    cmsxIT8SetProperty(it8, "MATERIAL",     (const char *) "");

    cmsxIT8SetProperty(it8, "CHISQ_DOF",    "3");

    GridLayout* Patch;
    int nSets = 0;
    int nFields = 5;

    for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {
                    if (Patch -> p.dwFlags != 0) 
                        nSets++;
            }

    cmsxIT8SetPropertyDbl(it8, "NUMBER_OF_SETS", nSets);

    if (RadioButtonLabXYZ -> isChecked()) nFields += 3;

    cmsxIT8SetPropertyDbl(it8, "NUMBER_OF_FIELDS", nFields);

    nFields = 0;
    cmsxIT8SetDataFormat(it8, nFields++, "SAMPLE_ID");

   if (RadioButtonRGB -> isChecked()) {

    cmsxIT8SetDataFormat(it8, nFields++, "RGB_R");
    cmsxIT8SetDataFormat(it8, nFields++, "RGB_G");
    cmsxIT8SetDataFormat(it8, nFields++, "RGB_B");
     }

   if (RadioButtonLab -> isChecked() ||
        RadioButtonLabXYZ -> isChecked()) {

    cmsxIT8SetDataFormat(it8, nFields++, "LAB_L");
    cmsxIT8SetDataFormat(it8, nFields++, "LAB_A");
    cmsxIT8SetDataFormat(it8, nFields++, "LAB_B");
    }

    if (RadioButtonXYZ -> isChecked() ||
        RadioButtonLabXYZ -> isChecked()) {

    cmsxIT8SetDataFormat(it8, nFields++, "XYZ_X");
    cmsxIT8SetDataFormat(it8, nFields++, "XYZ_Y");
    cmsxIT8SetDataFormat(it8, nFields++, "XYZ_Z");
    }

    cmsxIT8SetDataFormat(it8, nFields++, "CHI_SQD_PAR");
   
    for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {

                if (Patch -> p.dwFlags != 0) {

                cmsxIT8SetDataSet(it8, Patch->p.Name, "SAMPLE_ID", Patch->p.Name);
               
               if (RadioButtonRGB -> isChecked()) {

                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_R", Patch ->p.Colorant.RGB[0]);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_G", Patch ->p.Colorant.RGB[1]);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_B", Patch ->p.Colorant.RGB[2]);
               }
            
               if (RadioButtonLab -> isChecked() || RadioButtonLabXYZ -> isChecked()) {

                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_L", Patch ->p.Lab.L);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_A", Patch ->p.Lab.a);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_B", Patch ->p.Lab.b);
                }
            
               if (RadioButtonXYZ -> isChecked() || RadioButtonLabXYZ -> isChecked()) {

                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_X", Patch ->p.XYZ.X * 100.);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_Y", Patch ->p.XYZ.Y * 100.);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_Z", Patch ->p.XYZ.Z * 100.);
                }


                cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "CHI_SQD_PAR", Patch ->p.ChiSq);

                }
            }
            
    cmsxIT8SaveToFile(it8, measfile);
    cmsxIT8Free(it8);  
}



// ------------------------------------------------------------------------------ Slots

void lprofMain::slotPick()
{
    
    // qDebug("lprofMain::SlotPick");
    if (TheImage && TheGrid) 
    {
        TheGrid -> Pick(InputProfileSelector->getFilename(), 
                        TheImage -> image, 
                        TheImage -> sx, TheImage -> sy);
        DumpResultsToIT8(TheGrid -> Layout);
        slotIsAllReady();          
    }
}


// end measurement tool stuff


void lprofMain::SetGoButton(const char* Caption, BOOL lEnable)
{
    // qDebug("lprofMain::SetGoButton"); 
    QToolTip::remove( TheGoButton );
    QToolTip::add( TheGoButton, Caption );
	
    TheGoButton -> setEnabled(TRUE);	    
    TheGoButton -> setEnabled(lEnable);
    TheGoButton -> repaint();
}

void lprofMain::SetGoButton_2(const char* Caption, BOOL lEnable)
{
    // qDebug("lprofMain::SetGoButton"); 
    QToolTip::remove( TheGoButton_2 );
    QToolTip::add( TheGoButton_2, Caption );
	
    TheGoButton_2 -> setEnabled(TRUE);	    
    TheGoButton_2 -> setEnabled(lEnable);
    TheGoButton_2 -> repaint();
}
 
 void lprofMain::SetOutputFile( const QString OutputFile )
{
     // qDebug("lprofMain::SetOutputFile"); 
     switch (TabProfiler -> currentPageIndex()) {

        case 0: OutputFileEdit -> setText(OutputFile); break;
        case 1: OutputFileEdit_Mon -> setText(OutputFile); break;
        
    default:;  // if not on a profiling tab do nothing
    }	
}

 void ref_file::get( ref_file &out)
 {
     QDir d;
     QString temp;
     out.items.temp_dir=sys.hdr.template_dir;
     out.items.ref_dir=sys.hdr.ref_dir;
     out.items.home_dir=d.convertSeparators(d.homeDirPath());
 }
 
 void checkerP::get(checkerP &out)
 {
     // qDebug("checkP::get"); 
     
     out.items.ref_dir=(QString) sys.hdr.ref_dir;
     out.items.cur_ref=sys.hdr.cur_ref;
     out.items.profile=(QString) sys.hdr.OutputProfileFile;
     out.items.msheet=(QString) sys.hdr.MeasurementSheet;  
     out.items.mon_profile_dir=(QString) sys.hdr.mon_profile_dir;
     out.items.mon_profile_file_name=(QString) sys.hdr.mon_profile_file_name;
 }
 
 void lprofMain::init_measurement_tool()
{
    // qDebug("lprofMain::init_measurement_tool"); 
    TheImage        = NULL;
    TheGrid         = NULL;
    CurrentTemplate = "*";
    CurrentSafeFrame = -1;
    
    int w = CanvasFrame -> width();
    int h = CanvasFrame -> height();
    CanvasFrameLayout =new QVBoxLayout( CanvasFrame ); 
    CanvasFrameLayout->setSpacing( 1 );
    CanvasFrameLayout->setMargin( 1 );
    Canvas = new QCanvas(measure_view_H, measure_view_V);
    Canvas -> setAdvancePeriod(30);
    FigEditor = new FigureEditor(*this, *Canvas, CanvasFrame);
    FigEditor -> clear();
    FigEditor-> resize(w, h);
    FigEditor->setHScrollBarMode(QScrollView::Auto);
    FigEditor->setVScrollBarMode(QScrollView::Auto);

    CanvasFrameLayout->addWidget(FigEditor);  
    
}
 

// Main app contructor. 

lprofMain::lprofMain( QWidget* parent)
    : lprofMainBase( parent )
{
    // qDebug("lprofMain::lprofMain");
    targetList = new QPtrList<target_template>;
    
    Console    = ProgressConsole;
     // Init the lcmsx engine, this always does success
    cmsxScannerProfilerInit(&sys); 
    init_env();
    monitorValues.items.valid_mon=FALSE;
    
    sys.hdr.cmsprintf = ConsolePrintf;
    sys.hdr.Gauger = Gauger;
    
    init_mon();
       
    // Hide Printer_Tab until printer profiling is available
    TabProfiler->removePage(Printer_Tab);
    // Hidden tab is used for items that are no longer visible to users
    TabProfiler->removePage(Hidden);
    
    init_measurement_tool();
    LoadConfig();
    init_targetlist();
    last_tab=0;
 
}

lprofMain::~lprofMain(void)
{
    // qDebug("lprofMain::~lprofMain");
    SaveConfig(); 
}


void lprofMain::ControlsToValues()
{
    // qDebug("lprofMain::ControlsToValues");
    QString cTarget = TargetSelector -> getFilename();

    if (cTarget != QString::null)
            strcpy(sys.hdr.ReferenceSheet, cTarget.local8Bit());
    
    strcpy(sys.hdr.MeasurementSheet,  measfile);
    strcpy(sys.hdr.MonMeasurementSheet, (const char*)MonMeasurementSheet->getFilename().local8Bit());

    strcpy(sys.hdr.OutputProfileFile, (const char*) OutputFileEdit -> text().local8Bit());
    strcpy(sys.hdr.MonOutputProfileFile, (const char*) OutputFileEdit_Mon -> text().local8Bit());
    strcpy(sys.hdr.ref_dir, (const char*)TargetSelector->Dir.local8Bit());
    sys.hdr.cur_ref=TargetSelector->getCurrItem(); 
    strcpy(sys.hdr.template_dir,SelectTemplate->Dir.local8Bit());
    strcpy(sys.hdr.mon_profile_dir, (const char*) MonitorProfileSelector->Dir.local8Bit());
    strcpy(sys.hdr.mon_profile_file_name, (const char*)MonitorProfileSelector->getFilename().local8Bit());
}

// ------------------------------------------------------------------- Results

void lprofMain::DoScannerProfile()
{
    // qDebug("lprofMain::DoScannerProfile");
    Console -> setText("");
    ProgBar = ProgressBar;
    Gauger("Init...", 0, 100, 0);

    SetGoButton("Profiling... please wait", FALSE);
    ConsolePrintf("Working hard...");
    sys.hdr.DeviceClass = icSigInputClass;
    sys.hdr.ColorSpace  = icSigRgbData;
    sys.hdr.PCSType     = PT_Lab;
    sys.hdr.Medium      = MEDIUM_REFLECTIVE_D50;

    QString cTarget = TargetSelector -> getFilename();

    if (cTarget != QString::null)
            strcpy(sys.hdr.ReferenceSheet, cTarget.local8Bit());
    strcpy(sys.hdr.MeasurementSheet, measfile);
     // qDebug("about to call cmsxScannerProfilerDo");
     if (!cmsxScannerProfilerDo(&sys)) 
    {
         ConsolePrintf("** ERROR: Unable to profile.");
	 // qDebug("done failed");
        return;  
    }
    else  // it worked finish up
     {
        Gauger("Init...", 0, 100, 100);
        ConsolePrintf("Profile '%s' DONE!", sys.hdr.OutputProfileFile);
    }
    
    SetGoButton("Ready to GO!", TRUE);
}

void lprofMain::DoMonitorProfile()
{

    // qDebug("lprofMain::DoMonitorProfile");          
    Console -> setText("");
    ProgBar = ProgressBar_2;

    Gauger("Init...", 0, 100, 0);

    SetGoButton("Profiling... please wait", FALSE);
    ConsolePrintf("Working hard...");
    sys.hdr.DeviceClass = icSigDisplayClass;
    sys.hdr.ColorSpace  = icSigRgbData;
    sys.hdr.PCSType     = PT_Lab;
    sys.hdr.Medium      = MEDIUM_TRANSMISSIVE;        
   //  extrap = sys.lLocalConvergenceExtrapolation;
    // sys.lLocalConvergenceExtrapolation = FALSE;
    strcpy(sys.hdr.ReferenceSheet, "");
    if (RadioCoarse->isChecked()) 
        strcpy(sys.hdr.MonMeasurementSheet, "");
    else
        strcpy(sys.hdr.MonMeasurementSheet, MonMeasurementSheet->getFilename().local8Bit());
    if (!cmsxMonitorProfilerDo(&sys)) 
    {
        ConsolePrintf("** ERROR: Unable to profile.");
        return;  // it failed
    }
    else 
    {  // it worked finish up
        Gauger("Init...", 0, 100, 100);
        ConsolePrintf("Profile '%s' DONE!", sys.hdr.MonOutputProfileFile);
    }
		
    SetGoButton("Ready to GO!", TRUE);
 //   sys.lLocalConvergenceExtrapolation = extrap;
}

// --------------------------------------------------------------------- Slots

void setData(uint i)
{
    data[i].CLUTPoints = sys.hdr.CLUTPoints;
    data[i].ProfileVerbosityLevel = sys.hdr.ProfileVerbosityLevel;
    data[i].RsplSmoothness = sys.RsplSmoothness;
    data[i].AvgDev =  sys.AvgDev;
    data[i].lUseCIECAM97s = sys.hdr.lUseCIECAM97s;
    data[i].device.surround = sys.hdr.device.surround;
    data[i].device.La = sys.hdr.device.La;
    data[i].device.Yb = sys.hdr.device.Yb;
    // profile ID information
    strcpy(data[i].Manufacturer, sys.hdr.Manufacturer);
    strcpy(data[i].Model, sys.hdr.Model);
    strcpy(data[i].Copyright, sys.hdr.Copyright);
    strcpy(data[i].Description, sys.hdr.Description);
}


void lprofMain::tabChanged()
{
    setData(last_tab);
     
     last_tab = TabProfiler -> currentPageIndex();
     // profile parms 
    sys.hdr.CLUTPoints = data[last_tab].CLUTPoints;
    sys.hdr.ProfileVerbosityLevel = data[last_tab].ProfileVerbosityLevel;
    sys.RsplSmoothness = data[last_tab].RsplSmoothness;
    sys.AvgDev = data[last_tab].AvgDev;
    sys.hdr.lUseCIECAM97s = data[last_tab].lUseCIECAM97s;
    sys.hdr.device.surround = data[last_tab].device.surround;
    sys.hdr.device.La = data[last_tab].device.La;
    sys.hdr.device.Yb = data[last_tab].device.Yb;
    
    // profile ID information
    strcpy(sys.hdr.Manufacturer, data[last_tab].Manufacturer);
    strcpy(sys.hdr.Model, data[last_tab].Model);
    strcpy(sys.hdr.Copyright, data[last_tab].Copyright);
    strcpy(sys.hdr.Description, data[last_tab].Description);
    
    // ControlsToValues();
    setProfileIDText();
    setProfileParmsText();
    // slotIsAllReady();
        
}

void lprofMain::getConfigParmsandID(QString profile)
{
     // profile parms 
         sys.hdr.CLUTPoints = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", 10);
         sys.hdr.ProfileVerbosityLevel = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", 0);
         sys.RsplSmoothness = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/RsplSmoothness", 1.0);
         sys.AvgDev = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/AvgDev", 0.007);
         sys.hdr.lUseCIECAM97s = settings->readBoolEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", false);
         sys.hdr.device.surround = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/surround", 0);
         sys.hdr.device.La = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/La", 20);
         sys.hdr.device.Yb = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/Yb", 20);

         // profile ID information
         strcpy(sys.hdr.Manufacturer, settings->readEntry("LPROF/profile-"  + profile + "/text/manufacturer", sys.hdr.Manufacturer));
         strcpy(sys.hdr.Model, settings->readEntry("LPROF/profile-"  + profile + "/text/model", sys.hdr.Model));
         strcpy(sys.hdr.Copyright, settings->readEntry("LPROF/profile-"  + profile + "/text/copyright", sys.hdr.Copyright));
         strcpy(sys.hdr.Description, settings->readEntry("LPROF/profile-"  + profile + "/text/description", sys.hdr.Description));
    
}



void lprofMain::OutputFileNameChangedMon()
{
    QString temp, profile;
    bool ok;
   
    profile =  OutputFileEdit_Mon -> text().mid(OutputFileEdit_Mon -> text().findRev('/') + 1,
                                                                            OutputFileEdit_Mon -> text().length() - OutputFileEdit_Mon -> text().findRev('/') - 1);
    temp = settings->readEntry("/LPROF/profile-"  + profile + "/Files/MON_OUTPUT_PROFILE", QString::null, &ok);
    if (ok)  // found entry in lprof settings
    {
        
        getConfigParmsandID(profile);
                  
         ok = settings->readBoolEntry("/LPROF/profile-" +  profile + "/boolians/Course");
         RadioCoarse->setChecked(ok);  
         RadioAccurate->setChecked(!ok);
         
         if (!ok)
         {
               MonMeasurementSheet -> setFilename( settings->readEntry("/LPROF/profile-" + profile + "/Files/MEASUREMENT_SHEET"));
         }
        else
        {
             monitorValues.items.wppos = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/whitePpos");
             monitorValues.items.ppos = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/primePos");
          
             monitorValues.items.rgamma = settings->readEntry("/LPROF/profile-" + profile + "/numbers/rgamma");
             monitorValues.items.ggamma = settings->readEntry("/LPROF/profile-" + profile + "/numbers/ggamma" );
             monitorValues.items.bgamma = settings->readEntry("/LPROF/profile-" + profile + "/numbers/bgamma");
             
             sys.hdr.Primaries.Red.x = settings->readDoubleEntry("/LPROF/profile-"  + profile + "/numbers/red_x");
             sys.hdr.Primaries.Red.y = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/red_y");
             sys.hdr.Primaries.Green.x = settings->readDoubleEntry("/LPROF/profile-" +profile + "/numbers/green_x");
             sys.hdr.Primaries.Green.y = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/green_y");
             sys.hdr.Primaries.Blue.x = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/blue_x");
             sys.hdr.Primaries.Blue.y = settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/blue_y");
                    
             monitorValues.items.temp = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/whitePoint");   
             monitorValues.items.valid_mon = true;
             monitorValues.items.linked = settings->readBoolEntry("/LPROF/profile-" +  profile + "/boolians/linked");
         
             if (sys.Prelinearization[0]) cmsFreeGamma(sys.Prelinearization[0]);
             if (sys.Prelinearization[1]) cmsFreeGamma(sys.Prelinearization[1]);    
             if (sys.Prelinearization[2]) cmsFreeGamma(sys.Prelinearization[2]);
        
             sys.Prelinearization[0] = cmsBuildGamma(256, settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/rgamma"));
             sys.Prelinearization[1] = cmsBuildGamma(256, settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/ggamma" ));
             sys.Prelinearization[2] = cmsBuildGamma(256, settings->readDoubleEntry("/LPROF/profile-" + profile + "/numbers/bgamma"));
          }
         setData(1);

         ControlsToValues();
         setProfileIDText();
         setProfileParmsText();
         slotIsAllReady();
         }    
}

void lprofMain::OutputFileNameChanged()
{
    QString temp, profile, template_file, target;
    bool ok;
    
    profile =  OutputFileEdit -> text().mid(OutputFileEdit -> text().findRev('/') + 1,
                                                                  OutputFileEdit -> text().length() - OutputFileEdit -> text().findRev('/') - 1);
    temp = settings->readEntry("/LPROF/profile-"  + profile + "/Files/OUTPUT_PROFILE", QString::null, &ok);
    if (ok)  // found entry in lprof settings
    {         
        Marks.ur_x = settings->readNumEntry("/LPROF/profile-"  +  profile + "/numbers/ur_x");
        Marks.ur_y = settings->readNumEntry("/LPROF/profile-"  + profile + "/numbers/ur_y");
        Marks.lr_x = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/lr_x");
        Marks.lr_y = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/lr_y");
        Marks.ul_x = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ul_x");
        Marks.ul_y = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ul_y");
        Marks.ll_x = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ll_x");
        Marks.ll_y = settings->readNumEntry("/LPROF/profile-" + profile + "/numbers/ll_y");
        fn = settings->readEntry("/LPROF/profile-" + profile + "/Files/IT8Image");
        // SelectTemplate->setCurrItem(settings->readNumEntry( "/LPROF/profile-" + profile + "/numbers/TEMPLATE_NUM"));
        // TargetSelector->setCurrItem(settings->readNumEntry( "/LPROF/profile-" + profile + "/numbers/TARGET_NUM"));
        // template_file = settings->readEntry( "/LPROF/profile-" + profile + "/numbers/TEMPLATE_Filename" );
        target = settings->readEntry( "/LPROF/profile-" + profile + "/numbers/TARGET_Filename");
        
         if (!targetList->isEmpty()) 
        for (uint i=0; i<=targetList->count()-1; i++) 
        {
             if (targetList->at(i)->targetFile == target) 
             {
                 SelectTemplate->setCurrItem(targetList->at(i)->tempPos);
                 TargetSelector->setCurrItem(targetList->at(i)->targPos);
             }
        }
         
        getConfigParmsandID(profile);
        
        ControlsToValues();
        setProfileIDText();
        setProfileParmsText();
        
         setData(0);
         
        FigEditor->clear();
        TheGrid = NULL;
        CurrentTemplate = "";
        // fix me ?? what does ProofTogle do ???
        if (ProofToggle -> isOn()) ProofToggle -> toggle();

        TheImage = new ImageItem(fn, MonitorProfileSelector ->getFilename(),
                                                InputProfileSelector->getFilename(),  
                                               Canvas);
        // open the image file
       Reload();
       // place corner markers and pick
                    
       grid_corners.putPoints(0, 4, Marks.ul_x,  Marks.ul_y, 
                                                       Marks.ur_x, Marks.ur_y, 
                                                       Marks.lr_x, Marks.lr_y, 
                                                       Marks.ll_x, Marks.ll_y);
       AddTemplate();
       // check to see if all corners are marked and it is time to place full template and pick
    
       corners_ready=TRUE;
       slotPick();
       slotIsAllReady();
       }   
}

void lprofMain::slotSelectOutputFile()
{
    // qDebug("lprofMain::slotSelectOutputFile");

    QString fn = QFileDialog::getSaveFileName( outprofile, 
                                                "icc profiles (*.icc *.icm)\nAll files (*.*)",
                                                this,
                                                "",
                                                "Select output profile filename");
    if (fn != QString::null)
        SetOutputFile(fn);
    ConsolePrintf("select file name");
    // slotIsAllReady();
} 

void lprofMain::slotIsAllReady()
{
    // qDebug("lprofMain::slotIsAllReady");
    // check what type of profile is currently being worked on
    // and decide if the GoButton should be enabled
    switch (TabProfiler -> currentPageIndex()) {

        case 0: 
                if (TargetSelector -> getFilename() == QString::null)
                    SetGoButton("You still have to select the target reference file", FALSE);
                else if (OutputFileEdit -> text() == "")
                    SetGoButton("You need to specify output profile!", FALSE);
                else 
                {
                    // OutputFileNameChanged();
                    if (!(Marks.ul_x>0 && Marks.ur_x>0 && Marks.ll_x>0 && Marks.lr_x>0))
                        SetGoButton("You need to load a target image and select it's corners!", FALSE);
                    else 
                        SetGoButton("Ready to GO!", TRUE);
                }
                break;
        case 1: 
                if (OutputFileEdit_Mon -> text() == "")
                    SetGoButton("You need to specify output profile!", FALSE);
                else 
                {   
                    // OutputFileNameChanged();
                    if (RadioCoarse->isChecked())
                    {
                       if (monitorValues.items.valid_mon)
                           SetGoButton_2("Ready to GO!", TRUE); 
                       else
                           SetGoButton_2("You need to enter monitor values.", FALSE);       
                    }
                    else if (MonMeasurementSheet->getFilename()=="")  
                       SetGoButton_2("You need to specify a measurement sheet!", FALSE);
                    else
                      SetGoButton_2("Ready to GO!", TRUE);
                } 
                break;

    default:; // if not on a profileing tab then do nothing
        
    }	
}


void lprofMain::Go_button_clicked()
{
    // qDebug("lprofMain::Go_button_clicked");
   ControlsToValues();
   switch (TabProfiler -> currentPageIndex()) {

        case 0: DoScannerProfile(); break;
        case 1: DoMonitorProfile(); break;
        
    default:;  // if not on a profiling tab do nothing
    }	
    saveProfileDetails();
}


void lprofMain::slotTargetChanged()
{
    // qDebug("lprofMain::slotTargetChanged");
    // DescriptorText -> setText("");

    QString TargetFile = TargetSelector -> getFilename();
    
    if (TargetFile == QString::null) return;

    LCMSHANDLE hIT8 = cmsxIT8LoadFromFile(TargetFile.local8Bit());
    if (hIT8 == NULL) return;

     cmsxIT8Free(hIT8);
     slotIsAllReady();

}

BOOL lprofMain::LoadConfig()
{
    char temp[128];
    target_template hold;
    
    // qDebug("lprofMain::LoadConfig");
    settings = new QSettings();
    settings->setPath( "lprof.sourceforge.net", "lprof");
    settings->insertSearchPath( QSettings::Unix, QDir::homeDirPath() + "/.lprof/config" );
    
    SelectTemplate->Dir = settings->readEntry("/LPROF/Files/TEMPLATE_DIR", "");
    
    // QString temp1 = SelectTemplate->Dir;
    if (SelectTemplate->Dir.length() > 0)
    {   
                // from Measurement tool
        // SelectTemplate->Dir = settings->readEntry("/LPROF/Files/TEMPLATE_DIR", "");   
        SelectTemplate->FillValues();
        // SelectTemplate->setCurrItem(settings->readNumEntry( "/LPROF/numbers/TEMPLATE_NUM", 0));
        
        MonitorProfileSelector ->Dir = settings->readEntry( "/LPROF/Files/MONITOR_PROFILES_DIR", "");
        MonitorProfileSelector ->RestrictColorspace = icSigRgbData;
        MonitorProfileSelector ->RestrictClass = icSigDisplayClass;
        MonitorProfileSelector -> FillValues();
        MonitorProfileSelector ->setFilename(settings->readEntry( "/LPROF/Files/MONITOR_PROFILE", ""));

        InputProfileSelector->Dir = (settings->readEntry( "/LPROF/Files/INPUT_PROFILES_DIR", ""));
        InputProfileSelector-> RestrictColorspace = icSigRgbData;
        InputProfileSelector->FillValues();
        InputProfileSelector->setFilename(settings->readEntry( "/LPROF/Files/INPUT_PROFILE", ""));

        SafeFrame -> setValue(settings->readNumEntry( "/LPROF/numbers/SAFE_FRAME", 0));
        
        TargetSelector->Dir = (settings->readEntry("/LPROF/Files/TARGET_DIR", ""));	
        TargetSelector->FillValues();
        // TargetSelector->setCurrItem(settings->readNumEntry( "/LPROF/numbers/TARGET_NUM", 0));
        
        targetList->clear();
        const int n=settings->readNumEntry( "/LPROF/numbers/NUMBER_TARGETS", 0);
        for (int i=0; i<=n-1; i++) 
        {
            // file target to template list with information
            sprintf(temp,"/LPROF/Files/TARGET%i", i);
            hold.targetFile=settings->readEntry(temp, "");
            sprintf(temp,"/LPROF/Files/TEMPLATE%i", i);
            hold.templateFile=settings->readEntry(temp, "" );
            add_target(hold);
        }
        
        if ((uint)TargetSelector->count() > targetList->count())
        {
            // we know that at least one target has been added since the last time the 
            // the config file was saved.  So we must up date the targetList->
           // This should never happen since it is an indication that the program crashed
           // the last time it was run or the user manually copied a reference file to the 
           // hidden configuration directory
            qDebug("Target not in targetList");
        }
        init_targetlist();   
        slotTargetRefChanged();
        OutputFileEdit_Mon -> setText(settings->readEntry("/LPROF/Files/MON_OUTPUT_PROFILE", ""));
        OutputFileEdit -> setText(settings->readEntry("/LPROF/Files/OUTPUT_PROFILE", ""));

        return TRUE;
    } 
          //  means no config file found this is first time app has been run
          // config file will be created when program is closed
         // Set everything to default values
   
    SafeFrame -> setValue(60);
    SelectTemplate -> Dir = templates;
    SelectTemplate->FillValues();
    SelectTemplate->setCurrItem(0);
    TargetSelector->Dir = ref_dir;
    TargetSelector->FillValues();
    TargetSelector->setCurrItem(0);
    MonitorProfileSelector ->Dir = mon_profile;
    MonitorProfileSelector ->FillValues();
    InputProfileSelector ->Dir = in_profile;
    InputProfileSelector->FillValues();  
    return FALSE;
	
}


void lprofMain::setProfileParmsText()
{
    char buff[128];
    // qDebug("lprofMain::setProfileParmsText");
    sprintf(buff,"Resolution (CLUT points):  %i", sys.hdr.CLUTPoints );
    textEditProfileParms->setText(buff);
    
    switch (sys.hdr.ProfileVerbosityLevel)
    {
    case 0:
        textEditProfileParms->insertParagraph("Profile verbosity: Only required tags", 3);
        break;
    case 1: 
        textEditProfileParms->insertParagraph("Profile verbosity: Store additional tags", 3);
        break;
    case 2: 
        textEditProfileParms->insertParagraph("Profile verbosity: Store anything", 3);
        break;
    }
  
    textEditProfileParms->insertParagraph("Regression:", 5);
     sprintf(buff,"    Smoothness: %g",sys.RsplSmoothness);
     textEditProfileParms->insertParagraph(buff, 6);
     sprintf(buff,"    Deviation: %g",sys.AvgDev);
     textEditProfileParms->insertParagraph(buff, 7);
    
    if (sys.hdr.lUseCIECAM97s)
    {
	 textEditProfileParms->insertParagraph("CIECAM97s: ", 8);
	 sprintf(buff,"%i",sys.hdr.device.surround);

	 switch (sys.hdr.device.surround)
	 {
	 case 0:  
	     textEditProfileParms->insertParagraph("     Average surround (>4)",9);
	     break;
	 case 1:  
	     textEditProfileParms->insertParagraph("     Average surround", 9);
	     break;
	 case 2: 
	     textEditProfileParms->insertParagraph("     Dim surround", 9);
	     break;
	 case 3: 
	     textEditProfileParms->insertParagraph("     Dark surround", 9);
	     break;
	 case 4:	 
	     textEditProfileParms->insertParagraph("     Cutsheet surround", 9);
	     break;
	 default:
	      textEditProfileParms->insertParagraph("     Average surround (>4)", 9);
                }
	 sprintf(buff,"     La: %g",sys.hdr.device.La);
	 textEditProfileParms->insertParagraph(buff, 10);
	 sprintf(buff,"     Yb: %g",sys.hdr.device.Yb);
	 textEditProfileParms->insertParagraph(buff, 10);

     }   
    else textEditProfileParms->insertParagraph("Linear Bradford ", 8);
  
}

void lprofMain::saveProfileDetails()
{
    char slash[3];
    bool cs_profile = true;
    QDir d;
    QString home_path, copy, profile;

    # ifdef __WIN32__
         strcpy(slash, "\\");    // set correct slash character for Windows files operations 
         copy = "copy \"";
     # else
         strcpy(slash,  "/");
         copy = "cp \"";
     # endif /* __WIN32__ */
    
    if (TabProfiler -> currentPageIndex()== 0)
    {
          profile = OutputFileEdit -> text().mid(OutputFileEdit -> text().findRev('/') + 1,
                                                                       OutputFileEdit -> text().length() - OutputFileEdit -> text().findRev('/') - 1);
          settings->writeEntry("/LPROF/profile-" + profile + "/Files/OUTPUT_PROFILE", OutputFileEdit -> text()); 
         home_path = dir.convertSeparators(dir.homeDirPath());
         home_path =  home_path + (QString) slash + (QString) ".lprof" + (QString)slash + 
                                (QString)"measurements" + (QString)slash + profile + (QString) ".cgt";
         QString copycommand = copy + dir.convertSeparators(measfile) + "\" \"" + home_path + "\"";
         system (copycommand);

         settings->writeEntry("/LPROF/profile-" + profile + "/Files/MEASUREMENT_SHEET", (QString) profile + ".cgt");
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ur_x", Marks.ur_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ur_y", Marks.ur_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/lr_x", Marks.lr_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/lr_y", Marks.lr_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ul_x", Marks.ul_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ul_y", Marks.ul_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ll_x", Marks.ll_x);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/ll_y", Marks.ll_y);
         settings->writeEntry("/LPROF/profile-" + profile + "/Files/IT8Image", image_file_name);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/RsplSmoothness", sys.RsplSmoothness);
         settings->writeEntry("/LPROF/profile-" + profile + "/numbers/AvgDev", sys.AvgDev);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", (int) sys.hdr.CLUTPoints);
         settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", (int) sys.hdr.ProfileVerbosityLevel);
         
        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TEMPLATE_NUM", SelectTemplate->getCurrItem() );
        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TARGET_NUM", TargetSelector->getCurrItem());
        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TEMPLATE_Filename", SelectTemplate->getFilename() );
        settings->writeEntry( "/LPROF/profile-" + profile + "/numbers/TARGET_Filename", TargetSelector->getFilename());
        
        settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", sys.hdr.lUseCIECAM97s);
        settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/surround", sys.hdr.device.surround);
        settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/La", sys.hdr.device.La);
        settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/Yb", sys.hdr.device.Yb);

        // profile ID
        settings->writeEntry("/LPROF/profile-" +  profile + "/text/manufacturer", sys.hdr.Manufacturer);
        settings->writeEntry("/LPROF/profile-" +  profile + "/text/model", sys.hdr.Model);
        settings->writeEntry("/LPROF/profile-" + profile + "/text/copyright", sys.hdr.Copyright);
        settings->writeEntry("/LPROF/profile-" + profile + "/text/description", sys.hdr.Description);
   
    }
    else if (TabProfiler -> currentPageIndex()== 1)
    {
        profile = OutputFileEdit_Mon -> text().mid(OutputFileEdit_Mon -> text().findRev('/') + 1,
                                                                               OutputFileEdit_Mon -> text().length() - OutputFileEdit_Mon -> text().findRev('/') - 1); 
        cs_profile = false;
        settings->writeEntry("/LPROF/profile-"    + 
                             (QString) profile + 
                             "/Files/MON_OUTPUT_PROFILE", 
                             OutputFileEdit_Mon -> text()); 
       if (!RadioCoarse->isChecked())
       {
          home_path = dir.convertSeparators(dir.homeDirPath());
          QString meas_file =  home_path + (QString) slash + (QString) ".lprof" + (QString)slash + (QString)"measurements" + (QString)slash + (QString) profile + (QString) ".cgt";
          QString copycommand = copy + dir.convertSeparators(MonMeasurementSheet->getFilename()) + "\" \"" + meas_file + "\"";
          system (copycommand);

          settings->writeEntry("/LPROF/profile-"  + profile + "/Files/MEASUREMENT_SHEET",  meas_file);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/SAFE_FRAME", (int) SafeFrame->value());
          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/Course", false);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", (int) sys.hdr.CLUTPoints);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", (int) sys.hdr.ProfileVerbosityLevel);
    
          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", sys.hdr.lUseCIECAM97s);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/surround", sys.hdr.device.surround);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/La", sys.hdr.device.La);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/Yb", sys.hdr.device.Yb);

          // profile ID
         settings->writeEntry("/LPROF/profile-" + profile + "/text/manufacturer", sys.hdr.Manufacturer);
         settings->writeEntry("/LPROF/profile-" + profile + "/text/model", sys.hdr.Model);
         settings->writeEntry("/LPROF/profile-" + profile + "/text/copyright", sys.hdr.Copyright);
         settings->writeEntry("/LPROF/profile-" + profile + "/text/description", sys.hdr.Description);

          
       }
       else
       {
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/whitePpos", monitorValues.items.wppos);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/primePos", monitorValues.items.ppos);
          
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/rgamma", monitorValues.items.rgamma.toDouble());
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/ggamma", monitorValues.items.ggamma.toDouble());
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/bgamma", monitorValues.items.bgamma.toDouble());
          
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/red_x", sys.hdr.Primaries.Red.x);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/red_y", sys.hdr.Primaries.Red.y);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/green_x", sys.hdr.Primaries.Green.x);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/green_y", sys.hdr.Primaries.Green.y);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/blue_x", sys.hdr.Primaries.Blue.x);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/blue_y", sys.hdr.Primaries.Blue.y);
                    
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/whitePoint", monitorValues.items.temp); 
          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/Course", true);
          settings->writeEntry("/LPROF/profile-" +  profile + "/boolians/linked", monitorValues.items.linked);
          
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/CLUT_POINTS", (int) sys.hdr.CLUTPoints);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/PROFILE_VERBOSITY_LEVEL", (int) sys.hdr.ProfileVerbosityLevel);
    
          settings->writeEntry("/LPROF/profile-"  + profile + "/boolians/lUseCIECAM97s", sys.hdr.lUseCIECAM97s);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/surround", sys.hdr.device.surround);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/La", sys.hdr.device.La);
          settings->writeEntry("/LPROF/profile-"  + profile + "/numbers/Yb", sys.hdr.device.Yb);

          // profile ID
          settings->writeEntry("/LPROF/profile-" + profile + "/text/manufacturer", sys.hdr.Manufacturer);
          settings->writeEntry("/LPROF/profile-" + profile + "/text/model", sys.hdr.Model);
          settings->writeEntry("/LPROF/profile-" + profile + "/text/copyright", sys.hdr.Copyright);
          settings->writeEntry("/LPROF/profile-" + profile + "/text/description", sys.hdr.Description);
       }
    }
    else qDebug("Something wrong");  // will be needed later for printer profiler tab
}


void lprofMain::setProfileIDText()
{  
    // qDebug("lprofMain::setProfileIDText");
    textEditProfileID->setText( "Model: ");
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert( sys.hdr.Model);
    textEditProfileID->insertParagraph("Manufacturer: ", 3);
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Manufacturer);
    textEditProfileID->insertParagraph("Description: ", 5); 
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Description);
    textEditProfileID->insertParagraph("Copyright: ", 7);
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Copyright);
}

void lprofMain::SaveConfig()
{  
    char temp[128];
    // qDebug("lprofMain::SaveConfig");
    
    settings->writeEntry("/LPROF/Files/TARGET_DIR", TargetSelector->Dir);
   // settings->writeEntry("/LPROF/numbers/TARGET_NUM", (int)TargetSelector->getCurrItem());
    settings->writeEntry("/LPROF/numbers/NUMBER_TARGETS", (int) targetList->count());
    if (!targetList->isEmpty()) 
        for (uint i=0; i<=targetList->count()-1; i++) 
        {
            // add target to template information
            sprintf(temp,"/LPROF/Files/TARGET%i", i);
            settings->writeEntry(temp, targetList->at(i)->targetFile);
            sprintf(temp,"/LPROF/Files/TEMPLATE%i", i);
            settings->writeEntry(temp, targetList->at(i)->templateFile);
        }
    
    settings->writeEntry("/LPROF/Files/OUTPUT_PROFILE", OutputFileEdit -> text());
    settings->writeEntry("/LPROF/Files/MON_OUTPUT_PROFILE",  OutputFileEdit_Mon ->text());
        
    settings->writeEntry("/LPROF/Files/TEMPLATE_DIR", SelectTemplate->Dir);
    // settings->writeEntry("/LPROF/numbers/TEMPLATE_NUM", (int) SelectTemplate->getCurrItem());
    settings->writeEntry("/LPROF/Files/MONITOR_PROFILES_DIR", MonitorProfileSelector->Dir);
    settings->writeEntry("/LPROF/Files/MONITOR_PROFILE", MonitorProfileSelector->getFilename());
    settings->writeEntry("/LPROF/Files/INPUT_PROFILES_DIR", InputProfileSelector->Dir);
    settings->writeEntry("/LPROF/Files/INPUT_PROFILE", InputProfileSelector->getFilename());
    settings->writeEntry("/LPROF/numbers/SAFE_FRAME", (int) SafeFrame->value());

    settings->~QSettings();
}

void lprofMain::slotChangeStrategy()
{
    // qDebug("lprofMain::setProfileIDText");
    NoHardwareLabel->setEnabled(RadioCoarse->isChecked());
    MeasureMonitorButton->setEnabled(RadioCoarse->isChecked());
    MonMeasurementSheet->setEnabled(RadioAccurate->isChecked());
    ControlsToValues(); 
    slotIsAllReady();
}

void lprofMain::slotTargetRefChanged()
{
   if (!targetList->isEmpty())  // taragetList has items and we are now at the begining
      for (uint i=0; i<targetList->count(); i++)
         if (targetList->at(i)->targPos == TargetSelector->getCurrItem())
            {
                SelectTemplate->setCurrItem(targetList->at(i)->tempPos);
                break;
            }      
}

// interfaces to other dialogs

void lprofMain::ProfChecker_clicked()
{
    // qDebug("lprofMain::profChecker_clicked");
    QString temp_measurement, temp_Output, Mon_temp_measure;
    
    ControlsToValues();
     temp_measurement= (QString)  sys.hdr.MeasurementSheet;
     temp_Output = (QString)  sys.hdr.OutputProfileFile;
     Mon_temp_measure = (QString) sys.hdr.MonMeasurementSheet;
     
     switch (lprofMain::TabProfiler -> currentPageIndex()) 
     {
        case 0:  break;
        case 1:  if (RadioCoarse->isChecked())
                          strcpy( sys.hdr.MonMeasurementSheet, "");
                      strcpy(sys.hdr.OutputProfileFile, sys.hdr.MonOutputProfileFile);
                      strcpy(sys.hdr.MeasurementSheet, sys.hdr.MonMeasurementSheet);     
                      break;
        
    default:;  // if not on a profiling tab do nothing
    }
    
    ProfileChecker check(this);
    check.show();
    check.exec();
    strcpy(sys.hdr.MonMeasurementSheet, Mon_temp_measure);
    strcpy( sys.hdr.MeasurementSheet, temp_measurement); 
    strcpy(sys.hdr.OutputProfileFile, temp_Output);
}

void lprofMain::ProfIDpushButton_clicked()
{
    // qDebug("lprofMain::ProfIDButton_clicked");
    ProfileID profID(this);
    profID.setModal(true);
    profID.show();
    profID.exec();
    
    setProfileIDText();
    slotIsAllReady();    
}


void lprofMain::ProfileParmsbutton()
{
    // qDebug("lprofMain::ProfileParmsbutton");
    ProfileParms profParms(this);
    profParms.show();
    profParms.exec();
    
    setProfileParmsText();
    slotIsAllReady();
}


void lprofMain::monitorvalues_clicked()
{
    // qDebug("lprofMain::monitorvalues_clicked");
    MonitorValues monVal(this);
    monVal.show();
    monVal.exec();
    slotIsAllReady();
}

void monVal::get(monVal* out)
{
    // qDebug("in get mon");
    out->items.wppos=monitorValues.items.wppos;
    out->items.ppos=monitorValues.items.ppos;
    out->items.temp=monitorValues.items.temp;
    out->items.linked=monitorValues.items.linked;
    out->items.rgamma=monitorValues.items.rgamma;
    out->items.ggamma=monitorValues.items.ggamma;
    out->items.bgamma=monitorValues.items.bgamma;
    out->items.rchecked=monitorValues.items.rchecked;
    out->items.gchecked=monitorValues.items.gchecked;
    out->items.bchecked=monitorValues.items.bchecked;
      
    }

void monVal::put(monVal &in)
{
     monitorValues.items=in.items;
}

void passSys::get( PROFILERDATA* out)
{
    out->hdr=sys.hdr;
    out->Prelinearization[0]=sys.Prelinearization[0];
    out->Prelinearization[1]=sys.Prelinearization[1];
    out->Prelinearization[2]=sys.Prelinearization[2];
    out->ReverseTables[0]=sys.ReverseTables[0];
    out->ReverseTables[1]=sys.ReverseTables[1];
    out->ReverseTables[2]=sys.ReverseTables[2];
    out->PreLab[0]=sys.PreLab[0];
    out->PreLab[1]=sys.PreLab[1];
    out->PreLab[2]=sys.PreLab[2];
    out->PreLabRev[0]=sys.PreLabRev[0];
    out->PreLabRev[1]=sys.PreLabRev[1];
    out->PreLabRev[2]=sys.PreLabRev[2];
    out->PrimariesMatrix=sys.PrimariesMatrix;
    out->PrimariesMatrixRev=sys.PrimariesMatrixRev;
    out->HiTerms=sys.HiTerms;       
    out->LoTerms=sys.LoTerms;
    out->lLocalConvergenceExtrapolation=sys.lLocalConvergenceExtrapolation;
    out->RsplSmoothness=sys.RsplSmoothness;
    out->AvgDev=sys.AvgDev; 
    out->UseRspl=sys.UseRspl;
    out-> Rspl=sys.Rspl;     
}

void passSys::put(PROFILERDATA &in)
{
     sys=in;
}

void lprofMain::init_targetlist()
{
    QString TargetFile = TargetSelector -> getFilename();
    QString TemplateFile = SelectTemplate -> getFilename();
    int i = TargetSelector->getCurrItem();
    int n = SelectTemplate->getCurrItem();
    // reinitialize TargetSelector so that it has the new target ref file/template file pair if one was added
    // This could cause the possition of the currently selected target to change in the drop down
    // So we must get the filename from the curent item to make sure that this item is selected 
    // when this is finished and before TargetSelector is reintitalized with FillValues
    TargetSelector->FillValues();
    // find new possition of currently selected target
    int j;
    for (j=0; j<TargetSelector->count(); j++)
    {
        TargetSelector->setCurrItem(j);
        if (TargetSelector->getFilename()==TargetFile) 
        { 
            i=j;
           j=TargetSelector->count();
        }
    }
    
    for (j=0; j<SelectTemplate->count(); j++)
    {
        SelectTemplate->setCurrItem(j);
        if (SelectTemplate->getFilename()==TargetFile) 
        { 
            n=j;
           j=SelectTemplate->count();
        }
    }
    // Now add new target and it's template to the target list
    for (j=0; j<TargetSelector->count(); j++)
    {
        TargetSelector->setCurrItem(j);
        for (int k=0; k<SelectTemplate->count(); k++)
        {
            SelectTemplate->setCurrItem(k);
                      
            if (!targetList->isEmpty())  // taragetList has items and we are now at the begining
                for (uint m=0; m<targetList->count(); m++)  
                     if (targetList->at(m)->targetFile==TargetSelector->getFilename() && 
                        targetList->at(m)->templateFile==SelectTemplate->getFilename())
                       { 
                           targetList->at(m)->targPos=j;
                           targetList->at(m)->tempPos=k;
                       }
         }
     }
   TargetSelector->setCurrItem(i);
   SelectTemplate->setCurrItem(n);
}


void targetTemplate::put(targetTemplate &in)
{ 
    if (in.items.targetFile!=""&&in.items.templateFile!="")
        add_target(in.items);     
}

void lprofMain::slotInstallReference()
{
    // qDebug("lprofMain::ProfIDButton_clicked");
    InstallRefFile reffile(this);
    reffile.setModal(true);
    reffile.show();
    reffile.exec();
    init_targetlist();
    // qDebug("back from inti_targetList");
    slotTargetRefChanged();
    slotIsAllReady();    
}

void lprofMain::slotHelpButton()
{
    QStringList cmdLst;
     QString execpath = (QString) get_QTDIR() + (QString) "/bin";
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     // qDebug("path used in the command list = " + path);
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/lprof-help.html";
     // qDebug(path);
     help->openAssistant ();
     help->showPage(path);
}
