// $Id: profilechecker.h,v 1.3 2006/02/19 23:59:12 hvengel Exp $
//  Lttle cms Profiler
//  Copyright (C) 1998-2001 Marti Maria 
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11
#ifndef PROFILECHECKER_H
#define PROFILECHECKER_H

#include <qstringlist.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qslider.h>
#include <qfiledialog.h>
#include <qmultilineedit.h>
#include <qtabwidget.h>
#include <qtextview.h>
#include <qprogressbar.h>
#include <qdir.h>
#include <qapplication.h>
#include <qtable.h>
#include <qtooltip.h>
#include "profilecheckerbase.h"
#include "lcmsprf.h"

#include <qvariant.h>
#include <qpixmap.h>

class  ProfileChecker : public ProfileCheckerBase
{
  Q_OBJECT
    
public:
    
  ProfileChecker(QWidget *parent = 0 );
  virtual ~ProfileChecker();
  
public slots:

	virtual void slotSelectOutputFile();
	virtual void slotGO();
	virtual void slotChangeCurve();
	virtual void slotUpdateLabels();
	virtual void slotSelectScanoutIT8();  
    
protected:

	virtual void resizeEvent(QResizeEvent* );

	void ResetData(BOOL lFree = FALSE);
	
	void SetInputProfile(const QString OutputFile);
	void SetScanoutFile(const QString ScanoutFile);

	int  GetIntent(void);

	void InspectProfile();

	void ResetMeasurement(BOOL lFree);
	void RedrawTonge();
	void RedrawCurve();
              void slotHelpButton();

	// The Data

	char ReferenceSheet[MAX_PATH];
              char MeasurementSheet[MAX_PATH];
	char OutputProfileFile[MAX_PATH];

	

	MEASUREMENT m;

	icColorSpaceSignature ProfileColorSpace;
	icColorSpaceSignature PCSColorSpace;
	int nChennels;

	cmsCIExyYTRIPLE Primaries;
	cmsCIEXYZ		MediaWhite;

	LPGAMMATABLE TRC[3];
	LPGAMMATABLE A2B0Pre[3][MAXCHANNELS];
	LPGAMMATABLE A2B0Post[3][MAXCHANNELS];
	LPGAMMATABLE B2A0Pre[3][MAXCHANNELS];
	LPGAMMATABLE B2A0Post[3][MAXCHANNELS];

	char* CharTarget;
	size_t CharTargetSize;
	
};

#endif
