// $Id:
//  Lttle cms Profiler
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11

#include "profileid.h"
#include <lprofmain.h>
#include <qvariant.h>
#include <qdialog.h>
#include  <qwidget.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <string.h>
#include <lcmsprf.h>

static PROFILERDATA sys;
   	
ProfileID::ProfileID( QWidget *parent)
    : ProfileIDBase(parent)
{ 
   passSys a;
   
   a.get(&sys);
    ManufacturerEdit->setText(sys.hdr.Manufacturer);
    ModelEdit -> setText(sys.hdr.Model);
    CopyrightEdit -> setText(sys.hdr.Copyright);
    DescriptionEdit -> setText(sys.hdr.Description);
   // CommentsEdit->setText(sys.hdr.Comments);
}

ProfileID::~ProfileID()
{
  
}

void ProfileID::slotUpdateValues()
{
    passSys a;
    
      strcpy(sys.hdr.Manufacturer, ManufacturerEdit->text().local8Bit());
      strcpy(sys.hdr.Model, ModelEdit -> text().local8Bit());
      strcpy(sys.hdr.Copyright, CopyrightEdit -> text().local8Bit());
      strcpy(sys.hdr.Description, DescriptionEdit -> text().local8Bit());
      // strcpy(sys.hdr.Comments, CommentsEdit->text());
      a.put(sys);
  }

static QAssistantClient *help;

QString ID_get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

void ProfileID::slotHelpButton()
{
     QString execpath = (QString) ID_get_QTDIR() + (QString) "/bin";
     help = new QAssistantClient(execpath, this);
     QStringList cmdLst;
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/profile-id.html";
     help->openAssistant ();
     help->showPage(path);
}

