/***************************************************************************
                          adslstatus.c  -  description
                             -------------------
    begin                : |2001-06-21|
    copyright            : (C) |2001| by |Bert van Oortmarssen|
    email                : |bert.van.oortmarssen@xs4all.nl|
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
version 0.10 initial release
version 0.11 workaround for 4Gb overflow in counters in /proc/net/dev
version 0.12 error in recovery from abort on pppd
 	marker since last status request added on Cyberdude47's request 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/stat.h>
#include <signal.h>

#include "adslstatus.h"
#include "adsl.h"

#define FOURGB	4294967296.0

/* global variables */

time_t	tmNow;
uid_t	uid;
char	pppBuf[256];		/* textbuffer containing ppp0 info */
struct stat st;				/* contains filestatus of STATFILE */
double	received, sent ;

int isAdslUp()
{
char	buffer[256], device[80];
FILE	*f;
int	found,count;


	/*check for status file first*/
	if (stat(STATFILE, &st) < 0)
	{	fprintf(stderr,"\nFailed to retrieve status for: %s\n", STATFILE);
		fprintf(stderr,"Probably is your connection down, this program is stopped\n");
		return 0;
	}
	/* try to get networkcounters for ppp0, if not available then problems*/
	found = 0;
	f=fopen(DEVFILE, "rt");
	if (f)
	{	fgets(buffer, 254, f);
		fgets(buffer, 254, f);

		while(fgets(buffer, 254, f))
		{	if (strstr(buffer,"ppp0")!=NULL)
    	{	found = 1;
				strcpy(pppBuf,buffer);
				count = sscanf(buffer, "%*[ \t]%5[a-zA-Z0-9]%*1[:]%lf%*d%*d%*d%*d%*d%*d%*d%lf", (char *) &device, &received, &sent);
		    break;
	    }
		}
		fclose(f);
		if (!found)
		{	fprintf(stderr,"\nadslstatus: Device ppp0 not found!! Problems??\n");
			return 0;
		}
	}
	else
	{ fprintf(stderr,"Huh?? Can't open file: %s\n", DEVFILE);
		return 0;
	}
	return 1;
}

int startlogging()
{	
	/* 	logging must be started */
	/* 	first create a logfile for the current connection
			the timestamp is found in the create time of ppp-mxstream.pid
	*/

	FILE	*fp;
	char	buffer[256],buffer2[256];
	char	szToday[80], *ptr, szMonth[80];
	double recToday = 0.0;
	double sendToday = 0.0;
	
	strftime((char *) &buffer2, 100, "%Y-%m-%d %H:%M:%S", localtime(&st.st_ctime));
	fp = fopen(CURRSESSFILE,"rt");
  if (fp)
	{	fgets(buffer,80,fp);
		fclose(fp);
		if (strncmp(buffer,buffer2,19)==0)
		{	fprintf(stderr,"Logging for this connection already enabled\n");
			return 0;
		}
		else
		{	/* an old logging never has been stopped, recovery required */
			fp = fopen(SESSIONLOG,"at");
			if (fp)
			{	fprintf(fp,"%s\n",buffer);
				fclose(fp);
			}
		}
  }
	fp = fopen(CURRSESSFILE,"wt");
	if (fp)
	{ 		fprintf(fp,"%s %s %14.0f %14.0f",buffer2,buffer2,received,sent);

		fclose(fp);
	}
	else
	{ fprintf(stderr,"\nFailed to create %s\n",CURRSESSFILE);
    return 1;
	}
	/* check for existence of daily counters */
	strftime((char *) &szToday, 79, "%Y-%m-%d", localtime(&st.st_ctime));
	if ( (fp = fopen(TODAYFILE,"rt")))
  {	fgets(buffer,80,fp);
		fclose(fp);
		if (strncmp(szToday,buffer,10)==0)
		{  /* same day */
			ptr = strchr(buffer,' ');
			if (ptr)
			{	recToday = strtod(ptr, (char **) &ptr);
				sendToday = strtod(ptr, (char **) &ptr);
			}
		}
    else
		{	/* daily counters are from other day, caused by stop and restart next day so do some recovery */
			if ( (fp=fopen(DAILYLOG,"at") ))
		  {	double s,r;
				char *ptr;
				ptr = strchr(buffer,' ');
				r = strtod(ptr, (char **) &ptr);
				s = strtod(ptr, (char **) &ptr);
				buffer[10]=0;
				fprintf(fp,"%s %14.0f %14.0f\n",buffer,r,s);
				fclose(fp);
			}
		}
  }
	if ((fp = fopen(TODAYFILE,"wt")))
	{	fprintf(fp,"%s %14.0f %14.0f %14.0f %14.0f",szToday,recToday,sendToday,0.0,0.0);
		fclose(fp);
	}

	/* check for existence of monthly counters */
	strftime((char *) &szMonth, 79, "%Y-%m", localtime(&st.st_ctime));
	if ( (fp=fopen(THISMONTHFILE,"rt")))
	{	fgets(buffer,80,fp);
		fclose(fp);
		if (strncmp(szMonth,buffer,7)!=0)
		{	/* we start logging, but for some reasons the monthfile is not of this month,
					thus some recovery required */
			if ((fp=fopen(MONTHLYLOG,"at")) )
			{	fprintf(fp,"%s\n",buffer);
				fclose(fp);
			}
			if ( (fp=fopen(THISMONTHFILE,"wt")))
			{	fprintf(fp,"%s %14.0f %14.0f",szMonth,0.0,0.0);
    	 	fclose(fp);
			}
		}
	}
	else
	{	/* create a monthcounter */
		if ( (fp=fopen(THISMONTHFILE,"wt")))
		{	fprintf(fp,"%s %14.0f %14.0f",szMonth,0.0,0.0);
     	fclose(fp);
		}
	}
	/* create a marker file */
	fp = fopen(MARKERFILE,"wt");
	if (fp)
	{	fprintf(fp,"%14.0f %14.0f",0.0,0.0);
		fclose(fp);
	}
	fprintf(stdout,"ADSL4Linux logging started:\n");
	return 0;

}


int statuslogging()
{	
  /* at first check if logging is enabled and that the logging belongs to current connection */
	FILE	*fp;
	char	buffer[256],buffer2[256];
	char	szToday[80], *ptr, szMonth[80];
	double recToday = 0.0;
	double sendToday = 0.0;
	double recPrevToday = 0.0;
	double sendPrevToday = 0.0;
	double	diffRec = 0.0;
	double	diffSent = 0.0;
	double	recMonth = 0.0;
	double	sentMonth = 0.0;
	double	markRec = 0.0;
	double	markSent = 0.0;
	int	duration,days,hours,minutes,seconds, totalhours;
	
	strftime((char *) &buffer2, 100, "%Y-%m-%d %H:%M:%S", localtime(&st.st_ctime));
	fp = fopen(CURRSESSFILE,"rt");
  if (fp)
	{	fgets(buffer,80,fp);
		fclose(fp);
		if (strncmp(buffer,buffer2,19)!=0)
		{	fprintf(stderr,"ADSL4Linux logging for old connection still active\n");
			return 0;
		}
  }
	else
	{	fprintf(stderr,"\nADSL4Linux logging is not started!\n");
		return 0;
	}

	/* show all types of information */
	fprintf(stdout,"\n-- ADSL4Linux %s STATUS --\n\n",VERSION);

	duration = tmNow - st.st_ctime;
	seconds = duration % 60;
	duration = duration / 60;
	minutes = duration % 60;
	totalhours = duration / 60;
	duration = duration / 60;
	hours = duration % 24;
	days = duration /24;

	/* get data from markerfile */
	if ((fp = fopen(MARKERFILE,"rt")))
	{	fgets(buffer,80,fp);
		markRec = strtod(buffer, (char **) &ptr);
		markSent = strtod(ptr, (char **) &ptr);
		fclose(fp);
		markSent = sent - markSent;
		markRec = received - markRec;
	}
  else
	{	markRec = received;
		markSent = sent;
  }
	if (uid==0 && ( fp=fopen(MARKERFILE,"wt")))
	{	fprintf(fp,"%14.0f %14.0f",received,sent);
		fclose(fp);
	}
		
	fprintf(stdout,"Session started %s\nUptime is %d days, %d Hours %d minutes, %d seconds (or %d hours)\n",buffer2,days,hours,minutes,seconds,totalhours);
	fprintf(stdout,"Bytes received %s (+%s)\n",showAmount(received,szMonth), showAmount(markRec,buffer));
	fprintf(stdout,"Bytes sent     %s (+%s)\n",showAmount(sent,szMonth), showAmount(markSent,buffer));
	fprintf(stdout,"Total          %s (+%s)\n",showAmount(received+sent,szMonth), showAmount(markSent+markRec,buffer));

	/* Get todays info and display it */
	memset(szToday,0,80);
	strftime((char *) &szToday, 79, "%Y-%m-%d", localtime(&tmNow));
	if ( (fp = fopen(TODAYFILE,"rt")))
  {	fgets(buffer,80,fp);
		fclose(fp);
		strncpy(szToday,buffer,10);
		ptr = strchr(buffer,' ');
		recToday = strtod(ptr, (char **) &ptr);
		sendToday = strtod(ptr, (char **) &ptr);
		recPrevToday = strtod(ptr, (char **) &ptr);
		sendPrevToday = strtod(ptr, (char **) &ptr);
  }
	diffRec = received - recPrevToday;
	diffSent = sent - sendPrevToday;
	if ( diffRec < 0.0) diffRec += FOURGB;
	if ( diffSent < 0.0) diffSent += FOURGB;

	fprintf(stdout,"\nStatus for today %s\n",szToday);
	fprintf(stdout,"Bytes received %s\n",showAmount(recToday+diffRec,szMonth));
	fprintf(stdout,"Bytes sent     %s\n",showAmount(sendToday+diffSent,szMonth));
	fprintf(stdout,"Total          %s\n",showAmount(recToday+sendToday+diffRec+diffSent,szMonth));

	/* Get info from this month */
	memset(szMonth,0,80);
	strftime((char *) &szMonth, 79, "%Y-%m", localtime(&tmNow));
	if ( (fp = fopen(THISMONTHFILE,"rt")))
  {	fgets(buffer,80,fp);
		fclose(fp);
		strncpy(szMonth,buffer,7);
		ptr = strchr(buffer,' ');
		recMonth = strtod(ptr, (char **) &ptr);
		sentMonth = strtod(ptr, (char **) &ptr);
  }
	fprintf(stdout,"\nStatus for month %s\n",szMonth);
	fprintf(stdout,"Bytes received %s\n",showAmount(recMonth+diffRec,szMonth));
	fprintf(stdout,"Bytes sent     %s\n",showAmount(sentMonth+diffSent,szMonth));
	fprintf(stdout,"Total          %s\n",showAmount(recMonth+sentMonth+diffRec+diffSent,szMonth));

	return 0;
}

char* showAmount(double d,char *str)
{
double	 t;

	if (d<1024.0)
	{	sprintf(str,"%.0f Bytes",	d);
		return str;
	}
	t = d / 1024.0;
	if (t<1024.0)
	{	sprintf(str,"%.3f Kb",	t);
		return str;
	}
	t = t / 1024.0;
	if (t<1024.0)
	{	sprintf(str,"%.3f Mb",	t);
		return str;
	}
	t = t / 1024.0;
	sprintf(str,"%.3f Gb",	t);
	return str;
}

int usagelogging()
{
  /* at first check if logging is enabled and that the logging belongs to current connection */
	FILE	*fp;
	char	buffer[256],buffer2[256];
	char	szToday[80], *ptr, szMonth[80], szCurrent[128];
	double recToday = 0.0;
	double sendToday = 0.0;
	double recPrevToday = 0.0;
	double sendPrevToday = 0.0;
	double	diffRec = 0.0;
	double	diffSent = 0.0;
	double	recMonth = 0.0;
	double	sentMonth = 0.0;
	
	strftime((char *) &buffer2, 100, "%Y-%m-%d %H:%M:%S", localtime(&st.st_ctime));
	fp = fopen(CURRSESSFILE,"rt");
  if (fp)
	{	fgets(szCurrent,80,fp);
		fclose(fp);
		if (strncmp(szCurrent,buffer2,19)!=0)
			return 0;		// old connection log
  }
	else
		return 0;			// logging not running

	/* Get todays info */
	memset(szToday,0,80);
	strftime((char *) &buffer2, 79, "%Y-%m-%d", localtime(&tmNow));
	if ( (fp = fopen(TODAYFILE,"rt")))
  {	fgets(szToday,80,fp);
		fclose(fp);
		ptr = strchr(szToday,' ');
		recToday = strtod(ptr, (char **) &ptr);
		sendToday = strtod(ptr, (char **) &ptr);
		recPrevToday = strtod(ptr, (char **) &ptr);
		sendPrevToday = strtod(ptr, (char **) &ptr);
  }
	diffRec = received - recPrevToday;
	diffSent = sent - sendPrevToday;
	if ( diffRec < 0.0) diffRec += FOURGB;
	if ( diffSent < 0.0) diffSent += FOURGB;

	/* Get info from this month */
	memset(szMonth,0,80);
	strftime((char *) &buffer2, 79, "%Y-%m", localtime(&tmNow));
	if ( (fp = fopen(THISMONTHFILE,"rt")))
  {	fgets(szMonth,80,fp);
		fclose(fp);
		ptr = strchr(szMonth,' ');
		recMonth = strtod(ptr, (char **) &ptr);
		sentMonth = strtod(ptr, (char **) &ptr);
  }

	/* update the current session */
	fp = fopen(CURRSESSFILE,"wt");
	if (fp)
	{	memset(buffer,0,80);
		strftime((char *) &buffer2, 100, "%Y-%m-%d %H:%M:%S", localtime(&tmNow));
		strncpy(buffer,szCurrent,19);
 		fprintf(fp,"%s %s %14.0f %14.0f",buffer,buffer2,received,sent);
		fclose(fp);
	}

	/* update daily counters */
	strftime((char *) &buffer2, 79, "%Y-%m-%d", localtime(&tmNow));
	if (strncmp(szToday,buffer2,10)!=0)
	{	/* add daycount to dailylog and reset for new day */
		memset(buffer,0,80);
		strncpy(buffer,szToday,10);
		if ( (fp=fopen(DAILYLOG,"at") ))
		{	fprintf(fp,"%s %14.0f %14.0f\n",buffer,diffRec+recToday,diffSent+sendToday);
			fclose(fp);
		}
		sendToday=-diffSent;
		recToday=-diffRec;
	}
	if ( (fp = fopen(TODAYFILE,"wt")))
	{	fprintf(fp,"%s %14.0f %14.0f %14.0f %14.0f",buffer2,diffRec+recToday,diffSent+sendToday,received,sent);
		fclose(fp);
  }

  /* update monthly counters */
	strftime((char *) &buffer2, 79, "%Y-%m", localtime(&tmNow));
	if (strncmp(szMonth,buffer2,7)!=0)
	{	memset(buffer,0,80);
		strncpy(buffer,szMonth,7);
		if ( (fp=fopen(MONTHLYLOG,"at")) )
		{	fprintf(fp,"%s %14.0f %14.0f\n",buffer,diffRec+recMonth,sentMonth+diffSent);
			fclose(fp);
		}
		recMonth=-diffRec;
		sentMonth=-diffSent;
	}
	if ( (fp = fopen(THISMONTHFILE,"wt")))
  {	fprintf(fp,"%s %14.0f %14.0f",buffer2,recMonth+diffRec,sentMonth+diffSent);
		fclose(fp);
  }

	return 0;
}

int stoplogging()
{
FILE *fp;
char	buffer[100];

	/* update all counters */
	usagelogging();
	statuslogging();
	fp = fopen(CURRSESSFILE,"rt");
  if (fp)
	{	fgets(buffer,80,fp);
		fclose(fp);
		fp = fopen(SESSIONLOG,"at");
		if (fp)
		{	fprintf(fp,"%s\n",buffer);
			fclose(fp);
		}
	}
	unlink(CURRSESSFILE);
	unlink(MARKERFILE);
	return 0;
}
