"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusCheckParamsType = exports.StatusCheckFiltersType = exports.RangeUnitType = exports.MonitorAvailabilityType = exports.GetMonitorAvailabilityParamsType = exports.AtomicStatusCheckParamsType = void 0;

var t = _interopRequireWildcard(require("io-ts"));

function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function (nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}

function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }

  if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
    return {
      default: obj
    };
  }

  var cache = _getRequireWildcardCache(nodeInterop);

  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }

  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }

  newObj.default = obj;

  if (cache) {
    cache.set(obj, newObj);
  }

  return newObj;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const StatusCheckFiltersType = t.type({
  'monitor.type': t.array(t.string),
  'observer.geo.name': t.array(t.string),
  tags: t.array(t.string),
  'url.port': t.array(t.string)
});
exports.StatusCheckFiltersType = StatusCheckFiltersType;
const AtomicStatusCheckParamsType = t.intersection([t.type({
  numTimes: t.number,
  timerangeCount: t.number,
  timerangeUnit: t.string
}), t.partial({
  search: t.string,
  filters: StatusCheckFiltersType,
  shouldCheckStatus: t.boolean,
  isAutoGenerated: t.boolean,
  shouldCheckAvailability: t.boolean
})]);
exports.AtomicStatusCheckParamsType = AtomicStatusCheckParamsType;
const StatusCheckParamsType = t.intersection([t.partial({
  filters: t.string,
  shouldCheckStatus: t.boolean,
  isAutoGenerated: t.boolean
}), t.type({
  locations: t.array(t.string),
  numTimes: t.number,
  timerange: t.type({
    from: t.string,
    to: t.string
  })
})]);
exports.StatusCheckParamsType = StatusCheckParamsType;
const RangeUnitType = t.union([t.literal('s', 'Second'), t.literal('m', 'Minute'), t.literal('h', 'Hour'), t.literal('d', 'Day'), t.literal('w', 'Week'), t.literal('M', 'Month'), t.literal('y', 'Year')]);
exports.RangeUnitType = RangeUnitType;
const GetMonitorAvailabilityParamsType = t.intersection([t.type({
  range: t.number,
  rangeUnit: RangeUnitType,
  threshold: t.string
}), t.partial({
  filters: t.string
})]);
exports.GetMonitorAvailabilityParamsType = GetMonitorAvailabilityParamsType;
const MonitorAvailabilityType = t.intersection([t.type({
  availability: GetMonitorAvailabilityParamsType,
  shouldCheckAvailability: t.boolean
}), t.partial({
  filters: StatusCheckFiltersType,
  search: t.string
})]);
exports.MonitorAvailabilityType = MonitorAvailabilityType;