/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.infra_bundle_jsonpfunction=window.infra_bundle_jsonpfunction||[]).push([[2],{115:function(e,i,t){"use strict";t.d(i,"a",(function(){return m}));var s=t(0),a=t(88),r=t(98);const n=s.type({field:s.string,from:s.number,to:s.number,interval:s.string}),d=s.union([s.string,s.null,s[void 0]]),o=s.type({id:s.string,aggregations:a.d}),l=(s.intersection([s.type({timerange:n,indexPattern:s.string,metrics:s.array(o)}),s.partial({groupBy:s.array(d),modules:s.array(s.string),afterKey:s.union([s.null,r.b]),limit:s.union([s.number,s.null,s[void 0]]),filters:s.array(s.object),dropPartialBuckets:s.boolean,alignDataToEnd:s.boolean})]),s.type({afterKey:s.union([s.null,r.b,s[void 0]]),interval:s.number})),c=s.keyof({date:null,number:null,string:null}),u=s.type({name:s.string,type:c}),p=s.intersection([s.type({timestamp:s.number}),s.record(s.string,s.union([s.string,s.number,s.null,s[void 0],s.array(s.object)]))]),m=s.intersection([s.type({id:s.string,columns:s.array(u),rows:s.array(p)}),s.partial({keys:s.array(s.string)})]);s.type({series:s.array(s.intersection([m,s.partial({metricsets:s.array(s.string)})])),info:l})},117:function(e,i,t){"use strict";t.d(i,"a",(function(){return r}));var s=t(3),a=t(67);function r(){const[e]=Object(s.useUiSetting$)(a.UI_SETTINGS.DATEFORMAT_TZ);return e&&"Browser"!==e?e:"local"}},139:function(e,i,t){"use strict";t.d(i,"a",(function(){return s}));const s=(e,i,t)=>({[`${e}_interfaces`]:{terms:{field:t},aggregations:{[`${e}_interface_max`]:{max:{field:i}}}},[`${e}_sum_of_interfaces`]:{sum_bucket:{buckets_path:`${e}_interfaces>${e}_interface_max`}},[`${e}_deriv`]:{derivative:{buckets_path:`${e}_sum_of_interfaces`,gap_policy:"skip",unit:"1s"}},[e]:{bucket_script:{buckets_path:{value:`${e}_deriv[normalized_value]`},script:{source:"params.value > 0.0 ? params.value : 0.0",lang:"painless"},gap_policy:"skip"}}})},179:function(e,i,t){"use strict";t.d(i,"a",(function(){return u}));var s=t(225);const a={nginxActiveConnections:(e,i,t)=>({id:"nginxActiveConnections",requires:["nginx.stubstatus"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"connections",metrics:[{field:"nginx.stubstatus.active",id:"avg-active",type:"avg"}],split_mode:"everything"}]}),nginxHits:(e,i,t)=>({id:"nginxHits",requires:["nginx.access"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"200s",metrics:[{id:"count-200",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[200 TO 299]",language:"lucene"}},{id:"300s",metrics:[{id:"count-300",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[300 TO 399]",language:"lucene"}},{id:"400s",metrics:[{id:"count-400",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[400 TO 499]",language:"lucene"}},{id:"500s",metrics:[{id:"count-500",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[500 TO 599]",language:"lucene"}}]}),nginxRequestRate:(e,i,t)=>({id:"nginxRequestRate",requires:["nginx.stubstatus"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"rate",metrics:[{field:"nginx.stubstatus.requests",id:"max-requests",type:"max"},{field:"max-requests",id:"derv-max-requests",type:"derivative",unit:"1s"},{id:"posonly-derv-max-requests",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"derv-max-requests"}],script:"params.rate > 0.0 ? params.rate : 0.0"}],split_mode:"everything"}]}),nginxRequestsPerConnection:(e,i,t)=>({id:"nginxRequestsPerConnection",requires:["nginx.stubstatus"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"reqPerConns",metrics:[{field:"nginx.stubstatus.handled",id:"max-handled",type:"max"},{field:"nginx.stubstatus.requests",id:"max-requests",type:"max"},{id:"reqs-per-connection",type:"calculation",variables:[{id:"var-handled",name:"handled",field:"max-handled"},{id:"var-requests",name:"requests",field:"max-requests"}],script:"params.handled > 0.0 && params.requests > 0.0 ? params.handled / params.requests : 0.0"}],split_mode:"everything"}]}),awsCpuUtilization:(e,i)=>({id:"awsCpuUtilization",requires:["aws.ec2"],map_field_to:"cloud.instance.id",id_type:"cloud",index_pattern:i,interval:">=5m",time_field:e,type:"timeseries",series:[{id:"cpu-util",metrics:[{field:"aws.ec2.cpu.total.pct",id:"avg-cpu-util",type:"avg"}],split_mode:"everything"}]}),awsDiskioBytes:(e,i)=>({id:"awsDiskioBytes",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"writes",metrics:[{field:"aws.ec2.diskio.write.bytes",id:"sum-diskio-out",type:"sum"},{id:"csum-sum-diskio-out",field:"sum-diskio-out",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-out",unit:"1s",type:"derivative",field:"csum-sum-diskio-out"},{id:"posonly-deriv-csum-sum-diskio-out",field:"deriv-csum-sum-diskio-out",type:"positive_only"}],split_mode:"everything"},{id:"reads",metrics:[{field:"aws.ec2.diskio.read.bytes",id:"sum-diskio-in",type:"sum"},{id:"csum-sum-diskio-in",field:"sum-diskio-in",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-in",unit:"1s",type:"derivative",field:"csum-sum-diskio-in"},{id:"posonly-deriv-csum-sum-diskio-in",field:"deriv-csum-sum-diskio-in",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-diskio-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-diskio-in"}],script:"params.rate * -1"}],split_mode:"everything"}]}),awsDiskioOps:(e,i)=>({id:"awsDiskioOps",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"writes",metrics:[{field:"aws.ec2.diskio.write.count",id:"sum-diskio-writes",type:"sum"},{id:"csum-sum-diskio-writes",field:"sum-diskio-writes",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-writes",unit:"1s",type:"derivative",field:"csum-sum-diskio-writes"},{id:"posonly-deriv-csum-sum-diskio-writes",field:"deriv-csum-sum-diskio-writes",type:"positive_only"}],split_mode:"everything"},{id:"reads",metrics:[{field:"aws.ec2.diskio.read.count",id:"sum-diskio-reads",type:"sum"},{id:"csum-sum-diskio-reads",field:"sum-diskio-reads",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-reads",unit:"1s",type:"derivative",field:"csum-sum-diskio-reads"},{id:"posonly-deriv-csum-sum-diskio-reads",field:"deriv-csum-sum-diskio-reads",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-diskio-reads",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-diskio-reads"}],script:"params.rate * -1"}],split_mode:"everything"}]}),awsNetworkBytes:(e,i)=>({id:"awsNetworkBytes",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"tx",metrics:[{field:"aws.ec2.network.out.bytes",id:"sum-net-out",type:"sum"},{id:"csum-sum-net-out",field:"sum-net-out",type:"cumulative_sum"},{id:"deriv-csum-sum-net-out",unit:"1s",type:"derivative",field:"csum-sum-net-out"},{id:"posonly-deriv-csum-sum-net-out",field:"deriv-csum-sum-net-out",type:"positive_only"}],split_mode:"everything"},{id:"rx",metrics:[{field:"aws.ec2.network.in.bytes",id:"sum-net-in",type:"sum"},{id:"csum-sum-net-in",field:"sum-net-in",type:"cumulative_sum"},{id:"deriv-csum-sum-net-in",unit:"1s",type:"derivative",field:"csum-sum-net-in"},{id:"posonly-deriv-csum-sum-net-in",field:"deriv-csum-sum-net-in",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-net-in"}],script:"params.rate * -1"}],split_mode:"everything"}]}),awsNetworkPackets:(e,i)=>({id:"awsNetworkPackets",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"timeseries",series:[{id:"packets-out",metrics:[{field:"aws.ec2.network.out.packets",id:"avg-net-out",type:"avg"}],split_mode:"everything"},{id:"packets-in",metrics:[{field:"aws.ec2.network.in.packets",id:"avg-net-in",type:"avg"},{id:"inverted-avg-net-in",type:"calculation",variables:[{id:"var-avg",name:"avg",field:"avg-net-in"}],script:"params.avg * -1"}],split_mode:"everything"}]}),awsOverview:(e,i)=>({id:"awsOverview",requires:["aws.ec2"],index_pattern:i,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:e,type:"top_n",series:[{id:"cpu-util",split_mode:"everything",metrics:[{field:"aws.ec2.cpu.total.pct",id:"cpu-total-pct",type:"max"}]},{id:"status-check-failed",split_mode:"everything",metrics:[{field:"aws.ec2.status.check_failed",id:"status-check-failed",type:"max"}]},{id:"packets-out",split_mode:"everything",metrics:[{field:"aws.ec2.network.out.packets",id:"network-out-packets",type:"avg"}]},{id:"packets-in",split_mode:"everything",metrics:[{field:"aws.ec2.network.in.packets",id:"network-in-packets",type:"avg"}]}]})};t(197).a;var r=t(227),n=t(226),d=t(231),o=t(228),l=t(229),c=t(230);const u={tsvb:{...s.a.tsvb,...a,...r.a.tsvb,...n.a.tsvb,...d.a.tsvb,...o.a.tsvb,...l.a.tsvb,...c.a.tsvb}}},197:function(e,i,t){"use strict";t.d(i,"a",(function(){return s}));const s={count:{bucket_script:{buckets_path:{count:"_count"},script:{source:"count * 1",lang:"expression"},gap_policy:"skip"}}}},225:function(e,i,t){"use strict";t.d(i,"a",(function(){return d}));var s=t(197);var a=t(139);const r=Object(a.a)("rx","system.network.in.bytes","system.network.name"),n=Object(a.a)("tx","system.network.out.bytes","system.network.name"),d={tsvb:{hostSystemOverview:(e,i,t)=>({id:"hostSystemOverview",requires:["system.cpu","system.memory","system.load","system.network"],index_pattern:i,interval:t,time_field:e,type:"top_n",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"system.cpu.total.norm.pct",id:"avg-cpu-total",type:"avg"}]},{id:"load",split_mode:"everything",metrics:[{field:"system.load.5",id:"avg-load-5m",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"system.memory.actual.used.pct",id:"avg-memory-actual-used",type:"avg"}]},{id:"rx",split_mode:"terms",terms_field:"system.network.name",metrics:[{field:"system.network.in.bytes",id:"max-net-in",type:"max"},{field:"max-net-in",id:"deriv-max-net-in",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-in"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}]},{id:"tx",split_mode:"terms",terms_field:"system.network.name",metrics:[{field:"system.network.out.bytes",id:"max-net-out",type:"max"},{field:"max-net-out",id:"deriv-max-net-out",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-out",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-out"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}]}]}),hostCpuUsage:(e,i,t)=>({id:"hostCpuUsage",requires:["system.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"user",metrics:[{field:"system.cpu.user.pct",id:"avg-cpu-user",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-user",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"system",metrics:[{field:"system.cpu.system.pct",id:"avg-cpu-system",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-system",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"steal",metrics:[{field:"system.cpu.steal.pct",id:"avg-cpu-steal",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"avg-cpu-steal",id:"var-avg",name:"avg"},{field:"max-cpu-cores",id:"var-cores",name:"cores"}]}],split_mode:"everything"},{id:"irq",metrics:[{field:"system.cpu.irq.pct",id:"avg-cpu-irq",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-irq",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"softirq",metrics:[{field:"system.cpu.softirq.pct",id:"avg-cpu-softirq",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-softirq",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"iowait",metrics:[{field:"system.cpu.iowait.pct",id:"avg-cpu-iowait",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-iowait",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"nice",metrics:[{field:"system.cpu.nice.pct",id:"avg-cpu-nice",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-nice",id:"var-avg",name:"avg"}]}],split_mode:"everything"}]}),hostLoad:(e,i,t)=>({id:"hostLoad",requires:["system.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"load_1m",metrics:[{field:"system.load.1",id:"avg-load-1m",type:"avg"}],split_mode:"everything"},{id:"load_5m",metrics:[{field:"system.load.5",id:"avg-load-5m",type:"avg"}],split_mode:"everything"},{id:"load_15m",metrics:[{field:"system.load.15",id:"avg-load-15m",type:"avg"}],split_mode:"everything"}]}),hostMemoryUsage:(e,i,t)=>({id:"hostMemoryUsage",requires:["system.memory"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"free",metrics:[{field:"system.memory.free",id:"avg-memory-free",type:"avg"}],split_mode:"everything"},{id:"used",metrics:[{field:"system.memory.actual.used.bytes",id:"avg-memory-used",type:"avg"}],split_mode:"everything"},{id:"cache",metrics:[{field:"system.memory.actual.used.bytes",id:"avg-memory-actual-used",type:"avg"},{field:"system.memory.used.bytes",id:"avg-memory-used",type:"avg"},{id:"calc-used-actual",script:"params.used - params.actual",type:"calculation",variables:[{field:"avg-memory-actual-used",id:"var-actual",name:"actual"},{field:"avg-memory-used",id:"var-used",name:"used"}]}],split_mode:"everything"}]}),hostNetworkTraffic:(e,i,t)=>({id:"hostNetworkTraffic",requires:["system.network"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"tx",metrics:[{field:"system.network.out.bytes",id:"max-net-out",type:"max"},{field:"max-net-out",id:"deriv-max-net-out",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-out",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-out"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"system.network.name"},{id:"rx",metrics:[{field:"system.network.in.bytes",id:"max-net-in",type:"max"},{field:"max-net-in",id:"deriv-max-net-in",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-in"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-net-in",id:"var-rate",name:"rate"}]},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"system.network.name"}]}),hostFilesystem:(e,i,t)=>({id:"hostFilesystem",requires:["system.filesystem"],filter:"system.filesystem.device_name:\\/*",index_pattern:i,time_field:e,interval:t,type:"timeseries",series:[{id:"used",metrics:[{field:"system.filesystem.used.pct",id:"avg-filesystem-used",type:"avg"}],split_mode:"terms",terms_field:"system.filesystem.device_name",terms_order_by:"used",terms_size:5}]}),hostK8sOverview:(e,i,t)=>({id:"hostK8sOverview",requires:["kubernetes"],index_pattern:i,interval:t,time_field:e,type:"top_n",series:[{id:"cpucap",split_mode:"everything",metrics:[{field:"kubernetes.node.cpu.allocatable.cores",id:"max-cpu-cap",type:"max"},{field:"kubernetes.node.cpu.usage.nanocores",id:"avg-cpu-usage",type:"avg"},{id:"calc-used-cap",script:"params.used / (params.cap * 1000000000)",type:"calculation",variables:[{field:"max-cpu-cap",id:"var-cap",name:"cap"},{field:"avg-cpu-usage",id:"var-used",name:"used"}]}]},{id:"diskcap",metrics:[{field:"kubernetes.node.fs.capacity.bytes",id:"max-fs-cap",type:"max"},{field:"kubernetes.node.fs.used.bytes",id:"avg-fs-used",type:"avg"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-fs-cap",id:"var-cap",name:"cap"},{field:"avg-fs-used",id:"var-used",name:"used"}]}],split_mode:"everything"},{id:"memorycap",metrics:[{field:"kubernetes.node.memory.allocatable.bytes",id:"max-memory-cap",type:"max"},{field:"kubernetes.node.memory.usage.bytes",id:"avg-memory-usage",type:"avg"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-memory-cap",id:"var-cap",name:"cap"},{field:"avg-memory-usage",id:"var-used",name:"used"}]}],split_mode:"everything"},{id:"podcap",metrics:[{field:"kubernetes.node.pod.capacity.total",id:"max-pod-cap",type:"max"},{field:"kubernetes.pod.uid",id:"card-pod-name",type:"cardinality"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-pod-cap",id:"var-cap",name:"cap"},{field:"card-pod-name",id:"var-used",name:"used"}]}],split_mode:"everything"}]}),hostK8sCpuCap:(e,i,t)=>({id:"hostK8sCpuCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.cpu.allocatable.cores",id:"max-cpu-cap",type:"max"},{id:"calc-nanocores",type:"calculation",variables:[{id:"var-cores",field:"max-cpu-cap",name:"cores"}],script:"params.cores * 1000000000"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.cpu.usage.nanocores",id:"avg-cpu-usage",type:"avg"}],split_mode:"everything"}]}),hostK8sPodCap:(e,i,t)=>({id:"hostK8sPodCap",requires:["kubernetes.node"],map_field_to:"kubernetes.node.name",index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.pod.allocatable.total",id:"max-pod-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.pod.uid",id:"avg-pod",type:"cardinality"}],split_mode:"everything"}]}),hostK8sDiskCap:(e,i,t)=>({id:"hostK8sDiskCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.fs.capacity.bytes",id:"max-fs-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.fs.used.bytes",id:"avg-fs-used",type:"avg"}],split_mode:"everything"}]}),hostK8sMemoryCap:(e,i,t)=>({id:"hostK8sMemoryCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.memory.allocatable.bytes",id:"max-memory-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.memory.usage.bytes",id:"avg-memory-usage",type:"avg"}],split_mode:"everything"}]}),hostDockerOverview:(e,i,t)=>({id:"hostDockerOverview",requires:["docker.info"],index_pattern:i,interval:t,time_field:e,type:"top_n",series:[{id:"total",metrics:[{field:"docker.info.containers.total",id:"max-total",type:"max"}],split_mode:"everything"},{id:"running",metrics:[{field:"docker.info.containers.running",id:"max-running",type:"max"}],split_mode:"everything"},{id:"paused",metrics:[{field:"docker.info.containers.paused",id:"max-paused",type:"max"}],split_mode:"everything"},{id:"stopped",metrics:[{field:"docker.info.containers.stopped",id:"max-stopped",type:"max"}],split_mode:"everything"}]}),hostDockerInfo:(e,i,t)=>({id:"hostDockerInfo",requires:["docker.info"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"running",metrics:[{field:"docker.info.containers.running",id:"max-running",type:"max"}],split_mode:"everything"},{id:"paused",metrics:[{field:"docker.info.containers.paused",id:"max-paused",type:"max"}],split_mode:"everything"},{id:"stopped",metrics:[{field:"docker.info.containers.stopped",id:"max-stopped",type:"max"}],split_mode:"everything"}]}),hostDockerTop5ByMemory:(e,i,t)=>({id:"hostDockerTop5ByMemory",requires:["docker.memory"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"avg-memory",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory-metric",type:"avg"}],split_mode:"terms",terms_field:"container.name",terms_order_by:"avg-memory",terms_size:5}]}),hostDockerTop5ByCpu:(e,i,t)=>({id:"hostDockerTop5ByCpu",requires:["docker.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"avg-cpu",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-metric",type:"avg"}],split_mode:"terms",terms_field:"container.name",terms_order_by:"avg-cpu",terms_size:5}]})},snapshot:{count:s.a,cpu:{cpu_user:{avg:{field:"system.cpu.user.pct"}},cpu_system:{avg:{field:"system.cpu.system.pct"}},cpu_cores:{max:{field:"system.cpu.cores"}},cpu:{bucket_script:{buckets_path:{user:"cpu_user",system:"cpu_system",cores:"cpu_cores"},script:{source:"(params.user + params.system) / params.cores",lang:"painless"},gap_policy:"skip"}}},load:{load:{avg:{field:"system.load.5"}}},logRate:{count:{bucket_script:{buckets_path:{count:"_count"},script:{source:"count * 1",lang:"expression"},gap_policy:"skip"}},cumsum:{cumulative_sum:{buckets_path:"count"}},logRate:{derivative:{buckets_path:"cumsum",gap_policy:"skip",unit:"1s"}}},memory:{memory:{avg:{field:"system.memory.actual.used.pct"}}},rx:r,tx:n},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},226:function(e,i,t){"use strict";t.d(i,"a",(function(){return a}));var s=t(139);const a={tsvb:{containerOverview:(e,i,t)=>({id:"containerOverview",requires:["docker"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-total",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory",type:"avg"}]},{id:"tx",split_mode:"everything",metrics:[{field:"docker.network.out.bytes",id:"avg-network-out",type:"avg"}]},{id:"rx",split_mode:"everything",metrics:[{field:"docker.network.in.bytes",id:"avg-network-in",type:"avg"}]}]}),containerCpuUsage:(e,i,t)=>({id:"containerCpuUsage",requires:["docker.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-total",type:"avg"}]}]}),containerCpuKernel:(e,i,t)=>({id:"containerCpuKernel",requires:["docker.cpu"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"kernel",split_mode:"everything",metrics:[{field:"docker.cpu.kernel.pct",id:"avg-cpu-kernel",type:"avg"}]}]}),containerDiskIOOps:(e,i,t)=>({id:"containerDiskIOOps",requires:["docker.disk"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"read",split_mode:"everything",metrics:[{field:"docker.diskio.read.ops",id:"max-diskio-read-ops",type:"max"},{field:"max-diskio-read-ops",id:"deriv-max-diskio-read-ops",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-read-ops",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-read-ops"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"write",split_mode:"everything",metrics:[{field:"docker.diskio.write.ops",id:"max-diskio-write-ops",type:"max"},{field:"max-diskio-write-ops",id:"deriv-max-diskio-write-ops",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-write-ops",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-write-ops"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-diskio-write-ops",id:"var-rate",name:"rate"}]}]}]}),containerDiskIOBytes:(e,i,t)=>({id:"containerDiskIOBytes",requires:["docker.disk"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"read",split_mode:"everything",metrics:[{field:"docker.diskio.read.bytes",id:"max-diskio-read-bytes",type:"max"},{field:"max-diskio-read-bytes",id:"deriv-max-diskio-read-bytes",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-read-bytes",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-read-bytes"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"write",split_mode:"everything",metrics:[{field:"docker.diskio.write.bytes",id:"max-diskio-write-bytes",type:"max"},{field:"max-diskio-write-bytes",id:"deriv-max-diskio-write-bytes",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-write-bytes",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-write-bytes"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-diskio-write-bytes",id:"var-rate",name:"rate"}]}]}]}),containerNetworkTraffic:(e,i,t)=>({id:"containerNetworkTraffic",requires:["docker.network"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"tx",metrics:[{field:"docker.network.outbound.bytes",id:"max-net-out",type:"max"},{field:"max-net-out",id:"deriv-max-net-out",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-out",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-out"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"docker.network.interface"},{id:"rx",metrics:[{field:"docker.network.inbound.bytes",id:"max-net-in",type:"max"},{field:"max-net-in",id:"deriv-max-net-in",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-in"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-net-in",id:"var-rate",name:"rate"}]},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"docker.network.interface"}]}),containerMemory:(e,i,t)=>({id:"containerMemory",requires:["docker.memory"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"memory",split_mode:"everything",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory",type:"avg"}]}]})},snapshot:{cpu:{cpu:{avg:{field:"docker.cpu.total.pct"}}},memory:{memory:{avg:{field:"docker.memory.usage.pct"}}},rx:Object(s.a)("rx","docker.network.inbound.bytes","docker.network.interface"),tx:Object(s.a)("tx","docker.network.outbound.bytes","docker.network.interface")},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},227:function(e,i,t){"use strict";t.d(i,"a",(function(){return a}));const s=(e,i)=>({[`${e}_max`]:{max:{field:i}},[`${e}_deriv`]:{derivative:{buckets_path:`${e}_max`,gap_policy:"skip",unit:"1s"}},[e]:{bucket_script:{buckets_path:{value:`${e}_deriv[normalized_value]`},script:{source:"params.value > 0.0 ? params.value : 0.0",lang:"painless"},gap_policy:"skip"}}}),a={tsvb:{podOverview:(e,i,t)=>({id:"podOverview",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.pod.cpu.usage.node.pct",id:"avg-cpu-without",type:"avg"},{field:"kubernetes.pod.cpu.usage.limit.pct",id:"avg-cpu-with",type:"avg"},{id:"cpu-usage",type:"calculation",variables:[{id:"cpu_with",name:"with_limit",field:"avg-cpu-with"},{id:"cpu_without",name:"without_limit",field:"avg-cpu-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]},{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.pod.memory.usage.node.pct",id:"avg-memory-without",type:"avg"},{field:"kubernetes.pod.memory.usage.limit.pct",id:"avg-memory-with",type:"avg"},{id:"memory-usage",type:"calculation",variables:[{id:"memory_with",name:"with_limit",field:"avg-memory-with"},{id:"memory_without",name:"without_limit",field:"avg-memory-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]},{id:"rx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.rx.bytes",id:"max-network-rx",type:"max"},{field:"max-network-rx",id:"deriv-max-network-rx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-network-rx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-rx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"tx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.tx.bytes",id:"max-network-tx",type:"max"},{field:"max-network-tx",id:"deriv-max-network-tx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-network-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]}]}),podCpuUsage:(e,i,t)=>({id:"podCpuUsage",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.pod.cpu.usage.node.pct",id:"avg-cpu-without",type:"avg"},{field:"kubernetes.pod.cpu.usage.limit.pct",id:"avg-cpu-with",type:"avg"},{id:"cpu-usage",type:"calculation",variables:[{id:"cpu_with",name:"with_limit",field:"avg-cpu-with"},{id:"cpu_without",name:"without_limit",field:"avg-cpu-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]}]}),podLogUsage:(e,i,t)=>({id:"podLogUsage",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"logs",split_mode:"everything",metrics:[{field:"kubernetes.container.logs.used.bytes",id:"avg-log-used",type:"avg"},{field:"kubernetes.container.logs.capacity.bytes",id:"max-log-cap",type:"max"},{id:"calc-usage-limit",script:"params.usage / params.limit",type:"calculation",variables:[{field:"avg-log-userd",id:"var-usage",name:"usage"},{field:"max-log-cap",id:"var-limit",name:"limit"}]}]}]}),podNetworkTraffic:(e,i,t)=>({id:"podNetworkTraffic",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"tx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.tx.bytes",id:"max-network-tx",type:"max"},{field:"max-network-tx",id:"deriv-max-network-tx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"rx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.rx.bytes",id:"max-network-rx",type:"max"},{field:"max-network-rx",id:"deriv-max-network-rx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"invert-posonly-deriv-max-network-rx",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-network-rx",id:"var-rate",name:"rate"}]}]}]}),podMemoryUsage:(e,i,t)=>({id:"podMemoryUsage",requires:["kubernetes.pod"],index_pattern:i,interval:t,time_field:e,type:"timeseries",series:[{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.pod.memory.usage.node.pct",id:"avg-memory-without",type:"avg"},{field:"kubernetes.pod.memory.usage.limit.pct",id:"avg-memory-with",type:"avg"},{id:"memory-usage",type:"calculation",variables:[{id:"memory_with",name:"with_limit",field:"avg-memory-with"},{id:"memory_without",name:"without_limit",field:"avg-memory-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]}]})},snapshot:{cpu:{cpu_with_limit:{avg:{field:"kubernetes.pod.cpu.usage.limit.pct"}},cpu_without_limit:{avg:{field:"kubernetes.pod.cpu.usage.node.pct"}},cpu:{bucket_script:{buckets_path:{with_limit:"cpu_with_limit",without_limit:"cpu_without_limit"},script:{source:"params.with_limit > 0.0 ? params.with_limit : params.without_limit",lang:"painless"},gap_policy:"skip"}}},memory:{memory_with_limit:{avg:{field:"kubernetes.pod.memory.usage.limit.pct"}},memory_without_limit:{avg:{field:"kubernetes.pod.memory.usage.node.pct"}},memory:{bucket_script:{buckets_path:{with_limit:"memory_with_limit",without_limit:"memory_without_limit"},script:{source:"params.with_limit > 0.0 ? params.with_limit : params.without_limit",lang:"painless"},gap_policy:"skip"}}},rx:s("rx","kubernetes.pod.network.rx.bytes"),tx:s("tx","kubernetes.pod.network.tx.bytes")},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},228:function(e,i,t){"use strict";t.d(i,"a",(function(){return a}));var s=t(87);const a={tsvb:{awsS3BucketSize:Object(s.a)("awsS3BucketSize",["aws.s3_daily_storage"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_daily_storage.bucket.size.bytes",id:"max-bytes",type:"max"}]}],">=86400s",!1),awsS3TotalRequests:Object(s.a)("awsS3TotalRequests",["aws.s3_request"],[{id:"total",split_mode:"everything",metrics:[{field:"aws.s3_request.requests.total",id:"max-size",type:"max"}]}],">=300s"),awsS3NumberOfObjects:Object(s.a)("awsS3NumberOfObjects",["aws.s3_daily_storage"],[{id:"objects",split_mode:"everything",metrics:[{field:"aws.s3_daily_storage.number_of_objects",id:"max-size",type:"max"}]}],">=86400s",!1),awsS3DownloadBytes:Object(s.a)("awsS3DownloadBytes",["aws.s3_request"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_request.downloaded.bytes",id:"max-bytes",type:"max"}]}],">=300s"),awsS3UploadBytes:Object(s.a)("awsS3UploadBytes",["aws.s3_request"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_request.uploaded.bytes",id:"max-bytes",type:"max"}]}],">=300s")},snapshot:{s3BucketSize:{s3BucketSize:{max:{field:"aws.s3_daily_storage.bucket.size.bytes"}}},s3NumberOfObjects:{s3NumberOfObjects:{max:{field:"aws.s3_daily_storage.number_of_objects"}}},s3TotalRequests:{s3TotalRequests:{max:{field:"aws.s3_request.requests.total"}}},s3UploadBytes:{s3UploadBytes:{max:{field:"aws.s3_request.uploaded.bytes"}}},s3DownloadBytes:{s3DownloadBytes:{max:{field:"aws.s3_request.downloaded.bytes"}}}},defaultSnapshot:"s3BucketSize",defaultTimeRangeInSeconds:604800}},229:function(e,i,t){"use strict";t.d(i,"a",(function(){return a}));var s=t(87);const a={tsvb:{awsRDSLatency:Object(s.a)("awsRDSLatency",["aws.rds"],[{id:"read",split_mode:"everything",metrics:[{field:"aws.rds.latency.read",id:"avg",type:"avg"}]},{id:"write",split_mode:"everything",metrics:[{field:"aws.rds.latency.write",id:"avg",type:"avg"}]},{id:"insert",split_mode:"everything",metrics:[{field:"aws.rds.latency.insert",id:"avg",type:"avg"}]},{id:"update",split_mode:"everything",metrics:[{field:"aws.rds.latency.update",id:"avg",type:"avg"}]},{id:"commit",split_mode:"everything",metrics:[{field:"aws.rds.latency.commit",id:"avg",type:"avg"}]}]),awsRDSConnections:Object(s.a)("awsRDSConnections",["aws.rds"],[{id:"connections",split_mode:"everything",metrics:[{field:"aws.rds.database_connections",id:"avg-conns",type:"avg"}]}]),awsRDSCpuTotal:Object(s.a)("awsRDSCpuTotal",["aws.rds"],[{id:"cpu",split_mode:"everything",metrics:[{field:"aws.rds.cpu.total.pct",id:"avg-cpu",type:"avg"},{id:"convert-to-percent",script:"params.avg / 100",type:"calculation",variables:[{field:"avg-cpu",id:"var-avg",name:"avg"}]}]}]),awsRDSQueriesExecuted:Object(s.a)("awsRDSQueriesExecuted",["aws.rds"],[{id:"queries",split_mode:"everything",metrics:[{field:"aws.rds.queries",id:"avg-queries",type:"avg"}]}]),awsRDSActiveTransactions:Object(s.a)("awsRDSActiveTransactions",["aws.rds"],[{id:"active",split_mode:"everything",metrics:[{field:"aws.rds.transactions.active",id:"avg",type:"avg"}]},{id:"blocked",split_mode:"everything",metrics:[{field:"aws.rds.transactions.blocked",id:"avg",type:"avg"}]}])},snapshot:{cpu:{cpu_avg:{avg:{field:"aws.rds.cpu.total.pct"}},cpu:{bucket_script:{buckets_path:{cpu:"cpu_avg"},script:{source:"params.cpu / 100",lang:"painless"},gap_policy:"skip"}}},rdsLatency:{rdsLatency:{avg:{field:"aws.rds.latency.dml"}}},rdsConnections:{rdsConnections:{avg:{field:"aws.rds.database_connections"}}},rdsQueriesExecuted:{rdsQueriesExecuted:{avg:{field:"aws.rds.queries"}}},rdsActiveTransactions:{rdsActiveTransactions:{avg:{field:"aws.rds.transactions.active"}}}},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:14400}},230:function(e,i,t){"use strict";t.d(i,"a",(function(){return a}));var s=t(87);const a={tsvb:{awsSQSMessagesVisible:Object(s.a)("awsSQSMessagesVisible",["aws.sqs"],[{id:"visible",split_mode:"everything",metrics:[{field:"aws.sqs.messages.visible",id:"avg-visible",type:"avg"}]}],">=300s"),awsSQSMessagesDelayed:Object(s.a)("awsSQSMessagesDelayed",["aws.sqs"],[{id:"delayed",split_mode:"everything",metrics:[{field:"aws.sqs.messages.delayed",id:"avg-delayed",type:"avg"}]}],">=300s"),awsSQSMessagesSent:Object(s.a)("awsSQSMessagesSent",["aws.sqs"],[{id:"sent",split_mode:"everything",metrics:[{field:"aws.sqs.messages.sent",id:"avg-sent",type:"avg"}]}],">=300s"),awsSQSMessagesEmpty:Object(s.a)("awsSQSMessagesEmpty",["aws.sqs"],[{id:"empty",split_mode:"everything",metrics:[{field:"aws.sqs.messages.not_visible",id:"avg-empty",type:"avg"}]}],">=300s"),awsSQSOldestMessage:Object(s.a)("awsSQSOldestMessage",["aws.sqs"],[{id:"oldest",split_mode:"everything",metrics:[{field:"aws.sqs.oldest_message_age.sec",id:"max-oldest",type:"max"}]}],">=300s")},snapshot:{sqsMessagesVisible:{sqsMessagesVisible:{avg:{field:"aws.sqs.messages.visible"}}},sqsMessagesDelayed:{sqsMessagesDelayed:{max:{field:"aws.sqs.messages.delayed"}}},sqsMessagesEmpty:{sqsMessagesEmpty:{max:{field:"aws.sqs.messages.not_visible"}}},sqsMessagesSent:{sqsMessagesSent:{max:{field:"aws.sqs.messages.sent"}}},sqsOldestMessage:{sqsOldestMessage:{max:{field:"aws.sqs.oldest_message_age.sec"}}}},defaultSnapshot:"sqsMessagesVisible",defaultTimeRangeInSeconds:14400}},231:function(e,i,t){"use strict";t.d(i,"a",(function(){return a}));var s=t(87);const a={tsvb:{awsEC2CpuUtilization:Object(s.a)("awsEC2CpuUtilization",["aws.ec2"],[{id:"total",split_mode:"everything",metrics:[{field:"aws.ec2.cpu.total.pct",id:"avg-cpu",type:"avg"},{id:"convert-to-percent",script:"params.avg / 100",type:"calculation",variables:[{field:"avg-cpu",id:"var-avg",name:"avg"}]}]}]),awsEC2NetworkTraffic:Object(s.a)("awsEC2NetworkTraffic",["aws.ec2"],[{id:"tx",split_mode:"everything",metrics:[{field:"aws.ec2.network.out.bytes_per_sec",id:"avg-tx",type:"avg"}]},{id:"rx",split_mode:"everything",metrics:[{field:"aws.ec2.network.in.bytes_per_sec",id:"avg-rx",type:"avg"},{id:"calculation-rate",type:"calculation",variables:[{id:"rate-var",name:"rate",field:"avg-rx"}],script:"params.rate * -1"}]}]),awsEC2DiskIOBytes:Object(s.a)("awsEC2DiskIOBytes",["aws.ec2"],[{id:"write",split_mode:"everything",metrics:[{field:"aws.ec2.diskio.write.bytes_per_sec",id:"avg-write",type:"avg"}]},{id:"read",split_mode:"everything",metrics:[{field:"aws.ec2.diskio.read.bytes_per_sec",id:"avg-read",type:"avg"},{id:"calculation-rate",type:"calculation",variables:[{id:"rate-var",name:"rate",field:"avg-read"}],script:"params.rate * -1"}]}])},snapshot:{cpu:{cpu_avg:{avg:{field:"aws.ec2.cpu.total.pct"}},cpu:{bucket_script:{buckets_path:{cpu:"cpu_avg"},script:{source:"params.cpu / 100",lang:"painless"},gap_policy:"skip"}}},rx:{rx:{avg:{field:"aws.ec2.network.in.bytes_per_sec"}}},tx:{tx:{avg:{field:"aws.ec2.network.in.bytes_per_sec"}}},diskIOReadBytes:{diskIOReadBytes:{avg:{field:"aws.ec2.diskio.read.bytes_per_sec"}}},diskIOWriteBytes:{diskIOWriteBytes:{avg:{field:"aws.ec2.diskio.write.bytes_per_sec"}}}},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:14400}},87:function(e,i,t){"use strict";t.d(i,"a",(function(){return s}));const s=(e,i,t,s=">=300s",a=!0)=>(r,n)=>({id:e,requires:i,drop_last_bucket:a,index_pattern:n,interval:s,time_field:r,type:"timeseries",series:t})},88:function(e,i,t){"use strict";t.d(i,"c",(function(){return a})),t.d(i,"b",(function(){return r})),t.d(i,"a",(function(){return n})),t.d(i,"d",(function(){return D})),t.d(i,"e",(function(){return C})),t.d(i,"f",(function(){return T}));var s=t(0);const a=s.keyof({host:null,pod:null,container:null,awsEC2:null,awsS3:null,awsSQS:null,awsRDS:null}),r=s.keyof({line:null,area:null,bar:null}),n=(s.keyof({abbreviatedNumber:null,bits:null,bytes:null,number:null,percent:null,highPercision:null}),s.keyof({hostSystemOverview:null,hostCpuUsage:null,hostFilesystem:null,hostK8sOverview:null,hostK8sCpuCap:null,hostK8sDiskCap:null,hostK8sMemoryCap:null,hostK8sPodCap:null,hostLoad:null,hostMemoryUsage:null,hostNetworkTraffic:null,hostDockerOverview:null,hostDockerInfo:null,hostDockerTop5ByCpu:null,hostDockerTop5ByMemory:null,podOverview:null,podCpuUsage:null,podMemoryUsage:null,podLogUsage:null,podNetworkTraffic:null,containerOverview:null,containerCpuKernel:null,containerCpuUsage:null,containerDiskIOOps:null,containerDiskIOBytes:null,containerMemory:null,containerNetworkTraffic:null,nginxHits:null,nginxRequestRate:null,nginxActiveConnections:null,nginxRequestsPerConnection:null,awsOverview:null,awsCpuUtilization:null,awsNetworkBytes:null,awsNetworkPackets:null,awsDiskioBytes:null,awsDiskioOps:null,awsEC2CpuUtilization:null,awsEC2NetworkTraffic:null,awsEC2DiskIOBytes:null,awsS3TotalRequests:null,awsS3NumberOfObjects:null,awsS3BucketSize:null,awsS3DownloadBytes:null,awsS3UploadBytes:null,awsRDSCpuTotal:null,awsRDSConnections:null,awsRDSQueriesExecuted:null,awsRDSActiveTransactions:null,awsRDSLatency:null,awsSQSMessagesVisible:null,awsSQSMessagesDelayed:null,awsSQSMessagesSent:null,awsSQSMessagesEmpty:null,awsSQSOldestMessage:null,custom:null})),d=s.keyof({avg:null,max:null,min:null,calculation:null,cardinality:null,series_agg:null,positive_only:null,derivative:null,count:null,sum:null,cumulative_sum:null}),o=s.type({id:s.string,type:s.literal("count")}),l=s.intersection([s.type({id:s.string,type:d}),s.partial({field:s.string})]),c=s.type({field:s.string,id:s.string,name:s.string}),u=s.type({id:s.string,script:s.string,type:s.literal("calculation"),variables:s.array(c)}),p=s.type({id:s.string,field:s.string,unit:s.string,type:s.literal("derivative")}),m=s.type({id:s.string,function:s.string,type:s.literal("series_agg")}),y=s.type({id:s.string,value:s.number}),v=s.intersection([s.type({id:s.string,type:s.literal("percentile"),percentiles:s.array(y)}),s.partial({field:s.string})]),g=s.union([o,l,u,p,v,m]),f=s.intersection([s.type({id:s.string,metrics:s.array(g),split_mode:s.string}),s.partial({terms_field:s.string,terms_size:s.number,terms_order_by:s.string,filter:s.type({query:s.string,language:s.keyof({lucene:null,kuery:null})})})]),_=(s.intersection([s.type({id:n,requires:s.array(s.string),index_pattern:s.union([s.string,s.array(s.string)]),interval:s.string,time_field:s.string,type:s.string,series:s.array(f)}),s.partial({filter:s.string,map_field_to:s.string,id_type:s.keyof({cloud:null,node:null}),drop_last_bucket:s.boolean})]),s.record(s.string,s.union([s[void 0],s.type({field:s.string})]))),w=s.type({percentiles:s.type({field:s.string,percents:s.array(s.number)})}),k=s.type({cardinality:s.partial({field:s.string,script:s.string})}),b=s.type({bucket_script:s.intersection([s.type({buckets_path:s.record(s.string,s.union([s[void 0],s.string])),script:s.type({source:s.string,lang:s.keyof({painless:null,expression:null})})}),s.partial({gap_policy:s.keyof({skip:null,insert_zeros:null})})])}),x=s.type({cumulative_sum:s.type({buckets_path:s.string})}),h=s.type({derivative:s.type({buckets_path:s.string,gap_policy:s.keyof({skip:null,insert_zeros:null}),unit:s.string})}),S=s.type({sum_bucket:s.type({buckets_path:s.string})}),q=s.type({top_metrics:s.type({metrics:s.union([s.array(s.type({field:s.string})),s.type({field:s.string})])})}),M=s.recursion("SnapshotModelRT",(()=>s.type({terms:s.type({field:s.string}),aggregations:D}))),O=s.union([_,w,b,x,h,S,M,k,q]),D=s.record(s.string,O),C={count:null,cpu:null,load:null,memory:null,tx:null,rx:null,logRate:null,diskIOReadBytes:null,diskIOWriteBytes:null,s3TotalRequests:null,s3NumberOfObjects:null,s3BucketSize:null,s3DownloadBytes:null,s3UploadBytes:null,rdsConnections:null,rdsQueriesExecuted:null,rdsActiveTransactions:null,rdsLatency:null,sqsMessagesVisible:null,sqsMessagesDelayed:null,sqsMessagesSent:null,sqsMessagesEmpty:null,sqsOldestMessage:null,custom:null},T=s.keyof(C)},91:function(e,i,t){"use strict";t.d(i,"c",(function(){return w})),t.d(i,"b",(function(){return k})),t.d(i,"a",(function(){return x}));var s=t(1),a=t(225);const r=["nginxHits","nginxRequestRate","nginxActiveConnections","nginxRequestsPerConnection"],n={id:"host",displayName:s.i18n.translate("xpack.infra.inventoryModel.host.displayName",{defaultMessage:"Hosts"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.host.singularDisplayName",{defaultMessage:"Host"}),requiredModule:"system",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},fields:{id:"host.name",name:"host.name",ip:"host.ip"},metrics:a.a,requiredMetrics:["hostSystemOverview","hostCpuUsage","hostLoad","hostMemoryUsage","hostNetworkTraffic","hostK8sOverview","hostK8sCpuCap","hostK8sMemoryCap","hostK8sDiskCap","hostK8sPodCap","awsOverview","awsCpuUtilization","awsNetworkBytes","awsNetworkPackets","awsDiskioOps","awsDiskioBytes",...r],tooltipMetrics:["cpu","memory","tx","rx"]};var d=t(227);const o={id:"pod",displayName:s.i18n.translate("xpack.infra.inventoryModel.pod.displayName",{defaultMessage:"Kubernetes Pods"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.pod.singularDisplayName",{defaultMessage:"Kubernetes Pod"}),requiredModule:"kubernetes",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},fields:{id:"kubernetes.pod.uid",name:"kubernetes.pod.name",ip:"kubernetes.pod.ip"},metrics:d.a,requiredMetrics:["podOverview","podCpuUsage","podMemoryUsage","podNetworkTraffic",...r],tooltipMetrics:["cpu","memory","rx","tx"]};var l=t(231);const c={id:"awsEC2",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsEC2.displayName",{defaultMessage:"EC2 Instances"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsEC2.singularDisplayName",{defaultMessage:"EC2 Instance"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},metrics:l.a,fields:{id:"cloud.instance.id",name:"cloud.instance.name",ip:"aws.ec2.instance.public.ip"},requiredMetrics:["awsEC2CpuUtilization","awsEC2NetworkTraffic","awsEC2DiskIOBytes"],tooltipMetrics:["cpu","rx","tx"],nodeFilter:[{term:{"event.dataset":"aws.ec2"}}]};var u=t(228);const p={id:"awsS3",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsS3.displayName",{defaultMessage:"S3 Buckets"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsS3.singularDisplayName",{defaultMessage:"S3 Bucket"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!1,uptime:!1},metrics:u.a,fields:{id:"aws.s3.bucket.name",name:"aws.s3.bucket.name"},requiredMetrics:["awsS3BucketSize","awsS3NumberOfObjects","awsS3TotalRequests","awsS3DownloadBytes","awsS3UploadBytes"],tooltipMetrics:["s3BucketSize","s3NumberOfObjects","s3TotalRequests","s3UploadBytes","s3DownloadBytes"]};var m=t(229);const y={id:"awsRDS",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsRDS.displayName",{defaultMessage:"RDS Databases"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsRDS.singularDisplayName",{defaultMessage:"RDS Database"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!1,uptime:!1},metrics:m.a,fields:{id:"aws.rds.db_instance.arn",name:"aws.rds.db_instance.identifier"},requiredMetrics:["awsRDSCpuTotal","awsRDSConnections","awsRDSQueriesExecuted","awsRDSActiveTransactions","awsRDSLatency"],tooltipMetrics:["cpu","rdsLatency","rdsConnections","rdsQueriesExecuted","rdsActiveTransactions"]};var v=t(230);const g={id:"awsSQS",displayName:s.i18n.translate("xpack.infra.inventoryModels.awsSQS.displayName",{defaultMessage:"SQS Queues"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModels.awsSQS.singularDisplayName",{defaultMessage:"SQS Queue"}),requiredModule:"aws",crosslinkSupport:{details:!0,logs:!0,apm:!1,uptime:!1},metrics:v.a,fields:{id:"aws.sqs.queue.name",name:"aws.sqs.queue.name"},requiredMetrics:["awsSQSMessagesVisible","awsSQSMessagesDelayed","awsSQSMessagesSent","awsSQSMessagesEmpty","awsSQSOldestMessage"],tooltipMetrics:["sqsMessagesVisible","sqsMessagesDelayed","sqsMessagesEmpty","sqsMessagesSent","sqsOldestMessage"]};var f=t(226);const _={id:"container",displayName:s.i18n.translate("xpack.infra.inventoryModel.container.displayName",{defaultMessage:"Docker Containers"}),singularDisplayName:s.i18n.translate("xpack.infra.inventoryModel.container.singularDisplayName",{defaultMessage:"Docker Container"}),requiredModule:"docker",crosslinkSupport:{details:!0,logs:!0,apm:!0,uptime:!0},fields:{id:"container.id",name:"container.name",ip:"container.ip_address"},metrics:f.a,requiredMetrics:["containerOverview","containerCpuUsage","containerMemory","containerNetworkTraffic","containerDiskIOBytes","containerDiskIOOps"],tooltipMetrics:["cpu","memory","rx","tx"]};t(179);const w=[n,o,_,c,p,y,g],k=e=>{const i=w.find((i=>i.id===e));if(!i)throw new Error(s.i18n.translate("xpack.infra.inventoryModels.findInventoryModel.error",{defaultMessage:"The inventory model you've attempted to find does not exist"}));return i},b=["host","pod","container"],x=(e,i)=>{const t=k(e);if(i&&b.includes(e)){const s=((e,i)=>{switch(e){case"pod":return i.pod;case"host":return i.host;case"container":return i.container}})(e,i)||t.fields.id;return{...t.fields,id:s}}return t.fields}},93:function(e,i,t){"use strict";t.d(i,"g",(function(){return u})),t.d(i,"a",(function(){return p})),t.d(i,"e",(function(){return m})),t.d(i,"b",(function(){return v})),t.d(i,"c",(function(){return f})),t.d(i,"d",(function(){return _})),t.d(i,"f",(function(){return w}));var s=t(0),a=t(88),r=t(115);const n=s.intersection([s.type({value:s.string,label:s.string}),s.partial({ip:s.union([s.string,s.null])})]),d=s.partial({value:s.union([s.number,s.null]),avg:s.union([s.number,s.null]),max:s.union([s.number,s.null]),timeseries:r.a}),o=s.type({name:s.union([a.f,s.string])}),l=s.intersection([o,d]),c=s.type({metrics:s.array(l),path:s.array(n),name:s.string}),u=s.type({nodes:s.array(c),interval:s.string}),p=s.intersection([s.type({interval:s.string,to:s.number,from:s.number}),s.partial({lookbackSize:s.number,ignoreLookback:s.boolean,forceInterval:s.boolean})]),m=s.array(s.partial({label:s.union([s.string,s.null]),field:s.union([s.string,s.null])})),y=s.type({type:a.f}),v=["avg","max","min","rate"],g=v.reduce(((e,i)=>({...e,[i]:null})),{}),f=s.keyof(g),_=s.intersection([s.type({type:s.literal("custom"),field:s.string,aggregation:f,id:s.string}),s.partial({label:s.string})]),w=s.union([y,_]);s.intersection([s.type({timerange:p,metrics:s.array(w),groupBy:s.union([m,s.null]),nodeType:a.c,sourceId:s.string}),s.partial({accountId:s.string,region:s.string,filterQuery:s.union([s.string,s.null]),includeTimeseries:s.boolean,overrideCompositeSize:s.number})])},98:function(e,i,t){"use strict";t.d(i,"a",(function(){return a})),t.d(i,"c",(function(){return n})),t.d(i,"d",(function(){return l})),t.d(i,"b",(function(){return m})),t.d(i,"e",(function(){return k}));var s=t(0);const a=["avg","max","min","cardinality","rate","count","sum","p95","p99"],r=a.reduce(((e,i)=>({...e,[i]:null})),{}),n=s.keyof(r),d=s.type({aggregation:n}),o=s.partial({field:s.union([s.string,s[void 0]])}),l=s.intersection([d,o]),c=s.type({field:s.string,from:s.number,to:s.number,interval:s.string}),u=s.type({timerange:c,indexPattern:s.string,metrics:s.array(l)}),p=s.union([s.string,s.null,s[void 0]]),m=s.record(s.string,s.union([s.string,s.null])),y=s.partial({groupBy:s.union([p,s.array(p)]),afterKey:s.union([s.string,s.null,s[void 0],m]),limit:s.union([s.number,s.null,s[void 0]]),filterQuery:s.union([s.string,s.null,s[void 0]]),forceInterval:s.boolean,dropLastBucket:s.boolean}),v=(s.intersection([u,y]),s.type({total:s.number,afterKey:s.union([s.string,s.null,m])})),g=s.keyof({date:null,number:null,string:null}),f=s.type({name:s.string,type:g}),_=s.intersection([s.type({timestamp:s.number}),s.record(s.string,s.union([s.string,s.number,s.null,s[void 0],s.array(s.object)]))]),w=s.intersection([s.type({id:s.string,columns:s.array(f),rows:s.array(_)}),s.partial({keys:s.array(s.string)})]),k=s.type({series:s.array(w),pageInfo:v})},99:function(e,i,t){"use strict";t.d(i,"b",(function(){return o})),t.d(i,"a",(function(){return p}));var s=t(22),a=t(2),r=t(14),n=t(66),d=t(40);const o=({defaultState:e,decodeUrlState:i,encodeUrlState:t,urlStateKey:s,writeDefaultState:r=!1})=>{const d=Object(n.useHistory)(),o=null!=d&&d.location?c(d.location):"",y=Object(a.useMemo)((()=>{if(o)return u(o,s)}),[o,s]),v=Object(a.useMemo)((()=>i(l(y))),[i,y]),g=Object(a.useMemo)((()=>void 0!==v?v:e),[e,v]),f=Object(a.useCallback)((e=>{if(!d||!d.location)return;const i=d.location,a=m(i,p(s,void 0!==e?t(e):void 0)(c(i)));a!==i&&d.replace(a)}),[t,d,s]),[_,w]=Object(a.useState)(r&&void 0===v);return Object(a.useEffect)((()=>{_&&(w(!1),f(e))}),[_,f,e]),[g,f]},l=e=>{try{return e?Object(r.decode)(e):void 0}catch(e){if(e instanceof Error&&e.message.startsWith("rison decoder error"))return{};throw e}},c=e=>e.search.substring(1),u=(e,i)=>{const t=Object(s.parse)(e,{sort:!1})[i];return Array.isArray(t)?t[0]:t},p=(e,i)=>t=>{const a=Object(s.parse)(t,{sort:!1}),n=void 0===i?a:{...a,[e]:(o=i,Object(r.encode)(o))};var o;return Object(s.stringify)(d.url.encodeQuery(n),{sort:!1,encode:!1})},m=(e,i)=>i===c(e)?e:{...e,search:`?${i}`}}}]);